<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'hotpot', language 'sr_cr', version '5.1'.
 *
 * @package     hotpot
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['abandoned'] = 'Напуштено';
$string['abandonhotpot'] = 'Ваши досадашњи резултати биће сачувани али нећете моћи да наставите или да касније поново покренете ову активност.';
$string['activitycloses'] = 'Активност се завршава';
$string['activitygrade'] = 'Оцена активности';
$string['activityopens'] = 'Активност почиње';
$string['added'] = 'Додато';
$string['addquizchain'] = 'Додавање низа теста';
$string['addquizchain_help'] = 'Да ли треба све тестове додати у низ тестова?

**Не**
: само један тест ће бити додат курсу

**Да**
: ако је изворна датотека **датотека теста**, она ће бити третирана као почетак низа тестова и сви тестови у низу биће додати курсу са идентичним подешавањима, Сваки тест у низу мора да има линк ка наредној датотеци у низу.

Ако је изворна датотека **фолдер**, сви тестови који се могу препознати у том фолдеру биће додат курсу како би се формирао низ тестова са идентичним подешавањима.

Ако је изворна датотека **јединична датотека**, као што је тзв. Hot Potatoes Masher датотека или index.html, тестови који се налазе на списку јединице биће додати курсу као низ тестова са идентичним подешавањима.';
$string['allowpaste'] = 'Дозволи преношење';
$string['allowpaste_help'] = 'Ако је ово подешавање омогућено студенти ће моћи да копирају, преносе и превлаче текст у оквир за унос текста.';
$string['allowreview'] = 'Дозволи преглед';
$string['allowreview_help'] = 'Ако је омогућено, студенти могу да прегледају своје покушаје након што тест буде затворен.';
$string['analysisreport'] = 'Анализа ставки';
$string['attempted'] = 'Покушано';
$string['attemptlimit'] = 'Ограничење покушаја';
$string['attemptlimit_help'] = 'Максималан број покушаја које студент може да има на овој HotPot активности';
$string['attemptnumber'] = 'Број покушаја';
$string['attempts'] = 'Покушаји';
$string['attemptscore'] = 'Резултат покушаја';
$string['attemptsunlimited'] = 'Неограничени број покушаја';
$string['average'] = 'Просек';
$string['averagescore'] = 'Просечан резултат';
$string['bodystyles'] = 'Основни стилови';
$string['bodystylesbackground'] = 'Боја и слика позадине';
$string['bodystylescolor'] = 'Боја текста';
$string['bodystylesfont'] = 'Величина и фамилија фонта';
$string['bodystylesmargin'] = 'Лева и десна маргина';
$string['cacherecords'] = 'HotPot кеш запис';
$string['canrestarthotpot'] = 'Ваши досадашњи резултати биће сачувани, и  касније, можете поново да урадите "{$a}"';
$string['canresumehotpot'] = 'Ваши досадашњи резултати биће сачувани и касније можете да наставите "{$a}".';
$string['checks'] = 'Провере';
$string['checksomeboxes'] = 'Молимо, означите нека од поља';
$string['clearcache'] = 'Обриши HotPot кеш';
$string['cleardetails'] = 'Oбриши HotPot детаље';
$string['clearedcache'] = 'HotPot кеш је обрисан';
$string['cleareddetails'] = 'HotPot детаљи су обрисани';
$string['clickreporting'] = 'Омогучавање извештавања о кликовима';
$string['clickreporting_help'] = 'Ако је омогућено, сваки пут када се кликне на дугме "Савет", "Траг" или "Провери" биће сачуван засебан запис. То дозвољава предавачу да види врло детаљан извештај који приказује стање теста при сваком клику. У супротном, чува се само један запис за сваки покушај решавања теста.';
$string['clicktrailreport'] = 'Праћење кликова';
$string['closed'] = 'Ова активност је затворена';
$string['clues'] = 'Трагови';
$string['completed'] = 'Завршено';
$string['configbodystyles'] = 'Стандардно, стилови Moodle теме ће заменити стилове HotPot активности. Међутим, за све стилове који се овде изаберу, стилови HotPot активност ће имати предност у односу на стилове Moodle теме.';
$string['configenablecache'] = 'Укључивање HotPot кеша може драматично да убрза испоруку тестова студентима.';
$string['configenablecron'] = 'Наведите време у Вашој временској зони у које се може покренути Hotpot крон скрипт.';
$string['configenablemymoodle'] = 'Ово подешавање одређује да ли се HotPot тестови појављују на страници MyMoodle';
$string['configenableobfuscate'] = '"Замућивање" (енкрипција) Javascript кôда за уметање медија плејера отежава одређивање назива мултимедијалне датотеке, као и нагађање шта она садржи.';
$string['configenableswf'] = 'Дозволи уградњу SWF датотека у HotPot активности. Ако је омогућено, ово подешавање надјачава filter_mediaplugin_enable_swf.';
$string['configfile'] = 'Конфигурациона датотека';
$string['configframeheight'] = 'Када се тест приказује унутар оквира, ова вредност представља висину (у пикселима) горњег оквира који садржи Moodle навигациону траку.';
$string['configlocation'] = 'Положај конфигурационе датотеке';
$string['configlockframe'] = 'Ако је ово подешавање омогућено, онда ће навигациони оквир, уколико  се користи, бити закључан тако да неће моћи да се користи трака са клизачем и да се мења величина оквира, нити ће оквир имати бордуру.';
$string['configmaxeventlength'] = 'Ако HotPot тест има наведено и време отварања и време затварања, и ако је разлика између ова два времена већа од број дана овде наведених, онда ће у календар курса бити додата два одвојена догађаја. За краће трајање, или када је наведено само једно време, онда ћe у календар бити додат само један догађај. Ако ниједно време није наведено, онда ниједан догађај неће бити додат у календар.';
$string['configstoredetails'] = 'Ако је ово подешавање омогућено, онда ће необрађени XML детаљи о покушајима да се реше HotPot тестови бити сачувани у табели hotpot_details. Ово дозвољава да покушаји решавања могу касније да буду поново оцењени ако се промени HotPot систем за бодовање. Међутим, ако омогућите ову опцију на сајту који се пуно користи, то може довести до тога да се табела hotpot_details врло брзо увећа.';
$string['confirmdeleteattempts'] = 'Да ли стварно желите да обришете ове покушаје?';
$string['confirmstop'] = 'Да ли сте сигурни да желите да одете са ове странице?';
$string['correct'] = 'Тачно';
$string['couldnotinsertsubmissionform'] = 'Није могуће уметнути образац за слање';
$string['d_index'] = 'Индекс дискриминације';
$string['delay1'] = 'Временски размак 1';
$string['delay1_help'] = 'Најмањи временски размак између првог и другог покушаја';
$string['delay1summary'] = 'Временски размак између првог и другог покушаја';
$string['delay2'] = 'Временски размак 2';
$string['delay2_help'] = 'Минимални временски размак између два покушаја';
$string['delay2summary'] = 'Временски размак између каснијих покушаја';
$string['delay3'] = 'Временски размак 3';
$string['delay3_help'] = 'Подешавање одређује временски размак између завршетка теста и повратка контроле приказа Moodleu.

**Користите одређено време (у секундима)**
: контрола ће бити враћена Moodleu након одређеног броја секунди.

**Користите подешавања из изворне или датотеке шаблона**
: контрола ће бити враћена Moodleu након времена (у секундама) наведеног у изворној или датотекама шаблона за овај излазни формат.

**Сачекајте док студент не кликне OK**
: контрола ће бити враћена Moodleu након што студент кликне дугме ОК на завршној поруци у квизу.

**Немојте настављати аутоматски**
: контрола неће бити враћена Moodleu након што тест буде завршен. Студент ће бити слободан да оде са странице са тестом.

Имајте у виду да се резултати теста увек враћају Moodleu одмах
након што је тест завршен или напуштен, без обзира на ово подешавање.';
$string['delay3afterok'] = 'Сачекајте док студент не кликне на OK';
$string['delay3disable'] = 'Немојте настављати аутоматски';
$string['delay3specific'] = 'Користите одређено време (у секундима)';
$string['delay3summary'] = 'Временски размак на крају теста';
$string['delay3template'] = 'Користите подешавања из изворне или датотеке шаблона';
$string['deleteallattempts'] = 'Обриши све покушаје';
$string['deleteattempts'] = 'Обриши покушаје';
$string['detailsrecords'] = 'Запис о HotPot детаљима';
$string['duration'] = 'Трајање';
$string['enablecache'] = 'Укључи HotPot кеш';
$string['enablecron'] = 'Омогући HotPot cron';
$string['enablemymoodle'] = 'Прикажи HotPot тестове на страници Мој Moodle';
$string['enableobfuscate'] = 'Омогући "замућивање" (енкрипцију) кôда медија плејера';
$string['enableswf'] = 'Дозволи уграђивање SWF датотека у HotPot активности';
$string['entry_attempts'] = 'Покушаји';
$string['entry_dates'] = 'Датум';
$string['entry_grading'] = 'Оцењивање';
$string['entry_title'] = 'Назив јединице као наслов';
$string['entrycm'] = 'Претходна активност';
$string['entrycm_help'] = 'Ово подешавање одређује Moodle активност и минималну оцену коју студент мора да постигне за ту активност, пре него што буде могао да покуша ову HotPot активност.

Предавач може да изабере одређену активност или једно од следећих општих подешавања:

* Претходна активност на овом курсу
* Претходна активност у овој секцији курса
* Претходни HotPot на овом курсу
* Претходни HotPot у овој секцији курса';
$string['entrycmcourse'] = 'Претходна активност на овом курсу';
$string['entrycmsection'] = 'Претходна активност у овој секцији курса';
$string['entrycompletionwarning'] = 'Пре него што започнете ову активност, прво морате да погледате {$a}.';
$string['entrygrade'] = 'Оцена претходне активности';
$string['entrygradewarning'] = 'Не можете да започнете ову активност док не освојите {$a->entrygrade}% на {$a->entryactivity}. Тренутно, Ваша оцена за ту активност је {$a->usergrade}%';
$string['entryhotpotcourse'] = 'Претходни HotPot на овом курсу';
$string['entryhotpotsection'] = 'Претходни HotPot у овој секциј курса';
$string['entryoptions'] = 'Опције уводне странице';
$string['entryoptions_help'] = 'Ова поља за потврду омогућују и онемогућују приказ ставки на HotPot улазној страници.

**Назив јединице као наслов**
: ако је поље потврђено, назив јединице биће приказан као наслов на улазној страници.

**Оцењивања**
: ако је поље потврђено, информације о оцењивању HotPota биће приказана на улазној страници.

**Датуми**
: ако је поље потврђено,  датуми отварања и затварања HotPota биће приказани на улазној страници.

**Покушаји**
: ако је поље потврђено, табела која приказује детаље претходних покушаја корисника на овом HotPot тесту биће приказана на улазној страници. Покушаји који могу да се наставе имаће дугме за наставак.';
$string['entrypage'] = 'Прикажи уводну страницу';
$string['entrypage_help'] = 'Да ли треба студентима приказати иницијалну страницу пре него што започну HotPot активност?

**Да**
: студентима ће бити приказана улазна страница пре него што започну HotPot. Садржај улазне странице је одређен опцијама за улазну страницу HotPota.

**Не**
: студентима неће бити приказана улазна страница, и одмах ће започети HotPot.

Улазна страница се увек приказује предавачима како би могли да приступе извештајима и уређивању странице са тестовима';
$string['entrypagehdr'] = 'Уводна страница';
$string['entrytext'] = 'Текст на уводној страници';
$string['event_attempt_reviewed'] = 'Прегледан ХотПот покушај';
$string['event_attempt_reviewed_description'] = 'Корисник "{$a->userid}" је прегледао покушај "хотпот" активности у модулу курса "{$a->cmid}"';
$string['event_attempt_reviewed_explanation'] = 'Корисник је управо прегледао покушај ХотПот активности';
$string['event_attempt_started'] = 'Започет ХотПот покушај';
$string['event_attempt_started_description'] = 'Корисник "{$a->userid}" је започео покушај "хотпот" активности у модулу курса "{$a->cmid}"';
$string['event_attempt_started_explanation'] = 'Корисник је управо започео покушај ХотПот активности';
$string['event_attempt_submitted'] = 'ХотПот покушај је предат';
$string['event_attempt_submitted_description'] = 'Корисник "{$a->userid}" је предао покушај "хотпот" активности у модулу курса "{$a->cmid}"';
$string['event_attempt_submitted_explanation'] = 'Корисник је управо предао покушај ХотПот активности';
$string['event_base'] = 'Детектован је ХотПот догађај';
$string['event_base_description'] = 'Корисник "{$a->userid}" је иницирао догађај у "хотпот" активности у модулу курса "{$a->cmid}"';
$string['event_base_explanation'] = 'ХотПот модул је детектовао догађај';
$string['event_report_viewed'] = 'Погледан ХотПот извештај';
$string['event_report_viewed_description'] = 'Корисник "{$a->userid}" је погледао извештај о покушајима "хотпот" активности у модулу курса "{$a->cmid}"';
$string['event_report_viewed_explanation'] = 'Корисник је управо погледао извештај о покушајума у ХотПот активности';
$string['exit_areyouok'] = 'Јесте ли још увек ту?';
$string['exit_attemptscore'] = 'Ваш резултат за тај покушај је био {$a}';
$string['exit_course'] = 'Курс';
$string['exit_course_text'] = 'Повратак на насловну страницу курса';
$string['exit_encouragement'] = 'Охрабрење';
$string['exit_excellent'] = 'Одлично!';
$string['exit_feedback'] = 'Повратна информација на излазној страници';
$string['exit_feedback_help'] = 'Ове опције омогућавају и онемогућавају приказивање повратних информација на излазној страници HotPota.

**Назив јединице као наслов**
: ако је поље потврђено, назив јединице биће приказан као наслов на излазној страници.

**Охрабрење**
: ако је поље потврђено, биће приказане охрабрујуће - повратне поруке на излазној страници. Која повратна порука ће бити приказана зависи од резултата на HotPot тесту:
: **> 90%**: Одлично!
: **> 60%**: Добро урађено
: **> 0%**: Може и боље
: **= 0%**: Да ли је све у реду?

**Оцена покушаја**
: ако је поље потврђено, оцена за управо завршени покушај биће приказана на излазној страници.

**Оцена јединице**
: ако је поље потврђено HotPot оцена биће приказана на излазној страници.

Осим тога, ако начин оцењивања јединице подразумева највећу оцену кориснику ће бити приказана порука која ће му рећи да ли је његов последњи покушај био једнак или бољи од претходних.';
$string['exit_goodtry'] = 'Може и боље!';
$string['exit_grades'] = 'Оцене';
$string['exit_grades_text'] = 'Погледајте своје досадашње оцене на овом курсу.';
$string['exit_hotpotgrade'] = 'Ваша оцена за ову активност је {$a}';
$string['exit_hotpotgrade_average'] = 'Ваша просечна оцена до сада за ову активност је {$a}';
$string['exit_hotpotgrade_highest'] = 'Ваша највећа оцена до сада за ову активност је {$a}';
$string['exit_hotpotgrade_highest_equal'] = 'Изједначили сте свој претходни најбољи резултат за ову активност!';
$string['exit_hotpotgrade_highest_previous'] = 'Ваша претходно највећа оцена за ову активност била је {$a}';
$string['exit_hotpotgrade_highest_zero'] = 'Још увек нисте освојили више од {$a} за ову активност';
$string['exit_index'] = 'Индекс';
$string['exit_index_text'] = 'Иди на индекс активности';
$string['exit_links'] = 'Линкови на излазној страници';
$string['exit_links_help'] = 'Ове опције омогућавају и онемогућавају приказивање одрећених линкова на излазној страници HotPota.

**Покушај поново**
: ако су дозвољени вишеструки покушаји на овом HotPot тесту, а студент има још неискоришћених покушаја на располагању, биће приказан линк који дозвољава студенту да поново покуша да реши HotPot тест.

**Индекс**
: ако је поље потврђено, биће приказан линк ка индексној страници HotPot активности.

**Курс**
: ако је поље потврђено, биће приказана линк ка страници курса у Moodleu.

**Оцене**
: ако је поље потврђено биће приказан линк ка књизи оцена у  Moodleu.';
$string['exit_next'] = 'Следеће';
$string['exit_next_text'] = 'Покушајте следећу активност';
$string['exit_noscore'] = 'Успешно сте завршили ову активност!';
$string['exit_retry'] = 'Покушај поново';
$string['exit_retry_text'] = 'Покушај поново ову активност';
$string['exit_welldone'] = 'Добро урађено!';
$string['exit_whatnext_0'] = 'Шта бисте желели да радите следеће?';
$string['exit_whatnext_1'] = 'Куда даље...';
$string['exit_whatnext_default'] = 'Молимо да одаберете једно од следећег:';
$string['exitcm'] = 'Следећа активност';
$string['exitcm_help'] = 'Ово подешавање одређује Moodle активност коју студенти морају да  ураде након што заврше ову HotPot активност. Опциона оцена је минимална оцена за ову HotPot активност која се захтева пре него што се прикаже следећа активност.

Предавач може да изабере одређену активност или једно од следећих општих подешавања:

* Следећа активност на овом курсу
* Следећа активност у овој секцији курса
* Следећа HotPot активност на овом курсу
* Следећа HotPot активност у овој секцији курса

Ако су друге опције за излазну страницу онемогућене, а студент је постигао тражену оцену за ову HotPot активност, онда ће му одмах бити приказана следећа активност. У супротном, студенту ће бити приказан линк, на који може да кликне, када буде био спреман за то.';
$string['exitcmcourse'] = 'Следећа активност на овом курсу';
$string['exitcmsection'] = 'Следећа активност у овој секцији курса';
$string['exitgrade'] = 'Следећа оцена активности';
$string['exithotpotcourse'] = 'Следећи HotPot на овом курсу';
$string['exithotpotsection'] = 'Следећи HotPot у овој секцији курса';
$string['exitoptions'] = 'Опције излазне странице';
$string['exitpage'] = 'Прикажи излазну страницу';
$string['exitpage_help'] = 'Да ли треба приказати излазну страницу након завршетка HotPot теста?

**Да**
: студентима ће након завршетка HotPot теста бити приказана излазна страница. Садржај излазне странице је одређен подешавањима за повратне информације и линкове на HotPot излазној страници.

**Не**
: студентима неће бити приказана излазна страница. Уместо тога, они ће одмах ићи на наредну активност или ће бити враћени на странице курса у Moodleu.';
$string['exitpagehdr'] = 'Излазна страница';
$string['exittext'] = 'Текст на излазној страници';
$string['feedbackdiscuss'] = 'Дискутујте о овом тесту на форуму';
$string['feedbackformmail'] = 'Образац за повратне информације';
$string['feedbackmoodleforum'] = 'Moodle форум';
$string['feedbackmoodlemessaging'] = 'Moodle систем за поруке';
$string['feedbacknone'] = 'Нема';
$string['feedbacksendmessage'] = 'Пошаљите поруку свом предавачу';
$string['feedbackwebpage'] = 'Веб страница';
$string['firstattempt'] = 'Први покушај';
$string['forceplugins'] = 'Обавезни мултимедијални додаци';
$string['forceplugins_help'] = 'Ако је омогућено, Moodle компатибилни медија плејери ће приказивати датотеке као што су mpeg, mpg, mp3, mov и wmv. У супротном, Moodle неће да промени подешавање било ког медија плејера у тесту.';
$string['frameheight'] = 'Висина оквира';
$string['giveup'] = 'Одустајање';
$string['grademethod'] = 'Начин оцењивања';
$string['grademethod_help'] = 'Ово подешавање одређује како се на основу резултата покушаја рачуна оцена за HotPot.

**Највећи резултат**
: оцена ће бити подешена на највећи резултат за покушај на овој HotPot активности.

**Просечан резултат**
: оцена ће бити подешена на  просечан резултат свих покушаја на овој HotPot активности.

**Први покушај**
: оцена ће бити подешена на резултат првог покушаја на овој HotPot активности.

**Последњи покушај**
: оцена ће бити подешена на резултат последњег покушаја на овој HotPot активности.';
$string['gradeweighting'] = 'Пондерисање оцене';
$string['gradeweighting_help'] = 'Оцена за ову HotPot активност биће градирана према овом броју у књизи са оценама Moodlea.';
$string['highestscore'] = 'Најбољи резултат';
$string['hints'] = 'Помоћ';
$string['hotpot:addinstance'] = 'Додај нову HotPot активност';
$string['hotpot:attempt'] = 'Покушајте HotPot тест и пошаљите одговоре';
$string['hotpot:deleteallattempts'] = 'Обриши све покушаје корисника на HotPot активности.';
$string['hotpot:deletemyattempts'] = 'Обриши сопствене покушаје на HotPot активности.';
$string['hotpot:ignoretimelimits'] = 'Игнориши временска ограничења HotPot активности';
$string['hotpot:manage'] = 'Измени подешавања HotPot активности';
$string['hotpot:preview'] = 'Преглед HotPot активности';
$string['hotpot:reviewallattempts'] = 'Погледај све покушаје корисника на HotPot активности.';
$string['hotpot:reviewmyattempts'] = 'Погледај сопствене покушаје на HotPot активности.';
$string['hotpot:view'] = 'Погледај улазну страницу HotPot теста';
$string['hotpotname'] = 'Назив HotPot активности';
$string['ignored'] = 'Игнорисано';
$string['inprogress'] = 'У току';
$string['isgreaterthan'] = 'је већи од';
$string['islessthan'] = 'је мањи од';
$string['lastaccess'] = 'Последњи приступ';
$string['lastattempt'] = 'Последњи покушај';
$string['lockframe'] = 'Закључај оквир';
$string['maxeventlength'] = 'Максималан број дана за један календарски догађај';
$string['mediafilter_hotpot'] = 'HotPot медијски филтер';
$string['mediafilter_moodle'] = 'Стандардни медијски филтери Moodlea';
$string['migratingfiles'] = 'Миграција датотека Hot Potatoes теста';
$string['migratinglogs'] = 'Премештам хот потеитос записе о активностима';
$string['missingsourcetype'] = 'HotPot запису недостаје изворни тип';
$string['modulename'] = 'HotPot тест';
$string['modulename_help'] = 'HotPot модул омогућава предавачима да својим студентима дистрибуирају интерактивне садржаје за учење путем Moodlea, као и да виде извештаје о њиховим одговорима и резултатима.

Једна HotPot активност се састоји од уводне странице, која је опциона, једне онлајн вежбе и излазне странице, која је, такође, опциона. Онлајн вежба може бити статична веб страница или интерактивна веб страница која студентима нуди интерактивни текстуални, аудио и видео садржај, и бележи њихове одговоре. Онлајн вежбу предавач креира на свом рачунару користећи софтверски алат за креирање садржаја, а затим припремљени материјал поставља на Moodle.

HotPot активност може да манипулише вежбама које су креиране уз помоћ следећих софтверских пакета:

* Hot Potatoes (version 6)
* Qedoc
* Xerte
* iSpring
* било који HTML едитор';
$string['modulename_link'] = 'mod/hotpot/view';
$string['modulenameplural'] = 'HotPot тестови';
$string['nameadd'] = 'Назив';
$string['nameadd_help'] = 'Назив може бити специфичан текст који је унео предавач или аутоматски генерисани текст

**Преузми из изворне датотеке**
: назив ће бити извучен из изворне датотеке.

**Користи назив изворне датотеке**
: назив изворне датотеке биће коришћен као назив.

**Користи путању изворне датотеке**
: путања изворне датотеке биће коришћена као назив. Све косе црте у путањи биће замењене са размацима.

**Специфичан текст**
: одређени текст који је унео предавач биће коришћен као назив.';
$string['nameedit'] = 'Назив';
$string['nameedit_help'] = 'Текст који се приказује студентима';
$string['navigation'] = 'Навигација';
$string['navigation_embed'] = 'Уграђена веб страница';
$string['navigation_frame'] = 'Moodle навигациони оквир';
$string['navigation_give_up'] = 'Дугме за појединачно одустајање';
$string['navigation_help'] = 'Ово подешавање одређује која врста навигације ће бити коришћена у тесту:

**Moodle навигациона трака**
: Moodle навигациона трака биће приказана у истом прозору као у тест, на врху странице

**Moodle навигациона оквир**
: Moodle navigaciona трака биће приказана у одвојеном оквиру, на врху теста

**Уграђена веб страница**
: Moodle навигациона трака биће приказана у истом прозору са Хот Потатоес тестом, уграђеним у прозор

**Оригинална навигација**
: ако је унутар теста дефинисано било које навигационо дугме, тест ће бити приказан са њима

**Дугме "Одустани"**
: тест ће бити приказан са једним јединим дугметом "Одустани" на врху странице

** Нема навигације**
: тест ће бити приказан без навигационих помагала, тако да ће након тачних одговора на сва питања, зависно од подешавања "Прикажи следећи тест", Moodle или преусмерити корисника на насловну страницу курса или ће приказати следећи тест';
$string['navigation_moodle'] = 'Стандардне Moodle навигационе траке (на врху и са стране)';
$string['navigation_none'] = 'Нема';
$string['navigation_original'] = 'Оригинална навигација';
$string['navigation_topbar'] = 'Само Moodle навигациона трака на врху (без навигације са стране)';
$string['noactivity'] = 'Нема активности';
$string['nohotpots'] = 'Ниједна HotPot активност није пронађена';
$string['nomoreattempts'] = 'Нажалост, није Вам преостао више ниједан покушај  за ову активност';
$string['noresponses'] = 'Нису пронађене информације о појединачним питањима и одговорима.';
$string['noreview'] = 'Нажалост, није вам дозвољено да погледате детаље овог покушаја решавања теста';
$string['noreviewafterclose'] = 'Нажалост, овај тест је затворен. Није вам више дозвољено да погледате детаље овог покушаја решавања теста.';
$string['noreviewbeforeclose'] = 'Нажалост, није вам дозвољено да погледате детаље овог покушаја решавања теста до {$a}';
$string['nosourcefilesettings'] = 'HotPot запису недостаје информација о изворној датотеци';
$string['notattemptedyet'] = 'Још није покушано';
$string['notavailable'] = 'Нажалост, ова активност Вам тренутно није доступна';
$string['outputformat'] = 'Излазни формат';
$string['outputformat_best'] = 'Најбоље';
$string['outputformat_help'] = 'Излазни формат одређује како ће садржај бити презентован студентима

Излазни формати који су доступни зависе од типа изворне датотеке. Неки типови изворних датотека имају само један излазни формат док други типови имају неколико излазних формата.

"Најбоље" подешавање прикаће садржај користећи оптималан излазни формата за студентске веб читаче.';
$string['outputformat_hp_6_jcloze_html'] = 'JCloze (v6) from html';
$string['outputformat_hp_6_jcloze_html_dropdown'] = 'JCloze HP6 html: Rottmeier DropDown';
$string['outputformat_hp_6_jcloze_html_findit_a'] = 'FindIt (a) из html';
$string['outputformat_hp_6_jcloze_html_findit_b'] = 'FindIt (b) из html';
$string['outputformat_hp_6_jcloze_html_jgloss'] = 'JCloze HP6 html: Rottmeier JGloss';
$string['outputformat_hp_6_jcloze_xml_anctscan'] = 'ANCT-Scan from HP6 JCloze xml';
$string['outputformat_hp_6_jcloze_xml_dropdown'] = 'DropDown from HP6 JCloze xml';
$string['outputformat_hp_6_jcloze_xml_findit_a'] = 'FindIt (a) from HP6 JCloze xml';
$string['outputformat_hp_6_jcloze_xml_findit_b'] = 'FindIt (b) from HP6 JCloze xml';
$string['outputformat_hp_6_jcloze_xml_jgloss'] = 'JGloss from HP6 JCloze xml';
$string['outputformat_hp_6_jcloze_xml_v6'] = 'JCloze (v6) from HP6 xml';
$string['outputformat_hp_6_jcloze_xml_v6_autoadvance'] = 'JCloze (v6) из HP6 xml-а (Аутоматско напредовање)';
$string['outputformat_hp_6_jcross_html'] = 'JCross (v6) from html';
$string['outputformat_hp_6_jcross_xml_v6'] = 'JCross (v6) from xml';
$string['outputformat_hp_6_jmatch_html'] = 'JMatch (v6) from html';
$string['outputformat_hp_6_jmatch_html_sort'] = 'JMatch сортирање из html';
$string['outputformat_hp_6_jmatch_xml_flashcard'] = 'JMatch (flashcard) from xml';
$string['outputformat_hp_6_jmatch_xml_jmemori'] = 'JMemori from xml';
$string['outputformat_hp_6_jmatch_xml_sort'] = 'JMatch сортирање из xml';
$string['outputformat_hp_6_jmatch_xml_v6'] = 'JMatch (v6) from xml';
$string['outputformat_hp_6_jmatch_xml_v6_plus'] = 'JMatch (v6+) from xml';
$string['outputformat_hp_6_jmix_html'] = 'JMix (v6) from html';
$string['outputformat_hp_6_jmix_xml_v6'] = 'JMix (v6) from xml';
$string['outputformat_hp_6_jmix_xml_v6_plus'] = 'JMix (v6+) from xml';
$string['outputformat_hp_6_jmix_xml_v6_plus_deluxe'] = 'JMix (v6+ with prefix, suffix with distractors) from xml';
$string['outputformat_hp_6_jmix_xml_v6_plus_keypress'] = 'JMix (v6+ with key press) from xml';
$string['outputformat_hp_6_jquiz_html'] = 'JQuiz (v6) from html';
$string['outputformat_hp_6_jquiz_xml_v6'] = 'JQuiz (v6) from xml';
$string['outputformat_hp_6_jquiz_xml_v6_autoadvance'] = 'JQuiz (v6) from xml (Auto-advance)';
$string['outputformat_hp_6_jquiz_xml_v6_exam'] = 'JQuiz (v6) from xml (Exam)';
$string['outputformat_hp_6_rhubarb_html'] = 'Rhubarb (v6) from html';
$string['outputformat_hp_6_rhubarb_xml'] = 'Rhubarb (v6) from xml';
$string['outputformat_hp_6_sequitur_html'] = 'Sequitur (v6) from html';
$string['outputformat_hp_6_sequitur_html_incremental'] = 'Sequitur (v6) from html, incremental scoring';
$string['outputformat_hp_6_sequitur_xml'] = 'Sequitur (v6) from xml';
$string['outputformat_hp_6_sequitur_xml_incremental'] = 'Sequitur (v6) from xml, incremental scoring';
$string['outputformat_html_ispring'] = 'iSpring HTML датотека';
$string['outputformat_html_xerte'] = 'Xerte HTML датотека';
$string['outputformat_html_xhtml'] = 'Стандардна HTML датотека';
$string['outputformat_qedoc'] = 'Qedoc датотека';
$string['overviewreport'] = 'Преглед';
$string['penalties'] = 'Казнени бодови';
$string['percent'] = 'Проценат';
$string['pluginadministration'] = 'HotPot администрација';
$string['pluginname'] = 'Hot Potatoes модул';
$string['pressoktocontinue'] = 'Притисни OK за наставак или Одустани да бисте остали на текућој страници';
$string['questionshort'] = 'Питање {$a}';
$string['quizname_help'] = 'текст помоћи за Назив теста';
$string['quizzes'] = 'Тестови';
$string['responses'] = 'Одговора';
$string['responsesreport'] = 'Одговори';
$string['reviewafterattempt'] = 'Дозволи преглед након покушаја';
$string['reviewafterclose'] = 'Дозволи преглед након што се ХотПот затвори';
$string['reviewduringattempt'] = 'Дозволи преглед током покушаја';
$string['reviewoptions'] = 'Опције прегледа';
$string['score'] = 'Резултат';
$string['scoresreport'] = 'Резултати';
$string['selectattempts'] = 'Изабери покушаје';
$string['showerrormessage'] = 'HotPot грешка: {$a}';
$string['sourcefile'] = 'Назив изворне датотеке';
$string['sourcefile_help'] = 'Ово подешавање одређује датотеку у којој се налази садржај који ће бити приказан студентима.

Обично се изворна датотека креира изван Moodlea, а затим се поставља у подручје са датотекама Moodle курса.
То може да буде html или неки други тип датотеке креиране уз помоћ програма као што су Hot Potatoes или Qedoc

Изворна датотека може да буде наведена као фолдер и путања датотеке унутар подручја за датотеке Moodle курса или као  url адреса која почиње са http:// or https://

За Qedec материјале, изворна датотека мора да буде url адреса Qedec модула који постављен на Qedec сервер.

* нпр. http://www.qedoc.net/library/ABCDE_123.zip
* За информације о постављањз Qedoc модула погледај [Qedoc documentation: Uploading_modules](http://www.qedoc.org/en/index.php?title=Uploading_modules)';
$string['sourcefilenotfound'] = 'Изворна датотека није пронађена (или је празна): {$a}';
$string['status'] = 'Статус';
$string['stopbutton'] = 'Прикажи дугме за заустављање';
$string['stopbutton_help'] = 'Ако је омогућено, у тест ће бити убачено дугме за зауствљање.

Ако студент кликне на дугме за заустављање, дотадашњи његов резултат биће прослеђен Moodleu, а статус покушаја решавања теста биће постављен на \'Напуштено\'

Текст који се приказује на дугмету за заустављање може бити нека од стандардниих фраза из Moodle језичког пакета или предавач може да одреди сопствени текст за дугме.';
$string['stopbutton_langpack'] = 'Из језичког пакета';
$string['stopbutton_specific'] = 'Користи специфичан текст';
$string['stoptext'] = 'Текст на дугмету за заустављање';
$string['storedetails'] = 'Сачувај необрађене XML детаље покушаја решавања HotPot теста';
$string['studentfeedback'] = 'Повратне информације студента';
$string['studentfeedback_help'] = 'Ако је омогућено, линк ка искачућем прозору  са повратном информацијом ће се приказати увек када студент кликне дугме "Провери". Прозор  са повратном информацијом дозвољава студентима да дискутују о овом тесту са својим предавачима и колегама на један од следећих начина:

*Веб страница**
: захтева URL адресу веб странице, на пример http://myserver.com/feedbackform.html

**Образац повратне информације**
: захтева URL адресу скрипта са обрасцем, на пример http://myserver.com/cgi-bin/formmail.pl

**Moodle форум**
: биће приказан индекс форума на курсу

**Moodle систем за поруке**
: биће приказан Moodle прозор за поруке. Ако курс има неколико предавача од студенте ће се тражити да изабере једног од њих пре него што се прозор за поруке појави.';
$string['submits'] = 'Предата решења';
$string['subplugintype_hotpotattempt'] = 'Формат резултата';
$string['subplugintype_hotpotattempt_plural'] = 'Формати резултата';
$string['subplugintype_hotpotreport'] = 'Извештај';
$string['subplugintype_hotpotreport_plural'] = 'Извештаји';
$string['subplugintype_hotpotsource'] = 'Изворна датотека';
$string['subplugintype_hotpotsource_plural'] = 'Изворне датотеке';
$string['textsourcefile'] = 'Преузми из изворне датотеке';
$string['textsourcefilename'] = 'Користи назив изворне датотеке';
$string['textsourcefilepath'] = 'Користи путању изворне датотеке';
$string['textsourcequiz'] = 'Преузимање из теста';
$string['textsourcespecific'] = 'Специфициран текст';
$string['timeclose'] = 'Доступно до';
$string['timedout'] = 'Време је истекло';
$string['timelimit'] = 'Временско ограничење';
$string['timelimit_help'] = 'Ово подешавање одређује максимално дозвољено трајање једног покушаја.

**Користите подешавања из изворне или датотеке шаблона**
: временско ограничење ће бити преузето из изворне или датотека шаблона за овај излазни формат.

**Користите одређено време**
: временско ограничење одређено у подешавањима HotPot теста биће коришћено за покушаје решавања овог теста. Ово подешавање има предност у односу на временско ограничење у изворној, конфигурационој или датотекама шаблона за овај излазни формат.

**Онемогући**
: временско ограничење неће бити постављено за покушаје решавања овог теста.

Имајте у виду, да уколико се покушај наставља, тајмер наставља тамо где је стао у тренутку када је покушај привремено прекинут.';
$string['timelimitexpired'] = 'Временско ограничење за овај покушај је истекло';
$string['timelimitspecific'] = 'Користи одређено време';
$string['timelimitsummary'] = 'Временско ограничење за један покушај';
$string['timelimittemplate'] = 'Користите подешавања из изворне или датотеке шаблона';
$string['timeopen'] = 'Доступно од';
$string['timeopenclose'] = 'Време отварања и затварања';
$string['timeopenclose_help'] = 'Можете да одредите време када је тест доступан корисницима за решавање. Пре отварања и након затварања, тест ће бити недоступан.';
$string['title'] = 'Наслов';
$string['title_help'] = 'Ово подешавање одређује наслов који ће бити приказан на веб страници

**Назив HotPot активности**
: назив HotPot активности биће приказан као наслов веб странице.

**Преузми из изворне датотеке**
: ако је наслов дефинисан у изворној датотеци, биће коришћен као наслов веб странице.

**Користи назив изворне датотеке**
: као наслов веб странице биће коришћен назив изворне датотеке, искључујући називе фолдера.

**Користи путању изворне датотеке**
: као наслов веб странице биће коришћена путања изворне датотеке, укључујући називе било ког фолдера.';
$string['toolsindex'] = 'Индекс ХотПот алата';
$string['unitname_help'] = 'текст помоћи за назив јединица';
$string['unrecognizedsourcefile'] = 'Жао нам је, HotPot модул није могао да детектује тип изворне датотеке: {$a}';
$string['updated'] = 'Ажурирано';
$string['updatinggrades'] = 'Ажурирам ХотПот оцене';
$string['usefilters'] = 'Користи филтере';
$string['usefilters_help'] = 'Ако је ово подешавање омогућено, садржај ће бити пропуштен кроз филтере Moodlea пре него што буде послат веб читачу.';
$string['useglossary'] = 'Користи речник';
$string['useglossary_help'] = 'Ако је ово подешавање омогућено, садржај ће бити пропуштен кроз филтер за аутоматско-линковање Moodle речника пре него што буде послат веб читачу.

Имајте у виду да ово подешавање има предност над истим таквим подешавањем филтером за аутоматско линковање на нивоу сајта.';
$string['usemediafilter'] = 'Користи медијске филтере';
$string['usemediafilter_help'] = 'Ово подешавање одређује медијске филтере који ће се користити.

**Без филтера**
: садржај неће бити пропуштени ни кроз један филтер

**Стандардни медијски филтери Moodlea**
: садржај ће бити пропуштен кроз стандардне медијске филтере Moodlea. Ови филтери трагају за линковима уобичајених аудио и видео датотека и конвертују их за приказ у одговарајућим медија плејерима.

**HotPot медијски филтер**
: садржај ће бити пропуштен кроз филтере који откривају линкове, слике, аудио и видео датотеке које ће бити наведене помоћу угластих заграда (square bracket notation)

Нотација помоћу угластих заграда има следећу синтаксу:
<code>[url player width height options]</code>

**url**
: релативна или апсолутна url адреса мултимедијалне датотеке

**плејер** (опционо)
: назив плејерa који ће бити уметнут. Подразумевана вредност за ово подешавање је "moodle". Стандардна верзија модула HotPot такође нуди следеће плејере:
: **dew**: mp3 плејер
: **dyer**: mp3 плејер Bernarda Dyera
: **hbs**: mp3 player фирме Half-Baked Software
: **слика**: убацује слику у веб страницу
: **линк**: убацује линк у веб страницу

**ширина** (опционо)
: потребна ширина плејера

**висина** (опционо)
: потребна висина плејера. Ако је изостављена ова вредност ће бити иста као и подешавање за ширину.

**опције** (опционо)
: списак опција раздвојених зарезом биће прослеђена плејеру. Свака опција може бити једноставан укључи/искључи прекидач, или пар назива и вредностри.
: **назив=вредност
: **назив=нека вредност са размацима"';
$string['viewreports'] = 'Погледај извештаје за {$a} корисника';
$string['views'] = 'Прегледи';
$string['weighting'] = 'Вредновање';
$string['wrong'] = 'Погрешно';
$string['zeroduration'] = 'Без трајања';
$string['zeroscore'] = 'Нула бодова';
