<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'format_tiles', language 'sr_cr', version '5.1'.
 *
 * @package     format_tiles
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['addsections'] = 'Додај плочицу';
$string['admintools'] = 'Администраторски алати';
$string['all'] = 'Све';
$string['allcomplete'] = 'Све је завршено';
$string['allcoursescomplypalette'] = 'Сви курсеви већ имају дозвољене боје плочица. Нема ничега за ресетовање. Уверите се да сте сачували све промене дозвољених боја пре него што притиснете дугме за ресетовање.';
$string['allowphototiles'] = 'Дозволи фото плочице';
$string['allowphototiles_desc'] = 'Ако је изабрана ова опција, предавачи ће моћи да поставе фотографију која ће служити као позадина плочице. Без обзира на то, они ће и даље моћи да користе стандардне иконице на истом курсу (ако пак није изабрано, само ће иконице бити дозвољене, а остала подешавања која се односе на фото плочице биће занемарена).';
$string['allowsubtilesview'] = 'Дозволи приказ подплочица';
$string['allowsubtilesview_desc'] = 'Дозволи коришћење подешавања курса које, ако је изабрано, омогућава да се активности и ресурси (осим натписа) унутар плочице приказују  као подплочице, уместо стандардне листе';
$string['alternativelink'] = 'алтернативни линк';
$string['areyousure'] = 'Да ли сте сигурни?';
$string['asfraction'] = 'Прикажи као разломак';
$string['aspectratiotootallorwide'] = 'Постављена слика је сачувана, али молим вас проверите, јер би могла да буде <strong>{$a->tallorwide}</strong>. Уколико не изгледа добро исеците је на стандардне димензије положене слике и поставите поново. На пример, димензије слике 300 пискела ширине x 200 пиксела висина би биле сасвим одговарајуће.';
$string['aspercentagedial'] = 'Прикажи као %';
$string['assumedatastoreconsent'] = 'Претпоставите сагласност корисника да се подаци складиште у локалној меморији веб читача';
$string['assumedatastoreconsent_desc'] = 'Ако је изабрана ова опција, кориснику <b>неће</b> бити приказан дијалог у којем се тражи сагласност да се подаци чувају у локалној меморији веб читача';
$string['backupfailed'] = 'Креирање резервне копије није успело';
$string['basecolour'] = 'Боја за плочице';
$string['basecolour_help'] = 'Овде подешена боја биће примењена на све плочице на курсу (доступне боје одређује администратор сајта на страници за подешавање додатка \'Плочице\').';
$string['brandcolour'] = 'Боја бренда';
$string['cachedef_formatoptionelementids'] = 'Једноставан низ ID ознака елемената који имају подешене опције формата, нпр. ID ознаке секција на курсу које садрже фотографије.';
$string['cachedef_formatoptions'] = 'Низ вредности опција формата курса ID ознака елемената. Нпр. називи датотека фотографија према ID ознаци секције на курсу.';
$string['cachedef_modalcmids'] = 'ID ознаке модула на курсу који треба да се покрену помоћу модалног прозора';
$string['cachedef_videocmids'] = 'ID ознаке модула на курсу (по курсу) као што су видео снимци (URL активности које воде до YouTube или Vimeo видео клипова)';
$string['changedcolour'] = 'Боја плочица је ресетована на подразумевану за курс {$a}';
$string['checkforproblemcourses'] = 'Проверите да ли постоје евентуални проблеми унутар курсева и исправите их';
$string['clearphoto'] = 'Ресетујте ову плочицу';
$string['clickiffailstoload'] = 'Кликните ако се страница не учита';
$string['close'] = 'Затвори';
$string['closetopsection'] = 'Затворите секцију на врху';
$string['collapse'] = 'Скупи секцију';
$string['collapsesections'] = 'Скупи све';
$string['colourblue'] = 'Плаво';
$string['colourdarkgreen'] = 'Тамно зелено';
$string['colourgreen'] = 'Зелено';
$string['colourlightblue'] = 'Светло плаво';
$string['colourname_descr'] = 'Приказује назив за боју (корисници обично не виде овај назив, већ узорак боје)';
$string['colournamegeneral'] = 'Прикажи назив за боју изнад';
$string['colourpurple'] = 'Љубичасто';
$string['colourred'] = 'Црвено';
$string['colours'] = 'Боје';
$string['complete'] = 'Завршено';
$string['complete-n-auto'] = 'Ставка није завршена. Биће означена као завршена тек када испуните све критеријуме за завршетак. Ово не можете променити ручно.';
$string['complete-y-auto'] = 'Ставка је завршена. Означена је као завршена оног тренутка када сте испунили критеријуме за завршетак. Ово не можете променити ручно.';
$string['completion_help'] = 'Квачица са десне стране активности може се користити да означи када је активност завршена (празан круг биће приказан ако није).<br><br>
У зависности од подешавања, квачица се може појавити аутоматски када сте завршили активност, а на основу услова које је поставио предавач.<br><br>
У осталим случајевима можете кликнути на празан круг када мислите да сте завршили активност и он ће се претворити у зелену квачицу (ако се предомислите, поновним кликом квачица се уклања ).';
$string['completionswitchhelp'] = '<p>Изабрали сте да прикажете праћење завршетка на свакој плочици.  Стога смо опцију "Праћење завршетка > Омогући праћење завршетка" у наставку ове странице подесили на "Да".</p>
<p>Поред тога, потребно је да укључите праћење завршетка за <b>сваку ставку</b> коју пратите, као нпр. за  PDF датотеку, кликните на "Уреди подешавања", а затим у оквиру опције "Завршетак активности", изаберите подешавање које желите.</p>
<p>Ово такође можете учинити и <b>групно</b> (за већи број ставки истовремено) као што је већ описано у детаљном објашњењу о праћењу завршетка на {$a}</a></p>';
$string['completionwarning'] = 'Иако сте у подешавањима курса укључили праћење завршетка, на нивоу појединачних активности ни код једне од активности праћење завршетка није омогућено, тако да нема шта да се прати.';
$string['completionwarning_changeinbulk'] = 'Групна промена завршетка активности';
$string['completionwarning_help'] = 'Морате да омогућите праћење завршетка појединачних активности тако што ћете укључити праћење  у подешавањима сваке од активности, појединачно (Завршетак активност > Праћење завршетка). Ово можете учинити, и истовремено за већи број активност на нивоу самог курса тако што ћете у оквиру картице \'Више\' изабрати \'Завршетак курса\', а затим, на следећој страници, из падајућег менија \'Групно уређивање завршетка активности\'';
$string['contact'] = 'Будимо у контакту';
$string['contactdeveloper'] = 'Контактирајте програмера';
$string['contents'] = 'Садржаји';
$string['controls'] = 'Контролни елементи';
$string['coursephotomigrationincomplete'] = 'Иконице плочица и фотографије још увек нису мигриране након преласка на нову верзију система. Ставке које недостају требало би да се појаве у року од неколико сати од надоградње.';
$string['courseshowtileprogress'] = 'Напредак на свакој плочици';
$string['courseshowtileprogress_error'] = 'Подесили сте \'Праћење завршетка >Омогући праћење завршетка\' на \'Не\' (погледајте даље, у наставку ове страници) што је у супротности са овим подешавањем. Ако желите да прикажете напредак на плочицама, подесите \'Праћење завршетка >Омогући праћење завршетка\' на \'Да\'. У супротном, поставите ово подешавање на \'Не\'.';
$string['courseshowtileprogress_help'] = '<p>Када се изабере ова опција, напредак корисника са активностима биће приказано у свакој плочици, било као <em>разломак</em> (нпр. \'Напредак 2/10\' значи да је корисник завршио 2 од 10 активности), или као <em>проценат</em> у кругу.</p><p>Ово се може користити само ако је подешавање \'Праћење завршетка >Омогући праћење завршетка\' укључено.</p><p>Ако унутар дате плочице нема активности чији завршетак може да се прати, онда индикатор за ту плочицу неће бити приказан.</p>';
$string['courseshowtileprogress_link'] = 'Activity_completion_settings#Activity_settings';
$string['coursetoomanysections'] = 'Упозорење за кориснике са уређивачким правима: овај курс има више плочица од максимално дозвољеног броја. Полазницима ће бити приказано највише {$a->max} плочице/а (до "{$a->tilename}") (корисници са уређивачким правима могу да виде више).';
$string['courseusebarforheadings'] = 'Истакни наслове обојеним језичком';
$string['courseusebarforheadings_help'] = 'Прикажите обојену картицу лево од наслова у курсу кад год је стил наслова изабран у едитору текста';
$string['courseusesubtiles'] = 'Користите подплочице за активности';
$string['courseusesubtiles_help'] = 'Унутар сваке плочице, прикажите сваку активност као подплочицу, уместо као листу активности на страници. Ово се не односи на натписе које неће бити приказане као подплочице па се могу користити као наслови између плочица.';
$string['currentsection'] = 'Ова плочица';
$string['customcss'] = 'Прилагођени CSS';
$string['customcssdesc'] = 'Прилагођени CSS који се примењује на секцију са садржајем курса када се користи формат плочица. CSS неће бити провераван, па водите рачуна да унесете исправан кôд. На пример: <p>.section { color: red; }</p><p>li.activity.subtile.resource.pdf { background-color: orange !important; }</p>';
$string['datapref'] = 'Подешавање складишта података';
$string['datapreferror'] = 'Функција подешавања складишта података је доступна само ако је JavaScript доступан у вашем веб читачу. У супротном, складиштење података не може бити омогућено.
Подешавање складишта података је доступно само ако је омогућен JavaScript у Вашем веб прегледачу.';
$string['dataprefquestion'] = '<p>Како би сајт био једноставнији за коришћење, у оквиру веб читача чувамо функционалне информације попут ID броја плочице коју сте последњу отворли. Ти подаци остају запамћени кратко на вашем рачунару, у случају да поново посетите исту страницу. Не користимо их за праћење. Да ли је то у реду?</p>
<p>Ваш избор ће бити запамћен све док не избришете историју посећених сајтова у вашем веб читачу. Да бисте искључили ову опцију кликните на "Откажи".</p>';
$string['defaultthiscourse'] = 'Подразумевано за овај курс';
$string['defaulttilecolour'] = 'Подразумевана боја плочице';
$string['defaulttileicon'] = 'Иконица плочице';
$string['defaulttileicon_help'] = 'Овде изабрана иконица стандардно ће се појављивати на <em>свим</em> плочицама у овом курсу. За појединачне плочице могу се изабрати друге иконице или позадинске фотографије, коришћењем различитих подешавања на нивоу плочице.';
$string['deleteemptytiles'] = 'Обриши празне плочице';
$string['deleteimage'] = 'Обриши слику';
$string['deletesection'] = 'Обриши';
$string['developedby'] = 'Формат плочица развио је {$a}';
$string['developer'] = 'Програмер';
$string['disabledbyadmin'] = 'Онемогућио администратор сајта';
$string['displayfilterbar'] = 'Трака филтера';
$string['displayfilterbar_error'] = 'Можете приказати траку филтера само на основу бројева плочица, а не на основу исхода, осим ако нисте претходно подесили исходе за овај курс,  Прво креирајте исходе па се затим вратите овде.';
$string['displayfilterbar_help'] = '<p>Када се изабере ова опција, на почетку главне странице курс биће аутоматски приказан низ дугмади, на које корисници могу да кликну како би филтрирали плочице из одговарајућег опсега</p><p>
Када се изабере  опција \'на основу бројева плочица\', биће приказан низ дугмади, нпр. дугме за плочице 1-4, дугме за плочице 5-8 итд.</p><p>Када се изабере опција \'на основу исхода курса\', за сваки исход курса биће приказано једно дугме. Свака плочица може бити додељена датом исходу (а самим тим и датом дугмету) са странице за подешавања те плочице.</p>';
$string['displayfilterbar_link'] = 'Outcomes';
$string['displaytitle_mod_doc'] = 'Word документ';
$string['displaytitle_mod_html'] = 'Веб страница';
$string['displaytitle_mod_jpeg'] = 'Слика';
$string['displaytitle_mod_mp3'] = 'Аудио';
$string['displaytitle_mod_mp4'] = 'Видео';
$string['displaytitle_mod_pdf'] = 'PDF';
$string['displaytitle_mod_ppt'] = 'Powerpoint презентација';
$string['displaytitle_mod_txt'] = 'Текст';
$string['displaytitle_mod_xls'] = 'Радна табела';
$string['displaytitle_mod_zip'] = 'Zip архива';
$string['download'] = 'Преузми';
$string['editoradvicesubtiles'] = 'У овој верзији додатка \'Формат плочица\', активности ће се појављивати као подплочице само ако је режим уређивања искључен';
$string['editsection'] = 'Уреди';
$string['editsectionname'] = 'Уреди назив секције';
$string['embeddedurlerror'] = 'Ако екстерни веб сајт одбије да буде приказан у прозору изнад, употребите ово:';
$string['enablelinebreakfilter'] = 'Омогући филтер за прелом реда';
$string['enablelinebreakfilter_desc'] = 'Филтрирајте наслове плочица за невидљиви знак за спајање речи {$a} и, ако он постоји, а наслов плочице је дугачак, замените га са  "- " како бисте дозволили прелом реда. У супротном га немојте замените ни са чим (тј. без прелома реда).';
$string['entersection'] = 'Уђи на секцију';
$string['existingimage'] = 'Постојећа слика за ову плочицу';
$string['expand'] = 'Прошири';
$string['expandall'] = 'Прошири све';
$string['expandsections'] = 'Откријте све активности (све секције)';
$string['expandtopsection'] = 'Отворите секцију на врху';
$string['experimental'] = 'експериментално';
$string['experimentalfeatures'] = 'Експерименталне функције';
$string['fileaddedtobottom'] = 'Датотека је додата на крај секције';
$string['filterboth'] = 'Прикажи дугмад на основу бројева плочица и исхода курса';
$string['filternumbers'] = 'Прикажи дугмад на основу бројева плочица';
$string['filteroutcomes'] = 'Прикажи дугмад на основу исхода курса';
$string['filteroutcomesrestore'] = 'Оригинални курс користио је исходе у траци филтера, који још нису подржани током процеса рестаурирања. Подешавање траке филтера је стога промењено у рестаурираном курсу. Уколико желите да користите исходе за филтрирање плочица у рестаурираном курсу, подесите их поново. Првобитни курс није промењен.';
$string['filters'] = 'Филтери';
$string['fittilestowidth'] = 'Прилагодите плочице ширини екрана';
$string['fittilestowidth_desc'] = 'Ако је означено, када корисник приступа курсу на уређају који није мобилан, учитавање плочице биће одложено на пола секунде док се направи прорачун за најбољи распоред плочица на страници. На пример, избегавајте да један ред има само једну плочицу, или да плочицу поставите у центар екрана. Ово ће се догодити само када корисници први пут уђу на курс у датој сесији, а онда ће распоред плочица бити запамћено за ту сесију или док корисник не подеси величину екрана.';
$string['fixproblems'] = 'Реши проблеме';
$string['folderdisplayerror'] = 'Директоријуми подешени да приказују садржај унутар почетне странице курса нису компатибилни са форматом подплочица. На пример директоријум "{$a}" треба да се промени тако да садражј приказује на засебној страници';
$string['followthemecolour'] = 'Обавезна употреба боја графичке теме';
$string['followthemecolour_desc'] = 'Ако је подешено на \'Да\', ова додатак неће дати предавачима могућност да бирају боје, и све боје подешене у наставку ове странице биће игнорисане. Уместо тога, користиће се главна бренд боја графичке теме';
$string['guidance'] = 'Упутство';
$string['height'] = 'висина';
$string['hidden'] = 'Сакривено';
$string['hide'] = 'Сакриј';
$string['highcontrastmode'] = 'Режим високог контраста';
$string['highcontrastmodeallow'] = 'Дозволите режим високог контраста';
$string['highcontrastmodeallow_desc'] = 'Дозволите полазницима да подесе своје корисничке параметре тако да плочице на курсевима буду приказани са израженијим контрастом (боје плочица које је изабрао предавач ће бити замењене тамном бојом)';
$string['highestsectionnum'] = 'Пронађен највећи број секција';
$string['home'] = 'Почетна страница курса';
$string['icontitle-address-book-o'] = 'Адресар';
$string['icontitle-assessment_graded'] = 'Провера знања А+';
$string['icontitle-assessment_timer'] = 'Тајмер за проверу знања';
$string['icontitle-asterisk'] = 'Звездица';
$string['icontitle-award-solid'] = 'Наградна розета';
$string['icontitle-balance-scale'] = 'Вага';
$string['icontitle-bar-chart'] = 'Тракасти графикон';
$string['icontitle-bell-o'] = 'Звоно';
$string['icontitle-binoculars'] = 'Двоглед';
$string['icontitle-bitcoin'] = 'Биткоин';
$string['icontitle-book'] = 'Књига';
$string['icontitle-bookmark-o'] = 'Обележивач';
$string['icontitle-briefcase'] = 'Актовка';
$string['icontitle-building'] = 'Зграда';
$string['icontitle-bullhorn'] = 'Мегафон';
$string['icontitle-bullseye'] = 'Центар мете';
$string['icontitle-calculator'] = 'Калкулатор';
$string['icontitle-calendar'] = 'Календар';
$string['icontitle-calendar-check-o'] = 'Календар са штриклом';
$string['icontitle-check'] = 'Штрикла';
$string['icontitle-child'] = 'Дете';
$string['icontitle-clock-o'] = 'Сат';
$string['icontitle-clone'] = 'Клон';
$string['icontitle-cloud-download'] = 'Облак (преузимање)';
$string['icontitle-cloud-upload'] = 'Облак (постављање)';
$string['icontitle-comment-o'] = 'Коментар';
$string['icontitle-comments-o'] = 'Коментари';
$string['icontitle-compass'] = 'Компас';
$string['icontitle-diamond'] = 'Дијамант';
$string['icontitle-dollar'] = 'Долар';
$string['icontitle-euro'] = 'Долар';
$string['icontitle-exclamation-triangle'] = 'Знак узвика у троуглу';
$string['icontitle-feed'] = 'Извор вести';
$string['icontitle-file-text-o'] = 'Текстуална датотека';
$string['icontitle-film'] = 'Филм';
$string['icontitle-flag-checkered'] = 'Заставица (карирана)';
$string['icontitle-flag-o'] = 'Заставица';
$string['icontitle-flash'] = 'Бљесак';
$string['icontitle-flask'] = 'Боца';
$string['icontitle-flipchart'] = 'Флип чарт (табла са папиром)';
$string['icontitle-frown-o'] = 'Намрштено лице';
$string['icontitle-gavel'] = 'Чекић';
$string['icontitle-gbp'] = 'Британска фунта';
$string['icontitle-globe'] = 'Глобус';
$string['icontitle-handshake-o'] = 'Руковање';
$string['icontitle-headphones'] = 'Слушалице';
$string['icontitle-heartbeat'] = 'Откуцај срца';
$string['icontitle-history'] = 'Историјски часовник';
$string['icontitle-home'] = 'Кућа';
$string['icontitle-id-card-o'] = 'ID картица';
$string['icontitle-info'] = 'Инфо';
$string['icontitle-jigsaw'] = 'Слагалица';
$string['icontitle-key'] = 'Кључ';
$string['icontitle-laptop'] = 'Преносиви рачунар';
$string['icontitle-life-buoy'] = 'Појас за спасавање';
$string['icontitle-lightbulb-o'] = 'Сијалица';
$string['icontitle-line-chart'] = 'Линијски графикон';
$string['icontitle-list'] = 'Неуређена листа';
$string['icontitle-list-ol'] = 'Уређена листа';
$string['icontitle-location-arrow'] = 'Стрелица за локацију';
$string['icontitle-map-marker'] = 'Маркер на мапи';
$string['icontitle-map-o'] = 'Мапа';
$string['icontitle-map-signs'] = 'Путокази';
$string['icontitle-microphone'] = 'Микрофон';
$string['icontitle-mobile-phone'] = 'Мобилни телефон';
$string['icontitle-mortar-board'] = 'Академска капа';
$string['icontitle-music'] = 'Музика';
$string['icontitle-newspaper-o'] = 'Новине';
$string['icontitle-number'] = 'Број {$a}';
$string['icontitle-pencil-square-o'] = 'Оловка у квадрату';
$string['icontitle-person'] = 'Особа';
$string['icontitle-pie-chart'] = 'Кружни графикон';
$string['icontitle-podcast'] = 'Подкаст';
$string['icontitle-puzzle-piece'] = 'Комад слагалице';
$string['icontitle-question-circle'] = 'Знак питања у кругу';
$string['icontitle-random'] = 'Насумичан избор';
$string['icontitle-refresh'] = 'Освежи';
$string['icontitle-road'] = 'Пут';
$string['icontitle-search'] = 'Лупа';
$string['icontitle-sliders'] = 'Клизачи';
$string['icontitle-smile-o'] = 'Осмех';
$string['icontitle-star'] = 'Звездица (осенчена)';
$string['icontitle-star-half-o'] = 'Звездица (полуосенчена)';
$string['icontitle-star-o'] = 'Звездица (неосенчена)';
$string['icontitle-survey'] = 'Истраживање';
$string['icontitle-tags'] = 'Ознаке';
$string['icontitle-tasks'] = 'Задаци';
$string['icontitle-television'] = 'Телевизија';
$string['icontitle-thinking-person'] = 'Особа са сијалицом';
$string['icontitle-thumbs-o-down'] = 'Знак неодобравања (палац на доле)';
$string['icontitle-thumbs-o-up'] = 'Знак одобравања (палац на горе)';
$string['icontitle-trophy'] = 'Трофеј';
$string['icontitle-umbrella'] = 'Кишобран';
$string['icontitle-university'] = 'Универзитет';
$string['icontitle-user-o'] = 'Особа (неосенчено)';
$string['icontitle-users'] = 'Људи';
$string['icontitle-volume-up'] = 'Звучник';
$string['icontitle-wrench'] = 'Виљушкасти кључ';
$string['imagecannotbeused'] = 'Слика се не може користити';
$string['imagedeletedfrom'] = 'Слика је oбрисана са "{$a}"';
$string['imagesavedfor'] = 'Слика је сачувана за {$a}';
$string['imagesize'] = 'Величина слике';
$string['invalidsectionid'] = 'Неисправна  ID ознака секције "{$a}"';
$string['jsactivate'] = 'Анимирана навигација';
$string['jsdeactivated'] = 'Деактивирали сте анимирану навигацију на свом налогу';
$string['jsreactivated'] = 'Активирали сте анимирану навигацију на свом налогу.';
$string['legacytiledata'] = 'Број података старих, наслеђених плочица';
$string['links'] = 'Линкови';
$string['loading'] = 'Учитавање';
$string['maxcoursesectionsallowed'] = 'Максималан број секција курса дозвољен у овом окружењу је {$a}.';
$string['migratecoursedata'] = 'Мигрирајте податке курса';
$string['migratedcourseid'] = 'ID ознака мигираног курса {$a}';
$string['migratenow'] = 'Мигрирајте сада';
$string['modalmodules'] = 'Модални модули';
$string['modalmodules_desc'] = 'Покрените ове модуле курса у модалном прозору (остали модули могу бити додати у каснијим издањима)';
$string['modalresources'] = 'Модални ресурси';
$string['modalresources_desc'] = 'Покрените ове ресурсе у модалном прозору. Напомена: ако је овде дозвољено, ресурс URL адреса ће се отварати само у модалном прозору ако је на нивоу активности опција за изглед подешена на  {$a->displayembed} (нпр. YouTube или Vimeo видео). Чак и тада, власник веб сајта може да блокира ово подешавање, тј. да спречи да се видео клипови приказују као уграђени - погледајте {$a->link}';
$string['modalwindows'] = 'Модални прозори';
$string['newsectionname'] = 'Нови назив за секцију {$a}';
$string['newtiledata'] = 'Број података нових плочица';
$string['nexttopic'] = 'Следећа тема';
$string['noconnectionerror'] = 'Није могуће учитати садржај. Проверите своју интернет везу';
$string['nojswarning'] = 'Ваш веб читач изгледа не подржава JavaScript или је исти онемогућен. Унапређени интерфејс биће доступан ако омогућите JavaScript';
$string['none'] = 'Ниједан';
$string['noproblemsfound'] = 'Нису пронађени проблеми';
$string['notcomplete'] = 'Није завршено';
$string['notrecommended'] = 'Не препоручује се';
$string['novaliddefaultcolour'] = 'Није подешена исправна боја за подразумевану боју плочице';
$string['numberofsections'] = 'Број секција унутар курса';
$string['numbers'] = 'Бројеви';
$string['numbers_desc'] = 'Изаберите иконицу броја за ову плочицу';
$string['off'] = 'Искључи';
$string['ok'] = 'OK';
$string['on'] = 'Укључи';
$string['onlywhenediting'] = 'Само приликом уређивања';
$string['other'] = 'Остала подешавања';
$string['outcomes'] = 'исходи';
$string['outcomesunavailable'] = 'Недоступни исходи';
$string['overall'] = 'Свеукупно';
$string['overallprogress'] = 'Завршетак активности - свеукупни напредак';
$string['overallprogressshort'] = 'Свеукупни напредак';
$string['photoguidance_desc'] = '<p>Поставите фотографију у формату <strong>положене слике</strong>.  Ширина треба да буде око 1,35 пута већа од висине. На пример, димензије фотографије 270 пиксела ширине x 200 пиксела висине ће сасвим одговарати.  Не морате бити скроз прецизни.</p>
<p>Фотографије у формату усправне слике неће одговарати облику плочице. Велике слике или датотеке биће, након постављања, смањене и компримоване ако је то потребно.</p>';
$string['photolibrary'] = 'Библиотека фотографија';
$string['photolibrary_desc'] = 'Ово су фотографије које сте недавно поставили или користили. Како бисте неку од њих искористили као позадину за ову плочицу, кликните на жељену фотографију. Да поставите нову фотографију, употребите  горњу картицу за постављање.';
$string['phototilesaltstyle'] = 'Алтернативни стил фото плочица';
$string['phototilesaltstyle_desc'] = 'Ако није изабрано (што је подразумевана вредност), наслов ће бити приказан на врху фото плочице. Алтернативни стил приказује наслов на дну плочице';
$string['phototilesettings'] = 'Фото плочице';
$string['phototiletitletransarency'] = 'Транспарентност наслова фото плочице';
$string['phototiletitletransarency_desc'] = 'Наслов на фото плочици може имати благо транспарентну позадину или једнобојну позадину (траснпарентност = 0%)';
$string['phototitletitlelineheight'] = 'Висина насловног реда';
$string['phototitletitlepadding'] = 'Вертикални размак између насловног реда и ивице';
$string['picknewicon'] = 'Изабери нову иконицу';
$string['picknewiconphoto'] = 'Изабери нову иконицу или слику позадине';
$string['plugin_description'] = 'Визуелно богат формат, где су секције и активности представљени плочицама, са фотографијама, иконицама и бојама које се могу прилагодити по потреби.';
$string['pluginname'] = 'Плочице';
$string['previoustopic'] = 'Претходна тема';
$string['privacy:metadata:preference:format_tiles_high_contrast_mode'] = 'Да ли полазник користи режим високог контраста.';
$string['privacy:metadata:preference:format_tiles_stopjsnav'] = 'Да ли је корисник онемогућио анимирану JavaScript навигацију.';
$string['privacypolicy'] = 'Правилник о приватности';
$string['problemcourses'] = 'Проблематични курсеви';
$string['problemcoursesintro'] = 'Следећи курсеви имају бројеве секција већи од очекиваног. Употребите дугмад у наставку како бисте решили проблеме.';
$string['progress'] = 'Напредак';
$string['progressincludesubsections'] = 'Индикатор напретка - укључити податке из подсекција?';
$string['progressincludesubsections_desc'] = 'Да ли индикатор напретка у оквиру плочице треба да садржи податке о напретку за активности унутар њених подсекција?';
$string['progresstitle'] = '{$a->numComplete} / {$a->numOutOf} проценат завршених ставки ({$a->percent}%)';
$string['reactivate'] = 'Активирајте поново';
$string['reopenlastsection'] = 'Поново отвори плочицу коју сте последњу посетили';
$string['reopenlastsection_desc'] = 'Када је означено, ако корисник поново приступи курсу, секција (тј. плочица) коју је последњу отворио приликом претходног приступа курс, биће му поново приказана по доласку';
$string['resetallcoursecolours'] = 'Ресетујте све боје курса';
$string['resetalltiles'] = 'Ресетујте фотографије и иконице плочица';
$string['resetalltilessure'] = 'Да ли сте сигурни да желите да ресетујете плочице за овај курс? Ово ће обрисати све фотографије плочица и ресетовати све иконице на подразумеване вредности? Садржај неће бити обрисан. Ово је деструктивна акција и не може се поништити. Уколико нисте сигурни прво направите резервну копију курса.';
$string['resetcolours'] = 'Ресетовање боја';
$string['resetcolours_desc'] = 'Притисните ово дугме како бисте ресетовали боју плочице за све курсеве који немају неку од доле подешених боја. Курсеви ће бити промењени у подразумевану боју плочице доле подешену. Ово можете да користите након што промените палету боја испод, али уверите се да сте <strong>сачували све промене</strong> боја пре него што притиснете ово дугме. Будите опрезни јер ово може променити боју многих курсева!';
$string['resetincomplete'] = 'Ресетовање није довршено';
$string['restorefailed'] = 'Рестаурирање није успело';
$string['restoreincorrectsections'] = 'Грешка: није могуће завршити јер изворни курс садржи нетачан број нумерисаних секција (нпр. број секција ({$a->sectionnum}) је већи од макасимално дозвеољених ({$a->maxallowed}) како је дефинисано у администраторском подешавању \'moodlecourse | maxsections\'). Покушајте да изузмете или обришете секције са великим бројевима.';
$string['restoretoomanysections'] = 'Грешка: није могуће креирати резервну копију или рестаурирати јер је укључено превише секција на курсу (max {$a}). Покушајте да искључите или обришете неке секције.';
$string['revealcontents'] = 'Откријте садржај плочица';
$string['section0name'] = 'Општа секција';
$string['sectionerrorstring'] = 'Ваша сесија је можда истекла. Покушајте да освежите ову страницу.';
$string['sectionerrortitle'] = 'Грешка при учитавању садржаја';
$string['sectionname'] = 'Плочица';
$string['sectionnumber'] = 'Број секције / плочице';
$string['seczerocollapsible'] = 'Уводна (нулта) секција може бити скупљена';
$string['seczerocollapsible_desc'] = 'Дозволи кориснику да скупи уводну секавију на курсу';
$string['selected'] = 'Изабрано';
$string['setavailabletilecolours'] = 'Дозвољене боје плочица (на читавом сајту)';
$string['setbackgroundphoto'] = 'Подесите фотографију / иконицу';
$string['settings'] = 'Подешавања формата плочица';
$string['show'] = 'Прикажи';
$string['showalltiles'] = 'Прикажи све плочице';
$string['showfromothers'] = 'Прикажи';
$string['showoverallprogress'] = 'Прикажи индикатор укупног напретка';
$string['showoverallprogress_desc'] = 'Прикажи индикатор "Свеукупни напредак %“ у горњем десном углу курса (приказана вредност представља збир % завршетка сваке плочице, на основу завршетка активности, а не завршетка курса)';
$string['showprogresssphototiles_desc'] = 'Ако је изабрана ова опција, напредак полазника (нпр. Напредак 2/5) биће приказан на фото плочици';
$string['showseczerocoursewide'] = 'Прикажи уводну секцију на врху, изнад свих секција';
$string['showseczerocoursewide_desc'] = 'Ако је означено, уводна секција (на самом врху почетне странице курса) биће приказана када се на курс уђе, али, такође и на врху, изнад <b>сваке странице секције курса</b> (тј. на врху изнад садржаја сваке плочице).  Ако није означено (што се препоручује), уводна секција биће приказана само на почетној страници курса';
$string['showseparatewin'] = 'Прикажи у засебном прозору';
$string['sitename'] = 'Назив сајта';
$string['snapwarning'] = 'Можда ће бити могуће да уредити свој курс у формату плочица користећи другу графичку тему, а затим се вратити на Snap тему када завршите са уређивањем.';
$string['snapwarning_help'] = 'Theme_settings#Allow_user_themes';
$string['style'] = 'Стил';
$string['subtileiconcolourbackground'] = 'Иконице подплочица - користите круг са хомогено обојеном позадином';
$string['subtileiconcolourbackground_desc'] = 'Ако је ово поље означено, иконице подплочица ће бити приказане као беле иконице у кругу са позадином која је хомогено обојена. У супротном, саме иконице ће (1) бити обојене, и (2) у кругу који је обојен али не хомогеном, уједначеном бојом.';
$string['subtileszeczerotoggled'] = 'Прекидач промене приказа уводне секције - формат списка активности/формат подплочица';
$string['suremigratelegacyoptions'] = 'Да ли сте сигурни да желите да мигрирате фотографије или иконице плочица ({$a}) за овај курс?';
$string['sureresetcolours'] = 'Да ли сте сигурни да желите да ресетујете боје плочица на курсевима на подразумеване вредности? Ово ће имати утицаја на {$a} курс/а/ева';
$string['tilearialabel'] = '{$a}, отвара детаље у искачућем прозору, линк';
$string['tilecolourgeneral'] = 'Палета боја - боја по избору';
$string['tilecolourgeneral_descr'] = 'Ова подешавања омогућавају администратору да подеси које боје ће бити доступне предавачим за коришћење на курсевима. Ако желите да онемогућите неку од боја подесите њен хексадецимални код на црну боју тј. #000.  Ако промените боје овде, неће бити промена у постојећим курсевима, све док следећи пут предавач не покуша да промени боју плочица. У том тренутку, предавачу ће бити доступне само боје које сте овде подесили.';
$string['tilecolourschanged'] = 'Боје плочица су ресетоване. Све плочице сада имају боје у складу са бојама које су подешене у наставку ове странице.';
$string['tileicon'] = 'Иконица / фотографија за приказ само на овој плочици';
$string['tileicon_help'] = 'Овде изабрана иконица ће заменити, само за ову плочицу, било коју иконицу плочице која је подешена на нивоу курса.';
$string['tileicons'] = 'Иконице плочица';
$string['tileoutcome'] = 'Исход за ову плочицу';
$string['tileoutcome_help'] = 'Ако изаберете исход за ову плочицу, тада ћете у подешавањима курса моћи да прикажете скуп <em>дугмади за филтрирање</em>, по једно дугме за сваки исход, која када се притисну филтрирају приказане плочице зависно од исхода који су тим плочицама придружени';
$string['tileselecttip'] = 'На курсу, са укљученим режимом  уређивања, једноставно кликните на иконицу или фотографију коју желите да промените. Појавиће се прозор у којем ћете моћи да изаберете иконицу, односно фотографију.';
$string['tilesformatregistration'] = 'Регистрација додатка \'Формат плочица\'';
$string['tilesreset'] = 'Плочице и иконице су ресетоване за овај курс';
$string['tilestyle'] = 'Стил плочица';
$string['tilestyle_desc'] = 'Стил 1 = фото плочице ће приказати наслов на врху плочице, стил 2 = наслов на дну';
$string['togglecompletion'] = 'Кликните да бисте променили статус завршетка';
$string['togglecompletioncomplete'] = 'Кликните да бисте променили статус завршетка (завршено)';
$string['togglecompletionincomplete'] = 'Кликните да бисте променили статус завршетка (незавршено)';
$string['tootall'] = 'превисоко за плочицу';
$string['toowide'] = 'прешироко за плочицу';
$string['transparenttitleadjustments'] = 'Подешавања транспарентности наслова';
$string['transparenttitleadjustments_desc'] = 'На фото плочицама са траснпарентном позадином наслова, у зависности од графичке теме коју користите, можда ћете желети да их прилагодите како бисте осигурали да се транспарентни редови наслова не преклапају када се преламају.
Имајте на уму да се ови параметри мало разликују између различтих веб читача. Предложене вредности за Chrome веб читач: Boost и теме базиране на теми Clean: 30.5 и 4 | Adaptable: 32 и 4 | Moove: 32 и 2 | Remui: 32 и 2.5';
$string['unmigratedcoursesintro'] = 'Чини се да следећи курсеви {$a} нису мигрирали све иконице плочица и фотографије након преласка на нову верзију система. Кликните на дугме да обрадите курс сада. Ако сачекате, позадински "cron" процес би требало да обради све ово, али ако желите да процесуирате дати курс сада, кликните на дугме';
$string['uploadnewphoto'] = 'Поставите нову фотографију';
$string['uploadnewphoto_help'] = 'Поставите слику која ће се користити на овој плочици';
$string['usecourseindex'] = 'Користите индекс курса';
$string['usecourseindex_desc'] = 'Када је курс у формат плочица, да ли треба приказати индекс курса са леве стране?';
$string['usejavascriptnav'] = 'Користите анимирану навигацију на главној страници са плочицама';
$string['usejavascriptnav_desc'] = 'Када је означено, ако корисник кликне на плочицу на почетној страници курса, а JavaScript је активиран, JS ће се користити за прелазак на садржај плочице. Ако није означено, JS неће бити коришћен и уместо њега ће се користити наслеђена навигација. (учитавање PHP странице). Остала JS подешавања у наставку биће игнорисана.';
$string['usejseditingexpandcollapse'] = 'Режим уређивања - користите JavaScript како бисте проширили/скупили плочице';
$string['usejseditingexpandcollapse_desc'] = 'Ако је изабрана ова опција, у режиму уређивања предавач може да прошири и скупи плочице са анимираним прелазима. Садржај плочице ће се учитавати приликом њеног ширења, без поновног учитавања странице.';
$string['usejsnavforsinglesection'] = 'Користите JS навигацију за приказ странице појединачне секције';
$string['usejsnavforsinglesection_desc'] = 'Када је означено, сваки позив странице појединачне секције (&section=xx) биће обрађен помоћу JavaScripta, покретањем почетне странице курса, анимиране да се отвори у траженој секцији преко JS-а, уместо да се позива стари PHP стил приказа странице појединачне секције';
$string['usesubtilesseczero'] = 'Користи подниво са плочицама у секцији на врху';
$string['usesubtilesseczero_help'] = 'Ако је изабрана ова опција, подплочице ће се користити у уводној секцији (плочици) курса, исто као и унутар свих плочица. Опција је доступна само ако користите подплочице на читавом курсу. Ово је због тога што подплочице заузимају много простора на самом врху курса. Можда би било боље да не изаберете ову опцију, тако да све ставке у уводној секцију буду приказане у стандардном формату списка активности/ресурса.';
$string['version'] = 'Верзија {$a}';
$string['width'] = 'ширина';
