<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'install', language 'sl', version '5.1'.
 *
 * @package     install
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['admindirerror'] = 'Določen skrbniški imenik ni pravilen';
$string['admindirname'] = 'Skrbniški imenik';
$string['admindirsetting'] = 'Le redka spletna mesta uporabljajo /admin kot poseben URL za dostop
 do nadzorne plošče ali česa drugega.  Žal je to v sporu s
 standardno lokacijo skrbniških strani Moodle .  To lahko popravite s
    preimenovanjem skrbniškega imenika v vaši namestitvi in vstavljanjem tega
    novega imena sem.  Na primer: <br /> <br /><b>moodleadmin</b><br /> <br />
    To bo popravilo skrbniške povezave za Moodle.';
$string['admindirsettinghead'] = 'Nastavitev skrbniškega imenika ...';
$string['admindirsettingsub'] = 'Le redka spletna mesta uporabljajo /admin kot poseben URL za dostop
    do nadzorne plošče ali česa drugega.  Žal je to v sporu s
    privzeto lokacijo skrbniških strani Moodle .  To lahko popravite s
    preimenovanjem skrbniškega imenika v vaši namestitvi in vstavljanjem tega
    novega imena sem.  Na primer: <br /> <br /><b>moodleadmin</b><br /> <br />
    To bo popravilo skrbniške povezave za Moodle.';
$string['availablelangs'] = 'Jezikovni paketi na voljo';
$string['caution'] = 'Pozor';
$string['chooselanguage'] = 'Izberite jezik';
$string['chooselanguagehead'] = 'Izberite jezik';
$string['chooselanguagesub'] = 'Izberite jezik za namestitev. Ta jezik bo uporabljen tudi kot privzeti jezik za spletno mesto, a ga je mogoče pozneje spremeniti.';
$string['cliadminemail'] = 'Nov skrbniški e-poštni naslov';
$string['cliadminpassword'] = 'Novo skrbniško geslo';
$string['cliadminusername'] = 'Uporabniško ime skrbniškega računa';
$string['clialreadyconfigured'] = 'Konfiguracijska datoteka config.php že obstaja. Uporabite admin/cli/install_database.php, če želite namestiti Moodle na to spletno mesto.';
$string['clialreadyinstalled'] = 'Datoteka config.php že obstaja, prosimo uporabite admin/cli/install_database.php, če želite posodobiti to spletno mesto.';
$string['cliinstallfinished'] = 'Namestitev uspešno zaključena.';
$string['cliinstallheader'] = 'Moodle {$a} namestitveni program z ukazno vrstico';
$string['climustagreelicense'] = 'V neinteraktivnem načinu se morate strinjati z licenco tako, da izberete možnost --agree-license';
$string['cliskipdatabase'] = 'Preskakujem namestitev podatkovne baze';
$string['clitablesexist'] = 'Tabele podatkovne baze so že prisotne, namestitev CLI se ne more nadaljevati.';
$string['compatibilitysettings'] = 'Preverjanje vaših PHP nastavitev ...';
$string['compatibilitysettingshead'] = 'Preverjanje vaših PHP nastavitev ...';
$string['compatibilitysettingssub'] = 'Da bi Moodle pravilno deloval, mora vaš strežnik opraviti vse navedene preizkuse';
$string['configfilenotwritten'] = 'Skripta nameščanja ni mogla samodejno ustvariti datoteke config.php, ki bi vsebovala vaše izbrane nastavitve. Verjetno Moodle imenik ni zapisljiv. Ročno lahko prekopirate naslednjo kodo v datoteko z imenom config.php v korenskem imeniku Moodle.';
$string['configfilewritten'] = 'datoteka config.php je uspešno ustvarjena';
$string['configurationcomplete'] = 'Konfiguracija je zaključena';
$string['configurationcompletehead'] = 'Konfiguracija je zaključena';
$string['configurationcompletesub'] = 'Moodle je poskušal shraniti vašo konfiguracijo v datoteko v korenu vaše namestitve Moodle.';
$string['database'] = 'Podatkovna baza';
$string['databasehead'] = 'Nastavitve podatkovne baze';
$string['databasehost'] = 'Gostitelj podatkovne baze';
$string['databasename'] = 'Ime podatkovne baze';
$string['databasepass'] = 'Geslo podatkovne baze';
$string['databaseport'] = 'Vrata podatkovne baze';
$string['databasesocket'] = 'Unix reža';
$string['databasetypehead'] = 'Izberite gonilnik podatkovne baze';
$string['databasetypesub'] = 'Moodle podpira več tipov strežnikov podatkovnih baz. Kontaktirajte skrbnika strežnika, če želite izvedeti, katere vrste uporabiti.';
$string['databaseuser'] = 'Uporabnik podatkovne baze';
$string['dataroot'] = 'Podatkovni imenik';
$string['datarooterror'] = 'Podatkovnega imenika, ki ste ga navedli, ni mogoče najti ali ustvariti.  Bodisi popravite pot ali ustvarite mapo ročno.';
$string['datarootpermission'] = 'Dovoljenje za podatkovne imenike';
$string['datarootpublicerror'] = 'Podatkovni imenik\', ki ste ga navedli, je dostopen s spleta. Uporabite drug imenik.';
$string['dbconnectionerror'] = 'S podatkovno bazo, ki ste jo navedli, ni moč vzpostaviti povezave. Preverite vaše nastavitve podatkovne zbirke.';
$string['dbcreationerror'] = 'Napaka ustvarjanja podatkovne baze. S podanimi nastavitvami ni možno ustvariti podatkovne zbirke z navedenim imenom';
$string['dbhost'] = 'Gostiteljski strežnik';
$string['dbpass'] = 'Geslo';
$string['dbport'] = 'Vrata';
$string['dbprefix'] = 'Predpona tabel';
$string['dbtype'] = 'Tip';
$string['directorysettings'] = '<p>Potrdite lokacije te namestitve Moodle.</p>

<p><b>Spletni naslov:</b>
Navedite polni spletni naslov za dostop do Moodle.
Če je vaše spletišče dostopno prek večih URL naslovov izberite
najbolj pogostega, ki ga bodo uporabljali udeleženci.  Ne vključite
zaključne poševnice.</p>

<p><b>Imenik Moodle:</b>
Navedite polno pot imenika do te namestitve
Pazite, da bodo pravilne velike in male črke.</p>

<p><b>Podatkovni imenik:</b>
Potrebujete prostor, kamor lahko Moodle shranjuje naložene datoteke.  Ta
imenik mora biti berljiv IN ZAPISLJIV za uporabniško ime spletnega strežnika
(običajno \'nobody\' ali \'apache\'), a ne sme biti dostopen
neposredno prek spleta. Če še ne obstaja, ga bo ustvaril namestitveni program.</p>';
$string['directorysettingshead'] = 'Potrdite lokacije te namestitve Moodle';
$string['directorysettingssub'] = '<b>Spletni naslov:</b>
Navedite polni spletni naslov za dostop do Moodle.
Če je vaše spletišče dostopno prek večih URL naslovov izberite
najbolj pogostega, ki ga bodo uporabljali udeleženci.  Ne vključite
zaključne poševnice.
<br />
<br />
<b>Imenik Moodle:</b>
Navedite polno pot imenika do te namestitve
Pazite, da bodo pravilne velike in male črke.
<br />
<br />
<b>Podatkovni imenik:</b>
Potrebujete prostor kamor lahko Moodle shranjuje naložene datoteke.  Ta
imenik mora biti berljiv IN ZAPISLJIV za uporabniško ime spletnega strežnika
(običajno \'nobody\' ali \'apache\'), a ne sme biti dostopen
neposredno prek spleta. Če še ne obstaja, ga bo ustvaril namestitveni program.';
$string['dirroot'] = 'Moodle imenik';
$string['dirrooterror'] = 'Nastavitev »Moodle imenik« je, kot kaže, napačna – tam ni mogoče najti namestitve Moodla. Spodnja vrednost je bila ponastavljena.';
$string['download'] = 'Prenos';
$string['downloadlanguagebutton'] = 'Prenesite jezikovni paket &quot;{$a}&quot;';
$string['downloadlanguagehead'] = 'Prenos jezikovnega paketa';
$string['downloadlanguagenotneeded'] = 'Nadaljujete lahko postopek namestitve z uporabo privzetega jezikovnega paketa, "{$a}".';
$string['downloadlanguagesub'] = 'Zdaj imate možnost prenosa jezikovnega paketa in nadaljevanja s postopkom namestitve v tem jeziku.<br /><br />Če ne morete prenesti jezikovnega paketa, se bo namestitveni postopek nadaljeval v angleščini. (Ko bo namestitveni postopek zaključen, boste imeli možnost prenosa in namestitve dodatnih jezikovnih paketov.)';
$string['doyouagree'] = 'Se strinjate? (da/ne):';
$string['environmenthead'] = 'Preverjanje vašega okolja ...';
$string['environmentsub'] = 'Preverjamo, ali razne komponente vašega sistema ustrezajo sistemskim zahtevam';
$string['environmentsub2'] = 'Vsaka Moodle različica ima nekatere minimalne PHP zahteve in številne obvezne PHP razširitve.
Pred vsako namestitvijo ali posodobitvijo se izvede popolna preverba okolja. Kontaktirajte skrbnika strežnika, če ne veste, kako namestiti novo verzijo ali omogočiti PHP razširitev.';
$string['errorsinenvironment'] = 'Preverjanje okolja ni uspelo!';
$string['fail'] = 'Neuspeh';
$string['fileuploads'] = 'Nalaganja datotek';
$string['fileuploadserror'] = 'To bi moralo biti vključeno';
$string['fileuploadshelp'] = '<p>Nalaganje datotek je, kot kaže, onemogočeno na vašem strežniku.</p>

<p>Moodle je še vedno možno namestiti, vendar brez te možnosti ne boste mogli
   nalagati datotek predmetov ali novih slik profilov uporabnikov.</p>

<p>Za omogočanje nalaganja datotek boste (ali vaš skrbnik sistema) morali
   urediti glavno datoteko php.ini na vašem sistemu in spremeniti nastavitev za
   <b>file_uploads</b> na \'1\'.</p>';
$string['inputdatadirectory'] = 'Podatkovni imenik:';
$string['inputwebadress'] = 'Spletni naslov:';
$string['inputwebdirectory'] = 'Moodle imenik:';
$string['installation'] = 'Namestitev';
$string['invaliddbprefix'] = 'Neveljavna predpona. Predpona lahko vsebuje le male črke in podčrtaj.';
$string['langdownloaderror'] = 'Žal jezika »{$a}« ni mogoče namestiti. Postopek namestitve se bo nadaljeval v angleščini.';
$string['langdownloadok'] = 'Jezik "{$a}" je uspešno nameščen. Postopek namestitve se bo nadaljeval v tem jeziku.';
$string['memorylimit'] = 'Omejitev pomnilnika';
$string['memorylimiterror'] = 'Omejitev pomnilnika PHP je nastavljena precej nizko ... pozneje lahko pride do težav.';
$string['mysqliextensionisnotpresentinphp'] = 'PHP ni bil ustrezno konfiguriran v razširitvi MySQLi, zato ne more komunicirati s strežnikom MySQL. Preverite datoteko php.ini ali ponovno prevedite PHP.';
$string['nativeauroramysql'] = 'Aurora MySQL (native/auroramysql)';
$string['nativeauroramysqlhelp'] = '<p>V podatkovni bazi se shranjuje večina Moodle nastavitev in podatkov, ki jih morate konfigurirati tukaj.</p>
<p>Ime podatkovne baze, uporabniško ime in geslo so zahtevana polja; predpona tabele je neobvezna.</p>
<p>Ime podatkovne baze lahko vsebuje samo alfanumerične znake, dolar ($) in podčrtaj (_).</p>
<p>Če podatkovna baza trenutno ne obstaja in ima uporabnik, ki ste ga določili, dovoljenje, bo Moodle poskušal ustvariti novo podatkovno bazo s pravilnimi dovoljenji in nastavitvami.</p>
<p>Ta gonilnik ni združljiv s starejšim mehanizmom MyISAM.</p>';
$string['nativemariadb'] = 'MariaDB (native/mariadb)';
$string['nativemariadbhelp'] = '<p>V podatkovni bazi se shranjuje večina Moodle nastavitev in podatkov, ki jih morate konfigurirati tukaj.</p>
<p>Ime podatkovne baze, uporabniško ime in geslo so zahtevana polja; predpona tabele je neobvezna.</p>
<p>Ime podatkovne baze lahko vsebuje samo alfanumerične znake, dolar ($) in podčrtaj (_).</p>
<p>Če podatkovna baza trenutno ne obstaja in ima uporabnik, ki ste ga določili, dovoljenje, bo Moodle poskušal ustvariti novo podatkovno bazo s pravilnimi dovoljenji in nastavitvami.</p>
<p>Ta gonilnik ni združljiv s starejšim mehanizmom MyISAM.</p>';
$string['nativemysqli'] = 'Izboljšan MySQL (native/mysqli)';
$string['nativemysqlihelp'] = '<p>Večina Moodle nastavitev in podatkov je shranjenih v podatkovni bazi, ki jo morate konfigurirati tukaj.</p>
<p>Ime podatkovne baze, uporabniško ime in geslo so zahtevana polja; predpona tabel je neobvezen podatek.</p>
<p>Ime podatkovne baze lahko vsebuje le alfanumerične znake, dolar ($) in podčrtaj (_).</p>
<p>Če podatkovna baza trenutno ne obstaja in ima izbrani uporabnik ustrezne pravice, bo Moodle poskusil ustvariti novo podatkovno bazo s pravilnimi dovoljenji in nastavitvami.</p>';
$string['nativepgsql'] = 'PostgreSQL (native/pgsql)';
$string['nativepgsqlhelp'] = '<p>Večina Moodle nastavitev in podatkov je shranjenih v podatkovni bazi, ki jo morate tukaj konfigurirati.</p>
<p>Ime podatkovne baze, uporabniško ime,  geslo in predpona tabel so zahtevana polja.</p>
<p>Podatkovna baza mora že obstajati in uporabnik mora imeti dostop tako do branja kot pisanja vanjo.</p>';
$string['nativesqlsrv'] = 'SQL*Server Microsoft (native/sqlsrv)';
$string['nativesqlsrvhelp'] = 'Sedaj morate konfigurirati podatkovno bazo, kjer bodo shranjeni Moodle podatki.
Ta podatkovna baza mora biti že ustvarjena z uporabniškim imenom ter geslom za dostop. Predpona tabele je obvezna.';
$string['nativesqlsrvnodriver'] = 'Microsoftovi gonilniki za strežnik SQL za PHP niso ustrezno nameščeni ali konfigurirani.';
$string['pass'] = 'Uspešno';
$string['paths'] = 'Poti';
$string['pathserrcreatedataroot'] = 'Podatkovni imenik ({$a->dataroot}) ne more biti ustvarjen z namestitvenim programom.';
$string['pathshead'] = 'Potrdite poti';
$string['pathsrodataroot'] = 'Korenski imenik ni zapisljiv.';
$string['pathsroparentdataroot'] = 'Nadrejeni imenik ({$a->parent}) ni zapisljiv. Podatkovna mapa ({$a->dataroot}) ne more biti ustvarjena preko namestitvenega programa.';
$string['pathssubadmindir'] = 'Zelo malo spletnih gostiteljev uporablja /admin kot posebni URL preko katerega dostopate do nadzorne plošče. Na žalost je to v sporu s privzeto lokacijo za Moodlove skrbniške strani. To lahko popravite s preimenovanjem skrbniškega imenika v vaši namestitvi in vnesete tukaj to novo ime. Na primer: <em>moodleadmin</em>. To bo popravilo skrbniške povezave v Moodlu.';
$string['pathssubdataroot'] = '<p>Imenik, kamor bo Moodle shranjeval vso vsebino datoteke, ki jo nalagajo uporabniki.</p>
<p>Ta imenik mora biti tako berljiv kot zapisljiv za uporabnika spletnega strežnika (po navadi \'www-data\', \'nobody\' ali ‚apache‘)</p>
<p>Imenik ne sme biti dostopen neposredno preko spleta.</p>
<p>Če imenik trenutno še ne obstaja ga bo namestitveni proces poskušal ustvariti.</p>';
$string['pathssubdirroot'] = '<p>Polna pot do imenika s kodo Moodle.</p>';
$string['pathssubwwwroot'] = '<p>Polni spletni naslov na katerem bo Moodle dostopen. To je naslov, ki ga bodo uporabniki, za dostop do Moodla, vnesli v naslovno vrstico brskalnika.</p>
<p>Dostop do Moodla z uporabo več naslovov ni mogoč. Če je vaše spletno mesto dostopno z javnih naslovov, izberite najlažjega in za ostale nastavite trajne preusmeritve.</p>
<p>Če je vaše spletno mesto dostopno tako s spleta kot z javnega omrežja (včasih imenovano Intranet), tukaj uporabite javni naslov.</p>
<p>Če trenutni naslov ni pravilen, spremenite URL v naslovni vrstici vašega brskalnika in ponovno začnite z namestitvijo.</p>';
$string['pathsunsecuredataroot'] = 'Lokacija korenske podatkovne mape ni varna';
$string['pathswrongadmindir'] = 'Skrbniški imenik ne obstaja';
$string['pgsqlextensionisnotpresentinphp'] = 'Konfiguracija PHP v razširitvi PGSQL je napačna, zato ne more komunicirati s strežnikom PostgreSQL. Preverite datoteko php.ini ali ponovno prevedite PHP.';
$string['phpextension'] = '{$a} PHP razširitev';
$string['phpversion'] = 'Različica PHP';
$string['releasenoteslink'] = 'Za informacije o tej Moodle različici, si oglejte informacije o različici na {$a}';
$string['safemode'] = 'Varni način';
$string['safemodeerror'] = 'Moodle lahko ima težave z vključenim varnim načinom';
$string['safemodehelp'] = '<p>Moodle ima lahko razne težave z vključenim varnim načinom. Ne samo, da
   verjetno ne bo smel ustvarjati novih datotek.</p>

<p>Varni način je običajno vključen pri paranoidnih javnih spletnih gostiteljih in boste morda morali
   poiskati novo družbo za gostovanje vašega Moodle spletnega mesta.</p>

<p>Če želite lahko poskusite nadaljevati z namestitvijo, a pričakujte nekaj težav pozneje.</p>';
$string['sessionautostart'] = 'Samodejni začetek seje';
$string['sessionautostarterror'] = 'To bi moralo biti izključeno';
$string['sessionautostarthelp'] = '<p>Moodle zahteva podporo za seje in ne bo deloval brez tega.</p>

<p>Seje lahko omogočite v datoteki php.ini ... poiščite parameter session.auto_start.</p>';
$string['sqliteextensionisnotpresentinphp'] = 'PHP ni bil pravilno konfiguriran z SQLite razširitvijo. Preverite php.ini datoteko ali ponovno prevedite PHP.';
$string['upgradingqtypeplugin'] = 'Vtičnik za nadgrajevanje vprašanj/tipov';
$string['welcomep10'] = '{$a->installername} ({$a->installerversion})';
$string['welcomep20'] = 'To stran vidite, ker ste uspešno namestili in
    zagnali paket <strong>{$a->packname} {$a->packversion}</strong> na vašem računalniku. Čestitamo!';
$string['welcomep30'] = 'Ta različica <strong>{$a->installername}</strong> vključuje aplikacije
    za ustvarjanje okolja v katerem bo deloval <strong>Moodle</strong> in sicer:';
$string['welcomep40'] = 'Ta paket vključuje tudi <strong>Moodle {$a->moodlerelease} ({$a->moodleversion})</strong>.';
$string['welcomep50'] = 'Uporabo vseh aplikacij v tem paketu določajo njihove ustrezne
    licence. Celoten paket <strong>{$a->installername}</strong> je
    <a href="http://www.opensource.org/docs/definition_plain.html">odprta koda</a> in se razširja
    pod licenco <a href="http://www.gnu.org/copyleft/gpl.html">GPL</a>.';
$string['welcomep60'] = 'Naslednje strani vas bodo popeljale skozi nekaj enostavno sledljivih korakov za
    konfiguracijo in nastavitev <strong>Moodle</strong>  na vašem računalniku. Sprejmete lahko privzete
    nastavitve ali jih, če tako želite, spremenite, da bodo ustrezale vašim potrebam.';
$string['welcomep70'] = 'Kliknite spodnji gumb "Naprej" za nadaljevanje nastavitve <strong>Moodle</strong>.';
$string['wwwroot'] = 'Spletni naslov';
$string['wwwrooterror'] = 'Spletni naslov, kot kaže, ni veljaven - te namestitve Moodle, kot kaže, ni tam. Spodnja vrednost je bila ponastavljena.';
