<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'auth_shibboleth', language 'sl', version '5.1'.
 *
 * @package     auth_shibboleth
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['auth_shib_auth_logo'] = 'Logotip metode preverjanja pristnosti';
$string['auth_shib_auth_logo_description'] = 'Navedite logotip za metodo preverjanja pristnosti Shibboleth, ki je znana vašim uporabnikom. Lahko je to logotip vaše zveze Shibboleth, npr. <tt>SWITCHaai Prijava</tt> ali <tt> InCommon Prijava </ tt> ali podobno.';
$string['auth_shib_auth_method'] = 'Ime metode preverjanja pristnosti';
$string['auth_shib_auth_method_description'] = 'Navedite ime za metodo preverjanja pristnosti Shibboleth, ki je znana vašim uporabnikom. Lahko je ime vaše zveze Shibboleth, npr <tt>SWITCHaai Prijava</tt> ali <tt>InCommon Prijava</tt> ali podobno.';
$string['auth_shib_changepasswordurl'] = 'URL za spreminjanje gesla';
$string['auth_shib_contact_administrator'] = 'V primeru, da niste povezani z danimi organizacijami in potrebujete dostop do predmeta na tem strežniku, kontaktirajte <a href=«mailto: {$a}">Skrbnika Moodla/a>.';
$string['auth_shib_convert_data'] = 'API spreminjanja podatkov';
$string['auth_shib_convert_data_description'] = 'Ta programski vmesnik (API) lahko uporabite za dodatno spreminjanje podatkov, ki jih ponuja Shibboleth. Za dodatna navodila preberite <a href="../auth/shibboleth/README.txt">README</a>.';
$string['auth_shib_convert_data_filepath_warning'] = 'Datoteke, ki se nahaja v trenutnem imeniku spletnega mesta ($CFG->dataroot), ne morete uporabiti kot API za spreminjanje podatkov.';
$string['auth_shib_convert_data_warning'] = 'Datoteka ne obstaja ali ni berljiva za proces spletnega strežnika!';
$string['auth_shib_idp_list'] = 'Ponudniki identitet';
$string['auth_shib_idp_list_description'] = 'Navedite seznam ID identitet ponudnika identitet, med katerimi lahko uporabnik izbira na strani za prijavo. <br /> V vsaki vrstici morata biti skupina ID identitet IdP-ja (glej datoteko metapodatkov Shibboleth) in ime IdP-ja ločena z vejicami, saj se bodo elementi prikazali na spustnem seznamu. <br /> Kot neobvezni tretji parameter lahko dodate lokacijo pobudnika seje Shibboleth, ki se uporablja v primeru, če je vaša Moodle namestitev del nastavitve več zvez.';
$string['auth_shib_instructions'] = 'Uporabite <a href="{$a}">prijavo Shibboleth</a> za pridobitev dostopa prek Shibboleth, če vaša organizacija to podpira.<br />Sicer uporabite običajni prijavni obrazec, prikazan tukaj.';
$string['auth_shib_instructions_help'] = 'Tu morate zagotoviti navodila po meri za svoje uporabnike, da jim razložite Shibboleth. Prikazana bodo na strani prijave v odseku navodil. Navodila morajo vključevati povezavo do "<b>{$a}</b>", ki jo uporabniki kliknejo, ko se želijo prijaviti.';
$string['auth_shib_instructions_key'] = 'Navodila za prijavo';
$string['auth_shib_integrated_wayf'] = 'Moodle WAYF storitev';
$string['auth_shib_integrated_wayf_description'] = 'Če to omogočite, bo Moodle uporabljal svojo storitev WAYF namesto storitve, konfigurirane za Shibboleth. Moodle bo prikazal spustni seznam na tej nadomestni strani za prijavo, kjer uporabnik izbere identiteto svojega ponudnika.';
$string['auth_shib_logout_return_url'] = 'Nadomestni povratni URL za odjavo';
$string['auth_shib_logout_return_url_description'] = 'Navedite URL, kamor bodo po odjavi preusmerjeni Shibboleth uporabniki. <br /> Če pustite prazno, bodo uporabniki preusmerjeni na mesto, kamor moodle preusmerja uporabnike';
$string['auth_shib_logout_url'] = 'URL odjavnega vodnika ponudnika storitev Shibboleth';
$string['auth_shib_logout_url_description'] = 'Navedite URL za odjavnega vodnika ponudnika storitev Shibboleth. To je običajno <tt>/Shibboleth.sso/Logout</tt>';
$string['auth_shib_no_organizations_warning'] = 'Če želite uporabiti vključeno storitev WAYF, morate dodati seznam identitet ponudnikov preverjanja pristnosti (Identity Provider entityID), ločenih z vejico, njihova imena in neobvezno še pobudnika seje (session initiator).';
$string['auth_shib_only'] = 'Samo Shibboleth';
$string['auth_shib_only_description'] = 'Označite to možnost, če naj bo preverjanje pristnosti Shibboleth vsiljeno';
$string['auth_shib_username_description'] = 'Ime spremenljivke okolja spletnega strežnika Shibboleth, ki naj se uporabi kot Moodle uporabniško ime';
$string['auth_shibboleth_errormsg'] = 'Izberite organizacijo, ki ji pripadate!';
$string['auth_shibboleth_login'] = 'Prijava Shibboleth';
$string['auth_shibboleth_login_long'] = 'Prijava v Moodle prek Shibboleth';
$string['auth_shibboleth_manual_login'] = 'Ročna prijava';
$string['auth_shibboleth_select_member'] = 'Sem član...';
$string['auth_shibboleth_select_organization'] = 'Za preverjanja pristnosti preko Shibboletha izberite svojo organizacijo iz spustnega menija:';
$string['auth_shibbolethdescription'] = 'Z uporabo te metode se uporabniki ustvarijo in njihova pristnost se preveri preko Shibboletha. Za podrobnosti o nastavitvi, si preberite <a href="{$a}">Shibboleth README</a>.';
$string['pluginname'] = 'Shibboleth';
$string['privacy:metadata'] = 'Vtičnik za preverjanje pristnosti Shibboleth ne shranjuje nobenih osebnih podatkov.';
$string['shib_invalid_account_error'] = 'Videti je, da ste preverjeni del Shibboletha, toda Moodle nima veljavnega računa ža vaše uporabniško ime. Vaš račun morda ne obstaja, ali pa je bil suspendiran.';
$string['shib_no_attributes_error'] = 'Kot kaže je vaša pristnost potrjena z mehanizmom Shibboleth, vendar Moodle ni prejel nobenih uporabniških atributov. Prosimo preverite, če vaš ponudnik identitete objavlja potrebne lastnosti ({$a}) ponudniku storitev kjer teče Moodle ali obvestite skrbnika tega strežnika.';
$string['shib_not_all_attributes_error'] = 'Moodle potrebuje nekatere atribute Shibboleth, ki jih v vašem primeru ni. Ti atributi so: {$a}<br />Prosimo, kontaktirajte skrbnika tega strežnika ali vašega ponudnika identitete.';
$string['shib_not_set_up_error'] = 'Preverjanje pristnosti Shibboleth kot kaže ni pravilno nastavljeno, saj na strani ni spremenljivk okolja Shibboleth. Preverite v datoteki <a href="README.txt">README</a> za nadaljna navodila, kako nastaviti preverjanje pristnosti Shibboleth ali kontaktirajte skrbnika te namestitve Moodle.';
