<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'tool_generator', language 'sk', version '5.1'.
 *
 * @package     tool_generator
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['bigfile'] = 'Veľký súbor {$a}';
$string['courseexplanation'] = 'Tento nástroj vytvára štandardné kurzy s testami, obsahujúce mnohé sekcie, aktivity a súbory.

Jeho zámerom je poskytnúť štandardizovaný nástroj na kontrolu spoľahlivosti a výkonu rozličných zložiek systému (ako je napr. zálohovanie a obnovenie).

Tento test je dôležitý, pretože v minulosti sa vyskytlo mnoho prípadov, keď kurzy v reálnej praxi (napr. kurzy s 1000 aktivitami) nefungovali.

Takéto veľké kurzy vytvorené pomocou tohto nástroja môžu zaberať veľký objem databázy a priestoru v súborovom systéme (desiatky GB). Aby ste tento priestor znovu uvoľnili, budete potrebovať po použití kurzy odstrániť  (a čakať, kým prebehnú rôzne operácie čistenia).

**Nepoužívajte túto vlastnosť v spustenom systéme**. Použite ju len na vývojárskom serveri.
(Aby ste sa vyhli náhodnému použitiu, je táto vlastnosť deaktivovaná, kým nezvolíte aj úroveň ladenia DEVELOPER.';
$string['coursesize_0'] = 'XS (~10KB; vytvorený za ~ 1 sekundu)';
$string['coursesize_1'] = 'S (~10MB; vytvorený za ~30 sekúnd)';
$string['coursesize_2'] = 'M (~100MB; vytvorený za  ~5 minút)';
$string['coursesize_3'] = 'L (~1GB; vytvorený za  ~1 hodinu)';
$string['coursesize_4'] = 'XL (~10GB; vytvorené za  ~2 hodiny)';
$string['coursesize_5'] = 'XXL (~20GB; vytvorené za  ~4 hodiny)';
$string['coursewithoutusers'] = 'Zvolený kurz nemá žiadnych používateľov';
$string['createcourse'] = 'Vytvoriť kurz';
$string['createtestplan'] = 'Vytvoriť plán testovania';
$string['creating'] = 'Vytváranie kurzu';
$string['done'] = 'dokončené ({$a}s)';
$string['downloadtestplan'] = 'Stiahnuť plán testovania';
$string['downloadusersfile'] = 'Stiahnuť súbor s používateľmi';
$string['error_nocourses'] = 'Na vytvorenie plánu testovania neexistujú žiadne kurzy';
$string['error_noforumdiscussions'] = 'Zvolený kurz neobsahuje diskusné fóra';
$string['error_noforuminstances'] = 'Zvolený kurz neobsahuje inštancie modulov fór';
$string['error_noforumreplies'] = 'Zvolený kurz neobsahuje odpovede z fóra';
$string['error_nonexistingcourse'] = 'Uvedený kurz neexistuje';
$string['error_nopageinstances'] = 'Uvedený kurz neobsahuje inštancie modulov stránok';
$string['error_notdebugging'] = 'Nie je k dispozícii na tomto serveri, pretože ladenie nie je nastavené na možnosť DEVELOPER';
$string['error_nouserspassword'] = 'Aby ste vytvorili plán testovania, potrebujete nastaviť $CFG->tool_generator_users_password v config.php';
$string['fullname'] = 'Testovací kurz: {$a->size}';
$string['maketestcourse'] = 'Vyrobiť testovací kurz';
$string['maketestplan'] = 'Vyrobiť plán testovania JMeter';
$string['notenoughusers'] = 'Zvolený kurz nemá dosť používateľov';
$string['pluginname'] = 'Generátor vývojových údajov';
$string['privacy:metadata'] = 'Modul Generátor vývojových údajov neukladá žiadne osobné údaje.';
$string['progress_checkaccounts'] = 'Kontrolujú sa používateľské účty ({$a})';
$string['progress_coursecompleted'] = 'Kurz dokončený ({$a}s)';
$string['progress_createaccounts'] = 'Vytváranie používateľských účtov ({$a->from} - {$a->to})';
$string['progress_createassignments'] = 'Vytváranie zadaní ({$a})';
$string['progress_createbigfiles'] = 'Vytváranie veľkých súborov ({$a})';
$string['progress_createcourse'] = 'Vytváranie kurzu {$a}';
$string['progress_createforum'] = 'Vytváranie fóra ({$a} príspevkov)';
$string['progress_createpages'] = 'Vytváranie stránok ({$a})';
$string['progress_createsmallfiles'] = 'Vytváranie malých súborov ({$a})';
$string['progress_enrol'] = 'Zapisovanie používateľov do kurzu ({$a})';
$string['progress_sitecompleted'] = 'Portál dokončený ({$a}s)';
$string['shortsize_0'] = 'XS';
$string['shortsize_1'] = 'S';
$string['shortsize_2'] = 'M';
$string['shortsize_3'] = 'L';
$string['shortsize_4'] = 'XL';
$string['shortsize_5'] = 'XXL';
$string['sitesize_0'] = 'XS (~10MB; 3 kurzy, vytvorený za ~30 sekúnd)';
$string['sitesize_1'] = 'S (~50MB; 8 kurzov, vytvorený za ~2 minúty)';
$string['sitesize_2'] = 'M (~200MB; 73 kurzov, vytvorený za ~10 minút)';
$string['sitesize_3'] = 'L (~1\'5GB; 277 kurzov, vytvorený za ~1,5 hodiny)';
$string['sitesize_4'] = 'XL (~10GB; 1065 kurzov, vytvorený za ~5 hodín)';
$string['sitesize_5'] = 'XXL (~20GB; 4177 kurzov, vytvorený za ~10 hodín)';
$string['size'] = 'Veľkosť kurzu';
$string['smallfiles'] = 'Malé súbory';
$string['targetcourse'] = 'Testovať cieľový kurz';
$string['testplanexplanation'] = 'Tento nástroj vytvára súbor plánu testovania JMeter spolu so súborom user credentials.

Tento plán testovania je určený na prácu spolu s {$a}, ktorý uľahčuje spustenie plánu testovania v konkrétnom Moodle prostredí, zbiera informácie o spusteniach a porovnáva výsledky, takže ho budete musieť stiahnuť a použiť jeho skript test_runner.sh,  alebo postupovať podľa inštalácie a návodu na použitie.

Musíte nastaviť heslo pre používateľov kurzu v config.php (napr. $CFG->tool_generator_users_password = \'moodle\';). Pre toto heslo neexistuje žiadna štandardná hodnota, aby sa zabránilo neoprávnenému použitiu nástroja. Budete musieť použiť možnosť aktualizácie hesiel v prípade, že používatelia vašich kurzov majú iné heslá, alebo boli vytvorené pomocou tool_generator, ale bez nastavenia hodnoty $CFG->tool_generator_users_password.

Je to súčasť súboru tool_generator, preto dobre funguje s kurzami generovanými kurzami a generátormi portálu, môže byť tiež použitý s akýmkoľvek kurzom, ktorý obsahuje aspoň:

* dosť zapísaných používateľov (závisí od veľkosti plánu testovania, akú si zvolíte) s heslom obnoveným na výraz \'moodle\'
* Inštanciu modulu stránky
* Inštanciu modulu fóra s minimálne jednou diskusiou a jednou odpoveďou

Mohli by ste chcieť zvážiť kapacitu vašich serverov, keď priebeh veľkých plánov testovania ako objem na nahranie generovaný nástrojom JMeter môže byť mimoriadne veľký. Bola nastavená perióda zrýchlenia podľa počtu vlákien (používateľov), aby sa zredukoval tento druh problémov, ale nahrávanie je stále enormné.

**Nespúšťajte plán testovania v spustenom systéme**. Táto vlastnosť iba vytvára súbory na zásobovanie nástroja JMeter, takže samotná nie je nebezpečná, ale **NIKDY** by ste nemali spúšťať tento plán testovania na produkčných stránkach.';
$string['testplansize_0'] = 'XS ({$a->users} používateľov, {$a->loops} slučiek a {$a->rampup} perióda zrýchlenia)';
$string['testplansize_1'] = 'S ({$a->users} users, {$a->loops} slučiek a {$a->rampup} perióda zrýchlenia)';
$string['testplansize_2'] = 'M ({$a->users} používateľov, {$a->loops} slučiek a {$a->rampup} perióda zrýchlenia)';
$string['testplansize_3'] = 'L ({$a->users} používateľov, {$a->loops} slučiek a {$a->rampup} perióda zrýchlenia)';
$string['testplansize_4'] = 'XL ({$a->users} používateľov, {$a->loops} slučiek a {$a->rampup} perióda zrýchlenia)';
$string['testplansize_5'] = 'XXL ({$a->users} používateľov, {$a->loops} slučiek a {$a->rampup} perióda zrýchlenia)';
$string['updateuserspassword'] = 'Aktualizovať heslá používateľov kurzu';
$string['updateuserspassword_help'] = 'Jmeter potrebuje prihlasovacie meno ako používatelia kurzu. Používateľské heslá môžete nastaviť použitím $CFG->tool_generator_users_password v config.php; toto nastavenie aktualizuje heslo používateľa kurzu podľa $CFG->tool_generator_users_password. Môže byť užitočné v prípade, že používate kurz, ktorý nebol vytvorený v tool_generator alebo ak $CFG->tool_generator_users_password nebolo nastavené, keď ste vytvárali testovacie kurzy.';
