<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'feedback', language 'sk', version '5.1'.
 *
 * @package     feedback
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['add_item'] = 'Pridať otázku';
$string['add_pagebreak'] = 'Pridať oddeľovač stránky';
$string['adjustment'] = 'Úpravy';
$string['after_submit'] = 'Zobraziť po odoslaní dotazníku';
$string['allowfullanonymous'] = 'Umožniť úplnú anonymitu';
$string['analysis'] = 'Analýzy';
$string['anonymous'] = 'Anonymný';
$string['anonymous_edit'] = 'Zaznamenať mená používateľov';
$string['anonymous_entries'] = 'Anonymné záznamy ({$a})';
$string['anonymous_user'] = 'Anonymný používateľ';
$string['answerquestions'] = 'Odpovedzte na otázky';
$string['append_new_items'] = 'Pridať novú položku';
$string['autonumbering'] = 'Automaticky číslovať každú otázku';
$string['autonumbering_help'] = 'Povoliť alebo nepovoliť automatické číslovanie otázok';
$string['average'] = 'Priemer';
$string['bold'] = 'Hrubým písmom';
$string['calendarend'] = '{$a} - zavreté';
$string['calendarstart'] = '{$a} - otvorené';
$string['cannotaccess'] = 'K tejto spätnej väzbe môžete pristupovať len z kurzu';
$string['cannotsavetempl'] = 'Ukladať šablóny nie je povolené';
$string['captcha'] = 'Bezpečnostná skúška Captcha';
$string['captchanotset'] = 'Captcha nebola ešte nastavená';
$string['check'] = 'Viacero možností - viaceré odpovede';
$string['check_values'] = 'Možné odpovede';
$string['checkbox'] = 'Je povolených viacero možností - viaceré odpovede (check box)';
$string['choosefile'] = 'Zvoľte súbor';
$string['chosen_feedback_response'] = 'Zvolená odpoveď';
$string['closebeforeopen'] = 'Zadali ste dátum ukončenia pred dátumom zahájenia';
$string['complete_the_form'] = 'Odpovedzte na otázky';
$string['completed'] = 'Dokončené';
$string['completed_feedbacks'] = 'Odoslané odpovede';
$string['completedon'] = 'Dokončené {$a}';
$string['completiondetail:submit'] = 'Odoslať spätnú väzbu';
$string['completionsubmit'] = 'Zobraziť ako splnené, keď je odoslaná spätná väzba';
$string['configallowfullanonymous'] = 'Ak je nastavené na „áno“, používatelia môžu vykonať spätnú väzbu na domovskej stránke portálu bez toho, aby sa museli prihlasovať.';
$string['confirmdeleteentry'] = 'Ste si istý, že chcete vymazať tento záznam?';
$string['confirmdeleteitem'] = 'Ste si istý, že chcete vymazať tento prvok?';
$string['confirmdeletetemplate'] = 'Ste si istý, že chcete vymazať túto šablónu?';
$string['confirmusetemplate'] = 'Ste si istý, že chcete použiť túto šablónu?';
$string['continue_the_form'] = 'Pokračovať vo zodpovedaní otázok';
$string['count_of_nums'] = 'Počet čísel';
$string['courseid'] = 'ID kurzu';
$string['creating_templates'] = 'Uložiť tieto otázky do novej šablóny';
$string['delete_entry'] = 'Vymazať záznam';
$string['delete_item'] = 'Vymazať otázku';
$string['delete_old_items'] = 'Vymazať staré položky';
$string['delete_pagebreak'] = 'Odstrániť koniec stránky';
$string['delete_template'] = 'Vymazať šablónu';
$string['delete_templates'] = 'Vymazať šablónu';
$string['depending'] = 'Závislé položky';
$string['depending_help'] = 'Je možné ukázať položku v závislosti od hodnoty inej položky.<br /> <strong>Tu je príklad.
</strong><br />
<ul>
<li>Najprv vytvorte položku, od hodnoty ktorej bude závisieť iná položka.</li>
<li>Za ňu vložte oddeľovač stránky.</li>
<li>Potom pridajte položky závislé na hodnote položky vytvorenej predtým. Vyberte položku zo zoznamu označeného ako "Závislé položky" a napíšte požadovanú hodnotu do okienka označeného "Závislá hodnota".</li>
</ul>
<strong>Štruktúra položky by mala vyzerať asi takto.</strong>
<ol>
<li>Položka Ot: Máte auto? Od: áno/nie</li>
<li>Oddeľovač stránky</li>
<li>Položka Ot: Akú farbu má vaše auto?<br /> (táto položka závisí od položky 1 s hodnotou = áno)</li>
<li>Položka Ot: Prečo nemáte auto?<br /> (táto položka závisí od položky 1 s hodnotou = nie)</li>
<li> ... iné položky</li>
</ol>';
$string['dependitem'] = 'Závisieť na položke';
$string['dependvalue'] = 'Závisieť na hodnote';
$string['description'] = 'Opis';
$string['do_not_analyse_empty_submits'] = 'Neanalyzovať prázdne odoslané spätné väzby';
$string['downloadresponseas'] = 'Siahnuť všetky odpovedi ako:';
$string['drop_feedback'] = 'Odstrániť z tohto kurzu';
$string['dropdown'] = 'Viacero možností - jedna povolená odpoveď (dropdown zoznam)';
$string['dropdown_values'] = 'Odpovede';
$string['dropdownlist'] = 'Viacero možností - jedna odpoveď (rozbaľovacia ponuka)';
$string['dropdownrated'] = 'Rozbaľovacia ponuka (s číselným hodnotením)';
$string['edit_item'] = 'Upraviť otázku';
$string['edit_items'] = 'Upraviť otázky';
$string['email_notification'] = 'Zasielať notifikácie emailom';
$string['email_notification_help'] = 'Ak je táto možnosť zvolená, učitelia budú dostávať email notifikácie o odoslaní spätnej väzby.';
$string['emailteachermail'] = '{$a->username} ukončil spätnú väzbu : "{$a->feedback}".

Výstup si môžete pozrieť kliknutím na nasledujúci odkaz:

{$a->url}';
$string['emailteachermailhtml'] = '<p>{$a->username} ukončil spätnú väzbu : <i>\'{$a->feedback}\'</i></p><p> Výstup si môžete pozrieť kliknutím na <a href="{$a->url}">tento</a> odkaz. </p>';
$string['entries_saved'] = 'Vaše odpovede boli uložené. Ďakujeme.';
$string['eventresponsedeleted'] = 'Odpoveď odstránená';
$string['eventresponsesubmitted'] = 'Odpoveď odoslaná';
$string['export_questions'] = 'Exportovať otázky';
$string['export_to_excel'] = 'Exportovať do formátu MS Excel';
$string['feedback:addinstance'] = 'Pridať novú spätnú väzbu';
$string['feedback:complete'] = 'Vyplňovať dotazník';
$string['feedback:createprivatetemplate'] = 'Vytvoriť súkromnú šablónu';
$string['feedback:createpublictemplate'] = 'Vytvoriť verejnú šablónu';
$string['feedback:deletesubmissions'] = 'Vymazať odovzdané dotazníky';
$string['feedback:deletetemplate'] = 'Vymazať šablónu';
$string['feedback:edititems'] = 'Upraviť položku';
$string['feedback:mapcourse'] = 'Prepojiť kurzy na globálne spätné väzby';
$string['feedback:receivemail'] = 'Prijímať notifikácie emailom';
$string['feedback:view'] = 'Zobraziť spätnú väzbu';
$string['feedback:viewanalysepage'] = 'Zobraziť analýzu po odoslaní ';
$string['feedback:viewreports'] = 'Zobraziť správy';
$string['feedback_is_not_for_anonymous'] = 'Spätná väzba nie je dostupná anonymným účastníkom';
$string['feedback_is_not_open'] = 'Spätná väzba nie je otvorená';
$string['feedbackclose'] = 'Povoliť odpovede';
$string['feedbackcompleted'] = '{$a->username} ukončil {$a->feedbackname}';
$string['feedbackopen'] = 'Dostupné od';
$string['feedbackupdated'] = 'Spätná väzba bola aktualizovaná.';
$string['file'] = 'Súbor';
$string['filter_by_course'] = 'Filtrovať podľa kurzu';
$string['handling_error'] = 'Objavila sa chyba počas spracovania  aktivity spätnej väzby';
$string['hide_no_select_option'] = 'Skryť možnosť "Nevybrané"';
$string['horizontal'] = 'Horizontálne';
$string['import_questions'] = 'Importovať otázky';
$string['import_successfully'] = 'Import prebehol úspešne';
$string['importfromthisfile'] = 'Importovať zo súboru';
$string['includeuserinrecipientslist'] = 'Zahrnúť {$a} do zoznamu príjemcov';
$string['indicator:cognitivedepth'] = 'Kognitívna Spätná väzba';
$string['indicator:cognitivedepth_help'] = 'Tento indikátor je založený na študentom získanej kognitívnej hĺbke v aktivite Spätná väzba.';
$string['indicator:cognitivedepthdef'] = 'Kognitívna Spätná väzba';
$string['indicator:cognitivedepthdef_help'] = 'Počas tohto intervalu analýzy dosiahol účastník toto percento kognitívnej angažovanosti ponúkanej aktivitami Spätná väzba (Úrovne = Bez zobrazenia, Zobrazenie, Odovzdanie)';
$string['indicator:cognitivedepthdef_link'] = 'Learning_analytics_indicators#Cognitive_depth';
$string['indicator:socialbreadth'] = 'Sociálna Spätná väzba';
$string['indicator:socialbreadth_help'] = 'Tento indikátor je založený na študentom získanej sociálnej šírke v aktivite Spätná väzba.';
$string['indicator:socialbreadthdef'] = 'Sociálna Spätná väzba';
$string['indicator:socialbreadthdef_help'] = 'Počas tohto intervalu analýzy dosiahol účastník toto percento sociálnej angažovanosti ponúkanej aktivitami Spätná väzba (Úrovne = Bez účasti, Účastník sám, Účastník s ostatnými)';
$string['indicator:socialbreadthdef_link'] = 'Learning_analytics_indicators#Social_breadth';
$string['info'] = 'Informácie';
$string['infotype'] = 'Typ Informácie';
$string['insufficient_responses'] = 'neúplné odpovede';
$string['insufficient_responses_for_this_group'] = 'Pre túto skupinu sú to nedostatočné odpovede';
$string['insufficient_responses_help'] = 'Pre túto skupinu sú to nedostatočné odpovede. Pre zachovanie anonymity, musia byť ukončené aspoň 2 odpovede.';
$string['item_label'] = 'Štítok';
$string['item_name'] = 'Otázka';
$string['label'] = 'Štítok';
$string['labelcontents'] = 'Obsah';
$string['mapcourse'] = 'Prepojiť spätnú väzbu s kurzami';
$string['mapcourse_help'] = 'Štandardné formy spätnej väzby vytvorené na domovskej stránke sú dostupné na celom portáli a tiež vo všetkých kurzoch, ktoré využívajú aktivitu spätnej väzby. Môžete vynútiť zobrazovanie formy spätnej väzby vytvorením sticky bloku. Ďalšou možnosťou je prepojiť formu do špecifických kurzov, a tým obmedziť jej zobrazovanie.';
$string['mapcourseinfo'] = 'Táto spätná väzba je dostupná pre všetky kurzy. Prepojením do vybraných kurzov môžete obmedziť dostupnosť spätnej väzby. Vyhľadajte kurzy a prepojte do nich aktivitu.';
$string['mapcoursenone'] = 'Žiadne kurzy neboli prepojené. Spätná väzba je dostupná pre všetky kurzy.';
$string['mapcourses'] = 'Prepojiť spätnú väzbu do kurzov';
$string['mappedcourses'] = 'Prepojené kurzy';
$string['mappingchanged'] = 'Mapovanie kurzu bolo zmenené';
$string['maximal'] = 'Maximum';
$string['messageprovider:message'] = 'Upozornenie na vyplnený dotazník';
$string['messageprovider:submission'] = 'Notifikácie o spätnej väzbe';
$string['minimal'] = 'Minimum';
$string['mode'] = 'Program';
$string['modulename'] = 'Spätná väzba';
$string['modulename_help'] = 'Aktivita spätnej väzby umožňuje vytvárať rôzne prieskumy. Slúži pre získanie spätnej väzby od účastníkov kurzu. Pri návrhu dotazníku je možné použiť viacero typov položiek vrátane výberu z viacerých možností, áno/nie, alebo voľných odpovedí.

Vyplnené dotazníky môžu byť anonymné, ak je to potrebné. Výsledky môžu byť k dispozícii študentom alebo iba vyučujúcim. Dotazníky na titulnej stránke serveru môžu vypĺňať aj neprihlásení používatelia.

Spätnú väzbu možno využiť napr. na:

* evalváciu kurzu pre zvýšenie kvality obsahu
* prihlasovanie sa účastníkov k rozličným udalostiam
* získanie anonymnej odozvy od náhodných návštevníkov portálu
* zber anonymných hlásení, napr. šikana a pod.';
$string['modulename_link'] = 'mod/feedback/view';
$string['modulenameplural'] = 'Spätné väzby';
$string['move_item'] = 'Presunúť túto otázku';
$string['multichoice'] = 'Viacero odpovedí';
$string['multichoice_values'] = 'Hodnota pre otázku, ktorá má viacero možností ';
$string['multichoiceoption'] = '<span class="weight">({$a->weight}) </span>{$a->name}';
$string['multichoicerated'] = 'Viacero odpovedí (hodnotené)';
$string['multichoicetype'] = 'Typ otázky, ktorá má viacero možností ';
$string['multiplesubmit'] = 'Možnosť viacerých odoslaní';
$string['multiplesubmit_help'] = 'Ak je zvolená možnosť anonymných prieskumov, používatelia môžu odoslať spätnú väzbu bez obmedzení počtu odoslaní.  ';
$string['name'] = 'Názov';
$string['name_required'] = 'Názov je požadovaná položka';
$string['nameandlabelformat'] = '({$a->label}) {$a->name}';
$string['next_page'] = 'Ďalšia stránka';
$string['no_handler'] = 'Neexistuje žiadne riadenie pre';
$string['no_itemlabel'] = 'Žiadny štítok';
$string['no_itemname'] = 'Položka bez názvu';
$string['no_items_available_yet'] = 'Neboli pripravené zatiaľ žiadne otázky';
$string['no_templates_available_yet'] = 'Žiadne šablóny nie sú zatiaľ dostupné';
$string['non_anonymous'] = 'Meno používateľa bude zaznamenané a zobrazí sa spolu s jeho odpoveďami';
$string['non_anonymous_entries'] = 'Neanonymné záznamy ({$a})';
$string['non_respondents_students'] = 'Používatelia, ktorí ešte neodpovedali ({$a})';
$string['not_completed_yet'] = 'Zatiaľ neukončené';
$string['not_selected'] = 'Nebola vybratá';
$string['not_started'] = 'Nebola spustená';
$string['numberoutofrange'] = 'Číslo je mimo rozsah';
$string['numeric'] = 'Číselná odpoveď';
$string['numeric_range_from'] = 'Rozsah od';
$string['numeric_range_to'] = 'Rozsah do';
$string['of'] = 'zo';
$string['oldvaluespreserved'] = 'Všetky staršie otázky a hodnoty k nim priradené, budú uchované';
$string['oldvalueswillbedeleted'] = 'Súčasné otázky a všetky odpovede vaších používateľov budú vymazané';
$string['only_one_captcha_allowed'] = 'V spätnej väzbe je povolený len jeden modul Captcha';
$string['openafterclose'] = 'Zadali ste dátum ukončenia pred dátumom zahájenia';
$string['overview'] = 'Prehľad';
$string['page'] = 'Stránka';
$string['page-mod-feedback-x'] = 'Ľubovoľná stránka modulu spätná väzba';
$string['page_after_submit'] = 'Správa o dokončení';
$string['pagebreak'] = 'Oddeľovač stránky';
$string['pluginadministration'] = 'Správa spätnej väzby';
$string['pluginname'] = 'Spätná väzba';
$string['position'] = 'Umiestnenie';
$string['previous_page'] = 'Predošlá stránka';
$string['privacy:metadata:completed'] = 'Zápis odoslanej spätnej väzby';
$string['privacy:metadata:completed:anonymousresponse'] = 'Či má byť odoslané ako anonymné';
$string['privacy:metadata:completed:timemodified'] = 'Čas úpravy správy.';
$string['privacy:metadata:completed:userid'] = 'ID používateľa, ktorý spätnú väzbu dokončil.';
$string['privacy:metadata:completedtmp'] = 'Prehľad doposiaľ prebiehajúcich plnení spätných väzieb';
$string['privacy:metadata:value'] = 'Zápis odpovedi na otázku.';
$string['privacy:metadata:value:value'] = 'Zvolená odpoveď.';
$string['privacy:metadata:valuetmp'] = 'Zápis odpovedi na otázku v prebiehajúcom vyplňovaní spätnej väzby.';
$string['public'] = 'Verejná';
$string['question'] = 'Otázka';
$string['questionandsubmission'] = 'Nastavenie otázok a príspevkov';
$string['questions'] = 'Otázky';
$string['questionslimited'] = 'Zobraziť iba {$a} prvých otázok, zobraziť jednotlivé odpovede alebo stiahnuť údaje k zobrazeniu všetkých údajov.';
$string['radio'] = 'Viacero možností - jedna odpoveď';
$string['radio_values'] = 'Odpovede';
$string['ready_feedbacks'] = 'Pripravené spätné väzby';
$string['required'] = 'Požadované';
$string['resetting_data'] = 'Vynulovať odpovede spätnej väzby';
$string['resetting_feedbacks'] = 'Vynulovať spätné väzby';
$string['response_nr'] = 'Odpoveď číslo';
$string['responses'] = 'Odpovede';
$string['responsetime'] = 'Čas odpovedí';
$string['save_as_new_item'] = 'Uložiť ako novú otázku';
$string['save_as_new_template'] = 'Uložiť ako novú šablónu';
$string['save_entries'] = 'Odoslať vaše odpovede';
$string['save_item'] = 'Uložiť otázku';
$string['saving_failed'] = 'Ukladanie bolo neúspešné';
$string['search:activity'] = 'Spätná väzba - informácia o aktivite';
$string['search_course'] = 'Prehľadať kurz';
$string['searchcourses'] = 'Vyhľadávať kurzy';
$string['searchcourses_help'] = 'Vyhľadávať kód alebo názov kurzu/kurzov, ktorý chcete prepojiť s touto spätnou väzbou.';
$string['selected_dump'] = 'Vybrané indexy premennej $SESSION, sú uložené tu: ';
$string['send'] = 'Odoslať';
$string['send_message'] = 'Odoslať oznámenie';
$string['show_all'] = 'Zobraziť všetko';
$string['show_analysepage_after_submit'] = 'Po odoslaní zobraziť stránku analýzy';
$string['show_entries'] = 'Zobraziť odpovede';
$string['show_entry'] = 'Zobraziť odpoveď';
$string['show_nonrespondents'] = 'Zobraziť používateľov, ktorí ešte neodpovedali';
$string['site_after_submit'] = 'Stránka, ktorá sa zobrazí po odoslaní spätnej väzby';
$string['sort_by_course'] = 'Triediť podľa kurzu';
$string['started'] = 'Spustená';
$string['startedon'] = 'Spustená  {$a}';
$string['subject'] = 'Predmet';
$string['switch_item_to_not_required'] = 'Nastaviť na: odpoveď je voliteľná';
$string['switch_item_to_required'] = 'Nastaviť na: odpoveď je povinná';
$string['template'] = 'Šablóna';
$string['template_deleted'] = 'Šablóna odstránená';
$string['template_saved'] = 'Šablóna bola uložená';
$string['templates'] = 'Šablóny';
$string['textarea'] = 'Odpoveď s dlhším textom';
$string['textarea_height'] = 'Počet riadkov';
$string['textarea_width'] = 'Šírka';
$string['textfield'] = 'Krátka odpoveď';
$string['textfield_maxlength'] = 'Maximálna dĺžka textu je akceptovaná';
$string['textfield_size'] = 'Šírka textového poľa';
$string['there_are_no_settings_for_recaptcha'] = 'Nie sú dostupné žiadne nastavenia pre Captcha';
$string['this_feedback_is_already_submitted'] = 'Už ste ukončili túto aktivitu.';
$string['typemissing'] = 'Chýbajúca hodnota "typ"';
$string['update_item'] = 'Uložiť zmeny do otázky';
$string['url_for_continue'] = 'Odkaz pre tlačidlo Pokračovať';
$string['url_for_continue_help'] = 'Tlačidlo Pokračovať vám po odoslaní spätnej väzby otvorí okno kurzu. Ak si prajete prejsť po vyplnení dotazníku na inú stránku, vložte sem príslušnú adresu stránky.';
$string['use_one_line_for_each_value'] = 'Každú odpoveď umiestnite na jeden riadok!';
$string['use_this_template'] = 'Použiť túto šablónu';
$string['using_templates'] = 'Použiť šablónu';
$string['vertical'] = 'Vertikálne';
$string['whatfor'] = 'Čo chcete robiť?';
