<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'tool_muprog', language 'pt_br', version '5.1'.
 *
 * @package     tool_muprog
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['addset'] = 'Adicionar novo conjunto';
$string['allocation'] = 'Alocação';
$string['allocation_archive'] = 'Alocação de arquivo';
$string['allocation_reset'] = 'Reiniciar o progresso do programa';
$string['allocation_reset_updateallocation'] = 'Atualizar alocação';
$string['allocation_restore'] = 'Restaurar alocação';
$string['allocation_update'] = 'Atualizar alocação';
$string['allocationdate'] = 'Data de alocação';
$string['allocationend'] = 'Fim da alocação';
$string['allocationend_help'] = 'O significado da data final da alocação depende das fontes de alocação habilitadas. Normalmente, novas alocações não são possíveis após essa data, se especificada.';
$string['allocations'] = 'Alocações';
$string['allocationsources'] = 'Fontes de alocação';
$string['allocationstart'] = 'Início da alocação';
$string['allocationstart_help'] = 'O significado da data de início da alocação depende das fontes de alocação habilitadas. Normalmente, novas alocações só são possíveis após essa data, se especificada.';
$string['allprograms'] = 'Todos os programas';
$string['appendinto'] = 'Acrescentar ao item';
$string['appenditem'] = 'Anexar item';
$string['archived'] = 'Arquivado';
$string['calendarprogramdue'] = '{$a} é devido';
$string['calendarprogramend'] = '{$a} termina';
$string['calendarprogramstart'] = '{$a} começa';
$string['catalogue'] = 'Catálogo de programas';
$string['catalogue_actions'] = 'Ações de catálogo';
$string['catalogue_dofilter'] = 'Procurar';
$string['catalogue_resetfilter'] = 'Limpar';
$string['catalogue_searchtext'] = 'Pesquisar texto';
$string['catalogue_tag'] = 'Filtrar por tag';
$string['certificatetemplatechoose'] = 'Escolha um modelo...';
$string['cohorts'] = 'Visível para coortes';
$string['cohorts_help'] = 'Programas não públicos podem ser tornados visíveis para membros específicos da coorte. O status de visibilidade não afeta programas já alocados.';
$string['columnusedalready'] = 'A coluna já está em uso';
$string['completiondate'] = 'Data de conclusão';
$string['completiondelay'] = 'Atraso na conclusão';
$string['completionoverride'] = 'Substituir conclusão';
$string['creategroups'] = 'Grupos de curso';
$string['creategroups_help'] = 'Se habilitado, um grupo será criado em cada curso adicionado ao programa e todos os usuários alocados serão adicionados como membros do grupo.';
$string['currentcontextonly'] = 'Excluir subcategorias';
$string['customfields'] = 'Campos personalizados do programa';
$string['customfields_allocation'] = 'Campos personalizados de alocação de programa';
$string['customfieldsettings'] = 'Configurações de campos personalizados de programas comuns';
$string['customfieldvisible:allocated'] = 'Usuários alocados aos programas';
$string['customfieldvisible:allocatee'] = 'Alocado';
$string['customfieldvisible:everyone'] = 'Todos que podem ver outros detalhes do programa';
$string['customfieldvisible:viewcapability'] = 'Usuários com capacidade de visualizar programas';
$string['customfieldvisibleto'] = 'O conteúdo do campo é visível para';
$string['deleteallocation'] = 'Excluir alocação de programa';
$string['deletecourse'] = 'Remover curso';
$string['deleteset'] = 'Excluir conjunto';
$string['deletetraining'] = 'Remover treinamento';
$string['duedate'] = 'Data de vencimento';
$string['enrolrole'] = 'Função do curso';
$string['enrolrole_desc'] = 'Selecione a função que será usada pelos programas para inscrição no curso';
$string['errorcontentproblem'] = 'Problema detectado na estrutura do conteúdo do programa, a conclusão do programa não será rastreada corretamente!';
$string['errorcoursemissing'] = 'Falta curso';
$string['errorcoursesmissing'] = 'Cursos faltantes: {$a}';
$string['errordifferenttenant'] = 'O programa de outro locatário não pode ser acessado';
$string['errorinvalidoverridedates'] = 'Substituições de data inválidas';
$string['errornoallocation'] = 'O programa não está alocado';
$string['errornoallocations'] = 'Nenhuma alocação de usuário encontrada';
$string['errornomyprograms'] = 'Você não está alocado em nenhum programa.';
$string['errornoprograms'] = 'Nenhum programa encontrado.';
$string['errornorequests'] = 'Nenhuma solicitação de programa encontrada';
$string['errornotenabled'] = 'O plugin do programa não está habilitado';
$string['event_allocation_archived'] = 'Alocação de usuário arquivada';
$string['event_allocation_completed'] = 'Programa concluído pelo usuário';
$string['event_allocation_created'] = 'Usuário alocado ao programa';
$string['event_allocation_deleted'] = 'Usuário desalocado do programa';
$string['event_allocation_restored'] = 'Alocação de usuário restaurada';
$string['event_allocation_updated'] = 'Alocação de programa de usuário atualizada';
$string['event_catalogue_program_viewed'] = 'Catálogo de programas visualizado';
$string['event_program_archived'] = 'Programa arquivado';
$string['event_program_created'] = 'Programa criado';
$string['event_program_deleted'] = 'Programa deletado';
$string['event_program_restored'] = 'Programa restaurado';
$string['event_program_updated'] = 'Programa atualizado';
$string['event_program_viewed'] = 'Programa visualizado';
$string['evidence'] = 'Outras evidências';
$string['evidence_details'] = 'Detalhes';
$string['evidence_detailsdefault'] = 'Detalhes padrão';
$string['evidencedate'] = 'Data de conclusão da evidência';
$string['evidenceupdate'] = 'Atualizar outras evidências';
$string['evidenceupload'] = 'Evidências de conclusão do upload';
$string['evidenceupload_csvfile'] = 'arquivo CSV';
$string['evidenceupload_errors'] = '{$a} linhas inválidas detectadas';
$string['evidenceupload_skipped'] = '{$a} linhas puladas';
$string['evidenceupload_updated'] = 'Evidência de conclusão atualizada para usuários {$a}';
$string['export'] = 'Programas de exportação';
$string['exportfile_info'] = 'informação';
$string['exportfile_programs'] = 'programas';
$string['exportformat'] = 'Formato de arquivo';
$string['exportformat_csv'] = 'CSV';
$string['exportformat_json'] = 'JSON';
$string['fixeddate'] = 'Em uma data fixa';
$string['importallocationend'] = 'Fim da alocação ({$a})';
$string['importallocationstart'] = 'Início da alocação ({$a})';
$string['importprogramallocation'] = 'Configurações de alocação de importação';
$string['importprogramallocationconfirmation'] = 'Você está importando configurações de alocação do programa __{$a->fullname} / {$a->idnumber} / {$a->category}__. Selecione todas as configurações que deseja importar.';
$string['importprogramcontent'] = 'Importar conteúdo do programa';
$string['importprogramcontentconfirmation'] = 'Você está importando conteúdo do programa __{$a->fullname} / {$a->idnumber} / {$a->category}__.';
$string['importprogramdue'] = 'Programa pendente ({$a})';
$string['importprogramend'] = 'Fim do programa ({$a})';
$string['importprogramstart'] = 'Início do programa ({$a})';
$string['importselectprogram'] = 'Selecione o programa';
$string['invalidallocationdates'] = 'Datas de alocação de programa inválidas';
$string['invalidcompletiondate'] = 'Data de conclusão do programa inválida';
$string['item'] = 'Item';
$string['itemcompletion'] = 'Conclusão do item do programa';
$string['itempoints'] = 'Pontos';
$string['itemrecalculate'] = 'Recalcular a conclusão do item';
$string['management'] = 'Gestão de programas';
$string['management_allocation_actions'] = 'Ações de alocação';
$string['management_index_actions'] = 'Ações de programas';
$string['management_program_allocation_actions'] = 'Ações de configurações de alocação';
$string['management_program_general_actions'] = 'Ações do programa';
$string['management_program_users_actions'] = 'Ações dos usuários';
$string['messageprovider:allocation_notification'] = 'Notificação de alocação de programa';
$string['messageprovider:approval_reject_notification'] = 'Notificação de rejeição de solicitação de programa';
$string['messageprovider:approval_request_notification'] = 'Notificação de solicitação de aprovação do programa';
$string['messageprovider:completion_notification'] = 'Notificação de conclusão do programa';
$string['messageprovider:deallocation_notification'] = 'Notificação de desalocação do programa';
$string['messageprovider:due_notification'] = 'Notificação de atraso do programa';
$string['messageprovider:duesoon_notification'] = 'Notificação em breve da data de vencimento do programa';
$string['messageprovider:endcompleted_notification'] = 'Notificação de término do programa concluído';
$string['messageprovider:endfailed_notification'] = 'Notificação de programa com falha encerrada';
$string['messageprovider:endsoon_notification'] = 'Notificação em breve da data de término do programa';
$string['messageprovider:reset_notification'] = 'Notificação de reinicialização do programa';
$string['messageprovider:start_notification'] = 'Notificação de início do programa';
$string['moveafter'] = 'Mover "{$a->item}" depois de "{$a->target}"';
$string['movebefore'] = 'Mova "{$a->item}" antes de "{$a->target}"';
$string['moveinto'] = 'Mover "{$a->item}" para "{$a->target}"';
$string['moveitem'] = 'Mover item';
$string['moveitemcancel'] = 'Cancelar a mudança';
$string['muprog:addcourse'] = 'Adicionar curso aos programas';
$string['muprog:addtocertifications'] = 'Adicionar programa às certificações';
$string['muprog:admin'] = 'Administração avançada de programas';
$string['muprog:allocate'] = 'Atribuir usuários a programas';
$string['muprog:clone'] = 'Clonar conteúdo e configurações do programa';
$string['muprog:configurecustomfields'] = 'Configurar campos personalizados do programa';
$string['muprog:deallocate'] = 'Desalocar usuários de programas';
$string['muprog:delete'] = 'Excluir programas';
$string['muprog:edit'] = 'Adicionar e atualizar programas';
$string['muprog:export'] = 'Programas de exportação';
$string['muprog:manageallocation'] = 'Gerenciar alocações de usuários';
$string['muprog:manageevidence'] = 'Gerenciar outras evidências de conclusão';
$string['muprog:reset'] = 'Reiniciar o progresso do programa';
$string['muprog:upload'] = 'Carregar programas';
$string['muprog:view'] = 'Ver gerenciamento de programas';
$string['muprog:viewcatalogue'] = 'Catálogo de programas de acesso';
$string['myprograms'] = 'Meus programas';
$string['notification_allocation'] = 'Usuário alocado';
$string['notification_allocation_body'] = 'Olá {$a->user_fullname}, você foi alocado no programa "{$a->program_fullname}", a data de início é {$a->program_startdate}.';
$string['notification_allocation_description'] = 'Notificação enviada aos usuários quando eles são alocados ao programa.';
$string['notification_allocation_subject'] = 'Notificação de alocação de programa';
$string['notification_completion'] = 'Programa concluído';
$string['notification_completion_body'] = 'Olá {$a->user_fullname}, você concluiu o programa "{$a->program_fullname}".';
$string['notification_completion_description'] = 'Notificação enviada aos usuários quando eles concluem o programa.';
$string['notification_completion_subject'] = 'Programa concluído';
$string['notification_deallocation'] = 'Usuário desalocado';
$string['notification_deallocation_body'] = 'Olá {$a->user_fullname}, você foi desalocado do programa "{$a->program_fullname}".';
$string['notification_deallocation_description'] = 'Notificação enviada aos usuários quando eles são desalocados do programa.';
$string['notification_deallocation_subject'] = 'Notificação de desalocação do programa';
$string['notification_due'] = 'Programa atrasado';
$string['notification_due_body'] = 'Olá {$a->user_fullname}, a conclusão do programa "{$a->program_fullname}" era esperada antes de {$a->program_duedate}.';
$string['notification_due_description'] = 'Notificação enviada aos usuários quando a conclusão do programa estiver atrasada.';
$string['notification_due_subject'] = 'A conclusão do programa era esperada';
$string['notification_duesoon'] = 'Data de vencimento do programa em breve';
$string['notification_duesoon_body'] = 'Olá {$a->user_fullname}, a conclusão do programa "{$a->program_fullname}" está prevista para {$a->program_duedate}.';
$string['notification_duesoon_description'] = 'Notificação enviada aos usuários antes da data de conclusão do programa, a menos que o programa já tenha sido concluído.';
$string['notification_duesoon_subject'] = 'A conclusão do programa está prevista para breve';
$string['notification_endcompleted'] = 'Programa concluído encerrado';
$string['notification_endcompleted_body'] = 'Olá {$a->user_fullname}, o programa "{$a->program_fullname}" terminou, você o concluiu antes.';
$string['notification_endcompleted_description'] = 'Notificação enviada aos usuários quando o programa concluído termina.';
$string['notification_endcompleted_subject'] = 'Programa concluído encerrado';
$string['notification_endfailed'] = 'O programa falhou e terminou';
$string['notification_endfailed_body'] = 'Olá {$a->user_fullname}, o programa "{$a->program_fullname}" terminou, você não conseguiu concluí-lo.';
$string['notification_endfailed_description'] = 'Notificação enviada aos usuários quando o programa que eles não conseguiram concluir termina.';
$string['notification_endfailed_subject'] = 'O programa falhou e terminou';
$string['notification_endsoon'] = 'Data de término do programa em breve';
$string['notification_endsoon_body'] = 'Olá {$a->user_fullname}, o programa "{$a->program_fullname}" terminará em {$a->program_enddate}.';
$string['notification_endsoon_description'] = 'Notificação enviada aos usuários antes da data de término do programa, a menos que o programa já tenha sido concluído.';
$string['notification_endsoon_subject'] = 'O programa termina em breve';
$string['notification_reset'] = 'Redefinição do progresso do usuário';
$string['notification_reset_body'] = 'Olá {$a->user_fullname}, seu progresso no programa "{$a->program_fullname}" foi reiniciado.';
$string['notification_reset_description'] = 'Notificação enviada aos usuários quando o progresso do programa é reiniciado.';
$string['notification_reset_subject'] = 'Notificação de reinicialização do programa';
$string['notification_start'] = 'Programa iniciado';
$string['notification_start_body'] = 'Olá {$a->user_fullname}, o programa "{$a->program_fullname}" foi iniciado.';
$string['notification_start_description'] = 'Notificação enviada aos usuários quando o programa começa.';
$string['notification_start_subject'] = 'Programa iniciado';
$string['notificationdates'] = 'Datas de notificação';
$string['notset'] = 'Não definido';
$string['plugindisabled'] = 'O plugin de inscrição no programa está desabilitado, os programas não funcionarão. [Habilitar plugin agora]({$a->url})';
$string['pluginname'] = 'Programas';
$string['pluginname_desc'] = 'Os programas são projetados para permitir a criação de conjuntos de cursos.';
$string['privacy:metadata:field:allocationid'] = 'ID de alocação do programa';
$string['privacy:metadata:field:archived'] = 'O registro está arquivado';
$string['privacy:metadata:field:createdby'] = 'Evidência criada por';
$string['privacy:metadata:field:datajson'] = 'Informações sobre a solicitação';
$string['privacy:metadata:field:evidencejson'] = 'Informações sobre evidências de conclusão';
$string['privacy:metadata:field:explanation'] = 'Explicação';
$string['privacy:metadata:field:issueid'] = 'ID do problema';
$string['privacy:metadata:field:itemid'] = 'ID do item';
$string['privacy:metadata:field:programid'] = 'ID do programa';
$string['privacy:metadata:field:quantity'] = 'Quantidade';
$string['privacy:metadata:field:reason'] = 'Razão';
$string['privacy:metadata:field:rejectedby'] = 'Solicitação rejeitada por';
$string['privacy:metadata:field:sourcedatajson'] = 'Informações sobre a origem da alocação';
$string['privacy:metadata:field:sourceid'] = 'Fonte de alocação';
$string['privacy:metadata:field:timeallocated'] = 'Data de alocação do programa';
$string['privacy:metadata:field:timecompleted'] = 'Data de conclusão';
$string['privacy:metadata:field:timecreated'] = 'Data de criação';
$string['privacy:metadata:field:timedue'] = 'Data de vencimento';
$string['privacy:metadata:field:timeend'] = 'Data de término';
$string['privacy:metadata:field:timerejected'] = 'Data de rejeição';
$string['privacy:metadata:field:timerequested'] = 'Data da solicitação';
$string['privacy:metadata:field:timestart'] = 'Data de início';
$string['privacy:metadata:field:userid'] = 'ID do usuário';
$string['privacy:metadata:table:tool_muprog_allocation'] = 'Informações sobre alocações de programas';
$string['privacy:metadata:table:tool_muprog_cert_issue'] = 'Problemas com certificados de alocação de programas';
$string['privacy:metadata:table:tool_muprog_completion'] = 'Conclusões de alocação de programas';
$string['privacy:metadata:table:tool_muprog_evidence'] = 'Informações sobre outras evidências de conclusão';
$string['privacy:metadata:table:tool_muprog_request'] = 'Informações sobre solicitação de alocação';
$string['program'] = 'Programa';
$string['program_actions'] = 'Ações do programa';
$string['program_allocations_edit'] = 'Atualizar alocações';
$string['program_archive'] = 'Programa de arquivo';
$string['program_archive_info'] = 'Arquivamento do programa: * suspende inscrições em cursos do programa, * exclui eventos do programa do calendário, * impede atualizações do programa, * e, em geral, oculta o programa de usuários comuns. O arquivamento é uma etapa necessária antes que o programa possa ser excluído.';
$string['program_create'] = 'Adicionar programa';
$string['program_delete'] = 'Excluir programa';
$string['program_delete_info'] = 'Durante a exclusão do programa, todos os dados do programa são excluídos e os usuários são cancelados nos cursos do programa.';
$string['program_restore'] = 'Restaurar programa';
$string['program_restore_info'] = 'A restauração do programa reverte as alterações feitas durante o arquivamento. No entanto, é recomendável verificar todas as configurações do programa e os usuários alocados posteriormente.';
$string['program_update'] = 'Programa de atualização';
$string['programallocations'] = 'Alocações de programas';
$string['programautofix'] = 'Programa de reparo de automóveis';
$string['programcompletion'] = 'Data de conclusão do programa';
$string['programcompletionoverride'] = 'Substituir conclusão do programa';
$string['programdue'] = 'Prazo do programa';
$string['programdue_date'] = 'Data de vencimento';
$string['programdue_delay'] = 'Vencimento após o início';
$string['programdue_help'] = 'A data de vencimento do programa indica quando os usuários devem concluir o programa.';
$string['programend'] = 'Fim do programa';
$string['programend_date'] = 'Data de término do programa';
$string['programend_delay'] = 'Fim após o início';
$string['programend_help'] = 'Os usuários não podem entrar nos cursos do programa após o término do mesmo.';
$string['programidnumber'] = 'ID do programa';
$string['programimage'] = 'Imagem do programa';
$string['programname'] = 'Nome do programa';
$string['programs'] = 'Programas';
$string['programstart'] = 'Início do programa';
$string['programstart_allocation'] = 'Comece imediatamente após a alocação';
$string['programstart_date'] = 'Data de início do programa';
$string['programstart_delay'] = 'Início retardado após alocação';
$string['programstart_help'] = 'Os usuários não podem entrar nos cursos do programa antes do seu início.';
$string['programstatus'] = 'Status do programa';
$string['programstatus_any'] = 'Qualquer status do programa';
$string['programstatus_archived'] = 'Arquivado';
$string['programstatus_archivedcompleted'] = 'Arquivado concluído';
$string['programstatus_completed'] = 'Concluído';
$string['programstatus_failed'] = 'Fracassado';
$string['programstatus_future'] = 'Ainda não aberto';
$string['programstatus_open'] = 'Abrir';
$string['programstatus_overdue'] = 'Atrasado';
$string['programurl'] = 'URL do programa';
$string['publicaccess'] = 'Público';
$string['publicaccess_help'] = 'Os programas públicos são visíveis para todos os usuários. O status de visibilidade não afeta os programas já alocados.';
$string['purchaseaccess'] = 'Acesso de compra';
$string['resettype'] = 'Tipo de redefinição';
$string['resettype_deallocate'] = 'Somente desalocação de programa';
$string['resettype_full'] = 'Purga completa do curso';
$string['resettype_none'] = 'Nenhum';
$string['resettype_standard'] = 'Limpeza de curso padrão';
$string['scheduling'] = 'Agendamento';
$string['sequencetype'] = 'Tipo de conclusão';
$string['sequencetype_allinanyorder'] = 'Tudo em qualquer ordem';
$string['sequencetype_allinorder'] = 'Tudo em ordem';
$string['sequencetype_atleast'] = 'Pelo menos {$a->min}';
$string['sequencetype_minpoints'] = 'Mínimo de {$a->minpoints} pontos';
$string['set'] = 'Conjunto de cursos';
$string['settings'] = 'Configurações do programa';
$string['source'] = 'Fonte';
$string['source_approval'] = 'Solicitações com aprovação';
$string['source_approval_allownew'] = 'Permitir aprovações';
$string['source_approval_allownew_desc'] = 'Permitir adicionar novas _solicitações com fontes de aprovação_ aos programas';
$string['source_approval_allowrequest'] = 'Permitir novas solicitações';
$string['source_approval_confirm'] = 'Por favor, confirme que você deseja solicitar alocação ao programa.';
$string['source_approval_daterejected'] = 'Data de rejeição';
$string['source_approval_daterequested'] = 'Data solicitada';
$string['source_approval_makerequest'] = 'Solicitar acesso';
$string['source_approval_notification_approval_reject_body'] = 'Olá {$a->user_fullname}, sua solicitação para acessar o programa "{$a->program_fullname}" foi rejeitada. {$a->reason}';
$string['source_approval_notification_approval_reject_subject'] = 'Notificação de rejeição de solicitação de programa';
$string['source_approval_notification_approval_request_body'] = 'O usuário {$a->user_fullname} solicitou acesso ao programa "{$a->program_fullname}".';
$string['source_approval_notification_approval_request_subject'] = 'Notificação de solicitação de programa';
$string['source_approval_rejectionreason'] = 'Motivo da rejeição';
$string['source_approval_request'] = 'Solicitar';
$string['source_approval_requestallowed'] = 'Solicitações são permitidas';
$string['source_approval_requestapprove'] = 'Aprovar solicitação';
$string['source_approval_requestdelete'] = 'Solicitação de exclusão';
$string['source_approval_requestnotallowed'] = 'Não são permitidos pedidos';
$string['source_approval_requestpending'] = 'Solicitação de acesso pendente';
$string['source_approval_requestreject'] = 'Rejeitar solicitação';
$string['source_approval_requestrejected'] = 'O pedido de acesso foi rejeitado';
$string['source_approval_requests'] = 'Solicitações';
$string['source_cohort'] = 'Alocação automática de coorte';
$string['source_cohort_allownew'] = 'Permitir alocação de coorte';
$string['source_cohort_allownew_desc'] = 'Permitir adicionar novas fontes de _alocação automática de coorte_ aos programas';
$string['source_cohort_cohortstoallocate'] = 'Alocar coortes';
$string['source_manual'] = 'Alocação manual';
$string['source_manual_allocateusers'] = 'Alocar usuários';
$string['source_manual_csvfile'] = 'arquivo CSV';
$string['source_manual_hasheaders'] = 'A primeira linha é o cabeçalho';
$string['source_manual_potusers'] = 'Candidatos à alocação';
$string['source_manual_potusersmatching'] = 'Candidatos de alocação correspondentes';
$string['source_manual_result_assigned'] = '{$a} usuários foram atribuídos ao programa.';
$string['source_manual_result_errors'] = 'Erros {$a} detectados ao atribuir programas.';
$string['source_manual_result_skipped'] = '{$a} usuários já foram atribuídos ao programa.';
$string['source_manual_timeduecolumn'] = 'Coluna de tempo devido';
$string['source_manual_timeendcolumn'] = 'Coluna de fim de tempo';
$string['source_manual_timestartcolumn'] = 'Coluna de início de tempo';
$string['source_manual_uploadusers'] = 'Alocações de upload';
$string['source_manual_usercolumn'] = 'Coluna de identificação do usuário';
$string['source_manual_usermapping'] = 'Mapeamento de usuários via';
$string['source_manual_userupload_allocated'] = 'Alocado para \'{$a}\\';
$string['source_manual_userupload_alreadyallocated'] = 'Já alocado para \'{$a}\\';
$string['source_manual_userupload_invalidprogram'] = 'Não é possível alocar para \'{$a}\\';
$string['source_mucertify'] = 'Certificações';
$string['source_mucertify_allownew'] = 'Permitir alocação de certificações';
$string['source_mucertify_allownew_desc'] = 'Permitir adicionar novas fontes de _certificação_ aos programas';
$string['source_program'] = 'Programa completado';
$string['source_program_allownew'] = 'Permitir alocação de conclusão do programa';
$string['source_program_allownew_desc'] = 'Permitir adicionar novas fontes de _conclusão de programa_ aos programas';
$string['source_program_completedprogram'] = 'Programa para completar';
$string['source_selfallocation'] = 'Autoalocação';
$string['source_selfallocation_allocate'] = 'Inscrever-se';
$string['source_selfallocation_allownew'] = 'Permitir autoalocação';
$string['source_selfallocation_allownew_desc'] = 'Permitir adicionar novas fontes de _autoalocação_ aos programas';
$string['source_selfallocation_allowsignup'] = 'Permitir novas inscrições';
$string['source_selfallocation_confirm'] = 'Por favor, confirme que você deseja ser alocado ao programa.';
$string['source_selfallocation_enable'] = 'Habilitar autoalocação';
$string['source_selfallocation_key'] = 'Chave de inscrição';
$string['source_selfallocation_keyrequired'] = 'A chave de inscrição é necessária';
$string['source_selfallocation_maxusers'] = 'Máximo de usuários';
$string['source_selfallocation_maxusers_status'] = 'Usuários {$a->count}/{$a->max}';
$string['source_selfallocation_maxusersreached'] = 'Número máximo de usuários já autoalocados';
$string['source_selfallocation_signupallowed'] = 'Inscrições são permitidas';
$string['source_selfallocation_signupnotallowed'] = 'Não são permitidas inscrições';
$string['taballocation'] = 'Configurações de alocação';
$string['tabcontent'] = 'Conteúdo';
$string['tabgeneral'] = 'Geral';
$string['tabusers'] = 'Usuários';
$string['tabvisibility'] = 'Visibilidade do catálogo';
$string['tagarea_tool_muprog_program'] = 'Programas';
$string['taskcertificate'] = 'Programas emissores de certificados cron';
$string['taskcron'] = 'Programas plugin cron';
$string['training'] = 'Treinamento';
$string['trainingcompletion'] = 'Treinamento necessário: {$a}';
$string['trainingprogress'] = 'Progresso do treinamento: {$a->atual}/{$a->total}';
$string['unlinkeditems'] = 'Itens não vinculados';
$string['updatecourse'] = 'Curso de atualização';
$string['updatescheduling'] = 'Atualizar agendamento';
$string['updateset'] = 'Conjunto de atualizações';
$string['updatesource'] = 'Atualizar {$a}';
$string['updatetraining'] = 'Treinamento de atualização';
$string['upload'] = 'Carregar programas';
$string['upload_files'] = 'Arquivos';
$string['upload_files_error'] = 'São esperados vários arquivos CSV, um arquivo JSON ou um arquivo Zip';
$string['upload_invalidcount'] = 'Registros inválidos';
$string['upload_preview'] = 'Visualização de dados';
$string['upload_status'] = 'Status';
$string['upload_status_invalid'] = 'Inválido';
$string['upload_targetcontext'] = 'Adicionar programas ao contexto';
$string['upload_uploadcount'] = 'Programas para upload';
$string['upload_usecategory'] = 'Use a coluna de categoria para contextos';
$string['userupload_completion_error'] = 'A conclusão do programa não pode ser atualizada';
$string['userupload_completion_updated'] = 'A conclusão do programa foi atualizada';
