<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'hvp', language 'pt_br', version '5.1'.
 *
 * @package     hvp
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['acceptterms'] = 'Eu aceito os <a href=":url" target="_blank">termos de uso</a>';
$string['accountdetailslinktext'] = 'aqui';
$string['action'] = 'Ação';
$string['add'] = 'Adicionar';
$string['addedandupdatedpp'] = 'Foram adicionadas {$a->%new} novas biliotecas H5P e {$a->%old} antigas foram atualizadas.';
$string['addedandupdatedps'] = 'Foram adicionadas {$a->%new} novas biliotecas H5P e {$a->%old} antiga foi atualizada.';
$string['addedandupdatedsp'] = 'Foi adicionada {$a->%new} nova bilioteca H5P e {$a->%old} antigas foram atualizadas.';
$string['addedandupdatedss'] = 'Foi adicionada {$a->%new} nova bilioteca H5P e {$a->%old} antiga foi atualizada.';
$string['addednewlibraries'] = 'Foram adicionadas {$a->%new} new H5P libraries.';
$string['addednewlibrary'] = 'Foi adicionada {$a->%new} nova bilioteca H5P.';
$string['additionalinfo'] = 'Informações adicionais';
$string['additionallicenseinfo'] = 'Qualquer informação adicional sobre a licença';
$string['addlibraries'] = 'Adicionar bibliotecas';
$string['address'] = 'Endereço';
$string['age'] = 'Idade típica';
$string['agedescription'] = 'A audiência-alvo deste conteúdo. Possíveis formatos de entrada separados por vírgulas: "1,34-45,-50,59-".';
$string['ajaxfailed'] = 'Falha ao carregar dados.';
$string['alttext'] = 'Texto alternativo';
$string['anunexpectedsave'] = 'Aconteceu algo inexperado. Não foi possível salvar este conteúdo.';
$string['assistivetechnologieslabel'] = 'Rótulo de Tecnologias Assistivas';
$string['attribution'] = 'Atribuição 4.0';
$string['attributionnc'] = 'Atribuição-NãoComercial 4.0';
$string['attributionncnd'] = 'Atribuição-NãoComercial-SemDerivações 4.0';
$string['attributionncsa'] = 'Atribuição-NãoComercial-CompartilhaIgual 4.0';
$string['attributionnd'] = 'Atribuição-SemDerivações 4.0';
$string['attributionsa'] = 'Atribuição-CompartilhaIgual 4.0';
$string['author'] = 'Autor';
$string['authorcomments'] = 'Comentários do autor';
$string['authorcommentsdescription'] = 'Comentários para o editor de conteúdo (Este texto não será publicado como parte das informações sobre direitos autorais)';
$string['authorname'] = 'Nome do Autor';
$string['authorrole'] = 'Papel do Autor';
$string['back'] = 'Voltar';
$string['by'] = 'por';
$string['cancel'] = 'Cancelar';
$string['cancellabel'] = 'Cancelar';
$string['cancelpublishconfirmationdialogcancelbuttontext'] = 'Não';
$string['cancelpublishconfirmationdialogconfirmbuttontext'] = 'Sim';
$string['cancelpublishconfirmationdialogdescription'] = 'Você tem certeza de que deseja cancelar o processo de compartilhamento?';
$string['cancelpublishconfirmationdialogtitle'] = 'Cancelar compartilhamento';
$string['ccattribution'] = 'Atribuição (CC BY)';
$string['ccattributionnc'] = 'Atribuição-NãoComercial (CC BY-NC)';
$string['ccattributionncnd'] = 'Atribuição-NãoComercial-SemDerivações (CC BY-NC-ND)';
$string['ccattributionncsa'] = 'Atribuição-NãoComercial-CompartilhaIgual (CC BY-NC-SA)';
$string['ccattributionnd'] = 'Atribuição-SemDerivações (CC BY-ND)';
$string['ccattributionsa'] = 'Atribuição-CompartilhaIgual (CC BY-SA)';
$string['ccpdd'] = 'Dedicação de domínio público (CC0)';
$string['ccpdm'] = 'Marca de domínio público (PDM)';
$string['changedby'] = 'Alterado por';
$string['changedescription'] = 'Descrição da alteração';
$string['changehasbeensubmitted'] = 'Uma alteração foi enviada para';
$string['changelog'] = 'Alterar Log';
$string['changeplaceholder'] = 'Foto cortada, texto alterado, etc.';
$string['city'] = 'Cidade';
$string['close'] = 'Fechar';
$string['completionpass'] = 'Exigir nota de aprovação';
$string['completionpass_help'] = 'Se ativado, esta atividade é considerada completa quando o estudante recebe uma nota de aprovação (conforme especificado na seção de Notas das configurações da atividade H5P) ou superior.';
$string['completionpassdesc'] = 'O estudante deve alcançar uma nota de aprovação para concluir esta atividade';
$string['confirmdialogbody'] = 'Por favor confirme que deseja proseguir. Esta ação é irreversível.';
$string['confirmdialogheader'] = 'Confirmar ação';
$string['confirmlabel'] = 'Confirmar';
$string['connectionlost'] = 'Conexão perdida. Os resultados serão salvos e enviados quando for restabelecida sua conexão.';
$string['connectionreestablished'] = 'Conexão restabelecida.';
$string['contactperson'] = 'Pessoa de Contato';
$string['contactpersondescription'] = 'O H5P entrará em contato com a pessoa de contato caso haja algum problema com o conteúdo compartilhado pelo editor. O nome ou outras informações da pessoa de contato não serão publicados nem compartilhados com terceiros';
$string['contentavailable'] = 'Seu conteúdo estará normalmente disponível no Hub em até um dia útil.';
$string['contentchanged'] = 'Este conteúdo mudou desde a última vez que você o usou.';
$string['contentcopied'] = 'Conteúdo é copiado para a área de transferência.';
$string['contenthub:changesettings'] = 'Alterar configurações da conta <a href="{$a}">aqui</a>';
$string['contenthub:licenseagreementdescription'] = 'Por favor, leia o seguinte acordo antes de prosseguir com';
$string['contenthub:licenseagreementmaintext'] = 'A FAZER';
$string['contenthub:licenseagreementtitle'] = 'Contrato de Licença do Usuário Final (EULA)';
$string['contenthub:nopermissions'] = 'Você não tem permissão para registrar o site no hub de conteúdo.';
$string['contenthub:register'] = 'Registrar uma conta no H5P Hub <a href="{$a}">aqui</a>';
$string['contenthub:settings:box'] = 'Conta do Content Hub';
$string['contenthub:settings:heading'] = 'Configurações da Conta do H5P Hub';
$string['contenthubeditsharing'] = 'Editar informações de compartilhamento';
$string['contenthuboptions'] = 'Opções do H5P OER Hub';
$string['contenthubshare'] = 'Compartilhar no H5P Hub';
$string['contenthubsharinginprogress'] = 'Compartilhando...';
$string['contenthubsyncchanges'] = 'Sincronizar alterações';
$string['contenthubunshare'] = 'Cancelar compartilhamento';
$string['contentissyncing'] = 'Conteúdo está sendo sincronizado.';
$string['contentlicensetitle'] = 'Informações da Licença do Conteúdo';
$string['contentnotshared'] = 'Conteúdo não está compartilhado no Hub.';
$string['contentstatefrequency'] = 'Frequência de salvamente de estado de conteúdo';
$string['contentstatefrequency_help'] = 'Em segundos, o quão frequentemente você deseja que o conteúdo do usuário seja salvo automaticamente. Aumente este número se você está tendo problema com muitas requisições ajax';
$string['contenttype'] = 'Tipo de Conteúdo';
$string['contenttypecacheheader'] = 'Cache dos tipos de conteúdo';
$string['contentupdatesoon'] = 'Seu conteúdo será atualizado em breve';
$string['copyright'] = 'Direitos de uso';
$string['copyrightinfo'] = 'Informaçõoes de direitos autorais';
$string['copyrightstring'] = 'Direitos autorais';
$string['copyrighttitle'] = 'Ver informações de direitos autorais para este conteúdo.';
$string['copyrightwarning'] = 'Material protegido por direitos autorais não pode ser compartilhado no H5P Content Hub. Se o conteúdo estiver licenciado com uma licença amigável para OER, como Creative Commons, escolha a licença apropriada. Caso contrário, esse conteúdo não pode ser compartilhado.';
$string['couldnotcopy'] = 'Não foi possível copiar o arquivo.';
$string['couldnotparsejsonfromzip'] = 'Não foi possível analisar o JSON do pacote: %fileName';
$string['couldnotparsepostdata'] = 'Não foi possível analisar os dados enviados.';
$string['couldnotreadfilefromzip'] = 'Não foi possível ler o arquivo do pacote: %fileName';
$string['couldnotsave'] = 'Não foi possível salvar o arquivo.';
$string['country'] = 'País';
$string['create'] = 'Criar';
$string['creativecommons'] = 'Creative Commons';
$string['ctcachebuttonlabel'] = 'Atualizar cache de conteúdo';
$string['ctcacheconnectionfailed'] = 'Não foi possível se comunicar com o H5P Hub. Por favor, tente novamente.';
$string['ctcachedescription'] = 'Certificando-se que o cache de tipos de conteúdo está atualizado permitirá que você possa ver, baixar e utilizar as bibliotecas mais recentes. Isso é diferente de atualizar as bibliotecas proprimente ditas.';
$string['ctcachelastupdatelabel'] = 'Última atualização';
$string['ctcacheneverupdated'] = 'Nunca';
$string['ctcachenolibraries'] = 'Nenhum conteúdo foi recebido do H5P Hub. Por favor, tente novamente.';
$string['ctcachesuccess'] = 'O cache da biblioteca foi atualizado com sucesso!';
$string['ctcachetaskname'] = 'Atualizar cache de conteúdo';
$string['currentpage'] = 'Página $current de $total';
$string['currentstep'] = 'Passo :step de :total';
$string['dataviewreportlabel'] = 'Ver respostas';
$string['date'] = 'Data';
$string['description'] = 'Descrição';
$string['disablefileextensioncheck'] = 'Desabilitar verificação de arquivos de extensão';
$string['disablefileextensioncheckwarning'] = 'Aviso! Desabilitar a verificação de arquivos de extensão pode resultar em implicações de segurança no upload de arquivos php. Isto, por sua vez, pode tornar possível ataques maliciosos ao seu site. Por favor, tenha certeza que sabe o que está enviando.';
$string['disablefullscreen'] = 'Desativar tela cheia';
$string['disablehubconfirmationmsg'] = 'Ainda deseja habilitar o hub ?';
$string['disablehubdescription'] = 'É fortemente recomendado manter esta opção habilitada. O H5P Hub fornece uma interface fácil para adquirir novos tipos de conteúdo e manter conteúdos já existentes atualizados. No futuro, tornará mais fácil o compartilhamento e o reuso de conteúdo. Se esta opção for desabilitada, você terá que instalar e atualizar os conteúdos através de formulários de upload.';
$string['disciplinedescription'] = 'Você pode selecionar várias disciplinas';
$string['disciplinelabel'] = 'Disciplinas';
$string['disciplinelimitreachedmessage'] = 'Você pode selecionar até :numDisciplinas disciplinas';
$string['disciplines'] = 'Disciplinas';
$string['displayoptionalwaysshow'] = 'Sempre mostrar';
$string['displayoptionauthoroff'] = 'Controlado pelo autor, padrão é desabilitado';
$string['displayoptionauthoron'] = 'Controlado pelo autor, padrão é habilitado';
$string['displayoptiondownloadalways'] = 'Sempre';
$string['displayoptiondownloadnever'] = 'Nunca';
$string['displayoptiondownloadpermission'] = 'Somente se o usuário tem permissão para exportar o H5P';
$string['displayoptionnevershow'] = 'Nunca mostrar';
$string['displayoptionpermissions'] = 'Mostrar apenas se o usuário possui permissões para exportar H5P';
$string['displayoptionpermissionsembed'] = 'Mostrar apenas se o usuário possui permissões para embutir H5P';
$string['displayoptions'] = 'Mostrar opções';
$string['download'] = 'Baixar';
$string['downloadfailed'] = 'Falha em baixar a bilbioteca solicitada.';
$string['downloadtitle'] = 'Baixe este conteúdo como um arquivo H5P.';
$string['dropdownbutton'] = 'Botão de menu suspenso';
$string['editinfotitle'] = 'Editar informações para <strong>:title</strong>';
$string['editingfailed'] = 'Edição falhou.';
$string['editor'] = 'Editor';
$string['emailaddress'] = 'Endereço de E-mail';
$string['emailaddressdescription'] = 'O endereço de e-mail será usado pelo H5P para entrar em contato com o editor em caso de problemas com o conteúdo ou se o editor precisar recuperar sua conta. Não será publicado nem compartilhado com terceiros';
$string['emailconfirmbody'] = 'Olá {$a->username},

Obrigado por enviar suas respostas para \'{$a->hvpname}\' no curso \'{$a->coursename}\'.

Esta mensagem confirma que suas respostas foram salvas.

Você pode acessar o H5P em {$a->hvpurl}.';
$string['emailconfirmsmall'] = 'Obrigado por enviar suas respostas para \'{$a->hvpname}\'';
$string['emailconfirmsubject'] = 'Confirmação de envio: {$a->hvpname}';
$string['emailnotifybody'] = 'Olá {$a->username},

{$a->studentname} concluiu \'{$a->hvpname}\' ({$a->hvpurl}) no curso \'{$a->coursename}\'.

Você pode revisar esta tentativa em {$a->hvpreporturl}.';
$string['emailnotifysmall'] = '{$a->studentname} concluiu {$a->hvpname}. Veja {$a->hvpreporturl}';
$string['emailnotifysubject'] = '{$a->studentname} concluiu {$a->hvpname}';
$string['embed'] = 'Incorporar';
$string['embedloginfailed'] = 'Você não possui acesso a este conteúdo. Tente fazer login.';
$string['embedtitle'] = 'Ver o código embutido para este conteúdo.';
$string['empty'] = 'Não há resultados disponíveis';
$string['enableabout'] = 'Botão Sobre o H5P';
$string['enablecopyright'] = 'Botão de direitos autorais';
$string['enabledlrscontenttypes'] = 'Habilitar tipos de conteúdo dependentes de LRS';
$string['enabledlrscontenttypes_help'] = 'Torna possível usar tipos de conteúdo que necessitam de um Learning Record Store para funcionar adequadamente, como o conteúdo do tipo Questionário.';
$string['enabledownload'] = 'Permitir baixar';
$string['enableembed'] = 'Botão de embutir';
$string['enableframe'] = 'Mostrar a barra de ações e o quadro';
$string['enablehublabel'] = 'Usar o H5P Hub';
$string['enablejavascript'] = 'Por favor habilite o JavaScript.';
$string['enablesavecontentstate'] = 'Salvar o estado do conteúdo';
$string['enablesavecontentstate_help'] = 'Salva automaticamente o estado atual do conteúdo para cada usuário. Isso significa que o usuário pode continuar de onde parou.';
$string['failedtodownloadh5p'] = 'Falha ao baixar o H5P requisitado.';
$string['fileexceedsmaxsize'] = 'Um dos arquivos dentro do pacote excedeu o tamanho máximo de arquivo permitido. (%file %used > %max)';
$string['filenotfoundonserver'] = 'Arquivo não encontrado no servidor. Verifique as configurações de envio de arquivo.';
$string['filenotimage'] = 'O arquivo não é uma imagem.';
$string['filetypenotallowed'] = 'Tipo do arquivo não permitido.';
$string['finished'] = 'Terminado';
$string['fullscreen'] = 'Tela cheia';
$string['gpl'] = 'Licença geral pública (GPL) v3';
$string['gradeheading'] = 'Resultados para {$a}';
$string['gradetopassmustbeset'] = 'A nota para aprovação não pode ser zero, pois esta atividade H5P tem seu método de conclusão definido para exigir uma nota de aprovação. Por favor, defina um valor diferente de zero.';
$string['gradetopassnotset'] = 'Esta atividade H5P ainda não tem uma nota de aprovação definida. Pode ser configurada na seção de Notas das configurações da atividade H5P.';
$string['h5pfile'] = 'Arquivo H5P';
$string['h5ptitle'] = 'Visite H5P.org para conferir mais conteúdo legal.';
$string['helpchoosinglicense'] = 'Me ajude a escolher uma licença';
$string['hide'] = 'Esconder';
$string['hideadvanced'] = 'Ocultar avançado';
$string['hubcommunicationdisabled'] = 'A comunicação com o H5P hub foi desabilitada porque um ou mais requisitos H5P falharam.';
$string['hubisdisabled'] = 'O hub está desabilitado. Você pode habilitá-lo nas configurações do H5P.';
$string['hubisdisableduploadlibraries'] = 'O H5P Hub foi desabilitado até que este problema seja resolvido. Você ainda pode enviar bibliotecas através da página "Bibliotecas H5P".';
$string['hubsettingsheader'] = 'Tipos de conteúdo';
$string['hvp:addinstance'] = 'Criar novas atividades H5P';
$string['hvp:contenthubregistration'] = 'Registrar o site no H5P Content Hub';
$string['hvp:emailconfirmsubmission'] = 'Receber uma mensagem de confirmação ao enviar';
$string['hvp:emailnotifysubmission'] = 'Receber uma mensagem de notificação quando uma tentativa é enviada';
$string['hvp:getcachedassets'] = 'Exigido para visualização de atividades H5P';
$string['hvp:getembedcode'] = 'Ver código H5P embutido quando a opção \'controlado por permissão\' estiver habilitada';
$string['hvp:getexport'] = 'Baixar arquivo .h5p quando a opção \'controlado por permissão\' estiver habilitada';
$string['hvp:installrecommendedh5plibraries'] = 'Instalar novo conteúdo seguro H5P recomendado pelo H5P.org';
$string['hvp:manage'] = 'Editar atividades H5P existentes';
$string['hvp:restrictlibraries'] = 'Restringir acesso a certos tipos de conteúdo H5P';
$string['hvp:savecontentuserdata'] = 'Salvar o progresso do usuário para atividades H5P';
$string['hvp:saveresults'] = 'Salvar os resultados para atividades H5P concluídas';
$string['hvp:share'] = 'Compartilhar conteúdo no H5P OER Hub';
$string['hvp:updatelibraries'] = 'Instalar novos conteúdos H5P ou atualizar os existentes';
$string['hvp:userestrictedlibraries'] = 'Utilizar tipos restritos de conteúdo H5P';
$string['hvp:view'] = 'Veja e interaja com atividades H5P';
$string['hvp:viewallresults'] = 'Visualizar todos os resultados par atividades H5P concluídas';
$string['hvp:viewresults'] = 'Visualizar os próprios resultados para atividades H5P concluídas';
$string['icon'] = 'Ícone';
$string['icondescription'] = '640x480px. Se não selecionado, o conteúdo usará o ícone da categoria';
$string['in'] = 'em';
$string['installdenied'] = 'Você não tem permissão para instalar tipos de conteúdo. Contate o administrador do seu site.';
$string['installedlibraries'] = 'Instalar bibliotecas';
$string['intro'] = 'Introdução';
$string['invalidage'] = 'Formato de entrada inválido para Idade típica. Possíveis formatos de entrada separados por vírgulas: "1, 34-45, -50, -59-".';
$string['invalidaudioformat'] = 'Formato de arquivo de áudio inválido. Use mp3 ou wav.';
$string['invalidcontentfolder'] = 'Pasta de conteúdo inválida';
$string['invalidcontenttype'] = 'O tipo de conteúdo escolhido é inválido';
$string['invalidfieldtype'] = 'Tipo do campo inválido.';
$string['invalidfile'] = 'Arquivo "{$a->%filename}" não permitido. Apenas arquivos com as seguintes extensões são permitidos: {$a->%files-allowed}.';
$string['invalidh5ppost'] = 'Não foi possível postar H5P.';
$string['invalidhvp'] = 'Atividade H5P inválida';
$string['invalidimageformat'] = 'Formato de arquivo de imagem inválido. Use jpg, png ou gif.';
$string['invalidlanguagefile'] = 'Arquivo de linguagem inválido {$a->%file} na biblioteca {$a->%library}';
$string['invalidlanguagefile2'] = 'Arquivo de linguagem inválido {$a->%languageFile} foi incluído na biblioteca {$a->%name}';
$string['invalidlibrary'] = 'Biblioteca inválida';
$string['invalidlibrarydata'] = 'Dados inválidos fornecidos para {$a->%property} em {$a->%library}';
$string['invalidlibrarydataboolean'] = 'Dados inválidos fornecidos para {$a->%property} em {$a->%library}. Boolean esperado.';
$string['invalidlibraryname'] = 'Nome de biblioteca inválido: {$a->%name}';
$string['invalidlibrarynamed'] = 'A biblioteca H5P {$a->%library} usada neste conteúdo não é válida.';
$string['invalidlibraryoption'] = 'Opção ilegal {$a->%option} em {$a->%library}';
$string['invalidlibraryproperty'] = 'Não foi possível ler a propriedade {$a->%property} em {$a->%library}';
$string['invalidmainjson'] = 'Um arquivo principal válido h5p.json está ausente';
$string['invalidmultiselectoption'] = 'Opção de seleção inválida em multi-seleção.';
$string['invalidparameters'] = 'Parâmetros inválidos';
$string['invalidselectoption'] = 'Opção de seleção inválida em seleção.';
$string['invalidsemanticsjson'] = 'Arquivo inválido semantics.json foi incluído na biblioteca {$a->%name}';
$string['invalidsemanticstype'] = 'Erro interno H5P: unknown content type "{$a->@type}" in semantics. Removing content!';
$string['invalidstring'] = 'A string fornecida não é válida em semântica de acordo com o regexp. (valor: \\"{$a->%value}\\", regexp: \\"{$a->%regexp}\\")';
$string['invalidtoken'] = 'O H5P recebeu um token inválido. Atualize a página e tente novamente';
$string['invalidvideoformat'] = 'Formato de arquivo de vídeo inválido. Use mp4 ou webm.';
$string['invalidxapiresult'] = 'Nenhum resultado xAPI foi encontrado para a dada combinação de conteúdo e identificação de usuário';
$string['isnowsubmitted'] = 'Agora foi enviado para o H5P Hub';
$string['javascriptloading'] = 'Esperando por JavaScript...';
$string['keywordexists'] = 'Palavra-chave já existe!';
$string['keywords'] = 'Palavras-chave';
$string['keywordsdescription'] = 'Você pode adicionar várias palavras-chave separadas por vírgulas. Pressione "Enter" ou "Adicionar" para confirmar as palavras-chave';
$string['keywordsexists'] = 'Palavras-chave já existem!';
$string['keywordsplaceholder'] = 'Adicionar palavras-chave';
$string['language'] = 'Idioma';
$string['level'] = 'Nível';
$string['libraries'] = 'Biblioteca do H5P';
$string['librarydirectoryerror'] = 'O nome do diretório da biblioteca de ser compatível com machineName ou machineName-majorVersion.minorVersion (de library.json). (Diretório: {$a->%directoryName} , machineName: {$a->%machineName}, majorVersion: {$a->%majorVersion}, minorVersion: {$a->%minorVersion})';
$string['librarylistactions'] = 'Ações';
$string['librarylistinstancedependencies'] = 'Dependências de instância';
$string['librarylistinstances'] = 'Instâncias';
$string['librarylistlibrarydependencies'] = 'Dependências de biblioteca';
$string['librarylistrestricted'] = 'Restrito';
$string['librarylisttitle'] = 'Título';
$string['librarynotselected'] = 'Você precisa selecionar o tipo de conteúdo.';
$string['license'] = 'Licença';
$string['licenseCC010'] = 'CC0 1.0 Universal (CC0 1.0) Dedicação de domínio público';
$string['licenseCC010U'] = 'CC0 1.0 Universal';
$string['licenseCC10'] = '1.0 Generic';
$string['licenseCC20'] = '2.0 Generic';
$string['licenseCC25'] = '2.5 Generic';
$string['licenseCC30'] = '3.0 Unported';
$string['licenseCC40'] = '4.0 International';
$string['licenseGPL'] = 'Licença geral pública (GPL)';
$string['licenseV1'] = 'Versão 1';
$string['licenseV2'] = 'Versão 2';
$string['licenseV3'] = 'Versão 3';
$string['licensedescription'] = 'Selecione uma licença para o seu conteúdo';
$string['licensedetails'] = 'Detalhes da Licença';
$string['licensedialogdescription'] = 'Clique em uma licença específica para obter informações sobre o uso adequado';
$string['licensee'] = 'Licenciado';
$string['licenseextras'] = 'Extras da licença';
$string['licenseversion'] = 'Versão de licença';
$string['licenseversiondescription'] = 'Selecione uma versão de licença';
$string['loadingdata'] = 'Carregando dados.';
$string['logouploadtext'] = 'Logotipo ou avatar da organização';
$string['longdescription'] = 'Descrição longa';
$string['longdescriptionplaceholder'] = 'Descrição longa do seu conteúdo';
$string['lookforupdates'] = 'Procurar por atualizações do H5P';
$string['maintitle'] = 'Compartilhando <strong>:title</strong>';
$string['maximumgrade'] = 'Nota máxima';
$string['maximumgradeerror'] = 'Por favor, informe um dígito positivo válido como a pontuação máxima disponível para esta atividade';
$string['maxlength'] = ':length é o número máximo de caracteres';
$string['maxpostsizetoosmall'] = 'O seu tamanho de publicação máximo do PHP é bem pequeno. Com a sua configuração atual, você não poderá enviar arquivos maiores que {$a->%number} MB. Isso pode causar problemas ao tentar enviar H5Ps, imagens e vídeos. Por favor, considere aumentar para mais de 5MB.';
$string['maxscore'] = 'Pontuação máxima';
$string['maxuploadsizetoosmall'] = 'O seu tamanho de upload máximo do PHP é bem pequeno. Com a sua configuração atual, você não poderá enviar arquivos maiores que {$a->%number} MB. Isso pode causar problemas ao tentar enviar H5Ps, imagens e vídeos. Por favor, considere aumentar para mais de 5MB.';
$string['messageprovider:confirmation'] = 'Confirmação dos seus próprios envios de H5P';
$string['messageprovider:submission'] = 'Notificação de envio de H5P';
$string['missingcontentfolder'] = 'Uma pasta de conteúdo válido está ausente';
$string['missingcontentuserdata'] = 'Erro: Não foi possível encontrar dados do usuário de conteúdo';
$string['missingcoreversion'] = 'O sistema foi incapaz de instalar o componente <em>{$a->%component}</em> do pacote, requer uma versão mais recente do plugin H5P. Este site está atualmente rodando a versão {$a->%current}, e a versão exigida é {$a->%required} ou superior. Você deve considerar atualizar e tentar novamente.';
$string['missingdependency'] = 'Dependência {$a->@dep} ausente exigida por {$a->@lib}.';
$string['missinglibrary'] = 'Biblioteca exigida {$a->@library} ausente';
$string['missinglibraryfile'] = 'O arquivo "{$a->%file}" está ausente da biblioteca: "{$a->%name}"';
$string['missinglibraryjson'] = 'Não foi possível encontrar o arquivo library.json com um formato json válido para a biblioteca {$a->%name}';
$string['missinglibraryproperty'] = 'A propriedade exigida {$a->%property} está ausente de {$a->%library}';
$string['missingmbstring'] = 'A extenção mbstring PHP não foi carregada. H5P precisa desta extensão para funcionar corretamente';
$string['missingparameters'] = 'Parâmetros ausentes';
$string['missinguploadpermissions'] = 'Note que as bibliotecas podem existir no arquivo que você enviou, mas você não tem permissão para enviar novas bibliotecas. Contate o administrador do site sobre isso.';
$string['modulename'] = 'Conteúdo interativo';
$string['modulename_help'] = 'O módulo de atividade H5P permite que você crie conteúdos interativos como Vídeos interativos, Conjuntos de questões, Questões de arrastar e soltar, Questões de múltipla escolha, Apresentações e muito mais.

Além de ser uma ferramenta de autoria para conteúdo rico, o H5P permite importar e exportar arquivos H5P para uma eficaz reutilização e compartilhamento de conteúdo.

As interações e pontuações do usuário são monitoras usando xAPI e estão disponíveis no livro de notas. Observe que atualmente é possível que pessoas com habilidades de programação trapaceiem nas interações H5P e obtenham uma pontuação total sem saber as respostas corretas. Os conteúdos H5Ps não devem ser usados para provas ou similares.

Você adiciona conteúdo H5P interativo criando conteúdo usando a ferramenta de autoria incorporada ou enviando arquivos H5P encontrados em outros sites habilitados para H5P.';
$string['modulename_link'] = 'https://h5p.org/moodle-more-help';
$string['modulenameplural'] = 'Conteúdo interativo';
$string['next'] = 'Próximo';
$string['nextpage'] = 'Próxima página';
$string['noanswersubmitted'] = 'Este usuário ainda não submeteu nenhuma resposta ao H5P';
$string['nocontent'] = 'Não foi possível encontrar ou analisar o arquivo content.json';
$string['nocontenttype'] = 'Nenhum tipo de conteúdo foi especificado.';
$string['nocopyright'] = 'Nenhuma informação sobre direitos autorais disponível para este conteúdo.';
$string['nodata'] = 'Não há dados disponíveis que correspondam aos seus critérios.';
$string['noexport'] = 'Arquivo de exportação ausente.';
$string['noextension'] = 'O arquivo que você enviou não é um pacote HTML5 válido (não possui a extensão de arquivo .h5p)';
$string['noh5ps'] = 'Não há conteúdo interativo disponível para este curso.';
$string['nohubregistration'] = 'Não registrado no H5P Hub';
$string['nojson'] = 'O arquivo principal h5p.json não é válido';
$string['nombstringexteension'] = 'A extenção PHP mbstring não está carregada. H5P precisa disso para funcionar corretamente';
$string['noparameters'] = 'Nenhum parâmetro';
$string['noparse'] = 'Não foi possível analisar(parse) o arquivo principal h5p.json';
$string['nopermissiontogettranslations'] = 'Você não tem permissão para recuperar traduções';
$string['nopermissiontorestrict'] = 'Você não possui permissão para acessar bibliotecas restritas.';
$string['nopermissiontosavecontentuserdata'] = 'Você não possui permissão para salvar dados de usuário de conteúdos.';
$string['nopermissiontosaveresult'] = 'Você não possui permissão para salvar resultados para este conteúdo.';
$string['nopermissiontoupgrade'] = 'Você não possui permissão para atualizar bibliotecas.';
$string['nopermissiontouploadcontent'] = 'Você não possui permissão para enviar conteúdo aqui.';
$string['nopermissiontouploadfiles'] = 'Você não possui permissão para enviar arquivos aqui.';
$string['nopermissiontoviewcontenthubcache'] = 'Você não tem permissão para visualizar os metadados do centro de conteúdo.';
$string['nopermissiontoviewcontenttypes'] = 'Você não possui permissão para ver os tipos de conteúdo.';
$string['nopermissiontoviewresult'] = 'Você não possui permissão para ver resultados para este conteúdo.';
$string['nosuchlibrary'] = 'Nenhuma biblioteca';
$string['notapplicable'] = 'N/A';
$string['nounzip'] = 'O arquivo que você enviou não é um pacote HTML5 válido (Não foi possível descompactá-lo)';
$string['noversionattribution'] = 'Atribuição';
$string['noversionattributionnc'] = 'Atribuição-NãoComercial';
$string['noversionattributionncnd'] = 'Atribuição-NãoComercial-SemDerivações';
$string['noversionattributionncsa'] = 'Atribuição-NãoComercial-CompartilhaIgual';
$string['noversionattributionnd'] = 'Atribuição-SemDerivações';
$string['noversionattributionsa'] = 'Atribuição-CompartilhaIgual';
$string['nowriteaccess'] = 'Um problema com o acesso de escrita do servidor foi detectado. Por favor, tenha certeza que o seu servidor pode escrever em sua pasta de dados.';
$string['noziparchive'] = 'Sua versão do PHP não suporta arquivos zipados (ZipArchive).';
$string['offlinedialogbody'] = 'Não foi possível enviar informações sobre sua conclusão dessa tarefa. Por favor, verifique sua conexão com a internet.';
$string['offlinedialogheader'] = 'Sua conexão com o servidor foi perdida';
$string['offlinedialogretrybuttonlabel'] = 'Tentar novamente';
$string['offlinedialogretrymessage'] = 'Tentando novamente em :num....';
$string['offlinesuccessfulsubmit'] = 'Resultados enviados com sucesso.';
$string['oldphpversion'] = 'Sua versão do PHP está desatualizada. H5P requer a versão 5.2 para funcionar corretamente. Versão 5.6 ou superior são recomendadas.';
$string['olduploadoldcontent'] = 'Você está tentando enviar conteúdo de uma versão mais antiga do H5P. Por favor, atualize o conteúdo no servidor de origem e tente fazer o envio novamente ou habilite o H5P Hub para que esse servidor atualize para você automaticamente.';
$string['onlyupdate'] = 'Somente enviar bibliotecas existentes';
$string['optionalinfo'] = 'Informações Opcionais';
$string['options'] = 'Opções';
$string['originator'] = 'Criador';
$string['pd'] = 'Domínio público';
$string['pddl'] = 'Dedicação e licença de domínio público';
$string['pdm'] = 'Marca de domínio público';
$string['phone'] = 'Telefone';
$string['pleasewait'] = 'Por favor, aguarde...';
$string['pluginadministration'] = 'H5P';
$string['pluginname'] = 'H5P';
$string['postmessagerequired'] = 'Uma mensagem postada é necessária para acessar o endpoint fornecido';
$string['previouspage'] = 'Página anterior';
$string['privacy:metadata:core_files'] = 'A atividade H5P armazena arquivos que tenham sido enviados como parte do conteúdo H5P.';
$string['privacy:metadata:core_grades'] = 'A atividade H5P armazena notas do usuários que responderam o conteúdo H5P.';
$string['privacy:metadata:hvp_content_user_data'] = 'Descreve o estado atual de um conteúdo exibido para o usuário. Usado para restaurar estados antigos de conteúdo.';
$string['privacy:metadata:hvp_content_user_data:data'] = 'Dados armazenados do usuário.';
$string['privacy:metadata:hvp_content_user_data:data_id'] = 'Identificar de tipo de dados.';
$string['privacy:metadata:hvp_content_user_data:delete_on_content_change'] = 'Flag que determina se dados devem ser deletados quando o conteúdo é alterado.';
$string['privacy:metadata:hvp_content_user_data:hvp_id'] = 'A ID do conteúdo H5P que os dados pertencem.';
$string['privacy:metadata:hvp_content_user_data:id'] = 'A ID da relção de dados de usuário e conteúdo.';
$string['privacy:metadata:hvp_content_user_data:preloaded'] = 'Flag que determina se dados devem ser pré-carregados no conteúdo.';
$string['privacy:metadata:hvp_content_user_data:sub_content_id'] = 'Sub-conteúdo do H5P, 0 se não é sub-conteúdo.';
$string['privacy:metadata:hvp_content_user_data:user_id'] = 'A ID do usuário a quem os dados pertencem.';
$string['privacy:metadata:hvp_events'] = 'Mantém o controle de eventos registrados do H5P.';
$string['privacy:metadata:hvp_events:content_id'] = 'A ID do conteúdo em que a ação foi executada, 0 se nenhum ou novo conteúdo.';
$string['privacy:metadata:hvp_events:content_title'] = 'Título do conteúdo.';
$string['privacy:metadata:hvp_events:created_at'] = 'A hora em que o evento foi criado.';
$string['privacy:metadata:hvp_events:id'] = 'A ID única do evento.';
$string['privacy:metadata:hvp_events:library_name'] = 'A biblioteca afetada pelo evento.';
$string['privacy:metadata:hvp_events:library_version'] = 'A versão da biblioteca afeitada pelo evento.';
$string['privacy:metadata:hvp_events:sub_type'] = 'O sub-tipo de evento, ou ação do evento.';
$string['privacy:metadata:hvp_events:type'] = 'O tipo de evento.';
$string['privacy:metadata:hvp_events:user_id'] = 'A ID do usuário que executou a ação.';
$string['privacy:metadata:hvp_xapi_results'] = 'Armazena eventos xAPI em conteúdo H5P.';
$string['privacy:metadata:hvp_xapi_results:additionals'] = 'Informações adicionais que o H5P pode enviar.';
$string['privacy:metadata:hvp_xapi_results:content_id'] = 'A ID do conteúdo em que o evento foi executado.';
$string['privacy:metadata:hvp_xapi_results:correct_responses_pattern'] = 'O padrão correto de resposta.';
$string['privacy:metadata:hvp_xapi_results:description'] = 'A descrição, tarefa ou questão do conteúdo em que a ação foi executada.';
$string['privacy:metadata:hvp_xapi_results:id'] = 'A ID única do evento xAPI.';
$string['privacy:metadata:hvp_xapi_results:interaction_type'] = 'O tipo de interação.';
$string['privacy:metadata:hvp_xapi_results:max_score'] = 'Pontuação máxima adquirível para o evento.';
$string['privacy:metadata:hvp_xapi_results:parent_id'] = 'A ID do conteúdo-pai do conteúdo em que o evento foi executado. Null se não há conteúdo-pai.';
$string['privacy:metadata:hvp_xapi_results:raw_score'] = 'Pontuação atingida para o evento.';
$string['privacy:metadata:hvp_xapi_results:response'] = 'A resposta que o usuário enviou.';
$string['privacy:metadata:hvp_xapi_results:user_id'] = 'A ID do usuário que executou a ação.';
$string['publisherdescription'] = 'Descrição do Editor';
$string['publisherdescriptiontext'] = 'Isso será exibido em "Informações do Editor" no conteúdo compartilhado';
$string['publisherfielddescription'] = 'Isso será exibido como o "Nome do Editor" no conteúdo compartilhado';
$string['publisherfieldtitle'] = 'Editora';
$string['question'] = 'Questão';
$string['registeronhub'] = 'Registrar no H5P Hub';
$string['registrationfailed'] = 'Ocorreu um erro';
$string['registrationfaileddescription'] = 'Não foi possível criar uma conta neste momento. Algo deu errado. Tente novamente mais tarde.';
$string['registrationtitle'] = 'Registro no H5P Hub';
$string['remove'] = 'Remover';
$string['removechip'] = 'Remover :chip da lista';
$string['removeimage'] = 'Remover imagem';
$string['removeoldlogentries'] = 'Remover entradas de log antigas do H5P';
$string['removeoldmobileauthentries'] = 'Remove old H5P mobile auth entries';
$string['removetmpfiles'] = 'Remover arquivos temporários antigos do H5P';
$string['reportingquestionsremaininglabel'] = 'questões restantes para correção';
$string['reportingscaledscoredelimiter'] = ',';
$string['reportingscaledscorelabel'] = 'Pontuação no quadro de notas:';
$string['reportingscoredelimiter'] = 'de';
$string['reportingscorelabel'] = 'Pontuação:';
$string['reportnotsupported'] = 'Não suportado';
$string['reportsubmitgradelabel'] = 'Submeter notas';
$string['requiredinfo'] = 'Informações Obrigatórias';
$string['resizescript'] = 'Inclua este script no seu website se deseja redimensionamento dinâmico no conteúdo embutido:';
$string['resubmitscores'] = 'Tentando enviar resultados armazenados.';
$string['reuse'] = 'Reutilizar';
$string['reusecontent'] = 'Reutilizar Conteúdo';
$string['reusedescription'] = 'Reutilizar este conteúdo.';
$string['reveal'] = 'Mostrar';
$string['reviewandsave'] = 'Revisar e Salvar';
$string['reviewandshare'] = 'Revisar e Compartilhar';
$string['reviewinfo'] = 'Revisar informações';
$string['reviewmessage'] = 'Por favor, reveja as informações abaixo antes de compartilhar';
$string['reviseserversetupandretry'] = 'Quando as configurações do server forem revistas, você poderá reativar a comunicação com o H5P hub nas configurações do H5P.';
$string['savechanges'] = 'Salvar alterações';
$string['score'] = 'Pontuação';
$string['screenshots'] = 'Capturas de tela';
$string['screenshotsdescription'] = 'Adicione até cinco capturas de tela do seu conteúdo';
$string['search'] = 'Pesquisar';
$string['searchplaceholder'] = 'Digite para buscar disciplinas';
$string['sendusagestatistics'] = 'Contribuir com estatísticas de uso';
$string['sendusagestatistics_help'] = 'As estatísticas de uso serão automaticamente reportadas para ajudar os desenvolvedores a entender melhor como o H5P é usado e para determinar o potenciais áreas de melhoria. Leia mais sobre quais <a {$a}>dados são coletados em h5p.org</a>.';
$string['settings'] = 'Configurações do H5P';
$string['share'] = 'Compartilhar';
$string['shared'] = 'Compartilhado';
$string['sharefailed'] = 'Falha no compartilhamento.';
$string['sharetryagain'] = 'Algo deu errado, por favor, tente compartilhar novamente.';
$string['sharingnote'] = 'Todos os detalhes do conteúdo podem ser editados após o compartilhamento';
$string['shortdescription'] = 'Descrição Curta';
$string['shortdescriptionplaceholder'] = 'Descrição curta do seu conteúdo';
$string['showadvanced'] = 'Mostrar avançado';
$string['showless'] = 'Mostrar menos';
$string['showmore'] = 'Mostrar mais';
$string['sitecouldnotberegistered'] = 'O site não pôde ser registrado pelo hub. Por favor, contate o administrador do seu site.';
$string['sitekey'] = 'Chave do site';
$string['sitekeydescription'] = 'A chave do site é secreta e identifica unicamente este site no Hub.';
$string['sitekeyregistered'] = 'Uma chave única foi fornecida a você. Esta chave identifica você com o Hub quando novas atualizações são recebidas. Esta chave está disponível para visualização na página "Configurações H5P".';
$string['size'] = 'Tamanho';
$string['somekeywordsexists'] = 'Algumas dessas palavras-chave já existem';
$string['source'] = 'Fonte';
$string['sslnotenabled'] = 'Seu servidor não possui SSL habilitado. SSL deve ser habilitado para certificar uma conexão segura com o H5P hub.';
$string['startingover'] = 'Você começará novamente.';
$string['subcontentwarning'] = 'O subconteúdo (imagens, questões etc.) será compartilhado sob :license, a menos que seja especificado de outra forma na ferramenta de autoria';
$string['sublevel'] = 'Subnível';
$string['submitted'] = 'Enviado!';
$string['successfullyregisteredwithhub'] = 'Seu site foi registrado com sucesso pelo H5P Hub.';
$string['successfullyregistred'] = 'Você se registrou com sucesso em uma conta no H5P Hub';
$string['successfullyregistreddescription'] = 'Os detalhes da sua conta podem ser alterados';
$string['successfullyupdated'] = 'As configurações da sua conta no H5P Hub foram alteradas com sucesso';
$string['thumbnail'] = 'Miniatura';
$string['title'] = 'Título';
$string['unabletocreatedir'] = 'Incapaz de criar diretório.';
$string['unabletogetfieldtype'] = 'Incapaz de capturar o tipo do campo.';
$string['undisclosed'] = 'Não revelado';
$string['unpackedfilesexceedsmaxsize'] = 'O tamanho total dos arquivos descompactados excede o tamanho máximo permitido (%used > %max)';
$string['updatedlibraries'] = 'Foram atualizadas {$a->%old} bibliotecas H5P.';
$string['updatedlibrary'] = 'Foi atualizada {$a->%old} biblioteca H5P.';
$string['updatelibraries'] = 'Atualizar todas as bibliotecas';
$string['updateregistrationonhub'] = 'Salvar configurações da conta';
$string['upgrade'] = 'Atualizar H5P';
$string['upgradebuttonlabel'] = 'Atualizar';
$string['upgradedone'] = 'Você atualizou com sucesso a(s) instância(s) do conteúdo {$a} .';
$string['upgradeerror'] = 'Um erro ocorreu enquanto parâmetros eram processados:';
$string['upgradeerrorcontent'] = 'Não foi possível atualizar o conteúdo %id:';
$string['upgradeerrordata'] = 'Não foi possível carregar dados para a biblioteca %lib.';
$string['upgradeerrormissinglibrary'] = 'Missing required library %lib.';
$string['upgradeerrornotsupported'] = 'Parameters contain %used which is not supported.';
$string['upgradeerrorparamsbroken'] = 'Os parâmetros estão quebrados.';
$string['upgradeerrorscript'] = 'Não foi possível carregar o script de atualizações para %lib.';
$string['upgradeerrortoohighversion'] = 'Parameters contain %used while only %supported or earlier are supported.';
$string['upgradeheading'] = 'Atualizar o conteúdo {$a}';
$string['upgradeinprogress'] = 'Atualizando para %ver...';
$string['upgradeinvalidtoken'] = 'Erro: Token de segurança inválido!';
$string['upgradelibrarycontent'] = 'Atualizar conteúdo da biblioteca';
$string['upgradelibrarymissing'] = 'Erro: Biblioteca ausente!';
$string['upgrademessage'] = 'Você está prestes a atualizar a(s) instância(s) do conteúdo {$a} . Por favor selecione a versão de atualização.';
$string['upgradenoavailableupgrades'] = 'Não há nenhuma atualização disponível para este conteúdo.';
$string['upgradenothingtodo'] = 'Não há instâncias de conteúdo para atualizar.';
$string['upgradereturn'] = 'Retornar';
$string['upload'] = 'Enviar';
$string['uploadlibraries'] = 'Enviar bibliotecas';
$string['uploadsizelargerthanpostsize'] = 'O seu tamanho de upload máximo PHP é maior que o seu tamanho de publicação máximo. Isso é conhecido por causar alguns problemas em algumas instalações.';
$string['user'] = 'Usuário';
$string['validatingh5pfailed'] = 'A validação do pacote h5p falhou.';
$string['validationfailed'] = 'O H5P solicitado não é válido';
$string['viewreportlabel'] = 'Reportar';
$string['welcomecommunity'] = 'Esperamos que você desfrute do H5P e participe de nossa crescente comunidade através dos nossos <a {$a->forums}>fórums</a>.';
$string['welcomecontactus'] = 'Se você tiver qualquer comentário, não hesite em entrar em <a {$a}>contato</a> conosco. Levamos os feedbacks bastante a sério e nos dedicamos para fazer o H5P mehor a cada dia!';
$string['welcomegettingstarted'] = 'Para começar a usar o H5P e Moodle dê uma olhada no nosso <a {$a->moodle_tutorial}>tutorial</a> e confira o <a {$a->example_content}>conteúdo exemplo</a> em H5P.org para inspiração.';
$string['welcomeheader'] = 'Bem-vindo ao mundo do H5P!';
$string['wrongversion'] = 'A versão da biblioteca H5P {$a->%machineName} usada neste conteúdo não é válida. O conteúdo contém {$a->%contentLibrary}, mas deveria conter {$a->%semanticsLibrary}.';
$string['year'] = 'Ano';
$string['years'] = 'Ano(s)';
$string['yearsfrom'] = 'Ano (de)';
$string['yearsto'] = 'Ano (até)';
$string['zip'] = 'CEP';
