<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'data', language 'pl', version '5.1'.
 *
 * @package     data
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['action'] = 'Akcja';
$string['actionsmenu'] = 'Menu akcji';
$string['add'] = 'Dodaj wpis';
$string['addcomment'] = 'Dodaj komentarz';
$string['addtemplate'] = 'Szablon dodawania';
$string['advancedsearch'] = 'Wyszukiwanie zaawansowane';
$string['allowcomments'] = 'Pozwól komentować wpisy';
$string['alttext'] = 'Alternatywny tekst';
$string['approvalstatus'] = 'Status zatwierdzenia';
$string['approve'] = 'Zatwierdź';
$string['approved'] = 'Zatwierdzony';
$string['areacontent'] = 'Pola';
$string['ascending'] = 'Rosnąco';
$string['asearchtemplate'] = 'Szablon zaawansowanego wyszukiwania';
$string['atmaxentry'] = 'Została wykorzystana maksymalna liczba wejść';
$string['authorfirstname'] = 'Imię';
$string['authorlastname'] = 'Nazwisko';
$string['autogenallforms'] = 'Generuj wszystkie domyślne szablony';
$string['autolinkurl'] = 'Automatycznie linkuj URL';
$string['availablefromdate'] = 'Dostępny od';
$string['availabletags'] = 'Dostępne znaczniki';
$string['availabletags_help'] = 'Znaczniki są elementami szablonu, które zostaną zastąpione przez dane lub inne elementy, takie jak ikona edycji, w czasie edytowania lub wyświetlania.

Pola mają format [[nazwa_pola]]. Wszystkie inne znaczniki mają format ##tag##.

Tylko znaczniki z listy "dostępnych znaczników" może być stosowane w obecnym szablonie.';
$string['availabletodate'] = 'Dostępny do';
$string['availabletodatevalidation'] = 'Data "Dostępny do" nie może być przed datą "Dostępny od".';
$string['bynameondate'] = 'przez {$a->name} - {$a->date}';
$string['calendarend'] = '{$a} zamyka się';
$string['calendarstart'] = '{$a} otwiera się';
$string['cancel'] = 'Anuluj';
$string['cannotaccesspresentsother'] = 'Nie masz dostępu do wzorców innych użytkowników';
$string['cannotadd'] = 'Nie można dodawać wpisów';
$string['cannotapplypreset'] = 'Błąd przy zastosowaniu wzorca.';
$string['cannotdeletepreset'] = 'Błąd przy usuwaniu wzorca';
$string['cannotoverwritepreset'] = 'Błąd przy nadpisywaniu wzorca!';
$string['cannotunziptopreset'] = 'Nie można rozpakować pliku zip do katalogu wzorca';
$string['checkbox'] = 'Pole opcji (checkboxes)';
$string['chooseexportfields'] = 'Wybierz pola, które chcesz eksportować';
$string['chooseexportformat'] = 'Wybierz format, do którego chcesz eksportować:';
$string['chooseorupload'] = 'Wybierz plik';
$string['choosepreset'] = 'Plik wzorca';
$string['closebeforeopen'] = 'Podano datę końcową poprzedzającą datę początkową.';
$string['columns'] = 'kolumny';
$string['comment'] = 'Komentarz';
$string['commentdeleted'] = 'Usunięto komentarz';
$string['commentempty'] = 'Komentarz jest pusty';
$string['comments'] = 'Komentarze';
$string['commentsaved'] = 'Komentarz zapisano';
$string['commentsn'] = '{$a} komentarzy';
$string['commentsoff'] = 'Funkcja Komentarze nie jest włączona';
$string['completiondetail:entries'] = 'Dodaj wpisy: {$a}';
$string['completionentriescount'] = 'Dodaj wpisy';
$string['completionentriesdesc'] = 'Minimalna wymagana liczba wpisów: {$a}';
$string['configenablerssfeeds'] = 'To ustawienie włącza możliwość ustawienia kanałów RSS dla całych baz danych. Musisz włączyć ręcznie to ustawienie dla każdej bazy danych.';
$string['confirmdeletefield'] = 'Czy na pewno usunąć te pole?';
$string['confirmdeleterecord'] = 'Na pewno chcesz usunąć ten wpis?';
$string['confirmdeleterecords'] = 'Czy na pewno chcesz usunąć te wpisy?';
$string['createactivity'] = 'Utwórz własne pola do zbierania danych lub użyj wzorca, który już zawiera pola';
$string['createfields'] = 'Utwórz pola, aby zbierać różne typy danych.';
$string['createtemplates'] = 'Szablony określają interfejs aktywności. Po utworzeniu pól szablony zostaną utworzone automatycznie. Alternatywnie można użyć wzorca, który obejmuje pola oraz szablony.';
$string['csstemplate'] = 'Niestandardowy CSS';
$string['csvfailed'] = 'Nie mogę czytać surowych danych z pliku CSV';
$string['csvfile'] = 'CSV lub ZIP zawierający plik CSV';
$string['csvimport'] = 'import pliku CSV';
$string['csvimport_help'] = 'Wpisy mogą być importowane przez zwykły plik tekstowy z listą nazw pól jako pierwszą linią, a następnie danymi, z jednym rekordem na linię.';
$string['csvwithselecteddelimiter'] = '<abbr title="Wartości rozdzielane przecinkami">CSV</abbr>';
$string['data:addinstance'] = 'Dodaj nową bazę danych';
$string['data:approve'] = 'Zatwierdź i cofnij zatwierdzone wpisy';
$string['data:comment'] = 'Napisz komentarz';
$string['data:exportallentries'] = 'Eksport wszystkich wpisów w bazie danych';
$string['data:exportentry'] = 'Eksportuj wpis w bazie danych';
$string['data:exportownentry'] = 'Eksport własnych wpisów w bazie danych';
$string['data:exportuserinfo'] = 'Eksport danych użytkownika';
$string['data:managecomments'] = 'Zarządzaj komentarzami';
$string['data:manageentries'] = 'Zarządzaj wpisami';
$string['data:managetemplates'] = 'Zarządzaj szablonami';
$string['data:manageuserpresets'] = 'Zarządzaj wszystkimi wzorcami szablonów';
$string['data:rate'] = 'Oceń wpisy';
$string['data:readentry'] = 'Czytaj wpisy';
$string['data:view'] = 'Przeglądaj aktywność baza danych';
$string['data:viewallratings'] = 'Wyświetl wszystkie nie przeliczone oceny';
$string['data:viewalluserpresets'] = 'Przeglądaj wzorce wszystkich użytkowników';
$string['data:viewanyrating'] = 'Wyświetl całkowite oceny, które ktoś otrzymał';
$string['data:viewentry'] = 'Zobacz wpisy';
$string['data:viewrating'] = 'Wyświetl całkowitą otrzymaną ocenę';
$string['data:writeentry'] = 'Napisz wpisy';
$string['date'] = 'Data';
$string['dateentered'] = 'Data utworzenia';
$string['datemodified'] = 'Ostatnio edytowane:';
$string['defaultfielddelimiter'] = '(domyślnie jest przecinek)';
$string['defaultfieldenclosure'] = '(domyślnie jest puste)';
$string['defaultsortfield'] = 'Domyślne pole sortowania';
$string['delcheck'] = 'Opcja masowego usuwania';
$string['delete'] = 'Usuń';
$string['deleteallentries'] = 'Wszystkie wpisy';
$string['deletecomment'] = 'Na pewno usunąć ten komentarz?';
$string['deleteconfirm'] = 'Usunąć wzorzec {$a}?\'';
$string['deleted'] = 'Usunięto';
$string['deleteentry'] = 'Usuń wpis';
$string['deletefield'] = 'Usuń pole';
$string['deletenotenrolled'] = 'Wpisy niezapisanych użytkowników';
$string['deletewarning'] = 'Usunięcie wzorca spowoduje jego usunięcie z listy dostępnych wzorców we wszystkich kursach.';
$string['descending'] = 'Malejąco';
$string['directorynotapreset'] = 'Brak {$a->directory}, brakuje plików {$a->missing_files}';
$string['disapprove'] = 'Cofnij zatwierdzenie';
$string['download'] = 'Ściągnij';
$string['duedate'] = 'Termin';
$string['edit'] = 'Edytuj';
$string['editcomment'] = 'Edytuj komentarz';
$string['editentry'] = 'Edytuj wpis';
$string['editfield'] = 'Edytuj pole';
$string['editordisable'] = 'Wyłącz edytor';
$string['editorenable'] = 'Włącz edytor kodu';
$string['editpreset'] = 'Edytuj wzorzec';
$string['emptyadd'] = 'Dodany szablon jest pusty, generowanie domyślnego ...';
$string['emptyaddform'] = 'Nie wypełniono wszystkich pól';
$string['emptypresetname'] = 'Nazwa wzorca oraz nazwa pliku nie mogą być puste';
$string['enabletemplateeditorcheck'] = 'Czy na pewno włączyć edytor? Może to spowodować modyfikację zawartości podczas zapisu szablonu.';
$string['entries'] = 'Wpisy';
$string['entrieslefttoadd'] = 'Musisz dodać {$a->entriesleft} więcej wpisów, aby ukończyć tę aktywność.';
$string['entrieslefttoaddtoview'] = 'Musisz dodać {$a->entrieslefttoview} więcej wpisów, aby móc wyświetlać wpisy innych użytkowników.';
$string['entry'] = 'Wpis';
$string['entrysaved'] = 'Wpis został zapisany';
$string['errordatafilenotfound'] = 'Nie można zaimportować pliku. Akceptowane typy plików to CSV lub ZIP zawierający plik CSV w formacie używanym do eksportowania wpisów.';
$string['errormustbeteacher'] = 'Musisz być nauczycielem, aby wejść na tę stronę!';
$string['errormustsupplyvalue'] = 'Musisz podać wartość tutaj.';
$string['errorpresetexists'] = 'Istnieje już wzorzec o wskazanej nazwie';
$string['errorpresetexistsbutnotoverwrite'] = 'Wzorzec o tej nazwie już istnieje. Wybierz inną nazwę.';
$string['errorpresetnotfound'] = 'Wzorzec o nazwie {$a} nie został odnaleziony.';
$string['eventfieldcreated'] = 'Pole utworzone';
$string['eventfielddeleted'] = 'Pole usunięte';
$string['eventfieldupdated'] = 'Pole zaktualizowane';
$string['eventrecordcreated'] = 'Wpis utworzony';
$string['eventrecorddeleted'] = 'Wpis usunięty';
$string['eventrecordupdated'] = 'Wpis zaktualizowany';
$string['eventtemplateupdated'] = 'Szablon zaktualizowany';
$string['eventtemplateviewed'] = 'Szablony wyświetlone';
$string['example'] = 'Przykładowy moduł bazy danych';
$string['excel'] = 'Excel';
$string['expired'] = 'Niestety, ta aktywność została zamknięta {$a} i nie jest już dłużej dostępna';
$string['export'] = 'Eksportuj';
$string['exportaszip'] = 'Eksportuj jako zip';
$string['exportaszip_help'] = 'Ta funkcja umożliwia zapisywanie szablonów i pól w postaci wzorców w formacie zip do pobrania. Plik zip można następnie zaimportować do innego przedmiotu.';
$string['exportedtozip'] = 'Eksport jako tymczasowy plik zip...';
$string['exportentries'] = 'Eksportuj wpisy';
$string['exportformat'] = 'Format eksportu';
$string['exportoptions'] = 'Opcje eksportu';
$string['exportownentries'] = 'Eksport tylko własnych wpisów? ({$a->mine}/{$a->all})';
$string['exportpreset'] = 'Eksportuj wzorzec';
$string['failedpresetdelete'] = 'Wystąpił błąd przy próbie usunięcia wzorca.';
$string['fieldadded'] = 'Dodano pole';
$string['fieldallowautolink'] = 'Pozwól na autolinkowanie';
$string['fielddeleted'] = 'Usunięto pole';
$string['fielddelimiter'] = 'Separator pola';
$string['fielddescription'] = 'Opis pola';
$string['fieldenclosure'] = 'Ogranicznik pola';
$string['fieldheight'] = 'Wysokość';
$string['fieldheightlistview'] = 'Wysokość (w pikselach) w widoku listy';
$string['fieldheightsingleview'] = 'Wysokość (w pikselach) w pojedynczym widoku';
$string['fieldmappings'] = 'Mapowanie pól';
$string['fieldmappings_help'] = 'To menu pozwala na przeniesienie danych z istniejącej bazy danych. Aby zachować dane z pola, należy zamapować je na nowe pole, do którego dane zostaną przeniesione. Każde pole może pozostać puste, wtedy dane nie będą do niego kopiowane. Stare pole nie zamapowane na nowe zostanie utracone wraz z danymi. Można mapować tylko pola tego samego typu, zatem każda lista będzie miała inne pola do wyboru. Ponadto należy uważać, aby nie spróbować zamapować jednego starego pola na więcej niż jedno nowe pole.';
$string['fieldname'] = 'Nazwa pola';
$string['fieldnametype'] = '{$a->name} ({$a->type})';
$string['fieldnotmatched'] = 'Następujące pola w twoim pliku nie są znane w tej bazie danych: {$a}';
$string['fieldoptions'] = 'Opcje (jedno w linii)';
$string['fields'] = 'Pola';
$string['fieldshelp'] = 'Utwórz pola, aby zbierać różne typy danych. Pola określają strukturę wpisów w bazie danych.';
$string['fieldsinformationtags'] = 'Szczegóły pola';
$string['fieldsnavigation'] = 'Pola: nawigacja trzeciego poziomu';
$string['fieldtagdescription'] = '{$a} - opis';
$string['fieldtagid'] = '{$a} - ID';
$string['fieldtagname'] = '{$a} - nazwa';
$string['fieldupdated'] = 'Uaktualniono pola';
$string['fieldwidth'] = 'Szerokość';
$string['fieldwidthlistview'] = 'Szerokość (w pikselach) w widoku listy';
$string['fieldwidthsingleview'] = 'Szerokość (w pikselach) w pojedynczym widoku';
$string['file'] = 'Plik';
$string['fileencoding'] = 'Wpis zaktualizowany';
$string['filesnotgenerated'] = 'Nie wszystkie pliki zostały wygenerowane: {$a}';
$string['filtername'] = 'Autolinkowanie treści bazy danych';
$string['footer'] = 'Stopka';
$string['forcelinkname'] = 'Wymuszaj nazywanie linków';
$string['foundnorecords'] = 'Nie znaleziono wpisów (<a href="{$a->reseturl}">Wyczyść filtry</a>)';
$string['foundrecords'] = 'Znalezione wpisy: {$a->num} z {$a->max} (<a href="{$a->reseturl}">Wyczyść filtry</a>)';
$string['fromfile'] = 'Importuj z pliku zip';
$string['fromfile_help'] = 'Ta funkcja pozwala na przeglądanie i ładowanie plików zip z szablonami i polami.';
$string['generateerror'] = 'Nie wszystkie pliki wygenerowano!';
$string['header'] = 'Nagłówek';
$string['headeraddtemplate'] = 'Zdefiniuj interfejs do dodawania lub edytowania wpisów.';
$string['headerasearchtemplate'] = 'Zdefiniuj interfejs dla wyszukiwania zaawansowanego.';
$string['headercsstemplate'] = 'Zdefiniuj własne style CSS dla szablonów.';
$string['headerjstemplate'] = 'Zdefiniuj własny JavaScript dla szablonów Listy, Pojedynczego oraz Dodawania wpisów.';
$string['headerlisttemplate'] = 'Zdefiniuj wygląd widoku Listy wpisów.';
$string['headerrsstemplate'] = 'Zdefiniuj wygląd wpisów dla kanału RSS.';
$string['headersingletemplate'] = 'Zdefiniuj wygląd widoku Pojedynczego wpisu.';
$string['id'] = 'ID wpisu';
$string['importandapply'] = 'Importuj i zastosuj wzorzec';
$string['importapreset'] = 'Zaimportuj wzorzec';
$string['importentries'] = 'Importuj wpisy';
$string['importpreset'] = 'Importuj wzorzec';
$string['importpreset_desc'] = 'Wzorzec zostanie zastosowany do tej aktywności, tworząc pola i szablony. Nie pojawi się na liście wzorców tej witryny.';
$string['importpresetmissingcapability'] = 'Brak uprawnień do importowania wzorców.';
$string['importsuccess'] = 'Wzorzec został skutecznie zastosowany.';
$string['includeapproval'] = 'Uwzględnij status zatwierdzenia wpisu';
$string['includefiles'] = 'Uwzględnij pola przy eksporcie';
$string['includetags'] = 'Uwzględnij tagi';
$string['includetime'] = 'Uwzględnij czas dodania / modyfikacji';
$string['includeuserdetails'] = 'Uwzględnij dane użytkownika';
$string['indicator:cognitivedepth'] = 'Poznawczość Bazy danych';
$string['indicator:cognitivedepth_help'] = 'Ten wskaźnik opiera się na głębi poznawczej osiągniętej przez studenta podczas korzystania z aktywności Bazy danych.';
$string['indicator:cognitivedepthdef'] = 'Poznawczość Bazy danych';
$string['indicator:cognitivedepthdef_help'] = 'Uczestnik osiągnął określony procent zaangażowania poznawczego oferowanego przez aktywność Bazy danych w tym okresie analizy (Poziomy = Brak wyświetlenia, Wyświetlenie, Wysłanie)';
$string['indicator:cognitivedepthdef_link'] = 'Learning_analytics_indicators#Cognitive_depth';
$string['indicator:socialbreadth_help'] = 'Wskaźnik ten opiera się na poziomie kompetencji społecznych osiągniętych przez studenta w ramach aktywności związanej z bazą danych.';
$string['indicator:socialbreadthdef_link'] = 'Learning_analytics_indicators#Social_breadth';
$string['insufficiententries'] = 'potrzebujesz większej liczby wpisów, aby oglądać tę bazę danych';
$string['intro'] = 'Opis';
$string['invalidaccess'] = 'Dostęp do tej strony nie był prawidłowy';
$string['invalidfieldid'] = 'ID pola jest niepoprawne';
$string['invalidfieldname'] = 'Proszę wybrać inna nazwę do tego pola';
$string['invalidfieldtype'] = 'Typ pola jest niepoprawny';
$string['invalidid'] = 'Nieprawidłowe ID danych';
$string['invalidpreset'] = '{$a} nie zawiera poprawnego wzorca.';
$string['invalidrecord'] = 'Niepoprawny wpis.';
$string['invalidurl'] = 'Wprowadzony adres URL nie jest poprawny';
$string['jstemplate'] = 'Szablon JavaScript';
$string['latitude'] = 'Szerokość geogr.';
$string['latlong'] = 'Koordynaty';
$string['latlongboth'] = 'Wymagana jest zarówno szerokość jak i długość geograficzna.';
$string['latlongdownloadallhint'] = 'Link pobierania wszystkich wpisów jako KML';
$string['latlongkmllabelling'] = 'Jak oznaczyć wpisy w plikach KML (Google Earth)';
$string['latlonglinkservicesdisplayed'] = 'Serwisy dostarczające linki zewnętrzne do wyświetlenia';
$string['latlongotherfields'] = 'Inne pola';
$string['list'] = 'Podgląd listy';
$string['listtemplate'] = 'Szablon listy';
$string['listview'] = 'Widok listy';
$string['longitude'] = 'Długość geogr.';
$string['manageapproved'] = 'Zezwalaj na edycję zatwierdzonych wpisów';
$string['manageapproved_help'] = 'Jeśli wyłączone, zatwierdzone wpisy nie mogą być edytowane ani usuwane przez użytkownika, który je dodał. To ustawienie ma efekt tylko po włączeniu opcji "Wymagane zatwierdzenie".';
$string['managefields'] = 'Zarządzaj polami';
$string['mapexistingfield'] = 'Mapuj do: {$a}';
$string['mapnewfield'] = 'Utwórz nowe pole';
$string['mapping:applypresets'] = 'Zastosuj wzorzec';
$string['mapping:dialogtitle:usepreset'] = 'Zastosować wzorzec {$a}?';
$string['mapping:fieldstocreate'] = 'Pola do utworzenia: {$a}';
$string['mapping:fieldstodelete'] = 'Istniejące pola do usunięcia: {$a}';
$string['mapping:mapfields'] = 'Mapowanie pól';
$string['mapping:warningmessagedelete'] = 'Jeśli pola do usunięcia są tego samego typu, co nowe pola w stosowanym wzorcu, można je zmapować przez Mapowanie pól.';
$string['mapping:warningmessagedeleteandcreate'] = 'Jeśli pola do usunięcia są tego samego typu co pola, które mają zostać utworzone, można je zmapować przez Mapowanie pól.';
$string['mappingwarning'] = 'Wszystkie stare pola nie mapowane do nowego pola zostaną utracone, a dane z tych pól zostaną usunięte.';
$string['maxentries'] = 'Maksymalna liczba wpisów';
$string['maxentries_help'] = 'Maksymalna liczba wpisów, które student może przesłać w ramach tej aktywności.';
$string['maxsize'] = 'Maksymalny rozmiar';
$string['menu'] = 'Lista rozwijana';
$string['menuchoose'] = 'Wybierz...';
$string['missingdata'] = 'ID danych lub obiekt musi być podany dla klasy pola.';
$string['missingfield'] = 'Błąd programisty: Musisz określić pola i/lub dane, gdy definiujesz pole klasy.';
$string['missingfieldtype'] = 'Nie znaleziono typu pola dla {$a->name}';
$string['missingfieldtypeimport'] = 'Następujące pola nie zostały zaimportowane, ponieważ odpowiadające im typy pól nie są zainstalowane:';
$string['missingfieldtypes'] = 'Następujące pola nie mają zainstalowanych odpowiadających im typów pól i nie zostaną uwzględnione w formularzu Dodaj wpis. Należy sprawdzić Szablon dodawania i usunąć wszelkie takie nazwy pól.';
$string['modulename'] = 'Baza Danych';
$string['modulename_help'] = 'Moduł aktywności bazy danych umożliwia uczestnikom tworzenie, utrzymywanie i przeszukiwanie zbioru wpisów. Struktura wpisów jest definiowana za pomocą różnych typów pól, takich jak krótki tekst, lista rozwijana, pole tekstowe, adres URL, obraz lub przesyłany plik.

Wizualny układ informacji podczas wyświetlania, przeglądania lub edycji wpisów bazy danych może być kontrolowany przez szablony bazy danych. Bazy danych mogą być współdzielone między przedmiotami jako wzorce, a nauczyciel może również importować i eksportować wpisy bazy danych.

Nauczyciel może komentować i oceniać wpisy, może także zezwolić studentom na ocenianie i komentowanie wpisów (ocena rówieśnicza). Oceny rówieśnicze można agregować, tworząc ostateczną ocenę, która jest zapisywana w dzienniku ocen.

Jeśli włączony jest filtr autolinkowania treści bazy danych, wszystkie wpisy w bazie danych będą automatycznie linkowane do miejsc, gdzie w kursie pojawiają się słowa lub frazy.

Aktywności bazy danych można używać do:

* Tworzenia wspólnej kolekcji linków internetowych, książek, recenzji książek, odniesień do czasopism, itp.
* Wyświetlania stworzonych przez studentów zdjęć, plakatów, stron internetowych lub wierszy do komentowania i recenzowania.';
$string['modulename_link'] = 'mod/data/view';
$string['modulenameplural'] = 'Bazy danych';
$string['more'] = 'Więcej';
$string['moreurl'] = 'Więcej URL';
$string['movezipfailed'] = 'Nie można przenieść pliku zip';
$string['multientry'] = 'Powtórzony wpis';
$string['multimenu'] = 'Lista wielokrotnego wyboru';
$string['multipletags'] = 'Znalezione wielokrotne wystąpienia znaczników! Szablon nie został zapisany.';
$string['myentries'] = 'Moje wpisy';
$string['newentry'] = 'Nowy wpis';
$string['newfield'] = 'Utwórz pole';
$string['newfield_help'] = 'Pole umożliwia wprowadzanie danych. Każdy wpis w bazie danych może mieć wiele pól różnych typów, takich jak pole daty pozwalające uczestnikom wybrać dzień, miesiąc i rok z menu rozwijanego, pole obrazu pozwalające przesłać plik z obrazem, lub pole wyboru pozwalające wybrać jedną lub więcej opcji.

Każde pole musi mieć unikalną nazwę. Opis pola jest opcjonalny.';
$string['noaccess'] = 'Nie masz praw dostępu do tej strony';
$string['nodefinedfields'] = 'Nowy wzorzec nie ma zdefiniowanych pól!';
$string['nofieldcontent'] = 'Zawartość pola nie znaleziona';
$string['nofieldindatabase'] = 'Nie ma żadnych zdefiniowanych pól w tej bazie danych.';
$string['nofields'] = 'Nie ma jeszcze pól';
$string['nolisttemplate'] = 'Szablon widoku listy nie został jeszcze zdefiniowany';
$string['nomatch'] = 'Żaden wpis nie został znaleziony.';
$string['nomaximum'] = 'Brak maksimum';
$string['nopreviewavailable'] = 'Brak podglądu dla {$a}';
$string['norecords'] = 'Nie ma jeszcze wpisów';
$string['notapproved'] = 'Oczekiwanie na zatwierdzenie.';
$string['notapprovederror'] = 'Wpis nie jest jeszcze zatwierdzony.';
$string['notemplates'] = 'Nie ma jeszcze szablonów';
$string['notinjectivemap'] = 'To nie jest injekcja (jeden do jeden)';
$string['notopenyet'] = 'Niestety, ta aktywność jest niedostępna aż do {$a}';
$string['number'] = 'Liczba';
$string['numberofentriestoapprove'] = 'Wpisy do zatwierdzenia: {$a}.';
$string['numberrssarticles'] = 'Wpisy w RSS';
$string['numnotapproved'] = 'Oczekuje';
$string['numrecords'] = '{$a} wpisów';
$string['ods'] = '<abbr title="Arkusz kalkulacyjny OpenDocument">ODS</abbr> (OpenOffice)';
$string['openafterclose'] = 'Podano datę otwarcia późniejszą niż data zamknięcia';
$string['optionaldescription'] = 'Krótki opis (opcjonalnie)';
$string['optionalfilename'] = 'Nazwa pliku (opcjonalnie)';
$string['other'] = 'Inne';
$string['otherfields'] = 'Wszystkie inne pola';
$string['overrwritedesc'] = 'Zastąp, jeżeli już istnieje';
$string['overwrite'] = 'Nadpisanie';
$string['overwritesettings'] = 'Nadpisz bieżące ustawienia takie jak komentarze, oceny, itp.';
$string['page-mod-data-x'] = 'Dowolna strona bazy danych';
$string['pagesize'] = 'Wpisów na stronę';
$string['participants'] = 'Uczestnicy';
$string['picture'] = 'Obraz';
$string['pluginadministration'] = 'Administracja aktywnością Baza Danych';
$string['pluginname'] = 'Baza Danych';
$string['portfolionotfile'] = 'Eksportuj do portfolio zamiast do pliku (tylko csv i leap2a)';
$string['presetdeleted'] = 'Wzorzec został usunięty.';
$string['presetinfo'] = 'Zapisanie jako wzorzec opublikuje ten szablon. Inni użytkownicy mogą wykorzystać go w swoich bazach danych.';
$string['presetnotselected'] = 'Nie wybrano żadnego wzorca.';
$string['presets'] = 'Wzorce';
$string['presetshelp'] = 'Wybierz wzorzec do użycia jako punkt wyjścia.';
$string['preview'] = 'Podgląd {$a}';
$string['previewaction'] = 'Podgląd';
$string['privacy:metadata:commentpurpose'] = 'Komentarze do wpisów bazy danych';
$string['privacy:metadata:data_content'] = 'Zawartość pola';
$string['privacy:metadata:data_content:content'] = 'Zawartość';
$string['privacy:metadata:data_content:content1'] = 'Dodatkowa zawartość 1';
$string['privacy:metadata:data_content:content2'] = 'Dodatkowa zawartość 2';
$string['privacy:metadata:data_content:content3'] = 'Dodatkowa zawartość 3';
$string['privacy:metadata:data_content:content4'] = 'Dodatkowa zawartość 4';
$string['privacy:metadata:data_content:fieldid'] = 'Identyfikator definicji pola';
$string['privacy:metadata:data_records'] = 'Wpisy w module aktywności bazy danych';
$string['privacy:metadata:data_records:approved'] = 'Status zatwierdzenia';
$string['privacy:metadata:data_records:groupid'] = 'Grupa';
$string['privacy:metadata:data_records:timecreated'] = 'Czas utworzenia wpisu';
$string['privacy:metadata:data_records:timemodified'] = 'Czas ostatniej modyfikacji wpisu';
$string['privacy:metadata:data_records:userid'] = 'Użytkownik, który utworzył wpis';
$string['privacy:metadata:datafieldnpluginsummary'] = 'Pola dla modułu aktywności bazy danych';
$string['privacy:metadata:filepurpose'] = 'Plik załączony do wpisu bazy danych';
$string['privacy:metadata:ratingpurpose'] = 'Oceny we wpisach bazy danych';
$string['privacy:metadata:tagpurpose'] = 'Tagi we wpisach bazy danych';
$string['radiobutton'] = 'Pole wyboru (radio buttons)';
$string['recordapproved'] = 'Wpis zatwierdzony';
$string['recorddeleted'] = 'Wpis usunięty';
$string['recorddisapproved'] = 'Wpis niezatwierdzony';
$string['recordsnotsaved'] = 'Żaden wpis nie został zapisany. Sprawdź format pobieranego pliku.';
$string['recordssaved'] = 'Wpisy zapisano';
$string['removealldatatags'] = 'Wszystkie bazy danych tagów';
$string['requireapproval'] = 'Wymagane zatwierdzenie';
$string['requireapproval_help'] = 'Jeśli ta opcja jest włączona, wpisy wymagają zatwierdzenia przez nauczyciela, zanim będą widoczne dla wszystkich.';
$string['required'] = 'Wymagane';
$string['requiredentries'] = 'Wpisy wymagające uzupełnienia (stare)';
$string['requiredentries_help'] = 'Jeśli ta opcja jest włączona, wyświetlany jest komunikat określający liczbę wpisów wymaganych do ukończenia. Zauważ, że to ustawienie nie jest powiązane z kończeniem aktywności.

W przypadku wpisów wymaganych do ukończenia aktywności należy użyć nowego ustawienia "Wymagane wpisy". Aby całkowicie usunąć to ustawienie, ustaw na brak, a następnie zapisz zmiany.
Zamiast tego użyj pól "Wymagane wpisy" w sekcji kończenia aktywności.';
$string['requiredentriestoview'] = 'Wpisy wymagane przed przeglądaniem';
$string['requiredentriestoview_help'] = 'Liczba wpisów, które student musi przesłać zanim będzie mógł przeglądać wpisy innych studentów.

Uwaga: Jeśli wpisy są wymagane przed wyświetleniem, filtr autolinkowania treści bazy danych powinien być wyłączony. Dzieje się tak, ponieważ sam filtr autolinkowania treści bazy danych nie może określić, czy użytkownik przesłał wymaganą liczbę wpisów.';
$string['requiredentrieswarning'] = 'To ustawienie zostało zastąpione przez ustawienie kończenia aktywności "Wymagane wpisy"';
$string['requiredfield'] = 'Pole wymagane';
$string['resetalltemplates'] = 'Resetuj wszystkie szablony';
$string['resetalltemplatesconfirm'] = 'Zamierzasz usunąć wszystkie szablony z bieżącego wzorca. Jeśli chcesz później przywrócić szablony, musisz wybrać wzorzec ponownie na karcie "Wzorce".';
$string['resetalltemplatesconfirmtitle'] = 'Zresetować wszystkie szablony?';
$string['resetsettings'] = 'Resetuj filtry';
$string['resettemplate'] = 'Resetuj bieżący szablon';
$string['resettemplateconfirm'] = 'Spowoduje to trwałe usunięcie {$a} z bieżącego wzorca.';
$string['resettemplateconfirmtitle'] = 'Zresetować szablon?';
$string['resizingimages'] = 'Zmienianie rozmiarów miniaturek...';
$string['rows'] = 'wiersze';
$string['rssglobaldisabled'] = 'Wyłączone. Sprawdź zmienne w konfiguracji witryny.';
$string['rsstemplate'] = 'Szablon RSS';
$string['rsstitletemplate'] = 'Tytuł szablonu RSS';
$string['rsstype'] = 'Kanał RSS dla tej aktywności';
$string['save'] = 'Zapisz';
$string['saveandadd'] = 'Zapisz i dodaj następny';
$string['saveandview'] = 'Zapisz i pokaż';
$string['saveaspreset'] = 'Publikuj jako wzorzec na tej witrynie';
$string['saveaspreset_help'] = 'Funkcja publikuje szablony i pola jako wzorzec, który inni użytkownicy tej witryny mogą wykorzystywać. (Można go usunąć z listy wzorców w dowolnym momencie.)';
$string['saveaspresetmissingcapability'] = 'Użytkownik nie ma uprawnień do zapisania bazy danych jako wzorca.';
$string['savedataaspreset'] = 'Zapisz wszystkie pola i szablony i opublikuj je jako wzorzec na tej witrynie';
$string['savesettings'] = 'Zapisz ustawienia';
$string['savesuccess'] = 'Zapisano wzorzec. <a href="{$a->url}">Pokaż podgląd wzorca</a>';
$string['search'] = 'Szukaj';
$string['search:activity'] = 'Baza danych - informacje o aktywności';
$string['search:entry'] = 'Baza danych - wpisy';
$string['searchresults'] = 'Wpisy zawierające „{$a}”';
$string['selectedrequired'] = 'Wszystkie zaznaczone są wymagane';
$string['selectexportoptions'] = 'Wybierz opcje eksportu';
$string['selectfields'] = 'Wybierz pola';
$string['selectfordeletion'] = 'Wybierz wpis do usunięcia';
$string['showall'] = 'Pokaż wszystkie wpisy';
$string['showmore'] = 'Pokaż więcej';
$string['single'] = 'Pokaż pojedynczo';
$string['singletemplate'] = 'Pojedynczy szablon';
$string['singleview'] = 'Widok pojedynczy';
$string['startbuilding'] = 'Zacznij budować tę aktywność';
$string['subplugintype_datafield'] = 'Typ pola bazy danych';
$string['subplugintype_datafield_plural'] = 'Typy pól bazy danych';
$string['subplugintype_datapreset'] = 'Wzorzec';
$string['subplugintype_datapreset_plural'] = 'Wzorce';
$string['tagarea_data_records'] = 'Wpisy bazy danych';
$string['tags'] = 'Tagi';
$string['tagsdeleted'] = 'Tagi bazy danych zostały usunięte';
$string['teachersandstudents'] = '{$a->teachers} i {$a->students}';
$string['templatereset'] = 'Resetowanie szablonu';
$string['templateresetall'] = 'Resetowanie wszystkich szablonów';
$string['templates'] = 'Szablony';
$string['templatesaved'] = 'Szablon zachowany';
$string['templatesnavigation'] = 'Szablony: nawigacja trzeciego poziomu';
$string['text'] = 'Krótki tekst';
$string['textarea'] = 'Obszar tekstowy';
$string['timeadded'] = 'Czas dodania';
$string['timemodified'] = 'Czas modyfikacji';
$string['totalentries'] = 'Wszystkie wpisy';
$string['type'] = 'Typ pola';
$string['unknown'] = 'Nieznane pole';
$string['unsupportedfields'] = 'Nieobsługiwane pola';
$string['unsupportedfieldslist'] = 'Nie można wyeksportować następujących pól:';
$string['updatefield'] = 'Uaktualnij istniejące pola';
$string['uploadfile'] = 'Prześlij plik';
$string['uploadrecords'] = 'Prześlij wpisy z pliku';
$string['uploadrecords_help'] = 'Wpisy mogą być importowane poprzez plik tekstowy. Jego format powinien być następujący:

* Każda linia zawiera jeden rekord
* Każdy rekord jest serią danych rozdzielonych przecinkami (lub innymi znakami rozdzielającymi)
* Pierwszy rekord zawiera listę nazw pól określających format reszty pliku

Ogranicznik pola to znak, który otacza zawartość każdego pola w każdym rekordzie. Zwykle może nie być określony.';
$string['uploadrecords_link'] = 'mod/data/import';
$string['url'] = 'Adres URL';
$string['usedate'] = 'Uwzględnij w wyszukiwaniu.';
$string['usepredefinedset'] = 'Użyj wzorca';
$string['usepreset'] = 'Użyj tego wzorca';
$string['usestandard'] = 'Wykorzystaj wzorzec';
$string['usestandard_help'] = 'Aby użyć wzorca dostępnego na całej witrynie, wybierz go z listy. (Jeśli wzorzec został dodany do tej listy za pomocą funkcji Publikuj jako wzorzec, można go również usunąć.)';
$string['viewentries'] = 'Wyświetl wpisy';
$string['viewfromdate'] = 'Tylko do podglądu od';
$string['viewnavigation'] = 'Przeglądanie: nawigacja trzeciego poziomu';
$string['viewtemplates'] = 'Widok szablonów';
$string['viewtodate'] = 'Tylko do podglądu do';
$string['viewtodatevalidation'] = 'Końcowa data tylko do podglądu nie może poprzedzać początkowej daty tylko do podglądu.';
$string['wrongdataid'] = 'Podany niepoprawny ID danych';
