<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'competency', language 'pl', version '5.1'.
 *
 * @package     competency
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['allchildrenarecomplete'] = 'Wszystkie podrzędne są ukończone';
$string['competencies'] = 'Kompetencje';
$string['competenciesarenotenabled'] = 'Kompetencje nie są włączone';
$string['competenciessettings'] = 'Ustawienia kompetencji';
$string['competency'] = 'Kompetencja';
$string['competencyframework'] = 'Struktura kompetencji';
$string['completeplanstask'] = 'Ukończ wymagane plany nauki';
$string['coursecompetencyoutcome_complete'] = 'Ukończ kompetencję';
$string['coursecompetencyoutcome_evidence'] = 'Dołącz dokumentację';
$string['coursecompetencyoutcome_none'] = 'Nic nie rób';
$string['coursecompetencyoutcome_recommend'] = 'Wyślij do przeglądu';
$string['coursemodulecompetencyoutcome_complete'] = 'Ukończ kompetencję';
$string['coursemodulecompetencyoutcome_evidence'] = 'Dołącz dokumentację';
$string['coursemodulecompetencyoutcome_none'] = 'Nic nie rób';
$string['coursemodulecompetencyoutcome_recommend'] = 'Wyślij do przeglądu';
$string['deletecompetencyratings'] = 'Oceny kompetencji';
$string['duplicateditemname'] = '{$a} (kopia)';
$string['enablecompetencies'] = 'Włącz kompetencje';
$string['enablecompetencies_desc'] = 'Kompetencje pozwalają oceniać użytkowników według planów uczenia się.';
$string['errorcannotchangeapastduedate'] = 'Termin oddania minął; nie możesz tego zmienić';
$string['errorcannotsetduedateinthepast'] = 'Termin oddania nie może być przeszły.';
$string['errorcannotsetduedatetoosoon'] = 'Termin oddania jest zbyt bliski.';
$string['errorcompetencyrule'] = 'Nieznana reguła kompetencji kursu \'{$a}\'';
$string['errorcoursecompetencyrule'] = 'Nieznana reguła kompetencji kursu \'{$a}\'';
$string['errorinvalidcourse'] = 'Niepoprawny kurs.';
$string['errornocompetency'] = 'Nie można znaleźć {$a} kompetencji';
$string['errorplanstatus'] = 'Nieznany status planów nauki \'{$a}\'';
$string['errorscalealreadyused'] = 'Skala nie może być zmieniona, jest już w użyciu.';
$string['errorusercomptencystatus'] = 'Nieznany status kompetencji użytkownika \'{$a}\'';
$string['eventcompetencycreated'] = 'Utworzono kompetencję.';
$string['eventcompetencydeleted'] = 'Usunięto kompetencję.';
$string['eventcompetencyframeworkcreated'] = 'Ramy kwalifikacji utworzono.';
$string['eventcompetencyframeworkdeleted'] = 'Ramy kwalifikacji usunięto.';
$string['eventcompetencyframeworkupdated'] = 'Ramy kwalifikacji zaktualizowano.';
$string['eventcompetencyframeworkviewed'] = 'Ramy kwalifikacji wyświetlono.';
$string['eventcompetencyupdated'] = 'Zaktualizowano kompetencję.';
$string['eventcompetencyviewed'] = 'Przegląd kompetencji.';
$string['eventevidencecreated'] = 'Utworzono dokumentację.';
$string['eventplanapproved'] = 'Zatwierdzono plan nauki.';
$string['eventplancompleted'] = 'Ukończono plan nauki.';
$string['eventplancreated'] = 'Utworzono plan nauki.';
$string['eventplandeleted'] = 'Usunięto plan nauki.';
$string['eventplanreopened'] = 'Plan nauki został ponownie otwarty.';
$string['eventplanreviewrequestcancelled'] = 'Żądanie przeglądu planu nauki zostało anulowane.';
$string['eventplanreviewrequested'] = 'Zażądano przeglądu planu nauki.';
$string['eventplanreviewstarted'] = 'Żądanie przeglądu planu nauki zostało rozpoczęte.';
$string['eventplanreviewstopped'] = 'Żądanie przeglądu planu nauki zostało zatrzymane.';
$string['eventplanunapproved'] = 'Odrzucono plan nauki';
$string['eventplanunlinked'] = 'Odłączono plan nauki.';
$string['eventplanupdated'] = 'Zaktualizowano plan nauki.';
$string['eventplanviewed'] = 'Wyświetlono plan nauki.';
$string['eventtemplatecreated'] = 'Utworzono szablon planu nauki.';
$string['eventtemplatedeleted'] = 'Usunięto szablon planu nauki.';
$string['eventtemplateupdated'] = 'Zaktualizowano szablon planu nauki.';
$string['eventtemplateviewed'] = 'Wyświetlono szablon planu nauki.';
$string['eventusercompetencyplanviewed'] = 'Wyświetlono plan kompetencji użytkownika.';
$string['eventusercompetencyratedinplan'] = 'Kompetencje użytkownika w planie nauki zostały ocenione.';
$string['eventusercompetencyviewedinplan'] = 'Kompetencje użytkownika w planie nauki zostały wyświetlone.';
$string['eventuserevidencecreated'] = 'Dokumentacja wcześniejszej nauki została utworzona.';
$string['eventuserevidencedeleted'] = 'Dokumentacja wcześniejszej nauki została usunięta.';
$string['eventuserevidenceupdated'] = 'Dokumentacja wcześniejszej nauki została zaktualizowana.';
$string['evidence_competencyrule'] = 'Zasada kompetencji została spełniona.';
$string['evidence_coursecompleted'] = 'Kurs \'{$a}\' został ukończony.';
$string['evidence_coursemodulecompleted'] = 'Aktywność \'{$a}\' została ukończona.';
$string['evidence_courserestored'] = 'Ocena została przywrócona wraz z kursem \'{$a}\'.';
$string['evidence_evidenceofpriorlearninglinked'] = 'Dokumentacja wcześniejszej nauki \'{$a}\' została podłączona.';
$string['evidence_evidenceofpriorlearningunlinked'] = 'Dokumentacja wcześniejszej nauki \'{$a}\' została odłączona.';
$string['evidence_manualoverride'] = 'Ocena kompetencji została ustawiona ręcznie.';
$string['evidence_manualoverrideincourse'] = 'Ocena kompetencji została ustawiona ręcznie dla kursu \'{$a}\'.';
$string['evidence_manualoverrideinplan'] = 'Ocena kompetencji została ustawiona ręcznie dla planu uczenia się \'{$a}\'.';
$string['invalidevidencedesc'] = 'Niepoprawny opis dokumentacji';
$string['invalidgrade'] = 'Nieprawidłowa ocena';
$string['invalidplan'] = 'Niepoprawny plan nauki';
$string['invalidtaxonomy'] = 'Nieprawidłowa taksonomia: {$a}';
$string['invalidurl'] = 'Adres URL jest nieprawidłowy. Upewnij się, że zaczyna się od \'http: //\' lub \'https: //\'.';
$string['nouserplanswithcompetency'] = 'Żaden plan uczenia się nie zawiera tej kompetencji.';
$string['planstatusactive'] = 'Aktywne';
$string['planstatuscomplete'] = 'Ukończone';
$string['planstatusdraft'] = 'Szkic';
$string['planstatusinreview'] = 'W trakcie przeglądu';
$string['planstatuswaitingforreview'] = 'Oczekuje na przegląd';
$string['privacy:evidence:action:log'] = 'Zaloguj akcję';
$string['privacy:metadata:competency'] = 'Zapis kompetencji';
$string['privacy:metadata:competency_coursecomp'] = 'Zapis kompetencji powiązanych z kursem';
$string['privacy:metadata:competency_coursecompsetting'] = 'Zapis ustawień kompetencji w kursie';
$string['privacy:metadata:competency_evidence'] = 'Zapis dokumentacji wpływających na stan kompetencji';
$string['privacy:metadata:competency_framework'] = 'Zapis ustawień kompetencji w kursie';
$string['privacy:metadata:competency_modulecomp'] = 'Zapis kompetencji powiązanych z modułem';
$string['privacy:metadata:competency_plan'] = 'Zapis planów nauki';
$string['privacy:metadata:competency_plancomp'] = 'Zapis kompetencji w planie nauki';
$string['privacy:metadata:competency_relatedcomp'] = 'Zapis relacji między kompetencjami';
$string['privacy:metadata:competency_template'] = 'Zapis szablonów planów nauki';
$string['privacy:metadata:competency_templatecohort'] = 'Zapis kohort powiązanych z szablonem planu nauki';
$string['privacy:metadata:competency_templatecomp'] = 'Zapis kompetencji w szablonie planu nauki';
$string['privacy:metadata:competency_usercomp'] = 'Zapis stanu kompetencji użytkownika';
$string['privacy:metadata:competency_usercompcourse'] = 'Zapis stanu kompetencji użytkownika na kursie';
$string['privacy:metadata:competency_usercompplan'] = 'Zapis stanu kompetencji w planie nauki';
$string['privacy:metadata:competency_userevidence'] = 'Zapis dokumentacji wcześniejszego uczenia się';
$string['privacy:metadata:competency_userevidencecomp'] = 'Zapis kompetencji związanych z dokumentacją wcześniejszego uczenia się';
$string['privacy:metadata:core_comments'] = 'Komentarze dotyczące planów nauki i kompetencji';
$string['privacy:metadata:evidence:action'] = 'Rodzaj działania podjętego z dokumentacją';
$string['privacy:metadata:evidence:desca'] = 'Opcjonalne parametry możliwego do przetłumaczenia opisu dokumentacji';
$string['privacy:metadata:evidence:desccomponent'] = 'Składnik możliwego do przetłumaczenia opisu dokumentacji';
$string['privacy:metadata:evidence:descidentifier'] = 'Identyfikator możliwego do przetłumaczenia opisu dokumentacji';
$string['privacy:metadata:evidence:grade'] = 'Ocena związana z dokumentacją';
$string['privacy:metadata:evidence:note'] = 'Niezlokalizowana notatka dołączona do dokumentacji';
$string['privacy:metadata:evidence:url'] = 'Adres URL powiązany z dokumentacją';
$string['privacy:metadata:plan:description'] = 'Opis planu nauki';
$string['privacy:metadata:plan:duedate'] = 'Termin realizacji planu nauki';
$string['privacy:metadata:plan:name'] = 'Nazwa planu nauki';
$string['privacy:metadata:plan:reviewerid'] = 'Identyfikator recenzenta planu nauki';
$string['privacy:metadata:plan:status'] = 'Stan planu nauki';
$string['privacy:metadata:plan:userid'] = 'Identyfikator użytkownika, którego jest to plan nauki';
$string['privacy:metadata:timecreated'] = 'Czas utworzenia rekordu';
$string['privacy:metadata:usercomp:grade'] = 'Ocena wystawiona za kompetencję';
$string['privacy:metadata:usercomp:proficiency'] = 'Czy osiągnięto sprawność/biegłość';
$string['privacy:metadata:usercomp:status'] = 'Status kompetencji';
$string['privacy:metadata:userevidence:description'] = 'Opis dokumentacji';
$string['privacy:metadata:userevidence:name'] = 'Nazwa dokumentacji wcześniejszego uczenia się';
$string['privacy:metadata:userevidence:url'] = 'Adres URL powiązany z dokumentacją';
$string['privacy:metadata:usermodified'] = 'Użytkownik, który utworzył lub zmodyfikował rekord';
$string['privacy:path:plans'] = 'Plany nauki';
$string['privacy:path:relatedtome'] = 'Powiązane ze mną';
$string['privacy:path:userevidence'] = 'Dokumentacja wcześniejszego uczenia się';
$string['proficient'] = 'Biegły';
$string['pushcourseratingstouserplans'] = 'Przenieś oceny kursu do indywidualnych planów nauczania';
$string['pushcourseratingstouserplans_desc'] = 'Domyślna wartość dla ustawienia kursu, aby zaktualizować poszczególne plany uczenia się, gdy oceniane są kwalifikacje kursu';
$string['rating'] = 'Ocena';
$string['syncplanscohorts'] = 'Synchronizuj plany z szablonów planów nauki kohort';
$string['taxonomy_behaviour'] = 'Zachowanie';
$string['taxonomy_competency'] = 'Kompetencja';
$string['taxonomy_concept'] = 'Pojęcie';
$string['taxonomy_domain'] = 'Domena';
$string['taxonomy_indicator'] = 'Wskaźnik';
$string['taxonomy_level'] = 'Poziom';
$string['taxonomy_outcome'] = 'Wynik';
$string['taxonomy_practice'] = 'Praktyka';
$string['taxonomy_proficiency'] = 'Biegłość';
$string['taxonomy_skill'] = 'Umiejętność';
$string['taxonomy_value'] = 'Wartość';
$string['usercommentedonacompetency'] = '{$a->fullname} skomentował/a kompetencję "{$a->competency}":

{$a->comment}

Zobacz: {$a->url}';
$string['usercommentedonacompetencyhtml'] = '<p>{$a->fullname} skomentował/a kompetencję "{$a->competency}":</p>
<div>{$a->comment}</div>
<p>See: <a href="{$a->url}">{$a->urlname}</a>.</p>';
$string['usercommentedonacompetencysmall'] = '{$a->fullname} skomentował/a kompetencję "{$a->competency}".';
$string['usercommentedonaplan'] = '{$a->fullname} umieścił komentarz w planie nauczania "{$a->plan}":

{$a->comment}

Zobacz: {$a->url}';
$string['usercommentedonaplanhtml'] = '<p>{$a->fullname} umieścił komentarz w planie nauczania "{$a->plan}":</p>
<div>{$a->comment}</div>
<p>Zobacz: <a href="{$a->url}">{$a->urlname}</a>.</p>';
$string['usercommentedonaplansmall'] = '{$a->fullname} umieścił komentarz w planie nauki "{$a->plan}".';
$string['usercommentedonaplansubject'] = '{$a} umieścił komentarz w planie nauki.';
$string['usercompetency'] = 'Kompetencje użytkownika';
$string['usercompetencystatus_idle'] = 'Bezczynny';
$string['usercompetencystatus_inreview'] = 'W przeglądzie';
$string['usercompetencystatus_waitingforreview'] = 'Oczekuje na przegląd';
$string['userplans'] = 'Plany nauki';
