<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'qtype_stack', language 'nl', version '5.1'.
 *
 * @package     qtype_stack
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['ATAlgEquiv_SA_not_equation'] = 'Je antwoord moet een vergelijking zijn, maar het is er geen.';
$string['ATAlgEquiv_SA_not_expression'] = 'Je antwoord moet een expressie zijn, geen vergelijking, ongelijkheid, lijst, set of matrix.';
$string['ATAlgEquiv_SA_not_function'] = 'Je antwoord moet een functie zijn, bepaald door de operator  <tt>:=</tt>,  maar het is er geen.';
$string['ATAlgEquiv_SA_not_inequality'] = 'Je antwoord moet een ongelijkheid zijn, maar is het niet.';
$string['ATAlgEquiv_SA_not_list'] = 'Je antwoord moet een lijst zijn, maar is er geen. Merk op dat de syntax om een lijst in te geven een komma gescheiden reeks waarden is, die tussen vierkante haakjes staat.';
$string['ATAlgEquiv_SA_not_logic'] = 'Je antwoord moet een vergelijking, een ongelijkheid of een logische combinatie van deze zijn, maar dat is het niet.';
$string['ATAlgEquiv_SA_not_matrix'] = 'Je antwoord moet een matrix zijn, maar het is er geen.';
$string['ATAlgEquiv_SA_not_realset'] = 'Je antwoord moet een reeks reële getallen zijn. Dit kunnen getallen zijn of een verzameling intervallen.';
$string['ATAlgEquiv_SA_not_set'] = 'Je antwoord moet een set zijn, maar is dat niet. Merk op dat de syntax om een set in te geven is als een door accolades omgeven komma gescheiden lijst.';
$string['ATAlgEquiv_SA_not_string'] = 'Je antwoord moet een string zijn, maar is dat niet.';
$string['ATAlgEquiv_TA_not_equation'] = 'Je hebt een vergelijking ingegeven, maar hier wordt geen vergelijking verwacht. Je kunt iets getypt hebben als  "y=2*x+1" maar je moet iets typen als  "2*x+1".';
$string['ATCompSquare_SA_not_depend_var'] = 'Je antwoord moet afhangen van de variable {$a->m0} maar dat is niet het geval.';
$string['ATCompSquare_not_AlgEquiv'] = 'Jouw antwoord lijkt de juiste vorm te hebben, maar is toch niet equivalent aan het juiste antwoord.';
$string['ATDiff_error_list'] = 'De antwoordcontrole ging mis. Breng de beheerder hiervan op de hoogte.';
$string['ATDiff_int'] = 'Het lijkt alsof je geïntegreerd hebt!';
$string['ATEquivFirst_SA_wrong_end'] = 'Je uiteindelijke antwoord is niet in de juiste vorm.';
$string['ATEquivFirst_SA_wrong_start'] = 'De eerste regel in je argument moet "{$a->m0}" zijn.';
$string['ATFacForm_error_list'] = 'De antwoordcontrole ging mis. Breng de beheerder hiervan op de hoogte.';
$string['ATFacForm_isfactored'] = 'Je antwoord is ontbonden in factoren. Goed gedaan!';
$string['ATFacForm_notalgequiv'] = 'Je antwoord is algebraïsch niet equivalent aan het juiste antwoord. Je hebt een fout gemaakt.';
$string['ATFacForm_notfactored'] = 'Jouw antwoord is niet vermenigvuldigd.';
$string['ATFacForm_notpoly'] = 'Deze term zou een merkwaardig product moeten zijn, maar is dat niet.';
$string['ATInequality_backwards'] = 'Jouw ongelijkheid lijkt omgekeerd te zijn.';
$string['ATInequality_nonstrict'] = 'Je moet een strikte ongelijkheid hebben, maar dit is niet strikt!';
$string['ATInequality_strict'] = 'Je ongelijkheid mag niet strikt zijn!';
$string['ATInt_diff'] = 'Het lijkt er op dat je ten onrechte gedifferentieerd hebt.';
$string['ATInt_error_list'] = 'De antwoordcontrole ging mis. Breng de beheerder hiervan op de hoogte.';
$string['ATList_wrongentries'] = 'De onderstaande rood onderlijnde items zijn niet correct. {$a->m0}';
$string['ATList_wronglen'] = 'Jouw lijst zou {$a->m0} elementen moeten hebben, maar ze zou eigenlijk {$a->m1} moeten hebben.';
$string['ATLowestTerms_entries'] = 'Volgende termen in je antwoord zijn niet voldoende vereenvoudigd: {$a->m0}. Probeer opnieuw.';
$string['ATLowestTerms_not_rat'] = 'Je moet het volgende weghalen uit de noemer van je breuk: {$a->m0}';
$string['ATLowestTerms_wrong'] = 'Je moet breuken annuleren in je antwoord.';
$string['ATMatrix_wrongentries'] = 'De onderstaande rood onderlijnde items zijn niet correct. {$a->m0}';
$string['ATMatrix_wrongsz'] = 'Jouw matrix zou moeten {$a->m0} door {$a->m1} zijn, maar is eigenlijk  {$a->m2} door  {$a->m3}.';
$string['ATNumDecPlaces_Float'] = 'Je antwoord moet een drijvendekommagetal zijn, maar is dat niet.';
$string['ATNumDecPlaces_NoDP'] = 'Je antwoord moet een decimaal cijfer zijn, met een komma.';
$string['ATNumDecPlaces_Wrong_DPs'] = 'Jouw antwoord is afgerond op het verkeerde aantal decimalen.';
$string['ATNumSigFigs_Inaccurate'] = 'De nauwkeurigheid van jouw antwoord is niet juist. Ofwel je hebt verkeerd afgerond, danwel een afronding gedaan tijdens de berekening, die doorwerkt in je antwoord.';
$string['ATNumSigFigs_NotDecimal'] = 'Je antwoord zou een decimaal getal moeten zijn, maar is dat niet.';
$string['ATNumSigFigs_WrongDigits'] = 'Jouw antwoord bevat niet het juiste aantal decimalen.';
$string['ATNumSigFigs_WrongSign'] = 'Je antwoord heeft het foute algebraïsche teken.';
$string['ATNumSigFigs_error_list'] = 'De antwoordcontrole ging mis. Breng de beheerder hiervan op de hoogte.';
$string['ATNum_OutofRange'] = 'Een numerieke expressie is buiten de ondersteunde marge. Neem contact op met je leraar.';
$string['ATNumerical_FAILED'] = 'Je antwoord zou een drijvendekommagetal, een lijst of een set getallen moeten zijn, maar is dat niet.';
$string['ATNumerical_SA_not_list'] = 'Je antwoord zou een lijst moeten zijn, maar is dat niet. Merk op dat de syntax om een lijst in te geven is om komma gescheiden waarden te omsluiten met vierkante haken.';
$string['ATNumerical_SA_not_number'] = 'Je antwoord moet een drijvendekommagetal zijn, maar is dat niet.';
$string['ATNumerical_SA_not_set'] = 'Je antwoord zou een verzameling moeten zijn, maar is dat niet. Merk op dat de syntax om een verzameling in te geven is om komma gescheiden waarden te omsluiten met accolades.';
$string['ATNumerical_SB_not_number'] = 'De waarde die voor het lerarenantwoord ingegeven is zou een drijvendekommagetal moeten zijn maar is dat niet. Dit is een interne fout van de test. Spreek je leraar hierover aan.';
$string['ATPartFrac_denom_ret'] = 'Als je antwoord is geschreven als een enkele breuk, dan zou de noemer {$a->m0} zijn. Echter,  {$a->m1} is het juiste antwoord.';
$string['ATPartFrac_diff_variables'] = 'De variabelen in jouw antwoord verschillen van die van de vraagtekst, controleer ze nogmaals.';
$string['ATPartFrac_error_list'] = 'De antwoordcontrole ging mis. Breng de beheerder hiervan op de hoogte.';
$string['ATPartFrac_ret_expression'] = 'Jouw antwoord onder een noemer gebracht is {$a->m0}';
$string['ATSet_wrongsz'] = 'Jouw verzameling zou {$a->m0} verschillende elementen moeten bevatten, maar heeft er eigenlijk {$a->m1}.';
$string['ATSets_SA_not_set'] = 'Jouw antwoord zou een verzameling moeten zijn, maar is dat niet. Merk op dat de syntax om een verzameling in te geven is om een komma gescheiden lijst in te geven die omsloten is met accolades.';
$string['ATSets_duplicates'] = 'Jouw verzameling lijkt sommige items dubbel te bevatten!';
$string['ATSets_missingentries'] = 'Het volgende ontbreekt in je verzameling: {$a->m0}';
$string['ATSets_wrongentries'] = 'Deze elementen zouden geen deel mogen zijn van jouw verzameling: {$a->m0}';
$string['ATSingleFrac_div'] = 'Jouw antwoord bevat breuken in breuken. Je moet deze oplossen en je antwoord als een enkele breuk noteren.';
$string['ATSingleFrac_error_list'] = 'De antwoordcontrole ging mis. Breng de beheerder hiervan op de hoogte.';
$string['ATSingleFrac_part'] = 'Jouw antwoord wordt in de vorm van ( {a} gedeeld door {b} ) verwacht.';
$string['ATSingleFrac_ret_exp'] = 'Jouw antwoord is algebraïsch niet gelijk aan het juiste antwoord. Je moet een fout gemaakt hebben.';
$string['ATSingleFrac_var'] = 'De variabelen in je antwoord zijn verschillend van die in de vraag. Controleer ze.';
$string['ATSubstEquiv_Opt_List'] = 'De optie om deze vraag te beantwoorden moet een lijst zijn. Dit is een fout. Neem contact op met je leraar.';
$string['ATSysEquiv_SA_extra_variables'] = 'Je antwoord bevat teveel variabelen.';
$string['ATSysEquiv_SA_missing_variables'] = 'Er ontbreken één of meer variabelen in je antwoord.';
$string['ATSysEquiv_SA_not_eq_list'] = 'Je antwoord zou een lijst van vergelijkingen moeten zijn, maar dat is het niet.';
$string['ATSysEquiv_SA_not_list'] = 'Je antwoord zou een lijst moeten zijn, maar is dat niet.';
$string['ATSysEquiv_SA_not_poly_eq_list'] = 'Eén of meer van jouw vergelijkingen is geen veelterm';
$string['ATSysEquiv_SA_system_overdetermined'] = 'De onderstaande rood onderlijnde items zijn niet correct. {$a->m0}';
$string['ATSysEquiv_SA_wrong_variables'] = 'Je antwoord gebruikt de foute variabelen.';
$string['ATSysEquiv_SB_not_eq_list'] = 'Het antwoord van de leraar is geen lijst met vergelijkingen, maar zou dat moeten zijn.';
$string['ATSysEquiv_SB_not_list'] = 'Het antwoord van de leraar is geen lijs. Neem contact op met je leraar.';
$string['ATSysEquiv_SB_not_poly_eq_list'] = 'Het antwoord van je leraar zou een lijst met veeltermen moeten zijn, maar is dat niet. Neem contact op met je leraar.';
$string['ATUnits_SA_bad_units'] = 'Je antwoord moet eenheden hebben en je moet vermenigvuldigen om de eenheden aan je waarde te koppelen, bijvoorbeeld <code>3.2*m/s</code>.';
$string['ATUnits_SA_excess_units'] = 'Er staan eenheden (of variabelen) in je antwoord, maar die zouden er niet mogen staan.';
$string['ATUnits_SA_no_units'] = 'Je antwoord moet eenheden hebben.';
$string['ATUnits_SA_not_expression'] = 'Je antwoord met een getal met een eenheid zijn. Gebruik geen sets, lijsten, vergelijkingen of matrices.';
$string['ATUnits_SA_only_units'] = 'Je antwoord moet een getal met eenheden zijn. Jouw antwoord heeft enkel eenheden.';
$string['ATUnits_compatible_units'] = 'Jouw eenheden verschillen van degene die je leraar heeft gebruikt, maar ze zijn er mee compatibel. Numerieke waarden worden geconverteerd naar SI-eenheden voor vergelijking.';
$string['ATUnits_correct_numerical'] = 'Controleer je eenheden grondig.';
$string['ATUnits_incompatible_units'] = 'Je eenheden komen niet overeen met degene die de leraar gebruikt heeft.';
$string['AT_EmptySA'] = 'Er is geprobeerd een antwoordcontrole uit te voeren met een leeg studentantwoord, waarschijnlijk is er sprake van een CAS validatie probleem tijdens het bewerken van de vraag.';
$string['AT_EmptyTA'] = 'Er is geprobeerd een antwoordcontrole uit te voeren met een leeg docentantwoord, waarschijnlijk is er sprake van een CAS validatieprobleem tijdens het bewerken van de vraag.';
$string['AT_InvalidOptions'] = 'Optieveld is niet geldig. {$a->errors}';
$string['AT_MissingOptions'] = 'Optie ontbrak tijdens het uitvoeren van de test.';
$string['FacForm_UnPick_morework'] = 'De term {$a->m0} kan nog wat verfijnd worden.';
$string['Illegal_floats'] = 'Jouw antwoord bevat drijvendekommagetallen , die hier niet toegestaan zijn. Geef je antwoorden zonder het getal te benaderen. Bijvoorbeeld 1/3 en niet 0,33333 wat een benadering zou zijn van een derde.';
$string['Illegal_groups'] = 'Je antwoord bevat evaluatiegroepen "(a,b,c)" die hier niet toegestaan zijn.';
$string['Illegal_identifiers_in_units'] = 'De input bevat een variabele-naam terwijl hier enkel eenheden verwacht worden.';
$string['Illegal_illegal_operation_in_units'] = 'De operator <code>{$a}</code> is niet toegestaan in deze invoer.';
$string['Illegal_illegal_power_of_ten_in_units'] = 'De waarde mag geen gehele machten van tien bevatten.';
$string['Illegal_lists'] = 'Jouw antwoord bevat lijsten zoals "[a,b,c]" maar dat mag hier niet.';
$string['Illegal_sets'] = 'Jouw antwoord bevat lijsten zoals "{a,b,c}" maar dat mag hier niet.';
$string['Illegal_strings'] = 'Jouw antwoord bevat "strings" maar dat mag hier niet.';
$string['Lowest_Terms'] = 'Je antwoord bevat delen die niet in de eenvoudigste termen geschreven zijn. Zoek naar gemene delers en probeer opnieuw.';
$string['Maxima_DivisionZero'] = 'Deling door nul.';
$string['Subst'] = 'Je antwoord zou correct geweest zijn als je volgende substitutie van variabelen zou gebruikt hebben: {$a->m0}';
$string['TEST_FAILED'] = 'De antwoordcontrole heeft niet juist gewerkt: waarschuw je leraar. {$a->errors}';
$string['TEST_FAILED_Q'] = 'De antwoordtest kon niet juist uitgevoerd worden: waarschuw je leraar.';
$string['addanothernode'] = 'Voeg een knoop toe';
$string['addanothertestcase'] = 'Voeg nog een testcase toe...';
$string['addatestcase'] = 'Voeg een testcase toe...';
$string['addingatestcase'] = 'Een testcase aan een vraag toevoegen {$a}';
$string['alg_indices_fact'] = 'De volgende regels beslaan het manipuleren van een index:
[a^ma^n = a^{m+n}]
[frac{a^m}{a^n} = a^{m-n}]
[(a^m)^n = a^{mn}]
[a^0 = 1]
[a^{-m} = frac{1}{a^m}]
[a^{frac{1}{n}} = sqrt[n]{a}]
[a^{frac{m}{n}} = left(sqrt[n]{a}right)^m]';
$string['alg_indices_name'] = 'De regels van indices';
$string['alg_inequalities_fact'] = '\\[a>b \\hbox{ betekent } a \\hbox{ is groter dan } b.\\]
\\[ a < b \\hbox{ betekent } a \\hbox{ is kleiner dan } b\\]
\\[a\\geq b \\hbox{ betekent } a \\hbox{ is groter dan of gelijk aan } b.\\]
\\[a\\leq b \\hbox{ betekent } a \\hbox{ is kleiner dan of gelijk aan } b.\\]';
$string['alg_inequalities_name'] = 'Ongelijkheden';
$string['alg_logarithms_fact'] = 'Voor een willekeurig grondtal \\(c>0\\) met (c \\neq 1\\):
\\[\\log_c(a) = b \\mbox{, betekent } a = c^b\\]
\\[\\log_c(a) + \\log_c(b) = \\log_c(ab)\\]
\\[\\log_c(a) - \\log_c(b) = \\log_c\\left(\\frac{a}{c}\\right)\\]
\\[n\\log_c(a) = \\log_c\\left(a^n\\right)\\]
\\[\\log_c(1) = 0\\]
\\[\\log_c(b) = 1\\]
Omreken naar een ander grondtal gaat volgens:
\\[\\log_a(x) = \\frac{\\log_b(x)}{\\log_b(a)}\\]
Logaritmen met het grondtal  \\(e\\), genoteerd als \\(\\log_e\\) of anders \\(\\ln\\)  noem je natuurlijk logaritmen.  De letter \\(e\\)  staat voor een belangrijke wiskundige constante, met een waarde van ongeveer \\(2.718\\).';
$string['alg_logarithms_name'] = 'De rekenregels bij logaritmen';
$string['alg_quadratic_formula_name'] = 'De wortelformule';
$string['all'] = 'Alle';
$string['allnodefeedbackmustusethesameformat'] = 'Alle feedback voor alle nodes in een PRT moeten hetzelfde tekstformat hebben.';
$string['allowwords'] = 'Toegestane woorden';
$string['allowwords_link'] = '%%WWWROOT%%/question/type/stack/doc/doc.php/Authoring/Inputs.md#Allow_Words';
$string['alreadydeployed'] = 'Er is al een vraagversie in gebruik met dezelfde vraag-toevoeging';
$string['alttextmissing'] = 'Eén of meer afbeelden hebben een lege of geen \'alt\'-tag in "{$a->field}" ({$a->num}).';
$string['answernote'] = 'Feedbacknotitie';
$string['answernote_err'] = 'Antwoorden mogen het teken | niet bevatten. Dit teken wordt door STACK ingevoerd en wordt later gebruikt om antwoorden automatisch te splitsen.';
$string['answernote_help'] = 'Dit is een tag voor rapport-doeleinden. Het is gemaakt om een uniek pad door de vertakkingen van elke antwoordcontrôle vast te leggen. Het wordt automatisch gegenereerd, maar kan gewijzigd worden in iets wat een duidelijkere betekening heeft.';
$string['answernote_link'] = '%%WWWROOT%%/question/type/stack/doc/doc.php/Authoring/Potential_response_trees.md#Answer_note';
$string['answernotedefaultfalse'] = '{$->prtname}-{$a->nodename}-F';
$string['answernotedefaulttrue'] = '{$->prtname}-{$a->nodename}-G';
$string['answernoterequired'] = 'Feedback-toevoeging mag niet leeg zijn.';
$string['answertest'] = 'Antwoordcontrole';
$string['answertest_help'] = 'Een antwoordcontrole wordt gebruikt om twee expressies te vergelijken, om te controleren of ze voldoen aan gestelde wiskundige criteria.';
$string['answertest_link'] = '%%WWWROOT%%/question/type/stack/doc/doc.php/Authoring/Answer_Tests/index.md';
$string['assumepositive'] = 'Veronderstel positief';
$string['assumepositive_help'] = 'Deze optie stelt de waarde in van Maxima\'s assume_pos variable.';
$string['assumepositive_link'] = '%%WWWROOT%%/question/type/stack/doc/doc.php/Authoring/Options.md#Assume_Positive';
$string['assumereal'] = 'Veronderstel reëel';
$string['assumereal_help'] = 'Deze optie stelt de assume_real variable in';
$string['assumereal_link'] = '%%WWWROOT%%/question/type/stack/doc/doc.php/Authoring/Options.md#Assume_Real';
$string['autosimplify'] = 'Auto-vereenvoudig';
$string['autosimplify_help'] = 'Bepaald de waarde van de variabele "simp" binnen Maxima voor deze vraag. Dat is voor vraagvariabelen, vraagtekst e.d..
De waarde die opgegeven wordt in elke PRT zal deze waarde overschrijven voor de expressies in de vertakkingen.';
$string['autosimplify_link'] = '%%WWWROOT%%/question/type/stack/doc/doc.php/CAS/Maxima.md#Simplification';
$string['autosimplifyprt'] = 'Auto-vereenvoudig';
$string['autosimplifyprt_link'] = '%%WWWROOT%%/question/type/stack/doc/doc.php/CAS/Maxima.md#Simplification';
$string['basicquestionreport'] = 'Eenvoudig vraag gebruiksrapport';
$string['basicquestionreport_help'] = 'Genereert een eenvoudig rapport over pogingen voor deze vraag op de server.
Nuttig om te beslissen welke test kan toegevoegd worden om feedback te verbeteren in het licht van wat de leerling eigenlijk doet. (De meeste vragen worden slechts op één plaats gebruikt)';
$string['basicreportinputsummary'] = 'Ruwe invoer, onafhankelijk van welke variant gebruikt werd';
$string['basicreportraw'] = 'Ruwe gegevens';
$string['booleangotunrecognisedvalue'] = 'Ongeldige input.';
$string['boxsize'] = 'Grootte inputbox';
$string['boxsize_help'] = 'Breedte van het html-invulveld.';
$string['boxsize_link'] = '%%WWWROOT%%/question/type/stack/doc/doc.php/Authoring/Inputs.md#Box_Size';
$string['branchfeedback'] = 'Knoopvertakking feedback';
$string['branchfeedback_help'] = 'Deze CAS-tekst gebruik mag maken van alle vraagvariabelen, input-elementen of feedbackvariablen. Het wordt eerst geëvalueerd en dan weergegeven aan de student als deze vertakking wordt aangesproken.';
$string['bulktestcontinuefromhere'] = 'Opnieuw laten lopen of herstarten vanaf hier';
$string['bulktestindexintro'] = 'Het klikken op gelijk welke link zal alle vragentesten in alle STACK-vragen in die context uitvoeren.';
$string['bulktestindexintro_desc'] = 'De <a href="{$a->link}"> start de vragentests in een bulk script</a>  laat je gemakkelijk alle STACK-vragen in een bepaalde context lopen. Dit test niet alleen de vragen, het is ook een goede manier om de CAS cache opnieuw te vullen nadat die leeg gemaakt is.';
$string['bulktestindextitle'] = 'Laat alle vraagtesten in bulk lopen';
$string['bulktestnogeneralfeedback'] = 'Deze vraag heeft geen algemene feedback.';
$string['bulktestnotests'] = 'Deze vraag heeft nog geen testen.';
$string['bulktestrun'] = 'Laat alle vraagtesten voor all vragen in het systeem (traag, enkel admin)';
$string['bulktesttitle'] = 'Alle vraagtesten laten lopen in {$a}';
$string['cachedef_parsercache'] = 'STACK verwerkte Maxima-expressies';
$string['calc_chain_rule_name'] = 'De kettingregel';
$string['calc_diff_linearity_rule_name'] = 'De kettingregel';
$string['calc_diff_standard_derivatives_name'] = 'Standaard afgeleiden';
$string['calc_int_linearity_rule_name'] = 'De kettingregel bij integreren';
$string['calc_int_methods_parts_indefinite_name'] = 'Partiële integratie';
$string['calc_int_methods_parts_name'] = 'Partiële integratie';
$string['calc_int_methods_substitution_name'] = 'Integratie door substitutie';
$string['calc_int_standard_integrals_name'] = 'Standaard integralen';
$string['calc_product_rule_name'] = 'De productregel';
$string['calc_quotient_rule_name'] = 'De quotiëntregel';
$string['calc_rules_name'] = 'Analyse-regels';
$string['casdisplay'] = 'CAS scherm';
$string['cassuitecolerrors'] = 'CAS fouten';
$string['castext'] = 'CAS tekst';
$string['casvalid'] = 'V2';
$string['casvalue'] = 'CAS waarde';
$string['chat'] = 'Stuur naar CAS';
$string['chat_desc'] = 'Met het <a href="{$a->link}">CAS chat script</a> kun je de verbinding met de CAS testen en de  Maxima syntax uitproberen.';
$string['chatintro'] = 'Met deze pagina kun je CAS tekst rechtstreeks evalueren. Het is een eenvoudig script dat een bruikbaar eenvoudig voorbeeld mogelijk maakt, een handige manier om te kijken of de CAS werkt en allerhande invoer te proberen. Het eerste tekstvak laat je de variabelen definiëren en het tweede is voor de CAS-tekst zelf.';
$string['chattitle'] = 'Test de verbinding met CAS';
$string['checkanswertype'] = 'Controleer het antwoordtype';
$string['checkanswertype_link'] = '%%WWWROOT%%/question/type/stack/doc/doc.php/Authoring/Inputs.md#Check_Type';
$string['clearedthecache'] = 'CAS cache leeggemaakt';
$string['clearingcachefiles'] = 'Verwijderen van cached STACK plot bestanden {$a->done}/{$a->total}';
$string['clearthecache'] = 'Maak de cache leeg';
$string['completetestcase'] = 'Vul de rest van het formulier in om een geslaagde test te maken.';
$string['complexno'] = 'Betekenis en het tonen van sqrt(-1)';
$string['complexno_help'] = 'Controleert de betekenis en het tonen van het symbool i en sqrt(-1)';
$string['complexno_link'] = '%%WWWROOT%%/question/type/stack/doc/doc.php/Authoring/Options.md#sqrt_minus_one.';
$string['createtestcase'] = 'Maak een testcase';
$string['currentlyselectedvariant'] = 'Dit is de variant die hieronder wordt weergegeven.';
$string['ddl_badanswer'] = 'Het model antwoordveld voor deze invoer heeft een verkeerde vorm: <code>{$a}</code>.';
$string['ddl_duplicates'] = 'Er zijn dubbele waarden gevonden bij het genereren van de invoeropties.';
$string['ddl_empty'] = 'Er zijn geen keuzes voorzien voor dit rolmenu.';
$string['ddl_nocorrectanswersupplied'] = 'De leraar heeft geen juist antwoord aangeduid.';
$string['ddl_runtime'] = 'De invoer heeft volgende fout gegenereerd, waardoor je niet kunt antwoorden. Neem contact op met je leraar.';
$string['ddl_unknown'] = 'STACK kreeg  <code>{$a}</code>  maar dat is niet door een leraar als optie opgegeven.';
$string['debuginfo'] = 'Debug info';
$string['defaultprtcorrectfeedback'] = 'Juist antwoord, goed gedaan.';
$string['defaultprtincorrectfeedback'] = 'Fout antwoord.';
$string['defaultprtpartiallycorrectfeedback'] = 'Jouw antwoord is gedeeltelijk correct.';
$string['deletetestcase'] = 'Verwijder testcase ($a->no} for question {$a->question}';
$string['deletetestcaseareyousure'] = 'Weet je zeker dat je testcase {$a->no} voor vraag {$a->question}?';
$string['deletethistestcase'] = 'Verwijder deze testcase';
$string['deploy'] = 'Uitrollen';
$string['deployedprogress'] = 'Varianten uitrollen';
$string['deployedvariants'] = 'Uitgerolde varianten';
$string['deployedvariantsn'] = 'Uitgerolde varianten ({$a})';
$string['deploymanyerror'] = 'Fout in gebruikersinvoer: kan "{$a->err}" varianten niet uitrollen.';
$string['deploymanysuccess'] = 'Aantal nieuwe varianten gemaakt, getest en uitgerold: {$a->no}.';
$string['deployremoveall'] = 'Uitrol stoppen van alle varianten:';
$string['deploytestall'] = 'Start alle testen op alle uitgerolde varianten (traag):';
$string['deploytoomanyerror'] = 'STACK zal proberen om maximaal 100 nieuwe varianten uit te rollen in één verzoek. Geen nieuwe varianten uitgerold.';
$string['dropdowngotunrecognisedvalue'] = 'Ongeldige invoer.';
$string['editingtestcase'] = 'Bewerk testcase {$a->no} voor vraag {$a->question}';
$string['editquestioninthequestionbank'] = 'Bewerk deze vraag';
$string['editthistestcase'] = 'Bewerk deze testcase...';
$string['equiv_AND'] = 'en';
$string['equiv_ANDOR'] = 'en/of verwarring!';
$string['equiv_MISSINGVAR'] = 'Ontbrekende opdrachten';
$string['equiv_NAND'] = 'nand';
$string['equiv_NOR'] = 'nor';
$string['equiv_NOT'] = 'not';
$string['equiv_OR'] = 'or';
$string['equiv_XNOR'] = 'xnor';
$string['equiv_XOR'] = 'xor';
$string['equivfirstline'] = 'Je hebt de foute eerste lijn in je argument gebruikt!';
$string['equivnocomments'] = 'Je mag geen opmerkingen zetten in dit invoertype. Werk lijn per lijn.';
$string['errors'] = 'Error';
$string['exceptionmessage'] = '{$a}';
$string['expectedanswernote'] = 'Verwachte vraagnotitie';
$string['expectedoutcomes'] = 'Verwacht PRT resultaat: [gebruikte inputs]';
$string['expectedpenalty'] = 'Verwachte strafpunten';
$string['expectedscore'] = 'Verwachte score';
$string['exportthisquestion'] = 'Exporteer deze vraag';
$string['exportthisquestion_help'] = 'Dit zal een Moodle XML exportbestand maken die juist deze ene vraag bevat. Een voorbeeld van wanneer dit nuttig kan zijn, is wanneer je denkt dat dit een fout in STACK kan aantonen en je die wil rapporteren aan de ontwikkelaars.';
$string['fact_sheet_preamble'] = '# Hints

STACK bevat een "formularium" met nuttige fragmenten die een leraar concistent kan toevoegen.  Dit kan gedaan worden met het "hints"-systeem

Hints kunnen in elke [CASText](CASText.md) ingevoegd worden.

Om een hint toe te voegen, gebruik je de syntax

    [[facts:tag]]

De "tag" wordt uit onderstaande lijst gekozen.

## Alle ondersteunde hints';
$string['false'] = 'Fout';
$string['falsebranch'] = 'Fout-vertakking';
$string['falsebranch_help'] = 'Met deze velden bepaal je wat er gebeurt als de antwoordcontrôle een antwoord fout rekent.
### Modus en score
Hoe de beoordeling wordt aangepast: = betekent, ken een bepaalde score toe, +/- betekent tel op bij/haal af van de huidige totale score.

### Strafpunten
In adaptieve of interactieve modus, ken zoveel strafpunten toe.

### Volgende
Hier geef je een link naar de volgende node, of anders \'stop\'.

### Feedback-toevoeging
Dit is een tag voor rapport-doeleinden. Het is gemaakt om een uniek pad door de vertakkingen van elke antwoordcontrôle vast te leggen. Het wordt automatisch gegenereerd, maar kan gewijzigd worden in iets wat een duidelijkere betekening heeft.';
$string['feedbackfromprtx'] = '[ Feedback van {$a}. ]';
$string['feedbackstyle0'] = 'Formatief';
$string['feedbackstyle1'] = 'Standaard';
$string['feedbackstyle2'] = 'Compact';
$string['feedbackstyle3'] = 'Enkel symbool';
$string['feedbackstyle_link'] = '%%WWWROOT%%/question/type/stack/doc/doc.php/Authoring/Potential_response_trees.md';
$string['feedbackvariables'] = 'Feedback variabelen';
$string['feedbackvariables_help'] = 'De feedbackvariabelen maken het mogelijk om de inputs en/of de vraagvariabelen te verwerken alvorens verder te gaan in de vertakkingen. Variabelen die hier worden gedefinieerd mogen in onderliggende hierna overal in de boom gebruikt worden.';
$string['feedbackvariables_link'] = '%%WWWROOT%%/question/type/stack/doc/doc.php/Authoring/Variables.md#Feedback_variables';
$string['fieldshouldnotcontainplaceholder'] = '{$a->field} mag geen  [[{$a->type}:...]] plaatshouders bevatten.';
$string['fixdollars'] = 'Dollartekens herstellen';
$string['fixdollars_help'] = 'Deze optie is nuttig als je TeX kopieert en plakt (of typt) die <code>$...$</code> en <code>$$...$$</code> scheidingstekens bevat. Deze scheidingstekens zullen vervangen worden door de aangeraden scheidingstekens tijdens het bewaren.';
$string['fixdollarslabel'] = 'Vervang <code>$...$</code> met <code>\\(...\\)</code>, <code>$$...$$</code> met <code>\\[...\\]</code> en <code>@...@</code> met <code>{@...@}</code> tijdens het bewaren.';
$string['forbidfloat'] = 'Verbied drijvendekommagetal';
$string['forbidfloat_help'] = 'Indien ja zal elk antwoord van de leerling dat een drijvendekommagetal bevat als ongeldig verworpen worden.';
$string['forbidfloat_link'] = '%%WWWROOT%%/question/type/stack/doc/doc.php/Authoring/Inputs.md#Forbid_Floats';
$string['forbidwords'] = 'Verboden woorden';
$string['forbidwords_help'] = 'Dit is een kommagescheiden lijst van tekstfragmenten die verboden zijn in het antwoord van de leerling.';
$string['forbidwords_link'] = '%%WWWROOT%%/question/type/stack/doc/doc.php/Authoring/Inputs.md#Forbidden_Words';
$string['generalfeedback'] = 'Algemene feedback';
$string['generalfeedback_help'] = 'Algemene feedback is CAS-tekst.
Algemene feedback, vaak ook "uitwerkingen" genoemd, wordt aan de leerling getoond, nadat zij de vraag hebben beantwoord. Anders dan bij feedback die op het antwoord van de leerling wordt toegespitst, wordt deze feedback getoond aan alle leerlingen. Het kan wel afhangen van de vraagvariabelen die gebruikt worden in de versie van de vraag.';
$string['generalfeedback_link'] = '%%WWWROOT%%/question/type/stack/doc/doc.php/Authoring/CASText.md#general_feedback';
$string['greek_alphabet_fact'] = '||||
|--- |--- |--- |
|Hoofdletters, \\(\\quad\\)|kleine letters, \\(\\quad\\)|name|
|\\(A\\)|\\(\\alpha\\)|alpha|
|\\(B\\)|\\(\\beta\\)|beta|
|\\(\\Gamma\\)|\\(\\gamma\\)|gamma|
|\\(\\Delta\\)|\\(\\delta\\)|delta|
|\\(E\\)|\\(\\epsilon\\)|epsilon|
|\\(Z\\)|\\(\\zeta\\)|zeta|
|\\(H\\)|\\(\\eta\\)|eta|
|\\(\\Theta\\)|\\(\\theta\\)|theta|
|\\(K\\)|\\(\\kappa\\)|kappa|
|\\(M\\)|\\(\\mu\\)|mu|
|\\(N\\)|\\( u\\)|nu|
|\\(\\Xi\\)|\\(\\xi\\)|xi|
|\\(O\\)|\\(o\\)|omicron|
|\\(\\Pi\\)|\\(\\pi\\)|pi|
|\\(I\\)|\\(\\iota\\)|iota|
|\\(P\\)|\\(\\rho\\)|rho|
|\\(\\Sigma\\)|\\(\\sigma\\)|sigma|
|\\(\\Lambda\\)|\\(\\lambda\\)|lambda|
|\\(T\\)|\\(\\tau\\)|tau|
|\\(\\Upsilon\\)|\\(\\upsilon\\)|upsilon|
|\\(\\Phi\\)|\\(\\phi\\)|phi|
|\\(X\\)|\\(\\chi\\)|chi|
|\\(\\Psi\\)|\\(\\psi\\)|psi|
|\\(\\Omega\\)|\\(\\omega\\)|omega|';
$string['greek_alphabet_name'] = 'Het griekse alfabet';
$string['healthautomaxopt'] = 'Maak automatisch een geoptimaliseerde Maxima-afbeelding';
$string['healthautomaxopt_failed'] = 'Het maken van een geoptimaliseerde Maxima-afbeelding mislukt: [{$a->errmsg}]';
$string['healthautomaxopt_nolisp'] = 'Kon LISP-versie niet bepalen, dus Maxima-afbeelding kon niet automatisch gemaakt worden.';
$string['healthautomaxopt_nolisprun'] = 'Kon lisp.run niet automatisch vinden. Probeer "sudo updatedb" in een terminal en bekijk de optimalisatie-documentatie.';
$string['healthautomaxopt_notok'] = 'Maxima-afbeelding niet automatisch gemaakt.';
$string['healthautomaxopt_ok'] = 'Maxima-afbeelding gemaakt op: <tt>{$a->command}</tt>';
$string['healthautomaxopt_succeeded'] = 'Het maken van een geoptimalieerde Maxima-afbeelding is gelukt';
$string['healthautomaxoptintro'] = 'Om de prestaties te optimaliseren moeten we Maxima optimaliseren op een Linux-machine. Gebruik de pagina "gezondheidscontrole" en lees de documentatie.';
$string['healthcheck'] = 'STACK healthcheck';
$string['healthcheck_desc'] = 'Het <a href="{$a->link}">gezondeiddscontrole-script</a> helpt je om te controleren of alle onderdelen van STACK goed werken.';
$string['healthcheckcache_db'] = 'CAS resultaten worden gecached in de database';
$string['healthcheckcache_none'] = 'CAS-resultaten worden niet gecached';
$string['healthcheckcache_otherdb'] = 'CAS-resultaten worden gecached in een andere databank.';
$string['healthcheckcachestatus'] = 'De cache bevat op dit moment {$a} items.';
$string['healthcheckconnect'] = 'Verbinding met CAS aan het maken';
$string['healthcheckconnectintro'] = 'We proberen volgende CAS-tekst te evalueren:';
$string['healthcheckcreateimage'] = 'Maak nieuw Maxima-image';
$string['healthcheckfilters'] = 'Zorg ervoor dat de {$a->filter} is ingeschakeld op de <a href="{$a->url}">Beheer filters</a> pagina.';
$string['healthchecklatex'] = 'Controleer of LaTeX juist geconverteerd wordt';
$string['healthchecklatexintro'] = 'STACK genereert instant LaTeX en maakt het voor leraren mogelijk om LaTeX in vragen op te nemen. Het gaat er van uit dat LaTeX geconverteerd zal worden door een Moodle filter. Hieronder staan voorbeelden van getoonde en inline uitdrukkingen in LaTeX die correct in je browser zouden moeten verschijnen. Als er hier problemen zijn, dan ligt dat aan een foute instelling van de Moodle filterinstellingen, geen probleem met STACK zelf. STACK gebruikt de enkele en dubbele dollarteken-notatie, maar sommige vragenauteurs gebruiken soms de andere vormen.';
$string['healthchecklatexmathjax'] = 'STACK steunt op de Moodle Mathjax filter. Een alternatief is om de javascript-code bij in Moodle\'s HTML te zetten. Bekijk de STACK installatie-documentatie voor meer informatie over deze optie.';
$string['healthcheckmathsdisplaymethod'] = 'Gebruikte methode om wiskunde te tonen: {$a}.';
$string['healthchecknombstring'] = 'STACK v4.3 en later vereist de PHP-module mbstring en die ontbreekt. Lees de installatiedocumentatie.';
$string['healthcheckplots'] = 'Grafieken tekenen';
$string['healthchecksamplecas'] = 'De afgeleide van {@ x^4/(1+x^4) @} is \\[ \\frac{d}{dx} \\frac{x^4}{1+x^4} = {@ diff(x^4/(1+x^4),x) @}. \\]  Bevestig dat unicode ondersteund wordt: \\(\\forall\\) zou moeten getoond worden als {@unicode(8704)@}.';
$string['healthchecksampledisplaytex'] = '\\[\\sum_{n=1}^\\infty \\frac{1}{n^2} = \\frac{\\pi^2}{6}.\\]';
$string['healthchecksampleinlinetex'] = '\\(\\sum_{n=1}^\\infty \\frac{1}{n^2} = \\frac{\\pi^2}{6}\\).';
$string['healthchecksstackmaximanotupdated'] = 'Het lijkt er op dat STACK niet juist is geüpdatet. Bezoek de  <a href="{$a}">Systeembeheer -> Meldingen-pagina</a>.';
$string['healthchecksstackmaximatooold'] = 'Zo oud dat de versie onbekend is!';
$string['healthchecksstackmaximaversion'] = 'Maxima-versie';
$string['healthchecksstackmaximaversionfixoptimised'] = '<a href="{$a->url}">Maxima geoptimaliseerde code opnieuw opbouwen</a>.';
$string['healthchecksstackmaximaversionfixserver'] = 'Bouw de Maxima-code opnieuw op je MaximaPool-server.';
$string['healthchecksstackmaximaversionfixunknown'] = 'Het is niet helemaal duidelijk hoe dit kon gebeuren. Je zult het probleem zelf moeten opsporen. Begin met het wissen van de CAS-cache';
$string['healthunabletolistavail'] = 'Platformtype staat niet op "Linux", het is dus niet mogelijk om de beschikbare versies van Maxima te tonen.';
$string['healthuncachedstack_CAS_calculation'] = 'Verwachtte CAS-berekening: {$a->expected}.  Werkelijke CAS-berekening: {$a->actual}.';
$string['healthuncachedstack_CAS_not'] = 'CAS gaf zoals verwacht gegevens terug, maar er waren fouten.';
$string['healthuncachedstack_CAS_ok'] = 'Cas gaf zoals verwacht gegevens terug. Je hebt een werkende verbinding met CAS.';
$string['hyp_functions_name'] = 'Hyperbolische functies';
$string['hyp_identities_name'] = 'Hyperbolische identiteiten';
$string['hyp_inverse_functions_name'] = 'Inverse hyperbolische functies';
$string['illegalcaschars'] = 'De tekens @, $  en \\ zijn niet toegestaan in CAS input.';
$string['inputdisplayed'] = 'Weergeven als';
$string['inputentered'] = 'Ingevulde waarde';
$string['inputexpression'] = 'Testinput';
$string['inputextraoptions'] = 'Extra opties';
$string['inputextraoptions_help'] = 'Sommige inputtypes vereisen extra opties om te werken. Je kunt die hier invoegen. Het gaat hier om een CAS expressie.';
$string['inputextraoptions_link'] = '%%WWWROOT%%/question/type/stack/doc/doc.php/Authoring/Inputs.md#Extra options';
$string['inputheading'] = 'Input: {$a}';
$string['inputinvalidparamater'] = 'Ongeldige parameter';
$string['inputname'] = 'Inputnaam';
$string['inputnameform'] = 'Invoernamen mogen enkel letters zijn, optioneel gevolgd door cijfers. \'{$a}\' is niet geldig.';
$string['inputnamelength'] = 'Invoernamen kunnen niet langer dan 18 tekens zijn. \'{$a}\' is te lang.';
$string['inputoptionunknown'] = 'Deze invoer ondersteunt de optie \'{$a}\' niet.';
$string['inputremovedconfirm'] = 'Ik bevestig dat ik deze invoer van deze vraag wil verwijderen.';
$string['inputremovedconfirmbelow'] = 'Invoer \'{$a}\'. is verwijderd. Bevestig dit onderaan.';
$string['inputs'] = 'Inputs';
$string['inputstatus'] = 'Status';
$string['inputstatusname'] = 'Leeg';
$string['inputstatusnameinvalid'] = 'Ongeldig';
$string['inputstatusnamescore'] = 'Score';
$string['inputstatusnamevalid'] = 'Geldig';
$string['inputtest'] = 'Inputtest';
$string['inputtype'] = 'Inputtype';
$string['inputtype_help'] = 'Dit bepaalt het type inputelement, bijvoorbeeld: invulveld, goed/fout, tekstgebied.';
$string['inputtype_link'] = '%%WWWROOT%%/question/type/stack/doc/doc.php/Authoring/Inputs.md';
$string['inputtypealgebraic'] = 'Algebraïsche input';
$string['inputtypeboolean'] = 'Goed/Fout';
$string['inputtypecheckbox'] = 'Selectievakje';
$string['inputtypedropdown'] = 'Rolmenu';
$string['inputtypematrix'] = 'Matrix';
$string['inputtypenotes'] = 'Notities';
$string['inputtypenumerical'] = 'Numeriek';
$string['inputtyperadio'] = 'Radio';
$string['inputtypesinglechar'] = 'Enkel teken';
$string['inputtypestring'] = 'String';
$string['inputtypetextarea'] = 'Tekstgebied';
$string['inputtypeunits'] = 'Eenheden';
$string['inputtypevarmatrix'] = 'Matrix van variabele grootte';
$string['insertspaces'] = 'Enkel sterren invoeren voor spaties';
$string['insertstars'] = 'Sterren invoeren';
$string['insertstars_link'] = '%%WWWROOT%%/question/type/stack/doc/doc.php/Authoring/Inputs.md#Insert_Stars';
$string['insertstarsno'] = 'Geen sterren invoeren';
$string['inversetrig_link'] = '%%WWWROOT%%/question/type/stack/doc/doc.php/Authoring/Options.md#inverse_trig';
$string['irred_Q_commonint'] = 'Je moet er een gemeenschappelijke factor uithalen.';
$string['irred_Q_optional_fac'] = 'Je kunt meer werk doen, want {$a->m0}  kan verder ontbonden worden in factoren. Maar het is niet echt noodzakelijk.';
$string['languageproblemsexist'] = 'Er is mogelijks een taalprobleem in je vraag.';
$string['languageproblemsextra'] = 'Het veld {$a->field} heeft volgende talen niet in de vraagtekst: {$a->langs}.';
$string['languageproblemsmissing'] = 'Het taallabel {$a->lang} ontbreekt in het volgende: {$a->missing}.';
$string['logicsymbol'] = 'Logische symbolen';
$string['logicsymbol_link'] = '%%WWWROOT%%/question/type/stack/doc/doc.php/Authoring/Options.md#logicsymbol';
$string['logicsymbollang'] = 'Taal';
$string['logicsymbolsymbol'] = 'Symbool';
$string['matrixparens'] = 'Standaardvorm voor matrix haakjes';
$string['matrixparens_link'] = '%%WWWROOT%%/question/type/stack/doc/doc.php/CAS/Matrix.md#matrixparens';
$string['mbstringrequired'] = 'Het is noodzakelijk voor STACK om de mbstring-bibliotheek te installeren.';
$string['multcross'] = 'Kruis';
$string['multdot'] = 'Punt';
$string['multiplicationsign'] = 'Vermenigvuldigingsteken';
$string['multiplicationsign_help'] = 'Bepaalt hoe het vermenigvuldigingsteken wordt weergeven.';
$string['multiplicationsign_link'] = '%%WWWROOT%%/question/type/stack/doc/doc.php/Authoring/Options.md#multiplication';
$string['mustverify'] = 'Student moet verifiëren';
$string['mustverify_link'] = '%%WWWROOT%%/question/type/stack/doc/doc.php/Authoring/Inputs.md#Student_must_verify';
$string['namealreadyused'] = 'Deze naam is al eerder gebruikt.';
$string['newnameforx'] = 'Nieuwe naam voor \'{$a}\'';
$string['next'] = 'Volgende';
$string['nodehelp'] = 'Antwoordboom knoop';
$string['nodehelp_help'] = '### Antwoordtest
Een antwoordtest wordt gebruikt om twee expressies te vergelijken zodat gecontroleerd kan worden of de twee voldoen aan de gestelde wiskundige criteria.

### SAns
Dit is de eerste expressie die nodig is voor de antwoordtest functie. In asymetrische tests hoort hier het antwoord van de student in te staan (STANDAARD: ans1) hoewel er elke geldige CAS expressie kan worden ingevuld. Dit is afhankelijk van de vraagvariabelen of de feedbackvariabelen.

### TAns
Dit is de tweede expressie die nodig is voor de antwoordtest functie. In asymetrische tests is dit het antwoord van de leraar, er kan elke geldige CAS expressie worden ingevuld. Dit is afhankelijk van de vraagvariabelen of de feedbackvariabelen.

### Testopties
Dit veld maakt het mogelijk om extra opties aan de antwoordtest toe te voegen, zoals:een variabele of een numerieke precisie.

### Stil
Wanneer dit op ja staat, wordt de feedback automatisch gegenereerd, maar de antwoordtest wordt achtergehouden en niet getoond aan de leerling. De feedbackvelden in de takken worden niet gewijzigd door deze optie.';
$string['nodex'] = 'Knoop {$a}';
$string['nodexdelete'] = 'Verwijder knoop {$a}';
$string['nodexfalsefeedback'] = 'Knoop {$a} \'fout\'-feedback';
$string['nodextruefeedback'] = 'Knoop {$a} \'goed\'-feedback';
$string['nodexwhenfalse'] = 'Knoop {$a} als \'fout\'';
$string['nodexwhentrue'] = 'Knoop {$a} als \'goed\'';
$string['nonempty'] = 'Dit mag niet leeg zijn.';
$string['noprtsifnoinputs'] = 'Een vraag zonder inputs kan geen PRT\'s hebben.';
$string['notanswered'] = '(Onbeantwoord)';
$string['notavalidname'] = 'Geen geldige naam';
$string['notestcasesyet'] = 'Er zijn nog geen testcases toegevoegd.';
$string['numericalinputdp'] = 'Je moet juist \\( {$a} \\)  decimalen invoeren.';
$string['numericalinputmaxdp'] = 'Je mag maximaal \\( {$a} \\)  decimalen invoeren';
$string['numericalinputmaxsf'] = 'Je mag maximaal \\( {$a} \\) beduidende cijfers invoeren.';
$string['numericalinputmindp'] = 'Je moet minstens \\( {$a} \\) decimalen geven.';
$string['numericalinputminmaxerr'] = 'Het vereiste minimale aantal numerieke plaatsten is groter dan het maximale aantal plaatsen!';
$string['numericalinputminsf'] = 'Je moet minstens \\( {$a} \\) beduidende cijfers geven.';
$string['numericalinputminsfmaxdperr'] = 'Geef geen vereisten op voor zowel aantal decimalen als beduidende cijfers in hetzelfde invoerveld.';
$string['numericalinputmustfloat'] = 'Deze invoer verwacht een drijvendekommagetal.';
$string['numericalinputmustnumber'] = 'De invoer verwacht een getal.';
$string['numericalinputmustrational'] = 'Deze invoer verwacht een breuk of een rationaal getal.';
$string['numericalinputsf'] = 'Je moet exact \\( {$a} \\)  beduidende cijfers geven.';
$string['numericalinputvarsforbidden'] = 'Deze invoer verwacht een getal en mag dus geen variabelen bevatten.';
$string['options'] = 'Opties';
$string['overallresult'] = 'Het eindresultaat';
$string['penalty'] = 'Strafpunten';
$string['penalty_link'] = '%%WWWROOT%%/question/type/stack/doc/doc.php/Authoring/Feedback.md';
$string['penaltyerror'] = 'Het strafpunt moet een numerieke waarde tussen 0 en 1 zijn.';
$string['penaltyerror2'] = 'Het strafpunt moet leeg zijn of een numerieke waarde tussen 0 en 1.';
$string['phpcasstring'] = 'PHP output';
$string['phpsuitecolerror'] = 'PHP-fouten';
$string['phpvalid'] = 'V1';
$string['pleaseananswerallparts'] = 'Beantwoord alle delen van de vraag';
$string['pleasecheckyourinputs'] = 'Controleer of je antwoord juist weergegeven wordt.';
$string['pluginname'] = 'STACK';
$string['pluginname_help'] = 'STACK is een beoordelingssysteem voor wiskunde.';
$string['pluginnameadding'] = 'STACK-vraag toevoegen';
$string['pluginnameediting'] = 'STACK-vraag bewerken';
$string['pluginnamesummary'] = 'Met STACK maak je wiskundevragen voor de Moodle test. Deze gebruiken een computer algebrasysteem om de wiskundige eigenschappen van de antwoorden van leerlingen te analyseren.';
$string['privacy:metadata'] = 'De STACK vraag-plugin bewaart geen persoonlijke gegevens.';
$string['prtcorrectfeedback'] = 'Standaardfeedback voor juist';
$string['prtincorrectfeedback'] = 'Standaardfeedback voor niet juist';
$string['prtpartiallycorrectfeedback'] = 'Standaardfeedback voor deels juist';
$string['questionnotdeployedyet'] = 'Er zijn nog geen varianten van deze vraag uitgerold.';
$string['questionnote'] = 'Vraagnotitie';
$string['questionnote_link'] = '%%WWWROOT%%/question/type/stack/doc/doc.php/Authoring/Question_note.md';
$string['questionnotempty'] = 'De vraagtoevoeging kan niet leeg gelaten worden als gebruik gemaakt wordt van rand() in de variabelen. De vraagtoevoeging wordt gebruikt om onderscheid te maken tussen verschillende willekeurige versies van de vraag.';
$string['questionpreview'] = 'Vraag voorbeeld';
$string['questionsimplify'] = 'Vraagniveau vereenvoudigen';
$string['questionsimplify_help'] = 'Bepaald de globale variabele "simp" in Maxima voor de hele vraag.';
$string['questionsimplify_link'] = '%%WWWROOT%%/question/type/stack/doc/doc.php/CAS/Maxima.md#Simplification';
$string['questiontestempty'] = 'Lege vraagtekst niet toegestaan';
$string['questiontests'] = 'Vraagtekst';
$string['questiontestsdefault'] = '(Standaard)';
$string['questiontestspass'] = 'Alle vraagtesten zijn gelukt';
$string['questiontext'] = 'Vraagtekst';
$string['questiontext_help'] = 'De vraagtekst is CASText. Dit is de "vraag" die de leerling ziet. Je moet er invoerelementen en validatiestrings inzetten, enkel en alleen in dit veld. Gebruik bijvoorbeeld `[[input:ans1]] [[validation:ans1]]`.';
$string['questiontext_link'] = '%%WWWROOT%%/question/type/stack/doc/doc.php/Authoring/CASText.md#question_text';
$string['questiontextfeedbacklanguageproblems'] = 'Er zijn geen inconsistenties in de feedback-tags tussen de verschillende talen.';
$string['questiontextfeedbackonlycontain'] = 'De vraagtekst gecombineerd met specifieke feedback mag het token  \'{$a}\' maar één keer bevatten.';
$string['questiontextlanguages'] = 'Volgende taaltags gevonden in je vraag:  {$a}.';
$string['questiontextmustcontain'] = 'De vraagtekst moet het token  \'{$a}\' bevatten.';
$string['questiontextnonempty'] = 'De vraagtekst mag niet leeg zijn.';
$string['questiontextonlycontain'] = 'De vraagtekst mag het token  \'{$a}\' maar één keer bevatten.';
$string['questiontextplaceholderswhitespace'] = 'Plaatshouders mogen geen witruimte bevatten. Dit blijkt wel zo te zijn:  \'{$a}\'.';
$string['questionvalue'] = 'Vraagwaarde';
$string['questionvaluepostive'] = 'De vraagwaarde mag niet negatief zijn.';
$string['questionvariables'] = 'Vraagvariabelen';
$string['questionvariables_help'] = 'Met dit veld kun je CAS-variabelen definiëren en wijzigen, vb om willekeurige varianten te maken. Deze zijn te gebruiken in alle andere delen van de vraag.';
$string['questionvariables_link'] = '%%WWWROOT%%/question/type/stack/doc/doc.php/Authoring/Variables.md#Question_variables';
$string['questionvariablevalues'] = 'Waarde vraagvariabele';
$string['questionwarnings'] = 'Vraagwaarschuwingen';
$string['questionwarnings_help'] = 'Vraagwaarschuwingen zijn problemen die je misschien wil aanpakken, maar die geen echte fouten zijn.';
$string['quiet'] = 'Stil';
$string['quiet_help'] = 'Wanneer hier voor \'ja\' wordt gekozen, wordt alle automatisch gegenereerde feedback onderdrukt en niet weergegeven aan de student. De feedback velden in de vertakkingen worden niet beïnvloed door deze instelling.';
$string['renamequestionparts'] = 'Delen van de vraag hernoemen';
$string['replacedollarscount'] = 'Deze categorie bevat {$a} STACK-vragen.';
$string['replacedollarsin'] = 'Herstelde wiskunde scheidingstekens in veld {$a}';
$string['replacedollarsindex'] = 'Contexten met STACK-vragen';
$string['replacedollarsindextitle'] = 'Vervang $s in vraagteksten';
$string['replacedollarsnoproblems'] = 'Geen problematische scheidingstekens gevonden.';
$string['replacedollarstitle'] = 'Vervang $s in vraagteksten in {$a}';
$string['requirelowestterms_link'] = '%%WWWROOT%%/question/type/stack/doc/doc.php/Authoring/Inputs.md#Require_lowest_terms';
$string['runquestiontests'] = 'Vraagtesten en uitgerolde varianten';
$string['runquestiontests_alert'] = 'Er ontbreken testen of varianten voor deze vraag';
$string['runtimeerror'] = 'Deze vraag gaf een onverwachte interne fout. Zoek hulp, bijvoorbeeld van je leraar.';
$string['runtimefielderr'] = 'Het veld ""{$a->field}"" genereerde volgende fout: {$a->err}';
$string['sans_help'] = 'Dit is de eerste expressie die nodig is voor de antwoordcontrôle functie. In asymetrische tests hoort hier het antwoord van de student in te staan (STANDAARD: ans1) hoewel er elke geldige CAS expressie kan worden ingevuld. Dit is afhankelijk van de vraagvariabelen of de feedbackvariabelen.';
$string['sans_link'] = '%%WWWROOT%%/question/type/stack/doc/doc.php/Authoring/Answer_Tests/index.md';
$string['score'] = 'Score';
$string['scoreerror'] = 'De score moet een numerieke waarde zijn tussen de 0 en 1.';
$string['seethisquestioninthequestionbank'] = 'Bekijk deze vraag in de vragenpool';
$string['settingajaxvalidation'] = 'Onmiddellijk valideren';
$string['settingajaxvalidation_desc'] = 'Wanneer deze instelling is ingeschakeld, dan zal de invoer van leerlingen onmiddellijk gevalideerd worden wanneer ze pauzeren met typen. Dit geeft een betere gebruikerservaring, maar zal de serverbelasting verhogen.';
$string['settingcasdebugging'] = 'CAS foutopsporing';
$string['settingcasdebugging_desc'] = 'Of er foutopsporingsinformatie moet bewaard worden over de CAS-verbinding.';
$string['settingcasmaximaversion'] = 'Maxima-versie';
$string['settingcasmaximaversion_desc'] = 'De versie van de gebruikte Maxima.';
$string['settingcasresultscache'] = 'CAS resultaat cachen';
$string['settingcasresultscache_db'] = 'Cache in databank';
$string['settingcasresultscache_none'] = 'Niet cachen';
$string['settingcastimeout'] = 'CAS verbindings-time-out';
$string['settingcastimeout_desc'] = 'De time-out bij het verbinden met Maxima.';
$string['settingdefaultinputoptions'] = 'Standaard invoer-opties';
$string['settingdefaultinputoptions_desc'] = 'Gebruikt bij het maken van een nieuwe vraag, of bij het toevoegen van nieuwe invoer bij een bestaande vraag.';
$string['settingdefaultquestionoptions'] = 'Standaard invoer-opties';
$string['settingdefaultquestionoptions_desc'] = 'Gebruikt bij het maken van nieuwe vragen';
$string['settingmathsdisplay'] = 'Wiskundefilter';
$string['settingmathsdisplay_desc'] = 'De methode die gebruikt wordt om wiskunde te tonen. Als je Mathjax kiest, dan zul je de instructies op de Gezondheidscontrole-pagina moeten volgen om het in te stellen. Als je een filter selecteert, dan moet je er voor zorgen dat die ingeschakeld is op de Beheer filters configuratiepagina.';
$string['settingmathsdisplay_mathjax'] = 'Mathjax';
$string['settingmathsdisplay_maths'] = 'Oude OU wiskundefilter';
$string['settingmathsdisplay_oumaths'] = 'Nieuwe OU wiskundefilter';
$string['settingmathsdisplay_tex'] = 'Moodle TeX-filter';
$string['settingmaximalibraries'] = 'Optionele Maxima-bibliotheken laden';
$string['settingmaximalibraries_desc'] = 'Dit is een kommagescheiden lijst van Maxima-bibliotheken die automatisch in Maxima geladen worden. Je kunt enkel ondersteunde bibliotheeknamen gebruiken, zoals "stats, distrib, descriptive, simplex". Deze bibliotheken worden niet geladen als je een maxima-versie gebruikt om performantie te optimaliseren.';
$string['settingmaximalibraries_error'] = 'Volgend pakket wordt niet ondersteund: {$a}';
$string['settingmaximalibraries_failed'] = 'Blijkbaar konden sommige Maxima-pakketten die je wou laden niet geladen worden. Zoek in de installatie-instructies naar informatie over deze fout.';
$string['settingplatformmaximacommand'] = 'Maxima-opdracht';
$string['settingplatformmaximacommand_desc'] = 'Als dit leeg gelaten wordt, dan zal STACK een berekende gok doen over waar Maxima gevonden kan worden. Als dat mislukt, dan moet het volledige pad van Maxima of de geoptimaliseerde versie ervan gegeven worden. Gebruik dit enkel voor ontwikkeling en foutopsporing. Gebruik dit niet op een productiesysteem. Gebruik geoptimaliseerd of beter de Maxima Pool-optie.';
$string['settingplatformmaximacommandopt'] = 'Geoptimaliseerde Maxima-opdracht';
$string['settingplatformmaximacommandopt_desc'] = 'Dit moet ingesteld worden op het volledige pad van de geoptimaliseerde maxima versie. Overweeg het gebruik van het time-out commando op Linux-systemen, vb timeout --kill-after=10s 10s maxima';
$string['settingplatformmaximacommandserver'] = 'URL van de Maxima Pool';
$string['settingplatformtype'] = 'Platformtype';
$string['settingplatformtypelinux'] = 'Linux';
$string['settingplatformtypelinuxoptimised'] = 'Linux (geoptimaliseerd)';
$string['settingplatformtypeserver'] = 'Server';
$string['settingreplacedollars'] = 'Vervang <code>$</code> en <code>$$</code>';
$string['settingreplacedollars_desc'] = 'Vervang <code>$</code> en <code>$$</code> scheidingstekens in de vraagtekst, bovenop <code>\\\\[...\\\\]</code> en <code>\\\\(...\\\\)</code>. Een beter optie is om het \'Herstel wiskunde scheidingstekens\'-script te gebruiken waarnaar hieronder verwezen wordt.';
$string['settingserveruserpass'] = 'Server gebruikersnaam:wachtwoord';
$string['settingsmathsdisplayheading'] = 'Wiskunde toon-opties';
$string['settingsmaximasettings'] = 'Verbinden met Maxima';
$string['settingusefullinks'] = 'Handige links';
$string['showingundeployedvariant'] = 'Toon niet uitgerolde variant: {$a}';
$string['showvalidation'] = 'Toon de validatie';
$string['showvalidation_link'] = '%%WWWROOT%%/question/type/stack/doc/doc.php/Authoring/Inputs.md#Show_validation';
$string['showvalidationcompact'] = 'Ja, compact';
$string['showvalidationno'] = 'Nee';
$string['showvalidationyes'] = 'Ja met een variabele lijst';
$string['showvalidationyesnovars'] = 'Ja, zonder variabelenlijst';
$string['singlechargotmorethanone'] = 'Je kunt hier slechts één teken invoeren.';
$string['specificfeedback'] = 'Specifieke feedback';
$string['sqrtsign_link'] = '%%WWWROOT%%/question/type/stack/doc/doc.php/Authoring/Options.md#surd';
$string['stack:usediagnostictools'] = 'Gebruik de STACK-tools';
$string['stackBlock_jsxgraph_height'] = 'De hoogte van een JSXGraph met een bekende CSS lengte-eenheid zijn.';
$string['stackBlock_jsxgraph_height_num'] = 'Het numerieke deel van de hoogte van een JSXGraph moet een getal zijn en mag geen andere tekens bevatten.';
$string['stackBlock_jsxgraph_param'] = 'Het JSXGraph-blok ondersteunt enkele volgende parameters in deze context: {$a->param}.';
$string['stackBlock_jsxgraph_ref'] = 'Het JSXGraph-blok ondersteunt enkel referenties naar inputs die in dezelfde CASText sectie aanwezig zijn. \'{$a->var}\' bestaat hier niet.';
$string['stackBlock_jsxgraph_width'] = 'De breedte van een JSXGraph moet een bekende CSS lengte-eenheid zijn.';
$string['stackBlock_jsxgraph_width_num'] = 'Het numerieke deel van de breedte van een JSXGraph moet een getal zijn en mag geen andere tekens bevatten.';
$string['stackBlock_missmatch'] = 'heeft geen overeenkomsten.';
$string['stackBlock_multiple_else'] = 'Meerdere else-vertakkingen in één if-blok.';
$string['stackBlock_unknownBlock'] = 'Volgend blok is onbekend:';
$string['stackCas_CASError'] = 'CAS gaf volgende fouten terug:';
$string['stackCas_CASErrorCaused'] = 'veroorzaakt volgende fout:';
$string['stackCas_MissingAt'] = 'Er ontbreekt een <code>@</code>-teken.';
$string['stackCas_MissingCloseDisplay'] = 'Er ontbreekt een <code>]</code>.';
$string['stackCas_MissingCloseHTML'] = 'Er ontbreekt een sluitende html-tag.';
$string['stackCas_MissingCloseInline'] = 'Er ontbreekt een <code>\\)</code>.';
$string['stackCas_MissingClosingRawCAS'] = 'Er ontbreekt een <code>#</code>.';
$string['stackCas_MissingClosingTeXCAS'] = '<code>@}</code> ontbreekt.';
$string['stackCas_MissingDollar'] = 'Er ontbreekt een <code>$</code>-teken.';
$string['stackCas_MissingOpenDisplay'] = 'Er ontbreekt een <code>\\</code>.';
$string['stackCas_MissingOpenHTML'] = 'Er ontbreekt een openende html-tag.';
$string['stackCas_MissingOpenInline'] = 'Er ontbreekt een <code>\\(</code>.';
$string['stackCas_MissingOpenRawCAS'] = 'Er ontbreekt een <code>{#</code>.';
$string['stackCas_MissingOpenTeXCAS'] = 'Er ontbreekt een <code>{@</code>.';
$string['stackCas_MissingStars'] = 'Er ontbreken * tekens. Misschien bedoelde je {$a->cmd}.';
$string['stackCas_MissingString'] = 'Er ontbreekt een quote-teken <code>"</code>.';
$string['stackCas_StringOperation'] = 'Er staat een string op de foute plaats. Dit is het probleem: <code>{$a->issue}</code>.';
$string['stackCas_allFailed'] = 'CAS kon geen geëvalueerde expressies teruggeven. Controleer je verbinding met CAS.';
$string['stackCas_apostrophe'] = 'Aanhalingstekens zijn niet toegestaan in antwoorden.';
$string['stackCas_applyfunmakestring'] = 'De naam van de functie kan geen string zijn in <code>{$a->type}</code>.';
$string['stackCas_applyingnonobviousfunction'] = 'De functie-aanroep {$a->problem} heeft blijkbaar geen makkelijk te vinden functienaam. Om veiligheidsredenen moet je de aanroep vereenvoudigen zodat de validatietest de functienaam kan vinden.';
$string['stackCas_badpostfixop'] = 'Je hebt een slechte "postfix" operator in je expressie.';
$string['stackCas_bracketsdontmatch'] = 'De haakjes zijn fout genest in de expressie: {$a->cmd}.';
$string['stackCas_errorpos'] = 'Ongeveer op lijn {$a->line} teken {$a->col}.';
$string['stackCas_failedReturn'] = 'CAS kon geen gegevens teruggeven.';
$string['stackCas_failedReturnOne'] = 'CAS kon niet alle gegevens teruggeven.';
$string['stackCas_failedValidation'] = 'CASText-validatie mislukt.';
$string['stackCas_finalChar'] = '\'{$a->char}\' is een ongeldig laatste teken in {$a->cmd}';
$string['stackCas_forbiddenChar'] = 'CAS-commando\'s mogen volgende tekens niet bevatten: {$a->char}.';
$string['stackCas_forbiddenFunction'] = 'Verboden functie: {$a->forbid}.';
$string['stackCas_forbiddenOperator'] = 'Verboden operator: {$a->forbid}.';
$string['stackCas_forbiddenVariable'] = 'Verboden variabele of constante: {$a->forbid}.';
$string['stackCas_forbiddenWord'] = 'De expressie {$a->forbid} is verboden.';
$string['stackCas_inputsdefined'] = 'Je mag invoernamen niet als variabele gebruiken. Je probeerde <code>{$a}</code> te definiëren.';
$string['stackCas_invalidCommand'] = 'CAS-commando niet geldig.';
$string['stackCas_missingLeftBracket'] = 'Er ontbreekt een linkerhaakje <span class="stacksyntaxexample">{$a->bracket}</span> in de expressie: {$a->cmd}.';
$string['stackCas_missingRightBracket'] = 'Er ontbreekt een rechterhaakje <span class="stacksyntaxexample">{$a->bracket}</span> in de expressie: {$a->cmd}.';
$string['stackCas_newline'] = 'Nieuwe regel-tekens zijn niet toegestaan in antwoorden.';
$string['stackCas_noFunction'] = 'Het gebruik van de functie {$a->forbid} in de term {$a->term} is niet toegestaan in deze context.';
$string['stackCas_operatorAsVariable'] = 'Operator {$a->op} geïnterpreteerd als variable, controleer syntax.';
$string['stackCas_percent'] = '% gevonden in expressie {$a->expr}.';
$string['stackCas_qmarkoperators'] = 'Vraagtekens worden niet toegestaan in antwoorden.';
$string['stackCas_reserved_function'] = 'De functienaam  "{$a->name}" is niet toegestaan in deze vraag. Neem contact op met je leraar.';
$string['stackCas_spaces'] = 'Ongeldige spaties gevonden in expressie {$a->expr}.';
$string['stackCas_spuriousop'] = 'Onbekende operator: {$a->cmd}.';
$string['stackCas_studentInputAsFunction'] = 'Het gebruik van leerling-invoer als de naam van een functie is niet toegestaan.';
$string['stackCas_underscores'] = 'Volgend gebruik van een underscore is niet toegestaan: {$a}.';
$string['stackCas_unencpsulated_comma'] = 'Er verschijnt op een vreemde manier een komma in je expressie. Komma\'s worden gebruikt om zaken te scheiden, zoals lijsten, sets enz. Je moet een decimaal punt gebruiken in decimalen, geen komma.';
$string['stackCas_unitssynonym'] = 'Je hebt blijkbaar eenheden {$a->forbid}.  Bedoelde je {$a->unit}?';
$string['stackCas_unknownFunction'] = 'Onbekende functie: {$a->forbid} in de term {$a->term}.';
$string['stackCas_unknownFunctionCase'] = 'Invoer is hoodlettergevoelig.: {$a->forbid} is een onbekende functie. Bedoelde je {$a->lower}?';
$string['stackCas_unknownUnitsCase'] = 'De invoer van eenheden is hoofdlettergevoelig:  {$a->forbid} is een onbekende eenheid. Bedoelde je één uit volgende lijst {$a->unit}?';
$string['stackCas_unknownVariableCase'] = 'Invoer is hoodlettergevoelig: {$a->forbid} is een onbekende variabele. Bedoelde je {$a->lower}?';
$string['stackCas_useinsteadChar'] = 'Wissel <span class="stacksyntaxexample">{$a->bad}</span> met \'<span class="stacksyntaxexample">{$a->char}</span>\'.';
$string['stackDoc_404'] = 'Fout 404';
$string['stackDoc_404message'] = 'Bestand niet gevonden.';
$string['stackDoc_directoryStructure'] = 'Mappenstructuur';
$string['stackDoc_docs'] = 'STACK Documentatie';
$string['stackDoc_docs_desc'] = '<a href="{$a->link}">Documentatie voor STACK</a>: een lokale statische wiki die de code documenteert die op je site loopt.';
$string['stackDoc_home'] = 'Documentatie startpagina';
$string['stackDoc_index'] = 'Categorie-index';
$string['stackDoc_siteMap'] = 'Site map';
$string['stackDoc_siteMap_en'] = 'Engelstalige site-map';
$string['stackDoc_version'] = 'Je site gebruikt STACK versie {$a}.';
$string['stackInstall_input_intro'] = 'Met deze pagina kun je testen hoe STACK verschillende invoer van leerlingen interpreteert. Dit controleert nu enkel de meest vrije instellingen om te proberen een informele syntax aan te passen en sterren in te voeren. <br />\'V\' kolommen registreren geldigheid zoals beoordeeld door PHP en de CAS.  V1 = PHP geldig, V2 = CAS geldig.';
$string['stackInstall_input_title'] = 'Een testomgeving voor het valideren van de invoer van leerlingen';
$string['stackInstall_input_title_desc'] = 'Het  <a href="{$a->link}">invoer-tests script</a> voorziet testcases om te tonen hoe STACK wiskundige expressies interpreteert. Zij zijn ook nuttig om te leren door voorbeelden.';
$string['stackInstall_testsuite_choose'] = 'Selecteer een antwoordcontrôle';
$string['stackInstall_testsuite_errors'] = 'De vraag genereerde de volgende fouten.';
$string['stackInstall_testsuite_fail'] = 'Niet alle tests zijn geslaagd!';
$string['stackInstall_testsuite_failingtests'] = 'Mislukte testen';
$string['stackInstall_testsuite_failingupgrades'] = 'Vragen waarvoor de upgrade mislukt is.';
$string['stackInstall_testsuite_intro'] = 'Deze pagina maakt het voor je mogelijk om te testen of de STACK antwoordcontrole functie goed werkt. Let op dat alleen antwoordcontroles kunnen worden getest door de webinterface. Andere Maxima commands moeten getest worden via de commandline: bekijk unittest.mac.';
$string['stackInstall_testsuite_nogeneralfeedback'] = 'Vragen zonder algemene feedback: leerlingen appreciëren werkende oplossingen!';
$string['stackInstall_testsuite_notests'] = 'Vragen zonder testen: voeg er toe!';
$string['stackInstall_testsuite_pass'] = 'Alle testen geslaagd!';
$string['stackInstall_testsuite_title'] = 'Een testomgeving voor de STACK antwoordcontrole functie';
$string['stackInstall_testsuite_title_desc'] = 'Het <a href="{$a->link}">Antwoordcontrole testscript</a> bepaalt of de antwoordcontrolefunctie goed werkt. Het script is ook handig om te leren van voorbeelden, hoe elke antwoordcontrole gebruikt kan worden.';
$string['stackOptions_AnsTest_values_AlgEquiv'] = 'AlgEquiv';
$string['stackOptions_AnsTest_values_CasEqual'] = 'CasEqual';
$string['stackOptions_AnsTest_values_CompSquare'] = 'CompletedSquare';
$string['stackOptions_AnsTest_values_Diff'] = 'Diff';
$string['stackOptions_AnsTest_values_EqualComAss'] = 'EqualComAss';
$string['stackOptions_AnsTest_values_Expanded'] = 'Expanded';
$string['stackversionedited'] = 'Deze vraag is bewerkt met STACK versie {$a}.';
$string['stackversionerror'] = 'Deze vraag gebruikt {$a->pat} in de {$a->qfield}, die gewijzigd is in STACK versie {$a->ver} en wordt niet meer ondersteund.';
$string['stackversionerroralt'] = 'Een alternatief is {$a}.';
$string['stackversionmulerror'] = 'Deze vraag heeft een invoer die de "mul"-optie gebruikt, die niet meer ondersteund wordt na STACK 4.2. Wijzig deze vraag.';
$string['stackversionnone'] = 'Deze vraag is niet meer bewerkt sinds de vraag variantnummering werd ingevoerd in STACK 4.2. Wijzig deze vraag voorzichtig.';
$string['stackversionnow'] = 'De huidige versie van STACK is {$a}.';
$string['stackversionregexp'] = 'De RegExp antwoordtest wordt niet meer ondersteund na STACK versie 4.3. Gebruik in de plaats de nieuwe SRegExp.';
$string['stop'] = '[stop]';
$string['strictsyntax'] = 'Strikte syntax';
$string['strictsyntax_help'] = 'Deze optie wordt niet meer gebruikt en zal verwijderd worden.';
$string['strictsyntax_link'] = '%%WWWROOT%%/question/type/stack/doc/doc.php/';
$string['strlengtherror'] = 'Deze string mag niet langer dan 255 tekens zijn.';
$string['studentValidation_invalidAnswer'] = 'Dit antwoord is niet geldig.';
$string['studentValidation_listofunits'] = 'Volgende eenheden zijn in jouw antwoord gevonden: {$a}';
$string['studentValidation_listofvariables'] = 'Volgende variabelen zijn in jouw antwoord gevonden: {$a}';
$string['studentValidation_notes'] = '(Deze invoer is niet automatisch door STACK beoordeeld.)';
$string['studentValidation_yourLastAnswer'] = 'Je laatste antwoord is {$a}';
$string['studentanswer'] = 'Leerlingantwoord';
$string['switchtovariant'] = 'Wissel naar arbitraire variant';
$string['symbolicprtcorrectfeedback'] = '<span style="font-size: 1.5em; color:green;"><i class="fa fa-check"></i></span>';
$string['symbolicprtincorrectfeedback'] = '<span style="font-size: 1.5em; color:red;"><i class="fa fa-times"></i></span>';
$string['symbolicprtpartiallycorrectfeedback'] = '<span style="font-size: 1.5em; color:orange;"><i class="fa fa-adjust"></i></span>';
$string['syntaxattribute'] = 'Hint attirbuut';
$string['syntaxattribute_help'] = 'De syntaxhint zal verschijnen als bewerkbare *waarde* of als niet bewerkbare *plaatshouder*';
$string['syntaxattribute_link'] = '%%WWWROOT%%/question/type/stack/doc/doc.php/Authoring/Inputs.md#Syntax_Hint';
$string['syntaxattributeplaceholder'] = 'Plaatshouder';
$string['syntaxattributevalue'] = 'Waarde';
$string['syntaxhint'] = 'Syntaxhint';
$string['syntaxhint_help'] = 'De syntaxhint zal in het antwoordvak van de leerling verschijnen als die leeg gelaten wordt.';
$string['syntaxhint_link'] = '%%WWWROOT%%/question/type/stack/doc/doc.php/Authoring/Inputs.md#Syntax_Hint';
$string['tans_help'] = 'Dit is de tweede expressie die nodig is voor de antwoordcontrole functie. In asymmetrische tests is dit het antwoord van de leraar, er kan elke geldige CAS expressie worden ingevuld. Dit is afhankelijk van de vraagvariabelen of de feedbackvariabelen.';
$string['tans_link'] = '%%WWWROOT%%/question/type/stack/doc/doc.php/Authoring/Answer_Tests/index.md';
$string['tansrequired'] = 'TAns mag niet leeg zijn.';
$string['teacheranswer'] = 'Leraarantwoord';
$string['teacheranswercase'] = 'Gebruik het antwoord van je leraar als test.';
$string['teacheranswerempty'] = 'Deze invoer kan leeg gelaten worden.';
$string['teacheranswershow'] = 'Het juiste antwoord is \\( {$a->display} \\), dat als volgt getypt kan worden: {$a->value}';
$string['teacheranswershow_disp'] = 'Een juist antwoord is {$a->display}.';
$string['teacheranswershow_mcq'] = 'Een juist antwoord is {$a->display}.';
$string['teacheranswershownotes'] = 'Er is geen juist antwoord voorzien voor deze input.';
$string['teachersanswer'] = 'Modelantwoord';
$string['teachersanswer_help'] = 'De docent moet een modelantwoord opgeven voor elke input. Dit moet een geldige Maxima expressie zijn, waarbij gebruik gemaakt mag worden van de vraagvariabelen.';
$string['teachersanswer_link'] = '%%WWWROOT%%/question/type/stack/doc/doc.php/Authoring/Inputs.md#model_answer';
$string['testcasexresult'] = 'Testcase {$a->no}{$a->result}';
$string['testingquestion'] = 'Vraag aan het testen {$a}';
$string['testingquestionvariants'] = 'Vraagvarianten voorbereiden';
$string['testinputs'] = 'Testinputs';
$string['testinputsimpwarning'] = 'Let op dat de test inputs altijd <em>onvereenvoudigd</em> zijn, ongeacht de vraag- of PRT-optie-instellingen. Gebruik <tt>ev(....,simp)</tt> om een gedeelte of de gehele testinput te vereenvoudigen.';
$string['testoptions'] = 'Test opties';
$string['testoptions_help'] = 'Dit veld maakt het mogelijk voor om een extra optie op te geven voor de antwoordcontrole functie; b.v. een variabele of een numerieke precisie.';
$string['testoptions_link'] = '%%WWWROOT%%/question/type/stack/doc/doc.php/Authoring/Potential_response_trees.md';
$string['testoptionsinvalid'] = 'Deze opties zijn niet geldieg: {$a}';
$string['testoptionsrequired'] = 'Testopties zijn vereist voor deze test.';
$string['testpassesandfails'] = '{$a->passes} geslaagd en {$a->fails} mislukt.';
$string['testsuitecolerror'] = 'CAS-fouten';
$string['testsuitecolpassed'] = 'Geslaagd?';
$string['testsuitefail'] = 'Mislukt';
$string['testsuitefeedback'] = 'Feedback';
$string['testsuiteknownfail'] = 'Verwachte mislukking';
$string['testsuiteknownfailmaths'] = 'Verwachte mislukking (wiskunde)';
$string['testsuitenotests'] = 'Aantal testen: {$a->no}.';
$string['testsuitepass'] = 'Geslaagd';
$string['testsuiteteststook'] = 'Test duurde {$a->time} seconden.';
$string['testsuiteteststookeach'] = 'Gemiddelde per test: {$a->time} seconden.';
$string['testthisvariant'] = 'Wissel om deze variant te testen';
$string['tidyquestion'] = 'STACK vragen opschonen';
$string['tidyquestionx'] = 'Hernoem de delen van vraag {$a}';
$string['trig_degrees_radians_name'] = 'Graden en radialen';
$string['true'] = 'Waar';
$string['truebranch'] = 'Waar vertakking';
$string['truebranch_help'] = 'Met deze velden bepaal je wat er gebeurt als de antwoordcontrole een antwoord goed rekent.
### Modus en score
Hoe de beoordeling wordt aangepast: = betekent, ken een bepaalde score toe, +/- betekent tel op bij/haal af van de huidige totale score.

### Strafpunten
In adaptieve of interactieve modus, ken zoveel strafpunten toe.

### Volgende
Hier geef je een link naar de volgende node, of anders \'stop\'.

### Feedback-toevoeging
Dit is een tag voor rapportdoeleinden. Het is gemaakt om een uniek pad door de vertakkingen van elke antwoordcontrole vast te leggen. Het wordt automatisch gegenereerd, maar kan gewijzigd worden in iets wat een duidelijkere betekenis heeft.';
$string['unrecognisedfactstags'] = 'De volgende feiten tag(s) zijn niet herkend:{$a->tags}.';
$string['variant'] = 'Variant';
$string['variantsselectionseed'] = 'Willekeurige groep';
$string['verifyquestionandupdate'] = 'Controleer de vraagtekst en pas het formulier aan';
$string['yamlrecommended'] = 'Het installeren van de YAML-bibliotheek wordt aangeraden voor STACK';
$string['youmustconfirm'] = 'Je moet hier bevestigen.';
