<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'groupformation', language 'nl', version '5.1'.
 *
 * @package     groupformation
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['activity'] = 'Activiteit';
$string['activity_end'] = 'Stop activiteit';
$string['activity_start'] = 'Start activiteit';
$string['activity_visible'] = 'Activiteit is niet zichtbaar voor jou.';
$string['add_line'] = 'Voeg regel toe';
$string['adopt_groups_task'] = 'Groep adoptietaak';
$string['allanswersrequired'] = 'Alle vragen moeten beantwoord worden om de activiteit af te ronden.';
$string['allanswersrequired_description'] = 'Alle vragen moeten beantwoord worden om de activiteit af te ronden.';
$string['alreadySubmitted'] = 'Al ingediend';
$string['analyse'] = 'Analyse';
$string['answers_for_eval_text'] = 'De evaluatie-tab toont terugkoppeling als alle vragen zijn beantwoord. Evaluatie is niet mogelijk zolang er onbeantwoorde vragen zijn.';
$string['archive_activity_task'] = 'Archiveringstaak';
$string['archived_activity_admin'] = 'De activiteit is gearchiveerd. Er hoeft niets gedaan te worden.';
$string['archived_activity_answers'] = 'De activiteit is gearchiveerd. Je antwoorden zijn verwijderd en je hoeft hier niets meer te doen.';
$string['are'] = 'Er zijn';
$string['are_now'] = 'Nu zijn er';
$string['availability_nochangespossible'] = 'De vragenlijst is al beantwoord. Je kunt de beschikbaarheid niet meer aanpassen.';
$string['bad'] = 'slecht';
$string['build_groups_task'] = 'Groepformatietaak';
$string['cannotloadxml'] = 'Can XML-bestand niet openen';
$string['category_catfreetext'] = 'Vrije tekst';
$string['category_catmultiselect'] = 'Meerdere opties';
$string['category_catnumber'] = 'Nummer';
$string['category_character'] = 'Teken';
$string['category_demographic'] = 'Demografisch';
$string['category_general'] = 'Algemeen';
$string['category_grade'] = 'Doelen';
$string['category_honesty'] = 'Eerlijkheid';
$string['category_knowledge'] = 'Kennis';
$string['category_learning'] = 'Leren';
$string['category_motivation'] = 'Motivatie';
$string['category_points'] = 'Doelen';
$string['category_self'] = 'Zelftoets';
$string['category_sellmo'] = 'Motivatie voor leren en prestatie';
$string['category_skills'] = 'Ervaring';
$string['category_srl'] = 'Zelf-beheerd leren';
$string['category_team'] = 'Team';
$string['category_times'] = 'Beschikbaarheid';
$string['category_topic'] = 'Onderwerpen';
$string['choose_evaluationmethod'] = 'Kies methode';
$string['choose_number'] = 'Kies nummer';
$string['choose_scenario'] = 'Kies scenario';
$string['cohort_index'] = 'Cohorts-Performance-Index:';
$string['cohort_index_info'] = 'De Cohorts-Performance-Index (KPI) is een maat voor de kwaliteit van de gevormde groepen en heeft een waarde tussen 0 en 1. Hogere waardes geven betere kwaliteit aan.';
$string['committed_not_completed'] = 'van de ingestuurde vragenlijsten zijn niet volledig.';
$string['completeTheForm'] = 'Vul vragenlijst in';
$string['completed_questionnaire'] = 'volledig beantwoorde vragenlijsten.';
$string['consent_agree'] = 'Ik ga akkoord met de voorwaarden';
$string['consent_alert_message'] = 'Je moet uw toestemming geven voordat je de vragenlijst kunt openen. Scroll naar beneden en ga akkoord met de voorwaarden voordat je op "Volgende" klikt.';
$string['consent_header'] = 'Ik wil deelnemen aan het groepformatieproces en ben bereid de vragen te beantwoorden. Deelname heeft geen invloed op het beoordelingsproces of het cijfer.';
$string['consent_header_import'] = 'Door je antwoorden te importeren, geef je aan te willen meedoen in het groepsformatieproces en geef je aan bereid te zijn de vragen te beantwoorden. Deelname heeft geen invloed op het beoordelingsproces of het cijfer.';
$string['consent_message'] = '<ul></li>
De leraar heeft geen directe toegang tot mijn antwoorden voor de groepsformatie (alleen ikzelf kan de resultaten over mijn persoonlijkheid en die van de groep inzien)
</li><li>
Mijn persoonsgegevens zullen worden verwijderd op het moment dat de cursus eindigt - ten laatste na 360 dagen.</li></ul>';
$string['consent_opt_in'] = 'Toestemming (opt-in)';
$string['contact_members'] = 'Je kunt op de gebruikersnamen klikken om contact te leggen met de leden van je team.';
$string['continueTheForm'] = 'Ga door';
$string['cron_job_not_running'] = 'Het groepsformatieproces loopt op bepaalde tijden. Helaas reageert het op dit moment niet of is niet actief. Stuur een bericht aan de beheerder als je deze melding over 24u nog steeds ziet.';
$string['drop_selection'] = 'Deselecteer alles';
$string['edit_param'] = 'Bewerk';
$string['editparam'] = 'Bewerk parameters';
$string['emailnotifications'] = '<i style="color:red;">Het automatische bericht dat aangeeft dat het groepsformatieproces klaar is, is niet beschikbaar.</i>';
$string['emailnotifications_description'] = '<i style="color:red;">Het automatische bericht dat aangeeft dat het groepsformatieproces klaar is, is niet beschikbaar.</i>';
$string['emailnotifications_info'] = 'Je krijgt een bericht als het is afgerond.';
$string['endtime'] = 'Eindtijd';
$string['eval_caption_course'] = 'Cursus';
$string['eval_caption_group'] = 'Groep';
$string['eval_caption_user'] = 'Gebruiker';
$string['eval_cutoff_caption_agreeableness'] = 'Sociale betrouwbaarheid';
$string['eval_cutoff_caption_challenge'] = 'Uitdaging';
$string['eval_cutoff_caption_conscientiousness'] = 'Zorgvuldigheid';
$string['eval_cutoff_caption_extraversion'] = 'Extraversie';
$string['eval_cutoff_caption_interest'] = 'Interesse';
$string['eval_cutoff_caption_lackofconfidence'] = 'Verwachting van mislukken';
$string['eval_cutoff_caption_neuroticism'] = 'Neuroticisme';
$string['eval_cutoff_caption_openness'] = 'Open voor ervaring';
$string['eval_cutoff_caption_successprobability'] = 'Kans op succes';
$string['eval_final_text'] = 'De vergelijking is gebaseerd op {$a->percent}% van de antwoorden ({$a->completed} die {$a->coursesize} gebruikers al beantwoord hebben).';
$string['eval_first_page_text'] = 'Bijgaand de persoonlijke feedback op je antwoorden in de vragenlijst. Vragen met hetzelfde onderwerp zijn samengenomen, gemiddelden zijn berekend en vergeleken met de leerlingenpopulatie. Percentielen zijn berekend om aan te geven hoe vaak een bepaalde waarde voorkomt, niet om aan te geven of een bepaalde waarde goed of fout is. Een percentiel van 10% betekent dat 10% van de populatie dezelfde of lagere waarde heeft behaald. Een percentiel van 90% betekent dat 90% van de populatie hetzelfde of lagere waarde heeft behaald.
\\n\\n
Je krijgt terugkoppeling op vijf persoonlijkheidskenmerken die relatief stabiel zijn oftewel onafhankelijk van specifieke situaties: dit zijn extraversie, neuroticisme, zorgvuldigheid, sociale betrouwbaarheid, en open voor ervaring. Daarna krijg je terugkoppeling op vier motivatiedimensies die gerelateerd zijn aan de huidige cursus of opdracht en dus variëren per situatie: interesse, uitdaging, kans op succes en verwachting van mislukken.';
$string['eval_first_page_title'] = 'Algemene informatie';
$string['eval_max_caption_agreeableness'] = 'aangenaam';
$string['eval_max_caption_challenge'] = 'Uitdaging';
$string['eval_max_caption_conscientiousness'] = 'zorgvuldig';
$string['eval_max_caption_extraversion'] = 'extravert';
$string['eval_max_caption_interest'] = 'Interesse';
$string['eval_max_caption_lackofconfidence'] = 'Verwachting van mislukken';
$string['eval_max_caption_neuroticism'] = 'emotioneel stabiel';
$string['eval_max_caption_openness'] = 'open';
$string['eval_max_caption_successprobability'] = 'Kans op succes';
$string['eval_max_text_agreeableness'] = 'Sociale betrouwbaarheid refereert aan het gedrag naar andere mensen.';
$string['eval_max_text_challenge'] = 'Uitdaging is een motivatie-dimensie die uitgeeft in welke mate de huidige cursus gezien wordt als zijnde relevant voor prestatie. M.a.w. in welke mate je het gevoel hebt je skills en vaardigheden toe te passen.';
$string['eval_max_text_conscientiousness'] = 'Zorgvuldigheid beschrijft de mate van zelfbeheersing, accuraatheid en determinatie.';
$string['eval_max_text_extraversion'] = 'Introversie en extraversie zijn twee uiteinden van een persoonlijkheidskenmerk dat wordt gekarakteriseerd door interactie met de omgeving. Introversie geeft een naar binnen gerichte houding aan, terwijl extraversie naar buiten gericht is.';
$string['eval_max_text_interest'] = 'Interesse is een motivatie-dimensie die is afgeleid van de waardering van de taakinhoud. Interesse wordt o.a. uitgedrukt als taken met plezier en vrijwillig uitgevoerd worden. Vooral als taken zelfstandig uitgevoerd worden en gericht zijn op diepgaand begrip kan interesse sterk bijdragen aan het succes van leren.';
$string['eval_max_text_lackofconfidence'] = 'Verwachting van mislukken is een vorm van motivatie die voortkomt uit de angst de taak niet te kunnen uitvoeren of afronden, gecombineerd met het idee dat men door de druk van de situatie niet optimaal zal kunnen studeren.';
$string['eval_max_text_neuroticism'] = 'Het persoonlijkheidskenmerk neuroticisme geeft aan dat er individuele verschillen zijn in het ervaren van negatieve emoties en staat ook bekend als emotionele instabiliteit. De tegenpool is emotionele stabiliteit.';
$string['eval_max_text_openness'] = 'Open voor ervaring beschrijft de interesse en de mate van waarin opgegaan wordt in nieuwe ervaringen en indrukken.';
$string['eval_max_text_successprobability'] = 'Kans op succes is gebaseerd op aannames over de mate dat iemand er vertrouwen in heeft een goed resultaat te behalen in de huidige cursus of opdracht. Het gevoel hebben voldoende capabel te zijn of de taak eenvoudig te vinden kan aanleiding geven tot de verwachting op een hoge kans op succes.';
$string['eval_min_caption_agreeableness'] = 'competetief';
$string['eval_min_caption_challenge'] = 'Uitdaging';
$string['eval_min_caption_conscientiousness'] = 'onzorgvuldig';
$string['eval_min_caption_extraversion'] = 'introvert';
$string['eval_min_caption_interest'] = 'Interesse';
$string['eval_min_caption_lackofconfidence'] = 'Verwachting van mislukken';
$string['eval_min_caption_neuroticism'] = 'emotioneel instabiel';
$string['eval_min_caption_openness'] = 'conservatief';
$string['eval_min_caption_successprobability'] = 'Kans op succes';
$string['eval_min_text_agreeableness'] = 'Sociale betrouwbaarheid verwijst naar het gedrag naar andere mensen.';
$string['eval_min_text_challenge'] = 'Uitdaging is een motivatie-dimensie die uitgeeft in welke mate de huidige cursus gezien wordt als zijnde relevant voor prestatie. M.a.w. in welke mate je het gevoel hebt je skills en vaardigheden toe te passen.';
$string['eval_min_text_conscientiousness'] = 'Zorgvuldigheid beschrijft de mate van zelfbeheersing, accuraatheid en determinatie.';
$string['eval_min_text_extraversion'] = 'Introversie en extraversie zijn twee uiteinden van een persoonlijkheidskenmerk dat wordt gekarakteriseerd door interactie met de omgeving. Introversie geeft een naar binnen gerichte houding aan, terwijl extraversie naar buiten gericht is.';
$string['eval_min_text_interest'] = 'Interesse is een motivatie-dimensie die is afgeleid van de waardering van de taakinhoud. Interesse wordt o.a. uitgedrukt als taken met plezier en vrijwillig uitgevoerd worden. Vooral als taken zelfstandig uitgevoerd worden en gericht zijn op diepgaand begrip kan interesse sterk bijdragen aan het succes van leren.';
$string['eval_min_text_lackofconfidence'] = 'Verwachting van mislukken is een vorm van motivatie die voortkomt uit de angst de taak niet te kunnen uitvoeren of afronden, gecombineerd met het idee dat men door de druk van de situatie niet optimaal zal kunnen studeren.';
$string['eval_min_text_neuroticism'] = 'Het persoonlijkheidskenmerk neuroticisme geeft aan dat er individuele verschillen zijn in het ervaren van negatieve emoties en staat ook bekend als emotionele instabiliteit. De tegenpool is emotionele stabiliteit.';
$string['eval_min_text_openness'] = 'Open voor ervaring beschrijft de interesse en de mate van waarin opgegaan wordt in nieuwe ervaringen en indrukken.';
$string['eval_min_text_successprobability'] = 'Kans op succes is gebaseerd op aannames over de mate dat iemand er vertrouwen in heeft een goed resultaat te behalen in de huidige cursus of opdracht. Het gevoel hebben voldoende capabel te zijn of de taak eenvoudig te vinden kan aanleiding geven tot de verwachting op een hoge kans op succes.';
$string['eval_name_big5'] = 'Persoonlijkheid';
$string['eval_name_fam'] = 'Motivatie';
$string['eval_text_big5_agreeableness_1'] = 'Je lage scores op betrouwbaarheid geven aan dat je vrij argumentatief en egocentrisch bent en bedoelingen van anderen wantrouwt. Je gedrag is eerder competitief dan coöperatief. Je kunt je eigen interesses verdedigen en geeft minder toe.';
$string['eval_text_big5_agreeableness_2'] = 'Je gemiddelde scores op betrouwbaarheid geven aan dat je noch sterk egocentrisch bent noch altruïstisch. Men zal je beschrijven als noch bijzonder wantrouwend noch bijzonder snel van vertrouwen en noch extreem toegeeflijk noch extreem koppig.';
$string['eval_text_big5_agreeableness_3'] = 'Je hoge scores op betrouwbaarheid geven aan dat je in het algemeen meer altruïstisch bent. Je behandelt anderen met begrip, vriendelijkheid en empathie. Je probeert anderen te helpen en gaat ervanuit dat anderen jou zullen helpen. Je neigt naar interpersoonlijk vertrouwen, samenwerking en volgzaamheid.';
$string['eval_text_big5_conscientiousness_1'] = 'Je lijkt een relatief lage score te hebben op zorgvuldigheid. Dit geeft aan dat je neigt naar spontaniteit en dat je wat zorgeloos en inaccuraat handelt.';
$string['eval_text_big5_conscientiousness_2'] = 'Je hebt een gemiddelde score op zorgvuldigheid. Dit wijst erop dat je een balans hebt tussen zorgvuldig en onzorgvuldig handelen en dat je niet zeer strak georganiseerd noch zeer los georganiseerd bent.';
$string['eval_text_big5_conscientiousness_3'] = 'Je hebt een hoge score op zorgvuldigheid. Dit geeft aan dat je georganiseerd bent, zorgvuldig plant, effectief, verantwoordelijk en betrouwbaar bent en dat je verstandig handelt.';
$string['eval_text_big5_extraversion_1'] = 'Je antwoorden geven een lage score op extraversie aan. Je neigt waarschijnlijk naar introversie, discreet gedrag in sociale interacties. Je kunt goed alleen zijn. Introverte personen worden vaak omschreven als kalm, rustig en gereserveerd.';
$string['eval_text_big5_extraversion_2'] = 'Je antwoorden geven een gemiddelde score op extraversie aan. Je bent waarschijnlijk gematigd enthousiast en niet overmatig dominant of spraakzaam.';
$string['eval_text_big5_extraversion_3'] = 'Je antwoorden geven een hoge score op extraversie aan. Je neigt waarschijnlijk naar sociaal gedrag, bent actief en spraakzaam, optimistisch en warm. Je reageert waarschijnlijk sterker op stimuli en opwinding.';
$string['eval_text_big5_neuroticism_1'] = 'Je hebt een lage score op neuroticisme. Je bent relatief rustig, tevreden, stabiel, ontspannen en voelt je veilig. Je kunt meestal beter omgaan met stressvolle situaties.';
$string['eval_text_big5_neuroticism_2'] = 'Je hebt een gemiddelde score op neuroticisme. Je ervaart niet in extreme mate veel of weinig angst, nervositeit, spanning, verdriet, onzekerheid of verlegenheid. In stressvolle situaties bent je niet bijzonder gevoelig of ongevoelig voor problemen.';
$string['eval_text_big5_neuroticism_3'] = 'Je hebt een relatief hoge score op neuroticisme. Je ervaart vaak angst, nervositeit, spanning, somberheid, onzekerheid en verlegenheid. Bovendien blijven deze gevoelens langer hangen en treden ze sneller op. Je hebt de neiging je meer zorgen te maken over je gezondheid, om onrealistische ideeën te ontwikkelen en je vindt het moeilijk om te reageren op stressvolle situaties.';
$string['eval_text_big5_openness_1'] = 'Je hebt een relatieve lage score op openheid. Dit suggereert dat je meer neigt naar behoudend gedrag en conservatieve houding. Je geeft de voorkeur aan gevestigde en goedgekeurde dingen boven nieuwe dingen. Je ervaart uw emotionele reacties relatief zwak. Je reageert pragmatisch in hier en nu.';
$string['eval_text_big5_openness_2'] = 'Je hebt een gemiddelde score op openheid. Dit geeft aan dat je niet neigt tot overdreven conventioneel of onconventionele houdingen en gedrag. Je balanceert een aanleg voor visie en fantasie met een pragmatisch zijn in hier en nu.';
$string['eval_text_big5_openness_3'] = 'Je hebt een relatieve hoge score op openheid. Dit suggereert dat je een actief fantasievol leven hebt en dat je geïnteresseerd bent in veel privé en publieke processen. Zulke mensen worden vaak beschreven als intellectueel, experimenteel en met artistieke interesses. Ze zijn vaak onconventioneel en geven de voorkeur aan afwisseling.';
$string['eval_text_fam_challenge_1'] = 'Je vond de huidige cursus op opdracht niet bepaald uitdagend. Dit kan positief zijn voor extern gerichte taken, maar kan negatieve effecten hebben voor zelfsturende taken.';
$string['eval_text_fam_challenge_2'] = 'Je vond de huidige cursus of opdracht niet echt uitdagend, maar ook niet erg eenvoudig.';
$string['eval_text_fam_challenge_3'] = 'Je vond de huidige cursus of opdracht bijzonder uitdagend. Dit kan negatief zijn voor extern gereguleerde opdrachten, maar positief voor zelf-gestuurde opdrachten.';
$string['eval_text_fam_interest_1'] = 'Je lijkt een weinig interesse te hebben voor de inhoud van de huidige cursus of opdracht. Dit is minder gunstig voor jouw eigen leren als het leerproces grotendeels zelfgestuurd is.';
$string['eval_text_fam_interest_2'] = 'Je lijkt een gemiddelde interesse te hebben in de inhoud van de huidige cursus of opdracht.';
$string['eval_text_fam_interest_3'] = 'Je lijkt een sterke interesse te hebben in de inhoud van de huidige cursus of opdracht. Dit is gunstig voor Je eigen leren als het leerproces grotendeels zelfgestuurd is.';
$string['eval_text_fam_lackofconfidence_1'] = 'Je score suggereert dat je verwachtingen voor mislukken laag zijn. Dit kan komen doordat je in het algemeen niet angstig bent, geen faalangst of examenvrees hebt. Dit kan ook liggen aan meer specifieke situationele aspecten van de huidige cursus of opdracht. In het algemeen heeft dit een positief effect op leren.';
$string['eval_text_fam_lackofconfidence_2'] = 'Je score suggereert dat je verwachtingen voor mislukken gemiddeld zijn. Dit kan voortvloeien uit een algemeen gevoel van angst, faalangst of examenvrees. Het kan ook liggen aan meer specifieke situationele aspecten van de huidige cursus of opdracht. In het algemeen hebben verwachtingen voor mislukken een negatief effect op leren.';
$string['eval_text_fam_lackofconfidence_3'] = 'Jescore geeft aan dat je een sterke verwachting voor mislukken hebt. Dit kan voortvloeien uit een algemeen gevoel van angst, faalangst of examenvrees. Het kan ook liggen aan meer specifieke situationele aspecten van de huidige cursus of opdracht. In het algemeen hebben verwachtingen voor mislukken een negatief effect op leren.';
$string['eval_text_fam_successprobability_1'] = 'Je vond dat je kans op succes in de huidige cursus of opdracht laag was. Dit heeft gewoonlijk een negatief effect op leren.';
$string['eval_text_fam_successprobability_2'] = 'Je ging ervanuit dat je gemiddelde resultaten zou behalen in de huidige cursus of opdracht. Dit heeft geen uitgesproken effect op leren.';
$string['eval_text_fam_successprobability_3'] = 'Je ging ervanuit dat je waarschijnlijk de cursus of opdracht met goed gevolg zou afleggen. In het algemeen stimuleert dit het leerproces.';
$string['evaluation'] = 'Evaluatie';
$string['evaluation_point_info'] = 'geef het maximum aantal punten aan';
$string['evaluationmethod_description'] = 'Hoe beoordeel je het werk?';
$string['evaluationmethod_error'] = 'Kies een evaluatiemethode.';
$string['excellent'] = 'uitstekend';
$string['export'] = 'Exporteer';
$string['export_all'] = 'Exporteer alle persoonlijke gegevens';
$string['export_all_data_check'] = 'Voeg persoonsgegevens van alle groepformaties in het gehele Moodle systeem toe (conform de Algemene verordening gegevensbescherming)';
$string['export_all_description'] = 'Hier kun je al je persoonlijke gegevens van deze activiteit exporteren:';
$string['export_answers'] = 'Hier kun je alle antwoorden met geanonimiseerde gebruiker-ID\'s downloaden:';
$string['export_description_no'] = 'Je kunt je antwoorden niet exporteren omdat je niet alle vragen hebt beantwoord in de categorieën die geëxporteerd kunnen worden.';
$string['export_description_yes'] = 'Klik op de knop hieronder om je antwoorden te exporteren.';
$string['export_group_users'] = 'Hier kun jealle groepsgebruikersrelaties met geanonimiseerde gebruiker-ID\'s downloaden:';
$string['export_groups'] = 'Hier kun je alle groepen met geanonimiseerde gebruiker-ID\'s downloaden:';
$string['export_logging'] = 'Hier kun je alle log-gegevens met geanonimiseerde gebruiker-ID\'s downloaden:';
$string['export_users'] = 'Hier kun je alle gegevens betreffende gebruikers met geanonimiseerde gebruiker-ID\'s downloaden:';
$string['failed_import'] = 'De import kan niet uitgevoerd worden vanwege een ongeldige opmaak. Upload een bestand met een opmaak conform exporteerbare antwoorden.';
$string['file_error'] = 'Je moet een *.xml-bestand uploaden.';
$string['freetext_noanswer'] = 'Geen antwoord';
$string['generategroups'] = 'Maak groepen aan';
$string['go_to_group_view'] = 'naar de Moodle groepsweergave';
$string['grades'] = 'Cijfers';
$string['groupSettingsInfo'] = 'Je hebt ervoor gekozen om onderwerpen te definiëren. Zoals je hieronder ziet, worden daarom het aantal groepen en groepsgrootte berekend.';
$string['group_building'] = 'Groepsvorming';
$string['group_overview'] = 'Overzicht van aangemaakte groepen';
$string['groupformation'] = 'Groepsformatie';
$string['groupformation:addinstance'] = 'Voeg groepsformatie toe';
$string['groupformation:editsettings'] = 'Bewerk groepsformatie';
$string['groupformation:onlymanager'] = 'groepsformatie: alleen manager';
$string['groupformation:onlyread'] = 'groepsformatie: alleen lezen';
$string['groupformation:onlystudent'] = 'groepsformatie: alleen leerling';
$string['groupformation:readsettings'] = 'groepsformatie: instellingen voor lezen';
$string['groupformation:submit'] = 'groepsformatie: stuur in';
$string['groupformation:view'] = 'groepsformatie: bekijk';
$string['groupformation_message'] = 'De groepsformatie is klaar. Je kunt nu de resultaten zien.';
$string['groupformation_message_contexturlname'] = 'resultaten';
$string['groupformation_message_subject'] = 'Groepsformatie is klaar';
$string['groupformation_subject'] = 'groepsformatie is afgerond';
$string['groupformationfieldset'] = 'Aangepast voorbeeld van velden';
$string['groupformationname'] = 'Groepsformatie';
$string['groupformationname_help'] = 'Tooltip groepsformatie';
$string['groupformationsettings'] = 'Instellingen voor groepsformatie';
$string['groupingNotReady'] = 'Groepsformatie is nog niet afgerond.';
$string['grouping_abort'] = 'Annuleer het genereren van groepen';
$string['grouping_adopt'] = 'Neem groepen aan';
$string['grouping_delete'] = 'Verwijder groepen';
$string['grouping_delete_moodle_groups'] = 'Verwijder Moodle-groepen';
$string['grouping_edit'] = 'Bewerk groepen';
$string['grouping_start'] = 'Start groepsformatie';
$string['grouping_status_0'] = 'Je moet de vragenlijst afsluiten om de groepsformatie te starten.';
$string['grouping_status_1'] = 'Je kunt de groepsformatie nu starten';
$string['grouping_status_2'] = 'De groepsformatie is bezig. Dit proces kan 2-5 minuten duren. Ververs de pagina om het resultaat te zien.';
$string['grouping_status_3'] = 'Het groepsformatieproces wordt beëindigd';
$string['grouping_status_4'] = 'De groepsformatie is klaar. Je kunt de groepen opnemen in Moodle of een algoritme kiezen om een nieuw resultaat te genereren.';
$string['grouping_status_5'] = 'De aangemaakte groepen worden in Moodle opgenomen. Je kunt ze handmatig bijwerken.';
$string['grouping_status_6'] = 'De aangemaakte groepen worden nu in Moodle opgenomen. Dit kan 2-5 minuten duren. Ververs de pagina om het resultaat te zien.';
$string['groupname'] = 'Naam site-groep';
$string['groupname_error'] = 'Kies een naam met minder dan 100 tekens.';
$string['groupname_help'] = 'De naam die u gekozen hebt voor de site-groep zal als prefix voor de aangemaakte groepen gebruikt worden. Het schema is [site-groepnaam]_XXX waar XXX het number van de groep is.';
$string['groupnameexists'] = 'Deze groep bestaat al.';
$string['groupoption_allanswersrequired'] = 'Voordat je door kunt gaan naar de volgende pagina van de vragenlijst moet je alle vragen beantwoorden.';
$string['groupoption_description'] = 'Beschrijving van groepsinstellingen';
$string['groupoption_help'] = 'Deze parameter kan na het indienen van de vragenlijsten geoptimaliseerd worden.';
$string['groupoption_onlyactivestudents'] = 'Leerlingen zonder antwoorden worden niet aan een groep toegekend.';
$string['groupoptions'] = 'Groepsinstellingen';
$string['groupsize'] = 'Groepsgrootte:';
$string['import'] = 'Importeer';
$string['import_description_no'] = 'Je kunt je antwoorden niet importeren omdat je je antwoorden al ingestuurd hebt of omdat de vragenlijst niet beschikbaar is.';
$string['import_description_yes'] = 'Je kunt je antwoorden importeren door op de knop hieronder te klikken en een bestand met een exporteerbare antwoordopmaak te uploaden.';
$string['import_form_description'] = 'Je kunt je antwoorden van vorige vragenlijsten importeren door hieronder een "answers.xml" bestand in te sturen.';
$string['inactive_members_are'] = 'Deelnemers die de groep of de cursus verlaten hebben:';
$string['info_header_student'] = 'Waar dient de "groepsformatie" voor?';
$string['info_header_teacher_analysis'] = 'Hoe gaat de groepsformatie-activiteit in zijn werk?';
$string['info_header_teacher_settings'] = 'Hoe gaat de groepsformatie-activiteit in zijn werk?';
$string['info_text_student'] = 'In deze Moodle-cursus wordt "groepsformatie" gebruikt om succesvolle coöperatieve {$a->scenario_name} aan te maken.
        Nadat je de vragenlijst ingediend hebt, wordt bepaald met wie je het beste samen kunt leren.
        Alle gegevens worden vertrouwelijk behandeld.
        <br>Nadat de vragenlijst verlopen is, worden groepen aangemaakt, rekening houdend met jouw gegevens en voorkeuren.
        <br><br>
        Vragen, problemen of suggesties?
        Je kunt de ontwikkelaar van de plugin en de wetenschapper vinden op<br>
        https://github.com/moodlepeers <br>
        (ontwikkeld met middelen ter verbetering van de kwaliteit van onderwijs van TU Darmstadt)';
$string['info_text_teacher_analysis'] = 'Met deze plugin kun je groepsformatie voor jouw leerlingen optimaliseren. Volg de drie stappen:<br>
        1.) Voeg de activiteit "groepsformatie" aan je cursus toe.
        In de instellingen kun je het scenario kiezen dat het beste past (bij twijfel kies je projectgroepen).
        Met de overige instellingen kun je groepsgrootte aangeven en/of voorkennis van de leerlingen. Je kunt aangeven of de voorkennis van leerlingen complementair moet zijn.
        2.) De leerlingen krijgen de vragenlijst die op jouw instellingen is gebaseerd. Je kunt aangeven wanneer de vragenlijst beschikbaar is (zie stap 1).
        Je kunt een voorbeeldweergave van de vragenlijst zien als je de activiteit als leraar opent. <br>
        3.) Je kunt de statistieken voor de antwoorden zien als je de activiteit opent. Als je tevreden bent met de resultaten kun je handmatig de groepsformatie starten (dit gebeurt nooit automatisch).<br>
        Het duurt even totdat de groepen zijn aangemaakt. Voordat je de groepen aan Moodle toevoegt, kun je de aangemaakte groepen bekijken. <br>
        <br>
        Klaar. Nu kunnen ook de leerlingen hun groepsleden zien. Als leraar kun je altijd de groepen in Moodle handmatig aanpassen (bijv. voor achterblijvers).<br>';
$string['info_text_teacher_settings'] = 'Met deze plugin kunt je groepsformatie voor je leerlingen optimaliseren. Volg de drie stappen:<br>
        1.) Voeg de activiteit "groepsformatie" aan je cursus toe.
        In de instellingen kun je het scenario kiezen dat het beste past (bij twijfel kies je projectgroepen).
        Met de overige instellingen kun je groepsgrootte aangeven en/of voorkennis van de leerlingen. Je kunt aangeven of de voorkennis van leerlingen complementair moet zijn.
        2.) De leerlingen krijgen de vragenlijst die op jouw instellingen is gebaseerd. Je kunt aangeven wanneer de vragenlijst beschikbaar is (zie stap 1).
        Je kunt een voorbeeldweergave van de vragenlijst zien als je de activiteit als leraar opent. <br>
        3.) Je kunt de statistieken voor de antwoorden zien als je de activiteit opent. Als je tevreden bent met de resultaten kun je handmatig de groepsformatie starten (dit gebeurt nooit automatisch).<br>
        Het duurt even totdat de groepen zijn aangemaakt. Voordat je de groepen aan Moodle toevoegt, kun je de aangemaakte groepen bekijken. <br>
        <br>
        Klaar. Nu kunnen ook de leerlingen hun groepsleden zien. Als leraar kun je ten allen tijde de groepen in Moodle handmatig aanpassen (bijv. voor achterblijvers).<br>';
$string['input'] = 'Input:';
$string['invalid'] = 'ongeldige status';
$string['jobget_name'] = 'Groepsformatie en beheer';
$string['justpass'] = 'Alleen geslaagd';
$string['knowledge'] = 'Kennis';
$string['knowledgeChoice'] = 'Kennis';
$string['knowledge_description'] = 'Ik wil kennisvragen opnemen';
$string['knowledge_description_extended'] = 'Geef alle kennisgebieden aan waarvoor leerlingen de vragen moeten invullen.
    Rechts kunt u een voorbeeldweergave zien.';
$string['knowledge_dummy'] = 'Voorbeeld';
$string['knowledge_help'] = 'Als je hebt gekozen voor onderwerpen (zie optie hieronder), dan wordt deze optie automatisch uitgezet.';
$string['knowledge_info_homework'] = 'Geef alle kennisgebieden aan waarvoor leerlingen de vragen moeten invullen.
    Bekijk de voorbeeldweergave aan de rechterkant.
    Aangezien je gekozen hebt voor "huiswerkgroepen" zal de voorkennis binnen groepen variëren.';
$string['knowledge_info_presentation'] = 'Geef alle kennisgebieden aan waarvoor leerlingen de vragen moeten invullen.
    Bekijk de voorbeeldweergave aan de rechterkant.
    Aangezien je gekozen hebt voor "presentatiegroepen" zal de voorkennis binnen groepen variëren (niet meegenomen als onderwerpen zijn geselecteerd).';
$string['knowledge_info_project'] = 'Geef alle kennisgebieden aan waarvoor leerlingen de vragen moeten invullen.
    Bekijk de voorbeeldweergave aan de rechterkant.
    Aangezien je gekozen hebt voor "projectgroepen" zal de voorkennis (gebieden) binnen groepen variëren, maar is het gewenst dat het kennisniveau vergelijkbaar is.';
$string['knowledge_question'] = 'Hoeveel weet je over de volgende onderwerpen?';
$string['knowledge_scale'] = '0 = geen kennis, 100 = veel kennis';
$string['language'] = 'en';
$string['max_group_size'] = 'Maximale groepsgrootte:';
$string['max_group_size_not_reached'] = 'De volgende groepen hebben nog niet de maximale groepsgrootte bereikt:';
$string['maxgroups'] = 'Maximum aantal groepen';
$string['maxgroups_error'] = 'Kies een nummer groter dan 0';
$string['maxmembers'] = 'Maximum aantal groepsleden';
$string['maxmembers_error'] = 'Kies een nummer groter dan 0';
$string['maxpoints'] = 'Maximum aantal punten';
$string['maxpoints_error'] = 'Kies een nummer tussen 1 en 100';
$string['members_are'] = 'Jouw groepsleden zijn:';
$string['messageprovider:submission'] = 'Waarschuw me als de groepsformatie is afgerond';
$string['modulename'] = 'Groepsformatie';
$string['modulename_help'] = 'De groepsformatie-plugin deelt deelnemers in groepen in op basis van antwoorden op de vragen.';
$string['modulenameplural'] = 'Groepsformaties';
$string['name_by_group'] = 'Naam:';
$string['namingschema'] = 'Schema voor naam';
$string['noGroup'] = 'Je bent nog niet in een groep ingedeeld omdat je de vragenlijst niet beantwoord hebt.';
$string['noUser'] = 'Gebruiker bestaat niet';
$string['no_data_to_display'] = 'Geen gegevens beschikbaar om te tonen';
$string['no_evaluation_ready'] = 'Er is geen evaluatie beschikbaar voor jouw. De evaluatie kan alleen uitgevoerd worden als je alle vragen hebt beantwoord en hebt ingediend.';
$string['no_evaluation_text'] = 'Er is geen evaluatie voor deze groepsformatie-activiteit.';
$string['no_time'] = 'Geen tijd ingesteld';
$string['nochangespossible'] = 'De vragenlijst is al beantwoord.
Je kunt alleen het maximum aantal groepsleden of het maximum aantal groepen wijzigen. Andere wijzigingen worden niet opgeslagen.';
$string['noevaluation'] = 'Geen evaluatie';
$string['nogroupformation'] = 'Geen groepsformatie';
$string['none'] = 'geen';
$string['notOpen'] = 'Je kunt niet meer indienen.';
$string['notamember'] = '(Heeft groep of cursus verlaten)';
$string['number_member'] = 'Aantal leden:';
$string['number_of_groups'] = 'Aantal aangemaakte groepen';
$string['oneManGroup'] = 'Jouw groep bestaat uit 1 persoon.';
$string['onlyactivestudents'] = 'Alleen leerlingen die minimaal 1 antwoord hebben ingediend, zouden in aanmerkingen genomen moeten worden bij het vormen van de groepen.';
$string['onlyactivestudents_description'] = 'Alleen leerlingen die minimaal 1 antwoord hebben ingediend, zouden in aanmerkingen genomen moeten worden bij het vormen van de groepen.';
$string['onlyactivestudents_info'] = 'Alleen leerlingen die minimaal 1 antwoord hebben ingediend, worden meegenomen in de groepsformatie. Dit kan ingesteld worden in {$a->url}.';
$string['options'] = 'Opties';
$string['overview'] = 'Overzicht';
$string['page_title_analysis'] = 'Activiteit';
$string['page_title_evaluation'] = 'Evaluatie';
$string['page_title_export'] = 'Export';
$string['page_title_group'] = 'Groepsopdracht';
$string['page_title_grouping'] = 'Groepsformatie';
$string['page_title_grouping_edit'] = 'Groepsformatie - Bewerkingsweergave';
$string['page_title_import_export'] = 'Import & Export';
$string['page_title_overview'] = 'Overzicht';
$string['participant_code_alert_message'] = 'Je moet een geldige deelnemerscode opgeven om de vragenlijst te kunnen openen. Ga verder naar beneden en vul je deelnemerscode in.';
$string['participant_code_footer'] = 'Jouw persoonlijke deelnemerscode is';
$string['participant_code_title'] = 'Deelnemerscode';
$string['password_wrong'] = 'verkeerd wachtwoord';
$string['pluginadministration'] = 'Beheer: groepsformatie';
$string['pluginname'] = 'Groepsformatie';
$string['points'] = 'Punten';
$string['preview'] = 'Voorbeeldweergave :';
$string['quality'] = 'Groepskwaliteit';
$string['quality_info'] = 'GPI (Group-Performance-Index of Groep-Prestatie-Index) is een representatie van de kwaliteit van de samengestelde groep en heeft een waarde tussen 0 en 1. Hogere waarden voor betere groepen. Als er geen waarde getoond wordt, is de groep niet op basis van een algoritme samengesteld, maar willekeurig.';
$string['questionnaire_answer_stats'] = 'Huidige status van de vragenlijst:';
$string['questionnaire_availability_info_from'] = 'De vragenlijst is beschikbaar vanaf {$a->start}.';
$string['questionnaire_availability_info_future'] = 'De vragenlijst is beschikbaar in the periode van {$a->start} tot {$a->end}.';
$string['questionnaire_availability_info_now'] = 'De vragenlijst is beschikbaar tot {$a->end}.';
$string['questionnaire_availability_info_until'] = 'De vragenlijst is nog beschikbaar tot {$a->end}.';
$string['questionnaire_available'] = 'De vragenlijst kan nu verwerkt worden.';
$string['questionnaire_available_end'] = 'De vragenlijst kan nu verwerkt worden.';
$string['questionnaire_committed'] = 'Jouw antwoorden zijn ingediend. Je kunt deze niet meer aanpassen in deze activiteit.';
$string['questionnaire_delete'] = 'Verwijder toestemming';
$string['questionnaire_go_to_start'] = 'Ga naar start';
$string['questionnaire_no_more_questions'] = 'Er zijn geen vragen meer die je moet beantwoorden.';
$string['questionnaire_not_available'] = 'De vragenlijst is momenteel niet beschikbaar.';
$string['questionnaire_not_available_begin'] = 'De vragenlijst is beschikbaar vanaf {$a->start}.';
$string['questionnaire_not_available_begin_end'] = 'De vragenlijst is beschikbaar in the periode van {$a->start} tot {$a->end}.';
$string['questionnaire_not_available_end'] = 'De vragenlijst is niet meer beschikbaar.';
$string['questionnaire_not_started'] = 'De vragenlijst is klaar.';
$string['questionnaire_not_submitted'] = 'Jouw antwoorden zijn nog niet ingediend.';
$string['questionnaire_outdated'] = 'Deze activiteit is te oud. Het kan zijn dat het niet correct werkt. Maak een nieuwe activiteit aan om de volledige functionaliteit te kunnen gebruiken.';
$string['questionnaire_press_beginning_submit'] = 'Klik op "Ga naar Start" op terug te gaan naar de beginpagina. Daar kun je jouw antwoorden insturen.';
$string['questionnaire_press_continue_submit'] = 'Klik op "Bewerken" om verder te gaan met de vragenlijst of op "Insturen" om jouw antwoorden in te sturen.
Je kunt ook je toestemming weer intrekken door op "Verwijder toestemming" te klikken. Eerder gegeven antwoorden worden verwijderd.';
$string['questionnaire_press_preview'] = 'Klik op "Voorbeeldweergave " om de vragenlijst te bekijken.';
$string['questionnaire_press_revert'] = 'Klik op "Terugzetten" als je de vragenlijst toch niet wilt indienen. Je kunt ook je toestemming weer intrekken door op "Verwijder toestemming" te klikken. Eerder gegeven antwoorden worden verwijderd.';
$string['questionnaire_press_to_begin'] = 'Geef je toestemming en klik op "Volgende" om te beginnen.';
$string['questionnaire_press_to_begin_participant_code'] = 'Vul je deelnemerscode in en geef je toestemming. Klik op "Volgende" om te beginnen.';
$string['questionnaire_preview'] = 'Dit is een voorbeeldweergave van de vragenlijst.';
$string['questionnaire_submit'] = 'Stuur antwoorden in';
$string['questionnaire_submit_disabled_teacher'] = 'Insturen is niet beschikbaar omdat dit een voorbeeldweergave is.';
$string['questionnaire_submitted'] = 'Je hebt je antwoorden ingestuurd. Je kunt dit terugtrekken of je toestemming verwijderen als je opnieuw wilt beginnen.';
$string['remove_line'] = 'Verwijder regel';
$string['sampleGroupName'] = 'De naam van de groep is';
$string['scenario'] = 'Scenario';
$string['scenarioInfo'] = 'De drie scenario\'s verschillen in de manier waarop de vragen de groepsformatie beïnvloeden.
            Voor projectgroepen wordt uitgegaan van voorkennis en kenmerken van groepsleden die elkaar aanvullen terwijl motivatie(niveau) en persoonlijke doelen zoveel mogelijk gelijk moeten zijn.
            Voor huiswerkgroepen wordt gericht op een optimale samenstelling en best mogelijke voorwaarden voor samenwerkend leren.
            Voor presentatiegroepen is een gedeelde interesse in hetzelfde geselecteerde (en toegewezen) onderwerp het belangrijkste.';
$string['scenario_description'] = 'Kies het meest geschikte scenario voor de groepsformatie.';
$string['scenario_error'] = 'Kies een scenario';
$string['scenario_homeworkgroups'] = 'Huiswerkgroepen';
$string['scenario_homeworkgroups_description'] = 'Huiswerkgroepen ronden (kleinere) opdrachten in een regelmatig interval (vaak wekelijks) af als voorbereiding op een examen. Hoewel de opdrachten (vaak oefeningen, praktijk, beheersingsvragen of huiswerk genoemd) in principe over groepsleden verdeeld zouden kunnen worden, is dit niet de bedoeling, omdat ieder lid van de groep tijdens het examen individueel beoordeeld wordt en daarom in staat moet zijn om alle taken alleen te kunnen uitvoeren. Daarom gaat de groepsformatie voor diversiteit in voorkennis en een variëteit in leerstijlen die elkaar aanvullen.';
$string['scenario_homeworkgroups_short'] = 'Kennisgebieden en leerdoelen zijn heterogeen; oriëntatie van het team is homogeen.';
$string['scenario_presentationgroups'] = 'Presentatiegroepen';
$string['scenario_presentationgroups_description'] = 'Presentatiegroepen werken samen gedurende een relatief korte tijd om een presentatie (die vaak in de klas gegeven wordt) af te ronden. Aan het begin wordt vaak een specifieke subtaak toegewezen aan (of geselecteerd door) iedere student. Waarna iedereen individueel aan de slag gaat om aan het eind alles samen te voegen tot een volledige presentatie. De beoordeling gebeurt meestal op het groepsproduct. Daarom richt de groepsformatie vooral op gedeelde interesse in hetzelfde onderwerp.';
$string['scenario_presentationgroups_short'] = 'Hiermee wordt de optie aangezet om de lijst van onderwerpen via Slepen en Neerzetten (drag and drop) te ordenen. De procedure "wie eerste komt, eerste maalt" wordt vermeden om een zo eerlijk mogelijke verdeling van onderwerpen toe te staan.';
$string['scenario_projectteams'] = 'Projectgroepen';
$string['scenario_projectteams_description'] = 'Projectgroepen werken intensief samen om een project af te ronden (bijv. om een studie uit te voeren, een report te schrijven, etc.). Vaak kunnen taken gesplitst worden en verdeeld over de projectleden. Daarom is het gunstig om aanvullende competenties in de groep te hebben. Meestal krijgen alle groepsleden hetzelfde cijfer voor dit soort collectieve producten. Dus richt de groepsformatie op vergelijkbare motivatie en doelen (naast de ingangseisen).';
$string['scenario_projectteams_short'] = 'Kennisgebieden en motivatie zijn heterogeen; kennisniveau, doelen en oriëntatie van de groep zijn homogeen; karakterkenmerken zijn gedeeltelijk homogeen, gedeeltelijk heterogeen.';
$string['scenario_usage_header'] = 'Vragenlijstgebruik';
$string['scenario_usage_header_presentation'] = 'Leerlingen stellen voorkeur in';
$string['select_info'] = 'Selecteer groepsleden om ze te verplaatsen naar een andere groep';
$string['settings_archiving_time'] = 'Archiveringstijd';
$string['settings_archiving_time_description'] = 'Na x dagen wordt de activiteit gearchiveerd';
$string['settings_description'] = 'Instelling voor archivering en aanvullende functionaliteit';
$string['settings_header'] = 'Algemeen';
$string['settings_import_export'] = 'Import/Export van antwoorden';
$string['settings_import_export_description'] = 'Indien ingesteld, kunnen leerlingen hun antwoorden exporteren en in een andere activiteit importeren.';
$string['settings_participant_code'] = 'Deelnemerscode';
$string['settings_participant_code_description'] = 'Leerlingen dienen een deelnemerscode in te vullen (zoals gebruikelijk voor psychologische testen).';
$string['starttime'] = 'Starttijd';
$string['statistic'] = 'Statistieken van de vragenlijst';
$string['stats_all'] = 'Je hebt alle vragen uit de categorie "{$a->category}" beantwoord.';
$string['stats_none'] = 'JE hebt geen van de vragen uit de categorie "{$a->category}" beantwoord.';
$string['stats_partly'] = 'Je hebt {$a->answered} van de {$a->questions} vragen uit de categorie "{$a->category}" beantwoord.';
$string['students_enrolled_info'] = 'Leerlingen zijn ingeschreven in de cursus';
$string['students_selected'] = 'geselecteerde leerlingen';
$string['submit-modal-text'] = 'Het is belangrijk dat je alle antwoorden naar waarheid en correct invult, zowel vanuit wetenschappelijk punt als voor het groepsformatieproces. We stellen je medewerking op prijs.

Klik op \'Annuleer\' als je je antwoorden wil aanpassen voordat je ze indient.';
$string['submit-modal-title'] = 'Stuur je antwoorden in';
$string['successful_import'] = 'Je vragen zijn geïmporteerd. Je kunt je antwoorden in de vragenlijst bekijken.';
$string['tab_analysis'] = 'Analyse';
$string['tab_evaluation'] = 'Evaluatie';
$string['tab_group'] = 'Groepsopdracht';
$string['tab_grouping'] = 'Groepsformatie';
$string['tab_overview'] = 'Overzicht';
$string['tab_preview'] = 'Vragenlijst (Voorbeeldweergave )';
$string['tab_questionnaire'] = 'Vragenlijst';
$string['tabletitle_catfreetext'] = 'Vrije tekst';
$string['tabletitle_catmultiselect'] = 'Selecteer meerdere opties';
$string['tabletitle_catnumber'] = 'Nummer';
$string['tabletitle_character'] = 'Teken';
$string['tabletitle_demographic'] = 'Demografisch';
$string['tabletitle_general'] = 'Algemeen';
$string['tabletitle_grade'] = 'Doelen';
$string['tabletitle_honesty'] = 'Eerlijkheid';
$string['tabletitle_knowledge'] = 'Hoeveel weet je over de volgende onderwerpen?';
$string['tabletitle_learning'] = 'Leren';
$string['tabletitle_motivation'] = 'Motivatie';
$string['tabletitle_points'] = 'Doelen';
$string['tabletitle_self'] = 'Zelf-evaluatie';
$string['tabletitle_sellmo'] = 'Motivatie voor leren en prestatie';
$string['tabletitle_skills'] = 'Ervaring';
$string['tabletitle_srl'] = 'Zelf-beheerd leren';
$string['tabletitle_team'] = 'Team';
$string['tabletitle_times'] = 'Beschikbaarheid';
$string['tabletitle_topic'] = 'Onderwerpen';
$string['time'] = 'Tijd';
$string['topic'] = 'Onderwerp';
$string['topic_group_info'] = 'Jouw onderwerp is';
$string['topicchoice'] = 'Selectie van onderwerp';
$string['topics'] = 'Onderwerpen';
$string['topics_description'] = 'Ik wil onderwerpen definiëren';
$string['topics_description_extended'] = 'Geef de onderwerpen aan waaruit de leerlingen kunnen kiezen. <strong>Het groepsformatieproces optimaliseert dan uitsluitend op de voorkeur voor geselecteerde onderwerpen.</strong> Alle andere delen van de vragenlijst worden niet meegenomen.';
$string['topics_dummy'] = 'Onderwerp';
$string['topics_help'] = 'Als je onderwerpen gebruikt, worden kennisvragen uitgeschakeld en bepaalt het aantal onderwerpen het aantal groepen.';
$string['topics_question'] = 'Sorteer de volgende onderwerpen volgens uw eigen interesse en begin met je meest favoriete onderwerp. Je kunt onderwerpen naar een andere plek slepen.';
$string['topics_statistics'] = 'Statistieken van aangeboden onderwerpen';
$string['topics_statistics_description'] = 'De volgende scores geven aan welke onderwerpen favoriet zijn bij de leerlingen: een score dicht bij 1 geeft aan dat leerlingen dit onderwerp leuker vinden dan een onderwerp met een lagere score.';
$string['topics_statistics_score'] = 'Score [0-1]';
$string['unselect_all'] = 'Deselecteer alles';
$string['useOneLineForEachKnowledge'] = 'Gebruik een regel per onderwerp';
$string['useOneLineForEachTopic'] = 'Gebruik een regel per onderwerp';
$string['userpergroup'] = 'Hoeveel leden per groep?';
$string['your_group'] = 'De naam van de groep is:';
