<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'scorm', language 'el', version '5.1'.
 *
 * @package     scorm
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['activation'] = 'Ενεργοποίηση';
$string['activityloading'] = 'Θα μεταφερθείτε αυτόματα στη δραστηριότητα σε';
$string['activityoverview'] = 'Υπάρχουν SCORM πακέτα που χρήζουν παρακολούθησης';
$string['activitypleasewait'] = 'Η δραστηριότητα φορτώνεται. Παρακαλούμε περιμένετε...';
$string['adminsettings'] = 'Ρυθμίσεις διαχειριστή';
$string['advanced'] = 'Παράμετροι';
$string['aicchacpkeepsessiondata'] = 'Δεδομένα συνόδου AICC HACP';
$string['aicchacpkeepsessiondata_desc'] = 'Χρονικό διάστημα σε ημέρες για τη διατήρηση εξωτερικών δεδομένων συνόδου AICC HACP (υψηλή ρύθμιση θα γεμίσει τον πίνακα με παλιά δεδομένα, αλλά μπορεί να είναι χρήσιμο κατά την αποσφαλμάτωση)';
$string['aicchacptimeout'] = 'Τέλος χρόνου AICC HACP';
$string['aicchacptimeout_desc'] = 'Χρονικό διάστημα σε λεπτά όπου μια εξωτερική σύνοδος AICC HACP μπορεί να παραμείνει ανοιχτή';
$string['aiccuserid'] = 'Μεταβίβαση αριθμητικού αναγνωριστικού χρήστη στο AICC';
$string['aiccuserid_desc'] = 'Το πρότυπο AICC για το όνομα χρήστη είναι πολύ περιοριστικό σε σχέση με το Moodle, και επιτρέπει μόνο αλφαριθμητικούς χαρακτήρες, παύλα και κάτω παύλα. Τελείες, κενά και το σύμβολο @ δεν επιτρέπονται. Αν ενεργοποιηθεί, μεταβιβάζεται κάθε φορά ο αναγνωριστικός αριθμός χρήστη στο πακέτο AICC αντί για το όνομα χρήστη.';
$string['aliasonly'] = 'Όταν επιλέγετε ένα αρχείο imsmanifest.xml από ένα αποθετήριο θα πρέπει να χρησιμοποιήσετε ένα ψευδώνυμο / συντόμευση για αυτό το αρχείο.';
$string['allowapidebug'] = 'Ενεργοποίηση API αποσφαλμάτωσης και παρακολούθησης (καθορίστε τη μάσκα καταγραφής με το apidebugmask)';
$string['allowtypeaicchacp'] = 'Ενεργοποίηση εξωτερικού AICC HACP';
$string['allowtypeaicchacp_desc'] = 'Αν ενεργοποιηθεί επιτρέπει την εξωτερική επικοινωνία AICC HACP χωρίς να απαιτείται σύνδεση του χρήστη για την αποστολή αιτημάτων από το εξωτερικό πακέτο AICC';
$string['allowtypeexternal'] = 'Ενεργοποίηση πακέτων εξωτερικού τύπου';
$string['allowtypeexternalaicc'] = 'Ενεργοποίηση απευθείας URL AICC';
$string['allowtypeexternalaicc_desc'] = 'Αν ενεργοποιηθεί επιτρέπει τη χρήση άμεσης διεύθυνσης URL σε ένα απλό πακέτο AICC';
$string['allowtypelocalsync'] = 'Ενεργοποίηση πακέτων που κατεβαίνουν';
$string['apidebugmask'] = 'Μάσκα καταγραφής αποσφαλμάτωσης API - χρησιμοποιήστε μια απλή κανονική έκφραση σε &lt;username&gt;:&lt;activityname&gt; π.χ. admin:.* θα κάνει αποσφαλμάτωση για τον χρήστη admin (διαχειριστής) μόνο';
$string['areacontent'] = 'Αρχεία περιεχομένου';
$string['areapackage'] = 'Αρχείο πακέτου';
$string['asset'] = 'Στοιχείο';
$string['assetlaunched'] = 'Στοιχείο - Προβλήθηκε';
$string['attempt'] = 'Προσπάθεια';
$string['attempt1'] = '1 προσπάθεια';
$string['attempts'] = 'Προσπάθειες';
$string['attemptsmanagement'] = 'Διαχείριση προσπαθειών';
$string['attemptstatusall'] = 'Ταμπλό και σελίδα εισόδου';
$string['attemptstatusentry'] = 'Μόνο σελίδα εισόδου';
$string['attemptstatusmy'] = 'Μόνο Ταμπλό';
$string['attemptsx'] = '{$a} προσπάθειες';
$string['attr_error'] = 'Εσφαλμένη τιμή για την ιδιότητα {$a->attr} στην ετικέτα {$a->tag}.';
$string['autocommit'] = 'Αυτόματη αποδοχή';
$string['autocommit_help'] = 'Αν ενεργοποιηθεί, τα δεδομένα SCORM θα αποθηκεύονται αυτόματα στη βάση δεδομένων. Χρήσιμο για αντικείμενα SCORM που δεν αποθηκεύουν τα δεδομένα τους σε τακτική βάση.';
$string['autocommitdesc'] = 'Αυτόματη αποθήκευση των δεδομένων SCORM αν το πακέτο SCORM δεν τα αποθηκεύει.';
$string['autocontinue'] = 'Αυτόματη συνέχιση';
$string['autocontinue_help'] = 'Αν ενεργοποιηθεί, τα επόμενα μαθησιακά αντικείμενα θα ξεκινήσουν αυτόματα, διαφορετικά θα πρέπει να χρησιμοποιηθεί το πλήκτρο «Συνέχεια».';
$string['autocontinuedesc'] = 'Αν ενεργοποιηθεί, τα μαθησιακά αντικείμενα που θα επακολουθήσουν θα ξεκινούν αυτόματα, διαφορετικά θα πρέπει να χρησιμοποιείται το πλήκτρο «Συνέχεια».';
$string['averageattempt'] = 'Μέσος όρος προσπαθειών';
$string['badarchive'] = 'Θα πρέπει να δώσετε ένα έγκυρο συμπιεσμένο αρχείο';
$string['badimsmanifestlocation'] = 'Βρέθηκε ένα αρχείο imsmanifest.xml, αλλά δεν ήταν στη ρίζα του συμπιεσμένου αρχείο, παρακαλούμε πακετάρετε ξανά το SCORM';
$string['badmanifest'] = 'Υπήρξαν σφάλματα στο manifest: δείτε το αρχείο καταγραφής σφαλμάτων';
$string['browse'] = 'Προεπισκόπηση';
$string['browsed'] = 'Προβλήθηκε';
$string['browsemode'] = 'Κατάσταση προεπισκόπησης';
$string['browserepository'] = 'Πλοήγηση στο αποθετήριο';
$string['calculatedweight'] = 'Υπολογιζόμενος συντελεστής βαρύτητας';
$string['calendarend'] = '{$a} κλείνει';
$string['calendarstart'] = '{$a} ανοίγει';
$string['cannotaccess'] = 'Δεν είναι δυνατή η κλήση του σεναρίου με αυτό τον τρόπο';
$string['cannotfindsco'] = 'Δεν ήταν δυνατή η εύρεση του SCO';
$string['chooseapacket'] = 'Επιλογή ή ενημέρωση πακέτου';
$string['closebeforeopen'] = 'Έχετε δηλώσει ημερομηνία λήξη προγενέστερη της ημερομηνίας έναρξης';
$string['collapsetocwinsize'] = 'Σύμπτυξη πίνακα περιεχομένων όταν το μέγεθος του παραθύρου είναι κάτω από';
$string['collapsetocwinsizedesc'] = 'Αυτή η ρύθμιση σας επιτρέπει να καθορίσετε το μέγεθος του παραθύρου κάτω από το οποίο ο πίνακας περιεχομένων θα πρέπει να συμπτυχθεί αυτόματα.';
$string['compatibilitysettings'] = 'Ρυθμίσεις συμβατότητας';
$string['completed'] = 'Ολοκληρωμένο';
$string['completiondetail:allscos'] = 'Κάντε όλα τα μέρη αυτής της δραστηριότητας';
$string['completiondetail:completionscore'] = 'Λάβετε βαθμολογία {$a} ή περισσότερο';
$string['completiondetail:completionstatuscompleted'] = 'Ολοκληρώστε τη δραστηριότητα';
$string['completiondetail:completionstatuscompletedorpassed'] = 'Ολοκληρώστε και περάστε τη δραστηριότητα';
$string['completiondetail:completionstatuspassed'] = 'Περάστε τη δραστηριότητα';
$string['completionscorerequired'] = 'Απαιτείται ελάχιστο σκορ';
$string['completionscorerequireddesc'] = 'Για την ολοκλήρωση απαιτείται ελάχιστο σκορ {$a}';
$string['completionstatus_completed'] = 'Ολοκληρωμένο';
$string['completionstatus_passed'] = 'Πέρασε';
$string['completionstatusallscos'] = 'Απαιτείται όλα τα scos να επιστρέφουν κατάσταση ολοκλήρωσης';
$string['completionstatusallscos_help'] = 'Μερικά πακέτα SCORM περιέχουν πολλαπλά συστατικά ή «scos» - όταν είναι ενεργοποιημένη η ρύθμιση όλα τα scos εντός του πακέτου πρέπει να επιστρέφουν το σχετικό lesson_status προκειμένου η δραστηριότητα να σημαιοδοτηθεί ως ολοκληρωμένη.';
$string['completionstatusrequired'] = 'Απαιτείται κατάσταση';
$string['completionstatusrequired_help'] = 'Επιλέγοντας μια ή περισσότερες καταστάσεις ο χρήστης θα πρέπει να επιτύχει τουλάχιστον μια από τις επιλεγμένες καταστάσεις, προκειμένου να επισημανθεί ως ολοκληρωμένη η δραστηριότητα SCORM, καθώς και οι όποιες άλλες απαιτήσεις Ολοκλήρωσης Δραστηριότητας.';
$string['completionstatusrequireddesc'] = 'Ο μαθητής πρέπει να πετύχει τουλάχιστον μια από τις ακόλουθες καταστάσεις: {$a}';
$string['confirmloosetracks'] = 'ΠΡΟΣΟΧΗ: Το πακέτο έχει αλλαχθεί ή τροποποιηθεί. Αν η δομή του πακέτου έχει αλλάξει, κάποια στοιχεία χρηστών πιθανώς να χαθούν κατά τη διαδικασία ενημέρωσης.';
$string['contents'] = 'Περιεχόμενα';
$string['coursepacket'] = 'Πακέτο μαθήματος';
$string['coursestruct'] = 'Δομή μαθήματος';
$string['crontask'] = 'Επεξεργασία παρασκηνίου για το SCORM';
$string['currentwindow'] = 'Τρέχον παράθυρο';
$string['datadir'] = 'Σφάλμα αρχείου συστήματος: Αδυναμία δημιουργίας φακέλου δεδομένων μαθήματος';
$string['defaultdisplaysettings'] = 'Προεπιλεγμένες ρυθμίσεις εμφάνισης';
$string['defaultgradesettings'] = 'Προεπιλεγμένες ρυθμίσεις βαθμολόγησης';
$string['defaultothersettings'] = 'Άλλες προεπιλεγμένες ρυθμίσεις';
$string['deleteallattempts'] = 'Διαγραφή όλων των προσπαθειών';
$string['deleteattemptcheck'] = 'Είστε απολύτως βέβαιοι ότι θέλετε να διαγράψετε εντελώς τις προσπάθειες;';
$string['deleteselected'] = 'Διαγραφή επιλεγμένων προσπαθειών';
$string['deleteuserattemptcheck'] = 'Είστε απολύτως βέβαιοι ότι θέλετε να διαγράψετε εντελώς όλες τις προσπάθειες;';
$string['details'] = 'Παρακολούθηση λεπτομερειών';
$string['directories'] = 'Εμφάνιση συνδέσμων φακέλου';
$string['disabled'] = 'Απενεργοποιημένο';
$string['display'] = 'Εμφάνιση πακέτου';
$string['displayattemptstatus'] = 'Εμφάνιση κατάστασης προσπαθειών';
$string['displayattemptstatus_help'] = 'Αυτή η προτίμηση επιτρέπει την εμφάνιση μιας σύνοψης των προσπαθειών των χρηστών στο μπλοκ επισκόπηση μαθημάτων στο Ταμπλό ή/και στη σελίδα εισόδου στο SCORM.';
$string['displayattemptstatusdesc'] = 'Αν η περίληψη των προσπαθειών του χρήστη εμφανίζεται στο μπλοκ επισκόπησης μαθημάτων στο Ταμπλό και/ή στη σελίδα εισαγωγής SCORM.';
$string['displaycoursestructure'] = 'Εμφάνιση δομής μαθήματος στη σελίδα εισόδου';
$string['displaycoursestructure_help'] = 'Αν ενεργοποιηθεί, ο πίνακας περιεχομένων εμφανίζεται στη σελίδα περιγράμματος του SCORM.';
$string['displaycoursestructuredesc'] = 'Αν ενεργοποιηθεί, ο πίνακας περιεχομένων εμφανίζεται στη σελίδα περιγράμματος του SCORM.';
$string['displaydesc'] = 'Αν το πακέτο SCORM θα εμφανίζεται σε νέο παράθυρο.';
$string['displaysettings'] = 'Ρυθμίσεις εμφάνισης';
$string['dnduploadscorm'] = 'Προσθήκη πακέτου SCORM';
$string['domxml'] = 'Εξωτερική βιβλιοθήκη DOMXML';
$string['element'] = 'Στοιχείο';
$string['enter'] = 'Είσοδος/Σύνδεση';
$string['entercourse'] = 'Είσοδος στο μάθημα';
$string['errorlogs'] = 'Αρχείο καταγραφής σφαλμάτων';
$string['eventattemptdeleted'] = 'Η προσπάθεια διαγράφηκε';
$string['eventinteractionsviewed'] = 'Εμφάνιση αλληλεπιδράσεων';
$string['eventreportviewed'] = 'Εμφάνιση αναφοράς';
$string['eventscolaunched'] = 'Εκκίνηση sco';
$string['eventscorerawsubmitted'] = 'Υποβλήθηκε ανεπεξέργαστο σκορ του SCORM';
$string['eventstatussubmitted'] = 'Υποβλήθηκε κατάσταση SCORM';
$string['eventtracksviewed'] = 'Εμφάνιση παρακολούθησης';
$string['eventuserreportviewed'] = 'Εμφάνιση αναφοράς χρήστη';
$string['everyday'] = 'Κάθε μέρα';
$string['everytime'] = 'Κάθε φορά που χρησιμοποιείται';
$string['exceededmaxattempts'] = 'Έχετε φτάσει το όριο του επιτρεπόμενου αριθμού προσπαθειών.';
$string['exit'] = 'Έξοδος από το μάθημα';
$string['exitactivity'] = 'Έξοδος από τη δραστηριότητα';
$string['expired'] = 'Λυπάμαι, αλλά η δραστηριότητα αυτή έκλεισε στις {$a} και δεν είναι πλέον διαθέσιμη';
$string['external'] = 'Χρόνος ενημέρωσης εξωτερικών πακέτων';
$string['failed'] = 'Απέτυχε';
$string['finishscorm'] = 'Αν ολοκληρώσατε την παρακολούθηση του πόρου, {$a}';
$string['finishscormlinkname'] = 'πατήστε εδώ για επιστροφή στη σελίδα του μαθήματος';
$string['firstaccess'] = 'Πρώτη προσπέλαση';
$string['firstattempt'] = 'Πρώτη προσπάθεια';
$string['floating'] = 'Κινούμενο';
$string['forceattemptalways'] = 'Πάντα';
$string['forceattemptoncomplete'] = 'Όταν η προηγούμενη προσπάθεια ολοκληρώθηκε, πέρασε ή απέτυχε';
$string['forcecompleted'] = 'Επιβολή ολοκλήρωσης';
$string['forcecompleted_help'] = 'Αν ενεργοποιηθεί, η κατάσταση της τρέχουσας προσπάθειας θα οριστεί υποχρεωτικά ως «ολοκληρώθηκε». (Ισχύει μόνο για πακέτα SCORM 1.2.)';
$string['forcecompleteddesc'] = 'Η ρύθμιση αυτή χρησιμοποιείται σαν εξ\' ορισμού τιμή για την επιβολή ολοκλήρωσης';
$string['forcejavascript'] = 'Επιβολή χρηστών να ενεργοποιήσουν την JavaScript';
$string['forcejavascript_desc'] = 'Εάν ενεργοποιηθεί (συνιστάται), εμποδίζει την πρόσβαση σε αντικείμενα SCORM όταν η JavaScript δεν υποστηρίζεται ή δεν είναι ενεργοποιημένη στον περιηγητή του χρήστη. Αν απενεργοποιηθεί, ο χρήστης μπορεί να δει το SCORM αλλά η επικοινωνία API θα αποτύχει και δεν θα αποθηκευτούν πληροφορίες βαθμολόγησης.';
$string['forcejavascriptmessage'] = 'Απαιτείται JavaScript για να δείτε αυτό το αντικείμενο, παρακαλούμε ενεργοποιήσετε την JavaScript στον περιηγητή σας και δοκιμάστε ξανά.';
$string['forcenewattempts'] = 'Επιβολή νέας προσπάθειας';
$string['forcenewattempts_help'] = 'Υπάρχουν 3 επιλογές:

* Όχι - Αν μια προηγούμενη προσπάθεια ολοκληρώθηκε, πέρασε ή απέτυχε, στον μαθητή θα παρέχεται η επιλογή να μπαίνει σε κατάσταση λειτουργίας αναθεώρησης ή να ξεκινά μια νέα προσπάθεια.
* Όταν η προηγούμενη προσπάθεια ολοκληρώθηκε, πέρασε ή απέτυχε - Το πακέτο SCORM αναλαμβάνει να ορίσει την κατάσταση «ολοκληρωμένη», «πέρασε» ή «απέτυχε».
* Πάντα - Κάθε επάνοδος στην δραστηριότητα SCORM θα δημιουργήσει μια νέα προσπάθεια και ο μαθητής δεν θα επιστρέψει στο ίδιο σημείο που έφτασε στην προηγούμενή του προσπάθεια.';
$string['found'] = 'Η διακήρυξη βρέθηκε';
$string['frameheight'] = 'Το ύψος του';
$string['framewidth'] = 'Το πλάτος του πλαισίου ή του παραθύρου';
$string['fromleft'] = 'Από αριστερά';
$string['fromtop'] = 'Από επάνω';
$string['fullscreen'] = 'Γέμισμα όλης της οθόνης';
$string['general'] = 'Γενικά δεδομένα';
$string['gradeaverage'] = 'Μέσος βαθμός';
$string['gradeforattempt'] = 'Βαθμός προσπάθειας';
$string['gradehighest'] = 'Υψηλότερος βαθμός';
$string['grademethod'] = 'Μέθοδος βαθμολόγησης';
$string['grademethod_help'] = 'Η μέθοδος βαθμολόγησης καθορίζει το πως θα οριστεί ο βαθμός για μια μοναδική προσπάθεια της δραστηριότητας. Υπάρχουν 4 μέθοδοι βαθμολόγησης: * Μαθησιακά αντικείμενα - Ο αριθμός των ολοκληρωμένων/περασμένων μαθησιακών αντικειμένων. * Μέγιστος βαθμός - Το υψηλότερο σκορ που επιτεύχθηκε σε όλα τα περασμένα μαθησιακά αντικείμενα. * Μέσος όρος βαθμών - Η μέση τιμή όλων των σκορ. * Άθροισμα βαθμών - Το άθροισμα όλων των σκορ.';
$string['grademethoddesc'] = 'Η μέθοδος βαθμολόγησης καθορίζει το πως θα προσδιοριστεί ο βαθμός για μια μοναδική προσπάθεια της δραστηριότητας.';
$string['gradereported'] = 'Βαθμολογία';
$string['gradescoes'] = 'Μαθησιακά αντικείμενα';
$string['gradesettings'] = 'Ρυθμίσεις βαθμού';
$string['gradesum'] = 'Άθροισμα βαθμού';
$string['height'] = 'Ύψος';
$string['hidden'] = 'Κρυμμένο';
$string['hidebrowse'] = 'Απενεργοποίηση κατάστασης προεπισκόπησης';
$string['hidebrowse_help'] = 'Η κατάσταση προεπισκόπησης επιτρέπει σε έναν μαθητή να περιηγείται σε μια δραστηριότητα πριν την προσπαθήσει. Αν η κατάσταση προεπισκόπησης είναι απενεργοποιημένη, το κουμπί για την προεπισκόπηση αποκρύπτεται.';
$string['hidebrowsedesc'] = 'Η κατάσταση προεπισκόπησης επιτρέπει σε έναν μαθητή να περιηγείται σε μια δραστηριότητα πριν την προσπαθήσει.';
$string['hideexit'] = 'Απόκρυψη συνδέσμου εξόδου';
$string['hidereview'] = 'Απόκρυψη κουμπιού αναθεώρησης';
$string['hidetoc'] = 'Εμφάνιση δομής μαθήματος στο πρόγραμμα αναπαραγωγής';
$string['hidetoc_help'] = 'Ο τρόπος εμφάνισης του πίνακα περιεχομένων στο λογισμικό αναπαραγωγής του SCORM.';
$string['hidetocdesc'] = 'Η ρύθμιση αυτή καθορίζει το πως εμφανίζεται ο πίνακας περιεχομένων στο πρόγραμμα αναπαραγωγής του SCORM.';
$string['highestattempt'] = 'Υψηλότερη βαθμολογία';
$string['identifier'] = 'Αναγνωριστικό ερώτησης';
$string['incomplete'] = 'Μη ολοκληρωμένο';
$string['indicator:cognitivedepth'] = 'Βάθος κατανόησης SCORM';
$string['indicator:cognitivedepth_help'] = 'Αυτός ο δείκτης βασίζεται στο βάθος κατανόησης που επιτεύχθηκε από τον μαθητή σε μια δραστηριότητα SCORM.';
$string['indicator:cognitivedepthdef'] = 'Βάθος κατανόησης SCORM';
$string['indicator:cognitivedepthdef_help'] = 'Ο συμμετέχων έχει φτάσει αυτό το ποσοστό αφοσίωσης στο βάθος κατανόησης που προσφέρεται από τις δραστηριότητες SCORM κατά τη διάρκεια αυτού του διαστήματος ανάλυσης (Επίπεδα = Καμία εμφάνιση, Εμφάνιση, Υποβολή, Εμφάνιση ανατροφοδότησης)';
$string['indicator:cognitivedepthdef_link'] = 'Δείκτες_μαθησιακής_αναλυτικής#Βάθος_κατανόησης';
$string['indicator:socialbreadth'] = 'Κοινωνικό εύρος SCORM';
$string['indicator:socialbreadth_help'] = 'Αυτός ο δείκτης βασίζεται στο κοινωνικό εύρος που επιτεύχθηκε από τον μαθητή σε μια δραστηριότητα SCORM.';
$string['indicator:socialbreadthdef'] = 'Κοινωνικό εύρος SCORM';
$string['indicator:socialbreadthdef_help'] = 'Ο συμμετέχων έχει φτάσει αυτό το ποσοστό αφοσίωσης στο κοινωνικό εύρος που προσφέρεται από τις δραστηριότητες SCORM κατά τη διάρκεια αυτού του διαστήματος ανάλυσης (Επίπεδα = Καμία συμμετοχή, Συμμετέχων μόνος)';
$string['indicator:socialbreadthdef_link'] = 'Δείκτες_μαθησιακής_αναλυτικής#Κοινωνικό_εύρος';
$string['interactions'] = 'Αλληλεπιδράσεις';
$string['invalidactivity'] = 'Η δραστηριότητα SCORM είναι λανθασμένη';
$string['invalidhacpsession'] = 'Μη έγκυρη σύνοδος HACP';
$string['invalidmanifestname'] = 'Μπορεί να γίνει επιλογή μόνο imsmanifest.xml ή .zip αρχείων';
$string['invalidmanifestresource'] = 'ΠΡΟΣΟΧΗ: Οι παρακάτω πόροι αναφέρονται στο manifest, αλλά δεν είναι εφικτή η εύρεση τους:';
$string['invalidstatus'] = 'Μη έγκυρη κατάσταση';
$string['invalidurl'] = 'Μη έγκυρο URL';
$string['invalidurlhttpcheck'] = 'Μη έγκυρο URL. Μήνυμα αποσφαλμάτωσης:<pre>{$a->cmsg}</pre>';
$string['last'] = 'Τελευταία πρόσβαση στις';
$string['lastaccess'] = 'Τελευταία πρόσβαση';
$string['lastattempt'] = 'Τελευταία ολοκληρωμένη προσπάθεια';
$string['lastattemptlock'] = 'Κλείδωμα μετά την τελική προσπάθεια';
$string['lastattemptlock_help'] = 'Εάν ενεργοποιηθεί, ένας μαθητής εμποδίζεται να ξεκινήσει το πρόγραμμα εκτέλεσης SCORM όταν πια έχει χρησιμοποιήσει προσπάθειες που του εκχωρήθηκαν.';
$string['lastattemptlockdesc'] = 'Εάν ενεργοποιηθεί, ένας μαθητής εμποδίζεται να ξεκινήσει το πρόγραμμα εκτέλεσης SCORM όταν πια έχει χρησιμοποιήσει όλες τις προσπάθειες που του εκχωρήθηκαν.';
$string['location'] = 'Εμφάνιση γραμμής διευθύνσεως';
$string['masteryoverride'] = 'Ένα σκορ αριστοτεχνίας παρακάμπτει την κατάσταση';
$string['masteryoverride_help'] = 'Εάν ενεργοποιηθεί και παρέχεται σκορ αριστοτεχνίας, όταν καλείται το LMSFinish και έχει οριστεί ανεπεξέργαστο σκορ, η κατάσταση θα επανυπολογιστεί χρησιμοποιώντας το ανεπεξέργαστο σκορ και το σκορ αριστοτεχνίας και οποιαδήποτε κατάσταση παρέχεται από το SCORM (συμπεριλαμβανομένης της «ανολοκλήρωτη») θα παρακαμφθεί.';
$string['masteryoverridedesc'] = 'Αυτή η προτίμηση ορίζει την προεπιλογή για τη ρύθμιση παράκαμψης λόγω σκορ αριστοτεχνίας';
$string['max'] = 'Μέγιστο σκορ';
$string['maximumattempts'] = 'Μέγιστος αριθμός προσπαθειών';
$string['maximumattempts_help'] = 'Αυτή η ρύθμιση δίνει την δυνατότητα να περιοριστεί ο αριθμός των προσπαθειών. Εφαρμόζεται μόνο για πακέτα SCORM 1.2 και AICC.';
$string['maximumattemptsdesc'] = 'Η ρύθμιση αυτή χρησιμοποιείται σαν εξ\' ορισμού τιμή για τον μέγιστο αριθμό προσπαθειών';
$string['maximumgradedesc'] = 'Η ρύθμιση αυτή χρησιμοποιείται σαν εξ\' ορισμού τιμή για τον μέγιστο βαθμό';
$string['menubar'] = 'Εμφάνιση της γραμμής μενού';
$string['min'] = 'Ελάχιστο σκορ';
$string['missing_attribute'] = 'Απούσα ιδιότητα {$a->attr} στην ετικέτα {$a->tag}';
$string['missing_tag'] = 'Απούσα ετικέτα {$a->tag}';
$string['missingparam'] = 'Λείπει ή είναι λάθος μια απαιτούμενη παράμετρος';
$string['mode'] = 'Κατάσταση';
$string['modulename'] = 'Πακέτο SCORM';
$string['modulename_help'] = 'Ένα πακέτο SCORM είναι μια συλλογή αρχείων που συσκευάζονται σύμφωνα με ένα συμφωνημένο πρότυπο για μαθησιακά αντικείμενα. Το άρθρωμα δραστηριότητας SCORM επιτρέπει σε ένα SCORM ή AICC πακέτο να ανεβαίνει ως ένα συμπιεσμένο αρχείο zip και να προστίθεται σε ένα μάθημα. Το περιεχόμενο συνήθως εμφανίζεται σε αρκετές σελίδες, με πλοήγηση μεταξύ των σελίδων. Υπάρχουν διάφορες επιλογές για την προβολή περιεχομένου σε ένα αναδυόμενο παράθυρο, με έναν πίνακα περιεχομένων, με πλήκτρα πλοήγησης κλπ. Οι δραστηριότητες SCORM γενικά περιλαμβάνουν ερωτήσεις, με τους βαθμούς να καταγράφονται στο βαθμολόγιο. Οι δραστηριότητες SCORM μπορεί να χρησιμοποιηθούν:

* Για την παρουσίαση πολυμεσικού περιεχομένου και κινουμένων σχεδίων
* Ως εργαλείο αξιολόγησης';
$string['modulename_link'] = '';
$string['modulenameplural'] = 'Πακέτα SCORM';
$string['myaiccsessions'] = 'Οι σύνοδοι AICC μου';
$string['myattempts'] = 'Οι προσπάθειές μου';
$string['nav'] = 'Εμφάνιση Πλοήγησης';
$string['nav_help'] = 'Αυτή η ρύθμιση καθορίζει αν θα εμφανίζονται ή θα αποκρύπτονται τα κουμπιά πλοήγησης και η θέση τους.
Υπάρχουν 3 επιλογές:

* Όχι - Τα κουμπιά πλοήγησης δεν εμφανίζονται
* Κάτω από το περιεχόμενο - Τα κουμπιά πλοήγησης εμφανίζονται κάτω από το περιεχόμενο του πακέτου SCORM
* Αιωρούμενα - Τα κουμπιά πλοήγησης εμφανίζονται αιωρούμενα, με την απόσταση της θέσης από πάνω και από αριστερά να καθορίζεται από το πακέτο.';
$string['navdesc'] = 'Αυτή η ρύθμιση καθορίζει αν θα εμφανίζονται ή θα αποκρύπτονται τα πλήκτρα πλοήγησης και η θέση τους.';
$string['navigation'] = 'Πλοήγηση';
$string['navpositionleft'] = 'Θέση πλήκτρων πλοήγησης από αριστερά σε εικονοστοιχεία.';
$string['navpositiontop'] = 'Θέση πλήκτρων πλοήγησης από επάνω σε εικονοστοιχεία.';
$string['networkdropped'] = 'Το λογισμικό αναπαραγωγής SCORM έχει διαπιστώσει ότι η σύνδεσή σας στο Διαδίκτυο είναι αναξιόπιστη ή έχει διακοπεί. Αν συνεχίσετε σε αυτή την δραστηριότητα SCORM, η πρόοδος σας μπορεί να μην σωθεί. <br />
Θα πρέπει να βγείτε από τη δραστηριότητα τώρα, και να επιστρέψει όταν θα έχετε μια αξιόπιστη σύνδεση στο Διαδίκτυο.';
$string['newattempt'] = 'Έναρξη νέας προσπάθειας';
$string['next'] = 'Συνέχεια';
$string['no_attributes'] = 'Η ετικέτα {$a->tag} πρέπει να έχει ιδιότητες';
$string['no_children'] = 'Η ετικέτα {$a->tag} πρέπει να έχει θυγατρικές';
$string['noactivity'] = 'Τίποτα προς αναφορά';
$string['noattemptsallowed'] = 'Επιτρεπόμενος αριθμός προσπαθειών';
$string['noattemptsmade'] = 'Αριθμός προσπαθειών που κάνατε';
$string['nolimit'] = 'Απεριόριστες προσπάθειες';
$string['nomanifest'] = 'Λάθος πακέτο αρχείου - λείπει το imsmanifest.xml ή η δομή AICC';
$string['noprerequisites'] = 'Συγγνώμη αλλά δεν έχετε τις απαιτούμενες προϋποθέσεις για να προσπελάσετε αυτή τη δραστηριότητα.';
$string['noreports'] = 'Καμία αναφορά για προβολή';
$string['normal'] = 'Κανονικό';
$string['noscriptnoscorm'] = 'Ο περιηγητής σας δεν υποστηρίζει τη Javascript ή είναι απενεργοποιημένη. Αυτό το πακέτο SCORM μπορεί να μην εμφανιστεί ή να μην αποθηκεύσει δεδομένα σωστά.';
$string['not_corr_type'] = 'Αναντιστοιχία τύπου για την ετικέτα {$a->tag}';
$string['notattempted'] = 'Δεν έγινε προσπάθεια';
$string['notopenyet'] = 'Συγγνώμη, αυτή η δραστηριότητα δεν είναι διαθέσιμη μέχρι {$a}';
$string['objectives'] = 'Στόχοι';
$string['openafterclose'] = 'Έχετε ορίσει ημερομηνία έναρξης μετά την ημερομηνία λήξης';
$string['optallstudents'] = 'όλοι οι χρήστες';
$string['optattemptsonly'] = 'χρήστες με προσπάθειες μόνο';
$string['options'] = 'Επιλογές (Εμποδίζονται από μερικούς περιηγητές)';
$string['optionsadv'] = 'Επιλογές (Προχωρημένες)';
$string['optionsadv_desc'] = 'Αν επιλεγεί, το ύψος και το πλάτος θα εμφανίζονται ως προχωρημένες επιλογές.';
$string['optnoattemptsonly'] = 'χρήστες χωρίς προσπάθειες μόνο';
$string['organization'] = 'Οργανισμός';
$string['organizations'] = 'Οργανισμοί';
$string['othersettings'] = 'Επιπρόσθετες ρυθμίσεις';
$string['package'] = 'Περιεχόμενο πακέτου';
$string['package_help'] = 'Το αρχείο πακέτου είναι ένα συμπιεσμένο zip (ή pif) αρχείο που περιέχει αρχεία ορισμού μαθήματος SCORM/AICC.';
$string['packagedir'] = 'Σφάλμα αρχείων συστήματος: Αδυναμία δημιουργίας φακέλου πακέτου';
$string['packagefile'] = 'Δεν καθορίστηκε αρχείο πακέτου';
$string['packagehdr'] = 'Πακέτο';
$string['packageurl'] = 'Διεύθυνση URL';
$string['packageurl_help'] = 'Αυτή η ρύθμιση επιτρέπει να οριστεί ένα URL για το πακέτο SCORM, αντί να γίνει επιλογή ενός αρχείου μέσω του επιλογέα αρχείων.';
$string['page-mod-scorm-x'] = 'Οποιαδήποτε σελίδα του SCORM';
$string['pagesize'] = 'Μέγεθος σελίδας';
$string['passed'] = 'Πέρασε';
$string['php5'] = 'PHP 5 (βιβλιοθήκη DOMXML)';
$string['pluginadministration'] = 'Διαχείριση πακέτου SCORM';
$string['pluginname'] = 'πακέτο SCORM';
$string['popup'] = 'Νέο παράθυρο';
$string['popuplaunched'] = 'Αυτό το πακέτο SCORM έχει ανοίξει σε αναδυόμενο παράθυρο. Αν έχετε τελειώσει με την παρακολούθηση του πόρου, πατήστε εδώ για να επιστρέψετε στη σελίδα του μαθήματος';
$string['popupmenu'] = 'Σε ένα πτυσσόμενο μενού';
$string['popupopen'] = 'Άνοιγμα πακέτου σε νέο παράθυρο';
$string['popupsblocked'] = 'Φαίνεται ότι τα αναδυόμενα παράθυρα αποκλείονται, εμποδίζοντας την αναπαραγωγή του πακέτου SCORM. Παρακαλούμε ελέγξτε τις ρυθμίσεις του περιηγητή σας και δοκιμάστε ξανά.';
$string['position_error'] = 'Η ετικέτα {$a->tag} δεν μπορεί να είναι απόγονος/παιδί της ετικέτας {$a->parent}';
$string['preferencespage'] = 'Προτιμήσεις μόνο για αυτή τη σελίδα';
$string['preferencesuser'] = 'Προτιμήσεις για αυτή την αναφορά';
$string['prev'] = 'Προηγούμενο';
$string['privacy:metadata:aicc:data'] = 'Προσωπικά δεδομένα που διαβιβάστηκαν από το υποσύστημα AICC/SCORM.';
$string['privacy:metadata:aicc:externalpurpose'] = 'Αυτό το πρόσθετο αποστέλλει δεδομένα εξωτερικά με χρήση AICC HACP.';
$string['privacy:metadata:aicc_session:lessonstatus'] = 'Η κατάσταση της διδασκαλίας προς παρακολούθηση';
$string['privacy:metadata:aicc_session:scormmode'] = 'Η κατάσταση λειτουργίας του στοιχείου προς παρακολούθηση';
$string['privacy:metadata:aicc_session:scormstatus'] = 'Η κατάσταση του στοιχείου προς παρακολούθηση';
$string['privacy:metadata:aicc_session:sessiontime'] = 'Ο χρόνος συνόδου προς παρακολούθηση';
$string['privacy:metadata:aicc_session:timecreated'] = 'Πότε δημιουργήθηκε το παρακολουθούμενο στοιχείο';
$string['privacy:metadata:attempt'] = 'Ο αριθμός προσπάθειας';
$string['privacy:metadata:scoes_track:element'] = 'Το όνομα του στοιχείου προς παρακολούθηση';
$string['privacy:metadata:scoes_track:value'] = 'Η τιμή του δεδομένου στοιχείου';
$string['privacy:metadata:scorm_aicc_session'] = 'Οι πληροφορίες συνόδου AICC HACP';
$string['privacy:metadata:timemodified'] = 'Πότε τροποποιήθηκε τελευταία το παρακολουθούμενο στοιχείο';
$string['privacy:metadata:userid'] = 'Το αναγνωριστικό του χρήστη που είχε πρόσβαση στη δραστηριότητα SCORM';
$string['protectpackagedownloads'] = 'Προστασία λήψεων πακέτου';
$string['protectpackagedownloads_desc'] = 'Αν ενεργοποιηθεί, τα πακέτα SCORM μπορούν να κατέβουν μόνο αν ο χρήστης έχει τη δυνατότητα course:manageactivities. Αν απενεργοποιηθεί, τα πακέτα SCORM μπορούν να κατέβουν χωρίς περιορισμό (από κινητό ή άλλα μέσα).';
$string['raw'] = 'Ανεπεξέργαστο σκορ';
$string['regular'] = 'Κανονικό manifest';
$string['report'] = 'Αναφορά';
$string['reportcountallattempts'] = '{$a->nbattempts} προσπάθειες από {$a->nbusers} χρήστες, από {$a->nbresults} αποτελέσματα';
$string['reportcountattempts'] = '{$a->nbresults} αποτελέσματα ({$a->nbusers} χρήστες)';
$string['reports'] = 'Αναφορές';
$string['repositorynotsupported'] = 'Αυτό το αποθετήριο δεν υποστηρίζει σύνδεση απευθείας σε ένα αρχείο imsmanifest.xml.';
$string['response'] = 'Απόκριση';
$string['result'] = 'Αποτέλεσμα';
$string['results'] = 'Αποτελέσματα';
$string['review'] = 'Ανασκόπηση';
$string['reviewmode'] = 'Κατάσταση ανασκόπησης';
$string['rightanswer'] = 'Σωστή απάντηση';
$string['scoes'] = 'Μαθησιακά αντικείμενα';
$string['score'] = 'Σκορ';
$string['scorm:addinstance'] = 'Προσθήκη νέου SCORM πακέτου';
$string['scorm:deleteownresponses'] = 'Διαγραφή των προσπαθειών σας';
$string['scorm:deleteresponses'] = 'Διαγραφή προσπαθειών';
$string['scorm:savetrack'] = 'Αποθήκευση παρακολούθησης';
$string['scorm:skipview'] = 'Παράληψη επισκόπησης';
$string['scorm:viewreport'] = 'Εμφάνιση αναφορών';
$string['scorm:viewscores'] = 'Εμφάνιση των σκορ';
$string['scormclose'] = 'Διαθέσιμο μέχρι';
$string['scormcourse'] = 'Εκπαιδευτική διαδικασία';
$string['scormloggingoff'] = 'Η καταγραφή του API είναι απενεργοποιημένη';
$string['scormloggingon'] = 'Η καταγραφή του API είναι ενεργοποιημένη';
$string['scormopen'] = 'Διαθέσιμο από';
$string['scormresponsedeleted'] = 'Οι προσπάθειες των χρηστών διαγράφηκαν';
$string['scormstandard'] = 'Κατάσταση λειτουργίας προτύπων SCORM';
$string['scormstandarddesc'] = 'Όταν είναι απενεργοποιημένο, το Moodle επιτρέπει στα πακέτα SCORM 1.2 να αποθηκεύουν περισσότερα από όσα επιτρέπονται από τις προδιαγραφές και χρησιμοποιεί τις ρυθμίσεις μορφότυπου πλήρους ονόματος Moodle όταν μεταβιβάζει το όνομα χρήστη στο πακέτο SCORM.';
$string['scormtype'] = 'Τύπος';
$string['scormtype_help'] = 'Αυτή η ρύθμιση καθορίζει τον τρόπο με τον οποίο περιλαμβάνεται το πακέτο στο μάθημα. Υπάρχουν έως και 4 επιλογές:

* Ανεβασμένο πακέτο - Ενεργοποιεί την επιλογή ενός πακέτου SCORM μέσω του εργαλείου επιλογής αρχείων
* Εξωτερική διακήρυξη (περιγραφή αρχείων πακέτου) SCORM - Επιτρέπει τον καθορισμό μιας διεύθυνσης URL ενός αρχείου imsmanifest.xml. Σημείωση: Εάν η διεύθυνση URL έχει διαφορετικό όνομα τομέα από τον ιστότοπό σας, τότε το «Κατεβασμένο πακέτο» είναι μια καλύτερη επιλογή, γιατί αλλιώς οι βαθμοί δεν αποθηκεύονται.
* Κατεβασμένο πακέτο - Επιτρέπει τον καθορισμό μιας διεύθυνσης URL ενός πακέτου. Το πακέτο θα αποσυμπιεστεί και θα αποθηκευτεί τοπικά και θα ενημερωθεί όταν ενημερωθεί το εξωτερικό πακέτο SCORM.
* Εξωτερική διεύθυνση URL AICC - αυτή η διεύθυνση URL είναι η διεύθυνση URL έναρξης για μια μόνο δραστηριότητα AICC. Ένα πακέτο psuedo θα κατασκευαστεί γύρω από αυτό.';
$string['scrollbars'] = 'Εμφάνιση γραμμών κύλισης';
$string['search:activity'] = 'πακέτο SCORM - πληροφορίες δραστηριότητας';
$string['selectall'] = 'Επιλογή όλων';
$string['selectnone'] = 'Αποεπιλογή όλων';
$string['show'] = 'Εμφάνιση';
$string['sided'] = 'Πλευρικά';
$string['skipview'] = 'Μη προβολή σελίδας δομής περιεχομένου';
$string['skipview_help'] = 'Αυτή η ρύθμιση καθορίζει αν η σελίδα δομής περιεχομένου θα πρέπει ποτέ να παραλειφθεί (να μην εμφανιστεί). Εάν το πακέτο περιέχει μόνο ένα μαθησιακό αντικείμενο, η σελίδα δομής περιεχομένου μπορεί πάντα να παραλειφθεί.';
$string['skipviewdesc'] = 'Η ρύθμιση αυτή χρησιμοποιείται σαν εξ\' ορισμού τιμή για τη μη προβολή σελίδας δομής περιεχομένου';
$string['slashargs'] = 'ΠΡΟΣΟΧΗ: Οι παράμετροι γραμμής εντολών είναι απενεργοποιημένες σε αυτό τον ιστότοπο και τα αντικείμενα (π.χ. SCORM) μπορεί να μην λειτουργούν όπως αναμένεται!';
$string['stagesize'] = 'Μέγεθος σκηνής';
$string['stagesize_help'] = 'Αυτές οι δύο ρυθμίσεις καθορίζουν το πλάτος και το ύψος πλαισίου/παραθύρου για τα μαθησιακά αντικείμενα.';
$string['started'] = 'Ξεκίνησε στις';
$string['status'] = 'Κατάσταση';
$string['statusbar'] = 'Εμφάνιση γραμμής κατάστασης';
$string['student_response'] = 'Απόκριση';
$string['subplugintype_scormreport'] = 'Αναφορά';
$string['subplugintype_scormreport_plural'] = 'Αναφορές';
$string['suspended'] = 'Σε αναστολή';
$string['syntax'] = 'Συντακτικό λάθος';
$string['tag_error'] = 'Άγνωστη ετικέτα ({$a->tag}) με αυτό το περιεχόμενο: {$a->value}';
$string['time'] = 'Ώρα';
$string['title'] = 'Τίτλος';
$string['toc'] = 'Πίνακας περιεχομένων';
$string['too_many_attributes'] = 'Η ετικέτα ({$a->tag}) έχει υπερβολικά πολλές ιδιότητες';
$string['too_many_children'] = 'Η ετικέτα ({$a->tag}) έχει υπερβολικά πολλά παιδιά/απογόνους';
$string['toolbar'] = 'Εμφάνιση εργαλειοθήκης';
$string['totaltime'] = 'Συνολικός Χρόνος';
$string['trackcorrectcount'] = 'Καταμέτρηση σωστών απαντήσεων';
$string['trackcorrectcount_help'] = 'Αριθμός σωστών απαντήσεων για την ερώτηση';
$string['trackid'] = 'Αναγνωριστικό';
$string['trackid_help'] = 'Αυτό είναι το αναγνωριστικό που ορίζεται από το πακέτο SCORM για την ερώτηση, η προδιαγραφή SCORM δεν επιτρέπει την εμφάνιση του πλήρους κειμένου της ερώτησης.';
$string['trackingloose'] = 'ΠΡΟΣΟΧΗ: Τα δεδομένα παρακολούθησης αυτού του πακέτου θα χαθούν!';
$string['tracklatency'] = 'Χρόνος αναμονής';
$string['tracklatency_help'] = 'Το χρονικό διάστημα που μεσολάβησε από τη διάθεση της ερώτησης στον εκπαιδευόμενο για απάντηση μέχρι την πρώτη απάντηση.';
$string['trackpattern'] = 'Μοτίβο';
$string['trackpattern_help'] = 'Εδώ είναι μια σωστή απάντηση σε αυτή την ερώτηση· δεν εμφανίζει την απάντηση των εκπαιδευόμενων.';
$string['trackresponse'] = 'Απόκριση';
$string['trackresponse_help'] = 'Αυτή είναι η απάντηση που έδωσε ο εκπαιδευόμενος στην ερώτηση';
$string['trackresult'] = 'Αποτέλεσμα';
$string['trackresult_help'] = 'Εμφανίζει αν ο εκπαιδευόμενος έδωσε τη σωστή απάντηση';
$string['trackscoremax'] = 'Μέγιστο σκορ';
$string['trackscoremax_help'] = 'Η μέγιστη τιμή που μπορεί να δοθεί για το ανεπεξέργαστο σκορ';
$string['trackscoremin'] = 'Ελάχιστο σκορ';
$string['trackscoremin_help'] = 'Η ελάχιστη τιμή που μπορεί να δοθεί για το ανεπεξέργαστο σκορ';
$string['trackscoreraw'] = 'Ανεπεξέργαστο σκορ';
$string['trackscoreraw_help'] = 'Ο αριθμός που αντικατοπτρίζει την απόδοση του εκπαιδευόμενου σε σχέση με το εύρος που ορίζεται από τις τιμές της ελάχιστης και μέγιστης βαθμολογίας';
$string['tracksuspenddata'] = 'Αναστολή δεδομένων';
$string['tracksuspenddata_help'] = 'Παρέχει χώρο για την αποθήκευση και ανάκτηση δεδομένων μεταξύ των συνόδων του εκπαιδευόμενου';
$string['tracktime'] = 'Ώρα';
$string['tracktime_help'] = 'Η ώρα που ξεκίνησε η προσπάθεια';
$string['tracktype'] = 'Τύπος';
$string['tracktype_help'] = 'Ο τύπος της ερώτησης, για παράδειγμα «επιλογής» ή «σύντομης απάντησης»';
$string['trackweight'] = 'Συντελεστής βαρύτητας';
$string['trackweight_help'] = 'Ο συντελεστής βαρύτητας που έχει ανατεθεί στην ερώτηση κατά τον υπολογισμό του σκορ.';
$string['type'] = 'Τύπος';
$string['typeaiccurl'] = 'URL Εξωτερικού AICC';
$string['typeexternal'] = 'Εξωτερικό SCORM manifest';
$string['typelocal'] = 'Ανεβασμένο πακέτο';
$string['typelocalsync'] = 'Κατεβασμένο πακέτο';
$string['undercontent'] = 'Κάτω από το περιεχόμενο';
$string['unziperror'] = 'Εμφανίστηκε σφάλμα κατά την αποσυμπίεση του πακέτου';
$string['updatefreq'] = 'Συχνότητα αυτόματης ενημέρωσης';
$string['updatefreq_error'] = 'Η συχνότητα αυτόματης ενημέρωσης μπορεί να οριστεί μόνο όταν το αρχείο του πακέτου φιλοξενείται εξωτερικά';
$string['updatefreq_help'] = 'Επιτρέπει το εξωτερικό πακέτο να κατεβαίνει και να ενημερώνεται αυτόματα';
$string['updatefreqdesc'] = 'Η ρύθμιση αυτή καθορίζει τη συχνότητα αυτόματης ενημέρωσης της δραστηριότητας';
$string['validateascorm'] = 'Επικύρωση πακέτου';
$string['validation'] = 'Αποτέλεσμα επικύρωσης';
$string['validationtype'] = 'Αυτή η ρύθμιση ορίζει τη βιβλιοθήκη DOMXML που χρησιμοποιείται για την επικύρωση των αρχείων καταγραφής SCORM. Αν δε γνωρίζετε αφήστε την επιλεγμένη ρύθμιση.';
$string['value'] = 'Τιμή';
$string['versionwarning'] = 'Η έκδοση του manifest είναι παλαιότερη της 1.3, προσοχή στην ετικέτα {$a->tag}';
$string['viewallreports'] = 'Εμφάνιση αναφορών για {$a} προσπάθειες';
$string['viewalluserreports'] = 'Εμφάνιση αναφορών για {$a} χρήστες';
$string['whatgrade'] = 'Βαθμολόγηση προσπαθειών';
$string['whatgrade_help'] = 'Αν επιτρέπονται πολλαπλές προσπάθειες, αυτή η ρύθμιση καθορίζει αν η υψηλότερη, ο μέσος όρος, η πρώτη ή η τελευταία ολοκληρωμένη προσπάθεια καταγράφεται στο βαθμολόγιο. Η επιλογή της τελευταίας ολοκληρωμένης προσπάθειας δεν περιλαμβάνει απόπειρες σε κατάσταση «απέτυχε».

Σημειώσεις σχετικά με το χειρισμό των πολλαπλών προσπαθειών:

* Η επιλογή για να ξεκινήσει μια νέα προσπάθεια παρέχεται από ένα πλαίσιο επιλογής πάνω από το πλήκτρο Enter στη σελίδα δομής του περιεχομένου, οπότε επιβεβαιώστε ότι υπάρχει πρόσβαση σε αυτή τη σελίδα, αν θέλετε να επιτρέψετε περισσότερες από μία προσπάθειες.
* Μερικά πακέτα SCORM είναι έξυπνα σχετικά με τις νέες προσπάθειες ενώ άλλα δεν είναι. Αυτό σημαίνει ότι αν ο εκπαιδευόμενος εισέλθει εκ νέου σε μια υπάρχουσα προσπάθεια, αν το περιεχόμενο SCORM δεν έχει εσωτερική λογική για την αποφυγή αντικατάστασης προηγούμενων προσπαθειών, αυτές μπορούν να αντικατασταθούν, ακόμα και αν η προσπάθεια «ολοκληρώθηκε» ή «πέρασε».
* Οι ρυθμίσεις «Επιβολή ολοκλήρωσης», «Επιβολή νέας προσπάθειας» και «Κλείδωμα μετά την τελική προσπάθεια» μπορούν επίσης να παρέχουν περαιτέρω διαχείριση των πολλαπλών προσπαθειών.';
$string['whatgradedesc'] = 'Αν η υψηλότερη, ο μέσος όρος, η πρώτη ή η τελευταία ολοκληρωμένη προσπάθεια θα καταγραφεί στο βαθμολόγιο αν επιτρέπονται πολλαπλές προσπάθειες.';
$string['width'] = 'Πλάτος';
$string['window'] = 'Παράθυρο';
$string['youmustselectastatus'] = 'Θα πρέπει να επιλέξετε μια απαιτούμενη κατάσταση';
