<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'local_moodlemobileapp', language 'el', version '5.1'.
 *
 * @package     local_moodlemobileapp
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['addon.blog.errorloadentries'] = 'Σφάλμα φόρτωσης καταχωρήσεων ιστολογίου.';
$string['addon.blog.showonlyyourentries'] = 'Εμφάνιση μόνο των καταχωρήσεών σας';
$string['addon.calendar.calendarevent'] = 'Γεγονός ημερολογίου';
$string['addon.calendar.calendarevents'] = 'Γεγονότα ημερολογίου';
$string['addon.calendar.calendarreminders'] = 'Υπενθυμίσεις ημερολογίου';
$string['addon.calendar.currentmonth'] = 'Τρέχων μήνας';
$string['addon.calendar.defaultnotificationtime'] = 'Προεπιλεγμένος χρόνος ειδοποίησης';
$string['addon.calendar.errorloadevent'] = 'Σφάλμα στην φόρτωση γεγονότος.';
$string['addon.calendar.errorloadevents'] = 'Σφάλμα στην φόρτωση γεγονότων.';
$string['addon.calendar.noevents'] = 'Δεν υπάρχουν γεγονότα';
$string['addon.calendar.reminders'] = 'Υπενθυμίσεις';
$string['addon.calendar.setnewreminder'] = 'Ορισμός μιας νέας υπενθύμισης';
$string['addon.competency.errornocompetenciesfound'] = 'Δεν βρέθηκαν ικανότητες';
$string['addon.competency.nocompetencies'] = 'Δεν βρέθηκαν ικανότητες';
$string['addon.coursecompletion.complete'] = 'Ολοκλήρωση';
$string['addon.coursecompletion.couldnotloadreport'] = 'Δεν ήταν δυνατή η φόρτωση της αναφοράς ολοκλήρωσης του μαθήματος, δοκιμάστε ξανά αργότερα.';
$string['addon.messageoutput_airnotifier.processorsettingsdesc'] = 'Διαμόρφωση συσκευών';
$string['addon.messages.contactlistempty'] = 'Η λίστα επαφών είναι κενή';
$string['addon.messages.contactname'] = 'Όνομα επαφής';
$string['addon.messages.deletemessage'] = 'Διαγραφή μηνύματος';
$string['addon.messages.deletemessageconfirmation'] = 'Σίγουρα θέλετε να διαγράψετε αυτό το μήνυμα; Θα διαγραφεί μόνο από το ιστορικό μηνυμάτων σας και θα εξακολουθεί να είναι ορατό από το χρήστη που έστειλε ή έλαβε το μήνυμα.';
$string['addon.messages.errordeletemessage'] = 'Σφάλμα κατά τη διαγραφή του μηνύματος.';
$string['addon.messages.errorwhileretrievingcontacts'] = 'Σφάλμα κατά την ανάκτηση των επαφών από τον εξυπηρετητή.';
$string['addon.messages.errorwhileretrievingdiscussions'] = 'Σφάλμα κατά την ανάκτηση των συζητήσεων από τον εξυπηρετητή.';
$string['addon.messages.errorwhileretrievingmessages'] = 'Σφάλμα κατά την ανάκτηση των μηνυμάτων από τον εξυπηρετητή.';
$string['addon.messages.errorwhileretrievingusers'] = 'Σφάλμα κατά την λήψη χρηστών από τον εξυπηρετητή.';
$string['addon.messages.messagenotsent'] = 'Το μήνυμα δεν στάλθηκε, δοκιμάστε ξανά αργότερα.';
$string['addon.messages.newmessages'] = 'Νέα μηνύματα';
$string['addon.messages.nousersfound'] = 'Δεν βρέθηκαν χρήστες';
$string['addon.messages.showdeletemessages'] = 'Εμφάνιση διαγραμμένων μηνυμάτων';
$string['addon.messages.type_blocked'] = 'Μπλοκαρισμένοι';
$string['addon.messages.type_offline'] = 'Εκτός σύνδεσης';
$string['addon.messages.type_online'] = 'Εντός σύνδεσης';
$string['addon.messages.type_search'] = 'Αποτελέσματα αναζήτησης';
$string['addon.messages.type_strangers'] = 'Άλλοι';
$string['addon.messages.useentertosenddescdesktop'] = 'Εάν απενεργοποιηθεί, μπορείτε να χρησιμοποιήσετε το συνδυασμό πλήκτρων Ctrl+Enter για να στείλετε το μήνυμα.';
$string['addon.messages.useentertosenddescmac'] = 'Εάν απενεργοποιηθεί, μπορείτε να χρησιμοποιήσετε το συνδυασμό πλήκτρων Cmd+Enter για να στείλετε το μήνυμα.';
$string['addon.messages.warningconversationmessagenotsent'] = 'Αδυναμία αποστολής μηνύματος/-άτων στην συζήτηση {{conversation}}. {{error}}';
$string['addon.messages.warningmessagenotsent'] = 'Το/Τα μηνύματα δεν μπόρεσαν να σταλούν στο χρήστη {{user}}. {{error}}';
$string['addon.mod_assign.acceptsubmissionstatement'] = 'Παρακαλούμε δεχθείτε τη δήλωση υποβολής.';
$string['addon.mod_assign.cannoteditduetostatementsubmission'] = 'Δεν μπορείτε να προσθέσετε ή να επεξεργαστείτε μια υποβολή στην εφαρμογή, γιατί δεν κατέστη δυνατό να ανακτηθεί η δήλωση υποβολής από τον ιστότοπο.';
$string['addon.mod_assign.cannotgradefromapp'] = 'Μερικές μέθοδοι βαθμολόγησης δεν υποστηρίζονται ακόμα από την εφαρμογή και δεν μπορεί να τροποποιηθεί.';
$string['addon.mod_assign.cannotsubmitduetostatementsubmission'] = 'Δεν μπορείτε να υποβάλετε για βαθμολόγηση στην εφαρμογή, γιατί δεν κατέστη δυνατό να ανακτηθεί η δήλωση υποβολής από τον ιστότοπο.';
$string['addon.mod_assign.erroreditpluginsnotsupported'] = 'Δεν μπορείτε να προσθέσετε ή να επεξεργαστείτε μια υποβολή στην εφαρμογή κινητού επειδή ορισμένα πρόσθετα δεν υποστηρίζονται ακόμη για επεξεργασία:';
$string['addon.mod_assign.errorshowinginformation'] = 'Δεν μπορούν να εμφανιστούν οι πληροφορίες υποβολής';
$string['addon.mod_assign.feedbacknotsupported'] = 'Αυτό το σχόλιο δεν υποστηρίζεται από την εφαρμογή και μπορεί να μην περιέχει όλες τις πληροφορίες';
$string['addon.mod_assign.gradenotsynced'] = 'Η βαθμολογία δεν συγχρονίστηκε';
$string['addon.mod_assign.notallparticipantsareshown'] = 'Συμμετέχοντες χωρίς υποβολές δεν προβάλλονται';
$string['addon.mod_assign.numberofdraftsubmissionscountdescription'] = 'Υπάρχουν {{count}} πρόχειρα.';
$string['addon.mod_assign.numberofparticipantscountdescription'] = 'Υπάρχουν {{count}} συμμετέχοντες.';
$string['addon.mod_assign.numberofsubmissionsneedgradingcountdescription'] = 'Υπάρχουν {{count}} υποβολές που χρειάζονται βαθμολόγηση.';
$string['addon.mod_assign.numberofsubmittedassignmentscountdescription'] = 'Υπάρχουν {{count}} υποβληθείσες εργασίες.';
$string['addon.mod_assign.numberofteamscountdescription'] = 'Υπάρχουν {{count}} ομάδες.';
$string['addon.mod_assign.submissionnotsupported'] = 'Η υποβολή αυτή δεν υποστηρίζεται από την εφαρμογή κινητού και μπορεί να μην περιέχει όλα τα στοιχεία.';
$string['addon.mod_assign.syncblockedusercomponent'] = 'βαθμός χρήστη';
$string['addon.mod_assign.warningsubmissiongrademodified'] = 'Ο βαθμός υποβολής τροποποιήθηκε στον ιστότοπο.';
$string['addon.mod_assign.warningsubmissionmodified'] = 'Η υποβολή του χρήστη τροποποιήθηκε στον ιστότοπο.';
$string['addon.mod_chat.confirmloss'] = 'Σίγουρα; Το ιστορικό συνομιλίας μπορεί να χαθεί.';
$string['addon.mod_chat.errorwhileconnecting'] = 'Σφάλμα κατά τη σύνδεση στην γραπτή συνομιλία.';
$string['addon.mod_chat.errorwhilegettingchatdata'] = 'Σφάλμα κατά την ανάκτηση των δεδομένων της γραπτής συνομιλίας.';
$string['addon.mod_chat.errorwhilegettingchatusers'] = 'Σφάλμα κατά την ανάκτηση των χρηστών της γραπτής συνομιλίας.';
$string['addon.mod_chat.errorwhileretrievingmessages'] = 'Σφάλμα κατά την ανάκτηση των μηνυμάτων από τον εξυπηρετητή.';
$string['addon.mod_chat.errorwhilesendingmessage'] = 'Σφάλμα κατά την αποστολή του μηνύματος.';
$string['addon.mod_chat.mustbeonlinetosendmessages'] = 'Πρέπει να είστε συνδεδεμένοι για να στείλετε μηνύματα.';
$string['addon.mod_chat.nosessionsfound'] = 'Δεν βρέθηκε καμία σύνοδος';
$string['addon.mod_chat.showincompletesessions'] = 'Εμφάνιση μη ολοκληρωμένων συνόδων';
$string['addon.mod_choice.errorgetchoice'] = 'Σφάλμα κατά τη λήψη των επιλεγμένων δεδομένων.';
$string['addon.mod_choice.responsesresultgraphdescription'] = '{{number}}% των χρηστών επέλεξε την επιλογή: {{text}}.';
$string['addon.mod_choice.resultsnotsynced'] = 'Η τελευταία απόκρισή σας χρειάζεται συγχρονισμό πριν συμπεριληφθεί στα αποτελέσματα.';
$string['addon.mod_data.edittagsnotsupported'] = 'Λυπούμαστε! Η επεξεργασία ετικετών δεν υποστηρίζεται από την εφαρμογή κινητού.';
$string['addon.mod_data.errorapproving'] = 'Σφάλμα έγκρισης ή απόρριψης καταχώρησης.';
$string['addon.mod_data.errordeleting'] = 'Σφάλμα διαγραφής καταχώρησης.';
$string['addon.mod_data.gettinglocation'] = 'Λήψη τοποθεσίας';
$string['addon.mod_data.locationnotenabled'] = 'Η τοποθεσία δεν είναι ενεργοποιημένη';
$string['addon.mod_data.locationpermissiondenied'] = 'Η άδεια για πρόσβαση στην τοποθεσία σας απορρίφθηκε.';
$string['addon.mod_data.mylocation'] = 'Η τοποθεσία μου';
$string['addon.mod_data.searchbytagsnotsupported'] = 'Λυπούμαστε! Η αναζήτηση κατά ετικέτες δεν υποστηρίζεται από την εφαρμογή κινητού.';
$string['addon.mod_feedback.captchaofflinewarning'] = 'Η ανατροφοδότηση με χρήση captcha δεν μπορεί να ολοκληρωθεί εκτός σύνδεσης, ή αν δεν έχει ρυθμιστεί, ή αν ο εξυπηρετητής δεν λειτουργεί.';
$string['addon.mod_feedback.completedfeedbackscountdescription'] = 'Υπάρχουν {{count}} υποβληθείσες απαντήσεις.';
$string['addon.mod_feedback.feedback_submitted_offline'] = 'Αυτή η ανατροφοδότηση έχει αποθηκευτεί για να υποβληθεί αργότερα.';
$string['addon.mod_feedback.questionscountdescription'] = 'Υπάρχουν {{count}} ερωτήσεις.';
$string['addon.mod_folder.emptyfilelist'] = 'Δεν υπάρχουν αρχεία.';
$string['addon.mod_forum.errorgetforum'] = 'Σφάλμα κατά τη λήψη των δεδομένων του forum.';
$string['addon.mod_forum.errorgetgroups'] = 'Σφάλμα κατά τη λήψη των ρυθμίσεων της ομάδας.';
$string['addon.mod_forum.errorposttoallgroups'] = 'Αδυναμία δημιουργίας νέας συζήτησης σε όλες τις ομάδες.';
$string['addon.mod_forum.forumnodiscussionsyet'] = 'Δεν υπάρχουν ακόμα θέματα συζήτησης σε αυτό το forum.';
$string['addon.mod_forum.group'] = 'Ομάδα';
$string['addon.mod_forum.numdiscussions'] = '{{numdiscussions}} συζητήσεις';
$string['addon.mod_forum.numreplies'] = '{{numreplies}} απαντήσεις';
$string['addon.mod_forum.refreshposts'] = 'Ανανεώστε τα μηνύματα της συζήτησης';
$string['addon.mod_glossary.browsemode'] = 'Περιήγηση στις καταχωρήσεις';
$string['addon.mod_glossary.byalphabet'] = 'Αλφαβητικά';
$string['addon.mod_glossary.byauthor'] = 'Ομαδοποίηση ανά συγγραφέα';
$string['addon.mod_glossary.bycategory'] = 'Ομαδοποίηση ανά κατηγορία';
$string['addon.mod_glossary.bynewestfirst'] = 'Νεότερα πρώτα';
$string['addon.mod_glossary.byrecentlyupdated'] = 'Ανανεώθηκαν πρόσφατα';
$string['addon.mod_glossary.bysearch'] = 'Αναζήτηση';
$string['addon.mod_glossary.cannoteditentry'] = 'Δεν είναι δυνατή η επεξεργασία της καταχώρισης';
$string['addon.mod_glossary.entriestobesynced'] = 'Entries που πρέπει να συγχρονιστούν';
$string['addon.mod_glossary.entrypendingapproval'] = 'Εκκρεμεί η έγκριση για αυτή την καταχώρηση.';
$string['addon.mod_glossary.errorloadingentries'] = 'Παρουσιάστηκε σφάλμα κατά τη φόρτωση των καταχωρήσεων.';
$string['addon.mod_glossary.errorloadingentry'] = 'Παρουσιάστηκε σφάλμα κατά τη φόρτωση της καταχώρησης.';
$string['addon.mod_glossary.errorloadingglossary'] = 'Παρουσιάστηκε σφάλμα κατά τη φόρτωση του γλωσσαρίου.';
$string['addon.mod_glossary.noentriesfound'] = 'Δεν βρέθηκαν καταχωρήσεις.';
$string['addon.mod_glossary.searchquery'] = 'Αναζήτηση ερωτήματος';
$string['addon.mod_h5pactivity.downloadh5pfile'] = 'Λήψη αρχείου H5P';
$string['addon.mod_h5pactivity.errorgetactivity'] = 'Σφάλμα κατά τη λήψη δεδομένων δραστηριότητας H5P.';
$string['addon.mod_h5pactivity.filestatenotdownloaded'] = 'Δεν έγινε λήψη του πακέτου H5P. Πρέπει να το κατεβάσετε για να μπορείτε να το χρησιμοποιήσετε.';
$string['addon.mod_h5pactivity.filestateoutdated'] = 'Το πακέτο H5P έχει τροποποιηθεί από την τελευταία λήψη. Πρέπει να το κατεβάσετε ξανά για να μπορείτε να το χρησιμοποιήσετε.';
$string['addon.mod_h5pactivity.offlinedisabledwarning'] = 'Πρέπει να είστε συνδεδεμένοι για να δείτε το πακέτο H5P.';
$string['addon.mod_h5pactivity.viewattempt'] = 'Προβολή προσπάθειας {{$a}}';
$string['addon.mod_imscp.showmoduledescription'] = 'Εμφάνιση περιγραφής';
$string['addon.mod_lesson.errorprefetchrandombranch'] = 'Αυτή η διδασκαλία περιέχει μια μεταπήδηση σε μια σελίδα τυχαίου περιεχομένου. Δεν μπορεί να την προσπαθήσει κανείς στην εφαρμογή κινητού, μέχρι να ξεκινήσει σε έναν περιηγητή ιστού.';
$string['addon.mod_lesson.errorreviewretakenotlast'] = 'Αυτή η προσπάθεια δεν μπορεί πλέον να αναθεωρηθεί επειδή μια άλλη προσπάθεια έχει ήδη ολοκληρωθεί.';
$string['addon.mod_lesson.finishretakeoffline'] = 'Αυτή η προσπάθεια έχει ολοκληρωθεί εκτός σύνδεσης.';
$string['addon.mod_lesson.retakefinishedinsync'] = 'Μια προσπάθεια εκτός σύνδεσης συγχρονίστηκε. Θέλετε να την αναθεωρήσετε;';
$string['addon.mod_lesson.retakelabelfull'] = '{{retake}}: {{grade}} {{timestart}} ({{duration}})';
$string['addon.mod_lesson.retakelabelshort'] = '{{retake}}: {{grade}} {{timestart}}';
$string['addon.mod_lesson.warningretakefinished'] = 'Η προσπάθεια ολοκληρώθηκε στον ιστότοπο.';
$string['addon.mod_lti.errorgetlti'] = 'Σφάλμα κατά τη λήψη των δεδομένων του module.';
$string['addon.mod_lti.errorinvalidlaunchurl'] = 'Η αρχική διεύθυνση δεν είναι έγκυρη.';
$string['addon.mod_lti.launchactivity'] = 'Ξεκινήστε την δραστηριότητα';
$string['addon.mod_page.errorwhileloadingthepage'] = 'Σφάλμα κατά τη φόρτωση του περιεχομένου της σελίδας.';
$string['addon.mod_quiz.canattemptbutnotsubmit'] = 'Μπορείτε να προσπαθήσετε αυτό το κουίζ στην εφαρμογή κινητού, αλλά θα πρέπει να υποβάλετε την προσπάθεια στον περιηγητή για τους εξής λόγους:';
$string['addon.mod_quiz.cannotsubmitquizdueto'] = 'Αυτή η προσπάθεια επίλυσης του κουίζ δεν μπορεί να υποβληθεί για τους εξής λόγους:';
$string['addon.mod_quiz.confirmcontinueoffline'] = 'Αυτή η προσπάθεια δεν έχει συγχρονιστεί από {{$a}}. Αν έχετε συνεχίσει την προσπάθεια αυτή σε μια άλλη συσκευή από τότε, μπορεί να χάσετε δεδομένα.';
$string['addon.mod_quiz.confirmleavequizonerror'] = 'Παρουσιάστηκε σφάλμα κατά την αποθήκευση των απαντήσεων. Είστε σίγουροι ότι θέλετε να εξέλθετε από το κουίζ;';
$string['addon.mod_quiz.errorbehaviournotsupported'] = 'Δεν μπορείτε να πραγματοποιήσετε αυτό το κουίζ στην εφαρμογή κινητού, διότι η συμπεριφορά ερωτήσεων δεν υποστηρίζεται από την εφαρμογή:';
$string['addon.mod_quiz.errordownloading'] = 'Σφάλμα κατά τη λήψη των απαιτούμενων δεδομένων.';
$string['addon.mod_quiz.errorgetattempt'] = 'Σφάλμα κατά τη λήψη δεδομένων προσπάθειας.';
$string['addon.mod_quiz.errorgetquestions'] = 'Σφάλμα κατά τη λήψη των ερωτήσεων.';
$string['addon.mod_quiz.errorgetquiz'] = 'Σφάλμα κατά τη λήψη δεδομένων κουίζ.';
$string['addon.mod_quiz.errorparsequestions'] = 'Παρουσιάστηκε σφάλμα κατά την ανάγνωση των ερωτήσεων. Παρακαλούμε να κάνετε αυτό το κουίζ σε ένα web browser.';
$string['addon.mod_quiz.errorquestionsnotsupported'] = 'Αυτό το κουίζ δεν μπορεί να επιχειρηθεί στην εφαρμογή κινητού, γιατί περιέχει μόνο ερωτήσεις που δεν υποστηρίζονται από την εφαρμογή:';
$string['addon.mod_quiz.errorrulesnotsupported'] = 'Αυτό το κουίζ δεν μπορεί να επιχειρηθεί στην εφαρμογή κινητού επειδή έχει κανόνες πρόσβασης που δεν υποστηρίζονται από την εφαρμογή:';
$string['addon.mod_quiz.errorsaveattempt'] = 'Παρουσιάστηκε σφάλμα κατά την προσπάθεια αποθήκευσης των δεδομένων.';
$string['addon.mod_quiz.finishnotsynced'] = 'Ολοκληρωμένο αλλά όχι συγχρονισμένο';
$string['addon.mod_quiz.opentoc'] = 'Ανοίξτε το popover πλοήγησης.';
$string['addon.mod_quiz.warningattemptfinished'] = 'Η προσπάθεια εκτός σύνδεσης απορρίφθηκε διότι είτε δεν βρέθηκε, είτε έχει ολοκληρωθεί στον ιστότοπο.';
$string['addon.mod_quiz.warningdatadiscarded'] = 'Μερικές απαντήσεις εκτός σύνδεσης απορρίφθηκαν διότι οι ερωτήσεις είχαν τροποποιηθεί εντός σύνδεσης.';
$string['addon.mod_quiz.warningdatadiscardedfromfinished'] = 'Η προσπάθεια δεν ολοκληρώθηκε διότι κάποιες απαντήσεις απορρίφθηκαν. Παρακαλούμε ελέγξτε τις απαντήσεις και υποβάλετε ξανά την προσπάθεια.';
$string['addon.mod_quiz.warningquestionsnotsupported'] = 'Αυτό το κουίζ περιέχει ερωτήσεις που δεν υποστηρίζονται από την εφαρμογή κινητού:';
$string['addon.mod_resource.errorwhileloadingthecontent'] = 'Σφάλμα κατά τη φόρτωση του περιεχομένου.';
$string['addon.mod_resource.openthefile'] = 'Άνοιγμα';
$string['addon.mod_scorm.cannotcalculategrade'] = 'Ο βαθμός δεν μπόρεσε να υπολογιστεί.';
$string['addon.mod_scorm.dataattemptshown'] = 'Αυτά τα δεδομένα ανήκουν στην προσπάθεια με αριθμό {{number}}.';
$string['addon.mod_scorm.errorcreateofflineattempt'] = 'Παρουσιάστηκε σφάλμα κατά τη εκκίνηση μιας νέας προσπάθειας εκτός σύνδεσης. Παρακαλούμε προσπαθήστε ξανά.';
$string['addon.mod_scorm.errordownloadscorm'] = 'Σφάλμα κατά τη λήψη SCORM: «{{name}}».';
$string['addon.mod_scorm.errorgetscorm'] = 'Σφάλμα κατά τη λήψη δεδομένων SCORM.';
$string['addon.mod_scorm.errorinvalidversion'] = 'Λυπούμαστε, η εφαρμογή υποστηρίζει μόνο SCORM 1.2.';
$string['addon.mod_scorm.errornotdownloadable'] = 'Η λήψη των πακέτων SCORM είναι απενεργοποιημένη στον δικτυακό τόπο του Moodle. Παρακαλούμε επικοινωνήστε με το διαχειριστή του Moodle ιστοτόπου σας.';
$string['addon.mod_scorm.errornovalidsco'] = 'Αυτό το SCORM δεν έχει ορατό SCO για να φορτωθεί.';
$string['addon.mod_scorm.errorpackagefile'] = 'Λυπούμαστε, η εφαρμογή υποστηρίζει μόνο πακέτα ZIP.';
$string['addon.mod_scorm.errorsyncscorm'] = 'Παρουσιάστηκε σφάλμα κατά το συγχρονισμό. Παρακαλούμε προσπαθήστε ξανά.';
$string['addon.mod_scorm.offlineattemptnote'] = 'Αυτή η προσπάθεια έχει στοιχεία που δεν έχουν συγχρονιστεί.';
$string['addon.mod_scorm.offlineattemptovermax'] = 'Αυτή η προσπάθεια δεν μπορεί να σταλεί, γιατί έχετε ξεπεράσει το μέγιστο αριθμό προσπαθειών.';
$string['addon.mod_scorm.scormstatusnotdownloaded'] = 'Αυτό το SCORM δεν έχει κατέβει. Θα κατέβει αυτόματα όταν το ανοίξετε.';
$string['addon.mod_scorm.scormstatusoutdated'] = 'Αυτό το SCORM έχει τροποποιηθεί από την τελευταία λήψη. Θα κατέβει αυτόματα όταν το ανοίξετε.';
$string['addon.mod_scorm.warningofflinedatadeleted'] = 'Ορισμένα εκτός σύνδεσης δεδομένα της προσπάθειας {{number}} διαγράφηκαν επειδή δεν ήταν δυνατή η δημιουργία νέας προσπάθειας.';
$string['addon.mod_scorm.warningsynconlineincomplete'] = 'Κάποιες προσπάθειες δεν μπόρεσαν να συγχρονιστούν με τον ιστότοπο διότι η τελευταία εντός σύνδεσης προσπάθεια δεν έχει ολοκληρωθεί. Παρακαλούμε τελειώστε την εντός σύνδεσης προσπάθεια πρώτα.';
$string['addon.mod_survey.cannotsubmitsurvey'] = 'Λυπούμαστε, υπήρξε πρόβλημα υποβολής της έρευνας. Παρακαλούμε δοκιμάστε ξανά.';
$string['addon.mod_survey.errorgetsurvey'] = 'Σφάλμα κατά τη λήψη των δεδομένων της έρευνας.';
$string['addon.mod_survey.results'] = 'Αποτελέσματα';
$string['addon.mod_url.accessurl'] = 'Πρόσβαση στη διεύθυνση URL';
$string['addon.mod_url.pointingtourl'] = 'Η διεύθυνση URL στην οποία δείχενει ο πόρος.';
$string['addon.mod_wiki.errorloadingpage'] = 'Παρουσιάστηκε σφάλμα κατά τη φόρτωση της σελίδας.';
$string['addon.mod_wiki.errornowikiavailable'] = 'Αυτό το wiki δεν έχει ακόμα περιεχόμενο.';
$string['addon.mod_wiki.gowikihome'] = 'Μετάβαση στην αρχική σελίδα του wiki';
$string['addon.mod_wiki.subwiki'] = 'Υπο-wiki';
$string['addon.mod_wiki.titleshouldnotbeempty'] = 'Ο τίτλος δεν πρέπει να είναι κενός';
$string['addon.mod_wiki.viewpage'] = 'Δείτε τη σελίδα';
$string['addon.mod_wiki.wikipage'] = 'Σελίδα Wiki';
$string['addon.mod_workshop.assessmentstrategynotsupported'] = 'Η στρατηγική αξιολόγησης {{$a}} δεν υποστηρίζεται';
$string['addon.mod_workshop.submissionrequiredtitle'] = 'Πρέπει να δώσετε έναν τίτλο.';
$string['addon.mod_workshop.warningassessmentmodified'] = 'Η υποβολή τροποποιήθηκε στον ιστότοπο.';
$string['addon.mod_workshop.warningsubmissionmodified'] = 'Η αξιολόγηση τροποποιήθηκε στον ιστότοπο.';
$string['addon.notes.warningnotenotsent'] = 'Αδυναμία προσθήκης σημειώσεων στο μάθημα {{course}}. {{error}}';
$string['addon.notifications.errorgetnotifications'] = 'Σφάλμα κατά τη λήψη ειδοποιήσεων.';
$string['addon.notifications.notifications'] = 'Ειδοποιήσεις';
$string['addon.notifications.playsound'] = 'Αναπαραγωγή ήχου';
$string['addon.notifications.therearentnotificationsyet'] = 'Δεν υπάρχουν ειδοποιήσεις.';
$string['addon.privatefiles.couldnotloadfiles'] = 'Αδυναμία φόρτωσης της λίστας αρχείων.';
$string['addon.privatefiles.emptyfilelist'] = 'Δεν υπάρχουν αρχεία προς εμφάνιση.';
$string['addon.privatefiles.erroruploadnotworking'] = 'Δυστυχώς, προς το παρόν δεν είναι δυνατή η αποστολή/ανέβασμα αρχείων στον ιστότοπό σας.';
$string['addon.storagemanager.deletecourses'] = 'Ξεφορτώστε όλα τα δεδομένα μαθημάτων';
$string['addon.storagemanager.deletedatafrom'] = 'Ξεφόρτωση δεδομένων από {{name}}';
$string['appstoredescription'] = 'ΣΗΜΕΙΩΣΗ: Η επίσημη εφαρμογή κινητού Moodle, λειτουργεί μόνο σε συνδυασμό με Moodle ιστοτόπους που έχουν ρυθμιστεί να το επιτρέπουν. Παρακαλούμε επικοινωνήστε με τον διαχειριστή του Moodle ιστοτόπου σας εάν έχετε κάποιο πρόβλημα στη σύνδεσή με την εφαρμογή.

Εάν ο Moodle ιστότοπός σας έχει ρυθμιστεί σωστά μπορείτε να χρησιμοποιήσετε την εφαρμογή για να:
- περιηγηθείτε στο περιεχόμενο των μαθημάτων σας, ακόμα και όταν είστε εκτός σύνδεσης
- λαμβάνετε άμεσα ειδοποιήσεις μηνυμάτων και άλλες εκδηλώσεις
- βρείτε και να επικοινωνήσετε άμεσα με άλλους εκπαιδευόμενους
- ανεβάσετε εικόνες, ήχο, βίντεο και άλλα αρχεία από το κινητό σας
- δείτε τους βαθμούς σας
- Και πολλά άλλα!

Επισκεφτείτε τη σελίδα http://docs.moodle.org/en/Mobile_app για περισσότερες πληροφορίες.

Θα εκτιμούσαμε κάθε καλή κριτική για τη λειτουργικότητα της εφαρμογής μέχρι τώρα, και τις συμβουλές σας σε ό,τι άλλο επιθυμείτε να προσφέρει η εφαρμογή.

Η εφαρμογή απαιτεί δικαιώματα για τα παρακάτω:
Εγγραφή ήχου - Για την εγγραφή ηχητικού αρχείου προκειμένου να ανέβει στο Moodle.
Πρόσβαση στα δεδομένα της SD κάρτας του κινητού - Τα περιεχόμενα αποθηκεύονται στην SD κάρτα προκειμένου να μπορείτε να τα δείτε εκτός σύνδεσης.
Πρόσβαση στο δίκτυο - Για να μπορείτε να συνδεθείτε στον Moodle ιστότοπό σας και να γίνεται έλεγχος για επιτυχή σύνδεση.
Εκτέλεση κατά την εκκίνηση - Για την λήψη ενημερώσεων ακόμα και αν η εφαρμογή τρέχει στο παρασκήνιο.
Παρεμπόδιση της μετάβασης του τηλεφώνου σε κατάσταση αδράνειας - Για να δέχεστε ενημερώσεις οποιαδήποτε στιγμή.';
$string['core.browser'] = 'Περιηγητής';
$string['core.cannotconnect'] = 'Αδυναμία σύνδεσης';
$string['core.cannotdownloadfiles'] = 'Το κατέβασμα αρχείων είναι απενεργοποιημένο. Παρακαλούμε, επικοινωνήστε με τον διαχειριστή του ιστοτόπου σας.';
$string['core.cannotopeninapp'] = 'Αυτό το αρχείο ενδέχεται να μην λειτουργεί όπως αναμένεται σε αυτήν τη συσκευή. Θέλετε να το ανοίξετε ούτως ή άλλως;';
$string['core.cannotopeninappdownload'] = 'Αυτό το αρχείο ενδέχεται να μην λειτουργεί όπως αναμένεται σε αυτήν τη συσκευή. Θέλετε να κάνετε λήψη του ούτως ή άλλως;';
$string['core.captureaudio'] = 'Εγγραφή ήχου';
$string['core.capturedimage'] = 'Ληφθείσα εικόνα.';
$string['core.captureimage'] = 'Λήψη εικόνας';
$string['core.capturevideo'] = 'Εγγραφή βίντεο';
$string['core.clearsearch'] = 'Καθαρισμός αναζήτησης';
$string['core.clearstoreddata'] = 'Εκκαθάριση αποθήκευσης {{$a}}';
$string['core.clicktoseefull'] = 'Κάντε κλικ για να δείτε το πλήρες περιεχόμενο.';
$string['core.comments.commentsnotworking'] = 'Τα σχόλια δεν μπορούν να ανακτηθούν';
$string['core.comments.warningcommentsnotsent'] = 'Αδυναμία συγχρονισμού σχολίων. {{error}}';
$string['core.confirmcanceledit'] = 'Είστε σίγουροι ότι θέλετε να αποχωρήσετε από αυτήν τη σελίδα; Όλες οι αλλαγές θα χαθούν.';
$string['core.confirmleaveunknownchanges'] = 'Είστε βέβαιοι ότι θέλετε να αποχωρήσετε από αυτήν τη σελίδα; Εάν έχετε μη αποθηκευμένες αλλαγές, θα χαθούν.';
$string['core.confirmloss'] = 'Σίγουρα; Όλες οι αλλαγές θα χαθούν.';
$string['core.confirmopeninbrowser'] = 'Θέλετε να το ανοίξετε στο πρόγραμμα περιήγησης;';
$string['core.contenteditingsynced'] = 'Το περιεχόμενο που επεξεργάζεστε έχει συγχρονιστεί.';
$string['core.contentlinks.chooseaccount'] = 'Επιλέξτε λογαριασμό';
$string['core.contentlinks.chooseaccounttoopenlink'] = 'Επιλέξτε λογαριασμό για να ανοίξετε το σύνδεσμο.';
$string['core.contentlinks.confirmurlothersite'] = 'Αυτός ο σύνδεσμος προέρχεται από άλλον ιστότοπο. Θέλετε να τον ανοίξετε;';
$string['core.contentlinks.errornoactions'] = 'Αυτός ο σύνδεσμος δεν μπορεί να ανοίξει.';
$string['core.contentlinks.errornosites'] = 'Δεν βρέθηκε κάποιος ιστότοπος για αυτό το σύνδεσμο.';
$string['core.contentlinks.errorredirectothersite'] = 'Η διεύθυνση URL ανακατεύθυνσης δεν μπορεί να δείχνει σε έναν διαφορετικό ιστότοπο.';
$string['core.copiedtoclipboard'] = 'Το κείμενο αντιγράφηκε στο πρόχειρο';
$string['core.copytoclipboard'] = 'Αντιγραφή στο πρόχειρο';
$string['core.course.activitydisabled'] = 'Ο οργανισμός σας απενεργοποίησε αυτήν την δραστηριότητα στην εφαρμογή κινητού.';
$string['core.course.activitynotyetviewableremoteaddon'] = 'Ο οργανισμός σας εγκατέστησε ένα πρόσθετο που δεν υποστηρίζεται ακόμη.';
$string['core.course.allsections'] = 'Όλες οι ενότητες';
$string['core.course.aria:sectionprogress'] = 'Πρόοδος ενότητας:';
$string['core.course.availablespace'] = 'Αυτή τη στιγμή έχετε περίπου {{available}} διαθέσιμο χώρο.';
$string['core.course.cannotdeletewhiledownloading'] = 'Δεν είναι δυνατή η διαγραφή αρχείων κατά τη λήψη της δραστηριότητας. Παρακαλούμε, περιμένετε να ολοκληρωθεί η λήψη.';
$string['core.course.confirmdownload'] = 'Πρόκειται να κατεβάσετε {{size}} σε διαθέσιμο χώρο {{availableSpace}}. Σίγουρα θέλετε να συνεχίσετε;';
$string['core.course.confirmdownloadunknownsize'] = 'Αδυναμία υπολογισμού του μεγέθους των αρχείων προς λήψη.{{availableSpace}} Σίγουρα θέλετε να συνεχίσετε;';
$string['core.course.confirmdownloadzerosize'] = 'Πρόκειται να ξεκινήσετε λήψη σε διαθέσιμο χώρο {{availableSpace}} Σίγουρα συνέχεια;';
$string['core.course.confirmlimiteddownload'] = 'Αυτή τη στιγμή δεν υπάρχει σύνδεση με Wi-Fi.';
$string['core.course.confirmpartialdownloadsize'] = 'Πρόκειται να κατεβάσετε <strong>τουλάχιστον</strong> {{size}} σε διαθέσιμο χώρο {{availableSpace}}. Είστε σίγουροι ότι θέλετε να συνεχίσετε;';
$string['core.course.couldnotloadsectioncontent'] = 'Δεν ήταν δυνατή η φόρτωση του περιεχομένου αυτής της ενότητας, δοκιμάστε ξανά αργότερα.';
$string['core.course.couldnotloadsections'] = 'Δεν ήταν δυνατή η φόρτωση αυτής της ενότητας, δοκιμάστε ξανά αργότερα.';
$string['core.course.downloadcoursesprogressdescription'] = 'Λήψη μαθημάτων: πραγματοποιήθηκε λήψη {{count}} από {{total}}.';
$string['core.course.downloadsectionprogressdescription'] = 'Λήψη ενοτήτων: πραγματοποιήθηκε λήψη {{count}} από {{total}}.';
$string['core.course.errordownloadingcourse'] = 'Σφάλμα λήψης μαθήματος.';
$string['core.course.errordownloadingsection'] = 'Σφάλμα λήψης ενότητας.';
$string['core.course.errorgetmodule'] = 'Σφάλμα κατά τη λήψη των δεδομένων της δραστηριότητας.';
$string['core.course.insufficientavailablequota'] = 'Η συσκευή σας δεν ήταν δυνατό να εκχωρήσει χώρο για να αποθηκεύσει αυτό το στοιχείο λήψης. Μπορεί να διατηρεί απόθεμα χώρου για ενημερώσεις εφαρμογών και συστήματος. Παρακαλούμε να καθαρίσετε λίγο χώρο αποθήκευσης πρώτα.';
$string['core.course.insufficientavailablespace'] = 'Προσπαθείτε να κάνετε λήψη {{size}}. Αυτό θα αφήσει στη συσκευή σας ανεπαρκή χώρο για να λειτουργήσει κανονικά. Παρακαλούμε να καθαρίσετε λίγο χώρο αποθήκευσης πρώτα.';
$string['core.course.manualcompletionnotsynced'] = 'Η χειροκίνητη ολοκλήρωση δεν συγχρονίστηκε.';
$string['core.course.nocontentavailable'] = 'Δεν υπάρχει περιεχόμενο διαθέσιμο αυτή τη στιγμή.';
$string['core.course.refreshcourse'] = 'Ανανέωση μαθήματος';
$string['core.course.useactivityonbrowser'] = 'Μπορείτε ακόμη να το χρησιμοποιήσετε μέσω του περιηγητή ιστού της συσκευής σας.';
$string['core.course.warningmanualcompletionmodified'] = 'Η χειροκίνητη ολοκλήρωση μιας δραστηριότητας τροποποιήθηκε στον ιστότοπο.';
$string['core.course.warningofflinemanualcompletiondeleted'] = 'Κάποια εκτός σύνδεσης ολοκλήρωση του μαθήματος «{{name}}» έχει διαγραφεί. {{error}}';
$string['core.coursenogroups'] = 'Δεν είστε μέλος καμιάς ομάδας αυτού του μαθήματος.';
$string['core.courses.cannotretrievemorecategories'] = 'Δεν είναι δυνατή η ανάκτηση κατηγοριών μετά από το επίπεδο {{$a}}.';
$string['core.courses.downloadcourses'] = 'Λήψη μαθημάτων';
$string['core.courses.enrolme'] = 'Εγγραφή μου';
$string['core.courses.errorloadcategories'] = 'Παρουσιάστηκε σφάλμα κατά την φόρτωση των κατηγοριών.';
$string['core.courses.errorloadcourses'] = 'Παρουσιάστηκε σφάλμα κατά τη φόρτωση των μαθημάτων.';
$string['core.courses.errorloadplugins'] = 'Τα πρόσθετα που απαιτούνται από αυτό το μάθημα δεν μπόρεσαν να φορτωθούν σωστά. Παρακαλούμε, ξαναφορτώστε την εφαρμογή κινητού για να προσπαθήσετε ξανά.';
$string['core.courses.errorsearching'] = 'Παρουσιάστηκε σφάλμα κατά τη διάρκεια της αναζήτησης.';
$string['core.courses.filtermycourses'] = 'Φιλτράρισμα των μαθημάτων μου';
$string['core.courses.notenrollable'] = 'Δεν μπορείτε να αυτο-εγγραφείτε σε αυτό το μάθημα.';
$string['core.courses.password'] = 'Κλειδί εγγραφής';
$string['core.courses.searchcoursesadvice'] = 'Μπορείτε να χρησιμοποιήσετε το κουμπί Αναζήτηση μαθημάτων για πρόσβαση ως επισκέπτης ή για να αυτο-εγγραφείτε σε μαθήματα που το επιτρέπουν.';
$string['core.courses.totalcoursesearchresults'] = 'Συνολικά μαθήματα: {{$a}}';
$string['core.currentdevice'] = 'Τρέχουσα συσκευή';
$string['core.datastoredoffline'] = 'Τα δεδομένα αποθηκεύονται στη συσκευή, διότι δεν μπορούν να σταλούν. Θα αποσταλούν αυτόματα αργότερα.';
$string['core.deletedoffline'] = 'Διαγράφηκε εκτός σύνδεσης';
$string['core.deleting'] = 'Γίνεται διαγραφή';
$string['core.desktop'] = 'Επιφάνεια εργασίας';
$string['core.dfdaymonthyear'] = 'MM-DD-YYYY';
$string['core.dfdayweekmonth'] = 'ddd, D MMM';
$string['core.dffulldate'] = 'dddd, D MMMM YYYY h[:]mm A';
$string['core.dflastweekdate'] = 'ddd';
$string['core.dfmediumdate'] = 'LLL';
$string['core.dftimedate'] = 'h[:]mm A';
$string['core.discard'] = 'Απόρριψη';
$string['core.dismiss'] = 'Απόρριψη';
$string['core.downloaded'] = 'Η λήψη έγινε';
$string['core.downloading'] = 'Κατέβασμα';
$string['core.editor.hidetoolbar'] = 'Απόκρυψη γραμμής εργαλείων';
$string['core.editor.toggle'] = 'Εναλλαγή επεξεργαστή κειμένου';
$string['core.emptysplit'] = 'Αυτή η σελίδα θα εμφανιστεί κενή, εάν ο αριστερός πίνακας είναι κενός ή φορτώνεται.';
$string['core.errorchangecompletion'] = 'Παρουσιάστηκε σφάλμα κατά την αλλαγή της κατάστασης ολοκλήρωσης. Παρακαλούμε προσπαθήστε ξανά.';
$string['core.errordeletefile'] = 'Σφάλμα κατά τη διαγραφή του αρχείου. Παρακαλούμε προσπαθήστε ξανά.';
$string['core.errordownloading'] = 'Σφάλμα στο κατέβασμα του αρχείου.';
$string['core.errordownloadingsomefiles'] = 'Σφάλμα κατά τη λήψη αρχείων μονάδας. Ορισμένα αρχεία μπορεί να λείπουν.';
$string['core.errorfileexistssamename'] = 'Υπάρχει ήδη ένα αρχείο με αυτό το όνομα.';
$string['core.errorinvalidform'] = 'Η φόρμα περιέχει μη έγκυρα δεδομένα. Παρακαλούμε φροντίστε να συμπληρώσετε όλα τα απαιτούμενα πεδία και ότι τα δεδομένα είναι έγκυρα.';
$string['core.errorinvalidresponse'] = 'Ελήφθη μη έγκυρη απόκριση. Επικοινωνήστε με τον διαχειριστή του ιστοτόπου σας εάν το πρόβλημα παραμένει.';
$string['core.errorloadingcontent'] = 'Σφάλμα κατά τη φόρτωση περιεχομένου.';
$string['core.errorofflinedisabled'] = 'Η περιήγηση εκτός σύνδεσης είναι απενεργοποιημένη στον ιστότοπό σας. Πρέπει να είστε συνδεδεμένος στο Διαδίκτυο για να χρησιμοποιήσετε την εφαρμογή κινητού.';
$string['core.erroropenfiledownloading'] = 'Σφάλμα κατά το άνοιγμα αρχείου: πρέπει να περιμένετε να ολοκληρωθεί η λήψη.';
$string['core.erroropenfilenoapp'] = 'Σφάλμα κατά το άνοιγμα αρχείου: δεν βρέθηκε εφαρμογή για το άνοιγμα αυτού του είδους αρχείων.';
$string['core.erroropenfilenoextension'] = 'Σφάλμα κατά το άνοιγμα αρχείου: το αρχείο δεν έχει επέκταση.';
$string['core.erroropenpopup'] = 'Αυτή η δραστηριότητα προσπαθεί να ανοίξει ένα αναδυόμενο παράθυρο. Αυτό δεν υποστηρίζεται σε αυτή την εφαρμογή.';
$string['core.errorrenamefile'] = 'Σφάλμα κατά τη μετονομασία αρχείου. Παρακαλούμε δοκιμάστε ξανά.';
$string['core.errorsomedatanotdownloaded'] = 'Αν κάνατε λήψη αυτής της δραστηριότητας, παρακαλούμε, σημειώστε ότι κάποια δεδομένα δεν κατεβαίνουν κατά την λήψη για λόγους απόδοσης και σωστής χρήσης δεδομένων.';
$string['core.errorsync'] = 'Παρουσιάστηκε σφάλμα κατά τη διαδικασία του συγχρονισμού. Παρακαλούμε δοκιμάστε ξανά.';
$string['core.errorsyncblocked'] = 'Αυτό το {{$a}} δεν μπορεί να συγχρονιστεί τώρα εξαιτίας μιας συνεχιζόμενης διαδικασίας. Παρακαλούμε δοκιμάστε ξανά αργότερα. Εάν το πρόβλημα παραμένει, δοκιμάστε να επανεκκινήσετε την εφαρμογή.';
$string['core.errorurlschemeinvalidscheme'] = 'Αυτή η διεύθυνση URL προορίζεται να χρησιμοποιηθεί σε άλλη εφαρμογή: {{$a}}.';
$string['core.errorurlschemeinvalidsite'] = 'Αυτή η διεύθυνση URL ιστοτόπου δεν μπορεί να ανοιχτεί σε αυτή την εφαρμογή.';
$string['core.filenameexist'] = 'Το όνομα του αρχείου υπάρχει ήδη: {{$a}}';
$string['core.fileuploader.audio'] = 'Audio';
$string['core.fileuploader.camera'] = 'Κάμερα';
$string['core.fileuploader.confirmuploadfile'] = 'Πρόκειται να ανεβάσετε {{size}}. Είστε σίγουροι ότι θέλετε να συνεχίσετε;';
$string['core.fileuploader.confirmuploadunknownsize'] = 'Δεν κατέστη δυνατός ο υπολογισμός των αρχείων για ανέβασμα. Είστε σίγουροι ότι θέλετε να συνεχίσετε;';
$string['core.fileuploader.errorcapturingaudio'] = 'Σφάλμα σύλληψης ήχου.';
$string['core.fileuploader.errorcapturingimage'] = 'Σφάλμα σύλληψης εικόνας.';
$string['core.fileuploader.errorcapturingvideo'] = 'Σφάλμα σύλληψης βίντεο.';
$string['core.fileuploader.errorgettingimagealbum'] = 'Σφάλμα κατά τη λήψη εικόνας από το άλμπουμ.';
$string['core.fileuploader.errormustbeonlinetoupload'] = 'Πρέπει να είστε συνδεδεμένοι για να ανεβάσετε αρχεία.';
$string['core.fileuploader.errornoapp'] = 'Δεν έχετε εγκατεστημένη εφαρμογή για να εκτελέσετε αυτή την ενέργεια.';
$string['core.fileuploader.errorreadingfile'] = 'Σφάλμα ανάγνωσης αρχείου.';
$string['core.fileuploader.errorwhileuploading'] = 'Παρουσιάστηκε σφάλμα κατά το ανέβασμα του αρχείου.';
$string['core.fileuploader.file'] = 'Αρχείο';
$string['core.fileuploader.fileuploaded'] = 'Το αρχείο ανέβηκε επιτυχώς.';
$string['core.fileuploader.maxbytesfile'] = 'Το αρχείο {{$a.file}} είναι πολύ μεγάλο. Το μέγιστο μέγεθος που μπορείτε να ανεβάσετε είναι {{$a.size}}.';
$string['core.fileuploader.photoalbums'] = 'Άλμπουμ φωτογραφιών';
$string['core.fileuploader.readingfile'] = 'Ανάγνωση αρχείου';
$string['core.fileuploader.readingfileperc'] = 'Ανάγνωση αρχείου: {{$a}}%';
$string['core.fileuploader.selectafile'] = 'Επιλογή αρχείου';
$string['core.fileuploader.uploadafile'] = 'Ανεβάστε ένα αρχείο';
$string['core.fileuploader.uploading'] = 'Ανέβασμα';
$string['core.fileuploader.uploadingperc'] = 'Ανέβασμα: {{$a}}%';
$string['core.fileuploader.video'] = 'Βίντεο';
$string['core.fullnameandsitename'] = '{{fullname}} ({{sitename}})';
$string['core.h5p.errorgetemail'] = 'Σφάλμα κατά τη λήψη της διεύθυνσης ηλε.ταχυδρομείου χρήστη. Παρακαλούμε, ελέγξτε τη σύνδεσή σας και δοκιμάστε ξανά.';
$string['core.h5p.offlinedisabled'] = 'Ο ιστότοπος δεν επιτρέπει τη λήψη πακέτων H5P.';
$string['core.h5p.play'] = 'Αναπαραγωγή H5P';
$string['core.hasdatatosync'] = 'Αυτό το {{$a}} έχει δεδομένα εκτός σύνδεσης τα οποία πρέπει να συγχρονιστούν.';
$string['core.humanreadablesize'] = '{{size}} {{unit}}';
$string['core.iframehelp'] = 'Δεν λειτουργεί αυτό το περιεχόμενο;';
$string['core.image'] = 'Εικόνα';
$string['core.imageviewer'] = 'Εργαλείο προβολής εικόνων';
$string['core.ioscookieshelp'] = 'Το ενσωματωμένο περιεχόμενο ενδέχεται να απαιτεί cookies για τη λειτουργία του. Παρακαλούμε, μεταβείτε στις ρυθμίσεις iOS της εφαρμογής, ενεργοποιήστε την επιλογή «Να επιτρέπεται η παρακολούθηση μεταξύ ιστοτόπων» και δοκιμάστε ξανά.';
$string['core.lastdownloaded'] = 'Τελευταία λήψη';
$string['core.lastsync'] = 'Τελευταίος συγχρονισμός';
$string['core.loadmore'] = 'Φόρτωση περισσότερων';
$string['core.login.authenticating'] = 'Έλεγχος ταυτότητας';
$string['core.login.changepasswordbutton'] = 'Άνοιγμα της σελίδας αλλαγής κωδικού πρόσβασης';
$string['core.login.changepasswordhelp'] = 'Εάν έχετε προβλήματα με την αλλαγή του κωδικού πρόσβασής σας, επικοινωνήστε με το διαχειριστή του ιστοτόπου σας. «Διαχειριστές ιστοτόπου» είναι οι άνθρωποι που διαχειρίζονται το Moodle στο σχολείο/πανεπιστήμιο/εταιρεία ή τον εκπαιδευτικό οργανισμό σας. Αν δεν γνωρίζετε πώς να επικοινωνήσετε μαζί τους, παρακαλούμε επικοινωνήστε με τους διδάσκοντες/εκπαιδευτές σας.';
$string['core.login.changepasswordreconnectinstructions'] = 'Κάντε κλικ στο ακόλουθο πλήκτρο για επανασύνδεση με τον ιστότοπο. (Λάβετε υπόψιν ότι αν δεν αλλάξατε τον κωδικό πρόσβασής σας με επιτυχία, θα επιστρέψετε στην προηγούμενη οθόνη.)';
$string['core.login.confirmdeletesite'] = 'Είστε σίγουροι ότι θέλετε να διαγράψετε τον ιστότοπο {{sitename}};';
$string['core.login.connect'] = 'Σύνδεση!';
$string['core.login.connecttomoodle'] = 'Σύνδεση στο Moodle';
$string['core.login.connecttomoodleapp'] = 'Προσπαθείτε να συνδεθείτε σε έναν κανονικό ιστότοπο Moodle. Παρακαλούμε, για πρόσβαση σε αυτόν τον ιστότοπο, κατεβάστε την επίσημη εφαρμογή κινητού Moodle.';
$string['core.login.connecttoworkplaceapp'] = 'Προσπαθείτε να συνδεθείτε σε έναν ιστότοπο Moodle για Χώρους Εργασίας. Παρακαλούμε, για πρόσβαση σε αυτόν τον ιστότοπο, κατεβάστε την εφαρμογή κινητού Moodle για Χώρους Εργασίας.';
$string['core.login.credentialsdescription'] = 'Δώστε το όνομα χρήστη και τον κωδικό πρόσβασής σας για να συνδεθείτε.';
$string['core.login.emailconfirmsentnoemail'] = '<p>Ένα μήνυμα ηλε.ταχυδρομείου πρέπει να έχει σταλεί στην διεύθυνσή σας.</p><p>Περιέχει εύκολες οδηγίες ολοκλήρωσης της καταχώρησής σας.</p><p>Αν συνεχίσετε να αντιμετωπίζετε κάποια δυσχέρεια, επικοινωνήστε με τον διαχειριστή του ιστοτόπου.</p>';
$string['core.login.emailnotmatch'] = 'Οι διευθύνσεις ηλε.ταχυδρομείου δεν ταιριάζουν';
$string['core.login.erroraccesscontrolalloworigin'] = 'Η κλήση πολλαπλών προελεύσεων (Cross-Origin call) που προσπαθείτε να εκτελέσετε έχει απορριφθεί. Παρακαλούμε ελέγξτε https://docs.moodle.org/dev/Moodle_Mobile_development_using_Chrome_or_Chromium';
$string['core.login.errordeletesite'] = 'Παρουσιάστηκε σφάλμα κατά την διαγραφή του ιστοτόπου. Παρακαλούμε, προσπαθήστε ξανά.';
$string['core.login.errorexampleurl'] = 'Η διεύθυνση URL https://campus.example.edu είναι μόνο ένα παράδειγμα διεύθυνσης URL· δεν είναι πραγματικός ιστότοπος. <strong>Παρακαλούμε, χρησιμοποιήστε τη διεύθυνση URL του ιστοτόπου του σχολείου ή του οργανισμού σας.</strong>';
$string['core.login.errorqrnoscheme'] = 'Αυτή η διεύθυνση δεν είναι έγκυρη διεύθυνση URL σύνδεσης.';
$string['core.login.errorupdatesite'] = 'Παρουσιάστηκε σφάλμα κατά την ενημέρωση του κουπονιού του ιστοτόπου.';
$string['core.login.faqcannotfindmysiteanswer'] = 'Πληκτρολογήσατε σωστά το όνομα; Είναι επίσης πιθανό ο ιστότοπός σας να μην περιλαμβάνεται στον κατάλογο μας δημόσιων ιστοτόπων. Εάν εξακολουθείτε να μην μπορείτε να τον βρείτε, παρακαλούμε εισαγάγετε τη διεύθυνση του ιστοτόπου σας.';
$string['core.login.faqcannotfindmysitequestion'] = 'Δεν μπορώ να βρω τον ιστότοπό μου.';
$string['core.login.faqsetupsiteanswer'] = 'Επισκεφτείτε το σύνδεσμο {{$link}} για να δείτε τις διάφορες επιλογές που έχετε για να δημιουργήσετε τον δικό σας ιστότοπο Moodle.';
$string['core.login.faqsetupsitelinktitle'] = 'Ξεκινήστε.';
$string['core.login.faqsetupsitequestion'] = 'Θέλω να δημιουργήσω τον δικό μου ιστότοπο Moodle.';
$string['core.login.faqtestappanswer'] = 'Για να δοκιμάσετε την εφαρμογή κινητού με έναν δοκιμαστικό ιστότοπο Moodle, πληκτρολογήστε «teacher» (δάσκαλος) ή «student» (μαθητής) στο πεδίο «Ο ιστότοπός σας» και κάντε κλικ στο κουμπί «Σύνδεση με τον ιστότοπό σας».';
$string['core.login.faqtestappquestion'] = 'Θέλω απλώς να δοκιμάσω την εφαρμογή κινητού, τι μπορώ να κάνω;';
$string['core.login.faqwhatisurlanswer'] = '<p>Κάθε οργανισμός έχει τη δική του μοναδική διεύθυνση ή διεύθυνση URL για τον Moodle ιστότοπό του. Για να βρείτε τη διεύθυνση:</p><ol><li>Ανοίξτε έναν περιηγητή ιστού και μεταβείτε στη σελίδα σύνδεσης του Moodle ιστοτόπου σας.</li><li>Στην κορυφή της σελίδας, στη γραμμή διευθύνσεων, θα δείτε τη διεύθυνση URL του Moodle ιστοτόπου σας π.χ. «campus.example.edu».<br>{{$image}}</li><li>Αντιγράψτε τη διεύθυνση (μην αντιγράψετε το /login και ό,τι ακολουθεί), επικολλήστε την στην εφαρμογή Moodle και μετά κάντε κλικ στο «Σύνδεση στον ιστότοπό σας»</li><li>Τώρα μπορείτε να συνδεθείτε στον ιστότοπό σας χρησιμοποιώντας το όνομα χρήστη και τον κωδικό πρόσβασής σας.</li></ol>';
$string['core.login.faqwhatisurlquestion'] = 'Ποια είναι η διεύθυνση του ιστοτόπου μου; Πώς μπορώ να βρω τη διεύθυνση URL του ιστοτόπου μου;';
$string['core.login.faqwhereisqrcode'] = 'Πού μπορώ να βρω τον κωδικό QR;';
$string['core.login.faqwhereisqrcodeanswer'] = '<p>Εάν ο οργανισμός σας τον έχει ενεργοποιήσει, θα βρείτε έναν κωδικό QR στον ιστότοπο στο κάτω μέρος της σελίδας προφίλ χρήστη.</p> {{$image}}';
$string['core.login.findyoursite'] = 'Εύρεση του ιστοτόπου σας';
$string['core.login.invalidaccount'] = 'Ελέγξτε τα στοιχεία σύνδεσης ή ζητήστε από τον διαχειριστή του ιστοτόπου σας να ελέγξει τη διαμόρφωση του ιστοτόπου.';
$string['core.login.invalidmoodleversion'] = '<p>Μη έγκυρη έκδοση ιστοτόπου Moodle. Η εφαρμογή Moodle υποστηρίζει μόνο συστήματα Moodle {{$a}} και νεότερα.</p>
<p>Μπορείτε να επικοινωνήσετε με τους διαχειριστές του ιστοτόπου σας και να τους ζητήσετε να ενημερώσουν το Moodle σύστημά τους.</p>
<p>«Διαχειριστές ιστοτόπου» είναι οι άνθρωποι που διαχειρίζονται το Moodle στο δικό σας σχολείο/πανεπιστήμιο/εταιρεία ή εκπαιδευτικό οργανισμό. Αν δεν ξέρετε πώς να επικοινωνήσετε μαζί τους, παρακαλούμε, επικοινωνήστε με τους εκπαιδευτικούς/εκπαιδευτές σας.</p>';
$string['core.login.invalidsite'] = 'Η διεύθυνση ιστοτόπου δεν είναι έγκυρη.';
$string['core.login.invalidtime'] = 'Μη έγκυρη ώρα';
$string['core.login.invalidvaluemax'] = 'Η μεγαλύτερη τιμή είναι {{$a}}';
$string['core.login.invalidvaluemin'] = 'Η μικρότερη τιμή είναι {{$a}}';
$string['core.login.loginbutton'] = 'Σύνδεση';
$string['core.login.mobileservicesnotenabled'] = 'Οι υπηρεσίες κινητής τηλεφωνίας δεν είναι ενεργοποιημένες στον ιστότοπό σας. Παρακαλούμε, επικοινωνήστε με τον διαχειριστή του ιστοτόπου εάν πιστεύετε ότι η πρόσβαση στο κινητό θα πρέπει να είναι ενεργοποιημένη.';
$string['core.login.notloggedin'] = 'Πρέπει να συνδεθείτε';
$string['core.login.onboardingcreatemanagecourses'] = 'Δημιουργήστε και διαχειριστείτε τα μαθήματά σας';
$string['core.login.onboardingenrolmanagestudents'] = 'Εγγραφή και διαχείριση των μαθητών σας';
$string['core.login.onboardinggetstarted'] = 'Ξεκινήστε με το Moodle';
$string['core.login.onboardingialreadyhaveasite'] = 'Έχω ήδη έναν ιστότοπο Moodle';
$string['core.login.onboardingimalearner'] = 'Είμαι εκπαιδευόμενος';
$string['core.login.onboardingimaneducator'] = 'Είμαι εκπαιδευτής';
$string['core.login.onboardingineedasite'] = 'Χρειάζομαι έναν ιστότοπο Moodle';
$string['core.login.onboardingprovidefeedback'] = 'Δώστε έγκαιρα σχόλια';
$string['core.login.onboardingtoconnect'] = 'Για να συνδεθείτε στην εφαρμογή κινητού Moodle θα χρειαστείτε έναν ιστότοπο Moodle';
$string['core.login.onboardingwelcome'] = 'Καλώς ορίσατε στην εφαρμογή κινητού Moodle!';
$string['core.login.or'] = 'Ή';
$string['core.login.passwordrequired'] = 'Απαιτείται κωδικός πρόσβασης';
$string['core.login.recaptchachallengeimage'] = 'Εικόνα reCAPTCHA';
$string['core.login.recaptchaexpired'] = 'Η επαλήθευση έληξε. Απαντήστε την ερώτηση ασφαλείας ξανά.';
$string['core.login.recaptchaincorrect'] = 'Η απάντηση στην ερώτηση ασφαλείας είναι λανθασμένη.';
$string['core.login.reconnect'] = 'Επανασύνδεση';
$string['core.login.searchby'] = 'Αναζήτηση κατά:';
$string['core.login.selectsite'] = 'Παρακαλούμε, επιλέξτε τον ιστότοπό σας:';
$string['core.login.signupplugindisabled'] = '{{$a}} δεν έχει ενεργοποιηθεί.';
$string['core.login.signuprequiredfieldnotsupported'] = 'Η φόρμα εγγραφής περιέχει ένα απαιτούμενο προσαρμοσμένο πεδίο που δεν υποστηρίζεται στην εφαρμογή. Δημιουργήστε τον λογαριασμό σας χρησιμοποιώντας ένα πρόγραμμα περιήγησης ιστού.';
$string['core.login.siteaddress'] = 'Ο ιστότοπός σας';
$string['core.login.sitebadgedescription'] = 'Υπάρχουν {{count}} μη αναγνωσμένες ειδοποιήσεις.';
$string['core.login.sitehasredirect'] = 'Ο ιστότοπός σας περιέχει τουλάχιστον μία ανακατεύθυνση HTTP. Η εφαρμογή κινητού δεν μπορεί να ακολουθήσει ανακατευθύνσεις, κι αυτό μπορεί να είναι το πρόβλημα που δεν επιτρέπει στην εφαρμογή να συνδεθεί με τον ιστότοπό σας.';
$string['core.login.siteinmaintenance'] = 'Ο ιστότοπός σας βρίσκεται σε λειτουργία συντήρησης';
$string['core.login.sitepolicynotagreederror'] = 'Η πολιτική του ιστοτόπου δεν έγινε δεκτή.';
$string['core.login.siteurl'] = 'URL του ιστοτόπου';
$string['core.login.siteurlrequired'] = 'Το URL του ιστοτόπου είναι απαραίτητο, π.χ. <i>http://www.yourmoodlesite.abc or https://www.yourmoodlesite.efg</i>';
$string['core.login.stillcantconnect'] = 'Ακόμα δεν μπορείτε να συνδεθείτε;';
$string['core.login.usernamerequired'] = 'Το όνομα χρήστη είναι απαραίτητο';
$string['core.login.visitchangepassword'] = 'Θέλετε να επισκεφτείτε τον ιστότοπο για να αλλάξετε τον κωδικό πρόσβασης;';
$string['core.login.webservicesnotenabled'] = 'Ο Η/Υ που φιλοξενεί τον ιστότοπό σας ενδέχεται να μην έχει ενεργοποιήσει τις υπηρεσίες ιστού. Παρακαλούμε, επικοινωνήστε με τον διαχειριστή του Η/Υ για βοήθεια.';
$string['core.login.youcanstillconnectwithcredentials'] = 'Μπορείτε ακόμα να συνδεθείτε στον ιστότοπο εισαγάγοντας το όνομα χρήστη και τον κωδικό πρόσβασής σας.';
$string['core.login.yourenteredsite'] = 'Σύνδεση με τον ιστότοπό σας';
$string['core.lostconnection'] = 'Η σύνδεσή σας είναι άκυρη ή έχει λήξει. Θα πρέπει να ξανασυνδεθείτε στον ιστότοπο.';
$string['core.needhelp'] = 'Χρειάζεστε βοήθεια;';
$string['core.networkerroriframemsg'] = 'Αυτό το περιεχόμενο δεν είναι διαθέσιμο εκτός σύνδεσης. Παρακαλούμε, συνδεθείτε στο Διαδίκτυο και προσπαθήστε ξανά.';
$string['core.networkerrormsg'] = 'Το δίκτυο δεν είναι ενεργοποιημένο ή δεν δουλεύει. Παρακαλούμε, ελέγξτε την σύνδεσή σας και δοκιμάστε ξανά.';
$string['core.nooptionavailable'] = 'Δεν υπάρχει καμιά διαθέσιμη επιλογή';
$string['core.nopasswordchangeforced'] = 'Δεν μπορείτε να προχωρήσετε χωρίς να αλλάξετε τον κωδικό πρόσβασής σας.';
$string['core.nopermissionerror'] = 'Λυπούμαστε, αλλά δεν έχετε αυτή τη στιγμή δικαιώματα για να το κάνετε αυτό.';
$string['core.notapplicable'] = 'δ/υ';
$string['core.notsent'] = 'Δεν εστάλη';
$string['core.nummore'] = '{{$a}} περισσότερα';
$string['core.openfile'] = 'Άνοιγμα αρχείου';
$string['core.openfullimage'] = 'Πατήστε εδώ για να δείτε την εικόνα σε πλήρες μέγεθος';
$string['core.openinbrowser'] = 'Άνοιγμα στον περιηγητή';
$string['core.openmodinbrowser'] = 'Άνοιγμα {{$a}} στον περιηγητή';
$string['core.opensecurityquestion'] = 'Ανοίξτε την ερώτηση ασφαλείας';
$string['core.opensettings'] = 'Ανοίξτε τις ρυθμίσεις';
$string['core.openwith'] = 'Ανοιγμα με...';
$string['core.percentagenumber'] = '{{$a}}%';
$string['core.play'] = 'Παίξτε';
$string['core.pulltorefresh'] = 'Τραβήξτε προς τα κάτω για ανανέωση';
$string['core.qrscanner'] = 'Σαρωτής QR';
$string['core.question.cannotdeterminestatus'] = 'Αδυναμία προσδιορισμού κατάστασης';
$string['core.question.errorattachmentsnotsupportedinsite'] = 'Ο ιστότοπός σας δεν υποστηρίζει την επισύναψη αρχείων σε απαντήσεις ακόμη.';
$string['core.question.errorembeddedfilesnotsupportedinsite'] = 'Ο ιστότοπός σας δεν υποστηρίζει την επεξεργασία ενσωματωμένων αρχείων ακόμη.';
$string['core.question.errorquestionnotsupported'] = 'Αυτός ο τύπος ερωτήματος δεν υποστηρίζεται από την εφαρμογή: {{$a}}.';
$string['core.question.howtodraganddrop'] = 'Πατήστε για να επιλέξετε και στη συνέχεια, πατήστε για να αφήσετε.';
$string['core.question.questionmessage'] = 'Ερώτηση {{$a}}: {{$b}}';
$string['core.redirectingtosite'] = 'Θα μεταφερθείτε στον ιστότοπο.';
$string['core.removefiles'] = 'Διαγραφή αρχείων {{$a}}';
$string['core.requireduserdatamissing'] = 'Αυτός ο χρήστης δεν έχει συμπληρωμένα κάποια απαιτούμενα στοιχεία του προφίλ του. Συμπληρώστε τα δεδομένα στο Moodle σας και προσπαθήστε ξανά.<br>{{$a}}';
$string['core.retry'] = 'Προσπαθήστε ξανά';
$string['core.scanqr'] = 'Σάρωση κωδικού QR';
$string['core.scrollbackward'] = 'Κύλιση προς τα πίσω';
$string['core.scrollforward'] = 'Κύλιση προς τα μπρός';
$string['core.searching'] = 'Αναζήτηση';
$string['core.settings.about'] = 'Σχετικά';
$string['core.settings.appsettings'] = 'Ρυθμίσεις εφαρμογής κινητού';
$string['core.settings.appversion'] = 'Έκδοση εφαρμογής κινητού';
$string['core.settings.cannotsyncloggedout'] = 'Αυτός ο ιστότοπος δεν μπορεί να συγχρονιστεί επειδή έχετε αποσυνδεθεί. Δοκιμάστε ξανά όταν συνδεθείτε ξανά στον ιστότοπο.';
$string['core.settings.cannotsyncoffline'] = 'Δεν είναι δυνατός ο συγχρονισμός εκτός σύνδεσης.';
$string['core.settings.cannotsyncwithoutwifi'] = 'Δεν μπορεί να γίνει συγχρονισμός, επειδή οι τρέχουσες ρυθμίσεις επιτρέπουν μόνο συγχρονισμό όταν είστε συνδεδεμένοι με Wi-Fi. Συνδεθείτε με ένα δίκτυο Wi-Fi.';
$string['core.settings.colorscheme'] = 'Συνδυασμός χρωμάτων';
$string['core.settings.colorscheme-dark'] = 'Σκούρο';
$string['core.settings.colorscheme-light'] = 'Ανοιχτό';
$string['core.settings.colorscheme-system'] = 'Προεπιλογή συστήματος';
$string['core.settings.colorscheme-system-notice'] = 'Η προεπιλεγμένη κατάσταση λειτουργίας του συστήματος εξαρτάται από την υποστήριξη της συσκευής σας.';
$string['core.settings.compilationinfo'] = 'Πληροφορίες συλλογής';
$string['core.settings.copyinfo'] = 'Αντιγραφή πληροφοριών συσκευής στο πρόχειρο';
$string['core.settings.cordovadevicemodel'] = 'Μοντέλο συσκευής Cordova';
$string['core.settings.cordovadeviceosversion'] = 'Cordova έκδοση συσκευής OS';
$string['core.settings.cordovadeviceplatform'] = 'Πλατφόρμα συσκευής Cordova';
$string['core.settings.cordovadeviceuuid'] = 'Cordova Device uuid';
$string['core.settings.cordovaversion'] = 'Έκδοση Cordova';
$string['core.settings.debugdisplaydescription'] = 'Αν ενεργοποιηθεί, τα μηνύματα σφάλματος ((στα αναδυόμενα παραθυράκια)) θα εμφανίζουν περισσότερα δεδομένα για το σφάλμα, αν είναι δυνατόν.';
$string['core.settings.deviceinfo'] = 'Πληροφορίες συσκευές';
$string['core.settings.deviceos'] = 'Λειτουργικό σύστημα συσκευής';
$string['core.settings.displayformat'] = 'Μορφή εμφάνισης';
$string['core.settings.enabledownloadsection'] = 'Ενεργοποίηση της λήψης ενοτήτων';
$string['core.settings.enablerichtexteditor'] = 'Ενεργοποιήστε τον επεξεργαστή εμπλουτισμένου κειμένου';
$string['core.settings.enablerichtexteditordescription'] = 'Εάν ενεργοποιηθεί, ένας επεξεργαστής εμπλουτισμένου κειμένου θα είναι διαθέσιμος όταν εισέρχεστε σε περιεχόμενο.';
$string['core.settings.entriesincache'] = '{{$a}} καταχωρήσεις στην κρυφή μνήμη';
$string['core.settings.estimatedfreespace'] = 'Εκτιμώμενος ελεύθερος χώρος';
$string['core.settings.filesystemroot'] = 'Σύστημα αρχείων root';
$string['core.settings.fontsize'] = 'Μέγεθος κειμένου';
$string['core.settings.forcedsetting'] = 'Αυτή η ρύθμιση έχει επιβληθεί από τις ρυθμίσεις του ιστοτόπου σας.';
$string['core.settings.helpusimprove'] = 'Βοηθήστε μας να βελτιώσουμε αυτήν την εφαρμογή';
$string['core.settings.ioscookies'] = 'Παρακολούθηση μεταξύ ιστοτόπων';
$string['core.settings.ioscookiesdescription'] = 'Το ενσωματωμένο περιεχόμενο από τον ιστότοπο ενδέχεται να απαιτεί cookie μεταξύ ιστότοπων για να λειτουργήσει. Για να το ενεργοποιήσετε, παρακαλούμε μεταβείτε στις ρυθμίσεις iOS της εφαρμογής και ενεργοποιήστε την επιλογή «Να επιτρέπεται η παρακολούθηση μεταξύ ιστότοπων».';
$string['core.settings.localnotifavailable'] = 'Διαθέσιμες τοπικές ειδοποιήσεις';
$string['core.settings.locationhref'] = 'Webview URL';
$string['core.settings.navigatorlanguage'] = 'Γλώσσα πλοήγησης';
$string['core.settings.navigatoruseragent'] = 'Navigator userAgent';
$string['core.settings.networkstatus'] = 'Κατάσταση σύνδεσης στο Internet';
$string['core.settings.opensourcelicenses'] = 'Άδειες χρήσης ανοικτού κώδικα';
$string['core.settings.privacypolicy'] = 'Πολιτική απορρήτου';
$string['core.settings.publisher'] = 'Εκδότης';
$string['core.settings.pushid'] = 'Αναγνωριστικό προωθητικών ειδοποιήσεων';
$string['core.settings.reportinbackground'] = 'Αυτόματη αναφορά σφαλμάτων';
$string['core.settings.screen'] = 'Πληροφορίες οθόνης';
$string['core.settings.showdownloadoptions'] = 'Εμφάνιση επιλογών λήψης';
$string['core.settings.siteinfo'] = 'Πληροφορίες ιστοτόπου';
$string['core.settings.spaceusage'] = 'Χρήση χώρου';
$string['core.settings.synchronization'] = 'Συγχρονισμός';
$string['core.settings.synchronizenow'] = 'Συγχρονίστε τώρα';
$string['core.settings.synchronizenowhelp'] = 'Ο συγχρονισμός ενός ιστοτόπου θα στείλει εκκρεμείς αλλαγές και όλη τη δραστηριότητα εκτός σύνδεσης που είναι αποθηκευμένη στη συσκευή και θα συγχρονίσει κάποια δεδομένα όπως μηνύματα και ειδοποιήσεις.';
$string['core.settings.syncsettings'] = 'Ρυθμίσεις συγχρονισμού';
$string['core.settings.wificonnection'] = 'Σύνδεση WiFi';
$string['core.sharedfiles.chooseaccountstorefile'] = 'Επιλέξτε ένα λογαριασμό για να αποθηκεύσετε το αρχείο.';
$string['core.sharedfiles.chooseactionrepeatedfile'] = 'Υπάρχει ήδη ένα αρχείο με αυτό το όνομα. Θέλετε να αντικαταστήσετε το υπάρχον αρχείο ή να το μετονομάσετε σε «{{$a}}»;';
$string['core.sharedfiles.errorreceivefilenosites'] = 'Δεν υπάρχουν αποθηκευμένες τοποθεσίες. Προσθέστε έναν ιστότοπο προτού μοιραστείτε ένα αρχείο με την εφαρμογή.';
$string['core.sharedfiles.nosharedfiles'] = 'Δεν υπάρχουν αποθηκευμένα αρχεία σε αυτόν τον ιστότοπο.';
$string['core.sharedfiles.nosharedfilestoupload'] = 'Δεν έχετε αρχεία για ανέβασμα εδώ. Αν θέλετε να ανεβάσετε ένα αρχείο από άλλη εφαρμογή, εντοπίστε το αρχείο και κάντε κλικ στο κουμπί «Άνοιγμα σε».';
$string['core.sharedfiles.rename'] = 'Μετονομασία';
$string['core.sharedfiles.replace'] = 'Αντικατάσταση';
$string['core.sharedfiles.sharedfiles'] = 'Κοινόχρηστα αρχεία';
$string['core.sharedfiles.successstorefile'] = 'Το αρχείο αποθηκεύτηκε με επιτυχία. Τώρα μπορείτε να επιλέξετε αυτό το αρχείο για να το ανεβάσετε στα ιδιωτικά αρχεία σας ή να το επισυνάψετε σε ορισμένες δραστηριότητες.';
$string['core.sizetb'] = 'TB';
$string['core.sorry'] = 'Λυπάμαι...';
$string['core.storingfiles'] = 'Αποθηκεύσεις αρχείων';
$string['core.tablet'] = 'Τάμπλετ';
$string['core.tag.errorareanotsupported'] = 'Αυτή η περιοχή ετικέτας δεν υποστηρίζεται από την εφαρμογή κινητού.';
$string['core.tag.tagareabadgedescription'] = 'Υπάρχουν {{count}} αντικείμενα.';
$string['core.tag.warningareasnotsupported'] = 'Μερικές από τις περιοχές ετικέτας δεν εμφανίζονται, διότι δεν υποστηρίζονται από την εφαρμογή κινητού.';
$string['core.thereisdatatosync'] = 'Υπάρχουν εκτός σύνδεσης {{$a}} για συγχρονισμό.';
$string['core.toggledelete'] = 'Εναλλαγή κουμπιών διαγραφής';
$string['core.tryagain'] = 'Προσπαθήστε ξανά.';
$string['core.twoparagraphs'] = '{{p1}}<br><br>{{p2}}';
$string['core.uhoh'] = 'Ωχ όχι!';
$string['core.unexpectederror'] = 'Απρόσμενο σφάλμα. Κλείστε και ανοίξτε ξανά την εφαρμογή για να προσπαθήσετε ξανά';
$string['core.unicodenotsupported'] = 'Ορισμένα εμότζι δεν υποστηρίζονται σε αυτόν τον ιστότοπο. Αυτοί οι χαρακτήρες θα αφαιρεθούν κατά την αποστολή του μηνύματος.';
$string['core.unicodenotsupportedcleanerror'] = 'Κενό κείμενο βρέθηκε κατά τον καθαρισμό χαρακτήρων Unicode.';
$string['core.unknown'] = 'Άγνωστο';
$string['core.unzipping'] = 'Αποσυμπίεση';
$string['core.updaterequired'] = 'Απαιτείται ενημέρωση εφαρμογής κινητού';
$string['core.updaterequireddesc'] = 'Παρακαλούμε, ενημερώστε την εφαρμογή κινητού σας σε έκδοση {{$a}}';
$string['core.user.contact'] = 'Επικοινωνία';
$string['core.user.detailsnotavailable'] = 'Λεπτομέρειες για αυτό τον χρήστη δεν είναι διαθέσιμες.';
$string['core.user.errorloaduser'] = 'Σφάλμα φόρτωσης χρήστη.';
$string['core.user.sendemail'] = 'Ηλε.ταχυδρομείο';
$string['core.user.userwithid'] = 'Χρήστης με αναγνωριστικό {{id}}';
$string['core.viewcode'] = 'Εμφάνιση κώδικα';
$string['core.vieweditor'] = 'Εμφάνιση επεξεργαστή κειμένου';
$string['core.viewembeddedcontent'] = 'Εμφάνιση ενσωματωμένου περιεχομένου';
$string['core.warningofflinedatadeleted'] = 'Τα δεδομένα εκτός σύνδεσης {{component}} «{{name}}» έχουν σβηστεί. {{error}}';
$string['core.whyisthishappening'] = 'Γιατί συμβαίνει αυτό;';
$string['core.wsfunctionnotavailable'] = 'Η λειτουργία διαδικτύου δεν είναι διαθέσιμη.';
$string['core.youreoffline'] = 'Είστε εκτός σύνδεσης';
$string['core.youreonline'] = 'Είστε πάλι εντός σύνδεσης';
$string['pluginname'] = 'Moodle Mobile φράσεις για μετάφραση';
