<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'error', language 'ar', version '5.1'.
 *
 * @package     error
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['TODO'] = 'للقيام بـــ';
$string['activityisscheduledfordeletion'] = 'حذف النشاط قيد التنفيذ...';
$string['agedigitalconsentmapinvalidage'] = '"{$a}" ليست قيمة صحيحة للعمر.';
$string['agedigitalconsentmapinvalidcomma'] = '"{$a}" فيها الفارزة الفاصلة مستعملة لأكثر أو أقل من مرة.';
$string['agedigitalconsentmapinvalidcountry'] = '"{$a}" ليست قيمة صحيحة للبلد.';
$string['agedigitalconsentmapinvaliddefault'] = 'القيمة الافتراضية (*) مفقودة.';
$string['agelocationverificationdisabled'] = 'التحقق من العمر والموقع معطلان';
$string['alreadyloggedin'] = 'أنت حالياً مسجل كـ{$a}، عليك أولاً الخروج من ذاك الحساب قبل محاولة الدخول كمستخدم جديد.';
$string['authnotexisting'] = 'إضافة منح الصلاحية غير موجودة';
$string['backupcontainexternal'] = 'يحتوي الملف الاحتياطي هذا على مضيفات شبكة مودل خارجية لم تتم تهيئتها محلياً';
$string['backuptablefail'] = 'لم يتمكن من إعداد جداول النسخ الاحتياطي بنجاح!';
$string['blockcannotadd'] = 'لا يمكن إضافة الكتلة';
$string['blockcannotconfig'] = 'هذه الكتلة لا تدعم الإعدادات العامة';
$string['blockcannotinistantiate'] = 'مشكلة أثناء إنشاء الكتلة';
$string['blockcannotread'] = 'لم يتمكن من قراءة البيانات للكتلة ذات المعرف: {$a}';
$string['blockdoesnotexist'] = 'هذه الكتلة غير موجودة';
$string['blockdoesnotexistonpage'] = 'هذه الكتلة (المُعرَّف={$a->instanceid}) غير موجودة في هذه الصفحة ({$a->url}).';
$string['blocknameconflict'] = 'تضارب بالتسمية: الكتلة {$a->name} لها نفس اسم كتلة موجودة: {$a->conflict}!';
$string['callbackrejectcomment'] = 'تم رفض هذا التعليق عند الرد عليه.';
$string['cannotaddcoursemodule'] = 'تعذرت إضافة وحدة مقرر جديدة';
$string['cannotaddcoursemoduletosection'] = 'لم يتمكن من إضافة وحدة المساق الجديد لذلك القسم';
$string['cannotaddmodule'] = 'لم تتم إضافة الوحدة {$a} إلى قائمة الوحدات!';
$string['cannotaddnewmodule'] = 'تعذرت إضافة الوحدة الجديدة {$a}';
$string['cannotaddrss'] = 'ليست لديك صلاحية إضافة مغذيات الخدمة الإخبارية';
$string['cannotaddthisblocktype'] = 'لا يمكنك إضافة كتلة {$a} إلى هذه الصفحة.';
$string['cannotassignrole'] = 'لا يمكن تعيين دور في هذا المساق';
$string['cannotassignrolehere'] = 'لا يمكنك تعيين هذا الدور (id = {$a->roleid}) في هذا السياق ({$a->context})';
$string['cannotassignselfasparent'] = 'لايمكن تعيين حسابك كأب';
$string['cannotcallscript'] = 'لا يمكنك استدعاء هذا السكريبت بتلك الطريقة';
$string['cannotcallusgetselecteduser'] = 'لا يمكنك استعداء user_selector::get_selected_user إذا كان التحديد المتعدد مفعّلاً';
$string['cannotcreatebackupdir'] = 'تعذر إنشاء مجلد بيانات الحفظ الاحتياطي. على مشرف الموقع إصلاح صلاحيات الملفات';
$string['cannotcreatecategory'] = 'لم يتم إدراج تصنيف';
$string['cannotcreatedboninstall'] = '<p>لا يمكن إنشاء قاعدة البيانات.</p>
<p>لا وجود لقاعدة البيانات المحددة والمستخدم المُعطى ليس لديه صلاحية إنشاء قاعدة البيانات.</p>
<p>مسؤول الموقع يجب أن يتحقق من إعدادات قاعدة البيانات.</p>';
$string['cannotcreategroup'] = 'خطأ في إنشاء المجموعة';
$string['cannotcreatelangbase'] = 'خطأ: لا يمكن إنشاء مجلد اللغة الأساسية';
$string['cannotcreatelangdir'] = 'لا يمكن إنشاء مجلد اللغة';
$string['cannotcreateorfindstructs'] = 'خطأ في إيجاد أو إنشاء هياكل القسم لهذا المساق';
$string['cannotcreatepopupwin'] = 'عنصر غير مُعرَّف - تعذر إنشاء النافذة المنبثقة';
$string['cannotcreatesitedir'] = 'تعذر إنشاء مجلد الموقع. المشرف على الموقع عليه إصلاح صلاحيات الملف.';
$string['cannotcreatetempdir'] = 'لا يمكن إنشاء المجلد المؤقت';
$string['cannotcreateuploaddir'] = 'لا يمكن إنشاء مجلد الرفع. على مشرف الموقع إصلاح صلاحيات الملفات.';
$string['cannotcustomisefiltersblockuser'] = 'لا يمكنك تخصيص إعدادات المنقحات في سياقات المستخدم أو الكتلة.';
$string['cannotdeletebackupids'] = 'تعذر حذف مُعرَّفات الحفظ الاحتياطي السابق';
$string['cannotdeletecategorycourse'] = 'لا يمكن حذف المساق \'{$a}\'';
$string['cannotdeletecategoryquestions'] = 'لا يمكن حذف السؤال من التصنيف \'{$a}\'';
$string['cannotdeletecourse'] = 'ليس لديك الإذن بحذف هذا المساق';
$string['cannotdeletecustomfield'] = 'حصل خطأ في حذف بيانات الحقل المخصص';
$string['cannotdeletedir'] = 'لا يمكن حذف ({$a})';
$string['cannotdeletefile'] = 'لا يمكن حذف هذا الملف';
$string['cannotdeleterole'] = 'لا يمكن حذفه بسبب {$a}';
$string['cannotdeleterolewithid'] = 'لا يمكن حذف الدور صاحب المعرف {$a}';
$string['cannotdeletethisrole'] = 'لا يمكنك حذف هذا الدور لأنه يُستعمل من قبل النظام، أو لأنه هو الدور الأخير ذي إمكانيات مشرف الموقع.';
$string['cannotdisableformat'] = 'لا يمكنك تعطيل التنسيق الافتراضي.';
$string['cannotdownloadcomponents'] = 'تعذر تنزيل المُكونات';
$string['cannotdownloadlanguageupdatelist'] = 'تعذر تنزيل قائمة تحديثات اللغات من download.moodle.org';
$string['cannotdownloadzipfile'] = 'لم يتم تحميل الملف المضغوط';
$string['cannoteditcomment'] = 'هذا التعليق ليس لك لتعدله!';
$string['cannoteditcommentexpired'] = 'لا يمكنك تحرير هذا. لقد انتهى وقت الصلاحية!';
$string['cannoteditpostorblog'] = 'لا يمكنك إنشاء أو تحرير المدونات';
$string['cannoteditsiteform'] = 'لا يمكنك تعديل المساق للموقع باستخدام هذا النموذج';
$string['cannotedituserpreferences'] = 'لا تستطيع تعديل تفضيلات هذا المستخدم';
$string['cannotedityourprofile'] = 'عذراً، لا يمكنك تحرير ملفك الشخصي';
$string['cannotexecduringupgrade'] = 'لا يمكن التنفيذ خلال ترقية النظام';
$string['cannotfindcategory'] = 'لايمكن ايجاد هذا التصنيف في قاعدة البيانات باستخدام المعرف - {$a}';
$string['cannotfindcomponent'] = 'لم يتم العثور على المكون';
$string['cannotfindcontext'] = 'لم يتم العثور على محتوى';
$string['cannotfindcourse'] = 'لم يتم العثور على المساق';
$string['cannotfinddocs'] = 'لا يمكن إيجاد ملفات مساعدة اللغة "{$a}"';
$string['cannotfindgradeitem'] = 'لم يتم العثور على عنصر التقييم';
$string['cannotfindgroup'] = 'تعذر العثور على المجموعة';
$string['cannotfindhelp'] = 'لم يتم العثور على ملفات مساعدة اللغة "{$a}" ';
$string['cannotfindinfo'] = 'لم يتم العثور على معلومات عن: "{$a}" ';
$string['cannotfindlang'] = 'لم يتم إيجاد حزمة اللغة "{$a}" ';
$string['cannotfindteacher'] = 'تعذر العثور على المعلم';
$string['cannotfinduser'] = 'لم يتم إيجاد المستخدم المسمى "{$a}"';
$string['cannotgeoplugin'] = 'تعذر الاتصال بمخدم geoPlugin عبر https://www.geoplugin.com. لطفاً، تحقق من إعدادات الوكيل أو قم بتنصيب ملف بيانات MaxMind GeoIP City.';
$string['cannotgetblock'] = 'لم يتم استرداد الكتل من قاعدة البيانات';
$string['cannotgetcats'] = 'لا يمكن الحصول على سجل التصنيف';
$string['cannotgetdata'] = 'لم يتم الحصول على البيانات';
$string['cannotgradeuser'] = 'لا يمكن وضع علامة لهذا المستخدم';
$string['cannothaveparentcate'] = 'لا يمكن أن يكون لتصنيف المساق تصنيف أعلى!';
$string['cannotimport'] = 'خطأ في الاستيراد';
$string['cannotimportformat'] = 'عذراً، استيراد هذا التنسيق غير مدعوم بعد!';
$string['cannotimportgrade'] = 'خطأ في استيراد التقديرات';
$string['cannotinsertgrade'] = 'لا يمكن إدراج الدرجة من دون معرف المساق';
$string['cannotinsertrate'] = 'لا يمكن إدراج تقييم جديد ({$a->id} = {$a->rating})';
$string['cannotinsertrecord'] = 'لا يمكن إدراج السجل الجديد ذي المُعرَّف {$a}';
$string['cannotmailconfirm'] = 'خطأ في إرسال بريد التحقق من تغيير كلمة السر';
$string['cannotmanualctrack'] = 'هذا النشاط لا يوفر تتبع الإكمال يدوياً';
$string['cannotmapfield'] = 'اكتشاف اصطدام في الارتباط - يوجد حقلين مختلفين مرتبطين بنفس عنصر الدرجة {$a}';
$string['cannotmigratedatacomments'] = 'تعذر ترحيل تعليقات وحدة البيانات';
$string['cannotmodulename'] = 'تعذر الحصول على اسم الوحدة في بناء التنقل';
$string['cannotmoduletype'] = 'تعذر الحصول على نوع الوحدة في بناء التنقل';
$string['cannotmovecategory'] = 'لايمكن نقل التصنيف';
$string['cannotmovecourses'] = 'لا يمكنك نقل المقررات الدراسية من تصنيف لا تنتمي له المقررات الدراسية أصلاً.';
$string['cannotmoverolewithid'] = 'لا يمكن نقل الدور ذي المُعرَّف {$a}';
$string['cannotopencsv'] = 'لا يمكن فتح ملف CSV';
$string['cannotopenfile'] = 'لا يمكن فتح ملف ({$a})';
$string['cannotopenforwrit'] = 'لا يمكن فتح {$a} للكتابة';
$string['cannotopentemplate'] = 'لا يمكن فتح ملف القالب ({$a})';
$string['cannotopenzip'] = 'لا يمكن فتح الملف المضغوط، ربما لوجود خطأ في امتداده على نظام 64 بت.';
$string['cannotoverridebaserole'] = 'لا يمكن تجاوز إمكانيات الدور الأساسي';
$string['cannotoverriderolehere'] = 'لا يُسمح لك بتجاوز هذا الدور (المُعرَّف = {$a->roleid}) في هذا السياق ({$a->context})';
$string['cannotreadfile'] = 'لا يمكنك قراءة الملف  ({$a})';
$string['cannotreadtmpfile'] = 'خطأ في قراءة الملف المؤقت';
$string['cannotreaduploadfile'] = 'لم بتمكن من قراءة الملف المرفوع';
$string['cannotremovefrommeta'] = 'تعذرت إزالة المساق المحدد من هذا المساق الوصفي!';
$string['cannotreprocessgrades'] = 'لا يمكن إعادة معالجة التقديرات لهذا النشاط {$a}';
$string['cannotresetguestpwd'] = 'لا يمكنك إعادة تعيين كلمة سر الزائر';
$string['cannotresetmail'] = 'خطأ أثناء إعادة تعيين كلمة السر وإرسال بريد إلكتروني لك';
$string['cannotresetthisrole'] = 'لا يمكن إعادة تعيين هذا الدور';
$string['cannotrestore'] = 'حدث خطأ وتعذر إكمال الاستعادة!';
$string['cannotrestoreadminorcreator'] = 'عليك أن تكون المنشئ أو المشرف للاستعادة بمثابة مقرر جديد!';
$string['cannotrestoreadminoredit'] = 'عليك أن تكون المعلم أو المشرف للاستعادة إلى المساق المحدد!';
$string['cannotsaveagreement'] = 'لايمكن تخزين الاتفاق';
$string['cannotsaveblock'] = 'خطأ أثناء حفظ إعدادات الكتلة';
$string['cannotsavecomment'] = 'لم يتم حفظ التعليق';
$string['cannotsavedata'] = 'لا يمكن حفظ البيانات';
$string['cannotsavefile'] = 'لا يمكن حفظ الملف "{$a}"!';
$string['cannotsavemd5file'] = 'تعذر حفظ ملف md5';
$string['cannotsavezipfile'] = 'تعذر حفظ الملف المضغوط';
$string['cannotservefile'] = 'لا يمكن تقديم الملف لوجود مشكلة في تهيئة المخدم.';
$string['cannotsetparentforcatoritem'] = 'لا يمكن جعله برتبة أعلى بالنسبة للتصنيف أو المساق!';
$string['cannotsetpassword'] = 'لم يتمكن من تعيين كلمة سر المستخدم!';
$string['cannotsetprefgrade'] = 'تعذر ضبط الإعداد aggregationview على {$a} لتصنيف الدرجة هذا';
$string['cannotsettheme'] = 'لا يمكن تعيين القالب!';
$string['cannotsetupblock'] = 'تعذرت تهيئة جداول الكتل بنجاح!';
$string['cannotsetupcapformod'] = 'تعذرت تهيئة الإمكانيات لـ {$a}';
$string['cannotsetupcapforplugin'] = 'تعذرت تهيئة الإمكانيات لـ {$a}';
$string['cannotshowhidecoursesincategory'] = 'تعذر إظهار/إخفاء المقررات الدراسية في التصنيف {$a}.';
$string['cannotsignup'] = 'لا يمكنك إنشاء حساب جديد لأنك بالفعل قمت بالدخول الا بحسابك كــ {$a}.';
$string['cannotunassigncap'] = 'لا يمكن إلغاء الصلاحية المهملة {$a->cap} من الدور {$a->role}';
$string['cannotunassignrolefrom'] = 'تعذر إلغاء منح هذا المستخدم للدور ذي المعُرَّف: {$a}';
$string['cannotunzipfile'] = 'تعذر فك الملف المضغوط';
$string['cannotupdatemod'] = 'لا يمكن تحديث {$a}';
$string['cannotupdatepasswordonextauth'] = 'فشل تحديث كلمة المرور على المصادقة الخارجية: {$a}. اطلع على سجلات الخادم لمزيد من التفاصيل.';
$string['cannotupdateprofile'] = 'خطأ في تحديث سجل المستخدم';
$string['cannotupdaterecord'] = 'لايمكن تحديث سجل المعرف  {$a}';
$string['cannotupdaterss'] = 'لا يمكن تحديث RSS';
$string['cannotupdatesubcourse'] = 'لايمكن تحديث جزء المساق';
$string['cannotupdateusermsgpref'] = ' لايمكن تحديث تفضيلات رسالة المستخدم';
$string['cannotupdateuseronexauth'] = 'فشل تحديث بيانات المستخدم في المصادقة الخارجية: {$a}. أنظر سجلات وقوعات المخدم لمزيد من التفاصيل.';
$string['cannotuploadfile'] = 'خطأ عند معالجة تحميل الملف';
$string['cannotuseadmin'] = 'عليك أن تكون مشرفًا لتستعمل هذه الصفحة';
$string['cannotuseadminadminorteacher'] = 'عليك أن تكون معلمًا أو مشرفًا لتستعمل هذه الصفحة';
$string['cannotusepage'] = 'يمكن فقط للمعلمين والمدراء استعمال هذه الصفحة';
$string['cannotusepage2'] = 'عذراً، لا يمكنك استخدام هذه الصفحة';
$string['cannotviewcategory'] = 'ليست لديك صلاحية معاينة هذه القائمة من المقررات الدراسية.';
$string['cannotviewprofile'] = 'لا تستطيع معاينة الملف الشخصي لهذا المستخدم';
$string['cannotviewreport'] = 'لا تستطيع معاينة هذا التقرير';
$string['cannotwritefile'] = 'لايمكن الكتابة في الملف  ({$a})';
$string['categoryerror'] = 'خطأ في التصنيف';
$string['categoryidnumbertaken'] = 'المعرف مستخدم مسبقا لتصنيف آخر';
$string['categorynamerequired'] = 'يجب تعبئة اسم الفئة';
$string['categorytoolong'] = 'اسم الفئة طويل جدا';
$string['commentmisconf'] = 'مُعرَّف التعليق خاطئ التهيئة';
$string['componentisuptodate'] = 'العنصر محدث';
$string['confirmationnotenabled'] = 'لم يتم تمكين تأكيدات المستخدم في هذا الموقع';
$string['confirmsesskeybad'] = 'عذراً، ولكن مفتاح جلسة العمل الخاصة  بك لم يتم تأكيده لتنفيذ هذا الإجراء. هذا الإجراء الأماني يمنع من  تنفيذ أعمال بطريق الخطأ أو انتحال شخصيتك والقيام  بوظائف مهمة تحت اسمك. من فضلك تأكد من أنك تريد حقاً تنفيذ هذه المهمة.';
$string['contenttypenotfound'] = 'إن نوع بنك المحتوى \'{$a}\' غير موجود أو تعذر التعرف عليه.';
$string['contentvisibilitynotfound'] = 'حالة الإظهار ذات القيمة \'{$a}\' غير موجودة أو يتعذر التعرف عليها.';
$string['couldnotassignrole'] = 'خطأ جسيم لكنه غير محدد، وقع عند محاولة منح الدور لك';
$string['couldnotupdatenoexistinguser'] = 'لا يمكن تحديث المستخدم - المستخدم غير موجود';
$string['couldnotverifyagedigitalconsent'] = 'وقع خطأ عند محاولة التحقق من عمر الموافقة الرقمية.<br />لطفاً، اتصل بالمشرف.';
$string['countriesphpempty'] = 'خطأ: الملف countries.php في حزمة اللغة {$a} فارغ أو غير موجود.';
$string['coursedoesnotbelongtocategory'] = 'المساق لا ينتمي إلى هذا التصنيف';
$string['courseformatnotfound'] = 'تنسيق المقرر \'{$a}\' غير موجود أو لا يمكن التعرُّف عليه.';
$string['coursegroupunknown'] = 'المساق الدرسي المتطابق مع المجموعة {$a} لم يحدد';
$string['courseidnotfound'] = 'معرّف المساق غير موجود.';
$string['courseidnumbertaken'] = 'المعرف مستخدم مبقا في مساق آخر';
$string['coursemisconf'] = 'تم إعداد المساق بشكل خاطئ';
$string['courserequestdisabled'] = 'عذراً، ولكن تم تعطيل طلبات المقررات الدراسية من قبل مدير الموقع.';
$string['csvcolumnduplicates'] = 'تم الكشف عن عمود مكرر';
$string['csvemptyfile'] = 'ملف الـCSV هذا؛ فارغ';
$string['csvfewcolumns'] = 'لا توجد أعمدة كافية، يرجى التحقق من إعدادات الفاصلة';
$string['csvfileerror'] = 'هناك خطأ ما في صياغة ملف CSV. لطفاً، تحقق من تطابق عدد عناصر الرأس مع الأعمدة، ومن أن الفاصلة المستعملة وترميز الملف صحيحان. {$a}';
$string['csvinvalidcols'] = '<b>ملف CSV غير صحيح:</b> السطر الأول ينبغي أن يحتوي على "مسميات الحقول" والملف ينبغي أن يكون من نوع <br />"حقول موسعة/مفصولة بفارزة"<br />أو<br /> "حقول موسعة مع ترميز نتائج CAVV /مفصولة بفارزة"';
$string['csvinvalidcolsnum'] = 'خطأ في ملف CSV - كل سطر يجب أن يحوي 49 أو 70 حقلاً';
$string['csvloaderror'] = 'حدث خطأ ما في أثناء تحميل ملف CSV: {$a}';
$string['csvnodata'] = 'ملف CSV خاطئ - ملف CSV يمتلك رأس الجدول ولكنه خالٍ من أي بيانات.';
$string['csvweirdcolumns'] = 'تنسيق ملف CSV غير صالح - عدد الأعمدة ليست ثابتة!';
$string['dbconnectionfailed'] = '<P>خطأ: فشل اتصال قاعدة البيانات </P>
<P>من الممكن أن قاعدة البيانات تجاوزت طاقتها أو لا تعمل بشكل صحيح.</P>
<p>يجب على مشرف الموقع أيضًا التحقق من أن تفاصيل قاعدة البيانات تم تحديدها بشكل صحيح في الملف config.php</P>';
$string['dbdriverproblem'] = '<p>خطأ: تم الكشف عن مشكلة في مشغل قاعدة البيانات</p>
<p>على مدير الموقع التحقق من إعدادات المخدم</p><p>{$a}</p>';
$string['dbsessionbroken'] = 'تم اكتشاف خطأ جسيم في جلسة قاعدة البيانات.<br /><br />لطفاً، أبلغ مشرف المُخدم.';
$string['dbsessionhandlerproblem'] = 'فشل إعداد جلسة قاعدة البيانات.لطفاً، أبلغ مشرف المُخدم.';
$string['dbsessionmysqlpacketsize'] = 'تم الكشف عن خطأ جسيم في الجلسة. لطفاً، أبلغ المشرف على الموقع. هذه المشكلة ناتجة في الغالب عن قيمة قليلة في max_allowed_packet ضمن إعدادات MySQL.';
$string['dbupdatefailed'] = 'فشل تحديث قاعدة البيانات';
$string['ddldependencyerror'] = '{$a->targettype} "{$a->targetname}" لا يمكن تعديله .التبعية وجدت مع {$a->offendingtype} "{$a->offendingname}"';
$string['ddlexecuteerror'] = 'خطأ في تنفيذ لغة تعريف البيانات (DDL) ل SQL';
$string['ddlfieldalreadyexists'] = 'الحقل "{$a}" موجود مسبقاً';
$string['ddlfieldnotexist'] = 'الحقل "{$a->fieldname}" موجود مسبقاً في الجدول "{$a->tablename}"';
$string['ddltablealreadyexists'] = 'الجدول "{$a}" موجود مسبقاً';
$string['ddltablenotexist'] = 'الجدول "{$a}" غير موجود';
$string['ddlunknownerror'] = 'خطأ غير معروف في مكتبة لغة تعريف البيانات (DDL)';
$string['ddlxmlfileerror'] = 'وجدت أخطاء في ملف قاعدة بيانات XML';
$string['ddsequenceerror'] = 'تعريف جدول "{$a}"  غير صحيح; يمكن أن يكون هناك عمود تلقائي واحد فقط، ويجب أن يتم تعريف على أنه يحتوي على المفتاح.';
$string['destinationcmnotexit'] = 'وحدة المساق المستهدفة غير موجودة';
$string['detectedbrokenplugin'] = 'المُلحق {$a} فيه عيب أو عفا عليه الزمن؛ عذرًا، لا يمكنك المتابعة.';
$string['dmlexceptiononinstall'] = '<p>حدث خطأ في قاعدة البيانات[{$a->errorcode}].<br />{$a->debuginfo}</p>';
$string['dmlparseexception'] = 'وقع خطأ عند استعراب استعلام SQL';
$string['dmlreadexception'] = 'خطأ عند القراءة من قاعدة البيانات';
$string['dmltransactionexception'] = 'خطأ في عملية نقل لقاعدة البيانات';
$string['dmlwriteexception'] = 'خطأ عند الكتابة إلى قاعدة البيانات';
$string['dndmaxbytes'] = 'الملف كبير للغاية. أقصى حجم مسموح به هو {$a->size}.';
$string['dndread'] = 'خطأ عند قراءة الملف';
$string['dndunkownfile'] = 'نوع الملف هذا غير مدعوم';
$string['dndupload'] = 'وقع خطأ غير معروف عند رفع الملف';
$string['downgradedcore'] = 'خطأ: الرمز الذي تستعمله أقدم من النسخة المسجلة في قاعدة البيانات.';
$string['downloadedfilecheckfailed'] = 'فشل التحقق من الملف الذي تم تنزيله';
$string['duplicatefieldname'] = 'تم الكشف عن تكرار في اسم الحقل"{$a}"';
$string['duplicatenosupport'] = 'النشاط \'{$a->modname}\' لا يمكن تكراره لأن وحدة {$a->modtype} لا تدعم عمليتي الحفظ الاحتياطي والاستعادة.';
$string['duplicateparaminsql'] = 'خطأ: تكرار الاسم في الاستعلام';
$string['duplicaterolename'] = 'هناك وظيفة مسبقة بهذا الاسم';
$string['duplicateroleshortname'] = 'هناك دور مسبق ب الاسم القصير';
$string['duplicateusername'] = 'تكرر اسم المستخدم - تجاوز السجل';
$string['editedpagenotfound'] = 'تعذر على النظام تحديد الصفحة التي أنت فيها. رجاءً حاول تنشيط الصفحة ثم المحاولة مجددًا.';
$string['emailfail'] = 'فشل إرسال البريد الإلكتروني';
$string['encryption_decryptfailed'] = 'فشل فك التشفير';
$string['encryption_encryptfailed'] = 'فشل التشفير';
$string['encryption_invalidkey'] = 'مفتاح غير صالح';
$string['encryption_keyalreadyexists'] = 'المفتاح موجود مسبقاً';
$string['encryption_nokey'] = 'المفتاح غير موجود';
$string['encryption_wrongmethod'] = 'البيانات لا تطابق أي طريقة تشفير مدعومة';
$string['enddatebeforestartdate'] = 'تاريخ انتهاء المساق ينبغي أن يكون بعد تاريخ بدئه.';
$string['error'] = 'وقع خطأ';
$string['error_question_answers_missing_in_db'] = 'فشل في العثور على مطابقة الجواب  "{$a->answer}" في جدول قاعدة البيانات الذي يحتفظ بإجابة الأسئلة والمسمى بـ question_answers.  حدث ذلك  أثناء استعادة السؤال صاحب معرف {$a->filequestionid} في النسخة المحفوظة, والتي تم مطابقتها للسؤال الموجود مُسبقاً  صاحب معرف رقم {$a->dbquestionid} في قاعدة البيانات.';
$string['errorcleaningdirectory'] = 'خطأ  في تنظيف دليل "{$a}"';
$string['errorcopyingfiles'] = 'خطأ في نسخ الملفات';
$string['errorcreatingdirectory'] = 'خطأ عند إنشاء المجلد "{$a}"';
$string['errorcreatingfile'] = 'خطأ في تنظيف ملف "{$a}"';
$string['errorcreatingrole'] = 'خطأ في إنشاء الدور';
$string['errorfetchingrssfeed'] = 'خطأ عند إحظار التغذية الإخبارية.';
$string['erroronline'] = 'خطأ في سطر {$a}';
$string['erroroutput'] = 'خطأ في المخرجات، وبالتالي تعطيل إعادة توجيه التلقائي.';
$string['errorparsingxml'] = 'خطأ تحليل XML:{$a->errorstring} في سطر {$a->errorline}, رمز {$a->errorchar}';
$string['errorprocessingarchive'] = 'خطأ في إجراء ارشفة الملف';
$string['errorreadingfile'] = 'خطأ في قراءة ملف "{$a}"';
$string['errorsavingrequest'] = 'ظهر خطأ اثناء محاولة تخزين طلبك';
$string['errorsettinguserpref'] = 'خطأ في إعدادات تفضيلات المستخدم';
$string['errorunzippingfiles'] = 'خطأ في فك الملفات المضغوطة';
$string['expiredkey'] = 'انتهة فترة صلاحية المفتاح';
$string['externalauthpassworderror'] = 'كلمة المرور يجب أن تكون غير فارغة للمصادقة الخارجية';
$string['externalfilenolocation'] = 'الملف الخارجي ليس له مسار لموضعه';
$string['failtoloadblocks'] = 'واحد أو أكثر من الكتل مسجل في قاعدة البيانات، لكنها فشلت جميعها عند التحميل!';
$string['fieldrequired'] = '"{$a}" حقل مطلوب';
$string['fileexists'] = 'الملف موجود';
$string['filemismatch'] = 'لا تطابق في تسمية ملف غير أساسي. الملف "{$a->current}" ينبغي أن يكون بالتسمية {$a->file}';
$string['filenotfound'] = 'عذراً، لم يتم العثور على  الملف المطلوب';
$string['filenotreadable'] = 'الملف غير قابل للقراءة';
$string['filterdoesnothavelocalconfig'] = 'المرشح {$a} لا يسمح بالإعدادت المحلية.';
$string['filternotactive'] = 'المرشح {$a} ليس فعالاً حالياً';
$string['filternotenabled'] = 'المنقح غير مفعل';
$string['filternotinstalled'] = 'المرشح {$a} غير مُنصَّب حالياً';
$string['forumblockingtoomanyposts'] = 'لقد تجاوزت الحد المسموح به للنشر في هذا المنتدى';
$string['functionalityremoved'] = 'أنت تحاول الوصول إلى وظيفة قد تمت إزالتها.';
$string['gdfeaturenotsupported'] = 'الامتداد GD لم يتم تجميعه بحيث يتضمن طرق معالجة لـ {$a}';
$string['gdmimetypenotsupported'] = 'نوع MIME غير مدعوم.';
$string['generalexceptionmessage'] = 'خطأ - {$a}';
$string['gradecantregrade'] = 'حدث خطأ أثناء حساب الدرجة: {$a}';
$string['gradepubdisable'] = 'تم تعطيل نشرالدرجة';
$string['gradesneedregrading'] = 'تتطلب تقديرات المساق إلى إعادة حسابها';
$string['groupalready'] = 'المستخدم ينتمي للمجموعة {$a}';
$string['groupexistforcourse'] = 'المجموعة "{$a}" موجودة مسبقاً في هذا المساق';
$string['groupexistforcoursewithidnumber'] = '{$a->problemgroup}: المجموعة "{$a->name}" رقم معرفها {$a->idnumber}" موجودة حالياً في هذا المساق';
$string['grouphasidnumber'] = 'المجموعة "{$a}" لديها رقم معرف تم إنشاؤها تلقائياً بواسطة نظام خارجي. ليس لديك إذن لإزالة هذه المجموعة.';
$string['groupinghasidnumber'] = 'التجميع "{$a}" لديه رقم معرف قد يكون تم إنشاؤه تلقائياً بواسطة نظام خارجي. ليس لديك صلاحية إزالة هذا التجميع.';
$string['groupingnotaddederror'] = 'لم تتم إضافة التجميع "{$a}"';
$string['groupnotaddederror'] = 'لم تتم إضافة المجموعة "{$a}"';
$string['groupnotaddedtogroupingerror'] = 'المجموعة "{$a->groupname}" لم يتم إضافتها إلى التجمُّع "{$a->groupingname}"';
$string['groupunknown'] = 'المجموعة {$a}  لا ترتبط بأي مساق محدد';
$string['groupusernotmember'] = 'المستخدم ليس عضواً في هذه المجموعة';
$string['guestcantaccessprofiles'] = 'لا يمكن للضيوف الوصول إلى الملفات الشخصية للمستخدمين. قم بتسجيل الدخول باستخدام حساب المستخدم الكامل للمتابعة.';
$string['guestnocomment'] = 'لا يسمح للضيوف بإضافة التعليقات!';
$string['guestnoeditprofile'] = 'لا يمكن للمستخدم الضيف أن يعدّل حسابه';
$string['guestnoeditprofileother'] = 'لا يمكن تعديل حساب المستخدم الضيف';
$string['guestnorate'] = 'الضيوف لا يُسمح لهم بتقييم الإدخالات';
$string['guestsarenotallowed'] = 'لا يسمح للمستخدم الضيف القيام بذلك';
$string['hackdetected'] = 'تم الكشف عن محاولة اختراق';
$string['hashpoolproblem'] = 'محتوى تجمُّع الملف غير صحيح {$a}.';
$string['headersent'] = 'تم إرسال العناوين الرئيسية مُسبقاً';
$string['idnumbertaken'] = 'رقم التعريف هذا  قيد الاستخدام';
$string['idnumbertoolong'] = 'رقم المعرف طويل جدا';
$string['importformatnotimplement'] = 'عذراً، استيراد هذا التنسيق غير منفذ بعد!';
$string['incorrectext'] = 'امتداد الملف غير صحيح';
$string['inplaceeditableerror'] = 'حدث خطأ في استدعاء معالج التحديث';
$string['installproblem'] = 'عادة لا يكون من الممكن التعافي من الأخطاء الناجمة في أثناء التنصيب، قد تحتاج إلى إنشاء قاعدة بيانات جديدة أو استعمال بادئة مختلفة لجداول قاعدة البيانات إذا كنت ترغب في إعادة محاولة التنصيب.';
$string['internalauthpassworderror'] = 'كلمة المرور مفقودة أوسياسة كلمة المرور غير صحيح للمصادقة الداخلية';
$string['invalidaccess'] = 'هذه الصفحة لم يتم الوصول إليها بشكل صحيح';
$string['invalidaccessparameter'] = 'معامل دخول غير صحيح';
$string['invalidaction'] = 'معامل عمل غير صحيح';
$string['invalidactivityid'] = 'مُعرَّف النشاط غير صحيح';
$string['invalidadminsettingname'] = 'إعداد المشرف غير صحيحة  ({$a})';
$string['invalidargorconf'] = 'لم يتم إدخال معاملات صحيحة أو أن إعدادات المخدم غير صحيحة';
$string['invalidarguments'] = 'لم يتم إدخال معاملات صحيحة';
$string['invalidblockinstance'] = 'عينة كتلة غير صحيحة لـ: {$a}';
$string['invalidbulkenrolop'] = 'تم طلب عملية تسجيل لعدد كبير (بالجملة) غير صحيحة';
$string['invalidcategory'] = 'التصنيف غير صحيح';
$string['invalidcategoryid'] = 'مُعرَّف التصنيف خاطئ!';
$string['invalidcomment'] = 'التعليق خاطئ';
$string['invalidcommentarea'] = 'منطقة تعليق غير صالحة';
$string['invalidcommentid'] = 'مُعرَّف التعليق غير صحيح';
$string['invalidcommentitemid'] = 'مُعرَّف فقرة التعليق غير صحيح';
$string['invalidcommentparam'] = '';
$string['invalidcomponent'] = 'اسم عنصر غير صحيح';
$string['invalidconfirmdata'] = 'تأكيد البيانات غير صحيح';
$string['invalidcontentid'] = 'مُعرَّف المحتوى غير صحيح';
$string['invalidcontext'] = 'سياق غير صحيح';
$string['invalidcountrycode'] = 'ترميز البلد غير صالح: {$a}';
$string['invalidcourse'] = 'المساق غير صحيح';
$string['invalidcourseformat'] = 'تنسيق المقرر غير صحيح';
$string['invalidcourseid'] = 'أنت تحاول استعمال مُعرَّف مساق  غير صحيح';
$string['invalidcourselevel'] = 'مستوى السياق خاطئ';
$string['invalidcoursemodule'] = 'معرف وحدة المساق غير صحيح';
$string['invalidcoursemoduleid'] = 'مُعرَّف وحدة مساق غير صحيح: {$a}';
$string['invalidcoursenameshort'] = 'الاسم المختصر للمقرر الدراسي غير صحيح';
$string['invaliddata'] = 'البيانات المسلمة غير صحيحة';
$string['invaliddatarootpermissions'] = 'تم اكتشاف خطأ في الصلاحيات عند إنشاء مجلد جديد. قم بتشغيل التصحيح debugging لتفاصيل أكثر';
$string['invaliddatetimebetween'] = 'إن {$a->after} ينبغي أن تكون قبل {$a->before}.';
$string['invaliddatetimemode'] = 'وضع خاطئ لمرشح الوقت المتغير: {$a}';
$string['invaliddevicetype'] = 'نوع جهاز غير صالح';
$string['invalidelementid'] = 'مُعرَّف العنصر خاطئ!';
$string['invalidentry'] = 'هذا ليس مُدخل صحيح!';
$string['invalidevent'] = 'حدث غير صحيح';
$string['invalidfieldname'] = '"{$a}" ليس اسمًا صحيحًا للحقل';
$string['invalidfile'] = 'الملف غير موجود';
$string['invalidfiletype'] = '"{$a}" ليس نوع ملف صالح';
$string['invalidformatpara'] = 'صيغة خاطئة لمعامل اختيار';
$string['invalidformdata'] = 'نموذج البيانات غير صحيح';
$string['invalidfunction'] = 'عملية غير صحيحة';
$string['invalidgradeitemid'] = 'مُعرَّف عنصر التقييم خاطئ';
$string['invalidgroupid'] = 'المُعرَّف المحدد للمجموعة خاطئ';
$string['invalidipformat'] = 'تنسيق عنوان برتوكول الإنترنت IP غير صحيح';
$string['invaliditemid'] = 'مُعرَّف العنصر خاطئ';
$string['invalidkey'] = 'المفتاح غير صحيح';
$string['invalidlanguagecode'] = 'رمز لغة غير صالح: {$a}';
$string['invalidlegacy'] = 'تعريف الدور من النسخ القديمة لمودل غير صحيح لنوع: {$a}';
$string['invalidmd5'] = 'المتغير المُختار خاطئ - حاول مرة أخرى';
$string['invalidmode'] = 'نمط غير صحيح  ({$a})';
$string['invalidmodule'] = 'وحدة غير صحيحة';
$string['invalidmoduleid'] = 'مُعرَّف الوحدة غير صحيح: {$a}';
$string['invalidmodulename'] = 'اسم الوحدة غير صحيح: {$a}';
$string['invalidnum'] = 'القيمة الرقمية غير صحيحة';
$string['invalidnumkey'] = 'المصفوفة $conditions ينبغي أن لا تحتوي على مفاتيح رقمية. لطفاً، قم بإصلاح الترميز البرمجي!';
$string['invalidoutcome'] = 'مُعرَّف المخرجات خاطئ';
$string['invalidpagesize'] = 'حجم الصفحة غير صحيح';
$string['invalidpasswordpolicy'] = 'اتفاقية كلمة المرور غير صحيحة';
$string['invalidpaymentmethod'] = 'طريقة دفع المبلغ المالي غير صحيحة: {$a}';
$string['invalidpersistenterror'] = 'خطأ: {$a}';
$string['invalidqueryparam'] = 'خطأ: عدد غير صحيح من معاملات الاستعلام. المتوقع {$a->expected}, وتم الحصول على {$a->actual}.';
$string['invalidratingarea'] = 'منطقة تصنيف غير صالحة';
$string['invalidrecord'] = 'تعذر العثور على السجل في جدول قاعدة البيانات {$a}.';
$string['invalidrecordunknown'] = 'تعذر العثور على السجل في قاعدة البيانات.';
$string['invalidrequest'] = 'طلب غير صحيح';
$string['invalidrole'] = 'الدور غير صحيح';
$string['invalidroleid'] = 'معرف الدور غير صحيح';
$string['invalidscaleid'] = 'مُعرَّف المقياس خاطئ';
$string['invalidsection'] = 'يحتوي سجل وحدة المساق على قسم غير صحيح';
$string['invalidsesskey'] = 'جلستك انتهت صلاحيتها على الأغلب. لطفاً، تحقق من كونك مسجل لدخولك أو إرجع إلى الصفحة السابقة ثم أعد التحميل.';
$string['invalidshortname'] = 'الاسم المختصر للمقرر الدراسي غير صحيح';
$string['invalidsourcefield'] = 'حقل المصدر لملف المسودة غير صحيح';
$string['invalidstatedetected'] = 'فهناك شيء ما خطأ:  {$a}. هذا لا ينبغي أبدا أن يحدث بشكل طبيعي.';
$string['invalidurl'] = 'عنوان الإنترنت غير صحيح';
$string['invaliduser'] = 'المستخدم غير صحيح';
$string['invaliduserdata'] = 'بيانات المستخدم غير صالحة: {$a}';
$string['invaliduserfield'] = 'حقل المستخدم غير صالح: {$a}';
$string['invaliduserid'] = 'مُعرَّف المستخدم خاطئ';
$string['invalidusername'] = 'اسم المستخدم المُعطى يحتوي على رموز غير صالحة';
$string['invalidusernameblank'] = 'اسم المستخدم لا يمكن أن يكون فارغاً';
$string['invalidxmlfile'] = '"{$a}" ليس ملف XML صالح';
$string['iplookupfailed'] = 'لا يمكن العثور على معلومات جغرافية حول هذا العنوان IP {$a}';
$string['iplookupprivate'] = 'يتعذر إظهار قائمة بحث لعنوان IP خاص';
$string['ipmismatch'] = 'عنوان IP للعميل غير متطابق';
$string['itemnotfound'] = 'لم يتم العثور على {$a->itemtype} بالمُعرَّف \'{$a->identifier}\'';
$string['listcantmovedown'] = 'فشل نقل العنصر إلى الأسفل، لأنه الأخير بين نظرائه.';
$string['listcantmoveleft'] = 'فشل نقل العنصر إلى اليمين، لأنه لا يوجد لديه عنصر ذو رتبة أعلى';
$string['listcantmoveright'] = 'فشل نقل العنصر إلى اليمين، نظراً لعدم وجود نظير ليكون متفرعاً منه. أنقله أسفل نظير آخر وعندها يمكنك نقله إلى اليمين.';
$string['listcantmoveup'] = 'فشل نقل العنصر إلى الأعلى، لأنه الأول بين نظرائه.';
$string['listnochildren'] = 'تعذر العثور على فروع للعنصر';
$string['listnoitem'] = 'لم يتم إيجاد العنصر';
$string['listnopeers'] = 'تعذر العثور على نظراء للعنصر';
$string['listupdatefail'] = 'فشلت عملية قاعدة البيانات عند تعديل التسلسل الهرمي للقائمة';
$string['logfilenotavailable'] = 'سجلات الوقوعات غير متاحة';
$string['loginasnoenrol'] = 'لا يمكنك استعمال الانضمام أو إلغاء الانضمام خلال جلسة الدخول منتحلاً صفة مستخدم آخر.';
$string['loginasonecourse'] = 'لا يمكنك دخول هذا المساق. عليك إنهاء جلسة \'الدخول بصفة\' قبل دخول أي مساق آخر.';
$string['maxareabytes'] = 'الملف أكبر من المساحة المتبقية في هذه المنطقة.';
$string['maxbytesfile'] = 'حجم الملف {$a->file} كبير جداً . الحد الأقصى الذي تستطيع رفعه هو {$a->size}.';
$string['maxdraftitemids'] = 'صار رفعك للملفات محدودًا بشكل مؤقت بعد قيامك برفع مقدار كبير من الملفات، يرجى المحاولة مجددًا بعد برهة.';
$string['messageundeliveredbynotificationsettings'] = 'تعذر إرسال الرسالة لأن الرسائل الشخصية بين المستخدمين (في إعدادات الإشعارات) قد تم تعطيلها من قبل مشرف الموقع.';
$string['messagingdisable'] = 'نظام المراسلة معطل في هذا الموقع';
$string['mimetexisnotexist'] = 'نظامك غير مهيأ لتشغيل mimeTeX. ينبغي عليك الحصول على مصدر لغة البرمجة C من <a href="https://www.forkosh.com/mimetex.zip">https://www.forkosh.com/mimetex.zip</a>، ثم تجميعه ووضع الناتج القابل للتنفيذ في المجلد moodle/filter/tex/ الخاص بنسختك من مودل.';
$string['mimetexnotexecutable'] = 'mimetex المخصص غير قابل للتنفيذ!';
$string['missing_moodle_backup_xml_file'] = 'الحفظ الاحتياطي يفتقر إلى ملف XML: {$a}';
$string['missingcategoryrole'] = 'تعذر تعيين الدور للمستخدم: لا يوجد دور للتصنيف.';
$string['missingfield'] = 'الحقل "{$a}" غير موجود';
$string['missingkeyinsql'] = 'خطأ: معامل مفقود "{$a}" في الاستعلام';
$string['missingparam'] = 'المعامل الإجباري ({$a}) مفقود';
$string['missingparameter'] = 'معامل مفقود';
$string['missingrequiredfield'] = 'بعض الحقول المطلوبة مفقودة';
$string['missinguseranditemid'] = 'مُعرَّفا المستخدم والفقرة مفقودان';
$string['missingvarname'] = 'تسمية متغير مطلوب مفقودة!';
$string['mixedtypesqlparam'] = 'خطأ: أنواع متفاوتة من معاملات استعلام sql!!';
$string['mnetdisable'] = 'شبكة مودل غير مُمَكَّنة';
$string['mnetlocal'] = 'مستخدمو شبكة مودل الخارجيون لا يمكنهم تسجيل الدخول محلياً';
$string['moduledisable'] = 'هذه الوحدة ({$a}) قد تم تعطيلها في هذا المساق بالذات';
$string['moduledoesnotexist'] = 'هذه الوحدة غير موجودة';
$string['moduleinstancedoesnotexist'] = 'عينة هذه الوحدة غير موجودة';
$string['modulemissingcode'] = 'تفتقر الوحدة {$a} إلى الترميز البرمجي المطلوب لتنفيذ هذه الوظيفة';
$string['moodlenet:invalidshareformat'] = 'صيغة المشاركة مع شبكة مودل غير صالحة';
$string['moodlenet:invalidsharestatus'] = 'حالة مشاركة شبكة مودل خاطئة';
$string['moodlenet:invalidsharetype'] = 'نوع مشاركة شبكة مودل خاطئ';
$string['moodlenet:usernotconfigured'] = 'ليست لديك صلاحية مشاركة المحتوى مع شبكة مودل، أو أن حسابك غير مهيأ بشكل صحيح.';
$string['movecatcontentstoroot'] = 'نقل محتويات التصنيف إلى الجذر الرئيسي أمر غير مسموح له. ينبغي عليك نقل المحتويات إلى تصنيف موجود فعلياً!';
$string['movecatcontentstoselected'] = 'بعض محتويات التصنيف لا يمكن نقلها إلى التصنيف المحدد.';
$string['movecategorynotpossible'] = 'لا يمكنك نقل التصنيف \'{$a}\' إلى داخل التصنيف المحدد.';
$string['movecategoryownparent'] = 'لا يمكنك جعل التصنيف \'{$a}\' تابعاً إلى نفسه.';
$string['movecategoryparentconflict'] = 'لا يمكنك جعل التصنيف \'{$a}\' تصنيفاً فرعياً لواحد من التصنيفات الفرعية العائدة له.';
$string['mssqlrcsmodemissing'] = 'قاعدة البيانات لا تستعمل النمط المتوقع READ_COMMITTED_SNAPSHOT مما قد يؤدي إلى نتائج خاطئة، خصوصاً تحت سيناريوهات ضغط التشغيل العالي. لطفاً، قم بتمكينه للحصول على أسلوب التشغيل الصحيح. للمزيد من المعلومات، عاين <a href="https://docs.moodle.org/en/Installing_MSSQL_for_PHP">تنصيب MSSQL لـ PHP</a>.';
$string['multiplerecordsfound'] = 'تم العثور على سجلات متعددة، بينما المتوقع وجود سجل واحد.';
$string['multiplerestorenotallow'] = 'لا يُسمح بتشغيل مهمات استعادة متعددة!';
$string['mustbeloggedin'] = 'لابد أن تكون داخلاً على النظام لتتمكن من القيام بهذا';
$string['mustbeteacher'] = 'المعلمون فقط يستطيعون معاينة هذه الصفحة';
$string['myisamproblem'] = 'جداول قاعدة البيانات تستعمل محرك قاعدة البيانات MyISAM، من الموصى به استعمال محرك متوافق مع ACID مع دعم مناقلة كامل كما في InnoDB.';
$string['needcopy'] = 'ًتحتاج إلى نسخ شيء أولا!';
$string['needcoursecategroyid'] = 'لا بد من تحديد مُعرَّف المساق أو التصنيف';
$string['needphpext'] = 'عليك إضافة دعم {$a} إلى تنصيب PHP الخاص بك';
$string['noadmins'] = 'لا يوجد مشرفون!';
$string['noblocks'] = 'لم يتم العثور على كتل!';
$string['nocapabilitytousethisservice'] = 'المستخدم ليس لديه الإمكانية المطلوبة لاستعمال هذه الخدمة';
$string['nocategorydelete'] = 'يتعذر حذف التصنيف \'{$a}\'!';
$string['nocontext'] = 'عذراً، ولكن المساق ليس سياقاً صحيحاً';
$string['nodata'] = 'لا يوجد بيانات';
$string['noexistingcategory'] = 'لا يوجد تصنيف';
$string['nofile'] = 'لم يتم تحديد الملف';
$string['nofiltersenabled'] = 'لم يتم تمكين أي منقحات.';
$string['nofolder'] = 'المجلد المطلوب غير موجود';
$string['noformdesc'] = 'لا يوجد ملف وصفي لنموذج formslib لهذا النشاط.';
$string['noguest'] = 'لا يسمح بزوار هنا!';
$string['noinstances'] = 'لا توجد عينات من {$a} في هذا المساق!';
$string['nologinas'] = 'غير مسموح لك بالدخول منتحلاً صفة هذا المستخدم';
$string['nonmeaningfulcontent'] = 'لا يوجد محتوي ذي معني';
$string['noparticipants'] = 'لم يتم العثور على مشاركين في هذا المساق';
$string['noparticipatorycms'] = 'عذراً، ولكن ليس لديك وحدات مساق ذات طابع تشاركي لتقدم بها تقريراً';
$string['nopermissions'] = 'عذراً، ولكنك لا تملك حالياً الصلاحيات للقيام بهذا ({$a}).';
$string['nopermissiontoaccesspage'] = 'ليست لديك صلاحية الوصول إلى هذه الصفحة.';
$string['nopermissiontocomment'] = 'لا تستطيع إضافة تعليقات';
$string['nopermissiontodelentry'] = 'لا يمكنك حذف هذا التعليق!';
$string['nopermissiontoeditcomment'] = 'لا تستطيع تحرير تعليقات الاخرين!';
$string['nopermissiontohide'] = 'لا صلاحية لإخفائه!';
$string['nopermissiontoimportact'] = 'ليست لديك الصلاحية المطلوبة لاستيراد النشاطات إلى هذا المساق';
$string['nopermissiontolock'] = 'لا صلاحية لتأمينه!';
$string['nopermissiontomanagegroup'] = 'ليست لديك الصلاحية المطلوبة لإدارة المجموعات';
$string['nopermissiontorate'] = 'تقييم الفقرات غير مسموح به!';
$string['nopermissiontoshow'] = 'لا صلاحية لمشاهدة هذا!';
$string['nopermissiontounlock'] = 'لا صلاحية لإلغاء تأمينه!';
$string['nopermissiontoupdatecalendar'] = 'عذراً، ولكنك لا تمتلك صلاحية تعديل حدث التقويم.';
$string['nopermissiontoviewcalendar'] = 'عذرًا، ولكن ليست لديك صلاحية معاينة حدث التقويم.';
$string['nopermissiontoviewgrades'] = 'لا يمكن معاينة التقديرات.';
$string['nopermissiontoviewletergrade'] = 'الافتقار إلى صلاحية معاينة تقديرات الحروف';
$string['nopermissiontoviewpage'] = 'ليس مسموحاً لك النظر إلى هذه الصفحة';
$string['nosite'] = 'تعذر العثور على مساق بالرتبة الأعلى!';
$string['nositeid'] = 'لا مُعرَّف للموقع';
$string['nostartdatenoenddate'] = 'تاريخ انتهاء المساق يمكن تحديده فقط إذا تم تحديد تاريخ بدئه.';
$string['nostatstodisplay'] = 'عذراً، لا يوجد بيانات ليتم عرضها';
$string['notallowedtoupdateprefremotely'] = 'ليس مسموحاً لك تحديث هذا التفضيل للمستخدم عن بعد';
$string['notavailable'] = 'ًغير متوفر حاليا';
$string['notfound'] = 'غير موجود';
$string['notlocalisederrormessage'] = '{$a}';
$string['notmemberofgroup'] = 'لستَ من أعضاء هذه المجموعة في المساق';
$string['notownerofkey'] = 'أنت لست صاحب هذا المفتاح';
$string['nousers'] = 'لا يوجد مثل هذا المستخدم!';
$string['oauth1accesstoken'] = 'خطأ في OAuth 1.0: لم يتسن لنا الحصول على رمز الوصول إلى الخدمة.';
$string['oauth1requesttoken'] = 'خطأ في OAuth 1.0: لم يتسن لنا الحصول على رمز الوصول المطلوب، قد يكون مزود الخدمة متوقف عن العمل مؤقتاً.';
$string['oauth2refreshtokenerror'] = 'تعذر تنشيط ترميز OAuth 2. حالة HTTPS للنقاط الطرفية البعيدة هي: {$a}';
$string['oauth2refreshtokentaskerror'] = 'تعذر تنشيط ترميز OAuth 2 لمُصدر واحد أو أكثر. أنظر مخرجات المهمة لمعرفة التفاصيل.';
$string['oauth2upgradetokenerror'] = 'تعذرت ترقية ترميز OAuth 2. حالة HTTPS للنقاط الطرفية البعيدة هي: {$a}';
$string['onlyadmins'] = 'المشرفون فقط يمكنهم القيام بذلك';
$string['onlyeditingteachers'] = 'المعلمون بصلاحية التحرير فقط يمكنهم القيام بذلك';
$string['onlyeditown'] = 'تستطيع تحرير معلوماتك فقط';
$string['opensslsealerror'] = 'لا يمكن لـ OpenSSL ختم البيانات';
$string['opensslsignerror'] = 'لا يمكن لـ OpenSSL توقيع البيانات';
$string['orderidnotfound'] = 'رقم معرف الطلب {$a} غير موجود';
$string['pagenotexist'] = '<p>وقع خطأ غير عادي (محاولة للوصول إلى صفحة غير موجودة):</p> {$a}';
$string['pagenotexisttitle'] = 'خطأ 404: تعذر العثور على الملف';
$string['passwordexceeded'] = 'كلمة المرور لا يمكنها أن تتجاوز {$a} من المحارف!';
$string['pathdoesnotstartslash'] = 'تم تزويد معامل غير صحيح، المسار لا يبدأ بشطبة!';
$string['pleasereport'] = 'إن كان لديك برهة من الزمن، لطفاً، أبلغنا عما كنت بصدد القيام به عند وقوع الخطأ:';
$string['pluginnotexist'] = 'الملحق {$a} غير موجود';
$string['pluginrequirementsnotmet'] = 'تعذر تنصيب الإضافة "{$a->pluginname}" ({$a->pluginversion}). إنه يتطلب نسخة أحدث من مودل (حالياً أنت تستعمل {$a->currentmoodle}، بينما تحتاج إلى {$a->requiremoodle}).';
$string['pluginunsupported'] = 'الإضافة "{$a->pluginname}" {$a->pluginversion} لا يدعم هذه النسخة من مودل {$a->moodleversion}. تحرى معلومات الإضافة لمعرفة الإصدارات التي تدعمها.';
$string['prefixcannotbeempty'] = '<p>خطأ: بادئة جدول قاعدة البيانات لا يمكن أن تكون فارغة ({$a})</p>
<p>المشرف على الموقع عليه إصلاح هذه المشكلة.</p>';
$string['privatefilesupload'] = 'الرفع المباشر إلى ملفات المستخدم الخاصة لم يعد مدعوماً. قم بالرفع إلى منطقة مؤقتة ومن ثم أنقل الملفات مستعملاً
core_user::add_user_private_files';
$string['processingstops'] = 'المعالجة تقف هنا. تم تجاهل السجلات المتبقية';
$string['protected_cc_not_supported'] = 'الخراطيش المحمية غير مدعومة.';
$string['querystringcannotbeempty'] = 'نص الاستعلام لا يمكن أن يكون خالياً.';
$string['redirecterrordetected'] = 'تم الكشف عن إعادة توجيه غير مدعومة؛ تم إيقاف تشغيل النص البرمجي.';
$string['redissessionhandlerproblem'] = 'إعداد جلسة Redis قد فشل. يرجى إبلاغ مشرف المخدم.';
$string['refoundto'] = 'يمكن ردها إلى {$a}';
$string['refoundtoorigi'] = 'تم ردها إلى المبلغ الأصلي: {$a}';
$string['registrationdisabled'] = 'التسجيل معطل في هذا الموقع';
$string['remotedownloaderror'] = '<p>فشل تنزيل المكون إلى مُخدمك. لطفاً تحقق من إعدادات الوكيل؛ الامتداد cURL لـ PHP موصى به بشدة.</p>
<p>عليك تنزيل الملف <a href="{$a->url}">{$a->url}</a> يدوياً، ونسخه إلى "{$a->dest}" في مُخدمك ثم القيام بفك ضغطه هناك.</p>';
$string['remotedownloadnotallowed'] = 'تنزيل المكونات إلى مخدمك أمر غير مسموح به (allow_url_fopen معطل).<br /><br />عليك تنزيل الملف <a href="{$a->url}">{$a->url}</a> يدوياً، ونسخه إلى "{$a->dest}" في مُخدمك ثم القيام بفك ضغطه هناك.';
$string['reportnotavailable'] = 'هذا النوع من التقرير ';
$string['requirecorrectaccess'] = 'رابط أو منفذ خاطئ.';
$string['requireloginerror'] = 'لا يمكن الوصول إلي هذا المساق أو النشاط';
$string['restore_path_element_missingmethod'] = 'طريقة الاستعادة {$a} مفقودة. لا بد من تعريفها من قبل مطوِّر.';
$string['restore_path_element_noobject'] = 'المكون المستعاد {$a} ليس مكوناً حقاً.';
$string['restorechecksumfailed'] = 'حدثت مشكلة ما مع المعلومات المستعادة في جلستك. لطفاً، تحقق من حدود حجم memory/DB في إعدادات PHP.
الاستعادة توقفت.';
$string['restrictedcontextexception'] = 'عذراً، تنفيذ الوظيفة الخارجية ينتهك قيود السياق.';
$string['restricteduser'] = 'عذراً، حسابك الحالي "{$a}" لا يخولك للقيام بذلك';
$string['reverseproxyabused'] = 'الوكيل العكسي مُمَكَّن لذلك لا يمكن الوصول إلى المخدم مباشرة.<br />لطفاً، اتصل بالمشرف.';
$string['rpcerror'] = 'عفواً! إتصالك بشبكة مودل قد تعرض إلى الفشل! إليك رسالة الخطأ لتقوم بتمريرها إلى المشرف: {$a}';
$string['scheduledbackupsdisabled'] = 'الحفظ الاحتياطي المجدول قد تم تعطيله من قبل المشرف';
$string['secretalreadyused'] = 'رابط تأكيد تغيير كلمة المرور قد سبق استعماله؛ كلمة المرور لم تتعرض للتغيير.';
$string['sectioncantbefound'] = '<p><strong>لا يمكن العثور على هذا المحتوى.</strong></p><p>ربما تم حذفه، أو أن عنوان الرابط غير صحيح.</p>';
$string['sectionnotexist'] = 'هذا القسم غير موجود';
$string['sendmessage'] = 'أرسل رسالة';
$string['sendmessagesent'] = 'شكراً على إفادتك بشأن:<br>{$a}';
$string['serverconnection'] = 'خطأ في الاتصال بالخادم';
$string['servicedonotexist'] = 'الخدمة غير موجودة';
$string['sessioncannotobtainlock'] = '<p>يتعذر الحصول على تأمين للجلسة ذات المُعرَّف {$a->id} ضمن {$a->acquiretimeout}.</p>
<p>من المرجح وجود صفحة أخرى ({$a->whohaslock}) قيد التشغيل في تبويب آخر لمستعرض الويب، أو أنها لم تفك التأمين بسبب خطأ ما.</p>
<p>يمكنك الانتظار حتى انقضاء مهلة تأمين الجلسة ({$a->lockexpire}) أو يمكنك إعادة جلسة مستعرضك. إذا تكرر ظهور هذا الخطأ، يرجى إبلاغ مشرف المخدم.</p>';
$string['sessioncookiesdisable'] = 'استعمال خاطئ للدالة require_key_login() - ملفات تعريف الارتباط المتعلقة بجلسة العمل لا بد من تعطيلها!';
$string['sessiondiskfull'] = 'جزء التحكم بجلسات العمل ممتلئ. يتعذر دخول الموقع حالياً. لطفاً، أبلغ المشرف.';
$string['sessionerroruser'] = 'انتهت جلستك، الرجاء تسجيل الدخول مجدداً.';
$string['sessionerroruser2'] = 'تم الكشف عن وقوع خطأ في المخدم له تأثير على جلسة دخولك. لطفاً، سجل دخولك مجدداً أو أعد تشغيل المتصفح.';
$string['sessionexpired'] = 'انتهت صلاحية الجلسة';
$string['sessionhandlerproblem'] = 'معالج الجلسة غير مهيأ بشكل صحيح';
$string['sessionipnomatch'] = 'عذراً، ولكن عنوان IP قد تغير عما كان عليه لدى تسجيلك للدخول أول مرة. ميزة الأمان هذه تمنع المخترقين من سرقة هويتك عندما تكون مستعملاً للموقع. المستخدمون العاديون ليس عليهم معاينة هذه الرسالة - لطفاً، أطلب مساعدة المشرف على الموقع.';
$string['sessionipnomatch2'] = '<p>عذراً، ولكن عنوان IP قد تغير عما كان عليه لدى تسجيلك للدخول أول مرة. ميزة الأمان هذه تمنع المخترقين من سرقة هويتك عندما تكون مستعملاً للموقع. قد تصادفك هذه الرسالة عند استعمالك للشبكات اللاسلكية أو عندما تكون متنقلاً ما بين شبكات مختلفة. لطفاً، أطلب مساعدة إضافية من المشرف على الموقع.</p>
<p>إذا أردت المتابعة، لطفاً، إضغط المفتاح F5 لتنشيط هذه الصفحة.</p>';
$string['sessionstarterror'] = 'لم يمكن البدء بالجلسة. ترجى المحاولة في وقت لاحق.';
$string['sessionwaiterr'] = 'انتهت الصلاحية بينما يجري انتظار تأمين الجلسة.<br />إنتظر انتهاء طلباتك الحالية ثم حاول مجدداً فيما بعد.';
$string['shortnametaken'] = 'الاسم المختصر مستعمل سلفاً لمساق آخر ({$a})';
$string['sitepolicynotagreed'] = 'سياسة الموقع غير موافق عليها: <a href="{$a}">أنقر هنا لفتح صفحة سياسة الموقع.</a>';
$string['socksnotsupported'] = 'وكيل SOCKS5 غير مدعوم في PHP4';
$string['spellcheckernotconf'] = 'المدقق الأملائي غير معد';
$string['sslonlyaccess'] = 'لدواعي الأمان، فقط الاتصالات عبر بروتوكول https مسموح بها. عذراً.';
$string['statscatchupmode'] = 'الإحصائيات حالياً في طور المواكبة. حتى الآن {$a->daysdone} يوماً تمت معالجتها وهناك {$a->dayspending} يوم قيد الانتظار. عاود التحقق قريباً!';
$string['statsdisable'] = 'لم يتم تمكين الإحصاءات.';
$string['statsnodata'] = 'لا توجد بيانات لهذا المزيج من المساق والفترة الزمنية';
$string['storedfilecannotcreatefile'] = 'تعذر إنشاء ملف محلي لمجمع الملفات. لطفاً، تحقق من الصلاحيات في مجلد البيانات الرئيسي والحيز المتاح من القرص الصلب.';
$string['storedfilecannotcreatefiledirs'] = 'تعذر إنشاء مجلدات لمجمع الملفات المحلية. لطفاً، تحقق من الصلاحيات في مجلد البيانات الرئيسي.';
$string['storedfilecannotread'] = 'لا يمكن قراءة الملف. إما أن الملف غير موجود أو أن هناك مشكلة في التصريح.';
$string['storedfilecannotreadfile'] = 'تعذرت قراءة الملف \'{$a}\'. إما أن الملف غير موجود أو هناك مشكلة في الصلاحيات.';
$string['storedfilenotcreated'] = 'لا يمكن إنشاء الملف {$a->contextid}/{$a->component}/{$a->filearea}/{$a->itemid}{$a->filepath}{$a->filename}';
$string['storedfileproblem'] = 'استثناء غير معروف متعلق بالملفات المحلية ({$a})';
$string['tagdisabled'] = 'الوسوم معطّلة!';
$string['tagnotfound'] = 'تعذر العثور على الوسم المحدد في قاعدة البيانات';
$string['targetdatabasenotempty'] = 'قاعدة البيانات الهدف ليست فارغة. تم إيقاف عملية النقل لأسباب تتعلق بالسلامة.';
$string['textconditionsnotallowed'] = 'مقارنات شروط أعمدة النصوص أمر غير مسموح به. لطفاً، استعمل الدالة sql_compare_text() في استعلامك.';
$string['themenotinstall'] = 'هذا القالب غير منصب!';
$string['tokengenerationfailed'] = 'تعذر توليد ترميز جديد.';
$string['transactionvoid'] = 'تعذر تفريغ التبادل لأنه سبق القيام بذلك';
$string['unenrolerror'] = 'وقع خطأ ما عند محاولة إلغاء انضمام ذلك الشخص';
$string['unicodeupgradeerror'] = 'عذراً، ولكن قاعدة بياناتك ليست بترميز يونيكود وهذا الإصدار من مودل لا يستطيع ترحيل قاعدة بياناتك إلى يونيكود. لطفاً، قم بالترقية إلى الإصدار 1.7.x أولاً ثم أجرِ الترحيل إلى يونيكود من صفحة المشرف. بعد إكمال ذلك، سيكون بإمكانك الترحيل إلى الإصدار {$a} من مودل';
$string['unknowaction'] = 'إجراء غير معروف';
$string['unknowcategory'] = 'التصنيف غير معروف';
$string['unknowcontext'] = 'هذا سياق غير معروف ({$a}) في get_child_contexts!';
$string['unknowformat'] = 'التنسيق ({$a}) غير معروف';
$string['unknownbackupexporterror'] = 'خطأ غير معروف عند تحضير المعلومات للاستيراد';
$string['unknownblockregion'] = 'منطقة الكتلة \'{$a}\' غير معروفة في هذه الصفحة.';
$string['unknowncategory'] = 'تصنيف غير معروف ذي الرقم "{$a}"';
$string['unknowncontext'] = 'هذا سياق غير معروف';
$string['unknowncourse'] = 'اسم المقرر غير معروف "{$a}"';
$string['unknowncourseidnumber'] = 'معرف المساق غير معروف "{$a}';
$string['unknowncourserequest'] = 'طلب مساق غير معروف';
$string['unknowncoursesection'] = 'القسم غير معروف في المساق "{$a}"';
$string['unknownevent'] = 'حدث غير معروف';
$string['unknownfiletype'] = 'خطأ غير معروف في نوع المرشح';
$string['unknowngroup'] = 'المجموعة غير معروفة "{$a}"';
$string['unknownjsinrequirejs'] = 'تعذر العثور على مكتبة JavaScript {$a}.';
$string['unknownmodulename'] = 'اسم الوحدة النمطية غير معروف للنموذج';
$string['unknownrole'] = 'الدورغير معروف "{$a}"';
$string['unknownsortcolumn'] = 'ترتيب عمود غير معروف {$a}';
$string['unknownuseraction'] = 'عذراً، أنا لا أفهم هذا العمل المستخدم';
$string['unknownuserselector'] = 'محدد مستخدم غير معروف';
$string['unknoworder'] = 'الترتيب غير معروف "{$a}"';
$string['unknowparamtype'] = 'نوع معامل غير معروف: {$a}';
$string['unknowquestiontype'] = 'نوع السؤال غير مدعوم {$a}';
$string['unknowuploadaction'] = 'خطأ: إجراء رفع غير معروف ({$a})';
$string['unspecifycourseid'] = 'لا بد من تحديد مُعرَّف المساق، اسمه المختصر أو رمزه';
$string['unsupportedevent'] = 'نوع حدث غير مدعوم';
$string['unsupportedstate'] = 'حالة إكمال غير مدعومة';
$string['unsupportedwebserver'] = 'برنامج مخدم الويب ({$a}) غير مدعوم، عذراً.';
$string['upgraderequires19'] = 'خطأ: إصدار جديد من مودل قد تم تنصيبه في المخدم، لسوء الحظ، الترقية مباشرة من الإصدار القديم متعذرة.<br />لطفاً، قم بالترقية أولاً إلى الإصدار الأخير من الإطلاق 1.9.x. يمكنك أيضاً العودة إلى الإصدار السابق عبر إعادة تنصيب ملفاته الأصلية.';
$string['upgraderunning'] = 'الموقع قيد الترقية حاليًا، الرجاء إعادة المحاولة لاحقًا.';
$string['urlnotdefinerss'] = 'عنوان الرابط غير مُعرَّف لمغذي خدمة الأخبار';
$string['useradmineditadmin'] = 'يسمح للمشرفين فقط بتعديل حسابات المشرفين الآخرين';
$string['useradminodelete'] = 'لا يمكن حذف حسابات المشرفين.';
$string['userautherror'] = 'إضافة مصادقة غير معروفة';
$string['userauthunsupported'] = 'إضافة المصادقة غير مدعومة هنا';
$string['useremailduplicate'] = 'العنوان مكرر';
$string['userisfilteredout'] = 'هذا المستخدم لا يطابق المرشحات وتفضيلات الجدول!';
$string['usermustbemnet'] = 'المستخدمون في قائمة السيطرة على الوصول لشبكة مودل لا بد أن يكونوا مستخدمين بعيدين لشبكة مودل';
$string['usernamelowercase'] = 'اسم المستخدم لا بد أن يكون بحروف لاتينية صغيرة';
$string['usernotaddederror'] = 'المستخدم لم تتم إضافته - خطأ';
$string['usernotaddedregistered'] = 'المستخدم لم تتم إضافته - مسجل مسبقاً';
$string['usernotaddedusernameexists'] = 'لم تتم إضافة المستخدم - اسم المستخدم سبق وأن تم استعماله مع عنوان بريد الكتروني آخر';
$string['usernotavailable'] = 'تفاصيل هذا المستخدم غير متاحة لك';
$string['usernotdeletedadmin'] = 'لم يتم حذف المُستخدم نظرًا لأن حسابات المشرفين لا يمكن حذفها.';
$string['usernotdeleteddeleted'] = 'هذا المستخدم سبق وأن تم حذفه.';
$string['usernotdeletederror'] = 'لم يتم حذف المُستخدم - خطأ';
$string['usernotdeletedmissing'] = 'لم يتم حذف المُستخدم - لا يمكن العثور على اسم المستخدم';
$string['usernotdeletedoff'] = 'لم يتم حذف المُستخدم -الحذف غير مسموح';
$string['usernotfullysetup'] = 'تهيئة حساب المستخدم لم تكتمل بعد';
$string['usernotincourse'] = 'هذا المستخدم ليس في هذا المساق!';
$string['usernotrenamedadmin'] = 'لا يمكن إعادة تسمية حسابات المشرف';
$string['usernotrenamedexists'] = 'لم يتم إعادة تسمية المستخدم - الاسم المُدخل الجديد مُستخدم حالياً';
$string['usernotrenamedmissing'] = 'لم يتم إعادة تسمية المستخدم - لم يتم إيجاد اسم المستخدم القديم';
$string['usernotrenamedoff'] = 'لم يتم إعادة تسمية المستخدم - إعادة التسمية غير مسموحة';
$string['usernotupdatedadmin'] = 'لا يمكن تحديث حسابات المشرفين';
$string['usernotupdatederror'] = 'المستخدم لم يتم تحديثه - خطأ';
$string['usernotupdatednotexists'] = 'لم يتم تحديث المُستخدم-المُستخدم غير موجود';
$string['userquotalimit'] = 'لقد وصلت إلى الحد الأقصى لحصتك النسبية من الملفات.';
$string['userselectortoomany'] = 'منتقي المستخدمين لديه أكثر من مستخدم تم اختياره، رغم أن خاصية تعدد الاختيار غير مفعلة.';
$string['verifyagedigitalconsentnotpossible'] = 'عذراً، موافقة التحقق من العمر الرقمي غير ممكنة حالياً.';
$string['wrongcall'] = 'هذا النص البرمجي مستدعَى بطريقة خاطئة';
$string['wrongcontextid'] = 'مُعرَّف السياق لم يكن صحيحاً (تعذر العثور عليه)';
$string['wrongdestpath'] = 'مسار الهدف خاطئ';
$string['wrongroleid'] = 'مُعرَّف الدور خاطئ!';
$string['wrongsourcebase'] = 'أساس رابط المصدر خاطئ';
$string['wrongusernamepassword'] = 'المستخدم غير صحيح / كلمة المرور';
$string['wrongzipfilename'] = 'تسمية الملف المضغوط خاطئة';
$string['wscouldnotcreateecoursenopermission'] = 'WS - لم تتمكن من إنشاء المقرر الدراسي - لا صلاحية';
$string['wwwrootmismatch'] = 'تم الكشف عن وصول غير صحيح. يمكن الوصول إلى هذا المخدم فقط عبر العنوان "{$a}"، عذراً.<br />لطفاً، أبلغ المشرف.';
$string['wwwrootpublic'] = 'تم الكشف عن إعداد $CFG->wwwroot خاطئ في الملف config.php، ينبغي أن لا ينتهي بـ /public. أنظر MDL-85816 لمزيد من المعلومات.';
$string['wwwrootslash'] = 'تم الكشف عن تعريف خاطئ لـ $CFG->wwwroot في ملف التهيئة config.php، لا ينبغي أن يحتوي على علامة شطب لاحقة.<br />لطفاً، أبلغ المشرف.';
$string['xmldberror'] = 'خطأ في XMLDB!';
$string['youcannotdeletecategory'] = 'لا يمكنك حذف التصنيف \'{$a}\' لأنه لا يمكنك حذف المحتويات، ولا نقلها في مكان آخر.';
