<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'qtype_stack', language 'no', version '5.0'.
 *
 * @package     qtype_stack
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['ATAlgEquiv_SA_not_equation'] = 'Svaret ditt skal være en likning, men er det ikke.';
$string['ATAlgEquiv_SA_not_expression'] = 'Svaret ditt skal være et uttrykk, ikke en likning, ulikhet, liste, mengde eller matrise.';
$string['ATAlgEquiv_SA_not_function'] = 'Svaret ditt skal være en funksjon, definert ved hjelp av operatoren <tt>:=</tt>, men er det ikke.';
$string['ATAlgEquiv_SA_not_inequality'] = 'Svaret ditt skal være en ulikhet, men er det ikke.';
$string['ATAlgEquiv_SA_not_list'] = 'Svaret ditt skal være en liste, men er det ikke. Merk at syntaksen for å legge inn en liste er å omslutte de kommaseparerte verdiene med firkantklammer.';
$string['ATAlgEquiv_SA_not_logic'] = 'Svaret ditt skal være en ligning, ulikhet eller en logisk kombinasjon av disse, men er det ikke.';
$string['ATAlgEquiv_SA_not_matrix'] = 'Svaret ditt skal være en matrise, men er det ikke.';
$string['ATAlgEquiv_SA_not_realset'] = 'Svaret ditt skal være en delmengde av de reelle tallene. Dette kan være en tallmengde, eller en samling av intervaller.';
$string['ATAlgEquiv_SA_not_set'] = 'Svaret ditt skal være en mengde, men er det ikke. Merk at syntaksen for å angi en mengde er å omslutte de kommaseparerte verdiene med krøllparenteser.';
$string['ATAlgEquiv_SA_not_string'] = 'Svaret ditt skal være en tekststreng, men er det ikke.';
$string['ATAlgEquiv_TA_not_equation'] = 'Du har lagt inn en ligning, men det forventes ikke en ligning her. Du kan ha skrevet noe sånt som "y=2*x+1" når du bare trengte å skrive "2*x+1".';
$string['ATCompSquare_SA_not_depend_var'] = 'Svaret ditt skal avhenge av variabelen {$a->m0}, men det gjør det ikke!';
$string['ATCompSquare_false_no_summands'] = 'Den utfylte firkanten har formen \\( a(\\cdots\\cdots)^2 + b\\) hvor \\(a\\) og \\(b\\) ikke avhenger av variabelen din. Mer enn én av summene dine ser ut til å avhenge av variabelen i svaret ditt.';
$string['ATCompSquare_not_AlgEquiv'] = 'Svaret ditt ser ut til å være på riktig form, men tilsvarer ikke det riktige svaret.';
$string['ATDiff_error_list'] = 'Svartesten mislyktes. Ta kontakt med systemadministratoren din';
$string['ATDiff_int'] = 'Det ser ut som du har integrert i stedet!';
$string['ATEqualComAssRules_Opt_Incompatible'] = 'Alternativet til denne svartesten inneholder inkompatible regler. Dette er en feil. Ta kontakt med læreren din.';
$string['ATEqualComAssRules_Opt_List'] = 'Alternativet til denne svartesten må være en ikke-tom liste over støttede regler. Dette er en feil. Ta kontakt med læreren din.';
$string['ATEquivFirst_SA_not_list'] = 'Det første argumentet til Equiv-svartesten skal være en liste, men testen mislyktes. Ta kontakt med læreren din.';
$string['ATEquivFirst_SA_wrong_end'] = 'Det endelige svaret ditt er ikke på riktig form.';
$string['ATEquivFirst_SA_wrong_start'] = 'Den første linjen i argumentet må være "{$a->m0}".';
$string['ATEquivFirst_SB_not_list'] = 'Det andre argumentet til Equiv svar-testen skal være en liste, men testen mislyktes. Ta kontakt med læreren din.';
$string['ATEquiv_SA_not_list'] = 'Det første argumentet til Equiv-svartesten skal være en liste, men testen mislyktes. Ta kontakt med læreren din.';
$string['ATEquiv_SB_not_list'] = 'Det andre argumentet til Equiv-svartesten skal være en liste, men testen mislyktes. Ta kontakt med læreren din.';
$string['ATFacForm_error_list'] = 'Svartesten mislyktes. Ta kontakt med systemadministratoren din';
$string['ATFacForm_isfactored'] = 'Svaret ditt er faktorisert, godt jobbet.';
$string['ATFacForm_notalgequiv'] = 'Merk at svaret ditt ikke er algebraisk ekvivalent med det riktige svaret. Du må ha gjort noe galt.';
$string['ATFacForm_notfactored'] = 'Svaret ditt er ikke faktorisert.';
$string['ATFacForm_notpoly'] = 'Dette leddet forventes å være et polynom, men er det ikke.';
$string['ATInequality_backwards'] = 'Ulikheten din ser ut til å være bakvendt.';
$string['ATInequality_nonstrict'] = 'Ulikheten skal være "større enn" eller "mindre enn".';
$string['ATInequality_strict'] = 'Ulikheten skal ikke være "større enn" eller "mindre enn".';
$string['ATInt_EqFormalDiff'] = 'Den deriverte av svaret ditt tilsvarer uttrykket du ble bedt om å integrere. Svaret ditt skiller seg imidlertid fra det riktige svaret på en betydelig måte, det vil si ikke bare, for eksempel en integrasjonskonstant. Spør læreren din om dette.';
$string['ATInt_STACKERROR_OptList'] = 'Svartesten ble ikke utført riktig: vennligst varsle læreren din. Når alternativet til ATInt er en liste, må den ha nøyaktig to elementer, men det har den ikke.';
$string['ATInt_const'] = 'Du må legge til en integrasjonskonstant, ellers ser dette ut til å være riktig. Bra jobbet.';
$string['ATInt_const_int'] = 'Du må legge til en integrasjonskonstant. Dette skal være en vilkårlig konstant, ikke et tall.';
$string['ATInt_diff'] = 'Det ser ut som du har derivert i stedet!';
$string['ATInt_error_list'] = 'Svartesten mislyktes. Ta kontakt med systemadministratoren din';
$string['ATInt_generic'] = 'Den deriverte av svaret skal være lik uttrykket du ble bedt om å integrere, det vil si: {$a->m0}. Den deriverte av svaret ditt, med hensyn til {$a->m1}, er { $a->m2}, så du må ha gjort noe galt!';
$string['ATInt_logabs'] = 'Den deriverte av svaret ditt tilsvarer uttrykket du ble bedt om å integrere. Svaret ditt skiller seg imidlertid fra det riktige svaret på en betydelig måte, det vil si ikke bare, for eksempel en integrasjonskonstant. Læreren din forventer kanskje at du bruker resultatet \\(\\int\\frac{1}{x} dx = \\log(|x|)+c\\), i stedet for \\(\\int\\frac{1}{x} dx = \\log(x)+c\\). Spør læreren din om dette.';
$string['ATInt_logabs_inconsistent'] = 'Det ser ut til å være merkelige uoverensstemmelser mellom din bruk av \\(\\log(...)\\) og \\(\\log(|...|)\\). Spør læreren din om dette.';
$string['ATInt_weirdconst'] = 'Den deriverte av svaret ditt tilsvarer uttrykket du ble bedt om å integrere. Du har imidlertid en merkelig integreringskonstant. Spør læreren din om dette.';
$string['ATLevenshtein_SA_not_string'] = 'Det første argumentet til Levenshtein-svartesten må være en streng. Testen mislyktes. Ta kontakt med læreren din.';
$string['ATLevenshtein_SB_malformed'] = 'Det andre argumentet til Levenshtein-svartesten må være på formen [allow, deny] der hvert element er en liste over strenger. Dette argumentet er feil utformet, og derfor mislyktes testen. Ta kontakt med læreren din.';
$string['ATLevenshtein_match'] = 'Det nærmeste var "{$a->m0}".';
$string['ATLevenshtein_tol_not_number'] = 'Toleransen i Levenshtein-svartesten må være et tall, men er det ikke. Testen mislyktes. Ta kontakt med læreren din.';
$string['ATLevenshtein_upper_not_boolean'] = 'Alternativet for store og små bokstaver i Levenshtein-svartesten må være boolsk, men er det ikke. Testen mislyktes. Ta kontakt med læreren din.';
$string['ATList_wrongentries'] = 'Oppføringene som er understreket med rødt nedenfor, er de som er feil. {$a->m0}';
$string['ATList_wronglen'] = 'Listen din skal ha {$a->m0} elementer, men den har {$a->m1}.';
$string['ATLowestTerms_entries'] = 'Følgende del av svaret ditt kan forkortes mer: {$a->m0}. Prøv igjen.';
$string['ATLowestTerms_not_rat'] = 'Du må fjerne følgende fra nevneren til brøken din: {$a->m0}';
$string['ATLowestTerms_wrong'] = 'Du må forkorte brøker i svaret ditt.';
$string['ATMatrix_wrongentries'] = 'Oppføringene som er understreket med rødt nedenfor, er de som er feil. {$a->m0}';
$string['ATMatrix_wrongsz'] = 'Matrisen din skal være {$a->m0} med {$a->m1}, men den er {$a->m2} ved {$a->m3}.';
$string['ATNumDecPlacesWrong_OptNotInt'] = 'For ATnumDecPlacesWrong må testalternativet være et positivt heltall, men "{$a->m0}" kom inn.';
$string['ATNumDecPlaces_Float'] = 'Svaret ditt skal være et flyttall, men er det ikke.';
$string['ATNumDecPlaces_NoDP'] = 'Svaret ditt skal være et desimaltall, inkludert et desimaltegn.';
$string['ATNumDecPlaces_OptNotInt'] = 'For ATnumDecPlaces må testalternativet være et positivt heltall, men "{$a->m0}" kom inn.';
$string['ATNumDecPlaces_Wrong_DPs'] = 'Svaret ditt er gitt med feil antall desimaler.';
$string['ATNumSigFigs_Inaccurate'] = 'Nøyaktigheten av svaret ditt er ikke riktig. Enten har du ikke rundet av riktig, eller så har du avrundet et mellomsvar som har gitt en følgefeil.';
$string['ATNumSigFigs_NotDecimal'] = 'Svaret ditt skal være et desimaltall, men er det ikke!';
$string['ATNumSigFigs_WrongDigits'] = 'Svaret ditt inneholder feil antall gjeldende sifre.';
$string['ATNumSigFigs_WrongSign'] = 'Svaret ditt har feil algebraisk tegn.';
$string['ATNumSigFigs_error_list'] = 'Svartesten mislyktes. Ta kontakt med systemadministratoren din';
$string['ATNum_OutofRange'] = 'Et numerisk uttrykk er utenfor det støttede området. Ta kontakt med læreren din.';
$string['ATNumerical_FAILED'] = 'Svaret ditt skal være et flyttall, eller en liste eller en mengde med tall. Det er det ikke.';
$string['ATNumerical_SA_not_list'] = 'Svaret ditt skal være en liste, men er det ikke. Merk at syntaksen for å legge inn en liste er å omslutte de kommaseparerte verdiene med firkantklammer.';
$string['ATNumerical_SA_not_number'] = 'Svaret ditt skal være et flyttall, men er det ikke.';
$string['ATNumerical_SA_not_set'] = 'Svaret ditt skal være en mengde, men er det ikke. Merk at syntaksen for å angi et sett er å omslutte de kommaseparerte verdiene med krøllparenteser.';
$string['ATNumerical_SB_not_number'] = 'Verdien som oppgis for lærerens svar skal være et flyttall, men er det ikke. Dette er en intern feil med testen. Spør læreren din om dette.';
$string['ATNumerical_STACKERROR_tol'] = 'Den numeriske toleransen for ATNumerical skal være et flyttall, men er det ikke. Dette er en intern feil med testen. Spør læreren din om dette.';
$string['ATPartFrac_denom_ret'] = 'Hvis svaret er skrevet som en enkelt brøk, vil nevneren være {$a->m0}. Den skulle vært {$a->m1}.';
$string['ATPartFrac_diff_variables'] = 'Variablene i svaret ditt er forskjellige fra de i spørsmålet, vennligst sjekk dem.';
$string['ATPartFrac_error_list'] = 'Svartesten mislyktes. Ta kontakt med systemadministratoren din';
$string['ATPartFrac_ret_expression'] = 'Svaret ditt som enkeltbrøk er {$a->m0}';
$string['ATSRegExp_SA_not_string'] = 'Det første argumentet til SRegExp-svartesten skal være en streng. Testen mislyktes. Ta kontakt med læreren din.';
$string['ATSRegExp_SB_not_string'] = 'Det andre argumentet til SRegExp-svartesten skal være en streng. Testen mislyktes. Ta kontakt med læreren din.';
$string['ATSet_wrongentries'] = 'Følgende oppføringer er feil, selv om de kan vises i en forenklet form fra det du faktisk skrev inn. {$a->m0}';
$string['ATSet_wrongsz'] = 'Mengden din skal ha {$a->m0} forskjellige elementer, men den har faktisk {$a->m1}.';
$string['ATSets_SA_not_set'] = 'Svaret ditt bør være en mengde, men er det ikke. Merk at syntaksen for å angi en mengde er å omslutte de kommaseparerte verdiene med krøllparenteser.';
$string['ATSets_SB_not_set'] = 'Svartesten "Sets" forventer at det andre argumentet er en mengde. Dette er en feil. Ta kontakt med læreren din.';
$string['ATSets_duplicates'] = 'Mengden din ser ut til å inneholde dupliserte oppføringer!';
$string['ATSets_missingentries'] = 'Følgende mangler i mengden din. {$a->m0}';
$string['ATSets_wrongentries'] = 'Disse oppføringene skal ikke være en del av mengden din. {$a->m0}';
$string['ATSingleFrac_div'] = 'Svaret ditt inneholder brudne brøker. Du må skrive svaret som en enkelt brøk.';
$string['ATSingleFrac_error_list'] = 'Svartesten mislyktes. Ta kontakt med systemadministratoren din';
$string['ATSingleFrac_part'] = 'Svaret ditt må være en enkelt brøk på formen \\( {a}\\over{b} \\).';
$string['ATSingleFrac_ret_exp'] = 'Svaret ditt tilsvarer ikke algebraisk det riktige svaret. Du må ha gjort noe galt.';
$string['ATSingleFrac_var'] = 'Variablene i svaret ditt er forskjellige fra de i spørsmålet, vennligst sjekk dem.';
$string['ATString_SA_not_string'] = 'Svaret ditt skal være en tekststreng, men er det ikke.';
$string['ATString_SB_not_string'] = 'Lærerens svar skal være en tekststreng, men er det ikke.';
$string['ATSubstEquiv_Opt_List'] = 'Alternativet til denne svartesten skal være en liste. Dette er en feil. Ta kontakt med læreren din.';
$string['ATSysEquiv_SA_extra_variables'] = 'Svaret ditt har for mange variabler!';
$string['ATSysEquiv_SA_missing_variables'] = 'Svaret ditt mangler en eller flere variabler!';
$string['ATSysEquiv_SA_not_eq_list'] = 'Svaret ditt skal være en liste med likninger, men det er det ikke!';
$string['ATSysEquiv_SA_not_list'] = 'Svaret ditt skal være en liste, men det er det ikke.';
$string['ATSysEquiv_SA_not_poly_eq_list'] = 'Én eller flere av likningene dine er ikke et polynom.';
$string['ATSysEquiv_SA_system_overdetermined'] = 'Oppføringene som er understreket med rødt nedenfor, er de som er feil. {$a->m0}';
$string['ATSysEquiv_SA_system_underdetermined'] = 'Likningene i systemet ditt ser ut til å være riktige, men du trenger andre i tillegg.';
$string['ATSysEquiv_SA_wrong_variables'] = 'Svaret ditt har feil variabler.';
$string['ATSysEquiv_SB_not_eq_list'] = 'Lærerens svar er ikke en liste over likninger, men skulle vært det.';
$string['ATSysEquiv_SB_not_list'] = 'Lærerens svar er ikke en liste. Ta kontakt med læreren din.';
$string['ATSysEquiv_SB_not_poly_eq_list'] = 'Lærerens svar skal være en liste over polynomlikninger, men er det ikke. Ta kontakt med læreren din.';
$string['ATUnits_SA_bad_units'] = 'Svaret ditt må ha enheter, og du må bruke multiplikasjon for å knytte enhetene til en verdi, f.eks. <code>3,2*m/s</code>.';
$string['ATUnits_SA_errorbounds_invalid'] = 'Svaret ditt har feilgrenser. Angi ikke feilgrenser i dette tilfellet, bruk i stedet bare antall og enheter.';
$string['ATUnits_SA_excess_units'] = 'Svaret ditt har brukt enheter (eller variabler), men det skal det ikke ha.';
$string['ATUnits_SA_no_units'] = 'Svaret ditt må ha enheter.';
$string['ATUnits_SA_not_expression'] = 'Svaret ditt må være et tall sammen med enheter. Ikke bruk mengder, lister, likninger eller matriser.';
$string['ATUnits_SA_only_units'] = 'Svaret ditt må være et tall sammen med enheter. Svaret ditt har bare enheter.';
$string['ATUnits_SO_wrong_units'] = 'Enhetene som er spesifisert for den numeriske toleransen må samsvare med enhetene som brukes for lærerens svar. Dette er en intern feil med testen. Spør læreren din om dette.';
$string['ATUnits_compatible_units'] = 'Enhetene dine er forskjellige fra de som brukes av læreren, men er kompatible med dem. Numeriske verdier konverteres til SI-basisenheter for sammenligning.';
$string['ATUnits_correct_numerical'] = 'Vennligst sjekk enhetene dine nøye.';
$string['ATUnits_incompatible_units'] = 'Enhetene dine er inkompatible med de som brukes av læreren.';
$string['AT_EmptySA'] = 'Forsøkte å utføre en svartest med et tomt elevsvar, sannsynligvis et CAS-valideringsproblem da spørsmålet ble skrevet.';
$string['AT_EmptyTA'] = 'Forsøkte å utføre en svartest med et tomt lærersvar, sannsynligvis et CAS-valideringsproblem da spørsmålet ble skrevet.';
$string['AT_InvalidOptions'] = 'Alternativfeltet er ugyldig. {$a->feil}';
$string['AT_MissingOptions'] = 'Manglende alternativ ved utføring av testen.';
$string['AT_raw_sans_needed'] = 'Noen svartester er avhengige av råinndata fra en student, og derfor bør "SAns"-feltet i noden være navnet på et spørsmålsinndata. Vennligst sjekk følgende (prt.node) som ser ut som en beregnet verdi i stedet: {$a->prt}';
$string['Bad_assignment'] = 'Når du viser verdiene til en variabel, bør du gjøre det på følgende måte: {$a->m0}. Vennligst endre dine inndata.';
$string['CommaError'] = 'Svaret ditt inneholder kommaer som ikke er en del av en liste, en mengde eller en matrise. <ul><li>Hvis du mente å skrive inn en liste, vennligst bruk <tt>{...}</tt>,</li><li>Hvis du mente å skrive inn en mengde, vennligst bruk <ul><li> tt>{...}</tt>.</li></ul>';
$string['Equiv_Illegal_list'] = 'Lister er ikke tillatt ved resonnement ved ekvivalens.';
$string['Equiv_Illegal_matrix'] = 'Matriser er ikke tillatt ved resonnement ved ekvivalens.';
$string['Equiv_Illegal_set'] = 'Mengder er ikke tillatt ved resonnement ved ekvivalens.';
$string['FacForm_UnPick_morework'] = 'Du kan fortsatt jobbe mer med leddet {$a->m0}.';
$string['Illegal_control_flow'] = 'Svaret ditt inneholder kontrollflyt-setninger som <code>if</code>-betinget eller <code>do</code>-løkken, disse er forbudt her, du må sannsynligvis gi resultatet av disse setningene som svar.';
$string['Illegal_floats'] = 'Svaret ditt inneholder flyttall, som ikke er tillatt her. Du må skrive inn tall som brøker. For eksempel bør du skrive 1/3 ikke 0,3333, som tross alt bare er en tilnærming til en tredjedel.';
$string['Illegal_groupping'] = 'Svaret ditt inneholder parenteser som brukes til å gruppere operasjoner, disse er forbudt her. Du bør sannsynligvis skrive om uttrykket og fjerne dem.';
$string['Illegal_groups'] = 'Svaret ditt inneholder evalueringsgrupper "(a,b,c)" disse er ikke tillatt her.';
$string['Illegal_identifiers_in_units'] = 'Inndataene inneholder et variabelnavn når bare enheter var forventet.';
$string['Illegal_illegal_operation_in_units'] = 'Operatoren <code>{$a}</code> er ikke tillatt i denne inngangen.';
$string['Illegal_illegal_power_of_ten_in_units'] = 'Verdien kan ikke inneholde ikke-heltallige potenser av 10.';
$string['Illegal_input_form_units'] = 'Denne innverdien forventer en numerisk verdi etterfulgt eller multiplisert med et uttrykk som definerer en enhet, f.eks. <code>1,23*W/m^2</code>. Merk at enheten som kreves her kan være noe annet.';
$string['Illegal_lists'] = 'Svaret ditt inneholder lister "[a,b,c]", disse er ikke tillatt her.';
$string['Illegal_sets'] = 'Svaret ditt inneholder mengder "{a,b,c}", disse er ikke tillatt her.';
$string['Illegal_singleton_floats'] = 'Denne inndata aksepterer ikke desimaltall i den gitte formen. Denne inndata krever en numerisk verdi presentert i en av følgende former: <code>{$a->forms}</code>';
$string['Illegal_singleton_integer'] = 'Denne inndata godtar ikke heltallsverdier. Denne inndata krever en numerisk verdi presentert i en av følgende former: <code>{$a->forms}</code>';
$string['Illegal_singleton_power'] = 'Denne inndata krever en numerisk verdi presentert i en av følgende former: <code>{$a->forms}</code>';
$string['Illegal_strings'] = 'Svaret ditt inneholder "tekststrenger", disse er ikke tillatt her.';
$string['Illegal_x10'] = 'Svaret ditt ser ut til å bruke tegnet "x" som multiplikasjonstegn. Vennligst bruk <code>*</code> for multiplikasjon.';
$string['Interval_backwards'] = 'I et intervall må endepunktene stå i riktig rekkefølge. {$a->m0} skal være {$a->m1}.';
$string['Interval_illegal_entries'] = 'Mengder skal ikke inneholde følgende: {$a->m0}';
$string['Interval_notinterval'] = 'Det var forventet et intervall, men i stedet har vi {$a->m0}.';
$string['Interval_wrongnumargs'] = 'Intervallkonstruksjon må ha nøyaktig to argumenter, så dette må være en feil: {$a->m0}.';
$string['Lowest_Terms'] = 'Svaret ditt inneholder brøker som ikke er forkortet. Vennligst stryk faktorer og prøv igjen.';
$string['Maxima_Args'] = 'args: argument må være et ikke-atomisk uttrykk.';
$string['Maxima_DivisionZero'] = 'Divisjon med null.';
$string['Subst'] = 'Svaret ditt ville vært riktig hvis du byttet ut variablene som følger. {$a->m0}';
$string['TEST_FAILED'] = 'Svartesten ble ikke utført riktig: vennligst varsle læreren din. {$a->feil}';
$string['TEST_FAILED_Q'] = 'Svartesten ble ikke utført riktig: vennligst varsle læreren din.';
$string['ValidateVarsMissing'] = 'Disse variablene mangler: {$a->m0}.';
$string['ValidateVarsSpurious'] = 'Disse variablene er ikke nødvendige: {$a->m0}.';
$string['Variable_function'] = 'Følgende vises i uttrykket ditt som både en variabel og en funksjon: {$a->m0}. Vennligst presiser inndataene dine. Sett inn <code>*</code>-symboler for å fjerne funksjoner, eller få alle forekomster til å fungere.';
$string['addanothernode'] = 'Legg til en ny node';
$string['addanothertestcase'] = 'Legg til et nytt testtilfelle...';
$string['addatestcase'] = 'Legg til et testtilfelle';
$string['addingatestcase'] = 'Legger til et testtilfelle i spørsmålet {$a}';
$string['alg_indices_fact'] = 'Følgende lover gjelder for potenser:
\\[a^ma^n = a^{m+n}\\]
\\[\\frac{a^m}{a^n} = a^{m-n}\\]
\\[(a^m)^n = a^{mn}\\]
\\[a^0 = 1\\]
\\[a^{-m} = \\frac{1}{a^m}\\]
\\[a^{\\frac{1}{n}} = \\sqrt[n]{a}\\]
\\[a^{\\frac{m}{n}} = \\left(\\sqrt[n]{a}\\right)^m\\]';
$string['alg_indices_name'] = 'Potensreglene';
$string['alg_inequalities_fact'] = '\\[a>b \\hbox{ betyr } a \\hbox{ er større enn } b.\\]
\\[ a < b \\hbox{ betyr } a \\hbox{ er mindre enn } b.\\]
\\[a\\geq b \\hbox{ betyr } a \\hbox{ er større enn eller lik } b.\\]
\\[a\\leq b \\hbox{ betyr } a \\hbox{ er mindre enn eller lik } b.\\]';
$string['alg_inequalities_name'] = 'Ulikheter';
$string['alg_logarithms_fact'] = 'For en vilkårlig base \\(c>0\\) med \\(c \\neq 1\\):
\\[\\log_c(a) = b \\mbox{, betyr } a = c^b\\]
\\[\\log_c(a) + \\log_c(b) = \\log_c(ab)\\]
\\[\\log_c(a) - \\log_c(b) = \\log_c\\left(\\frac{a}{c}\\right)\\]
\\[n\\log_c(a) = \\log_c\\venstre(a^n\\høyre)\\]
\\[\\log_c(1) = 0\\]
\\[\\log_c(b) = 1\\]
Formelen for endring av base er:
\\[\\log_a(x) = \\frac{\\log_b(x)}{\\log_b(a)}\\]
Logaritmer til base \\(e\\), betegnet \\(\\log_e\\) eller alternativt \\(\\ln\\) kalles naturlige logaritmer. Bokstaven \\(e\\) representerer eksponentialkonstanten som er ca \\(2.718\\).';
$string['alg_logarithms_name'] = 'Logaritmereglene';
$string['alg_partial_fractions_fact'] = 'Ekte brøker er \\[{\\frac{P(x)}{Q(x)}}\\]
når \\(P\\) og \\(Q\\) er polynomer og graden av \\(P\\) er lavere enn graden av \\(Q\\). I denne saken fortsetter vi
som følger: skriv \\(Q(x)\\) i faktorisert form,

* en <em>lineær faktor</em> \\(ax+b\\) i nevneren gir en delbrøk av formen \\[{\\frac{A}{ax+b}}.\\]
* a <em>gjentatte lineære faktorer</em> \\((ax+b)^2\\) i nevneren
gir delbrøker av formen \\[{A\\over øks+b}+{B\\over (ax+b)^2}.\\]
* en <em>andregradsfaktor</em> \\(ax^2+bx+c\\)
i nevneren produserer en delbrøk av
formen \\[{Ax+B\\over ax^2+bx+c}\\]
* <em>Uekte brøker</em> krever et ekstra ledd som er et polynom av grad \\(n-d\\) hvor \\(n\\) er
graden av telleren (dvs. \\(P(x)\\)) og \\(d\\) er graden av
nevneren (dvs. \\(Q(x)\\)).';
$string['alg_partial_fractions_name'] = 'Delbrøker';
$string['alg_quadratic_formula_fact'] = 'Hvis vi har en andregradslikning av formen:
\\[ax^2 + bx + c = 0,\\]
så er løsningen(e) til likningen gitt av andregradsformelen:
\\[x = \\frac{-b \\pm \\sqrt{b^2 - 4ac}}{2a}.\\]';
$string['alg_quadratic_formula_name'] = 'Andregradsformelen';
$string['all'] = 'Alle';
$string['allnodefeedbackmustusethesameformat'] = 'All tilbakemelding for alle nodene i en PRT må bruke samme tekstformat.';
$string['allowwords'] = 'Tillatte ord';
$string['allowwords_help'] = 'Som standard er vilkårlige funksjons- eller variabelnavn på mer enn to tegn ikke tillatt. Dette er en kommadelt liste over funksjons- eller variabelnavn som er tillatt i en elevs svar.';
$string['allowwords_link'] = '%%WWWROOT%%/question/type/stack/doc/doc.php/Authoring/Inputs.md#Allow_Words';
$string['alreadydeployed'] = 'En variant som samsvarer med dette spørsmålsnotatet er allerede distribuert.';
$string['alttextmissing'] = 'Ett eller flere bilder ser ut til å ha en manglende eller tom \'alt\'-tag i "{$a->field}" ({$a->num}).';
$string['ansnotemismatch'] = '[Svarnotat stemmer ikke overens]';
$string['answernote'] = 'Svarnotat';
$string['answernote_err'] = 'Svarnotater kan ikke inneholde tegnet |. Dette tegnet settes inn av STACK og brukes senere til å dele svarnotater automatisk.';
$string['answernote_err2'] = 'Svarnotater kan ikke inneholde ; eller : tegn. Disse tegnene brukes til å dele sammendragsstrenger for spørsmålsforsøk i frakoblede rapporteringsverktøy.';
$string['answernote_help'] = 'Dette er en tag som er viktig for rapporteringsformål. Den er designet for å registrere den unike banen gjennom treet, og resultatet av hver svartest. Dette genereres automatisk, men kan endres til noe mer forklarende.';
$string['answernote_link'] = '%%WWWROOT%%/question/type/stack/doc/doc.php/Authoring/Potential_response_trees.md#Answer_note';
$string['answernoterequired'] = 'Svarnotatet må ikke være tomt.';
$string['answernoteunique'] = 'Dupliserte svarnotater oppdaget i dette potensiellresponstreet.';
$string['answertest'] = 'Svartest';
$string['answertest_ab'] = 'Test';
$string['answertest_help'] = 'En svartest brukes til å sammenligne to uttrykk for å fastslå om de tilfredsstiller noen matematiske kriterier.';
$string['answertest_link'] = '%%WWWROOT%%/question/type/stack/doc/doc.php/Authoring/Answer_Tests/index.md';
$string['assumepositive'] = 'Anta positiv';
$string['assumepositive_help'] = 'Dette alternativet setter verdien til Maximas assume_pos-variabel.';
$string['assumepositive_link'] = '%%WWWROOT%%/question/type/stack/doc/doc.php/Authoring/Options.md#Assume_Positive';
$string['assumereal'] = 'Anta reell';
$string['assumereal_help'] = 'Dette alternativet setter assume_real-variabelen.';
$string['assumereal_link'] = '%%WWWROOT%%/question/type/stack/doc/doc.php/Authoring/Options.md#Assume_Real';
$string['autosimplify_link'] = '%%WWWROOT%%/question/type/stack/doc/doc.php/CAS/Maxima.md#Simplification';
$string['autosimplifyprt_link'] = '%%WWWROOT%%/question/type/stack/doc/doc.php/CAS/Maxima.md#Simplification';
$string['boxsize_link'] = '%%WWWROOT%%/question/type/stack/doc/doc.php/Authoring/Inputs.md#Box_Size';
$string['checkanswertype_link'] = '%%WWWROOT%%/question/type/stack/doc/doc.php/Authoring/Inputs.md#Check_Type';
$string['complexno_link'] = '%%WWWROOT%%/question/type/stack/doc/doc.php/Authoring/Options.md#sqrt_minus_one.';
$string['feedbackstyle_link'] = '%%WWWROOT%%/question/type/stack/doc/doc.php/Authoring/Potential_response_trees.md';
$string['feedbackvariables_link'] = '%%WWWROOT%%/question/type/stack/doc/doc.php/Authoring/Variables.md#Feedback_variables';
$string['forbidfloat_link'] = '%%WWWROOT%%/question/type/stack/doc/doc.php/Authoring/Inputs.md#Forbid_Floats';
$string['forbidwords_link'] = '%%WWWROOT%%/question/type/stack/doc/doc.php/Authoring/Inputs.md#Forbidden_Words';
$string['generalfeedback_link'] = '%%WWWROOT%%/question/type/stack/doc/doc.php/Authoring/CASText.md#general_feedback';
$string['inputextraoptions_link'] = '%%WWWROOT%%/question/type/stack/doc/doc.php/Authoring/Inputs.md#Extra options';
$string['inputtype_link'] = '%%WWWROOT%%/question/type/stack/doc/doc.php/Authoring/Inputs.md';
$string['insertstars_link'] = '%%WWWROOT%%/question/type/stack/doc/doc.php/Authoring/Inputs.md#Insert_Stars';
$string['inversetrig_link'] = '%%WWWROOT%%/question/type/stack/doc/doc.php/Authoring/Options.md#inverse_trig';
$string['logicsymbol_link'] = '%%WWWROOT%%/question/type/stack/doc/doc.php/Authoring/Options.md#logicsymbol';
$string['matrixparens_link'] = '%%WWWROOT%%/question/type/stack/doc/doc.php/CAS/Matrix.md#matrixparens';
$string['multiplicationsign_link'] = '%%WWWROOT%%/question/type/stack/doc/doc.php/Authoring/Options.md#multiplication';
$string['mustverify_link'] = '%%WWWROOT%%/question/type/stack/doc/doc.php/Authoring/Inputs.md#Student_must_verify';
$string['penalty_link'] = '%%WWWROOT%%/question/type/stack/doc/doc.php/Authoring/Feedback.md';
$string['questionnote_link'] = '%%WWWROOT%%/question/type/stack/doc/doc.php/Authoring/Question_note.md';
$string['questionsimplify_link'] = '%%WWWROOT%%/question/type/stack/doc/doc.php/CAS/Maxima.md#Simplification';
$string['questiontext_link'] = '%%WWWROOT%%/question/type/stack/doc/doc.php/Authoring/CASText.md#question_text';
$string['questionvariables_link'] = '%%WWWROOT%%/question/type/stack/doc/doc.php/Authoring/Variables.md#Question_variables';
$string['requirelowestterms_link'] = '%%WWWROOT%%/question/type/stack/doc/doc.php/Authoring/Inputs.md#Require_lowest_terms';
$string['sans_link'] = '%%WWWROOT%%/question/type/stack/doc/doc.php/Authoring/Answer_Tests/index.md';
$string['showvalidation_link'] = '%%WWWROOT%%/question/type/stack/doc/doc.php/Authoring/Inputs.md#Show_validation';
$string['sqrtsign_link'] = '%%WWWROOT%%/question/type/stack/doc/doc.php/Authoring/Options.md#surd';
$string['strictsyntax'] = 'Bestemt syntaks';
$string['strictsyntax_help'] = 'Dette alternativet brukes ikke lenger og vil bli fjernet.';
$string['strictsyntax_link'] = '%%WWWROOT%%/question/type/stack/doc/doc.php/';
$string['strlengtherror'] = 'Denne tekststrengen kan ikke overstige 255 tegn.';
$string['studentValidation_invalidAnswer'] = 'Ugyldig svar.';
$string['studentValidation_listofunits'] = 'Enhetene som ble funnet i svaret ditt var: {$a}';
$string['studentValidation_listofvariables'] = 'Variablene som ble funnet i svaret ditt var: {$a}';
$string['studentValidation_notes'] = '(Denne inndataen vurderes ikke automatisk av STACK.)';
$string['studentValidation_yourLastAnswer'] = 'Det siste svaret ditt ble tolket som {$a}';
$string['studentanswer'] = 'Studentens svar';
$string['switchtovariant'] = 'Bytt til variant:';
$string['symbolicprtcorrectfeedback'] = '';
$string['syntaxattribute'] = 'Hint-egenskap';
$string['syntaxattribute_help'] = 'Syntakshintet vil vises som en redigerbar *verdi* eller en ikke-redigerbar *plassholder*.';
$string['syntaxattribute_link'] = '%%WWWROOT%%/question/type/stack/doc/doc.php/Authoring/Inputs.md#Syntax_Hint';
$string['syntaxattributeplaceholder'] = 'Plassholder';
$string['syntaxattributevalue'] = 'Verdi';
$string['syntaxhint'] = 'Syntakshint';
$string['syntaxhint_help'] = 'Syntakstipset vil vises i svarboksen hver gang studenten lar  dette stå tomt.';
$string['syntaxhint_link'] = '%%WWWROOT%%/question/type/stack/doc/doc.php/Authoring/Inputs.md#Syntax_Hint';
$string['tans_help'] = 'Dette er det andre argumentet til svartestfunksjonen. I asymmetriske tester anses dette å være "lærerens svar", selv om det kan være et hvilket som helst gyldig CAS-uttrykk, og kan avhenge av spørsmålsvariablene eller tilbakemeldingsvariablene.';
$string['tans_link'] = '%%WWWROOT%%/question/type/stack/doc/doc.php/Authoring/Answer_Tests/index.md';
$string['tansrequired'] = 'TAns må oppgis.';
$string['teacheranswer'] = 'Lærers svar';
$string['teacheranswercase'] = 'Bruk lærers svar som testcase';
$string['teacheranswerempty'] = 'Denne trenger ikke oppgis.';
$string['teacheranswershow'] = 'Et riktig svar er \\( {$a->display} \\), som kan skrives inn som følger: {$a->value}';
$string['teacheranswershow_disp'] = 'Et riktig svar er {$a->display}.';
$string['teacheranswershow_mcq'] = 'Et riktig svar er: {$a->display}.';
$string['teacheranswershownotes'] = 'Det er dessverre ikke mulig å oppgi et riktig svar på oppgaven.';
$string['teachersanswer_help'] = 'Læreren må angi et modellsvar for hver input. Dette må være en gyldig Maxima-streng, og spørsmålsvariablene kan brukes som en del av det.';
$string['teachersanswer_link'] = '%%WWWROOT%%/question/type/stack/doc/doc.php/Authoring/Inputs.md#model_answer';
$string['testallincategory'] = 'Test alle spørsmålene i denne kategorien';
$string['testalltitle'] = 'Test alle spørsmålene i denne sammenhengen';
$string['testingquestion'] = 'Tester spørsmål {$a}';
$string['testingquestionvariants'] = 'Forbereder spørsmålsvarianter';
$string['testinputs'] = 'Test-inndata';
$string['testinputsimpwarning'] = 'Vær oppmerksom på at test-inndata alltid er <em>uforenklet</em> uavhengig av spørsmålet eller PRT-alternativinnstillingen. Vennligst bruk <tt>ev(...,simp)</tt> for å forenkle deler av eller alle test-inndatauttrykkene.';
$string['testoptions'] = 'Testalternativer';
$string['testoptions_help'] = 'Her kan læreren notere ned formålet med testen';
$string['testoptions_link'] = '%%WWWROOT%%/question/type/stack/doc/doc.php/Authoring/Potential_response_trees.md';
$string['testoptionsinvalid'] = 'Testalternativene er ugyldige: {$a}';
$string['testoptionsrequired'] = 'Testalternativer kreves for denne testen.';
$string['testpassesandfails'] = '{$a->passes} bestått og {$a->fails} feil.';
$string['testsuitecolerror'] = 'CAS-feil';
$string['testsuitecolmark'] = 'Karakter';
$string['testsuitefeedback'] = 'Tilbakemelding';
$string['testsuitenotests'] = 'Antall tester: {$a->no}.';
$string['testsuiteteststook'] = 'Testene tok {$a->time} sekunder.';
$string['testsuiteteststookeach'] = 'Gjennomsnitt per test: {$a->time} sekunder.';
$string['testthisvariant'] = 'Bytt til å teste denne varianten';
$string['texdisplaystyle'] = 'Display-likning';
$string['texinlinestyle'] = 'Inline-likning';
$string['tidyquestionx'] = 'Gi nytt navn til delene av spørsmålet {$a}';
$string['todowarning'] = 'Du har uløste gjøremålsblokker i "{$a->field}".';
$string['trig_degrees_radians_name'] = 'Grader og radianer';
$string['trig_standard_identities_name'] = 'Standard trigonometriske identiteter';
$string['trig_standard_values_name'] = 'Standard trigonometriske verdier';
$string['true'] = 'Sann';
$string['truebranch'] = 'Sann gren';
$string['truebranch_help'] = 'Disse feltene styrer hva som skjer når svarprøven blir bestått
### Mod og poengsum
Hvordan poengsummen justeres. = betyr å sette poengsummen til en bestemt verdi, +/- betyr å legge til eller trekke fra den gitte poengsummen fra gjeldende total.

### Straffepoeng
Hvor mange straffepoeng som skal gis i adaptiv eller interaktiv modus.

### Neste
Om du skal gå til en annen node, og i så fall hvilken, eller stoppe.

### Svarnotat
Dette er en tag som er viktig for rapporteringsformål. Den er designet for å registrere den unike banen gjennom treet, og resultatet av hver svartest. Dette navnet genereres automatisk, men kan endres til noe meningsfullt.';
$string['unauthorisedbulktest'] = 'Ingen tilgang til STACK-spørsmål';
$string['undeploy'] = 'Angre utplassering';
$string['unknown_block'] = 'Ukjent blokk av typen {$a->type} forespurt!';
$string['unrecognisedfactstags'] = 'Følgende fakta-tag(er) gjenkjennes ikke: {$a->tags}.';
$string['variantsselectionseed'] = 'random-gruppe';
$string['variantsselectionseed_help'] = 'Normalt kan du la denne boksen stå tom. Hvis du derimot vil at to forskjellige spørsmål i en quiz skal bruke samme random seed, skriv inn den samme tekststrengen i denne boksen for de to spørsmålene (og distribuer det samme settet med random seeds, hvis du bruker utplasserte varianter) og random seeds for de to spørsmålene vil bli synkronisert.';
$string['verifyquestionandupdate'] = 'Bekreft spørsmålsteksten og oppdater skjemaet';
$string['version'] = 'Versjon';
$string['yamlrecommended'] = 'Installering av YAML-biblioteket anbefales for STACK.';
$string['youmustconfirm'] = 'Du må godta her.';
