<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'glossary', language 'zh_cn', version '4.5'.
 *
 * @package     glossary
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['addcategory'] = '添加类别';
$string['addcomment'] = '添加评论';
$string['addentry'] = '添加新词条';
$string['addingcomment'] = '添加一条评论';
$string['addsingleentry'] = '在通知公告中使用课程全称';
$string['alias'] = '关键词';
$string['aliases'] = '关键词';
$string['aliases_help'] = '词汇表中的每个词条都可以与一些关键词（或别名）相关联。如果词条被自动链接，那么关键词也会被自动链接。

每个关键词独占一行（不是以逗号分割）。';
$string['allcategories'] = '所有类别';
$string['allentries'] = '全部';
$string['allowcomments'] = '允许评论词条';
$string['allowcomments_help'] = '如启用，有写评论权限的用户都可以为词条撰写评论。';
$string['allowduplicatedentries'] = '允许词条重复';
$string['allowduplicatedentries_help'] = '如果启用，则多个词条可以使用相同的词名。';
$string['allowprintview'] = '允许打印视图';
$string['allowprintview_help'] = '如果启用，会向学生提供适合打印的词汇表页面链接。此链接永远对教师可见。';
$string['andmorenewentries'] = '还有 {$a} 个新词条。';
$string['answer'] = '答案';
$string['approvaldisplayformat'] = '接受显示格式';
$string['approvaldisplayformat_help'] = '当接受词汇表项时您可能希望使用不同的显示格式';
$string['approve'] = '接受';
$string['areaattachment'] = '附件';
$string['areaentry'] = '定义';
$string['areyousuredelete'] = '您确定要删除该词条吗？';
$string['areyousuredeletecomment'] = '您确定要删除该评论吗?';
$string['areyousureexport'] = '您确定将该词条导出到';
$string['ascending'] = '升序';
$string['attachment'] = '附件';
$string['attachment_help'] = '您可以为每个词条附带一个或多个文件。';
$string['author'] = '作者';
$string['authorview'] = '按作者浏览';
$string['back'] = '返回';
$string['cachedef_concepts'] = '概念连接';
$string['cantinsertcat'] = '不能插入类别';
$string['cantinsertrec'] = '不能插入记录';
$string['cantinsertrel'] = '不能插入 类别-词条 关系';
$string['casesensitive'] = '此词条区分大小写';
$string['casesensitive_help'] = '此设置决定在自动链接词条时，是否要大小写完全匹配。';
$string['cat'] = '类别';
$string['categories'] = '类别';
$string['category'] = '类别';
$string['categorydeleted'] = '类别已删除';
$string['categoryview'] = '按类别浏览';
$string['changeto'] = '变为{$a}';
$string['cnfallowcomments'] = '设定词汇表是否缺省允许评论词条';
$string['cnfallowdupentries'] = '设定词汇表是否缺省允许同名词条';
$string['cnfapprovalstatus'] = '设定学生提交的词条的缺省接受状态';
$string['cnfcasesensitive'] = '设定链接词条时是否缺省大小写敏感';
$string['cnfdefaulthook'] = '选择第一次浏览词汇表时的缺省视图。';
$string['cnfdefaultmode'] = '选择第一次浏览词汇表时的缺省框架。';
$string['cnffullmatch'] = '设定词条在自动链接时是否缺省大小写完全匹配';
$string['cnflinkentry'] = '设定词条是否缺省被自动链接';
$string['cnflinkglossaries'] = '设定词汇表是否缺省被自动链接';
$string['cnfrelatedview'] = '选择自动链接和查看词条时的显示格式。';
$string['cnfshowgroup'] = '设定是否分组显示。';
$string['cnfsortkey'] = '选择缺省排序方式。';
$string['cnfsortorder'] = '选择缺省的排序顺序。';
$string['cnfstudentcanpost'] = '设定学生是否缺省能提交词条';
$string['cnftabs'] = '为此术语表格式选择可见选项卡';
$string['comment'] = '评论';
$string['commentdeleted'] = '评论已删除。';
$string['comments'] = '评论';
$string['commentson'] = '评论：';
$string['commentupdated'] = '该评论已更新。';
$string['completiondetail:entries'] = '创建条目：{$a}';
$string['completionentries'] = '创建条目：';
$string['completionentriesdesc'] = '学生必须创建至少{$a}个条目';
$string['completionentriesgroup'] = '必建词条';
$string['concept'] = '词条名';
$string['concepts'] = '词名';
$string['configenablerssfeeds'] = '这个选项使所有词汇表都可以使用 RSS 功能。但还必须手工开启每个词汇表中的设置。';
$string['current'] = '当前排序按{$a}';
$string['currentglossary'] = '当前词汇表';
$string['date'] = '日期';
$string['dateview'] = '按时间浏览';
$string['defaultapproval'] = '缺省为接受';
$string['defaultapproval_help'] = '如果设为否，那么只有教师接受的词条才能被所有人看到。';
$string['defaulthook'] = '默认钩子';
$string['defaultmode'] = '默认模式';
$string['defaultsortkey'] = '默认排序列';
$string['defaultsortorder'] = '默认排序顺序';
$string['definition'] = '定义';
$string['definitions'] = '定义';
$string['deletecategory'] = '删除类别';
$string['deleteentry'] = '删除词条';
$string['deleteentrya'] = '删除条目：{$a}';
$string['deletenotenrolled'] = '未选课用户的词条';
$string['deletingcomment'] = '删除评论';
$string['deletingnoneemptycategory'] = '删除类别不会删除它包含的词条——它们将会被标记为未分类。';
$string['descending'] = '降序';
$string['destination'] = '词条导入目标';
$string['destination_help'] = '词条可以导入到当前词汇表，也可以导入到新词汇表。新词汇表会按 XML 文件中的信息创建。';
$string['disapprove'] = '取消审核';
$string['displayformat'] = '显示格式';
$string['displayformat_help'] = '有 7 种显示格式：

* 简单字典风格 - 不显示作者，附件显示为链接
* 连续（不含作者）- 词条后面跟着词条，除了编辑图标，没有任何分隔
* 详细（含作者）- 论坛一样的显示格式，显示作者信息，附件显示为链接
* 详细（不含作者）- 论坛一样的显示格式，不显示作者信息，附件显示为链接
* 百科全书 - 同“详细（含作者）”类似，但附件中的图片会直接内嵌显示
* 词条列表 - 以链接的形式列出所有词名
* 常见问题 - 在词名和定义后自动附加“问题”和“解答”字样';
$string['displayformatcontinuous'] = '连续（不含作者）';
$string['displayformatdefault'] = '默认显示格式相同';
$string['displayformatdictionary'] = '简单字典风格';
$string['displayformatencyclopedia'] = '百科全书';
$string['displayformatentrylist'] = '词条列表';
$string['displayformatfaq'] = '常见问题';
$string['displayformatfullwithauthor'] = '详细（含作者）';
$string['displayformatfullwithoutauthor'] = '详细（不含作者）';
$string['displayformats'] = '显示格式';
$string['displayformatssetup'] = '显示格式设置';
$string['duplicatecategory'] = '类别重名';
$string['duplicateentry'] = '词条重名';
$string['editalways'] = '总允许编辑';
$string['editalways_help'] = '此设置决定词条是永远可编辑还是学生只能在指定的时间窗口（通常 30 分钟）内编辑他们的词条。';
$string['editcategories'] = '编辑类别';
$string['editcategory'] = '编辑类别';
$string['editentry'] = '编辑词条';
$string['editentrya'] = '编辑条目：{$a}';
$string['editingcomment'] = '编辑评论';
$string['entbypage'] = '每页显示词条数';
$string['entries'] = '词条';
$string['entrieswithoutcategory'] = '未分类词条';
$string['entry'] = '词条';
$string['entryalreadyexist'] = '词条已存在';
$string['entryapproved'] = '该词条已被接受';
$string['entrydeleted'] = '词条已删除';
$string['entryexported'] = '词条成功导出';
$string['entryishidden'] = '（此词条处于隐藏状态）';
$string['entryleveldefaultsettings'] = '词条级的缺省设置';
$string['entrylink'] = '条目链接：{$a}';
$string['entrynotapproved'] = '入境申请未获批准';
$string['entrysaved'] = '词条已保存';
$string['entryupdated'] = '词条已更新';
$string['entryusedynalink'] = '此词条可自动链接';
$string['entryusedynalink_help'] = '如果管理员启用了全站词汇表自动链接功能，且此复选框被勾选，那么在课程中出现的所有词名都会被自动链接到词条。';
$string['errcannoteditothers'] = '您不能编辑其他人的词条。';
$string['errconceptalreadyexists'] = '此词条名已存在。此词汇表中不允许使用相同词条名。';
$string['errdeltimeexpired'] = '您不能删除它。时限已到！';
$string['erredittimeexpired'] = '该词条的编辑时间已过。';
$string['errorparsingxml'] = '解析文件发生错误。请确认 XML 语法正确。';
$string['errreservedkeywords'] = '一个或多个关键字包含不能使用的特殊字符。';
$string['eventcategorycreated'] = '分类已创建';
$string['eventcategorydeleted'] = '分类已删除';
$string['eventcategoryupdated'] = '分类已更新';
$string['evententryapproved'] = '条目已审核';
$string['evententrycreated'] = '条目已创建';
$string['evententrydeleted'] = '条目已删除';
$string['evententrydisapproved'] = '条目未接受';
$string['evententryupdated'] = '条目已更新';
$string['evententryviewed'] = '条目已查看';
$string['explainaddentry'] = '向当前词汇表添加新词条。<br />词名和定义是必填项目。';
$string['explainall'] = '在一页中显示所有词条';
$string['explainalphabet'] = '按索引浏览词汇表';
$string['explainexport'] = '点击下面按钮导出词条。<br />您可以随时在此课程或其它课程导入它。<p>请注意，附件（比如图片）和作者没有导出。</p>';
$string['explainimport'] = '您必须指定要导入的文件及导入标准。<p>提交您的请求并查看结果。</p>';
$string['explainspecial'] = '显示以非字母字符开头的词条';
$string['export'] = '导出';
$string['exportedentry'] = '已导出词条';
$string['exportentries'] = '导出词条';
$string['exportentriestoxml'] = '导出词条到 XML 文件';
$string['exportfile'] = '导出词条到文件';
$string['exportglossary'] = '导出词汇表';
$string['exporttomainglossary'] = '导出到主词汇表';
$string['filetoimport'] = '从文件导入';
$string['filetoimport_help'] = '从您的电脑浏览并选择要导入词条所属的 XML 文件。';
$string['fillfields'] = '词条名和定义都是必填字段。';
$string['filtername'] = '词汇表自动链接';
$string['fullmatch'] = '整词匹配';
$string['fullmatch_help'] = '此设置决定是否只链接整个词，例如，不会将单词“constructivism”指向“construct”词条。';
$string['glossary:addinstance'] = '添加一个新词汇表';
$string['glossary:approve'] = '审核及取消审核条目';
$string['glossary:comment'] = '添加评论';
$string['glossary:export'] = '导出词条';
$string['glossary:exportentry'] = '导出单个词条';
$string['glossary:exportownentry'] = '导出您的单个词条';
$string['glossary:import'] = '导入词条';
$string['glossary:managecategories'] = '管理类别';
$string['glossary:managecomments'] = '管理评论';
$string['glossary:manageentries'] = '管理词条';
$string['glossary:rate'] = '评价词条';
$string['glossary:view'] = '查看词汇表';
$string['glossary:viewallratings'] = '查看所有人给的原始评分';
$string['glossary:viewanyrating'] = '查看每个人收到的总评分';
$string['glossary:viewrating'] = '查看您收到的总评分';
$string['glossary:write'] = '创建新词条';
$string['glossaryleveldefaultsettings'] = '词汇表级别缺省设置';
$string['glossarytype'] = '词汇表类型';
$string['glossarytype_help'] = '主词汇表是一种词汇表，可以在其中导入辅助词汇表中的条目。一门课程中只能有一个主要词汇表，如果不需要导入词汇表条目，则课程中的所有词汇表都可以是辅助词汇表。';
$string['guestnoedit'] = '访客不能编辑词汇表';
$string['importcategories'] = '导入类别';
$string['importedcategories'] = '导入的类别';
$string['importedentries'] = '导入的词条';
$string['importentries'] = '导入词条';
$string['importentriesfromxml'] = '从 XML 文件导入词条';
$string['includegroupbreaks'] = '包含分组';
$string['indicator:cognitivedepth'] = '词汇表活动认知深度';
$string['indicator:cognitivedepth_help'] = '这个指标是基于学生在词汇表活动中所达到的认知深度。';
$string['indicator:cognitivedepthdef'] = '词汇认知';
$string['indicator:cognitivedepthdef_help'] = '在此分析间隔期间，参与者已达到词汇表活动提供的认知参与百分比（级别=无查看、查看、提交）';
$string['indicator:cognitivedepthdef_link'] = 'Learning_analytics_indicators#Cognitive_depth';
$string['indicator:socialbreadth'] = '词汇表活动社会宽度';
$string['indicator:socialbreadth_help'] = '这个指标是基于学生在词汇表活动中所达到的社会宽度。';
$string['indicator:socialbreadthdef'] = '社会词汇表';
$string['indicator:socialbreadthdef_help'] = '在此分析间隔期间，参与者已达到词汇表活动提供的社交参与的百分比（级别=无参与，仅参与者一人）';
$string['indicator:socialbreadthdef_link'] = 'Learning_analytics_indicators#Social_breadth';
$string['isglobal'] = '是全局词汇表吗？';
$string['isglobal_help'] = '全局词汇表的词条不仅可以在所属课程中自动链接，而且可以在全站自动链接。只有管理员可以将词汇表设为全局。';
$string['letter'] = '字母';
$string['linkcategory'] = '自动链接此类别';
$string['linkcategory_help'] = '如果启用了词汇表自动链接，并且打开此设置，那么课程其它地方出现的类别名都会被自动链接到这里。当用户点击了类别名链接，他们会进入词汇表的“按类别浏览”页。';
$string['linking'] = '自动链接';
$string['mainglossary'] = '主词汇表';
$string['maxtimehaspassed'] = '很抱歉，已超过了修改该评论（{$a}）的最大时限！';
$string['modulename'] = '词汇表';
$string['modulename_help'] = '词汇表活动模块使参与者能够创建和维护定义列表，如字典，或收集和组织资源或信息。

教师可以允许将文件附加到词汇表条目中。附加的图像显示在条目中。可以按字母顺序或按类别、日期或作者搜索或浏览条目。参赛作品可以默认获得批准，也可以需要教师的批准才能被所有人查看。

如果启用了词汇表自动链接过滤器，则在课程中概念词和/或短语出现的地方将自动链接条目。

教师可以允许对条目发表评论。参赛作品也可以由教师或学生进行评分（同行评价）。评分可以汇总起来形成最终成绩，并记录在成绩簿中。

词汇表有很多用途，例如
* 关键术语的协作库
* 一个“了解你”的空间，新生可以在其中添加他们的名字和个人详细信息
* 实用主题最佳实践的“实用技巧”资源
* 有用的视频、图像或声音文件的共享区域
* 要记住的事实修订资源';
$string['modulename_link'] = 'mod/glossary/view';
$string['modulenameplural'] = '词汇表';
$string['newentries'] = '新词条';
$string['newglossary'] = '新词汇表';
$string['newglossarycreated'] = '已创建新词汇表。';
$string['newglossaryentries'] = '新词条:';
$string['nocomment'] = '没有评论';
$string['nocomments'] = '（没有找到对此词条的评论）';
$string['noconceptfound'] = '没有找到词名或定义。';
$string['noentries'] = '在此节中未找到词条';
$string['noentry'] = '未找到词条。';
$string['nopermissiontodelcomment'] = '您不能删除其他人的评论！';
$string['nopermissiontodelinglossary'] = '您不能在评论此词汇表！';
$string['nopermissiontoviewresult'] = '您只能看您自己的词条的结果';
$string['notapproved'] = '词条还未被接受。';
$string['notcategorised'] = '未分类';
$string['numberofentries'] = '词条数';
$string['onebyline'] = '（每行一个）';
$string['page-mod-glossary-edit'] = '词汇表添加/编辑词条页面';
$string['page-mod-glossary-view'] = '查看词汇表编辑页面';
$string['page-mod-glossary-x'] = '任意词汇表模块页面';
$string['pendingapproval'] = '正在等待批准';
$string['pendingapprovalcount'] = '等待审批 ({$a})';
$string['pluginadministration'] = '词汇表管理';
$string['pluginname'] = '词汇表';
$string['popupformat'] = '弹出窗口格式';
$string['print'] = '打印';
$string['printerfriendly'] = '可打印版';
$string['printviewnotallowed'] = '不允许使用打印视图';
$string['privacy'] = '结果的保密性';
$string['privacy:metadata:core_comments'] = '使用core_注释系统存储对术语表定义的注释';
$string['privacy:metadata:core_files'] = '链接到术语表定义的文件使用 core_
files 系统存储';
$string['privacy:metadata:core_rating'] = '添加到术语表条目的评级使用core_评级系统存储';
$string['privacy:metadata:core_tag'] = '添加到术语表定义中的标记使用core_标记系统存储';
$string['privacy:metadata:glossary_entries'] = '关于给定词汇表活动的用户条目的信息';
$string['privacy:metadata:glossary_entries:attachment'] = '用户添加的条目的附件';
$string['privacy:metadata:glossary_entries:concept'] = '用户添加的条目的概念';
$string['privacy:metadata:glossary_entries:definition'] = '用户添加的条目的定义';
$string['privacy:metadata:glossary_entries:glossaryid'] = '词汇表活动的ID';
$string['privacy:metadata:glossary_entries:timemodified'] = '指示用户修改术语表条目的时间戳';
$string['privacy:metadata:glossary_entries:userid'] = '添加此词汇表条目的用户的ID';
$string['question'] = '问题';
$string['rejectedentries'] = '已拒绝的词条';
$string['rejectionrpt'] = '拒收报告';
$string['removeallglossarytags'] = '所有术语表标签';
$string['resetglossaries'] = '从哪里删除词条';
$string['resetglossariesall'] = '所有词汇表词条';
$string['rssarticles'] = 'RSS 中最近文章个数';
$string['rssarticles_help'] = '此设置决定在 RSS 种子中包含的词条个数。通常设为 5 到 20 之间。';
$string['rssfeed'] = 'RSS源';
$string['rsssubscriberss'] = '在 RSS 种子中显示“{$a}”条词名';
$string['rsstype'] = '此活动的 RSS 种子';
$string['rsstype_help'] = '要启用此活动的 RSS 种子，请选择种子内容是词名（含作者）还是词名（不含作者）。';
$string['search:activity'] = '词汇表-活动信息';
$string['search:entry'] = '词汇表-词条';
$string['searchindefinition'] = '全文搜索';
$string['secondaryglossary'] = '副词汇表';
$string['showall'] = '显示“全部”链接';
$string['showall_help'] = '如果启用，用户可以一次浏览所有词条。';
$string['showalphabet'] = '显示字母索引';
$string['showalphabet_help'] = '如果启用，用户可以按字母索引浏览词汇表。';
$string['showspecial'] = '显示“特殊”链接';
$string['showspecial_help'] = '如果启用，用户可以按特殊字符（如 @ 和 #）浏览词汇表。';
$string['sortby'] = '排序方式';
$string['sortbycreation'] = '按创建时间';
$string['sortbylastupdate'] = '按更新时间';
$string['sortchronogically'] = '按时间排序';
$string['special'] = '特殊';
$string['standardview'] = '按首字母浏览';
$string['studentcanpost'] = '学生可以提交词条';
$string['tagarea_glossary_entries'] = '词汇表词条';
$string['tagsdeleted'] = '词汇表标签已被删除';
$string['totalentries'] = '词条总数';
$string['usedynalink'] = '自动链接词条';
$string['usedynalink_help'] = '如果管理员启用了全站词汇表自动链接功能，且此设置也被启用，那么“添加新词条”表单就会有自动链接课程中出现的词名到词条的选项。';
$string['visibletabs'] = '可见选项卡';
$string['warningstudentcapost'] = '（仅适用于非主词汇表）';
$string['withauthor'] = '词名（含作者）';
$string['withoutauthor'] = '词名（不含作者）';
$string['writtenby'] = '作者';
$string['youarenottheauthor'] = '您不是该评论的作者，故您无权编辑它。';
