<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'local_moodleorg', language 'sr_lt', version '4.5'.
 *
 * @package     local_moodleorg
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['aboutstatistics'] = 'S obzirom da Moodle možete besplatno da preuzmete, i da je registracija dobrovoljna, nemamo potpune podatke o svima koji Moodle koriste. Međutim, na osnovu podataka koje posedujemo, automatski generišemo neke zanimljive grafikone i brojčane podatke koji se mogu videti na našoj stranici za statistiku.';
$string['aboutstatisticsheading'] = 'Moodle statistika';
$string['aboutstatisticstitle'] = 'Statistika';
$string['activeusers24hours'] = 'Registrovani korisnici koji su pristupali sajtu u poslednja 24 časa.';
$string['activeuserspastmonth'] = 'Registrovani korisnici koji su pristupali sajtu u poslednja mesec dana.';
$string['browsegittitle'] = 'Pregledajte naš izvorni kôd';
$string['cachedef_frontpagecolumn'] = 'Kolone na naslovnoj stranici';
$string['cachedef_usefulposts'] = 'Korisni postovi';
$string['communities'] = 'Zajednice';
$string['communitiesmy'] = 'Moje zajednice';
$string['community'] = 'Zajednica';
$string['communityadministration'] = 'Administracija zajednice';
$string['communitycurrent'] = 'Trenutna zajednica';
$string['communityenrolme'] = 'Postanite član ove zajednice';
$string['communityenrolmentoptions'] = 'Придруживање заједници';
$string['communityintro'] = 'Moodle ima veliku i raznoliku zajednicu korsinika sa preko <a href="http://moodle.org/userpics">{$a->usercount} registrovanih korisnika</a> samo na ovom Moodle sajtu, koji govore preko <a href="http://download.moodle.org/langpack/">{$a->langcount} jezika</a> u <a href="http://moodle.org/sites">{$a->countrycount} zemalja</a> (na <a href="http://moodle.org/stats">možete videti detaljnije statističke podatke</a>).';
$string['communityjoinbyyourself'] = 'Pridružite se sami';
$string['communityjoinbyyourselfas'] = 'Pridružite se sami kao {$a->rolename}';
$string['communitynoguestaccess'] = 'Gosti ne mogu pristupiti ovom delu zajednice, pokušajte da se prijavite.';
$string['communitynotenrollable'] = 'Ne možete sami postati član ove zajednice. Molimo obratite se fascilitatoru zajednice.';
$string['communitysomeallowguest'] = 'Neke zajednice mogu dozvoliti pristup gostima';
$string['communityunenrolme'] = 'Napusti zajednicu {$a}';
$string['conferencecenter'] = 'Moodle konferencijski centar';
$string['connectedsites'] = 'Neki Moodle sajtovi su povezani sa moodle.org putem Moodle umrežavanja (MNet), tako da se na njih možete prijaviti direktno, nakon što Vaš identitet buden proveren na ovom sajtu.';
$string['donations10over'] = 'Druge donacije od 10 ili više dolara';
$string['donationsassociation'] = 'Pridružite se <a href="https://moodleassociation.org/">Moodle Asocijaciji</a> - Pomozite da se donese odluka kako da se utroše članarine na dalji razvoj Moodlea.';
$string['donationsdevelopment'] = 'Međutim, razvoj Moodlea i održavanje svih naših sajtova zajednice nas koštaju mnogo novca, te stoga uvek možemo da koristimo dodatnu podršku. Ako vam se Moodle sviđa ili smatrate da je koristan za vaše poslovanje, školu ili instituciju, molimo vas da razmislite o donaciji. Svako malo pomaže.';
$string['donationsdonatenow'] = 'Donirajte sada';
$string['donationsensure'] = 'Donacije osiguravaju da osnovni zupčanici Moodle mašine (naši programeri) nastave da stvaraju nove funkcije i ispravljaju greške, čineći Moodle boljim za sve nas.';
$string['donationsmoodle'] = 'Donacija za Moodle';
$string['donationsopensource'] = 'Moodle je softver istinski otvorenog kôda i bez ikakvih finansijskih obaveza za naše korisnike - softver takav treba da bude!';
$string['donationsover1000'] = 'Prethodne donacije preko 1000 dolara';
$string['donationsover200'] = 'Ostale donacije preko 200 dolara';
$string['donationsover500'] = 'Ostale donacije preko 500 dolara';
$string['donationspartner'] = 'Koristite <a href="https://moodle.com/partners/"> sertifikovane Moodle partnere </a> za usluge -10% njihovog prihoda se koristi za dalji razvoj Moodle projekta.';
$string['donationsshop'] = 'Kupite neki od proizvoda u našoj <a href="http://www.zazzle.com/moodle_hq/"> Moodle prodavnici </a> i koristite ga sa ponosom!';
$string['donationsthankeveryone'] = 'Hvala svima koji su doprineli Moodle projektu.';
$string['donationsthankyou'] = 'Hvala vam';
$string['donationstitle'] = 'Donacije';
$string['donationsways'] = 'Drugi načini da finansijski doprinesete Moodleu:';
$string['download_activities'] = 'Aktivnosti';
$string['download_admintools'] = 'Administratorski alati';
$string['download_appdocumentation'] = 'Dokumentacija aplikacije';
$string['download_appreleasenotes'] = 'Beleške o izdanju';
$string['download_browseall'] = 'Pregledaj sve';
$string['download_downloadosx'] = 'Preuzmite Moodle za OS X (sadrži Moodle, Apache, MySQL i PHP za pokretanje na Mac OS)';
$string['download_downloadwindows'] = 'Preuzmite Moodle za Windows (sadrži Moodle, Apache, MySQL i PHP za pokretanje na Windows OS)';
$string['download_forandroid'] = 'Za Android';
$string['download_forios'] = 'Za iOS';
$string['download_helpbox_description'] = 'Pročitajte dokumentaciju kako biste pokrenuli svoj Moodle sajt i posetite forume naše zajednice ili jednostavno stupite u kontakt sa Moodle partnerom za hostovanje, instalaciju i druge usluge.';
$string['download_helpbox_installing'] = 'Instaliranje Moodlea';
$string['download_helpbox_partners'] = 'Moodle partneri';
$string['download_helpbox_support'] = 'Forumi podrške';
$string['download_helpbox_title'] = 'Potrebna vam je pomoć?';
$string['download_helpbox_upgrading'] = 'Nadogradnja Moodlea';
$string['download_hero_description'] = 'Moodle se nalazi pod <a class="link" href="http://docs.moodle.org/dev/License">GPL- licencom </a>, što znači da svako ima potpuni slobodu da ga koristi i uživa u njegovim prednostima.<br><br>Pogledajte najnovije izdanje Moodlea.';
$string['download_hero_headline'] = 'Moodle je aplikacija otvorenog koda.';
$string['download_langpackinfo'] = 'Jezički paketi se automatski generišu na osnovu rada prevodilaca na <a href="http://lang.moodle.org/">Sajtu za prevođenje</a>. Za više informacija, pogledajte <a href="https://docs.moodle.org/dev/Translation">Dokumentaciju o prevođenju</a>.';
$string['download_langpackinstallinfo'] = 'Dodatni jezički paketi mogu biti instalirani na vašem Moodle sajtu preko <em>Administracija > Administracija sajta >Jezik > Jezički paketi</em>, ili ručno. Za više informacija, pogledajte <a href="https://docs.moodle.org/en/Language_packs">Dokumentaciju jezičkih paketa</a>.';
$string['download_langpackinstalltitle'] = 'Instalacija jezičkog paketa';
$string['download_langpacktitle'] = 'Jezički paleti za Moodle {$a}';
$string['download_mobileapp'] = 'Mobile App';
$string['download_themes'] = 'Grafičke teme';
$string['download_viewallbuilds'] = 'Pogledajte sve verzije (zahteva veb server, PHP i bazu podataka za pokretanje)';
$string['downloadcore'] = 'Naš glavni način distribucije je putem ovih standardnih osnovnih paketa. Oni sadrže veliki broj modula koje održavaju naši glavni programeri. Paketi su pogodni za instalaciju na skoro svim platformama na kojima već postoje PHP i neka od baza podataka.';
$string['downloadcoretitle'] = 'Standardni Moodle paketi';
$string['downloadintro'] = 'Moodle je paket otovorenog koda pod <a href="http://docs.moodle.org/en/License">GPL licencom</a>. Sve što proizvedemo vama je dostupno za besplatno preuzimanje i korišćenje.';
$string['downloadlang'] = 'U tekućim verzijama Moodlea, dodavanje podrške za nove jezike je automatizovano iz administratorskog menija unutar vašem sajta. Međutim, za neke starije verzije Moodlea novi jezički paketi se moraju ručno preuzeti i instalirati.';
$string['downloadlangtitle'] = 'Jezički paleti';
$string['downloadmac'] = 'Ukoliko već nemate instaliran Web server, ovi "sve-u-jednom" paketi će vam olakšati instalaciju Moodlea na bilo kom Apple računaru sa Mac OS X operativnim sistemom.';
$string['downloadmactitle'] = 'Moodle za Mac OS X';
$string['downloadmodules'] = 'Pretražite našu sveobuhvatnu bazu nestandardnih modula i dodataka koji mogu biti dodati vašem Moodleu, kako biste mu obezbedili dodatnu funkcionalnost, izvan osnovnog paketa.';
$string['downloadmodulestitle'] = 'Moduli i dodaci';
$string['downloadthemes'] = 'Izgled Moodle sajta se može dramatično promeniti korišćenjem različitih grafičkih tema. Mi održavamo bazu grafičkih tema koje su kreirali naši korisnici.';
$string['downloadthemestitle'] = 'Grafičke teme';
$string['downloadviagitcvs'] = 'Drugi načini da preuzmete Moodle uključuje <a href="http://docs.moodle.org/en/Git_for_Administrators">preuzimanje putem Gita</a> Ili <a href="http://docs.moodle.org/22/en/CVS_for_Administrators"> putem CVS-a</a>.';
$string['downloadwin'] = 'Ukoliko već nemate instaliran Web server, ovi "sve-u-jednom" paketi će Vam olakšati instalaciju Moodlea na bilo kom računaru sa Microsoft Windows operativnim sistemom.';
$string['downloadwintitle'] = 'Moodle za Windows';
$string['erroradminonly'] = 'Ovom interfejsu mogu da pristupe samo administratori';
$string['erroralreadyvoted'] = 'Već ste glasali za {$a}';
$string['errormaxmessages'] = 'Oprostite, ali ne možete poslati više od 3 poruke.';
$string['errornomainnews'] = 'На овом сајту, није могуће пронаћи или креирати главни форум Вести';
$string['errorsendingmail'] = 'Dogodila se greška prilikom slanja poruke. Molimo, pokušajte ponovo kasnije ili se obratite administratoru sajta.';
$string['eventdonation_created'] = 'Napravljen je spisak donacija';
$string['eventdonation_submitted'] = 'Донација послата';
$string['events'] = 'Iako smo mi specijalizovani za onlajn učenje, još uvek je lepo sresti se uživo, u realnom svetu. Pogledajte ove linkove za više informacija o našim konferencijama (mi ih zovemo Moodle Moot) i drugim događajima.';
$string['eventstitle'] = 'Događaji';
$string['feed_events'] = 'Događaji';
$string['feed_events_more'] = 'Više unosa u kalendaru';
$string['feed_news'] = 'Obaveštenja';
$string['feed_news_more'] = 'Pogledajte sva obaveštenja';
$string['feed_resources'] = 'Resursi';
$string['feed_useful'] = 'Korisni postovi';
$string['feed_useful_more'] = 'Još postova';
$string['focusbox_community'] = 'Podrška i forumi zajednice';
$string['focusbox_community_text'] = 'Dobijte podršku i podelite ideje na svom jeziku.';
$string['focusbox_community_viewall'] = 'Sve zajednice';
$string['focusbox_future'] = 'Pomozite u oblikovanju budućnosti Moodlea';
$string['focusbox_future_crowdfund'] = 'Finansiranje projekata';
$string['focusbox_future_gdf'] = 'Diskusije za programere';
$string['focusbox_future_research'] = 'Moodle istraživanje';
$string['focusbox_future_roadmap'] = 'Plan';
$string['focusbox_future_text'] = 'Saznajte šta je sledeće i pomozite nam da napravimo razliku.';
$string['focusbox_future_ux'] = 'Diskusije o korisničkom iskustvu (UX).';
$string['focusbox_settingup'] = 'Podešavanje';
$string['focusbox_settingup_community'] = 'Podrška zajednice';
$string['focusbox_settingup_download'] = 'Besplatno preuzimanje';
$string['focusbox_settingup_hosting'] = 'Hosting';
$string['focusbox_settingup_install'] = 'Instalacija';
$string['focusbox_settingup_own'] = 'Samostalno';
$string['focusbox_settingup_partner'] = 'Preko Moodle partnera';
$string['focusbox_settingup_plugins'] = 'Dodaci';
$string['focusbox_settingup_support'] = 'Komercijalna podrška';
$string['focusbox_teaching'] = 'Nastava uz Moodle';
$string['focusbox_teaching_books'] = 'Knjige';
$string['focusbox_teaching_courses'] = 'Kursevi i sadržaj';
$string['focusbox_teaching_docs'] = 'Dokumentacija';
$string['focusbox_teaching_text'] = 'Istražite širok spektar funkcija i dostupnih resursa Moodlea.';
$string['focusbox_theproject'] = 'Moodle projekat';
$string['focusbox_theproject_about'] = 'O Moodleu';
$string['focusbox_theproject_devs'] = 'Programeri';
$string['focusbox_theproject_hq'] = 'Moodle HQ';
$string['focusbox_theproject_mua'] = 'Udruženje Moodle korisnika (МUA - Moodle Users Association)';
$string['focusbox_theproject_partners'] = 'Moodle partneri';
$string['focusbox_theproject_stats'] = 'Statistika';
$string['focusbox_theproject_text'] = 'Saznajte više o Moodle projektu i našim otvorenim, saradničkim partnerstvima.';
$string['focusbox_uptodate'] = 'Budite u toku';
$string['focusbox_uptodate_buzz'] = 'Moodle buzz';
$string['focusbox_uptodate_news'] = 'Obaveštenja';
$string['focusbox_uptodate_planet'] = 'Planet Moodle';
$string['focusbox_uptodate_security'] = 'Bezbednosna obaveštenja';
$string['focusbox_uptodate_social'] = 'Društveni mediji';
$string['focusbox_uptodate_text'] = 'Najnovije Moodle vesti, ažuriranja i svedočanstva širom sveta.';
$string['generaldeveloperforum'] = 'Opšti forum za razvoj';
$string['graphpopulation'] = 'Grafikon Moodle populacije';
$string['graphregistrationmap'] = 'Moodle mapa registrovanih sajtova';
$string['graphregistrationmapdesc'] = 'Top 10 registrovanih sajtova iz {$a} zemalja';
$string['graphusersites'] = 'Poređenje Moodle sajtova prema broju korisnika';
$string['heroslide_community_description'] = 'Dobrodošli u Moodle zajednicu! Otkrijte vrednost otvorenog, zajedničkog napora jednog od najvećih timova otvorenog kôda na svetu.';
$string['heroslide_community_headline'] = 'Vođen zajednicom, globalno podržan.';
$string['heroslide_community_slidecontrol'] = 'Podržana od strane globalne zajednice';
$string['heroslide_donate_headline'] = 'Pomozite nam da napravimo razliku sa otvorenim i kvalitetnim obrazovanjem za sve';
$string['heroslide_getstarted40_description'] = 'Moodle LMS ima novi prepoznatljiv izgled i redefinisano korisničko iskustvo koje unapređuje onlajn nastavu i učenje za predavače, polaznike i administratore.';
$string['heroslide_getstarted40_headline'] = 'Moodle 4.0 - Novi izgled, bolje korisničko iskustvo!';
$string['heroslide_getstarted40_slidecontrol'] = 'Moodle 4.0 je ovde!';
$string['heroslide_getstarted_description'] = 'Moodle je najpopularniji sistem za upravljanje učenjem na svetu. Počnite da kreirate svoju veb sajt za onlajn učenje za nekoliko minuta!';
$string['heroslide_getstarted_headline'] = 'Početi je lako';
$string['heroslide_getstarted_slidecontrol'] = 'Počnite još danas';
$string['heroslide_global_description'] = 'Dostupan na preko 100 jezika, Moodle ima veliko poverenje brojnih organizacija i institucija, velikih i malih, sa milionima korisnika širom sveta.';
$string['heroslide_global_headline'] = 'Pokreće okruženja za učenje širom sveta';
$string['heroslide_global_slidecontrol'] = 'Pokreće okruženja za učenje širom sveta';
$string['heroslide_link_demo'] = 'Demo';
$string['heroslide_link_donate'] = 'Donirajte';
$string['heroslide_link_features'] = 'Funkcije';
$string['heroslide_link_forums'] = 'Forumi zajednice';
$string['heroslide_link_getstarted'] = 'Počnite još danas';
$string['heroslide_link_getstarted40'] = 'Saznajte više o Moodleu 4.0';
$string['heroslide_link_sites'] = 'Registrovani sajtovi';
$string['heroslide_link_stats'] = 'Statistika';
$string['heroslide_link_stories'] = 'Opširnije';
$string['heroslide_power40_description'] = 'Lako, brzo i intuitivno! Istražite poboljšano korisničko iskustvo i nove funkcije Moodle verzije 4.0.';
$string['heroslide_power40_headline'] = 'Doživite Moodle 4.0';
$string['heroslide_power40_slidecontrol'] = 'Doživite Moodle 4.0';
$string['heroslide_power_description'] = 'Svetska besplatna platforma za učenje koja vam pomaže da kreirate efikasnu onlajn nastavu i iskustvo učenja u kolaborativnom i privatnom okruženju.';
$string['heroslide_power_headline'] = 'Moćan. Bezbedan. Otvorenog kôda.';
$string['heroslide_power_slidecontrol'] = 'Robusna platforma za učenje otvorenog kôda';
$string['heroslide_story1_description'] = '“Vodeći u učenju uz pomoć tehnologije, Moodle nam omogućava da olakšamo našim studentima otkrivanje i kreativnost.” - prof. Darel Evans, prodekan za nastavu, Univerzitet Monaš';
$string['heroslide_story1_headline'] = 'Poboljšanje nastave i učenja svuda';
$string['heroslide_story2_description'] = 'Globalni provajder usluga za transport, logistiku i pomorske usluge, GAC, omogućava učenje i razvoj za preko 10.000 zaposlenih u više od 70 zemalja, sa svojom korporativnom akademijom.';
$string['heroslide_story2_headline'] = 'Postizanje izvrsnosti na polju korporativnog učenja';
$string['heroslide_story3_description'] = 'Forth Valley College je jedan od najvećih škotskih koledža, koji nudi više od 750 kurseva sa preko 20.000 aktivnih korisnika na svojim sajtovima.';
$string['heroslide_story3_headline'] = 'Pružanje svestranog fleksibilnog obrazovanja';
$string['heroslide_story4_description'] = 'Voluntary Service Overseas - VSO (Volonterska služba u inostranstvu) pruža interaktivno učenje i podršku volonterima na međunarodnom nivou kako bi im se omogućio globalni pristup obuci.';
$string['heroslide_story4_headline'] = 'Pomoć volonterima u realizaciji programa za borbu protiv siromaštva';
$string['heroslide_story5_description'] = 'Slajd 5 - opis';
$string['heroslide_story5_headline'] = 'Slajd 5 - naslov';
$string['heroslide_story_slidecontrol'] = 'Moodle priče iz celog sveta';
$string['jobs'] = 'Posetite našu bazu podataka o poslovima za više informacija o radnim mestima širom sveta, koja su u vezi sa Moodleom';
$string['logoinfo'] = 'Naziv Moodle ™ je registrovani zaštitni znak kompanije Moodle Trust.

Ako nameravate da koristite ime i/ili logo za reklamiranje generičkih Moodle usluga (npr. Moodle hosting, Moodle podrška, Moodle sertifikacija, Moodle obuka, Moodle konsalting, prilagođavanje Moodlea, razvoj Moodle programa za kurseve, dizajn Moodle grafičkih tema, Moodle integracije, Moodle instalacije, itd.) ili kao naziv softverskog paketa, onda morate tražiti i dobiti direktnu pismenu dozvolu od kompanije Moodle Trust putem [moodle.com helpdesk](http://moodle.com/helpdesk/), u skladu sa uobičajena ograničenjima u korišćenju zaštnog znaka.

Ne postoje ograničenja u vezi sa načinom na koji koristite ime u drugim kontekstima (na primer, ako koristite Moodle samo da biste držali onlajn kurseve, onda možete slobodno da koristite ime kako biste se pozvali na njega). Ako niste sigurni u konkretnom slučaj, možete nam poslati pitanje putem [moodle.com helpdesk](http://moodle.com/helpdesk/). Biće nam drago da vam damo zvaničnu dozvolu u pisanoj formi ili da vam pomognemo da popravite svoj tekst.';
$string['logotitle'] = 'Moodle logo';
$string['manageads'] = 'Upravljanje oglasima partnera';
$string['managedonations'] = 'Upravljanje donacijama';
$string['moodleorg:manageads'] = 'Upravljanje oglasima partnera';
$string['moodleorg:managedonations'] = 'Upravljanje registrom donacija';
$string['moodlepartner_corporate'] = 'Korporativna obuka';
$string['moodlepartner_other'] = 'Ostali sektori';
$string['moodlepartner_school'] = 'Škola';
$string['moodlepartner_university'] = 'Univerzitet';
$string['networkinfo'] = 'Sledeći Moodle sajtovi su povezani sa sajtom moodle.org koristeći Moodle umrežavanje, tako da se direktno odavde možete prijaviti na te sajtove.';
$string['networktitle'] = 'Povezani sajtovi';
$string['newregistrations'] = 'Nove registracije';
$string['newstitle'] = 'Obaveštenja';
$string['noenrolledcoursesyet'] = 'Još uvek niste upisani ni na jedan kurs na ovom sajtu';
$string['partnerslogan'] = 'Moodle projekat podržava preko 90 sertifikovanih <a href="https://moodle.com/partners/">Moodle partnera</a> širom sveta.';
$string['permalink'] = 'Permanentni link';
$string['pluginname'] = 'Moodle.org sajt';
$string['popularissues'] = 'Najpopularniji pitanja';
$string['privacy:metadata:db:registerdonations'] = 'Ima evidenciju o donacijama Moodleu';
$string['privacy:metadata:db:registerdonations:amount'] = 'Donirani iznos';
$string['privacy:metadata:db:registerdonations:name'] = 'Ime/naziv donatora';
$string['privacy:metadata:db:registerdonations:org'] = 'Donatorska organizacija';
$string['privacy:metadata:db:registerdonations:timedonated'] = 'Vreme donacije';
$string['privacy:metadata:db:registerdonations:url'] = 'URL adresa donatora';
$string['recentlyratedposts'] = 'Nedavno ocenjeni postovi';
$string['recentpart'] = 'Ova stranica prikazuje neke od ljudi koji su danas koristili moodle.org';
$string['registeredsites'] = 'Institucije nisu obavezne da bilo koga obaveste o tome da koriste Moodle, zato što je  Moodle softver otvorenog koda. Međutim, neki Moodle sajtovi su izabrali da se registruju kod nas i mi održavamo spisak tih sajtova.';
$string['registeredsitestitle'] = 'Registrovani sajtovi';
$string['registereduserslastday'] = 'Novi korisnici (u poslednja 24 časa)';
$string['registereduserstotal'] = 'Ukupno registrovanih korisnika';
$string['registrationgraphalt'] = 'Svi Moodle registrovani sajtovi tokom vremena';
$string['registrationgraphdesc'] = 'Mi sprovodimo <a href="http://docs.moodle.org/en/Usage">redovnu masovnu proveru registrovanih sajtova</a> kako bi bili sigurni da su oni i dalje aktivni, tako da povremeno možete videti da se njihov broj smanjuje.';
$string['registrationslast6months'] = 'Registrovani sajtovi u poslednjih 6 meseci';
$string['registrationslastmonths'] = 'Registracije u poslednja/ih {$a} mesec/i/a';
$string['registrationstotal'] = 'Sve trenutne registracije';
$string['resources_buzz'] = 'Buzz';
$string['resources_courses'] = 'Kursevi';
$string['resources_jobs'] = 'Poslovi';
$string['resources_plugins'] = 'Dodaci';
$string['roadmap'] = 'Plan razvoja Moodlea';
$string['rssdescription'] = 'Nedavni ili postovi ocenjeni kao korisni na forumu na moodle.org';
$string['rssmoodlecommore'] = 'Pogledajte sve najnovije vesti';
$string['rssmoodlecomtitle'] = 'Najnovije vesti';
$string['rsstitle'] = 'Postovi na Moodle.org forumima';
$string['searchmoodleorg'] = 'Pretražite moodle.org';
$string['securitytitle'] = 'Bezbednosna obaveštenja';
$string['shop'] = 'Da li tražite način na koji ćete pokazati da ste deo naše zajednice? Posetite onlajn prodavnicu u kojoj možete kupiti majice, šolje i razne druge proizvode.';
$string['social-facebook-moodle'] = 'Zvanična Moodle stranica na Facebooku';
$string['social-googleplus-community'] = 'Zvanična stranica Moodle zajednice na Google +';
$string['social-googleplus-moodle'] = 'Zvanična Moodle stranica na Google +';
$string['social-linkedin-moodle'] = 'Zvanična Moodle stranica na LinkedInu';
$string['social-twitter-moodle'] = 'Zvanična Moodle obaveštenja, agregirane Moodle vesti (Planet Moodle i Moodle buzz), kao i korisni postovi na forumima';
$string['social-twitter-moodledev'] = 'Vesti o razvoju i ažuriranja Moodlea';
$string['social-twitter-moodlehq'] = 'Tvitovi Moodle HQ-a';
$string['social-twitter-moodlejobs'] = 'Poslovi, vezani za Moodle, u ponudi';
$string['social-twitter-moodlenet'] = 'Deljeni Moodle kursevi i sadržaji';
$string['social-twitter-moodleplugins'] = 'Nedavno objavljeni Moodle dodaci';
$string['social-twitter-moodleresearch'] = 'Novosti o godišnjoj Moodle Research konferenciji i istraživanjima povezanim za Moodle';
$string['social-twitter-moodlesecurity'] = 'Moodle bezbednosna obaveštenja';
$string['social-twitter-moodlesites'] = 'Ажурирања статуса за Moodle HQ мрежу сајтова и сервиса';
$string['social-twitter-moodlethemes'] = 'Недавно објављене Moodle графичке теме';
$string['social-youtube-moodle'] = 'Zvanični Moodle kanal na YouTubeu';
$string['socialinfo'] = 'Prisutni smo se na nekoliko sajtova društvenih medija kako bismo pomogli u podizanju svesti o Moodle projektu i podelili najnovije vesti i dešavanja u svetu Moodlea. Pratite nas kako biste bili u toku i upoznali druge mudlere u zajednici!';
$string['socialtitle'] = 'Društveni mediji';
$string['statscountries'] = 'Zemlje';
$string['statscourses'] = 'Kursevi';
$string['statsenrolments'] = 'Upisi';
$string['statsposts'] = 'Postovi na forumu';
$string['statsquestions'] = 'Test pitanja';
$string['statsresources'] = 'Resursi';
$string['statsteachers'] = 'Predavači';
$string['statsusers'] = 'Korisnici';
$string['supportbooks'] = 'Održavamo spisak velikog broja knjiga o Moodleu, koje možete naručiti.';
$string['supportcommercial'] = 'Moodle partneri predstavljaju grupu ovlašćenih kompanija širom sveta koji mogu da vam pomognu u implementacijia Moodlea.';
$string['supportdocs1'] = 'Moodle Docs je odlično mesto za početak, posebno naše stranice sa Često postavljanim pitanjima (FAQ).';
$string['supportdocs2'] = 'Najbolji način za pristup relevantnoj dokumentaciji jeste korišćenje linka "Moodle dokumentacija za ovu stranicu" koji se nalazi na dnu svake stranice Vašeg Moodle sajta.';
$string['supportdocsfaq'] = 'Često postavljana pitanja (FAQ)';
$string['supportdocslang'] = 'Moodle Docs na drugim jezicima';
$string['supportforums'] = 'Naša zajednica korisnika većinom komunicira putem foruma unutar "kurseva" na ovom Moodle sajtu. Morate da se "upišete" na kurs kako biste mogli da učestvujete u diskusijama na forumima (upis je potpuno besplatan).';
$string['supportforumsenglish'] = 'Glavna podrška i diskusije o razvoju između korisnika i programera se odvijaju (na engleskom) ovde:';
$string['supportforumsenglishname'] = 'Korišćenje Moodlea';
$string['supportforumslang'] = 'Glavni forum za druženje korisnika Moodlea, na engleskom, se nalazi ovde:';
$string['supportforumslangname'] = 'Moodle Lounge';
$string['supportforumslangurl'] = 'http://moodle.org/course/view.php?id=55';
$string['supportforumslist'] = 'Postoji veliki broj drugih foruma na mnogobrojnim jezicima:';
$string['supportforumslistname'] = 'Spisak svih kurseva';
$string['supportintro'] = 'Niste sami! Postoje razni načini da dobijete pomoć u korišćenju Moodlea, ukoliko Vam je ona potrebna.';
$string['syncregistrationstask'] = 'Sinhronizujte ažuriranja registracije sajta pod Moodle verzijom 1.9 sa moodle.net';
$string['top10countriesbyregistration'] = 'Top 10 zemalja prema broju registrovanih sajtova';
$string['top10sitesbycourses'] = '10 top sajtova po broju kurseva';
$string['top10sitesbyusers'] = '10 top sajtova po broju korisnika';
$string['url-about'] = 'http://docs.moodle.org/en/About_Moodle';
$string['url-features'] = 'http://docs.moodle.org/en/Features';
$string['url-install'] = 'http://docs.moodle.org/en/Installation';
$string['url-standards'] = 'http://docs.moodle.org/en/Standards';
$string['url-userdocs'] = 'http://docs.moodle.org/en/';
$string['versionsused'] = 'Korišćene verzije';
