<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'format_tiles', language 'ru', version '4.5'.
 *
 * @package     format_tiles
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['addsections'] = 'Добавить плитку';
$string['admintools'] = 'Инструменты администратора';
$string['all'] = 'Все';
$string['allcomplete'] = 'Все завершенные';
$string['allcoursescomplypalette'] = 'Все курсы уже имеют разрешенные цвета плитки. Нечего сбрасывать. Обязательно сохраните все изменения в разрешенных цветах, прежде чем нажимать кнопку сброса';
$string['allowphototiles'] = 'Разрешить фото плитки';
$string['allowphototiles_desc'] = 'Если этот параметр выбран, учителя смогут загружать фотографии, которые будут использоваться в качестве фонов плиток. Они по-прежнему смогут использовать стандартные значки плиток в том же курсе. (Если этот флажок не установлен, будут разрешены только значки мозаики, а остальные настройки фотоизображения ниже будут игнорироваться.)';
$string['allowsubtilesview'] = 'Разрешить показ вложенных плиток';
$string['allowsubtilesview_desc'] = 'Если включен, разрешает отображать внутри плитки элементы и ресурсы (за исключением пояснений) в виде вложенных плиток вместо стандартного списка';
$string['alternativelink'] = 'альтернативная ссылка';
$string['areyousure'] = 'Вы уверены?';
$string['asfraction'] = 'Показать в виде дроби';
$string['aspectratiotootallorwide'] = 'Загруженное изображение было сохранено, но, пожалуйста, проверьте, может ли оно быть <strong>{$a->tallorwide}</strong>. Если оно выглядит неправильно, обрежьте его до стандартных размеров и загрузите снова. Например 200 в ширину х 300 в высоту.';
$string['aspercentagedial'] = 'Показать как % в круге';
$string['assumedatastoreconsent'] = 'Предполагать согласие на локальное хранение данных в браузере';
$string['assumedatastoreconsent_desc'] = 'Если включен, пользователю <b>не будет</b> показан диалог, спрашивающий согласия на хранение данных в локальном хранилище браузера';
$string['backupfailed'] = 'Резервное копирование не удалось';
$string['basecolour'] = 'Цвет для плиток';
$string['basecolour_help'] = 'Заданный здесь цвет будет применяться ко всем плиткам в курсе. (Доступные цвета определяются администратором вашего сайта на странице настроек плагина Tiles).';
$string['brandcolour'] = 'Цвет бренда';
$string['changedcolour'] = 'Цвет плитки по умолчанию для курса {$a}';
$string['checkforproblemcourses'] = 'Проверить и исправить проблемные курсы';
$string['clickiffailstoload'] = 'Нажмите, если страница не загружается';
$string['close'] = 'Закрыть';
$string['collapse'] = 'Свернуть раздел';
$string['collapsesections'] = 'Свернуть все разделы';
$string['colourblue'] = 'Синий';
$string['colourdarkgreen'] = 'Темно-зеленый';
$string['colourgreen'] = 'Зеленый';
$string['colourlightblue'] = 'Светло-синий';
$string['colourname_descr'] = 'Отображаемое название цвета (это название обычно не отображается пользователям — вместо этого они видят образец цвета)';
$string['colournamegeneral'] = 'Отображаемое имя для цвета выше';
$string['colourpurple'] = 'Пурпурный';
$string['colourred'] = 'Красный';
$string['colours'] = 'Цвета';
$string['complete'] = 'Выполнено';
$string['complete-n-auto'] = 'Элемент не выполнен. Он будет помечен как выполненный, когда Вы выполните необходимые условия. Вы не можете поставить отметку вручную.';
$string['complete-y-auto'] = 'Элемент выполнен. Он был помечен как выполненный, когда Вы выполнили необходимые условия. Вы не можете убрать отметку вручную.';
$string['completion_help'] = 'Галочка справа от элемента может быть использована для того чтобы показать, что элемент выполнен (если элемент не выполнен, будет показан пустой круг).
<br><br>
В зависимости от настройки, галочка может появляться автоматически, когда Вы выполните все условия, заданные учителем для этого элемента.<br><br>
В других случаях, Вы можете щелкнуть мышью на пустом круге, когда Вы считаете, что выполнили этот элемент, и он будет отмечен зеленой галочкой. (Повторный щелчок мышью уберет галочку, если Вы измените свое мнение.)';
$string['completionswitchhelp'] = '<p>Вы выбрали показ отслеживания выполнения на каждой плитке, поэтому ниже на этой странице мы переключили параметр «Отслеживание выполнения > Включить отслеживание выполнения» в «Да».</p>
<p>Помимо этого, вам необходимо включить отслеживание выполнения для <b>каждого элемента</b>, который Вы отслеживаете. Например, для PDF щелкните «Редактировать настройки», перейдите в «Выполнение элемента курса» и выберите необходимую настройку.</p>
<p>Вы также можете сделать это <b>массово</b>, как описано в <a href="https://docs.moodle.org/35/en/Activity_completion_settings" target="_blank">подробном объяснении отслеживания выполнения на moodle.org</a></p>';
$string['completionwarning'] = 'Вы включили отслеживание выполнения на уровне курса, однако на уровне отдельных элементов отслеживание не включено, поэтому нечего отслеживать.';
$string['completionwarning_changeinbulk'] = 'Массовое изменение';
$string['completionwarning_help'] = 'Вам необходимо настроить отслеживание отдельных элементов, отредактировав их (Выполнение элемента курса > Отслеживание выполнения). Или же можете это сделать массово — Управление курсом > Завершение курса > Массовое редактирование настроек завершения элементов курса';
$string['contact'] = 'Связаться';
$string['contactdeveloper'] = 'Связаться с разработчиком';
$string['contents'] = 'Содержание';
$string['courseshowtileprogress'] = 'Прогресс на каждой плитке';
$string['courseshowtileprogress_error'] = 'Параметр «Отслеживание выполнения > Включить отслеживание выполнения» установлен в «Нет» (смотрите ниже на этой странице), что конфликтует с данным параметром. Если Вы хотите отображать прогресс на плитках, пожалуйста, установите «Отслеживание выполнения > Включить отслеживание выполнения» в «Да». В противном случае, установите этот параметр в «Нет».';
$string['courseshowtileprogress_help'] = '<p>При включенном параметре прогресс пользователя по элементам курса будет показан на каждой плитке либо в виде <em>дроби</em> (например, «Прогресс 2/10» означает выполнение 2 из 10 элементов), либо в виде <em>процента</em> в круге.</p><p>Можно использовать только если параметр «Отслеживание выполнения > Включить отслеживание выполнения» был включен.</p><p>Если в данной плитке нет отслеживаемых элементов, индикатор для неё не будет показан.</p>';
$string['courseshowtileprogress_link'] = 'Activity_completion_settings#Activity_settings';
$string['coursetoomanysections'] = 'Предупреждение для редакторов: в этом курсе больше плиток, чем разрешено. Студентам будет показано максимум {$a->max} (вплоть до "{$a->tilename}") (редакторы могут видеть больше).';
$string['courseusebarforheadings'] = 'Выделять заголовки цветной вкладкой';
$string['courseusebarforheadings_help'] = 'Отображать цветную вкладку слева от заголовка в курсе каждый раз, когда в текстовом редакторе выбран стиль заголовка.';
$string['courseusesubtiles'] = 'Использовать вложенные плитки для элементов';
$string['courseusesubtiles_help'] = 'Внутри каждой плитки показывать все элементы как вложенные плитки вместо отображения списка элементов на странице. Это не применяется к пояснениям, которые не будут показаны как вложенные плитки, так что их можно использовать как заголовки между плитками.';
$string['currentsection'] = 'Эта плитка';
$string['customcss'] = 'Пользовательский CSS';
$string['customcssdesc'] = 'Пользовательский CSS применяется к контенту раздела курса, когда используется данный формат курса. Валидность данного CSS не проверяется, поэтому позаботьтесь о том, чтобы код был правильным. Например: <p>.section { color: red; }</p><p>li.activity.subtile.resource.pdf { background-color: orange !important; }</p>';
$string['datapref'] = 'Настройка данных';
$string['datapreferror'] = 'Настройка данных доступна только если в браузере включен javascript. Если он выключен, хранилище данных включить невозможно.';
$string['dataprefquestion'] = '<p>Для удобства работы с этим сайтом используется функционал вашего браузера для хранения информации о содержимом последней открытой плитки. Контент остается на вашем компьютере на короткое время для отображения при новом посещении этой страницы. Мы не используем его для отслеживания. Это нормально?</p><p>Мы будем помнить ваш выбор, пока вы не очистите историю просмотров. Выбор «Нет» может замедлить загрузку страницы.</p>';
$string['defaultthiscourse'] = 'По умолчанию для данного курса';
$string['defaulttilecolour'] = 'Цвет плитки по умолчанию';
$string['defaulttileicon'] = 'Значок плитки';
$string['defaulttileicon_help'] = 'Выбранный здесь значок появится на <em>всех</em> плитках в этом курсе. Для отдельных плиток можно выбрать другие значки, используя настройки на уровне плитки.';
$string['deleteimage'] = 'Удалить картинку';
$string['deletesection'] = 'Удалить плитку';
$string['developedby'] = '«Плитка», разработанная {$a}';
$string['developer'] = 'Разработчик';
$string['disabledbyadmin'] = 'Отключено администратором сайта';
$string['displayfilterbar'] = 'Панель фильтров';
$string['displayfilterbar_error'] = 'Если Вы не настраивали показатели для этого курса, вы можете показать только фильтр, основанный на номерах плиток, а не на показателях. Создайте сначала несколько показателей, а затем вернитесь сюда. Подробнее';
$string['displayfilterbar_help'] = '<p>Если включен, автоматически показывает набор кнопок перед набором плиток в курсе. Щелкая на кнопки пользователи могут отфильтровать плитки по определенным диапазонам</p><p>Если выбрано «с учетом номеров плиток», будет показана серия кнопок, например, кнопка для плиток 1-4, кнопка для плиток 5-8 и т. д.</p><p>Если выбрано «с учетом показателей курса», показатели курса будут показаны по одному на каждой кнопке. Каждая плитка может быть назначена конкретному показателю (и следовательно конкретной кнопке) на странице настроек этой плитки.</p>';
$string['displayfilterbar_link'] = 'Outcomes';
$string['displaytitle_mod_doc'] = 'Документ Word';
$string['displaytitle_mod_html'] = 'Веб-страница';
$string['displaytitle_mod_jpeg'] = 'Изображение';
$string['displaytitle_mod_mp3'] = 'Аудио';
$string['displaytitle_mod_mp4'] = 'Видео';
$string['displaytitle_mod_pdf'] = 'PDF';
$string['displaytitle_mod_ppt'] = 'Презентация PowerPoint';
$string['displaytitle_mod_txt'] = 'Текст';
$string['displaytitle_mod_xls'] = 'Электронная таблица Excel';
$string['displaytitle_mod_zip'] = 'Архив';
$string['download'] = 'Скачать';
$string['editsectionname'] = 'Введите название плитки';
$string['embeddedurlerror'] = 'Если внешний сайт отказывается подключаться в окне выше, используйте это:';
$string['entersection'] = 'Введите раздел';
$string['existingimage'] = 'Существующее изображение для этой плитки';
$string['expand'] = 'Развернуть';
$string['expandall'] = 'Развернуть все';
$string['expandsections'] = 'Показать все элементы (все разделы)';
$string['fileaddedtobottom'] = 'Файл добавлен в конец раздела';
$string['filterboth'] = 'Показать кнопки с учетом номеров плиток и показателей курса';
$string['filternumbers'] = 'Показать кнопки с учетом номеров плиток';
$string['filteroutcomes'] = 'Показать кнопки с учетом показателей курса';
$string['filteroutcomesrestore'] = 'Исходный курс использует в фильтре показатели, которые пока не поддерживаются в процессе восстановления. Поэтому в восстановленном курсе настройка фильтра была изменена. Если вы хотите  в восстановленном курсе использовать показатели для фильтрации плиток, то снова настройте показатели. Исходный курс не был изменен.';
$string['folderdisplayerror'] = 'Папки, заданные для отображения встроенного контента, не совместимы с форматом вложенных плиток.  Поэтому, эта <a href="{$a}">папка</a> была заменена на отображение на отдельной странице';
$string['followthemecolour'] = 'Принудительно использовать цвет темы';
$string['followthemecolour_desc'] = 'Если включен, данный плагин не даст учителям возможности выбора и все цвета плиток ниже будут проигнорированы. Вместо этого будет предпринята попытка взять основной цвет бренда темы и использовать его.';
$string['hidden'] = 'Скрытый';
$string['hide'] = 'Скрыть';
$string['hidefromothers'] = 'Скрыть плитку';
$string['home'] = 'Главная страница курса';
$string['icontitle-address-book-o'] = 'Адресная книга';
$string['icontitle-assessment_timer'] = 'Таймер оценки';
$string['icontitle-asterisk'] = 'Звездочка';
$string['icontitle-award-solid'] = 'Бейдж';
$string['icontitle-balance-scale'] = 'Весы в равновесии';
$string['icontitle-bar-chart'] = 'Гистограмма';
$string['icontitle-bell-o'] = 'Колокол';
$string['icontitle-binoculars'] = 'Бинокль';
$string['icontitle-bitcoin'] = 'Биткоин';
$string['icontitle-book'] = 'Книга';
$string['icontitle-bookmark-o'] = 'Закладка';
$string['icontitle-briefcase'] = 'Портфель';
$string['icontitle-building'] = 'Здание';
$string['icontitle-bullhorn'] = 'Мегафон';
$string['icontitle-bullseye'] = 'Мишень';
$string['icontitle-calculator'] = 'Калькулятор';
$string['icontitle-calendar'] = 'Календарь';
$string['icontitle-calendar-check-o'] = 'Календарь с отметкой';
$string['icontitle-check'] = 'Галочка';
$string['icontitle-child'] = 'Ребенок';
$string['icontitle-clock-o'] = 'Часы';
$string['icontitle-clone'] = 'Клонировать';
$string['icontitle-cloud-download'] = 'Облако (скачать)';
$string['icontitle-cloud-upload'] = 'Облако (загрузить)';
$string['icontitle-comment-o'] = 'Комментарий';
$string['icontitle-comments-o'] = 'Комментарии';
$string['icontitle-compass'] = 'Компас';
$string['icontitle-diamond'] = 'Бриллиант';
$string['icontitle-dollar'] = 'Доллар';
$string['icontitle-euro'] = 'Евро';
$string['icontitle-exclamation-triangle'] = 'Восклицательный знак в треугольнике';
$string['icontitle-feed'] = 'Канал';
$string['icontitle-file-text-o'] = 'Текстовый файл';
$string['icontitle-film'] = 'Фильм';
$string['icontitle-flag-checkered'] = 'Флаг в клетку';
$string['icontitle-flag-o'] = 'Флаг';
$string['icontitle-flash'] = 'Молния';
$string['icontitle-flask'] = 'Колба';
$string['icontitle-flipchart'] = 'Флипчарт';
$string['icontitle-frown-o'] = 'Грустный смайл';
$string['icontitle-gavel'] = 'Молоток';
$string['icontitle-gbp'] = 'Британский фунт';
$string['icontitle-globe'] = 'Глобус';
$string['icontitle-handshake-o'] = 'Рукопожатие';
$string['icontitle-headphones'] = 'Наушники';
$string['icontitle-heartbeat'] = 'Сердцебиение';
$string['icontitle-history'] = 'Часы истории';
$string['icontitle-home'] = 'Дом';
$string['icontitle-id-card-o'] = 'ID-карта';
$string['icontitle-info'] = 'Информация';
$string['icontitle-jigsaw'] = 'Пазл';
$string['icontitle-key'] = 'Ключ';
$string['icontitle-laptop'] = 'Ноутбук';
$string['icontitle-life-buoy'] = 'Спасательный круг';
$string['icontitle-lightbulb-o'] = 'Лампочка';
$string['icontitle-line-chart'] = 'Линейная диаграмма';
$string['icontitle-list'] = 'Список (маркированный)';
$string['icontitle-list-ol'] = 'Список (нумерованный)';
$string['icontitle-location-arrow'] = 'Стрелка направления';
$string['icontitle-map-marker'] = 'Маркер карты';
$string['icontitle-map-o'] = 'Карта';
$string['icontitle-map-signs'] = 'Указатели';
$string['icontitle-microphone'] = 'Микрофон';
$string['icontitle-mobile-phone'] = 'Мобильный телефон';
$string['icontitle-mortar-board'] = 'Конфедератка';
$string['icontitle-music'] = 'Музыка';
$string['icontitle-newspaper-o'] = 'Газета';
$string['icontitle-pencil-square-o'] = 'Карандаш в квадрате';
$string['icontitle-person'] = 'Человек';
$string['icontitle-pie-chart'] = 'Секторная диаграмма';
$string['icontitle-podcast'] = 'Подкаст';
$string['icontitle-puzzle-piece'] = 'Элемент пазла';
$string['icontitle-question-circle'] = 'Вопросительный знак в круге';
$string['icontitle-random'] = 'Случайным образом';
$string['icontitle-refresh'] = 'Обновить';
$string['icontitle-road'] = 'Дорога';
$string['icontitle-search'] = 'Лупа';
$string['icontitle-sliders'] = 'Слайдеры';
$string['icontitle-smile-o'] = 'Смайл';
$string['icontitle-star'] = 'Звезда (полностью закрашенная)';
$string['icontitle-star-half-o'] = 'Звезда (наполовину закрашенная)';
$string['icontitle-star-o'] = 'Звезда (не закрашенная)';
$string['icontitle-survey'] = 'Опрос';
$string['icontitle-tags'] = 'Теги';
$string['icontitle-tasks'] = 'Задачи';
$string['icontitle-television'] = 'Телевизор';
$string['icontitle-thinking-person'] = 'Человек с лампочкой';
$string['icontitle-thumbs-o-down'] = 'Палец вниз';
$string['icontitle-thumbs-o-up'] = 'Палец вверх';
$string['icontitle-trophy'] = 'Кубок';
$string['icontitle-umbrella'] = 'Зонт';
$string['icontitle-university'] = 'Университет';
$string['icontitle-user-o'] = 'Человек (не закрашенный)';
$string['icontitle-users'] = 'Люди';
$string['icontitle-volume-up'] = 'Динамик';
$string['icontitle-wrench'] = 'Гаечный ключ';
$string['jsactivate'] = 'Включить анимированную навигацию';
$string['jsdeactivated'] = 'Вы отключили анимированную навигацию для своей учетной записи. Вы можете повторно включить её с помощью меню навигации.';
$string['jsreactivated'] = 'Вы включили анимированную навигацию для своей учетной записи. Это может ускорить работу. Необходимо, чтобы был включен Javascript.';
$string['loading'] = 'Загрузка';
$string['modalmodules'] = 'Модальные модули';
$string['modalmodules_desc'] = 'Открывать эти элементы курса в модальном окне';
$string['modalresources'] = 'Модальные ресурсы';
$string['modalresources_desc'] = 'Открывать эти ресурсы в модальном окне';
$string['newsectionname'] = 'Новое название для темы {$a}';
$string['nexttopic'] = 'Следующая тема';
$string['noconnectionerror'] = 'Не удается загрузить контент. Проверьте соединение с Интернетом';
$string['nojswarning'] = 'Похоже, ваш браузер не поддерживает javascript или javascript отключен. Расширенный интерфейс будет доступен, если Вы включите javascript.';
$string['none'] = 'Нет';
$string['notcomplete'] = 'Не завершено';
$string['notrecommended'] = 'Не рекомендуется';
$string['other'] = 'Другие';
$string['outcomes'] = 'показатели';
$string['outcomesunavailable'] = 'Показатели недоступны';
$string['overall'] = 'Общий';
$string['overallprogress'] = 'Выполнение элементов курса — общий прогресс';
$string['overallprogressshort'] = 'Общий прогресс';
$string['pluginname'] = 'Плитки';
$string['previoustopic'] = 'Предыдущая тема';
$string['privacy:metadata:preference:format_tiles_stopjsnav'] = 'Отключил ли пользователь анимированную с помощью javascript навигацию';
$string['progress'] = 'Прогресс';
$string['reopenlastsection'] = 'Заново открыть последнюю посещенную плитку';
$string['reopenlastsection_desc'] = 'Если включен, то при повторном входе пользователя в курс ему будет показан последний раздел, который он открывал';
$string['resetallcoursecolours'] = 'Сбросить все цвета курса';
$string['resetcolours'] = 'Сбросить цвета';
$string['restorefailed'] = 'Не удалось восстановить';
$string['restoreincorrectsections'] = 'Ошибка: Невозможно завершить курс, так как исходный курс содержит неправильно пронумерованные разделы (например, номер раздела ({$a->sectionnum}) больше максимально допустимого ({$a->maxallowed}). Попробуйте исключить или удалить разделы с большими номерами.';
$string['restoretoomanysections'] = 'Ошибка: невозможно выполнить резервное копирование или восстановление, так как включено слишком много разделов курса ({$a->numsections}), а это больше, чем разрешено ({$a->maxallowed}). Попробуйте исключить или удалить некоторые разделы.';
$string['revealcontents'] = 'Показать содержимое плитки';
$string['section0name'] = 'Общее';
$string['sectionerrorstring'] = 'Возможно, что время вашей сессии истекло. Попробуйте обновить эту страницу.';
$string['sectionerrortitle'] = 'Ошибка загрузки контента';
$string['sectionname'] = 'Плитка';
$string['sectionnumber'] = 'Номер раздела / плитки';
$string['selected'] = 'Выбрано';
$string['setavailabletilecolours'] = 'Допустимые цвета плитки (для всего сайта)';
$string['settings'] = 'Настройки формата плиток';
$string['show'] = 'Показать';
$string['showalltiles'] = 'Показать все плитки';
$string['showfromothers'] = 'Показать плитку';
$string['showoverallprogress'] = 'Показать индикатор общего прогресса';
$string['showoverallprogress_desc'] = 'Показать индикатор «Общий прогресс %» в правом верхнем углу курса. Показанное значение представляет собой совокупность процентов завершения каждой плитки, основанную на завершении элементов, а не на завершении курса.';
$string['showprogresssphototiles_desc'] = 'Если выбрано, прогресс учащегося (например, Прогресс 2/5) будет отображаться на плитках с фотографиями.';
$string['showseczerocoursewide'] = 'Показать нулевой раздел сверху во всех разделах';
$string['showseczerocoursewide_desc'] = 'Если включен, то нулевой (самый верхний) раздел будет показан на главной странице курса и в самом начале <b>страницы каждого раздела курса</b> (то есть в самом верху содержимого каждой плитки).  Если выключен (рекомендуется), то он будет показан только на главной странице курса';
$string['showseparatewin'] = 'Показать файл в отдельном окне';
$string['sitename'] = 'Название сайта';
$string['snapwarning'] = 'Вы можете отредактировать курс в формате Tiles, используя другую тему, а затем вернуться к теме Snap после окончания редактирования.';
$string['subtileszeczerotoggled'] = 'Верхний раздел переключился между списком и форматом  вложенных плиток';
$string['sureresetcolours'] = 'Вы уверены, что хотите сбросить цвета плиток поля по умолчанию? Это повлияет на курсы ({$a})';
$string['tilecolourgeneral'] = 'Палитра цветов — дополнительный цвет';
$string['tilecolourgeneral_descr'] = 'Эти настройки позволяют администратору указать, какие цвета будут доступны учителям в курсах. Чтобы отключить конкретный цвет, установите для него значение черного цвета (#000). Если вы  здесь измените цвета, то никакие изменения не будут внесены в существующие курсы до тех пор, пока учитель в следующий раз не попытается изменить цвет плитки. При этом ему будут доступны только те цвета, которые вы установили здесь.';
$string['tilecolourschanged'] = 'Цвета плиток были сброшены. Все плитки теперь имеют цвета, соответствующие приведенным ниже.';
$string['tileicon'] = 'Значок для отображения только на этой плитке';
$string['tileicon_help'] = 'Выбранный здесь значок заменит для этой плитки любой значок, выбранный для плиток на уровне курса.';
$string['tileicons'] = 'Значки плиток';
$string['tileoutcome'] = 'Показатель для этой плитки';
$string['tileoutcome_help'] = 'Если Вы выбрали показатель для этой плитки, то затем в настройках курса Вы сможете отобразить набор <em>кнопок фильтра</em>, по одной для каждого показателя. При нажатии на эти кнопки будут отфильтрованы плитки, в соответствии с назначенными им показателями';
$string['tileselecttip'] = 'Вот более простой способ изменить значок или фотографию плитки: при включенном режиме редактирования курса просто щелкните значок или фотографию, которую хотите изменить. Появится окно выбора значков.';
$string['togglecompletion'] = 'Щелкните, чтобы переключить статус завершения';
$string['usejavascriptnav'] = 'Использовать навигацию javascript на главной странице с плитками';
$string['usejavascriptnav_desc'] = 'При включенном параметре, если пользователь щелкает мышью на плитке на главной странице курса и javascript включен, то JS будет использован для перехода к содержимому плитки. Содержимое плитки будет храниться локально в браузере в соответствии с настройками, заданными ниже. Если параметр отключен, JS не будет использован и вместо него будет применяться стандартная навигация, остальные настройки JS будут проигнорированы.';
$string['usejsnavforsinglesection'] = 'Использовать навигацию JS для страницы с одним разделом';
$string['usejsnavforsinglesection_desc'] = 'Если включен, любой вызов страницы с одним разделом  (§ion=xx) будет обрабатываться с помощью javascript, выполняя запуск главной страницы курса и анимацию открытия запрошенного раздела посредством JS вместо того, чтобы вызывать старомодную PHP-страницу с одним разделом.';
$string['usesubtilesseczero'] = 'Использовать вложенные плитки в верхнем разделе';
$string['usesubtilesseczero_help'] = 'Если включен, вложенные плитки будут использоваться в верхнем разделе курса так же, как и во всех остальных плитках. Отображение в виде вложенных плиток может занимать много места в самом верху курса. Может быть стоит оставить этот параметр выключенным, чтобы все элементы в верхнем разделе отображались в формате стандартного списка.';
