<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'geogebra', language 'sr_lt', version '4.1'.
 *
 * @package     geogebra
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['activityclosed'] = 'Ova aktivnost je završena';
$string['activitynotopened'] = 'Ova aktivnost još nije dostupna';
$string['attempt'] = 'Pokušaj';
$string['attempts'] = 'Pokušaji';
$string['attemptsremaining'] = 'Preostali pokušaji za ovu aktivnost';
$string['autograde'] = 'Aktivnost koja se samostalno ocenjuje';
$string['availabledate'] = 'Dostupno od';
$string['average'] = 'Prosek';
$string['choosescripttype'] = 'Odaberite tip skripta';
$string['codebase'] = 'Lokacija GeoGebra kodne baze';
$string['codebase_desc'] = 'Lokacija GeoGebra kodne baze. Korisno za oflajn režim.';
$string['comment'] = 'Komentar';
$string['configintro'] = 'Ovde podešene vrednosti definišu podrazumevane URL adrese sa kojih će se učitati GeoGebra.';
$string['contentheader'] = 'Sadržaj';
$string['coursewithoutstudents'] = 'Kurs na kom nema polaznika';
$string['datestudent'] = 'Poslednji put izmenjeno (predat rad)';
$string['dateteacher'] = 'Poslednji put izmenjeno (ocena)';
$string['deleteallattempts'] = 'Obriši sve pokušaje';
$string['deployggb'] = 'URL adresa za distribuciju modula GeoGebra';
$string['deployggb_desc'] = 'URL adresa za distributivnu datoteku deployggb.js. Obično treba da ukazuje na www.geogebratube.org. Može biti lokalna datoteka.';
$string['description'] = 'Opis';
$string['discardchanges'] = 'Poništi izmene i vrati se';
$string['duedate'] = 'Rok';
$string['duration'] = 'Trajanje';
$string['enableLabelDrags'] = 'Omogući prevlačenje labela';
$string['enableRightClick'] = 'Omogući desni klik';
$string['errorattempt'] = 'Greška: pokušaj nije mogao biti sačuvan.';
$string['event_course_module_viewed'] = 'Prikazan je modul kursa';
$string['event_instances_list_viewed'] = 'Prikazana je lista instanci';
$string['expired'] = 'Nažalost ova aktivnost je zatvorena na dan {$a} i nije više dostupna';
$string['extractedfromggb'] = 'datoteke izdvojene iz datoteke ggb formata';
$string['fflate'] = 'URL adresa za fflate distribuciju';
$string['fflate_desc'] = 'URL adresa za JavaScript biblioteku ”fast flate script” koji se koristi za raspakivanje GeoGebra javascript datoteka.';
$string['filename'] = 'Naziv datoteke';
$string['filenotfound'] = 'Navedena datoteka ne postoji';
$string['filetype'] = 'Tip';
$string['filetype_help'] = 'Ovo podešavanje određuje kako se GeoGebra aktivnost uključuje u kurs. Moguće su 2 opcije:

* Postavljena GeoGebra - Omogućava da se valjan ".ggb" paket odabere pomoću birača datoteka.
* Eksterni URL - Omogućava da se navede URL. Napomena: URL mora počinjati sa http(s) ili www i sadrži valjanu ".ggb" datoteku.';
$string['filetypeexternal'] = 'Eksterni URL';
$string['filetypelocal'] = 'Postavljena datoteka';
$string['firstattempt'] = 'Prvi pokušaj';
$string['for'] = 'za';
$string['functionalityoptionsgrp'] = 'Funkcionalnost';
$string['geogebra:addinstance'] = 'Dodaj GeoGebra aktivnost';
$string['geogebra:grade'] = 'Oceni GeoGebra aktivnost';
$string['geogebra:submit'] = 'Predaj GeoGebra aktivnost';
$string['geogebra:view'] = 'Prikaži GeoGebra aktivnost';
$string['geogebrafile'] = 'GeoGebra datoteka';
$string['geogebrafile_help'] = '.ggb datoteka';
$string['geogebraurl'] = 'URL';
$string['geogebraurl_help'] = 'Pronađite konstrukciju na <a href="https://www.geogebra.org/" target="_blank">geogebra.org</a>, idite na <strong> Detalji </strong>, zatim kliknite desnim tasterom miša na <strong>Preuzimanje</strong> i izaberite <strong>Kopiraj adresu linka</strong>. Na kraju, idite na polje za URL adresu i kopirajte link sa <strong>Ctrl+V</strong>.<br/>Pogledajte primer ”korak po korak” u video klipu: <a href="https://youtu.be/qbp-RuM4NpU" target="_blank">https://youtu.be/qbp-RuM4NpU</a>.';
$string['grade'] = 'Ocena';
$string['gradeit'] = 'Oceni';
$string['grademethod'] = 'Metod ocenjivanja';
$string['header_geogebra'] = 'GeoGebra parametri';
$string['height'] = 'Visina';
$string['height_help'] = 'Vrednost u pikselima. Mora biti veća od nule.';
$string['highestattempt'] = 'Najbolji pokušaj';
$string['httpnotallowed'] = 'Trenutno nije dozvoljeno korišćenje eksternih datoteka';
$string['interfaceoptionsgrp'] = 'Korisnički interfejs';
$string['invalidgeogebrafile'] = 'Nije data validna GeoGebra datoteka. Mora imati ekstenziju ".ggb".';
$string['invalidurl'] = 'Nije dat validan URL. Mora počinjati sa http(s) i biti validna ".ggb" datoteka.';
$string['language'] = 'Jezik';
$string['lastattempt'] = 'Poslednji pokušaj';
$string['lastattemptremaining'] = 'Ovo je vaš poslednji pokušaj za ovu aktivnost';
$string['lastmodifiedgrade'] = 'Poslednja izmena (ocena)';
$string['lastmodifiedsubmission'] = 'Poslednja izmena (predati rad)';
$string['lowestattempt'] = 'Najlošiji pokušaj';
$string['manualgrade'] = 'Da li se ocenjuje ručno?';
$string['maxattempts'] = 'Maksimalan broj pokušaja';
$string['modulename'] = 'GeoGebra';
$string['modulename_help'] = '<p><a href="https://www.geogebra.org" target="_blank">GeoGebra</a> je besplatan, multiplatformski, dinamički matematički softver za sve nivoe obrazovanja koji udružuje geometriju, algebru, tebele, grafike, statistiku i proračune u jedan paket koji je lak za korišćenje.</p>
<p>Stoga je <a href="http://www.gencat.cat/ensenyament/" target="_blank">Departman za obrazovanje u Kataloniji</a> u saradnji sa <a href="https://acgeogebra.cat/" target="_blank">Katalonskom GeoGebra asocijacijom</a> (ACG) i GeoGeobra razvojnim timom implementirao ovaj modul koji dozvoljava inkorporaciju GeoGebra aktivnosti u Moodle. NJegove osnovne odlike su:
<ul>
    <li>Dozvoljava lako ugrađivanje GeoGebra aktivnosti u Moodle kurseve.</li>
    <li>Olakšava praćenje rada polaznika jer čuva njihove rezultate, kao i datum, trajanje i izradu svakog njihovog pokušaja.</li>
    <li>Polaznici mogu da sačuvaju trenutno stanje aktivnosti da bi se kasnije vratili na njih.</li>
</ul>
</p>';
$string['modulenameplural'] = 'GeoGebra';
$string['msg_noattempts'] = 'Radili ste ovu aktivnost maksimalan broj puta';
$string['msg_nosessions'] = 'Ova Geogebra aktivnost još nema nijednu sesiju';
$string['name'] = 'Ime';
$string['noattempts'] = '-';
$string['nograding'] = 'Bez ocenjivanja';
$string['nomoreattempts'] = 'Nije preostalo više pokušaja za ovu aktivnost';
$string['notopenyet'] = 'Nažalost ova aktivnost neće biti raspoloživa do {$a}';
$string['pluginadministration'] = 'Administracija GeoGebra aktivnosti';
$string['pluginname'] = 'GeoGebra';
$string['preview_geogebra'] = 'Pregled Geogebra aktivnosti';
$string['previewtab'] = 'Prikaz';
$string['privacy'] = 'Privatnost rezultata';
$string['privacy:metadata:geogebra_attempts'] = 'Informacije o rezultatima pokušaja korisnika za datu Geogebra aktivnost';
$string['privacy:metadata:geogebra_attempts:datestudent'] = 'Vremenska oznaka koja pokazuje kada je polaznik završio pokušaj';
$string['privacy:metadata:geogebra_attempts:dateteacher'] = 'Vremenska oznaka koja pokazuje kada je predavač završio pokušaj';
$string['privacy:metadata:geogebra_attempts:finished'] = 'Vremenska oznaka koja pokazuje kada je korisnik završio pokušaj';
$string['privacy:metadata:geogebra_attempts:gradecomment'] = 'Komentar ocene za pokušaj rešavanja Geogebra aktivnosti.';
$string['privacy:metadata:geogebra_attempts:userid'] = 'ID oznaka korisnika koji odgovara na ovu Geogebra aktivnost';
$string['privacy:metadata:geogebra_attempts:vars'] = 'ID oznaka opcije koju je korisnik izabrao.';
$string['redirecttocourse'] = 'Aktivnost je sačuvana. Bićete preusmereni na početnu stranicu.';
$string['report'] = 'Izveštaj o';
$string['results'] = 'Rezultati';
$string['resultstab'] = 'Rezultati';
$string['resumeattempt'] = 'Nastavak nezavršenog pokušaja';
$string['review'] = 'Pregled za';
$string['reviewtab'] = 'Pregled';
$string['savechanges'] = 'Sačuvaj izmene';
$string['savewithoutsubmitting'] = 'Sačuvaj bez predaje rada';
$string['seed'] = 'Početna vrednost';
$string['seed_help'] = 'Početna vrednost (tzv. ”seed ”) može biti pozitivan broj između 0 i 99. Ako je nula, nasumično generisana Geogebra aktivnost biće drugačija pri svakom ponovnom učitavanju. Ako nije nula, nakon ponovnog učitavanja, prikazuje se ista nasumična verzija. Korišćenje dva različite početne vrednosti će dati dve različite nasumične verzije. Koristite nulu kao početnu vrednost kako biste svakom polazniku dali drugačiji test. Upotrebite početnu vrednost koja nije nula za probno uvežbavanje testa kako biste bili sigurni da su svi polaznici dobili isti test.';
$string['settings'] = 'Podešavanja';
$string['showAlgebraInput'] = 'Prikaži traku za unos';
$string['showMenuBar'] = 'Prikaži traku menija';
$string['showResetIcon'] = 'Prikaži ikonicu za resetovanje konstrukcije';
$string['showToolBar'] = 'Prikaži paletu alatki';
$string['showToolBarHelp'] = 'Prikaži pomoć za paletu alatki';
$string['showsubmit'] = 'Prikaži dugme za predaju rada';
$string['status'] = 'Status';
$string['submitandfinish'] = 'Predaj urađeno i završi sa radom';
$string['timing'] = 'Podešavanje vremena';
$string['total'] = 'Ukupno';
$string['unfinished'] = 'Nezavršeno';
$string['ungraded'] = 'Neocenjeno';
$string['unlimitedattempts'] = 'Neograničeni broj pokušaja za ovu aktivnost';
$string['urledit'] = 'GeoGebra datoteka';
$string['urledit_help'] = '".ggb" datoteka u kojoj ćete naći GeoGebra aktivnost.';
$string['urlggb'] = 'URL adresa za prilagođenu implementaciju';
$string['urlggb_help'] = 'Alternativna URL adresa za datoteku deployggb.js, tj. gde se nalazi GeoGebra distribucija. Ako je podešen, URL adresa će se koristiti umesto podrazumevane vrednosti konfigurisane u podešavanjima modula. Obično, ovo polje može ostati prazno.';
$string['useBrowserForJS'] = 'Koristi JavaScript sa:';
$string['useBrowserForJS_geogebra'] = 'GeoGebra datoteka (false)';
$string['useBrowserForJS_html'] = 'HTML (true)';
$string['view'] = 'Prikaži';
$string['viewattempt'] = 'Prikaži pokušaj';
$string['viewattempts'] = 'Prikaži pokušaje';
$string['viewattempttab'] = 'Prikaz pokušaja';
$string['viewtab'] = 'Prikaz';
$string['weight'] = 'Težina';
$string['width'] = 'Širina';
$string['width_help'] = 'Vrednost u pikselima. Mora biti veća od nule.';
