<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'backup', language 'sk', version '4.1'.
 *
 * @package     backup
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['asyncbackupcomplete'] = 'Proces zálohovania bol dokončený';
$string['asyncbackupcompletebutton'] = 'Pokračovať';
$string['asyncbackupcompletedetail'] = 'Proces zálohovania bol úspešne dokončený. <br/>Zálohu môžete otvoriť na stránke <a href="{$a}"> obnoviť. </a>';
$string['asyncbackuperror'] = 'Proces zálohovania zlyhal';
$string['asyncbackuperrordetail'] = 'Proces zálohovania zlyhal. Kontaktujte administrátora systému.';
$string['asyncbackuppending'] = 'Proces zálohovania čaká na vybavenie';
$string['asyncbackupprocessing'] = 'Prebieha zálohovanie';
$string['asyncbadexecution'] = 'Zlyhalo vykonávanie ovládača záloh. Je {$a} a malo by byť 2';
$string['asynccheckprogress'] = 'Priebeh môžete kedykoľvek skontrolovať na  <a href="{$a}"> obnova stránky. </a>';
$string['asyncemailenable'] = 'Povoliť upozornenia na správy';
$string['asyncemailenabledetail'] = 'Ak je táto možnosť aktivovaná, používatelia dostanú správu pri dokončení asynchrónneho zálohovania alebo obnovy.';
$string['asyncgeneralsettings'] = 'Asynchrónne zálohovanie/obnovenie';
$string['asyncmessagebody'] = 'Správa';
$string['asyncmessagebodydefault'] = 'Vaša {operácia} (ID: {backupid}) bola úspešne dokončená. Prístup k nej získate tu: <a href="{link}">{link}</a>.';
$string['asyncmessagebodydetail'] = 'Správa, ktorá bude odoslaná pri dokončení asynchrónneho obnovenia alebo zálohovania.';
$string['asyncmessagesubject'] = 'Predmet';
$string['asyncmessagesubjectdefault'] = 'Moodle {operation} úspešně dokončená';
$string['asyncmessagesubjectdetail'] = 'Predmet správy';
$string['asyncnowait'] = 'Nemusíte tu čakať, proces bude pokračovať na pozadí.';
$string['asyncprocesspending'] = 'Čaká sa na vybavenie';
$string['asyncrestorecomplete'] = 'Proces obnovy bol dokončený';
$string['asyncrestorecompletebutton'] = 'Pokračovať';
$string['asyncrestorecompletedetail'] = 'Proces obnovenia bol úspešne dokončený. Kliknutím na tlačidlo Pokračovať prejdite na <a href="{$a}"> kurz pre obnovenú položku. </a>';
$string['asyncrestoreerror'] = 'Proces obnovy zlyhal';
$string['asyncrestoreerrordetail'] = 'Proces obnovy zlyhal. Obráťte sa na administrátora systému.';
$string['asyncrestoreinprogress'] = 'Prebieha obnova';
$string['asyncrestoreinprogress_help'] = 'Asynchrónna obnova kurzu práve prebieha a jej priebeh je zobrazený tu.';
$string['asyncrestorepending'] = 'Proces obnovy čaká na vybavenie';
$string['asyncrestoreprocessing'] = 'Prebieha obnova';
$string['asyncreturn'] = 'Návrat do kurzu';
$string['autoactivedescription'] = 'Či sa majú vykonávať automatické zálohy. V prípade zvolenia možnosti "Ručne", automatické zálohy sú možné len cez automatizovaný CLI skript. Ten môže byť spustený buď ručne alebo pomocou naplánovanej úlohy (cron) na serveri.';
$string['autoactivedisabled'] = 'Zakázané';
$string['autoactiveenabled'] = 'Povolené';
$string['autoactivemanual'] = 'Ručne';
$string['automatedbackupschedule'] = 'Zoznam';
$string['automatedbackupschedulehelp'] = 'Zvoľte dni v týždni, kedy majú byť spúšťané automatizované zálohovania.';
$string['automatedbackupsinactive'] = 'Automatické zálohy neboli administrátorom  povolené';
$string['automatedbackupstatus'] = 'Zoznam o stave zálohovania';
$string['automateddeletedays'] = 'Odstrániť zálohy staršie než';
$string['automatedmaxkept'] = 'Maximálny počet uchovávaných záloh';
$string['automatedmaxkepthelp'] = 'Určuje maximálny počet posledných automatizovaných záloh, ktoré majú byť uchovávané pre každý kurz. Staršie zálohy budú automaticky zmazané.';
$string['automatedminkept'] = 'Minimálny počet uchovávaných záloh';
$string['automatedminkepthelp'] = 'Ak sú vymazané zálohy staršie ako špecifikovaný počet dní, môže sa stať, že neaktívny kurz skonči bez záloh. Pre zabránenie tohto je potrebné zvoliť minimálny počet ukladaných záloh.';
$string['automatedsettings'] = 'Nastavenia plánovania zálohovania';
$string['automatedsetup'] = 'Nastavenie automatického zálohovania';
$string['automatedstorage'] = 'Úložisko pre automatické zálohovanie';
$string['automatedstoragehelp'] = 'Vyberte si miesto, kde chcete uložiť zálohy, ktoré budú vytvorené automaticky.';
$string['backupactivity'] = 'Zálohovať aktivitu: {$a}';
$string['backupautoactivitiesdescription'] = 'Nastavuje predvolené nastavenie pre zahrnutie aktivít do zálohy. Aby kôš fungoval, musí byť toto nastavenie povolené.';
$string['backupcourse'] = 'Zálohovať kurz: {$a}';
$string['backupcoursedetails'] = 'Podrobnosti kurzu';
$string['backupcoursesection'] = 'Sekcia {$a}';
$string['backupcoursesections'] = 'Sekcie kurzu';
$string['backupdate'] = 'Dátum zálohovania';
$string['backupdetails'] = 'Podrobnosti zálohovania';
$string['backupdetailsnonstandardinfo'] = 'Vybraný súbor nie je štandardný Moodle zálohový súbor. Obnovovací proces sa pokúsi o konverziu súboru do štandardného formátu a následné obnovenie.';
$string['backupformat'] = 'Formát';
$string['backupformatimscc1'] = 'IMS Common Cartridge 1.0';
$string['backupformatimscc11'] = 'IMS Common Cartridge 1.1';
$string['backupformatmoodle1'] = 'Moodle 1';
$string['backupformatmoodle2'] = 'Moodle 2';
$string['backupformatunknown'] = 'Neznámy formát';
$string['backuplog'] = 'Technické informácie a upozornenia';
$string['backupmode'] = 'Mód';
$string['backupmode10'] = 'Všeobecný';
$string['backupmode20'] = 'Import';
$string['backupmode30'] = 'Hub';
$string['backupmode40'] = 'Z rovnakého servera';
$string['backupmode50'] = 'Automatizovaný';
$string['backupmode60'] = 'Konvertovaný';
$string['backupmode70'] = 'Asynchrónny';
$string['backupsection'] = 'Zálohovať sekciu kurzu: {$a}';
$string['backupsettings'] = 'Nastavenia zálohovania';
$string['backupsitedetails'] = 'Podrobnosti stránky';
$string['backupstage16action'] = 'Pokračovať';
$string['backupstage1action'] = 'Ďalej';
$string['backupstage2action'] = 'Ďalej';
$string['backupstage4action'] = 'Vykonať zálohu';
$string['backupstage8action'] = 'Pokračovať';
$string['backuptype'] = 'Typ';
$string['backuptypeactivity'] = 'Aktivita';
$string['backuptypecourse'] = 'Kurz';
$string['backuptypesection'] = 'Sekcia';
$string['backupversion'] = 'Verzia zálohy';
$string['cannotfindassignablerole'] = 'Rolu {$a} v zálohe nie je možné prideliť k žiadnej inej, ktorú máte právo vy prideľovať.';
$string['choosefilefromactivitybackup'] = 'Priestor záloh aktivít';
$string['choosefilefromactivitybackup_help'] = 'Ak sa zálohujú aktivity použitím východzím nastavení, súbory záloh budú umiestnené tu.';
$string['choosefilefromautomatedbackup'] = 'Automaticky vytvorené zálohy.';
$string['choosefilefromautomatedbackup_help'] = 'Obsahuje automaticky vytvorené zálohy.';
$string['choosefilefromcoursebackup'] = 'Oblasť so zálohami kurzov';
$string['choosefilefromcoursebackup_help'] = 'Pri východzom spôsobe zálohovania kurzov sa budú súbory záloh ukladať sem';
$string['choosefilefromuserbackup'] = 'Oblasť pre súkromné zálohy kurzov';
$string['choosefilefromuserbackup_help'] = 'Súbory záloh vytvorené s anonymizovanými používateľmi sú uložené tu.';
$string['config_keep_groups_and_groupings'] = 'Vo východzom nastavení zachovať existujúce skupiny a zoskupenia.';
$string['config_keep_roles_and_enrolments'] = 'Vo východzom nastavení zachovať existujúce role a zápisy.';
$string['config_overwrite_conf'] = 'Umožňuje používateľovi prepísať aktuálnu konfiguráciu kurzu';
$string['config_overwrite_course_fullname'] = 'Vo východzom nastavení prepísať celý názov kurzu názvom zo záložného súboru. To vyžaduje oprávnenie  „Prepísať konfiguráciu kurzu“, ktoré majú byť kontrolované a aktuálny používateľ musí mať možnosť zmeniť názov kurzu (moodle/course:changefullname)';
$string['config_overwrite_course_shortname'] = 'Vo východzom nastavení prepísať krátky názov kurzu názvom zo záložného súboru. To vyžaduje oprávnenie „Prepísať konfiguráciu kurzu“, ktoré majú byť kontrolované a aktuálny používateľ musí mať možnosť zmeniť krátky názov kurzu (moodle/course:changeshortname)';
$string['config_overwrite_course_startdate'] = 'Vo východzom nastavení prepísať dátum kurzu dátumom zo záložného súboru. To vyžaduje oprávnenie „Prepísať konfiguráciu kurzu“, ktoré majú byť kontrolované a aktuálny používateľ musí mať možnosť zapísať dátum do obnoveného kurzu (moodle/restore:rolldates)';
$string['configgeneralactivities'] = 'Nastaví východzie parametre pre zahrnutie aktivít do zálohy';
$string['configgeneralanonymize'] = 'Pri zvolení, východzie nastavenie bude, že žiadne informácie patriace užívateľom, nebudú zverejnené.  ';
$string['configgeneralbadges'] = 'Nastavenie východzích hodnôt pre zahrnutie odznakov do záloh.';
$string['configgeneralblocks'] = 'Nastaví východzie parametre pre zahrnutie blokov do zálohy.';
$string['configgeneralcalendarevents'] = 'Nastavenie východzej hodnoty pre zahrnutie udalostí kalendára do záloh.';
$string['configgeneralcomments'] = 'Nastaví východzie parametre pre zahrnutie komentov do zálohy.';
$string['configgeneralcompetencies'] = 'Nastavenie východzej hodnoty pre zahrnutie kompetencií do záloh.';
$string['configgeneralcontentbankcontent'] = 'Nastavenie východzej hodnoty pre zahrnutie obsahu banky obsahu do záloh.';
$string['configgeneralfiles'] = 'Nastaví východzie nastavenie pre zahrnutie súborov do zálohy. Poznámka: Zákaz tohoto nastavenia bude mať za následok zálohu, ktorá zahrňuje iba odkazy na súbory. To nie je  problém, ak je záloha obnovená na rovnakom portáli a súbory neboli odstránené nastavením „Vysypať kôš“ (filescleanupperiod).';
$string['configgeneralfilters'] = 'Nastaví východzie parametre pre zahrnutie filtrov do zálohy.';
$string['configgeneralgroups'] = 'Nastaviť východzie parametre pre zahrnutie skupín a zoskupení do zálohy';
$string['configgeneralhistories'] = 'Nastaví východzie parametre pre zahrnutie histórie užívateľov do zálohy.';
$string['configgenerallogs'] = 'Pri zvolení východzieho nastavenia, zálohy bude obsahovať logy.';
$string['configgeneralpermissions'] = 'Ak je povolené, budú importované oprávnenia role. To môže prepísať existujúce oprávnenia pre registrovaných používateľov.';
$string['configgeneralquestionbank'] = 'Či do záloh zahrnúť banku úloh. POZNÁMKA: Vypnutím tohto nastavenia sa vypne zálohovanie činností, ktoré využívajú banku úloh, ako je test.';
$string['configgeneralroleassignments'] = 'Pri zvolení, východzie nastavenie bude, že záloha bude obsahovať aj role.';
$string['configgeneralusers'] = 'Nastaviť východzie hodnoty, či zahrnúť používateľov v zálohách.';
$string['configgeneraluserscompletion'] = 'Ak je zapnuté, bude informácia o dokončení kurzu používateľom zahrnutá v zálohách. ';
$string['configlegacyfiles'] = 'Nastaví východziu hodnotu pre zahrnutie starších súborov kurzu do zálohy. Staršie súbory kurzov pochádzajú z verzií Moodle starších ako 2.0.';
$string['configloglifetime'] = 'Toto nastavenie určuje čas, počas ktorého chcete zachovať protokoly o zálohách. Záznamy, ktoré sú staršie ako tento dátum, sú automaticky vymazané. Odporúčame nechať túto hodnotu nízku, keďže tieto protokoly môžu zabrať veľké množstvo miesta.';
$string['configrestoreactivities'] = 'Nastaviť východzie nastavenia pre obnovenie aktivít.';
$string['configrestorebadges'] = 'Nastaviť východzie nastavenia pre obnovenie odznakov.';
$string['configrestoreblocks'] = 'Nastaviť východzie nastavenia pre obnovenie blokov.';
$string['configrestorecalendarevents'] = 'Nastaviť východzie nastavenia pre obnovenie udalostí kalendára.';
$string['configrestorecomments'] = 'Nastaviť východzie nastavenia pre obnovenie komentárov.';
$string['configrestorecompetencies'] = 'Nastaviť východzie nastavenia pre obnovenie kompetencií.';
$string['configrestorecontentbankcontent'] = 'Nastaviť východzie nastavenia pre obnovenie obsahu banky obsahu.';
$string['configrestoreenrolments'] = 'Nastaviť východzie nastavenia pre obnovenie metód zápisu';
$string['configrestorefilters'] = 'Nastaviť východzie nastavenia pre obnovenie filtrov.';
$string['configrestoregroups'] = 'V prípade, že boli skupiny a zoskupenia zaradené do zálohy, nastaviť ich východzie hodnoty.';
$string['configrestorehistories'] = 'V prípade, že bol používateľ zaradený do zálohy, nastaviť východzie hodnoty pre obnovenie histórie používateľa.';
$string['configrestorelogs'] = 'Ak je povolené, budú štandardne obnovené protokoly, ak boli zahrnuté do zálohy.';
$string['configrestorepermissions'] = 'Ak je povolené, budú obnovené oprávnenia role. To môže prepísať existujúce oprávnenia pre registrovaných používateľov.';
$string['configrestoreroleassignments'] = 'Ak je povolené, budú štandardne obnovené priradenia rolí, ak boli zahrnuté do zálohy.';
$string['configrestoreusers'] = 'Určí východzie hodnoty nastavenia obnovy používateľov, ak boli zahrnuté do zálohy.';
$string['configrestoreuserscompletion'] = 'Aj je povolené, budú štandardne obnovené údaje plnenia a absolvovania používateľov, ak boli zahrnuté do zálohy.';
$string['confirmcancel'] = 'Zrušiť zálohovanie';
$string['confirmcancelimport'] = 'Zrušiť import';
$string['confirmcancelno'] = 'Nezrušiť';
$string['confirmcancelquestion'] = 'Naozaj chcete ukončiť? Všetky informácie, ktoré ste vložili, budú stratené.';
$string['confirmcancelrestore'] = 'Zrušiť obnovenie';
$string['confirmcancelyes'] = 'Zrušiť zálohu';
$string['confirmnewcoursecontinue'] = 'Upozornenie na nový kurz';
$string['confirmnewcoursecontinuequestion'] = 'Počas obnovy bude vytvorený dočasný (skrytý) kurz. Pre prerušenie obnovy kliknite na zrušiť. Nezatvárajte Váš prehliadač počas obnovy.';
$string['copiesinprogress'] = 'V tomto kurze prebiehajú kópie. <a href="{$a}"> Zobraziť priebeh kopírovania. </a>';
$string['copycoursedesc'] = 'Tento kurz bude dupikovaný a zaradený do vybranej kategórie kurzu.';
$string['copycourseheading'] = 'Kopírovať kurz';
$string['copycoursetitle'] = 'Kopírovať kurz: {$a}';
$string['copydest'] = 'Cieľ';
$string['copyfieldnotfound'] = 'Nenašli sa požadované údaje polí pre polia: {$a}';
$string['copyformfail'] = 'AJAX odoslanie formulára kópie kurzu sa nepodarilo.';
$string['copyingcourse'] = 'Prebieha kopírovanie kurzu';
$string['copyingcourseshortname'] = 'kopírovanie';
$string['copyop'] = 'Aktuálna operácia';
$string['copyprogressheading'] = 'Prebieha kopírovanie kurzu';
$string['copyprogressheading_help'] = 'Táto tabuľka ukazuje stav všetkých vašich nedokončených kópií kurzu.';
$string['copyprogresstitle'] = 'Priebeh kopírovania kurzu';
$string['copyreturn'] = 'Skopírovať a späť';
$string['copysource'] = 'Zdroj';
$string['copyview'] = 'Skopírovať a zobraziť';
$string['coursecategory'] = 'Kategória, do ktorej bude kurz obnovený';
$string['courseid'] = 'Originál ID číslo';
$string['coursesettings'] = 'Nastavenia kurzu';
$string['coursetitle'] = 'Názov';
$string['currentstage1'] = 'Počiatočné nastavenia';
$string['currentstage16'] = 'Ukončené';
$string['currentstage2'] = 'Podrobný výber';
$string['currentstage4'] = 'Potvrdenie a kontrola';
$string['currentstage8'] = 'Vykonať zálohu';
$string['enableasyncbackup'] = 'Povoliť asynchrónne zálohy';
$string['enableasyncbackup_help'] = 'Ak je povolené, budú vykonané všetky operácie zálohovania a obnovy asynchrónne. To nemá vplyv na import a export. Asynchrónne zálohovanie a obnova umožňuje používateľom vykonávať iné operácie, kým prebieha zálohovanie alebo obnova.';
$string['enterasearch'] = 'Zadajte vyhľadávanie';
$string['error_block_for_module_not_found'] = 'Našla sa osamotená instancia bloku (id: {$a->bid}) pre modul kurzu (id: {$a->mid}). Tento blok nebude zálohovaný.';
$string['error_course_module_not_found'] = 'Našiel sa osamotený modul kurzu (id: {$a}). Tento modul nebude zálohovaný.';
$string['errorcopyingbackupfile'] = 'Pred obnovením sa nepodarilo skopírovať záložný súbor do dočasného priečinku.';
$string['errorfilenamemustbezip'] = 'Názov, ktorý zvolíte, musí byť ZIP súbor a mať príponu .mbs';
$string['errorfilenamerequired'] = 'Musíte zadať platný názov súboru zálohy';
$string['errorfilenametoolong'] = 'Názov súboru musí mať dĺžku menšiu než 255 znakov.';
$string['errorinvalidformat'] = 'Neznámy formát záloh.';
$string['errorinvalidformatinfo'] = 'Vybraný súbor nie je platný zálohový súbor Moodle a  nemôže byť obnovený.';
$string['errorminbackup20version'] = 'Tento záložný súbor bol vytvorený vývojovou verziou Moodle zálohovania ({$a->backup}). Minimálna požadovaná je  {$a->min}. Nemôže byť obnovený.';
$string['errorrestorefrontpagebackup'] = 'Na titulnej stránke môžete obnoviť iba zálohu titulnej stránky.';
$string['executionsuccess'] = 'Súbor zálohy bol úspešne vytvorený.';
$string['extractingbackupfileto'] = 'Extrahovanie záložného súboru do: {$a}';
$string['failed'] = 'Záloha sa nepodarila';
$string['filealiasesrestorefailures'] = 'Zlyhalo obnovenie zástupcov.';
$string['filealiasesrestorefailures_help'] = 'Zástupcovia sú symbolické odkazy na iné súbory, včítane tých uložených v externých úložiskách. V niektorých prípadoch ich Moodle nedokáže obnoviť – napríklad pri obnove zálohy na inom serveri, alebo ak odkazovaný súbor neexistuje.

Ďalšie podrobnosti a aktuálny dôvod zlyhania je možné nájsť v protokole obnovy.';
$string['filealiasesrestorefailures_link'] = 'restore/filealiases';
$string['filealiasesrestorefailuresinfo'] = 'Nie je možné obnoviť niektorých zástupcov zahrnutých v súbore záloh. Nasledujúci zoznam obsahuje ich očakávané umiestnenie a zdrojový súbor odkazujúci na pôvodné miesto.';
$string['filename'] = 'Názov súboru';
$string['filereferencesincluded'] = 'Záloha obsahuje odkazy na externé súbory. Tieto nebudú fungovať, ak je záloha obnovená na inom portáli.';
$string['filereferencesnotsamesite'] = 'Záloha je z iného serveru, niektoré odkazy na súbory nemôžu byť obnovené.';
$string['filereferencessamesite'] = 'Záloha je z rovnakého serveru, takže odkazy na súbory môžu byť obnovené.';
$string['generalactivities'] = 'Zahrnúť aktivity a zdroje';
$string['generalanonymize'] = 'Anonymné informácie';
$string['generalbackdefaults'] = 'Východzie nastavenia zálohovania';
$string['generalbadges'] = 'Zahrnúť odznaky';
$string['generalblocks'] = 'Pridať bloky';
$string['generalcalendarevents'] = 'Zahrnúť udalosti z kalendára';
$string['generalcomments'] = 'Pridať komentáre';
$string['generalcompetencies'] = 'Zahrnúť kompetencie';
$string['generalcontentbankcontent'] = 'Zahrnúť obsah banky obsahu';
$string['generalenrolments'] = 'Zahrnúť metódy zápisu';
$string['generalfiles'] = 'Zahrnúť súbory';
$string['generalfilters'] = 'Pridať filtre';
$string['generalgradehistories'] = 'Pridať históriu známok';
$string['generalgroups'] = 'Zahrnúť skupiny a zoskupenia';
$string['generalhistories'] = 'Pridať históriu';
$string['generallegacyfiles'] = 'Zahrnúť staré súbory kurzov';
$string['generallogs'] = 'Pridať logy';
$string['generalpermissions'] = 'Zahrnúť prepísané oprávnenia';
$string['generalquestionbank'] = 'Zahrnúť banku otázok';
$string['generalrestoredefaults'] = 'Všeobecné východzie nastavenia obnovy';
$string['generalrestoresettings'] = 'Všeobecné nastavenia obnovenia';
$string['generalroleassignments'] = 'Zahrnúť priradenia rol';
$string['generalsettings'] = 'Všeobecné nastavenia pre zálohovanie';
$string['generalusers'] = 'Pridať užívateľov';
$string['generaluserscompletion'] = 'Zahrnúť informáciu o splnení aktivít v kurze';
$string['hidetypes'] = 'Skryť voľby typov modulov';
$string['importbackupstage16action'] = 'Pokračovať';
$string['importbackupstage1action'] = 'Ďalší';
$string['importbackupstage2action'] = 'Ďalší';
$string['importbackupstage4action'] = 'Vykonať import';
$string['importbackupstage8action'] = 'Pokračovať';
$string['importcurrentstage0'] = 'Výber kurzu';
$string['importcurrentstage1'] = 'Počiatočné nastavenie';
$string['importcurrentstage16'] = 'Kompletný';
$string['importcurrentstage2'] = 'Nastavenia schémy';
$string['importcurrentstage4'] = 'Potvrdenie a prehľad';
$string['importcurrentstage8'] = 'Vykonať import';
$string['importfile'] = 'Importovať súbor zálohy';
$string['importgeneralduplicateadminallowed'] = 'Povoliť riešenie konfliktu konta admin';
$string['importgeneralduplicateadminallowed_desc'] = 'Ak má portál účet s používateľským menom „admin“, potom pokus o obnovenie záložného súboru obsahujúceho účet s používateľským menom „admin“ môže spôsobiť konflikt. Ak je toto nastavenie povolené, konflikt sa vyrieši zmenou používateľského mena v záložnom súbore na „admin_xyz“.';
$string['importgeneralmaxresults'] = 'Maximálny počet kurzov zobrazených pre import';
$string['importgeneralmaxresults_desc'] = 'Určuje počet kurzov, ktoré sú zobrazené v prvom kroku procesu importu';
$string['importgeneralsettings'] = 'Východzie hodnoty importu';
$string['importrootsettings'] = 'Nastavenia importu';
$string['importsettings'] = 'Všeobecné nastavenia importu';
$string['importsuccess'] = 'Import je kompletný. Kliknite na tlačidlo Pokračovať pre návrat do kurzu.';
$string['includeactivities'] = 'Zahrnúť:';
$string['includeditems'] = 'Zahrnuté položky:';
$string['includefilereferences'] = 'Odkazy na externé súbory';
$string['includesection'] = 'Sekcia {$a}';
$string['includeuserinfo'] = 'Informácie o užívateľoch';
$string['inprogress'] = 'Prebieha zálohovanie';
$string['jumptofinalstep'] = 'Preskočiť na posledný krok';
$string['keep'] = 'Zachovať';
$string['keptroles'] = 'Zahrnúť zápisy rolí';
$string['keptroles_help'] = 'Používatelia s vybranými roľami budú zaradení do nového kurzu. Ak nie je povolená možnosť „Zahrnúť používateľské údaje“, žiadne používateľské údaje nebudú skopírované.';
$string['locked'] = 'Uzamknuté';
$string['lockedbyconfig'] = 'Toto nastavenie bolo uzamknuté východzím nastavením zálohy';
$string['lockedbyhierarchy'] = 'Zamknuté závislosťami';
$string['lockedbypermission'] = 'Nemáte dostatočné oprávnenie na zmenu tohto nastavenia';
$string['loglifetime'] = 'Zachovať protokoly';
$string['managefiles'] = 'Spravovať súbory záloh';
$string['mergerestoredefaults'] = 'Obnoviť východzie nastavenia pri zlúčení do iného kurzu';
$string['missingfilesinpool'] = 'Niektoré súbory nemohli byť počas zálohovania uložené, nebude ich možné obnoviť.';
$string['module'] = 'Modul';
$string['moodleversion'] = 'Verzia Moodle';
$string['morecoursesearchresults'] = 'Bolo nájdených viac ako {$a} kurzov, zobrazuje sa prvých {$a} výsledkov';
$string['moreresults'] = 'Bolo nájdených príliš veľa výsledkov, prosím zadajte presnejšie vyhľadávanie.';
$string['nomatchingcourses'] = 'Nie sú žiadne kurzy na zobrazenie';
$string['norestoreoptions'] = 'Neexistujú kategórie alebo existujúce kurzy, do ktorých môžete obnovovať.';
$string['originalwwwroot'] = 'URL odkaz zálohy';
$string['overwrite'] = 'Prepísať';
$string['pendingasyncdeletedetail'] = 'Tento kurz má čakajúcu asynchrónnu zálohu. <br/> Kurzy nie je možné vymazať, ak sa táto záloha nedokončí.';
$string['pendingasyncdetail'] = 'Asynchrónne zálohy umožňujú používateľovi mať iba jednu nevybavenú zálohu zdroja. <br/> Asynchrónne zálohy rovnakého zdroja nemôžu byť zaradené do fronty, co by pravdepodobne viedlo k viacerým zálohám s rovnakým obsahom.';
$string['pendingasyncedit'] = 'Pre tento kurz existuje nevybavená asynchrónna záloha. Tento kurz neupravujte, kým nebude zálohovanie dokončené.';
$string['pendingasyncerror'] = 'Čaká sa na dokončenie zálohy';
$string['preparingdata'] = 'Pripravujem dáta';
$string['preparingui'] = 'Príprava zobrazenia stránky';
$string['previousstage'] = 'Predošlý';
$string['privacy:metadata:backup:detailsofarchive'] = 'Tento archív môže obsahovať rôzne používateľské údaje týkajúce sa kurzu, ako napríklad známky, zápisy používateľov a údaje o činnostiach.';
$string['privacy:metadata:backup:externalpurpose'] = 'Účelom tohto archívu je ukladať informácie týkajúce sa kurzu, ktorý môže byť v budúcnosti obnovený.';
$string['privacy:metadata:backup_controllers'] = 'Zoznam operácií zálohovania';
$string['privacy:metadata:backup_controllers:itemid'] = 'ID kurzu';
$string['privacy:metadata:backup_controllers:operation'] = 'Operácia, ktorá bola vykonaná, napr. obnova.';
$string['privacy:metadata:backup_controllers:timecreated'] = 'Čas vytvorenia akcie';
$string['privacy:metadata:backup_controllers:timemodified'] = 'Čas úpravy akcie';
$string['privacy:metadata:backup_controllers:type'] = 'Typ položky, na ktorej sa pracuje, napríklad aktivita.';
$string['qcategory2coursefallback'] = 'Kategória testových úloh "{$a->name}", pôvodne umiestnená v systémovom kontexte alebo v kontexte kategórie kurzu v zálohe, bude pri obnove vytvorená v kontexte kurzu.';
$string['qcategorycannotberestored'] = 'Kategória otázok "{$a->name}" nemôže byť vytvorená pri obnove';
$string['question2coursefallback'] = 'Kategória testových úloh "{$a->name}", pôvodne umiestnená v systémovom kontexte alebo v kontexte kategórie kurzu v zálohe, bude pri obnove vytvorená v kontexte kurzu.';
$string['questioncannotberestored'] = 'Otázky "{$a->name}" nemôžu byť vytvorené pri obnove';
$string['recyclebin_desc'] = 'Tieto nastavenia budú použité aj pre kôš.';
$string['replacerestoredefaults'] = 'Obnoviť východzie hodnoty pri obnovovaní kurzu do iného kurzu s vymazaním obsahu';
$string['restoreactivity'] = 'Obnoviť aktivitu';
$string['restorecourse'] = 'Obnoviť kurz';
$string['restorecoursesettings'] = 'Nastavenia kurzu';
$string['restoredcourseid'] = 'Obnovený kurz ID: {$a}';
$string['restoreexecutionsuccess'] = 'Kurz bol úspešne obnovený.';
$string['restorefileweremissing'] = 'Niektoré súbory nemohli byť obnovené, pretože chýbali v zálohe.';
$string['restorenewcoursefullname'] = 'Nový názov kurzu';
$string['restorenewcourseshortname'] = 'Nový skrátený názov kurzu';
$string['restorenewcoursestartdate'] = 'Nový začiatočný dátum kurzu';
$string['restorerolemappings'] = 'Obnoviť mapovanie rol';
$string['restorerootsettings'] = 'Obnoviť nastavenia';
$string['restoresection'] = 'Obnoviť sekciu';
$string['restorestage1'] = 'Povrdiť';
$string['restorestage16'] = 'Skontrolovať';
$string['restorestage16action'] = 'Vykonať obnovu';
$string['restorestage1action'] = 'Ďalej';
$string['restorestage2'] = 'Miesto určenia';
$string['restorestage2action'] = 'Ďalej';
$string['restorestage32'] = 'Vykonať';
$string['restorestage32action'] = 'Pokračovať';
$string['restorestage4'] = 'Nastavenia';
$string['restorestage4action'] = 'Ďalej';
$string['restorestage64'] = 'Ukončenie';
$string['restorestage64action'] = 'Pokračovať';
$string['restorestage8'] = 'Schéma';
$string['restorestage8action'] = 'Ďalej';
$string['restoretarget'] = 'Cieľ obnovy';
$string['restoretocourse'] = 'Obnoviť do kurzu:';
$string['restoretocurrentcourse'] = 'Obnoviť do tohto kurzu';
$string['restoretocurrentcourseadding'] = 'Zlúčiť zálohovaný kurz do tohto kurzu';
$string['restoretocurrentcoursedeleting'] = 'Najskôr vymazať obsah tohto kurzu a potom obnoviť zálohovaný kurz';
$string['restoretoexistingcourse'] = 'Obnoviť do existujúceho kurzu';
$string['restoretoexistingcourseadding'] = 'Zlúčiť zálohovaný kurz do existujúceho kurzu';
$string['restoretoexistingcoursedeleting'] = 'Najskôr vymazať obsah existujúceho kurzu a potom obnoviť zálohovaný kurz';
$string['restoretonewcourse'] = 'Obnoviť ako nový kurz';
$string['restoringcourse'] = 'Prebieha obnova kurzu...';
$string['restoringcourseshortname'] = 'Prebieha obnova...';
$string['rootenrolmanual'] = 'Obnoviť ako ručný zápis do kurzu';
$string['rootsettingactivities'] = 'Zahrnúť aktivity a zdroje';
$string['rootsettinganonymize'] = 'Anonymizovať informácie o používateľoch';
$string['rootsettingbadges'] = 'Zahrnúť odznaky';
$string['rootsettingblocks'] = 'Pridať bloky';
$string['rootsettingcalendarevents'] = 'Zahrnúť udalosti z kalendára';
$string['rootsettingcomments'] = 'Pridať komentáre';
$string['rootsettingcompetencies'] = 'Zahrnúť kompetencie';
$string['rootsettingcontentbankcontent'] = 'Zahrnúť obsah banky obsahu';
$string['rootsettingcustomfield'] = 'Zahrnúť vlastné polia';
$string['rootsettingenrolments'] = 'Zahrňte metódy zápisu';
$string['rootsettingenrolments_always'] = 'Áno, vždy';
$string['rootsettingenrolments_never'] = 'Nie, obnoviť používateľa ako ručný zápis';
$string['rootsettingenrolments_withusers'] = 'Áno, ale iba v prípade, že sú zahrnutí používatelia';
$string['rootsettingfiles'] = 'Zahrnúť súbory';
$string['rootsettingfilters'] = 'Pridať filtre';
$string['rootsettinggradehistories'] = 'Pridať históriu známok';
$string['rootsettinggroups'] = 'Zahrnúť skupiny a zoskupenia';
$string['rootsettingimscc1'] = 'Konvertovať na IMS Common Cartridge 1.0';
$string['rootsettingimscc11'] = 'Konvertovať na IMS Common Cartridge 1.1';
$string['rootsettinglegacyfiles'] = 'Zahrnúť staré súbory kurzov';
$string['rootsettinglogs'] = 'Pridať logy kurzu';
$string['rootsettingpermissions'] = 'Zahrnúť prepísané oprávnenia';
$string['rootsettingquestionbank'] = 'Zahrnúť banku otázok';
$string['rootsettingroleassignments'] = 'Zahrnúť priradenia rol';
$string['rootsettings'] = 'Nastavenia zálohovania';
$string['rootsettingusers'] = 'Zahrnúť zapísaných používateľov kurzu';
$string['rootsettinguserscompletion'] = 'Zahrnúť podrobnosti o splnení aktivít v kurze';
$string['samesitenotification'] = 'Táto záloha bola vytvorená iba s odkazmi na súbory, nie so samotnými súbormi. Obnova bude fungovať iba na tomto portáli.';
$string['sectionactivities'] = 'Aktivity';
$string['sectioninc'] = 'Zahrnutý v zálohe (bez používateľských informácii)';
$string['sectionincanduser'] = 'Zahrnutý v zálohe vrátane používateľských informácii';
$string['selectacategory'] = 'Zvoliť kategóriu';
$string['selectacourse'] = 'Zvoliť kurz';
$string['setting_course_fullname'] = 'Názov kurzu';
$string['setting_course_shortname'] = 'Skrátený názov kurzu';
$string['setting_course_startdate'] = 'Dátum začiatku kurzu';
$string['setting_keep_groups_and_groupings'] = 'Zachovať aktuálne skupiny a zoskupenia';
$string['setting_keep_roles_and_enrolments'] = 'Zachovať aktuálne role a zápisy';
$string['setting_overwrite_conf'] = 'Prepísať konfiguráciu kurzu';
$string['setting_overwrite_course_fullname'] = 'Prepísať plný názov kurzu';
$string['setting_overwrite_course_shortname'] = 'Prepísať krátky názov kurzu';
$string['setting_overwrite_course_startdate'] = 'Prepísať dátum začiatku kurzu';
$string['showtypes'] = 'Zobraziť voľby typov modulov';
$string['sitecourseformatwarning'] = 'Toto je záloha titulnej stránky, táto záloha môže byť obnovená iba na titulnej stránke.';
$string['skiphidden'] = 'Preskočiť skryté kurzy';
$string['skiphiddenhelp'] = 'Vyberte, či chcete preskočiť skryté kurzy';
$string['skipmodifdays'] = 'Preskočiť kurzu nezmenené od';
$string['skipmodifdayshelp'] = 'Vyberte pre preskočenie kurzov, ktoré neboli zmenené po zadaný počet dní';
$string['skipmodifprev'] = 'Preskočiť kurzy nezmenené od predchádzajúcej zálohy';
$string['skipmodifprevhelp'] = 'Vyberte, či chcete preskočiť kurzy nezmenené od predošlej zálohy. Vyžaduje zapnuté logovanie.';
$string['status'] = 'Stav';
$string['storagecourseandexternal'] = 'Priestor zálohy kurzov a zadaný adresár';
$string['storagecourseonly'] = 'Oblasť so zálohami kurzov';
$string['storageexternalonly'] = 'Adresár určený pre automatické zálohy';
$string['successful'] = 'Záloha bola úspešná';
$string['successfulcopy'] = 'Kopírovanie bolo úspešné';
$string['successfulrestore'] = 'Obnova bola úspešná';
$string['timetaken'] = 'Strávený čas';
$string['title'] = 'Názov';
$string['totalcategorysearchresults'] = 'Spolu kategórii: {$a}';
$string['totalcoursesearchresults'] = 'Spolu kurzov: {$a}';
$string['undefinedrolemapping'] = 'Mapovanie rolí nie je definované pre archetyp "{$a}".';
$string['unnamedsection'] = 'Nepomenovaná sekcia';
$string['userdata'] = 'Zahrnúť používateľské údaje';
$string['userdata_help'] = 'Ak je táto možnosť povolená, údaje, ako sú príspevky vo fórach, zadania úloh atď., sa skopírujú do nového kurzu pre všetkých používateľov s rolou vybratou v \'Zahrnúť prihlášky rolí\'.';
$string['userinfo'] = 'Informácie používateľa';
