<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'format_tiles', language 'no', version '4.1'.
 *
 * @package     format_tiles
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['addsections'] = 'Legg til fliser';
$string['admintools'] = 'Administratorverktøy';
$string['all'] = 'Alle';
$string['allcomplete'] = 'Fullført';
$string['allcoursescomplypalette'] = 'Alle kurs har allerede tillatte flis-farger, så det er ikke noe å nullstille. Sikre deg at du lagrer alle endringer om tillatte farger før du trykker på tilbakestill.';
$string['allowphototiles'] = 'Tillat bildefliser';
$string['allowphototiles_desc'] = 'Hvis huket av, vil lærere ha mulighet til å laste opp bilder som kan benyttes som bakgrunn på fliser. De vil fortsatt ha mulighet til å bruke standard flis-ikoner i tillegg i de samme kursene. (Hvis ikke huket av, kan man kun benytte flis-ikoner og andre innstillinger for bilde-fliser vil ignoreres.)';
$string['allowsubtilesview'] = 'Tillat å se under-fliser';
$string['allowsubtilesview_desc'] = 'Tillat bruk av en kursinnstilling som, hvis valgt, viser aktiviteter(bortsett fra informasjonsfelt) inne i en flis som under-fliser istedenfor i en liste.';
$string['alternativelink'] = 'Alternativ lenke';
$string['areyousure'] = 'Er du sikker?';
$string['asfraction'] = 'Vis som brøkdel';
$string['aspectratiotootallorwide'] = 'Bildet som ble lastet opp har blitt lagret, men vennligst sjekk om det er<strong>{$a->tallorwide}</strong>. Hvis det ikke ser riktig ut, rediger til standard landskapsdimensjoner og last opp igjen. Eks.vis:  bredde 300 x høyde 200.';
$string['aspercentagedial'] = 'Vis som % i sirkel';
$string['assumedatastoreconsent'] = 'Anta samtykke til nettleserens lokale lagring';
$string['assumedatastoreconsent_desc'] = 'Hvis valgt, vil <b>ikke</b> bruker bli bedt om samtykke for å lagre data i nettleserens lokale lagring.';
$string['backupfailed'] = 'Backup feilet';
$string['basecolour'] = 'Farger for fliser';
$string['basecolour_help'] = 'Farger satt her vil bli lagt til på alle fliser i kurset. (Tilgjengelig farger er bestemt av administrator gjennom innstillinger for Fliser-formatet.)';
$string['brandcolour'] = 'Merkefarge.';
$string['canceltask'] = 'Avbryt oppgave';
$string['changedcolour'] = 'Flisfarge tilbakestilt til standard for kurset {$a}';
$string['checkforproblemcourses'] = 'Se etter og reparer kurs med problemer.';
$string['clickiffailstoload'] = 'Trykk om siden ikke laster';
$string['close'] = 'Lukk';
$string['collapse'] = 'Minimer seksjon';
$string['collapsesections'] = 'Minimer alt';
$string['colourblue'] = 'Blå';
$string['colourdarkgreen'] = 'Mørk grønn';
$string['colourgreen'] = 'Grønn';
$string['colourlightblue'] = 'Lys blå';
$string['colourname_descr'] = 'Vis navn for fargen (navn er vanligvis ikke synlig for brukere- de ser en fargeprøve istedenfor)';
$string['colournamegeneral'] = 'Vis navn for fargen over';
$string['colourpurple'] = 'Lilla';
$string['colourred'] = 'Rød';
$string['colours'] = 'Farger';
$string['complete'] = 'fullfør';
$string['complete-n-auto'] = 'Aktivitet ikke fullført. Den vil merkes som fullført når kriteriene er møtt. Du kan ikke endre dette manuelt.';
$string['complete-y-auto'] = 'Aktivitet fullført. Den ble merket som fullført da kriteriene ble møtt. Du kan ikke endre dette manuelt.';
$string['completion_help'] = 'En avhukning til høyre for en aktivitet kan brukes til å indikere om aktiviteten er fullført. En tom sirkel vil vises hvis den ikke er fullført.<br><br>
Avhengig av valgte innstillinger, kan avhukning vises automatisk når aktiviteten er fullført i henhold til aktivitetsfullføringsbetingelsene.<br><br>
Du kan også trykke på den tomme sirkelen for å markere den som fullført og få den huket av. Trykker du på nytt, vil avhukningen forsvinne.';
$string['completionswitchhelp'] = '<p>Du har valgt å vise fullførtsporing på hver flis. Vi har derfor satt "fullføringsporing > Aktiver" lengre ned på siden til "Ja" </p>
<p> I tillegg må du skru på fullførtsporing for <b> hver aktivitet</b>
som skal spores. Eks.vis for en PDF, trykk "Endre innstillinger", se under Aktivitetsfullføring, og velg innstillingen du vil ha.</p>
<p>Du kan også <b>masseredigere</b> dette som forklart i <a
href="https://docs.moodle.org/35/en/Activity_completion_settings" target="_blank">detailed explanation of completion tracking on moodle.org</a></p>';
$string['completionwarning'] = 'Du har fullførtsporing aktivert på dette kursnivået, men på enkeltaktivitetene er ikke sporing aktivert, så det er ingenting å spore.';
$string['completionwarning_changeinbulk'] = 'Masseredigering.';
$string['completionwarning_help'] = 'Du må gjøre enkeltaktiviteter sporbare ved å redigere dem ( under Aktivitetsfullføring > Fullførtsporing) eller du kan masseredigere under Tannhjulet > Angi kursfullføring > Masseredigering av aktivitetsfullføring';
$string['contact'] = 'Ta kontakt';
$string['contactdeveloper'] = 'Ta kontakt med utvikler';
$string['contents'] = 'Innhold';
$string['courseshowtileprogress'] = 'Framgang på hver flis';
$string['courseshowtileprogress_error'] = 'Du har \'Fullførtsporing > Aktiver Fullførtsporing\' satt til \'Nei\'( se lengre nede på denne siden) som er i konflikt med denne innstillingen. Hvis du ønsker å vise framgang på denne flisen, vennligst sett \'Fullføring sporing > Aktiver Fullførtsporing\' til \'Ja\'. Ellers, velg \'Nei\'.';
$string['courseshowtileprogress_help'] = '<p>Når valgt, vil brukerens framgang med aktiviteter bli vist på hver flis,
enten som en <em>brøkdel</em> (Eks.vis \'Framgang 2/10 betyr 2 av 10 aktiviteter fullført), eller som en <em>prosentdel</em> i en sirkel.</p><p> Dette kan kun brukes hvis \'Fullføring> Aktiver fullførtsporing\' er slått på.</p><p>Hvis det ikker er sporing på noen aktiviteter innenfor gitt flis, vil indikatoren ikke bli vist for den flisen.</p>';
$string['courseshowtileprogress_link'] = 'Activity_completion_settings#Activity_settings';
$string['coursetoomanysections'] = 'Advarsel for redaktører: dette kurset har flere fliser enn det som er tillat. Et antall av {$a->max} vil bli vist til studentene ( ned til "{$a->tilename}")
 (redaktører kan se mer).';
$string['courseusebarforheadings'] = 'Fremhev overskrifter med farget fane';
$string['courseusebarforheadings_help'] = 'Vis en farget fane til venstre for overskriften i dette kurset når en overskriftstil er valgt i tekstredigering';
$string['courseusesubtiles'] = 'Bruk under-fliser for aktiviteter';
$string['courseusesubtiles_help'] = 'Innenfor hver flis, vis hver aktivitet  som en under-flis, istedenfor som en liste med aktiviteter nedover på siden. Dette gjelder ikke Informasjonsfelt som ikke vil bli vist som under-fliser, men kan bli brukt som overskrifter mellom fliser';
$string['currentsection'] = 'Denne flisen';
$string['customcss'] = 'Tilpasset CSS';
$string['customcssdesc'] = 'Tilpasset CSS som kan legges til i kursseksjoner når kursformatet er i bruk. Dette vil ikke bli validert, så vær sikker på at gyldig kode legges til. For eksempel: <p>.section { color: red; }</p><p>li.activity.subtile.resource.pdf { background-color: orange !important; }</p>';
$string['datapref'] = 'Datapreferanser';
$string['datapreferror'] = 'Datapreferanser er kun tilgjengelig hvis du har JavaScript aktivert i nettleseren din. Ellers kan ikke datalagring aktiveres.';
$string['dataprefquestion'] = '<p>For å gjøre denne siden lettere å bruke, lagres funksjonell informasjon i nettleseren din som f.eks. id-nummeret for den siste flisen du åpnet. Denne informasjonen blir lagret på maskinen din for en liten periode i tilfelle du besøker siden igjen. Vi bruker ikke dette for sporing. Er det greit?</p><p> Vi vil huske valget ditt til du tømmer loggen. Trykk "Avbryt" hvis du ikke godtar.</p>';
$string['defaultthiscourse'] = 'Standard for dette kurset';
$string['defaulttilecolour'] = 'Standard flis-farge';
$string['defaulttileicon'] = 'Flis-ikon';
$string['defaulttileicon_help'] = 'Ikonet du velger her vil vises på <em>alle</em> fliser i dette kurset som standard.
Enkeltfliser kan ha forskjellige ikoner eller et bakgrunnsbilde, ved å bruke de forskjellige innstillingene på flisnivå.';
$string['deleteemptytiles'] = 'Slett tomme fliser';
$string['deleteimage'] = 'Slett bilde';
$string['deletesection'] = 'Slett flis';
$string['deletetile'] = 'Slett flis';
$string['developedby'] = '"Fliser" utviklet av {$a}';
$string['developer'] = 'Utvikler';
$string['disabledbyadmin'] = 'Deaktivert av Administrator';
$string['displayfilterbar'] = 'Filterlinje';
$string['displayfilterbar_error'] = 'Med mindre du har satt opp resultatbeskrivelser for dette kurset, kan du kun vise en filterlinje
basert på flis-nummer, og ikke basert på resultat. Lag noen beskrivelser først og kom tilbake hit. Se';
$string['displayfilterbar_help'] = '<p> Når valgt, vil en rekke knapper automatisk vises før flisene i kurset, slik at brukerne kan filtrere flisene.</p>
<p> Når \'Basert på flisnummer\' er valgt, vil en serie med knapper vises
f.eks. en knapp for flis 1 til 4, en knapp til flis 5 til 8 osv.</p><p>Når \'basert på resultat\' er valgt, vil det være en knapp for hver type resultat Hver flis kan bli tildelt til et resultat og derfor også en gitt knapp) fra denne flisens innstillinger. </p>';
$string['displayfilterbar_link'] = 'Outcomes';
$string['displaytitle_mod_doc'] = 'Word-dokument';
$string['displaytitle_mod_html'] = 'Nettside';
$string['displaytitle_mod_jpeg'] = 'Bilde';
$string['displaytitle_mod_mp3'] = 'Lyd';
$string['displaytitle_mod_mp4'] = 'Video';
$string['displaytitle_mod_pdf'] = 'PDF';
$string['displaytitle_mod_ppt'] = 'Powerpoint-presentasjon';
$string['displaytitle_mod_txt'] = 'Tekst';
$string['displaytitle_mod_xls'] = 'Regneark';
$string['displaytitle_mod_zip'] = 'Zip';
$string['documentation'] = 'Dokumentasjon';
$string['documentationurl'] = 'Dokumentasjonslenke';
$string['documentationurl_descr'] = 'Lenke til Tiles-dokumentasjonen';
$string['download'] = 'Nedlasting';
$string['editsectionname'] = 'Rediger flis-navn';
$string['embeddedurlerror'] = 'Hvis den eksterne nettsiden nekter å koble til i vinduet over, bruk denne:';
$string['enablelinebreakfilter'] = 'Aktiver linjeskiftfilter';
$string['enablelinebreakfilter_desc'] = 'Filtrer flistitler for det usynlige ordsammenføyningstegnet {$a} og, hvis aktuelt og tittel tittelen er lang, erstatt den med "- " for å la linjen brytes. Ellers erstatt den med ingenting (dvs. ingen linjeskift).';
$string['entersection'] = 'Åpne seksjonen';
$string['existingimage'] = 'Nåværende bilde for denne flisen';
$string['expand'] = 'Utvide';
$string['expandall'] = 'Utvide alle';
$string['expandsections'] = 'Vis alle aktiviteter (alle seksjoner)';
$string['fileaddedtobottom'] = 'Fil lagt til nederst i seksjonen';
$string['filenoshowtext'] = 'Hvis nedlastning ikke vises her, venligst bruk knapp til høyre for å laste ned eller se i nytt vindu';
$string['filterboth'] = 'Vis knapper basert på flis-nummer og kursresultater';
$string['filternumbers'] = 'Vis knapper basert på flis-nummer';
$string['filteroutcomes'] = 'Vis knapper basert på kursresultater';
$string['filteroutcomesrestore'] = 'Det originale kurset brukte resultat i filter-linjen, som ennå ikke støttes under gjenopprettingsprosessen. Filter-linjeinnstillingen er derfor endret i det gjenopprttede kurset. Hvis du ønsker å bruke resultatbeskrivelser sfor å filtrere fliser i det gjenopprettede kurset, vennligst sett opp beskrivelsene på nytt. Det originale kurset har ikke blitt endret.';
$string['fittilestowidth'] = 'Tilpass fliser til skjermbredden';
$string['fittilestowidth_desc'] = 'Hvis huket av, når en bruker går inn på et kurs på en ikke-mobil enhet, vil lasting av fliser avvente et halvt sekund mens en kalkulasjon blir gjort for det beste oppsettet. Eks.vis unngå en flis per rad eller sentrere flis på skjerm. Dette vil kun skje første gang de går inn på kurset i en gitt økt og vil bli husket for denne økten eller til brukeren endrer skjermstørrelse.';
$string['fixproblems'] = 'Løs problemer';
$string['folderdisplayerror'] = 'Mapper satt til å vise innebygd innhold er ikke kompatibel med under-flisformat. Dette  <a href="{$a}">mappe</a> har derfor blitt endret til å vises på en egen side.';
$string['followthemecolour'] = 'Tving å følge temafarge';
$string['followthemecolour_desc'] = 'Hvis satt til ja, vil lærere ikke kunne gjøre valg i denne funksjonen og alle farger på fliser under blir ignorert. I stedet blir det gjort et forsøk på å hente hovedtemaets merkefarge og bruke det i stedet.';
$string['guidance'] = 'Veiledning';
$string['height'] = 'høyde';
$string['hidden'] = 'Skjult';
$string['hide'] = 'Skjul';
$string['hidefromothers'] = 'Skjul flis';
$string['highestsectionnum'] = 'Høyeste seksjonsnummer funnet';
$string['home'] = 'Kurs hjem';
$string['icontitle-address-book-o'] = 'Adressebok';
$string['icontitle-assessment_graded'] = 'Vurdering A+';
$string['icontitle-assessment_timer'] = 'Vurderingstidtaker';
$string['icontitle-asterisk'] = 'Asterisk';
$string['icontitle-award-solid'] = 'Premiesløyfe';
$string['icontitle-balance-scale'] = 'Balansevekter';
$string['icontitle-bar-chart'] = 'Søylediagram';
$string['icontitle-bell-o'] = 'Klokke';
$string['icontitle-binoculars'] = 'Kikkert';
$string['icontitle-bitcoin'] = 'Bitcoin';
$string['icontitle-book'] = 'Bok';
$string['icontitle-bookmark-o'] = 'Bokmerke';
$string['icontitle-briefcase'] = 'Koffert';
$string['icontitle-building'] = 'Bygning';
$string['icontitle-bullhorn'] = 'Horn';
$string['icontitle-bullseye'] = 'Blink';
$string['icontitle-calculator'] = 'Kalkulator';
$string['icontitle-calendar'] = 'Kalender';
$string['icontitle-calendar-check-o'] = 'Kalender med avhukning';
$string['icontitle-check'] = 'Huk av';
$string['icontitle-child'] = 'Barn';
$string['icontitle-clock-o'] = 'Klokke';
$string['icontitle-clone'] = 'Klone';
$string['icontitle-cloud-download'] = 'Sky (laste ned)';
$string['icontitle-cloud-upload'] = 'Sky (laste opp)';
$string['icontitle-comment-o'] = 'Kommentar';
$string['icontitle-comments-o'] = 'Kommentarer';
$string['icontitle-compass'] = 'Kompass';
$string['icontitle-diamond'] = 'Diamant';
$string['icontitle-dollar'] = 'Dollar';
$string['icontitle-euro'] = 'Euro';
$string['icontitle-exclamation-triangle'] = 'Utropstegn i trekant';
$string['icontitle-feed'] = 'Mate';
$string['icontitle-file-text-o'] = 'Tekstfil';
$string['icontitle-film'] = 'Film';
$string['icontitle-flag-checkered'] = 'Flagg (sjakkmønster)';
$string['icontitle-flag-o'] = 'Flagg';
$string['icontitle-flash'] = 'Blits';
$string['icontitle-flask'] = 'Flaske';
$string['icontitle-flipchart'] = 'Flipover';
$string['icontitle-frown-o'] = 'Rynke';
$string['icontitle-gavel'] = 'Gavel';
$string['icontitle-gbp'] = 'Britisk pund';
$string['icontitle-globe'] = 'Klode';
$string['icontitle-handshake-o'] = 'Håndtrykk';
$string['icontitle-headphones'] = 'Hodetelefoner';
$string['icontitle-heartbeat'] = 'Hjerteslag';
$string['icontitle-history'] = 'Historieklokke';
$string['icontitle-home'] = 'Hjem';
$string['icontitle-id-card-o'] = 'ID-kort';
$string['icontitle-info'] = 'Info';
$string['icontitle-jigsaw'] = 'Puslespillbit';
$string['icontitle-key'] = 'Nøkkel';
$string['icontitle-laptop'] = 'Bærbar';
$string['icontitle-life-buoy'] = 'Redningsbelte / redningsbøye';
$string['icontitle-lightbulb-o'] = 'Lyspære';
$string['icontitle-line-chart'] = 'Linjediagram';
$string['icontitle-list'] = 'Liste (punkter)';
$string['icontitle-list-ol'] = 'Liste (nummerert)';
$string['icontitle-location-arrow'] = 'Plasseringspil';
$string['icontitle-map-marker'] = 'Kartmarkør';
$string['icontitle-map-o'] = 'Kart';
$string['icontitle-map-signs'] = 'Kartskilt';
$string['icontitle-microphone'] = 'Mikrofon';
$string['icontitle-mobile-phone'] = 'Mobiltelefon';
$string['icontitle-mortar-board'] = 'Mortar board';
$string['icontitle-music'] = 'Musikk';
$string['icontitle-newspaper-o'] = 'Avis';
$string['icontitle-pencil-square-o'] = 'Blyant i firkant';
$string['icontitle-person'] = 'Person';
$string['icontitle-pie-chart'] = 'Kakediagram';
$string['icontitle-podcast'] = 'Podcast';
$string['icontitle-puzzle-piece'] = 'Puslespillbrikke';
$string['icontitle-question-circle'] = 'Spørsmålstegn i sirkel';
$string['icontitle-random'] = 'Tilfeldig';
$string['icontitle-refresh'] = 'Oppfriske';
$string['icontitle-road'] = 'Vei';
$string['icontitle-search'] = 'Forstørrelsesglass';
$string['icontitle-sliders'] = 'Skyveknapper';
$string['icontitle-smile-o'] = 'Smil';
$string['icontitle-star'] = 'Stjerne (skyggelagt)';
$string['icontitle-star-half-o'] = 'Stjerne (halvskygge)';
$string['icontitle-star-o'] = 'Stjerne (uskyggelagt)';
$string['icontitle-survey'] = 'Undersøkelse';
$string['icontitle-tags'] = 'Tagger';
$string['icontitle-tasks'] = 'Oppgaver';
$string['icontitle-television'] = 'Fjernsyn';
$string['icontitle-thinking-person'] = 'Person med lyspære';
$string['icontitle-thumbs-o-down'] = 'Tommel ned';
$string['icontitle-thumbs-o-up'] = 'Tommel opp';
$string['icontitle-trophy'] = 'Trofé';
$string['icontitle-umbrella'] = 'Paraply';
$string['icontitle-university'] = 'Universitet';
$string['icontitle-user-o'] = 'Person (uskyggelagt)';
$string['icontitle-users'] = 'Mennesker';
$string['icontitle-volume-up'] = 'Høyttaler';
$string['icontitle-wrench'] = 'Skiftenøkkel';
$string['imagecannotbeused'] = 'Bildet kan ikke brukes';
$string['imagedeletedfrom'] = 'Bilde slettet fra "{$a}"';
$string['imagesavedfor'] = 'Bilde lagret for flis {$a}';
$string['imagesize'] = 'Bildestørrelse';
$string['jsactivate'] = 'Animert navigasjon på';
$string['jsdeactivate'] = 'Animert navigasjon av';
$string['jsdeactivated'] = 'Du har deaktivert animert navigasjon på kontoen din';
$string['jsnavsettings'] = 'JavaScript-navigasjon';
$string['jsreactivated'] = 'Du har aktivert animert navigasjon på kontoen din. Dette kan være raskere å bruke. Det krever JavaScript aktivert.';
$string['links'] = 'Lenker';
$string['loading'] = 'Laster';
$string['maxcoursesectionsallowed'] = 'Maksimalt antall tillatte kursseksjoner i dette miljøet er {$a}.';
$string['modalmodules'] = 'Innebygde moduler';
$string['modalmodules_desc'] = 'Start disse kursmodulene i et innebygget vindu. (Andre moduler kan legges til i en senere versjon.)';
$string['modalresources'] = 'Bygg inn-ressurser';
$string['modalresources_desc'] = 'Start disse ressursene i et innebygget vindu.  Merk: hvis dette tillates, vil URL-aktiviteter kun åpne i et innebygget vindu hvis de er satt til {$a->displayembed} på aktivitetsnivå
(e.g YouTube eller Vimeo videoer) Selv da, kan nettstedeier blokkere fra å vise innebygd - se {$a->link}';
$string['modalwindows'] = 'Innebygde vinduer';
$string['newsectionname'] = 'Nytt navn for emne {$a}';
$string['nexttopic'] = 'Neste emne';
$string['noconnectionerror'] = 'Kan ikke laste inn innhold. Sjekk internettforbindelsen din';
$string['nojswarning'] = 'Nettleseren din ser ikke ut til å støtte JavaScript, eller den er deaktivert. Et forbedret grensesnitt er tilgjengelig hvis du aktiverer Javascript';
$string['none'] = 'Ingen';
$string['noproblemsfound'] = 'Ingen problemer funnet';
$string['notcomplete'] = 'Ikke ferdig';
$string['notrecommended'] = 'Ikke anbefalt';
$string['notregistered'] = 'Tiles-modulen din er ennå ikke registrert hos plugin-utvikleren.';
$string['novaliddefaultcolour'] = 'Ingen gyldig farge satt for standard flis-farge nedenfor';
$string['numberofsections'] = 'Antall seksjoner i kurset';
$string['ok'] = 'Ok';
$string['other'] = 'Annet';
$string['outcomes'] = 'resultater';
$string['outcomesunavailable'] = 'Resultater utilgjengelige';
$string['overall'] = 'Alt i alt';
$string['overallprogress'] = 'Aktivitetsfullføring - framgang totalt sett';
$string['overallprogressshort'] = 'Total framgang';
$string['photoguidance_desc'] = '<p>Last opp et bilde i <strong>landskapsformat</strong>.   Bredden burde være omtrent 1.35 ganger høyden.  Eks.vis. 270 x 200.
Du trenger ikke være helt nøyaktig.</p>
<p>Bilder i stående format vil ikke samsvare med formen på flisen. Store bilder eller filer vil bli nedskalert og komprimert om nødvendig, etter opplasting.</p>';
$string['photolibrary'] = 'Bildebiblotek';
$string['photolibrary_desc'] = 'Dette er bildene du har lastet opp eller brukt nylig. For å bruke et som bakgrunn for denne flisen, trykk på det. For å laste opp et nytt, bruk opplastingsfanen ovenfor.';
$string['phototilesaltstyle'] = 'Bilde-fliser alternativ stil';
$string['phototilesaltstyle_desc'] = 'Hvis ikke valgt (som er standard), vil bilde-fliser vise tittelen øverst på flisen. Den alternative stilen viser tittelen nederst';
$string['phototilesettings'] = 'Bilde-fliser';
$string['phototiletitletransarency'] = 'Gjennomsiktighet tittel på bilde-flis';
$string['phototiletitletransarency_desc'] = 'Titteloverlegget på en bilde-flis kan ha en litt gjennomsiktig bakgrunn eller en ensfarget bakgrunn (0 %)';
$string['phototitletitlelineheight'] = 'Tittellinjehøyde';
$string['phototitletitlepadding'] = 'Vertikal linjeutfylling av tittelen';
$string['picknewicon'] = 'Velg et nytt ikon';
$string['picknewiconphoto'] = 'Velg et nytt ikon eller bakgrunnsbilde';
$string['pluginname'] = 'Flis-format';
$string['previoustopic'] = 'Forrige emne';
$string['privacy:metadata:preference:format_tiles_stopjsnav'] = 'Om brukeren har deaktivert animert JavaScript-navigasjon.';
$string['privacypolicy'] = 'Personvernerklæring';
$string['problemcourses'] = 'Problemkurs';
$string['problemcoursesintro'] = 'Følgende kurs har seksjonstall høyere enn forventet. Bruk knappene nedenfor for å løse problemer.';
$string['progress'] = 'Framgang';
$string['reactivate'] = 'Reaktivere';
$string['register'] = 'Registrere';
$string['registeragreeprivacy'] = 'Jeg godtar plugin-utviklerens {$a->privacypolicylink}';
$string['registerclicktocomplete'] = 'Trykk på OK for å fullføre prosessen';
$string['registeredthanks'] = 'Din plugin er registrert. Takk skal du ha.';
$string['registeremailno'] = 'Nei, jeg ønsker ikke å motta noen e-poster';
$string['registeremailyes'] = 'Ja, jeg er villig til å motta oppdateringsvarsler og annen informasjon om Tiles-modulen';
$string['registerintro1'] = 'Vi vil gjerne holde kontakten! Når du registrerer deg';
$string['registerintro2'] = 'Du støtter den fremtidige utviklingen av denne modulen';
$string['registerintro3'] = 'du kan umiddelbart høre om viktige oppdateringer og fremtidige planer';
$string['registerintro4'] = 'vi kan finne ut mer om hva du vil at denne modulen skal gjøre.';
$string['registerintro5'] = 'Dine opplysninger vil holdes private av utvikleren som angitt i personvernreglene som er koblet til nedenfor. Takk for støtten!';
$string['registermissingemail'] = 'Fyll ut e-postadressen din (du har valgt "Ja" for e-poster nedenfor)';
$string['registerpickemailpref'] = 'Vennligst velg din e-postpreferanse';
$string['registerpolicyagreedlinktext'] = 'Personvernerklæring og databehandlingsavtale';
$string['registrationdeferred'] = 'Takk skal du ha. Vi prøver å registrere modulen din (dette er ikke fullført ennå).';
$string['reopenlastsection'] = 'Åpne sist besøkte flis på nytt';
$string['reopenlastsection_desc'] = 'Når huket av, hvis en bruker besøker et kurs på nytt, vil den siste delen de hadde åpen bli åpnet igjen ved ankomst';
$string['resetallcoursecolours'] = 'Tilbakestill alle kursfarger';
$string['resetcolours'] = 'Tilbakestill farger';
$string['resetcolours_desc'] = 'Trykk på denne knappen for å tilbakestille flis-fargen for alle kursene som ikke har en av fargene nedenfor. Kursene vil bli endret til standard flis-farge nedenfor. Du kan bruke dette etter at du har endret fargepaletten, men sørg for at du har <strong>lagret eventuelle endringer</strong> i fargene før du trykker på denne knappen. Vær forsiktig da dette kan endre fargen på mange av kursene!';
$string['restorefailed'] = 'Gjenoppretting mislyktes';
$string['restoreincorrectsections'] = 'Feil: Kan ikke fullføre da kildekurset inneholder feil nummererte seksjoner Eks.vis seksjonsnummer ({$a->sectionnum}) er høyere enn maks tillatt ({$a->maxallowed}).  Prøv å ekskludere eller slette seksjoner med høye tall.';
$string['restoretoomanysections'] = 'Feil: Kan ikke sikkerhetskopiere eller gjenopprette fordi for mange kurs-seksjoner er inkludert ({$a->numsections}) og dette er mer enn tillatt ({$a->maxallowed}).
Prøv å ekskludere eller slette noen seksjoner.';
$string['revealcontents'] = 'Vis flis-innhold';
$string['scheduleddeleteemptysections'] = 'Oppgaven for å slette tomme seksjoner fra kurset er planlagt. Kom tilbake senere.';
$string['section0name'] = 'Generell';
$string['sectionerrorstring'] = 'Økten din kan ha utløpt. Prøv å oppdatere denne siden.';
$string['sectionerrortitle'] = 'Feil ved innlasting av innhold';
$string['sectionname'] = 'Flis';
$string['sectionnumber'] = 'Seksjon / flis-nummer';
$string['selected'] = 'Valgt';
$string['setavailabletilecolours'] = 'Tillatte flis-farger (på tvers av portalen)';
$string['settings'] = 'Innstillinger for flis-format';
$string['show'] = 'Vis';
$string['showalltiles'] = 'Vis alle fliser';
$string['showfromothers'] = 'Vis flis';
$string['showoverallprogress'] = 'Vis generell fremdriftsindikator';
$string['showoverallprogress_desc'] = 'Vis "Total fremgang %" indikator øverst til høyre i kurset (verdien som vises representerer summen av % fullført for hver flis, basert på aktivitetsfullføring ,ikke kursfullføring';
$string['showprogresssphototiles_desc'] = 'Hvis valgt, vil studentframgang (f.eks. Framgang 2/5) vises på bilde-fliser';
$string['showseczerocoursewide'] = 'Vis seksjon null øverst i alle seksjoner';
$string['showseczerocoursewide_desc'] = 'Hvis huket av, vil seksjon null (den aller øverste delen) vises på kursets landingsside og øverst på <b>hver kursseksjon</b> (i.e. på toppen av hver flis sitt innhold).  Hvis ikke huket av (anbefalt), vil det kun vises på kursets landingsside';
$string['showseparatewin'] = 'Vis fil i eget vindu';
$string['sitename'] = 'Portalnavn';
$string['snapwarning'] = 'Det kan være mulig å redigere kurset ditt i Tiles-format med et annet tema, og deretter bytte tilbake til Snap-tema når du er ferdig med redigeringen.';
$string['snapwarning_help'] = 'Tema_innstillinger#Tillate_Bruker_temaer';
$string['subtileszeczerotoggled'] = 'Toppseksjonen vekslet mellom liste- og under-flisformat';
$string['sureresetcolours'] = 'Er du sikker på at du vil tilbakestille kursets flisfarger til standard? Dette vil påvirke {$a} kurs';
$string['tilecolourgeneral'] = 'Fargepalett - valgfri farge';
$string['tilecolourgeneral_descr'] = 'Disse innstillingene lar administratoren angi hvilke farger som skal være tilgjengelige for lærere å bruke på kurs. Sett fargen til svart (#000) for å deaktivere den fargen. Hvis du endrer fargene her, vil det ikke bli gjort endringer på eksisterende kurs, før neste gang læreren prøver å endre flis-farge. På det tidspunktet vil bare fargene du har angitt her være tilgjengelige for læreren.';
$string['tilecolourschanged'] = 'Flis-farger er tilbakestilt. Alle fliser har nå farger som samsvarer med fargene nedenfor.';
$string['tileicon'] = 'Ikon som kun vises på denne flisen';
$string['tileicon_help'] = 'Elementet som er valgt her vil overstyre, kun for denne flisen, uansett hvilket flis-ikon som er angitt på kursnivå.';
$string['tileicons'] = 'Flis-ikoner';
$string['tileoutcome'] = 'Resultat for denne flisen';
$string['tileoutcome_help'] = 'Hvis du velger et resultat for denne flisen, vil du under kursinnstillinger kunne vise et sett med <em>filterknapper</em>, en for hvert resultat. Dette filtrerer de viste flisene etter hvilket resultat de har blitt tildelt';
$string['tilesformatregistration'] = 'Registrering av Tiles-formatet';
$string['togglecompletion'] = 'Klikk for å bytte fullføringsstatus';
$string['tootall'] = 'for høy for flisen';
$string['toowide'] = 'for bred for flisen';
$string['transparenttitleadjustments'] = 'Justeringer for gjennomsiktig tittel';
$string['transparenttitleadjustments_desc'] = 'På bilde-fliser med gjennomsiktig tittelbakgrunn, avhengig av temaet ditt, kan det være lurt å justere disse for å sikre at de gjennomsiktige linjene i tittelen ikke overlapper.
Merk at disse varierer litt mellom nettlesere også. Foreslåtte verdier for Chrome:
Boost and Clean based themes: 30.5 and 4 | Adaptable: 32 and 4 | Moove: 32 and 2 | Remui: 32 and 2.5';
$string['uploadnewphoto'] = 'Last opp nytt bilde';
$string['uploadnewphoto_help'] = 'Last opp et bilde som skal brukes på denne flisen';
$string['usejavascriptnav'] = 'Bruk JavaScript-navigasjon fra Tiles hovedside';
$string['usejavascriptnav_desc'] = 'Når avhuket, hvis brukeren trykker på en flis på kurssiden og har JavaScript, vil JS bli brukt til å gå over til flis-innhold. Flis-innholdet vil bli lagret lokalt i nettleseren i henhold til de andre innstillingene nedenfor. Hvis ikke huket av, vil ikke JS bli brukt, og eldre navigasjon vil bli brukt i stedet. De andre JS-innstillingene nedenfor vil bli ignorert.';
$string['usejseditingexpandcollapse'] = 'Redigeringsmodus - bruk JavaScript for å utvide/minimere fliser';
$string['usejseditingexpandcollapse_desc'] = 'Hvis valgt, i redigeringsmodus kan en lærer utvide og minimere redigerings liser med animerte overganger. Flis-innhold vil bli lastet ved utvidelse, uten at siden lastes på nytt.';
$string['usejsnavforsinglesection'] = 'Bruk JS-navigasjon for enkel seksjons-side';
$string['usejsnavforsinglesection_desc'] = 'Når huket av, vil ethvert kall for en enkelt seksjons side (&section=xx)
bli håndtert ved å bruke JavaScript, ved å starte kursets hovedside, animert for å åpne den forespurte seksjonen via JS, i stedet for å kalle den gamle stilen PHP enkelt seksjons siden';
$string['usesubtilesseczero'] = 'Bruk under-fliser i toppseksjonen';
$string['usesubtilesseczero_help'] = 'Hvis valgt, vil under-fliser bli brukt i toppseksjonen av kurs i tillegg til inne i alle fliser. Kun tilgjengelig hvis du bruker under-fliser i hele kurset. Dette er fordi under-flisene tar opp mye plass helt på toppen av kursene. Det kan være bedre å la dette være umarkert, slik at eventuelle elementer i den øverste delen vises i standard listeformat i stedet.';
$string['usetooltips'] = 'Bruk JavaScript verktøytips';
$string['usetooltips_desc'] = 'Bruk JavaScript verktøytips når brukeren holder markøren over visse elementer, f.eks. fullføringsbokser eller fliser for å se flis-innhold';
$string['width'] = 'Bredde';
