<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'theme_afterburner', language 'zh_cn', version '5.1'.
 *
 * @package     theme_afterburner
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['choosereadme'] = '<div class="clearfix">
 <div class="theme_screenshot">

  <h2>飞速</h2>
  <img src="afterburner/pix/screenshot.jpg" />

  <h3>主题讨论区：</h3>
  <p><a href="http://moodle.org/mod/forum/view.php?id=46">http://moodle.org/mod/forum/view.php?id=46</a></p>

  <h3>主题致谢</h3>
  <p><a href="http://docs.moodle.org/en/Theme_credits">http://docs.moodle.org/en/Theme_credits</a></p>

  <h3>主题文档：</h3>
  <p><a href="http://docs.moodle.org/en/Themes">http://docs.moodle.org/en/Themes</a></p><h3>报告 bug：</h3><p><a href="http://tracker.moodle.org">http://tracker.moodle.org</a></p>
 </div>
 <div class="theme_description">
  <h2>关于</h2>
  <p>飞速是一款为 Moodle 2.0 编写的三列、可变宽主题。它在每个页面的网站名下方显示自定义菜单。让用户登录或登出的额外功能现在也集成到此主题的自定义菜单中。</p>
  <h2>祖先</h2>
  <p>本主题基于 Moodle 核心的 Base 主题构建。如果您想修改它，处理提供的设置以外，我们建议您创建一个新主题，并将本主题和 Base 做为父主题。这样任意父主题更新都能反映到您的主题上。</p>
  <h2>致谢</h2>
  <p>主题最早由 Rocket Themes (www.rockettheme.com) 设计，后来 NewSchool Learning (www.newschoollearning.com) 的 Patrick Malley 为 Moodle 1.9 重建。NewSchool Learning (contact@newschoollearning.com) 的 Mary Evans 将它移植到 Moodle 2.0 </p>
  <h2>授权</h2>
  <p>Moodle 核心提供的所有主题，包括此主题的授权协议都是 <a href="http://www.gnu.org/licenses/gpl.html">GNU General Public License</a>。</p>
 </div>
</div>';
$string['configtitle'] = '飞速主题自定义设置';
$string['customcss'] = '自定义 CSS';
$string['customcssdesc'] = '您在此添加的所有 CSS 都会被附加到每个页面中，这样您就可以方便地定制此主题。';
$string['footnote'] = '脚注';
$string['footnotedesc'] = '您在此添加的任何内容都将显示在每个页面的页脚。';
$string['logo'] = '徽标';
$string['logodesc'] = '如果您想替换此主题的默认徽标，请添加您的新徽标的 URL。<br />默认徽标是一个宽 320 像素、高 75 像素的 JPG 图像，供您参考';
$string['pluginname'] = '飞速';
$string['region-side-post'] = '右侧';
$string['region-side-pre'] = '左侧';
