<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'report_security', language 'sr_cr', version '5.1'.
 *
 * @package     report_security
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['check_antivirus_details'] = 'Овај статус проверава да ли је откривена нека скорашња грешка на основу прага постављеног у главним антивирусним подешавањима.';
$string['check_antivirus_error'] = 'У последњем периоду {$a->lookback} откривен је следећи број грешака: {$a->errors}';
$string['check_antivirus_info'] = 'Тренутно није омогућен ниједан антивирусни скенер';
$string['check_antivirus_logstore_not_supported'] = 'Није могуће проверити стање антивирусних скенера због изабраног типа складишта записа';
$string['check_antivirus_name'] = 'Антивирус';
$string['check_antivirus_ok'] = '{$a->scanners} антивирусни скенер(и) је/су омогућен(и); никакви проблеми нису откривен у последња/их {$a->lookback}';
$string['check_configrw_details'] = '<p>Препоручљиво је да се након инсталације овлашћења над датотеком <code>config.php</code> промени тако да веб сервер не може да је мења.
Имајте у виду да ова мера не повећава значајно безбедност сервера, иако може да успори или ограничи могућност опште злоупотребе.</p>';
$string['check_configrw_name'] = 'Уписива config.php датотека';
$string['check_configrw_ok'] = 'PHP скриптови не могу да измене config.php датотеку.';
$string['check_configrw_warning'] = 'PHP скриптови могу да измене config.php.';
$string['check_cookiesecure_details'] = '<p>Уколико је омогућена https комуникација препоручује се да омогућите слање безбедних колачића. Требало би да имате перманентну редирекцију са http на https, а у идеалном случају понудите и HSTS заглавља.</p>';
$string['check_cookiesecure_error'] = 'Молимо да омогућите безбедне колачиће';
$string['check_cookiesecure_http'] = 'Морате да укључите https како бисте користили сигурне колачиће';
$string['check_cookiesecure_name'] = 'Безбедни колачићи';
$string['check_cookiesecure_ok'] = 'Безбедни колачићи омогућени';
$string['check_crawlers_details'] = '<p>Подешавање "Отворено за претраживаче" допушта претраживачким машинама да приступе курсевима као гости. Не постоји начин да се ова подешавање укључи уколико пријављивање у улози госта није дозвоњено.</p>';
$string['check_crawlers_error'] = 'Приступ претраживачким машинама је дозвољен али је приступ гостима онемогућен.';
$string['check_crawlers_info'] = 'Претраживачи могу ући као гости';
$string['check_crawlers_name'] = 'Отворено за претраживаче';
$string['check_crawlers_ok'] = 'Приступ претраживачима није омогућен';
$string['check_defaultuserrole_details'] = '<p>Свим корисницима који су пријављени на систем дају се способности које има подразумевана корисничка улога. Молимо вас, проверите да за ту улогу нису дозвољене опасне способности.</p>
<p>Једино подржани тип наслеђивања за подразумевану корисничку улогу је <em>Ауторизовани корисник</em>. Способност за преглед курса не сме бити омогућена.</p>
<p>Проверите да ли је омогућена опција за одобрење захтева за аутоматско брисање података (tool_dataprivacy | automaticdatadeletionapproval). Корисници могу да захтевају брисања која могу да oбришу велику количину података.</p>';
$string['check_defaultuserrole_error'] = 'Подразумевана улога корсника "{$a}" је погрешно дефинисана!';
$string['check_defaultuserrole_name'] = 'Подразумевана улога за све кориснике';
$string['check_defaultuserrole_notset'] = 'Подразумевана улога није подешена';
$string['check_defaultuserrole_ok'] = 'Дефиниција подразумеване улог за све кориснике је ОК';
$string['check_dirindex_info'] = 'Индекс директоријума не би требало да буде омогућен';
$string['check_displayerrors_details'] = '<p>Укључивање PHP подешавања <code>display_errors</code> се не препоручује на сајтовима са активним курсевима зато што поруке о грешкама могу открити осетљиве информације о вашем серверу.</p>';
$string['check_displayerrors_error'] = 'PHP подешавање за приказивање грешака је укључено. Препоручује се да га искључите.';
$string['check_displayerrors_name'] = 'Приказ PHP грешака';
$string['check_displayerrors_ok'] = 'Приказ PHP грешака је онемогућен';
$string['check_dotfiles_info'] = 'Све датотеке са тачком као префиксом, изузев  /.well-known/*, не би требало да буду јавне';
$string['check_emailchangeconfirmation_details'] = '<p>Препоручује се да потврда путем е-поште буде неопходна када корисници промене електронску адресу у својим профилима. Ако је ова опција искључена, спамери могу покушати да искористе сервер за слање нежељене поште.</p>
<p>Поље за електронску адресу, такође, може бити закључано од стране додатака за проверу идентитета. Ова могућност се овде не разматра.</p>';
$string['check_emailchangeconfirmation_error'] = 'Корисници могу да унесу било коју електронску адресу';
$string['check_emailchangeconfirmation_info'] = 'Корисници могу могу да унесу само  електронске адресе дозвоњених домена.';
$string['check_emailchangeconfirmation_name'] = 'Потврда промене електронске адресе';
$string['check_emailchangeconfirmation_ok'] = 'Потврда промене електронске адресе у корисничком профилу.';
$string['check_embed_details'] = 'Неограничено уметање објеката је верома опасно - било који регистровани корисник може да покрене XSS напад против других корисника. Ово подешавање треба онемогућити на серверима са активним курсевима.</p>';
$string['check_embed_error'] = 'Неограничено уметање објеката је омогућено - то је веома опасно за већину сервера.';
$string['check_embed_name'] = 'Дозволи EMBED и OBJECT';
$string['check_embed_ok'] = 'Неограничено уметање објеката није дозвољено';
$string['check_frontpagerole_details'] = '<p>Подразумевана улога на насловној страници сајта је дата свим регистрованим корисницима за активности на насловној страници. Молимо вас да проверите да ли су за ову улогу дозвољене ризичне могућности.</p>
<p>Препоручује се да се за ову сврху креира посебна улога и да се не користи наслеђени тип улоге.</p>';
$string['check_frontpagerole_error'] = 'Откривена је погрешно дефинисана улога насловне странице "{$a}"!';
$string['check_frontpagerole_name'] = 'Улога на насловној страници';
$string['check_frontpagerole_notset'] = 'Улога на насловној страници није подешена.';
$string['check_frontpagerole_ok'] = 'Дефиниција улоге на насловној страници је ОК.';
$string['check_guestrole_details'] = '<p>Улога Гост се користи за госте, кориснике које нису пријављени на систем као и за привремени приступ курсу. Молимо да проверите да нису дозвољене ризичне могућности за ову улогу.</p>
<p>Једини подрржани наслеђени тип за улогу госта је <em>Гост</em>.</p>';
$string['check_guestrole_error'] = 'Улога госта "{$a}" је погрешно дефинисана';
$string['check_guestrole_name'] = 'Улога госта';
$string['check_guestrole_notset'] = 'Улога госта није постављена';
$string['check_guestrole_ok'] = 'Дефиниција за улогу госта је ОК';
$string['check_nodemodules_details'] = '<p>Директоријум <code>{$a->path}</code> садржи Node.js модуле и њихове зависности, обично инсталиране помоћу NPM алата. Ови модули могу бити потребни за локални развој Moodlea, као што је коришћење Grunt алата. Они нису потребни за покретање Moodlea на продукционом северу и могу да садрже потенцијално опасан кôд и тако изложе ваш сајт удаљеним нападима.</p><p>Препоручује се да уклоните директоријум ако је сајт доступан преко јавне URL адресе, или да барем забраните веб приступ овом директоријуму, у конфигурацији вашег веб сервера.</p>';
$string['check_nodemodules_info'] = 'Директоријум node_modules не би требало да буде присутан на јавним сајтовима.';
$string['check_nodemodules_name'] = 'Директоријум Node.js модула';
$string['check_openprofiles_details'] = 'Отворене корисничке профиле могу да злоупотребе спамери. Препоручује се да буде укључена или опција <code>Приморај кориснике да се пријаве на систем за да би видели корисничке профиле</code> или <code>Приморај кориснике да се пријаве на систем</code>.';
$string['check_openprofiles_error'] = 'Свако може да види корисничке профиле без пријављивања на систем';
$string['check_openprofiles_name'] = 'Отворени кориснички профили';
$string['check_openprofiles_ok'] = 'За гледање корисничких профила неопходна је претходна пријава на систем.';
$string['check_passwordpolicy_details'] = '<p>Препоручљиво је да правила о креирању лозинке буде подешена јер је погађање лозинки врло често најлакши начин за стицање неовлашћеног приступа.
Немојте постављати превише строга правила, пошто то за последицу може имати да корисници не буду у стању да запамте своје лозинке, па ће их или заборављати или записивати.</p>';
$string['check_passwordpolicy_error'] = 'Правила за креирање лозинке нису подешена.';
$string['check_passwordpolicy_name'] = 'Правила за креирање лозинке';
$string['check_passwordpolicy_ok'] = 'Правила за креирање лозинке су омогућена';
$string['check_preventexecpath_details'] = '<p>Дозвола да путање буду подешене преко графичког корисничког интерфејса за администраторе представља потенцијалну опасност да поједини корисници стекну привилегије у систему које им нормално не припадају. Зато се ово мора спречити следећим подешавањем у config.php датотеци:</p><p><code>$CFG->preventexecpath = true;</code></p>';
$string['check_preventexecpath_name'] = 'Извршне путање';
$string['check_preventexecpath_ok'] = 'Извршне путање се могу подесити само у датотеци config.php.';
$string['check_preventexecpath_warning'] = 'Извршне путање се могу подесити у графичком корисничком интерфејсу за администраторе.';
$string['check_publicpaths_403'] = '(Веб сервер је проследио вредност 403, идеално би требало да буде 404)';
$string['check_publicpaths_generic'] = '{$a} датотеке/а не би требало да буду јавне';
$string['check_publicpaths_name'] = 'Проверите све јавне / приватне путање';
$string['check_publicpaths_ok'] = 'Све интерне путање нису јавно доступне';
$string['check_publicpaths_warning'] = 'Неки интерне путање су јавно доступне';
$string['check_riskadmin_detailsok'] = '<p>Молимо Вас да потврдите следећи списак администратора система:</p>{$a}';
$string['check_riskadmin_detailswarning'] = '<p>Молимо потврдите следећи списак администратора система:</p>{$a->admins}
<p>Препоручује да се да улогу администратoра додељујете само у контексту система. Следећи корисницима су додељене (неподржане) администраторске улоге у другим контекстима:</p>{$a->unsupported}';
$string['check_riskadmin_name'] = 'Администратори';
$string['check_riskadmin_ok'] = 'Пронађен/о је {$a} сервер администратор/а.';
$string['check_riskadmin_unassign'] = '<a href="{$a->url}">{$a->fullname} ({$a->email}) прегледај додељене улоге</a>';
$string['check_riskadmin_warning'] = 'Пронађено је {$a->admincount} администратора сервера и {$a->unsupcount} додељених администраторских улога које нису подржане.';
$string['check_riskbackup_details_overriddenroles'] = '<p>Ове активне измене овлашћења дају корисницима могућниост да укључе корисничке податке у резервне копије. Молимо, проверите да ли је ово овлашћење неопходно.</p> {$a}';
$string['check_riskbackup_details_systemroles'] = '<p>Следеће системске улоге допуштају корисницима да укључе корисничке податке у резервне копије. Молимо, проверите да ли је ово овлашћење неопходно.</p> {$a}';
$string['check_riskbackup_details_users'] = '<p>Због горе наведених улога или локалних измена овлашћења, следећи кориснички налози тренутно имају овлашћење да креирају резервне копије података које садрже приватне податке било ког корисника уписаног на курс. Проверите да ли су ти корисници (a) поуздани и (b) заштићени јаким лозинкама:</p> {$a}';
$string['check_riskbackup_detailsok'] = 'Нема улоге која експлицитно дозвољава креирање резервне копије корисничких података. Међутим имајте на уму да ће администратори, који имају способност "doanything" вероватно и даље моћи ово да ураде.';
$string['check_riskbackup_editoverride'] = '<a href="{$a->url}">{$a->name} у {$a->contextname}</a>';
$string['check_riskbackup_editrole'] = '<a href="{$a->url}">{$a->name}</a>';
$string['check_riskbackup_name'] = 'Резервна копија корисничких података';
$string['check_riskbackup_ok'] = 'Нема улоге која експлицитно дозвољава креирање резервне копије корисничких података';
$string['check_riskbackup_unassign'] = '<a href="{$a->url}">{$a->fullname} ({$a->email}) у {$a->contextname}</a>';
$string['check_riskbackup_warning'] = 'Пронађено је {$a->rolecount} улога/е, {$a->overridecount} измена овлашћења и {$a->usercount} корисника који имају могућност да креирају резервне копије корисничких података.';
$string['check_riskxss_details'] = '<p>RISK_XSS означава све опасне способности које могу да користе само поуздани корисници.</p>
<p>Молимо, потврдите следећи списак корисника на овом серверу и проверите да ли имате поптуно поверењe у њих:</p><p>{$a}</p>';
$string['check_riskxss_name'] = 'XSS поуздани корисници';
$string['check_riskxss_warning'] = 'RISK_XSS - пронађено је {$a} корисника који морају да буду поуздани.';
$string['check_unsecuredataroot_details'] = '<p>Директоријум dataroot не сме бити доступан преко веба. Најбољи начин да будете сигурни да директоријум није доступан је да користите онај који је изван јавног веб директоријума.</p>
<p>Ако преместите директоријум, морате да ажурирате <code>$CFG->dataroot</code> подешавање у <code>config.php</code> датотеци.</p>';
$string['check_unsecuredataroot_error'] = 'Ваш директоријум за податке <code>{$a}</code> је на погрешној локацији и доступан је преко веба!';
$string['check_unsecuredataroot_name'] = 'Небезбедни директоријум за податке';
$string['check_unsecuredataroot_ok'] = 'Директоријум за податке не сме бити доступан преко веба.';
$string['check_unsecuredataroot_warning'] = 'Ваш директоријум за податке <code>{$a}</code> је на погрешном месту и може му се приступити путем веба!';
$string['check_upgradefile_info'] = 'Датотеке са белешкама о надоградњи не би требало да буду јавне';
$string['check_vendordir_details'] = '<p>Директоријум <code>{$a->path}</code> садржи библиотеке независног произвођача и њихове зависности, обично инсталиране помоћу PHP Composera. Ове библиотеке могу бити потребне за локални развој Moodlea, као што је инсталирање PHPUnit оквира. Оне нису потребни за покретање Moodlea на продукционом северу и могу да садрже потенцијално опасан кôд и тако изложе ваш сајт удаљеним нападима.</p><p>Препоручује се да уклоните директоријум ако је сајт доступан преко јавне URL адресе, или да барем забраните веб приступ овом директоријуму, у конфигурацији свог веб сервера.</p>';
$string['check_vendordir_info'] = 'Директоријум <em>vendor</em> не би требало да буде присутан на јавним сајтовима.';
$string['check_vendordir_name'] = 'Директоријум <em>vendor</em>';
$string['check_webcron_details'] = '<p>Покретање крона из веб читача може да открије привилеговане информације анонимним корисницима. Препоручује се покретање крона само из командне линије или постављање крон лозинке за удаљени приступ.</p>';
$string['check_webcron_name'] = 'Веб крон';
$string['check_webcron_ok'] = 'Анонимни корисници не могу да приступе крону.';
$string['check_webcron_warning'] = 'Анонимни корисници могу да приступе крону.';
$string['configuration'] = 'Конфигурација';
$string['description'] = 'Опис';
$string['details'] = 'Детаљније информације';
$string['eventreportviewed'] = 'Извештај о безбедносној провери приказан';
$string['issue'] = 'Проблем';
$string['pluginname'] = 'Безбедносне провере';
$string['privacy:metadata'] = 'Додатак Преглед безбедности система не чува никакве личне податке.';
$string['security:view'] = 'Погледај извештај о безбедности';
$string['timewarning'] = 'Обрада података може потрајати, молим вас да будете стрпљиви';
