<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'local_moodleorg', language 'sr_cr', version '5.1'.
 *
 * @package     local_moodleorg
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['aboutstatistics'] = 'С обзиром да Moodle можете бесплатно да преузмете, и да је регистрација добровољна, немамо потпуне податке о свима који Moodle користе. Међутим, на основу података које поседујемо, аутоматски генеришемо неке занимљиве графиконе и бројчане податке који се могу видети на нашој страници за статистику.';
$string['aboutstatisticsheading'] = 'Moodle статистика';
$string['aboutstatisticstitle'] = 'Статистика';
$string['activeusers24hours'] = 'Регистровани корисници који су приступали сајту у последња 24 часа.';
$string['activeuserspastmonth'] = 'Регистровани корисници који су приступали сајту у последња месец дана.';
$string['browsegittitle'] = 'Прегледајте наш изворни кôд';
$string['cachedef_frontpagecolumn'] = 'Колоне на насловној страници';
$string['cachedef_usefulposts'] = 'Корисни постови';
$string['communities'] = 'Заједнице';
$string['communitiesmy'] = 'Моје заједнице';
$string['community'] = 'Заједница';
$string['communityadministration'] = 'Администрација заједнице';
$string['communitycurrent'] = 'Тренутна заједница';
$string['communityenrolme'] = 'Постаните члан ове заједнице';
$string['communityenrolmentoptions'] = 'Придруживање заједници';
$string['communityintro'] = 'Moodle има велику и разнолику заједницу корсиника са преко <a href="http://moodle.org/userpics">{$a->usercount} регистрованих корисника</a> само на овом Moodle сајту, који говоре преко <a href="http://download.moodle.org/langpack/">{$a->langcount} језика</a> у <a href="http://moodle.org/sites">{$a->countrycount} земаља</a> (на <a href="http://moodle.org/stats">можете видети детаљније статистичке податке</a>).';
$string['communityjoinbyyourself'] = 'Придружите се сами';
$string['communityjoinbyyourselfas'] = 'Придружите се сами као {$a->rolename}';
$string['communitynoguestaccess'] = 'Гости не могу приступити овом делу заједнице, покушајте да се пријавите.';
$string['communitynotenrollable'] = 'Не можете сами постати члан ове заједнице. Молимо обратите се фасцилитатору заједнице.';
$string['communitysomeallowguest'] = 'Неке заједнице могу дозволити приступ гостима';
$string['communityunenrolme'] = 'Напусти заједницу {$a}';
$string['conferencecenter'] = 'Moodle конференцијски центар';
$string['connectedsites'] = 'Неки Moodle сајтови су повезани са moodle.org путем Moodle умрежавања (MNet), тако да се на њих можете пријавити директно, након што Ваш идентитет буден проверен на овом сајту.';
$string['donations10over'] = 'Друге донације од 10 или више долара';
$string['donationsassociation'] = 'Придружите се <a href="https://moodleassociation.org/">Moodle Асоцијацији</a> - Помозите да се донесе одлука како да се утроше чланарине на даљи развој Moodlea.';
$string['donationsdevelopment'] = 'Међутим, развој Moodlea и одржавање свих наших сајтова заједнице нас коштају много новца, те стога увек можемо да користимо додатну подршку. Ако вам се Moodle свиђа или сматрате да је користан за ваше пословање, школу или институцију, молимо вас да размислите о донацији. Свако мало помаже.';
$string['donationsdonatenow'] = 'Донирајте сада';
$string['donationsensure'] = 'Донације осигуравају да основни зупчаници Moodle машине (наши програмери) наставе да стварају нове функције и исправљају грешке, чинећи Moodle бољим за све нас.';
$string['donationsmoodle'] = 'Донација за Moodle';
$string['donationsopensource'] = 'Moodle је софтвер истински отвореног кôда и без икаквих финансијских обавеза за наше кориснике - софтвер такав треба да буде!';
$string['donationsover1000'] = 'Претходне донације преко 1000 долара';
$string['donationsover200'] = 'Остале донације преко 200 долара';
$string['donationsover500'] = 'Остале донације преко 500 долара';
$string['donationspartner'] = 'Користите <a href="https://moodle.com/partners/">сертификоване Moodle партнере</a> за услуге -10% њиховог прихода се користи за даљи развој Moodle пројекта.';
$string['donationsshop'] = 'Купите неки од производа у нашој <a href="http://www.zazzle.com/moodle_hq/">Moodle продавници</a> и користите га са поносом!';
$string['donationsthankeveryone'] = 'Хвала свима који су допринели Moodle пројекту.';
$string['donationsthankyou'] = 'Хвала вам';
$string['donationstitle'] = 'Донације';
$string['donationsways'] = 'Други начини да финансијски допринесете Moodleu:';
$string['download_activities'] = 'Активности';
$string['download_admintools'] = 'Администраторски алати';
$string['download_appdocumentation'] = 'Документација апликације';
$string['download_appreleasenotes'] = 'Белешке о издању';
$string['download_browseall'] = 'Прегледај све';
$string['download_downloadosx'] = 'Преузмите Moodle за OS X (садржи Moodle, Apache, MySQL и PHP за покретање на Mac OS)';
$string['download_downloadwindows'] = 'Преузмите Moodle за Windows (садржи Moodle, Apache, MySQL и PHP за покретање на Windows OS)';
$string['download_forandroid'] = 'За Android';
$string['download_forios'] = 'За iOS';
$string['download_helpbox_description'] = 'Прочитајте документацију како бисте покренули свој Moodle сајт и посетите форуме наше заједнице или једноставно ступите у контакт са Moodle партнером за хостовање, инсталацију и друге услуге.';
$string['download_helpbox_installing'] = 'Инсталирање Moodlea';
$string['download_helpbox_partners'] = 'Moodle партнери';
$string['download_helpbox_support'] = 'Форуми подршке';
$string['download_helpbox_title'] = 'Потребна вам је помоћ?';
$string['download_helpbox_upgrading'] = 'Надоградња Moodlea';
$string['download_hero_description'] = 'Moodle се налази под <a class="link" href="http://docs.moodle.org/dev/License">GPL-лиценцом</a>, што значи да свако има потпуни слободу да га користи и ужива у његовим предностима.<br><br>Погледајте најновије издање Moodlea.';
$string['download_hero_headline'] = 'Moodle је апликација отвореног кода.';
$string['download_langpackinfo'] = 'Језички пакети се аутоматски генеришу на основу рада преводилаца на <a href="http://lang.moodle.org/">Сајту за превођење</a>. За више информација, погледајте <a href="https://docs.moodle.org/dev/Translation">Документацију о превођењу</a>.';
$string['download_langpackinstallinfo'] = 'Додатни језички пакети могу бити инсталирани на вашем Moodle сајту преко <em>Администрација > Администрација сајта >Језик > Језички пакети</em>, или ручно. За више информација, погледајте <a href="https://docs.moodle.org/en/Language_packs">Документацију језичких пакета</a>.';
$string['download_langpackinstalltitle'] = 'Инсталација језичког пакета';
$string['download_langpacktitle'] = 'Језички палети за Moodle {$a}';
$string['download_mobileapp'] = 'Mobile App';
$string['download_themes'] = 'Графичке теме';
$string['download_viewallbuilds'] = 'Погледајте све верзије (захтева веб сервер, PHP и базу података за покретање)';
$string['downloadcore'] = 'Наш главни начин дистрибуције је путем ових стандардних основних пакета. Они садрже велики број модула које одржавају наши главни програмери. Пакети су погодни за инсталацију на скоро свим платформама на којима већ постоје PHP и нека од база података.';
$string['downloadcoretitle'] = 'Стандардни Moodle пакети';
$string['downloadintro'] = 'Moodle је пакет отовореног кода под <a href="http://docs.moodle.org/en/License">GPL лиценцом</a>. Све што произведемо вама је доступно за бесплатно преузимање и коришћење.';
$string['downloadlang'] = 'У текућим верзијама Moodlea, додавање подршке за нове језике је аутоматизовано из администраторског менија унутар вашем сајта. Међутим, за неке старије верзије Moodlea нови језички пакети се морају ручно преузети и инсталирати.';
$string['downloadlangtitle'] = 'Језички палети';
$string['downloadmac'] = 'Уколико већ немате инсталиран веб сервер, ови "све-у-једном" пакети ће вам олакшати инсталацију Moodlea на било ком Apple рачунару са Mac OS X оперативним системом.';
$string['downloadmactitle'] = 'Moodle за Mac OS X';
$string['downloadmodules'] = 'Претражите нашу свеобухватну базу нестандардних модула и додатака који могу бити додати вашем Moodleu, како бисте му обезбедили додатну функционалност, изван основног пакета.';
$string['downloadmodulestitle'] = 'Модули и додаци';
$string['downloadthemes'] = 'Изглед Moodle сајта се може драматично променити коришћењем различитих графичких тема. Ми одржавамо базу графичких тема које су креирали наши корисници.';
$string['downloadthemestitle'] = 'Графичке теме';
$string['downloadviagitcvs'] = 'Други начини да преузмете Moodle укључује <a href="http://docs.moodle.org/en/Git_for_Administrators">преузимање путем Gita</a> или <a href="http://docs.moodle.org/22/en/CVS_for_Administrators">путем CVS-а</a>.';
$string['downloadwin'] = 'Уколико већ немате инсталиран веб сервер, ови "све-у-једном" пакети ће Вам олакшати инсталацију Moodlea на било ком  рачунару са Microsoft Windows оперативним системом.';
$string['downloadwintitle'] = 'Moodle за Windows';
$string['erroradminonly'] = 'Овом интерфејсу могу да приступе само администратори';
$string['erroralreadyvoted'] = 'Већ сте гласали за {$a}';
$string['errormaxmessages'] = 'Опростите, али не можете послати више од 3 поруке.';
$string['errornomainnews'] = 'На овом сајту, није могуће пронаћи или креирати главни форум Вести';
$string['errorsendingmail'] = 'Догодила се грешка приликом слања поруке. Молимо, покушајте поново касније или се обратите администратору сајта.';
$string['eventdonation_created'] = 'Направљен је списак донација';
$string['eventdonation_submitted'] = 'Донација послата';
$string['events'] = 'Иако смо ми специјализовани за онлајн учење, још увек је лепо срести се уживо, у реалном свету. Погледајте ове линкове за више информација о нашим конференцијама (ми их зовемо Moodle Moot) и другим догађајима.';
$string['eventstitle'] = 'Догађаји';
$string['feed_events'] = 'Догађаји';
$string['feed_events_more'] = 'Више уноса у календару';
$string['feed_news'] = 'Обавештења';
$string['feed_news_more'] = 'Погледајте сва обавештења';
$string['feed_resources'] = 'Ресурси';
$string['feed_useful'] = 'Корисни постови';
$string['feed_useful_more'] = 'Још постова';
$string['focusbox_community'] = 'Подршка и форуми заједнице';
$string['focusbox_community_text'] = 'Добијте подршку и поделите идеје на свом језику.';
$string['focusbox_community_viewall'] = 'Све заједнице';
$string['focusbox_future'] = 'Помозите у обликовању будућности Moodlea';
$string['focusbox_future_crowdfund'] = 'Финансирање пројеката';
$string['focusbox_future_gdf'] = 'Дискусије за програмере';
$string['focusbox_future_research'] = 'Moodle истраживање';
$string['focusbox_future_roadmap'] = 'План';
$string['focusbox_future_text'] = 'Сазнајте шта је следеће и помозите нам да направимо разлику.';
$string['focusbox_future_ux'] = 'Дискусије о корисничком искуству (UX).';
$string['focusbox_settingup'] = 'Подешавање';
$string['focusbox_settingup_community'] = 'Подршка заједнице';
$string['focusbox_settingup_download'] = 'Бесплатно преузимање';
$string['focusbox_settingup_hosting'] = 'Хостинг';
$string['focusbox_settingup_install'] = 'Инсталација';
$string['focusbox_settingup_own'] = 'Самостално';
$string['focusbox_settingup_partner'] = 'Преко Moodle партнера';
$string['focusbox_settingup_plugins'] = 'Додаци';
$string['focusbox_settingup_support'] = 'Комерцијална подршка';
$string['focusbox_teaching'] = 'Настава уз Moodle';
$string['focusbox_teaching_books'] = 'Књиге';
$string['focusbox_teaching_courses'] = 'Курсеви и садржај';
$string['focusbox_teaching_docs'] = 'Документација';
$string['focusbox_teaching_text'] = 'Истражите широк спектар функција и доступних ресурса Moodlea.';
$string['focusbox_theproject'] = 'Moodle пројекат';
$string['focusbox_theproject_about'] = 'О Moodleu';
$string['focusbox_theproject_devs'] = 'Програмери';
$string['focusbox_theproject_hq'] = 'Moodle HQ';
$string['focusbox_theproject_mua'] = 'Удружење Moodle корисника (МUA - Moodle Users Association)';
$string['focusbox_theproject_partners'] = 'Moodle партнери';
$string['focusbox_theproject_stats'] = 'Статистика';
$string['focusbox_theproject_text'] = 'Сазнајте више о Moodle пројекту и нашим отвореним, сарадничким партнерствима.';
$string['focusbox_uptodate'] = 'Будите у току';
$string['focusbox_uptodate_buzz'] = 'Moodle buzz';
$string['focusbox_uptodate_news'] = 'Обавештења';
$string['focusbox_uptodate_planet'] = 'Planet Moodle';
$string['focusbox_uptodate_security'] = 'Безбедносна обавештења';
$string['focusbox_uptodate_social'] = 'Друштвени медији';
$string['focusbox_uptodate_text'] = 'Најновије Moodle вести, ажурирања и сведочанства широм света.';
$string['generaldeveloperforum'] = 'Општи форум за развој';
$string['graphpopulation'] = 'Графикон Moodle популације';
$string['graphregistrationmap'] = 'Moodle мапа регистрованих сајтова';
$string['graphregistrationmapdesc'] = 'Топ 10 регистрованих сајтова из {$a} земаља';
$string['graphusersites'] = 'Поређење Moodle сајтова према броју корисника';
$string['heroslide_community_description'] = 'Добродошли у Moodle заједницу! Откријте вредност отвореног, заједничког напора једног од највећих тимова отвореног кôда на свету.';
$string['heroslide_community_headline'] = 'Вођен заједницом, глобално подржан.';
$string['heroslide_community_slidecontrol'] = 'Подржана од стране глобалне заједнице';
$string['heroslide_donate_headline'] = 'Помозите нам да направимо разлику са отвореним и квалитетним образовањем за све';
$string['heroslide_getstarted40_description'] = 'Moodle LMS има нови препознатљив изглед и редефинисано корисничко искуство које унапређује онлајн наставу и учење за предаваче, полазнике и администраторе.';
$string['heroslide_getstarted40_headline'] = 'Moodle 4.0 - Нови изглед, боље корисничко искуство!';
$string['heroslide_getstarted40_slidecontrol'] = 'Moodle 4.0 је овде!';
$string['heroslide_getstarted_description'] = 'Moodle је најпопуларнији систем за управљање учењем на свету. Почните да креирате своју веб sajt за онлајн учење за неколико минута!';
$string['heroslide_getstarted_headline'] = 'Почети је лако';
$string['heroslide_getstarted_slidecontrol'] = 'Почните још данас';
$string['heroslide_global_description'] = 'Доступан на преко 100 језика, Moodle има велико поверење бројних организација и институција, великих и малих, са милионима корисника широм света.';
$string['heroslide_global_headline'] = 'Покреће окружења за учење широм света';
$string['heroslide_global_slidecontrol'] = 'Покреће окружења за учење широм света';
$string['heroslide_link_demo'] = 'Демо';
$string['heroslide_link_donate'] = 'Донирајте';
$string['heroslide_link_features'] = 'Функције';
$string['heroslide_link_forums'] = 'Форуми заједнице';
$string['heroslide_link_getstarted'] = 'Почните још данас';
$string['heroslide_link_getstarted40'] = 'Сазнајте више о Moodleu 4.0';
$string['heroslide_link_sites'] = 'Регистровани сајтови';
$string['heroslide_link_stats'] = 'Статистика';
$string['heroslide_link_stories'] = 'Опширније';
$string['heroslide_power40_description'] = 'Лако, брзо и интуитивно! Истражите побољшано корисничко искуство и нове функције Moodle верзије 4.0.';
$string['heroslide_power40_headline'] = 'Доживите Moodle 4.0';
$string['heroslide_power40_slidecontrol'] = 'Доживите Moodle 4.0';
$string['heroslide_power_description'] = 'Светска бесплатна платформа за учење која вам помаже да креирате ефикасну онлајн наставу и искуство учења у колаборативном и приватном окружењу.';
$string['heroslide_power_headline'] = 'Моћан. Безбедан. Отвореног кôда.';
$string['heroslide_power_slidecontrol'] = 'Робусна платформа за учење отвореног кôда';
$string['heroslide_story1_description'] = '“Водећи у учењу уз помоћ технологије, Moodle нам омогућава да олакшамо нашим студентима откривање и креативност.” - проф. Дарел Еванс, продекан за наставу, Универзитет Монаш';
$string['heroslide_story1_headline'] = 'Побољшање наставе и учења свуда';
$string['heroslide_story2_description'] = 'Глобални провајдер услуга за транспорт, логистику и поморске услуге, GAC, омогућава учење и развој за преко 10.000 запослених у више од 70 земаља, са својом корпоративном академијом.';
$string['heroslide_story2_headline'] = 'Постизање изврсности на пољу корпоративног учења';
$string['heroslide_story3_description'] = 'Forth Valley College је један од највећих шкотских колеџа, који нуди више од 750 курсева са преко 20.000 активних корисника на својим сајтовима.';
$string['heroslide_story3_headline'] = 'Пружање свестраног флексибилног образовања';
$string['heroslide_story4_description'] = 'Voluntary Service Overseas - VSO (Волонтерска служба у иностранству) пружа интерактивно учење и подршку волонтерима на међународном нивоу како би им се омогућио глобални приступ обуци.';
$string['heroslide_story4_headline'] = 'Помоћ волонтерима у реализацији програма за борбу против сиромаштва';
$string['heroslide_story5_description'] = 'Слајд 5 - опис';
$string['heroslide_story5_headline'] = 'Слајд 5 - наслов';
$string['heroslide_story_slidecontrol'] = 'Moodle приче из целог света';
$string['jobs'] = 'Посетите нашу базу података о пословима за више информација о радним местима широм света, која су у вези са Моodleom';
$string['logoinfo'] = 'Назив Moodle™ је регистровани заштитни знак компаније Moodle Trust.

Ако намеравате да користите име и/или лого за рекламирање генеричких Moodle услуга (нпр. Moodle хостинг, Moodle подршка, Moodle сертификација, Moodle обука, Moodle консалтинг, прилагођавање Moodlea, развој Moodle програма за курсеве, дизајн Moodle графичких тема, Moodle интеграције, Moodle инсталације, итд.) или као назив софтверског пакета, онда морате тражити и добити директну писмену дозволу од компаније Moodle Trust путем [moodle.com helpdesk](http://moodle.com/helpdesk/), у складу са уобичајена ограничењима у коришћењу заштног знака.

Не постоје ограничења у вези са начином на који користите име у другим контекстима (на пример, ако користите Moodle само да бисте држали онлајн курсеве, онда можете слободно да користите име како бисте се позвали на њега). Ако нисте сигурни у конкретном случај, можете нам послати питање путем [moodle.com helpdesk](http://moodle.com/helpdesk/). Биће нам драго да вам дамо званичну дозволу у писаној форми или да вам помогнемо да поправите свој текст.';
$string['logotitle'] = 'Moodle лого';
$string['manageads'] = 'Управљање огласима партнера';
$string['managedonations'] = 'Управљање донацијама';
$string['moodleorg:manageads'] = 'Управљање огласима партнера';
$string['moodleorg:managedonations'] = 'Управљање регистром донација';
$string['moodlepartner_corporate'] = 'Корпоративни обука';
$string['moodlepartner_other'] = 'Остали сектори';
$string['moodlepartner_school'] = 'Школа';
$string['moodlepartner_university'] = 'Универзитет';
$string['networkinfo'] = 'Следећи Moodle сајтови су повезани са сајтом moodle.org користећи Moodle умрежавање, тако да се директно одавде можете пријавити на те сајтове.';
$string['networktitle'] = 'Повезани сајтови';
$string['newregistrations'] = 'Нове регистрације';
$string['newstitle'] = 'Обавештења';
$string['noenrolledcoursesyet'] = 'Још увек нисте уписани ни на један курс на овом сајту';
$string['partnerslogan'] = 'Moodle пројекат подржава преко 90 сертификованих <a href="https://moodle.com/partners/">Moodle партнера</a> широм света.';
$string['permalink'] = 'Перманентни линк';
$string['pluginname'] = 'Moodle.org сајт';
$string['popularissues'] = 'Најпопуларнији питања';
$string['privacy:metadata:db:registerdonations'] = 'Има евиденцију о донацијама Moodleu';
$string['privacy:metadata:db:registerdonations:amount'] = 'Донирани износ';
$string['privacy:metadata:db:registerdonations:name'] = 'Име/назив донатора';
$string['privacy:metadata:db:registerdonations:org'] = 'Донаторска организација';
$string['privacy:metadata:db:registerdonations:timedonated'] = 'Време донације';
$string['privacy:metadata:db:registerdonations:url'] = 'URL адреса донатора';
$string['recentlyratedposts'] = 'Недавно оцењени постови';
$string['recentpart'] = 'Ова страница приказује неке од људи који су данас користили moodle.org';
$string['registeredsites'] = 'Институције нису обавезне да било кога обавесте о томе да користе Moodle, зато што је  Moodle софтвер отвореног кода. Међутим, неки Moodle сајтови су изабрали да се региструју код нас и ми одржавамо списак тих сајтова.';
$string['registeredsitestitle'] = 'Регистровани сајтови';
$string['registereduserslastday'] = 'Нови корисници (у последња 24 часа)';
$string['registereduserstotal'] = 'Укупно регистрованих корисника';
$string['registrationgraphalt'] = 'Сви Moodle регистровани сајтови током времена';
$string['registrationgraphdesc'] = 'Ми спроводимо <a href="http://docs.moodle.org/en/Usage">редовну масовну проверу регистрованих сајтова</a> како би били сигурни да су они и даље активни, тако да повремено можете видети да се њихов број смањује.';
$string['registrationslast6months'] = 'Регистровани сајтови у последњих 6 месеци';
$string['registrationslastmonths'] = 'Регистрације у последња/их {$a} месец/и/a';
$string['registrationstotal'] = 'Све тренутне регистрације';
$string['resources_buzz'] = 'Buzz';
$string['resources_courses'] = 'Курсеви';
$string['resources_jobs'] = 'Послови';
$string['resources_plugins'] = 'Додаци';
$string['roadmap'] = 'План развоја Moodlea';
$string['rssdescription'] = 'Недавни или постови оцењени као корисни на форуму на moodle.org';
$string['rssmoodlecommore'] = 'Погледајте све најновије вести';
$string['rssmoodlecomtitle'] = 'Најновије вести';
$string['rsstitle'] = 'Постови на Moodle.org форумима';
$string['searchmoodleorg'] = 'Претражите moodle.org';
$string['securitytitle'] = 'Безбедносна обавештења';
$string['shop'] = 'Да ли тражите начин на који ћете показати да сте део наше заједнице? Посетите онлајн продавницу у којој можете купити мајице, шоље и разне друге производе.';
$string['social-facebook-moodle'] = 'Званична Moodle страница на Facebooku';
$string['social-googleplus-community'] = 'Званична страница Moodle заједнице на Google+';
$string['social-googleplus-moodle'] = 'Званична Moodle страница на Google+';
$string['social-linkedin-moodle'] = 'Званична Moodle страница на LinkedInu';
$string['social-twitter-moodle'] = 'Званична Moodle обавештења, агрегиране Moodle вести (Planet Moodle и Moodle buzz), као и корисни постови на форумима';
$string['social-twitter-moodledev'] = 'Вести о развоју и ажурирања Moodlea';
$string['social-twitter-moodlehq'] = 'Твитови Moodle HQ-а';
$string['social-twitter-moodlejobs'] = 'Послови, везани за Moodle, у понуди';
$string['social-twitter-moodlenet'] = 'Дељени Moodle курсеви и садржаји';
$string['social-twitter-moodleplugins'] = 'Недавно објављени Moodle додаци';
$string['social-twitter-moodleresearch'] = 'Новости о годишњој Moodle Research конференцији и истраживањима повезаним за Moodle';
$string['social-twitter-moodlesecurity'] = 'Moodle безбедносна обавештења';
$string['social-twitter-moodlesites'] = 'Ажурирања статуса за Moodle HQ мрежу сајтова и сервиса';
$string['social-twitter-moodlethemes'] = 'Недавно објављене Moodle графичке теме';
$string['social-youtube-moodle'] = 'Званични Moodle канал на YouTubeu';
$string['socialinfo'] = 'Присутни смо се на неколико сајтова друштвених медија како бисмо помогли у подизању свести о Moodle пројекту и поделили најновије вести и дешавања у свету Moodlea. Пратите нас како бисте били у току и упознали друге мудлере у заједници!';
$string['socialtitle'] = 'Друштвени медији';
$string['statscountries'] = 'Земље';
$string['statscourses'] = 'Курсеви';
$string['statsenrolments'] = 'Уписи';
$string['statsposts'] = 'Постови на форуму';
$string['statsquestions'] = 'Тест питања';
$string['statsresources'] = 'Ресурси';
$string['statsteachers'] = 'Предавачи';
$string['statsusers'] = 'Корисници';
$string['supportbooks'] = 'Одржавамо списак великог броја књига о Moodleu, које можете наручити.';
$string['supportcommercial'] = 'Moodle партнери представљају групу овлашћених компанија широм света који могу да вам помогну у имплементацијиа Moodlea.';
$string['supportdocs1'] = 'Moodle Docs је одлично место за почетак, посебно наше странице са Често постављаним питањима (FAQ).';
$string['supportdocs2'] = 'Најбољи начин за приступ релевантној документацији јесте коришћење линка "Moodle документација за ову страницу" који се налази на дну сваке странице Вашег Moodle сајта.';
$string['supportdocsfaq'] = 'Често постављана питања (FAQ)';
$string['supportdocslang'] = 'Moodle Docs на другим језицима';
$string['supportforums'] = 'Наша заједница корисника већином комуницира путем форума унутар "курсева" на овом Moodle сајту. Морате да се "упишете" на курс како бисте могли да учествујете у дискусијама на форумима (упис је потпуно бесплатан).';
$string['supportforumsenglish'] = 'Главна подршка и дискусије о развоју између корисника и програмера се одвијају (на енглеском) овде:';
$string['supportforumsenglishname'] = 'Коришћење Moodlea';
$string['supportforumslang'] = 'Главни форум за дружење корисника Moodlea, на енглеском, се налази овде:';
$string['supportforumslangname'] = 'Moodle Lounge';
$string['supportforumslangurl'] = 'http://moodle.org/course/view.php?id=55';
$string['supportforumslist'] = 'Постоји велики број других форума на многобројним језицима:';
$string['supportforumslistname'] = 'Списак свих курсева';
$string['supportintro'] = 'Нисте сами! Постоје разни начини да добијете помоћ у коришћењу Moodlea, уколико Вам је она потребна.';
$string['syncregistrationstask'] = 'Синхронизујте ажурирања регистрације сајта под Moodle верзијом 1.9 са moodle.net';
$string['top10countriesbyregistration'] = 'Топ 10 земаља према броју регистрованих сајтова';
$string['top10sitesbycourses'] = '10 топ сајтова по броју курсева';
$string['top10sitesbyusers'] = '10 топ сајтова по броју корисника';
$string['url-about'] = 'http://docs.moodle.org/en/About_Moodle';
$string['url-features'] = 'http://docs.moodle.org/en/Features';
$string['url-install'] = 'http://docs.moodle.org/en/Installation';
$string['url-standards'] = 'http://docs.moodle.org/en/Standards';
$string['url-userdocs'] = 'http://docs.moodle.org/en/';
$string['versionsused'] = 'Коришћене верзије';
