<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'diary', language 'ru', version '5.1'.
 *
 * @package     diary
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['accessdenied'] = 'Доступ закрыт';
$string['additionallinks'] = 'Дополнительные ссылки на данный модуль и курс';
$string['addtofeedback'] = 'Добавить стат. и авторейтинг в отзыв';
$string['alias'] = 'Ключевое слово';
$string['aliases'] = 'Ключевое(ые) слово(а)';
$string['aliases_help'] = 'Каждая запись в дневнике связана со списком ключевых слов (тэгов).

Введите каждое ключевое слово с новой строки (не через запятую).';
$string['alwaysopen'] = 'Всегда открыт';
$string['alwaysshowdescription'] = 'Всегда показывать описание';
$string['alwaysshowdescription_help'] = 'При отключенном параметре приведенное выше описание дневника будет видно студентам только в дату «Время открытия».';
$string['and'] = 'и';
$string['attachment'] = 'Вложение';
$string['attachment_help'] = 'При желании вы можете прикрепить к дневниковой записи один или несколько файлов.';
$string['autorating'] = 'Авторейтинг';
$string['autorating_descr'] = 'Если этот параметр включен, рейтинг записи будет вычислен автоматически на основе настроек Мин/Макс.';
$string['autorating_help'] = 'Эти настройки вместе с настройками Мин/Макс определяют значения по умолчанию для авторейтинга во всех новых дневниках.';
$string['autorating_title'] = 'Включить авторейтинг';
$string['autoratingbelowmaxitemdetails'] = 'Для автоматической оценки требуется {$a->one} или более {$a->two} с возможным штрафом в размере {$a->three}% за каждый недостающий элемент.<br>Вы использователи {$a->four}. Вам нужно набрать {$a->five}. Возможный штраф - {$a->six} баллов.';
$string['autoratingitempenaltymath'] = 'Расчет автоматического штрафа за элемент: (max({$a->one} - {$a->two}, 0)) * {$a->three} = {$a->four}.<br> Примечание: max предотвращает появление отрицательных чисел, вызванных избыточным числом записей.';
$string['autoratingitempercentset'] = 'Параметр автоматической оценки элемента в процентах: {$a}%';
$string['autoratingovermaxitemdetails'] = 'Для автоматической оценки установлено ограничение в {$a->one} {$a->two} с возможным штрафом в размере {$a->three}% за каждый лишний элемент.<br>Вы использовали {$a->four}, это на {$a->five} больше ограничения. Возможный штраф - {$a->six} баллов.';
$string['availabilityhdr'] = 'Доступность';
$string['avgsylperword'] = 'Среднее количество слогов в слове {$a}';
$string['avgwordlenchar'] = 'Средняя длина слова {$a} символов';
$string['avgwordpara'] = 'Среднее количество слов в абзаце {$a}';
$string['blankentry'] = 'Пустая запись';
$string['calendarend'] = '{$a} закрывается';
$string['calendarstart'] = '{$a} открывается';
$string['cancel'] = 'Отменить передачу';
$string['chars'] = 'Символов:';
$string['charspersentence'] = 'Символов в предложении';
$string['clearfeedback'] = 'Очистить отзыв';
$string['commonerrorpercentset'] = 'Настройка процента типовых ошибок {$a}%';
$string['commonerrors'] = 'Типовые ошибки';
$string['commonerrors_help'] = 'Распространенные ошибки описаны в «Глоссарии ошибок», связанном с этим вопросом.';
$string['configdateformat'] = 'Это определяет, как даты отображаются в дневниковых отчетах. Значение по умолчанию «M d, Y G:i» - это месяц, день, год и время в 24-часовом формате. Дополнительные примеры и предопределенные константы даты см. в разделе «Дата» в руководстве по PHP.';
$string['created'] = 'Создана {$a->one} дн. и {$a->two} час. назад.';
$string['createnewprompt'] = 'Создать подсказку';
$string['crontask'] = 'Фоновая обработка для модуля «Дневник»';
$string['csvexport'] = 'Экспортировать в .csv';
$string['currententry'] = 'Текущие записи дневника:';
$string['currpotrating'] = 'Ваш текущий потенциальный рейтинг составляет: {$a->one} балл(ов) или {$a->two}%.';
$string['datechanged'] = 'Дата изменения:';
$string['dateformat'] = 'Формат даты по умолчанию';
$string['datestart'] = 'Установите дату начала использования подсказки {$a}:';
$string['datestop'] = 'Установите дату окончания использования подсказки {$a}:';
$string['daysavailable'] = 'Доступен дней:';
$string['daysavailable_help'] = 'При использовании еженедельного формата вы можете указать, сколько дней дневник открыт для использования.';
$string['deadline'] = 'Открыт дней:';
$string['delete'] = 'Удалить';
$string['deleteallratings'] = 'Удалить все рейтинги';
$string['deleteexconfirm'] = 'Подтвердите, что хотите удалить подсказку';
$string['deletenotenrolled'] = 'Удалить записи незарегистрированных пользователей';
$string['details'] = 'Подробности:';
$string['detectcommonerror'] = 'Обнаружено по меньшей мере {$a->one}, {$a->two}. Это: {$a->three}
<br>Вы должны внести исправления и отправить запись повторно (если это допускается)';
$string['diary:addentries'] = 'Добавлять записи в дневник';
$string['diary:addinstance'] = 'Добавлять экземпляры дневника';
$string['diary:manageentries'] = 'Управлять записями дневника';
$string['diary:rate'] = 'Оценивать записи дневника';
$string['diaryclosetime'] = 'Дневник закрывается';
$string['diaryclosetime_help'] = 'Если установлено, вы можете установить дату, когда дневник будет закрыт и больше не будет доступен для использования.';
$string['diarydescription'] = 'Описание дневника';
$string['diaryentrydate'] = 'Установить дату для этой записи';
$string['diaryid'] = 'ID дневника, в который будет осуществлен перенос';
$string['diarymail'] = 'Приветствия, {$a->user}, {$a->teacher} оставил отзыв к вашей дневниковой записи \'{$a->diary}\'. Вы можете просмотреть его в своем дневнике: {$a->url}';
$string['diarymailhtml'] = 'Приветствия, {$a->user}, {$a->teacher} оставил отзыв к вашей дневниковой записи \'<i>{$a->diary}</i>\'.<br /><br /> Вы можете просмотреть его<a href="{$a->url}">в своем дневнике</a>.';
$string['diarymailhtmluser'] = 'опубликовал запись в дневнике «<i>{$a->diary}</i>»<br /><br />
Вы можете просмотреть <a href="{$a->url}"> запись по ссылке</a>.<br /><br />Примечание: Возможно, вам потребуется оставить отзыв или обновить статус записи, чтобы действие было отмечено как завершенное.';
$string['diarymailuser'] = 'В дневнике «{$a->diary}» опубликована запись.

Вы можете просмотреть запись здесь:

    {$a->url}

Примечание: Возможно, вам потребуется оставить отзыв или обновить статус записи, чтобы запись была учтена.';
$string['diaryname'] = 'Название дневника';
$string['diaryopentime'] = 'Дневник открывается';
$string['diaryopentime_help'] = 'Если установлено, можно задать дату, когда дневник станет доступным для ведения';
$string['diarytitle'] = 'Название';
$string['diarytitle_help'] = 'Вы можете добавить необязательный заголовок/описание';
$string['editall'] = 'Разрешить редактировать все записи';
$string['editall_help'] = 'Если установлено, пользователи могут редактировать все записи дневника';
$string['editdates'] = 'Разрешить редактировать даты записей';
$string['editdates_help'] = 'Если установлено, пользователи могут редактировать дату/время любой записи';
$string['editingended'] = 'Период редактирования истек';
$string['editingends'] = 'Период редактирования истекает';
$string['editthisentry'] = 'Редактировать эту запись';
$string['edittopoflist'] = 'Редактировать верх списка';
$string['eeditlabel'] = 'Править';
$string['emaillater'] = 'Отправить электронное письмо позже';
$string['emailnow'] = 'Отправить электронное письмо немедленно';
$string['emailpreference'] = 'Переключить настройки отправки электронных писем';
$string['enableautorating'] = 'Включить авторейтинг';
$string['enableautorating_help'] = 'Включить или отключить авторейтинг';
$string['enablestats'] = 'Включить статистику';
$string['enablestats_descr'] = 'Если этот параметр включен, то будет отображаться статистика по каждой записи.';
$string['enablestats_help'] = 'Включить или отключить статистику по каждой записи';
$string['enablestats_title'] = 'Включить статистику';
$string['enabletitles'] = 'Включить заголовки';
$string['enabletitles_descr'] = 'Если этот параметр включен, то заголовки для каждой записи будут обязательными и будут отображаться на экране.';
$string['enabletitles_help'] = 'Включить или отключить обязательные заголовки для каждой записи';
$string['enabletitles_title'] = 'Включить заголовки';
$string['entries'] = 'Записи';
$string['entry'] = 'Запись';
$string['entrybgc'] = 'Цвет фона записи/отзыва  в дневнике';
$string['entrybgc_colour'] = '#93FC84';
$string['entrybgc_descr'] = 'Устанавливает цвет фона дневниковой записи / отзыва.';
$string['entrybgc_help'] = 'Настройка общего цвета фона для каждой записи в дневнике и отзывах.';
$string['entrybgc_title'] = 'Цвет фона записи / отзыва в дневнике';
$string['entrycomment'] = 'Комментарий к записи';
$string['entrysuccess'] = 'Ваша запись сохранена! Возможно, ее потребуется просмотреть или оценить, прежде чем задание будет считаться выполненным.';
$string['entrytextbgc'] = 'Цвет фона текста дневника';
$string['entrytextbgc_colour'] = '#EEFC84';
$string['entrytextbgc_descr'] = 'Устанавливает цвет фона текста в дневниковой записи.';
$string['entrytextbgc_help'] = 'Настройка цвета фона для текста записи в дневнике.';
$string['entrytextbgc_title'] = 'Цвет фона текста дневника';
$string['errorbehavior'] = 'Поведение при сопоставлении ошибок';
$string['errorbehavior_help'] = 'Эти настройки уточняют порядок сопоставления записей в Глоссарии распространенных ошибок.';
$string['errorcmid'] = 'Глоссарий ошибок';
$string['errorcmid_help'] = 'Выберите глоссарий, содержащий список распространенных ошибок. Каждый раз, когда в ответе будет обнаружена одна из ошибок, указанный штраф будет вычитаться из рейтинга студента за эту запись.';
$string['errorfullmatch'] = 'Поведение при сопоставлении ошибок';
$string['errorfullmatch_help'] = 'Эти настройки уточняют порядок сопоставления записей в Глоссарии распространенных ошибок.';
$string['errorpercent'] = 'Штраф за ошибку';
$string['errorpercent_help'] = 'Выберите процент от общей оценки, который будет вычитаться за каждую ошибку, обнаруженную в ответе.';
$string['errp'] = '% ошибок:';
$string['eventdiarycreated'] = 'Дневник создан';
$string['eventdiarydeleted'] = 'Дневник удален';
$string['eventdiaryviewed'] = 'Дневник просмотрен';
$string['eventdownloadentriess'] = 'Скачать записи';
$string['evententriesviewed'] = 'Записи дневника просмотрены';
$string['evententrycreated'] = 'Запись дневника создана';
$string['evententryupdated'] = 'Запись дневника обновлена';
$string['eventfeedbackupdated'] = 'Отзыв по дневнику обновлен';
$string['eventinvalidentryattempt'] = 'Попытка неверного входа в дневник';
$string['eventpromptcreated'] = 'Подсказка создана';
$string['eventpromptedited'] = 'Подсказка отредактирована';
$string['eventpromptinuse'] = 'Предотвращено удаление подсказки';
$string['eventpromptremoved'] = 'Подсказка удалена';
$string['eventpromptsviewed'] = 'Подсказок просмотрено';
$string['eventxfrentries'] = 'Перенос записей из журнала в дневник';
$string['exportfilename'] = 'записи.csv';
$string['exportfilenamep1'] = 'Весь_сайт';
$string['exportfilenamep2'] = '_Записи_дневника_экспортированы_';
$string['feedbackupdated'] = 'Обновлен отзыв к записям ({$a})';
$string['files'] = 'Файлы';
$string['firstentry'] = 'Первые дневниковые записи:';
$string['fkgrade'] = 'Уровень чтения "Флеш–Кинкейд" (FK)';
$string['fkgrade_help'] = 'Средний балл по шкале Флеша Кинкейда указывает на количество лет обучения, которое обычно требуется для понимания данного текста. Постарайтесь получить оценку ниже 10 баллов.';
$string['fogindex'] = 'Индекс туманности';
$string['fogindex_help'] = 'Индекс туманности - это показатель удобочитаемости текста. Он рассчитывается по следующей формуле.

 ((слов в предложении) + (длинных слов в предложении)) х 0,4

Постарайтесь получить оценку ниже 10 баллов. Для получения дополнительной информации смотрите (на английском языке): <https://en.wikipedia.org/wiki/Gunning_fog_index>';
$string['for'] = 'с сайта:';
$string['format'] = 'Формат';
$string['freadingease'] = 'Легкость чтения по Флешу';
$string['freadingease_help'] = 'Легкость чтения по Флешу: высокие баллы указывают на то, что ваш текст прост для чтения, а низкие баллы — на то, что ваш текст сложен для чтения. Старайтесь, чтобы показатель легкости чтения был выше 60.';
$string['generalerror'] = 'Произошла ошибка.';
$string['generalerrorinsert'] = 'Не удалось добавить новую запись в дневник';
$string['generalerrorupdate'] = 'Не удалось обновить ваш дневник';
$string['gradeingradebook'] = 'Текущий рейтинг в журнале оценок';
$string['highestgradeentry'] = 'Записи с наивысшим рейтингом:';
$string['idlable'] = '(ID: {$a})';
$string['incorrectcourseid'] = 'Идентификатор курса неверен';
$string['incorrectmodule'] = 'Идентификатор модуля курса неверен';
$string['invalidaccess'] = 'Недействительный доступ';
$string['invalidaccessexp'] = 'У вас нет разрешения на просмотр страницы, к которой вы пытались получить доступ! Попытка просмотра записана в журнал!';
$string['invalidtimechange'] = 'Обнаружена недопустимая попытка изменить время создания этой записи.';
$string['invalidtimechangenewtime'] = 'Новое (измененное) время: {$a->one}.';
$string['invalidtimechangeoriginal'] = 'Исходное время: {$a->one}.';
$string['invalidtimeresettime'] = 'Значение времени было сброшено в исходное: {$a->one}.';
$string['journalid'] = 'ID журнала для переноса';
$string['journalmissing'] = 'В настоящее время в этом курсе нет журналов.';
$string['journaltodiaryxfrdid'] = '<br>Это список всех дневников данного курса.<br><b>    ID</b> | Курс | Название дневника<br>';
$string['journaltodiaryxfrjid'] = '<br>Это список всех журналов данного курса.<br><b>     ID</b> | Курс | Название журнала<br>';
$string['journaltodiaryxfrp1'] = 'Эта функция предназначена только для администратора. Она позволяет переносить записи из журнала в дневник. Записи из нескольких журналов могут быть перенесены в один дневник или в несколько отдельных дневников. Это новая возможность, которая все еще находится в стадии разработки.<br><br>';
$string['journaltodiaryxfrp2'] = 'Если вы установите флажок <b>Перенести и отправить по электронной почте</b>, то любая запись в журнале, перенесенная в дневник, будет помечена как требующая отправки пользователю электронного письма, чтобы он знал, что запись была перенесена в дневник.<br><br>';
$string['journaltodiaryxfrp3'] = 'Если вы используете кнопку <b>Перенести без электронной почты</b>, то электронное письмо НЕ будет отправлено каждому пользователю, при этом автоматически добавляется отзыв в новую запись дневника, даже если исходная запись журнала не содержала отзыва.<br><br>';
$string['journaltodiaryxfrp4'] = 'Курс, в котором вы работаете, называется: <b> {$a->one}</b>,  ID курса: <b> {$a->two}</b><br><br>';
$string['journaltodiaryxfrp5'] = 'Если вы решите включить отзыв о переносе, а в журнале еще нет отзывов, вы будете автоматически добавлены в качестве преподавателя для этой записи, чтобы предотвратить ошибку.<br><br>';
$string['journaltodiaryxfrtitle'] = 'Перенос из Журнала в Дневник';
$string['lastnameasc'] = 'Фамилия (по возрастанию):';
$string['lastnamedesc'] = 'Фамилия (по убыванию):';
$string['latestmodifiedentry'] = 'Последние измененные записи:';
$string['lexicaldensity'] = 'Лексическая плотность';
$string['lexicaldensity_help'] = 'Лексическая плотность - это процент, рассчитываемый по следующей формуле.

 100 х (количество уникальных слов) / (общее количество слов)

Таким образом, эссе, в котором повторяется много слов, имеет низкую лексическую плотность, в то время как эссе с большим количеством уникальных слов имеет высокую лексическую плотность.';
$string['longwords'] = 'Уникальных длинных слов';
$string['longwords_help'] = 'Длинные слова - это слова, состоящие из трех и более слогов. Обратите внимание, что алгоритм определения количества слогов дает лишь приблизительные результаты.';
$string['longwordspersentence'] = 'Длинных слов в предложении';
$string['lowestgradeentry'] = 'Записи с самым низким рейтингом:';
$string['mailed'] = 'Отправлено по почте';
$string['mailsubject'] = 'Отзыв по дневнику';
$string['max'] = 'макс.';
$string['maxc'] = 'Макс.:';
$string['maxchar'] = 'Максимальное количество символов';
$string['maxchar_help'] = 'Если введено число больше нуля, то пользователь должен использовать меньше символов, чем указано в максимальном количестве. Иначе он получит штраф за каждый лишний символ.';
$string['maxcharacterlimit'] = 'Максимальное количество символов';
$string['maxcharacterlimit_desc'] = 'Примечание: В этой записи может быть использовано <strong>не более {$a} символов.</strong>';
$string['maxcharacterlimit_help'] = 'Если введено число, то пользователь должен использовать меньше символов, чем указано в максимальном количестве.';
$string['maxparagraph'] = 'Максимальное количество абзацев';
$string['maxparagraph_help'] = 'Если введено число больше нуля, то пользователь должен использовать меньшее количество абзацев, чем указано в данной настройке.Иначе он получит штраф за каждый лишний абзац.';
$string['maxparagraphlimit'] = 'Максимальное количество абзацев';
$string['maxparagraphlimit_desc'] = 'Примечание: В этой записи можно использовать <strong>не более {$a} абзацев.</strong>';
$string['maxparagraphlimit_help'] = 'Если введено число, пользователь должен использовать меньше абзацев, чем указано в данной настройке.';
$string['maxpossrating'] = 'Максимально возможный рейтинг для этой записи составляет {$a} баллов.';
$string['maxsentence'] = 'Максимальное количество предложений';
$string['maxsentence_help'] = 'Если введено число больше нуля, то пользователь должен использовать меньшее количество предложений, чем указано в данной настройке. Иначе он получит штраф за каждое лишнее предложение.';
$string['maxsentencelimit'] = 'Максимальное количество предложений';
$string['maxsentencelimit_desc'] = 'Примечание: В этой записи можно использовать <strong>не более {$a} предложений.</strong>';
$string['maxsentencelimit_help'] = 'Если введено число, пользователь должен использовать меньше предложений, чем указано в данной настройке.';
$string['maxword'] = 'Максимальное количество слов';
$string['maxword_help'] = 'Если введено число больше нуля, то пользователь должен использовать меньшее количество слов, чем указано в данной настройке.Иначе он получит штраф за каждое лишнее слово.';
$string['maxwordlimit'] = 'Максимальное количество слов';
$string['maxwordlimit_desc'] = 'Примечание: В этой записи можно использовать <strong>не более {$a} слов.</strong>';
$string['maxwordlimit_help'] = 'Если введено число, пользователь должен использовать меньше слов, чем указано в данной настройке.';
$string['mediumwords'] = 'Уникальные средние слова';
$string['mediumwords_help'] = 'Средние слова – это слова, состоящие из двух слогов. Обратите внимание, что алгоритм определения количества слогов дает только приблизительные результаты.';
$string['min'] = 'мин.';
$string['minc'] = 'Мин.:';
$string['minchar'] = 'Минимальное количество символов';
$string['minchar_help'] = 'Если введено число больше нуля, то пользователь должен использовать большее количество символов, чем указано в данной настройке.Иначе он получит штраф за каждый из недостающих символов.';
$string['mincharacterlimit'] = 'Минимальное количество символов';
$string['mincharacterlimit_desc'] = 'Примечание: В этой записи нужно использовать <strong>не менее {$a} символов.</strong>';
$string['mincharacterlimit_help'] = 'Если введено число, пользователь должен использовать больше символов, чем указано в данной настройке.';
$string['minmaxcharpercent'] = 'Штраф за каждую ошибку, связанную с нарушением ограничений на мин./макс. число символов';
$string['minmaxcharpercent_help'] = 'Выберите процент от общей оценки, который будет вычитаться за каждую ошибку, связанную с нарушением ограничений на мин./макс. число символов.';
$string['minmaxhdr'] = 'Установки Мин/Макс';
$string['minmaxhdr_help'] = 'Эти настройки определяют значения по умолчанию для минимального и максимального количества символов и слов во всех новых дневниках.';
$string['minmaxparagraphpercent'] = 'Штраф за каждую ошибку, связанную с нарушением ограничений на мин./макс. число абзацев';
$string['minmaxparagraphpercent_help'] = 'Выберите процент от общей оценки, который будет вычитаться за каждую ошибку, связанную с нарушением ограничений на мин./макс. число абзацев.';
$string['minmaxparapercent'] = 'Штраф за каждую ошибку, связанную с нарушением ограничений на мин./макс. число абзацев';
$string['minmaxparapercent_help'] = 'Выберите процент от общей оценки, который будет вычитаться за каждую ошибку, связанную с нарушением ограничений на мин./макс. число абзацев.';
$string['minmaxpercent'] = 'Штраф за каждую ошибку, связанную с нарушением установок мин./макс.';
$string['minmaxpercent_help'] = 'Выберите процент от общей оценки, который будет вычитаться за каждую ошибку, связанную с нарушением установок мин./макс.';
$string['minmaxsentencepercent'] = 'Штраф за каждую ошибку, связанную с нарушением ограничений на мин./макс. число предложений';
$string['minmaxsentencepercent_help'] = 'Выберите процент от общей оценки, который будет вычитаться за каждую ошибку, связанную с нарушением ограничений на мин./макс. число предложений.';
$string['minmaxsentpercent'] = 'Штраф за каждую ошибку, связанную с нарушением ограничений на мин./макс. число предложений';
$string['minmaxsentpercent_help'] = 'Выберите процент от общей оценки, который будет вычитаться за каждую ошибку, связанную с нарушением ограничений на мин./макс. число предложений.';
$string['minmaxwordpercent'] = 'Штраф за каждую ошибку, связанную с нарушением ограничений на мин./макс. число слов';
$string['minmaxwordpercent_help'] = 'Выберите процент от общей оценки, который будет вычитаться за каждую ошибку, связанную с нарушением ограничений на мин./макс. число слов.';
$string['minparagraph'] = 'Минимальное количество абзацев';
$string['minparagraph_help'] = 'Если введено число больше нуля, пользователь должен использовать больше абзацев, чем указано в данной настройке. Иначе он получит штраф за каждый недостающий абзац.';
$string['minparagraphlimit'] = 'Минимальное количество абзацев';
$string['minparagraphlimit_desc'] = 'Примечание: В этой записи должно быть <strong> не менее {$a} абзацев.</strong>';
$string['minparagraphlimit_help'] = 'Если введено число, пользователь должен использовать больше абзацев, чем указано в данной настройке.';
$string['minsentence'] = 'Минимальное количество предложений';
$string['minsentence_help'] = 'Если введено число, большее нуля, пользователь должен использовать больше предложений, чем указано в данной настройке, или он получит штраф за каждое недостающее предложение.';
$string['minsentencelimit'] = 'Минимальное количество предложений';
$string['minsentencelimit_desc'] = 'Примечание: В этой записи должно быть <strong> не менее {$a} предложений.</strong>';
$string['minsentencelimit_help'] = 'Если введено число, пользователь должен использовать больше предложений, чем указано в данной настройке.';
$string['minword'] = 'Минимальное количество слов';
$string['minword_help'] = 'Если введено число больше нуля, пользователь должен использовать больше слов, чем указано в данной настройке. Иначе он получит штраф за каждое недостающее слово.';
$string['minwordlimit'] = 'Минимальное количество слов';
$string['minwordlimit_desc'] = 'Примечание: В этой записи должно быть <strong> не менее {$a} слов.</strong>';
$string['minwordlimit_help'] = 'Если введено число, пользователь должен использовать больше слов, чем указано в данной настройке.';
$string['missing'] = 'Отсутствует';
$string['modulename'] = 'Дневник';
$string['modulename_help'] = 'Дневник позволяет учителям получать обратную связь от учеников в течение определенного периода времени.';
$string['modulenameplural'] = 'Дневники';
$string['needsgrading'] = 'Эта запись еще не получила отзывов и оценок.';
$string['needsregrade'] = 'Эта запись была изменена с момента получения отзыва или оценки.';
$string['newdiaryentries'] = 'Новые записи дневника';
$string['nextentry'] = 'Следующая запись';
$string['nodeadline'] = 'Всегда открыт';
$string['noentriesmanagers'] = 'Нет учителей';
$string['noentry'] = 'Нет записей.';
$string['noratinggiven'] = 'Нет рейтинга';
$string['notextdetected'] = '<b>Текст не обнаружен!</b>';
$string['notopenuntil'] = 'Этот дневник будет недоступен до';
$string['notstarted'] = 'Вы еще не начали вести этот дневник';
$string['numwordscln'] = '{$a->one} чисто текстовых слов с использованием {$a->two} символов, НЕ включая {$a->three} пробелов.';
$string['numwordsnew'] = 'Новый расчет: {$a->one} сырых текстовых слов с использованием {$a->two} символов в {$a->three} предложениях в {$a->four} абзацах.';
$string['numwordsraw'] = '{$a->one} сырых текстовых слов с использованием {$a->two} символов, включая {$a->three} пробелов.';
$string['numwordsstd'] = '{$a->one} стандартизированных слов с использованием {$a->two} символов , включая {$a->three} пробелов.';
$string['outof'] = 'из {$a} записей';
$string['overallrating'] = 'Общий рейтинг';
$string['pagesize'] = 'Записей на страницу';
$string['paragraphs'] = 'Абзацев:';
$string['percentofentryrating'] = '{$a}% от оценки';
$string['phrasecasesensitiveno'] = 'Сравнивать без учета регистра.';
$string['phrasecasesensitiveyes'] = 'Сравнивать с учетом регистра.';
$string['phrasefullmatchno'] = 'Сравнивать слова полностью или частично.';
$string['phrasefullmatchyes'] = 'Сравнивать только целые слова.';
$string['phraseignorebreaksno'] = 'Распознавать разрывы строк.';
$string['phraseignorebreaksyes'] = 'Игнорировать разрывы строк';
$string['pluginadministration'] = 'Администрирование модуля дневника';
$string['pluginname'] = 'Дневник';
$string['popoverhelp'] = 'нажмите для информации';
$string['potautoratingerrpen'] = 'Возможный штраф за ошибку в Авторейтинге: {$a->one}% или {$a->two} баллов.';
$string['potcommerrpen'] = 'Потенциальный штраф за совершение распространенной ошибки: {$a->one} * {$a->two} = {$a->three}% или {$a->four} баллов.';
$string['present'] = 'Текущая';
$string['previousentry'] = 'Предыдущая запись';
$string['privacy:metadata:diary_entries'] = 'Запись в дневнике.';
$string['privacy:metadata:diary_entries:diary'] = 'ID дневника, в котором была опубликована запись.';
$string['privacy:metadata:diary_entries:entrycomment'] = 'Отзыв учителя и, возможно, авторейтинг';
$string['privacy:metadata:diary_entries:mailed'] = 'Этому пользователю уже отправили электронное письмо?';
$string['privacy:metadata:diary_entries:promptdatestart'] = 'Дата начала использования автоматической подсказки';
$string['privacy:metadata:diary_entries:promptdatestop'] = 'Дата окончания использования автоматической подсказки';
$string['privacy:metadata:diary_entries:promptid'] = 'ID автоматической подсказки, используемой для авторейтинга и отзыва.';
$string['privacy:metadata:diary_entries:prompttext'] = 'Текст подсказки, используемой для авторейтинга и отзыва.';
$string['privacy:metadata:diary_entries:rating'] = 'Числовая оценка за эту запись в дневнике. Может быть определена с помощью шкал / продвинутых форм оценивания и т.д., но всегда будет преобразована обратно в число с плавающей запятой.';
$string['privacy:metadata:diary_entries:teacher'] = 'ID пользователя, который оценивает запись.';
$string['privacy:metadata:diary_entries:text'] = 'Содержание записи';
$string['privacy:metadata:diary_entries:timecreated'] = 'Время создания записи.';
$string['privacy:metadata:diary_entries:timemarked'] = 'Время оценки записи.';
$string['privacy:metadata:diary_entries:timemodified'] = 'Время последнего изменения записи.';
$string['privacy:metadata:diary_entries:userid'] = 'ID пользователя.';
$string['prompt'] = 'Введите подсказку';
$string['promptbgc'] = 'Цвет фона для этой подсказки';
$string['promptbgc_help'] = 'Общий цвет фона для данной подсказки.';
$string['promptid'] = 'ID подсказки';
$string['promptinfo'] = 'Для этого Дневника имеются  ранее показанные подсказки - {$a->past} , текущие - {$a->current} и запланированные на будущее - {$a->future}.<br>';
$string['promptmaxc'] = 'Макс.симв.';
$string['promptmaxp'] = 'Макс.абз.';
$string['promptmaxs'] = 'Макс.предл.';
$string['promptmaxw'] = 'Макс.слов';
$string['promptminc'] = 'Мин.симв.';
$string['promptminmaxcp'] = '% симв.';
$string['promptminmaxpp'] = '% абз.';
$string['promptminmaxsp'] = '% предл.';
$string['promptminmaxwp'] = '% слов';
$string['promptminp'] = 'Мин.абз.';
$string['promptmins'] = 'Мин.предл.';
$string['promptminw'] = 'Мин.слов';
$string['promptremovefailure'] = 'Эта подсказка (ID {$a}) используется, ее нельзя удалить.';
$string['promptremovesuccess'] = 'Вы удалили подсказку с ID {$a}.';
$string['promptstart'] = 'Начало';
$string['promptstitle'] = 'Подсказки к написанию дневника';
$string['promptstop'] = 'Окончание';
$string['promptsviewtitle'] = 'Просмотр подсказок';
$string['prompttext'] = 'Текст подсказки';
$string['promptzerocount'] = '<td>В данном дневнике есть {$a} подсказок.</td>';
$string['rate'] = 'Оценить';
$string['rating'] = 'Оценить данную запись';
$string['reload'] = 'Обновить и показать от текущей до самой старой записи дневника';
$string['removealldiarytags'] = 'Удалить все теги из Дневника';
$string['removeentries'] = 'Удалить все записи';
$string['removemessages'] = 'Удалить все записи дневника';
$string['reportsingle'] = 'Получить все записи данного пользователя дневника';
$string['reportsingleallentries'] = 'Все записи данного пользователя дневника';
$string['returnto'] = 'Вернуться к {$a}';
$string['returntoreport'] = 'Вернуться на страницу отчета по {$a}';
$string['saveallfeedback'] = 'Сохранить все мои отзывы';
$string['savesettings'] = 'Сохранить настройки';
$string['search'] = 'Найти';
$string['search:activity'] = 'Дневник - информация о модуле';
$string['search:entry'] = 'Дневник - записи';
$string['search:entrycomment'] = 'Дневник - комментарий к записи';
$string['selectentry'] = 'Выберите запись для оценивания';
$string['sentences'] = 'Предложений:';
$string['sentencesperparagraph'] = 'Предложений в абзаце';
$string['shortwords'] = 'Уникальных коротких слов';
$string['shortwords_help'] = 'Короткие слова - это слова, состоящие только из одного слога. Обратите внимание, что алгоритм определения количества слогов дает лишь приблизительные результаты.';
$string['showlistno'] = 'Скрыть';
$string['showlistpreference'] = 'Показать пользователей без записей';
$string['showlistyes'] = 'Показать';
$string['shownone'] = 'Не показывать';
$string['showoverview'] = 'Показать обзор дневников в личном кабинете';
$string['showrecentactivity'] = 'Показать недавнюю активность';
$string['showstudentsonly'] = 'Показывать только студентам';
$string['showteacherandstudents'] = 'Показывать учителям и студентам';
$string['showteachersonly'] = 'Показывать только учителям';
$string['showtextstats'] = 'Показывать статистику по тексту?';
$string['showtextstats_help'] = 'Если эта опция включена, то будет отображаться статистика по тексту.';
$string['showtostudentsonly'] = 'Да, показывать только студентам';
$string['showtoteachersandstudents'] = 'Да, показывать учителям и студентам';
$string['showtoteachersonly'] = 'Да, показывать только учителям';
$string['sortcurrententry'] = 'От текущей записи в дневнике к первой записи.';
$string['sortfirstentry'] = 'От первой записи в дневнике к последней записи.';
$string['sorthighestentry'] = 'От записи дневника с самым высоким рейтингом к записи с самым низким рейтингом.';
$string['sortlastentry'] = 'От последней измененной записи дневника к самой старой измененной записи.';
$string['sortlowestentry'] = 'От записи дневника с самым низким рейтингом к записи с наивысшим рейтингом.';
$string['sortoptions'] = 'Настройки сортировки:';
$string['sortorder'] = 'Порядок сортировки:';
$string['startnewentry'] = 'Создать новую запись';
$string['startoredit'] = 'Создать новую или отредактировать сегодняшнюю запись';
$string['statshdr'] = 'Статистика по тексту';
$string['statshdr_help'] = 'Эти настройки определяют значения по умолчанию для статистики во всех новых дневниках.';
$string['statshide'] = 'Скрыть статистику';
$string['statsshow'] = 'Показать статистику';
$string['studentemail'] = 'Отправка уведомлений студентам по электронной почте';
$string['studentemail_help'] = 'Включите или отключите возможность немедленной отправки студентам уведомлений по электронной почте.';
$string['tablecolumncharacters'] = 'Символов';
$string['tablecolumnedit'] = 'Править&nbsp;&nbsp;&nbsp;&nbsp;';
$string['tablecolumnparagraphs'] = 'Абзацев';
$string['tablecolumnprompts'] = 'Подсказок';
$string['tablecolumnpromptsbgc'] = 'Фон подсказки';
$string['tablecolumnsentences'] = 'Предложений';
$string['tablecolumnstart'] = 'Начало';
$string['tablecolumnstatus'] = 'Статус';
$string['tablecolumnstop'] = 'Стоп';
$string['tablecolumnwords'] = 'Слов&nbsp;&nbsp;&nbsp;&nbsp;';
$string['tagarea_diary_entries'] = 'Записей дневника';
$string['tcount'] = 'В настоящее время для этого Дневника имеется всего подсказок -  {$a}.<br>';
$string['teacher'] = 'Учитель';
$string['teacheremail'] = 'Отправить учителям уведомления по электронной почте';
$string['teacheremail_help'] = 'Включите или отключите возможность немедленной отправки учителям уведомлений по электронной почте.';
$string['text'] = 'Текст';
$string['text_editor'] = 'Текст подсказки';
$string['textstatitems'] = 'Элементы статистики';
$string['textstatitems_help'] = 'Выберите здесь любые элементы, которые вы хотите отобразить в текстовой статистике, отображаемой на странице просмотра, странице отчета и странице отдельного отчета.';
$string['timecreated'] = 'Время создания';
$string['timemarked'] = 'Время оценивания';
$string['timemodified'] = 'Время изменения';
$string['toolbar'] = 'Панель управления';
$string['totalsyllables'] = 'Общее количество слогов {$a}';
$string['transfer'] = 'Перенести записи';
$string['transferwemail'] = 'Перенести и отправить электронное письмо. <b>По умолчанию: Не отправлять электронное письмо</b>';
$string['transferwfb'] = 'Перенести и включить отзыв о переносе. <b>По умолчанию: Не включать отзыв</b>';
$string['transferwfbmsg'] = 'Эта запись была перенесена из журнала с названием: {$a}';
$string['transferwoe'] = 'Перенос без электронной почты';
$string['uniquewords'] = 'Уникальных слов';
$string['userid'] = 'ID пользователя';
$string['usertoolbar'] = 'Панель управления:';
$string['viewalldiaries'] = 'Просмотреть все дневники курса';
$string['viewallentries'] = 'Просмотр записей дневника ({$a})';
$string['viewentries'] = 'Просмотр записей';
$string['warning'] = '<b>ВНИМАНИЕ - у вас есть {$a} текущих подсказок, что является ошибкой. У вас не может быть нескольких перекрывающихся текущих дат! Это необходимо исправить!</b><br>';
$string['words'] = 'Слов:';
$string['wordspersentence'] = 'Слов в предложении';
$string['writingpromptlable'] = 'Текущая подсказка: {$a->counter} (ID: {$a->entryid}), ее отображение началось {$a->starton} и завершится {$a->endon}.<br>{$a->datatext}';
$string['writingpromptlable2'] = 'Подсказка:';
$string['writingpromptlable3'] = 'Редактор подсказок для написания дневника';
$string['writingpromptnotused'] = 'Для настройки процентов авторейтинга этой записи были использованы стандартные настройки дневника.';
$string['writingpromptused'] = 'Для настройки процентов авторейтинга данной записи использована подсказка с ID {$a}';
$string['xfrresults'] = 'Обработано записей - {$a->one}, из них перенесено - {$a->two}.';
