<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'block_xp', language 'ru', version '5.1'.
 *
 * @package     block_xp
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['actions'] = 'Действие';
$string['activityoresourceis'] = 'Элемент курса или ресурс {$a}';
$string['addacondition'] = 'Добавить условие';
$string['addarule'] = 'Добавить правило';
$string['addinstructions'] = 'Добавить информацию';
$string['additionalresources'] = 'Дополнительные ресурсы';
$string['addlevel'] = 'Добавить уровень';
$string['addondeactivated'] = 'XP+ неактивен';
$string['addoninstallationerror'] = 'Мы обнаружили проблему с дополнением (local_xp). Похоже, оно установлено неправильно. Администратор должен завершить его установку.';
$string['addonnotactivated'] = 'Дополнение не было активировано';
$string['addrulesformhelp'] = 'Последняя колонка определяет количество баллов опыта, начисляемое при выполнении критерия';
$string['admindefaultrulesintro'] = 'Следующие правила будут использоваться по умолчанию для курсов, в которые добавлен блок.';
$string['admindefaultsettingsintro'] = 'Приведенные ниже настройки будут использоваться по умолчанию, когда блок будет добавлен в курс.';
$string['admindefaultvisualsintro'] = 'Следующее будет использоваться по умолчанию, когда блок будет добавлен в курс.';
$string['adminnotices'] = 'Уведомления администратора';
$string['adminnotices_desc'] = 'Если эта функция включена, администраторы сайта могут время от времени получать важные уведомления относительно совместимости, безопасности и доступности новых версий плагина «Опыт!‎».';
$string['adminscanearnxp'] = 'Администраторы могут зарабатывать баллы';
$string['adminscanearnxp_desc'] = 'По умолчанию администраторы не включены в группу пользователей, которые могут зарабатывать баллы. Это сделано из-за того, что у администраторов всегда есть право _block/xp:earnxp_, позволяющее им постоянно зарабатывать баллы на страницах системы. Используйте эту настройку, чтобы дать администраторам возможность тоже зарабатывать баллы.';
$string['allcoursesreset'] = 'Все курсы были сброшены';
$string['anonymity'] = 'Анонимность';
$string['anonymity_help'] = 'Здесь можно установить, видят ли участники имена и аватарки друг друга';
$string['apply'] = 'Применить';
$string['awardaxpwhen'] = '<strong>{$a}</strong> баллов опыта начислятся при:';
$string['badgeaward'] = 'Значок';
$string['badgeawarddesc'] = 'Значок, который получает пользователь за достижение уровня.';
$string['basepoints'] = 'Базовые баллы';
$string['basepointslineardesc'] = 'Минимальный шаг между каждым уровнем.';
$string['basepointsrelativedesc'] = 'Количество баллов, с которого начинается уровень.';
$string['basexp'] = 'Основание алгоритма';
$string['blockappearance'] = 'Скрыть';
$string['cachedef_filters'] = 'Фильтры уровня';
$string['cachedef_metadata'] = 'Метаданные';
$string['cachedef_ruleevent_eventslist'] = 'Список некоторых событий';
$string['cannotbesetindefaults'] = 'Не может быть установлен в значениях по умолчанию.';
$string['cannotshowblockconfig'] = 'Обычно настройки внешнего вида показываются здесь, но не получается найти ваш блок. Чтобы изменить внешний вид блока, вернитесь назад [здесь] ({$a}) (или туда, где вы добавили блок), включите режим редактирования и используйте опции "Настройки" в раскрывающемся списке блока. Если вы не можете найти блок, добавьте его в свой курс снова.';
$string['cannotshowblockconfigsys'] = 'Обычно настройки внешнего вида показываются здесь, но не получается найти ваш блок. Он может отсутствовать на [главной странице] ({$a->fp}) и [панели управления по умолчанию] ({$a->mysys}) ваших пользователей или присутствовать в обоих местах. Измените здесь настройки, убедившись, что блок отображается только в одном из них.';
$string['changecourse'] = 'Изменить курс';
$string['changelevelformhelp'] = 'Если вы измените количество уровней, настроенные значки будут временно отключены, чтобы предотвратить использование уровней без значков. В этом случае после сохранения этой формы перейдите на страницу «Внешний вид», чтобы снова включить использования собственных значков.';
$string['cheatguard'] = 'Защита от мошенничества';
$string['chooseacondition'] = 'Выберите условие';
$string['clearfilter'] = 'Очистить фильтр';
$string['clicktoselectcm'] = 'Нажмите для выбора активного элемента или ресурса';
$string['cmselector'] = 'Селектор модуля курса';
$string['coefxp'] = 'Коэффициент алгоритма';
$string['colon'] = '{$a->a}: {$a->b}';
$string['comparisonmethod'] = 'Метод сравнения';
$string['compatibilitycheck'] = 'Проверка совместимости';
$string['completionrules'] = 'Правила завершения';
$string['condition'] = 'Условие';
$string['configblockrankingsnapshot'] = 'Отобразить снимок таблицы лидеров';
$string['configblockrankingsnapshot_help'] = 'Снимок таблицы лидеров отображает позицию пользователя в рейтинге. Снимок также может отобразить по одному пользователю сверху и снизу позиции текущего пользователя. Эта функция требует, чтобы была включена таблица лидеров и отображался рейтинг пользователей.';
$string['configdescription'] = 'Добавлять описание';
$string['configdescription_help'] = 'Краткое введение отображается в блоке студентам. У студентов есть возможность отключить сообщение, и в этом случае они не увидят его снова.';
$string['configheader'] = 'Настройки';
$string['configrecentactivity'] = 'Показать последние поощрения';
$string['configrecentactivity_help'] = 'При включении в блоке будет отображаться краткий список последних событий, в которых студент поощряется баллами.';
$string['configtitle'] = 'Название';
$string['configtitle_help'] = 'Заголовок блока';
$string['congratulationsyouleveledup'] = 'Поздравляем!';
$string['coolthanks'] = 'Клево, спасибо!';
$string['coursea'] = 'Курс «{$a}»';
$string['courselog'] = 'Журнал курса';
$string['courselogintro'] = 'В журнале отображаются зафиксированные действия и количество начисленных за них баллов.';
$string['coursereport'] = 'Отчет по курсу';
$string['coursereportintro'] = 'Отчет содержит подробную информацию о каждом участнике, что позволяет принимать меры в отношении каждого из них индивидуально или в целом.';
$string['courserules'] = 'Правила курса';
$string['courseselectedcolon'] = 'Выбранные курсы';
$string['coursesettings'] = 'Настройки курса';
$string['coursevisuals'] = 'Внешний вид курса';
$string['currencysign'] = 'Обозначение баллов';
$string['currencysign_help'] = 'В этой настройке вы можете изменить обозначение баллов. Оно будет отображаться рядом с количеством баллов каждого пользователя как замена для выражения _experience points_ (рус.: баллы опыта).

Выберите одно из представленных обозначений или загрузите свое собственное!';
$string['currencysignxp'] = 'XP (баллы опыта)';
$string['customizelevels'] = 'Настроить уровни';
$string['dangerzone'] = 'Опасная зона';
$string['dataformat'] = 'Формат';
$string['defaultlevels'] = 'Уровень по умолчанию';
$string['defaultrules'] = 'Правила по умолчанию';
$string['defaultrulesformhelp'] = 'Это правила, предоставляемые плагином по умолчанию. Они автоматически дают баллы опыта, игнорируя некоторые излишние события. Ваши собственные правила будут иметь приоритет перед правилами по умолчанию.';
$string['defaultsettings'] = 'Настройки по умолчанию';
$string['defaultvisuals'] = 'Визуальные элементы по умолчанию';
$string['deletecondition'] = 'Удалить условие';
$string['deleterule'] = 'Удалить правило';
$string['description'] = 'Описание';
$string['difference'] = 'Разн.';
$string['difficulty'] = 'Метод расчета баллов';
$string['difficultyflat'] = 'Равный';
$string['difficultyflatdesc'] = 'Для достижения всех уровней требуется одинаковое количество баллов.';
$string['difficultylinear'] = 'Возрастающий';
$string['difficultylineardesc'] = 'Для достижения уровней постепенно требуется больше баллов.';
$string['difficultylinearincrdesc'] = 'Количество баллов, используемых для повышения сложности.';
$string['difficultypointincrease'] = 'Возрастание баллов';
$string['difficultyrelative'] = 'Лавинообразный';
$string['difficultyrelativedesc'] = 'Достигать уровней становится экспоненциально сложнее.';
$string['difficultyrelativeincrdesc'] = 'Процент, на который увеличиваются баллы предыдущего уровня.';
$string['discoverlevelupplus'] = 'Откройте Следующий уровень! Плюс';
$string['dismissnotice'] = 'Отклонить уведомление';
$string['displayeveryone'] = 'Показать всех';
$string['displaynneighbours'] = 'Показать {$a} соседних (по рангу) участников';
$string['displayoneneigbour'] = 'Показать одного соседнего (по рангу) участника';
$string['displayparticipantsidentity'] = 'Показывать фамилии участников';
$string['displayrank'] = 'Отображать ранги';
$string['displayrelativerank'] = 'Отображать относительные ранги';
$string['documentation'] = 'Документация';
$string['editingdefaultsettingsinwholesitemodenotice'] = '**Внимание!** Вы не изменяете текущие активные настройки, а редактируете значения по умолчанию. Поскольку блок «Опыт!» используется на всем сайте, вы, скорее всего, измените настройки на всем сайте. [Перейдите сюда]({$a->url}), чтобы изменить эти настройки, или перейдите по ссылке «Настройки» в самом блоке.';
$string['editinstructions'] = 'Редактировать';
$string['enablecheatguard'] = 'Включить защиту от мошенничества';
$string['enablecheatguard_help'] = 'Система защиты от мошенничества предлагает простой механизм, предотвращающий злоупотребление студентами использование очевидных приемов, таких как многократное обновление одной и той же страницы или постоянное повторение одного и того же действия.';
$string['enableinfos'] = 'Включить страницу «Информация»';
$string['enableinfos_help'] = 'Если задано «Нет», то студенты не смогут посмотреть страницу «Информация».';
$string['enableladder'] = 'Включить таблицу результатов';
$string['enableladder_help'] = 'Если задано «Нет», то студенты не смогут посмотреть таблицу результатов.';
$string['enablelevelupnotif'] = 'Включить уведомления о повышении уровня';
$string['enablelevelupnotif_help'] = 'Если выбрано значение «Да», студентам отобразится всплывающее окошко с поздравлениями при достижении нового уровня.';
$string['enablelogging'] = 'Включить ведение журнала';
$string['enablexpgain'] = 'Включить получение баллов за опыт';
$string['enablexpgain_help'] = 'Если задано «Нет», то никто в курсе не будет зарабатывать очки за опыт. Это полезно, чтобы зафиксировать накопленный опыт, или включить параметр в определенный момент времени.
Пожалуйста, обратите внимание, что этот параметр также может настраиваться более тонко с использованием возможности «block/xp:earnxp»';
$string['entersearchterm'] = 'Введите поисковый запрос';
$string['errorcontextcoursemismatchforwholesite'] = 'URL этой страницы <em>Следующий уровень!</em> не соответствует текущей конфигурации плагина. В текущей конфигурации страница<em>Следующий уровень!</em> будет использоваться "для всего сайта", однако предполагалось, что она будет использоваться "в курсе". Пожалуйста, <a href="{$a->nexturl}">нажмите здесь</a>, чтобы перейти на нужную страницу. Если вы хотите изменить конфигурацию, найдите настройки "block_xp_context".';
$string['errorcontextcoursemismatchpercourse'] = 'URL страницы <em>Следующий уровень!</em> не соответствует текущей конфигурации плагина. Ваша текущая конфигурация <em>Следующий уровень!</em> предполагает использование "для всего сайта". Скорее всего, URL записан в <em>блоке</em>, который был добавлен на панель управления или главную страницу, находясь в другом сайте. Вы должны удалить блок из указанных страниц и использовать его только в рамках конкретных курсов.';
$string['errorformvalues'] = 'Есть некоторые проблемы в значениях формы. Исправьте их.';
$string['errorlevelsincorrect'] = 'Минимальное число уровней — 2';
$string['errornotalllevelsbadgesprovided'] = 'Предоставлены значки не для всех уровней. Пропущены: {$a}';
$string['errorunknownevent'] = 'Ошибка: неизвестное событие';
$string['errorunknownmodule'] = 'Ошибка: неизвестный модуль';
$string['errorxprequiredlowerthanpreviouslevel'] = 'Требуемые баллы за опыт меньше или равны предыдущему уровню.';
$string['event_user_leveledup'] = 'Уровень пользователя повышен';
$string['eventis'] = 'Событие «{$a}»';
$string['eventname'] = 'Название события';
$string['eventproperty'] = 'Свойство события';
$string['eventsrules'] = 'Правила событий';
$string['eventsrules_help'] = 'Этот плагин используется для событий, при которых присваиваются баллы действиям, выполняемым учащимися.
Вы можете использовать форму ниже, чтобы добавить свои собственные правила и изменить стандартные.
Этот плагин использует события для присвоения баллов действиям, выполняемым учащимися.
 Вы можете использовать форму ниже, чтобы добавить свои собственные правила и изменить стандартные.

 Рекомендуется проверить страницу плагина _Log_, чтобы определить, какие события запускаются, когда студенты выполняют действия в курсе.

Дополнительные возможности:
- [Как рассчитываются очки опыта?]
(https://levelup.branchup.tech/docs/article/how-are-experience-points-calculated)
- [Правила устранения неполадок]
(https://levelup.branchup.tech/docs/article/event-rule-not-working)';
$string['eventsrulesintro'] = 'Отслеживайте события и начисляйте студентам баллы за их выполнение.';
$string['eventtime'] = 'Время события';
$string['filterbyuser'] = 'Фильтр по пользователю';
$string['filtermodules'] = 'Фильтр модулей';
$string['for1day'] = 'На 1 день';
$string['for1month'] = 'На месяц';
$string['for1week'] = 'На неделю';
$string['for3days'] = 'На 3 дня';
$string['forever'] = 'Навсегда';
$string['forthewholesite'] = 'Для всего сайта';
$string['give'] = 'дает';
$string['gotofullladder'] = 'Перейти к полному списку';
$string['hasnobadgeaward'] = 'Нет значка';
$string['hasnodescription'] = 'Нет описания';
$string['hasnoname'] = 'Нет названия';
$string['hasnopopupmessage'] = 'Нет всплывающего сообщения';
$string['hideparticipantsidentity'] = 'Скрывать фамилии участников';
$string['hiderank'] = 'Скрывать ранги';
$string['incourses'] = 'В курсах';
$string['ineffective'] = 'Неэффективный';
$string['infos'] = 'Информация';
$string['installed'] = 'Установлен';
$string['instructions'] = 'Подробная информация';
$string['invalidxp'] = 'Неверное значение баллов за опыт';
$string['keeplogs'] = 'Сохранить записи журнала';
$string['ladder'] = 'Таблица результатов';
$string['ladderadditionalcols'] = 'Добавочные столбцы';
$string['ladderadditionalcols_help'] = 'Этот параметр определяет, какие дополнительные столбцы будут отображаться на "лестнице". Нажмите клавишу CTRL или CMD во время щелчка, чтобы выбрать несколько столбцов или отменить выбор выбранного столбца.';
$string['ladderempty'] = 'Лестница в настоящее время пуста, не забудьте вернуться позже.';
$string['learnmore'] = 'Узнать больше';
$string['level'] = 'Уровень';
$string['levelbadges'] = 'Значки уровней';
$string['levelbadges_help'] = 'Загрузите изображения, чтобы заменить внешний вид отдельных уровней.

Файлы должны называться [уровень].[расширение файла], например 1.png, 2.jpg и т. д.

Рекомендуется использовать изображения размером 100x100 пикселей в любом из следующих форматов: GIF, JPEG, PNG и SVG.';
$string['levelbadgesformhelp'] = 'Называйте файлы по принципу [уровень].[расширение файла], например: 1.png, 2.jpg, и т.д. Рекомендуемый размер изображения: 100x100.';
$string['levelcount'] = 'Количество уровней';
$string['leveldesc'] = 'Описание уровня';
$string['leveldesc_help'] = 'Краткое описание уровня, это отображается на информационной странице рядом с самим уровнем. Вы можете использовать это для описания награды для учеников, которые достигают этого уровня, чтобы включить инструкции о том, как работать на этом уровне, чтобы описать уровень в игровой форме (например, "только самые настойчивые достигают этого уровня") и т. п.';
$string['leveldescriptiondesc'] = 'Краткое описание уровня, отображаемое студентам на информационной странице.';
$string['levelname'] = 'Название уровня';
$string['levelname_help'] = 'Краткое название для отображения вместо стандартных _Уровень #1_, _Уровень #2_ и т. д. Если вы даете названия некоторым уровням, то рекомендуем переименовать каждый из них!';
$string['levelpointslength'] = 'Продолжительность';
$string['levelpointsstart'] = 'Начало';
$string['levels'] = 'Уровни';
$string['levelsappearance'] = 'Внешний вид уровней';
$string['levelssaved'] = 'Уровни сохранены.';
$string['levelswillbereset'] = 'Внимание! Сохранение этой формы пересчитает уровни всех!';
$string['levelup'] = 'Опыт!';
$string['levelupoptionsunavailableforlevelone'] = 'Опции, связанные с достижением уровня, недоступны для первого уровня.';
$string['levelupplus'] = 'Уровень повышен! Плюс';
$string['levelx'] = 'Уровень № {$a}';
$string['likenotice'] = '<strong>Вам понравился этот плагин?</strong> Пожалуйста, найдите минутку, чтобы <a href="{$a->moodleorg}" target="_blank">добавить его в закладки</a> на Moodle.org или <a href="{$a->github}" target="_blank">проголосовать на GitHub</a>.';
$string['limitparticipants'] = 'Ограничения просмотра';
$string['limitparticipants_help'] = 'Здесь можно настроить, кто будет отображаться в рейтинговой таблице. Соседние (по рангу) участники - это участники, ранг которых выше и ниже, чем у текущего пользователя. Например, при выборе "Показывать двух соседних (по рангу) участников", будут показаны только двое участников, чей ранг непосредственно выше и ниже, чем у текущего пользователя';
$string['list'] = 'Список';
$string['logging'] = 'Ведение журнала';
$string['manually'] = 'Вручную';
$string['maxactionspertime'] = 'Максимальное количество действий за промежуток времени';
$string['maxactionspertime_help'] = 'Максимальное количество действий, которые будут учитываться для данного блока за отведенный промежуток времени. Все последующие действия за указанный период будут проигнорированы.';
$string['maxlevelexcl'] = 'максимальный уровень!';
$string['menu'] = 'Меню';
$string['missing'] = 'Отсутствует';
$string['movecondition'] = 'Переместить условие';
$string['moverule'] = 'Переместить правило';
$string['name'] = 'Название';
$string['navbardisplay'] = 'Отображать в панели навигации пользователя';
$string['navbardisplay_desc'] = 'Когда настройка включена, уровень пользователя будет отображаться в панели навигации пользователя. Если плагин используется для каждого курса в отдельности, уровень будет отображаться только в курсах. Обратите внимание, что этот функционал сильно зависит от темы оформления и может плохо работать или не работать совсем со сторонними темами. [Подробнее](https://docs.levelup.plus/xp/docs/navbar-display)';
$string['naveventrules'] = 'Правила событий';
$string['navimport'] = 'Импорт';
$string['navinfos'] = 'Информация';
$string['navladder'] = 'Таблица результатов';
$string['navlevels'] = 'Уровни';
$string['navlevelssetup'] = 'Настройки';
$string['navlog'] = 'Журнал';
$string['navpoints'] = 'Баллы';
$string['navpromo'] = 'Плюс';
$string['navreport'] = 'Отчет';
$string['navrules'] = 'Правила';
$string['navsettings'] = 'Настройки';
$string['navvisuals'] = 'Внешний вид';
$string['nextlevelin'] = 'следующий уровень через';
$string['nodescription'] = 'Нет описания';
$string['noissuesidentified'] = 'Проблем не обнаружено';
$string['noname'] = 'Нет названия';
$string['notecompatibilityissues'] = 'Пожалуйста, обратите внимание на проблемы с совместимостью, обнаруженные ниже';
$string['numberoflevels'] = 'Количество уровней';
$string['occasionally'] = 'Периодически';
$string['participant'] = 'Участник';
$string['participants'] = 'Участники';
$string['participatetolevelup'] = 'Участвуйте в курсе, чтобы получать баллы опыта и повышать свой уровень!';
$string['perpagecolon'] = 'На каждой странице';
$string['pickaconditiontype'] = 'Выбрать тип условия';
$string['pluginavailabilityxpdesc'] = 'Этот плагин позволяет преподавателям ограничивать доступ к элементам курса в зависимости от уровня слушателей.';
$string['pluginenrolxpdesc'] = 'Этот плагин обеспечивает автоматическое зачисление на курсы на основе уровня студента в другом курсе.';
$string['pluginname'] = 'Опыт!';
$string['pluginshortcodesdesc'] = 'Этот плагин позволяет преподавателям настраивать материалы курса, включая в них элементы, зависящие от опыта (очки, уровень, таблица лидеров, ...), а также скрывать или показывать материалы в зависимости от уровня студента.';
$string['pluginxmaybeincompatible'] = 'Версия {$a->name} ({$a->component}) может быть несовместима с Moodle версии {$a->version}.';
$string['pointsintimelinker'] = 'За единицу';
$string['pointsperlevel'] = 'Баллов за уровень';
$string['pointsrequired'] = 'Необходимые баллы';
$string['popupnotificationmessage'] = 'Всплывающее уведомление';
$string['popupnotificationmessagedesc'] = 'Необязательное сообщение, отображаемое во всплывающем уведомлении, которое поздравляет пользователя с достижением уровня.';
$string['privacy:metadata:log'] = 'Хранилище журнала событий';
$string['privacy:metadata:log:eventname'] = 'Название события';
$string['privacy:metadata:log:time'] = 'Дата проведения';
$string['privacy:metadata:log:userid'] = 'Пользователь, набравший баллы';
$string['privacy:metadata:log:xp'] = 'Баллы, присваиваемые за событие';
$string['privacy:metadata:prefintro'] = 'Записи о том, отклонил ли пользователь вступление блока';
$string['privacy:metadata:prefladderpagesize'] = 'Предпочтительный размер страницы пользователя при просмотре "лестницы"';
$string['privacy:metadata:preflevelup'] = 'Записи о том, должен ли пользователь видеть уведомление о повышении уровня';
$string['privacy:metadata:prefnotices'] = 'Записи о том, закрыл ли пользователь уведомление о поддержке';
$string['privacy:metadata:prefseenpromo'] = 'Записи о том, когда пользователь просматривал рекламную страницу';
$string['privacy:metadata:xp'] = 'Хранилище баллов и уровней пользователей';
$string['privacy:metadata:xp:lvl'] = 'Уровень пользователя';
$string['privacy:metadata:xp:userid'] = 'Пользователь';
$string['privacy:metadata:xp:xp'] = 'Баллы пользователя';
$string['privacy:path:addon'] = 'Надстройка';
$string['privacy:path:level'] = 'Уровень';
$string['privacy:path:logs'] = 'Файлы отчёта';
$string['progress'] = 'Прогресс';
$string['progressbar'] = 'Индикатор выполнения';
$string['promocontactintro'] = 'Свяжитесь с нами, чтобы получить больше информации. Мы не кусаемся и отвечаем быстро!';
$string['promocontactus'] = 'Связаться';
$string['promoemailusat'] = 'Напишите нам по адресу _levelup@branchup.tech_.';
$string['promoerrorsendingemail'] = 'Ой! Мы не смогли отправить сообщение... Пожалуйста, свяжитесь с нами напрямую по адресу: {$a}. Спасибо!';
$string['promogetnow'] = 'Получить XP+!';
$string['promoifpreferemailusat'] = 'Тссс! Если хотите, напишите нам по адресу  _{$a}_.';
$string['promointro'] = 'Надстройка для _Level up!_ с функциями, которые могут побудить учащихся полностью реализовать свой потенциал!';
$string['promorulesdidyouknow'] = 'А вы знали, что с <em>Level up! Plus</em> учащиеся могут получать баллы за <em>завершение курсов</em> и <em>их элементов</em>, или даже получать баллы в соответствии с их <em>оценками</em>? <a href="{$a->url}">Узнайте больше здесь</a>.';
$string['promoyourmessagewassent'] = 'Спасибо, ваше сообщение было отправлено. Мы свяжемся с вами очень скоро.';
$string['property:action'] = 'Действие события';
$string['property:component'] = 'Компонент события';
$string['property:crud'] = 'Тип события (создание, просмотр, обновление, удаление)';
$string['property:eventname'] = 'Название события';
$string['property:target'] = 'Цель события';
$string['provisionstates'] = 'Автоматическая подготовка пользователей';
$string['provisionstates_desc'] = 'По умолчанию пользователи появляются в таблице лидеров (и в отчете в режиме «‎Для всего сайта») только после того, как они были обнаружены по опыту. Подготовка пользователей — это расширенная функция, которая автоматически создает записи для отсутствующих пользователей, приблизительно идентифицированных по их роли. Это делается периодически с помощью запланированной задачи, которая по умолчанию запускается ежедневно. [Подробнее](https://docs.levelup.plus/xp/docs/automatic-user-provisioning)';
$string['questreleasenotice'] = '🎉 Мы рады анонсировать наш **новый плагин геймификации** под названием **Level Up Quest** 🥳. Превратите свои курсы в **захватывающие приключения**, наполненные **стратегиями повторного вовлечения** и **празднованиями** 🤯! Посетите [сайт Quest]({$a->questurl}) и нашу [публикацию здесь]({$a->questblogurl}). 👈';
$string['quickeditpoints'] = 'Быстро изменить баллы';
$string['rank'] = 'Место';
$string['ranking'] = 'Рейтинг';
$string['ranking_help'] = 'Рейтинг - это абсолютная позиция текущего пользователя в "лестнице" достижений. Относительный рейтинг - это разница в очках опыта между соседними пользователями';
$string['reallydeleteuserstate'] = 'Удаление пользователя удобно только для того, чтобы удалить его с цепной схемы. По любым другим причинам мы рекомендуем вместо этого установить их точки равными 0. Обратите внимание, что удаление их не влияет на их способность зарабатывать очки в будущем.

Важно отметить, что при спользовании _Level up!_ для всего сайта их удаление приведет к тому, что они исчезнут из отчета, и в этом случае вы не сможете повторно назначить им баллы. Однако, если вы используете _Level up!_ по каждому курсу студент все еще может появиться в отчете, если он зачислен на курс.

Вы действительно хотите удалить баллы этого пользователя?';
$string['reallydeleteuserstateandlogs'] = 'Удаление пользователя удаляет его из таблицы лидеров и удаляет все связанные с ним журналы.

Удаление журналов может позволить пользователю повторно заработать баллы за предыдущие действия. Если вы намерены только сбросить его баллы, мы рекомендуем вместо этого установить его баллы на 0. Обратите внимание, что удаление пользователя не влияет на его способность зарабатывать баллы в будущем.

Важно отметить, что при использовании _Level Up XP_ для всего сайта удаление приведет к тому, что он исчезнет из отчета, и в этом случае вы не сможете повторно назначить ему баллы. Однако, если вы используете _Level Up XP_ для курса, студент все еще может отображаться в отчете, если он зачислен на курс.

Вы действительно хотите удалить баллы и журналы этого пользователя?';
$string['reallyresetallcoursestodefaults'] = 'Вы действительно хотите сбросить правила всех курсов к правилам по умолчанию? Это действие необратимо.';
$string['reallyresetcourselevelstodefaults'] = 'Вы действительно хотите сбросить уровни курса к уровням по умолчанию? Это действие необратимо.';
$string['reallyresetcourserulestodefaults'] = 'Вы действительно хотите сбросить правила курса к правилам по умолчанию? Это действие является необратимым.';
$string['reallyresetdata'] = 'Действительно сбросить уровни и баллы за опыт для всех участников этого курса?';
$string['reallyresetgroupdata'] = 'Действительно сбросить уровни и баллы опыта для всех в этой группе?';
$string['reallyreverttopluginsdefaults'] = 'Действительно сбросить значения правил по умолчанию до значений, предложенных в плагине? Это действие является необратимым.';
$string['recentrewards'] = 'Последние награды';
$string['recommendedplugins'] = 'Рекомендованные плагины';
$string['removefilter'] = 'Удалить фильтр';
$string['reportisempty'] = 'Отчет пуст, студенты еще не заработали очки';
$string['reportisemptyenrolstudents'] = 'Отчет пуст, записаны ли студенты на курс?';
$string['requires'] = 'Требования';
$string['resetallcoursestodefaults'] = 'Сбросить все курсы по умолчанию';
$string['resetallcoursestodefaultsintro'] = 'Нажмите кнопку ниже, чтобы сбросить все курсы до указанных выше значений по умолчанию.';
$string['resetcoursedata'] = 'Сброс данных курса';
$string['resetcourserulestodefaults'] = 'Сбросить правила курса до значений по умолчанию';
$string['resetgroupdata'] = 'Сброс данных группы';
$string['resetlevelstodefaults'] = 'Сбросить уровни до начальных';
$string['resetvisualstodefaults'] = 'Сбросить внешний вид к настройкам по умолчанию';
$string['resultsfilteredforn'] = 'Результаты отфильтрованы для {$a}.';
$string['reverttopluginsdefaults'] = 'Вернуться к настройкам плагина по умолчанию';
$string['reverttopluginsdefaultsintro'] = 'Используйте кнопку ниже, если вы хотите вернуть вышеприведенные значения по умолчанию к значениям по умолчанию плагина. Это не влияет на правила существующих курсов.';
$string['reward'] = 'Награда';
$string['rule'] = 'Правило';
$string['rule:contains'] = 'содержит';
$string['rule:eq'] = 'совпадает с';
$string['rule:eqs'] = 'строго совпадает с';
$string['rule:gt'] = 'больше чем';
$string['rule:gte'] = 'больше или равно';
$string['rule:lt'] = 'меньше чем';
$string['rule:lte'] = 'меньше или равно';
$string['rule:regex'] = 'соответствует регулярному выражению';
$string['rulecm'] = 'Элемент курса или ресурс';
$string['rulecm_help'] = 'Это условие выполняется, когда событие происходит в указанном активном элементе или ресурсе.';
$string['rulecmdesc'] = 'Элемент или ресурс «{$a->contextname}».';
$string['rulecmdescwithcourse'] = 'Активный элемент или ресурс это: «{$a->contextname}» в «{$a->coursename}».';
$string['rulecminfo'] = 'Это условие требует, чтобы действие происходило в рамках определенного активного элемента или  ресурса.';
$string['ruleevent'] = 'Конкретное событие';
$string['ruleeventdesc'] = 'Это событие «{$a->eventname}»';
$string['ruleeventinfo'] = 'Выберите действие, которое должен выполнить пользователь, из предварительно подготовленного списка событий.';
$string['ruleproperty'] = 'Свойство события';
$string['rulepropertydesc'] = 'Свойство «{$a->property}» {$a->compare} «{$a->value}».';
$string['rulepropertyinfo'] = 'Это условие предназначено для опытных пользователей с техническими знаниями событий и их свойств.';
$string['ruleset'] = 'Группы условий';
$string['ruleset:all'] = 'ВСЕ условия должны быть выполнены';
$string['ruleset:any'] = 'ЛЮБОЕ из условий должно быть выполнено (хотя бы одно)';
$string['ruleset:none'] = 'НИ ОДНО из условий не должно быть выполнено';
$string['rulesetinfo'] = 'Объединить несколько условий в одно.';
$string['rulesformhelp'] = '<р>Этот плагин, опираясь на события в СДО, начисляет очки опыта за действия, выполняемые студентами. Вы можете использовать форму ниже, чтобы добавить свои собственные правила и просматривать те, которые установлены по умолчанию.</p>
<р>Рекомендуется проверить <a href="{$a->log}">журнал</a> плагина, чтобы определить, какие события срабатывают в курсе в зависимости от ваших действий, а также узнать больше о самих событиях: <a href="{$a->list}">список всех событий</a>, <a href="{$a->doc}«>документация для разработчиков</a>.</p>
<р>Обратите внимание, что плагин всегда игнорирует:
<ul>
<li>Действия, выполняемые администраторами, гостями или неавторизованными пользователями.</li>
<li>Действия, выполняемые пользователями, не имеющими права <em>block/xp:earnxp</em></li>
<li>Повторные действия в течение короткого промежутка времени, чтобы предотвратить обман.</li>
<li>События, которые помечаются как <em>anonymous</em>, например, при анонимном использовании элемента «Обратная связь».</li>
<li>События образовательного уровня, отличного от <em>Участник</em>.</li>
</ul>
</p>';
$string['searchandselectcourse'] = 'Поиск и выбор курса';
$string['send'] = 'Отправить';
$string['setpoints'] = 'Установить баллы';
$string['shortcode:xpbadge'] = 'Значок текущего уровня пользователя.';
$string['shortcode:xpiflevel'] = 'Отображение контента при достижении определенного уровня.';
$string['shortcode:xpiflevel_help'] = 'Обратитесь к примерам ниже, чтобы отформатировать этот шорткод. Если уровень задан строго, то контент будет отображаться независимо от других правил.
Правила _больше_ и _меньше_ должны совпадать для отображения содержимого. Будьте осторожны, так как иногда это может привести к тому, что содержимое никогда не будет отображаться!
Обратите внимание, что преподаватели или другие пользователи с правами редактирования всегда будут видеть все.

```
[xpiflevel 1 3 5]
    Отображается, если уровень пользователя равен 1, 3 или 5.
[/xpiflevel]

[xpiflevel >3]
    Отображается, если уровень пользователя больше 3.
[/xpiflevel]

[xpiflevel >=3]
    Отображается, если уровень пользователя больше или равен 3.
[/xpiflevel]

[xpiflevel >=10 <20 30]
    Отображается, если уровень пользователя больше или равен 10 И строго меньше 20
    ИЛИ строго равен 30.
[/xpiflevel]

[xpiflevel <=10 >=20]
    Никогда не отображается, поскольку уровень пользователя никогда не может быть меньше или равен 10 И больше или равен 20.
[/xpiflevel]
```

Обратите внимание, что эти шорткоды НЕ МОГУТ быть вложены друг в друга.';
$string['shortcode:xpladder'] = 'Отобразить часть таблицы лидеров.';
$string['shortcode:xpladder_help'] = 'По умолчанию будет отображаться часть таблицы лидеров, окружающая текущего пользователя.

```
[xpladder]
```

Чтобы отобразить 10 лучших студентов вместо соседей текущего пользователя, установите параметр `top`. Вы можете дополнительно установить количество отображаемых пользователей, например, `top=20`.

```
[xpladder top]
[xpladder top=15]
```

Ссылка на полную таблицу лидеров будет автоматически отображаться под таблицей, если вы не хотите отображать такую ссылку, добавьте аргумент `hidelink`.

```
[xpladder hidelink]
```

По умолчанию таблица не включает столбец прогресса, который отображает полосу прогресса. Если такой столбец был выбран в дополнительных столбцах в настройках таблицы лидеров, вы можете использовать аргумент `withprogress` для его отображения.

```
[xpladder withprogress]
```

Обратите внимание, что когда в курсе используются группы, таблица лидеров попытается определить, для какой группы отображать таблицу лидеров.';
$string['shortcode:xplevelname'] = 'Отобразить название уровня.';
$string['shortcode:xplevelname_help'] = 'По умолчанию тег отображает имя текущего уровня пользователя. В качестве альтернативы вы можете использовать аргумент `level` для отображения имени определенного уровня.

```
[xplevelname]
[xplevelname level=5]
```

Если аргумент level указан, а уровень не существует, ничего не будет отображено.';
$string['shortcode:xppoints'] = 'Отобразить количество баллов пользователя в формате очков опыта.';
$string['shortcode:xppoints_help'] = 'По умолчанию здесь отображается количество баллов текущего пользователя. В качестве альтернативы вы можете указать число, чтобы переопределить это значение.

Стиль баллов будет зависеть от того, отображается ли произвольное значение или баллы текущего пользователя. Аргумент `plain` можно использовать для удаления любого стиля.

```
[xppoints]
[xppoints 500]
[xppoints 123 plain]
```';
$string['shortcode:xpprogressbar'] = 'Индикатор продвижения текущего пользователя к следующему уровню.';
$string['sitewide'] = 'Для всего сайта';
$string['somefeaturesrequireotherplugins'] = 'Некоторые функции требуют установки дополнительных плагинов.';
$string['someoneelse'] = 'Кто-то ещё';
$string['somethinghappened'] = 'Что-то случилось';
$string['taskusagereport'] = 'Отчет об использовании';
$string['thankyou'] = 'Спасибо!';
$string['timebetweensameactions'] = 'Минимальное время между одинаковыми действиями';
$string['timebetweensameactions_help'] = 'Минимальное время в секундах, которое должно пройти между одинаковыми событиями. Действия считаются одинаковыми, если они относятся к одному и тому же контексту и объекту. Будет считаться одинаковым чтение сообщений на форуме, если будет прочитана та же запись.';
$string['timeformaxactions'] = 'Промежуток времени для ограничения по максимальному количеству действий';
$string['timeformaxactions_help'] = 'Промежуток времени в секундах, в течение которого пользователь не должен превышать максимальное число действий';
$string['total'] = 'Всего баллов';
$string['unknownbadgea'] = 'Неизвестный значок ({$a})';
$string['unknowneventa'] = 'Неизвестное событие ({$a})';
$string['unlockfeaturewithxpplus'] = 'Разблокируйте этот функционал с Опыт! Плюс. <a href="{$a}">Подробнее</a>';
$string['updateandpreview'] = 'Обновить и открыть предварительный просмотр';
$string['usagereport'] = 'Поделиться отчетом об использовании';
$string['usagereport_desc'] = 'Периодически делитесь анонимным отчетом об использовании с разработчиками плагина. Эта информация поможет лучше понять, как плагин используется, и повлияет на его развитие. Предоставляемая информация содержит информацию о сайте Moodle (URL, версию) и информацию об использовании плагина (количество пользователей, получивших баллы, обзор настроек, использованные правила)';
$string['usealgo'] = 'Использовать алгоритм';
$string['usecustomlevelbadges'] = 'Использовать собственные значки для уровней';
$string['usecustomlevelbadges_help'] = 'Если выбрано значение «Да», вам необходимо загрузить изображения для каждого из уровней';
$string['value'] = 'Значение';
$string['valuessaved'] = 'Значения были успешно сохранены.';
$string['viewas'] = 'Посмотреть как';
$string['viewlogs'] = 'Посмотреть логи';
$string['viewtheladder'] = 'Просмотр таблицы результатов';
$string['visualsintro'] = 'Настройте внешний вид уровней и значение баллов.';
$string['when'] = 'Когда';
$string['wherearexpused'] = 'Где используются баллы опыта?';
$string['wherearexpused_desc'] = 'Если выбрано «В курсах», баллы опыта будут начисляться внутри курса, в который добавлен блок. Если же выбрано «Для всего сайта» пользователь будет получать опыт на сайте, а не выборочно по курсам; будет использоваться опыт со всего сайта.';
$string['whoops'] = 'Ой!';
$string['xp'] = 'Баллы за опыт';
$string['xp:addinstance'] = 'Добавлять новый блок «Опыт!»';
$string['xp:earnxp'] = 'Получать баллы в блоке «Опыт!»';
$string['xp:myaddinstance'] = 'Добавлять новый блок «Опыт!» на страницу «Личный кабинет»';
$string['xp:view'] = 'Просмотреть блок и связанные с ним страницы';
$string['xp:viewlogs'] = 'Посмотреть логи';
$string['xp:viewreport'] = 'Посмотреть отчет';
$string['xpgaindisabled'] = 'Получение «Баллов за опыт» отключено';
$string['xpplusrequired'] = 'Необходим Опыт! Плюс';
$string['xprequired'] = 'Требуемые «Баллы за опыт»';
$string['youleveledupexcl'] = 'Вы повысили свой уровень!';
$string['youreachedlevel'] = 'Вы достигли уровня:';
$string['youreachedlevela'] = 'Вы достигли {$a} уровня!';
$string['yourmessage'] = 'Ваше сообщение';
$string['yourownrules'] = 'Ваши собственные правила';
