<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'moodle', language 'ro', version '5.1'.
 *
 * @package     moodle
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['abouttobeinstalled'] = 'urmează să fie instalat';
$string['accept'] = 'Accept';
$string['action'] = 'Acțiune';
$string['actionchoice'] = 'Ce doriți să faceți cu acest fișier "{$a}"?';
$string['actions'] = 'Acțiuni';
$string['actionsfor'] = 'Acțiuni cu {$a}';
$string['actionsmenu'] = 'Meniu acțiuni';
$string['active'] = 'Activ';
$string['activeusers'] = 'Utilizatori activi';
$string['activities'] = 'Activități';
$string['activities_help'] = 'Activitățile, precum forumuri, teste și wikis, permit adăugarea de conținut interactiv la curs.';
$string['activity'] = 'Activitate';
$string['activityclipboard'] = 'Mutarea acestei activități: {$a}';
$string['activityheader'] = 'Meniu activitate';
$string['activityicon'] = '{a} icoană';
$string['activityiscurrentlyhidden'] = 'Ne pare rău, această activitate este ascunsă în prezent';
$string['activitymodule'] = 'Modul activitate';
$string['activitymodules'] = 'Module activități';
$string['activitynotready'] = 'Activitatea nu este pregătită încă';
$string['activityorresource'] = 'Activitate sau resursă';
$string['activityreport'] = 'Raport activitate';
$string['activityreports'] = 'Rapoarte activitate';
$string['activityselect'] = 'Selectați această activitate, pentru a o muta în altă parte';
$string['activitysince'] = 'Activitate începând cu {$a}';
$string['activitytypetitle'] = '{$a->activity} - {$a->type}';
$string['activityweighted'] = 'Activitate pe utilizator';
$string['add'] = 'Adaugă';
$string['addactivity'] = 'Adaugă o activitate...';
$string['addactivitytosection'] = 'Adaugă o activitate la selecție "{$a}"';
$string['addadmin'] = 'Adaugă un administrator';
$string['addblock'] = 'Adaugă un bloc';
$string['addcomment'] = 'Adaugă un comentariu...';
$string['addcondition'] = 'Adaugă condiție';
$string['addcontent'] = 'Adaugă conținut';
$string['addcountertousername'] = 'Creează un utilizator, adăugând un număr la numele de utilizator';
$string['addcreator'] = 'Adaugă creatorul cursului';
$string['adddots'] = 'Adaugă...';
$string['added'] = 'Adăugat {$a}';
$string['addedtogroup'] = 'Adăugat la grup "{$a}"';
$string['addedtogroupnot'] = 'Nu a fost adăugat la grup "{$a}"';
$string['addedtogroupnotenrolled'] = 'Nu a fost adăugat la grup "{$a}", pentru că nu a fost înscris la curs';
$string['addfilehere'] = 'Aruncă fișierele aici pentru a le adăuga în partea de jos a acestei secțiuni';
$string['addfilesdrop'] = 'Puteți să trageți și să lipiți fișierele aici pentru a le încărca sau dați click pentru a le selecta.';
$string['addinganew'] = 'Nou {$a}';
$string['addingdatatoexisting'] = 'Adăugarea datelor la cele existente';
$string['additionalcustomnav'] = 'Navigare particularizată adițională';
$string['additionalnames'] = 'Nume suplimentare';
$string['addlinkhere'] = 'Adaugă un link aici';
$string['addnew'] = 'Adaugă o nouă {$a}';
$string['addnewcategory'] = 'Adaugă categorie nouă';
$string['addnewcourse'] = 'Adaugă un curs nou';
$string['addnewuser'] = 'Adaugă un utilizator nou';
$string['addnousersrecip'] = 'Adaugă utilizatorii care nu au această listă de destinatari {$a}';
$string['addpagehere'] = 'Adaugă text aici';
$string['addresource'] = 'Adaugă o resursă...';
$string['addresourceoractivity'] = 'Adaugă o activitate sau resursă';
$string['addresourcetosection'] = 'Adaugă o resursă la secțiune "{$a}"';
$string['address'] = 'Adresă';
$string['addsections'] = 'Adaugă secțiuni';
$string['addstudent'] = 'Adaugă cursant';
$string['addsubcategory'] = 'Adaugă o subcategorie';
$string['addteacher'] = 'Adaugă formator';
$string['admin'] = 'Administrator';
$string['adminhelpaddnewuser'] = 'Pentru a crea manual un nou cont de utilizator';
$string['adminhelpassignadmins'] = 'Administratorul poate face orice și poate accesa orice pagină a site-ului';
$string['adminhelpassigncreators'] = 'Creatorii de cursuri pot genera cursuri noi';
$string['adminhelpassignsiteroles'] = 'Aplicați roluri de site definite anumitor utilizatori';
$string['adminhelpassignstudents'] = 'Mergeți la un curs și adăugați studenți din meniul de administrare';
$string['adminhelpauthentication'] = 'Puteți utiliza conturi de utilizator interne sau baze de date externe';
$string['adminhelpbackup'] = 'Configurați copiile de rezervă automatizate și programul acestora';
$string['adminhelpconfiguration'] = 'Configurați aspectul și funcționarea site-ului';
$string['adminhelpconfigvariables'] = 'Configurați variabilele, care afectează funcționarea generală a site-ului';
$string['adminhelpcourses'] = 'Definiți cursuri și categorii și atribuiți-le persoane, editați cursuri în așteptare';
$string['adminhelpeditorsettings'] = 'Definiți setările de bază pentru editorul HTML';
$string['adminhelpedituser'] = 'Răsfoiți lista conturilor de utilizator și editați oricare dintre ele';
$string['adminhelpenvironment'] = 'Verificați modul în care serverul dvs. este compatibil cu cerințele de instalare actuale și viitoare';
$string['adminhelpfailurelogs'] = 'Răsfoiți jurnalele de conectări eșuate';
$string['adminhelplanguage'] = 'Pentru verificarea și editarea pachetului lingvistic curent';
$string['adminhelplogs'] = 'Răsfoiți jurnalele tuturor activităților de pe acest site';
$string['adminhelpmanageblocks'] = 'Gestionați blocurile instalate și setările acestora';
$string['adminhelpmanagedatabase'] = 'Accesați direct baza de date (atenție!)';
$string['adminhelpmanagefilters'] = 'Alegeți filtre de text și setări conexe';
$string['adminhelpmanagemodules'] = 'Gestionați modulele instalate și setările acestora';
$string['adminhelpmanageroles'] = 'Creați și definiți roluri, care pot fi aplicate utilizatorilor';
$string['adminhelpmymoodle'] = 'Configurați blocurile My Moodle pentru utilizatori';
$string['adminhelpreports'] = 'Rapoarte la nivel de site';
$string['adminhelpsitefiles'] = 'Pentru publicarea fișierelor generale sau încărcarea copiilor de rezervă externe';
$string['adminhelpsitesettings'] = 'Definiți cum arată prima pagină';
$string['adminhelpstickyblocks'] = 'Configurați blocuri Moodle-wide sticky';
$string['adminhelpthemes'] = 'Alegeți aspectul site-ului (culori, fonturi etc.)';
$string['adminhelpuploadusers'] = 'Importați conturi noi de utilizator dintr-un fișier text';
$string['adminhelpusers'] = 'Definiți-vă utilizatorii și configurați autentificarea';
$string['adminhelpxmldbeditor'] = 'Interfață pentru editarea fișierelor XMLDB. Numai pentru dezvoltatori.';
$string['administration'] = 'Administrare';
$string['administrationsite'] = 'Administrare site';
$string['administrator'] = 'Administrator';
$string['administratordescription'] = 'Administratorii pot face de obicei orice pe site, la toate cursurile.';
$string['administrators'] = 'Administratori';
$string['administratorsall'] = 'Toți administratorii';
$string['administratorsandteachers'] = 'Administratori și formatori';
$string['advanced'] = 'Avansat';
$string['advancedfilter'] = 'Căutare avansată';
$string['advancedsettings'] = 'Setări avansate';
$string['afterresource'] = 'După resursă "{$a}"';
$string['aftersection'] = 'După secțiunea "{$a}"';
$string['again'] = 'din nou';
$string['agelocationverification'] = 'Verificarea vârstei și a localizării';
$string['ajaxuse'] = 'AJAX și Javascript';
$string['all'] = 'Toate';
$string['allactions'] = 'Toate acțiunile';
$string['allactivities'] = 'Toate activitățile';
$string['allcategories'] = 'Toate categoriile';
$string['allchanges'] = 'Toate modificările';
$string['alldays'] = 'Toate zilele';
$string['allfiles'] = 'Toate fișierele';
$string['allgroups'] = 'Toate grupurile';
$string['alllogs'] = 'Toate jurnalele';
$string['allmods'] = 'Toate {$a}';
$string['allow'] = 'Permite';
$string['allowinternal'] = 'Permite și metodele interne';
$string['allownone'] = 'Nu permite nimic';
$string['allownot'] = 'Nu permite';
$string['allowstealthmodules'] = 'Permiteți activități invizibile';
$string['allowstealthmodules_help'] = 'Dacă este activată, activitățile pot fi puse la dispoziție, dar nu sunt afișate în secțiunile vizibile ale paginii cursului. Astfel, link-uri către activități invizibile trebuie furnizate din alte părți, cum ar fi dintr-o resursă a paginii. Activitățile invizibile sunt totuși afișate în carnetul de note și în alte rapoarte.';
$string['allparticipants'] = 'Toți participanții';
$string['allteachers'] = 'Toți formatorii';
$string['alphanumerical'] = 'Poate conține numai caractere alfanumerice, cratimă (-) sau punct (.)';
$string['alreadyconfirmed'] = 'Înregistrarea a fost deja confirmată';
$string['alternatename'] = 'Nume alternativ';
$string['always'] = 'Întotdeauna';
$string['and'] = '{$a->one} și {$a->two}';
$string['answer'] = 'Răspuns';
$string['any'] = 'Orice';
$string['appearance'] = 'Aspect';
$string['apply'] = 'Aplică';
$string['applyfilters'] = 'Aplică filtre';
$string['approve'] = 'Aprobă';
$string['areyousure'] = 'Sunteți sigur?';
$string['areyousuretorestorethis'] = 'Doriți să continuați?';
$string['areyousuretorestorethisinfo'] = 'Mai târziu în acest proces, veți avea posibilitatea de a adăuga această copie de rezervă la un curs existent sau de a crea un curs complet nou.';
$string['asc'] = 'Crescător';
$string['assessment'] = 'Evaluare';
$string['assignadmins'] = 'Alocă administratori';
$string['assigncreators'] = 'Alocă creatori';
$string['assignedrolecount'] = '{$a->role}: {$a->count}';
$string['assignsiteroles'] = 'Atribuiți roluri la nivelul întregului site';
$string['authenticateduser'] = 'Utilizator autentificat';
$string['authenticateduserdescription'] = 'Toți utilizatorii logați.';
$string['authentication'] = 'Autentificare';
$string['authenticationplugins'] = 'Plugin-uri de autentificare';
$string['autosubscribe'] = 'Abonare automată la forum';
$string['autosubscribeno'] = 'Nu: nu mă abona în mod automat la forumul de discuții';
$string['autosubscribeyes'] = 'Da: când postez, abonează-mă la forumul de discuții';
$string['availability'] = 'Disponibilitate';
$string['availablecourses'] = 'Cursuri disponibile';
$string['back'] = 'Înapoi';
$string['backto'] = 'Înapoi la {$a}';
$string['backtocourselisting'] = 'Înapoi la lista cursurilor';
$string['backtohome'] = 'Înapoi la pagina principală';
$string['backtopageyouwereon'] = 'Înapoi la pagina pe care vă aflați';
$string['backup'] = 'Backup';
$string['backupactivehelp'] = 'Alegeți dacă faceți sau nu backup automat.';
$string['backupadhocpending'] = 'Activitatea de backup ad hoc a cursului este în așteptare';
$string['backupcancelled'] = 'Backup anulat';
$string['backupcoursefileshelp'] = 'Dacă este activat, fișierele de curs vor fi incluse în backup-ul automat';
$string['backupdate'] = 'Dată backup';
$string['backupdatenew'] = '&nbsp; {$a->TAG} este acum {$a->weekday}, {$a->mday} {$a->month} {$a->year}<br />';
$string['backupdateold'] = '{$a->TAG} a fost {$a->weekday}, {$a->mday} {$a->month} {$a->year}';
$string['backupdaterecordtype'] = '<br />{$a->recordtype} - {$a->recordname}<br />';
$string['backupdetails'] = 'Detalii backup';
$string['backuperrorinvaliddestination'] = 'Fișierul de destinație al backup-ului nu există sau nu poate fi scris.';
$string['backupexecuteathelp'] = 'Alegeți la ce oră ar trebui să ruleze backup-ul automat.';
$string['backupfailed'] = 'Unele dintre cursurile dumneavoastră nu au fost salvate!!';
$string['backupfilename'] = 'backup';
$string['backupfinished'] = 'Backup-ul a fost realizat cu succes';
$string['backupfromthissite'] = 'Backup-ul a fost realizat pe acets site?';
$string['backupgradebookhistoryhelp'] = 'Dacă este activat, istoricul catalogului va fi inclus în backup-ul automat. Rețineți că istoricul calificărilor nu trebuie să fie dezactivat în setările serverului (dezactivează istoricul catalogului), pentru ca acest lucru să funcționeze';
$string['backupincludemoduleshelp'] = 'Alegeți dacă doriți să includeți module de curs, cu sau fără date de utilizator, în backup-ul automat';
$string['backupincludemoduleuserdatahelp'] = 'Alegeți dacă doriți să includeți datele utilizatorului modulului în backup-ul automat.';
$string['backupinfo'] = 'Fă o copie a acestui curs, incluzând tot conținutul și activitatea la zi. Poți folosi fișierul de rezervă pentru a restaura cursul.';
$string['backuplogdetailed'] = 'Jurnal de execuție detaliat';
$string['backuploglaststatus'] = 'Jurnal de execuție recent';
$string['backupmissinguserinfoperms'] = 'Notă: Acest backup nu conține date de utilizator. Activitățile de exercițiu și atelier nu vor fi incluse în backup, deoarece nu sunt compatibile cu acest tip de backup.';
$string['backupnext'] = 'Următorul backup';
$string['backupnonisowarning'] = 'Atenție: acest backup provine dintr-o versiune non-Unicode a Moodle (pre 1.6). Dacă textele conținute de backup nu sunt ISO-8859-1, ele vor fi CORUPTE când încercați să le restaurați la această versiune Unicode a Moodle.  A se vedea <a href="http://docs.moodle.org/en/Backup_FAQ">Backup FAQ</a> pentru informații suplimentare privind modul corect de recuperare a acestui backup.';
$string['backupnotyetrun'] = 'Backup automat în așteptare';
$string['backuporiginalname'] = 'Nume backup';
$string['backuproleassignments'] = 'Alocarea rolurilor de rezervă pentru aceste roluri';
$string['backupsavetohelp'] = 'Calea completă către directorul în care doriți să salvați fișierele de rezervă';
$string['backupsitefileshelp'] = 'Dacă este activată, fișierele de site utilizate la cursuri vor fi incluse în backup-ul automat';
$string['backuptakealook'] = 'Vă rugăm să aruncați o privire asupra jurnalelor dumneavoastră de backup:
  {$a}';
$string['backupuserfileshelp'] = 'Alegeți dacă fișierele utilizatorului (de exemplu, imaginile de profil) trebuie incluse în backup-ul automat';
$string['backupversion'] = 'Versiune backup';
$string['badges'] = 'Ecusoane';
$string['block'] = 'Bloc';
$string['blockconfiga'] = 'Configurarea unui {$a} bloc';
$string['blockconfigbad'] = 'Acest bloc nu a fost implementat corect și, prin urmare, nu poate oferi o interfață de configurare.';
$string['blocks'] = 'Blocuri';
$string['blocksaddedit'] = 'Adaugă/ Editează blocuri';
$string['blockseditoff'] = 'Dezactivează editarea blocurilor';
$string['blocksediton'] = 'Activează editarea blocurilor';
$string['blocksetup'] = 'Configurarea tabelelor blocurilor';
$string['blocksuccess'] = '{$a} tabelele au fost configurate corect';
$string['brief'] = 'Rezumat';
$string['bulkactions'] = 'Acțiuni în bloc';
$string['bulkactionselect'] = '{$a} Selectarea acțiunilor în bloc';
$string['bulkcancel'] = 'Încheie editarea în masă';
$string['bulkmovecoursessuccess'] = 'Cursurile {$a->courses} au fost mutate cu succes în {$a->category}';
$string['bulkselection'] = '{$a} selectate';
$string['bycourseorder'] = 'După ordinea cursului';
$string['byname'] = 'după {$a}';
$string['bypassed'] = 'Evitat';
$string['cachecontrols'] = 'Comenzi cache';
$string['calltofeedback'] = 'Creatorii acestui software doresc să oferiți un feedback.';
$string['calltofeedback_give'] = 'Oferiți feedback despre acest software';
$string['calltofeedback_remind'] = 'Amintește-mi mai târziu';
$string['cancel'] = 'Anulare';
$string['cancelled'] = 'Anulat';
$string['categories'] = 'Categorii curs';
$string['categoriesandcourses'] = 'Categorii curs și cursuri';
$string['category'] = 'Categorie';
$string['categoryadded'] = 'Categoria "{$a}" a fost adăugată';
$string['categorybulkaction'] = 'Acțiune în bloc pentru categoriile selectate';
$string['categorycontents'] = 'Subcategorii și cursuri';
$string['categorycurrentcontents'] = 'Conținutul {$a}';
$string['categorydeleted'] = 'Categoria "{$a}" a fost ștearsă';
$string['categoryduplicate'] = 'Există deja categoria numită "{$a}"!';
$string['categoryheader'] = 'Meniu categorie';
$string['categoryhidden'] = '(ascuns)';
$string['categorymodifiedcancel'] = 'Categoria a fost modificată! Vă rugăm să anulați și să încercați din nou.';
$string['categoryname'] = 'Nume categorie';
$string['categorypath'] = 'Calea categoriei';
$string['categorysubcategoryof'] = '{$a->category} - subcategorie a {$a->parentcategory}';
$string['categoryupdated'] = 'Categoria "{$a}" a fost actualizată';
$string['changedpassword'] = 'Parolă modificată';
$string['changepassword'] = 'Modifică parola';
$string['changesmade'] = 'Modificările făcute';
$string['changesmadereallygoaway'] = 'Ați făcut modificări. Sigur doriți să navigați și să pierdeți modificările?';
$string['changessaved'] = 'Modificări salvate';
$string['check'] = 'Verifică';
$string['checkactual'] = 'Real';
$string['checkall'] = 'Verifică tot';
$string['checkerror'] = 'Eroare la obținerea rezultatului verificării „{$a}”. Verificați consola browserului pentru mai multe informații.';
$string['checkexpected'] = 'Presupus';
$string['checkingbackup'] = 'Verificare backup';
$string['checkingcourse'] = 'Verificare curs';
$string['checkingforbbexport'] = 'Verificarea exportului BlackBoard';
$string['checkinginstances'] = 'Verificarea sesiunilor';
$string['checkingsections'] = 'Se verifică secțiunile';
$string['checklanguage'] = 'Verificarea limbii';
$string['checkloading'] = 'Se obține rezultatul verificării {$a}\'';
$string['checknone'] = 'Nu verifica';
$string['checks'] = 'Verificări';
$string['checksok'] = 'Toate verificările \'{$a}\' OK';
$string['childcoursenotfound'] = 'Cursul subordonat nu a fost găsit!';
$string['childcourses'] = 'Curs subordonat';
$string['choose'] = 'Selectați';
$string['choosecourse'] = 'Selectați un curs';
$string['choosedots'] = 'Selectați...';
$string['chooselivelogs'] = 'Sau urmăriți activitatea curentă';
$string['chooselogs'] = 'Selectați jurnalele pe care doriți să le vizualizați';
$string['choosereportfilter'] = 'Selectați un filtru pentru raport';
$string['choosetheme'] = 'Selectați o temă';
$string['chooseuser'] = 'Selectați un utilizator';
$string['city'] = 'Localitate/ oraș';
$string['cleaningtempdata'] = 'Ștergerea datelor de temporizare';
$string['clear'] = 'Șterge';
$string['clearall'] = 'Șterge tot';
$string['clearfilterrow'] = 'Șterge filtrul rândului';
$string['clearfilters'] = 'Șterge filtrele';
$string['clearsearch'] = 'Ștergeți valoarea de căutare';
$string['clickhelpiconformoreinfo'] = '... continuă ... Faceți click pe pictograma de asistență, pentru a citi articolul complet';
$string['clickhere'] = 'Faceți click aici ...';
$string['clicktohideshow'] = 'Faceți click, pentru a extinde sau a derula';
$string['closeblockdrawer'] = 'Închide sertarul cu blocuri';
$string['closebuttontitle'] = 'Închide';
$string['closecourseindex'] = 'Încheie index-ul cursului';
$string['closedrawer'] = 'Închide sertarul';
$string['closewindow'] = 'Închide această fereastră';
$string['collapse'] = 'Derulează';
$string['collapseall'] = 'Restrânge toate secțiunile';
$string['collapsecategory'] = 'Derulează {$a}';
$string['comebacklater'] = 'Vă rugăm să reveniți mai târziu.';
$string['commentincontext'] = 'Găsiți acest comentariu în context';
$string['comments'] = 'Comentarii';
$string['commentscount'] = 'Comentarii ({$a})';
$string['commentsnotenabled'] = 'Funcția de comentarii nu este activată';
$string['commentsrequirelogin'] = 'Trebuie să vă conectați, pentru a putea vizualiza comentariile.';
$string['comparelanguage'] = 'Compară și editează limba curentă';
$string['complete'] = 'Finalizat';
$string['completed'] = 'Completat';
$string['completereport'] = 'Raport complet';
$string['configuration'] = 'Configurare';
$string['confirm'] = 'Confirmă';
$string['confirmaccount'] = 'Confirmă cont';
$string['confirmcheckfull'] = 'Sunteți sigur că doriți să confirmați {$a} ?';
$string['confirmcoursemove'] = 'Sunteți sigur că doriți să transferați acest curs ({$a->course}) în această categorie ({$a->category})?';
$string['confirmdeletesection'] = 'Sunteți sigur că doriți să ștergeți complet "{$a}" și toate activitățile pe care le conține?';
$string['confirmed'] = 'Înregistrarea dumneavoastră a fost confirmată';
$string['confirmednot'] = 'Înregistrarea dumneavoastră nu a fost confirmată încă! Vă rugăm să verificați mail-ul pentru email-ul de confirmare.';
$string['considereddigitalminor'] = 'Nu aveți vârsta necesară pentru a putea crea un cont pe acest site.';
$string['contactsbyrolelist'] = '{$a->role}: {$a->contacts}';
$string['content'] = 'Conținut';
$string['contentbank'] = 'Bancă de conținut';
$string['contentexport_aboutthiscourse'] = 'Sumarul cursului';
$string['contentexport_coursesummary'] = 'Acest fișier este parte a conținutului descărcat de la <a href="{$a->courselink}">{$a->coursename}</a>.';
$string['contentexport_footersummary'] = 'Acest fișier face parte din conținutul descărcat de la <a href="{$a->courselink} "> {$a->coursename} </a> de către {$a->userfullname} pe {$a->date} .';
$string['contentexport_modulesummary'] = 'Această pagină este parte a conținutului descărcat de la <a href="{$a->modulelink}">{$a->modulename}</a> în {$a->date}. Luați în considerare că conținutul și fișierele mai mari de {$a->maxfilesize} nu sunt descărcate.';
$string['contentexport_viewfilename'] = 'Vezi fișierul {$a}';
$string['context'] = 'Context';
$string['contextlevel'] = 'Nivelul contextului';
$string['contextname'] = 'Denumirea contextului';
$string['contextparent'] = 'Părinte';
$string['contexturl'] = 'URL context';
$string['continue'] = 'Continuă';
$string['continuetocourse'] = 'Faceți click aici, pentru a accesa cursul dumneavoastră';
$string['convertingwikitomarkdown'] = 'Convertirea wiki în Markdown';
$string['cookiesenabled'] = 'Cookie-urile trebuie să fie activate în browser-ul dumneavoastră.';
$string['cookiesenabled_help'] = 'Acest site utilizează două cookie-uri:

Cookie-ul esențial este cel de sesiune, numit, de obicei, MoodleSession. Trebuie să autorizați acest cookie din browser-ul dumneavoastră, pentru a oferi continuitate și a menține datele de conectare de la pagină la pagină. Când vă deconectați sau închideți browser-ul, acest cookie va fi distrus (în browserul dvs. și pe server).

Celălalt cookie este doar pentru comoditate, fiind denumit, de obicei, MOODLEID. Acest cookie memorează doar numele de utilizator din browser. Acest lucru înseamnă că, atunci când reveniți pe acest site, câmpul cu numele de utilizator de pe pagina de autentificare va fi deja completat pentru dumneavoastră. Este sigur să refuzați acest cookie, dar va trebui să tastați din nou numele de utilizator de fiecare dată când vă conectați.';
$string['cookiesenabled_help_html'] = 'Pe acest site sunt folosite două cookie-uri:<br/><br/>

Cel esențial este cookie-ul de sesiune, numit de obicei MoodleSession. Trebuie să permiteți acestui cookie în browser să ofere continuitate și să rămână conectat atunci când navigați pe site. Când vă deconectați sau închideți browserul, acest cookie este distrus (în browser și pe server).<br/><br/>

Celălalt cookie este pur pentru comoditate, numit de obicei MOODLEID sau similar. Îți amintește doar numele de utilizator în browser. Aceasta înseamnă că atunci când reveniți pe acest site, câmpul de nume de utilizator de pe pagina de conectare este deja completat pentru dvs. Este sigur să refuzați acest cookie - va trebui doar să vă reintroduceți numele de utilizator de fiecare dată când vă conectați.';
$string['cookiesenabledonlysession'] = 'Trebuie activate cookie-urile în browserul Dvs.';
$string['cookiesenabledonlysession_help'] = 'Acest site utilizează o sesiune cookie, denumită de obicei MoodleSession. Trebuie să permiteți acest modul cookie în browserul dumneavoastră pentru a se asigura continuitatea și pentru a rămâne conectați pe site. Când vă deconectați sau închideți browserul, acest modul cookie este anulat (în browser și pe server).';
$string['cookiesnotenabled'] = 'Din păcate, cookie-urile nu sunt activate în prezent în browser-ul dumneavoastră.';
$string['cookiesnotice'] = 'Informare cu privire la cookies';
$string['copy'] = 'copiază';
$string['copyasnoun'] = 'copiază';
$string['copycourse'] = 'Copiază cursul';
$string['copyingcoursefiles'] = 'Copierea fișierelor cursului';
$string['copyingsitefiles'] = 'Copierea fișierelor site-ului care sunt utilizate în curs';
$string['copyinguserfiles'] = 'Copierea fișierelor utilizatorului';
$string['copyingzipfile'] = 'Copierea fișierelor zip';
$string['copyrightnotice'] = 'Notificare privind drepturile de autor';
$string['copytoclipboard'] = 'Copiază în clipboard';
$string['coresystem'] = 'Sistem';
$string['cost'] = 'Cost';
$string['costdefault'] = 'Cost implicit';
$string['counteditems'] = '{$a->count} {$a->items}';
$string['country'] = 'Țară';
$string['course'] = 'Curs';
$string['courseadministration'] = 'Administrare curs';
$string['courseapprovedemail'] = 'Cursul solicitat de dumneavoastră a fost aprobat, <a href="{$a->url}">{$a->name}</a>, și sunteți un {$a->teacher}.';
$string['courseapprovedemail2'] = 'Cursul solicitat de dumneavoastră este aprobat: <a href="{$a->url}">{$a->name}</a>.';
$string['courseapprovedfailed'] = 'Cursul nu a putu fi salvat în formatul aprobat!';
$string['courseapprovedsubject'] = 'Cursul dumneavoastră a fost aprobat!';
$string['courseavailable'] = 'Acest curs este disponibil pentru cursanți';
$string['courseavailablenot'] = 'Acest curs nu este disponibil pentru cursanți';
$string['coursebackup'] = 'Backup curs';
$string['coursebulkaction'] = 'Acțiuni în grup pentru cursurile selectate';
$string['coursecategories'] = 'Categorii de curs';
$string['coursecategory'] = 'Categorie curs';
$string['coursecategory_help'] = 'Această setare determină categoria în care va apărea cursul în lista cursurilor.';
$string['coursecategorydeleted'] = 'Șterge categorie curs {$a}';
$string['coursecatmanagement'] = 'Gestionarea cursului și a categoriei';
$string['coursecompletion'] = 'Finalizarea cursului';
$string['coursecompletions'] = 'Finalizarea cursului';
$string['coursecreators'] = 'Creator curs';
$string['coursecreatorsdescription'] = 'Creatorii de cursuri pot crea cursuri noi.';
$string['coursedeleted'] = 'Șterge curs {$a}';
$string['coursedetails'] = 'Detalii curs';
$string['coursedisplay'] = 'Aspect curs';
$string['coursedisplay_help'] = 'Secțiunile cursului pot fi afișate pe o singură pagină sau pe mai multe pagini.';
$string['coursedisplay_multi'] = 'Afișează câte o secțiune pe pagină';
$string['coursedisplay_single'] = 'Afișează toate secțiunile pe o singură pagină';
$string['courseduration'] = 'Durată curs';
$string['courseduration_desc'] = 'Durata cursului este utilizată pentru a calcula data implicită de încheiere a cursului. Data de încheiere a cursului este utilizată pentru a determina dacă un curs ar trebui inclus în lista de cursuri a unui utilizator. Poate fi folosită și în rapoarte personalizate. Utilizatorii pot accesa în continuare cursul și după data încheierii.';
$string['courseenddateenabled'] = 'Data de finalizare a cursului activată implicit';
$string['courseenddateenabled_desc'] = 'Această setare determină dacă data de încheiere a cursului va fi activată în mod implicit pentru cursurile noi și este setată raportat la durata cursului.';
$string['courseextendednamedisplay'] = '{$a->shortname} {$a->fullname}';
$string['coursefiles'] = 'Fișiere vechi de curs';
$string['coursefilesedit'] = 'Editați fișierele vechi de curs';
$string['coursefileswarning'] = 'Fișierele cursului sunt învechite';
$string['coursefileswarning_help'] = 'Fișierele de curs sunt învechite de la Moodle 2.0, vă rugăm să folosiți pe cât posibil depozite externe.';
$string['courseformatdata'] = 'Date despre formatul cursului';
$string['courseformatoptions'] = 'Opțiuni de formatare pentru {$a}';
$string['courseformats'] = 'Formate de curs';
$string['courseformatudpate'] = 'Actualizează format';
$string['coursegrades'] = 'Note la curs';
$string['courseheader'] = 'Meniul cursului';
$string['coursehelpcategory'] = 'Poziționați cursul pe lista cursurilor și acest lucru va facilita găsirea cursanților.';
$string['coursehelpforce'] = 'Forțați modul grup de curs la fiecare activitate din curs.';
$string['coursehelpformat'] = 'Pagina principală a cursului va fi afișată în acest format.';
$string['coursehelphiddensections'] = 'Cum sunt afișate studenților secțiunile ascunse din curs.';
$string['coursehelpmaximumupload'] = 'Definiți cea mai mare dimensiune a fișierului care poate fi încărcat în acest curs, limitată fiind de setarea la nivel de site.';
$string['coursehelpnewsitemsnumber'] = 'Numărul de anunțuri recente care apar în ultimul bloc de anunțuri de pe pagina cursului. Dacă este setat la zero, forumul de anunțuri nu va fi creat.';
$string['coursehelpnumberweeks'] = 'Numărul de secțiuni din curs (se aplică numai anumitor formate de curs).';
$string['coursehelpshowgrades'] = 'Activați afișarea catalogului. Nu împiedică afișarea notelor din cadrul activităților individuale.';
$string['coursehidden'] = 'Acest curs nu este disponibil în prezent studenților';
$string['courseinfo'] = 'Informații curs';
$string['courselegacyfiles'] = 'Fișiere vechi de curs';
$string['courselegacyfiles_help'] = 'Zona de fișiere a cursului oferă o oarecare compatibilitate înapoi cu Moodle 1.9 și versiunile anterioare. Toate fișierele din această zonă sunt întotdeauna accesibile tuturor participanților la curs (indiferent dacă vă conectați la ei sau nu) și nu există nicio modalitate de a ști unde se utilizează oricare dintre aceste fișiere în Moodle.

Dacă utilizați această zonă pentru a stoca fișiere de curs, vă puteți expune la o serie de probleme de confidențialitate și securitate, precum și de a experimenta fișiere lipsă în copiile de rezervă, importurile de cursuri și orice moment când conținutul este partajat sau refolosit. Prin urmare, este recomandat să nu utilizați această zonă decât dacă știți cu adevărat ce faceți.';
$string['courselegacyfiles_link'] = 'fișierecurs2';
$string['courselegacyfilesofcourse'] = 'Fișiere vechi de curs: {$a}';
$string['coursenotaccessible'] = 'Acest curs nu permite accesul publicului';
$string['courseoverview'] = 'Privire de ansamblu asupra cursului';
$string['courseoverviewfiles'] = 'Imaginea cursului';
$string['courseoverviewfiles_help'] = 'Imaginea cursului este afișată în pagina Cursurile mele și în lista cursurilor disponibile de pe Pagina principală. Administratorii site-ului pot activa tipuri de fișiere suplimentare și utilizarea mai multor fișiere. Dacă utilizați mai multe fișiere, toate vor fi afișate în lista de cursuri disponibile din Pagina principală.';
$string['courseoverviewfilesext'] = 'Extensii de fișiere pentru imaginea de curs';
$string['courseoverviewfileslimit'] = 'Limita fișierelor de imagini ale cursului';
$string['courseoverviewgraph'] = 'Grafic de prezentare generală a cursului';
$string['courseprofiles'] = 'Profile curs';
$string['coursereasonforrejecting'] = 'Motivele dumneavoastră pentru respingerea acestei solicitări';
$string['coursereasonforrejectingemail'] = 'Acestea vor fi transmise prin e-mail către solicitant';
$string['coursereject'] = 'Respinge o solicitare de curs';
$string['courserejected'] = 'Cursul a fost respins și solicitantul a fost notificat.';
$string['courserejectemail'] = 'Ne pare rău, dar cursul pe care l-ați solicitat a fost respins. Iată motivul prezentat:

{$a}';
$string['courserejectreason'] = 'Descrieți motivele pentru care ați respins acest curs<br />(acestea vor fi transmise prin e-mail către solicitant)';
$string['courserejectsubject'] = 'cursul dumneavoastră a fost respins';
$string['coursereport'] = 'Raport curs';
$string['coursereports'] = 'Rapoarte cursuri';
$string['courserequest'] = 'Solicitare curs';
$string['courserequestdetails'] = 'Detalii despre cursul pe care îl solicitați';
$string['courserequestfailed'] = 'Din anumite motive, solicitarea dumneavoastră de curs nu a putut fi salvată';
$string['courserequestintro'] = 'Utilizați acest formular, pentru a solicita crearea unui curs pentru dumneavoastră.<br />Încercați și completați cât de multe informații puteți, pentru a permite<br />administratorilor să înțeleagă motivele pentru care vă doriți acest curs.';
$string['courserequestreason'] = 'Motivele pentru care vă doriți acest curs';
$string['courserequestroleerror'] = 'Rolul creatorilor în configurarea cursurilor noi nu este valid. Te rugăm să consulți a href="{$a}">politicile utilizatorului</a>.';
$string['courserequestsuccess'] = 'Solicitare de curs trimisă.';
$string['courserequestsupport'] = 'Informații de sprijin pentru a ajuta administratorul să evalueze această solicitare';
$string['courserequestwarning'] = 'Utilizatorul care solicită acest curs va fi înscris automat și i se va atribui rolul de {$a}.';
$string['courserestore'] = 'Restaurează curs';
$string['coursereuse'] = 'Reutilizare curs';
$string['coursereusenavigationmenu'] = 'Meniul de navigare pentru reutilizarea cursului';
$string['courses'] = 'Cursuri';
$string['coursesectionsummaries'] = 'Rezumatele secțiunii cursului';
$string['coursesectiontitle'] = '{$a->sectionname}: {$a->sectiontitle} | {$a->course}';
$string['coursesectiontitlebulkediting'] = 'Editare în masă {$a->sectionname}: {$a->sectiontitle} | {$a->course}';
$string['coursesectiontitleediting'] = 'Editează {$a->sectionname}: {$a->sectiontitle} | {$a->course}';
$string['coursesettings'] = 'Setări implicite ale cursului';
$string['coursesmovedout'] = 'Cursuri mutate din {$a}';
$string['coursespending'] = 'Cursuri în așteptarea aprobării';
$string['coursestart'] = 'Începutul cursului';
$string['coursesummary'] = 'Rezumatul cursului';
$string['coursesummary_help'] = 'O scurtă descriere a cursului tău. Conținutul pe care îl adaugi aici poate fi căutat și indexat.';
$string['coursetitle'] = 'Curs: {$a->course}';
$string['coursetitlebulkediting'] = 'Editare în masă a cursului: {$a->course}';
$string['coursetitleediting'] = 'Editează cursul: {$a->course}';
$string['courseupdates'] = 'Actualizări curs';
$string['coursevisibility'] = 'Vizibilitate curs';
$string['coursevisibility_help'] = '* Afișare: Cursul apare în lista de cursuri iar cursanții îl pot accesa.
* Ascunde: Accesul este restricționat pentru profesori și alți utilizatori cu capacitatea de a vedea cursuri ascunse.';
$string['create'] = 'Creează';
$string['createaccount'] = 'Creează noul meu cont';
$string['createcategory'] = 'Creează categorie';
$string['createfolder'] = 'Creează un fișier în {$a}';
$string['createnew'] = 'Creează nou';
$string['createnewcategory'] = 'Creează categorie nouă';
$string['createnewcourse'] = 'Creează curs nou';
$string['createnewsubcategory'] = 'Creează subcategorie nouă';
$string['createsubcategoryof'] = 'Creează subcategoria {$a}';
$string['createuser'] = 'Creează utilizator';
$string['createziparchive'] = 'Creează arhivă zip';
$string['creatingblocks'] = 'Crearea blocurilor';
$string['creatingblocksroles'] = 'Crearea alocărilor și a suprascrierilor de roluri la nivel de bloc';
$string['creatingblogsinfo'] = 'Crearea informațiilor despre bloguri';
$string['creatingcategoriesandquestions'] = 'Crearea de categorii și întrebări';
$string['creatingcoursemodules'] = 'Crearea modulelor de curs';
$string['creatingcourseroles'] = 'Crearea atribuțiilor și a suprascrierilor de poziție la nivel de curs';
$string['creatingevents'] = 'Crearea evenimentelor';
$string['creatinggradebook'] = 'Crearea catalogului';
$string['creatinggroupings'] = 'Crearea grupărilor';
$string['creatinggroupingsgroups'] = 'Adăugarea grupurilor în grupări';
$string['creatinggroups'] = 'Crearea grupurilor';
$string['creatinglogentries'] = 'Crearea intrărilor în jurnal';
$string['creatingmessagesinfo'] = 'Crearea informațiilor despre mesaje';
$string['creatingmodroles'] = 'Crearea atribuțiilor și a suprascrierilor de poziție la nivel de modul';
$string['creatingnewcourse'] = 'Crearea cursurilor noi';
$string['creatingrolesdefinitions'] = 'Crearea definițiilor rolurilor';
$string['creatingscales'] = 'Crearea de scale';
$string['creatingsections'] = 'Crearea secțiunilor';
$string['creatingtemporarystructures'] = 'Crearea structurilor temporare';
$string['creatinguserroles'] = 'Crearea atribuțiilor și a suprascrierilor de poziție la nivel de utilizator';
$string['creatingusers'] = 'Crearea utilizatorilor';
$string['creatingxmlfile'] = 'Crearea fișierelor XML';
$string['currency'] = 'Valabilitate';
$string['currentcourse'] = 'Curs curent';
$string['currentcourseadding'] = 'Cursul curent, adăugând date la acesta';
$string['currentcoursedeleting'] = 'Cursul curent, ștergându-l mai întâi';
$string['currentlanguage'] = 'Limba curentă';
$string['currentlocaltime'] = 'ora locală curentă';
$string['currentpicture'] = 'Imaginea curentă';
$string['currentrelease'] = 'Informații actuale despre versiune';
$string['currenttheme'] = 'Tema actuală';
$string['currentversion'] = 'Versiune curentă';
$string['databasechecking'] = 'Actualizarea bazei de date Moodle de la versiunea {$a->oldversion} la versiunea {$a->newversion}';
$string['databaseperformance'] = 'Performanța bazei de date';
$string['databasesetup'] = 'Configurarea bazei de date';
$string['databasesuccess'] = 'Baza de date a fost actualizată cu succes';
$string['databaseupgradebackups'] = 'Versiunea backup este acum {$a}';
$string['databaseupgradeblocks'] = 'Versiunea backup este acum {$a}';
$string['databaseupgradegroups'] = 'Versiunea grupului este acum {$a}';
$string['databaseupgradelocal'] = 'Versiunea de personalizare a bazei de date locale este acum {$a}';
$string['databaseupgrades'] = 'Actualizarea bazei de date';
$string['dataformats'] = 'Formate de date';
$string['date'] = 'Date';
$string['datechanged'] = 'Modificarea datelor';
$string['datemostrecentfirst'] = 'Date - cele mai recente';
$string['datemostrecentlast'] = 'Date - cele mai vechi';
$string['day'] = 'zi';
$string['days'] = 'zile';
$string['decodinginternallinks'] = 'Decodarea link-urilor interne';
$string['default'] = 'Implicit';
$string['defaultcategoryname'] = 'Categoria 1';
$string['defaultcompetencescale'] = 'Scala implicită de competență';
$string['defaultcompetencescaledesc'] = 'O scală de evaluare binară care nu furnizează alte informații dacă cineva a demonstrat pro-eficiența sau nu';
$string['defaultcompetencescalenotproficient'] = 'Nu este competent încă';
$string['defaultcompetencescaleproficient'] = 'Competent';
$string['defaultcoursestudent'] = 'Cursant';
$string['defaultcoursestudentdescription'] = 'Cursanții au, în general, mai puține privilegii în cadrul unui curs.';
$string['defaultcoursestudents'] = 'Cursanți';
$string['defaultcoursesummary'] = 'Scrieți aici un paragraf concis și interesant, care să explice despre ce este acest curs';
$string['defaultcourseteacher'] = 'Formator';
$string['defaultcourseteacherdescription'] = 'Profesorii pot face orice activitate în cadrul unui curs, inclusiv schimbarea activităților și notarea elevilor.';
$string['defaultcourseteachers'] = 'Formatori';
$string['defaulteditor'] = 'Editor implicit';
$string['defaulthomepageuser'] = 'Pagina principală';
$string['defaulthomepageuser_help'] = 'La ce pagină ar trebui să fiți redirecționat după ce vă conectați la site?';
$string['delete'] = 'Șterge';
$string['deleteablock'] = 'Șterge un bloc';
$string['deleteall'] = 'Șterge tot';
$string['deleteallcannotundo'] = 'Ștergeți tot - nu poate fi anulat';
$string['deleteallcomments'] = 'Toate comentariile';
$string['deleteallratings'] = 'Toate evaluările';
$string['deletecategory'] = 'Șterge categorie: {$a}';
$string['deletecategorycheck'] = 'Sunteți sigur că doriți să ștergeți în întregime această categorie <b>"{$a}"</b>?<br />Aceasta va muta toate cursurile în categoria părinte, dacă există una, sau în Diverse.';
$string['deletecategorycheck2'] = 'Dacă ștergeți această categorie, trebuie să alegeți ce veți face cu toate cursurile și subcategoriile pe care le conține.';
$string['deletecategoryempty'] = 'Această categorie este goală.';
$string['deletecheck'] = 'Ștergeți {$a} ?';
$string['deletecheckfiles'] = 'Sunteți absolut sigur că doriți să ștergeți aceste fișiere?';
$string['deletecheckfull'] = 'Sunteți absolut sigur că doriți să ștergeți complet utilizatorul {$a}, inclusiv înscrierile, activitatea și alte date ale acestuia?';
$string['deletechecktype'] = 'Sunteți sigur că doriți să ștergeți această {$a->type}?';
$string['deletechecktypename'] = 'Sunteți sigur că doriți să ștergeți {$a->type} "{$a->name}"?';
$string['deletecheckwarning'] = 'Urmează să ștergeți aceste fișiere';
$string['deletecommentbyon'] = 'Șterge comentariul postat de {$a->user} pe {$a->time}';
$string['deletecompletely'] = 'Șterge complet';
$string['deletecourse'] = 'Șterge un curs';
$string['deletecoursecheck'] = 'Sunteți absolut sigur că doriți să ștergeți complet acest curs și toate datele pe care le conține?';
$string['deleted'] = 'Șters';
$string['deletedactivity'] = 'A fost șters {$a}';
$string['deletedcourse'] = '{$a} a fost complet șters';
$string['deletednot'] = 'Nu a putu fi șters {$a} !';
$string['deletepicture'] = 'Șterge imaginea';
$string['deletesection'] = 'Șterge';
$string['deleteselected'] = 'Șterge selecția';
$string['deleteselectedkey'] = 'Șterge cheia selectată';
$string['deletingcourse'] = 'Ștergere {$a}';
$string['deletingexistingcoursedata'] = 'Ștergerea datelor de curs existente';
$string['deletingolddata'] = 'Ștergerea datelor mai vechi';
$string['department'] = 'Departament';
$string['deprecatedeventname'] = '{$a} (nu mai este utilizat)';
$string['desc'] = 'Descrescător';
$string['description'] = 'Descriere';
$string['deselectall'] = 'Deselectează tot';
$string['deselectnos'] = 'Deselectați tot ce a fost selectat "Nu"';
$string['detailedless'] = 'Detaliat mai puțin';
$string['detailedmore'] = 'Detaliat mai mult';
$string['details'] = 'Detalii';
$string['digitalminor'] = 'Minor digital';
$string['digitalminor_desc'] = 'Părintele/tutorele dumneavoastră trebuie să contacteze următoarea persoană:';
$string['directory'] = 'Directorul';
$string['disable'] = 'Dezactivat';
$string['disabledcomments'] = 'Comentariile sunt dezactivate';
$string['dismissnotification'] = 'Închideți această notificare';
$string['displayingfirst'] = 'Numai primele {$a->count} {$a->things} sunt afișate';
$string['displayingrecords'] = 'Afișarea {$a} înregistrărilor';
$string['displayingusers'] = 'Afișarea utilizatorilor {$a->start} la {$a->end}';
$string['displayonpage'] = 'Afișarea pe pagină';
$string['dndcourse'] = 'Puteți trage și plasa acest curs, pentru a modifica sortarea acestuia sau pentru a-l muta în altă categorie.';
$string['dndenabled_inbox'] = 'Puteți trage și plasa fișiere aici, pentru a le adăuga.';
$string['dndnotsupported'] = 'Nu este acceptată încărcarea prin tragere și plasare';
$string['dndnotsupported_help'] = 'Browserul dvs. nu acceptă încărcare prin glisare și plasare. Această caracteristică este disponibilă în toate versiunile recente de Chrome, Firefox și Safari, precum și Internet Explorer v10 și versiunile ulterioare.';
$string['dndnotsupported_insentence'] = 'tragerea și plasarea nu sunt acceptate';
$string['dnduploadwithoutcontent'] = 'Această încărcare nu are conținut';
$string['dndworkingfile'] = 'Trageți și plasați fișierele în secțiunile cursului pentru a le încărca';
$string['dndworkingfilelink'] = 'Trageți și plasați fișierele sau link-urile în secțiunile cursului pentru a le încărca';
$string['dndworkingfiletext'] = 'Trageți și plasați fișierele sau textele în secțiunile cursului pentru a le încărca';
$string['dndworkingfiletextlink'] = 'Trageți și plasați fișierele, textele sau link-urile în secțiunile cursului pentru a le încărca';
$string['dndworkinglink'] = 'Trageți și plasați link-urile în secțiunile cursului pentru a le încărca';
$string['dndworkingtext'] = 'Trageți și plasați textele în secțiunile cursului pentru a le încărca';
$string['dndworkingtextlink'] = 'Trageți și plasați textele sau link-urile în secțiunile cursului pentru a le încărca';
$string['documentation'] = 'Documentația Moodle';
$string['dontsortcategories'] = 'Nu sorta categoriile';
$string['dontsortcourses'] = 'Nu sorta cursurile';
$string['down'] = 'Jos';
$string['download'] = 'Descarcă';
$string['downloadall'] = 'Descarcă tot';
$string['downloadexcel'] = 'Descarcă în format Excel';
$string['downloadfile'] = 'Descarcă fișier';
$string['downloadods'] = 'Descarcă în format ODS';
$string['downloadtext'] = 'Descarcă în format text';
$string['doyouagree'] = 'Ați citit și înțeles aceste condiții?';
$string['droptoupload'] = 'Plasați fișierele aici, pentru a le încărca';
$string['duplicate'] = 'Duplicat';
$string['duplicatedmodule'] = '{$a} (copie)';
$string['duplicatedsection'] = '{$a} (copy)';
$string['edhelpaspellpath'] = 'Pentru a utiliza verificarea ortografică în editor, TREBUIE să aveți instalat pe serverul dumneavoastră <strong>aspell 0.50</strong> sau mai recent și trebuie să specificați calea corectă, pentru a accesa binarul aspell.  Această cale este de obicei <strong>/usr/bin/aspell</strong> sau alta pe sistemele Unix / Linux.';
$string['edhelpbgcolor'] = 'Definește culoarea fundalului zonelor de editare .<br />Valorile valabile sunt, de exemplu: #FFFFFF or white';
$string['edhelpcleanword'] = 'Această setare activează sau dezactivează filtrarea formatului specific Word.';
$string['edhelpenablespelling'] = 'Activați sau dezactivați verificarea ortografică. Când este activat, <strong>aspell</strong> trebuie instalat pe server. Valoarea secundară este <strong>default dictionary</strong>. Această valoare va fi utilizată dacă aspell nu are dicționar pentru limba proprie a utilizatorilor.';
$string['edhelpfontfamily'] = 'Proprietatea familie font este o listă de nume de familie de fonturi și/ sau nume de familie generice. Numele de familie trebuie separate prin virgulă.';
$string['edhelpfontlist'] = 'Definiți fonturile utilizate în meniul derulant al editorilor.';
$string['edhelpfontsize'] = 'Dimensiunea implicită a fontului setează dimensiunea unui font. <br />Valori valabile sunt, de exemplu: mediu, mare, mai mic, mai mare, 10pt, 11px.';
$string['edit'] = 'Editează';
$string['edita'] = 'Editează {$a}';
$string['editcategorysettings'] = 'Editează setările categoriei';
$string['editcategorythis'] = 'Editează această categorie';
$string['editcoursesettings'] = 'Editează setările cursului';
$string['editfiles'] = 'Editează fișierele';
$string['editgroupprofile'] = 'Editează descrierea grupului';
$string['editingteachershort'] = 'Editor';
$string['editlock'] = 'Această valoare nu poate fi editată!';
$string['editmode'] = 'Mod de editare';
$string['editmyprofile'] = 'Editează profilul';
$string['editorbgcolor'] = 'Culoarea fundalului';
$string['editorcleanonpaste'] = 'Curățați Word HTML la lipire';
$string['editorcommonsettings'] = 'Setări generale';
$string['editordefaultfont'] = 'Font implicit';
$string['editorenablespelling'] = 'Activează corectorul ortogafic';
$string['editorfontlist'] = 'Listă cu fonturile';
$string['editorfontsize'] = 'Dimensiune implicită a fontului';
$string['editorpreferences'] = 'Opțiuni pentru editor';
$string['editorresettodefaults'] = 'Restaurează valorile implicite';
$string['editorsettings'] = 'Setările editorului';
$string['editorshortcutkeys'] = 'Combinaţii de taste pentru editor';
$string['editsection'] = 'Editare setări';
$string['editsectionname'] = 'Editează numele secțiunii';
$string['editsectionsettings'] = 'Editați setările secțiunii';
$string['editsectiontitle'] = 'Editare secțiunea: {$a}';
$string['editsettings'] = 'Editează setările';
$string['editthisactivity'] = 'Editează această activitate';
$string['editthiscategory'] = 'Editează această categorie';
$string['edittitle'] = 'Editează titlul';
$string['edittitleinstructions'] = 'Apăsați Escape pentru a anula și Enter când ați terminat';
$string['edituser'] = 'Editează conturile utilizatorului';
$string['edulevel'] = 'Toate evenimetele';
$string['edulevel_help'] = '* Predare - acțiuni realizate de un formator, de exemplu, actualizarea unei resurse
* Participare - acțiuni efectuate de un elev, de exemplu, postarea pe un forum
* Altele - acțiuni efectuate de un utilizator cu o altă poziție decât profesor sau elev';
$string['edulevelother'] = 'Altele';
$string['edulevelparticipating'] = 'Participare';
$string['edulevelteacher'] = 'Predare';
$string['email'] = 'Adresa de e-mail';
$string['emailactive'] = 'E-mail activat';
$string['emailagain'] = 'E-mail (din nou)';
$string['emailalreadysent'] = 'A fost transmis deja un e-mail de resetare a parolei. Vă rugăm să vă verificați e-mailul.';
$string['emailcharset'] = 'Set de caractere prin e-mail';
$string['emailconfirm'] = 'Confirmați contul dumneavoastră';
$string['emailconfirmation'] = 'Bună ziua {$a->firstname},

Un nou cont a fost solicitat pe "{$a->sitename}"
utilizând adresa dumneavoastră de e-mail.

Pentru a vă confirma noul cont, te rugăm să accesezi această adresă web:

{$a->link}

În majoritatea programelor de e-mail, ar trebui să apară sub forma unui link de culoare albastră
pe care puteți să dați click. Dacă nu funcționează,
atunci faceți copy-paste în bara de adrese a ferestrei browser-ului web.

Dacă aveți nevoie de asistență, vă rugăm să contactați administratorul site-ului,
{$a->admin}';
$string['emailconfirmationresend'] = 'Retrimite email-ul de confirmare';
$string['emailconfirmationsubject'] = '{$a}: confirmare cont';
$string['emailconfirmsent'] = '<p>A fost transmis un e-mail pe adresa dumneavoastră de pe <b>{$a}</b></p>
   <p>Conține instrucțiuni simple pentru a finaliza înregistrarea.</p>
   <p>Dacă întâmpinați dificultăți, vă rugăm să contactați administratorul site-ului.</p>';
$string['emailconfirmsentfailure'] = 'Nu s-a trimis mail-ul de confirmare';
$string['emailconfirmsentsuccess'] = 'S-a trimis mail-ul de confirmare';
$string['emaildigest'] = 'Tipul de rezumat al e-mailului';
$string['emaildigest_help'] = 'Aceasta este setarea zilnică de rezumat pe care forumurile o vor folosi în mod prestabilit.

* Fără rezumat - veți primi un e-mail pentru fiecare postare pe forum;
* Rezumat - postări complete - veți primi zilnic un e-mail de rezumat care include conținutul complet al fiecărei postări pe forum;
* Rezumat - numai subiecte - veți primi zilnic un e-mail de rezumat care conține doar subiectul fiecărei postări pe forum.

De asemenea, puteți alege o setare diferită pentru fiecare forum, dacă doriți.';
$string['emaildigestcomplete'] = 'Complet (e-mail zilnic cu postări complete)';
$string['emaildigestoff'] = 'Fără rezumat (e-mail unic pentru fiecare postare pe forum)';
$string['emaildigestsubjects'] = 'Subiecte (e-mail zilnic numai cu subiecte)';
$string['emaildisable'] = 'Această adresă de e-mail este dezactivată';
$string['emaildisableclick'] = 'Faceți click aici, pentru a dezactiva trimiterea tuturor e-mailurilor la această adresă';
$string['emaildisplay'] = 'Vizibilitate e-mail';
$string['emaildisplay_help'] = '* Ascuns - Doar utilizatorii cu permisiunile adecvate, de exemplu, profesorii, pot vedea adresa ta de e-mail.
* Vizibil pentru toți participanții - Toți utilizatorii de pe site pot vedea adresa ta de e-mail.
* Vizibil pentru participanții la curs - Doar participanții la cursurile la care ești înscris pot vedea adresa ta de e-mail.';
$string['emaildisplaycourse'] = 'Vizibilă pentru participanții la curs';
$string['emaildisplaycoursemembersonly'] = '(Vizibil pentru alți participanți la curs)';
$string['emaildisplayeveryone'] = '(Vizibil pentru toată lumea)';
$string['emaildisplayhide'] = '(Ascuns pentru toți participanții cu excepția utilizatorilor cu permisiuni adecvate)';
$string['emaildisplayno'] = 'Ascunsă';
$string['emaildisplayyes'] = 'Vizibilă pentru toți participanții';
$string['emailenable'] = 'Această adresă de e-mail este activată';
$string['emailenableclick'] = 'Faceți click aici, pentru a reactiva toate e-mailurile trimise la această adresă';
$string['emailexists'] = 'Această adresă de e-mail este deja înregistrată.';
$string['emailexistshintlink'] = 'Recuperați numele de utilizator sau parola uitate';
$string['emailexistssignuphint'] = 'Este posibil să fi creat anterior un cont? {$a}';
$string['emailformat'] = 'Format e-mail';
$string['emailmustbereal'] = 'Notă: adresa dumneavoastră de e-mail trebuie să fie una reală';
$string['emailnotallowed'] = 'Adresele de e-mail din aceste domenii nu sunt permise ({$a})';
$string['emailnotfound'] = 'Adresa de e-mail nu a fost găsită în baza de date';
$string['emailonlyallowed'] = 'Acest email nu poate fi folosit. Domeniile de email acceptate sunt: {$a}.';
$string['emailpasswordchangeinfo'] = 'Bună {$a->firstname},

Cineva (probabil dvs.) a solicitat o nouă parolă pentru
contul „{$a->username}” din „{$a->sitename}”.

Pentru a vă schimba parola, accesați următoarea adresă web:

{$a->link}

În majoritatea programelor de e-mail, aceasta ar trebui să apară ca o legătură albastră
pe care puteți doar să faceți clic. Dacă asta nu funcționează,
apoi tăiați și lipiți adresa în adresă
linie în partea de sus a ferestrei browserului web.

Dacă aveți nevoie de ajutor, vă rugăm să contactați administratorul site-ului,
{$a->admin}';
$string['emailpasswordchangeinfodisabled'] = 'Bună {$a->firstname},

Cineva (probabil dvs.) a solicitat o nouă parolă pentru contul dvs. pe „{$a->sitename}”.

Din păcate, contul dvs. de pe acest site este dezactivat, deci parola nu poate fi resetată. Vă rugăm să contactați administratorul site-ului {$a->admin}.';
$string['emailpasswordchangeinfofail'] = 'Bună {$a->firstname},

Cineva (probabil dvs.) a solicitat o nouă parolă pentru contul dvs. pe „{$a->sitename}”.

Din păcate, parolele nu pot fi resetate pe acest site.

Vă rugăm să contactați administratorul site-ului {$a->admin}.';
$string['emailpasswordchangeinfosubject'] = '{$a}: Schimbați informațiile despre parolă';
$string['emailpasswordconfirmation'] = 'Bună ziua {$a->firstname},

Cineva (probabil dumneavoastră) a solicitat o nouă parolă pentru contul dumneavoastră pe "{$a->sitename}".

Pentru a confirma acest lucru și pentru a vi se trimite o nouă
parolă prin e-mail,accesați următoarea adresă web

{$a->link}

În majoritatea programelor de e-mail, aceasta ar trebui să apară sub forma unui link de culoare albastră
pe care puteți să faceți click. Dacă nu funcționează,
tăiați și lipiți adresa în linia
din partea superioară a ferestrei browserului web.

Dacă aveți nevoie de asistență, vă rugăm să contactați administratorul site-ului,
{$a->admin}';
$string['emailpasswordconfirmationsubject'] = '{$a}:
Schimbați confirmarea parolei';
$string['emailpasswordconfirmmaybesent'] = '<p>Dacă ați furnizat un nume de utilizator sau o adresă de e-mail unică, ar fi trebuit să vi se trimită un e-mail.</p>
   <p>Conține instrucțiuni simple pentru confirmarea și completarea acestei modificări de parolă.
Dacă aveți în continuare dificultăți, vă rugăm să contactați administratorul site-ului.</p>';
$string['emailpasswordconfirmnoemail'] = '<p>Contul de utilizator specificat nu are o adresă de e-mail înregistrată.</p>
   <p>Vă rugăm să contactați administratorul site-ului.</p>';
$string['emailpasswordconfirmnotsent'] = '<p>Detaliile utilizatorului, pe care le-ați furnizat, nu identifică un cont de utilizator existent.</p>
   <p>Vă rugăm să verificați informațiile pe care le-ați introdus, apoi încercați din nou.
Dacă aveți în continuare dificultăți, vă rugăm să contactați administratorul site-ului.</p>';
$string['emailpasswordconfirmsent'] = 'Ar fi trebuit să vi se trimită un e-mail pe adresa <b>{$a}</b>.
<br />Conține instrucțiuni simple pentru confirmarea și completarea acestei modificări de parolă.
Dacă aveți în continuare dificultăți, vă rugăm să contactați administratorul site-ului.';
$string['emailresetconfirmation'] = 'Bună ziua {$a->firstname},

A fost solicitată resetarea parolei contului tău "{$a->username}" la {$a->sitename}.

Pentru a confirma această solicitare și a seta o nouă parolă pentru contul tău, te rugăm să accesezi următoarea adresă web:
<a href="{$a->link}">{$a->link}</a>

(Acest link este valabil pentru {$a->resetminutes} minute din momentul în care această resetare a fost solicitată pentru prima dată)

Dacă această resetare a parolei nu a fost solicitată de către tine, nu este necesară nicio acțiune.

Dacă ai nevoie de ajutor, te rugăm să contactezi administratorule site-ului , {$a->admin}';
$string['emailresetconfirmationsubject'] = '{$a}: Solicitare de resetare a parolei';
$string['emailresetconfirmsent'] = 'Un e-mail a fost transmis pe adresa dumneavoastră la <b>{$a}</b>.
<br />Conține instrucțiuni simple pentru confirmarea și completarea acestei modificări de parolă.
Dacă aveți în continuare dificultăți, vă rugăm să contactați administratorul site-ului.';
$string['emailstop'] = 'Dezactivați notificările';
$string['emailtoprivatefiles'] = 'Puteți, de asemenea, să trimiteți prin e-mail fișiere ca atașamente direct în spațiul dumneavoastră de fișiere private. Pur și simplu atașați fișierele într-un e-mail și trimiteți-le la {$a}';
$string['emailtoprivatefilesdenied'] = 'Administratorul dumneavoastră a dezactivat opțiunea de a încărca propriile fișiere private.';
$string['emailvia'] = '{$a->name} (via {$a->siteshortname})';
$string['emojicategoryactivities'] = 'Activități';
$string['emojicategoryanimalsnature'] = 'Animale & natură';
$string['emojicategoryflags'] = 'Steaguri';
$string['emojicategoryfooddrink'] = 'Mâncare & băutură';
$string['emojicategoryobjects'] = 'Obiecte';
$string['emojicategorypeoplebody'] = 'Oameni și siluete';
$string['emojicategoryrecent'] = 'Recent';
$string['emojicategorysmileysemotion'] = 'Emoticoane & emoție';
$string['emojicategorysymbols'] = 'Simboluri';
$string['emojicategorytravelplaces'] = 'Călătorii & locuri';
$string['emptycmids'] = 'ID-urile modulelor de curs necompletate';
$string['emptydragdropregion'] = 'regiune goală';
$string['emptysectionids'] = 'ID-urile secțiunilor necompletate';
$string['enable'] = 'Permite';
$string['encryptedcode'] = 'Cod criptat';
$string['enddate'] = 'Data de finalizare a cursului';
$string['enddate_help'] = 'Data de încheiere nu restricționează accesul studenților la curs. Acesta determină dacă un curs este afișat ca Trecut în pagina Cursurile mele.';
$string['enddatewithtaskenabled'] = 'Data încheierii cursului';
$string['enddatewithtaskenabled_help'] = 'Data când cursul va fi ascuns pentru cursanți și nu îl vor mai putea accesa.';
$string['english'] = 'Engleză';
$string['enrolmentmethods'] = 'Metode de înscriere';
$string['entercourse'] = 'Faceți click pentru a accesa acest curs';
$string['enteremail'] = 'Introduceți adresa dumneavoastră de e-mail';
$string['enteremailaddress'] = 'Accesați adresa dumneavoastră de e-mail, pentru a reseta
   parola și pentru a primi o nouă parolă via e-mail.';
$string['enterusername'] = 'Introduceți numele dumneavoastră de utilizator';
$string['entries'] = 'Intrări';
$string['error'] = 'Eroare';
$string['errorcreatingactivity'] = 'Imposibil de creat o instanță de activitate "{$a}"';
$string['errorfiletoobig'] = 'Fișiesul a depășit limita de {$a} biți';
$string['errornouploadrepo'] = 'Nu există niciun depozit de încărcare activat pentru acest site';
$string['errorwhenconfirming'] = 'Nu sunteți încă confirmat, deoarece a apărut o eroare. Dacă ați făcut click pe un link dintr-un e-mail, pentru a ajunge aici, asigurați-vă că linia din e-mail nu a fost distrusă. Probabil va trebui să utilizați tăierea și lipirea, pentru a reconstrui corect link-ul.';
$string['eventcommentcreated'] = 'Comentariu creat';
$string['eventcommentdeleted'] = 'Comentariu șters';
$string['eventcommentsviewed'] = 'Comentariu vizualizat';
$string['eventconfiglogcreated'] = 'A fost creat un fișier de jurnalizare a configurărilor';
$string['eventcontentviewed'] = 'Conținut vizualizat';
$string['eventcoursebackupcreated'] = 'Backup curs creat';
$string['eventcoursecategorycreated'] = 'Categorie creată';
$string['eventcoursecategorydeleted'] = 'Categorie ștearsă';
$string['eventcoursecategoryupdated'] = 'Categorie actualizată';
$string['eventcoursecategoryviewed'] = 'Categorie vizualizată';
$string['eventcoursecontentdeleted'] = 'Conținut curs șters';
$string['eventcoursecreated'] = 'Curs creat';
$string['eventcoursedeleted'] = 'Curs șters';
$string['eventcourseended'] = 'Curs încheiat';
$string['eventcourseinformationviewed'] = 'Rezumatul cursului vizualizat';
$string['eventcoursemodulecreated'] = 'Modul curs creat';
$string['eventcoursemoduledeleted'] = 'Modul curs șters';
$string['eventcoursemoduleinstancelistviewed'] = 'Lista sesiunilor modulului de curs vizualizată';
$string['eventcoursemoduleupdated'] = 'Modul curs actualizat';
$string['eventcoursemoduleviewed'] = 'Modul curs vizualizat';
$string['eventcourseresetended'] = 'Resetarea cursului a fost finalizată';
$string['eventcourseresetstarted'] = 'Resetarea cursului a fost inițiată';
$string['eventcourserestored'] = 'Curs restabilit';
$string['eventcoursesectioncreated'] = 'Secțiune curs creată';
$string['eventcoursesectiondeleted'] = 'Secțiune curs ștearsă';
$string['eventcoursesectionupdated'] = 'Secțiune curs actualizată';
$string['eventcoursessearched'] = 'Cursuri căutate';
$string['eventcoursestarted'] = 'Curs început';
$string['eventcourseupdated'] = 'Cursuri actualizate';
$string['eventcourseuserreportviewed'] = 'Raportul utilizatorului cursului vizualizat';
$string['eventcourseviewed'] = 'Curs vizualizat';
$string['eventdashboardreset'] = 'Tablou de bord resetat';
$string['eventdashboardsreset'] = 'Tablouri de bord resetate';
$string['eventdashboardviewed'] = 'Tablou de bord vizualizat';
$string['eventdatabasetextfieldcontentreplaced'] = 'Căutare în baza generală de date și înlocuire';
$string['eventemailfailed'] = 'E-mailul nu a putut fi trimis';
$string['eventmycoursesviewed'] = 'Cursurile mele vizualizate';
$string['eventname'] = 'Nume eveniment';
$string['eventrecentactivityviewed'] = 'Activitate recentă vizualizată';
$string['eventsearchindexed'] = 'Date de căutare îndexate';
$string['eventsearchresultsviewed'] = 'Rezultate de căutare vizualizate';
$string['eventsectionviewed'] = 'Secțiune vizualizată';
$string['eventunknownlogged'] = 'Eveniment necunoscut';
$string['eventurlblocked'] = 'URL-ul a fost blocat';
$string['eventusercreated'] = 'Utilizator creat';
$string['eventuserdeleted'] = 'Utilizator șters';
$string['eventuserfeedbackgiven'] = 'S-a dat click pe link-ul de feedback';
$string['eventuserfeedbackremind'] = 'Reamintește-mi mai târziu de link-ul de feedback';
$string['eventuserinfocategorycreated'] = 'Categoria de câmp a profilului utilizator creată';
$string['eventuserinfocategorydeleted'] = 'Categoria de câmp a profilului utilizator ștearsă';
$string['eventuserinfocategoryupdated'] = 'Categoria de câmp a profilului utilizator actualizată';
$string['eventuserinfofieldcreated'] = 'Câmpul profil de utilizator a fost creat';
$string['eventuserinfofielddeleted'] = 'Câmpul profil de utilizator a fost șters';
$string['eventuserinfofieldupdated'] = 'Câmpul profil de utilizator a fost actualizat';
$string['eventuserlistviewed'] = 'Listă utilizator vizualizată';
$string['eventuserloggedout'] = 'Deconectare utilizator';
$string['eventuserpasswordpolicyfailed'] = 'Parola folosită nu este conformă cu politicile de formatare a parolei din platformă';
$string['eventuserpasswordupdated'] = 'Parolă utilizator actualizată';
$string['eventuserprofileviewed'] = 'Profil utilizator vizualizat';
$string['eventuserupdated'] = 'Utilizator actualizat';
$string['everybody'] = 'Orice utilizator';
$string['executeat'] = 'Execută la';
$string['existing'] = 'Existent';
$string['existingadmins'] = 'Administrator existent';
$string['existingcourse'] = 'Curs existent';
$string['existingcourseadding'] = 'Se adaugă date la cursul existent';
$string['existingcoursedeleting'] = 'Se șterge mai întâi cursul existent';
$string['existingcreators'] = 'Creatori existenți ai cursurilor';
$string['existingstudents'] = 'Cursanți înscriși';
$string['existingteachers'] = 'Formatori existenți';
$string['expand'] = 'Extinde';
$string['expandall'] = 'Extinde toate secțiunile';
$string['expandcategory'] = 'Extinde {$a}';
$string['explanation'] = 'Explicație';
$string['explanationdigitalminor'] = 'Aceste informații sunt necesare pentru a determina dacă vârsta dumneavoastră depășește vârsta la care vă puteți da acordul online. Aceasta este vârsta la care o persoană poate fi de acord cu termenii și condițiile, iar datele sale sunt stocate și prelucrate legal.';
$string['extendperiod'] = 'Extinde perioada';
$string['extendsession'] = 'Extindeți sesiunea';
$string['failedloginattempts'] = '{$a->attempts} conectări eșuate de la ultima dumneavoastră conectare';
$string['failedtaskbody'] = '<p>Bună {$a->firstname},</p>
<p>Sarcina de lucru <b>{$a->taskname}</b> nu a fost îndeplinită cu succes de mai multe ori și trebuie să o analizați.</p>
<p><a href="{$a->link}">Vedeți sarcina de lucru</a></p>';
$string['failedtaskcontexturlname'] = 'Status raport';
$string['failedtasksubject'] = 'Task eșuat: {$a}';
$string['favourites'] = 'Evidențiate';
$string['feedback'] = 'Feedback';
$string['file'] = 'Fișier';
$string['fileexists'] = 'Există deja un fișier cu numele {$a}';
$string['filemissing'] = '{$a} lipsește';
$string['filereaderror'] = 'Fișierul "{$a}" nu a putu fi citit. Vă rugăm să verificați dacă este într-adevăr un fișier și nu un folder.';
$string['files'] = 'Fișiere';
$string['filesanduploads'] = 'Fișiere și încărcări';
$string['filesfolders'] = 'Fișiere/ foldere';
$string['fileuploadwithcontent'] = 'Încărcările de fișiere nu trebuie să includă parametrul de conținut';
$string['filloutallfields'] = 'Vă rugăm să completați toate câmpurile din acest formular';
$string['filter'] = 'Filtru';
$string['filteroption'] = '{$a->criteria}: {$a->value}';
$string['filterrowlegend'] = 'Filtru {$a}';
$string['filters'] = 'Filtre';
$string['filtersetmatchdescription'] = 'Cum ar trebui combinate mai multe filtre';
$string['filtertype'] = 'Tipul de filtru';
$string['findmorecourses'] = 'Găsește mai multe cursuri...';
$string['first'] = 'Primul';
$string['firstaccess'] = 'Primul acces';
$string['firstname'] = 'Prenume';
$string['firstnamephonetic'] = 'Prenume - fonetic';
$string['firstpage'] = 'Prima pagină';
$string['firstsiteaccess'] = 'Primul acces la site';
$string['firsttime'] = 'Este prima dată când ajungeți aici?';
$string['folder'] = 'Folder';
$string['folderclosed'] = 'Folder închis';
$string['folderopened'] = 'Folder deschis';
$string['followingoptional'] = 'Următoarele elemente sunt opționale';
$string['followingrequired'] = 'Următoarele elemente sunt obligatorii';
$string['for'] = 'Pentru';
$string['force'] = 'Impunere';
$string['forcelanguage'] = 'Limbă impusă';
$string['forceno'] = 'Nu impune';
$string['forcepasswordchange'] = 'Modificare impusă a parolei';
$string['forcepasswordchange_help'] = 'Dacă este bifată această casetă, utilizatorului i se va solicita să își schimbe parola la următoarea autentificare';
$string['forcepasswordchangecheckfull'] = 'Sunteți absolut sigur că doriți să impuneți modificarea parolei la {$a} ?';
$string['forcepasswordchangenot'] = 'Nu a putut fi impusă modificarea parolei {$a}';
$string['forcepasswordchangenotice'] = 'Pentru a continua, trebuie să vă modificați parola.';
$string['forcepasswordresetfailurenotice'] = 'Parola dvs. curentă nu mai trece politica de parolă setată. Vă rugăm să contactați administratorul Moodle pentru asistență.
{$a}';
$string['forcepasswordresetnotice'] = 'Parola dvs. curentă nu mai corespunde politicii de securitate, trebuie să resetați parola de autentificare.
{$a}';
$string['forcetheme'] = 'Temă impusă';
$string['forgotaccount'] = 'Ați pierdut parola?';
$string['forgotten'] = 'Ați uitat numele de utilizator sau parola?';
$string['forgottenduplicate'] = 'Adresa de e-mail este partajată de mai multe conturi; vă rugăm să introduceți numele de utilizator';
$string['forgotteninvalidurl'] = 'Adresa URL de resetare a parolei nu este validă';
$string['format'] = 'Format';
$string['formathtml'] = 'Format HTML';
$string['formatmarkdown'] = 'Format redus';
$string['formatplain'] = 'Format text simplu';
$string['formattext'] = 'Format automat Moodle';
$string['forumpreferences'] = 'Preferințe forum';
$string['framesetinfo'] = 'Acest set de documente conține:';
$string['fromdate'] = 'De la';
$string['fromsender'] = 'De la';
$string['frontpagecategorycombo'] = 'Lista combo';
$string['frontpagecategorynames'] = 'Lista de categorii';
$string['frontpagecourselist'] = 'Lista de cursuri';
$string['frontpagecoursesearch'] = 'Caseta de căutare a cursului';
$string['frontpagedescription'] = 'Rezumat prima pagină';
$string['frontpagedescriptionhelp'] = 'Acest rezumat poate fi afișat pe prima pagină folosind blocul de rezumat al cursului/site-ului.';
$string['frontpageenrolledcourselist'] = 'Cursuri înscrise';
$string['frontpageformat'] = 'Format prima pagină';
$string['frontpageformatloggedin'] = 'Formatul de pornire al site-ului când v-ați autentificat';
$string['frontpagenews'] = 'Anunțuri';
$string['frontpagesettings'] = 'Setări prima pagină';
$string['fulllistofcourses'] = 'Toate cursurile';
$string['fullname'] = 'Nume complet';
$string['fullnamecourse'] = 'Denumirea completă a cursului';
$string['fullnamecourse_help'] = 'Denumirea afișată în Cursurile mele și în lista cursurilor disponibile pe pagina principală.';
$string['fullnamedisplay'] = '{$a->firstname} {$a->lastname}';
$string['fullnameuser'] = 'Numele complet al utilizatorului';
$string['fullprofile'] = 'Profil complet';
$string['fullsitename'] = 'Numele complet al site-ului';
$string['functiondisabled'] = 'Funcționalitatea respectivă este dezactivată în prezent';
$string['general'] = 'General';
$string['geolocation'] = 'latitudine - longitudine';
$string['gettheselogs'] = 'Obține aceste jurnale';
$string['go'] = 'Mergi';
$string['gobacktosite'] = 'Mergi înapoi la curs';
$string['gpl'] = 'Drepturi de autor (C) 1999 și până în prezent Martin Dougiamas (https://moodle.com)

Acest program este software gratuit; îl poți redistribui și/sau modifica în condițiile licenței publice generale GNU publicate de Free Software Foundation; fie versiunea 2 a licenței, fie (la alegerea ta) orice versiune ulterioară.

Acest program este distribuit în speranța că va fi util, dar FĂRĂ NICIO GARANȚIE; chiar fără garanția implicită a VANDABILITĂȚII sau ADECVĂRII PENTRU UN SCOP PARTICULAR.

Consultă pagina cu informații despre licența Moodle pentru detalii complete: https://moodledev.io/general/license';
$string['gpl3'] = 'Drepturi de autor (C) 1999 și până în prezent Martin Dougiamas (https://moodle.com)

Acest program este software gratuit: îl puteți redistribui și / sau modifica în condițiile licenței publice generale GNU publicate de Free Software Foundation, fie versiunea 3 a licenței, fie (la alegerea dvs.) orice versiune ulterioară.

Acest program este distribuit în speranța că va fi util, dar FĂRĂ NICIO GARANȚIE; fără măcar garanția implicită a VANDABILITĂȚII sau ADECVĂRII PENTRU UN SCOP PARTICULAR.

Consultați pagina cu informații despre licența Moodle pentru detalii complete: https://moodledev.io/general/license';
$string['gpllicense'] = 'Licență GPL';
$string['gradenoun'] = 'Notă';
$string['grades'] = 'Note';
$string['gradeverb'] = 'Notă';
$string['gravatarenabled'] = '<a href="https://www.gravatar.com/"> Gravatar </a> a fost activat pentru acest site. Dacă nu încărcați o imagine de profil, Moodle va încerca să vă încarce o imagine de profil din Gravatar.';
$string['group'] = 'Grup';
$string['groupadd'] = 'Adaugă grup nou';
$string['groupaddusers'] = 'Adăugați selecția la grup';
$string['groupfor'] = 'pentru grup';
$string['groupinfo'] = 'Informații privind grupul selecționat';
$string['groupinfoedit'] = 'Editează setările grupului';
$string['groupinfomembers'] = 'Informații privind membrii selectați';
$string['groupinfopeople'] = 'Informații privind persoanele selectate';
$string['groupmembers'] = 'Membrii grupului';
$string['groupmemberssee'] = 'Vizualizați membrii grupului';
$string['groupmembersselected'] = 'Membrii grupului selectat';
$string['groupmode'] = 'Mod grup';
$string['groupmodeforce'] = 'Impune mod grup';
$string['groupmy'] = 'Grupul meu';
$string['groupnonmembers'] = 'Persoane care nu fac parte dintr-un grup';
$string['groupnotamember'] = 'Ne pare rău, nu sunteți membru al acelui grup';
$string['grouprandomassign'] = 'Alocare aleatorie a tuturor la grup';
$string['groupremove'] = 'Elimină grupul selectat';
$string['groupremovemembers'] = 'Elimină membrii selectați';
$string['groups'] = 'Grupuri';
$string['groupsnone'] = 'Niciun grup';
$string['groupsseparate'] = 'Grupuri separate';
$string['groupsvisible'] = 'Grupuri vizibile';
$string['guest'] = 'Vizitator';
$string['guestdescription'] = 'Vizitatorii au privilegii minime și, de obicei, nu pot introduce text nicăieri.';
$string['guestskey'] = 'Permiteți vizitatori care au cheia';
$string['guestsno'] = 'Nu permiteți accesul vizitatorilor';
$string['guestsnotallowed'] = 'Ne pare rău, "{$a}" nu este permis accesul vizitatorilor.';
$string['guestsyes'] = 'Permiteți vizitatorilor care nu au cheia';
$string['guestuser'] = 'Utilizator vizitator';
$string['guestuserinfo'] = 'Acest utilizator este unul special care permite accesul la unele cursuri numai în modul "citire".';
$string['help'] = 'Asistență';
$string['helpprefix2'] = 'Asistență {$a}';
$string['helpwiththis'] = 'Asistență cu aceasta';
$string['hiddenassign'] = 'Alocare ascunsă';
$string['hiddenfromstudents'] = 'Ascuns de cursanți';
$string['hiddenoncoursepage'] = 'Disponibil, dar neafișat pe pagina cursului';
$string['hiddensections'] = 'Secțiuni ascunse';
$string['hiddensections_help'] = 'Secțiunile ascunse pot fi afișate studenților ca „nedisponibile” pe pagina cursului sau pot fi complet ascunse.';
$string['hiddensectionscollapsed'] = 'Secțiunile ascunse sunt afișate ca nefiind disponibile';
$string['hiddensectionsinvisible'] = 'Secțiunile ascunse sunt complet invizibile';
$string['hiddenwithbrackets'] = '(ascuns)';
$string['hide'] = 'Ascunde';
$string['hideadvancedsettings'] = 'Ascunde setările avansate';
$string['hidechartdata'] = 'Ascunde datele graficului';
$string['hidefromstudents'] = 'Ascunde pe pagina cursului';
$string['hideoncoursepage'] = 'Setează ca fiind disponibil, dar nu afișa pe pagina cursului';
$string['hidepopoverwindow'] = 'Ascunde fereastra popover';
$string['hidesection'] = 'Ascunde secțiunea {$a}';
$string['hidesettings'] = 'Ascunde setările';
$string['hideshowblocks'] = 'Ascunde sau afișează blocurile';
$string['highlight'] = 'Evidențiere';
$string['highlighted'] = 'Evidențiat';
$string['highlightoff'] = 'Elimină evidențierea';
$string['hits'] = 'Observații';
$string['hitsoncourse'] = 'Observații privind {$a->coursename} al {$a->username}';
$string['hitsoncoursetoday'] = 'Observațiile de azi privind {$a->coursename} ale {$a->username}';
$string['home'] = 'Acasă';
$string['homeheader'] = 'Meniul principal';
$string['hour'] = 'oră';
$string['hours'] = 'ore';
$string['howtomakethemes'] = 'Cum să generezi teme noi';
$string['htmleditor'] = 'Utilizează editorul HTML';
$string['htmleditoravailable'] = 'Editorul HTML este disponibil';
$string['htmleditordisabled'] = 'Ați dezactivat editorul HTML din profilul dumneavoastră de utilizator';
$string['htmleditordisabledadmin'] = 'Administratorul a dezactivat editorul HTML de pe acest site';
$string['htmleditordisabledbrowser'] = 'Editorul HTML nu este disponibil pentru că browser-ul dumneavoastră web nu este compatibil';
$string['htmlfilesonly'] = 'Numai fișierele HTML';
$string['htmlformat'] = 'Format HTML';
$string['icon'] = 'Simbol';
$string['idnumber'] = 'Număr ID';
$string['idnumbercourse'] = 'Număr ID curs';
$string['idnumbercourse_help'] = 'Folosit doar pentru a conecta cursul cu sisteme externe. Lăsați necompletat dacă nu aveți un ID oficial al cursului.';
$string['idnumbercoursecategory'] = 'Număr ID categorie';
$string['idnumbercoursecategory_help'] = 'Numărul de identificare al unei categorii de cursuri este utilizat, numai atunci când corespunde sistemelor externe și nu este afișat nicăieri pe site. Atunci când categoria are un cod oficial, poate fi introdus acesta; altfel, câmpul poate fi lăsat necompletat.';
$string['idnumbergroup'] = 'Număr ID grup';
$string['idnumbergroup_help'] = 'Numărul de identificare al unui grup este utilizat, numai atunci când corespunde sistemelor externe și nu este afișat nicăieri pe site. Atunci când grupul are un cod oficial, poate fi introdus acesta; altfel, câmpul poate fi lăsat necompletat.';
$string['idnumbergrouping'] = 'Numărul ID al grupării';
$string['idnumbergrouping_help'] = 'Numărul de identificare al unei grupări este utilizat, numai atunci când corespunde sistemelor externe și nu este afișat nicăieri pe site. Atunci când gruparea are un cod oficial, poate fi introdus acesta; altfel, câmpul poate fi lăsat necompletat.';
$string['idnumbermod'] = 'Număr ID';
$string['idnumbermod_help'] = 'Setarea unui număr de identificare oferă o modalitate de identificare a activității sau a resursei în scopuri precum calcularea notei sau raportarea personalizată. În caz contrar, câmpul poate fi lăsat necompletat.

Pentru activitățile care pot fi notate, numărul de identificare poate fi, de asemenea, setat în carnetul de note, deși poate fi editat doar pe pagina de setări de activitate.';
$string['idnumbertaken'] = 'Acest număr ID este utilizat deja';
$string['imagealt'] = 'Descrierea imaginii';
$string['import'] = 'Importă';
$string['importdata'] = 'Importă date privind cursul';
$string['importdataexported'] = 'Date exportate din cursul "from" cu succes .<br /> Continuați să importați în cursul dumneavoastră "to" .';
$string['importdatafinished'] = 'Import finalizat! Conținuați cursul';
$string['importdatafrom'] = 'Găsiți un curs din care să importați date:';
$string['importinfo'] = 'Importă elemente din alte cursuri, cum ar fi activități, blocuri sau evenimente din calendar. Nu vor fi importate date despre utilizator.';
$string['inactive'] = 'Inactiv';
$string['include'] = 'Include';
$string['includeallusers'] = 'Include toți utilizatorii';
$string['includecoursefiles'] = 'Include fișierele cursului';
$string['includecourseusers'] = 'Include utilizatorii cursului';
$string['included'] = 'Inclus';
$string['includelogentries'] = 'Include intrările în jurnal';
$string['includemodules'] = 'Include modulele';
$string['includemoduleuserdata'] = 'Include datele privind utilizatorii modulului';
$string['includeneededusers'] = 'Include utilizatorii necesari';
$string['includenoneusers'] = 'Nu include utilizatori';
$string['includeroleassignments'] = 'Include alocările rolurilor';
$string['includesitefiles'] = 'Include fișierele site-ului utilizate în acest curs';
$string['includesubcategories'] = 'Include subcategoriile';
$string['includeuserfiles'] = 'Include fișierele utilizatorilor';
$string['increasesections'] = 'Mărește numărul de secțiuni';
$string['indicator:accessesafterend'] = 'Curs accesat după data de finalizare';
$string['indicator:accessesafterend_help'] = 'Acest indicator indică dacă studentul a accesat cursul după data de încheiere a cursului.';
$string['indicator:accessesbeforestart'] = 'Curs accesat înainte de data de începere';
$string['indicator:accessesbeforestart_help'] = 'Acest indicator reflectă dacă studentul a accesat cursul înainte de data de începere.';
$string['indicator:activitiesdue'] = 'Activități care trebuie încheiate.';
$string['indicator:activitiesdue_help'] = 'Utilizatorul are activități care trebuie încheiate.';
$string['indicator:anycourseaccess'] = 'Acces la orice curs';
$string['indicator:anycourseaccess_help'] = 'Acest indicator indică accesul la orice curs în care utilizatorul este înscris.';
$string['indicator:anywrite'] = 'Orice acțiune de scriere';
$string['indicator:anywrite_help'] = 'Acest indicator reprezintă orice acțiune de scriere (trimitere) a unor informații efectuată de către utilizator';
$string['indicator:anywriteincourse'] = 'Orice acțiune de scriere (trimitere) a unor informații efectuată de către utilizator în curs';
$string['indicator:anywriteincourse_help'] = 'Orice acțiune de scriere (trimitere) a unor informații efectuată de către utilizator în orice activitate de curs';
$string['indicator:completeduserprofile'] = 'Profilul utilizatorului este complet';
$string['indicator:completeduserprofile_help'] = 'Acest indicator reprezintă faptul că studentul și-a completat profilul de utilizator.';
$string['indicator:completeduserprofiledef'] = 'Profilul utilizatorului este complet';
$string['indicator:completeduserprofiledef_help'] = 'Politicile de utilizarea ale platformei au fost agreate și utilizatorul a completat următoarele câmpuri: Instituție, Departament, Adresa, Localitate, Țara, URL.';
$string['indicator:completionenabled'] = 'Urmărirea activităților a fost activată';
$string['indicator:completionenabled_help'] = 'Acest indicator reprezintă faptul că urmărirea activităților a fost activată în acest curs.';
$string['indicator:nostudent'] = 'Înrolările cursanților';
$string['indicator:nostudent_help'] = 'Acest indicator reflectă faptul că acest curs nu are cursanți.';
$string['indicator:noteacher'] = 'Disponibilitatea profesorului';
$string['indicator:noteacher_help'] = 'Acest indicator reflectă disponiblitatea profesorilor.';
$string['indicator:potentialcognitive'] = 'Profunzimea informațiilor cognitive din curs';
$string['indicator:potentialcognitive_help'] = 'Acest indicator se bazează pe profunzimea cognitivă potențială la care ar putea ajunge un cursant care participă la activități de curs.';
$string['indicator:potentialcognitivedef'] = 'Profunzimea informațiilor cognitive din curs';
$string['indicator:potentialcognitivedef_help'] = 'Gradul în care cursul oferă un angajament cognitiv „profund”, de ex. transmiterea răspunsurilor pentru feedback, posibilitatea de a revizui munca de către alții și posibilitatea de a revizui și a retrimite lucrarea.';
$string['indicator:potentialcognitivedef_link'] = 'Learning_analytics_indicators#Cognitive_depth';
$string['indicator:potentialsocial'] = 'Amploarea socială potențială a cursului';
$string['indicator:potentialsocial_help'] = 'Acest indicator se bazează pe amploarea socială potențială la care ar putea ajunge studentul care participă la activitățile de curs.';
$string['indicator:potentialsocialdef'] = 'Amploarea socială potențială a cursului';
$string['indicator:potentialsocialdef_help'] = 'Gradul în care cursul oferă un angajament social „larg”, interacționând cu alți participanți și cu comunitatea de practică din afara clasei.';
$string['indicator:potentialsocialdef_link'] = 'Learning_analytics_indicators#Social_breadth';
$string['indicator:readactions'] = 'Valoarea acțiunilor de citire (vizualizare)';
$string['indicator:readactions_help'] = 'Acest indicator reprezintă numărul de acțiuni de citire (vizualizare) întreprinse de un cursant.';
$string['indicator:userforumstracking'] = 'Utilizatorul urmărește forumurile';
$string['indicator:userforumstracking_help'] = 'Acest indicator reprezintă dacă un cursant a activat sau nu urmărirea discuțiilor din forumuri.';
$string['info'] = 'Informații';
$string['inprogress'] = 'În desfășurare';
$string['insertcontentbefore'] = 'Inserează conținut înaintea \'{$a->activityname}\'';
$string['insertresourceoractivitybefore'] = 'Include o activitate sau o resursă înaintea \'{$a->activityname}\'';
$string['institution'] = 'Instituție';
$string['instudentview'] = 'în atenția cursantului';
$string['interests'] = 'Preocupări';
$string['interestslist'] = 'Lista de preocupări';
$string['interestslist_help'] = 'Introduceți interesele dvs., unul câte unul, care vor fi apoi afișate pe pagina de profil ca etichete.';
$string['invalidemail'] = 'Adresă de e-mail incorectă';
$string['invalidlogin'] = 'Autentificare incorectă, vă rugăm să încercați din nou';
$string['invalidtaskclassname'] = 'Clasa sarcinii de lucru {$a} nu este validă';
$string['invalidtaskid'] = 'ID-ul sarcinii de lucru nu este validă';
$string['invalidusername'] = 'Numele de utilizator poate conține numai caractere alfanumerice minuscule (litere și cifre), subliniere (_), cratimă (-), punct (.) Sau la simbol (@).';
$string['invalidusernameupload'] = 'Numele de utilizator nu este valid';
$string['ip_address'] = 'Adresă IP';
$string['jump'] = 'Sari';
$string['jumpto'] = 'Sari la...';
$string['keep'] = 'Continuă';
$string['labelvalue'] = '{$a->label}: {$a->value}';
$string['langltr'] = 'Direcția limbii de la stânga la dreapta';
$string['langrtl'] = 'Direcția limbii de la dreapta la stânga';
$string['language'] = 'Limbă';
$string['languagegood'] = 'Acest pachet lingvistic este actualizat! :-)';
$string['languageselector'] = 'Selector limbă';
$string['last'] = 'Ultimul';
$string['lastaccess'] = 'Ultima accesare';
$string['lastcourseaccess'] = 'Ultima accesare a cursului';
$string['lastedited'] = 'Ultima editare';
$string['lastip'] = 'Ultima adresă IP';
$string['lastlogin'] = 'Ultima autentificare';
$string['lastmodified'] = 'Ultima modificare';
$string['lastname'] = 'Nume de familie';
$string['lastnamephonetic'] = 'Nume - fonetic';
$string['lastpage'] = 'Ultima pagină';
$string['lastsiteaccess'] = 'Ultima accesare a site-ului';
$string['lastyear'] = 'Ultimul an';
$string['latestlanguagepack'] = 'Căutați cele mai recente pachete lingvistice pe moodle.org';
$string['layouttable'] = 'Aspect tabel';
$string['leavetokeep'] = 'Lăsați-l necompletat, pentru a păstra parola curentă';
$string['legacylogginginuse'] = 'În prezent, acest site are activată scrierea în magazinul vechi de jurnale. Scrierea în acest magazin de jurnale este depreciată. Vă rugăm să scrieți la un magazin de jurnale acceptat, cum ar fi „standard” sau „extern”.';
$string['legacythemeinuse'] = 'Acest site vă este afișat în modul de compatibilitate, deoarece browser-ul dvs. este prea vechi.';
$string['license'] = 'Licență';
$string['licenses'] = 'Licențe';
$string['liketologin'] = 'Doriți să vă conectați acum, utilizând contul complet de utilizator?';
$string['list'] = 'Listă';
$string['listfiles'] = 'Lista fișierelor în {$a}';
$string['listofallpeople'] = 'Lista tuturor persoanelor';
$string['listofcourses'] = 'Lista cursurilor';
$string['loading'] = 'Încărcare';
$string['loadinghelp'] = 'Încărcare...';
$string['local'] = 'Local';
$string['localplugins'] = 'Plugin-uri locale';
$string['localpluginsmanage'] = 'Gestionează plugin-urile locale';
$string['location'] = 'Localizare';
$string['locktimeout'] = 'Operațiunea a expirat în timp ce așteptați o blocare.';
$string['log_excel_date_format'] = 'aaaa llll z h:mm';
$string['loggedinas'] = 'Sunteți conectat în calitate de {$a}';
$string['loggedinasguest'] = 'În prezent folosiți accesul pentru vizitatori';
$string['loggedinnot'] = 'Nu sunteți conectat.';
$string['login'] = 'Conectare';
$string['login_failure_logs'] = 'Jurnalele de erori de conectare';
$string['loginactivity'] = 'Activitatea de conectare';
$string['loginagain'] = 'Autentificați-vă din nou';
$string['loginalready'] = 'Sunteți deja conectat';
$string['loginas'] = 'Conectați-vă ca';
$string['loginaspasswordexplain'] = '<p>Trebuie să introduceți „parola de autentificare” specială, pentru a utiliza această caracteristică.<br />Dacă nu o cunoașteți, adresați-vă administratorului serverului.</p>';
$string['loginguest'] = 'Acces ca vizitator';
$string['loginsite'] = 'Conectați-vă la site';
$string['loginsteps'] = 'Pentru a avea acces complet pe acest site, va trebui mai întâi să vă creaţi un cont.';
$string['loginstepsnone'] = '<p>Hi!</p>
<p>Pentru a avea acces complet la cursuri, va trebui să vă creați un cont.</p>
<p>Tot ce trebuie să faceți este să creați un nume de utilizator și o parolă și să le utilizați în formularul de pe această pagină!</p>
<p>Dacă altcineva a ales deja numele dvs. de utilizator, va trebui să încercați din nou, folosind un alt nume de utilizator.</p>';
$string['loginto'] = 'Conectați-vă la {$a}';
$string['logoof'] = 'Logo al {$a}';
$string['logout'] = 'Delogare';
$string['logoutconfirm'] = 'Doriți să vă deconectați?';
$string['logs'] = 'Jurnale';
$string['logtoomanycourses'] = '[ <a href="{$a->url}">more</a> ]';
$string['logtoomanyusers'] = '[ <a href="{$a->url}">more</a> ]';
$string['lookback'] = 'În urmă cu';
$string['mailadmins'] = 'Informează administratorul';
$string['mailstudents'] = 'Informează cursanții';
$string['mailteachers'] = 'Informează formatorii';
$string['maincoursepage'] = 'Pagina principală a cursului';
$string['makeafolder'] = 'Creează folder';
$string['makeavailable'] = 'Faceți-l(o) disponibil(ă)';
$string['makeeditable'] = 'Dacă modificați "{$a}" prin procesul de server web (de exemplu, apache), puteți edita acest fișier direct din această pagină';
$string['makethismyhome'] = 'Setează această pagină ca pagină principală';
$string['makeunavailable'] = 'Setați ca indisponibil';
$string['manageblocks'] = 'Blocuri';
$string['managecategories'] = 'Administrați categorii de curs';
$string['managecategorythis'] = 'Gestionează această categorie';
$string['managecombined'] = 'Administrați categorii de curs și cursuri';
$string['managecontentbanktypes'] = 'Administrați tipurile de conținut';
$string['managecourses'] = 'Gestionează cursuri';
$string['managedatabase'] = 'Baza de date';
$string['managedataformats'] = 'Gestionează formatul datelor';
$string['manageeditorfiles'] = 'Gestionează câmpurile utilizate de editor';
$string['managefilters'] = 'Filtre';
$string['managemodules'] = 'Module';
$string['manageroles'] = 'Roluri și permisiuni';
$string['markallread'] = 'Marcați-le pe toate ca citite';
$string['match'] = 'Potrivire';
$string['matchingsearchandrole'] = 'Potrivire "{$a->search}" și {$a->role}';
$string['matchofthefollowing'] = 'sau următoarele:';
$string['maxareabytesreached'] = 'Fișierul (sau dimensiunea totală a mai multor fișiere) este mai mare decât spațiul rămas în această zonă.';
$string['maxfilesize'] = 'Dimensiunea maximă pentru fișierele noi: {$a}';
$string['maxfilesreached'] = 'Vi se permite să atașați maximum de {$a} fișiere la acest articol';
$string['maximumchars'] = 'Maximum de {$a} caractere';
$string['maximumgrade'] = 'Notă maximă';
$string['maximumgradex'] = 'Notă maximă: {$a}';
$string['maximumshort'] = 'Maxim';
$string['maximumupload'] = 'Dimensiunea maximă a fișierelor încărcate';
$string['maximumupload_help'] = 'Dimensiunea maximă permisă a fișierului încărcat de cursanți în curs. În plus, poți restricționa și mai departe dimensiunea maximă pentru fiecare activitate.';
$string['maxnumberweeks'] = 'Numărul maxim de secțiuni de curs';
$string['maxnumberweeks_desc'] = 'Controlează opțiunile maxime care apar în setarea "Număr de secțiuni".';
$string['maxnumcoursesincombo'] = 'Răsfoiește <a href="{$a->link}">{$a->numberofcourses} cursurile</a>.';
$string['maxsectionslimit'] = 'Nu se poate crea o secțiune nouă deoarece se va depăși numărul maxim de secțiuni permise pentru acest curs ({$a}).';
$string['maxsize'] = 'Dimensiune maximă: {$a}';
$string['maxsizeandareasize'] = 'Dimensiunea maximă a fișierelor noi: {$a->size}, limită generală: {$a->areasize}';
$string['maxsizeandattachments'] = 'Dimensiunea maximă a fișierelor: {$a->size}, numărul maxim de fișiere: {$a->attachments}';
$string['maxsizeandattachmentsandareasize'] = 'Dimensiunea maximă a fișierelor: {$a->size}, numărul maxim de fișiere: {$a->attachments}, dimensiunea totală: {$a->areasize}';
$string['memberincourse'] = 'Persoane la curs';
$string['menu'] = 'Meniu';
$string['message'] = 'Mesaj';
$string['messagebody'] = 'Conținut';
$string['messagedselectedusers'] = 'Utilizatorii selectați au primit mesaje și lista de destinatari a fost resetată.';
$string['messagedselectedusersfailed'] = 'Ceva nu a funcționat în timpul transmiterii mesajelor către utilizatorii selectați. Este posibil ca numai unii utilizatori să fi primit e-mailul.';
$string['messageprovider:asyncbackupnotification'] = 'Notificări de backup / restaurare asincrone';
$string['messageprovider:availableupdate'] = 'Notificări de actualizare disponibile';
$string['messageprovider:backup'] = 'Notificări backup';
$string['messageprovider:badgecreatornotice'] = 'Notificări pentru creatorii de ecusoane';
$string['messageprovider:badgerecipientnotice'] = 'Notificări pentru destinatarii ecusoanelor';
$string['messageprovider:competencyplancomment'] = 'Comentariu postat pe un plan de învățare';
$string['messageprovider:competencyusercompcomment'] = 'Comentariu postat la o competență';
$string['messageprovider:coursecompleted'] = 'Curs completat';
$string['messageprovider:coursecontentupdated'] = 'Modificări în conținutul cursului';
$string['messageprovider:courserequestapproved'] = 'Notificare de aprobare a cererii de creare a cursului';
$string['messageprovider:courserequested'] = 'Notificare cerere de creare a cursului';
$string['messageprovider:courserequestrejected'] = 'Notificare cerere de creare a cursului';
$string['messageprovider:enrolcoursewelcomemessage'] = 'Mesaj de bun venit pentru cursanții nou înscriși';
$string['messageprovider:errors'] = 'Erori importante la site';
$string['messageprovider:errors_help'] = 'Acestea sunt erori importante, pe care ar trebui să le cunoască un administrator.';
$string['messageprovider:failedtaskmaxdelay'] = 'Sarcina de lucru a atins limita maximă de întârziere a rulării';
$string['messageprovider:gradenotifications'] = 'Notificări privind notele';
$string['messageprovider:infected'] = 'Notificări de nefuncționare antivirus.';
$string['messageprovider:insights'] = 'Statistici generate de modele de predicție';
$string['messageprovider:instantmessage'] = 'Mesaje personale între utilizatori';
$string['messageprovider:instantmessage_help'] = 'Această secțiune configurează ce se întâmplă cu mesajele care vă sunt trimise direct de alți utilizatori ai acestui site.';
$string['messageprovider:messagecontactrequests'] = 'Notificare de solicitare contact';
$string['messageprovider:newlogin'] = 'Notificări pentru autentificare nouă';
$string['messageprovider:notices'] = 'Notificări privind problemele minore';
$string['messageprovider:notices_help'] = 'Acestea sunt notificări pe care un administrator ar putea fi interesat să le vadă.';
$string['messageprovider:reportbuilderschedule'] = 'Programarea generatorului de rapoarte personalizate';
$string['messageselect'] = 'Selectați acest utilizator ca destinatar al mesajului';
$string['messageselectadd'] = 'Trimite un mesaj';
$string['middlename'] = 'Prenume';
$string['migratinggrades'] = 'Migrarea notelor';
$string['min'] = 'min';
$string['mins'] = 'min';
$string['minute'] = 'minut';
$string['minutes'] = 'minute';
$string['miscellaneous'] = 'Diverse';
$string['missingcategory'] = 'Trebuie să alegeți o categorie';
$string['missingdescription'] = 'Lipsește descrierea';
$string['missingemail'] = 'Lipsește adresa de e-mail';
$string['missingfirstname'] = 'Lipsește prenumele';
$string['missingfromdisk'] = 'Lipsește de pe disc';
$string['missingfullname'] = 'Lipsește numele întreg';
$string['missinglastname'] = 'Lipsește numele de familie';
$string['missingname'] = 'Lipsește numele';
$string['missingnewpassword'] = 'Lipsește parola nouă';
$string['missingpassword'] = 'Lipsește parola';
$string['missingrecaptchachallengefield'] = 'reCAPTCHA nu a reușit, încercați din nou.';
$string['missingreqreason'] = 'Lipsește motivul';
$string['missingshortname'] = 'Lipsește prescurtarea numelui';
$string['missingshortsitename'] = 'Lipsește prescurtarea numelui site-ului';
$string['missingsitedescription'] = 'Lipsește descrierea site-ului';
$string['missingsitename'] = 'Lipsește numele site-ului';
$string['missingstrings'] = 'Verificați dacă există cuvinte sau expresii netraduse';
$string['missingstudent'] = 'Trebuie să alegi';
$string['missingsummary'] = 'Lipsește rezumatul';
$string['missingteacher'] = 'Trebuie să alegeți';
$string['missingurl'] = 'Lipsește adresa URL';
$string['missingusername'] = 'Lipsește numele de utilizator';
$string['moddoesnotsupporttype'] = 'Modulul {$a->modname} nu suportă încărcări de tip {$a->type}';
$string['modhide'] = 'Ascunde';
$string['modified'] = 'Modificat';
$string['modshow'] = 'Afișează';
$string['moduleintro'] = 'Descriere';
$string['modulesetup'] = 'Configurarea tabelelor modulului';
$string['modulesuccess'] = '{$a} tabelele au fost configurate corect';
$string['modulesused'] = 'Module utilizate';
$string['modvisible'] = 'Disponibilitate';
$string['modvisible_help'] = '* Afișează pe pagina cursului: Disponibil pentru cursanți (sub rezerva oricăror restricții de acces care pot fi setate).
* Ascunde de pe pagina cursului: nu este disponibil pentru cursanți.';
$string['modvisiblehiddensection'] = 'Disponibilitate';
$string['modvisiblehiddensection_help'] = '* Ascunde pe pagina cursului: Nu este disponibil pentru cursanți.
* Setează ca fiind disponibil, dar nu afișa pe pagina cursului: Disponibil pentru cursanți dacă se furnizează un link. Activitățile vor apărea în continuare în catalog și în alte rapoarte.';
$string['modvisiblewithstealth'] = 'Disponibilitate';
$string['modvisiblewithstealth_help'] = '* Afișează pe pagina cursului: disponibil pentru cursanți (se aplică orice restricții de acces care pot să fie setate).
* Ascunde pe pagina cursului: nu este disponibil pentru cursanți.
* Stează ca disponibil, dar nu afișa pe pagina cursului: Disponibil pentru cursanâi, dacă se furnizează un link. Activitățile vor apărea în continuare în catalog și în alte rapoarte.';
$string['month'] = 'Lună';
$string['months'] = 'Luni';
$string['moodledocs'] = 'Moodle Docs';
$string['moodledocslink'] = 'Documentația acestei pagini';
$string['moodlelogo'] = 'Logo Moodle';
$string['moodlenet:cannotconnecttoserver'] = 'Nu se poate conecta la serverul MoodleNet';
$string['moodlenet:columnname'] = 'Denumire';
$string['moodlenet:columnsenddate'] = 'Data trimiterii';
$string['moodlenet:columnsendstatus'] = 'Trimitere status';
$string['moodlenet:columntype'] = 'Tip';
$string['moodlenet:configoauthservice'] = 'Selectează un serviciu OAuth 2 pentru a activa partajarea pe acel site MoodleNet. Dacă serviciul nu există încă, va trebui să îl <a href="{$a}">creezi</a>.';
$string['moodlenet:deletedactivity'] = 'Activitata ștearsă';
$string['moodlenet:deletedcourse'] = 'Curs șters';
$string['moodlenet:eventresourceexported'] = 'Resursă exportată';
$string['moodlenet:gotomoodlenet'] = 'Mergi la ciornele MoodleNet';
$string['moodlenet:issuerisnotauthorized'] = 'Emitentul MoodleNet nu este autorizat';
$string['moodlenet:issuerisnotenabled'] = 'Emitentul MoodleNet nu este activat';
$string['moodlenet:issuerisnotset'] = 'Emitentul MoodleNet nu este setat la administrarea site-ului';
$string['moodlenet:nosharedresources'] = 'În prezent nu există resurse distribuite care să fie afișate.';
$string['moodlenet:outboundsettings'] = 'Setările de conectare la MoodleNet';
$string['moodlenet:packagingandsending'] = 'Complilare fișier și trimitere către MoodleNet...';
$string['moodlenet:sharefailtext'] = 'A apărut o eroare la partajarea conținutului tău înMoodleNet.<br>Te rugăm să încerci mai târziu.';
$string['moodlenet:sharefailtextwithsitesupport'] = 'A apărut o eroare la partajarea conținutului tău către MoodleNet.<br>Te rugăm să încerci mai târziu sau să contactezi suportul site-lui</a>.';
$string['moodlenet:sharefailtitle'] = 'A apărut o eroare';
$string['moodlenet:sharefilesizelimitexceeded'] = 'Dimensiunea resursei partajate ({$a->filesize} bytes) depășește limita de {$a->filesizelimit} biți.';
$string['moodlenet:sharenoticeactivity'] = 'Această activitate este partajată în MoodleNet ca o resursă.';
$string['moodlenet:sharenoticecourse'] = 'Acest curs este partajat în MoodleNet ca o resursă.';
$string['moodlenet:sharenoticepartial'] = 'Activitățile selectate sunt distribuite în MoodleNet sub formă de resursă.';
$string['moodlenet:sharenoticepartialactivitynumber'] = '{$a} activități vor fi incluse în curs.';
$string['moodlenet:shareprogress'] = 'Partajarea progresului în MoodleNet';
$string['moodlenet:shareprogressinfo'] = 'Lista afișează cursurile și activitățile pe care le-ai distribuit în.<br>Dă click pe denumirea resursei pentru a o vedea în MoodleNet.';
$string['moodlenet:sharesuccesstext'] = 'Aproape gata! Vizualizează ciornele tale în MoodleNet pentru a termina de partajat conținutul.';
$string['moodlenet:sharesuccesstitle'] = 'Salvat în ciornele MoodleNet';
$string['moodlenet:sharetomoodlenet'] = 'Partajează către MoodleNet';
$string['moodlenet:sharinglargefile'] = 'Fișierele de dimensiuni mai mari pot necesita mai mult timp pentru încărcare.';
$string['moodlenet:sharingstatus'] = 'Partajare către MoodleNet';
$string['moodlenet:sharingto'] = 'Partajare către:';
$string['moodlerelease'] = 'Versiune Moodle';
$string['moodleservicesandsupport'] = 'Servicii si suport';
$string['moodleversion'] = 'Versiune Moodle';
$string['more'] = 'mai multe';
$string['moreactions'] = 'Mai multe acțiuni';
$string['morehelp'] = 'Asistență suplimentară';
$string['morehelpaboutmodule'] = 'Mai mult ajutor în legătură cu activitatea {$a}';
$string['moreinfo'] = 'Informații suplimentare';
$string['moreinformation'] = 'Informații suplimentare privind eroarea';
$string['moremenu'] = 'Mai mult';
$string['morenavigationlinks'] = 'Mai multe...';
$string['moreprofileinfoneeded'] = 'Vă rugăm să ne spuneți mai multe despre dumneavoastră';
$string['mostrecently'] = 'cel mai recent';
$string['move'] = 'Mută';
$string['movecategoriessuccess'] = 'Categorii mutate cu succes {$a->count} în categoria "{$a->to}"';
$string['movecategoriestotopsuccess'] = 'Categorii mutate cu succes {$a->count} la nivel superior';
$string['movecategorycontentto'] = 'Mută în';
$string['movecategorysuccess'] = 'Categorii mutate cu succes "{$a->moved}" în categoria "{$a->to}"';
$string['movecategoryto'] = 'Mută categoria:';
$string['movecategorytotopsuccess'] = 'Mutat cu succes categoria \'{$a->moved}\'  în nivelul de sus';
$string['movecontent'] = 'Mută {$a}';
$string['movecontentafter'] = 'După "{$a}"';
$string['movecontentstoanothercategory'] = 'Mută conținuturile într-o altă categorie';
$string['movecontenttothetop'] = 'În capul listei';
$string['movecoursemodule'] = 'Mută activitatea';
$string['movecoursesection'] = 'Mută secțiune';
$string['movecourseto'] = 'Mută curs la:';
$string['movedown'] = 'Mută jos';
$string['movefilestohere'] = 'Mută fișierele aici';
$string['movefull'] = 'Mută {$a} în această locație';
$string['movehere'] = 'Mută aici';
$string['moveleft'] = 'Mută la stânga';
$string['moveright'] = 'Mută la dreapta';
$string['movesection'] = 'Mută secțiune {$a}';
$string['moveselectedcategoriesto'] = 'Mută categoriile selectate în';
$string['moveselectedcoursesto'] = 'Mută cursurile selectate în...';
$string['movetoanotherfolder'] = 'Mută în alt folder';
$string['moveup'] = 'Mută sus';
$string['mustchangepassword'] = 'Noua parolă trebuie să fie diferită de cea actuală';
$string['mustconfirm'] = 'Trebuie să confirmaţi contul dumneavoastră';
$string['mycourses'] = 'Cursurile mele';
$string['myfiles'] = 'Fișierele mele private';
$string['myfilesmanage'] = 'Gestionează fișierele mele private';
$string['myhome'] = 'Tablou de bord';
$string['mymoodledashboard'] = 'Tabloul meu de bord Moodle';
$string['myprofile'] = 'Profilul meu';
$string['name'] = 'Nume';
$string['namedfiletoolarge'] = 'Fișierul "{$a->filename}" este prea mare și nu poate fi încărcat';
$string['nameforlink'] = 'Cum doriți să numiți acest link?';
$string['nameforpage'] = 'Nume';
$string['navigation'] = 'Navigare';
$string['needed'] = 'Necesar';
$string['networkdropped'] = 'Conexiunea dumneavoastră la internet nu este de încredere sau a fost întreruptă.<br />
Rețineți că este posibil ca modificările să nu fie salvate corect, până când conexiunea dumneavoastră nu se îmbunătățește.';
$string['never'] = 'Niciodată';
$string['neverdeletelogs'] = 'Nu șterge niciodată jurnalele';
$string['new'] = 'Nou';
$string['newaccount'] = 'Cont nou';
$string['newactivityname'] = 'Nume nou pentru activitatea {$a}';
$string['newcourse'] = 'Curs nou';
$string['newloginnotificationbodyfull'] = '<p>Bună {$a->userfullname},</p>
<p>În contul dumneavoastră {$a->sitename} a avut loc o logare de pe un alt dispozitiv.</p>
<ul>
<li>Contul dumneavoastră: {$a->username} {$a->useremail}</li>
<li>{$a->logintime}</li>
<li>Device: {$a->logindevice}</li>
<li>IP: {$a->loginip}</li>
</ul>
<p>Dacă dumneavoastră v-ați logat în cont, nu mai trebuie să faceți nimic.</p>
<p>Dacă nu recunoașteți această activitate, vă rugăm să <a href="{$a->changepasswordlink}">schimbați parola</a>.</p>';
$string['newloginnotificationbodysmall'] = 'A avut loc o logare în contul dumneavoastră {$a} de pe un alt dispozitiv.';
$string['newloginnotificationtitle'] = 'Nouă logare în contul dumneavoastră {$a}';
$string['newpassword'] = 'Parolă nouă';
$string['newpassword_help'] = 'Introduceți o parolă nouă sau lăsați spațiul necompletat, pentru a păstra parola curentă.';
$string['newpasswordfromlost'] = '<strong>REȚINEȚI:</strong> <strong>Parola dumneavoastră curentă</strong> vă va fi trimisă în <strong>a doua</strong> dintre cele două e-mailuri trimise ca parte a procesului de recuperare a parolei pierdute. Asigurați-vă că ați primit parola de înlocuire, înainte de a continua cu acest ecran.';
$string['newpasswordtext'] = 'Bună ziua {$a->firstname},

Parola contului dumneavoastră la "{$a->sitename}" a fost resetată
și vi s-a emis o nouă parolă temporară.

Informațiile dvs. actuale de conectare sunt:
   nume utilizator: {$a->username}
   parolă: {$a->newpassword}

Accesați această pagină, pentru a vă schimba parola:
   {$a->link}

În majoritatea programelor de e-mail, aceasta ar trebui să apară sub forma unui link de culoare albastră
pe care puteți să faceți click. Dacă nu funcționează,
tăiați și lipiți adresa în linia
din partea superioară a ferestrei browserului web.

Salutări din partea administratorului "{$a->sitename}",
{$a->signoff}';
$string['newpicture'] = 'Imagine nouă';
$string['newpicture_help'] = 'Pentru a adăuga o imagine nouă, răsfoiți și selectați o imagine (în format JPG sau PNG), apoi faceți click pe „Actualizați profilul”. Imaginea va fi decupată în pătrat și redimensionată la 100x100 pixeli.';
$string['newpictureusernotsetup'] = 'Imaginea de profil poate fi adăugată numai după salvarea tuturor informațiilor de profil solicitate.';
$string['newsectionname'] = 'Nume nou pentru secțiunea {$a}';
$string['newsitem'] = 'elemente noi';
$string['newsitems'] = 'anunțuri';
$string['newsitemsnumber'] = 'Număr de anunțuri';
$string['newsitemsnumber_help'] = 'Forumul de Anunțuri are abonamentul forțat setat în mod implicit. Numai profesorii și alți utilizatori cu permisiunea corespunzătoare pot posta în acest forum.

Dacă nu aveți nevoie de un forum de anunțuri, setați această opțiune lucru la valoarea zero.

Această setare determină, de asemenea, câte anunțuri recente apar în blocul cele mai recente anunțuri.';
$string['newuser'] = 'Utilizator nou';
$string['newusernewpasswordsubj'] = 'Cont nou utilizator';
$string['newusernewpasswordtext'] = 'Bună ziua {$a->firstname},

A fost creat un nou cont pentru dumneavoastră pe "{$a->sitename}"
și vi s-a emis o nouă parolă temporară.

Informațiile dumneavoastră actuale de conectare sunt:
   nume utilizator: {$a->username}
   parolă: {$a->newpassword}
             (va trebui să modificați parola
              atunci când vă conectați pentru prima dată)

Pentru a începe să utilizați "{$a->sitename}", conectați-vă la
   {$a->link}

Dacă aveți nevoie de ajutor, puteți contacta adminsitratorul site-ului, {$a->admin}';
$string['newusers'] = 'Utilizatori noi';
$string['newwindow'] = 'Fereastră nouă';
$string['next'] = 'Următorul';
$string['nextpage'] = 'Pagina următoare';
$string['nextsection'] = 'Următoarea secțiune';
$string['no'] = 'Nu';
$string['noblockstoaddhere'] = 'Nu există blocuri pe care să le puteți adăuga la această pagină.';
$string['nobody'] = 'Nimeni';
$string['nochange'] = 'Nicio modificare';
$string['nocomments'] = 'Niciun comentariu';
$string['nocourses'] = 'Nu sunt cursuri disponibile';
$string['nocoursesfound'] = 'Nu s-au găsit cursuri cu cuvintele "{$a}"';
$string['nocoursestarttime'] = 'Cursul nu are o dată de începere.';
$string['nocoursesyet'] = 'Fără cursuri în această categorie';
$string['nodstpresets'] = 'Administratorul nu a activat asistența pentru ora de vară.';
$string['nofilesselected'] = 'Nu a fost selectat niciun fișier pentru restabilire';
$string['nofilesyet'] = 'Niciun fișier nu a fost încărcat încă în cursul dvs.';
$string['nofiltersapplied'] = 'Nu s-au aplicat filtre';
$string['nograde'] = 'Nicio notă';
$string['nohelpforactivityorresource'] = 'În prezent, nu există asistență asociată cu această resursă sau activitate';
$string['noimagesyet'] = 'Nu s-au încărcat încă imagini în cursul dumneavoastră';
$string['nologsfound'] = 'Nu s-au găsit jurnale';
$string['nomatchingusers'] = 'Nu corespunde niciun utilizator "{$a}"';
$string['nomorecourses'] = 'Nu s-au mai găsit cursuri corespunzătoare';
$string['nomoreidnumber'] = 'Nu folosiți un număr de identificare pentru a evita coliziunile';
$string['none'] = 'Nimic';
$string['noneditingteacher'] = 'Formator fără drept de editare';
$string['noneditingteacherdescription'] = 'Profesorii fără drept de editare pot preda cursuri și pot nota cursanții, dar nu pot modifica activitățile.';
$string['nonstandard'] = 'Non-standard';
$string['nopendingcourses'] = 'Nu există cursuri în așteptarea aprobării';
$string['nopotentialadmins'] = 'Fără posibili administratori';
$string['nopotentialcreators'] = 'Fără posibili creatori de curs';
$string['nopotentialstudents'] = 'Fără posibili cursanți';
$string['nopotentialteachers'] = 'Fără posibili formatori';
$string['norecentactivity'] = 'Fără activitate recentă';
$string['noreplybouncemessage'] = 'Ați răspuns la o adresă de e-mail no-reply. Dacă ați încercat să răspundeți la o postare pe forum, vă rugăm să răspundeți prin intermediul {$a} forumurilor.

Conținutul e-mailului dumneavoastră este următorul:';
$string['noreplybouncesubject'] = '{$a} - e-mail respins.';
$string['noreplyname'] = 'Nu răspundeți la acest e-mail';
$string['noresetrecord'] = 'Nu există nicio înregistrare a acelei cereri de resetare. Vă rugăm să inițiați o nouă solicitare de resetare a parolei.';
$string['noresults'] = 'Fără rezultate';
$string['noresultsfor'] = 'Nu există rezultate pentru "{$a}"';
$string['normal'] = 'Normal';
$string['normalfilter'] = 'Căutare normală';
$string['nosite'] = 'Nu am putut găsi un curs la nivel de site';
$string['nostudentsfound'] = 'Nu a fost găsit {$a}';
$string['nostudentsingroup'] = 'Nu există încă studenți în acest grup';
$string['nostudentsyet'] = 'Nu există cursanți înscriși la acest curs.';
$string['nosuchemail'] = 'Nu există o astfel de adresă de e-mail';
$string['notavailable'] = 'Nu e disponibil';
$string['notavailablecourse'] = '{$a} nu este disponibil';
$string['noteachersyet'] = 'Nu există încă formatori la acest curs';
$string['noteachingupcomingcourses'] = 'Cursurile viitoare nu au profesori sau studenți';
$string['notenrolled'] = '{$a} nu este înscris la acest curs.';
$string['notenrolledprofile'] = 'Acest profil nu este disponibil, deoarece acest utilizator nu este înscris la acest curs.';
$string['noteusercannotrolldatesoncontext'] = '<strong>Observație:</strong> Capacitatea de a reda datele la restaurarea acestui backup a fost dezactivată, deoarece nu aveți permisiunile necesare.';
$string['noteuserschangednonetocourse'] = '<strong>Observație:</strong> Utilizatorii cursului trebuie să fie restaurați, atunci când restabiliți datele utilizatorului (în activități, fișiere sau mesaje). Această setare a fost modificată pentru dumneavoastră.';
$string['nothingnew'] = 'Fără activitate recentă';
$string['nothingtodisplay'] = 'Nimic de afișat';
$string['notice'] = 'Notificare';
$string['noticenewerbackup'] = 'Acest fișier de rezervă a fost creat cu Moodle {$a->backuprelease} ({$a->backupversion}) și este mai nou decât Moodle instalat în prezent {$a->serverrelease} ({$a->serverversion}). Acest lucru ar putea genera unele neconcordanțe, deoarece compatibilitatea inversă a fișierelor de backup nu poate fi garantată.';
$string['notifications'] = 'Notificări';
$string['notifyloginfailuresmessage'] = '{$a->time}, IP: {$a->ip}, Utilizator: {$a->info}, Numele complet al utilizatorului: {$a->name}';
$string['notifyloginfailuresmessageend'] = 'Puteți vizualiza aceste jurnale la {$a}';
$string['notifyloginfailuresmessagestart'] = 'Iată o listă a încercărilor eșuate de conectare la {$a} de la ultima notificare';
$string['notifyloginfailuressubject'] = '{$a} :: Notificare de conectare nereușită';
$string['notincluded'] = 'Nu este inclus';
$string['notingroup'] = 'Ne pare rău, dar trebuie să faceţi parte dintr-un grup pentru a putea vizualiza această pagină.';
$string['notpublic'] = 'Nu este public!';
$string['nousersfound'] = 'Nu a fost găsit niciun utilizator';
$string['nousersmatching'] = 'Nu s-au găsit utilizatori care corespund "{$a}"';
$string['nousersyet'] = 'Nu există încă utilizatori';
$string['novalidcourses'] = 'Nu sunt afișate cursuri valabile';
$string['now'] = 'acum';
$string['numattempts'] = '{$a} încercări de conectare eșuate';
$string['numberofcourses'] = 'Număr de cursuri';
$string['numberweeks'] = 'Număr de secțiuni';
$string['numday'] = '{$a} zi';
$string['numdays'] = '{$a} zile';
$string['numhours'] = '{$a} ore';
$string['numletters'] = '{$a} litere';
$string['numminutes'] = '{$a} minute';
$string['nummonth'] = '{$a} lună';
$string['nummonths'] = '{$a} luni';
$string['numseconds'] = '{$a} secunde';
$string['numviews'] = '{$a} vizualizări';
$string['numweek'] = '{$a} săptămână';
$string['numweeks'] = '{$a} săptămâni';
$string['numwords'] = '{$a} cuvinte';
$string['numyear'] = '{$a} an';
$string['numyears'] = '{$a} ani';
$string['ok'] = 'OK';
$string['oldpassword'] = 'Parola curentă';
$string['olduserdirectory'] = 'Acesta este directorul pentru utilizatori vechi și nu mai este necesar. Puteți să-l ștergeți în siguranță. Fișierele, pe care le conține, au fost copiate în noul director de utilizator.';
$string['opendrawerblocks'] = 'Deschide sertarul cu blocuri';
$string['opendrawerindex'] = 'Deschide Indexul cursului';
$string['opensinnewwindow'] = 'Se deschide în fereastră nouă';
$string['operator_and'] = 'și';
$string['operator_andnot'] = 'și';
$string['operator_or'] = 'sau';
$string['optional'] = 'opțional';
$string['options'] = 'opțiuni';
$string['order'] = 'Comandă';
$string['originalpath'] = 'Calea originală';
$string['orphanedactivitiesinsectionno'] = 'Activități orfane (secțiunea {$a})';
$string['other'] = 'Altele';
$string['outline'] = 'Schiță';
$string['outlinereport'] = 'Schiță raport';
$string['page'] = 'Pagina';
$string['pagea'] = 'Pagina {$a}';
$string['pagedcontentnavigation'] = 'Navigare prin paginare';
$string['pagedcontentnavigationactiveitem'] = 'Pagina curentă, pagina {$a}';
$string['pagedcontentnavigationitem'] = 'Mergi la pagina {$a}';
$string['pagedcontentpagingbaritemsperpage'] = 'Afișează {$a} elemente pe pagină';
$string['pageheaderconfigablock'] = 'Configurarea unui bloc în {$a->fullname}';
$string['pagepath'] = 'Cale pagină';
$string['pageshouldredirect'] = 'Această pagină ar trebui să facă automat redirecționarea. Dacă nu se întâmplă nimic, vă rugăm să utilizați linkul de mai jos.';
$string['parentcategory'] = 'Categoria părinte';
$string['parentcoursenotfound'] = 'Cursul părinte nu a fost găsit!';
$string['parentfolder'] = 'Folder părinte';
$string['participants'] = 'Participanți';
$string['participantslist'] = 'Listă de participanți';
$string['participationratio'] = 'Rată de participare';
$string['participationreport'] = 'Raport participare';
$string['password'] = 'Parolă';
$string['passwordchanged'] = 'Parola a fost modificată';
$string['passwordextlink'] = 'Următorul link a fost furnizat, pentru a vă recupera parola pierdută. Acest lucru vă va scoate din Moodl.';
$string['passwordforgotten'] = 'Parolă uitată';
$string['passwordforgotteninstructions'] = 'Detaliile dvs. trebuie mai întâi găsite în baza de date a utilizatorilor. Vă rugăm să introduceți <strong>either</strong> numele de utilizator sau adresa de e-mail înregistrată în caseta corespunzătoare. Nu este necesar să le introduceți pe amândouă.';
$string['passwordforgotteninstructions2'] = 'Pentru a vă reseta parola, trimiteți numele dvs. de utilizator sau adresa de e-mail de mai jos. Dacă vă putem găsi în baza de date, veți primi un e-mail la adresa dumneavoastră de e-mail, care va conține instrucțiuni despre cum să obțineți din nou accesul.';
$string['passwordpolicynomatch'] = 'Parola dvs. actuală nu mai corespunde politicii de parolă setate.
    {$a}';
$string['passwordsdiffer'] = 'Aceste parole nu corespund';
$string['passwordset'] = 'Parola dumneavoastră a fost transmisă.';
$string['path'] = 'Cale';
$string['pathnotexists'] = 'Calea nu există pe serverul dvs.!';
$string['pathslasherror'] = 'Calea nu se poate termina cu un slash!!';
$string['paymentinstant'] = 'Folosiți butonul de mai jos, pentru a plăti și fi înscris în câteva minute!';
$string['paymentpending'] = '(<small><b><u>{$a}</u></b> pending</small>)';
$string['paymentrequired'] = 'Acest curs necesită o plată pentru intrare.';
$string['payments'] = 'Plăți';
$string['paymentsorry'] = 'Va multumim pentru plata efectuată!  Din păcate, plata dvs. nu a fost încă procesată complet și nu sunteți încă înregistrat pentru a intra la curs "{$a->fullname}".  Vă rugăm să încercați să continuați cursul în câteva secunde, iar în cazul în care aveți în continuare probleme, vă rugăm să alertați {$a->teacher} administratorul site-ului';
$string['paymentthanks'] = 'Va multumim pentru plata efectuată!  Acum sunteți înscris la cursul dorit.:<br />"{$a}"';
$string['pendingrequests'] = 'Cereri în așteptare';
$string['percents'] = '{$a}%';
$string['periodending'] = 'Perioadă ({$a})';
$string['perpage'] = 'Per pagină';
$string['perpagea'] = 'Per pagină: {$a}';
$string['personal'] = 'Personal';
$string['personalprofile'] = 'Profil personal';
$string['phone'] = 'Telefon';
$string['phone1'] = 'Telefon';
$string['phone2'] = 'Telefon mobil';
$string['phpinfo'] = 'Informații PHP';
$string['picture'] = 'Fotografie';
$string['pictureof'] = 'Fotografia lui {$a}';
$string['pictureofuser'] = 'Fotografia utilizatorului';
$string['placeholdertypeorselect'] = 'Tastează sau selectează ...';
$string['pleaseclose'] = 'Închide această fereastră acum.';
$string['pleasesearchmore'] = 'Vă rugăm să căutați mai multe';
$string['pleaseusesearch'] = 'Vă rugăm să utilizați căutarea';
$string['plugin'] = 'Plugin';
$string['pluginarea'] = 'Zonă';
$string['plugincheck'] = 'Verificare plugin-uri';
$string['plugindeletefiles'] = 'Toate datele asociate cu plugin-ul "{$a->name}" au fost șterse din baza de date. Pentru a preveni reinstalarea plugin-ului, ar trebui să ștergeți acum acest director de pe server: {$a->directory}';
$string['pluginitemid'] = 'Identificator element';
$string['pluginmissingfromdisk'] = '{$a->name} (Missing from disk)';
$string['pluginsetup'] = 'Configurarea tabelelor pentru plugin-uri';
$string['policyaccept'] = 'Înțeleg și sunt de acord';
$string['policyagree'] = 'Trebuie să fiți de acord cu această politică, pentru a continua să utilizați acest site.  Sunteți de acord?';
$string['policyagreement'] = 'Acord privind politica site-ului';
$string['policyagreementclick'] = 'Acord privind politica site-ului';
$string['popup'] = 'popup';
$string['popupwindow'] = 'Deschide fișierul într-o fereastră nouă';
$string['popupwindowname'] = 'Fereastră pop-up';
$string['post'] = 'Postare';
$string['posts'] = 'Postări';
$string['potentialadmins'] = 'Administratori potențiali';
$string['potentialcreators'] = 'Creatori potențiali de curs';
$string['potentialstudents'] = 'Cursanți potențiali';
$string['potentialteachers'] = 'Formatori potențiali';
$string['poweredbymoodle'] = 'Furnizat de <a href="https://moodle.com">Moodle</a>';
$string['preferences'] = 'Preferințe';
$string['preferredlanguage'] = 'Limbă preferată';
$string['preferredtheme'] = 'Temă preferată';
$string['preprocessingbackupfile'] = 'Procesarea preliminară a fișierului de backup';
$string['prev'] = 'Prev';
$string['preview'] = 'Previzualizare';
$string['previeworchoose'] = 'Previzualizați sau alegeți o temă';
$string['previewthemename'] = 'Previzualizare tema \'{$a}\'';
$string['previous'] = 'Anterior';
$string['previouslyselectedusers'] = 'Utilizatorii selectați anterior nu se potrivesc "{$a}"';
$string['previouspage'] = 'Pagina anterioară';
$string['previoussection'] = 'Secțiunea anterioară';
$string['primaryadminsetup'] = 'Configurați contul de administrator';
$string['privacy:metadata:config_log'] = 'Jurnalul de configurare se modifică.';
$string['privacy:metadata:config_log:name'] = 'Numele setării se schimbă.';
$string['privacy:metadata:config_log:oldvalue'] = 'Valoarea anterioară pentru această setare.';
$string['privacy:metadata:config_log:plugin'] = 'Plugin-ul a fost modificat.';
$string['privacy:metadata:config_log:timemodified'] = 'Momentul în care s-a făcut schimbarea.';
$string['privacy:metadata:config_log:userid'] = 'Utilizatorul care a făcut modificarea.';
$string['privacy:metadata:config_log:value'] = 'Noua valoare pentru această setare.';
$string['privacy:metadata:events_queue'] = 'Coada evenimentelor utilizatorilor care așteaptă să fie procesată.';
$string['privacy:metadata:events_queue:eventdata'] = 'Datele stocate în eveniment.';
$string['privacy:metadata:events_queue:stackdump'] = 'Orice proces asociat cu acest eveniment.';
$string['privacy:metadata:events_queue:timecreated'] = 'Ora la care a fost creat acest eveniment.';
$string['privacy:metadata:events_queue:userid'] = 'ID-ul de utilizator asociat acestui eveniment';
$string['privacy:metadata:log'] = 'O colecție de evenimente din trecut';
$string['privacy:metadata:log:action'] = 'O descriere a acțiunii';
$string['privacy:metadata:log:cmid'] = 'cmid';
$string['privacy:metadata:log:course'] = 'curs';
$string['privacy:metadata:log:info'] = 'Informatii suplimentare';
$string['privacy:metadata:log:ip'] = 'Adresa IP utilizată în momentul evenimentului';
$string['privacy:metadata:log:module'] = 'modul';
$string['privacy:metadata:log:time'] = 'Momentul în care a avut loc acțiunea';
$string['privacy:metadata:log:url'] = 'Adresa URL aferentă evenimentului';
$string['privacy:metadata:log:userid'] = 'ID-ul utilizatorului care a realizat acțiunea';
$string['privacy:metadata:moodlenet_share_progress'] = 'Detaliile partajării progresului în MoodleNet';
$string['privacy:metadata:moodlenet_share_progress:cmid'] = 'ID-ul modulului de curs asociat';
$string['privacy:metadata:moodlenet_share_progress:courseid'] = 'ID-ul cursului asociat';
$string['privacy:metadata:moodlenet_share_progress:resourceurl'] = 'Adresa URL returnată de MoodleNet după o distribuire cu succes.';
$string['privacy:metadata:moodlenet_share_progress:status'] = 'Statutus-ul rezultat al partajării';
$string['privacy:metadata:moodlenet_share_progress:timecreated'] = 'Când s-a efectuat distribuirea';
$string['privacy:metadata:moodlenet_share_progress:type'] = 'Tipul de distribuire care s-a efectuat';
$string['privacy:metadata:moodlenet_share_progress:userid'] = 'Utilizatorul care a efectuat distribuirea';
$string['privacy:metadata:oauth2_refresh_token'] = 'Actualizați tokenul utilizat în comunicarea OAuth 2.0';
$string['privacy:metadata:oauth2_refresh_token:issuerid'] = 'ID-ul emitentului căruia îi corespunde tokenul';
$string['privacy:metadata:oauth2_refresh_token:scopehash'] = 'ID-ul utilizatorului căruia îi corespunde tokenul';
$string['privacy:metadata:oauth2_refresh_token:timecreated'] = 'Când a fost creat token-ul';
$string['privacy:metadata:oauth2_refresh_token:timemodified'] = 'Când a fost actualizat token-ul ultima dată';
$string['privacy:metadata:oauth2_refresh_token:token'] = 'Tokenul de reîmprospătare pentru domeniile și utilizatorul respectiv';
$string['privacy:metadata:oauth2_refresh_token:userid'] = 'ID-ul utilizatorului căruia îi corespunde jetonul';
$string['privacy:metadata:task_adhoc'] = 'Starea sarcinilor ad hoc.';
$string['privacy:metadata:task_adhoc:component'] = 'Componenta care deține sarcina.';
$string['privacy:metadata:task_adhoc:nextruntime'] = 'Utilizatorul care va rula această sarcină de lucru';
$string['privacy:metadata:task_adhoc:userid'] = 'Utilizatorul care va rula această sarcină  de lucru';
$string['privacy:metadata:task_log'] = 'Afișare date un jurnalizate';
$string['privacy:metadata:task_log:component'] = 'Componenta care deține sarcina.';
$string['privacy:metadata:task_log:userid'] = 'Utilizatorul căruia i-a aparținut sarcina.';
$string['privacy:metadata:upgrade_log'] = 'Jurnalul de actualizare.';
$string['privacy:metadata:upgrade_log:backtrace'] = 'Orice urmărire asociată cu acest pas de actualizare.';
$string['privacy:metadata:upgrade_log:details'] = 'Informații suplimentare referitoare la upgrade.';
$string['privacy:metadata:upgrade_log:info'] = 'Informațiile pricipale pentru această etapă a actualizării.';
$string['privacy:metadata:upgrade_log:plugin'] = 'Plugin-ul care a fost actualizat.';
$string['privacy:metadata:upgrade_log:targetversion'] = 'Noua versiune care trebuie actualizată.';
$string['privacy:metadata:upgrade_log:timemodified'] = 'Ora la care a avut loc actualizarea.';
$string['privacy:metadata:upgrade_log:type'] = 'Tipul de intrare jurnal.';
$string['privacy:metadata:upgrade_log:userid'] = 'Utilizatorul care a efectuat actualizarea.';
$string['privacy:metadata:upgrade_log:version'] = 'Vechea versiune a plugin-ului.';
$string['private_files_handler'] = 'Stocați atașamente unui e-mail în spațiul de stocare a fișierelor private ale utilizatorului.';
$string['private_files_handler_name'] = 'E-mail către fișiere private';
$string['privatefiles'] = 'Fișiere private';
$string['privatefilesmanage'] = 'Gestionați fișierele private';
$string['proceed'] = 'Continuă';
$string['profile'] = 'Profil';
$string['profilenotshown'] = 'Această descriere a profilului nu va fi afișată, până când această persoană nu este înscrisă la cel puțin un curs.';
$string['progress'] = 'Progres';
$string['publicprofile'] = 'Profil public';
$string['publicsitefileswarning'] = 'Notă: fișierele plasate aici pot fi accesate de orice utilizator';
$string['publicsitefileswarning2'] = 'Notă: fișierele plasate aici pot fi accesate de oricine știe (sau poate ghici) adresa URL. Din motive de securitate, se recomandă ca orice fișier de backup să fie șters imediat după restaurare.';
$string['publicsitefileswarning3'] = 'Notă: fișierele plasate aici pot fi accesate de oricine știe (sau poate ghici) adresa URL. <br />Din motive de securitate, se recomandă ca orice fișier de backup să fie salvat doar în folderul securizat de date de backup.';
$string['question'] = 'Întrebare';
$string['questionsinthequestionbank'] = 'Întrebări în banca de întrebări';
$string['queued'] = 'Pus în așteptare';
$string['quotausage'] = 'Până în prezent ați utilizat {$a->used} din limita dumneavoastră de {$a->total}.';
$string['readinginfofrombackup'] = 'Citirea informațiilor din backup';
$string['readme'] = 'CITEȘTE-MĂ';
$string['recentactivity'] = 'Activitate recentă';
$string['recentactivityreport'] = 'Raportul complet al activității recente...';
$string['recipientslist'] = 'Listă destinatari';
$string['recommended'] = 'Recomandat';
$string['recreatedcategory'] = 'Categorie recreată {$a}';
$string['redirect'] = 'Redirecționează';
$string['reducesections'] = 'Reduce numărul de secțiuni';
$string['refresh'] = 'Reîncarcă';
$string['refreshingevents'] = 'Reîncărcarea evenimentelor';
$string['registration'] = 'Înregistrare Moodle';
$string['registrationcontact'] = 'Contact din partea publicului';
$string['registrationcontactno'] = 'Nu, nu doresc să fiu contactat de alte persoane';
$string['registrationcontactyes'] = 'Da, furnizați un formular pentru ca alți Moodlers să mă contacteze';
$string['registrationemail'] = 'Notificări prin e-mail';
$string['registrationinfo'] = '<p>Această pagină vă permite să vă înregistrați site-ul Moodle la moodle.org..
Principalul avantaj al înregistrării este că veți fi adăugat la o listă de corespondență cu volum redus
pentru notificări importante, cum ar fi alertele de securitate și noile versiuni de Moodle.</p>
<p>În mod implicit, informațiile dvs. vor fi păstrate ca date confidențiale și nu vor fi niciodată vândute sau transmise altcuiva. Singurul
    motiv pentru colectarea acestor informații constă în asistența și susținerea construirii unei imagini statistice a comunității Moodle în ansamblu..</p>
<p>Dacă alegeți, puteți permite ca numele site-ului dvs., țara și adresa URL să fie adăugate la lista publică a site-urilor Moodle.</p>
<p>Toate noile înregistrări sunt verificate manual, înainte de a fi adăugate la listă, dar odată ce au fost adăugate, puteți actualiza înregistrarea (și intrarea pe lista publică) în orice moment, trimițând din nou acest formular.</p>';
$string['registrationinfotitle'] = 'Informaţii de înregistrare';
$string['registrationsend'] = 'Trimiteți informațiile de înregistrare la moodle.org';
$string['registrationyes'] = 'Da, anunțați-mă despre noile versiuni Moodle, alerte de securitate și alte noutăți importante';
$string['reject'] = 'Respinge';
$string['rejectdots'] = 'Respinge...';
$string['relativedatesmode'] = 'Mod date relative';
$string['relativedatesmode_help'] = 'Afișați datele cursului sau ale activității în raport cu data de începere a utilizatorului în curs.

Data de începere a cursului utilizatorului va fi data de începere a înscrierii, cu excepția cazului în care este înscris înainte de începerea cursului, caz în care data de începere a acestora va fi data de începere a cursului.

AVERTISMENT: Aceasta este o caracteristică experimentală și nu toate activitățile o pot susține. Odată ce cursul a fost creat, această setare a cursului nu mai poate fi modificată.';
$string['relativedatesmode_warning'] = '<strong> Avertisment: </strong> modul de date relative nu poate fi schimbat după ce a fost creat cursul.';
$string['reload'] = 'Reîncarcă';
$string['remoteappuser'] = 'Utilizator {$a} de la distanță';
$string['remove'] = 'Elimină';
$string['removeadmin'] = 'Elimină administrator';
$string['removecreator'] = 'Elimină creator curs';
$string['removestudent'] = 'Elimină cursant';
$string['removeteacher'] = 'Elimină formator';
$string['rename'] = 'Redenumește';
$string['renamefileto'] = 'Redenumește <b>{$a}</b> la';
$string['report'] = 'Raport';
$string['reports'] = 'Rapoarte';
$string['reporttype'] = 'Tip de raport';
$string['repositories'] = 'Depozite';
$string['requestcourse'] = 'Solicită un curs';
$string['requestedby'] = 'Solicitat de';
$string['requestedcourses'] = 'Cursuri solicitate';
$string['requestreason'] = 'Motivul respingerii cursului';
$string['requests'] = 'Solicitări';
$string['required'] = 'Necesar';
$string['requirespayment'] = 'Acest curs trebuie plătit pentru a obține acces la el';
$string['resendemail'] = 'Retrimite email de confirmare';
$string['reset'] = 'Resetează';
$string['resetcomponent'] = 'Componentă';
$string['resetcourse'] = 'Resetează curs';
$string['resetcourseconfirm'] = 'Resetați cursul?';
$string['resetcoursewarning'] = 'Sunteți sigur(ă) că doriți să resetați cursul?
<br/><br/>
Se vor șterge datele selectate și se va reseta cursul la statusul inițial. Nu puteți anula această acțiune.';
$string['resetinfo'] = 'Această funcționalitate vă permite să ștergeți toate datele utilizatorului și să resetați cursul la statusul inițial. Activitățile și setările cursului rămân neschimbate.';
$string['resetinfoselect'] = 'Selectați datele pe care doriți să le ștergeți sau să le resetați din categoriile de mai jos:';
$string['resetnotimplemented'] = 'Resetarea nesuportată';
$string['resetnotimplementedinfo'] = 'Aceste activități nu pot fi resetate:';
$string['resetrecordexpired'] = 'Link-ul de resetare a parolei pe care l-ați folosit este mai vechi de {$a} minute și a expirat. Vă rugăm să inițiați o nouă resetare a parolei.';
$string['resetstartdate'] = 'Resetează data de începere';
$string['resetstatus'] = 'Status';
$string['resettable'] = 'Resetați preferințele tabelului';
$string['resettask'] = 'Resetare';
$string['resettodefaults'] = 'Reveniți la valorile implicite';
$string['resortcourses'] = 'Sortează cursurile';
$string['resortsubcategoriesby'] = 'Sortează subcategoriile în {$a} crescătoare';
$string['resortsubcategoriesbyreverse'] = 'Sortează subcategoriile în {$a} descrescătoare';
$string['resource'] = 'Resursă';
$string['resourcedisplayauto'] = 'Automat';
$string['resourcedisplaydownload'] = 'Impune descărcarea';
$string['resourcedisplayembed'] = 'Încorporează';
$string['resourcedisplayframe'] = 'În cadru';
$string['resourcedisplaynew'] = 'Fereastră nouă';
$string['resourcedisplayopen'] = 'Deschide';
$string['resourcedisplaypopup'] = 'În pop-up';
$string['resources'] = 'Resurse';
$string['resources_help'] = 'Tipurile de resurse permit inserarea în curs a oricărui tip de conținut web.';
$string['restore'] = 'Restaurează';
$string['restorecancelled'] = 'Restabilire anulată';
$string['restorecannotassignroles'] = 'Restaurarea trebuie să atribuie roluri și nu aveți permisiunea de a face acest lucru';
$string['restorecannotcreateorassignroles'] = 'Restaurarea trebuie să creeze sau să atribuie roluri și nu aveți permisiunea de a face acest lucru';
$string['restorecannotcreateuser'] = 'Restabilirea trebuie să creeze utilizatorul "{$a}" din fișierul backup file și nu aveți permisiunea de a face acest lucru';
$string['restorecannotoverrideperms'] = 'Restabilirea trebuie să înlocuiască permisiunile și nu aveți voie să faceți acest lucru';
$string['restorecoursenow'] = 'Restaurează acest curs acum!';
$string['restoredaccount'] = 'Cont restabilit';
$string['restoredaccountinfo'] = 'Acest cont a fost importat de pe alt server și parola a fost pierdută. Pentru a seta o nouă parolă prin e-mail, faceți click pe „Continuați”';
$string['restorefinished'] = 'Restabiilire finalizată cu succes';
$string['restoreinfo'] = 'Utilizează un fișier de rezervă pentru a restaura o versiune anterioară a unui curs sau pentru a crea un nou curs.';
$string['restoremnethostidmismatch'] = 'ID-ul de gazdă MNet al utilizatorului "{$a}"  nu se potrivește cu ID-ul de gazdă MNet local.';
$string['restoreto'] = 'Reveniți la';
$string['restoretositeadding'] = 'Avertisment: sunteți pe cale să restabiliți pagina de pornire a site-ului, adăugând date la acesta!';
$string['restoretositedeleting'] = 'Avertisment: sunteți pe cale să restabiliți pagina de pornire a site-ului, ștergând mai întâi datele din acesta!';
$string['restoreuserconflict'] = 'Încercarea de a restabili utilizatorul "{$a}" din fișierul de rezervă va provoca conflicte';
$string['restoreuserinfofailed'] = 'Procesul de restabilire s-a oprit, deoarece nu aveți permisiunea de a restabili datele utilizatorului.';
$string['restoreusersprecheck'] = 'Verificarea datelor utilizatorului';
$string['restoreusersprecheckerror'] = 'Unele probleme au fost detectate la verificarea datelor utilizatorului';
$string['restricted'] = 'Restricționat!';
$string['resultsfound'] = '{$a} rezultate găsite';
$string['retry'] = 'Încercați din nou';
$string['returningtosite'] = 'Reveniți la acest site web?';
$string['returntooriginaluser'] = 'Reveniți la {$a}';
$string['revert'] = 'Revenit';
$string['role'] = 'Rol';
$string['roleassignments'] = 'Alocări rol';
$string['rolemappings'] = 'Cartografieri rolului';
$string['rolerenaming'] = 'Redenumirea rolului';
$string['rolerenaming_help'] = 'Modifică afișarea denumirii rolurilor în acest curs.';
$string['rolerenaming_success'] = 'Denumirea rolurilor din curs a fost actualizată.';
$string['roles'] = 'Roluri';
$string['rss'] = 'RSS';
$string['rssarticles'] = 'Numărul de articole RSS recente';
$string['rsserror'] = 'Eroare la citirea datelor RSS';
$string['rsserrorauth'] = 'Link-ul dumneavoastră RSS linkul nu conține un indicativ de autentificare valid.';
$string['rsserrorguest'] = 'Acest flux folosește conectarea vizitatorilor pentru a accesa datele, fără ca aceștia să aibă permisiunea de a citi datele. Accesați locația originală din care provine acest flux (URL) ca utilizator valid și obțineți un nou link RSS de acolo.';
$string['rsskeyshelp'] = '<p> Pentru a asigura securitatea și confidențialitatea, adresele URL ale fluxului RSS conțin un simbol special care identifică utilizatorul pentru care sunt. Acest lucru împiedică ceilalți utilizatori să acceseze zone ale site-ului în care nu sunt permise. </p> <p> Tokenul este creat automat prima dată când accesați o zonă care produce un flux RSS. Dacă credeți că jetonul dvs. de flux RSS a fost compromis, puteți solicita unul nou făcând clic pe linkul de resetare. Rețineți că adresele URL curente ale fluxului RSS vor deveni nevalide. </p>';
$string['rsstype'] = 'Flux RSS pentru această activitate';
$string['save'] = 'Salvare';
$string['saveandnext'] = 'Salvează și afișează următoarele';
$string['savechanges'] = 'Salvează modificările';
$string['savechangesanddisplay'] = 'Salvează și afișează';
$string['savechangesandreturn'] = 'Salvează și revino';
$string['savechangesandreturntocourse'] = 'Salvează și revino la curs';
$string['savecomment'] = 'Salvează comentariile';
$string['savedat'] = 'Salvat la:';
$string['savepreferences'] = 'Salvează preferințele';
$string['saveto'] = 'Salvează la';
$string['scale'] = 'Scală';
$string['scale_help'] = 'O scală de notare oferă o modalitate de evaluare sau notare a performanței dintr-o activitate. Este definită de o listă ordonată de valori, de la negative la pozitive, separate prin virgule, de exemplu „Dezamăgitor, Insuficient de bun, Mediu, Bun, Foarte bun, Excelent!”';
$string['scale_link'] = 'notă/ scară de notare';
$string['scales'] = 'Scală de notare';
$string['scalescustom'] = 'Scală de notare personalizată';
$string['scalescustomcreate'] = 'Adaugă o nouă scală de notare';
$string['scalescustomno'] = 'Nu s-a creat încă o scală personalizată de notare';
$string['scalesstandard'] = 'Scală standard de notare';
$string['scalestandard'] = 'Scală standard de notare';
$string['scalestandard_help'] = 'O scală standard de notare este disponibilă la nivel de site, pentru toate cursurile.';
$string['scalestandard_link'] = 'notă/scară de notare';
$string['scalestip'] = 'Pentru a crea scări personalizate de notare, utilizați linkul "Scale..." din meniul de administrare a cursului.';
$string['scalestip2'] = 'Pentru a crea scale personalizate de notare, dați click pe link-ul Note din meniul de administrare a cursului, apoi alegeți Editare, Scală de notare.';
$string['schedule'] = 'Planificare';
$string['screenshot'] = 'Captură de ecran';
$string['search'] = 'Caută';
$string['search_help'] = 'Pentru căutarea de bază a unuia sau a mai multor cuvinte oriunde în text, trebuie doar să le tastați separat prin spații. Se folosesc toate cuvintele mai lungi de două caractere.

Pentru căutare avansată, apăsați butonul de căutare, fără să tastați ceva în caseta de căutare, pentru a accesa formularul de căutare avansată.';
$string['searchactivities'] = 'Caută activități după denumire sau după descriere';
$string['searchagain'] = 'Caută din nou';
$string['searchbyemail'] = 'Căutați după adresa de e-mail';
$string['searchbyusername'] = 'Căutare după nume de utilizator';
$string['searchcoursecategories'] = 'Caută categorii';
$string['searchcourses'] = 'Caută cursuri';
$string['searchgroups'] = 'Caută grupuri';
$string['searchitems'] = 'Caută elemente';
$string['searchoptions'] = 'Opțiuni căutare';
$string['searchresults'] = 'Rezultate căutare';
$string['searchusers'] = 'Caută utilizatori';
$string['sec'] = 'sec';
$string['seconds'] = 'secunde';
$string['secondsleft'] = '{$a} secunde';
$string['secondstotime172800'] = '2 zile';
$string['secondstotime259200'] = '3 zile';
$string['secondstotime345600'] = '4 zile';
$string['secondstotime432000'] = '5 zile';
$string['secondstotime518400'] = '6 zile';
$string['secondstotime604800'] = '1 săptămână';
$string['secondstotime86400'] = '1 zi';
$string['secretalreadyused'] = 'Link-ul de confirmare a modificării parolei a fost deja utilizat, parola nu a fost modificată.';
$string['secs'] = 'secunde';
$string['section'] = 'Secțiune';
$string['sectionactionnotsupported'] = 'Acțiunea secțiunii „{$a}” nu este acceptată aici';
$string['sectionname'] = 'Nume secțiune';
$string['sectionoutline'] = 'Contur secțiune';
$string['sections'] = 'Secțiuni';
$string['seealsostats'] = 'Vezi și: statistici';
$string['selctauser'] = 'Selectați un utilizator';
$string['select'] = 'Selectează';
$string['selectacategory'] = 'Vă rugăm să selectați o categorie';
$string['selectacountry'] = 'Selectează o țară';
$string['selectacourse'] = 'Selectează un curs';
$string['selectacoursesite'] = 'Selectează un curs sau un site';
$string['selectagroup'] = 'Selectează un grup';
$string['selectall'] = 'Selectează totul';
$string['selectallusersonpage'] = 'Selectați toți utilizatorii de pe această pagină';
$string['selectalluserswithcount'] = 'Selectați toți {$a} utilizatorii';
$string['selectamodule'] = 'Vă rugăm să selectați o activitate Modul';
$string['selectanaction'] = 'Selectează o acțiune';
$string['selectanoptions'] = 'Selectează o opțiune';
$string['selectaregion'] = 'Selectează o regiune';
$string['selectcategorysort'] = 'Ce categorii ați dori să sortați?';
$string['selectcategorysortby'] = 'Selectați modul în care doriți să sortați categoriile';
$string['selectcoursesortby'] = 'Selectați modul în care doriți să sortați cursurile';
$string['selectdefault'] = 'Selectați implicit';
$string['selectedcategories'] = 'Categorii selectate';
$string['selectedfile'] = 'Fișier selectat';
$string['selectednowmove'] = '{$a} fișiere selectate pentru mutare. Acum intrați în folderul de destinație și apăsați "Mutați fișierele aici"';
$string['selectfiles'] = 'Selectati fișierele';
$string['selectfiltertype'] = 'Selectează';
$string['selectgroupsseparate'] = 'Selectează grupuri separate';
$string['selectgroupsvisible'] = 'Selectează grupuri vizibile';
$string['selectitem'] = 'Selectează \'{$a}\'';
$string['selectmoduletoviewhelp'] = 'Selectați o activitate sau o resursă pentru a vedea ajutorul acestuia.

Faceți dublu clic pe o activitate sau pe un nume de resursă pentru ao adăuga rapid.';
$string['selectnos'] = 'Selectează toate \'Nu\'';
$string['selectperiod'] = 'Selectează perioada';
$string['selecttheme'] = 'Selectează tema';
$string['selectthemename'] = 'Selectează tema \'{$a}\'';
$string['senddetails'] = 'Trimiteți datele mele prin e-mail';
$string['sent'] = 'Trimis';
$string['separate'] = 'Separă';
$string['separateandconnected'] = 'Modalități separate și conectate de cunoaștere';
$string['separateandconnected1'] = 'Cunoașterea separată';
$string['separateandconnected2'] = 'Atât separată cât şi legată';
$string['separateandconnected3'] = 'Cunoașterea legată';
$string['separateandconnectedinfo'] = 'Scara bazată pe teoria cunoașterii separate și conectate. Această teorie descrie două moduri diferite prin care putem evalua și învăța despre lucrurile pe care le vedem și le auzim. <ul> <li> <strong> Cunoștințele separate </strong> rămân cât mai obiective posibil fără a include sentimente și emoții. Într-o discuție cu alte persoane, le place să-și apere propriile idei, folosind logica pentru a găsi găuri în ideile adversarului. </li> <li> <strong> Cunoscătorii conectați </strong> sunt mai sensibili la alte persoane. Sunt pricepuți la empatie și tind să asculte și să pună întrebări până când simt că se pot conecta și „înțelege lucrurile din punctul lor de vedere”. Ei învață încercând să împărtășească experiențele care au condus la cunoștințele pe care le găsesc la alte persoane. </li> </ul>';
$string['servererror'] = 'A apărut o eroare la comunicarea cu serverul';
$string['serverlocaltime'] = 'Ora locală a server-ului';
$string['sessionforceclean'] = 'Ca măsură de siguranță, scripturile generate de utilizatori au fost dezactivate în cadrul acestei sesiuni.';
$string['sessiontimeoutsoon'] = 'Sesiunea dumneavoastră urmează să se încheie. Doriți să extindeți sesiunea curentă?';
$string['setcategorytheme'] = 'Setați tema categoriei';
$string['setmode'] = 'Setează modul';
$string['setpassword'] = 'Setează parola';
$string['setpasswordinstructions'] = 'Vă rugăm să introduceți noua parolă mai jos, apoi să salvați modificările.';
$string['settings'] = 'Setări';
$string['share'] = 'Partajează';
$string['shortname'] = 'Denumire prescurtată';
$string['shortnamecollisionwarning'] = '[*] = Această prescurtare a numelui este deja utilizată de un curs și va trebui să fie modificată după aprobare';
$string['shortnamecourse'] = 'Denumirea scurtă a cursului';
$string['shortnamecourse_help'] = 'Numele afișat în zonele cu spațiu limitat. Trebuie să fie unic.';
$string['shortnametaken'] = 'Denumirea prescurtată este deja utilizată pentru alt curs ({$a})';
$string['shortnameuser'] = 'Numele scurt al utilizatorului';
$string['shortsitename'] = 'Numele scurt pentru site (de exemplu, un singur cuvânt)';
$string['show'] = 'Afișează';
$string['showactions'] = 'Afișează acțiuni';
$string['showactivitydates'] = 'Afișați datele activității';
$string['showactivitydates_help'] = 'Afișează datele activității pe pagina de curs.';
$string['showadvancededitor'] = 'Avansat';
$string['showadvancedsettings'] = 'Afișează setările avansate';
$string['showall'] = 'Afișează tot {$a}';
$string['showallcourses'] = 'Afișează toate cursurile';
$string['showblockcourse'] = 'Afișează lista cursurilor care conțin blocuri';
$string['showcategory'] = 'Afișează {$a}';
$string['showchartdata'] = 'Afișează datele graficului';
$string['showcomments'] = 'Afișează/ ascunde comentarii';
$string['showcommentsnonjs'] = 'Afișează comentariile';
$string['showdescription'] = 'Afișează descrierea pe pagina cursului';
$string['showdescription_help'] = 'Dacă este activată, descrierea de mai sus va fi afișată pe pagina cursului, chiar sub link-ul către activitate sau resursă.';
$string['showgrades'] = 'Carnetul de note este afișat pentru cursanți';
$string['showgrades_help'] = 'Permite cursanților să vadă o listă cu notele lor în pagina de curs.';
$string['showingacourses'] = 'Se afișează toate {$a} cursuri';
$string['showingxofycourses'] = 'Afișarea cursurilor {$a->start} la {$a->end} din {$a->total} cursuri';
$string['showless'] = 'Afișează mai puțin';
$string['showlistofcourses'] = 'Afișează lista cursurilor';
$string['showmodulecourse'] = 'Afișează lista cursurilor care conțin activitate';
$string['showmore'] = 'Afișează mai mult';
$string['showoncoursepage'] = 'Afișare pe pagina cursului';
$string['showonly'] = 'Afișează numai';
$string['showperpage'] = 'Afișează {$a} pe pagină';
$string['showpopoverwindow'] = 'Afișează fereastra popover';
$string['showrecent'] = 'Afișează activitatea recentă';
$string['showreports'] = 'Afișează rapoarte de activitate';
$string['showreports_help'] = 'Permite cursanților să își vadă rapoartele activității prin pagina de profil.';
$string['showsettings'] = 'Afișează setările';
$string['showtheselogs'] = 'Afișează aceste jurnale';
$string['showthishelpinlanguage'] = 'Afișează această asistență în limba: {$a}';
$string['sidepanel'] = 'Panou lateral';
$string['signoutofotherservices'] = 'Deconectați-vă de la toate web apps';
$string['signoutofotherservices_help'] = 'Deconectați-vă de la toate dispozitivele și sistemele care utilizează servicii web, de exemplu aplicația mobilă. Sesiunile de browser vor rămâne active.';
$string['since'] = 'De când';
$string['sincelast'] = 'de la ultima conectare';
$string['site'] = 'Site';
$string['sitedefault'] = 'Site implicit';
$string['sitedefaultspecified'] = 'Site implicit ({$a})';
$string['siteerrors'] = 'Erori site';
$string['sitefiles'] = 'Fișiere site';
$string['sitefilesused'] = 'Fișierele site-ului utilizate în acest curs';
$string['sitehome'] = 'Pagina principală';
$string['sitelegacyfiles'] = 'Fișiere de site vechi';
$string['sitelogs'] = 'Jurnalele site-ului';
$string['sitenews'] = 'Anunțuri pe site';
$string['sitepages'] = 'Paginile site-ului';
$string['sitepartlist'] = 'Nu aveți permisiunile necesare pentru a vizualiza lista de participanți';
$string['sitepartlist0'] = 'Trebuie să fiți formator de site pentru a avea permisiunea de a vedea lista participanților site-ului';
$string['sitepartlist1'] = 'Trebuie să fiți formator pentru a avea permisiunea de a vedea lista participanților site-ului';
$string['sites'] = 'Site-uri';
$string['sitesection'] = 'Adăugare conținut personalizat';
$string['sitesettings'] = 'Setările site-ului';
$string['siteteachers'] = 'Formatori site';
$string['size'] = 'Dimensiune';
$string['sizeb'] = 'biți';
$string['sizegb'] = 'GB';
$string['sizekb'] = 'KB';
$string['sizemb'] = 'MB';
$string['sizepb'] = 'PB';
$string['sizetb'] = 'TB';
$string['skipped'] = 'Omis';
$string['skiptocategorylisting'] = 'Treci la listele de categorii';
$string['skiptocoursedetails'] = 'Treci la informațiile detaliate despre curs';
$string['skiptocourselisting'] = 'Treci la listele cursurilor';
$string['someallowguest'] = 'Unele cursuri pot permite accesul vizitatorilor';
$string['someerrorswerefound'] = 'Unele informații lipseau sau erau incorecte. Uitați-vă mai jos pentru detalii.';
$string['sort'] = 'Sortează';
$string['sortby'] = 'Sortează după';
$string['sortbyx'] = 'Sortează după {$a} ascendent';
$string['sortbyxreverse'] = 'Sortează după {$a} descendent';
$string['sorting'] = 'Sortare';
$string['sourcerole'] = 'Rol sursă';
$string['specifyname'] = 'Trebuie să specificați un nume.';
$string['standard'] = 'Standard';
$string['starpending'] = '([*] = curs în așteptarea aprobării)';
$string['startdate'] = 'Data de începere a cursului';
$string['startdate_help'] = 'Această dată determină începutul primei săptămâni pentru un curs în format săptămânal. Este, de asemenea, data de începere a jurnalelor de activități ale cursului.

Dacă resetezi cursul și modifici această dată, toate datele din curs vor fi mutate în raport cu noua dată de începere.';
$string['startdatewithtaskenabled'] = 'Data începerii cursului';
$string['startdatewithtaskenabled_help'] = 'Data la care cursul devine vizibil pentru studenți. Înainte de această dată, aceștia nu vor putea accesa cursul.

Această dată determină, de asemenea, începutul primei săptămâni pentru un curs în format săptămânal și este data de începere a jurnalelor de activități ale cursului. Dacă resetați cursul și modificați această dată, toate datele din curs vor fi mutate în raport cu noua dată de începere.';
$string['startingfrom'] = 'Începând de la';
$string['startsignup'] = 'Creează un cont nou';
$string['state'] = 'Stat/ Provincie';
$string['statistics'] = 'Statistici';
$string['statisticsgraph'] = 'Grafic de statistici';
$string['stats'] = 'Statistici';
$string['statslogins'] = 'Conectări';
$string['statsmodedetailed'] = 'Vizualizare detaliată (utilizator)';
$string['statsmodegeneral'] = 'Vedere generală';
$string['statsnodata'] = 'Nu există date disponibile pentru această combinație de curs și perioadă de timp.';
$string['statsnodatauser'] = 'Nu există date disponibile pentru această combinație de curs, utilizator și perioadă de timp.';
$string['statsoff'] = 'Statisticile nu sunt activate în prezent';
$string['statsreads'] = 'Vizualizări';
$string['statsreport1'] = 'Conectări';
$string['statsreport10'] = 'Activitatea utilizatorului';
$string['statsreport11'] = 'Cele mai active cursuri';
$string['statsreport12'] = 'Cele mai active cursuri (ponderate)';
$string['statsreport13'] = 'Cele mai multe cursuri participative (înscrieri)';
$string['statsreport14'] = 'Cele mai multe cursuri participative (vizualizări/ postări)';
$string['statsreport2'] = 'Vizualizări (toate rolurile)';
$string['statsreport3'] = 'Postări (toate rolurile)';
$string['statsreport4'] = 'Toate activitățile (toate rolurile)';
$string['statsreport5'] = 'Toate activitățile (vizualizări și postări)';
$string['statsreport7'] = 'Activitatea utilizatorului (vizualizări și postări)';
$string['statsreport8'] = 'Toată activitatea utilizatorului';
$string['statsreport9'] = 'Conectări (curs site)';
$string['statsreportactivity'] = 'Toate activitățile (toate rolurile)';
$string['statsreportactivitybyrole'] = 'Toate activitățile (vizualizări și postări)';
$string['statsreportforuser'] = 'pentru';
$string['statsreportlogins'] = 'Conectări';
$string['statsreportreads'] = 'Vizualizări (toate rolurile)';
$string['statsreporttype'] = 'Tip raport';
$string['statsreportwrites'] = 'Postări (toate rolurile)';
$string['statsstudentactivity'] = 'Activitatea cursanților';
$string['statsstudentreads'] = 'Vizualizările cursanților';
$string['statsstudentwrites'] = 'Postările cursanților';
$string['statsteacheractivity'] = 'Activitatea formatorului';
$string['statsteacherreads'] = 'Vizualizările formatorului';
$string['statsteacherwrites'] = 'Postările formatorului';
$string['statstimeperiod'] = 'Perioada de timp - ultima:';
$string['statsuniquelogins'] = 'Conectări unice';
$string['statsuseractivity'] = 'Toate activitățile';
$string['statsuserlogins'] = 'Conectări';
$string['statsuserreads'] = 'Vizualizări';
$string['statsuserwrites'] = 'Postări';
$string['statswrites'] = 'Postări';
$string['status'] = 'Status';
$string['statuschecks'] = 'Verificări status';
$string['statuscritical'] = 'Critic';
$string['statusdone'] = 'Realizat';
$string['statuserror'] = 'Eroare';
$string['statusinfo'] = 'Info';
$string['statusna'] = 'N/A';
$string['statusok'] = 'OK';
$string['statusunknown'] = 'Necunoscut';
$string['statuswarning'] = 'Avertizare';
$string['stringsnotset'] = 'Următoarele șiruri nu sunt definite în {$a}';
$string['studentnotallowed'] = 'Ne pare rău, dar nu puteți accesa acest curs ca "{$a}"';
$string['students'] = 'Cursanți';
$string['studentsandteachers'] = 'Cursanți și formatori';
$string['subcategories'] = 'Subcategorii';
$string['subcategory'] = 'Subcategorie';
$string['subcategoryof'] = 'Subcategoria {$a}';
$string['subject'] = 'Subiect';
$string['submit'] = 'Trimite';
$string['subsectionmoveerror'] = 'Nu se poate muta această subsecțiune într-o altă subsecțiune';
$string['success'] = 'Succes';
$string['successduration'] = 'Succes ({$a} secunde)';
$string['summary'] = 'Rezumat';
$string['suspended'] = 'Suspendat';
$string['suspendedusers'] = 'Utilizatori suspendați';
$string['switchdevicedefault'] = 'Treceți la tema standard';
$string['switchdevicerecommended'] = 'Treceți la tema recomandată pentru dispozitivul dumneavoastră';
$string['switchrolereturn'] = 'Revenire la rolul meu obișnuit';
$string['switchroleto'] = 'Schimbați rolul...';
$string['switchroleto_help'] = 'Alegeți un rol, pentru a vă face o idee despre modul în care cineva cu poziția respectivă va vedea acest curs.

Vă rugăm să rețineți că este posibil ca această vizualizare să nu fie perfectă (<a href="https://docs.moodle.org/en/Switch_roles">Vedeți detalii și alternative</a>).';
$string['tag'] = 'Etichetă';
$string['tagalready'] = 'Această etichetă există deja';
$string['tagmanagement'] = 'Adaugă/ șterge etichete ...';
$string['tags'] = 'Etichete';
$string['targetrole'] = 'Poziția țintă';
$string['teacheronly'] = 'numai pentru {$a}';
$string['teacherroles'] = '{$a} roluri';
$string['teachers'] = 'Formatori';
$string['textcopiedtoclipboard'] = 'Text copiat în clipboard';
$string['textediting'] = 'Editor text';
$string['textediting_help'] = 'Dacă este selectat un editor HTML, cum ar fi, Atto sau TinyMCE, zonele de introducere a textului vor avea o bară de instrumente cu butoane folosită la adăugarea cu ușurință a unui conținut.

Dacă este selectată "zona de text simplu", se poate alege un format pentru zonele de introducere a textului, cum ar fi, HTML sau Markdown.

Lista editorilor de text disponibili este stabilită de administratorul site-ului.';
$string['texteditor'] = 'Utilizați formulare web standard';
$string['textellipsis'] = '{$a}...';
$string['textformat'] = 'Format text simplu';
$string['thanks'] = 'Mulțumim';
$string['theme'] = 'Temă';
$string['themepreviewdescription'] = 'Descrierea temei {$a}';
$string['themepreviewimage'] = 'imagine pentru previzualizare {$a}';
$string['themes'] = 'Teme';
$string['themesaved'] = 'Tema nouă a fost salvată';
$string['therearecourses'] = 'Există {$a} cursuri';
$string['thereareno'] = 'Nu există {$a} în acest curs';
$string['thiscategory'] = 'Această categorie';
$string['thiscategorycontains'] = 'Această categorie conține';
$string['time'] = 'Oră';
$string['timecreated'] = 'Creat pe';
$string['timecreatedcourse'] = 'Data creării cursului';
$string['timesplitting:deciles'] = 'Ultima zecime';
$string['timesplitting:deciles_help'] = 'Acest interval de analiză împarte cursul în zecimi (10 părți egale), fiecare predicție fiind bazată pe datele doar celei mai recente zecimi anterioare.';
$string['timesplitting:decilesaccum'] = 'Toare zecimile anterioare';
$string['timesplitting:decilesaccum_help'] = 'Acest interval de analiză împarte cursul în zecimi (10 părți egale), fiecare predicție fiind bazată pe datele acumulate ale tuturor zecimilor anterioare.';
$string['timesplitting:nosplitting'] = 'Fără limite de timp';
$string['timesplitting:nosplitting_help'] = 'Nu există un interval de timp definit pentru acest model.';
$string['timesplitting:onemonthafterstart'] = 'La o lună după începere';
$string['timesplitting:onemonthafterstart_help'] = 'Acest interval de analiză generează o predicție la 1 lună după începerea analizei.';
$string['timesplitting:oneweekafterstart'] = 'La o săptămână după începere';
$string['timesplitting:oneweekafterstart_help'] = 'Acest interval de analiză generează o predicție la 1 săptămână după începerea analizei.';
$string['timesplitting:past3days'] = 'Ultimele 3 zile';
$string['timesplitting:past3days_help'] = 'Acest interval de analiză generează predicții la fiecare 3 zile. Calculele indicatorilor se vor baza pe ultimele 3 zile.';
$string['timesplitting:pastmonth'] = 'Luna trecută';
$string['timesplitting:pastmonth_help'] = 'This analysis interval generates predictions every month. The indicators calculations will be based on the past month.';
$string['timesplitting:pastweek'] = 'Săptămâna trecută';
$string['timesplitting:pastweek_help'] = 'Acest interval de analiză generează predicții în fiecare lună. Calculele indicatorilor se vor baza pe luna trecută.';
$string['timesplitting:quarters'] = 'Ultimul sfert';
$string['timesplitting:quarters_help'] = 'Acest interval de analiză împarte cursul în sferturi (4 părți egale), fiecare predicție bazându-se doar pe datele celui mai recent trimestru anterior.';
$string['timesplitting:quartersaccum'] = 'Toate sferturile anterioare';
$string['timesplitting:quartersaccum_help'] = 'Acest interval de analiză împarte cursul în sferturi (4 părți egale), fiecare predicție fiind bazată pe datele acumulate din toate trimestrele anterioare.';
$string['timesplitting:singlerange'] = 'De la început la sfârșit';
$string['timesplitting:singlerange_help'] = 'Acest interval de analiză consideră întregul curs ca un singur interval.';
$string['timesplitting:tenpercentafterstart'] = '10% după ce a început';
$string['timesplitting:tenpercentafterstart_help'] = 'Acest interval de analiză generează o predicție după finalizarea a 10% din curs.';
$string['timesplitting:upcoming3days'] = 'Următoarele 3 zile';
$string['timesplitting:upcoming3days_help'] = 'Acest interval de analiză generează predicții la fiecare 3 zile. Calculele indicatorilor se vor baza pe următoarele 3 zile.';
$string['timesplitting:upcomingfortnight'] = 'Săptămâna viitoare';
$string['timesplitting:upcomingfortnight_help'] = 'Acest interval de analiză generează predicții la fiecare două săptămâni. Calculele indicatorilor se vor baza pe următoarea săptămână.';
$string['timesplitting:upcomingweek'] = 'Săptămâna viitoare';
$string['timesplitting:upcomingweek_help'] = 'Acest interval de analiză generează predicții în fiecare săptămână. Calculele indicatorilor se vor baza pe săptămâna viitoare.';
$string['timezone'] = 'Fus orar';
$string['tocontent'] = 'La elementul "{$a}"';
$string['tocreatenewaccount'] = 'Treci peste crearea unui cont nou';
$string['todate'] = 'La';
$string['today'] = 'Azi';
$string['todaylogs'] = 'Jurnalele de astăzi';
$string['toeveryone'] = 'tuturor';
$string['toggleemojipicker'] = 'Afișați selectorul de emoji';
$string['togglesearch'] = 'Afișați căutarea';
$string['toomanybounces'] = 'Adresa de e-mail respectivă a avut prea multe ricoșări. Modifică <b>must</b> pentru a continua.';
$string['toomanytags'] = 'Această căutare a inclus prea multe etichete; unele vor fi fost ignorate.';
$string['toomanytoshow'] = 'Sunt prea mulți utilizatori de afișat.';
$string['toomanyusersmatchsearch'] = 'Prea mulți utilizatori ({$a->count}) corespund "{$a->search}"';
$string['toomanyuserstoshow'] = 'Prea mulți utilizatori ({$a}) de afișat';
$string['toonly'] = 'numai pentru {$a}';
$string['top'] = 'Partea superioară';
$string['topic'] = 'Subiect';
$string['toplevelcategory'] = 'Categorie de nivel superior';
$string['torecipient'] = 'La';
$string['total'] = 'Total';
$string['totopofsection'] = 'În partea de sus a secțiunii "{$a}"';
$string['trackforums'] = 'Urmărirea forumului';
$string['trackforumsno'] = 'Nu: nu țineți evidența postărilor pe care le-am văzut';
$string['trackforumsyes'] = 'Da: evidențiați postări noi pentru mine';
$string['trysearching'] = 'Încercați să căutați în schimb.';
$string['turneditingoff'] = 'Dezactivați editarea';
$string['turneditingon'] = 'Activați editarea';
$string['unabletocopytoclipboard'] = 'Nu se poate copia text în clipboard';
$string['unauthorisedlogin'] = 'Contul utilizatorului "{$a}" nu este diponibil pe acest site';
$string['undecided'] = 'Nehotărât';
$string['unexistingcmid'] = 'Identificatorul modulului de curs nu a fost găsit';
$string['unexistingsectionid'] = 'Identificatorul secțiunii de curs nu a fost găsit';
$string['unfinished'] = 'Neîncheiat';
$string['unknowncategory'] = 'Categorie necunoscută';
$string['unknownerror'] = 'Eroare necunoscută';
$string['unknownuser'] = 'Utilizator necunoscut';
$string['unlimited'] = 'Nelimitat';
$string['unpacking'] = 'Despachetarea {$a}';
$string['unsafepassword'] = 'Parolă nesigură - încercați altceva';
$string['untilcomplete'] = 'Până la finalizare';
$string['unusedaccounts'] = 'Conturile neutilizate de mai mult de {$a} zile sunt anulate automat';
$string['unzip'] = 'Dezarhivare';
$string['unzippingbackup'] = 'Dezarhivează backup';
$string['up'] = 'Sus';
$string['update'] = 'Actualizează';
$string['updated'] = 'Actualizat {$a}';
$string['updatemymoodleoff'] = 'Nu mai personalizați această pagină';
$string['updatemymoodleon'] = 'Personalizați această pagină';
$string['updatemyprofile'] = 'Actualizați profilul';
$string['updatesevery'] = 'Actualizare la fiecare {$a} secunde';
$string['updatethis'] = 'Actualizează {$a}';
$string['updatethiscourse'] = 'Actualizează acest curs';
$string['upload'] = 'Încarcă';
$string['uploadafile'] = 'Încarcă un fișier';
$string['uploadcantwrite'] = 'Fișierul nu a putut fi scris pe disc';
$string['uploadedfile'] = 'Fișierul a fost încărcat cu succes';
$string['uploadedfileto'] = 'Încărcat {$a->file} în {$a->directory}';
$string['uploadedfiletoobig'] = 'Ne pare rău, dar acest fișier este prea mare (limita este de {$a} biți)';
$string['uploadextension'] = 'Încărcarea fișierelor a fost oprită de o extensie PHP';
$string['uploadfailednotrecovering'] = 'Încărcarea fișierului dvs. nu a reușit, deoarece a apărut o problemă cu unul dintre fișiere, {$a->name}.<br /> Iată un jurnal al problemelor:<br />{$a->problem}<br />Nu se recuperează.';
$string['uploadfilelog'] = 'Încărcați jurnalul pentru fișier {$a}';
$string['uploadformlimit'] = 'Fișierul încărcat {$a} a depășit limita maximă stabilită de formular';
$string['uploadlabel'] = 'Titlu:';
$string['uploadlimitwithsize'] = '{$a->contextname} limită de încărcare ({$a->displaysize})';
$string['uploadnewfile'] = 'Încărcați un fișier nou';
$string['uploadnofilefound'] = 'Nu a fost găsit niciun fișier - sunteți sigur că ați selectat unul pentru încărcare?';
$string['uploadnotallowed'] = 'Încărcările nu sunt permise';
$string['uploadnotempdir'] = 'Lipsește un folder temporar';
$string['uploadoldfilesdeleted'] = 'Fișierele vechi din zona dvs. de încărcare au fost șterse';
$string['uploadpartialfile'] = 'Fișierul a fost încărcat doar parțial';
$string['uploadproblem'] = 'A apărut o problemă necunoscută la încărcarea fișierului "{$a}" (poate că era prea mare?)';
$string['uploadrenamedchars'] = 'Fișierul a fost redenumit din {$a->oldname} în {$a->newname} din cauza caracterelor invalide.';
$string['uploadrenamedcollision'] = 'Fișierul a fost redenumit din {$a->oldname} în {$a->newname}, deoarece a existat un conflict de nume de fișier.';
$string['uploadserverlimit'] = 'Fișierul încărcat a depășit limita maximă stabilită de server';
$string['uploadthisfile'] = 'Încărcați acest fișier';
$string['url'] = 'URL';
$string['used'] = 'Utilizat';
$string['usedinnplaces'] = 'Utilizat în {$a} locuri';
$string['user'] = 'Utilizator';
$string['useraccount'] = 'Cont utilizator';
$string['useractivity'] = 'Activitate';
$string['userconfirmed'] = 'Confirmat {$a}';
$string['userdata'] = 'Date utilizator';
$string['userdeleted'] = 'Acest cont de utilizator a fost șters';
$string['userdescription'] = 'Descriere';
$string['userdescription_help'] = 'Această casetă vă permite să introduceți un text despre dumneavoastră, text care va fi apoi afișat pe pagina dumneavoastră de profil pentru ca alte persoane să îl poată vedea.';
$string['userdetails'] = 'Detalii utilizator';
$string['userfiles'] = 'Fișiere utilizator';
$string['userlist'] = 'Lista de utilizatori';
$string['usermatchedon'] = 'Acest utilizator corespunde căutării pe baza următorului câmp';
$string['usermenu'] = 'Meniul utilizatorului';
$string['usermenugoback'] = 'Întoarce-te la meniul utilizatorului';
$string['username'] = 'Nume de utilizator';
$string['usernameemail'] = 'Nume de utilizator sau email';
$string['usernameemailmatch'] = 'Numele de utilizator și adresa de e-mail nu se referă la același utilizator';
$string['usernameexists'] = 'Acest nume de utilizator există deja, alegeți altul';
$string['usernamelowercase'] = 'doar literele mici sunt permise';
$string['usernamenotfound'] = 'Numele de utilizator nu a fost găsit în baza de date';
$string['usernameoremail'] = 'Introduceți, fie numele de utilizator, fie adresa de e-mail';
$string['usernotconfirmed'] = 'Nu am putut confirma {$a}';
$string['userpic'] = 'Imaginea utilizatorului';
$string['userpreferences'] = 'Preferințele utilizatorilor';
$string['users'] = 'Utilizatori';
$string['userselectorautoselectunique'] = 'Dacă un singur utilizator se potrivește cu căutarea, selectați-l automat';
$string['userselectorpreserveselected'] = 'Păstrați utilizatorii selectați, chiar dacă nu mai corespund căutării';
$string['userselectorsearchanywhere'] = 'oriunde';
$string['userselectorsearchexactmatchonly'] = 'doar potriviri exacte';
$string['userselectorsearchfromstart'] = 'de la început';
$string['userselectorsearchmatching'] = 'Se potrivește:';
$string['usersnew'] = 'Utilizatori noi';
$string['usersnoaccesssince'] = 'Inactiv pentru mai mult de';
$string['userswithfiles'] = 'Utilizatori cu fișiere';
$string['useruploadtype'] = 'Tipul de încărcare a utilizatorului: {$a}';
$string['userzones'] = 'Zone utilizator';
$string['usetheme'] = 'Folosiți tema';
$string['usingexistingcourse'] = 'Folosind cursul existent';
$string['validatehtml'] = 'Validează HTML';
$string['valuealreadyused'] = 'Această valoare a fost deja utilizată.';
$string['version'] = 'Versiune';
$string['view'] = 'Vizualizare';
$string['viewallcourses'] = 'Vizualizați toate cursurile';
$string['viewallcoursescategories'] = 'Vizualizați toate cursurile și categoriile';
$string['viewallresults'] = 'Vezi toate rezultatele ({$a})';
$string['viewallsubcategories'] = 'Vizualizați toate subcategoriile';
$string['viewfileinpopup'] = 'Vizualizați fișierul într-o fereastră pop-up';
$string['viewing'] = 'Vizualizare:';
$string['viewmore'] = 'Vezi mai mult';
$string['viewprofile'] = 'Vezi profil';
$string['views'] = 'Vizualizări';
$string['viewsolution'] = 'vizualizează soluția';
$string['visible'] = 'Vizibil';
$string['visible_help'] = 'Această setare determină dacă respectivul curs apare în lista cursurilor. În afară de profesori și administratori, alți utilizatori nu au permisiunea de a accesa cursul.';
$string['visibletostudents'] = 'Vizibil pentru {$a}';
$string['warning'] = 'Avertisment';
$string['warningdeleteresource'] = 'Avertisment: {$a} este menționat într-o resursă. Doriți să actualizați resursa?';
$string['wcagcheck'] = 'Verificare Web Content Accessibility Guidelines (WCAG)';
$string['webpage'] = 'Pagina web';
$string['week'] = 'Săptămână';
$string['weeks'] = 'săptămâni';
$string['welcomeback'] = 'Salut, {$a->firstname}! 👋';
$string['welcometocourse'] = 'Bine ai venit la {$a}';
$string['welcometocoursetext'] = 'Bine ai venit la {$a->coursename}!

Dacă nu ai făcut deja acest lucru, ar trebui să îți editezi pagina de profil ca să te cunoaștem mai bine:

<a href="{$a->profileurl}">{$a->profileurl}</a>';
$string['welcometosite'] = 'Bine ai venit, {$a->firstname}! 👋';
$string['whatforlink'] = 'Ce doriți să faceți cu link-ul?';
$string['whatforpage'] = 'Ce doriți să faceți cu textul?';
$string['whatisyourage'] = 'Ce vârstă aveți?';
$string['whattocallzip'] = 'Cum doriți să denumiți fișierul zip?';
$string['whattodo'] = 'Ce trebuie făcut';
$string['wheredoyoulive'] = 'În ce țară locuiți?';
$string['whyisthisrequired'] = 'De ce este necesar acest lucru?';
$string['windowclosing'] = 'Această fereastră ar trebui să se închidă automat. Dacă nu se întâmplă acest lucru, vă rugăm să o închideți acum.';
$string['withchosenfiles'] = 'Cu fișierele alese';
$string['withdisablednote'] = '{$a} (disabled)';
$string['withoutuserdata'] = 'fără date de utilizator';
$string['withselectedusers'] = 'Cu utilizatorii selectați...';
$string['withuserdata'] = 'cu datele utilizatorului';
$string['wontrunfuturescheduledtask'] = 'Nu va rula sarcina care nu a eșuat și este programată să ruleze în viitor';
$string['wordforstudent'] = 'Definirea termenului Cursant';
$string['wordforstudenteg'] = 'De exemplu, cursant, participant etc';
$string['wordforstudents'] = 'Cuvântul dumneavoastră pentru cursanți';
$string['wordforstudentseg'] = 'De exemplu, cursanți, participanți etc';
$string['wordforteacher'] = 'Cuvântul dumneavoastră pentru formator';
$string['wordforteachereg'] = 'De exemplu, formator, tutore, facilitator, etc';
$string['wordforteachers'] = 'Cuvântul dumneavoastră pentru formatori';
$string['wordforteacherseg'] = 'ex. Profesori, Tutori, Facilitatori etc';
$string['writingblogsinfo'] = 'Crearea informațiilor despre bloguri';
$string['writingcategoriesandquestions'] = 'Crearea categoriilor și întrebărilor';
$string['writingcoursedata'] = 'Crearea datelor cursului';
$string['writingeventsinfo'] = 'Crearea informațiilor despre evenimente';
$string['writinggeneralinfo'] = 'Crearea informațiilor generale';
$string['writinggradebookinfo'] = 'Crearea informațiilor despre catalog';
$string['writinggroupingsgroupsinfo'] = 'Creare grupări - informații despre grupuri';
$string['writinggroupingsinfo'] = 'Crearea informațiilor despre grupări';
$string['writinggroupsinfo'] = 'Crearea informațiilor despre grupuri';
$string['writingheader'] = 'Creare antet';
$string['writingloginfo'] = 'Crearea informațiilor despre jurnale';
$string['writingmessagesinfo'] = 'Crearea informațiilor despre mesaje';
$string['writingmoduleinfo'] = 'Crearea informațiilor despre module';
$string['writingscalesinfo'] = 'Crearea informațiilor despre scale';
$string['writinguserinfo'] = 'Scrierea informațiilor despre utilizatori';
$string['wrongpassword'] = 'Parolă incorectă pentru acest nume de utilizator';
$string['year'] = 'an';
$string['years'] = 'ani';
$string['yes'] = 'Da';
$string['youareabouttocreatezip'] = 'Urmează să creați un fișier zip care să conțină';
$string['youaregoingtorestorefrom'] = 'Urmează să începeți procesul de restaurare pentru';
$string['youhaveupcomingactivitiesdue'] = 'Aveți activități viitoare';
$string['youhaveupcomingactivitiesdueinfo'] = 'Bună {$a},

<br/> <br/> Aveți următoarele activități de finalizat:';
$string['youneedtoenrol'] = 'Pentru a efectua acțiunea respectivă, trebuie să vă înscrieți la acest curs.';
$string['yourlastlogin'] = 'Ultima dată v-ați conectat în';
$string['yourself'] = 'dumneavoastră';
$string['yourteacher'] = 'al tău {$a}';
$string['yourwordforx'] = 'Termenul dumneavoastră pentru "{$a}"';
$string['zippingbackup'] = 'Arhivarea backup-ului';
