<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'aiprovider_deepseek', language 'pt', version '5.1'.
 *
 * @package     aiprovider_deepseek
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['action:explain_text:endpoint'] = 'Endpoint da API';
$string['action:explain_text:model'] = 'Modelo de explicação de texto';
$string['action:explain_text:model_help'] = 'O modelo utilizado para explicar o texto fornecido.';
$string['action:explain_text:systeminstruction'] = 'Instrução do sistema';
$string['action:explain_text:systeminstruction_help'] = 'Esta instrução é enviada para o modelo IA juntamente com o pedido do utilizador. A edição desta instrução não é recomendada, a não ser que seja absolutamente necessário.';
$string['action:generate_text:endpoint'] = 'Endpoint da API';
$string['action:generate_text:model'] = 'Modelo IA';
$string['action:generate_text:model_help'] = 'O modelo utilizado para gerar o texto da resposta.';
$string['action:generate_text:systeminstruction'] = 'Instrução do sistema';
$string['action:generate_text:systeminstruction_help'] = 'Esta instrução é enviada para o modelo IA juntamente com o pedido do utilizador. A edição desta instrução não é recomendada, a não ser que seja absolutamente necessário.';
$string['action:summarise_text:endpoint'] = 'Endpoint da API';
$string['action:summarise_text:model'] = 'Modelo IA';
$string['action:summarise_text:model_help'] = 'O modelo utilizado para resumir o texto fornecido.';
$string['action:summarise_text:systeminstruction'] = 'Instrução do sistema';
$string['action:summarise_text:systeminstruction_help'] = 'Esta instrução é enviada para o modelo IA juntamente com o pedido do utilizador. A edição desta instrução não é recomendada, a não ser que seja absolutamente necessário.';
$string['apikey'] = 'Chave API DeepSeek';
$string['apikey_help'] = 'Obtenha uma chave a partir das <a href="https://platform.deepseek.com/api_keys" target="_blank">chaves API da DeepSeek</a>.';
$string['custom_model_name'] = 'Nome do modelo personalizado';
$string['extraparams'] = 'Parâmetros extras';
$string['extraparams_help'] = 'Parâmetros extra podem ser configurados aqui. O formato JSON é suportado. Por exemplo:
<pre>
{
 "temperature": 0,5,
 "max_tokens": 100
}
</pre>';
$string['invalidjson'] = 'String JSON inválida';
$string['pluginname'] = 'Fornecedor da API DeepSeek';
$string['privacy:metadata'] = 'O módulo Fornecedor de API Deepseek não armazena quaisquer dados pessoais.';
$string['privacy:metadata:aiprovider_deepseek:externalpurpose'] = 'Esta informação é enviada à API DeepSeek para que seja gerada uma resposta. As definições da sua conta DeepSeek podem alterar a forma como a DeepSeek armazena e retém estes dados. Nenhum dado do utilizador é enviado explicitamente para a DeepSeek ou armazenado no Moodle LMS por este módulo.';
$string['privacy:metadata:aiprovider_deepseek:model'] = 'O modelo utilizado para gerar a resposta.';
$string['privacy:metadata:aiprovider_deepseek:prompttext'] = 'A prompt inserida pelo utilizador utilizada para gerar a resposta.';
$string['settings'] = 'Configurações';
$string['settings_frequency_penalty'] = 'frequency_penalty';
$string['settings_frequency_penalty_help'] = 'Número entre -2,0 e 2,0. Os valores positivos penalizam os novos tokens com base na sua frequência no texto até ao momento, diminuindo a probabilidade do modelo repetir a mesma linha na íntegra.';
$string['settings_help'] = 'Ajuste as configurações abaixo para personalizar a forma como os pedidos são enviados à DeepSeek.';
$string['settings_logprobs'] = 'logprobs';
$string['settings_logprobs_help'] = 'Especifique se pretende devolver a probabilidade logarítmica dos tokens de saída. Se esta configuração estiver ativada, irá devolver a probabilidade logarítmica de cada token de saída devolvido no conteúdo da mensagem.';
$string['settings_logprobs_label'] = 'Ativar';
$string['settings_max_tokens'] = 'max_tokens';
$string['settings_max_tokens_help'] = 'Inteiro entre 1 e 8192. O número máximo de tokens que podem ser gerados na conclusão do chat. O comprimento total dos tokens de entrada e dos tokens gerados é limitado pelo comprimento do contexto do modelo. Se max_tokens não for especificado, será utilizado o valor predefinido 4096.';
$string['settings_presence_penalty'] = 'presence_penalty';
$string['settings_presence_penalty_help'] = 'Número entre -2,0 e 2,0. Os valores positivos penalizam os novos tokens com base na sua presença no texto até ao momento, aumentando a probabilidade de o modelo abordar novos tópicos.';
$string['settings_temperature'] = 'temperature';
$string['settings_temperature_help'] = 'O valor de temperature da amostragem a utilizar, entre 0 e 2. Valores mais elevados, como 0,8, tornarão a saída mais aleatória, enquanto valores mais baixos, como 0,2, a tornarão mais focada e determinística. Geralmente, recomenda-se a alteração deste parâmetro ou top_p, mas não ambos.';
$string['settings_top_logprobs'] = 'top_logprobs';
$string['settings_top_logprobs_help'] = 'Um número inteiro entre 0 e 20 que especifica o número de tokens mais prováveis de retornar em cada posição de token, cada um com uma probabilidade de registo associada. \'logprobs\' deve ser definido como \'true\' se este parâmetro for utilizado.';
$string['settings_top_p'] = 'top_p';
$string['settings_top_p_help'] = 'Uma alternativa à amostragem de temperature, denominada amostragem de núcleo, em que o modelo considera os resultados dos tokens com peso de probabilidade top_p. Assim sendo, um valor de 0,1 significa que apenas são considerados os tokens com um peso de probabilidade superior a 10%. Geralmente, recomenda-se alterar esta ou a temperature, mas não ambas.';
