<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'plugin', language 'no', version '5.1'.
 *
 * @package     plugin
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['actions'] = 'Handlinger';
$string['availability'] = 'Tilgjengelighet';
$string['cancelinstallall'] = 'Avbryt nye installasjoner ({$a})';
$string['cancelinstallhead'] = 'Avbryt installeringen av moduler.';
$string['cancelinstallinfo'] = 'Følgende moduler er ennå ikke fullstendig installert, så installasjonen av dem kan avbrytes. For ågjøre dette må modul-mappa fjernes fra serveren nå. Du bør være helt sikker på at du virkelig ønsker dette for å hindre datatap (slik som egne kodemodifiseringer)';
$string['cancelinstallinfodir'] = 'Mappe som skal slettes: {$a}';
$string['cancelinstallone'] = 'Avbryt denne installasjonen';
$string['cancelupgradeall'] = 'Avbryt oppgraderinger ({$a})';
$string['cancelupgradehead'] = 'Gjenoppretter tidligere versjoner av moduler';
$string['cancelupgradeone'] = 'Avbryt denne oppgraderingen';
$string['checkforupdates'] = 'Sjekk etter tilgjengelige oppdateringer';
$string['checkforupdateslast'] = 'Siste sjekk ble gjort {$a}';
$string['dependencyavailable'] = 'Tilgjengelig';
$string['dependencyfails'] = 'Mislykkede forsøk';
$string['dependencyinstall'] = 'Installer';
$string['dependencyinstallhead'] = 'Installer manglende avhengigheter';
$string['dependencyinstallmissing'] = 'Installer manglende avhengigheter';
$string['dependencymissing'] = 'Mangler';
$string['dependencyunavailable'] = 'Utilgjengelig';
$string['dependencyupload'] = 'Last opp';
$string['dependencyuploadmissing'] = 'Last opp zip-filer';
$string['deprecated_type'] = 'Avviklet modul';
$string['detectedmisplacedplugin'] = 'Modul "{$a->component}" er installert på feil plassering "{$a->current}", forvented plassering er "{$a->expected}"';
$string['displayname'] = 'Navn på modul';
$string['err_response_curl'] = 'Kunne ikke hente tilgjengelige oppdateringsdata - uventet cURL-feil';
$string['err_response_format_version'] = 'Uventet versjon av svarformatet. Vennligst sjekk igjen om det finnes tilgjengelige oppdateringer.';
$string['err_response_http_code'] = 'Kunne ikke hente tilgjengelige oppdateringsdata - uventet HTTP svarkode.';
$string['filterall'] = 'Vis alle';
$string['filtercontribonly'] = 'Vis kun tilleggsmodul';
$string['filtermissingonly'] = 'Vis kun mangler fra disk';
$string['filternewpluginsonly'] = 'Vis kun moduler som skal installeres';
$string['filterupdatesonly'] = 'Vis kun oppdateringer';
$string['incompatibleversion'] = 'Inkompatibel Moodleversjon: {$a}';
$string['isenabled'] = 'Aktivert?';
$string['misdepinfoplugin'] = 'Modulinformasjon';
$string['misdepinfoversion'] = 'Versjonsinformasjon';
$string['misdepsavail'] = 'Manglende avhengigheter som er tilgjengelige';
$string['misdepsunavail'] = 'Manglende avhengigheter som ikke er tilgjengelige';
$string['misdepsunavaillist'] = 'Fant ingen versjon for å tilfredstille avhengigshetskravene: {$a}';
$string['misdepsunknownlist'] = 'Ikke i Plugins-mappa: <strong>{$a}</strong>.';
$string['moodlebranch'] = 'Moodle {$a->min} - {$a->max}';
$string['moodleversion'] = 'Moodle {$a}';
$string['noneinstalled'] = 'Ingen moduler av denne typen er installert';
$string['notdownloadable'] = 'Kan ikke laste ned pakken';
$string['notdownloadable_help'] = 'ZIP-pakken med oppdateringen kan ikke lastes ned automatisk.';
$string['notdownloadable_link'] = 'admin/mdeploy/notdownloadable';
$string['notes'] = 'Notater';
$string['notsupported'] = 'Modulen kan være inkompatibel med Moodleversjon {$a}';
$string['notwritable'] = 'Modulsidene er ikke skrivbare';
$string['notwritable_help'] = 'Modulenes filområde er ikke skrivbare for webserveren. Webserveren må ha skrive-rettighet for å få tilgang til modulmappen og dens innhold. Skrive-tilgang til rotmappen for angitt modultype kan også være påkrevd.';
$string['otherplugin'] = '{$a->component}';
$string['otherpluginversion'] = '{$a->component} ({$a->version})';
$string['overviewall'] = 'All moduler';
$string['overviewext'] = 'Tilleggsmoduler';
$string['overviewupdatable'] = 'Tilgjengelige oppdateringer';
$string['packagesdebug'] = 'Debugging utdata aktivert';
$string['packagesdownloading'] = 'Laster ned {$a}';
$string['packagesextracting'] = 'Pakker opp {$a}';
$string['packagesvalidating'] = 'Godkjenner {$a}';
$string['packagesvalidatingfailed'] = 'Installasjonen ble avbrutt på grunn av valideringsfeil.';
$string['packagesvalidatingok'] = 'Vellykket validering, installasjonen kan fortsette';
$string['plugincheckall'] = 'Alle moduler';
$string['plugincheckattention'] = 'Moduler som trenger oppmerksomhet';
$string['pluginchecknone'] = 'Ingen moduler krever ekstra oppmerksomhet akkurat nå';
$string['pluginchecknotice'] = 'Denne siden viser moduler som det kan hende at du må vie oppmerksomhet under oppgraderingen, slik som nye moduler som må installeres, moduer om må oppgraderes eller manglende moduler etc. Tilleggsmoduler vises om det er en tilgjengelig oppdatering for dem. Det anbefales at du sjekker om det er tilgjengelig nyere versjoner av tilleggsmoduleene, og evt. oppdateree kildekoden til disse tilleggsmodulene før du fortsetter med denne Moodle-oppgraderingen.';
$string['plugindisable'] = 'Deaktiver';
$string['plugindisabled'] = 'Deaktivert';
$string['pluginenable'] = 'Aktiver';
$string['pluginenabled'] = 'Aktivert';
$string['release'] = 'Utgitt';
$string['requiredby'] = 'Krevd av: {$a}';
$string['requires'] = 'Krever';
$string['rootdir'] = 'Katalog';
$string['settings'] = 'Innstillinger';
$string['source'] = 'Kilde';
$string['sourceext'] = 'I tillegg';
$string['sourcestd'] = 'Standard';
$string['status'] = 'Status';
$string['status_delete'] = 'Skal slettes';
$string['status_downgrade'] = 'Nyere versjon er allerede installert!';
$string['status_missing'] = 'Mangler fra disk';
$string['status_new'] = 'Skal installeres';
$string['status_nodb'] = 'Ingen database';
$string['status_upgrade'] = 'Skal oppgraderes';
$string['status_uptodate'] = 'Installert';
$string['supportedconversions'] = 'Støttede dokumentkonverteringer';
$string['supportedmoodleversions'] = 'Støttede Moodleversjoner';
$string['systemname'] = 'Identifikator';
$string['type_aiplacement'] = 'AI plasseringsmodul';
$string['type_aiplacement_plural'] = 'AI plasseringsmoduler';
$string['type_aiprovider'] = 'AI tilbydermodul';
$string['type_aiprovider_plural'] = 'AI tilbydermoduler';
$string['type_antivirus'] = 'Antivirusmodul';
$string['type_antivirus_plural'] = 'Antivirusmoduler';
$string['type_auth'] = 'Autentiseringsmetode';
$string['type_auth_plural'] = 'Autentiseringsmoduler';
$string['type_availability'] = 'Betinget tilgjengelighet';
$string['type_availability_plural'] = 'Tilgjengelighet';
$string['type_block'] = 'Blokk';
$string['type_block_plural'] = 'Blokker';
$string['type_cachelock'] = 'Mellomlagre låsbehandleren';
$string['type_cachelock_plural'] = 'Mellomlagre låsbehandlerene';
$string['type_cachestore'] = 'Mellomlager';
$string['type_cachestore_plural'] = 'Mellomlagre';
$string['type_calendartype'] = 'Kalendertype';
$string['type_calendartype_plural'] = 'Kalendertyper';
$string['type_communication'] = 'Kommunikasjonsleverandør';
$string['type_communication_plural'] = 'Kommunikasjonsleverandører';
$string['type_contenttype'] = 'Innholdsbank';
$string['type_contenttype_plural'] = 'Innholdsbankmoduler';
$string['type_core'] = 'Core undersystem';
$string['type_core_plural'] = 'Core undersystemer';
$string['type_coursereport'] = 'Kursrapporter';
$string['type_coursereport_plural'] = 'Kursrapporter';
$string['type_customfield'] = 'Egendefinert felt';
$string['type_customfield_plural'] = 'Egendefinerte felt';
$string['type_dataformat'] = 'Dataformat';
$string['type_dataformat_plural'] = 'Dataformater';
$string['type_editor'] = 'Editor';
$string['type_editor_plural'] = 'Editorer';
$string['type_enrol'] = 'Påmeldingsmetode';
$string['type_enrol_plural'] = 'Påmeldingsmetoder';
$string['type_fileconverter'] = 'Dokumentkonverterer';
$string['type_fileconverter_plural'] = 'Dokumentkonverterere';
$string['type_fileconvertermanage'] = 'Administrer dokumentkonverteringsprogrammer';
$string['type_filter'] = 'Filter';
$string['type_filter_plural'] = 'Tekstfiltre';
$string['type_format'] = 'Kursformater';
$string['type_format_plural'] = 'Kursformat';
$string['type_gradeexport'] = 'Karaktereksportmetode';
$string['type_gradeexport_plural'] = 'Karaktereksportmetoder';
$string['type_gradeimport'] = 'Karakterimportmetode';
$string['type_gradeimport_plural'] = 'Karakterimportmetoder';
$string['type_gradepenalty'] = 'Karaktertrekk';
$string['type_gradepenalty_plural'] = 'Karaktertrekk';
$string['type_gradereport'] = 'Karakterbokrapport';
$string['type_gradereport_plural'] = 'Karakterbokrapporter';
$string['type_gradingform'] = 'Avansert karaktersettingsmetode';
$string['type_gradingform_plural'] = 'Avanserte metoder for karaktersetting';
$string['type_h5plib'] = 'H5P rammeverk';
$string['type_h5plib_plural'] = 'H5P rammeverk';
$string['type_local'] = 'Lokal modul';
$string['type_local_plural'] = 'Lokale moduler';
$string['type_media'] = 'Mediaspiller';
$string['type_media_plural'] = 'Mediaspillere';
$string['type_message'] = 'Varslingsmodul';
$string['type_message_plural'] = 'Varslingsmoduler';
$string['type_mlbackend'] = 'Maskinlæring backend';
$string['type_mlbackend_plural'] = 'Maskinlæring backends';
$string['type_mnetservice'] = 'MNet-tjeneste';
$string['type_mnetservice_plural'] = 'MNet-tjenester';
$string['type_mod'] = 'Aktivitetsmodul';
$string['type_mod_plural'] = 'Aktivitetsmoduler';
$string['type_paygw'] = 'Betalings-gateway';
$string['type_paygw_plural'] = 'Betalings-gatewayer';
$string['type_paygwmanage'] = 'Administrere betalings-gatewayer';
$string['type_plagiarism'] = 'Plagiatbeskyttelsesmodul';
$string['type_plagiarism_plural'] = 'Moduler for plagiatbeskyttelse';
$string['type_portfolio'] = 'Portefølje';
$string['type_portfolio_plural'] = 'Porteføljer';
$string['type_profilefield'] = 'Type profilfelt';
$string['type_profilefield_plural'] = 'Typer profilfelt';
$string['type_qbank'] = 'Modul for spørsmålsbank';
$string['type_qbank_plural'] = 'Moduler for spørsmålsbanker';
$string['type_qbehaviour'] = 'Spørsmålsatferd';
$string['type_qbehaviour_plural'] = 'Spørsmålsatferd';
$string['type_qformat'] = 'Import/eksportformat på spørsmål';
$string['type_qformat_plural'] = 'Import/eksportformat på spørsmål';
$string['type_qtype'] = 'Spørsmålstype';
$string['type_qtype_plural'] = 'Spørsmålstyper';
$string['type_report'] = 'Portalrapport';
$string['type_report_plural'] = 'Rapporter';
$string['type_repository'] = 'Filområde';
$string['type_repository_plural'] = 'Filarkiv';
$string['type_search'] = 'Søkemotor';
$string['type_search_plural'] = 'Søkemotorer';
$string['type_smsgateway'] = 'SMS gateway';
$string['type_smsgateway_plural'] = 'SMS gateways';
$string['type_theme'] = 'Design';
$string['type_theme_plural'] = 'Design';
$string['type_tool'] = 'Adminverktøy';
$string['type_tool_plural'] = 'Adminverktøy';
$string['type_webservice'] = 'Protokoll over webtjenester';
$string['type_webservice_plural'] = 'Protokoller over webtjenester';
$string['uninstall'] = 'Fjern';
$string['uninstallconfirm'] = 'Du er i ferd med å avinstallere <em>{$a->name}</em>. Dette vil slette alt i databasen som er assosiert med modulen, inkludert oppsett, logger, brukerfiler som modulen bruker osv. Det finnes ingen vei tibake og Moodle i seg selv lager ingen tilbakestillingskopi. Er du SIKKER på at du ønsker å fortsette?';
$string['uninstalldelete'] = 'Alle data assosiert med modulen <em>{$a->name}</em> er slettet fra databasen. For å forhindre at modulen reinstallerer seg selv må mappen  <em>{$a->rootdir}</em> nå fjernes manuelt fra serveren. Moodle kan ikke på egen hånd fjerne mappen på grunn av manglende skriverettigheter.';
$string['uninstalldeleteconfirm'] = 'Alle data assosiert med modulen <em>{$a->name}</em> er slettet fra databasen. For å forhindre at modulen reinstallerer seg selv må mappen  <em>{$a->rootdir}</em> nå fjernes fra serveren. Ønsker du å fjerne mappen nå?';
$string['uninstalldeleteconfirmexternal'] = 'Det ser ut som om gjeldelde versjon av modulen er lagt til via kildehåndteringssystemet ({$a}). Hvis du fjerner modulmappen kan det være at du mister viktige lokale modifikasjoner av koden. Vennligst vær sikker på at du virkelig ønsker å fjerne modulmappen FØR du fortsetter.';
$string['uninstallextraconfirmblock'] = 'Denne blokken er brukt {$a->instances} ganger.';
$string['uninstallextraconfirmenrol'] = 'Det er {$a->enrolments} innmeldt brukere.';
$string['uninstallextraconfirmmod'] = 'Denne modulen er brukt {$a->instances} ganger i {$a->courses} kurs.';
$string['uninstalling'] = 'Avinstallerer {$a->name}';
$string['updateavailable'] = 'En ny versjon {$a} er tilgjengelig!';
$string['updateavailable_moreinfo'] = 'Mer informasjon...';
$string['updateavailable_release'] = 'Slipp {$a}';
$string['updatepluginconfirm'] = 'Bekreftelse på moduloppdatering';
$string['updatepluginconfirmexternal'] = 'Det ser ut til at den gjeldende versjonen av modulen har blitt skaffet via kildekodens administrasjonssystems ({$a}) utsjekk. Hvis du installerer denne oppdateringen, vil du ikke lenger kunne skaffe moduloppdateringer fra kildekodens administrasjonssystem. Vennligst forsikre deg om at du vil oppdatere modulen før du fortsetter.';
$string['updatepluginconfirminfo'] = 'Du er i ferd med å installere en ny versjon av modulen <strong>{$a->name}</strong>. En zip-pakke med versjonen {$a->version} av modulen vil bli lastet ned fra <a href="{$a->url}">{$a->url}</a> og pakket ut i din Moodleinstallasjon så den kan oppgraderes.';
$string['updatepluginconfirmwarning'] = 'Vennligst vær oppmerksom på at Moodle ikke automatisk vil lage en sikkerhetskopi av databasen din før oppgraderingen. Vi anbefaler sterkt at du tar en fullstendig sikkerhetskopi nå, for å kunne hanskes med det sjeldne tilfellet at den nye koden har feil som gjør portalen din utilgjengelig eller ødelegger databasen. Fortsett på egen risiko.';
$string['validationmsg_componentmatch'] = 'Fullt navn på komponenten';
$string['validationmsg_componentmismatchname'] = 'Tilleggsmodulens navn stemmer ikke';
$string['validationmsg_componentmismatchname_help'] = 'Noen ZIP-pakker, som de som genereres av Github, kan inneholde feil navn på rotmappen. Du må derfor endre navnet på rotmappen slik at den samsvarer med modulens navn.';
$string['validationmsg_componentmismatchname_info'] = 'Tilleggsmodulen deklarerer eget modulnavn til \'{$a}\', men dette samsvarer ikke med navnet på rotmappen til modulen.';
$string['validationmsg_componentmismatchtype'] = 'Ikke samsvar med modultypen';
$string['validationmsg_componentmismatchtype_info'] = 'Forventet modultype er  \'{$a->expected}\', men modulen deklarerer at modultypen er \'{$a->found}\'.';
$string['validationmsg_filenotexists'] = 'Utpakket fil ble ikke funnet';
$string['validationmsg_filesnumber'] = 'Fant ikke nok filer i pakken';
$string['validationmsg_filestatus'] = 'Ikke mulig å pakke ut alle filene';
$string['validationmsg_filestatus_info'] = 'Forsøket på å pakke ut filen {$a->file} resulterte i feilen \'{$a->status}\'.';
$string['validationmsg_foundlangfile'] = 'Fant språkfil';
$string['validationmsg_maturity'] = 'Deklarert modenhetsnivå';
$string['validationmsg_maturity_help'] = 'Modulen kan deklarere sitt modenhetsnivå. Dersom utvikleren bedømmer modulen som stabil, vil deklarert modenhetsnivå være MATURITY_STABLE. Alle andre modenhetsnivåer (som alfa og beta) bør bedømmes som ustabile og en advarsel gis.';
$string['validationmsg_missingcomponent'] = 'Modilen oppgir ikke sitt komponentnavn';
$string['validationmsg_missingcomponent_help'] = 'Alle moduler må oppgi sitt fulle komponentnavn via \'$plugin->component\' deklarasjonen i filen version.php.';
$string['validationmsg_missingcomponent_link'] = 'Development:version.php';
$string['validationmsg_missingexpectedlangenfile'] = 'Ikke samsvar med den engelske språkfilen';
$string['validationmsg_missingexpectedlangenfile_info'] = 'Modultypen mangler en forventet engelsk språkfil: {$a}';
$string['validationmsg_missinglangenfile'] = 'Fant ingen engelsk språkfil';
$string['validationmsg_missinglangenfolder'] = 'Mangler mappe for engelsk språkfil';
$string['validationmsg_missingversion'] = 'Tilleggsmodulen oppgir ikke hvilken versjon den har.';
$string['validationmsg_missingversionphp'] = 'Filen version.php finnes ikke';
$string['validationmsg_multiplelangenfiles'] = 'Fant duplikate engelske språkfiler';
$string['validationmsg_onedir'] = 'Ugyldig struktur på ZIP-pakken.';
$string['validationmsg_onedir_help'] = 'ZIP-pakken må inneholde en rotkatalog som inneholder modulens kode. Navnet på denne rotkatalogen må samsvare med modulens navn.';
$string['validationmsg_pathwritable'] = 'Sjekk av skrivetilgang';
$string['validationmsg_pluginversion'] = 'Tilleggsmodulens versjon';
$string['validationmsg_pluginversiontoolow'] = 'En nyere versjon av denne modulen er allerede installert';
$string['validationmsg_release'] = 'Tilleggsmodulens versjonsdato';
$string['validationmsg_requiresmoodle'] = 'Krav til Moodle-versjon';
$string['validationmsg_rootdir'] = 'Navnet på tilleggsmodulen som skal installeres';
$string['validationmsg_rootdir_help'] = 'Navnet på rotkatalogen i ZIP-pakken blir navnet på modulen som installeres. Dersom navnet ikke er korrekt, kan det være at du bør døpe om rotkatalogen i ZIP-pakken før du installerer.';
$string['validationmsg_rootdirinvalid'] = 'Ugyldig navn på tilleggsmodulen';
$string['validationmsg_rootdirinvalid_help'] = 'Navnet på rotkatalogen i ZIP-pakken har ugyldig syntaks. Noen ZIP-pakker, slik som generert fra Github, kan inneholde ugyldige navn på rotkatalogen. Du må fikse dette slik at mappenavnet samsvarer med navnet på tilleggsmodulen.';
$string['validationmsg_targetexists'] = 'Målmappen eksisterer allerede og vil bli fjernet';
$string['validationmsg_targetexists_help'] = 'Mappen hvor tilleggsmodulen skal installeres eksisterer fra før og vil bli erstattet.';
$string['validationmsg_targetnotdir'] = 'Målområdet er allerede okkupert av en fil';
$string['validationmsg_unknowntype'] = 'Ukjent modultype';
$string['validationmsg_versionphpsyntax'] = 'Ustøttet syntaks oppdaget i filen version.php';
$string['validationmsglevel_debug'] = 'Debug';
$string['validationmsglevel_error'] = 'Feil';
$string['validationmsglevel_info'] = 'OK';
$string['validationmsglevel_warning'] = 'Advarsel';
$string['version'] = 'Versjon';
$string['versiondb'] = 'Gjeldende versjon';
$string['versiondisk'] = 'Ny versjon';
