<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'theme_boost_union', language 'nl', version '5.1'.
 *
 * @package     theme_boost_union
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['aboutuscontentsetting'] = 'Over ons inhoud';
$string['aboutuscontentsetting_desc'] = 'Met deze instelling kun je tekst toevoegen die wordt weergegeven op de pagina over ons.';
$string['aboutusdisabled'] = 'De pagina over ons is uitgeschakeld voor deze site. Er is hier niets te zien';
$string['aboutusheading'] = 'Over ons';
$string['aboutuslinkpositionboth'] = 'Voeg een link naar de pagina over ons toe aan de voetnoot en aan het pictogram in de voettekst (vraagteken)';
$string['aboutuslinkpositionfooter'] = 'Voeg een link naar de pagina over ons toe in het (vraagtken) icoon in de voettekst';
$string['aboutuslinkpositionfootnote'] = 'Voeg een link naar de pagina over ons toe aan de voetnoot';
$string['aboutuslinkpositionnone'] = 'Niet automatisch een link tonen naar de pagina over ons';
$string['aboutuslinkpositionsetting'] = 'Positie link Over ons';
$string['aboutuslinkpositionsetting_desc'] = 'Met deze instelling kun je configureren of er automatisch een link naar de pagina over ons moet worden toegevoegd aan de Moodle pagina. Als je niet wilt dat dit automatisch gebeurt, kun je handmatig een link naar {$a->url} toevoegen waar je maar wilt in Moodle.';
$string['aboutuspagetitledefault'] = 'Over ons';
$string['aboutuspagetitlesetting'] = 'Paginatitel Over ons';
$string['aboutuspagetitlesetting_desc'] = 'Met deze instelling kun je de titel instellen voor de pagina over ons. Deze tekst wordt ook gebruikt als de linktekst naar deze pagina wanneer je de positie voor de link Over ons daarvoor hebt ingesteld.';
$string['accessibilitydeclarationcontentsetting'] = 'Pagina-inhoud toegankelijkheidsverklaring';
$string['accessibilitydeclarationcontentsetting_desc'] = 'Met deze instelling kun je rijke tekstinhoud toevoegen die wordt getoond op pagina over de toegankelijkheidsverklaring.';
$string['accessibilitydeclarationdisabled'] = 'De informatiepagina met de toegankelijkheidsverklaring is uitgeschakeld voor deze site. Er is hier niets te zien.';
$string['accessibilitydeclarationheading'] = 'Toegankelijkheidsverklaring';
$string['accessibilitydeclarationlinkpositionboth'] = 'Voeg een link toe naar de pagina met de toegankelijkheidsverklaring in de voetnoot en het footericoon (vraagteken).';
$string['accessibilitydeclarationlinkpositionfooter'] = 'Voeg een link toe naar de pagina met de toegankelijkheidsverklaring bij het footericoon (vraagteken).';
$string['accessibilitydeclarationlinkpositionfootnote'] = 'Voeg een link toe naar de pagina met de toegankelijkheidsverklaring in de voetnoot.';
$string['accessibilitydeclarationlinkpositionnone'] = 'Toon niet automatisch een link naar de pagina met de toegankelijkheidsverklaring.';
$string['accessibilitydeclarationlinkpositionsetting'] = 'Positie van de link naar de toegankelijkheidspagina.';
$string['accessibilitydeclarationpagetitledefault'] = 'Toegankelijkheidsverklaring';
$string['accessibilitydeclarationtab'] = 'Verklaring';
$string['accessibilitysupportanonymousemail'] = 'anonymous@email.invalid';
$string['accessibilitysupportanonymoususer'] = 'Anonieme gebruiker';
$string['accessibilitysupportcontentsetting'] = 'Pagina-inhoud ondersteuning bij toegankelijkheid';
$string['accessibilitysupportdefaultsubject'] = 'Feedback over toegankelijkheid';
$string['accessibilitysupportdisabled'] = 'De ondersteuningspagina voor toegankelijkheid is uitgeschakeld voor deze site. Er is hier niets te zien.';
$string['accessibilitysupportheading'] = 'Ondersteuningspagina toegankelijkheid';
$string['accessibilitysupportlinkpositionboth'] = 'Voeg een link toe naar de ondersteuningspagina voor toegankelijkheid in de voetnoot en het footericoon (vraagteken).';
$string['accessibilitysupportlinkpositionfooter'] = 'Voeg een link toe naar de ondersteuningspagina voor toegankelijkheid bij het footericoon (vraagteken).';
$string['accessibilitysupportlinkpositionfootnote'] = 'Voeg een link toe naar de ondersteuningspagina voor toegankelijkheid in de voetnoot.';
$string['accessibilitysupportlinkpositionnone'] = 'Toon niet automatisch een link naar de ondersteuningspagina voor toegankelijkheid.';
$string['accessibilitysupportlinkpositionsetting'] = 'Positie van de link naar de ondersteuningspagina voor toegankelijkheid.';
$string['accessibilitysupportmessagenotsent'] = 'Helaas kon je verzoek voor ondersteuning bij toegankelijkheid niet verstuurd worden.';
$string['accessibilitysupportmessagesent'] = 'Je verzoek voor ondersteuning bij toegankelijkheid is verstuurd.';
$string['accessibilitysupportmessagetryagain'] = 'Probeer het op een later moment nogmaals.';
$string['accessibilitysupportmessagetryalternative'] = 'Probeer het later nogmaals of stuur rechtstreeks een e-mail naar <a href="mailto:{$a}">{$a}</a>.';
$string['accessibilitysupportpagesrlinktitledefault'] = 'Vraag ondersteuning bij toegankelijkheid';
$string['accessibilitysupportpagetitledefault'] = 'Ondersteuning bij toegankelijkheid';
$string['accessibilitysupportpagetitlesetting'] = 'Titel van pagina over ondersteuning bij toegankelijkheid';
$string['accessibilitysupportsubmit'] = 'Indienen';
$string['accessibilitysupporttab'] = 'Ondersteuningspagina';
$string['accessibilitysupporttechinfo'] = 'Technische informatie';
$string['accessibilitysupporttechinfocheckbox'] = 'Ik ga ermee akkoord de volgende technische informatie met mijn bericht mee te sturen';
$string['accessibilitysupporttechinfolabel'] = 'Technische informatie om mee te sturen';
$string['accessibilitysupporttechinforeferrer'] = 'Verwezen vanaf pagina';
$string['accessibilitysupporttechinfosysinfo'] = 'Systeeminformatie';
$string['accessibilitysupportuserfirstname'] = 'Toegankelijkheid';
$string['accessibilitysupportuserlastname'] = 'ondersteuning';
$string['accessibilitysupportusermail'] = 'E-mailadres ondersteuning bij toegankelijkheid';
$string['accessibilitysupportusermailsubject'] = 'Verzoek voor ondersteuning bij toegankelijkheid';
$string['activitybrandingtab'] = 'Branding voor activiteiten';
$string['activityiconcoloradministrationsetting'] = 'Kleur activiteitspictogram voor "Beheer"';
$string['activityiconcoloradministrationsetting_desc'] = 'De kleur van het activiteitspictogram voor "Beheer"';
$string['activityiconcolorassessmentsetting'] = 'Kleur activiteitspictogram voor "Beoordeling"';
$string['activityiconcolorassessmentsetting_desc'] = 'De kleur van het activiteitspictogram voor "Beoordeling"';
$string['activityiconcolorcollaborationsetting'] = 'Kleur activiteitspictogram voor "Samenwerking"';
$string['activityiconcolorcollaborationsetting_desc'] = 'De kleur van het activiteitspictogram voor "Samenwerking"';
$string['activityiconcolorcommunicationsetting'] = 'Kleur activiteitspictogram voor "Communicatie"';
$string['activityiconcolorcommunicationsetting_desc'] = 'De kleur van het activiteitspictogram voor "Communicatie"';
$string['activityiconcolorcontentsetting'] = 'Kleur activiteitspictogram voor "Inhoud"';
$string['activityiconcolorcontentsetting_desc'] = 'De kleur van het activiteitspictogram voor "Inhoud"';
$string['activityiconcolorinteractivecontentsetting'] = 'Kleur activiteitenicoon voor "interactieve inhoud"';
$string['activityiconcolorinteractivecontentsetting_desc'] = 'De kleur van het activiteitenicoon voor "interactieve inhoud"';
$string['activityiconcolorinterfacesetting'] = 'Kleur activiteitspictogram voor "Interface"';
$string['activityiconcolorinterfacesetting_desc'] = 'De kleur van het activiteitspictogram voor "Interface"';
$string['activityiconcolorsheading'] = 'Kleuren van activiteitspictogram';
$string['activitynavigationsetting'] = 'Navigatie-elementen voor activiteit en sectie';
$string['activitynavigationsetting_desc'] = 'Met deze instelling worden elementen zichtbaar om naar de vorige en volgende activiteit/bron te springen, evenals het keuzemenu. Bovendien worden soortgelijke elementen zichtbaar in cursussen ingesteld voor één sectie per pagina. UI elementen zoals deze bestonden al in Boost (Moodle core) tot en met Moodle 3.11, maar werden in 4.0 verwijderd. Met Boost Union kun je ze opnieuw terugbrengen.';
$string['activitypurposeadministration'] = 'Administratie';
$string['activitypurposeassessment'] = 'Beoordeling';
$string['activitypurposecollaboration'] = 'Samenwerking';
$string['activitypurposecommunication'] = 'Communicatie';
$string['activitypurposecontent'] = 'Inhoud';
$string['activitypurposeheading'] = 'Activiteit pictogram doeleinden';
$string['activitypurposeheading_desc'] = 'Met deze instellingen kan je de achtergrondkleur van het activiteitspictogram overschrijven, die wordt bepaald door het doel van de activiteit (en die een hardgecodeerde plug-infunctie is in elke activiteit).';
$string['activitypurposeheadingtechnote'] = 'Technische noot: Door de manier waarop Moodle core de doelen voor activiteiten en bijbehorende kleuren implementeert, worden deze activiteitdoelen alleen met CSS overschreven in Boost Union. Op dit moment zouden alle gebieden waar Moodle core gekleurde activiteiteniconen toon afgedekt moeten zijn. Als je toch een gebied of een plugin van derden signaleert die de ongewijzigde kleuren voor activiteitdoelen toont, meld dit dan via {$a}.';
$string['activitypurposeinteractivecontent'] = 'Interactieve inhoud';
$string['activitypurposeinterface'] = 'Interface';
$string['activitypurposeother'] = 'Andere';
$string['additionalresourcesfileurlpersistent'] = 'URL (blijvend)';
$string['additionalresourcesfileurlrevisioned'] = 'URL (herzien)';
$string['additionalresourcesheading'] = 'Aanvullende middelen';
$string['additionalresourceslistsetting'] = 'Aanvullende middelen lijst';
$string['additionalresourceslistsetting_desc'] = 'Dit is de lijst van bestanden die je hebt geüpload naar de bestandenzone voor aanvullende bestanden. De gegeven URLs kunnen worden gebruikt om naar deze bestanden te linken in je aangepaste CSS, vanuit de voetnoot of waar je dan ook de geüploade bestanden wilt gebruiken maar op die plaats geen bestanden kunt uploaden.';
$string['additionalresourcessetting'] = 'Aanvullende middelen';
$string['additionalresourcessetting_desc'] = 'Met deze instelling kun je extra bronnen uploaden naar het thema. Het voordeel van het uploaden van bestanden naar dit bestandsgebied is dat die bestanden zonder controle afgeleverd kunnen worden als de gebruiker ingelogd is. Dit is ook de reden waarom je alleen bestanden moet toevoegen die niet cruciaal zijn en iedereen toegang moet hebben tot en niet beveiligd hoeft te zijn met een geldige login. Zodra je minimaal één bestand naar dit bestandsgebied hebt geüpload en de instellingen hebt opgeslagen, verschijnt eronder een lijst met de URL die je kunt gebruiken om naar een bepaald bestand te verwijzen.';
$string['addpreferredlangsetting'] = 'Voeg een link naar voorkeurstaal toe aan het taalmenu';
$string['administrationtab'] = 'Beheer';
$string['alternativelogolinkurlsetting'] = 'URL voor alternatieve link naar logo';
$string['always'] = 'Altijd';
$string['backgroundimagepositionsetting'] = 'Positie achtergrondafbeelding';
$string['backgroundimagepositionsetting_desc'] = 'Met deze instelling kun je de positie van de achtergrondafbeelding binnen het browservenster regelen. De eerste waarde is de horizontale positie, de tweede de verticale positie.';
$string['backgroundimagesetting'] = 'Achtergrond afbeelding';
$string['backgroundimagesetting_desc'] = 'Hier kan je een aangepaste afbeelding uploaden om als achtergrond van de site weer te geven. De achtergrondafbeelding die je hier uploadt, overschrijft de achtergrondafbeelding in jouw bestanden met vooraf ingestelde thema\'s.';
$string['backgroundimagesheading'] = 'Algemene achtergrondafbeeldingen';
$string['backtotop'] = 'Terug naar boven';
$string['backtotopbuttonsetting'] = 'Knop Terug naar boven';
$string['backtotopbuttonsetting_desc'] = 'Met deze instelling verschijnt er een terug naar boven-knop in de rechterbenedenhoek van de pagina zodra de gebruiker naar beneden scrolt. Een dergelijke knop bestond al op Boost in Moodle Core tot Moodle 3.11, maar werd verwijderd in 4.0. Met Boost Union kun je het terugbrengen.';
$string['blockdrawerwidthsetting'] = 'Breedte van de blokkenkolom';
$string['blockregionfooterwidth'] = 'Breedte van blokkenregio \'Footer\'';
$string['blockregionfooterwidth_desc'] = 'Met deze instelling kunt u de breedte van het blokgebied \'Footer\' instellen. U kunt kiezen tussen de volledige breedte, de breedte van de cursusinhoud en de breedte van de hero.';
$string['blockregionoutsidebottomwidth'] = 'Breedte van blokkenregio \'Buiten (onder)\'';
$string['blockregionoutsidebottomwidth_desc'] = 'Met deze instelling kunt u de breedte instellen van het blokgebied \'Buiten (onder)\' dat wordt weergegeven onder de hoofdinhoud. U kunt kiezen tussen de volledige breedte, de breedte van de cursusinhoud en de breedte van de held.';
$string['blockregionoutsideleftwidth'] = 'Breedte van blokkenregio \'Buiten (links)\'';
$string['blockregionoutsiderightwidth'] = 'Breedte van de blokkenregio \'Buiten (rechts)\'';
$string['blockregionoutsidetopwidth'] = 'Breedte van de blokkenregio \'Buiten (boven)\'';
$string['blockregionsforlayout'] = 'Aanvullende blokkenregio\'s voor de \'{$a}\' layout';
$string['blockregionsheading'] = 'Aanvullende blokkenregio\'s';
$string['blocksgeneralheading'] = 'Algemene blokken';
$string['blockstab'] = 'Blokken';
$string['boost_union:configure'] = 'Kan het thema instellen zonder sitebeheerder te zijn';
$string['boost_union:editregioncontentlower'] = 'Kan de blokregio Inhoud (onder) bewerken';
$string['boost_union:editregioncontentupper'] = 'Kan de blokregio Inhoud (boven) bewerken';
$string['boost_union:editregionfootercenter'] = 'Kan de blokregio Inhoud (midden) bewerken';
$string['boost_union:editregionfooterleft'] = 'Kan de blokregio Voettekst (links) bewerken';
$string['boost_union:editregionfooterright'] = 'Kan de blokregio Voettekst (rechts) bewerken';
$string['boost_union:editregionheader'] = 'Kan de blokregio Koptekst bewerken';
$string['boost_union:editregionoffcanvascenter'] = 'Kan de blokregio Off-canvas (midden) bewerken';
$string['boost_union:editregionoffcanvasleft'] = 'Kan de blokregio Off-canvas (links) bewerken';
$string['boost_union:editregionoffcanvasright'] = 'Kan de blokregio Off-canvas (rechts) bewerken';
$string['boost_union:editregionoutsidebottom'] = 'Kan de blokregio Buiten (onder) bewerken';
$string['boost_union:editregionoutsideleft'] = 'Kan de blokregio Buiten (links) bewerken';
$string['boost_union:editregionoutsideright'] = 'Kan de blokregio Buiten (rechts) bewerken';
$string['boost_union:editregionoutsidetop'] = 'Kan de blokregio Buiten (Boven) bewerken';
$string['boost_union:viewhintcourseselfenrol'] = 'Kan een hint zien voor zelf aanmelden zonder restricties in een zichtbare cursus.';
$string['boost_union:viewhintinhiddencourse'] = 'Kan een hint zien in een verborgen cursus.';
$string['boost_union:viewregioncontentlower'] = 'Kan de blokregio Inhoud (onder) zien';
$string['boost_union:viewregioncontentupper'] = 'Kan de blokregio Inhoud (boven) zien';
$string['boost_union:viewregionfootercenter'] = 'Kan de blokregio Voettekst (midden) zien';
$string['boost_union:viewregionfooterleft'] = 'Kan de blokregio Voettekst (links) zien';
$string['boost_union:viewregionfooterright'] = 'Kan de blokregio Voettekst (rechts) zien';
$string['boost_union:viewregionheader'] = 'Kan de blokregio Koptekst zien';
$string['boost_union:viewregionoffcanvascenter'] = 'Kan de blokregio Off-canvas (midden) zien';
$string['boost_union:viewregionoffcanvasleft'] = 'Kan de blokregio Off-canvas (links) zien';
$string['boost_union:viewregionoffcanvasright'] = 'Kan de blokregio Off-canvas (rechts) zien';
$string['boost_union:viewregionoutsidebottom'] = 'Kan de blokregio Buiten (onder) zien';
$string['boost_union:viewregionoutsideleft'] = 'Kan de blokregio Buiten (links) zien';
$string['boost_union:viewregionoutsideright'] = 'Kan de blokregio Buiten (rechts) zien';
$string['boost_union:viewregionoutsidetop'] = 'Kan de blokregio Buiten (boven) zien';
$string['bootstrapcolordangersetting'] = 'Bootstrap kleur voor "Gevaar"';
$string['bootstrapcolordangersetting_desc'] = 'De Bootstrap kleur voor "Gevaar"';
$string['bootstrapcolorinfosetting'] = 'Bootstrap kleur voor "Info"';
$string['bootstrapcolorinfosetting_desc'] = 'De Bootstrap kleur voor "Info"';
$string['bootstrapcolorsheading'] = 'Bootstrapkleuren';
$string['bootstrapcolorsuccesssetting'] = 'Bootstrap kleur voor "Succes"';
$string['bootstrapcolorsuccesssetting_desc'] = 'De Bootstrap kleur voor "Succes"';
$string['bootstrapcolorwarningsetting'] = 'Bootstrap kleur voor "Waarschuwing"';
$string['bootstrapcolorwarningsetting_desc'] = 'De Bootstrap kleur voor "Waarschuwing"';
$string['bootstrapdangercolor'] = 'Kleur gevaar';
$string['bootstrapdarkcolor'] = 'Kleur donker';
$string['bootstrapinfocolor'] = 'Kleur info';
$string['bootstraplightcolor'] = 'Kleur licht';
$string['bootstrapnone'] = 'Geen Bootstrap kleur';
$string['bootstrapprimarycolor'] = 'Primaire kleur';
$string['bootstrapsecondarycolor'] = 'Secundaire kleur';
$string['bootstrapsuccesscolor'] = 'Kleur succes';
$string['bootstrapwarningcolor'] = 'Kleur waarschuwing';
$string['brandcolorsheading'] = 'Merkkleuren';
$string['breadcrumbsheading'] = 'Broodkruimels';
$string['cachedef_flavours'] = 'Smaken die voor de huidige gebruiker van toepassing zijn op een pagina gezien het categorie ID';
$string['cachedef_smartmenu_items'] = 'Items in slimme menu\'s';
$string['cachedef_smartmenus'] = 'Slimme menu\'s';
$string['cachedef_touchiconsios'] = 'Bestanden voor tiptoetsiconen voor iOS';
$string['categorybreadcrumbs'] = 'Toon het broodkruimelpad voor categorieën in de koptekst van de cursus';
$string['categoryindextab'] = 'Index van een categorie / Site startpagina';
$string['categorylistingheading'] = 'Lijst van categorieën';
$string['categorylistingpresentation'] = 'Presentatie van de lijst van categorieën';
$string['categorylistingpresentation_boxlist'] = 'Lijst met vakjes';
$string['categorylistingpresentation_nochange'] = 'Nachtmerrie voor iedere ontwerper (onveranderd en weergegeven door Moodle core)';
$string['closeoffcanvas'] = 'Off-canvas zijbalk sluiten';
$string['configtitle'] = 'Boost Union';
$string['configtitleaccessibility'] = 'Toegankelijkheid';
$string['configtitlecontent'] = 'Inhoud';
$string['configtitlefeel'] = 'Gevoel';
$string['configtitleflavours'] = 'Smaken';
$string['configtitlefunctionality'] = 'Functionaliteit';
$string['configtitlelook'] = 'Opmaak';
$string['contactcontentsetting'] = 'Inhoud contactpagina';
$string['contactcontentsetting_desc'] = 'Met deze instelling kun je opgemaakte tekstinhoud toevoegen die wordt weergegeven op een contactpagina (die niet hetzelfde is als de in Moodle ingebouwde pagina \'Neem contact op met site-ondersteuning\').';
$string['contactdisabled'] = 'De contactpagina is uitgeschakeld voor deze pagina. Hier is niets te zien of lezen.';
$string['contactheading'] = 'Contact';
$string['contactlinkpositionboth'] = 'Voeg een link toe naar de contactpagina aan de voetnoot en in het footericoon (vraagteken)';
$string['contactlinkpositionfooter'] = 'Voeg een link toe naar de contactpagina en in het footericoon (vraagteken)';
$string['contactlinkpositionfootnote'] = 'Voeg een link toe naar de contactpagina aan de voetnoot';
$string['contactlinkpositionnone'] = 'Niet automatisch een link toevoegen naar de contactpagina';
$string['contactlinkpositionsetting'] = 'Positie link naar contactpagina';
$string['contactpagetitledefault'] = 'Contact';
$string['contactpagetitlesetting'] = 'Titel contactpagina';
$string['contentwidthheading'] = 'Breedte van de inhoud';
$string['coursecardscolumncount'] = 'Aantal kolommen voor cursuskaarten';
$string['coursecontentmaxwidthsetting'] = 'Maximale breedte van de cursusinhoud';
$string['courseheaderheading'] = 'Koptekst van de cursus';
$string['courseheaderimageenabled'] = 'Toon de cursusafbeelding in de koptekst van de cursus';
$string['courseheaderimagefallback'] = 'Afbeelding om op terug te vallen in de koptekst van de cursus';
$string['courseheaderimageheight'] = 'Hoogte van de cursusafbeelding in de koptekst';
$string['courseheaderimagelayout'] = 'Opmaak van de cursusafbeelding in de koptekst';
$string['courseheaderimagelayoutheadingabove'] = 'Cursustitel boven cursusafbeelding';
$string['courseheaderimagelayoutstackeddark'] = 'Cursustitel bovenop cursusafbeelding (witte letterkleur voor afbeeldingen met een donkere achtergrond)';
$string['courseheaderimagelayoutstackedlight'] = 'Cursustitel bovenop cursusafbeelding (zwarte letterkleur voor afbeeldingen met een lichte achtergrond)';
$string['courseheaderimageposition'] = 'Positie afbeelding cursusheader';
$string['courseindexcompletioninfoposition'] = 'Positie van de indicator voor activiteitsvoltooiing';
$string['courseindexcompletioninfopositionendofline'] = 'Einde van regel';
$string['courseindexcompletioninfopositioniconcolor'] = 'Kleur icoon';
$string['courseindexcompletioninfopositionstartofline'] = 'Begin van regel';
$string['courseindexdrawerwidthsetting'] = 'Breedte van de zijbalk voor cursusindex';
$string['courseindexheading'] = 'Cursusindex';
$string['courseindexmodiconenabled'] = 'Iconen van activiteitentype tonen in cursusindex';
$string['courselistingcontacts'] = 'Cursuscontact';
$string['courselistingfields'] = 'Cursusinformatie';
$string['courselistinggoto'] = 'Ga naar cursus';
$string['courselistingheading'] = 'Cursuslijst';
$string['courselistinghowcategory'] = 'Cursuscategorie in cursuslijst tonen';
$string['courselistinghowenrolicons'] = 'Iconen voor cursusaanmelding tonen in cursuslijst';
$string['courselistinghowgoto'] = 'Knop \'Ga naar cursus\' tonen in cursuslijst';
$string['courselistinghowimage'] = 'Cursusafbeelding tonen in cursuslijst';
$string['courselistinghowpopup'] = 'Popup met details tonen in cursuslijst';
$string['courselistinghowprogress'] = 'Cursusvoltooiing tonen in cursuslijst';
$string['courselistinghowshortname'] = 'Korte naam van cursus tonen in cursuslijst';
$string['courselistingnosummary'] = 'Er is geen samenvatting van deze cursus';
$string['courselistingpopup'] = 'Details';
$string['courselistingpresentation'] = 'Weergave van de cursuslijst';
$string['courselistingpresentation_cards'] = 'Cursuskaarten';
$string['courselistingpresentation_list'] = 'Cursuslijst';
$string['courselistingpresentation_nochange'] = 'Nachtmerrie van de ontwerper (onveranderd en weergegeven door Moodle core)';
$string['courselistingshowcontacts'] = 'Cursuscontacten tonen in cursuslijst';
$string['courselistingummary'] = 'Cursussamenvatting';
$string['courselistingviewprofile'] = 'Bekijk profiel';
$string['coursemanagementheading'] = 'Cursusbeheer';
$string['courseoverviewheading'] = 'Blok Cursusoverzicht';
$string['courseoverviewshowcourseimagessetting'] = 'Toon cursusafbeeldingen';
$string['courseoverviewshowprogresssetting'] = 'Toon voortgang cursusvoltooiing';
$string['courseoverviewshowprogresssetting_desc'] = 'Met deze instelling kun je regelen of de voortgang voor cursusvoltooiing zichtbaar is binnen het blok Cursusoverzicht.';
$string['coursestab'] = 'Cursussen';
$string['coursetab'] = 'Cursus';
$string['cssh5pheading'] = 'Ruwe CSS voor H5P';
$string['cssh5psetting'] = 'Ruwe CSS voor H5P';
$string['customfontsfileurlpersistent'] = 'URL (persistent)';
$string['customfontsfileurlrevisioned'] = 'URL (herzien)';
$string['customfontsheading'] = 'Aangepaste lettertypen';
$string['customfontslistsetting'] = 'Lijst aangepaste lettertypen';
$string['customfontssetting'] = 'Aangepaste lettertypen';
$string['dashboardtab'] = 'Mijn startpagina / Mijn cursussen';
$string['dontchange'] = 'Niets wijzigen';
$string['drawerwidthheading'] = 'Breedte van de zijbalk';
$string['emailbrandinghtmlheading'] = 'HTML voorbeeldweergave e-mail';
$string['emailbrandinginstruction'] = 'Uitleg';
$string['emailbrandinginstructionli3'] = 'Wijzigingen opslaan in taalpakket';
$string['emailbrandingintroheading'] = 'Introductie';
$string['emailbrandingpitfalls'] = 'Risico\'s';
$string['emailbrandingpitfalls0'] = 'Als je deze functionaliteit gebruikt, is er een aantal risico\'s om je bewust van te zijn:';
$string['emailbrandingtextheading'] = 'Voorbeeld weergave e-mail in platte tekst';
$string['enableaboutussetting'] = 'Pagina \'Over ons\' inschakelen';
$string['enablecontactsetting'] = 'Contactpagina inschakelen';
$string['enablefooterbutton'] = 'Footer inschakelen';
$string['enablefooterbuttonboth'] = 'Inschakelen voor computer, tablet en mobiel';
$string['enablefooterbuttondesktop'] = 'Alleen op computer en tablet inschakelen, verbergen op mobiel';
$string['enablefooterbuttonhidden'] = 'Verbergen op alle devices';
$string['enablefooterbuttonmobile'] = 'Alleen op mobiel inschakelen, verbergen op computer en tablet';
$string['enablehelpsetting'] = 'Ondersteuningspagina inschakelen';
$string['enableimprintsetting'] = 'Colofon inschakelen';
$string['enablemaintenancesetting'] = 'Pagina Onderhoudsinformatie inschakelen';
$string['enableofferssetting'] = 'Aanbiedingenpagina inschakelen';
$string['enablepage1setting'] = 'Generieke pagina 1 inschakelen';
$string['enablepage2setting'] = 'Generieke pagina 2 inschakelen';
$string['enablepage3setting'] = 'Generieke pagina 3 inschakelen';
$string['error:smartmenusmenuitemnotfound'] = 'Item van slim menu niet gevonden';
$string['error:smartmenusmenunotfound'] = 'Slim menu niet gevonden';
$string['extscssheading_instr'] = 'Instructies:';
$string['extscsssource'] = 'Externe bron voor SCSS';
$string['extscsssourcenone'] = 'Geen';
$string['extscssvalidationsetting'] = 'Validatie externe SCSS';
$string['faviconheading'] = 'Favicon';
$string['faviconsetting'] = 'Favicon';
$string['flavoursappliesto'] = 'Toepassen op';
$string['flavoursapplytocategories'] = 'Toepassen op cursuscategorieën';
$string['flavoursapplytocategories_help'] = 'Hier kun je instellen of deze smaak zou moeten worden toegepast op cursuscategorieën.';
$string['flavoursapplytocategories_ids'] = 'Cursuscategorieën';
$string['flavoursapplytocohorts'] = 'Toepassen op sitegroepen';
$string['flavoursapplytocohorts_help'] = 'Hier kun je instellen of deze smaak moet worden toegepast op sitegroepen.';
$string['flavoursapplytocohorts_ids'] = 'Sitegroepen';
$string['flavoursbackgroundimage'] = 'Achtergrondafbeelding';
$string['flavoursbacktooverview'] = 'Terug naar smakenoverzicht';
$string['flavourscreateflavour'] = 'Smaak maken';
$string['flavoursdelete'] = 'Verwijderen';
$string['flavoursdeleteconfirmation'] = 'Weet je zeker dat je de smaak <em>{$a}</em> wilt verwijderen?';
$string['flavoursdeleteflavour'] = 'Smaak verwijderen';
$string['flavoursdescription'] = 'Beschrijving';
$string['flavoursedit'] = 'Bewerken';
$string['flavourseditflavour'] = 'Smaak bewerken';
$string['flavoursfavicon'] = 'Favicon';
$string['flavoursflavours'] = 'Smaken';
$string['flavoursgeneralsettings'] = 'Algemene instellingen';
$string['flavoursincludesubcategories'] = 'Toepassen op subcategorieën';
$string['flavourslogo'] = 'Logo';
$string['flavourslogocompact'] = 'Compact logo';
$string['flavoursnothingtodisplay'] = 'Er zijn nog geen smaken aangemaakt. Ga aan de slag en maak je eerste smaak aan.';
$string['flavoursnotificationcreated'] = 'De smaak werd succesvol aangemaakt';
$string['flavoursnotificationdeleted'] = 'De smaak werd succesvol verwijderd';
$string['flavoursnotificationedited'] = 'De smaak werd succesvol bewerkt';
$string['flavourspreview'] = 'Voorbeeldweergave';
$string['flavourspreviewflavour'] = 'Voorbeeldweergave smaak';
$string['flavourstitle'] = 'Titel';
$string['flavourstitle_help'] = 'De titel van de smaak wordt enkel intern gebruikt om smaken in een lijst te kunnen bijhouden.';
$string['footerheading'] = 'Footer';
$string['footersuppresschatsetting'] = 'Link onderdrukken voor \'Chat met cursusdeelnemers\'';
$string['footersuppresscontactsetting'] = 'Link \'Neem contact op met websiteondersteuning\' onderdrukken';
$string['footersuppresshelpsetting'] = 'Link \'Documentatie voor deze pagina\' onderdrukken';
$string['footersuppressiconssetting'] = 'Iconen onderdrukken voor links in de voettekst';
$string['footersuppresslogininfosetting'] = 'Informatie over inloggen onderdrukken';
$string['footersuppresspoweredsetting'] = 'Onderdruk link \'Powered by Moodle\'';
$string['footersuppressservicessetting'] = 'Link \'Diensten en ondersteuning\' onderdrukken';
$string['footersuppressthemeswitchsetting'] = 'Links om van thema te wisselen onderdrukken';
$string['footertab'] = 'Footer';
$string['footnoteheading'] = 'Voetnoot';
$string['footnotesetting'] = 'Voetnoot';
$string['forguestsonly'] = 'Alleen voor gasten en niet-ingelogde gebruikers';
$string['h5pcontentmaxwidthsetting'] = 'Maximale breedte H5P Inhoudsbank';
$string['h5ptab'] = 'H5P';
$string['helpcontentsetting'] = 'Inhoud ondersteuningspagina';
$string['helpheading'] = 'Ondersteuning';
$string['helplinkpositionsetting'] = 'Positie link naar ondersteuningspagina';
$string['helppagetitledefault'] = 'Help';
$string['helppagetitlesetting'] = 'Titel ondersteuningspagina';
$string['imprintcontentsetting'] = 'Inhoud colofon';
$string['imprintheading'] = 'Colofon';
$string['infobannerclose'] = 'Sluiten';
$string['infobannerpageloginpage'] = 'Loginpagina';
$string['invalidurl'] = 'De gegeven URL is ongeldig';
$string['javascriptdisabledhint'] = 'Hint JavaScript uitgeschakeld';
$string['javascriptheading'] = 'JavaScript';
$string['linkstab'] = 'Links';
$string['loginbackgroundimage'] = 'Achtergrondafbeeldingen inlogpagina';
$string['loginformheading'] = 'Loginformulier';
$string['loginformpositionsetting'] = 'Positie loginformulier';
$string['loginformpositionsetting_center'] = 'Gecentreerd';
$string['loginformpositionsetting_left'] = 'Links uitgelijnd';
$string['loginformpositionsetting_right'] = 'Rechts uitgelijnd';
$string['loginformtransparencysetting'] = 'Transparantie van inlogformulier';
$string['loginidpshowintrosetting'] = 'IDP login intro';
$string['loginlocalintro'] = 'Log in met je Moodle account';
$string['loginlocalloginenablesetting'] = 'Lokale login';
$string['loginlocalloginformhead'] = 'Lokale login';
$string['loginlocalshowintrosetting'] = 'Intro voor lokale login';
$string['loginorderfirsttimesignupsetting'] = 'Informatie voor eerste bezoek & Zelfregistratie';
$string['loginorderguestsetting'] = 'Gasttoegang';
$string['loginorderheading'] = 'Volgorde van inloggen';
$string['loginorderidpsetting'] = 'IdP login';
$string['loginorderlocalsetting'] = 'Lokale login';
$string['loginpagetab'] = 'Inlogpagina';
$string['loginprovidersheading'] = 'Inlogproviders';
$string['logocompactsetting'] = 'Compact logo';
$string['logosetting'] = 'Logo';
$string['logosheading'] = 'Logo\'s';
$string['maintenanceheading'] = 'Onderhoud';
$string['maintenancepagetitledefault'] = 'Onderhoud';
$string['maintenancepagetitlesetting'] = 'Titel van onderhoudsinformatiepagina';
$string['markbrokenlinkssetting'] = 'Niet-werkende links markeren';
$string['misctab'] = 'Overige';
$string['mobileappearanceheading'] = 'Uiterlijk op mobiel';
$string['mobileappheading'] = 'Mobiele app';
$string['mobiletab'] = 'Mobiel';
$string['modiconactivity'] = 'Activiteit';
$string['modiconactivityunknown'] = 'Onbekend';
$string['modicongtmoodle4'] = 'Moodle 4 icoon';
$string['modiconsheading'] = 'Activiteit iconen';
$string['modiconversion'] = 'Versie icoon';
$string['navbarcolorsetting'] = 'Kleur navigatiebalk';
$string['navbarcolorsetting_dark'] = 'Donkere navigatiebalk met lichte letterkleur';
$string['navbarheading'] = 'Navigatiebalk';
$string['navigationheading'] = 'Navigatie';
$string['navigationtab'] = 'Navigatie';
$string['outsideregionswidthcoursecontentwidth'] = 'Breedte van cursusinhoud';
$string['outsideregionswidthfullwidth'] = 'Volledige breedte';
$string['pagetab'] = 'Pagina';
$string['pagewidthheading'] = 'Pagina breedte';
$string['pluginname'] = 'Boost Union';
$string['region-header'] = 'Kop';
$string['settingsoverview'] = 'Overzicht van instellingen';
$string['settingsoverview_smartmenus_desc'] = 'Met slimme menu\'s kun je de navigatie-items voor je Moodle site uitbreiden, in het hoofd- en gebruikersmenu. Daarnaast kun je een extra menu boven- of onderaan de pagina toevoegen.';
$string['settingsoverview_title'] = 'Overzicht van instellingen voor Boost Union';
$string['showhintcourseguestaccessgeneral'] = 'Je bekijkt deze cursus op het moment als <strong>{$a->role}</strong>.';
$string['showhintcourseguestaccesslink'] = 'Om volledige toegang tot de cursus te krijgen, kun je <a href="{$a->url}"jezelf aanmelden in de cursus</a>.';
$string['showhintcoursehiddengeneral'] = 'Deze cursus is op het moment <strong>verborgen</strong>. Alleen aangemelde leraren hebben toegang tot de cursus zolang die verborgen is.';
$string['showhintcoursehiddensetting'] = 'Hint tonen in verborgen cursussen';
$string['showhintcoursehiddensettingslink'] = 'Je kunt de zichtbaarheid wijzigingen in de <a href="{$a->url}">cursusinstellingen</a>.';
$string['showhintcourseselfenrolsetting'] = 'Hint tonen voor zelf aanmelden zonder aanmeldsleutel';
$string['showhintcourseselfenrolstartcurrently'] = 'Deze cursus is op het moment zichtbaar voor iedereen en <strong>zelf aanmelden zonder aanmeldsleutel</strong> is mogelijk.';
$string['showhintcourseselfenrolstartfuture'] = 'Deze cursus is op het moment zichtbaar voor iedereen en <strong>zelf aanmelden zonder aanmeldsleutel</strong> staat ingepland om beschikbaar te worden.';
$string['showhintcoursguestaccesssetting'] = 'Hint voor gasttoegang tonen';
$string['showhintforumnotifications'] = 'Deze cursus is op het moment <strong>verborgen</strong>. Dat betekent dat <strong>leerlingen geen meldingen, online of via e-mail, zullen ontvangen</strong> van berichten die je in dit forum plaatst.';
$string['showhintforumnotificationssetting'] = 'Hint tonen voor forumnotificaties in verborgencursussen';
$string['showhintforumnotificationssetting_desc'] = 'Met deze instelling verschijnt de hint niet alleen in de cursusheader, maar ook in een forum zolang de zichtbaarheid van de cursus is ingesteld op verborgen. Dit is om duidelijk te maken dat notificaties binnen een forum niet naar leerlingen zullen worden verstuurd en om de leraren te helpen deze omstandigheid te begrijpen.';
$string['showsitehomerighthandblockdraweronguestloginsetting'] = 'Blokkenkolom rechts tonen op sitestartpagina voor gasten die inloggen';
$string['slideranimationsetting_fade'] = 'Vervagen';
$string['slideranimationsetting_slide'] = 'Schuiven';
$string['sliderarrownavsetting'] = 'Navigeren met pijlen inschakelen';
$string['sliderarrownavsetting_desc'] = 'Met deze instelling kun je navigatiepijlen toevoegen aan beide kanten van de diavoorstelling.';
$string['sliderfrontpagepositionsetting'] = 'Plaatsing van de diavoorstelling op site startpagina';
$string['sliderfrontpagepositionsetting_afterafter'] = 'Na de inhoud van site startpagina (en na de reclametegels)';
$string['sliderfrontpagepositionsetting_afterbefore'] = 'Na de inhoud van site startpagina (maar voor de reclametegels)';
$string['sliderfrontpagepositionsetting_beforeafter'] = 'Voor de inhoud van site startpagina (en na de reclametegels)';
$string['sliderfrontpagepositionsetting_beforebefore'] = 'Voor de inhoud van site startpagina (maar voor de reclametegels)';
$string['slidergeneralheading'] = 'Diavoorstelling algemeen';
$string['sliderintervalsetting'] = 'Afspeelinterval diavoorstelling';
$string['sliderkeyboardsetting'] = 'Interactie via toetsenbord inschakelen voor diavoorstelling';
$string['sliderpausesetting'] = 'Diavoorstelling pauzeren bij mouseover';
$string['sliderridesetting_afterinteraction'] = 'Na interactie';
$string['sliderridesetting_never'] = 'Nooit';
$string['sliderridesetting_onpageload'] = 'Bij laden pagina';
$string['slidertab'] = 'Diavoorstelling';
$string['smartmenus'] = 'Slimme menu\'s';
$string['smartmenusbyadmin'] = 'Tonen aan';
$string['smartmenusbyadmin_admins'] = 'Alleen sitebeheerders';
$string['smartmenusbyadmin_all'] = 'Alle gebruikers';
$string['smartmenusbyadmin_help'] = 'Zichtbaarheid beperken op basis van of een gebruiker sitebeheerder is of niet.';
$string['smartmenusbyadmin_nonadmins'] = 'Alleen niet-sitebeheerders';
$string['smartmenusbycohort'] = 'Op basis van sitegroep';
$string['smartmenusbycohort_help'] = 'Zichtbaarheid beperken op basis van sitegroeplidmaatschappen van gebruiker.';
$string['smartmenusbydate'] = 'Op datum';
$string['smartmenusbydate_help'] = 'Zichtbaarheid beperken op basis van datum';
$string['smartmenusbydatefrom'] = 'Vanaf';
$string['smartmenusbydatefrom_help'] = 'Zichtbaarheid beperken totdat de gegeven datum bereikt is';
$string['smartmenusbydateuntil'] = 'Tot';
$string['smartmenusbydateuntil_help'] = 'Zichtbaarheid beperken nadat de gegeven datum bereikt is';
$string['smartmenusbylanguage'] = 'Op taal';
$string['smartmenusbylanguage_help'] = 'Zichtbaarheid beperken op basis van de taal van de gebruiker';
$string['smartmenusbyrole'] = 'Op rol';
$string['smartmenusbyrole_help'] = 'Zichtbaarheid beperken op basis van de rol(len) van de gebruiker';
$string['smartmenusdynamiccoursescompletionstatus'] = 'Status voltooiing';
$string['smartmenusdynamiccoursescompletionstatuscompleted'] = 'Voltooid';
$string['smartmenusdynamiccoursescompletionstatusenrolled'] = 'Aangemeld';
$string['smartmenusdynamiccoursescompletionstatusinprogress'] = 'Bezig';
$string['smartmenusdynamiccoursescoursecategory'] = 'Cursuscategorie';
$string['smartmenusmenucardsizelarge'] = 'Groot';
$string['smartmenusmenucardsizemedium'] = 'Medium';
$string['smartmenusmenucardsizesmall'] = 'Smal';
$string['smartmenusmenucreate'] = 'Maak menu';
$string['smartmenusmenudeleteconfirm'] = 'Weet je zeker dat je dit menu wilt verwijderen uit slimme menu\'s?';
$string['smartmenusmenudescription'] = 'Beschrijving';
$string['smartmenusmenuitemcreatesuccess'] = 'Slim menu-item succesvol aangemaakt';
$string['smartmenusmenuitemcssclass'] = 'CSS class';
$string['smartmenusmenuitemdeleteconfirm'] = 'Weet je zeker dat je dit menu-item wilt verwijderen uit het slimme menu?';
$string['smartmenusmenuitemdeletesuccess'] = 'Slim menu-item succesvol verwijderd';
$string['smartmenusmenuitemdisplayfield'] = 'Weergave cursusnaam';
$string['smartmenusmenuitemdisplayfieldcoursefullname'] = 'Cursus volledige naam';
$string['smartmenusmenuitemdisplayfieldcourseshortname'] = 'Cursus korte naam';
$string['smartmenusmenuitemdisplayoptions'] = 'Titelweergave';
$string['smartmenusmenuitemdisplayoptionshidetitlemobile'] = 'Tekst van titel verbergen en alleen icoon weergeven (op mobiele devices)';
$string['smartmenusmenuitemdisplayoptionsshowtitleicon'] = 'Tekst en icoon weergeven als titel';
$string['smartmenusmenuitemduplicate'] = 'Menu-item dupliceren';
$string['smartmenusmenuitemduplicatesuccess'] = 'Menu-item succesvol gedupliceerd';
$string['smartmenusmenuitemedit'] = 'Menu-item bewerken';
$string['smartmenusmenuitemeditsuccess'] = 'Slim menu-item succesvol bijgewerkt';
$string['smartmenusmenuitemicon'] = 'Icoon';
$string['smartmenusmenuitemlinktarget'] = 'Doel van link';
$string['smartmenusmenuitemlinktargetnewtab'] = 'Nieuw tabblad';
$string['smartmenusmenuitemlinktargetsamewindow'] = 'Zelfde venster';
$string['smartmenusmenuitemlistsort'] = 'Sorteren cursuslijst';
$string['smartmenusmenuitemlistsortcourseidasc'] = 'Cursus ID oplopend';
$string['smartmenusmenuitemlistsortcourseiddesc'] = 'Cursus ID aflopend';
$string['smartmenusmenuitemlistsortcourseidnumberasc'] = 'Cursus ID-nummer oplopend';
$string['smartmenusmenuitemlistsortcourseidnumberdesc'] = 'Cursus ID-nummer aflopend';
$string['smartmenusmenuitemlistsortfullnameasc'] = 'Volledige naam cursus oplopend';
$string['smartmenusmenuitemlistsortfullnamedesc'] = 'Volledige naam cursus aflopend';
$string['smartmenusmenuitemlistsortshortnameasc'] = 'Korte naam cursus oplopend';
$string['smartmenusmenuitemlistsortshortnamedesc'] = 'Korte naam cursus aflopend';
$string['smartmenusmenuitemmode'] = 'Modus menu-item';
$string['smartmenusmenuitemorder'] = 'Volgorde';
$string['smartmenusmenuitempresentationheader'] = 'Weergave menu-item';
$string['smartmenusmenuitemresponsive'] = 'Responsief verbergen';
$string['smartmenusmenuitemresponsivedesktop'] = 'Desktop';
$string['smartmenusmenuitemresponsivemobile'] = 'Mobiel';
$string['smartmenusmenuitemresponsivetablet'] = 'Tablet';
$string['smartmenusmenuitemrestriction'] = 'Regels voor toegang';
$string['smartmenusmenuitems'] = 'Menu-items';
$string['smartmenusmenuitemstructureheader'] = 'Structuur menu-items';
$string['smartmenusmenuitemtextcount'] = 'Aantal woorden';
$string['smartmenusmenuitemtextposition'] = 'Positie van tekst op kaart';
$string['smartmenusmenuitemtextpositionbelowimage'] = 'Onder afbeelding';
$string['smartmenusmenuitemtitle'] = 'Titel';
$string['smartmenusmenuitemtypeheading'] = 'Koptekst';
$string['smartmenusmenuitemtypestatic'] = 'Statisch';
$string['smartmenusmenuitemurl'] = 'URL van menu-item';
$string['smartmenusmenulocationmenu'] = 'Menubalk';
$string['smartmenusmenulocationuser'] = 'Gebruikersmenu';
$string['smartmenusmenumode'] = 'Menumodus';
$string['smartmenusmenumoremenubehavior'] = 'Meer instellingen voor gedrag van menu';
$string['smartmenusmenunothingtodisplay'] = 'Er zijn nog geen slimme menu\'s gemaakt. Ga aan de slag door je eerste slimme menu te maken.';
$string['smartmenusmenupresentationheader'] = 'Menuweergave';
$string['smartmenusmenushowdescription'] = 'Toon beschrijving';
$string['smartmenusmenushowdescriptionabove'] = 'Boven';
$string['smartmenusmenushowdescriptionbelow'] = 'Onder';
$string['smartmenusmenushowdescriptionhelp'] = 'Hulp';
$string['smartmenusmenushowdescriptionnever'] = 'Nooit';
$string['smartmenusmenustructureheader'] = 'Menustructuur';
$string['smartmenusmenutitle'] = 'Titel';
$string['smartmenusmenutitle_help'] = 'De titel van het menu. Dit wordt gebruikt om de bovenliggende knoop van dit menu te markeren.';
$string['smartmenusmenutype'] = 'Presentatietype';
$string['smartmenusmenutypecard'] = 'Kaart';
$string['smartmenusmenutypelist'] = 'Lijst';
$string['smartmenusmodeinline'] = 'Inline';
$string['smartmenusmodesubmenu'] = 'Submenu';
$string['smartmenusnorestrict'] = 'Niet beperkt';
$string['smartmenusoperator'] = 'Operator';
$string['smartmenusrestrictbycohortsheader'] = 'Zichtbaarheid beperken op sitegroepen';
$string['smartmenusrestrictbydateheader'] = 'Zichtbaarheid beperken op datum';
$string['smartmenusrestrictbylanguageheader'] = 'Zichtbaarheid beperken op taal';
$string['smartmenusrestrictbyrolesheader'] = 'Zichtbaarheid beperken op rollen';
$string['smartmenusrolecontext'] = 'Context';
$string['smartmenussettings'] = 'Instellingen voor slimme menu\'s';
$string['speciallinksmarkupheading'] = 'Opmaak voor speciale links';
$string['staticpagestab'] = 'Statische pagina\'s';
$string['switchedroleto'] = 'Je bekijkt de cursus op dit moment met de rol: <strong>{$a->role}</strong>';
$string['tilefrontpagepositionsetting_after'] = 'Na de inhoud op de startpagina';
$string['tilefrontpagepositionsetting_before'] = 'Voor de inhoud op de startpagina';
$string['tilelinktargetsetting_newtab'] = 'Nieuw tabblad';
$string['tilelinktargetsetting_samewindow'] = 'Zelfde venster';
$string['tilelinktitlefallback'] = 'Link';
$string['timelineheading'] = 'Blok Tijdlijn';
$string['timelinetintenabled'] = 'Kleur activiteiteniconen in Tijdlijn';
$string['timelinetintenabled_desc'] = 'Met deze instelling kun je de activiteiteniconen in het blok Tijdlijn een kleur geven op basis van het doel van de activiteit. Standaard worden deze in Moodle core zwart weergegeven.';
$string['upcomingeventsheading'] = 'Blok Binnenkort';
$string['upcomingeventstintenabled'] = 'Kleur activiteiteniconen in Binnenkort';
$string['upcomingeventstintenabled_desc'] = 'Met deze instelling kun je de activiteiteniconen in het blok Binnenkort een kleur geven op basis van het doel van de activiteit. Standaard worden deze in Moodle core zwart weergegeven.';
$string['upgradenotice_2022080922'] = 'Vanaf deze versie heeft Boost Union eigen instellingen voor logo en compact logo, en worden deze bestanden uit de Moodle core instellingen niet meer gebruikt.';
$string['upgradenotice_2022080922_copied'] = 'De bestaande <strong>{$a}</strong> uit de Moodle core instellingen zijn tijdens de upgrade naar de Boost Union {$a} instelling gekopieerd. Controleer het resultaat hiervan.';
$string['upgradenotice_2022080922_logo'] = 'logo';
$string['upgradenotice_2022080922_logocompact'] = 'compact logo';
$string['upgradenotice_2022080922_notcopied'] = 'De instelling <strong>{$a}</strong> binnen Boost Union is nu leeg. Als je een {$a} binnen Boost Union wilt gebruiken kun je dit vanaf nu op een later moment in de Boost Union {$a} instelling uploaden.';
$string['usermenuheading'] = 'Gebruikersmenu';
