<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'data', language 'el', version '5.1'.
 *
 * @package     data
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['action'] = 'Ενέργεια';
$string['add'] = 'Προσθήκη καταχώρησης';
$string['addcomment'] = 'Προσθήκη σχολίου';
$string['addtemplate'] = 'Προσθήκη φόρμας/υποδείγματος';
$string['advancedsearch'] = 'Προχωρημένη αναζήτηση';
$string['allowcomments'] = 'Να επιτρέπονται τα σχόλια στις καταχωρήσεις';
$string['alttext'] = 'Εναλλακτικό κείμενο';
$string['approvalstatus'] = 'Κατάσταση έγκρισης';
$string['approve'] = 'Έγκριση';
$string['approved'] = 'Εγκρίθηκε';
$string['areacontent'] = 'Πεδία';
$string['ascending'] = 'Αύξουσα';
$string['asearchtemplate'] = 'Φόρμα προχωρημένης αναζήτησης';
$string['atmaxentry'] = 'Έχετε εισαγάγει το μέγιστο επιτρεπόμενο αριθμό καταχωρήσεων!';
$string['authorfirstname'] = 'Όνομα συγγραφέα';
$string['authorlastname'] = 'Επίθετο συγγραφέα';
$string['autogenallforms'] = 'Δημιουργία όλων των προεπιλεγμένων φορμών';
$string['autolinkurl'] = 'Αυτόματη σύνδεση στο URL';
$string['availablefromdate'] = 'Διαθέσιμο από';
$string['availabletags'] = 'Διαθέσιμες ετικέτες';
$string['availabletags_help'] = 'Οι ετικέτες είναι δεσμευτικά θέσης στη φόρμα, που θα αντικατασταθούν από δεδομένα ή άλλα στοιχεία, όπως ένα εικονίδιο επεξεργασίας, όταν γίνεται προβολή ή επεξεργασία της καταχώρησης.

Τα πεδία έχουν το μορφότυπο [[fieldname]]. Όλες οι άλλες ετικέτες έχουν το μορφότυπο ##sometag##.

Μόνο οι ετικέτες που είναι στην λίστα «Διαθέσιμες ετικέτες» μπορούν να χρησιμοποιηθούν στην τρέχουσα φόρμα.';
$string['availabletodate'] = 'Διαθέσιμο έως';
$string['availabletodatevalidation'] = 'Η «Διαθέσιμο έως» ημερομηνία δεν μπορεί να οριστεί νωρίτερα από την «Διαθέσιμο από».';
$string['bynameondate'] = 'κατά {$a->name} - {$a->date}';
$string['calendarend'] = '{$a} λήξη';
$string['calendarstart'] = '{$a} έναρξη';
$string['cancel'] = 'Άκυρο';
$string['cannotaccesspresentsother'] = 'Δε σας επιτρέπεται η πρόσβαση σε προρυθμίσεις άλλων χρηστών';
$string['cannotadd'] = 'Αδυναμία προσθήκης καταχωρήσεων!';
$string['cannotdeletepreset'] = 'Σφάλμα κατά τη διαγραφή μιας προρύθμισης!';
$string['cannotoverwritepreset'] = 'Σφάλμα κατά τη αντικατάσταση προρύθμισης!';
$string['cannotunziptopreset'] = 'Δεν είναι δυνατή η αποσυμπίεση στον κατάλογο των προρυθμίσεων';
$string['checkbox'] = 'Πλαίσιο επιλογής';
$string['chooseexportfields'] = 'Επιλέξτε τα πεδία που επιθυμείτε να εξάγετε';
$string['chooseexportformat'] = 'Επιλέξτε τον μορφότυπο στον οποίο θέλετε να εξαγάγετε';
$string['chooseorupload'] = 'Επιλογή αρχείου';
$string['closebeforeopen'] = 'Έχετε ορίσει ημερομηνία λήξης πριν από την ημερομηνία έναρξης.';
$string['columns'] = 'στήλες';
$string['comment'] = 'Σχόλιο';
$string['commentdeleted'] = 'Το σχόλιο διαγράφηκε';
$string['commentempty'] = 'Δεν γράψατε τίποτα στην περιοχή των σχολίων';
$string['comments'] = 'Σχόλια';
$string['commentsaved'] = 'Το σχόλιο αποθηκεύτηκε';
$string['commentsn'] = '{$a} σχόλιο(α)';
$string['commentsoff'] = 'Η λειτουργία σχολίων δεν είναι ενεργοποιημένη';
$string['completiondetail:entries'] = 'Κάντε καταχωρήσεις: {$a}';
$string['completionentriescount'] = 'Πλήθος καταχωρήσεων';
$string['completionentriesdesc'] = 'Ελάχιστος αριθμός απαιτούμενων καταχωρήσεων: {$a}';
$string['configenablerssfeeds'] = 'Αυτή η ρύθμιση θα ενεργοποιήσει την δυνατότητα τροφοδοσιών RSS για όλες τις βάσεις δεδομένων. Θα χρειαστείτε ακόμη να ενεργοποιήσετε τις τροφοδοσίες και χειροκίνητα στις ρυθμίσεις κάθε βάσης δεδομένων.';
$string['confirmdeletefield'] = 'Πρόκειται να διαγράψετε αυτό το πεδίο. Είστε σίγουροι;';
$string['confirmdeleterecord'] = 'Σίγουρα θέλετε να διαγραφεί αυτή η καταχώρηση;';
$string['confirmdeleterecords'] = 'Σίγουρα θέλετε να διαγραφούν αυτές οι καταχωρήσεις;';
$string['csstemplate'] = 'Υπόδειγμα/Φόρμα CSS';
$string['csvfailed'] = 'Δεν είναι δυνατή η ανάγνωση ακατέργαστων δεδομένων από το αρχείο CSV';
$string['csvfile'] = 'CSV αρχείο';
$string['csvimport'] = 'Εισαγωγή αρχείου CSV';
$string['csvimport_help'] = 'Καταχωρήσεις μπορούν να εισαχθούν μέσω ενός απλού αρχείου κειμένου με μια λίστα από ονόματα πεδίων ως πρώτη γραμμή, μετά τα δεδομένα, με μια εγγραφή ανά γραμμή.';
$string['csvwithselecteddelimiter'] = '<abbr title="Τιμές διαχωρισμένες με κόμμα">CSV</abbr>';
$string['data:addinstance'] = 'Προσθήκη νέας βάσης δεδομένων';
$string['data:approve'] = 'Έγκριση και ακύρωση έγκρισης καταχωρήσεων';
$string['data:comment'] = 'Καταγραφή σχολίων';
$string['data:exportallentries'] = 'Εξαγωγή όλων των καταχωρήσεων της βάσης δεδομένων';
$string['data:exportentry'] = 'Εξαγωγή μιας καταχώρησης της βάσης δεδομένων';
$string['data:exportownentry'] = 'Εξαγωγή της δικής σας καταχώρησης βάσης δεδομένων';
$string['data:exportuserinfo'] = 'Εξαγωγή πληροφοριών χρήστη';
$string['data:managecomments'] = 'Διαχείριση σχολίων';
$string['data:manageentries'] = 'Διαχείριση καταχωρήσεων';
$string['data:managetemplates'] = 'Διαχείριση φορμών';
$string['data:manageuserpresets'] = 'Διαχείριση όλων των προρυθμίσεων φόρμας';
$string['data:rate'] = 'Βαθμολόγηση καταχωρήσεων';
$string['data:readentry'] = 'Ανάγνωση καταχωρήσεων';
$string['data:view'] = 'Εμφάνιση δραστηριότητας βάσης δεδομένων';
$string['data:viewallratings'] = 'Εμφάνιση όλων των ανεπεξέργαστων εκτιμήσεων που δόθηκαν από άτομα';
$string['data:viewalluserpresets'] = 'Εμφάνιση προρυθμίσεων όλων των χρηστών';
$string['data:viewanyrating'] = 'Εμφάνιση συνολικών αξιολογήσεων που έλαβε οποιοσδήποτε';
$string['data:viewentry'] = 'Εμφάνιση καταχωρήσεων';
$string['data:viewrating'] = 'Εμφάνιση συνολικής αξιολόγησης που έλαβες';
$string['data:writeentry'] = 'Εγγραφή καταχωρήσεων';
$string['date'] = 'Ημερομηνία';
$string['dateentered'] = 'Η ημερομηνία καταχωρήθηκε';
$string['defaultfielddelimiter'] = '(το κόμμα είναι ο προεπιλεγμένος χαρακτήρας)';
$string['defaultfieldenclosure'] = '(το προεπιλεγμένο είναι κανένα)';
$string['defaultsortfield'] = 'Προεπιλεγμένο πεδίο ταξινόμησης';
$string['delcheck'] = 'Πλαίσιο επιλογής μαζικής διαγραφής';
$string['delete'] = 'Διαγραφή';
$string['deleteallentries'] = 'Διαγραφή όλων των καταχωρήσεων';
$string['deletecomment'] = 'Σίγουρα θέλετε να διαγράψετε αυτό το σχόλιο;';
$string['deleted'] = 'διαγράφηκε';
$string['deletefield'] = 'Διαγραφή υπάρχοντος πεδίου';
$string['deletenotenrolled'] = 'Διαγραφή καταχωρήσεων από μη εγγεγραμμένους χρήστες';
$string['deletewarning'] = 'Σίγουρα θέλετε να διαγράψετε αυτή την προρύθμιση;';
$string['descending'] = 'Φθίνουσα';
$string['directorynotapreset'] = 'Ο κατάλογος {$a->directory} δεν αποτελεί προρύθμιση: λείπουν αρχεία: {$a->missing_files}';
$string['disapprove'] = 'Αναίρεση έγκρισης';
$string['download'] = 'Λήψη';
$string['edit'] = 'Επεξεργασία';
$string['editcomment'] = 'Επεξεργασία σχολίου';
$string['editentry'] = 'Επεξεργασία καταχώρησης';
$string['editordisable'] = 'Απενεργοποίηση επεξεργαστή κειμένου';
$string['editorenable'] = 'Ενεργοποίηση επεξεργαστή κειμένου';
$string['emptyadd'] = 'Η Προσθήκη φόρμας είναι άδεια, δημιουργία της προεπιλεγμένης φόρμας...';
$string['emptyaddform'] = 'Δεν συμπληρώσατε κανένα από τα πεδία!';
$string['enabletemplateeditorcheck'] = 'Σίγουρα θέλετε να ενεργοποιήσετε τον επεξεργαστή κειμένου; Αυτό μπορεί να έχει ως αποτέλεσμα να αλλάξει το περιεχόμενο όταν η φόρμα αποθηκεύεται.';
$string['entries'] = 'Καταχωρήσεις';
$string['entrieslefttoadd'] = 'Πρέπει να προσθέσετε {$a->entriesleft} επιπλέον καταχωρήσεις(η) ώστε να ολοκληρώσετε αυτήν τη δραστηριότητα';
$string['entrieslefttoaddtoview'] = 'Πρέπει να προσθέσετε {$a->entrieslefttoview} επιπλέον καταχωρήσεις(η) πριν να μπορέσετε να δείτε τις καταχωρήσεις άλλων χρηστών.';
$string['entry'] = 'Καταχώρηση';
$string['entrysaved'] = 'Η καταχώρησή σας αποθηκεύτηκε';
$string['errormustbeteacher'] = 'Πρέπει να είστε διδάσκων για να χρησιμοποιήσετε αυτή την σελίδα!';
$string['errormustsupplyvalue'] = 'Πρέπει να εισάγετε μια τιμή εδώ.';
$string['errorpresetexists'] = 'Υπάρχει ήδη μια προρύθμιση με το επιλεγμένο όνομα';
$string['eventfieldcreated'] = 'Το πεδίο δημιουργήθηκε';
$string['eventfielddeleted'] = 'Το πεδίο διαγράφηκε';
$string['eventfieldupdated'] = 'Το πεδίο ενημερώθηκε';
$string['eventrecordcreated'] = 'Η εγγραφή δημιουργήθηκε';
$string['eventrecorddeleted'] = 'Η εγγραφή διαγράφηκε';
$string['eventrecordupdated'] = 'Η εγγραφή ενημερώθηκε';
$string['eventtemplateupdated'] = 'Η φόρμα ενημερώθηκε';
$string['eventtemplateviewed'] = 'Φόρμες που εμφανίστηκαν';
$string['example'] = 'Παράδειγμα αρθρώματος βάσης δεδομένων';
$string['excel'] = 'Excel';
$string['expired'] = 'Δυστυχώς, η δραστηριότητα αυτή έκλεισε στις {$a} και δεν είναι πλέον διαθέσιμη';
$string['export'] = 'Εξαγωγή';
$string['exportaszip'] = 'Εξαγωγή ως συμπιεσμένο αρχείο (zip)';
$string['exportaszip_help'] = 'Η λειτουργία εξαγωγής ως συμπιεσμένο αρχείο (zip) σας επιτρέπει να αποθηκεύσετε τα υποδείγματα και τα πεδία ως ένα συμπιεσμένο αρχείο προρυθμίσεων έτοιμο προς λήψη. Το (ληφθέν) zip μπορεί κατόπιν να εισαχθεί σε κάποιο άλλο μάθημα.';
$string['exportedtozip'] = 'Εξήχθη σε προσωρινό συμπιεσμένο αρχείο...';
$string['exportentries'] = 'Εξαγωγή καταχωρήσεων';
$string['exportformat'] = 'Μορφότυπος εξαγωγής';
$string['exportoptions'] = 'Επιλογές εξαγωγής';
$string['exportownentries'] = 'Εξαγωγή μόνο των καταχωρήσεών σας; ({$a->mine}/{$a->all})';
$string['exportpreset'] = 'Εξαγωγή προρύθμισης';
$string['failedpresetdelete'] = 'Σφάλμα κατά τη διαγραφή μιας προρύθμισης!';
$string['fieldadded'] = 'Το πεδίο προστέθηκε';
$string['fieldallowautolink'] = 'Να επιτρέπεται η αυτόματη σύνδεση';
$string['fielddeleted'] = 'Το πεδίο διαγράφηκε';
$string['fielddelimiter'] = 'Διαχωριστικό πεδίων';
$string['fielddescription'] = 'Περιγραφή πεδίου';
$string['fieldenclosure'] = 'Χαρακτήρας εισαγωγικών (π.χ. «1,2,3» εντός των οποίων δεν ισχύει κανένα διαχωριστικό πεδίων)';
$string['fieldheight'] = 'Ύψος';
$string['fieldheightlistview'] = 'Ύψος στην προβολή λίστας';
$string['fieldheightsingleview'] = 'Ύψος στην ατομική προβολή';
$string['fieldmappings'] = 'Αντιστοιχίσεις πεδίων';
$string['fieldmappings_help'] = 'Αυτό το μενού σας επιτρέπει να διατηρείτε τα δεδομένα από την υπάρχουσα βάση δεδομένων. Για να διατηρήσετε τα δεδομένα σε ένα πεδίο, πρέπει να το αντιστοιχίσετε σε ένα νέο πεδίο, όπου θα εμφανιστούν τα δεδομένα. Οποιοδήποτε πεδίο μπορεί επίσης να παραμείνει κενό, χωρίς να αντιγραφούν καθόλου πληροφορίες μέσα σε αυτό. Οποιοδήποτε παλιό πεδίο, που δεν αντιστοιχίζεται σε νέο, θα χαθεί και όλα τα δεδομένα του θα διαγραφούν.
Μπορείτε να αντιστοιχίσετε μόνο πεδία του ίδιου τύπου, για αυτό κάθε πτυσσόμενο μενού περιέχει διαφορετικά πεδία. Επίσης, πρέπει να προσέξετε να μην προσπαθήσετε να αντιστοιχίσετε ένα παλιό πεδίο σε περισσότερα από ένα νέο πεδίο.';
$string['fieldname'] = 'Όνομα πεδίου';
$string['fieldnametype'] = '{$a->name} ({$a->type})';
$string['fieldnotmatched'] = 'Τα παρακάτω πεδία στο αρχείο σας δε βρίσκονται στη βάση: {$a}';
$string['fieldoptions'] = 'Ρυθμίσεις (μια ανά γραμμή)';
$string['fields'] = 'Πεδία';
$string['fieldupdated'] = 'Το πεδίο ανανεώθηκε';
$string['fieldwidth'] = 'Πλάτος';
$string['fieldwidthlistview'] = 'Πλάτος στην προβολή λίστας';
$string['fieldwidthsingleview'] = 'Πλάτος στην ατομική προβολή';
$string['file'] = 'Αρχείο';
$string['fileencoding'] = 'Κωδικοποίηση';
$string['filesnotgenerated'] = 'Δεν παρήχθησαν όλα τα αρχεία: {$a}';
$string['filtername'] = 'Αυτόματη σύνδεση βάσης δεδομένων';
$string['footer'] = 'Υποσέλιδο';
$string['forcelinkname'] = 'Επιβεβλημένο όνομα για τον σύνδεσμο';
$string['foundnorecords'] = 'Δε βρέθηκαν εγγραφές (<a href="{$a->reseturl}">Επαναρχικοποίηση φίλτρων</a>)';
$string['foundrecords'] = 'Βρέθηκαν οι εγγραφές: {$a->num}/{$a->max} (<a href="{$a->reseturl}">Επαναρχικοποίηση φίλτρων</a>)';
$string['fromfile'] = 'Εισαγωγή από συμπιεσμένο αρχείο (zip)';
$string['fromfile_help'] = 'Η λειτουργία εισαγωγής από συμπιεσμένο αρχείο (zip) σας επιτρέπει να περιηγηθείτε προς και να ανεβάσετε ένα συμπιεσμένο αρχείο zip προρυθμίσεων από υποδείγματα και πεδία.';
$string['generateerror'] = 'Δεν παρήχθησαν όλα τα αρχεία!';
$string['header'] = 'Επικεφαλίδα';
$string['headeraddtemplate'] = 'Ορίζει τη διεπαφή κατά την προσθήκη ή επεξεργασία καταχωρήσεων';
$string['headerasearchtemplate'] = 'Ορίζει τη διεπαφή για τις προχωρημένες αναζητήσεις';
$string['headercsstemplate'] = 'Ορίζει τα τοπικά CSS στυλ για τις άλλες φόρμες';
$string['headerjstemplate'] = 'Ορίζει προσαρμοσμένο Javascipt για διαχείριση του τρόπου εμφάνισης στοιχείων στις φόρμες: Λίστα, Ατομική ή Προσθήκη';
$string['headerlisttemplate'] = 'Ορίζει την διεπαφή πλοήγησης για πολλαπλές καταχωρήσεις';
$string['headerrsstemplate'] = 'Ορίζει την εμφάνιση των καταχωρήσεων στις τροφοδοσίες RSS';
$string['headersingletemplate'] = 'Ορίζει την διεπαφή πλοήγησης για μια ατομική καταχώρηση';
$string['importentries'] = 'Εισαγωγή καταχωρήσεων';
$string['importpreset'] = 'Εισαγωγή μιας προρύθμισης';
$string['importsuccess'] = 'Η προρύθμιση εφαρμόστηκε με επιτυχία.';
$string['includeapproval'] = 'Συμπερίληψη κατάστασης έγκρισης';
$string['includetags'] = 'Συμπερίληψη ετικετών';
$string['includetime'] = 'Συμπερίληψη ώρας προσθήκης/τροποποίησης';
$string['includeuserdetails'] = 'Συμπερίληψη λεπτομερειών χρήστη';
$string['indicator:cognitivedepth'] = 'Βάθος κατανόησης (δραστηριότητας) Βάσης δεδομένων';
$string['indicator:cognitivedepth_help'] = 'Αυτός ο δείκτης βασίζεται στο βάθος κατανόησης που επιτεύχθηκε από τον μαθητή σε μια δραστηριότητα Βάσης δεδομένων.';
$string['indicator:cognitivedepthdef'] = 'Βάθος κατανόησης (δραστηριότητας) Βάσης δεδομένων';
$string['indicator:cognitivedepthdef_help'] = 'Ο συμμετέχων έχει φτάσει αυτό το ποσοστό αφοσίωσης στο βάθος κατανόησης που προσφέρεται από τις δραστηριότητες βάσης δεδομένων κατά τη διάρκεια αυτού του διαστήματος ανάλυσης (Επίπεδα = Καμία εμφάνιση, Εμφάνιση, Υποβολή)';
$string['indicator:cognitivedepthdef_link'] = 'Δείκτες_μαθησιακής_αναλυτικής#Βάθος_κατανόησης';
$string['indicator:socialbreadth'] = 'Κοινωνικό εύρος βάσης δεδομένων';
$string['indicator:socialbreadth_help'] = 'Αυτός ο δείκτης βασίζεται στο κοινωνικό εύρος που επιτεύχθηκε από τον μαθητή σε μια δραστηριότητα Βάσης δεδομένων.';
$string['indicator:socialbreadthdef'] = 'Κοινωνικό εύρος βάσης δεδομένων';
$string['indicator:socialbreadthdef_help'] = 'Ο συμμετέχων έχει φτάσει αυτό το ποσοστό αφοσίωσης στο κοινωνικό εύρος που προσφέρεται από τις δραστηριότητες βάσης δεδομένων κατά τη διάρκεια αυτού του διαστήματος ανάλυσης (Επίπεδα = Καμία συμμετοχή, Συμμετέχων μόνος)';
$string['indicator:socialbreadthdef_link'] = 'Δείκτες_μαθησιακής_αναλυτικής#Κοινωνικό_εύρος';
$string['insufficiententries'] = 'απαιτούνται περισσότερες καταχωρήσεις για την εμφάνιση αυτής της βάσης δεδομένων';
$string['intro'] = 'Περιγραφή';
$string['invalidaccess'] = 'Η πρόσβαση σε αυτήν τη σελίδα δεν έγινε σωστά';
$string['invalidfieldid'] = 'Το πεδίο ID είναι λανθασμένο';
$string['invalidfieldname'] = 'Παρακαλούμε επιλέξτε ένα άλλο όνομα για αυτό το πεδίο';
$string['invalidfieldtype'] = 'Το πεδίο type είναι λανθασμένο';
$string['invalidid'] = 'Λανθασμένο ID δεδομένων';
$string['invalidpreset'] = 'Το {$a} δεν είναι προρύθμιση.';
$string['invalidrecord'] = 'Λανθασμένη εγγραφή';
$string['invalidurl'] = 'Το URL που μόλις δώσατε δεν είναι έγκυρο';
$string['jstemplate'] = 'Φόρμα Javascript';
$string['latitude'] = 'Γεωγραφικό πλάτος';
$string['latlong'] = 'Γεωγραφικό πλάτος/μήκος';
$string['latlongboth'] = 'Απαιτούνται και γεωγραφικό πλάτος και γεωγραφικό μήκος.';
$string['latlongdownloadallhint'] = 'Σύνδεσμος λήψης όλων των καταχωρήσεων ως KML (Keyhole Markup Language: XML για γεωγραφικά δεδομένα)';
$string['latlongkmllabelling'] = 'Πως να χαρακτηρίζονται τα αντικείμενα στα KML αρχεία (Google Earth)';
$string['latlonglinkservicesdisplayed'] = 'Υπηρεσίες link-out (αυτόματοι εξωτερικοί γεωγραφικοί σύνδεσμοι) προς εμφάνιση.';
$string['latlongotherfields'] = 'Άλλα πεδία';
$string['list'] = 'Εμφάνιση λίστας';
$string['listtemplate'] = 'Φόρμα λίστας';
$string['listview'] = 'Προβολή λίστας';
$string['longitude'] = 'Γεωγραφικό μήκος';
$string['manageapproved'] = 'Να επιτρέπεται επεξεργασία εγκεκριμένων καταχωρήσεων';
$string['manageapproved_help'] = 'Εάν ενεργοποιηθεί, οι εγκεκριμένες καταχωρήσεις δεν θα είναι πλέον τροποποιήσιμες ή διαγράψιμες από τον χρήστη που τις πρόσθεσε. Η ρύθμιση αυτή έχει αποτέλεσμα μόνο αν είναι ενεργοποιημένη η ρύθμιση «Απαιτείται έγκριση».';
$string['mapexistingfield'] = 'Αντιστοίχιση πεδίου με {$a}';
$string['mapnewfield'] = 'Δημιουργία νέου πεδίου';
$string['mappingwarning'] = 'Όλα τα παλιά πεδία που δεν έχουν αντιστοιχηθεί σε καινούργια πεδία θα χαθούν και τα δεδομένα των πεδίων αυτών θα αφαιρεθούν.';
$string['maxentries'] = 'Μέγιστος αριθμός καταχωρήσεων';
$string['maxentries_help'] = 'Ο μέγιστος αριθμός καταχωρήσεων που ένας μαθητής επιτρέπεται να υποβάλλει σε αυτή τη δραστηριότητα (βάσης δεδομένων).';
$string['maxsize'] = 'Μέγιστο μέγεθος';
$string['menu'] = 'Μενού';
$string['menuchoose'] = 'Επιλέξτε....';
$string['missingdata'] = 'Πρέπει να οριστεί το αναγνωριστικό δεδομένων ή αντικειμένου στην κλάση πεδίου';
$string['missingfield'] = 'Προγραμματιστικό λάθος: Πρέπει να ορίσετε το πεδίο και/ή δεδομένα κατά τον ορισμό της κλάσης πεδίου.';
$string['modulename'] = 'Βάση δεδομένων';
$string['modulename_help'] = 'Το άρθρωμα δραστηριότητας βάσης δεδομένων επιτρέπει στους συμμετέχοντες να δημιουργούν, να συντηρούν και να κάνουν αναζητήσεις μέσα από μια συλλογή καταχωρήσεων (δηλ. εγγραφών). Η δομή των καταχωρήσεων ορίζεται από τον διδάσκοντα ως ένα πλήθος από πεδία. Οι τύποι των πεδίων συμπεριλαμβάνουν πλαίσια επιλογής, κουμπιά μοναδικής επιλογής, πτυσσόμενα μενού, περιοχές κειμένου, διευθύνσεις ιστού URL, εικόνες και ανεβασμένα αρχεία.

Η οπτική διάταξη των πληροφοριών σε λίστες, εμφάνιση ή επεξεργασία καταχωρήσεων βάσης δεδομένων μπορεί να ελέγχεται από φόρμες βάσεων δεδομένων. Οι δραστηριότητες βάσεων δεδομένων μπορούν να διαμοιράζονται μεταξύ μαθημάτων ως προρυθμίσεις και ένας διδάσκων μπορεί επίσης να εισάγει και να εξάγει καταχωρήσεις βάσης δεδομένων.

Αν το φίλτρο δημιουργίας αυτόματων συνδέσμων για βάσεις δεδομένων είναι ενεργοποιημένο, για κάθε καταχώρηση στην βάση δεδομένων θα δημιουργείται σύνδεσμος σε κάθε θέση όπου οι λέξεις ή οι φράσεις εμφανίζονται στο μάθημα.

Ένας διδάσκων μπορεί να επιτρέψει σχόλια στις καταχωρήσεις. Οι καταχωρήσεις μπορούν επίσης να βαθμολογούνται από διδάσκοντες ή μαθητές (αξιολόγηση από ομότιμους). Οι βαθμολογίες μπορούν να συναθροίζονται για να διαμορφώσουν έναν τελικό βαθμό, ο οποίος εγγράφεται στο βαθμολόγιο.

Οι δραστηριότητες βάσεων δεδομένων έχουν πολλές χρήσεις, όπως:

* Μια συνεργατική συλλογή από συνδέσμους ιστού, βιβλία, κριτικές βιβλίων, αναφορές σε περιοδικά κλπ.
* Για εμφάνιση φωτογραφιών, αφισών, ιστοτόπων ή ποιημάτων δημιουργημένων από μαθητές, για σχολιασμό και κριτικές από ομότιμους.';
$string['modulename_link'] = '';
$string['modulenameplural'] = 'Βάσεις δεδομένων';
$string['more'] = 'Περισσότερα';
$string['moreurl'] = 'Περισσότερα URL';
$string['movezipfailed'] = 'Αδυναμία μετακίνησης συμπιεσμένου αρχείου';
$string['multientry'] = 'Επαναλαμβανόμενη καταχώρηση';
$string['multimenu'] = 'Μενού (Πολλαπλή επιλογή)';
$string['multipletags'] = 'Βρέθηκαν πολλαπλές ετικέτες! Η φόρμα δεν αποθηκεύτηκε';
$string['newentry'] = 'Νέα καταχώρηση';
$string['newfield'] = 'Δημιουργία νέου πεδίου';
$string['newfield_help'] = 'Ένα πεδίο επιτρέπει την εισαγωγή δεδομένων. Κάθε καταχώρηση κατά τη δραστηριότητα μιας βάσης δεδομένων μπορεί να έχει πολλά πεδία, πολλών τύπων όπως ένα πεδίο ημερομηνίας, που επιτρέπει στους συμμετέχοντες να επιλέξουν μια ημέρα, μήνα και έτος από ένα πτυσσόμενο μενού, ένα πεδίο εικόνας, που επιτρέπει στους συμμετέχοντες να ανεβάσουν ένα αρχείο εικόνας, ή ένα πεδίο πλαισίου επιλογής, που επιτρέπει στους συμμετέχοντες να επιλέξουν μία ή περισσότερες επιλογές.

Κάθε πεδίο πρέπει να έχει ένα μοναδικό όνομα πεδίου. Η περιγραφή του πεδίου είναι προαιρετική.';
$string['noaccess'] = 'Δεν έχετε πρόσβαση σε αυτή τη σελίδα';
$string['nodefinedfields'] = 'Η νέα προρύθμιση δεν έχει κανένα ορισμένο πεδίο!';
$string['nofieldcontent'] = 'Αδυναμία εύρεσης περιεχομένου πεδίου';
$string['nofieldindatabase'] = 'Δεν έχουν οριστεί πεδία για αυτήν τη βάση δεδομένων';
$string['nolisttemplate'] = 'Η φόρμα λίστας δεν έχει οριστεί ακόμα';
$string['nomatch'] = 'Δεν βρέθηκαν καταχωρήσεις που να ταιριάζουν!';
$string['nomaximum'] = 'Χωρίς μέγιστο';
$string['norecords'] = 'Δεν υπάρχουν καταχωρήσεις στη βάση δεδομένων';
$string['notapproved'] = 'Καταχώρηση μη εγκεκριμένη ακόμη.';
$string['notinjectivemap'] = 'Η αντιστοίχιση δεν είναι ένα προς ένα';
$string['notopenyet'] = 'Συγγνώμη, αυτή η δραστηριότητα δεν είναι διαθέσιμη μέχρι {$a}';
$string['number'] = 'Αριθμός';
$string['numberrssarticles'] = 'Καταχωρήσεις στην τροφοδοσία RSS';
$string['numnotapproved'] = 'Εκκρεμεί';
$string['numrecords'] = '{$a} καταχωρήσεις';
$string['ods'] = '<abbr title="OpenDocument Spreadsheet (φύλλο εργασίας)">ODS</abbr>&nbsp;(OpenOffice)';
$string['openafterclose'] = 'Ορίστηκε ημερομηνία ανοίγματος μετά την ημερομηνία κλεισίματος';
$string['optionaldescription'] = 'Σύντομη περιγραφή (προαιρετικό)';
$string['optionalfilename'] = 'Όνομα αρχείου (προαιρετικό)';
$string['other'] = 'Άλλο';
$string['overrwritedesc'] = 'Αντικατάσταση της προρύθμισης αν υπάρχει ήδη';
$string['overwrite'] = 'Αντικατάσταση';
$string['overwritesettings'] = 'Αντικατάσταση τρεχουσών ρυθμίσεων';
$string['page-mod-data-x'] = 'Σελίδα αρθρώματος οποιασδήποτε δραστηριότητας βάσης δεδομένων';
$string['pagesize'] = 'Καταχωρήσεις ανά σελίδα';
$string['participants'] = 'Συμμετέχοντες';
$string['picture'] = 'Εικόνα';
$string['pluginadministration'] = 'Διαχείριση δραστηριότητας βάσης δεδομένων';
$string['pluginname'] = 'Βάση δεδομένων';
$string['portfolionotfile'] = 'Εξαγωγή σε χαρτοφυλάκιο αντί αρχείου (μόνο csv ή leap2aσ)';
$string['presetinfo'] = 'Η αποθήκευση ως προρύθμιση θα δημοσιεύσει αυτή τη φόρμα. Οι άλλοι χρήστες ίσως να μπορούν να την χρησιμοποιήσουν στις βάσεις δεδομένων τους.';
$string['presetnotselected'] = 'Δεν έχει επιλεγεί καμία προρύθμιση.';
$string['presets'] = 'Προρυθμίσεις';
$string['privacy:metadata:commentpurpose'] = 'Σχόλια σε εγγραφές βάσης δεδομένων';
$string['privacy:metadata:data_content'] = 'Αντιπροσωπεύει μία απάντηση σε ένα πεδίο στο άρθρωμα βάσης δεδομένων';
$string['privacy:metadata:data_content:content'] = 'Περιεχόμενο';
$string['privacy:metadata:data_content:content1'] = 'Επιπρόσθετο περιεχόμενο 1';
$string['privacy:metadata:data_content:content2'] = 'Επιπρόσθετο περιεχόμενο 2';
$string['privacy:metadata:data_content:content3'] = 'Επιπρόσθετο περιεχόμενο 3';
$string['privacy:metadata:data_content:content4'] = 'Επιπρόσθετο περιεχόμενο 4';
$string['privacy:metadata:data_content:fieldid'] = 'Αναγνωριστικό ορισμού πεδίου';
$string['privacy:metadata:data_records'] = 'Αντιπροσωπεύει εγγραφές στο άρθρωμα βάσης δεδομένων';
$string['privacy:metadata:data_records:approved'] = 'Κατάσταση έγκρισης';
$string['privacy:metadata:data_records:groupid'] = 'Ομάδα';
$string['privacy:metadata:data_records:timecreated'] = 'Χρόνος δημιουργίας εγγραφής';
$string['privacy:metadata:data_records:timemodified'] = 'Χρόνος τελευταίας τροποποίησης της εγγραφής';
$string['privacy:metadata:data_records:userid'] = 'Ο χρήστης που δημιούργησε την εγγραφή';
$string['privacy:metadata:datafieldnpluginsummary'] = 'Πεδία για το άρθρωμα βάσης δεδομένων';
$string['privacy:metadata:filepurpose'] = 'Αρχείο που επισυνάπτεται στην εγγραφή βάσης δεδομένων';
$string['privacy:metadata:ratingpurpose'] = 'Αξιολογήσεις σε εγγραφές βάσεων δεδομένων';
$string['privacy:metadata:tagpurpose'] = 'Ετικέτες σε εγγραφές βάσεων δεδομένων';
$string['radiobutton'] = 'Κουμπιά μοναδικής επιλογής';
$string['recordapproved'] = 'Η καταχώρηση εγκρίθηκε';
$string['recorddeleted'] = 'Η καταχώρηση διαγράφηκε';
$string['recorddisapproved'] = 'Η έγκριση της καταχώρησης ακυρώθηκε';
$string['recordsnotsaved'] = 'Δεν αποθηκεύτηκε καμία καταχώρηση. Ελέγξτε τον μορφότυπο του ανεβασμένου αρχείου.';
$string['recordssaved'] = 'οι καταχωρήσεις αποθηκεύτηκαν';
$string['removealldatatags'] = 'Διαγραφή όλων των ετικετών βάσεων δεδομένων';
$string['requireapproval'] = 'Απαιτείται έγκριση';
$string['requireapproval_help'] = 'Αν ενεργοποιηθεί, οι καταχωρήσεις απαιτούν έγκριση από ένα διδάσκοντα πριν γίνουν ορατές από όλους.';
$string['required'] = 'Απαιτείται';
$string['requiredentries'] = 'Απαιτούμενες καταχωρήσεις για ολοκλήρωση (παλαιό)';
$string['requiredentries_help'] = 'Αν οριστεί, ένα μήνυμα εμφανίζεται με τον αριθμό των καταχωρήσεων που απαιτούνται για ολοκλήρωση. Σημειώστε ότι αυτή η ρύθμιση δεν σχετίζεται με την ολοκλήρωση της δραστηριότητας. Για καταχωρήσεις που απαιτούνται για ολοκλήρωση της δραστηριότητας πρέπει να χρησιμοποιηθεί η νέα ρύθμιση «Απαιτούνται καταχωρήσεις». Για να αφαιρέσετε αυτή τη ρύθμιση εντελώς, ορίστε την σε «Καμία» και αποθηκεύστε τις αλλαγές. Παρακαλούμε, αντί αυτού, να χρησιμοποιήσετε τα πεδία «Απαιτούμενες καταχωρήσεις» στην ενότητα «Ολοκλήρωση δραστηριότητας».';
$string['requiredentriestoview'] = 'Απαιτούμενες καταχωρήσεις πριν την προβολή';
$string['requiredentriestoview_help'] = 'Ο αριθμός των καταχωρήσεων που ένας μαθητής απαιτείται να έχει υποβάλει πριν να μπορεί να δει καταχωρήσεις από άλλους μαθητές. Σημείωση: αν οι καταχωρήσεις απαιτούνται πριν την προβολή, τότε το φίλτρο αυτόματων συνδέσμων πρέπει να απενεργοποιηθεί. Αυτό ισχύει διότι το φίλτρο αυτόματων συνδέσμων δεν μπορεί να καθορίσει αν ένας χρήστης έχει υποβάλει τον απαιτούμενο αριθμό καταχωρήσεων.';
$string['requiredentrieswarning'] = 'Αυτή η ρύθμιση έχει αντικατασταθεί από μια ρύθμιση ολοκλήρωσης δραστηριότητας «Απαιτούνται καταχωρήσεις»';
$string['requiredfield'] = 'Απαιτούμενο πεδίο';
$string['resetsettings'] = 'Επαναρχικοποίηση φίλτρων';
$string['resettemplate'] = 'Επαναρχικοποίηση φόρμας';
$string['resizingimages'] = 'Τροποποίηση μεγέθους των μικρογραφιών εικόνων...';
$string['rows'] = 'γραμμές';
$string['rssglobaldisabled'] = 'Απενεργοποιήθηκε. Δείτε τις μεταβλητές ρύθμισης του ιστοτόπου.';
$string['rsstemplate'] = 'Υπόδειγμα (τροφοδοσίας) RSS';
$string['rsstitletemplate'] = 'Υπόδειγμα τίτλου (τροφοδοσίας) RSS';
$string['rsstype'] = 'Τροφοδοσία RSS για αυτή τη δραστηριότητα';
$string['save'] = 'Αποθήκευση';
$string['saveandadd'] = 'Αποθήκευση και προσθήκη και άλλου';
$string['saveandview'] = 'Αποθήκευση και προβολή';
$string['saveaspreset'] = 'Αποθήκευση ως προρύθμιση';
$string['saveaspreset_help'] = 'Η λειτουργία αποθήκευσης ως προρύθμισης δημοσιεύει τις φόρμες και τα πεδία ως μια προρύθμιση, την οποία οι άλλοι χρήστες του ιστοτόπου μπορούν κατόπιν να χρησιμοποιήσουν. (Μπορείτε να την διαγράψετε από τη λίστα των προρυθμίσεων οποτεδήποτε.)';
$string['saveaspresetmissingcapability'] = 'Ο χρήστης δεν έχει τα σωστά δικαιώματα για να αποθηκεύσει τη βάση δεδομένων ως προρύθμιση.';
$string['savedataaspreset'] = 'Αποθήκευση όλων των πεδίων και των υποδειγμάτων ως προρύθμιση';
$string['savesettings'] = 'Αποθήκευση ρυθμίσεων';
$string['savesuccess'] = 'Επιτυχής αποθήκευση. Η προρύθμισή σας θα είναι διαθέσιμη σε όλο τον ιστότοπο.';
$string['search'] = 'Αναζήτηση';
$string['search:activity'] = 'Βάση δεδομένων - πληροφορίες δραστηριότητας';
$string['search:entry'] = 'Βάση δεδομένων - καταχωρήσεις';
$string['selectedrequired'] = 'Απαιτούνται όλα τα επιλεγμένα';
$string['selectexportoptions'] = 'Ορισμός επιλογών εξαγωγής';
$string['selectfields'] = 'Επιλογή πεδίων';
$string['showall'] = 'Εμφάνιση όλων των καταχωρήσεων';
$string['single'] = 'Ατομική προβολή';
$string['singletemplate'] = 'Ατομική φόρμα';
$string['singleview'] = 'Μονή προβολή';
$string['subplugintype_datafield'] = 'Τύπος πεδίου βάσης δεδομένων';
$string['subplugintype_datafield_plural'] = 'Τύποι πεδίων βάσης δεδομένων';
$string['subplugintype_datapreset'] = 'Προρύθμιση';
$string['subplugintype_datapreset_plural'] = 'Προρυθμίσεις';
$string['tagarea_data_records'] = 'Εγγραφές δεδομένων';
$string['tags'] = 'Ετικέτες';
$string['tagsdeleted'] = 'Οι ετικέτες της βάσης δεδομένων έχουν διαγραφεί';
$string['teachersandstudents'] = '{$a->teachers} και {$a->students}';
$string['templates'] = 'Υποδείγματα';
$string['templatesaved'] = 'Η φόρμα αποθηκεύτηκε';
$string['text'] = 'Κείμενο';
$string['textarea'] = 'Περιοχή κειμένου';
$string['timeadded'] = 'Χρόνος προσθήκης';
$string['timemodified'] = 'Χρόνος τροποποίησης';
$string['type'] = 'Τύπος πεδίου';
$string['undefinedprocessactionmethod'] = 'Δεν έχει οριστεί μέθοδος ενέργειας στο Data_Preset για να χειριστεί την ενέργεια «{$a}».';
$string['unsupportedfields'] = 'Μη υποστηριζόμενα πεδία';
$string['unsupportedfieldslist'] = 'Δεν είναι δυνατή η εξαγωγή των ακόλουθων πεδίων:';
$string['updatefield'] = 'Ενημέρωση ενός υπάρχοντος πεδίου';
$string['uploadfile'] = 'Ανέβασμα αρχείου';
$string['uploadrecords'] = 'Ανέβασμα καταχωρήσεων από ένα αρχείο';
$string['uploadrecords_help'] = 'Οι καταχωρήσεις μπορούν να ανεβούν μέσω αρχείου κειμένου. Ο μορφότυπος του αρχείου πρέπει να είναι ως εξής:

* Κάθε γραμμή του αρχείου περιέχει μια εγγραφή.
* Κάθε εγγραφή είναι μια σειρά από δεδομένα διαχωρισμένα με κόμμα (ή άλλο διαχωριστικό).
* Η πρώτη εγγραφή περιέχει μια λίστα από ονόματα πεδίων που ορίζουν τον μορφότυπο του υπόλοιπου αρχείου.

Ο χαρακτήρας εισαγωγικών (π.χ. «1,2,3» όπου δεν ισχύει το διαχωριστικό πεδίων κόμμα) είναι ένας χαρακτήρας που (μπορεί να) περικλείει κάθε πεδίο σε κάθε εγγραφή. Κανονικά δεν χρειάζεται να οριστεί.';
$string['uploadrecords_link'] = '';
$string['url'] = 'Διεύθυνση URL';
$string['usedate'] = 'Συμπερίληψη στην αναζήτηση.';
$string['usepredefinedset'] = 'Χρήση σετ προρυθμίσεων';
$string['usepreset'] = 'Χρήση προεπιλογής';
$string['usestandard'] = 'Χρήση μιας προρύθμισης';
$string['usestandard_help'] = 'Για να χρησιμοποιήσετε μια προρύθμιση διαθέσιμη σε όλο τον ιστότοπο, επιλέξτε την από μια λίστα. (Αν έχετε προσθέσει μια προρύθμιση στη λίστα χρησιμοποιώντας τη λειτουργία αποθήκευσης ως προρύθμιση, τότε έχετε την επιλογή της διαγραφής του.)';
$string['viewfromdate'] = 'Μόνο για ανάγνωση από';
$string['viewtodate'] = 'Μόνο για ανάγνωση μέχρι';
$string['viewtodatevalidation'] = 'Η «Μόνο για ανάγνωση μέχρι» ημερομηνία, δεν μπορεί να οριστεί πριν από την «Μόνο για ανάγνωση από» ημερομηνία.';
$string['wrongdataid'] = 'Έχει δοθεί λάθος αναγνωριστικό δεδομένων';
