<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'grades', language 'sl', version '5.0'.
 *
 * @package     grades
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['activities'] = 'Dejavnosti';
$string['addcategory'] = 'Dodaj kategorijo';
$string['addcategoryerror'] = 'Ni možno dodati kategorije.';
$string['addexceptionerror'] = 'Prišlo je do napake ob dodajanju izjeme za userid:gradeitem';
$string['addfeedback'] = 'Dodaj pripombo';
$string['addgradeletter'] = 'Dodaj črkovno oceno';
$string['addidnumbers'] = 'Dodaj ID številke';
$string['additem'] = 'Dodaj postavko ocene';
$string['additionalfeedback'] = 'Dodatna pripomba';
$string['addoutcome'] = 'Dodaj izid';
$string['addoutcomeitem'] = 'Dodaj element izida';
$string['addscale'] = 'Dodaj lestvico';
$string['adjustedweight'] = 'Prilagojena utež';
$string['aggregateextracreditmean'] = 'Povprečje ocen (z dodatnimi kreditnimi točkami)';
$string['aggregatemax'] = 'Najvišja ocena';
$string['aggregatemean'] = 'Povprečje ocen';
$string['aggregatemedian'] = 'Mediana ocen';
$string['aggregatemin'] = 'Najnižja ocena';
$string['aggregatemode'] = 'Modus ocen';
$string['aggregatenotonlygraded'] = 'Vključi ocene brez vrednosti';
$string['aggregateonlygraded'] = 'Združi samo ocene z vrednostjo';
$string['aggregateonlygraded_help'] = 'Ocena brez vrednosti je ocena, ki ni vpisana v redovalnico. Pojavi se lahko po oddaji naloge, ki še ni bila ocenjena, ali pa po kvizu, pri katerem ni bil opravljen še noben poskus.

 Ta nastavitev določa, ali ocene, ki nimajo določene vrednosti, ne bodo vključene v združevanje, ali pa bodo obravnavane kot najnižje ocene, na primer 0 za nalogo, ki se ocenjuje z ocenami od 0 do 100.';
$string['aggregateoutcomes'] = 'V združevanje vključi izide';
$string['aggregateoutcomes_help'] = 'Vključevanje izidov v združevanje morda ne vodi k želeni skupni oceni, zato imate možnost, da jih izključite.';
$string['aggregatesonly'] = 'Samo združene ocene';
$string['aggregatesubcatsupgradedgrades'] = 'Opomba: Nastavitev združevanja "Združi z vključevanjem podkategorij" je bila odstranjena pri nadgradnji strani. Ker ste "Združi z vključevanjem podkategorij" v tem predmetu uporabljali, vam svetujemo, da v redovalnici pregledate to spremembo.';
$string['aggregatesum'] = 'Seštevek ocen';
$string['aggregateweightedmean'] = 'Uteženo povprečje ocen';
$string['aggregateweightedmean2'] = 'Enostavno uteženo povprečje ocen';
$string['aggregation'] = 'Združevanje';
$string['aggregation_help'] = 'Združevanje določa, kako so ocene v določeni kategoriji kombinirane, kot na primer,

* Povprečje ocen - Vsota vseh ocen se deli s skupnim številom ocen
* Mediana ocen - Sredina, če ocene postavimo po vrsti glede na njihovo vrednost
* Najnižja ocena
* Najvišja ocena
* Modus ocen - Ocena, ki se pojavi najpogosteje
* Seštevek ocen - Vsota vseh vrednosti ocen glede na njihovo težo';
$string['aggregation_link'] = 'ocena/združevanje';
$string['aggregationcoef'] = 'Koeficient združevanja';
$string['aggregationcoefextra'] = 'Dodatne kreditne točke';
$string['aggregationcoefextra_help'] = 'Če je združevanje »seštevek ocen« ali »navadno uteženo povprečje« in je dodatna kreditna točka označena, potem najvišja ocena elementa ni dodana med najvišje ocene kategorije. To bo imelo za posledico možnost doseganja najvišje ocene v kategoriji brez najvišje ocene v vseh ocenjenih elementih. Če je administrator strani omogočil ocene, višje od najvišje, se lahko zgodi, da bo končna ocena višja od najvišje.

Če je združevanje »povprečje ocen (z dodatnimi krediti)« in je dodatni kredit nastavljen na vrednost večjo od nič, je dodatni kredit faktor, s katerim se ocena pomnoži, preden se doda v skupno oceno z izračunom povprečja.';
$string['aggregationcoefextra_link'] = 'ocena/združevanje';
$string['aggregationcoefextrasum'] = 'Dodatne kreditne točke';
$string['aggregationcoefextrasum_help'] = 'Če je označeno potrditveno polje za dodatne kreditne točke, najvišja ocena elementa ni dodana najvišji oceni kategorije, kar pomeni, da je mogoče doseči najvišjo oceno (ali oceno, višjo od te, če to omogoči administrator) v kategoriji brez vključene najvišje ocene v vseh elementih ocen.';
$string['aggregationcoefextrasum_link'] = 'ocena/združevanje';
$string['aggregationcoefextrasumabbr'] = '+';
$string['aggregationcoefextraweight'] = 'Utež dodatne kreditne točke';
$string['aggregationcoefextraweight_help'] = 'Če je utež dodatne kredite točke večja od nič se ocena obnaša kot dodatni kredit med združevanjem. Številka je faktor, s katerim se oceno pomnoži, preden se jo sešteje z vsoto za izračun povprečja.';
$string['aggregationcoefextraweight_link'] = 'ocena/združevanje';
$string['aggregationcoefweight'] = 'Utež elementa';
$string['aggregationcoefweight_help'] = 'Utež elementa se uporabi pri združevanju kategorij in vpliva na pomen elementa, ki se ga primerja z drugimi elementi ocene v isti kategoriji.';
$string['aggregationcoefweight_link'] = 'ocena/združevanje';
$string['aggregationhintdropped'] = '( Izpuščeno )';
$string['aggregationhintexcluded'] = '( Izključeno )';
$string['aggregationhintextra'] = '( Dodatne kredinte točke )';
$string['aggregationhintnovalue'] = '( Prazno )';
$string['aggregationofa'] = 'Združevanje od {$a}';
$string['aggregationposition'] = 'Položaj združevanja';
$string['aggregationposition_help'] = 'Ta nastavitev določa, ali se kategorija in stolpci z vsoto predmetov prikazujejo na začetku ali na koncu redovalnega poročila.';
$string['aggregationsvisible'] = 'Združevalni tipi na voljo';
$string['aggregationsvisiblehelp'] = 'Izberite vse združevalne tipe, ki morajo biti na voljo. Držite Ctrl tipko, da izberete več predmetov.';
$string['allgrades'] = 'Vse ocene po kategorijah';
$string['allstudents'] = 'Vsi udeleženci';
$string['allusers'] = 'Vsi uporabniki';
$string['autosort'] = 'Samodejno sortiranje';
$string['availableidnumbers'] = 'ID številke na voljo';
$string['average'] = 'Povprečje';
$string['averagesdecimalpoints'] = 'Decimalke v stolpcih povprečij';
$string['averagesdecimalpoints_help'] = 'Ta nastavitev določa število decimalnih mest za prikaz pri vsakem povprečju in ali bo uporabljena skupna nastavitev za vsa decimalna mesta v kategoriji ali pri elementu ocene (možnost Prevzemi).';
$string['averagesdisplaytype'] = 'Vrsta prikaza stolpcev povprečij';
$string['averagesdisplaytype_help'] = 'Ta nastavitev določa, ali se bo povprečje (srednja vrednost) prikazala kot prave ocene, odstotki ali črke in ali je vrsta prikaza uporabljena za kategorijo ali za element ocene (možnost Prevzemi).';
$string['backupwithoutgradebook'] = 'Varnostna kopija ne vsebuje konfiguracije redovalnice';
$string['badgrade'] = 'Podana ocena je neveljavna';
$string['badlyformattedscale'] = 'Prosimo, vnesite z vejicami ločen seznam vrednosti (vsaj dve obvezni vrednosti).';
$string['baduser'] = 'Podan uporabnik je neveljaven';
$string['bonuspoints'] = 'Dodatne točke';
$string['bulkcheckboxes'] = 'Množična potrditvena polja';
$string['calculatedgrade'] = 'Izračunana ocena';
$string['calculation'] = 'Izračun';
$string['calculation_help'] = 'Izračun ocene je formula, ki se uporablja za določanje ocene. Formula naj se začne z enačajem (=), vključuje lahko običajne matematične operatorje, kot je max, min in sum. Če želite, lahko druge elemente ocene vključite v izračun z vpisom ID številke v dvojnih oglatih oklepajih.';
$string['calculation_link'] = 'grade/calculation';
$string['calculationadd'] = 'Dodaj izračun';
$string['calculationedit'] = 'Uredi izračun';
$string['calculationsaved'] = 'Izračun je shranjen';
$string['calculationview'] = 'Ogled izračuna';
$string['cannotaccessgroup'] = 'Dostop do ocen izbrane skupine ni mogoč.';
$string['categories'] = 'Kategorije';
$string['category'] = 'Kategorija';
$string['categoryedit'] = 'Uredi kategorijo';
$string['categoryname'] = 'Ime kategorije';
$string['categorytotal'] = 'Seštevek kategorije';
$string['categorytotalfull'] = 'skupaj {$a->category}';
$string['categorytotalname'] = 'Skupno ime kategorije';
$string['changedefaults'] = 'Spremeni privzete vrednosti';
$string['changereportdefaults'] = 'Spremeni privzete vrednosti poročila';
$string['chooseaction'] = 'Izberi dejanje ...';
$string['choosecategory'] = 'Izberi kategorijo';
$string['collapsecriterion'] = 'Skrči kriterij';
$string['compact'] = 'Kompaktno';
$string['componentcontrolsvisibility'] = 'Če je ta element ocene skrit, se z njim lahko upravlja v nastavitvah dejavnosti.';
$string['contract'] = 'Skrči kategorijo';
$string['contributiontocoursetotal'] = 'Prispevek k seštevku predmeta';
$string['courseavg'] = 'Povprečje predmeta';
$string['coursegradecategory'] = 'Kategorija ocen predmeta';
$string['coursegradedisplaytype'] = 'Vrsta prikaza ocen predmeta';
$string['coursegradedisplayupdated'] = 'Vrsta prikaza ocen predmeta je bila posodobljena.';
$string['coursegradesettings'] = 'Nastavitve ocene predmeta';
$string['coursename'] = 'Ime predmeta';
$string['coursescales'] = 'Lestvice predmeta';
$string['coursesettings'] = 'Nastavitve predmeta';
$string['coursesettingsexplanation'] = 'Nastavitve predmeta določajo, kako se redovalnica prikaže za vse udeležence predmeta.';
$string['coursesiamtaking'] = 'Predmeti, ki jih obiskujem';
$string['coursesiamteaching'] = 'Predmeti, ki jih poučujem';
$string['coursetotal'] = 'Seštevek predmeta';
$string['createcategory'] = 'Ustvari kategorijo';
$string['createcategoryerror'] = 'Nove kategorije ni bilo mogoče ustvariti';
$string['creatinggradebooksettings'] = 'Ustvarjanje nastavitev redovalnice';
$string['csv'] = 'CSV';
$string['currentparentaggregation'] = 'Trenutno nadrejeno združevanje';
$string['curveto'] = 'Krivulja do';
$string['decimalpoints'] = 'Število decimalnih mest';
$string['decimalpoints_help'] = 'Ta nastavitev določa število decimalnih mest za prikaz pri vsaki oceni. Nima vpliva na izračune ocen, ki se izvajajo z natančnostjo na 5 decimalnih mest.';
$string['default'] = 'Privzeto';
$string['defaultprev'] = 'Privzeto ({$a})';
$string['deletecategory'] = 'Izbriši kategorijo';
$string['disablegradehistory'] = 'Onemogoči zgodovino ocen';
$string['disablegradehistory_help'] = 'Onemogoči beleženje zgodovine sprememb pri ocenah. To lahko malenkostno pohitri strežnik in prihrani prostor v podatkovni zbirki.';
$string['displaylettergrade'] = 'Prikaži črkovne ocene';
$string['displaypercent'] = 'Prikaži odstotke';
$string['displaypoints'] = 'Prikaži točke';
$string['displayweighted'] = 'Prikaži utežene ocene';
$string['droplow'] = 'Izpusti najnižje';
$string['droplow_help'] = 'Ta nastavitev omogoča možnost izpusta izbranega števila najnižjih ocen iz združevanja.';
$string['droplowestvalue'] = 'Nastavi spust najnižje vrednosti ocene';
$string['droplowestvalues'] = 'Izpusti {$a} najnižjih vrednosti';
$string['dropped'] = 'Izpuščeno';
$string['dropxlowest'] = 'Izpusti X najnižjih';
$string['dropxlowestwarning'] = 'Opomba: Če uporabite spust x najnižjih, ocenjevanje predvideva, da imajo vso elementi v kategoriji isto vrednost točk. Če se vrednosti točk razlikujejo, bodo rezultati nepredvidljivi';
$string['duplicatedgradeitem'] = '{$a} (kopija)';
$string['duplicatescale'] = 'Podvoji lestvico';
$string['edit'] = 'Uredi';
$string['editcalculation'] = 'Uredi izračun';
$string['editcalculationverbose'] = 'Uredi izračun za
{$a->category}
{$a->itemmodule}
{$a->itemname}';
$string['editfeedback'] = 'Uredi pripombe';
$string['editgrade'] = 'Uredi oceno';
$string['editgradeletters'] = 'Uredi črkovne ocene';
$string['editoutcome'] = 'Uredi rezultat';
$string['editoutcomes'] = 'Uredi izide';
$string['editscale'] = 'Uredi lestvico';
$string['edittree'] = 'Nastavitve';
$string['editverbose'] = 'Uredi {$a->category}
{$a->itemmodule}
{$a->itemname}';
$string['enableoutcomes'] = 'Omogoči izide';
$string['enableoutcomes_help'] = 'Če so omogočeni, so elementi ocene lahko ocenjeni z uporabo ene ali več lestvic, ki so povezane z izidi.';
$string['encoding'] = 'Kodiranje';
$string['encoding_help'] = 'Izberite znakovni nabor, ki bo uporabljen za podatke (standardni nabor je UTF-8). Če je po pomoti izbran napačen nabor, bo to vidno v predogledu podatkov za uvoz.';
$string['errorcalculationbroken'] = 'Napaka v izračunu elementa ocene {$a}';
$string['errorcalculationnoequal'] = 'Formula se mora začeti z znakom je enako (=1+2)';
$string['errorcalculationunknown'] = 'Neveljavna formula';
$string['errorgradevaluenonnumeric'] = 'Prejeta neštevilčna vrednost za nizko ali visoko oceno za';
$string['errornocalculationallowed'] = 'Izračuni za to postavko niso dovoljeni';
$string['errornocategorisedid'] = 'Ni moč pridobiti nekategoriziranega ID!';
$string['errornocourse'] = 'Ni moč pridobiti informacij o predmetu';
$string['errorreprintheadersnonnumeric'] = 'Prejeta neštevilčna vrednost za ponovni prikaz glave';
$string['errorsavegrade'] = 'Oprostite, ocene ni bilo mogoče shraniti.';
$string['errorsettinggrade'] = 'Napaka pri shranjevanju "{$a->itemname}" ocene za uporabniški ID {$a->userid}';
$string['errorupdatinggradecategoryaggregateonlygraded'] = 'Napaka pri posodabljanju "Združi zgolj ocene, ki niso prazne" nastavitve ocene kategorije ID {$a->id}';
$string['errorupdatinggradecategoryaggregateoutcomes'] = 'Napaka pri posodabljanju "Vključi izide v združevanje" nastavitve ocene kategorije ID {$a->id}';
$string['errorupdatinggradecategoryaggregation'] = 'Napaka pri posodabljanju vrste združevanja ocene kategorije ID {$a->id}';
$string['errorupdatinggradeitemaggregationcoef'] = 'Napaka pri posodabljanju koeficienta združevanja (za težo ali dodatne kreditne točke) pri elementu ocenjevanja ID {$a->id}';
$string['eventgradedeleted'] = 'Ocena izbrisana';
$string['eventgradeitemcreated'] = 'Element ocene ustvarjen';
$string['eventgradeitemdeleted'] = 'Element ocene izbrisan';
$string['eventgradeitemupdated'] = 'Element ocene posodobljen';
$string['eventgradelettercreated'] = 'Črkovna ocena ustvarjena';
$string['eventgradeletterdeleted'] = 'Črkovna ocena izbrisana';
$string['eventgradeletterupdated'] = 'Črkovna ocena posodobljena';
$string['eventgradeviewed'] = 'Ocene so bile ogledane v redovalnici';
$string['eventscalecreated'] = 'Lestvica ustvarjena';
$string['eventscaledeleted'] = 'Lestvica izbrisana';
$string['eventscaleupdated'] = 'Lestvica posodobljena';
$string['eventusergraded'] = 'Uporabnik ocenjen';
$string['excluded'] = 'Izključeno';
$string['excluded_help'] = 'Če je označena ta možnost, ocena ne bo vključena v združevanje.';
$string['expand'] = 'Razširi kategorijo';
$string['expandcriterion'] = 'Razširi kriterij';
$string['export'] = 'Izvozi';
$string['exportalloutcomes'] = 'Izvozi vse izide';
$string['exportfeedback'] = 'V izvoz vključi pripombe';
$string['exportfeedback_desc'] = 'To se lahko povozi pri izvozu.';
$string['exportformatoptions'] = 'Možnosti formata izvoza';
$string['exportonlyactive'] = 'Izključi začasno onemogočene uporabnike';
$string['exportonlyactive_help'] = 'Upoštevaj le tiste uporabnike, ki so vpisani in aktivirani in niso onemogočeni';
$string['exportplugins'] = 'Vtičniki za izvoz';
$string['exportsettings'] = 'Nastavitve izvoza';
$string['exportto'] = 'Izvozi v';
$string['externalurl'] = 'Zunanji URL';
$string['externalurl_desc'] = 'V primeru, da se uporablja zunanja redovalnica, je potrebno tukaj navesti URL.';
$string['extracreditvalue'] = 'Vrednost dodatniih kreditnih točk za {$a}';
$string['extracreditwarning'] = 'Opomba: Nastavitev vseh postavk kategorije za dodatne kreditne točke jih bo učinkovito odstranila iz izračuna ocen. Skupnega števila točk namreč ne bo';
$string['feedback'] = 'Pripombe';
$string['feedback_help'] = 'V okvirčku lahko komentirate oceno.';
$string['feedbackadd'] = 'Dodaj pripombo';
$string['feedbackedit'] = 'Uredi pripombe';
$string['feedbackfiles'] = 'Datoteke s pripombami';
$string['feedbackforgradeitems'] = 'Pripomba za {$a}';
$string['feedbackhistoryfiles'] = 'Zgodovina datotek za pripombo';
$string['feedbacks'] = 'Pripombe';
$string['feedbacksaved'] = 'Pripomba shranjena';
$string['feedbackview'] = 'Ogled pripomb';
$string['finalgrade'] = 'Končna ocena';
$string['finalgrade_help'] = 'Če je povoženo potrditveno polje označeno lahko dodate ali pripnete oceno.';
$string['fixedstudents'] = 'Statični stolpec udeležencev';
$string['fixedstudents_help'] = 'Dovoljuje vodoravni pomik ocen, ne da bi pri tem izgubili pogled na stolpec udeležencev, ki je postavljen statično.';
$string['forceimport'] = 'Vsiljen uvoz';
$string['forceimport_help'] = 'Vsili uvoz ocen, četudi so bile ocene po izvozu uvožene datoteke posodobljene';
$string['forceoff'] = 'Vsili: Izključeno';
$string['forceon'] = 'Vsili: Vključeno';
$string['forelementtypes'] = 'za izbrane {$a}';
$string['forstudents'] = 'Za udeležence';
$string['full'] = 'Polno';
$string['fullmode'] = 'Prikaži ocene in skupne vsote';
$string['generalsettings'] = 'Splošne nastavitve';
$string['grade_help'] = 'Ocena za nagraditi udeleženca za njegovo delo.';
$string['gradeadministration'] = 'Skrbništvo ocen';
$string['gradealreadyupdated'] = '{$a} ocen ni bilo uvoženih, ker so ocene v uvoženi datoteki starejše kot so v poročilu ocenjevalca. Če želite kljub temu nadaljevati z uvozom ocen, uporabite možnost vsiljenega uvoza.';
$string['gradeanalysis'] = 'Analiza ocen';
$string['gradebook'] = 'Redovalnica';
$string['gradebookcalculationsfixbutton'] = 'Sprejmi spremembe ocene in popravi računske napake';
$string['gradebookcalculationsuptodate'] = 'Izračuni v redovalnici so posodobljeni. Za ogled sprememb boste morda morali ponovno naložiti to stran.';
$string['gradebookcalculationswarning'] = 'Opomba: Pri izračunu ocen, prikazanih v redovalnici, so bile zaznane določene napake. Če se vaš predmet še ni začel ali je v teku, je priporočljivo, da se napake popravi s klikom na spodnji gumb, čeprav bo to povzročilo spremembe pri nekaterih ocenah. Če se je vaš predmet že zaključil in so bile ocene poslane, ocen verjetno ne želite popravljati.

Novejša različica je {$ a-> CurrentVersion}; vi uporabljate različico redovalnice {a- $> gradebookversion}. Seznam sprememb si lahko ogledate v <a href="{$a-> url} "> Spremembe v izračunih redovalnice</a>.';
$string['gradebookhiddenerror'] = 'Redovalnica je trenutno nastavljena tako, da vse skrije pred udeleženci.';
$string['gradebookhistories'] = 'Zgodovina ocen';
$string['gradebooksetup'] = 'Nastavitev redovalnice';
$string['gradeboundary'] = 'Omejitev črkovnih ocen';
$string['gradeboundary_help'] = 'Ta nastavitev določa najnižji odstotek, nad katerim bo dodeljena črkovna ocena.';
$string['gradecategories'] = 'Kategorije ocen';
$string['gradecategory'] = 'Kategorija ocen';
$string['gradecategoryonmodform'] = 'Kategorija ocen';
$string['gradecategoryonmodform_help'] = 'Ta nastavitev določa kategorijo, v katero se umestijo ocene dejavnosti v redovalnici.';
$string['gradecategorysettings'] = 'Nastavitve kategorije ocen';
$string['gradedisplay'] = 'Prikaz ocen';
$string['gradedisplaytype'] = 'Vrsta prikaza ocen';
$string['gradedisplaytype_help'] = 'Ta nastavitev določa način prikaza ocen v poročilih ocenjevalca in uporabnikov.

* Prave - dejanske ocene
* Odstotek
* Črka - Črke ali besede lahko uporabite za cel niz ocen';
$string['gradedon'] = 'Ocenjeno: {$a}';
$string['gradeexport'] = 'Izvoz ocen';
$string['gradeexportcolumntype'] = '{$a->name} ({$a->extra})';
$string['gradeexportcustomprofilefields'] = 'Polja profila po meri za izvoz ocen';
$string['gradeexportcustomprofilefields_desc'] = 'Pri izvozu ocen vključi ta polja profila po meri in jih loči z vejico.';
$string['gradeexportdecimalpoints'] = 'Decimalna mesta ocen pri izvozu';
$string['gradeexportdecimalpoints_desc'] = 'Število decimalnih mest za prikaz med izvozom. To je mogoče povoziti med izvozom.';
$string['gradeexportdisplaytype'] = 'Vrsta prikaza ocen pri izvozu';
$string['gradeexportdisplaytype_desc'] = 'Med izvozom so lahko ocene prikazane kot prave ocene, odstotki (v razmerju z najnižjo in najvišjo oceno) ali črke (A, B, C itd.). To je mogoče povoziti med izvozom.';
$string['gradeexportdisplaytypes'] = 'Vrste prikaza izvoza ocen';
$string['gradeexportuserprofilefields'] = 'Polja uporabniškega profila pri izvozu ocen';
$string['gradeexportuserprofilefields_desc'] = 'Pri izvozu ocen vključi ta polja uporabniškega profila in jih loči z vejico.';
$string['gradeforstudent'] = '{$a->student}<br />{$a->item}{$a->feedback}';
$string['gradegrademinmax'] = 'Začetne najnižje in najvišje ocene';
$string['gradehelp'] = 'Pomoč pri ocenah';
$string['gradehistorylifetime'] = 'Življenjska doba zgodovine ocen';
$string['gradehistorylifetime_help'] = 'Tu lahko določite, kako dolgo želite obdržati zgodovino sprememb pri ocenah. Priporočeno je, da je ta čas čim daljši. Če imate težave z zmogljivostjo ali imate omejen prostor v podatkovni zbirki, nastavite nižjo vrednost.';
$string['gradeimport'] = 'Uvoz ocen';
$string['gradeimportfailed'] = 'Uvoz ocen ni uspel. Podrobnosti:';
$string['gradeitem'] = 'Element ocene';
$string['gradeitemaddusers'] = 'Izključi iz ocenjevanja';
$string['gradeitemislocked'] = 'Ta dejavnost je v redovalnici zaklenjena. Spremembe, ki se določijo ocenam v tej dejavnosti, se ne bodo preslikale v redovalnico dokler je dejavnost zaklenjena.';
$string['gradeitemlocked'] = 'Ocenjevanje je zaklenjeno';
$string['gradeitemmembersselected'] = 'Izključeno iz ocenjevanja';
$string['gradeitemminmax'] = 'Najnižje in najvišje ocene, kot so podane v nastavitvah elementa ocene';
$string['gradeitemnonmembers'] = 'Vključeno v ocenjevanje';
$string['gradeitemremovemembers'] = 'Vključi v ocenjevanje';
$string['gradeitems'] = 'Elementi ocene';
$string['gradeitemsettings'] = 'Nastavitve elementov ocene';
$string['gradeitemsinc'] = 'Elementi ocene za vključitev';
$string['gradeletter'] = 'Črkovna ocena';
$string['gradeletter_help'] = 'Črkovne ocene, so A, B, C ... ali besede, kot npr. Odlično, Dobro, Zadostno ...';
$string['gradeletternote'] = 'Za izbris črkovne ocene izbrišite poljubno<br /> izmed treh področij za izbrano črko in kliknite pošlji.';
$string['gradeletteroverridden'] = 'Privzete črkovne ocene so trenutno povožene.';
$string['gradeletters'] = 'Črkovne ocene';
$string['gradelocked'] = 'Ocena je zaklenjena';
$string['gradelong'] = '{$a->grade} / {$a->max}';
$string['grademax'] = 'Najvišja ocena';
$string['grademax_help'] = 'Ta nastavitev določa najvišjo oceno, ko za ocenjevanje uporabljate vrednost. Najvišja ocena za dejavnost se določi v nastavitvah na strani dejavnosti.';
$string['grademin'] = 'Najnižja ocena';
$string['grademin_help'] = 'Ta nastavitev določa najnižjo oceno, ko za ocenjevanje uporabljate vrednost.';
$string['gradenotificationmessage'] = 'Imate novo pripombo na vaše delo za "{$a}"';
$string['gradenotificationsubject'] = 'Bili ste ocenjeni';
$string['gradeoutcomeitem'] = 'Element izida ocene';
$string['gradeoutcomes'] = 'Izidi';
$string['gradeoutcomescourses'] = 'Izidi predmeta';
$string['gradepass'] = 'Ocena za uspešno opravljanje';
$string['gradepass_help'] = 'Ta nastavitev določa najnižjo oceno, ki jo morajo udeleženci doseči ali preseči za uspešno opravljanje določenega elementa. Ta vrednost se uporablja za zaključevanje dejavnosti ali predmeta. V redovalnici se pozitivne ocene obarvajo zeleno, negativne pa rdeče.';
$string['gradepassgreaterthangrade'] = 'Ocena potrebna za uspešno opravljanje ne more biti večja od največje možne ocene {$a}';
$string['gradepointdefault'] = 'Privzeto točkovanje ocenjevanja';
$string['gradepointdefault_help'] = 'Nastavitev določa privzeto vrednost ocene tipa točke, ki je na voljo v elementu ocene.';
$string['gradepointdefault_validateerror'] = 'Nastavitev je potrebno nastaviti med 1 in najvišjim točkovanjem ocenjevanja.';
$string['gradepointmax'] = 'Najvišja ocena pri točkovanju';
$string['gradepointmax_help'] = 'Nastavitev določa privzeto vrednost za najvišjo vrednost točkovanja ocenjevanja pri tej dejavnosti.';
$string['gradepointmax_validateerror'] = 'Nastavitev je potrebno nastaviti na celo številko med 1 in 10000.';
$string['gradepreferences'] = 'Nastavitve ocen';
$string['gradepreferenceshelp'] = 'Pomoč pri nastavitvi ocen';
$string['gradepublishing'] = 'Omogoči objavljanje';
$string['gradepublishing_help'] = 'Omogoči objavo izvozov in uvozov: Izvožene ocene so lahko dostopne preko URL-ja brez prijave v Moodle. Če je ta možnost omogočena, lahko administratorji in uporabniki z dovoljenjem za objavo ocen (pri administratorjih je ta možnost že privzeta, uporabniki pa dovoljenje dobijo, če so v vlogi vodje) ocene izvozijo in spreminjajo nastavitve za redovalnice posameznih predmetov.';
$string['gradepublishinglink'] = 'Naloži: {$a}';
$string['gradereport'] = 'Poročilo z ocenami';
$string['graderreport'] = 'Poročilo ocenjevalca';
$string['grades'] = 'Ocene';
$string['gradesforuser'] = 'Ocene za {$a->user}';
$string['gradesmoduledeletionpendingwarning'] = 'Opzorilo: Brisanje aktivnosti poteka! Nekatere ocene bodo odstranjene.';
$string['gradesmoduledeletionprefix'] = '[Poteka brisanje]';
$string['gradesonly'] = 'Prikaži samo ocene';
$string['gradessettings'] = 'Nastavitve ocene';
$string['gradetype'] = 'Tip ocene';
$string['gradetype_help'] = 'Obstajajo 4 tipi ocen:
\\* Brez - ocenjevanje ni možno
* Vrednost - numerična vrednost z določeno najvišjo in najnižjo oceno
*, Lestvica - omogoča nastavitev lestvice
* Besedilo - samo pripomba

 Samo ocene z vrednostjo ali lestvico je možno združevati. Tip ocene za element ocene, ki temelji na dejavnosti, se določi na strani posamezne dejavnosti.';
$string['gradevaluetoobig'] = 'Ena izmed vrednosti ocen je večja od največje dovoljene ocene v {$a}';
$string['gradeview'] = 'Pokaži oceno';
$string['gradewasmodifiedduringediting'] = 'Vnešena ocena za {$a->itemname} za {$a->username} se ni upoštevala, ker jo je naknadno nekdo spremenil.';
$string['gradeweighthelp'] = 'Pomoč pri uteženih ocenah';
$string['gradingmodulename'] = 'Ocenjevanje ({$a})';
$string['groupavg'] = 'Povprečje skupine';
$string['hidden'] = 'Skrito';
$string['hidden_help'] = 'Če je označeno, so ocene skrite pred udeleženci. Lahko izberete skrito do datuma, če želite ocene prikazati po tistem, ko je ocenjevanje končano.';
$string['hiddenasdate'] = 'Prikaži datum oddaje za skrite ocene';
$string['hiddenasdate_help'] = 'Če uporabnik ne more videti skritih ocen, pokaži datum oddaje namesto\'-\'.';
$string['hiddenuntil'] = 'Skrito do';
$string['hiddenuntildate'] = 'Skrito do: {$a}';
$string['hideadvanced'] = 'Skrij dodatne možnosti';
$string['hideaverages'] = 'Skrij povprečja';
$string['hidecalculations'] = 'Skrij izračune';
$string['hidecategory'] = 'Skrito';
$string['hideeyecons'] = 'Skrij ikono prikaži/skrij';
$string['hidefeedback'] = 'Skrij pripombe';
$string['hideforcedsettings'] = 'Skrij vsiljene nastavitve';
$string['hideforcedsettings_help'] = 'Ne prikaži vsiljenih nastavitev v ocenjevalnem uporabniškem vmesniku.';
$string['hidegroups'] = 'Skrij skupine';
$string['hidelocks'] = 'Skrij zaklenjeno';
$string['hidenooutcomes'] = 'Prikaži izide';
$string['hidequickfeedback'] = 'Skrij hitre pripombe';
$string['hideranges'] = 'Skrij razpone';
$string['hidetotalifhiddenitems'] = 'Skrij skupne ocene, če vsebujejo skrite elemente';
$string['hidetotalifhiddenitems_help'] = 'Ta nastavitev določa, ali so končne ocene, ki vsebujejo skrite ocene, prikazane udeležencem ali pa so nadomeščene z vezajem (-). Če so prikazane, je lahko skupni izračun bodisi brez bodisi s skritimi ocenami.

Če so skrite ocene izključene, bo skupna ocena drugačna od tiste, ki jo učitelj vidi v poročilu ocen, saj učitelj vedno vidi skupne ocene, izračunane na podlagi vseh elementov, skritih ali prikazanih. Če so vključene skrite ocene, obstaja možnost, da lahko udeleženci izračunajo skrite ocene.';
$string['hidetotalshowexhiddenitems'] = 'Prikaži skupne ocene brez skritih ocen';
$string['hidetotalshowinchiddenitems'] = 'Prikaži skupne ocene s skritimi ocenami';
$string['hideverbose'] = 'Skrij {$a->category}
{$a->itemmodule}
{$a->itemname}';
$string['highgradeascending'] = 'Razvrsti po visokih ocenah naraščajoče';
$string['highgradedescending'] = 'Razvrsti po visokih ocenah padajoče';
$string['highgradeletter'] = 'Visoko';
$string['identifier'] = 'Identificiraj uporabnika po';
$string['idnumbers'] = 'ID številke';
$string['ignore'] = 'Prezri';
$string['import'] = 'Uvozi';
$string['importcsv'] = 'Uvozi CSV';
$string['importcsv_help'] = 'Ocene se lahko uvozijo preko CSV datoteke naslednjega formata:

* vsaka vrstica datoteke vsebuje en zapis,
* vsak zapis je zaporedje podatkov ločenih z vejico ali drugim ločilom,
* prvi zapis vsebuje seznam imen polj, ki opredelijo obliko preostanka datoteke.
* zahtevano je polje, ki vsebuje identifikacijski podatek uporabnika - ime, ID številko ali e-poštni naslov.

Datoteko pravilnega formata lahko dobimo tako, da najprej izvozimo nekaj ocen. Datoteko lahko nato urejate in shranite kot datoteko tipa CSV.';
$string['importcsv_link'] = 'ocena/uvoz/csv/kazalo';
$string['importcustom'] = 'Uvozi kot izide po meri (samo za ta predmet)';
$string['importerror'] = 'Prišlo je do napake, ta skripta ni bila klicana z ustreznimi parametri.';
$string['importfailed'] = 'Neuspešen uvoz. Noben podatek ni bil uvožen.';
$string['importfeedback'] = 'Uvozi pripombo';
$string['importfile'] = 'Uvozi datoteko';
$string['importfilemissing'] = 'Ni bilo prejete datoteke; pojdite nazaj na obrazec in uvozite veljavno datoteko.';
$string['importfrom'] = 'Uvozi iz';
$string['importoutcomenofile'] = 'Prenešena datoteka je prazna ali pokvarjena. Prosimo, preverite datoteko. Problem je bil zaznan v vrstici {$a}; vrstica nima toliko stolpcev kot prva vrstica ali pa v datoteki manjka pričakovana glava. Oglejte si izvoženo datoteko za primer datoteke s primerno glavo.';
$string['importoutcomes'] = 'Uvozi izide';
$string['importoutcomes_help'] = 'Izide je mogoče uvoziti prek datoteke csv v obliki, ki je enaka obliki izvoženih izidov.';
$string['importoutcomes_link'] = 'ocena/izid';
$string['importoutcomesuccess'] = 'Uvožen izid "{$a->name}" z ID-jem #{$a->id}';
$string['importplugins'] = 'Vtičniki za uvoz';
$string['importpreview'] = 'Predogled uvoza';
$string['importsettings'] = 'Nastavitve uvoza';
$string['importskippednomanagescale'] = 'Nimate dovoljenja za dodajanje nove lestvice, zato je bil izid "{$a}" preskočen, saj zahteva ustvarjanje nove lestvice';
$string['importskippedoutcome'] = 'Izid s kratkim imenom "{$a}" že obstaja v tem kontekstu, zato je bila ena izmed uvoženih datotek preskočena.';
$string['importstandard'] = 'Uvozi kot standardne izide';
$string['importsuccess'] = 'Uspešen uvoz ocen';
$string['importxml'] = 'Uvozi XML';
$string['includescalesinaggregation'] = 'V združevanje vključi lestvice';
$string['includescalesinaggregation_help'] = 'Lahko spremenite, ali naj se lestvice vključijo kot številke v vseh združenih ocenah v vseh redovalnicah, v vseh predmetih. OPOZORILO: sprememba te nastavitve bo prisilila vse združene ocene k ponovnem izračunu.';
$string['incorrectcourseid'] = 'ID predmeta je bil napačen';
$string['incorrectcustomscale'] = '(Nepravilna lestvica po meri, prosimo spremenite.)';
$string['incorrectminmax'] = 'Najnižja ocena mora biti nižja od najvišje';
$string['inherit'] = 'Prevzemi';
$string['intersectioninfo'] = 'Udeleženec/Informacije o oceni';
$string['invalidgradeexporteddate'] = 'Datum izvoza podatkov je nepravilen, ker je preteklo več kot eno leto ali se datum nahaja v prihodnosti ali ker je format nepravilen.';
$string['item'] = 'Element';
$string['iteminfo'] = 'Informacije o elementu';
$string['iteminfo_help'] = 'Ta nastavitev ponuja prostor za vnos informacije o elementu. Informacija se ne prikazuje nikjer drugje.';
$string['itemname'] = 'Ime postavke';
$string['itemnamehelp'] = 'Ime postavke, ki ga je določil modul.';
$string['items'] = 'Elementi';
$string['itemsedit'] = 'Uredi element ocene';
$string['keephigh'] = 'Obdrži najvišje';
$string['keephigh_help'] = 'Če nastavljena, bo ta možnost obdržala le X najvišjih ocen, pri čemer je X izbrana vrednost za to možnost.';
$string['keephighestvalues'] = 'Obdrži {$a} najvišjih vrednosti';
$string['keymanager'] = 'Upravljalec ključa';
$string['lessthanmin'] = 'Vnesena ocena za {$a->itemname} pri uporabniku {$a->username} ne dosega najnižje dovoljene vrednosti';
$string['letter'] = 'Črka';
$string['lettergrade'] = 'Črkovna ocena';
$string['lettergradenonnumber'] = 'Nizka in/ali visoka ocena sta bili neštevilčni za';
$string['letterpercentage'] = 'Črka (odstotek)';
$string['letterreal'] = 'Črka (prava)';
$string['letters'] = 'Črke';
$string['linkedactivity'] = 'Povezana dejavnost';
$string['linkedactivity_help'] = 'Ta nastavitev določa neobvezno dejavnost, ki je povezana s to postavko izida. To se uporablja za merjenje uspeha udeležencev na podlagi kriterijev, ki niso ovrednoteni z oceno dejavnosti.';
$string['linktoactivity'] = 'Povezava do {$a->name} dejavnosti {$a->title}';
$string['lock'] = 'Zakleni';
$string['locked'] = 'Zaklenjeno';
$string['locked_help'] = 'Če je označeno, ocene povezanih dejavnosti ne bodo več samodejno posodobljene.';
$string['locktime'] = 'Zakleni po';
$string['locktimedate'] = 'Zaklenjeno po: {$a}';
$string['lockverbose'] = 'Zakleni {$a->category}
{$a->itemmodule}
{$a->itemname}';
$string['lowest'] = 'Najnižja';
$string['lowgradeletter'] = 'Nizka';
$string['manualitem'] = 'Ročna postavka';
$string['mapfrom'] = 'Preslikaj iz';
$string['mapfrom_help'] = 'Izberite stolpec v tabeli, ki vsebuje podatke za identifikacijo uporabnika. Na primer uporabniško ime, uporabniški ID ali e-naslov.';
$string['mappings'] = 'Preslikave postavk ocen';
$string['mappings_help'] = 'Za vsak stolpec ocen v razpredelnici izberite ustrezajoč element ocene v katerega naj se uvozi ocene.';
$string['mapto'] = 'Preslikaj v';
$string['mapto_help'] = 'Izberi isti identifikacijski podatek kot je izbrano v "Preslikaj iz".';
$string['max'] = 'Najvišja';
$string['maxgrade'] = 'Najvišja ocena';
$string['meanall'] = 'Vse ocene';
$string['meangraded'] = 'Ocene z vrednostjo';
$string['meanselection'] = 'Izbrane ocene za povprečja v stolpcih';
$string['meanselection_help'] = 'Ali naj se celice brez ocen vključijo v izračun povprečja za vsak stolpec.';
$string['median'] = 'Mediana';
$string['min'] = 'Najnižja';
$string['minimum_show'] = 'Pokaži najnižjo oceno';
$string['minimum_show_help'] = 'Za preračunavanje ocen in uteži je uporabljena najnižja ocena. Če ta ni prikazana, bo privzeta najnižja ocena nič in je ne bo mogoče spremeniti.';
$string['minmaxtouse'] = 'Najnižja in najvišja ocena uporabljena v izračunu';
$string['minmaxtouse_desc'] = 'Ta nastavitev določa, ali se pri izvedbi izračuna ocen, prikazanih v redovalnici, uporabita najnižja in najvišja ocena, kot sta bili nastavljeni ob podelitvi ocene ali kot sta trenutno nastavljeni v nastavitvah elementa ocene.
Priporočljivo je, da se nastavitev spremeni v času manjše obremenitve sistema, saj preračun vseh ocen lahko povzroči visoko obremenitev strežnika.';
$string['minmaxtouse_help'] = 'Ta nastavitev določa, ali se pri izvedbi izračuna ocen, prikazanih v redovalnici, uporabita najnižja in najvišja ocena, kot sta bili nastavljeni ob podelitvi ocene ali kot sta trenutno nastavljeni v nastavitvah elementa ocene.';
$string['minmaxtouse_link'] = 'Grades_min_max';
$string['minmaxupgradedgrades'] = 'Opomba: Nekatere ocene so bile spremenjene, da se odpravi neskladje v redovalnici, ki je posledica spremembe najnižje in najvišje ocene, uporabljene pri izračunu prikazanih ocen. Priporočljivo je, da se spremembe pregledajo in potrdijo.';
$string['minmaxupgradefixbutton'] = 'Reši nedoslednosti';
$string['minmaxupgradewarning'] = 'Opomba: zaradi sprememb nastavitve najnižje in najvišje ocene, ki sta uporabljeni za izračun ocen prikazanih v redovalnici, je bila pri nekaterih ocenah zaznana nedoslednost. Priporočljivo je, da se nedoslednost odpravi s klikom na spodnji gumb, čeprav bo to povzročilo spremembe pri nekaterih ocenah.';
$string['missingitemtypeoreid'] = 'Pri drugem parametru grade_edit_tree_column_select::get_item_cell($item, $params) manjka ključ polja (itemtype ali eid)';
$string['missingscale'] = 'Izbrana mora biti lestvica';
$string['mode'] = 'Način';
$string['modgrade'] = 'Ocena';
$string['modgrade_help'] = 'Izberite način ocenjevanja za to dejavnost. Če izberete "lestvica", lahko izberete lestvico iz spustnega menija.
 Če izberete "točke", lahko vnesete največje možno število točk, ki je na voljo za to dejavnost.';
$string['modgradecantchangegradetype'] = 'Ker ocena za ta element že obstaja, tipa ne morete spremeniti.';
$string['modgradecantchangegradetypemsg'] = 'Nekatere ocene so že bile dodeljene, zato tipa ocene ni mogoče spremeniti. Če želite spremeniti najvišjo oceno, morate najprej določiti, ali želite prevrstiti že obstoječe ocene.';
$string['modgradecantchangegradetyporscalemsg'] = 'Nekatere ocene so že bile dodeljene, zato tipa ocene in lestvice ni mogoče spremeniti.';
$string['modgradecantchangeratingmaxgrade'] = 'Ne morete spremeniti nastavitve najvišje ocene, če v aktivnosti z možnostjo ocenjevanja že obstajajo ocene.';
$string['modgradecantchangescale'] = 'Ne morete spremeniti lestvice, ker za ta element že obstajajo ocene.';
$string['modgradecategorycantchangegradetypemsg'] = 'Ta kategorija ima povezane elemente ocene, ki so bili povoženi. Torej so bile nekatere ocene že dodeljene in sprememba tipa ocene ni več možna. Če želite spremeniti najvišjo oceno, morate najprej izbrati, ali naj se prevrsti obstoječe ocene.';
$string['modgradecategorycantchangegradetyporscalemsg'] = 'Ta kategorija ima povezane elemente ocene, ki so bili povoženi. Torej so bile nekatere ocene že dodeljene in sprememba tipa ocene in lestvice več ni možna.';
$string['modgradecategoryrescalegrades'] = 'Prevrsti povožene ocene';
$string['modgradecategoryrescalegrades_help'] = 'Pri spremembi najvišjih ocen v elementu redovalnice morate navesti, ali bo to povzročilo tudi spremembo obstoječih odstotkovnih ocen.
Če je ta možnost nastavljena na "Da", bodo vse obstoječe povožene ocene prevrščene tako, da ostane procentualna ocena ista.
Na primer, če je ta možnost nastavljena na "Da", bo sprememba najvišje ocene z 10 na 20 točk povzročila, da se oceno 6/10 (60 %) prevrsti na 12/20 (60 %). Pri nastavitvi na "Ne" pa bo ocena ostala nespremenjena, zahtevana bo ročna prilagoditev elementov ocene, da se zagotovi pravilnost rezultatov.';
$string['modgradedonotmodify'] = 'Ne spreminjaj obstoječih ocen';
$string['modgradeerrorbadpoint'] = 'Neveljavna vrednost ocene. Ta mora biti celo število med 1 in {$a}';
$string['modgradeerrorbadscale'] = 'Izbrali ste neveljavno lestvico. Preverite, ali ste izbrali lestvico s spodnjega seznama.';
$string['modgrademaxgrade'] = 'Najvišja ocena';
$string['modgraderescalegrades'] = 'Prevrsti obstoječe ocene';
$string['modgraderescalegrades_help'] = 'Pri spremembi najvišjih ocen v elementu redovalnice morate navesti, ali bo to povzročilo tudi spremembo obstoječih odstotkovnih ocen.

Če je ta možnost nastavljena na "Da", bodo obstoječe povožene ocene prevrščene tako, da ostane odstotkovna ocena ista.

Na primer, če je ta možnost nastavljena na "Da", bo sprememba najvišje ocene z 10 na 20 točk povzročila, da se oceno 6/10 (60 %) prevrsti na 12/20 (60 %). Pri nastavitvi na "Ne" pa se bo ocena prevrstila iz 6/10 (60%) na 6/20 (30%), zahtevana bo ročna prilagoditev elementov ocene, da se zagotovi pravilnost rezultatov.';
$string['modgradetype'] = 'Tip';
$string['modgradetypenone'] = 'Nič';
$string['modgradetypepoint'] = 'Točke';
$string['modgradetypescale'] = 'Lestvica';
$string['morethanmax'] = 'Vnesena ocena za {$a->itemname} pri uporabniku {$a->username} presega najvišjo dovoljeno vrednost';
$string['moveselectedto'] = 'Premakni izbrane predmete v:';
$string['movingelement'] = 'Premikanje {$a}';
$string['multfactor'] = 'Večkratnik';
$string['multfactor_help'] = 'Množitelj je faktor, s katerim bodo pomnožene vse ocene v tej postavki ocene z najvišjo vrednostjo enako najvišji oceni. Če je na primer večkratnik število 2 in najvišja ocena 100, potem se vse ocene, manjše od 50, pomnoži z 2, ocena z vrednostjo 50 ali več pa se spremeni v 100.';
$string['multfactorvalue'] = 'Vrednost večkratnika za {$a}';
$string['mustchooserescaleyesorno'] = 'Odločiti se morate, ali se obstoječe ocene prevrsti ali ne.';
$string['mygrades'] = 'Povezava na ocene v uporabniškem meniju';
$string['mygrades_desc'] = 'Nastavitev omogoča možnost povezovanja z zunanjo redovalnico iz uporabniškega menija.';
$string['mypreferences'] = 'Moje nastavitve';
$string['myreportpreferences'] = 'Moje nastavitve poročila';
$string['neverdeletehistory'] = 'Nikoli ne izbriši zgodovine';
$string['newcategory'] = 'Nova kategorija';
$string['newitem'] = 'Nov element ocene';
$string['newoutcomeitem'] = 'Nov element izida';
$string['no'] = 'Ne';
$string['nocategories'] = 'Kategorije ocen ni možno dodati ali najti za ta predmet';
$string['nocategoryname'] = 'Ni bilo danega imena kategorije.';
$string['nocategoryview'] = 'Ni kategorije za pregled';
$string['nocourses'] = 'Ni še predmetov';
$string['noforce'] = 'Ne vsili';
$string['nogradeletters'] = 'Ni nastavljenih črkovnih ocen';
$string['nogradesreturned'] = 'Ni vrnjenih ocen';
$string['noidnumber'] = 'Ni ID številke';
$string['nolettergrade'] = 'Ni črkovne ocene za';
$string['nomode'] = 'BREZ';
$string['nonnumericweight'] = 'Prejeta neštevilčna vrednost za';
$string['nonunlockableverbose'] = 'Te ocene ni mogoče odkleniti, dokler je postavka {$a->itemname} zaklenjena.';
$string['nonweightedpct'] = 'neutežen %';
$string['nooutcome'] = 'Ni izida';
$string['nooutcomes'] = 'Postavke izida morajo biti povezane z izidom predmeta, vendar v tem predmetu ni izidov. Ali želite dodati izid?';
$string['nopermissiontoresetweights'] = 'Ni dovoljenja za ponastavitev uteži';
$string['nopublish'] = 'Ne objavi';
$string['noreports'] = 'Niste vpisani oziroma ne učite nobegena predmeta na tej strani.';
$string['norolesdefined'] = 'Ni določenih vlog v Skrbništvo > Ocene > Splošne nastavitve > Ocenjene vloge';
$string['noscales'] = 'Izidi morajo biti povezani z lestvico predmeta ali globalno lestvico, vendar ni nobenih lestvic. Ali želite dodati lestvico?';
$string['noselectedcategories'] = 'ni izbranih kategorij.';
$string['noselecteditems'] = 'ni izbranih postavk.';
$string['notenrolled'] = 'Trenutno niste vpisani v noben predmet.';
$string['notteachererror'] = 'Za uporabo te možnosti morate biti izvajalec.';
$string['nousersloaded'] = 'Ni naloženih uporabnikov';
$string['nouserstograde'] = 'Ni uporabnikov za ocenjevanje';
$string['numberofgrades'] = 'Število ocen';
$string['onascaleof'] = 'na lestvici od {$a->grademin} do {$a->grademax}';
$string['operations'] = 'Dejanja';
$string['options'] = 'Možnosti';
$string['others'] = 'Drugi';
$string['outcome'] = 'Izid';
$string['outcome_help'] = 'Ta nastavitev določa izid, ki ga bo ta element ocene določal v redovalnici. Na voljo so samo izidi, ki so povezani s tem predmetom ali s celotno stranjo.';
$string['outcomeassigntocourse'] = 'Dodeli drug izid temu predmetu';
$string['outcomecategory'] = 'Ustvari izide v kategoriji';
$string['outcomecategorynew'] = 'Nova kategorija';
$string['outcomeconfirmdelete'] = 'Ali ste prepričani, da želite izbrisati izid "{$a}"?';
$string['outcomecreate'] = 'Dodaj nov izid';
$string['outcomedelete'] = 'Izbriši izid';
$string['outcomefullname'] = 'Polno ime';
$string['outcomeitem'] = 'Postavka elementa';
$string['outcomeitemsedit'] = 'Uredi element izida';
$string['outcomereport'] = 'Poročilo izida';
$string['outcomes'] = 'Izidi';
$string['outcomescourse'] = 'Izidi v predmetu';
$string['outcomescoursecustom'] = 'Uporabljeno po meri (ni mogoče odstraniti)';
$string['outcomescoursenotused'] = 'Standardni niso v uporabi';
$string['outcomescourseused'] = 'Standardni v uporabi (ni mogoče odstraniti)';
$string['outcomescustom'] = 'Izidi po meri';
$string['outcomeshortname'] = 'Kratko ime';
$string['outcomesstandard'] = 'Standardni izidi';
$string['outcomesstandardavailable'] = 'Standardni izidi na voljo';
$string['outcomestandard'] = 'Standardni izid';
$string['outcomestandard_help'] = 'Standardni izid je na voljo za celotno stran, za vse predmete.';
$string['overallaverage'] = 'Skupno povprečje';
$string['overridden'] = 'Povoženo';
$string['overridden_help'] = 'Če je označeno, ocene ni več mogoče spreminjati znotraj povezane dejavnosti

 Ko je ocena urejena v poročilu ocenjevalca, se povoženo polje samodejno označi. Polje je vseeno mogoče odznačiti in omogočiti spreminjanje ocene preko povezane dejavnosti.';
$string['overriddennotice'] = 'Končna ocena za to dejavnost je bila ročno prilagojena.';
$string['overridecat'] = 'Dovoli, da so ocene kategorije ročno povožene';
$string['overridecat_help'] = 'Če to nastavitev onemogočite, uporabnik ne bo imel možnosti povoziti ocene kategorije.';
$string['overridesitedefaultgradedisplaytype'] = 'Povozi privzete nastavitve strani';
$string['overridesitedefaultgradedisplaytype_help'] = 'Če je označeno, lahko nastavite črkovne ocene in meje za predmet po svoji izbiri in vam ni treba uporabiti privzetih nastavitev za stran.';
$string['overrideweightofa'] = 'Povozi utež {$a}';
$string['parentcategory'] = 'Nadrejena kategorija';
$string['pctoftotalgrade'] = '% od skupne ocene';
$string['percent'] = 'Odstotek';
$string['percentage'] = 'Odstotek';
$string['percentageletter'] = 'Odstotek (črka)';
$string['percentagereal'] = 'Odstotek (pravi)';
$string['percentascending'] = 'Razvrsti po odstotkih naraščajoče';
$string['percentdescending'] = 'Razvrsti po odstotkih padajoče';
$string['percentshort'] = '%';
$string['plusfactor'] = 'Odmik';
$string['plusfactor_help'] = 'Število, ki bo prišteto vsaki oceni za ta element ocene po množenju z večkratnikom.';
$string['plusfactorvalue'] = 'Vrednost odmika za {$a}';
$string['points'] = 'točke';
$string['pointsascending'] = 'Razvrsti po točkah naraščajoče';
$string['pointsdescending'] = 'Razvrsti po točkah padajoče';
$string['positionfirst'] = 'Prvi';
$string['positionlast'] = 'Zadnji';
$string['preferences'] = 'Nastavitve';
$string['prefgeneral'] = 'Splošno';
$string['prefletters'] = 'Črkovne ocene in omejitve';
$string['prefrows'] = 'Posebne vrstice';
$string['prefshow'] = 'Prikaži/skrij preklopnike';
$string['previewrows'] = 'Predogled vrstic';
$string['privacy:metadata:categorieshistory'] = 'Zapis prejšnjih različic kategorij ocen';
$string['privacy:metadata:filepurpose'] = 'Datoteke za odziv se shranijo v redovalnico uporabnika.';
$string['privacy:metadata:grade_import_newitem'] = 'Začasna tabela za shranjevanje novih imen ocen iz uvoženih ocen';
$string['privacy:metadata:grade_import_newitem:importcode'] = 'Edinstvena paketna koda za prepoznavanje uvoženih paketov';
$string['privacy:metadata:grade_import_newitem:importer'] = 'Uporabnik uvaža podatke';
$string['privacy:metadata:grade_import_newitem:itemname'] = 'Novo ime elementa ocene';
$string['privacy:metadata:grade_import_values'] = 'Začasna tabela za uvoz ocen';
$string['privacy:metadata:grade_import_values:feedback'] = 'Pripomba ocene';
$string['privacy:metadata:grade_import_values:finalgrade'] = 'Groba vrednost ocene';
$string['privacy:metadata:grade_import_values:importcode'] = 'Edinstvena paketna koda za prepoznavanje uvoženih paketov';
$string['privacy:metadata:grade_import_values:importer'] = 'Uporabnik uvaža podatke';
$string['privacy:metadata:grade_import_values:importonlyfeedback'] = 'Označi z zastavico samo, če je bila naložena pripomba';
$string['privacy:metadata:grade_import_values:userid'] = 'Uporabnik, katerega ocena je bila uvožena';
$string['privacy:metadata:grades'] = 'Zapis ocen';
$string['privacy:metadata:grades:aggregationstatus'] = 'Status združevanja';
$string['privacy:metadata:grades:aggregationweight'] = 'Teža v združevanju';
$string['privacy:metadata:grades:feedback'] = 'Pripomba';
$string['privacy:metadata:grades:finalgrade'] = 'Ocena';
$string['privacy:metadata:grades:information'] = 'Dodatne informacije o oceni';
$string['privacy:metadata:grades:timemodified'] = 'Čas zadnje spremembe ocene';
$string['privacy:metadata:grades:userid'] = 'ID uporabnika, ki mu ta ocena pripada';
$string['privacy:metadata:grades:usermodified'] = 'ID uporabnika, ki je zadnji spremenil zapis';
$string['privacy:metadata:gradeshistory'] = 'Zapis prejšnjih ocen';
$string['privacy:metadata:history:loggeduser'] = 'ID uporabnika, ki je bil vpisan, ko se je pojavila nova različica';
$string['privacy:metadata:history:timemodified'] = 'Čas pojavitve nove različice ocene';
$string['privacy:metadata:itemshistory'] = 'Zapis prejšnjih različic elementov ocen';
$string['privacy:metadata:outcomes'] = 'Zapis izidov';
$string['privacy:metadata:outcomes:timemodified'] = 'Čas, ko je bil zapis spremenjen';
$string['privacy:metadata:outcomes:usermodified'] = 'Uporabnik, ki je zadnji spremenil zapis';
$string['privacy:metadata:outcomeshistory'] = 'Zapis prejšnjih različic izidov';
$string['privacy:metadata:scale'] = 'Zapis lestvic';
$string['privacy:metadata:scale:timemodified'] = 'Čas zadnje spremembe zapisa';
$string['privacy:metadata:scale:userid'] = 'Uporabnik, ki je zadnji spremenil zapis';
$string['privacy:metadata:scalehistory'] = 'Zapis prejšnjih različic lestvic';
$string['privacy:path:relatedtome'] = 'Povezano z mano';
$string['privacy:request:historyactiondelete'] = 'Izbriši';
$string['privacy:request:historyactioninsert'] = 'Vstavi';
$string['privacy:request:historyactionupdate'] = 'Posodobi';
$string['privacy:request:unknowndeletedgradeitem'] = 'Neznano (element ocene je bil izbrisan)';
$string['profilereport'] = 'Poročilo uporabniškega profila';
$string['profilereport_help'] = 'Poročilo za ocene, ki se uporabi na profilu uporabnika.';
$string['publishing'] = 'Objavljanje';
$string['publishingoptions'] = 'Možnosti objave ocene';
$string['quickfeedback'] = 'Hitra pripomba';
$string['quickgrading'] = 'Hitro ocenjevanje';
$string['quickgrading_help'] = 'Če je omogočeno, se bo takrat, ko je vključeno urejanje, polje za vnos pojavilo pri vsaki oceni, kar bo omogočilo urejanje več ocen istočasno. Spremembe bodo shranjene in označene, ko boste kliknili gumb za posodobitev.

 Upoštevajte da se takrat, ko je ocena spremenjena v ocenjevalčevem poročilu, pojavi zastavica, kar pomeni, da ocene ni več mogoče spremninjati znotraj povezane dejavnosti.';
$string['range'] = 'Razpon';
$string['rangedecimals'] = 'Razpon decimalnih mest';
$string['rangedecimals_help'] = 'Število decimalnih mest za prikaz v razponu.';
$string['rangesdecimalpoints'] = 'Decimalke, prikazane v razponih';
$string['rangesdecimalpoints_help'] = 'Nastavitev določa število decimalnih mest za prikaz za vsak razpon oziroma, v primeru, da je nastavitev skupna, število decimalnih mest določa za celotno kategorijo ali element ocene. (prevzemi).';
$string['rangesdisplaytype'] = 'Vrsta prikaza razpona';
$string['rangesdisplaytype_help'] = 'Ta nastavitev določa, ali bo razpon prikazan kot prave ocene, odstotki ali črke in ali bo vrsta prikaza uporabljena za kategorijo ali element ocene (prevzemi).';
$string['rank'] = 'Razvrstitev';
$string['rawpct'] = 'Čisti %';
$string['real'] = 'Prave';
$string['realletter'] = 'Prave (črka)';
$string['realpercentage'] = 'Prave (odstotek)';
$string['recalculatinggrades'] = 'Preračunavanje ocen';
$string['recovergradesdefault'] = 'Ponastavi ocene';
$string['recovergradesdefault_help'] = 'Privzeto obnovi prejšnje ocene udeleženca, ko se ta ponovno vpiše v predmet.';
$string['refreshpreview'] = 'Osveži predogled';
$string['regradeanyway'] = 'Vseeno ponovno oceni';
$string['removeallcoursegrades'] = 'Izbriši vse ocene';
$string['removeallcoursegrades_help'] = 'Če obkljukate to polje, se vsi elementi ocene, ki ste jih ročno dodali v redovalnico, izbrišejo skupaj z ocenami in podatki o povoženih, izločenih, skritih ter zaklenjenih ocenah. Ostali bodo samo elementi ocene, ki so povezani z dejavnostmi.';
$string['removeallcourseitems'] = 'Izbriši vse elemente in kategorije';
$string['removeallcourseitems_help'] = 'Če obkljukate to polje, se vsi elementi ocene in kategorije, ki ste jih ročno dodali v redovalnico, izbrišejo skupaj z ocenami in podatki o povoženih, izločenih, skritih ter zaklenjenih ocenah. Ostali bodo samo elementi ocene, ki so povezani z dejavnostmi.';
$string['report'] = 'Poročilo';
$string['reportdefault'] = 'Privzeta vrednost poročila ({$a})';
$string['reportplugins'] = 'Vtičniki za poročilo';
$string['reportsettings'] = 'Nastavitve poročila';
$string['reprintheaders'] = 'Ponovni prikaz glave';
$string['resetweights'] = 'Ponastavitev uteži od {$a->itemname}';
$string['resetweightsshort'] = 'Ponastavi uteži';
$string['respectingcurrentdata'] = 'puščam nespremenjene trenutne nastavitve';
$string['rowpreviewnum'] = 'Predogled vrstic';
$string['rowpreviewnum_help'] = 'Predogled podatkov je možen pred potrditvijo uvoza. Ta nastavitev določa, koliko vrstic je prikazanih v predogledu.';
$string['savechanges'] = 'Shrani spremembe';
$string['savepreferences'] = 'Shrani nastavitve';
$string['scaleconfirmdelete'] = 'Ste prepričani, da želite izbrisati lestvico "{$a}"?';
$string['scaledpct'] = '% v razmerju';
$string['seeallcoursegrades'] = 'Ogled vseh ocen predmeta';
$string['select'] = 'Izberite {$a}';
$string['selectalloroneuser'] = 'Izberi vse ali enega uporabnika';
$string['selectauser'] = 'Izberi uporabnika';
$string['selectdestination'] = 'Izberite cilj za {$a}';
$string['separator'] = 'Ločilo';
$string['separator_help'] = 'Izberite ločilo, uporabljeno v datoteki CSV. (Običajno je to vejica.)';
$string['sepcolon'] = 'Dvopičje';
$string['sepcomma'] = 'Vejica';
$string['sepsemicolon'] = 'Podpičje';
$string['septab'] = 'Zavihek';
$string['setcategories'] = 'Nastavi kategorije';
$string['setcategorieserror'] = 'Najprej morate nastaviti kategorije za vaš predmet, preden jih lahko utežite.';
$string['setgradeletters'] = 'Nastavi črkovne ocene';
$string['setpreferences'] = 'Nastavi možnosti';
$string['setting'] = 'Nastavitev';
$string['settings'] = 'Nastavitve';
$string['setweights'] = 'Nastavi uteži';
$string['showallhidden'] = 'Prikaži skrito';
$string['showallstudents'] = 'Prikaži vse udeležence';
$string['showaverage'] = 'Prikaži povprečje';
$string['showaverage_help'] = 'Prikažem stolpec povprečja? Udeleženci bodo lahko predvideli ocene drugih udeležencev, če je povprečje izračunano iz majhnega števila ocen. Zaradi zmogljivostnih razlogov je povprečje približno, če je odvisno od skritih ocen.';
$string['showaverages'] = 'Prikaži povprečje stolpcev';
$string['showaverages_help'] = 'Če je možnost omogočena, bo poročilo ocenjevalca vsebovalo dodatno vrstico za prikaz povprečja (sredine) za vsako kategorijo in element ocene.';
$string['showcontributiontocoursetotal'] = 'Prikaži prispevek k seštevku predmeta';
$string['showcontributiontocoursetotal_help'] = 'Ali naj se prikaže stolpec z odstotki, ki kaže, koliko posamezen element ocene prispeva k uporabnikovemu odstotku seštevka predmeta (po izvedbi obtežitve).';
$string['showfeedback'] = 'Prikaži pripombo';
$string['showfeedback_help'] = 'Prikažem stolpec s pripombami?';
$string['showgrade'] = 'Prikaži ocene';
$string['showgrade_help'] = 'Prikažem stolpec ocen?';
$string['showgroups'] = 'Prikaži skupine';
$string['showhiddenitems'] = 'Prikaži skrite elemente';
$string['showhiddenitems_help'] = 'Ali so skriti elementi popolnoma skriti ali so imena skritih ocen vidna uporabnikom.

* Prikaži skrite - imena skritih elementov so prikazana, ocene so skrite

* Samo skrite do - Ocene z nastavitvijo "skrij do" so skrite popolnoma do nastavljenega datuma, po tem datumu pa so vse ocene prikazane

* Ne prikaži - Skrite ocene so popolnoma skrite';
$string['showhiddenuntilonly'] = 'Skrit do';
$string['showingaggregatesonly'] = 'Prikazovanje samo združenih';
$string['showingfullmode'] = 'Prikazovanje celotnega pogleda';
$string['showinggradesonly'] = 'Prikazovanje samo ocen';
$string['showlettergrade'] = 'Prikaži črkovne ocene';
$string['showlettergrade_help'] = 'Prikažem stolpec črkovnih ocen?';
$string['shownohidden'] = 'Ne prikaži';
$string['shownooutcomes'] = 'Skrij izide';
$string['shownumberofgrades'] = 'Prikaži število ocen v povprečjih';
$string['shownumberofgrades_help'] = 'Če je ta možnost omogočena, se število ocen, uporabljenih za izračun povprečja (sredine) prikaže v oklepaju za vsakim povprečjem.';
$string['showonlyactiveenrol'] = 'Prikaži samo aktivne vpisane uporabnike';
$string['showonlyactiveenrol_help'] = 'Ta nastavitev določa, ali bodo v poročilu redovalnice prikazani samo aktivni vpisani uporabniki. Če je možnost vključena, izpisani uporabniki ne bodo vidni v redovalnici.';
$string['showpercentage'] = 'Prikaži odstotek';
$string['showpercentage_help'] = 'Ali prikažem odstotno vrednost za vsak element ocene?';
$string['showrange'] = 'Prikaži območja';
$string['showrange_help'] = 'Prikažem stolpec z območji?';
$string['showranges'] = 'Prikaži območja';
$string['showranges_help'] = 'Če je ta možnost omogočena, bo poročilo ocenjevalca vsebovalo dodatno vrstico, ki bo prikazovala razpon za vsako kategorijo in element ocene.';
$string['showrank'] = 'Prikaži rang';
$string['showrank_help'] = 'Ta nastavitev določa, ali bo položaj uporabnika prikazan v primerjavi s preostalimi uporabniki za vsak element ocene';
$string['showuserimage'] = 'Prikaži slike uporabniških profilov';
$string['showuserimage_help'] = 'Ta nastavitev določa, ali se slika uporabnika prikaže zraven ocen v poročilu ocenjevalca.';
$string['showverbose'] = 'Prikaži {$a->category} {$a->itemmodule} {$a->itemname}';
$string['showweight'] = 'Prikaži uteževanje';
$string['showweight_help'] = 'Prikažem stolpec uteži ocene?';
$string['simpleview'] = 'Posamezen pogled';
$string['sitewide'] = 'Za celotno stran';
$string['sort'] = 'razvrsti';
$string['sortasc'] = 'Razvrsti naraščajoče';
$string['sortbyfirstname'] = 'Razvrsti po imenu';
$string['sortbylastname'] = 'Razvrsti po priimku';
$string['sortdesc'] = 'Razvrsti padajoče';
$string['standarddeviation'] = 'Standardni odklon';
$string['stats'] = 'Statistika';
$string['statslink'] = 'Statistika';
$string['student'] = 'Udeleženec';
$string['studentsperpagereduced'] = 'Najvišje število uporabnikov na stran od {$a->originalstudentsperpage} do {$a->studentsperpage}. Razmislite o tem, da bi povečali nastavite PHP max_input_vars od {$a->maxinputvars}.';
$string['subcategory'] = 'Običajna kategorija';
$string['submissions'] = 'Prispevki';
$string['submittedon'] = 'Oddano: {$a}';
$string['sumofgradesupgradedgrades'] = 'Opomba: kot del nadgradnje spletnega mesta je bila združevalna metoda "Vsota ocen" spremenjena v "Naravna". V tem predmetu je pred tem že bila uporabljena "Vsota ocen", zato je priporočljivo, da si v redovalnici spremembo ogledate.';
$string['switchtofullview'] = 'Zamenjaj na polni pogled';
$string['switchtosimpleview'] = 'Zamenjaj na enostavni pogled';
$string['topcategory'] = 'Super kategorija';
$string['total'] = 'Skupaj';
$string['totalweight100'] = 'Skupna utež je enaka 100';
$string['totalweightnot100'] = 'Skupna utež ni enaka 100';
$string['turnfeedbackoff'] = 'Izključi pripombe';
$string['turnfeedbackon'] = 'Vključi pripombe';
$string['typenone'] = 'Nič';
$string['typescale'] = 'Lestvica';
$string['typescale_help'] = 'Ta nastavitev določa uporabljeno lestvico pri uporabi lestvice kot vrste ocenjevanja. Lestvica za oceno na podlagi aktivnosti se nastavi v nastavitvah na strani posamezne dejavnosti.';
$string['typetext'] = 'Besedilo';
$string['typevalue'] = 'Vrednost';
$string['uncategorised'] = 'Nekategorizirano';
$string['unchangedgrade'] = 'Ocena nespremenjena';
$string['unenrolledusersinimport'] = 'Ta uvoz je vseboval naslednje ocene za uporabnike, ki trenutno niso vključeni v ta predmet: {$a}';
$string['unlimitedgrades'] = 'Neomejene ocene';
$string['unlimitedgrades_help'] = 'Privzeto so ocene omejene z največjo in najmanjšo vrednostjo vsakega elementa ocene. Omogočanje te nastavitve umakne to omejitev in dovoli, da se lahko vpiše ocena nad 100 % neposredno v redovalnico.';
$string['unlock'] = 'Odkleni';
$string['unlockverbose'] = 'Odkleni {$a->category} {$a->itemmodule} {$a->itemname}';
$string['unused'] = 'Neuporabljeno';
$string['updatedgradesonly'] = 'Izvozi samo nove ali posodobljene ocene';
$string['upgradedgradeshidemessage'] = 'Opusti obvestilo';
$string['upgradedminmaxrevertmessage'] = 'Povrni spremembe';
$string['uploadgrades'] = 'Naloži ocene';
$string['useadvanced'] = 'Uporabi napredne možnosti';
$string['usedcourses'] = 'Uporabljeni predmeti';
$string['usedgradeitem'] = 'Uporabljen element ocene';
$string['usenooutcome'] = 'Ne uporabi izidov';
$string['usenoscale'] = 'Ne uporabi lestvice';
$string['usepercent'] = 'Uporabi odstotek';
$string['user'] = 'Uporabnik';
$string['userenrolmentsuspended'] = 'Uporabniški vpis je bil suspendiran';
$string['userfields_show'] = 'Pokaži uporabniška polja';
$string['userfields_show_help'] = 'Prikaži dodatna uporabniška polja, kot so e-poštni naslov v ocenjevalčevem poročilu. Prikazana polja so odvisna od nastavitve na strani "showuseridentity"';
$string['usergrade'] = 'Uporabnik {$a->fullname} ({$a->useridnumber}) na elementu {$a->gradeidnumber}';
$string['userid'] = 'ID uporabnika';
$string['useridnumberwarning'] = 'Uporabniki brez ID številke so iz izvoza izključeni, saj jih ni mogoče uvoziti';
$string['usermappingerror'] = 'Napačno določen uporabnik: ni bilo možno najti uporabnika z {$a->field} pri "{$a->value}".';
$string['usermappingerrorcurrentgroup'] = 'Uporabnik ni član te skupine.';
$string['usermappingerrormultipleusersfound'] = 'Napačno določen uporabnik: Več uporabnikov najdenih z {$a->field} pri "{$a->value}". Prosim, uporabite bolj natančno oznako.';
$string['usermappingerrorusernotfound'] = 'Napačno določen uporabnik: uporabnika ni bilo mogoče najti.';
$string['userpreferences'] = 'Uporabniške nastavitve';
$string['useweighted'] = 'Uporabi uteženo';
$string['verbosescales'] = 'Podrobne lestvice';
$string['verbosescales_help'] = 'Opisna lestvica uporablja besede namesto številk. Nastavite na "Da", če se bodo uvažale tako numerične kot opisne lestvice. Nastavite na "Ne", če se bodo uvažale le numerične lestvice.';
$string['viewbygroup'] = 'Skupina';
$string['viewgrades'] = 'Poglej ocene';
$string['weight'] = 'Utež';
$string['weight_help'] = 'Vrednost, ki se uporablja za določanje relativne vrednosti elementov večkratnih ocen v kategoriji ali predmetu.';
$string['weightcourse'] = 'Uporabi utežene ocene pri predmetu';
$string['weightedascending'] = 'Razvrsti po uteženem odstotku naraščajoče';
$string['weighteddescending'] = 'Razvrsti po uteženem odstotku padajoče';
$string['weightedpct'] = 'utežen %';
$string['weightedpctcontribution'] = 'prispevek uteženega %';
$string['weightofa'] = 'Utež {$a}';
$string['weightorextracredit'] = 'Teža ali dodatne kreditne točke';
$string['weightoverride'] = 'prilagoditev uteži';
$string['weightoverride_help'] = 'Opusti izbrane za ponastavitev uteži elementa ocene na njegovo avtomatično izračunano vrednost. Izbrana polja bodo preprečila avtomatično prilagoditev uteži.';
$string['weights'] = 'Uteži';
$string['weightsadjusted'] = 'Vaše uteži so bile prilagojene skupni vrednosti 100.';
$string['weightsedit'] = 'Uredi težo in dodatne kreditne točke';
$string['weightuc'] = 'Izračunana utež';
$string['writinggradebookinfo'] = 'Pisanje nastavitev redovalnice';
$string['xml'] = 'XML';
$string['yes'] = 'Da';
$string['yourgrade'] = 'Vaša ocena';
