<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'install', language 'sk', version '5.0'.
 *
 * @package     install
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['admindirerror'] = 'Adresár pre správu (admin) nie je určený správne';
$string['admindirname'] = 'Adresár so súbormi pre správu servera';
$string['admindirsetting'] = 'Niektorí poskytovatelia web priestoru používajú adresár /admin pre prístup ku kontrolnému panelu, prípadne ku podobným funkciám. To bohužiaľ nie je v súlade so štandardným umiestnením adresáru pre správu v Moodle. Tento konflikt je možné vyriešiť premenovaním adresáru pre správu vo Vašej inštalácii. Vložte sem nový názov, napr.<br /><br />
<b>moodleadmin</b><br /><br />
Tým sa opravia odkazy na správu Moodle.';
$string['admindirsettinghead'] = 'Nastavovanie adresáre \'admin\'...';
$string['admindirsettingsub'] = 'Na niektorých serveroch je URL adresa /admin vyhradená pre špeciálne účely (napr. pre ovládací panel). Na takých serveroch môže dojsť ku kolízii so štandardným umiestením stránok pre správu Moodle. Ak máte tento problém, premenujte adresár \'admin\' vo vašej inštalácii Moodle a do tohto poľa zadajte jeho nový názov. Príklad: <br /> <br /><b>moodleadmin</b><br /> <br />
Všetky generované odkazy na stránky správy Moodle budú používať tento nový názov.';
$string['availablelangs'] = 'Dostupné jazykové balíčky';
$string['caution'] = 'Varovanie';
$string['chooselanguage'] = 'Vyberte jazyk';
$string['chooselanguagehead'] = 'Vyberte jazyk';
$string['chooselanguagesub'] = 'Zvoľte si jazyk pre inštaláciu. Tento jazyk bude tiež použitý ako východzí jazyk portálu, ale môže byť neskôr zmenený.';
$string['cliadminemail'] = 'E-mailová adresa nového administrátora';
$string['cliadminpassword'] = 'Nové heslo administrátora';
$string['cliadminusername'] = 'Login administrátora';
$string['clialreadyconfigured'] = 'Konfiguračný súbor config.php už existuje. Spusťte admin/cli/install_database.php, ak chcete inštalovať Moodle pre tento portál.';
$string['clialreadyinstalled'] = 'Súbor config.php už existuje. Použite admin/cli/install_database.php ak chcete aktualizovať váš portál.';
$string['cliinstallfinished'] = 'Inštalácia úspešne ukončená';
$string['cliinstallheader'] = 'Moodle {$a} inštalačný program z príkazového riadku';
$string['climustagreelicense'] = 'V neinteraktívnom móde musíte súhlasiť s licenciou pomocou voľby --agree-license.';
$string['cliskipdatabase'] = 'Preskočiť inštaláciu databázy';
$string['clisupportemail'] = 'E-mailová adresa podpory';
$string['clitablesexist'] = 'Databázové tabuľky už existujú, CLI inštalácia nemôže pokračovať.';
$string['compatibilitysettings'] = 'Kontrola nastavenia vášho PHP...';
$string['compatibilitysettingshead'] = 'Kontrola nastavenia vášho PHP...';
$string['compatibilitysettingssub'] = 'Pre správny beh Moodle by váš server mal vyhovieť vo všetkých nasledujúcich testoch.';
$string['configfilenotwritten'] = 'Inštalačný skript nebol schopný automaticky vytvoriť config.php súbor, obsahujúci Vaše zvolené nastavenia, pravdepodobne preto, že adresár Moodle nie je zapisovateľný. Môžete ručne skopírovať nasledovný kód do súboru s názvom config.php v rámci  koreňového adresára Moodle.';
$string['configfilewritten'] = 'súbor config.php bol úspešne vytvorený';
$string['configurationcomplete'] = 'Konfigurácia ukončená';
$string['configurationcompletehead'] = 'Konfigurácia ukončená';
$string['configurationcompletesub'] = 'Moodle sa pokúsil uložiť súbor s konfiguráciou do koreňového adresára inštalácie Moodle.';
$string['database'] = 'Databáza';
$string['databasehead'] = 'Nastavenia databázy';
$string['databasehost'] = 'Databázový server';
$string['databasename'] = 'Názov databázy';
$string['databasepass'] = 'Heslo pre databázu';
$string['databaseport'] = 'Port pre pripojenie k databázi';
$string['databasesocket'] = 'Unixový socket';
$string['databasetypehead'] = 'Vyberte ovládač pre databázu';
$string['databasetypesub'] = 'Moodle podporuje viaceré typy databázových serverov. Kontaktujte administrátora SQL servera, ak neviete, ktorý z nich použiť.';
$string['databaseuser'] = 'Databázový používateľ';
$string['dataroot'] = 'Adresár pre údaje';
$string['datarooterror'] = '\'Adresár pre údaje\', ktorý ste zadali, nemôže byť nájdený alebo vytvorený. Upravte buď cestu alebo vytvorte ten adresár ručne.';
$string['datarootpermission'] = 'Prístupové práva k údajovému adresáru';
$string['datarootpublicerror'] = 'Adresár \'data\', ktorý ste zvolili, je priamo dostupný z webu. Musíte zvoliť iný adresár.';
$string['dbconnectionerror'] = 'Nemohli sme sa pripojiť k vami zadanej databáze. Prosím skontrolujte nastavenia Vašej databázy.';
$string['dbcreationerror'] = 'Chyba pri vytváraní databázy. Ale bolo možné vytvoriť databázu so zadaným menom a jej nastaveniami';
$string['dbhost'] = 'Hosťovský server';
$string['dbpass'] = 'Heslo';
$string['dbport'] = 'Port';
$string['dbprefix'] = 'Predpona tabuliek';
$string['dbtype'] = 'Typ';
$string['directorysettings'] = '<p>Prosím, potvrďte umiestnenie inštalácie Moodle.</p>

<p><b>Web adresa:</b> Špecifikujte celú web adresu, kde bude Moodle umiestnený. Ak sa na túto adresu pristupuje z viacerých url adries, potom vyberte tú, ktorú budú používať Vaši študenti. Na konci nepoužívajte lomítko.</p>

<p><b>Adresár Moodle:</b> Špecifikujte celú cestu k adresáru a tejto inštalácii. Ubezpečte sa, že ste korektne použili veľké a malé písmená.</p>

<p><b>Adresár pre údaje:</b> Potrebujete miesto, kde Moodle bude ukladať prenášané súbory. Tento adresár by mal byť používateľovi webového servera prístupný aj na čítanie, aj na ZAPISOVANIE (zvyčajne \'nobody\' alebo \'apache\'), ale nemalo by sa dať k nemu pristupovať priamo z webu. Inštalátor bude skúšať ho vytvoriť, ak neexistuje.</p>';
$string['directorysettingshead'] = 'Potvrďte prosím adresy tejto inštalácie Moodle.';
$string['directorysettingssub'] = '<b>Webová adresa</b>:
zadajte celú webovú adresu, na ktorej bude Moodle dostupný. Ak sú vaše stránky dostupné na viacerých URL, vyberte z nich tú, ktorú budú vaši študenti používať najčastejšie. Na konci adresy nepíšte lomítko.
<br />
<br />
<b>Adresár Moodle</b>:
zadajte celú cestu k adresáru s touto inštaláciou. Uistite sa, že sú v nej správne uvedené malé/VEĽKÉ písmená.
<br />
<br />
<b>Dátový adresár</b>:
potrebujete diskový priestor, kam bude Moodle ukladať nahrané (uploadované) súbory. K tomuto adresári musí mať proces webového serveru právo na čítanie A ZÁPIS (webový server býva spustený pod užívateľom \'nobody\' alebo \'apache\' alebo podobne). Tento adresár by ale zároveň nemal byť dostupný priamo cez webové rozhranie (môže obsahovať neverejné údaje). Inštalátor bude skúšať ho vytvoriť, ak neexistuje.';
$string['dirroot'] = 'Adresár Moodle';
$string['dirrooterror'] = 'Nastavenia v \'Adresári Moodle\' sú nesprávne - nie je možné nájsť inštaláciu Moodle. Hodnota nižšie bola vynulovaná.';
$string['download'] = 'Stiahnuť';
$string['downloadlanguagebutton'] = 'Stiahnuť jazykový balíček "{$a}"';
$string['downloadlanguagehead'] = 'Stiahnuť jazykový balíček';
$string['downloadlanguagenotneeded'] = 'V inštalácii je možné pokračovať v jazyku "{$a}".';
$string['downloadlanguagesub'] = 'Teraz máte možnosť si stiahnuť si niektorý z jazykových balíčkov Moodle a pokračovať v tomto jazyku.<br /><br />Ak si práve nemôžete alebo nechcete stiahnuť jazykový balíček, bude inštalačný proces pokračovať v angličtine. Jazykové balíčky si budete môcť stiahnuť aj neskôr po ukončení inštalácie.';
$string['doyouagree'] = 'Súhlasíte ? (áno/nie)';
$string['environmenthead'] = 'Kontrola programového prostredia...';
$string['environmentsub'] = 'Teraz sa preveruje, či vybrané komponenty vášho systému splňujú požiadavky inštalácie.';
$string['environmentsub2'] = 'Každé vydanie Moodle vyžaduje určitú minimálnu verziu PHP a niekoľko povinných rozšírení PHP. Plná kontrola prostredia sa vykonáva pred každou inštaláciou a aktualizáciou. Prosím, kontaktujte správcu servera, ak neviete, ako nainštalovať novú verziu, alebo povoliť rozšírenia PHP.';
$string['errorsinenvironment'] = 'Kontrola programového prostredia zlyhala!';
$string['fail'] = 'Neúspešné';
$string['fileuploads'] = 'Nahrávanie súborov';
$string['fileuploadserror'] = 'Toto by malo byť zapnuté';
$string['fileuploadshelp'] = '<p>Zdá sa, že na Vašom serveri nie je aktivovaný prenos súborov.</p>

<p>Moodle môže byť aj napriek tomu nainštalovaný, ale bez tejto možnost, nebudete schopní preniesť súbory kurzu, alebo obrázky v nových používateľských profiloch.</p>

<p>Na aktivovanie prenosu súborov, Vy (alebo Váš systémový administrátor) budete musieť upraviť hlavný súbor php.ini súbor v systéme a zmeniť nastavenie pre <b>file_uploads</b> na \'1\'.</p>';
$string['inputdatadirectory'] = 'Adresár údajov :';
$string['inputwebadress'] = 'Webová adresa :';
$string['inputwebdirectory'] = 'Moodle adresár :';
$string['installation'] = 'Inštalácia';
$string['invaliddbprefix'] = 'Neplatná predpona. Predpona sa môže skladať iba z malých písmen a podtrhovníka.';
$string['langdownloaderror'] = 'Bohužiaľ, jazyk "{$a}" sa nepodarilo nainštalovať. Inštalácia bude pokračovať v angličtine.';
$string['langdownloadok'] = 'Podarilo so úspešne nainštalovať jazykový balíček "{$a}". Inštalácia bude pokračovať v tomto jazyku.';
$string['memorylimit'] = 'Limit pamäte';
$string['memorylimiterror'] = 'PHP limit pamäte je nastavený na minimum...S týmto môžete mať neskôr problémy.';
$string['mysqliextensionisnotpresentinphp'] = 'PHP nebolo správne nakonfigurované s rozšírením MySQLi, aby mohlo komunikovať s MySQL. Skontrolujte svoj súbor php.ini alebo prekompilujte PHP.';
$string['nativeauroramysql'] = 'Aurora MySQL (native/auroramysql)';
$string['nativeauroramysqlhelp'] = '<p> Databáza je miestom, kde je uložená väčšina nastavení a údajov Moodle a musí tu byť nakonfigurovaná. </p>
<p> Názov databázy, používateľské meno a heslo sú povinné polia; predpona tabuľky je voliteľná. </p>
<p> Názov databázy môže obsahovať iba alfanumerické znaky, dolár ($) a podtrhovník (_). </p>
<p> Ak databáza aktuálne neexistuje a Vami zadaný používateľ má oprávnenie, Moodle sa pokúsi vytvoriť novú databázu so správnymi oprávneniami a nastavením. </p>
<p> Tento ovládač nie je kompatibilní so starším modulom MyISAM. </p>';
$string['nativemariadb'] = 'MariaDB (native/mariadb)';
$string['nativemariadbhelp'] = '<p>Teraz je treba nakonfigurovať databázu, kde bude uložená väčšina údajov Moodle.</p>
<p>Databáza bude vytvorená, ak má používateľ s daným menom a heslom potrebné oprávnenia. Predpona názvov tabuliek je voliteľná.</p>
<p>Názov databázy môže obsahovať iba alfanumerické znaky, dolár ($) a podtrhovník (_).</p>
<p>Ak databáza v súčasnosti neexistuje a určený používateľ má oprávnenia, Moodle sa pokúsi vytvoriť novú databázu so správnym oprávnením a nastavením.</p>
<p>Tento ovládač nie je kompatibilný s predošlým engine MyISAM.</p>';
$string['nativemysqli'] = 'Vylepšená MySQL (natívne / mysqli)';
$string['nativemysqlihelp'] = '<p>Teraz je potrebné nakonfigurovať databázu, kde sa ukladajú Moodle nastavenia a údaje.</p>
<p>Povinné sú názov databázy, používateľ a heslo. Voliteľná je predpona názvov databázových tabuliek.</p>
<p>Názov databázy môže obsahovať iba alfanumerické znaky, dolár ($) a podtrhovník (_).</p>
<p>Ak v súčasnosti databáza neexistuje a daný používateľ má oprávnenia, Moodle sa pokúsi vytvoriť novú s správnymi oprávneniami a nastaveniami.</p>';
$string['nativepgsql'] = 'PostgreSQL (native/pgsql)';
$string['nativepgsqlhelp'] = '<p>Teraz je potrebné nakonfigurovať databázu, kde sa ukladajú Moodle nastavenia a údaje.</p> <p>Povinné sú názov databázy, používateľ, heslo a predpona názvov databázových tabuliek.</p>
<p>Databáza musí existovať a daný používateľ musí mať oprávnenia na čítanie a zápis.</p>';
$string['nativesqlsrv'] = 'SQL*Server Microsoft (native/sqlsrv)';
$string['nativesqlsrvhelp'] = 'Teraz je potrebné nakonfigurovať databázu, kam bude Moodle ukladať dáta. Databáza, spolu s menom a heslom musí byť už vytvorená. Predpona tabuliek je povynná.';
$string['nativesqlsrvnodriver'] = 'Microsoft ovládače pre SQL server pre PHP nie sú nainštalované alebo správne nastavené.';
$string['pass'] = 'Prejsť';
$string['paths'] = 'Cesty';
$string['pathserrcreatedataroot'] = 'Inštalátor nemôže vytvoriť dátový adresár ({$a->dataroot}). ';
$string['pathshead'] = 'Vytvoriť cesty';
$string['pathsrodataroot'] = 'Kmeňový adresár nie je zapisovateľný';
$string['pathsroparentdataroot'] = 'Nadriadený adresár ({$a->parent}) nie je zapisovateľný. Inštalátor nemôže vytvoriť dátový adresár ({$a->dataroot}). ';
$string['pathssubadmindir'] = 'Na niektorých serveroch je URL adresa /admin vyhradená pre špeciálne účely (napr. pre ovládací panel). Na takých serveroch môže dojsť ku kolízii so štandardným umiestnením stránok pre administratívu Moodle. Ak máte tento problém, premenujte adresár <em>admin</em> vo vašej inštalácii Moodle a sem zadajte jeho nový názov - napríklad <em>moodleadmin</em>. Všetky generované odkazy na stránky správy Moodle budú používať tento nový názov.';
$string['pathssubdataroot'] = '<p>Potrebujete adresár, kam Moodle bude ukladať nahrané súbory.</p>
<p>Adresár by mal povoliť čítanie a zapisovanie údajov používateľom web serveru (webový server býva väčšinou spustený pod používateľom "www-data" alebo "apache"), ale nesmie byť prístupný priamo cez web rozhranie. Pokiaľ ešte neexistuje, inštalácia sa pokúsi o jeho vytvorenie. </p>';
$string['pathssubdirroot'] = '<p>Absolútna cesta adresára Moodle inštalácie.</p>';
$string['pathssubwwwroot'] = '<p>Zadajte úplnú webovú adresu, na ktorej bude Moodle dostupný, t.j. adresa, ktorú zadajú používatelia do adresného riadku svojho prehliadača, aby spustili Moodle.</p>
<p>Moodle potrebuje jedinečnú adresu, nie je možné ho prevádzkovať na niekoľkých URL súčasne. Ak používate niekoľko verejných domén, musíte si sami nastaviť permanentné presmerovanie na jednu z nich a tú potom použiť.</p>
<p> Ak je váš server dostupný z vonkajšej a vnútornej siete pod rôznymi IP adresami, použite jeho verejnú adresu a nastavte si váš DNS server tak, že ju môžu používať aj používatelia z vnútornej siete.</p>
<p>Ak nie je aktuálna adresa správna, zmeňte URL adresu v adresnom riadku prehliadača a spusťte inštaláciu.</p>';
$string['pathsunsecuredataroot'] = 'Umiestnenie dátového adresára nie je bezpečné';
$string['pathswrongadmindir'] = 'Administrátorský adresár neexistuje';
$string['pgsqlextensionisnotpresentinphp'] = 'PHP nebolo správne nakonfigurované s PGSQL rozšírením, a tak nemôže komunikovať s PostgreSQL. Prosím, skontrolujte si Váš php.ini súbor alebo znovu vytvorte PHP.';
$string['phpextension'] = 'Rozšírenie PHP {$a}';
$string['phpversion'] = 'Verzia PHP';
$string['releasenoteslink'] = 'Pre viac informácií o tejto verzii Moodle viď poznámky k vydaniu tu: {$a}';
$string['safemode'] = 'Bezpečný mód';
$string['safemodeerror'] = 'Moodle môže mať problémy, ak je zapnutý bezpečný mód';
$string['safemodehelp'] = '<p>Moodle môže mať viacero problémov, ak je zapnutý bezpečný mód, pravdepodobne nedovolí vytvárať nové súbory.</p>

<p>Bezpečný mód je zvyčajne povolený iba paranoidnými verejnými poskytovateľmi webového priestoru, takže by ste si mali nájsť nového poskytovateľa webového priestoru pre stránku Moodle.</p>

<p>Môžete skúsiť pokračovať v inštalácii, ale pripravte sa na problémy.</p>';
$string['sessionautostart'] = 'Autoštart sekcie';
$string['sessionautostarterror'] = 'Toto by malo byť vypnuté';
$string['sessionautostarthelp'] = '<p>Moodle vyžaduje podporu sekcií a nebude bez nich fungovať.</p>';
$string['sqliteextensionisnotpresentinphp'] = 'PHP nebolo správne nakonfigurované pre rozšírenie PHP. Prosím skontrolujte váš súbor php.ini alebo rekompilujte PHP.';
$string['upgradingqtypeplugin'] = 'Aktualizácia modulu typu otázky';
$string['welcomep10'] = '{$a->installername} ({$a->installerversion})';
$string['welcomep20'] = 'Podarilo so vám úspešne nainštalovať a spustiť balíček <strong>{$a->packname} {$a->packversion}</strong>. Gratulujeme!';
$string['welcomep30'] = 'Táto verzia <strong>{$a->installername}</strong> obsahuje aplikáciu k vytvoreniu prostredia, v ktorom bude prevádzkovaný váš <strong>Moodle</strong>. Menovite sa jedná o:';
$string['welcomep40'] = 'Balíček tiež obsahuje <strong>Moodle vo verzii {$a->moodlerelease} ({$a->moodleversion})</strong>.';
$string['welcomep50'] = 'Použitie všetkých aplikácií v tomto balíčku je viazané ich príslušnými licenciami. Kompletný balíček <strong>{$a->installername}</strong> je software s <a href="http://www.opensource.org/docs/definition_plain.html"> otvoreným kódom (open source)</a> a je šírený pod licenciou <a href="http://www.gnu.org/copyleft/gpl.html">GPL</a>.';
$string['welcomep60'] = 'Nasledujúce stránky vás povedú v nekoľkých jednoduchých krokoch nastavením <strong>Moodle</strong> na vašom počítači. Môžete prijať východzie nastavenie, alebo si ich upraviť podľa svojich potrieb.';
$string['welcomep70'] = 'Stlačením nižšie uvedeného tlačidla "Ďalší" pokračujte v nastavení vašej inštalácie Moodle.';
$string['wwwroot'] = 'Web adresa';
$string['wwwrooterror'] = 'Táto web adresa pravdepodobne nie je platná - táto inštalácia Moodle tu pravdepodobne nie je.';
