<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'assign', language 'no', version '5.0'.
 *
 * @package     assign
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['activityattachments'] = 'Oppgaveaktivitetsvedlegg';
$string['activitydate:submissionsdue'] = 'Forfall:';
$string['activitydate:submissionsopen'] = 'Åpner:';
$string['activitydate:submissionsopened'] = 'Åpnet:';
$string['activityeditor'] = 'Aktivitetsinstruksjoner';
$string['activityeditor_help'] = 'Handlingene du vil at studenten skal utføre for denne oppgaven. Dette vises kun på innleveringssiden der en student redigerer og sender inn oppgaven.';
$string['activityoverview'] = 'Du har innleveringer som behøver din oppmerksomhet.';
$string['addattempt'] = 'Tillat et nytt forsøk';
$string['addnewattempt'] = 'Legg til et nytt forsøk';
$string['addnewattempt_help'] = 'Dette oppretter en ny tom innlevering som du kan jobbe med.';
$string['addnewattemptfromprevious'] = 'Legg til et nytt forsøk basert på forrige innlevering';
$string['addnewattemptfromprevious_help'] = 'Dette kopierer innholdet fra din forrige innlevering til en ny innlevering som du kan jobbe videre med.';
$string['addnewgroupoverride'] = 'Legg til gruppeoverstyring';
$string['addnewuseroverride'] = 'Legg til brukeroverstyring';
$string['addsubmission'] = 'Legg til innlevering';
$string['addsubmission_help'] = 'Du har ikke levert noe ennå.';
$string['allocatedmarker'] = 'Tildelt markør';
$string['allocatedmarker_help'] = 'Markør tildelt til denne innleveringen.';
$string['allowsubmissions'] = 'Tillat brukeren å fortsette og levere inn besvarelser til denne innleveringen.';
$string['allowsubmissionsfromdate'] = 'Tillat innsending fra';
$string['allowsubmissionsfromdate_help'] = 'Hvis denne funksjonen er aktivert, kan ikke studentene levere før denne datoen. Hvis den er deaktivert, kan studentene levere inn med en gang.';
$string['allowsubmissionsshort'] = 'Tillat endring av innsending';
$string['alwaysshowdescription'] = 'Vis alltid beskrivelse';
$string['alwaysshowdescription_help'] = 'Hvis denne funksjonen er deaktivert, blir innleveringsbeskrivelsen ovenfor først bli synlig for studentene på "Tillat innleveringer fra"-datoen.';
$string['applytoteam'] = 'Gjør karakterer og tilbakemeldinger gjeldende for helle gruppen';
$string['assign:addinstance'] = 'Legg til ny innlevering';
$string['assign:editothersubmission'] = 'Rediger en annen students innlevering';
$string['assign:exportownsubmission'] = 'Eksporter din innlevering';
$string['assign:grade'] = 'Karaktergivere';
$string['assign:grantextension'] = 'Gi utsettelse';
$string['assign:manageallocations'] = 'Administrer karaktersettere for denne innleveringen.';
$string['assign:managegrades'] = 'Forhåndsvis og publiser karakterer';
$string['assign:manageoverrides'] = 'Administrer innleveringsoverstyringer';
$string['assign:receivegradernotifications'] = 'Motta varsler om karaktersatte innleveringer';
$string['assign:releasegrades'] = 'Publiser karakterer';
$string['assign:revealidentities'] = 'Vis studentenes identitet';
$string['assign:reviewgrades'] = 'Forhåndsvis karakterer';
$string['assign:showhiddengrader'] = 'Se identiteten til den skjulte karaktergiveren.';
$string['assign:submit'] = 'Send inn oppgavesvaret';
$string['assign:view'] = 'Se på oppgave';
$string['assign:viewblinddetails'] = 'Vis brukernes identitet når anonym innlevering er aktivert.';
$string['assign:viewgrades'] = 'Se karakterer';
$string['assign:viewownsubmissionsummary'] = 'Se egen oversikt over innsendinger';
$string['assignfeedback'] = 'Tilbakemeldingsmodul';
$string['assignfeedbackpluginname'] = 'Tilbakemeldingsmodul';
$string['assignmentduedigesthtml'] = '<p>Hei {$a->firstname},</p>
<p>Følgende innleveringer må leveres innen <strong>{$a->duedate}</strong>.</p>
{$a->digest}';
$string['assignmentduedigestitem'] = '<strong>{$a->assignmentname}</strong> i kurs {$a->coursename}<br/>
<strong>Frist: {$a->duetime}</strong><br/>
<a href="{$a->url}" aria-label="Gå til {$a->assignmentname}">Gå til innlevering</a>';
$string['assignmentduedigestsms'] = 'En eller flere oppgaver må leveres inn om en uke. Logg inn for å se oppgavene det gjelder.';
$string['assignmentduedigestsubject'] = 'Du har innleveringer som må leveres innen 7 dager';
$string['assignmentduesoonhtml'] = '<p>Hei {$a->firstname},</p>
<p>Innleveringen <strong>{$a->assignmentname}</strong> i kurset {$a->coursename} må snart leveres inn.</p>
<p><strong>Frist: {$a->duedate}</strong></p>
<p><a href="{$a->url}">Gå til innlevering</a></p>';
$string['assignmentduesoonsms'] = 'Innleveringsoppgaven {$a->assignmentname} må leveres innen {$a->duedate}: {$a->url}';
$string['assignmentduesoonsubject'] = 'Frist {$a->duedate}: {$a->assignmentname}';
$string['assignmentisdue'] = 'Frist for innlevering';
$string['assignmentmail'] = '{$a->grader} har lagt ut en tilbakemelding på din innlevering for \'{$a->assignment}\'.

Du kan se tilbakemeldingen her: {$a->url}';
$string['assignmentmailhtml'] = '<p>{$a->grader} har lagt ut en tilbakemelding på din innlevering til \'{$a->assignment}\'</p>
<p>Du kan se tilbakemeldingen <a href="{$a->url}">her</a>.</p>';
$string['assignmentmailsmall'] = '{$a->grader} har lagt ut en tilbakemelding på din innlevering for \'{$a->assignment}\'.

Den er lagt til innleveringen din.';
$string['assignmentname'] = 'Oppgavenavn';
$string['assignmentoverduehtml'] = '<p>Hei {$a->firstname},</p>
<p><strong>{$a->assignmentname}</strong> i kurs {$a->coursename} skulle leveres <strong>{$a->duedate}</strong>.</p>
<p>Du kan fortsatt levere oppgaven inntil {$a->cutoffsnippet}, men den vil bli markert som levert for sent.</p>
<p><a href="{$a->url}">Gå til innlevering</a></p>';
$string['assignmentoverduehtmlcutoffsnippet'] = '<strong>av {$a->cutoffdate}</strong>';
$string['assignmentoverduesms'] = 'Innleveringsoppgaven {$a->assignmentname} må leveres innen {$a->duedate}: {$a->url}';
$string['assignmentoverduesubject'] = 'Forfalt: {$a->assignmentname}';
$string['assignmentplugins'] = 'Oppgavemoduler';
$string['assignmentsperpage'] = 'Oppgaver pr. side';
$string['assignsubmission'] = 'Innsendingsmodul';
$string['assignsubmissionpluginname'] = 'Innsendingsmodul';
$string['assigntimeleft'] = 'Tid igjen';
$string['attemptheading'] = 'Forsøk {$a->attemptnumber}: {$a->submissionsummary}';
$string['attempthistory'] = 'Tidligere forsøk';
$string['attemptnumber'] = 'Forsøk nummer';
$string['attemptreopenmethod'] = 'Tildel forsøk';
$string['attemptreopenmethod_automatic'] = 'Automatisk';
$string['attemptreopenmethod_automatic_help'] = 'Nye forsøk gis automatisk etter at forrige forsøk er vurdert.';
$string['attemptreopenmethod_help'] = 'Denne innstillingen avgjør om en student kan gjøre flere forsøk på oppgaven. For hvert forsøk lagres karakteren og tilbakemeldingen, og kan sees av læreren og eleven. De tilgjengelige alternativene er:

* Manuelt - Ytterligere forsøk kan tildeles av en lærer.
* Automatisk - Nye forsøk gis automatisk etter at forrige forsøk er vurdert.
* Automatisk til bestått - Ytterligere forsøk tildeles automatisk til studenten oppnår bestått.';
$string['attemptreopenmethod_manual'] = 'Manuelt';
$string['attemptreopenmethod_manual_help'] = 'Etter hvert forsøk kan du tildele nye forsøk via vurderings- eller oversiktssiden.';
$string['attemptreopenmethod_none'] = 'Aldri';
$string['attemptreopenmethod_untilpass'] = 'Tillat nytt forsøk helt til innleveringen er bestått';
$string['attemptreopenmethod_untilpass_help'] = 'Etter hvert forsøk bli det neste tildeles automatisk helt til deltakeren oppnår ståkarakteren.';
$string['attemptsettings'] = 'Forsøksinnstillinger';
$string['availability'] = 'Tilgjengelighet';
$string['back'] = 'Tilbake';
$string['backtoassignment'] = 'Tilbake til innleveringen';
$string['batchoperationaddattempt'] = 'Gi forsøk';
$string['batchoperationconfirmaddattempt'] = 'Tillat et forsøk til for valgte innleveringer?';
$string['batchoperationconfirmdownloadselected'] = 'Laste ned valgte innleveringer?';
$string['batchoperationconfirmgrantextension'] = 'Gi utsettelse til alle valgte innleveringer?';
$string['batchoperationconfirmlock'] = 'Skal alle valgte innsendinger låses?';
$string['batchoperationconfirmremovesubmission'] = 'Fjern valgte innleveringer';
$string['batchoperationconfirmreverttodraft'] = 'Gjøre om de valgte innleveringene til utkast?';
$string['batchoperationconfirmsetmarkingallocation'] = 'Angi tildeling av oppgaver for alle valgte innleveringer?';
$string['batchoperationconfirmsetmarkingworkflowstate'] = 'Angi status for arbeidsflyt for vurdering for alle valgte  innleveringer?';
$string['batchoperationconfirmunlock'] = 'Låse opp alle de valgte innleveringene?';
$string['batchoperationdownloadselected'] = 'Last ned';
$string['batchoperationgrantextension'] = 'Utvid';
$string['batchoperationlock'] = 'Lås';
$string['batchoperationremovesubmission'] = 'Slett';
$string['batchoperationreverttodraft'] = 'Tilbakestill til kladd';
$string['batchoperationsdescription'] = 'Med valgte...';
$string['batchoperationsetmarkingallocation'] = 'Tildel karaktergiver';
$string['batchoperationsetmarkingworkflowstate'] = 'Endre vurderingsstatus';
$string['batchoperationunlock'] = 'Lås opp';
$string['batchsetallocatedmarker'] = 'Angi tildeling for vurdering for {$a} valgte brukere.';
$string['batchsetmarkingworkflowstateforusers'] = 'Angi status for vurderingsarbeidsflyt for {$a} valgte brukere.';
$string['beginassignment'] = 'Begynn oppgaven';
$string['blindmarking'] = 'Anonyme innleveringer';
$string['blindmarking_help'] = 'Anonym innlevering skjuler studentenes identitet for den som setter karakter. Innstillingene for anonym innlevering låses når en innlevering eller karakter er utført i forbindelse med denne oppgaven.';
$string['blindmarkingenabledwarning'] = 'Anonyme innleveringer er aktivert for denne aktiviteten.';
$string['blindmarkingnogradewarning'] = 'Anonyme innleveringer er aktivert for denne aktiviteten. Karakterer blir ikke lagt til i karakterboken før studentidentiteten avsløres via handlingsmenyen.';
$string['bulkactionsselection'] = 'Massehandlingsutvalg';
$string['cachedef_overrides'] = 'Bruker- og gruppeoverstyringsinformasjon';
$string['calendardue'] = '{$a} må leveres';
$string['calendarextension'] = '{$a} forfaller (utvidet frist)';
$string['calendargradingdue'] = '{$a} må vurderes';
$string['caneditsubmission'] = 'Du kan sende inn/redigere innlevering etter at fristen er gått, men den vil bli merket som for sent.';
$string['changefilters'] = 'Endre filtere';
$string['changeuser'] = 'Endre bruker';
$string['choosegradingaction'] = 'Handling for karaktersetting';
$string['choosemarker'] = 'Velg...';
$string['chooseoperation'] = 'Velg handling';
$string['clickexpandreviewpanel'] = 'Klikk for å utvide gjennomgangspanelet';
$string['collapsegradepanel'] = 'Minimer karakterpanelet';
$string['collapsereviewpanel'] = 'Minimer gjennomgangspanelet';
$string['comment'] = 'Kommentar';
$string['completiondetail:submit'] = 'Lag en innlevering';
$string['completionsubmit'] = 'Lag en innsending';
$string['configshowrecentsubmissions'] = 'Alle kan se merknader til innleveringer i de siste aktivitetsrapporter.';
$string['confirmbatchgradingoperation'] = 'Er du sikker på at du vil {$a->operation} for {$a->count} studenter?';
$string['confirmstart'] = 'Du har {$a} for å fullføre denne oppgaven. Når du begynner, vil tidtakeren begynne å telle ned og kan ikke settes på pause.';
$string['confirmsubmission'] = 'Er du sikker på at du vil levere inn arbeidet ditt til vurdering? Da kan du ikke gjøre flere endringer.';
$string['confirmsubmissionheading'] = 'Bekreft innlevering';
$string['conversionexception'] = 'Kunne ikke konvertere innleveringen. Unntaket var: {$a}.';
$string['couldnotconvertgrade'] = 'Kunne ikke konvertere innleveringskarakteren til bruker {$a}.';
$string['couldnotconvertsubmission'] = 'Kunne ikke konvertere innleveringen til bruker {$a}.';
$string['couldnotcreatecoursemodule'] = 'Kunne ikke opprette kursmodulen.';
$string['couldnotcreatenewassignmentinstance'] = 'Kunne ikke opprette ny innleveringsinstans.';
$string['couldnotfindassignmenttoupgrade'] = 'Kunne ikke finne noen gammel innleveringsinstanse å oppgradere.';
$string['crontask'] = 'Bakgrunnsprosessering for innleveringsmodulen.';
$string['currentassigngrade'] = 'Nåværende karakter i oppgave';
$string['currentattempt'] = 'Dette er forsøk {$a}.';
$string['currentattemptof'] = 'Dette er forsøk {$a->attemptnumber} ( {$a->maxattempts} forsøk tillatt ).';
$string['currentgrade'] = 'Nåværende karakter i karakterboka';
$string['cutoffdate'] = 'Siste dato for innlevering';
$string['cutoffdate_help'] = 'Hvis denne funksjonen brukes, vil ikke innleveringen godta innsendinger etter denne datoen uten forlengelse.';
$string['cutoffdatecolon'] = 'Stopp-dato: {$a}';
$string['cutoffdatefromdatevalidation'] = 'Siste dato for innlevering må være etter åpningsdatoen for innleveringer.';
$string['cutoffdatevalidation'] = 'Siste dato for innlevering må være etter innleveringsfristen.';
$string['defaultgradescale'] = 'Karakterskala';
$string['defaultgradescale_help'] = 'Standard karakterskala for nye innleveringer.';
$string['defaultgradetype'] = 'Karaktertype';
$string['defaultgradetype_help'] = 'Standard karaktertype for nye innleveringer';
$string['defaultlayout'] = 'Tilbakestil til standardoppsettet';
$string['defaultsettings'] = 'Standardinnstillinger for innleveringsmodulen';
$string['defaultsettings_help'] = 'Disse innstillingene bestemmer standardinnstillingene for alle nye innleveringer.';
$string['defaultteam'] = 'Standardgruppe';
$string['deleteallsubmissions'] = 'Slett alle innleveringer';
$string['description'] = 'Beskrivelse';
$string['disabled'] = 'Deaktivert';
$string['downloadall'] = 'Last ned alle innsendinger';
$string['downloadasfolders'] = 'Last ned innleveringene i separate mapper';
$string['downloadasfolders_help'] = 'Innleveringer kan lastes ned som mapper. Hver innlevering plasseres da i egne mapper og filstrukturen beholdes for eventuelle undermapper. Filene vil beholde filnavnene.';
$string['downloadselectedsubmissions'] = 'Last ned valgte innleveringer';
$string['duedate'] = 'Innleveringsfrist';
$string['duedate_help'] = 'Dette er fristen for innleveringen. Hvis for sene innleveringer tillates, vil alle besvarelser som er levert inn etter denne datoen merkes som forsinket. Angi en siste frist for å forhindre innleveringer etter siste frist.';
$string['duedateaftersubmissionvalidation'] = 'Fristen må være etter datoen for å tillate innleveringer.';
$string['duedatecolon'] = 'Frist: {$a}';
$string['duedatereached'] = 'Fristen for denne innleveringen har passert.';
$string['duedatevalidation'] = 'Innleveringsfristen må være etter innleveringens åpningsdato.';
$string['duplicateoverride'] = 'Dupliser overstyring';
$string['editaction'] = 'Handlinger...';
$string['editattemptfeedback'] = 'Rediger karakteren og tilbakemeldingen for forsøk nummer {$a}';
$string['editingpreviousfeedbackwarning'] = 'Du redigerer tilbakemeldingen til et tidligere forsøk. Dette er forsøk {$a->attemptnumber} av {$a->totalattempts}.';
$string['editingstatus'] = 'Redigerer status';
$string['editonline'] = 'Rediger online';
$string['editoverride'] = 'Rediger overstyringer';
$string['editsubmission'] = 'Rediger innleveringen';
$string['editsubmission_help'] = 'Du kan fortsatt gjøre endringer på din innlevering';
$string['editsubmissionother'] = 'Rediger innlevering for {$a}';
$string['enabled'] = 'Aktivert';
$string['enabletimelimit'] = 'Aktivér tidsbegrensede oppgaver';
$string['enabletimelimit_help'] = 'Hvis den er aktivert, kan du angi en tidsbegrensning på siden for oppgavesinnstillinger.';
$string['errorgradechangessaveddetail'] = 'Endringene til karakter og tilbakemelding ble ikke lagret';
$string['errornosubmissions'] = 'Det er ingen innleveringer å laste ned';
$string['errorquickgradingvsadvancedgrading'] = 'Karakterene ble ikke lagret fordi denne innleveringen bruker avansert karaktersetting.';
$string['errorrecordmodified'] = 'Karakterene ble ikke lagret fordi noen har endret en eller flere oppføringer siden du lastet siden.';
$string['eventallsubmissionsdownloaded'] = 'Alle innleveringene bli lastet ned.';
$string['eventassessablesubmitted'] = 'En innlevering har blitt levert inn.';
$string['eventbatchsetmarkerallocationviewed'] = 'Innstillinger for automatisk karaktersetting vist';
$string['eventbatchsetworkflowstateviewed'] = 'Innstillinger for automatisk arbeidsflyt vist';
$string['eventextensiongranted'] = 'Det har blitt gitt en utsettelse.';
$string['eventfeedbackupdated'] = 'Feedback er oppdatert';
$string['eventfeedbackviewed'] = 'Feedback er vist';
$string['eventgradingformviewed'] = 'Vurderingsskjema vist';
$string['eventgradingtableviewed'] = 'Vurderingstabell vist';
$string['eventidentitiesrevealed'] = 'Alle identitene har blitt avslørt.';
$string['eventmarkerupdated'] = 'Oppgavetildelingen er oppdatert.';
$string['eventoverridecreated'] = 'Innleveringsoverstyring opprettet';
$string['eventoverridedeleted'] = 'Innleveringsoverstyring slettet';
$string['eventoverrideupdated'] = 'Innleveringsoverstyring slettet';
$string['eventremovesubmissionformviewed'] = 'Fjern innleveringsbekreftelse vist.';
$string['eventrevealidentitiesconfirmationpageviewed'] = 'Bekreftelsesside for avsløring av brukerindentiteter vist';
$string['eventstatementaccepted'] = 'Brukeren har akseptert innleveringserklæringen';
$string['eventsubmissionconfirmationformviewed'] = 'Bekreftelsesside for innleveringsskjema vist';
$string['eventsubmissioncreated'] = 'Innlevering opprettet';
$string['eventsubmissionduplicated'] = 'Brukeren duplikerte innleveringen sin';
$string['eventsubmissionformviewed'] = 'Innleveringsskjema vist';
$string['eventsubmissiongraded'] = 'Det har blitt satt en karakter på innleveringen.';
$string['eventsubmissionlocked'] = 'Innleveringen har blitt låst for en bruker';
$string['eventsubmissionremoved'] = 'Innlevering fjernet';
$string['eventsubmissionstatusupdated'] = 'Innleveringsstatusen har blitt oppdatert';
$string['eventsubmissionstatusviewed'] = 'Innleveringsstatus har blitt sett.';
$string['eventsubmissionunlocked'] = 'Innleveringen har blitt låst opp for en bruker.';
$string['eventsubmissionupdated'] = 'Brukeren har lagret en innlevering';
$string['eventsubmissionviewed'] = 'Innlevering sett.';
$string['eventworkflowstateupdated'] = 'Status for vurderingsarbeidsflyt er oppdatert.';
$string['expandreviewpanel'] = 'Utvid gjennomgangspanel';
$string['extensionduedate'] = 'Frist for forlengelse';
$string['extensionduedatecurrent'] = 'Frist etter utsettelse';
$string['extensionduedatenone'] = 'Ingen';
$string['extensionduedaterange'] = 'Varierendee mellom {$a->earliest} og {$a->latest}';
$string['extensionduedatewithout'] = 'Brukere uten aktiv utsettelse: {$a}';
$string['extensionnotafterduedate'] = 'Frist for forlengelse må være etter ordinær frist.';
$string['extensionnotafterfromdate'] = 'Frist for forlengelse må være etter åpningsdatoen for innleveringer.';
$string['feedback'] = 'Tilbakemelding';
$string['feedbackavailableanonhtml'] = 'Du har tilbakemeldinger på innleveringen din for {$a->assignment}\'
Du kan se den som vedlegg til <a href="{$a->url}">innleveringen</a>.';
$string['feedbackavailableanonsmall'] = 'Ny tilbakemelding for innleveringen {$a->assignment}';
$string['feedbackavailableanonsms'] = 'Ny tilbakemelding på oppgaven {$a->assignment} i {$a->coursefullname}. Logg inn for å se den.';
$string['feedbackavailableanontext'] = 'Du har fått en ny tilbakemelding på innleveringen din for \'{$a->assignement}\'

Du kan se den her: {$a->url}';
$string['feedbackavailablehtml'] = '{$a->username} har postet tilbakemeldinger på innleveringen din for \'{$a->assignment}\'. Du kan se tilbakemeldingen <a href="{$a->url}">her</a>.';
$string['feedbackavailablesmall'] = '{$a->username} har gitt tilbakemelding på innleveringen {$a->assignment}';
$string['feedbackavailablesms'] = 'Ny tilbakemelding på oppgaven {$a->assignment} i {$a->coursefullname}. Logg inn for å se den.';
$string['feedbackavailabletext'] = '{$a->username} har postet en tilbakemelding på innleveringen for \'{$a->assignment}\'

Du kan se tilbakemeldingen her: {$a->url}';
$string['feedbackplugin'] = 'Tilbakemeldingsmodul';
$string['feedbackpluginforgradebook'] = 'Modul for tilbakemeldinger som vil presse kommentarer til karakterboken.';
$string['feedbackpluginforgradebook_help'] = 'Bare en modul for tilbakemeldinger kan flytte tilbakemeldinger inn i karakterboken.';
$string['feedbackplugins'] = 'Tilbakemeldingsmoduler';
$string['feedbacksettings'] = 'Innstillinger for tilbakemelding';
$string['feedbacktypes'] = 'Tilbakemeldingstyper';
$string['filesubmissions'] = 'Filinnsendiger';
$string['filter'] = 'Filter';
$string['filterall'] = 'Alle';
$string['filterdraft'] = 'Kladd';
$string['filtergraded'] = 'Vurdert';
$string['filtergrantedextension'] = 'Innvilget utsettelse';
$string['filternone'] = 'Ingen filter';
$string['filternotsubmitted'] = 'Ikke levert';
$string['filterrequiregrading'] = 'Ikke vurdert ennå';
$string['filtersubmitted'] = 'Levert';
$string['fixrescalednullgrades'] = 'Innleveringen inneholder noen karakterer med feil. Du kan  <a href="{$a->link}"> automatisk fikse disse feilene. </a> Dette kan få betydning for beregning av kurstotaler.';
$string['fixrescalednullgradesconfirm'] = 'Er du sikker på at du vil fikse karakter med feil automatisk? Alle berørte karakterer blir fjernet. Dette kan få betydning for beregning av kurstotaler.';
$string['fixrescalednullgradesdone'] = 'Karakterer fikset.';
$string['gradeabovemaximum'] = 'Karakteren må være mindre enn eller lik {$a}.';
$string['gradeactions'] = 'Vurderingshandlinger';
$string['gradebelowzero'] = 'Karakteren må være høyere enn eller lik null.';
$string['gradebreakdown'] = 'Detaljert karakteroversikt';
$string['gradecanbechanged'] = 'Karakter kan endres';
$string['gradechangessaveddetail'] = 'Endringene i vurdering og tilbakemelding ble lagret';
$string['graded'] = 'Karaktersatt';
$string['gradedby'] = 'Vurdert av';
$string['gradedfollowupsubmit'] = 'Vurdert - oppfølgingsinnlevering mottatt';
$string['gradedon'] = 'Vurdert den';
$string['gradeitem:submissions'] = 'Innleveringer';
$string['gradelocked'] = 'Denne karakteren er låst eller overstyrt i karakterboken.';
$string['gradeoutof'] = 'Karakter av {$a} mulige.';
$string['gradeoutofhelp'] = 'Karakter';
$string['gradeoutofhelp_help'] = 'Skriv karakteren på studentens innlevering her. Du kan bruke desimaler hvis du ønsker det.';
$string['gradepenalty'] = 'Karaktertrekk';
$string['gradepenalty_help'] = 'Dersom aktivert vil innleveringer levert etter fristen få karaktertrekk';
$string['gradersubmissionupdatedhtml'] = '{$a->username} oppdaterte innleveringsin
for \'{$a->assignment}\'  {$a->timeupdated}.
Den er tilgjengelig i <a href="{$a->url}">innleveringer</a>.';
$string['gradersubmissionupdatedsmall'] = '{$a->username} har oppdatert besvarelsen sin for innleveringen {$a->assignment}.';
$string['gradersubmissionupdatedsms'] = '{$a->username} oppdaterte innleveringen sin for oppgaven {$a->assignment} i {$a->coursefullname}. Logg inn for å se den.';
$string['gradersubmissionupdatedtext'] = '{$a->username} har oppdatert innleveringen sin for \'{$a->assignment}\'  {$a->timeupdated}

Den er tilgjengelig her:

{$a->url}';
$string['gradestudent'] = 'Gi karakter til student: (id={$a->id}, fullname={$a->fullname}).';
$string['gradeuser'] = 'Karakter {$a}';
$string['grading'] = 'Karaktersetting';
$string['gradingchangessaved'] = 'Karakterendringene ble lagret';
$string['gradingduedate'] = 'Påminn meg om å vurdere innen';
$string['gradingduedate_help'] = 'Den forventede datoen for fullføring av karaktersetting/vurdering av innleveringene. Denne datoen brukes til å prioritere startside-varsler for lærere.';
$string['gradingdueduedatevalidation'] = 'Datobasert "minn meg på å vurdere" kan ikke være tidligere enn fristen for innleveringen.';
$string['gradingduefromdatevalidation'] = 'Datobasert "minn meg på å vurdere" kan ikke være tidligere enn fristen for når innleveringer kan starte.';
$string['gradingmethodpreview'] = 'Kriterier for karaktersetting';
$string['gradingoptions'] = 'Innstillinger';
$string['gradingstatus'] = 'Karaktersettingsstatus';
$string['gradingstudent'] = 'Gir karakter til student';
$string['gradingsummary'] = 'Oversikt over karakterer';
$string['grantextension'] = 'Gi forlengelse';
$string['grantextensionforusers'] = 'Gi forlengelse til {$a} studenter';
$string['groupoverrides'] = 'Gruppeoverstyring';
$string['groupoverridesdeleted'] = 'Gruppeoverstyring slettet';
$string['groupsnone'] = 'Det er ingen grupper i dette kurset';
$string['groupsubmissionsettings'] = 'Innstillinger for gruppeinnleveringer';
$string['hiddenuser'] = 'Deltaker';
$string['hidegrader'] = 'Skjul karaktergivers identitet for studentene';
$string['hidegrader_help'] = 'Hvis det er aktivert, vises ikke identiteten til brukeren som bedømmer en oppgaveinnlevering, slik at studentene ikke kan se hvem som vurderte arbeidet.

Merk at denne innstillingen ikke har noen innvirkning på kommentarfeltet på karaktersiden.';
$string['hideshow'] = 'Skjul/Vis';
$string['inactiveoverridehelp'] = '*Deltakeren har ikke den korrekte rollen eller gruppen til å gjennomføre innleveringen';
$string['includesuspendedparticipants'] = 'Inkluder deaktiverte deltakere';
$string['indicator:cognitivedepth'] = 'Kognitiv innlevering';
$string['indicator:cognitivedepth_help'] = 'Denne indikatoren er basert på den kognitive dybden en student oppnår gjennom en innleveringsaktivitet.';
$string['indicator:cognitivedepthdef'] = 'Kognitive ferdigheter';
$string['indicator:cognitivedepthdef_help'] = 'Deltakeren har nådd denne prosentandelen av det kognitive engasjementet som tilbys av oppdragsaktivitetene i løpet av dette analyseintervallet (Nivåer = Ingen visning, Vis, Send, Se tilbakemelding, Kommenter tilbakemelding, Send inn igjen etter å ha sett tilbakemelding)';
$string['indicator:cognitivedepthdef_link'] = 'Learning_analytics_indicators#Cognitive_depth';
$string['indicator:socialbreadth'] = 'Sosial innlevering';
$string['indicator:socialbreadth_help'] = 'Denne indikatoren er basert på den sosiale bredden en student oppnår gjennom en innleveringsaktivitet.';
$string['indicator:socialbreadthdef'] = 'Sosiale ferdigheter';
$string['indicator:socialbreadthdef_help'] = 'Deltakeren har nådd denne prosentandelen av det sosiale engasjementet som tilbys av oppdragsaktivitetene i løpet av dette analyseintervallet (Nivåer = Ingen deltakelse, deltaker alene, deltaker med andre)';
$string['indicator:socialbreadthdef_link'] = 'Learning_analytics_indicators#Social_breadth';
$string['instructionfiles'] = 'Instruksjonsfiler';
$string['introattachments'] = 'Tilleggsfiler';
$string['introattachments_help'] = 'Ytterligere filer for bruk i oppgaven, som svarmaler, kan legges til.';
$string['invalidfloatforgrade'] = 'Den oppgitte karakteren ble ikke forstått: {$a}';
$string['invalidgradeforscale'] = 'Den oppgitte karakteren var ikke gyldig for den gjeldende skalaen.';
$string['invalidoverrideid'] = 'Ugylidg overstyringsID';
$string['lastmodifiedgrade'] = 'Sist endret (karakter)';
$string['lastmodifiedsubmission'] = 'Sist endret (innsending)';
$string['latesubmissions'] = 'Sene innleveringer';
$string['latesubmissionsaccepted'] = 'Tillat inntil {$a}';
$string['loading'] = 'Laster...';
$string['locksubmissionforstudent'] = 'Forhindre flere innleveringer fra student: (id={$a->id}, fullname={$a->fullname}).';
$string['locksubmissions'] = 'Lås innsendinger';
$string['manageassignfeedbackplugins'] = 'Administrere moduler for tilbakemeldinger på innleveringer';
$string['manageassignsubmissionplugins'] = 'Administrere moduler for innsending av innleveringer';
$string['marker'] = 'Karaktersetter';
$string['markerfilter'] = 'Rettefilter';
$string['markerfilternomarker'] = 'Ingen markering';
$string['markingallocation'] = 'Bruk tildeling av oppgaver for vurdering';
$string['markingallocation_help'] = 'Når aktivert vil denne innstillingen gjøre det mulig å tildele studenter individuelt til karaktersetterne. Dette krever at arbeidsflyt for vurdering er aktivert.';
$string['markinganonymous'] = 'Tillat delvis frigivelse av karakterer mens du vurderer anonymt';
$string['markinganonymous_help'] = 'Hvis det er aktivert sammen med anonyme innleveringer og markeringsarbeidsflyt, tillater det delvis frigivelse av karakterer mens du vurderer anonymt.';
$string['markingstate'] = 'Vurderingsstatus';
$string['markingworkflow'] = 'Bruk arbeidsflyt for karaktersetting';
$string['markingworkflow_help'] = 'Hvis aktivert, vil vurderingen foregå som en del av en arbeidsflyt før den publiseres til studentene. Dette åpner for flere runder med vurdering av oppgavene og at endelig vurdering publiseres til studentene til samme tid.';
$string['markingworkflowstate'] = 'Status for arbeidsflyt';
$string['markingworkflowstate_help'] = 'Mulige arbeidsflytstadier kan inkludere (avhengig av dine rettigheter):

* Ikke vurdert - vurderingen har ennå ikke startet.
* Under vurdering - vurderingen pågår, men er ikke avsluttet.
* Til gjennomgang - vurderingen er nå til gjennomgang av en ansvarlig lærer for kvalitetssjekk.
* Klar for publisering - ansvarlig lærer er fornøyd med vurderingen, men vil vente med å publisere resultatene for studentene.
* Publisert - studenten gis tilgang til vurdering og tilbakemelding.';
$string['markingworkflowstateinmarking'] = 'Under retting';
$string['markingworkflowstateinreview'] = 'Blir vurdert';
$string['markingworkflowstatenotmarked'] = 'Ikke vurdert';
$string['markingworkflowstatereadyforrelease'] = 'Klar for publisering';
$string['markingworkflowstatereadyforreview'] = 'Karaktersetting fullført';
$string['markingworkflowstatereleased'] = 'Publisert';
$string['maxattempts'] = 'Tillatte forsøk';
$string['maxattempts_help'] = 'Maks antall innleveringsforsøk som kan gjøres av en student. Etter dette antallet har blitt levert kan ikke studenten gjenåpne innleveringen.';
$string['maxgrade'] = 'Høyeste karakter';
$string['maxperpage'] = 'Maks antall innleveringer pr side';
$string['maxperpage_help'] = 'Maksimum antall innleveringer en som vurderer kan vise samtidig på en vurderingsside. Nyttig når det er veldig mange innleveringer.';
$string['messageprovider:assign_due_digest'] = 'Varsling om innleveringer som må leveres innen 7 dager';
$string['messageprovider:assign_due_soon'] = 'Varsling om at fristen for innlevering snart utløper';
$string['messageprovider:assign_notification'] = 'Innleveringsvarsler';
$string['messageprovider:assign_overdue'] = 'Varsel om forfalt innlevering';
$string['modulename'] = 'Innlevering';
$string['modulename_help'] = 'Aktivitetsmodulen "Innlevering" gjør det mulig for læreren å annonsere oppgaver, samle inn studentenes arbeid, og gi karakterer og tilbakemeldinger.

Studentene kan levere inn alt slags digitalt innhold (filer), for eksempel tekstbehandlingsdokumenter, regneark, bilder, eller lyd- og videoklipp. Som et alternativ, eller i tillegg, kan innleveringen kreve at studentene skal skrive inn tekst direkte i teksteditoren. Innleveringer kan også brukes til å minne studentene på praktiske oppgaver som de må fullføre utenfor internett som ikke krever noe digitalt innhold, for eksempel en oppgave innen kunst og håndverk. Studentene kan levere inn arbeider individuelt eller som medlem av en gruppe.

Når innleveringene gjennomgås, kan lærerne legge til tilbakemeldinger og kommentarer og laste opp filer, f.eks. ferdig vurderte innleveringer, dokumenter med kommentarer, eller innspilte lydfiler med tilbakemeldinger. Vurdering av innleveringer kan skje ved bruk av numerisk eller egendefinert karaktersettingsmetode, f.eks. en rubrikk. Endelige karakterer registreres i karakterboken.';
$string['modulename_link'] = 'mod/assignment/view';
$string['modulenameplural'] = 'Innleveringer';
$string['moreusers'] = '{$a} mer...';
$string['multipleteams'] = 'Medlem av mer enn en gruppe';
$string['multipleteams_desc'] = 'Denne innleveringen krever gruppeinnlevering. Du er medlem av mer enn en gruppe. For å kunne levere kan du kun være medlem av en enkelt gruppe. Vennligst kontakt læreren din for å endre gruppemedlemsskapene dine.';
$string['multipleteamsgrader'] = 'Medlem av mer enn en gruppe, så kan ikke levere inn noe.';
$string['newsubmissions'] = 'Leverte besvarelser';
$string['nextuser'] = 'Neste bruker';
$string['noattempt'] = 'Ingen forsøk';
$string['noclose'] = 'Ingen avslutningsdato';
$string['nofiles'] = 'Ingen filer.';
$string['nofilters'] = 'Ingen filtere';
$string['nograde'] = 'Ingen karakter.';
$string['nogroupoverrides'] = 'Det er ingen gruppeoverstyringer';
$string['nomoresubmissionsaccepted'] = 'Kun for deltakere som har fått innvilget en utsettelse';
$string['none'] = 'Ingen';
$string['noonlinesubmissions'] = 'Denne innleveringen krever ikke at du skal levere inn noe på nett.';
$string['noopen'] = 'Ingen startdato';
$string['nooverridedata'] = 'Du må overstyre minst en av innleveringsinnstillingene';
$string['nosavebutnext'] = 'Neste';
$string['nosubmission'] = 'Ingenting har blitt levert inn til denne innleveringen.';
$string['nosubmissionyet'] = 'Ingen innleveringer er foretatt ennå';
$string['noteam'] = 'Ikke medlem av noen grupper.';
$string['noteam_desc'] = 'Denne innleveringen krever gruppeinnlevering. Du er ikke medlem av noen gruppe, og kan dermed ikke levere inn noe. Vennligst kontakt læreren din for å bli lagt til i en gruppe.';
$string['noteamgrader'] = 'Ikke medlem av noen grupper, så kan ikke levere inn noe.';
$string['notgraded'] = 'Ikke vurdert';
$string['notgradedyet'] = 'Ikke satt karakter enda';
$string['notifications'] = 'Meldinger';
$string['notifystudents'] = 'Varsle studenter';
$string['nouseroverrides'] = 'Det er for øyeblikket ingen bruker overstyringer.';
$string['nousers'] = 'Ingen brukere';
$string['nousersselected'] = 'Ingen brukere valgt';
$string['numberofdraftsubmissions'] = 'Utkast';
$string['numberofparticipants'] = 'Deltakere';
$string['numberofsubmissionsneedgrading'] = 'Må vurderes';
$string['numberofsubmissionsneedgradinglabel'] = 'Trenger vurdering: {$a}';
$string['numberofsubmittedassignments'] = 'Levert';
$string['numberofteams'] = 'Grupper';
$string['offline'] = 'Ingen innleveringer på nett påkrevd';
$string['open'] = 'Åpen';
$string['opensubmissionexists'] = 'Åpen oppgaveinnlevering finnes allerede.';
$string['outlinegrade'] = 'Karakter: {$a}';
$string['outof'] = '{$a->current} av {$a->total}';
$string['overdue'] = 'Oppgaven er forsinket med: {$a}';
$string['override'] = 'OVerstyr';
$string['overridedeletegroupsure'] = 'Er du sikker på at du ønsker å slette overstryingen for gruppe {$a}?';
$string['overridedeleteusersure'] = 'Er du sikker på at du ønsker å slette overstryingen for bruker {$a}?';
$string['overridegroup'] = 'Overstyr gruppe';
$string['overridegroupeventname'] = '{$a->assign} - {$a->group}';
$string['overriderecalculatepenalty'] = 'Rekalkuler straff for bruker(e) i overstyringen';
$string['overrides'] = 'Overstyringer';
$string['overrideuser'] = 'Overstyr bruker';
$string['overrideusereventname'] = '{$a->assign} - Overstyr';
$string['page-mod-assign-view'] = 'Forsiden og innleveringssiden i innleveringsmodulen';
$string['page-mod-assign-x'] = 'Alle sider i oppgavemodulen';
$string['paramtimeremaining'] = '{$a} igjen';
$string['participant'] = 'Deltaker';
$string['penaltyduedatechangemessage'] = 'Noen karakterer har allerede blitt tildelt. For å endre innleveringsfrist, aktivere/deaktivere straff, må du først velge om eksisterende karakterer skal rekalkuleres.';
$string['pluginadministration'] = 'Administrering av innlevering';
$string['pluginname'] = 'Innlevering';
$string['preventsubmissionnotingroup'] = 'Krev gruppe for å levere inn';
$string['preventsubmissionnotingroup_help'] = 'Når aktivert, vil elever som ikke er meldt inn i en gruppe ikke få lov til å levere inn.';
$string['preventsubmissions'] = 'Forhindre brukeren fra å levere inn flere besvarelser til denne innleveringen.';
$string['preventsubmissionsshort'] = 'Forhindre endringer i innleveringer';
$string['previous'] = 'Forrige';
$string['previoususer'] = 'Forrige bruker';
$string['privacy:attemptpath'] = 'forsøk {$a}';
$string['privacy:blindmarkingidentifier'] = 'Indentifikatoren brukt for anonyme innleveringer';
$string['privacy:gradepath'] = 'Karakter';
$string['privacy:metadata:assigndownloadasfolders'] = 'En brukerpreferanse for om massefilinnleveringer skal lastes ned i mapper.';
$string['privacy:metadata:assignfeedbackpluginsummary'] = 'Tilbakemeldingsdata for innleveringen.';
$string['privacy:metadata:assignfilter'] = 'Filtreringsvalg som \'Levert\', \'Ikke lever\', \'Trenger karakter\' og \'Innvilget utsettelse\'';
$string['privacy:metadata:assigngrades'] = 'Lagrer brukernes karakterer i innleveringen.';
$string['privacy:metadata:assignmarkerfilter'] = 'Filtrer innleveringsoversiktetn på tildelt karaktersetter.';
$string['privacy:metadata:assignmentid'] = 'InnleveringsID';
$string['privacy:metadata:assignmessageexplanation'] = 'Meldinger sendes til deltakerne gjennom meldingssystemet.';
$string['privacy:metadata:assignoverrides'] = 'Lagrer overstyringsinformasjon for innleveringen';
$string['privacy:metadata:assignperpage'] = 'Antall innleveringer vist per side.';
$string['privacy:metadata:assignquickgrading'] = 'En preferanse for om hurtig karaktergiving skal brukes eller ikke.';
$string['privacy:metadata:assignsubmissiondetail'] = 'Lagrer brukerinnleveringsinformasjon';
$string['privacy:metadata:assignsubmissionpluginsummary'] = 'Innleveringsinformasjon for innleveringsoppgaven.';
$string['privacy:metadata:assignuserflags'] = 'Lagrer brukermetadata som utsettelsesdatoer';
$string['privacy:metadata:assignusermapping'] = 'Mappingen for anonyme innleveringer';
$string['privacy:metadata:assignworkflowfilter'] = 'Filtrer etter ulike arbeidsflytstadier.';
$string['privacy:metadata:grade'] = 'Den numeriske karakteren for denne innleveringen. Kan bestemmes av skalaer eller karaktersettingsskjemaer e.l. men vil alltid konverteres tilbake til et tall.';
$string['privacy:metadata:grader'] = 'BrukerID\'en til personen som karaktersetter.';
$string['privacy:metadata:groupid'] = 'GruppeID\'en som brukeren er medlem av.';
$string['privacy:metadata:latest'] = 'En stor forenkling i spørringer for å finne informasjonen knyttet til det siste forsøket.';
$string['privacy:metadata:mailed'] = 'Har denne brukeren fått epost?';
$string['privacy:metadata:timecreated'] = 'Opprettet';
$string['privacy:metadata:timestarted'] = 'Startet';
$string['privacy:metadata:userid'] = 'Brukerens ID';
$string['privacy:studentpath'] = 'studentinnleveringer';
$string['privacy:submissionpath'] = 'innnlevering';
$string['quickgrading'] = 'Hurtig karaktersetting';
$string['quickgrading_help'] = 'Hurtig karaktersetting lar deg tildele karakterer (og resultater) direkte i innleveringstabellen. Hurtig karaktersetting er ikke forenelig med avansert karaktersetting, og er ikke anbefalt når det er flere lærere involvert i karaktersettingen.';
$string['quickgradingchangessaved'] = 'Endringene i karakterene ble lagret';
$string['quickgradingresult'] = 'Hurtig karaktersetting';
$string['recordid'] = 'Identifikator';
$string['relativedatessubmissiontimeleft'] = 'Beregnet for hver student';
$string['removeallgroupoverrides'] = 'Slett alle gruppeoverstyringer';
$string['removealluseroverrides'] = 'Slett alle brukeroverstyringer';
$string['removesubmission'] = 'Fjern innlevering';
$string['removesubmissionconfirm'] = 'Er du sikker på at du ønsker å fjerne innleveringen?';
$string['removesubmissionconfirmforstudent'] = 'Er du sikker på at du ønsker å fjerne innleveringen for {$a}?';
$string['removesubmissionconfirmforstudentwithtimelimit'] = 'Er du sikker på at du vil fjerne innsendingen for {$a}? Vær oppmerksom på at dette ikke vil tilbakestille studentens tidsbegrensning. Du kan gi mer tid ved å legge til en tidsbegrensning for brukeroverstyring.';
$string['removesubmissionconfirmwithtimelimit'] = 'Er du sikker på at du vil fjerne innsendingen din? Vær oppmerksom på at dette ikke vil tilbakestille tidsbegrensningen din.';
$string['removesubmissionforstudent'] = 'Fjern innlevering for: (id = {$a->id}, navn = {$a->fullname}).';
$string['reopenuntilpassincompatiblewithblindmarking'] = 'Åpen til bestått er ikke kombatibelt med anonym innlevering fordi karakterene ikke sendes til karakterboka før brukernes identitet er avslørt.';
$string['requireallteammemberssubmit'] = 'Krev at alle gruppemedlemmer leverer';
$string['requireallteammemberssubmit_help'] = 'Denne innstillingen må brukes sammen med "Krev at deltakerne klikker på levér-knappen" i innleveringsinnstillingene.

Hvis aktivert må alle gruppemedlemmene klikke på levér-knappen for at oppgaven skal leveres inn. Hvis deaktivert er det nok at en av gruppemedlemmene klikker på levér-knappen.';
$string['requiresubmissionstatement'] = 'Krev at studentene skal godta innleveringserklæringen';
$string['requiresubmissionstatement_help'] = 'Krev at studentene skal godta innleveringserklæringen for alle innleveringene på denne oppgaven.';
$string['revealidentities'] = 'Vis studentidentiteter';
$string['revealidentitiesconfirm'] = 'Er du sikker på at du vil vise studentidentitetene i denne innleveringen? Denne handlingen kan ikke omgjøres. Så fort studentidentitetene har blitt vist, blir karakterene frigitt til karakterboken.';
$string['reverttodefaults'] = 'Tilbakestill til innleveringens standardinnstillinger';
$string['reverttodraft'] = 'Tilbakestill innleveringen til utkast-status';
$string['reverttodraftforgroup'] = 'Tilbakestill innlevering til utkast for gruppe {$a}.';
$string['reverttodraftforstudent'] = 'Tilbakestill innleveringen til utkast for student:  (id={$a->id}, fullname={$a->fullname}).';
$string['reverttodraftshort'] = 'Tilbakestill innleveringen til utkast';
$string['reviewed'] = 'Gjennomlest';
$string['save'] = 'Lagre';
$string['saveallquickgradingchanges'] = 'Lagre alle endringene i hurtig karaktersetting';
$string['saveandcontinue'] = 'Lagre og fortsett';
$string['savechanges'] = 'Lagre endringer';
$string['savegradingresult'] = 'Karakter';
$string['savenext'] = 'Lagre og vis neste';
$string['saveoverrideandstay'] = 'Lagre og opprett en ny overstyring';
$string['savingchanges'] = 'Lagrer endringer...';
$string['scale'] = 'Skala';
$string['search:activity'] = 'Innlevering - aktivitetsinformasjon';
$string['selectedusers'] = 'Valgte brukere';
$string['selectlink'] = 'Velg...';
$string['selectuser'] = 'Velg {$a}';
$string['sendlatenotifications'] = 'Varsle karaktergivere om sene innleveringer';
$string['sendlatenotifications_help'] = 'Hvis denne funksjonen er aktivert, vil karaktergivere (vanligvis lærere) motta en melding når studenter leverer en besvarelse sent. Meldingsmetoder kan konfigureres.';
$string['sendnotificationduedatesoon'] = 'Varlser en bruker om at firsten for innlevering snart utløper';
$string['sendnotificationduedigest'] = 'Varsle bruker om innlevering som må leveres innen 7 dager';
$string['sendnotificationoverdue'] = 'Send et varsel om forfalt innlevering';
$string['sendnotifications'] = 'Varsle karaktergivere om innleveringer';
$string['sendnotifications_help'] = 'Hvis denne funksjonen er aktivert, vil karaktergivere (vanligvis lærere) motta en melding når studenter leverer en besvarelse tidlig, til rett tid og sent. Meldingmetoder kan konfigureres.';
$string['sendstudentnotifications'] = 'Gi beskjed til studenten';
$string['sendstudentnotifications_help'] = 'Hvis aktivert vil studentene få en melding om oppdatert karakter eller tilbakemelding. Hvis arbeidsflyt er aktivert i innleveringen, vil varsling først sendes når karaktereren har status publisert.';
$string['sendstudentnotificationsdefault'] = 'Standardinnstilling for å varsle studenter';
$string['sendstudentnotificationsdefault_help'] = 'Når du setter karakter på hver elev, bør \'Varsle student\' være avkrysset som standard?';
$string['sendsubmissionreceipts'] = 'Send innleveringskvittering til studentene';
$string['sendsubmissionreceipts_help'] = 'Denne bryteren vil aktivere innleveringskvitteringer for studenter. Studentene vil motta en melding hver gang de leverer inn en besvarelse.';
$string['setmarkerallocationforlog'] = 'Angi vurderingstildelig : (id={$a->id}, fullname={$a->fullname}, marker={$a->marker}).';
$string['setmarkingallocation'] = 'Angi hvem som skal vurdere';
$string['setmarkingworkflowstate'] = 'Angi fase i vurderingsarbeidsflyt';
$string['setmarkingworkflowstateforlog'] = 'Angi fase i arbeidsflyt: (id={$a->id}, fullname={$a->fullname}, state={$a->state}).';
$string['settings'] = 'Innleveringsinnstillinger';
$string['showrecentsubmissions'] = 'Vis nylige innleveringer';
$string['status'] = 'Status';
$string['studentnotificationworkflowstateerror'] = 'Status for automatisk arbeidsflyt må være satt til "Publisert" for at studentene skal varsles.';
$string['submission'] = 'Innlevering';
$string['submissionactions'] = 'Innleveringshandlinger';
$string['submissionattachments'] = 'Vis bare filer under innleveringen';
$string['submissionattachments_help'] = 'Når aktivert, vil filer kun vises på innsendingsskjermen.
Når den er deaktivert, vil filene vises på både oppgavevisning og innleveringsskjermer.';
$string['submissioncontains'] = 'Innleveringen din inneholder';
$string['submissioncopiedhtml'] = '<p>Du har laget en kopi av din tidligere oppgavebesvarelse for \'{$a->assignment}\'</p>
<p> Du kan se statusen på din <a href="{$a->url}">innlevering</a>.</p>';
$string['submissioncopiedsmall'] = 'Du har laget en kopi av din tidligere oppgavebesvarelse for {$a->assignment}';
$string['submissioncopiedsms'] = 'Du har kopiert din forrige innlevering for {$a->assignment} i {$a->coursefullname}. Logg inn for å se den.';
$string['submissioncopiedtext'] = 'Du har laget en kopi av din tidligere oppgavebesvarelse for \'{$a->assignment}\'

Du kan se statusen på din innlevering:

 {$a->url}';
$string['submissiondrafts'] = 'Krev at studentene klikker på levér-knappen';
$string['submissiondrafts_help'] = 'Skal deltakerne ha en innleveringsknapp for å bekrefte at de er ferdig med innleveringen og at den er klar for vurdering?';
$string['submissioneditable'] = 'Studenter kan redigere denne innleveringen';
$string['submissionempty'] = 'Ingenting ble sendt inn';
$string['submissionlog'] = 'Student: {$a->fullname}, Status: {$a->status}';
$string['submissionmodified'] = 'Du har eksisterende innleveringsdata. Vennligst forlat denne siden og prøv på nytt.';
$string['submissionmodifiedgroup'] = 'Innlevering har blitt endret av noen andre. Vennligst forlat siden og prøv på nytt.';
$string['submissionnotcopiedinvalidstatus'] = 'Innleveringen ble ikke kopiert fordi den har blitt redigert siden den ble gjenåpnet.';
$string['submissionnoteditable'] = 'Studenter kan ikke redigere denne innleveringen';
$string['submissionnotopen'] = 'Denne oppgaven er ikke åpen for innlevering';
$string['submissionnotready'] = 'Denne oppgavebesvarelsen er ikke klar til innlevering:';
$string['submissionplugins'] = 'Innleveringsmoduler';
$string['submissionreceiptcontains'] = 'Innlevert innhold ({$a->total} elementer)';
$string['submissionreceipthtml'] = '<p>Du har levert en oppgavebesvarelse for \'{$a->assignment}\'</p>
<p>Du kan se innleveringen og sjekke status <a href="{$a->url}">på innleveringssiden</a>.</p>';
$string['submissionreceiptotherhtml'] = 'Besvarelsen din for oppgaven \'{$a->assignment}\' er nå levert. Du kan se statusen for <a href="{$a->url}">innleveringen din her</a>.';
$string['submissionreceiptothersmall'] = 'Innleveringen din for oppgaven {$a->assignment} er nå levert.';
$string['submissionreceiptothersms'] = 'Oppgaven \'{$a->assignment}\' i \'{$a->coursefullname}\' er levert inn. Logg inn for å se innleveringsstatusen din';
$string['submissionreceiptothertext'] = 'Innleveringen din for oppgaven \'{$a->assignment}\' er nå levert.

Du kan se statusen for besvarelsen din her:

    {$a->url}';
$string['submissionreceipts'] = 'Send innleveringskvitteringer';
$string['submissionreceiptsmall'] = 'Innleveringsbekreftelse for {$a->assignment}';
$string['submissionreceiptsms'] = 'Du har levert inn «{$a->assignment}» i «{$a->coursefullname}». Logg inn for å se innleveringsstatusen.';
$string['submissionreceipttext'] = 'Du har levert en oppgavebesvarelse for {$a->assignment}

Du kan se status på din innlevering:

{$a->url}

{$a->submissionsummarytext}';
$string['submissions'] = 'Innleveringer';
$string['submissionsclosed'] = 'Innleveringene er stengt';
$string['submissionsettings'] = 'Innstillinger for innlevering';
$string['submissionslocked'] = 'Denne innleveringen tar ikke imot innleveringer';
$string['submissionslockedshort'] = 'Endringer i innleveringer ikke tillatt';
$string['submissionstatement'] = 'Innleveringserklæring';
$string['submissionstatement_help'] = 'Brukeravtale som hver student må akseptere for å få levert inn arbeidet sitt.';
$string['submissionstatementacceptedlog'] = 'Innleveringserklæring godtatt av bruker {$a}';
$string['submissionstatementdefault'] = 'Denne innleveringen er mitt eget arbeid, unntatt der hvor jeg har erkjent at jeg har brukt andres ideer og arbeid.';
$string['submissionstatementrequired'] = 'Du må godta denne erklæringen før du kan levere.';
$string['submissionstatementteamsubmission'] = 'Gruppeinnleveringserklæring';
$string['submissionstatementteamsubmission_help'] = 'Brukeravtale studenten må akseptere for å levere inn gruppens arbeid.';
$string['submissionstatementteamsubmissionallsubmit'] = 'Gruppeinnleveringserklæring der alle gruppemedlemmer skal levere inn';
$string['submissionstatementteamsubmissionallsubmit_help'] = 'Brukeravtale studenten må akseptere for å levere inn som et gruppemedlem.';
$string['submissionstatementteamsubmissionallsubmitdefault'] = 'Denne innleveringen er mitt eget arbeid som et gruppemedlem, med unntak av der jeg har anerkjent bruken av andres arbeid.';
$string['submissionstatementteamsubmissiondefault'] = 'Denne innlevering er min gruppes arbeid, med unntak av der vi har anerkjent bruken av andres arbeid.';
$string['submissionstatus'] = 'Status på innlevering';
$string['submissionstatus_'] = 'Ingen innlevering';
$string['submissionstatus_draft'] = 'Utkast (ikke levert)';
$string['submissionstatus_marked'] = 'Karaktersatt';
$string['submissionstatus_new'] = 'Ingen innlevering';
$string['submissionstatus_reopened'] = 'Gjenåpnet';
$string['submissionstatus_submitted'] = 'Levert til vurdering';
$string['submissionstatusheading'] = 'Status på innlevering';
$string['submissionsummary'] = '{$a->status}. Sist endret {$a->timemodified}';
$string['submissionteam'] = 'Gruppe';
$string['submissiontypes'] = 'Innleveringstyper';
$string['submitaction'] = 'Levér';
$string['submitassignment'] = 'Levér besvarelsen';
$string['submitassignment_help'] = 'Når du har levert denne oppgavebesvarelsen, vil du ikke kunne gjøre flere endringer.';
$string['submitforgrading'] = 'Lever for karaktersetting';
$string['submitted'] = 'Levert';
$string['submittedearly'] = 'Oppgavebesvarelsen ble levert {$a} for tidlig.';
$string['submittedlate'] = 'Oppgavebesvarelsen ble levert {$a} for sent.';
$string['submittedlateshort'] = '{$a} for sent';
$string['submittedovertime'] = 'Oppgaven ble sendt inn {$a} etter tidsfristen';
$string['submittedundertime'] = 'Oppgaven ble levert {$a} før fristen';
$string['subpagetitle'] = '{$a->contextname} - {$a->subpage}';
$string['subplugintype_assignfeedback'] = 'Feedbackmodul';
$string['subplugintype_assignfeedback_plural'] = 'Feedbackmoduler';
$string['subplugintype_assignsubmission'] = 'Innleveringsmodul';
$string['subplugintype_assignsubmission_plural'] = 'Innleveringsmoduler';
$string['teamname'] = 'Gruppe: {$a}';
$string['teamsubmission'] = 'Studenter leverer i grupper';
$string['teamsubmission_help'] = 'Hvis dette er aktivert, vil studentene bli delt inn i grupper basert på standardsettet med grupper eller en tilpasset gruppering. En gruppeinnlevering vil bli delt mellom gruppemedlemmene, og alle medlemmene i gruppen vil se hverandres endringer i innleveringen. Merk: Du kan ikke endre denne innstillingen hvis det allerede finnes innleveringer.';
$string['teamsubmissiongroupingid'] = 'Tilgangsgruppe for studentgrupper';
$string['teamsubmissiongroupingid_help'] = 'Dette er tilgangsgruppen som innleveringen vil bruke for å finne grupper til studentgrupper. Hvis ingenting er angitt, blir standard gruppesett brukt.';
$string['textinstructions'] = 'Innleveringsanvisninger';
$string['timelimit'] = 'Tidsfrist';
$string['timelimit_help'] = 'Hvis aktivert, er tidsbegrensningen angitt på oppdragssiden og en nedtellingstidtaker vises under oppdraget.';
$string['timelimitnotenabled'] = 'Tidsbegrensning er ikke aktivert for oppgaven.';
$string['timelimitpassed'] = 'Tidsgrensen er passert';
$string['timemodified'] = 'Sist endret';
$string['timeremaining'] = 'Tid som gjenstår';
$string['timeremainingcolon'] = 'Tid som gjenstår: {$a}';
$string['togglezoom'] = 'Zoom inn/ut av region';
$string['ungroupedusers'] = 'Innstillingen \'Krev gruppe for å levere\' er slått på, men noen brukere er enten ikke medlem av noen grupper eller medlem i flere grupper. Dette vil forhindre dem fra å levere inn noe.';
$string['ungroupedusersoptional'] = 'Innstillingen \'Studenter kan levere i grupper\' er aktivert og noen brukere er enten ikke medlemmer av noen gruppe eller i mer enn en gruppe. Vennligst vær klar over at disse studentene vil foreta innleveringen som medlem av \'Standard gruppe\'.';
$string['unlimitedattempts'] = 'Ubegrenset';
$string['unlimitedattemptsallowed'] = 'Ubegrenset antall forsøk tillatt.';
$string['unlimitedpages'] = 'Ubegrenset';
$string['unlocksubmissionforstudent'] = 'Tillat innleveringer for student: (id={$a->id}, fullname={$a->fullname}).';
$string['unlocksubmissions'] = 'Lås opp innleveringer';
$string['unsavedchanges'] = 'Ulagrede endringer';
$string['unsavedchangesquestion'] = 'Det er ulagrede endringer på vurderinger og tilbakemeldinger. Ønsker du å lagre endringene og fortsette?';
$string['updategrade'] = 'Oppdater karakter';
$string['updatetable'] = 'Lagre og oppdater tabell';
$string['upgradenotimplemented'] = 'Oppgradering ikke implementert i modul ({$a->type} {$a->subtype})';
$string['userassignmentdefaults'] = 'Standarder for brukerinnleveringer';
$string['userextensiondate'] = 'Forlengelse innvilget til: {$a}';
$string['usergrade'] = 'Brukers karakter';
$string['useridlistnotcached'] = 'Kunne ikke lagre. Moodle kunne ikke finne ut hvilken bruker som skulle ha karakteren.';
$string['useroverrides'] = 'Brukeroverstyringer';
$string['useroverridesdeleted'] = 'Brukeroverstyringer slettet';
$string['usersnone'] = 'Det er ingen påmeldte deltaker i dette kurset';
$string['usersubmissioncannotberemoved'] = 'Innleveringen til {$a} kan ikke fjernes.';
$string['userswhoneedtosubmit'] = 'Brukere som må levere: {$a}';
$string['validmarkingworkflowstates'] = 'Gyldig fase i vurderingsarbeidsflyt';
$string['viewadifferentattempt'] = 'Vis et annet forsøk';
$string['viewbatchmarkingallocation'] = 'Vis massehåndteringssiden for tildeling av oppgaver.';
$string['viewbatchsetmarkingworkflowstate'] = 'Vis massehåndteringsside for vurderingsarbeidsflyt.';
$string['viewfeedback'] = 'Vis tilbakemelding';
$string['viewfeedbackforuser'] = 'Vis tilbakemelding for bruker: {$a}';
$string['viewfull'] = 'Vis hele';
$string['viewfullgradingpage'] = 'Åpne karaktersettingssiden fullt ut for å gi tilbakemelding';
$string['viewgradebook'] = 'Vis karakterboken';
$string['viewgrader'] = 'Vis vurderingsskjema';
$string['viewgrading'] = 'Vis alle innleveringer';
$string['viewgradingformforstudent'] = 'Vis karaktersiden for student: (id={$a->id}, fullname={$a->fullname}).';
$string['viewownsubmissionform'] = 'Vis egen innleveringsside for oppgavebesvarelse.';
$string['viewownsubmissionstatus'] = 'Vis statussiden for egen innlevering';
$string['viewrevealidentitiesconfirm'] = 'Se side for visning av bekreftelse på studentidentitet';
$string['viewsubmission'] = 'Vis innlevering';
$string['viewsubmissionforuser'] = 'Vis innlevering for bruker: {$a}';
$string['viewsubmissiongradingtable'] = 'Vis karaktersettingstabell for innlevering';
$string['viewsummary'] = 'Vis oppsummering';
$string['workflowfilter'] = 'Filter for arbeidsflyt';
$string['xofy'] = '{$a->x} av {$a->y}';
