<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'local_kopere_dashboard', language 'ru', version '4.5'.
 *
 * @package     local_kopere_dashboard
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['about_bug'] = 'Если вы обнаружили какую-то ошибку или хотите предложить улучшения, откройте один выпуск';
$string['about_code'] = 'Код, доступный в';
$string['about_help'] = '<a href="https://vk.com/dionis">Перевод на русский язык выполнен Павлом Диброва</a>. Помощь включена';
$string['about_project'] = 'Проект с открытым исходным кодом, разработанный и поддерживаемый';
$string['about_title'] = 'Описание';
$string['active'] = 'Включено';
$string['add_report_user_fields'] = 'Добавить следующие пользовательские поля в отчетах';
$string['add_report_user_fields_alt'] = 'Выберите пользовательские поля, которые вы хотите отображать в отчетах Kopere.<br>
     Удерживая нажатой клавишу CTRL, выберите несколько полей.';
$string['background'] = 'Фон';
$string['backup_delete_confirm'] = 'Удаление резервной копии';
$string['backup_delete_title'] = 'Вы действительно хотите удалить <strong>{$a}</strong>';
$string['backup_deletesucessfull'] = 'Резервная копия успешно удалена!';
$string['backup_deleting'] = 'Исключая резервное копирование';
$string['backup_execute_complete'] = 'Резервное копирование завершено!';
$string['backup_execute_database'] = 'База данных:';
$string['backup_execute_date'] = 'Дата создания:';
$string['backup_execute_dump'] = 'Дамп табличных данных';
$string['backup_execute_dump_error'] = 'Таблица отслеживания ошибок';
$string['backup_execute_exec'] = 'Выполнение резервного копирования';
$string['backup_execute_structure'] = 'Структура для таблицы';
$string['backup_execute_success'] = 'Резервная копия успешно создана!';
$string['backup_execute_table'] = 'Выполнение резервного копирования таблицы';
$string['backup_hours'] = 'Не запускайте резервное копирование в часы пик!';
$string['backup_list'] = 'Список резервных копий';
$string['backup_list_action'] = 'Действие';
$string['backup_list_created'] = 'Создано в';
$string['backup_list_file'] = 'Файл';
$string['backup_list_size'] = 'Размер';
$string['backup_mark_all'] = 'Отметить/Снять отметку';
$string['backup_newnow'] = 'Создайте новую резервную копию прямо сейчас';
$string['backup_newsqlnow'] = 'Создайте новую резервную копию базы данных прямо сейчас';
$string['backup_none'] = 'Резервные копии не найдены!';
$string['backup_noshell'] = 'функция shell_exec отключена!';
$string['backup_notound'] = 'Файл не найден!';
$string['backup_returnlist'] = 'Вернуться к списку резервных копий';
$string['backup_sleep'] = 'Выполнение резервного копирования может занять несколько минут.';
$string['backup_title'] = 'Резервная копия';
$string['backup_windows'] = 'Недоступно на сервере Windows Server!';
$string['benchmark_based'] = 'Плагин на основе';
$string['benchmark_critical'] = 'Критический предел';
$string['benchmark_decription'] = 'Описание';
$string['benchmark_execute'] = 'Запустить тест';
$string['benchmark_executing'] = 'Запуск теста';
$string['benchmark_info'] = '<p>Выполнение этого теста может занять до 1 минуты.</p><p>Попробуйте провести более одного теста для получения среднего значения.</p><p>И не работайте в часы повышенной нагрузки на сервер.</p>';
$string['benchmark_max'] = 'Максимально допустимое значение';
$string['benchmark_seconds'] = 'сек.';
$string['benchmark_testconf'] = 'Протестируйте настройки Moodle';
$string['benchmark_testconf_action'] = 'Действие';
$string['benchmark_testconf_description'] = 'Описание';
$string['benchmark_testconf_problem'] = 'Проблема';
$string['benchmark_testconf_status'] = 'Статус';
$string['benchmark_timesec'] = 'Время, в секундах';
$string['benchmark_timetotal'] = 'Общее время:';
$string['benchmark_title'] = 'Проверка производительности';
$string['benchmark_title2'] = 'Проверка производительности хостинга';
$string['cachedef_courses_all_courses'] = 'Список кэшей всего курса';
$string['cachedef_performancemonitor_cache'] = 'Кэш-память монитора производительности';
$string['cachedef_report_getdata_cache'] = 'отчет получает кэш данных';
$string['cloadmoreinfo'] = 'Запустите конфигурационный файл &laquo;config.php&raquo;';
$string['cloadname'] = 'Время загрузки Moodle';
$string['close'] = 'Закрыть';
$string['color_blue'] = 'Синий';
$string['color_brown'] = 'Коричневый';
$string['color_green'] = 'Зеленый';
$string['color_grey'] = 'Серый';
$string['color_orange'] = 'Оранжевый';
$string['color_purple'] = 'Пурпурный';
$string['color_red'] = 'Красный';
$string['color_yellow'] = 'Желтый';
$string['colors'] = 'Цвета';
$string['contextactivity'] = 'Деятельность';
$string['contextbadgecompletion'] = 'Получение значка';
$string['contextcohort'] = 'Группа';
$string['contextcompetency'] = 'Компетенция';
$string['contextcourse'] = 'Курс';
$string['contextcoursegroup'] = 'Группа курсов';
$string['contextdefault'] = '...';
$string['contextduration'] = 'Продолжительность';
$string['contextfunction'] = 'Функция';
$string['contextgrade'] = 'Класс';
$string['contextsystem'] = 'Система';
$string['coursereadmoreinfo'] = 'Проверка скорости чтения курса';
$string['coursereadname'] = 'Чтение курса';
$string['courses_access'] = 'Доступ';
$string['courses_edit'] = 'Редактировать';
$string['courses_enrol'] = 'Nº количество зачисленных студентов';
$string['courses_enrol_new'] = 'Регистрация нового участника и его зачисление';
$string['courses_enrol_new_form'] = 'Зарегистрировать нового участника перед зачислением';
$string['courses_invalid'] = 'Неверный ID курса!';
$string['courses_name'] = 'Название курса';
$string['courses_notound'] = 'Курс не найден!';
$string['courses_page_create'] = 'Создайте страницу на основе этой сводки';
$string['courses_page_title'] = 'Уже созданные страницы';
$string['courses_shortname'] = 'Краткое название';
$string['courses_student_cadastrado'] = '<div>Пользователь уже зарегистрирован на курсе. <a href="{$a}">Кликните сюда</a> to check';
$string['courses_student_cadastrar'] = 'Запишите студента на этот курс';
$string['courses_student_cadastrar_ok'] = 'Пользователь успешно зарегистрировался!';
$string['courses_student_email'] = 'Почта студента';
$string['courses_student_name'] = 'Имя студента';
$string['courses_student_ok'] = 'Пользователь успешно создан:<br><strong>Логин:</strong> {$a->login}<br><strong>Пароль:</strong> {$a->password}';
$string['courses_student_password'] = 'Рекомендуемый пароль для студента';
$string['courses_student_status'] = 'Статус регистрации';
$string['courses_sumary'] = 'Резюме';
$string['courses_title'] = 'Курсы';
$string['courses_title1'] = 'Список курсов';
$string['courses_titleenrol'] = 'Зачисленные студенты';
$string['courses_user_create'] = 'Зарегистрируйте нового студента';
$string['courses_validate_user'] = 'Проверьте, существует ли студент, или зарегистрируйте его';
$string['courses_visible'] = 'Видимый';
$string['coursewritemoreinfo'] = 'Проверьте скорость работы базы данных, чтобы написать курс';
$string['coursewritename'] = 'Курс письма';
$string['crontask_db_report_login'] = 'Cron для хранения логинов пользователей во временной таблице';
$string['crontask_performance'] = 'Cron для сохранения данных о производительности';
$string['dashboard'] = 'Панель управления';
$string['dashboard_enrol_active'] = 'регистрация идет активно';
$string['dashboard_enrol_inactive'] = 'регистрация неактивна';
$string['dashboard_enrol_lastmodifield'] = 'Последнее изменение в';
$string['dashboard_enrol_text'] = 'Вы записались на этот курс <a href="?classname=courses&method=details&courseid={$a->courseid}">{$a->fullname}</a> and';
$string['dashboard_enrol_title'] = 'Последняя регистрация';
$string['dashboard_grade_in'] = 'В';
$string['dashboard_grade_incourse'] = 'в курсе <a href="?classname=courses&method=details&courseid={$a->courseid}">{$a->coursename}</a>';
$string['dashboard_grade_inmod'] = 'в модуле <strong>{$a->itemname}</strong>в курсе <a href="?classname=courses&method=details&courseid={$a->courseid}">{$a->coursename}</a>';
$string['dashboard_grade_of'] = 'of';
$string['dashboard_grade_text'] = 'Полученная записка {$a->grade} in {$a->evaluation}';
$string['dashboard_grade_title'] = 'Последние заметки';
$string['dashboard_title_course'] = 'Курсы / Видимый';
$string['dashboard_title_disk'] = 'Использование диска';
$string['dashboard_title_online'] = 'Онлайн / Последний час';
$string['dashboard_title_user'] = 'Пользователи / Активы';
$string['datatables_buttons_copyKeys'] = 'Нажмите <i>ctrl</i> or <i>\\u2318</i> + <i>C</i> чтобы скопировать данные таблицы<br>в системный буфер обмена.<br><br>Чтобы отменить, щелкните по этому сообщению или нажмите клавишу escape.';
$string['datatables_buttons_copySuccess1'] = 'Скопировал одну строку в буфер обмена';
$string['datatables_buttons_copySuccess_'] = 'Скопированные %d строки в буфер обмена';
$string['datatables_buttons_copyTitle'] = 'Скопировать в буфер обмена';
$string['datatables_buttons_copy_text'] = 'Копирование данных';
$string['datatables_buttons_csv_text'] = 'Скачать CSV';
$string['datatables_buttons_pageLength_'] = 'Показать %d айтемы';
$string['datatables_buttons_pageLength_1'] = 'Показать все';
$string['datatables_buttons_print_text'] = 'Печать';
$string['datatables_buttons_select_rows1'] = 'выбрана 1 строка';
$string['datatables_buttons_select_rows_'] = '%d строк выбрано';
$string['datatables_oAria_sSortAscending'] = ': Сортировка столбцов в порядке возрастания';
$string['datatables_oAria_sSortDescending'] = ': Сортировка столбцов в порядке убывания';
$string['datatables_oPaginate_sFirst'] = 'Первый';
$string['datatables_oPaginate_sLast'] = 'Последний';
$string['datatables_oPaginate_sNext'] = 'Следующий';
$string['datatables_oPaginate_sPrevious'] = 'Предыдущий';
$string['datatables_sEmptyTable'] = 'Записей не обнаружено';
$string['datatables_sErrorMessage'] = '<strong>Ошибка при загрузке данных</strong><div>Повторная попытка через {$a} секунд</div>';
$string['datatables_sInfo'] = '_START_ to _END_ of _TOTAL_';
$string['datatables_sInfoEmpty'] = '0 записей';
$string['datatables_sInfoFiltered'] = '(Filtered from _MAX_ records)';
$string['datatables_sInfoPostFix'] = '';
$string['datatables_sInfoThousands'] = '.';
$string['datatables_sLengthMenu'] = '_MENU_ на стр.';
$string['datatables_sLoadingRecords'] = 'Загрузка ...';
$string['datatables_sProcessing'] = 'Обработка ...';
$string['datatables_sSearch'] = 'Поиск';
$string['datatables_sZeroRecords'] = 'Записей не обнаружено';
$string['date_renderer_format'] = 'месяц/день/год';
$string['dateformat'] = '%d %B %Y, %I:%M %p';
$string['datetime'] = '%d/%m/%Y, %H:%M';
$string['datetime_renderer_format'] = 'месяц/днь/год час:минут';
$string['deleted_successfully'] = 'Удалено успешно';
$string['enable_debugmode'] = 'Вам необходимо включить режим разработчика и отображение сообщений об отладке';
$string['filemanager_title'] = 'Менеджер файлов';
$string['filereadmoreinfo'] = 'Проверьте скорость чтения в Moodle\'s временной папки';
$string['filereadname'] = 'Чтение файлов';
$string['filewritemoreinfo'] = 'Протестируйте скорость записи в Moodle\'s временной папки';
$string['filewritename'] = 'Создание файлов';
$string['help_title'] = 'Помогите с этой страницей';
$string['inactive'] = 'Неактивный';
$string['install_kopere_bi_desc'] = '<p>Установите <a href="https://moodle.org/plugins/local_kopere_bi" target="_blank">Kopere BI</a> и получите доступ к расширенным и подробным отчетам для лучшего анализа данных.</p>';
$string['install_kopere_bi_title'] = 'Установить Kopere BI';
$string['integracaoroot'] = 'Интеграция';
$string['invisible'] = 'Скрытый';
$string['kopere_dashboard:ajax'] = 'Загрузить ajax для панели управления Kopere';
$string['kopere_dashboard:emailconfirmsubmission'] = 'Отправлять уведомления';
$string['kopere_dashboard:manage'] = 'Управление панелью управления Kopere';
$string['kopere_dashboard:view'] = 'Просмотр панели управления Koper';
$string['kopere_dashboard_menu'] = 'Показать меню в верхней строке';
$string['kopere_dashboard_menu_desc'] = 'Если этот флажок установлен, в верхнем меню будет ссылка на панель управления Kopere';
$string['kopere_dashboard_menuwebpages'] = 'Показывать статические страницы для вошедших в систему пользователей';
$string['kopere_dashboard_menuwebpages_desc'] = 'Включите эту опцию, чтобы отображать статические страницы в навигационном меню для пользователей, вошедших в систему.';
$string['kopere_dashboard_monitor'] = 'Монитор сервера';
$string['kopere_dashboard_monitor_desc'] = 'Вы хотите отобразить монитор сервера в верхней части Koper?';
$string['kopere_dashboard_pagefonts'] = 'Дополнительные шрифты Google';
$string['kopere_dashboard_pagefonts_desc'] = 'Добавьте сюда ссылку @import из Google для получения дополнительных шрифтов.<br>Вы можете использовать множественный импорт.<br><a href="https://fonts.google.com/selection/embed" target="google">Внедрить код</a><br><img src="{$a}" style="max-width: 100%;width: 420px;">';
$string['loginguestmoreinfo'] = 'Измерение времени загрузки страницы входа в систему с учетной записью гостя';
$string['loginguestname'] = 'Время для подключения к гостевой учетной записи';
$string['loginusermoreinfo'] = 'Измерение времени загрузки страницы входа в систему с поддельной учетной записью пользователя';
$string['loginusername'] = 'Пришло время подключиться к поддельной учетной записи пользователя';
$string['messageprovider:kopere_dashboard_messages'] = 'Отправлять уведомления';
$string['modulename'] = 'Панель управления';
$string['navigation_page'] = 'Страница {$a->atualPage} of {$a->countPages}';
$string['none_course'] = '(Нет курса)';
$string['notification_add_action'] = 'О каких действиях вы хотите получать уведомления?';
$string['notification_add_create'] = 'Создать уведомление';
$string['notification_add_module'] = 'О каком модуле вы хотите получать уведомления?';
$string['notification_add_moduledesc'] = 'Модули / Неиспользуемые действия не отображаются!';
$string['notification_add_selectmodule'] = 'Выберите модуль!';
$string['notification_core_course'] = 'Курсы';
$string['notification_core_course_category'] = 'Категория курсов';
$string['notification_core_course_completion'] = 'Завершение курса';
$string['notification_core_course_content'] = 'Содержание курса';
$string['notification_core_course_module'] = 'Модуль курса';
$string['notification_core_course_section'] = 'Разделы курса';
$string['notification_core_user'] = 'Пользователи';
$string['notification_core_user_enrolment'] = 'Регистрация пользователя';
$string['notification_core_user_password'] = 'Пароли';
$string['notification_course_module_created'] = 'Создан новый модуль курса';
$string['notification_create'] = 'Создать оповещение';
$string['notification_created'] = 'Уведомление создано!';
$string['notification_delete_success'] = 'Уведомление успешно удалено!';
$string['notification_delete_yes'] = 'Вы действительно хотите удалить это уведомление?';
$string['notification_duplicate'] = 'У этого модуля и комбинации событий уже есть прослушиватель!';
$string['notification_editing'] = 'Уведомление об изменении';
$string['notification_error_smtp'] = '<p>Для того чтобы учащиеся могли получать сообщения, необходимо настроить протокол SMTP.</p>
          <p><a href="https://moodle.eduardokraus.com/configurar-o-smtp-no-moodle"
             target="_blank">Читайте здесь, как настроить SMTP</a></p>
          <p><a href="{$a->wwwroot}/admin/settings.php?section={$a->mail}"
             target="_blank">Нажмите здесь, чтобы настроить вывод электронной почты</a></p>';
$string['notification_from'] = 'От';
$string['notification_from_admin'] = 'Администратор сайта';
$string['notification_fromdesc'] = 'Кто будет отправителем сообщения?';
$string['notification_local_kopere_dashboard'] = 'Панель управления';
$string['notification_local_kopere_dashboard_payment'] = 'Kopere платеж';
$string['notification_local_kopere_hotmoodle'] = 'Kopere HotMoodle';
$string['notification_local_kopere_moocommerce'] = 'Kopere MooCommerce';
$string['notification_local_kopere_pay'] = 'Kopere Pagamento';
$string['notification_manager'] = 'Управление сообщениями';
$string['notification_message'] = 'Сообщения';
$string['notification_message_edit_template'] = 'Отредактируйте базовый шаблон электронного письма';
$string['notification_message_html'] = '<p>Здравствуйте {[to.fullname]},</p><p>&nbsp;</p><p>Att,<br>{[from.fullname]}.</p>';
$string['notification_message_html_core_course'] = '<p>Здравствуйте {[to.fullname]},</p>
<p>Пользователь {[to.fullname]} только что выполнил действие <strong>{[event.name]}</strong> в курсе {[course.fullname]}.</p>
<p>С уважением,<br>{[admin.fullname]}.</p>';
$string['notification_message_html_core_course_category'] = '<p>Здравствуйте {[to.fullname]},</p>
<p>Пользователь {[to.fullname]} только что выполнил действие <strong>{[event.name]}</strong> in the category {[category.fullname]}.</p>
<p>Best regards,<br>{[admin.fullname]}.</p>';
$string['notification_message_html_core_user'] = '<p>Здравствуйте {[to.fullname]},</p>
<p>Пользователь {[to.fullname]} только что выполнил действие <strong>{[event.name]}</strong>.</p>
<p>С уважением,<br>{[admin.fullname]}.</p>';
$string['notification_message_html_core_user_enrolment'] = '<p>Здравствуйте {[to.fullname]},</p>
<p>Пользователь {[from.fullname]} только что выполнил действие <strong>{[event.name]}</strong> for the user {[usertarget.fullname]}.</p>
<p>С уважением,<br>{[admin.fullname]}.</p>';
$string['notification_message_html_mod'] = '<p>Здравствуйте {[to.fullname]},</p>
<p>Пользователь {[to.fullname]} только что выполнил действие <strong>{[event.name]}</strong> in the module {[module.name]} in the course {[course.fullname]}.</p>
<p>С уважением,<br>{[admin.fullname]}.</p>';
$string['notification_message_template_error'] = 'Шаблон должен включать в себя "{[message]}" тег, позволяющий вставлять пользовательский контент.';
$string['notification_new'] = 'Новое уведомление';
$string['notification_notfound'] = 'Уведомление не найдено!';
$string['notification_notound'] = 'Уведомления не найдено!';
$string['notification_setting_config'] = 'Настройки почты';
$string['notification_setting_edit'] = 'Редактировать HTML-код шаблона';
$string['notification_setting_preview'] = 'Предварительный просмотр';
$string['notification_setting_template'] = 'Шаблон';
$string['notification_setting_templatelocation'] = 'Шаблоны находятся в папке';
$string['notification_status'] = 'Статус';
$string['notification_status_deleted'] = 'Удалено';
$string['notification_statusdesc'] = 'Если вы хотите отключить уведомления, отметьте это как "неактивное" и сохраните!';
$string['notification_subject'] = 'Тема';
$string['notification_subjectdesc'] = 'Тема сообщения';
$string['notification_subtitle'] = '<p>Получайте уведомления всякий раз, когда в Moodle происходит какое-либо действие.</p>';
$string['notification_table_action'] = 'Действие';
$string['notification_table_active'] = 'Активно';
$string['notification_table_empty'] = 'Без уведомления!';
$string['notification_table_module'] = 'Модуль';
$string['notification_table_subject'] = 'Тема';
$string['notification_tags'] = 'Какие ТЕГИ заменяются в сообщениях?';
$string['notification_testsmtp'] = 'Проверьте правильность настроек SMTP.';
$string['notification_testsmtp_error'] = 'Moodle не отправляет электронное письмо, если получатель и отправитель совпадают! <br> И вы являетесь главным администратором этого moodle. Итак, для тестирования вы должны войти в систему с помощью другого администратора.';
$string['notification_testsmtp_message'] = '<p> Это тест на отправку электронной почты. </p>';
$string['notification_testsmtp_subject'] = 'Тестирование отправки по электронной почте -';
$string['notification_title'] = 'Уведомления';
$string['notification_to'] = 'To';
$string['notification_todesc'] = 'Кто будет получать эти сообщения?';
$string['notification_todesc_admin'] = 'Администратор сайта (только основной)';
$string['notification_todesc_admins'] = 'Администраторы сайта (все администраторы)';
$string['notification_todesc_student'] = 'Студент (Отправить студенту, выполнившему данное действие)';
$string['notification_todesc_teachers'] = 'Преподаватели курса (только если это относится к одному курсу)';
$string['notification_update'] = 'Предупреждение об обновлении';
$string['notificationsend_course'] = 'Курс для отправки сообщения';
$string['notificationsend_criteria'] = 'Критерии';
$string['notificationsend_criteria_days'] = 'Сколько дней прошло с момента последнего доступа к курсу?';
$string['notificationsend_criteria_days_desc'] = 'Определяет количество дней без доступа к курсу, при котором будет отправлено уведомление. Значение «ноль» применяется ко ВСЕМ студентам.';
$string['notificationsend_criteria_enrol'] = 'Сколько дней прошло с момента зачисления на курс?';
$string['notificationsend_criteria_enrol_desc'] = 'Определяет количество дней с момента зачисления на курс, по истечении которых будет отправлено уведомление. Значение «ноль» применяется ко ВСЕМ студентам.';
$string['notificationsend_send'] = 'Отправить сообщения';
$string['notificationsend_test_title'] = 'Пользователи, которые получат электронное письмо';
$string['notificationsend_title'] = 'Отправить уведомление';
$string['notificationsend_to'] = 'Отправить сообщения';
$string['notificationsend_viewstudentswithcriteria'] = 'Посмотреть студентов с этими критериями';
$string['open_dashboard'] = 'Открыть панель управления';
$string['performancemonitor_cpu'] = 'Использование процессора';
$string['performancemonitor_hd'] = 'Данные Moodle';
$string['performancemonitor_memory'] = 'Память';
$string['performancemonitor_min'] = '{$a} мин:';
$string['performancemonitor_performance'] = 'Представление';
$string['php_datetime'] = 'м/д/г ч:с';
$string['pluginname'] = 'Панель управления';
$string['privacy:metadata'] = 'Панель мониторинга Kopere хранит данные для входа в систему и информацию о доступе к курсу для создания отчетов и анализа использования.';
$string['privacy:metadata:ip'] = 'IP-адрес пользователя во время доступа';
$string['privacy:metadata:user_id'] = 'Уникальный идентификатор пользователя в системе';
$string['processormoreinfo'] = 'В цикле вызывается функция для проверки скорости процессора';
$string['processorname'] = 'Функция вызывалась много раз';
$string['profile_access'] = 'Доступ как';
$string['profile_access_first'] = 'Первый доступ в:';
$string['profile_access_last'] = 'Последний доступ к:';
$string['profile_access_lastlogin'] = 'Последний вход в систему:';
$string['profile_access_title'] = 'Доступ';
$string['profile_courses_title'] = 'Зарегистрированные курсы';
$string['profile_edit'] = 'Отредактируйте эту регистрацию';
$string['profile_enrol_active'] = 'Регистрация активна';
$string['profile_enrol_expires'] = 'Истекает в';
$string['profile_enrol_inactive'] = 'Регистрация неактивна';
$string['profile_enrol_notexpires'] = 'и срок его действия никогда не истекает';
$string['profile_enrol_profile'] = 'Профили';
$string['profile_enrol_start'] = 'Начните с';
$string['profile_invalid'] = 'Неверный идентификатор пользователя!';
$string['profile_link_edit'] = 'Редактировать профиль';
$string['profile_link_profile'] = 'Показать профиль';
$string['profile_link_title'] = 'Полезные ссылки';
$string['profile_notenrol'] = 'Пользователь не имеет регистрации!';
$string['profile_notfound'] = 'Пользователь не найден!';
$string['profile_title'] = 'Пользователи';
$string['profile_userdate_title'] = 'Дата';
$string['querytype1moreinfo'] = 'Проверьте скорость работы базы данных для выполнения сложного запроса';
$string['querytype1name'] = 'Сложный запрос (n°1)';
$string['querytype2moreinfo'] = 'Проверьте скорость работы базы данных для выполнения сложного запроса';
$string['querytype2name'] = 'Сложный запрос (n°2)';
$string['reports_access_n'] = 'был доступный {$a} раз';
$string['reports_activitiesassigned'] = 'Назначенные действия';
$string['reports_activitiescomplete'] = 'Завершенные мероприятия';
$string['reports_add_new'] = 'Новый отчет';
$string['reports_badgename'] = 'Значок';
$string['reports_cohort'] = 'Название когорт';
$string['reports_context'] = 'Контекст';
$string['reports_coursecompleted'] = '% Завершенный курс';
$string['reports_coursecreated'] = 'Дата зачисления';
$string['reports_coursesize'] = 'Файлы курса';
$string['reports_criteriatype'] = 'Критерий';
$string['reports_datacourses'] = 'Данные курса';
$string['reports_datastudents'] = 'Данные о студенте';
$string['reports_dateissued'] = 'В';
$string['reports_disabled'] = 'отключенный: -';
$string['reports_download'] = 'Скачать данные';
$string['reports_export'] = 'Экспорт в Excel';
$string['reports_groupname'] = 'Название группы';
$string['reports_groupnode'] = 'Групповой режим';
$string['reports_lastlogin'] = 'Войдите в систему';
$string['reports_modulessize'] = 'Файлы модулей';
$string['reports_noneaccess'] = 'Доступ закрыт';
$string['reports_notfound'] = 'Отчет не найден!';
$string['reports_report_badge-1'] = 'Все бейджи доступны в Moodle';
$string['reports_report_badge-2'] = 'Все значки, выданные пользователями';
$string['reports_report_courses-1'] = 'Прогресс в процентах выполнения';
$string['reports_report_courses-2'] = 'Курсы, для которых включены группы';
$string['reports_report_courses-3'] = 'Отчет о доступе к курсу';
$string['reports_report_courses-4'] = 'Отчет о посещении курса с оценками';
$string['reports_report_courses-5'] = 'Последний доступ к курсу';
$string['reports_report_enrol_cohort-1'] = 'Группы и пользователи';
$string['reports_report_enrol_guest-1'] = 'Отчет о входах гостей в систему';
$string['reports_report_server-1'] = 'Отчет об использовании диска';
$string['reports_report_user-1'] = 'Количество студентов на каждом курсе';
$string['reports_report_user-2'] = 'Прохождение курса с соблюдением критериев';
$string['reports_report_user-3'] = 'Ежедневный отчет о доступе пользователей';
$string['reports_report_user-4'] = 'Отчет о логинах учащихся';
$string['reports_report_user-5'] = 'Пользователи, которые никогда не входили в систему';
$string['reports_report_user-6'] = 'Пользователи, завершившие курс';
$string['reports_report_user-7'] = 'Зарегистрированные пользователи, которые не заходят на курс';
$string['reports_report_user-8'] = 'Все пользователи';
$string['reports_reportcat_badge'] = 'Отчет о значках';
$string['reports_reportcat_courses'] = 'Отчет о курсе';
$string['reports_reportcat_enrol_cohort'] = 'Групповой отчет';
$string['reports_reportcat_enrol_guest'] = 'Отчет о посетителях';
$string['reports_reportcat_server'] = 'Системный отчет';
$string['reports_reportcat_user'] = 'Отчет пользователя';
$string['reports_selectcourse'] = 'Выберите курс для создания отчета';
$string['reports_settings_form_colunas'] = 'Столбцы';
$string['reports_settings_form_colunas_extra'] = 'Приведенные ниже данные оставляют поле пустым, если вы этого не сделали.\'t то сделайте!';
$string['reports_settings_form_colunas_key'] = 'SQL столбец';
$string['reports_settings_form_colunas_title'] = 'Заглавие';
$string['reports_settings_form_colunas_type'] = 'Тип данных';
$string['reports_settings_form_colunas_type_bytes'] = 'байты';
$string['reports_settings_form_colunas_type_currency'] = 'Валюты';
$string['reports_settings_form_colunas_type_date'] = 'Дата';
$string['reports_settings_form_colunas_type_int'] = 'Номер';
$string['reports_settings_form_colunas_type_text'] = 'Текст';
$string['reports_settings_form_enable'] = 'Включено?';
$string['reports_settings_form_foreach'] = 'изменение SQL столбцов';
$string['reports_settings_form_none'] = 'Пусто';
$string['reports_settings_form_prerequisit'] = 'Обязательное условие перед загрузкой отчета';
$string['reports_settings_form_prerequisit_badge_criteria_type'] = 'Измените критерии для бейджа на текстовые';
$string['reports_settings_form_prerequisit_badge_status_text'] = 'Измените статус значка на текстовый';
$string['reports_settings_form_prerequisit_courses_group_mode'] = 'Укажите групповой режим в тексте';
$string['reports_settings_form_prerequisit_listCourses'] = 'Список курсов';
$string['reports_settings_form_prerequisit_userfullname'] = 'Выполнить полное имя ($ user) в каждой строке отчета';
$string['reports_settings_form_reportsql'] = 'Отчет SQL';
$string['reports_settings_form_save'] = 'Сохранить отчет';
$string['reports_settings_form_title'] = 'Редактировать отчет';
$string['reports_settings_savesuccess'] = 'Успешно сохранено!';
$string['reports_settings_title'] = 'Редактировать отчет';
$string['reports_timecreated'] = 'Зарегистрировано в';
$string['reports_title'] = 'Отчеты';
$string['saved_successfully'] = 'Сохранено успешно';
$string['select'] = 'Выбрать';
$string['select_month'] = 'Выберите месяц';
$string['setting_saved'] = 'Настройки сохранены!';
$string['settings'] = 'Настройки';
$string['tags_message'] = '<h2>Заглавие</h2><p>Строка 1</p><p>Строка 2</p>';
$string['user_table_celphone'] = 'Мобильный';
$string['user_table_city'] = 'Город';
$string['user_table_email'] = 'E-mail';
$string['user_table_fullname'] = 'Имя';
$string['user_table_phone'] = 'Основной № телефона';
$string['user_table_username'] = 'Имя пользователя';
$string['user_title'] = 'Пользователи';
$string['useraccess_title'] = 'Доступ пользователя';
$string['userenrolment_created'] = 'Набор, созданный в';
$string['userenrolment_detail'] = 'Регистрационные данные';
$string['userenrolment_edit'] = 'Изменить дату регистрации';
$string['userenrolment_notfound'] = 'Регистрация пользователя не найдена!';
$string['userenrolment_status'] = 'Регистрация является';
$string['userenrolment_status_active'] = 'Включено';
$string['userenrolment_status_inactive'] = 'Выключено';
$string['userenrolment_timeend'] = 'Подписка заканчивается в';
$string['userenrolment_timeendstatus'] = 'Включить срок действия подписки';
$string['userenrolment_timestart'] = 'Подписка начинается с';
$string['userenrolment_updated'] = 'Данные о зачислении, измененные в последний раз в';
$string['userenrolment_updatesuccess'] = 'Количество участников успешно изменилось!';
$string['userimport_colname'] = 'Столбец {$a}';
$string['userimport_colselect'] = '..::Выбор столбца::..';
$string['userimport_courseenrol'] = 'Записаться на курс';
$string['userimport_courseenrol_desc'] = 'Если вы хотите, чтобы студент был зачислен на какой-либо курс, выберите столбец идентификатор курса.';
$string['userimport_cript'] = '--зашифрованный--';
$string['userimport_datanotok'] = 'Не в порядке, я кое-что забыл';
$string['userimport_dataok'] = 'Данные в порядке, вставляем в Moodle';
$string['userimport_date_desc'] = 'Система автоматически определяет основной формат даты.';
$string['userimport_empty'] = 'Если вы не выберете его, он будет использовать значение по умолчанию "{$a}"';
$string['userimport_event_import_course_enrol_message'] = '<p>Здравствуйте {[to.fullname]},</p>
<p>Вы были успешно зачислены на {[course.fullname]}. Теперь вы можете войти в личный кабинет студента и начать обучение в любое удобное для вас время и в любом месте.</p>
<p>С большим удовлетворением отмечаю, что {[moodle.fullname]} мы Вам очень рады.</p>
<p>Доступ {{course.link}}, и хорошей учебы.</p>
<p>Если у вас есть какие-либо сомнения, вы всегда можете обратиться за помощью.</p>
<p>Искренне,<br>
Команда поддержки</p>';
$string['userimport_event_import_course_enrol_subject'] = 'Добро пожаловать - {[course.fullname]}';
$string['userimport_event_import_user_created_and_enrol_message'] = '<p>Здравствуйте {[to.fullname]},</p>
<p>Вы были успешно зачислены на {[course.fullname]}. Теперь вы можете войти в личный кабинет студента и начать обучение в любое удобное для вас время и в любом месте.</p>
<p>Теперь я приглашаю вас войти в личный кабинет студента, указав следующие данные:</p>
<p><strong>Сайт:</strong> {[moodle.link]}<br>
   <strong>Учетная запись:</strong> {[to.username]}<br>
   <strong>Пароль:</strong> {[to.password]}</p>
<p>Если у вас есть какие-либо сомнения, вы всегда можете обратиться за помощью.</p>
<p>Искренне,<br>
Команда поддержки</p>';
$string['userimport_event_import_user_created_and_enrol_subject'] = 'Добро пожаловать - {[course.fullname]}';
$string['userimport_event_import_user_created_message'] = '<p>Здравствуйте {[to.fullname]},</p>
<p>Для вас была создана учетная запись на сайте {[moodle.fullname]}.</p>
<p>Теперь я приглашаю вас войти в личный кабинет студента, указав следующие данные:</p>
<p><strong>Сайт:</strong> {[moodle.link]}<br>
   <strong>Учетная запись:</strong> {[to.username]}<br>
   <strong>Пароль:</strong> {[to.password]}</p>
<p>Если у вас есть какие-либо сомнения, вы всегда можете обратиться за помощью.</p>
<p>Искренне,<br>
Команда поддержки</p>';
$string['userimport_event_import_user_created_subject'] = 'Добро пожаловать! - {[moodle.fullname]}';
$string['userimport_exist'] = 'Пользователь уже существует.';
$string['userimport_filenotfound'] = 'Файл "{$a}" не был найден. Загрузите CSV файл еще раз!';
$string['userimport_first10'] = 'Первые 10 записей из вашего CSV';
$string['userimport_firstname'] = 'Только имя или имя и отчество';
$string['userimport_firstname_desc'] = 'Если у вас есть полное имя в формате CSV, просто заполните это поле, Kopere будет отвечать за создание обоих полей. Если в вашем CSV есть имя и фамилия, выберите это и фамилию.';
$string['userimport_group_desc'] = 'Если вы хотите, чтобы студент был привязан к группе на курсе, столбец должен совпадать с названием группы или внутренним идентификатором.';
$string['userimport_import_course_enrol_name'] = 'Импортированный пользователь был зачислен на курс';
$string['userimport_import_user_created_and_enrol_name'] = 'Импортированный пользователь, зарегистрированный в Moodle и курсе';
$string['userimport_import_user_created_name'] = 'Пользователь импортирован и зарегистрирован в Moodle';
$string['userimport_inserted'] = 'Пользавотель в системе';
$string['userimport_linkall'] = 'Нажмите здесь, чтобы просмотреть все записи в формате CSV';
$string['userimport_messageinactive'] = 'Сообщение, озаглавленное{$a} является неактивным и не будет отправлено';
$string['userimport_messages'] = 'Сообщения, которые учащиеся получат во время импорта';
$string['userimport_moveuploadedfile_error'] = 'ОШИБКА при перемещении файла!';
$string['userimport_next'] = 'Обработка';
$string['userimport_noterror'] = 'Ошибки не обнаружены';
$string['userimport_notreceivemessage'] = 'При выполнении этого действия пользователь не будет получать никаких сообщений!';
$string['userimport_passcreate'] = '--Он будет создан--';
$string['userimport_receivemessage'] = 'Пользователь получит сообщение с заголовком {$a}';
$string['userimport_referencedata'] = 'Обращение к данным Moodle в формате CSV';
$string['userimport_separator_error'] = 'Вы должны экспортировать CSV-файл с разделителем "; Или ","!';
$string['userimport_title'] = 'Импорт пользователей';
$string['userimport_title_proccess'] = 'Обработка файла "{$a}"';
$string['userimport_upload'] = 'Перетащите CSV-файлы сюда или нажмите, чтобы открыть окно поиска.';
$string['userimport_userdata'] = 'Данные пользователя';
$string['userimport_userfields'] = 'Дополнительные поля профиля';
$string['userimport_wait'] = 'Пожалуйста, дождитесь обработки данных. После обработки будет доступна электронная таблица со вставленными данными.';
$string['useronline_subtitle'] = 'Открывайте вкладки с помощью Moodle';
$string['useronline_table_date'] = 'Данные';
$string['useronline_table_device'] = 'Устройство';
$string['useronline_table_focus'] = 'Фокус';
$string['useronline_table_fullname'] = 'Имя';
$string['useronline_table_navigator'] = 'Браузер';
$string['useronline_table_os'] = 'Операционная система';
$string['useronline_table_page'] = 'Страница';
$string['useronline_table_screen'] = 'Монитор';
$string['useronline_title'] = 'Пользователиъ онлайн';
$string['visible'] = 'Видимый';
$string['vvveb_footer_contact_title_default'] = 'Связаться с нами';
$string['vvveb_home_access'] = 'Доступ к курсу';
$string['vvveb_home_automatically_my_course'] = 'Не редактировать. Этот блок будет автоматически заменен курсами, на которые записан студент..';
$string['vvveb_home_mycourses_heading'] = 'Мои курсы';
$string['vvveb_home_popular_course'] = 'Популярные курсы';
$string['vvveb_home_team_subtitle'] = 'Мы - группа профессионалов, преданных своему делу';
$string['vvveb_home_team_title'] = 'Познакомьтесь с нашей командой';
$string['webpages_access'] = 'Перейти на страницу';
$string['webpages_allpages'] = 'Все страницы';
$string['webpages_error_menu'] = 'Меню не обнаружено!';
$string['webpages_error_page'] = 'Страница не найдена!';
$string['webpages_free'] = 'Свободно';
$string['webpages_menu_create'] = 'Создать новое меню';
$string['webpages_menu_created'] = 'Меню создано!';
$string['webpages_menu_delete'] = 'Исключающее меню';
$string['webpages_menu_deleted'] = 'Меню успешно удалено!';
$string['webpages_menu_edit'] = 'Редактирование меню';
$string['webpages_menu_error'] = 'Все данные должны быть заполнены!';
$string['webpages_menu_help'] = 'Помощь с меню';
$string['webpages_menu_inheader'] = 'Отображение в верхнем меню';
$string['webpages_menu_link'] = 'Ссылка на меню';
$string['webpages_menu_link_duplicate'] = '"Ссылка" дубликат!';
$string['webpages_menu_menuid'] = 'Подменю';
$string['webpages_menu_new'] = 'Новое меню';
$string['webpages_menu_nodelete'] = 'Вы не можете удалить меню, в котором зарегистрированы страницы!';
$string['webpages_menu_save'] = 'Сохранить';
$string['webpages_menu_subtitle'] = 'Статическое меню';
$string['webpages_menu_title'] = 'Название меню';
$string['webpages_menu_updated'] = 'Меню обновлено!';
$string['webpages_page_analytics'] = 'Идентификатор Google Analytics';
$string['webpages_page_analyticsdesc'] = 'Последовательность из 13 символов, начинающаяся на UA';
$string['webpages_page_confirmdeletemenu'] = '<p>Вы действительно хотите удалить <strong>{$a}</strong> меню?</p>';
$string['webpages_page_course'] = 'Связанный курс';
$string['webpages_page_crash'] = 'Если вы изменили URL-адрес Moodle и изображения перестали работать, нажмите здесь';
$string['webpages_page_create'] = 'Создать новую страницу';
$string['webpages_page_created'] = 'Созданная страница!';
$string['webpages_page_delete'] = 'Исключая страницу';
$string['webpages_page_delete_confirm'] = 'Вы действительно хотите удалить эту страницу <strong>{$a->Заглавие}</strong>?';
$string['webpages_page_deleted'] = 'Страница успешно удалена!';
$string['webpages_page_edit'] = 'Редактирование страницы';
$string['webpages_page_error'] = 'Все данные должны быть заполнены!';
$string['webpages_page_menu'] = 'Меню';
$string['webpages_page_new'] = 'Новая страница';
$string['webpages_page_nomenudelete'] = '<p>Это меню содержит внутренние страницы и не может быть удалено!</p>';
$string['webpages_page_notfound'] = 'Страница не найдена!';
$string['webpages_page_save'] = 'Сохранить страницу';
$string['webpages_page_settigs'] = 'Настройки статических страниц';
$string['webpages_page_theme'] = 'Макет страницы "Все страницы"';
$string['webpages_page_title'] = 'Заглавие';
$string['webpages_page_updated'] = 'Обновленная страница!';
$string['webpages_page_view'] = 'Просмотр страницы';
$string['webpages_subtitle'] = 'Навигационные меню';
$string['webpages_subtitle_help'] = 'Эти меню отображаются в разделе "Навигация" в разделе "Мои курсы".';
$string['webpages_table_image'] = 'Выберите изображение или перетащите его сюда.';
$string['webpages_table_link'] = 'Ссылка';
$string['webpages_table_menutitle'] = 'Меню';
$string['webpages_table_order'] = 'Приказ';
$string['webpages_table_text'] = 'Содержимое страницы';
$string['webpages_table_text_edit'] = 'Редактировать содержимое страницы';
$string['webpages_table_text_not'] = 'Сначала сохраните содержимое, чтобы вы могли создать страницу позже.';
$string['webpages_table_theme'] = 'Макет';
$string['webpages_table_title'] = 'Заглавие';
$string['webpages_table_visible'] = 'Видимый';
$string['webpages_theme_base'] = 'Макет без блоков';
$string['webpages_theme_frametop'] = 'Отсутствие блоков и минимальный нижний колонтитул';
$string['webpages_theme_frontpage'] = 'Макет сайта\'домашней страницы.';
$string['webpages_theme_popup'] = 'Ни навигации, ни блоков, ни заголовка';
$string['webpages_theme_print'] = 'Должен отображаться только контент и основные заголовки';
$string['webpages_theme_report'] = 'Макет страницы, используемый для составления отчетов';
$string['webpages_theme_standard'] = 'Макет по умолчанию с блоками';
$string['webpages_title'] = 'Статические страницы';
