<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'filter_filtercodes', language 'sv', version '4.4'.
 *
 * @package     filter_filtercodes
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['brief'] = 'Kortfattad';
$string['categorycardshowpic'] = 'Visa {categorycards}-bakgrund';
$string['categorycardshowpic_desc'] = 'Om aktiverat visas en bakgrundsfärg/ett bakgrundsmönster för taggen {categorycards} som liknar kursbilderna när ingen bild har angetts.';
$string['chartprogressbarlabel'] = '{$a->label}: {$a->value}';
$string['contentmissing'] = '<h1>Innehållet saknas.</h1><p>Vänligen kontakta administratören.</p>';
$string['coursecardsbyenrol'] = 'Max antal {coursecardsbyenrol}-kort.';
$string['coursecardsbyenrol_desc'] = 'Maximalt antal kurskort som ska visas för taggen {coursecardsbyenrol}. Sätt till noll för obegränsat antal (rekommenderas inte).';
$string['coursecontactlinktype'] = 'Länktyp för kontakt';
$string['coursecontactlinktype_desc'] = 'Välj typ av länk för kontakt-länkar i {coursecontacts}-taggarna.';
$string['coursecontactshowdesc'] = 'Visa profilbeskrivning för kontakten.';
$string['coursecontactshowdesc_desc'] = 'Om aktiverat visas kontaktens profilbeskrivning i {coursecontacts}-taggarna.';
$string['coursecontactshowpic'] = 'Visa bild för kontakt';
$string['coursecontactshowpic_desc'] = 'Om aktiverat visas kontaktens bild i {coursecontacts}-taggarna.';
$string['defaultemail'] = '';
$string['defaultfirstname'] = '';
$string['defaultsurname'] = '';
$string['defaultusername'] = '';
$string['disabled_customnav_description'] = '<strong>Anmärkning gällande stöd för anpassad meny</strong> – Om du vill aktivera stöd för <em>FilterCodes</em> på Moodle-webbplatsens anpassade meny kan du behöva anpassa temat eller Moodle-kärnan. <a href="https://github.com/michael-milette/moodle-filter_filtercodes#can-i-use-filtercodes-in-moodles-custom-menus">Information om hur man lägger till <em>FilterCodes</em> i anpassade menyer</a>.';
$string['enable_customnav'] = 'Stöd för anpassad navigering';
$string['enable_customnav_description'] = '<strong>Experimentell funktion</strong>: Aktivera stöd för FilterCode-taggar i Moodles anpassade navigeringsmeny.
OVS! Är endast kompatibelt med  <em>Clean-</em> och <em>Boost-</em>baserade teman i Moodle 3.2 - 3.4. Filtrerar inte taggar i sidan temainställningar i Moodle.';
$string['enable_scrape'] = 'Stöd för Scrape-tagg';
$string['enable_scrape_description'] = 'Aktivera Scrape-taggen';
$string['escapebraces'] = 'Escape-taggar';
$string['escapebraces_desc'] = 'När det här alternativet är markerat kan du visa FilterCode-taggar utan att de tolkas av det här filtret genom att radbryta taggen i [ hakparenteser ]. Detta kan vara mycket användbart när du skapar FilterCodes-dokumentation för lärare och kursskapare på din Moodle-webbplats.<br><br>Exempel: [{fullname}] visar inte användarens fullständiga namn utan visar taggen {fullname} utan hakparenteserna.';
$string['filtername'] = 'Filterkoder';
$string['formcheckin'] = '<form action="{wwwroot}/local/contact/index.php" method="post" class="cf check-in">
    <fieldset>
        <input type="hidden" id="subject" name="subject" value="Närvarande!">
        <input type="hidden" id="sesskey" name="sesskey" value="">
        <script>document.getElementById("sesskey").value = M.cfg.sesskey;</script>
        {recaptcha}
    </fieldset>
    <div>
        <input type="submit" name="submit" id="submit" value="Här är jag!">
    </div>
</form>';
$string['formcontactus'] = '<form action="{wwwroot}/local/contact/index.php" method="post" class="cf contact-us">
    <fieldset>
        <div class="form-group">
            <label for="name" id="namelabel" class="d-block">Ditt namn <strong class="required">(obligatoriskt)</strong></label>
            <input id="name" name="name" type="text" size="57" maxlength="45" pattern="[A-zÀ-ž]([A-zÀ-ž\\s]){2,}"
                    title="Minimum 3 letters/spaces." required="required" {readonly}{ifloggedin} disabled{/ifloggedin} value="{fullname}">
        </div>
        <div class="form-group">
            <label for="email" id="emaillabel" class="d-block">E-post <strong class="required">(obligatoriskt)</strong></label>
            <input id="email" name="email" type="email" size="57" maxlength="60"
                    required="required" {readonly}{ifloggedin} disabled{/ifloggedin} value="{email}">
        </div>
        <div class="form-group">
            <label for="subject" id="subjectlabel" class="d-block">Ämne <strong class="required">(obligatoriskt)</strong></label>
            <input id="subject" name="subject" type="text" size="57" maxlength="80" minlength="5"
                    title="Minst 5 tecken." required="required">
        </div>
        <div class="form-group">
            <label for="message" id="messagelabel" class="d-block">Meddelande <strong class="required">(obligatoriskt)</strong></label>
            <textarea id="message" name="message" rows="5" cols="58" minlength="5"
                    title="Minst 5 tecken." required="required"></textarea>
        </div>
        <input type="hidden" id="sesskey" name="sesskey" value="">
        <script>document.getElementById("sesskey").value = M.cfg.sesskey;</script>
        {recaptcha}
    </fieldset>
    <div>
        <input type="submit" name="submit" id="submit" value="Skicka">
    </div>
</form>';
$string['formcourserequest'] = '<form action="{wwwroot}/local/contact/index.php" method="post" class="cf new-course-request">
    <fieldset>
        <div class="form-group">
            <label for="name" id="namelabel" class="d-block">Ditt namn <strong class="required">(obligatoriskt)</strong></label>
            <input id="name" name="name" type="text" size="57" maxlength="45" pattern="[A-zÀ-ž]([A-zÀ-ž\\s]){2,}"
                    title="Minst 3 bokstäver/blanksteg." required="required" {readonly}{ifloggedin} disabled{/ifloggedin} value="{fullname}">
        </div>
        <div class="form-group">
            <label for="email" id="emaillabel" class="d-block">E-post <strong class="required">(obligatoriskt)</strong></label>
            <input id="email" name="email" type="email" size="57" maxlength="60" required="required" {readonly}{ifloggedin} disabled{/ifloggedin} value="{email}">
        </div>
        <div class="form-group">
            <label for="new_course_name" id="new_course_namelabel" class="d-block">Föreslaget namn för den nya kursen <strong class="required">(required)</strong></label>
            <input id="new_course_name" name="new_course_name" type="text" size="57" maxlength="80" minlength="5"
                    title="Minst 5 tecken." required="required">
        </div>
        <div class="form-group">
            <label for="description" id="descriptionlabel" class="d-block">Kursbeskrivning <strong class="required">(obligatoriskt)</strong></label>
            <textarea id="description" name="description" rows="5" cols="58" minlength="5"
                    title="Minst 5 tecken." required="required"></textarea>
        </div>
        <input type="hidden" id="sesskey" name="sesskey" value="">
        <script>document.getElementById("sesskey").value = M.cfg.sesskey;</script>
        {recaptcha}
    </fieldset>
    <div>
        <input type="submit" name="submit" id="submit" value="Skicka in förfrågan för den här kursen">
    </div>
</form>';
$string['formquickquestion'] = '<form action="{wwwroot}/local/contact/index.php" method="post" class="cf contact-us">
    <fieldset>
        <div class="form-group">
            <label for="subject" id="subjectlabel" class="d-block">Ämne <strong class="required">(obligatoriskt)</strong></label>
            <input class="block" id="subject" name="subject" type="text" size="57" maxlength="80" minlength="5"
                    title="Minst 5 tecken." required="required">
        </div>
        <div class="form-group">
            <label for="message" id="messagelabel" class="d-block">Meddelande <strong class="required">(obligatoriskt)</strong></label>
            <textarea id="message" name="message" rows="5" cols="58" minlength="5"
                    title="Minst 5 tecken." required="required"></textarea>
        </div>
        <input type="hidden" id="sesskey" name="sesskey" value="">
        <script>document.getElementById("sesskey").value = M.cfg.sesskey;</script>
        {recaptcha}
    </fieldset>
    <div>
        <input type="submit" name="submit" id="submit" value="Skicka">
    </div>
</form>';
$string['formsupport'] = '<form action="{wwwroot}/local/contact/index.php" method="post" class="cf support-request">
    <fieldset>
        <div class="form-group">
            <label for="name" id="namelabel" class="d-block">Ditt namn <strong class="required">(obligatoriskt)</strong></label>
            <input id="name" name="name" type="text" size="57" maxlength="45" pattern="[A-zÀ-ž]([A-zÀ-ž\\s]){2,}"
                    title="Minst 3 bokstäver/blanksteg." required="required" {readonly}{ifloggedin} disabled{/ifloggedin} value="{fullname}">
        </div>
        <div class="form-group">
            <label for="email" id="emaillabel" class="d-block">E-post <strong class="required">(obligatoriskt)</strong></label>
            <input id="email" name="email" type="email" size="57" maxlength="60" required="required" {readonly}{ifloggedin} disabled{/ifloggedin} value="{email}">
        </div>
        <div class="form-group">
            <label for="subject" id="subjectlabel" class="d-block">Ämne <strong class="required">(obligatoriskt)</strong></label>
            <select id="subject" name="subject" required="required">
                <option label="Välj ämne"></option>
                <option>Jag kan inte ändra mitt lösenord</option>
                <option>Jag kan inte logga in</option>
                <option value="Suggestion">Jag har ett förslag</option>
                <option value="Error message">Jag får ett felmeddelande</option>
                <option value="System error">Det är något som inte fungerar som det ska</option>
                <option value="Course">Jag kommer inte åt en kurs eller kursinnehåll</option>
                <option value="Other reason">Annat (vänligen förtydliga)</option>
            </select>
        </div>
        <div class="form-group">
            <label for="specific_subject" id="specifylabel" class="d-block">Specifikt ämne eller kursnamn&nbsp;<strong class="required">(obligatoriskt)</strong></label>
            <input type="text" id="specific_subject" name="specific_subject" size="57" maxlength="80" required="required">
        </div>
        <div class="form-group">
            <label for="url" id="urllabel" class="d-block">Ange webbadressen</label>
            <input type="url" id="url" name="url" size="57" maxlength="80" value="{referer}">
        </div>
        <div class="form-group">
            <label for="description" id="descriptionlabel" class="d-block">Beskrivning och steg-för-steg instruktioner hur felet kan återskapas&nbsp;<strong class="required">(obligatoriskt)</strong></label>
            <textarea id="description" name="description" rows="5" cols="58" minlength="5"
                    title="Minst 5 tecken." required="required"></textarea>
        </div>
        <input type="hidden" id="sesskey" name="sesskey" value="">
        <script>document.getElementById("sesskey").value = M.cfg.sesskey;</script>
        {recaptcha}
    </fieldset>
    <div>
        <input type="submit" name="submit" id="submit" value="Skicka in supportärende">
    </div>
</form>';
$string['globaltagcontentdesc'] = 'Det här är innehållet som din globala tagg kommer att ersätta. Exempel: Om taggen heter "{global_address}" ersätts taggen av innehållet som anges i det här fältet.';
$string['globaltagcontenttitle'] = 'Innehåll';
$string['globaltagcount'] = 'Antal globala taggar.';
$string['globaltagcountdesc'] = 'Välj antalet taggar som du vill definiera. För optimal prestanda väljer du bara det antal du behöver.';
$string['globaltagheadingdesc'] = 'Definiera dina egna globala taggar, ibland även kallade <em>globala block</em>.';
$string['globaltagheadingtitle'] = 'Globala anpassade taggar';
$string['globaltagnamedesc'] = 'Detta kommer att vara en del av ditt taggnamn med prefixet "global_". Exempel: Om du anger "adress" här kommer taggen att kallas {global_adress}". Namnet får enbart bestå av en enda sträng med bokstäver - inga blanksteg, siffror eller specialtecken är tillåtna.';
$string['globaltagnametitle'] = 'Tagg: global_';
$string['hidecompletedcourses'] = 'Dölj slutförda kurser';
$string['hidecompletedcourses_desc'] = 'Aktivera för att filtrera bort slutförda kurser i taggarna {mycoursesmenu}.';
$string['ifprofilefiedonlyvisible'] = '{ifprofile_field_} enbart synliga.';
$string['ifprofilefiedonlyvisible_desc'] = 'Begränsa taggen {ifprofile_field_...} så att den endast får åtkomst till synliga profilfält. Dolda fält fungerar som om fältet vore tomt. Om det här alternativet inte är markerat kan den här taggen kontrollera dolda användarfält.';
$string['narrowpage'] = 'Smal sida';
$string['narrowpage_desc'] = 'Aktivera detta alternativ för att optimera visningen av information om Moodle använder ett tema med begränsad sidbredd (t.ex. Boost i Moodle 4.0)';
$string['pagebuilder'] = 'Sidbyggare';
$string['pagebuilderlink'] = 'https://www.layoutit.com/build';
$string['photoeditor'] = 'Bildredigerare';
$string['photoeditorlink'] = 'https://pixlr.com/editor/';
$string['pluginname'] = 'Filterkoder';
$string['privacy:metadata'] = 'Pluginmodulen Filterkoder lagrar ingen personinformation.';
$string['screenrec'] = 'Skärminspelare';
$string['screenreclink'] = 'https://screenapp.io/#/recording';
$string['sizeb'] = 'B';
$string['sizeeb'] = 'EB';
$string['sizegb'] = 'GB';
$string['sizekb'] = 'KB';
$string['sizemb'] = 'MB';
$string['sizetb'] = 'TB';
$string['sizeyb'] = 'YB';
$string['sizezb'] = 'ZB';
$string['teamcardsformat'] = 'Format för teamkort';
$string['teamcardsformat_desc'] = 'Välj hur gruppmedlemmarna ska visas i taggen {teamcards}. <br>
<ul>
<li>Ingen: Visar bara bilden och namnet som ett kort utan användarbeskrivningen.</li>
<li>Ikon: Samma som <em>Ingen</em> förutom att användarbeskrivningen visas i en pop-up.</li>
<li>Kortfattad: Samma som <em>Ingen</em> men där användarbeskrivningen visas under användarbilden och namnet.</li>
<li>Utförlig: Användarna visas som en lista. Rekommenderas om dina teammedlemmar tenderar att ha långa användarbeskrivningar.</li>
</ul>';
$string['teamcardslinktype'] = 'Länktyp för team';
$string['teamcardslinktype_desc'] = 'Välj typ av länk för gruppmedlemmens länk i taggen {teamcards}. <strong>OBS!</strong> Foto länkas automatiskt till profilen när användaren är inloggad, oavsett vad du väljer här.';
$string['verbose'] = 'Utförlig';
