<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'theme_degrade', language 'ru', version '4.4'.
 *
 * @package     theme_degrade
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['background_color'] = 'Цвет фона';
$string['background_color_default'] = 'Тема по умолчанию {$a}';
$string['background_color_desc'] = 'Цвет фона верхнего и нижнего колонтитула';
$string['background_text_color'] = 'Цвет текста';
$string['background_text_color_desc'] = 'Цвет текста верхнего и нижнего колонтитула';
$string['choosereadme'] = 'Degrade — это тема, созданная с заботой, чтобы добавить радостные цвета в Moodle.';
$string['contact_address'] = 'Адрес';
$string['contact_email'] = 'Электронная почта';
$string['contact_phone'] = 'Телефон';
$string['content_pagefonts'] = 'Дополнительные шрифты Google';
$string['content_pagefonts_desc'] = 'Добавьте сюда ссылку @import из Google для дополнительных шрифтов.<br>Вы можете добавить несколько шрифтов.<br><a href="https://fonts.google.com/selection/embed" target="google">Код для вставки</a><br><img src="{$a}" style="max-width: 100%;width: 420px;">';
$string['content_type_default'] = 'По умолчанию в Moodle';
$string['content_type_empty'] = '(Нет контента)';
$string['content_type_footer'] = 'Тип контента для нижнего колонтитула';
$string['content_type_footer_desc'] = 'Выберите тип контента, который вы хотите отображать в нижнем колонтитуле.';
$string['content_type_home'] = 'Тип контента для главной страницы';
$string['content_type_home_desc'] = 'Выберите тип контента, который вы хотите отображать на главной странице.';
$string['content_type_html'] = 'Страница, создаваемая с помощью редактора';
$string['continuar'] = 'Продолжить обучение';
$string['countlesson'] = '{$a} урок';
$string['countlessons'] = 'уроков - {$a}';
$string['course_access'] = 'Получить доступ к курсу';
$string['course_moore'] = 'Подробнее';
$string['customcss_desc'] = 'Любые CSS-правила, добавленные в это текстовое поле, будут применены на всех страницах, что упрощает настройку данной темы.';
$string['custommenuitems'] = 'Пункты пользовательского верхнего меню';
$string['custommenuitems_desc'] = 'Вы можете создать пользовательское меню рядом с верхними меню. Основное меню должно начинаться от края, а в подменю должен предшествовать дефис (-). Количество дефисов определяет уровень вложенности пункта. Таким образом, элементы с одним дефисом появляются в подменю под предыдущим пунктом верхнего уровня, а элементы с двумя дефисами — в подменю под предыдущим подменю.
Содержимое каждого пункта меню должно состоять из трех элементов (<strong>метка</strong> | <strong>URL</strong> | <strong>всплывающая подсказка</strong> | <strong>язык</strong>), разделенных символом «|».
<ul>
<li><strong>метка</strong>: текст, который будет отображаться в пункте меню. Для каждого пункта меню необходимо указать метку.</li>
<li><strong>URL</strong>: ссылка, куда пользователь перейдет при щелчке на пункте меню. Это необязательно; если не указано, пункт никуда не ведет.<br>
Другие атрибуты, такие как «target», можно добавить в конец URL.</li>
<li><strong>всплывающая подсказка</strong>: если вы указали URL, то также можете добавить всплывающую подсказку для ссылки. Это необязательно, если не задано, используется метка как подсказка.</li>
<li><strong>язык</strong>: Вы можете добавить код языка (или список кодов через запятую) как четвертый элемент строки. Строка будет отображаться только если пользователь выбрал указанный язык(и).</li>
</ul>
Пример создания пользовательского меню:
<blockquote><pre>
Курсы
-Все курсы | /course/
-Мои курсы
--Пример курса
---Пример курса 7 | /course/view.php?id=7
---Пример курса 9 | /course/view.php?id=9
--Тестовый курс
---Тестовый курс 2 | /course/view.php?id=2
---Тестовый курс 5 | /course/view.php?id=5
Google
-Google на любом языке | https://google.com/" target="_blank
-Google в Мексике | https://www.google.com.mx/" target="_blank|Google Label|en
-Google на португальском | https://google.com.br/" target="_blank|Google Label|pt,pt_br,pt_br_kids
Страница поддержки | https://support.com/" target="_blank
</pre></blockquote>
Для Moodle с поддержкой нескольких языков значение <strong>метка</strong> должно быть в формате <strong>"langstringname,componentname"</strong>.
<blockquote><pre>
profile,moodle | /user/profile.php
messages,message | /message/index.php
</pre></blockquote>
<a href="https://docs.moodle.org/404/en/Advanced_theme_settings" target="_blank">Дополнительная информация о меню</a>';
$string['editor_link_footer'] = 'Редактировать блок нижнего колонтитула для языка {$a}';
$string['editor_link_footer_all'] = 'Редактировать блок нижнего колонтитула для всех языков';
$string['editor_link_home'] = 'Редактировать главную страницу для языка {$a}';
$string['editor_link_home_all'] = 'Редактировать главную страницу для всех языков';
$string['favicon'] = 'Фавикон';
$string['favicon_desc'] = 'Фавикон отображается рядом с названием страницы во вкладке браузера. Если пользовательский фавикон не задан, отображается фавикон Moodle.';
$string['fontfamily'] = 'Шрифты текста сайта';
$string['fontfamily_desc'] = 'Выберите шрифт, который вы хотите использовать для текста на своем сайте Moodle.';
$string['fontfamily_menus'] = 'Шрифты меню';
$string['fontfamily_menus_desc'] = 'Выберите шрифт, который вы хотите использовать для меню на своем сайте Moodle.';
$string['fontfamily_sitename'] = 'Шрифт для названия сайта';
$string['fontfamily_sitename_desc'] = 'Шрифт, который будет применен к названию сайта, если не предоставлен логотип.';
$string['fontfamily_title'] = 'Шрифты заголовков';
$string['fontfamily_title_desc'] = 'Выберите шрифт, который вы хотите использовать для заголовков на своем сайте Moodle.';
$string['fontpreview'] = 'Предпросмотр списка шрифтов';
$string['footer_contact_title'] = 'Заголовок блока контактов';
$string['footer_contact_title_default'] = 'Свяжитесь с нами';
$string['footer_contact_title_desc'] = 'Введите заголовок блока, который будет отображаться в нижнем колонтитуле с контактной информацией.';
$string['footer_description'] = 'Описание';
$string['footer_description_desc'] = 'Опишите свой Moodle, чем вы занимаетесь, и эта информация будет отображаться под логотипом в нижнем колонтитуле Moodle';
$string['footer_frontpage_blockcourses_instructor'] = 'Показать имена преподавателей';
$string['footer_frontpage_blockcourses_instructor_desc'] = 'Если отмечено, то имена преподавателей отображаются в списке курсов.';
$string['footer_frontpage_blockcourses_text'] = 'Краткий текст, объясняющий блок «{$a}»';
$string['footer_frontpage_blockcourses_text_desc'] = 'Добавьте текст, рассказывающий о «{$a}»';
$string['footer_links_title'] = 'Заголовок блока ссылок';
$string['footer_links_title_default'] = 'Важные ссылки';
$string['footer_show_copywriter'] = 'Показать «Сделано с ❤️»';
$string['footer_show_copywriter_desc'] = 'Снимите отметку, если хотите скрыть «Сделано с ❤️»';
$string['footer_social_title'] = 'Заголовок блока социальных сетей';
$string['footer_social_title_default'] = 'Подпишитесь на нас в социальных сетях';
$string['footer_social_title_desc'] = 'Введите заголовок блока, который будет отображаться в нижнем колонтитуле с данными из ваших социальных сетей.';
$string['footerblink'] = 'Ссылки нижнего колонтитула';
$string['footerblink_desc'] = 'Вы можете настроить блок ссылок нижнего колонтитула, который будет отображаться в темах.<br>Каждая строка состоит из текста меню или ключа языка (текста), URL-адреса ссылки (необязательно), разделенных вертикальной чертой. Например:<br><pre>Поддержка Moodle|https://moodle.org/support</pre>';
$string['footerblock_contact'] = 'Блок контактов';
$string['footerblock_copywriter'] = 'Сделано с ❤️';
$string['footerblock_description'] = 'Блок описания';
$string['footerblock_links'] = 'Блок ссылок';
$string['footerblock_social'] = 'Блок социальных сетей';
$string['free_name'] = 'Бесплатно';
$string['frontpage_about_description'] = 'Опишите, чем вы занимаетесь';
$string['frontpage_about_description_desc'] = 'Опишите цель своего Moodle максимум в 5 строках';
$string['frontpage_about_enable'] = 'Включить блок «О нас»';
$string['frontpage_about_enable_desc'] = 'Если отмечено, блок «О нас» будет отображаться под баннером.';
$string['frontpage_about_info'] = 'Блок данных {$a}';
$string['frontpage_about_logo'] = 'Другой логотип для отображения здесь';
$string['frontpage_about_logo_desc'] = 'Если задано, этот логотип будет использоваться вместо верхнего логотипа.<br>
Если пусто, то используется верхний логотип!';
$string['frontpage_about_number'] = 'Количество данных';
$string['frontpage_about_number_desc'] = 'Введите количество информации, указанной выше';
$string['frontpage_about_text'] = 'Название данных';
$string['frontpage_about_text_1_defalt'] = 'Курсы';
$string['frontpage_about_text_2_defalt'] = 'Преподаватели';
$string['frontpage_about_text_3_defalt'] = 'Студенты';
$string['frontpage_about_text_4_defalt'] = 'Уроки';
$string['frontpage_about_text_desc'] = 'Введите название данных для отображения на главной странице';
$string['frontpage_about_title'] = 'Заголовок блока «О нас»';
$string['frontpage_about_title_default'] = 'Наше глобальное сообщество';
$string['heart'] = 'Если вам нравится эта тема, <a href="{$a}" target="_blank">нажмите</a> ❤️ на странице тем';
$string['instructor'] = 'Инструктор';
$string['login_backgroundcolor'] = 'Цвет фона';
$string['login_backgroundcolor_desc'] = 'Выберите цвет фона страницы восстановления пароля';
$string['login_backgroundfoto'] = 'Фоновое изображение';
$string['login_backgroundfoto_desc'] = 'Выберите фоновое изображение для страницы входа/восстановления пароля/создания учетной записи. Изображение по умолчанию: {$a}';
$string['login_forgot_description'] = 'Текст сбоку на странице восстановления пароля';
$string['login_forgot_description_desc'] = 'Текст, который будет отображаться только на странице восстановления пароля';
$string['login_login_description'] = 'Текст сбоку на странице входа';
$string['login_login_description_desc'] = 'Текст, который будет отображаться только на странице входа';
$string['login_signup_description'] = 'Текст сбоку на странице создания учетной записи';
$string['login_signup_description_desc'] = 'Текст, который будет отображаться только на странице создания учетной записи';
$string['login_theme'] = 'Тема входа';
$string['login_theme_block'] = 'Центральный белый блок с необязательным фоном';
$string['login_theme_desc'] = 'Выберите тему, которую хотите использовать в области входа';
$string['login_theme_image_login'] = 'Фоновое изображение и вход сбоку';
$string['login_theme_imagetext_login'] = 'Фоновое изображение, текст на изображении и вход сбоку';
$string['login_theme_login'] = 'Только страница входа, без изображения сбоку';
$string['logo_color'] = 'Цветной логотип';
$string['logo_color_desc'] = 'Загрузите свой цветной ЛОГОТИП, если вы хотите включить его в верхнюю часть. Этот логотип будет отображаться по мере прокрутки страницы, а меню будет отображаться на белом фоне.';
$string['logo_write'] = 'Логотип верхнего меню при прокрутке';
$string['logo_write_desc'] = 'Загрузите свой логотип, если вы хотите включить его в верхнюю часть. Этот логотип будет отображаться, когда прокрутка остается вверху, а меню будет отображаться на цветном фоне.';
$string['matricular'] = 'Записаться';
$string['mycourses_color'] = 'Цвет фона блока';
$string['mycourses_color_desc'] = 'Цвет фона для блока.';
$string['mycourses_icon'] = 'Иконка';
$string['mycourses_icon_desc'] = 'Представительная иконка для блока. Размер иконки должен быть 48x48 пикселей.';
$string['mycourses_info'] = 'Блок {$a}';
$string['mycourses_numblocos'] = 'Нет блоков';
$string['mycourses_numblocos_desc'] = 'Сколько изображений вы хотите в слайд-шоу?';
$string['mycourses_numblocos_nenhum'] = 'Нет слайдов на главной странице';
$string['mycourses_title'] = 'Краткое название блока';
$string['mycourses_title_desc'] = 'Краткое и описательное название для блока.';
$string['mycourses_url'] = 'Ссылка блока';
$string['mycourses_url_desc'] = 'URL для перехода при щелчке на блоке. Это может быть внешняя ссылка или внутренняя ссылка в рамках платформы.';
$string['pluginname'] = 'Degrade';
$string['privacy:metadata'] = 'Тема Degrade не хранит личные данные пользователей.';
$string['settings_about_heading'] = 'О нашем Moodle';
$string['settings_css_heading'] = 'Шрифты и CSS';
$string['settings_footer_heading'] = 'Блок нижнего колонтитула';
$string['settings_icons_change_icons'] = 'Изменить стандартную иконку в списке курсов';
$string['settings_login_heading'] = 'Страница входа';
$string['settings_mycourses_heading'] = 'Блоки моих курсов';
$string['settings_slideshow_heading'] = 'Слайд-шоу';
$string['settings_theme_heading'] = 'Тема';
$string['settings_top_heading'] = 'Верхнее меню';
$string['sitefonts'] = 'Дополнительные шрифты Google';
$string['sitefonts_desc'] = 'Вставьте код @import из Google Fonts, как показано на изображении ниже. После сохранения поле «Шрифт сайта» будет обновлено, отображая эти шрифты. Вы можете добавить несколько @import по мере необходимости.';
$string['slidecaption_desc'] = 'Введите текст подписи, который будет использоваться на слайде';
$string['slideshow_image'] = 'Изображение слайда';
$string['slideshow_image_desc'] = 'Изображение должно быть 1250px X 400px.';
$string['slideshow_info'] = 'Слайд {$a}';
$string['slideshow_numslides'] = 'Количество изображений в Слайд-шоу';
$string['slideshow_numslides_desc'] = 'Сколько изображений вы хотите в Слайд-шоу?';
$string['slideshow_numslides_nenhum'] = 'Нет слайдов на главной странице';
$string['slideshow_text'] = 'Краткий описательный текст для слайда';
$string['slideshow_text_desc'] = 'Введите краткий текст о слайде.';
$string['slideshow_url'] = 'Ссылка на кнопку слайдов';
$string['slideshow_url_desc'] = 'Вставьте ссылку назначения для кнопки изображения слайда';
$string['social_facebook'] = 'Ваш Facebook';
$string['social_facebook_desc'] = 'URL-адрес Facebook для вашей организации.';
$string['social_instagram'] = 'Ваш Instagram';
$string['social_instagram_desc'] = 'URL-адрес Instagram для вашей организации.';
$string['social_linkedin'] = 'Ваш Linkedin';
$string['social_linkedin_desc'] = 'URL-адрес Linkedin для вашей организации.';
$string['social_twitter'] = 'Ваш Twitter';
$string['social_twitter_desc'] = 'URL-адрес Twitter для вашей организации.';
$string['social_youtube'] = 'Ваш Youtube';
$string['social_youtube_desc'] = 'URL-адрес Youtube для вашей организации.';
$string['theme_color-color_buttons'] = 'Цвет кнопок';
$string['theme_color-color_buttons_desc'] = 'Цвет, используемый для кнопок. Должен обеспечивать визуальную целостность и подчеркивать интерактивные действия.';
$string['theme_color-color_names'] = 'Цвет названий';
$string['theme_color-color_names_desc'] = 'Цвет, используемый для выделения названий или идентификаторов. Должен обеспечивать ясность и акцентировать внимание на конкретной текстовой информации.';
$string['theme_color-color_primary'] = 'Основной цвет';
$string['theme_color-color_primary_desc'] = 'Основной цвет темы. Обычно используется для выделения и подчеркивания элементов.';
$string['theme_color-color_secondary'] = 'Вторичный цвет';
$string['theme_color-color_secondary_desc'] = 'Вторичный цвет, который дополняет основной цвет, используется для выделения вторичных элементов или контраста с основным цветом.';
$string['theme_color_desc'] = 'Выберите цвета текстов и кнопок Moodle или щелкните по линии ниже:';
$string['theme_color_heading'] = 'Выбор цвета окружения';
$string['theme_color_sugestion'] = 'Предложение цвета';
$string['theme_color_sugestion_text'] = 'Нажмите на строку, чтобы применить цвет к полям ниже:';
$string['theme_degrade_about_editbooton'] = 'Редактировать блок «О нас»';
$string['theme_degrade_frontpage_bloco'] = 'Блок «{$a}»';
$string['theme_degrade_frontpage_home'] = 'Блоки на главной странице';
$string['theme_degrade_mycourses_editbooton'] = 'Редактировать блоки';
$string['theme_degrade_slideshow_editbooton'] = 'Редактировать слайд-шоу';
$string['theme_login_branco'] = 'Только страница входа, без изображения сбоку, с формой на белом фоне';
$string['top_color_heading'] = 'Цвет прокрутки вверх';
$string['top_scroll'] = 'Закрепить меню при прокрутке страницы';
$string['top_scroll_background_color'] = 'Цвет фона верхнего меню при прокрутке';
$string['top_scroll_background_color_desc'] = 'Установите цвет фона при прокрутке страницы. Если поле пустое, цвет останется неизменным.';
$string['top_scroll_desc'] = 'При включенном параметре меню будет прикреплено к верхней части экрана, что обеспечит лёгкий доступ к опциям меню при прокрутке страницы.';
$string['top_scroll_text_color'] = 'Цвет текста меню при прокрутке';
$string['top_scroll_text_color_desc'] = 'Установите цвет текста меню при прокрутке страницы.';
$string['vvveb_footer_contact_title_default'] = 'Свяжитесь с нами';
$string['vvveb_home_access'] = 'Доступ к курсу';
$string['vvveb_home_automatically_catalogo'] = 'Не редактировать. Этот блок будет автоматически заменён на каталог курсов.';
$string['vvveb_home_automatically_category'] = 'Не редактировать. Этот блок будет автоматически заменён на категории курсов.';
$string['vvveb_home_automatically_my_course'] = 'Не редактировать. Этот блок будет автоматически заменён курсами, на которые записан студент.';
$string['vvveb_home_automatically_popular'] = 'Не редактировать. Этот блок будет автоматически заменён на самые популярные курсы.';
$string['vvveb_home_catalogo_heading'] = 'Каталог курсов';
$string['vvveb_home_category_heading'] = 'Категории курсов';
$string['vvveb_home_mycourses_heading'] = 'Мои курсы';
$string['vvveb_home_popular_course'] = 'Популярные курсы';
$string['vvveb_home_team_subtitle'] = 'Мы группа профессионалов, преданных своему делу';
$string['vvveb_home_team_title'] = 'Познакомьтесь с нашей командой';
