<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'local_moodlemobileapp', language 'zh_cn', version '4.1'.
 *
 * @package     local_moodlemobileapp
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['addon.block_myoverview.browseallcourses'] = '浏览所有课程';
$string['addon.block_myoverview.nocoursesenrolled'] = '你还未注册任一课程。';
$string['addon.block_myoverview.nocoursesenrolleddescription'] = '浏览所有以下有效课程并开始学习。';
$string['addon.block_myoverview.noresult'] = '你的搜索未匹配到任何课程。';
$string['addon.block_myoverview.noresultdescription'] = '尝试调整你的过滤器或浏览以下所有课程。';
$string['addon.block_myoverview.searchavailablecourses'] = '搜索可用课程';
$string['addon.blog.errorloadentries'] = '加载博客条目出错。';
$string['addon.blog.showonlyyourentries'] = '只显示您的条目';
$string['addon.calendar.calendarevent'] = '日历事件';
$string['addon.calendar.calendarevents'] = '日历事件';
$string['addon.calendar.calendarreminders'] = '日历提醒';
$string['addon.calendar.currentmonth'] = '本月';
$string['addon.calendar.defaultnotificationtime'] = '默认通知时间';
$string['addon.calendar.errorloadevent'] = '加载事件出错。';
$string['addon.calendar.errorloadevents'] = '加载事件出错。';
$string['addon.calendar.monthlyview'] = '月试图';
$string['addon.calendar.noevents'] = '没有事件';
$string['addon.calendar.reminders'] = '提醒';
$string['addon.calendar.setnewreminder'] = '设置新提醒';
$string['addon.competency.errornocompetenciesfound'] = '没有找到能力';
$string['addon.competency.nocompetencies'] = '没有能力';
$string['addon.coursecompletion.complete'] = '完成';
$string['addon.coursecompletion.couldnotloadreport'] = '无法载入课程进度报表，请稍后再试。';
$string['addon.enrol_self.confirmselfenrol'] = '你确定自行注册此课程？';
$string['addon.enrol_self.errorselfenrol'] = '自行注册过程中发生错误。';
$string['addon.messageoutput_airnotifier.processorsettingsdesc'] = '配置设备';
$string['addon.messageoutput_airnotifier.pushdisabledwarning'] = '您的用户在移动设备上未收到本网站的任何通知。请在通知设置页面启用移动通知功能。';
$string['addon.messages.contactlistempty'] = '您的联系人名单是空的';
$string['addon.messages.contactname'] = '联系人姓名';
$string['addon.messages.deletemessage'] = '删除消息';
$string['addon.messages.deletemessageconfirmation'] = '您确定要删除此消息吗？ 它只会从您的消息收发历史记录中删除，发送或接收该消息的用户仍可以查看。';
$string['addon.messages.errordeletemessage'] = '删除消息出错。';
$string['addon.messages.errorwhileretrievingcontacts'] = '从服务器检索联系人出错。';
$string['addon.messages.errorwhileretrievingdiscussions'] = '从服务器检索话题出错。';
$string['addon.messages.errorwhileretrievingmessages'] = '从服务器检索消息出错。';
$string['addon.messages.errorwhileretrievingusers'] = '从服务器检索用户出错。';
$string['addon.messages.messagenotsent'] = '此消息未发送。请稍后再试。';
$string['addon.messages.newmessages'] = '新消息';
$string['addon.messages.nousersfound'] = '没有找到用户';
$string['addon.messages.showdeletemessages'] = '显示删除消息';
$string['addon.messages.type_blocked'] = '已屏蔽';
$string['addon.messages.type_offline'] = '离线';
$string['addon.messages.type_online'] = '在线';
$string['addon.messages.type_search'] = '搜索结果';
$string['addon.messages.type_strangers'] = '其他人';
$string['addon.messages.useentertosenddescdesktop'] = '如果禁用，可以使用Ctrl+Enter发送消息。';
$string['addon.messages.useentertosenddescmac'] = '如果禁用，您可以使用Cmd+Enter发送消息。';
$string['addon.messages.warningconversationmessagenotsent'] = '无法发送消息到对话{{conversation}}。 {{error}}';
$string['addon.messages.warningmessagenotsent'] = '无法发送消息到用户{{user}}。 {{error}}';
$string['addon.mod_assign.acceptsubmissionstatement'] = '请接受作业声明。';
$string['addon.mod_assign.allowsubmissionsanddescriptionfromdatesummary'] = '作业详情及提交表格将于<strong>{{$a}}</strong>发布。';
$string['addon.mod_assign.allowsubmissionsfromdatesummary'] = '本次作业将接受<strong>{{$a}}</strong>提交的作业。';
$string['addon.mod_assign.cannoteditduetostatementsubmission'] = '您不能在应用中添加或编辑作业，因为无法从站点检索作业声明。';
$string['addon.mod_assign.cannotgradefromapp'] = '此应用还不支持某些评分方法，因此不能修改。';
$string['addon.mod_assign.cannotsubmitduetostatementsubmission'] = '您不能在此应用中做作业，因为无法从站点检索作业声明。';
$string['addon.mod_assign.duedateno'] = '无截止日期';
$string['addon.mod_assign.erroreditpluginsnotsupported'] = '您不能在此应用中添加或编辑作业，因为某些插件还不支持编辑。';
$string['addon.mod_assign.errorshowinginformation'] = '无法显示作业信息。';
$string['addon.mod_assign.feedbacknotsupported'] = '应用不支持此反馈，并且可能不包含所有信息。';
$string['addon.mod_assign.gradenotsynced'] = '成绩未同步';
$string['addon.mod_assign.notallparticipantsareshown'] = '未做作业的参与人不会显示。';
$string['addon.mod_assign.numberofdraftsubmissionscountdescription'] = '共有 {{count}} 个草稿。';
$string['addon.mod_assign.numberofparticipantscountdescription'] = '共有{{count}}名参与者。';
$string['addon.mod_assign.numberofsubmissionsneedgradingcountdescription'] = '共有{{count}}份作业需要批改。';
$string['addon.mod_assign.numberofsubmittedassignmentscountdescription'] = '已提交作业{{count}}份。';
$string['addon.mod_assign.numberofteamscountdescription'] = '共有{{count}}支团队。';
$string['addon.mod_assign.submissionnotsupported'] = '应用不支持此作业，并且可能不包含所有信息。';
$string['addon.mod_assign.syncblockedusercomponent'] = '用户等级';
$string['addon.mod_assign.warningsubmissiongrademodified'] = '此作业成绩已在站点上修改。';
$string['addon.mod_assign.warningsubmissionmodified'] = '此用户作业已在站点上修改。';
$string['addon.mod_chat.confirmloss'] = '确定？聊天记录可能会丢失。';
$string['addon.mod_chat.errorwhileconnecting'] = '连接聊天出错。';
$string['addon.mod_chat.errorwhilegettingchatdata'] = '获取聊天数据出错。';
$string['addon.mod_chat.errorwhilegettingchatusers'] = '获取聊天用户出错。';
$string['addon.mod_chat.errorwhileretrievingmessages'] = '从服务器检索消息出错。';
$string['addon.mod_chat.errorwhilesendingmessage'] = '发送消息出错。';
$string['addon.mod_chat.mustbeonlinetosendmessages'] = '您必须在线才能发送消息。';
$string['addon.mod_chat.nosessionsfound'] = '找不到会话';
$string['addon.mod_chat.showincompletesessions'] = '显示未完成的会话';
$string['addon.mod_choice.errorgetchoice'] = '获取投票数据出错。';
$string['addon.mod_choice.responsesresultgraphdescription'] = '{{number}}%的用户选择了此选项：{{text}}。';
$string['addon.mod_choice.resultsnotsynced'] = '此结果不包括您最后的投票。请同步更新它们。';
$string['addon.mod_data.edittagsnotsupported'] = '对不起，此应用不支持编辑标签。';
$string['addon.mod_data.errorapproving'] = '批准或取消批准条目出错。';
$string['addon.mod_data.errordeleting'] = '删除条目出错。';
$string['addon.mod_data.gettinglocation'] = '获取位置';
$string['addon.mod_data.locationnotenabled'] = '定位被禁用';
$string['addon.mod_data.locationpermissiondenied'] = '访问您的位置的权限被拒绝。';
$string['addon.mod_data.mylocation'] = '我的位置';
$string['addon.mod_data.searchbytagsnotsupported'] = '对不起，此应用不支持标签搜索。';
$string['addon.mod_feedback.captchaofflinewarning'] = '使用验证码(CAPTCHA )的调查反馈无法离线完成，或者未配置，或者服务器已关闭。';
$string['addon.mod_feedback.completedfeedbackscountdescription'] = '共提交{{count}}条答案。';
$string['addon.mod_feedback.feedback_submitted_offline'] = '此反馈已保存以便稍后提交。';
$string['addon.mod_feedback.questionscountdescription'] = '共有 {{count}} 个问题。';
$string['addon.mod_folder.emptyfilelist'] = '没有可显示的文件。';
$string['addon.mod_forum.errorgetforum'] = '获取讨论区数据出错。';
$string['addon.mod_forum.errorgetgroups'] = '获取小组设置出错。';
$string['addon.mod_forum.errorloadingsortingorder'] = '论坛无法按此排序顺序显示。';
$string['addon.mod_forum.errorloadingsortingorderdetails'] = '请尝试更改排序顺序，或在线查看此论坛。';
$string['addon.mod_forum.errorposttoallgroups'] = '不能在所有小组中发起新话题。';
$string['addon.mod_forum.forumnodiscussionsyet'] = '此讨论区还没有话题。';
$string['addon.mod_forum.group'] = '小组';
$string['addon.mod_forum.numdiscussions'] = '{{numdiscussions}} 个话题';
$string['addon.mod_forum.numreplies'] = '{{numreplies}} 条回帖';
$string['addon.mod_forum.refreshposts'] = '刷新帖子';
$string['addon.mod_glossary.browsemode'] = '浏览词条';
$string['addon.mod_glossary.byalphabet'] = '按字母顺序';
$string['addon.mod_glossary.byauthor'] = '按作者分组';
$string['addon.mod_glossary.bycategory'] = '按类别分组';
$string['addon.mod_glossary.bynewestfirst'] = '新的在前';
$string['addon.mod_glossary.byrecentlyupdated'] = '最近更新的';
$string['addon.mod_glossary.bysearch'] = '搜索';
$string['addon.mod_glossary.cannoteditentry'] = '不能编辑词条';
$string['addon.mod_glossary.entriestobesynced'] = '要同步的词条';
$string['addon.mod_glossary.entrypendingapproval'] = '此词条有待批准。';
$string['addon.mod_glossary.errorloadingentries'] = '加载词条出错。';
$string['addon.mod_glossary.errorloadingentry'] = '加载词条出错。';
$string['addon.mod_glossary.errorloadingglossary'] = '加载词汇表出错。';
$string['addon.mod_glossary.noentriesfound'] = '找不到词条。';
$string['addon.mod_glossary.searchquery'] = '搜索查询';
$string['addon.mod_h5pactivity.downloadh5pfile'] = '下载H5P文件';
$string['addon.mod_h5pactivity.errorgetactivity'] = '获取H5P活动数据出错。';
$string['addon.mod_h5pactivity.filestatenotdownloaded'] = '此H5P包没有下载。您需要下载才能使用它。';
$string['addon.mod_h5pactivity.filestateoutdated'] = '自上次下载以来，H5P包已被修改。您需要再次下载才能使用它。';
$string['addon.mod_h5pactivity.offlinedisabledwarning'] = '您需要在线才能查看H5P包。';
$string['addon.mod_h5pactivity.viewattempt'] = '查看尝试{{$a}}';
$string['addon.mod_imscp.showmoduledescription'] = '显示描述';
$string['addon.mod_lesson.errorprefetchrandombranch'] = '此程序教学包含到随机内容页面的跳转。只有在web浏览器中开始后，才能在此应用中尝试。';
$string['addon.mod_lesson.errorreviewretakenotlast'] = '无法再回顾此尝试，因为另一次尝试已结束。';
$string['addon.mod_lesson.finishretakeoffline'] = '此尝试已离线结束。';
$string['addon.mod_lesson.retakefinishedinsync'] = '离线尝试已同步。您要回顾吗？';
$string['addon.mod_lesson.retakelabelfull'] = '{{retake}}: {{grade}} {{timestart}} ({{duration}})';
$string['addon.mod_lesson.retakelabelshort'] = '{{retake}}: {{grade}} {{timestart}}';
$string['addon.mod_lesson.warningretakefinished'] = '此尝试已在站点上结束。';
$string['addon.mod_lti.errorgetlti'] = '获取模块数据出错。';
$string['addon.mod_lti.errorinvalidlaunchurl'] = '启动网址无效。';
$string['addon.mod_lti.launchactivity'] = '启动活动';
$string['addon.mod_page.errorwhileloadingthepage'] = '加载页面内容出错。';
$string['addon.mod_quiz.canattemptbutnotsubmit'] = '您可以在此应用中试答此测验，但您需要在浏览器中提交试答，原因如下:';
$string['addon.mod_quiz.cannotsubmitquizdueto'] = '此测验试答因为如下原因不能提交：';
$string['addon.mod_quiz.confirmcontinueoffline'] = '自{{$a}}以来，此试答未同步。如果此后在其他设备上继续此试答，可能会丢失数据。';
$string['addon.mod_quiz.confirmleavequizonerror'] = '保存答案出错。您确定要离开此测验吗?';
$string['addon.mod_quiz.errorbehaviournotsupported'] = '此测验不能在应用中试答，因为应用不支持此试题行为：';
$string['addon.mod_quiz.errordownloading'] = '下载所需数据出错。';
$string['addon.mod_quiz.errorgetattempt'] = '获取试答数据出错。';
$string['addon.mod_quiz.errorgetquestions'] = '获取试题出错。';
$string['addon.mod_quiz.errorgetquiz'] = '获取测验数据出错。';
$string['addon.mod_quiz.errorparsequestions'] = '读取试题出错。请在web浏览器中试答此测验。';
$string['addon.mod_quiz.errorquestionsnotsupported'] = '此测验无法在此应用中试答，因为它只包含此应用不支持的试题:';
$string['addon.mod_quiz.errorrulesnotsupported'] = '此测验无法在此应用中试答，因为此应用不支持它的访问规则：';
$string['addon.mod_quiz.errorsaveattempt'] = '保存试答数据出错。';
$string['addon.mod_quiz.finishnotsynced'] = '结束但没有同步';
$string['addon.mod_quiz.opentoc'] = '打开导航弹窗。';
$string['addon.mod_quiz.warningattemptfinished'] = '离线试答已在站点上结束或未找到，因此已丢弃。';
$string['addon.mod_quiz.warningdatadiscarded'] = '某些离线回答被丢弃，因为这些试题被在线修改了。';
$string['addon.mod_quiz.warningdatadiscardedfromfinished'] = '试答未结束，因为某些离线回答被丢弃。请回顾您的回答，然后重新提交。';
$string['addon.mod_quiz.warningquestionsnotsupported'] = '此测验包含了应用不支持的试题：';
$string['addon.mod_resource.errorwhileloadingthecontent'] = '加载内容出错。';
$string['addon.mod_resource.openthefile'] = '打开文件';
$string['addon.mod_scorm.cannotcalculategrade'] = '成绩无法计算。';
$string['addon.mod_scorm.dataattemptshown'] = '此数据属于尝试编号{{number}}。';
$string['addon.mod_scorm.errorcreateofflineattempt'] = '创建新的离线尝试出错。请再试试。';
$string['addon.mod_scorm.errordownloadscorm'] = '下载SCORM "{{name}}"出错。';
$string['addon.mod_scorm.errorgetscorm'] = '获取SCORM数据出错。';
$string['addon.mod_scorm.errorinvalidversion'] = '对不起，此应用程序只支持SCORM 1.2。';
$string['addon.mod_scorm.errornotdownloadable'] = 'SCORM课件包下载被禁用。请联系您的站点管理员。';
$string['addon.mod_scorm.errornovalidsco'] = '此SCORM课件包没有可见的SCO要加载。';
$string['addon.mod_scorm.errorpackagefile'] = '对不起，此应用程序只支持ZIP包。';
$string['addon.mod_scorm.errorsyncscorm'] = '同步出错。请再试试。';
$string['addon.mod_scorm.offlineattemptnote'] = '此尝试有数据没有同步。';
$string['addon.mod_scorm.offlineattemptovermax'] = '由于超过了最大尝试次数，因此无法发送此尝试。';
$string['addon.mod_scorm.scormstatusnotdownloaded'] = '此SCORM课件包没有下载。当您打开它时，它会自动下载。';
$string['addon.mod_scorm.scormstatusoutdated'] = '此SCORM课件包在上次下载后被修改了。当您打开它时，它会自动下载。';
$string['addon.mod_scorm.warningofflinedatadeleted'] = '来自尝试{{number}} 的某些离线数据已被丢弃，因为这不能算作一次新尝试。';
$string['addon.mod_scorm.warningsynconlineincomplete'] = '某些尝试无法与站点同步，因为上次在线尝试还未结束。请先结束在线尝试。';
$string['addon.mod_survey.cannotsubmitsurvey'] = '抱歉，提交您的问卷调查出现问题。请再试试。';
$string['addon.mod_survey.errorgetsurvey'] = '获取问卷调查数据出错。';
$string['addon.mod_survey.results'] = '结果';
$string['addon.mod_url.accessurl'] = '访问此网址';
$string['addon.mod_url.pointingtourl'] = '此资源指向的网址。';
$string['addon.mod_wiki.errorloadingpage'] = '加载页面出错。';
$string['addon.mod_wiki.errornowikiavailable'] = '此 wiki 还没有任何内容。';
$string['addon.mod_wiki.gowikihome'] = '转到 wiki 第一页';
$string['addon.mod_wiki.subwiki'] = '子 wiki';
$string['addon.mod_wiki.titleshouldnotbeempty'] = '标题不能为空';
$string['addon.mod_wiki.viewpage'] = '查看页面';
$string['addon.mod_wiki.wikipage'] = 'Wiki 页面';
$string['addon.mod_workshop.assessmentstrategynotsupported'] = '不支持评价策略{{$a}}';
$string['addon.mod_workshop.submissionrequiredtitle'] = '您需要输入一个标题。';
$string['addon.mod_workshop.warningassessmentmodified'] = '此提交已在站点上进行了修改。';
$string['addon.mod_workshop.warningsubmissionmodified'] = '此评价在站点上进行了修改。';
$string['addon.notes.warningnotenotsent'] = '无法添加备注到课程 {{course}}。{{error}}';
$string['addon.notifications.errorgetnotifications'] = '获取通知出错。';
$string['addon.notifications.notifications'] = '通知';
$string['addon.notifications.playsound'] = '播放声音';
$string['addon.notifications.therearentnotificationsyet'] = '没有通知。';
$string['addon.storagemanager.deletecourses'] = '卸载所有课程数据';
$string['addon.storagemanager.deletedatafrom'] = '从{{name}}卸载数据';
$string['appstoredescription'] = '注意：这个官方Moodle移动应用只会与已经设置允许它的 Moodle
 站点一起工作。如果您有任何问题，请与您的 Moodle 管理员联系。

如果 Moodle 站点已经被正确配置，您可以使用这款应用来：

- 浏览您的课程内容，即使离线；
- 接收即时消息通知和其他事件；
- 在您的课程里快速找到和联系他人；
- 从您的移动设备上传图片,音频,视频和其他文件；
- 查看课程成绩
- 以及更多！

请参阅 http://docs.moodle.org/en/Mobile_app 获取所有最新的信息。

到目前为止，我们非常感谢您对该功能的任何好评，以及您对此应用的其他建议。

应用需要以下权限：
录制音频 - 录制音频上传到 Moodle
读取和修改你的 SD 卡的内容 - 下载内容到SD卡，这样您就可以离线看到它们
网络访问 - 能够连接 Moodle 站点，并检查您是否已连接，在无连接时切换到离线模式
启动时运行 - 所以此应用在后台运行的时候您也能接收本地通知事件
防止电话休眠 - 所以您可以随时收到推送通知';
$string['core.browser'] = '浏览器';
$string['core.cannotconnect'] = '无法连接';
$string['core.cannotdownloadfiles'] = '文件下载被禁用。请联系您的站点管理员。';
$string['core.cannotopeninapp'] = '此文件可能无法在此设备上按预期工作。你还是要打开它吗？';
$string['core.cannotopeninappdownload'] = '此文件可能无法在此设备上按预期工作。你还想下载吗？';
$string['core.captureaudio'] = '录制音频';
$string['core.capturedimage'] = '拍摄照片。';
$string['core.captureimage'] = '拍摄照片';
$string['core.capturevideo'] = '录制视频';
$string['core.clearsearch'] = '清空搜索';
$string['core.clearstoreddata'] = '清除存储 {{$a}}';
$string['core.clicktoseefull'] = '点击查看完整内容。';
$string['core.comments.commentsnotworking'] = '无法检索评论';
$string['core.comments.warningcommentsnotsent'] = '无法同步评论。{{error}}';
$string['core.confirmcanceledit'] = '您确定要离开此页面吗？所有的更改都将丢失。';
$string['core.confirmleaveunknownchanges'] = '您确定要离开此页面吗?如果您有未保存的更改，它们将丢失。';
$string['core.confirmloss'] = '您确定吗？所有的更改都将丢失。';
$string['core.confirmopeninbrowser'] = '您想在web浏览器中打开它吗?';
$string['core.contenteditingsynced'] = '您正在编辑的内容已经同步。';
$string['core.contentlinks.chooseaccount'] = '选择账号';
$string['core.contentlinks.chooseaccounttoopenlink'] = '选择一个帐号来打开此链接。';
$string['core.contentlinks.confirmurlothersite'] = '此链接属于另一个站点。您想打开它吗?';
$string['core.contentlinks.errornoactions'] = '找不到执行该链接的操作。';
$string['core.contentlinks.errornosites'] = '找不到处理此链接的任何站点。';
$string['core.contentlinks.errorredirectothersite'] = '重定向网址不能指向其他站点。';
$string['core.copiedtoclipboard'] = '复制文本到剪贴板';
$string['core.copytoclipboard'] = '复制到剪贴板';
$string['core.course.activitydisabled'] = '您的组织已在移动应用中禁用此活动。';
$string['core.course.activitynotyetviewableremoteaddon'] = '您的组织安装了一个还不支持的插件。';
$string['core.course.allsections'] = '所有小节';
$string['core.course.availablespace'] = '您当前大约有 {{available}} 空闲空间。';
$string['core.course.cannotdeletewhiledownloading'] = '在下载活动时无法删除文件。请等待下载结束。';
$string['core.course.confirmdownload'] = '您将要下载{{size}}。您确定要继续吗?';
$string['core.course.confirmdownloadunknownsize'] = '无法计算下载的大小。您确定要继续吗?';
$string['core.course.confirmdownloadzerosize'] = '您即将开始下载。{{availableSpace}}您确定要继续吗?';
$string['core.course.confirmlimiteddownload'] = '您当前没有连接到Wi-Fi。';
$string['core.course.confirmpartialdownloadsize'] = '您将下载<strong>至少</strong>{{size}}。{{availableSpace}} 您确定要继续吗?';
$string['core.course.couldnotloadsectioncontent'] = '无法加载此小节内容。请稍后再试。';
$string['core.course.couldnotloadsections'] = '无法加载此小节。请稍后再试。';
$string['core.course.errordownloadingcourse'] = '下载课程出错。';
$string['core.course.errordownloadingsection'] = '下载小节出错。';
$string['core.course.errorgetmodule'] = '获取活动数据出错。';
$string['core.course.insufficientavailablequota'] = '您的设备没有足够的空间来保存此下载。它可能会为应用和系统更新预留空间。请先清理一些存储空间。';
$string['core.course.insufficientavailablespace'] = '您正在下载{{size}}。这将使您的设备没有足够的空间正常运行。请先清理一些存储空间。';
$string['core.course.manualcompletionnotsynced'] = '手动进度没有同步。';
$string['core.course.nocontentavailable'] = '目前没有可用的内容。';
$string['core.course.refreshcourse'] = '刷新课程';
$string['core.course.useactivityonbrowser'] = '您仍然可以通过您的设备的网络浏览器使用它。';
$string['core.course.warningmanualcompletionmodified'] = '在站点上修改了活动的手动进度。';
$string['core.course.warningofflinemanualcompletiondeleted'] = '课程“{{name}}”的某些离线手动进度已被删除。{{error}}';
$string['core.coursenogroups'] = '您不是此课程任何小组的成员。';
$string['core.courses.cannotretrievemorecategories'] = '不能检索到超过{{$a}}层的类别。';
$string['core.courses.downloadcourses'] = '下载课程';
$string['core.courses.enrolme'] = '加入我';
$string['core.courses.errorloadcategories'] = '加载类别出错。';
$string['core.courses.errorloadcourses'] = '加载课程出错。';
$string['core.courses.errorloadplugins'] = '此课程所需的插件无法正确加载。请重新打开此应用再试试。';
$string['core.courses.errorsearching'] = '搜索出错。';
$string['core.courses.filtermycourses'] = '过滤我的课程';
$string['core.courses.notenrollable'] = '您不能报名加入此课程。';
$string['core.courses.password'] = '选课密钥';
$string['core.courses.searchcoursesadvice'] = '您可以使用“搜索课程”按钮来发现课程并作为访客访问，或者在允许选课的课程中选课。';
$string['core.courses.totalcoursesearchresults'] = '总课程数：{{$a}}';
$string['core.currentdevice'] = '当前设备';
$string['core.datastoredoffline'] = '数据存储在设备中，因为无法发送。稍后将自动发送。';
$string['core.deletedoffline'] = '已删除离线';
$string['core.deleting'] = '删除中';
$string['core.desktop'] = '桌面';
$string['core.dfdaymonthyear'] = 'YYYY-MM-DD';
$string['core.dfdayweekmonth'] = '';
$string['core.dffulldate'] = 'dddd, D MMMM YYYY h[:]mm A';
$string['core.dflastweekdate'] = 'ddd';
$string['core.dfmediumdate'] = 'LLL';
$string['core.dftimedate'] = 'h[:]mm A';
$string['core.discard'] = '丢弃';
$string['core.dismiss'] = '驳回';
$string['core.downloaded'] = '已下载';
$string['core.downloading'] = '下载中';
$string['core.editor.hidetoolbar'] = '隐藏工具栏';
$string['core.editor.toggle'] = '切换编辑器';
$string['core.emptysplit'] = '如果左边的面板是空的或者正在加载，此页面将显示为空白。';
$string['core.errorchangecompletion'] = '更改进度状态出错。请再试试。';
$string['core.errordeletefile'] = '删除文件出错。请再试试。';
$string['core.errordownloading'] = '下载文件出错。';
$string['core.errordownloadingsomefiles'] = '下载文件出错。某些文件可能丢失。';
$string['core.errorfileexistssamename'] = '此名称的文件已经存在。';
$string['core.errorinvalidform'] = '表单包含无效数据。请检查所有必需的字段是否都已填写，数据是否有效。';
$string['core.errorinvalidresponse'] = '无效的反馈。如果错误持续存在，请与站点管理员联系。';
$string['core.errorloadingcontent'] = '加载内容出错。';
$string['core.errorofflinedisabled'] = '您的站点禁用离线浏览。您需要连接到互联网才能使用此应用。';
$string['core.erroropenfilenoapp'] = '打开文件出错：没有找到打开该类型文件的应用。';
$string['core.erroropenfilenoextension'] = '打开文件出错：文件没有扩展名。';
$string['core.erroropenpopup'] = '此活动试图打开一个弹出窗口。此应用不支持此功能。';
$string['core.errorrenamefile'] = '重命名文件出错。请再试试。';
$string['core.errorsomedatanotdownloaded'] = '如果您下载了此活动，请注意，由于性能和数据使用原因，在下载过程中有些数据没有下载。';
$string['core.errorsync'] = '同步出错。请再试试。';
$string['core.errorsyncblocked'] = '此{{$a}}现在不能正确同步，因为有一个进程正在进行。请稍后再试。如果问题仍然存在，请重新启动此应用。';
$string['core.errorurlschemeinvalidscheme'] = '此URL将用于另一个应用程序：{{$a}}。';
$string['core.errorurlschemeinvalidsite'] = '无法在应用中打开此站点网址。';
$string['core.filenameexist'] = '文件名已经存在:{{$a}}';
$string['core.fileuploader.audio'] = '音频';
$string['core.fileuploader.camera'] = '相机';
$string['core.fileuploader.confirmuploadfile'] = '您将要上传{{size}}。您确定要继续吗?';
$string['core.fileuploader.confirmuploadunknownsize'] = '无法计算上传的大小。您确定要继续吗?';
$string['core.fileuploader.errorcapturingaudio'] = '捕捉音频出错。';
$string['core.fileuploader.errorcapturingimage'] = '捕捉图像出错。';
$string['core.fileuploader.errorcapturingvideo'] = '捕捉视频出错。';
$string['core.fileuploader.errorgettingimagealbum'] = '从相册获取图片出错。';
$string['core.fileuploader.errormustbeonlinetoupload'] = '您必须在线才能上传文件。';
$string['core.fileuploader.errornoapp'] = '您没有安装执行此操作的应用。';
$string['core.fileuploader.errorreadingfile'] = '读取文件出错。';
$string['core.fileuploader.errorwhileuploading'] = '上传文件出错。';
$string['core.fileuploader.file'] = '文件';
$string['core.fileuploader.fileuploaded'] = '文件上传成功。';
$string['core.fileuploader.maxbytesfile'] = '此文件{{$a.file}}太大。您可以上传的最大大小是{{$a.size}}。';
$string['core.fileuploader.photoalbums'] = '相册';
$string['core.fileuploader.readingfile'] = '读取文件';
$string['core.fileuploader.readingfileperc'] = '读取文件： {{$a}}%';
$string['core.fileuploader.selectafile'] = '选择一个文件';
$string['core.fileuploader.uploadafile'] = '上传一个文件';
$string['core.fileuploader.uploading'] = '上传中';
$string['core.fileuploader.uploadingperc'] = '上传: {{$a}}%';
$string['core.fileuploader.video'] = '视频';
$string['core.fullnameandsitename'] = '{{fullname}} ({{sitename}})';
$string['core.h5p.errorgetemail'] = '获取用户电子邮件出错。请检查连接并重试。';
$string['core.h5p.offlinedisabled'] = '该站点不允许下载H5P包。';
$string['core.h5p.play'] = '播放H5P';
$string['core.hasdatatosync'] = '此{{$a}}有离线数据要同步。';
$string['core.humanreadablesize'] = '{{size}} {{unit}}';
$string['core.image'] = '图片';
$string['core.imageviewer'] = '图片查看器';
$string['core.lastdownloaded'] = '上次下载';
$string['core.lastsync'] = '上次同步';
$string['core.loadmore'] = '加载更多';
$string['core.login.authenticating'] = '验证中';
$string['core.login.changepasswordbutton'] = '打开更改密码页面';
$string['core.login.changepasswordhelp'] = '如果您在更改密码时遇到问题，请与您的站点管理员联系。“站点管理员”是在您的学校/大学/公司或学习机构管理 Moodle 的人。如果您不知道如何联系他们，请联系您的老师/培训师。';
$string['core.login.changepasswordreconnectinstructions'] = '点击下面的按钮重新连接到站点。(请注意，如果您没有成功更改密码，您将返回到上一个屏幕)。';
$string['core.login.confirmdeletesite'] = '您确定要删除站点{{sitename}}吗?';
$string['core.login.connect'] = '连接!';
$string['core.login.connecttomoodle'] = '连接到 Moodle';
$string['core.login.connecttomoodleapp'] = '您正在连接到一个常规 Moodle 站点。请下载官方 Moodle 应用访问本站点。';
$string['core.login.connecttoworkplaceapp'] = '您正在连接到一个Moodle 工作场所站点。请下载 Moodle Workplace 应用访问本站点。';
$string['core.login.credentialsdescription'] = '请提供您的用户名和密码，以便登录。';
$string['core.login.emailconfirmsentnoemail'] = '<p>一封电子邮件应该已经发送到您的地址了。</p><p>它包含简单的说明，以完成您的注册。</p><p>如果您仍然有困难，请与站点管理员联系。</p>';
$string['core.login.emailnotmatch'] = '电子邮件不匹配';
$string['core.login.erroraccesscontrolalloworigin'] = '您试图执行的Cross-Origin调用被拒绝了。
请检查https://docs.moodle.org/dev/Moodle_Mobile_development_using_Chrome_or_Chromium';
$string['core.login.errordeletesite'] = '删除此站点出错。请再试试。';
$string['core.login.errorexampleurl'] = 'URL https://campus.example.edu只是一个示例网址，它不是一个真实的站点。<strong>请使用您的学校或组织站点的网址 。</strong>';
$string['core.login.errorqrnoscheme'] = '此URL不是有效的登录URL。';
$string['core.login.errorupdatesite'] = '更新站点令牌出错。';
$string['core.login.faqcannotfindmysiteanswer'] = '您输入的名称正确吗?也有可能，您的站点不包括在我们的公共站点目录。如果您仍然找不到它，请输入您的站点地址。';
$string['core.login.faqcannotfindmysitequestion'] = '我找不到我的站点。';
$string['core.login.faqsetupsiteanswer'] = '访问{{$link}}查看创建自己的 Moodle 站点的不同选项。';
$string['core.login.faqsetupsitelinktitle'] = '开始。';
$string['core.login.faqsetupsitequestion'] = '我想建立自己的 Moodle 站点。';
$string['core.login.faqtestappanswer'] = '要在 Moodle 演示站点中测试此应用，请在“您的站点”字段中输入“teacher”或“student”，然后点击“连接到您的站点”按钮。';
$string['core.login.faqtestappquestion'] = '我只是想测试这个应用，我该怎么做?';
$string['core.login.faqwhatisurlanswer'] = '<p>每个组织或学校都有他们自己定制地址的Moodle站点。</p><p>要找到您想要连接的Moodle站点的网址，请执行以下操作：</p><ol><li>打开网络浏览器，进入您的学校或组织的Moodle站点登录页面</li><li>在页面顶部的地址栏，您可以看到您的Moodle站点的网址。如。“campus.example.edu”。{{$image}}</li><li>复制地址(不要复制/login和后面的内容)，将其粘贴到Moodle应用中，然后点击“连接到您的站点”</li><li>现在您可以使用您的用户名和密码登录到您的站点了</li>';
$string['core.login.faqwhatisurlquestion'] = '我的站点地址是什么?我如何找到我的站点网址?';
$string['core.login.faqwhereisqrcode'] = '二维码在哪里?';
$string['core.login.faqwhereisqrcodeanswer'] = '<p>如果您的组织启用了该功能，您将在您的用户个人档案页面底部发现一个二维码。</p>{{$image}}';
$string['core.login.findyoursite'] = '找到您的站点';
$string['core.login.invalidaccount'] = '请检查您的登录详情或请您的站点管理员检查站点配置。';
$string['core.login.invalidmoodleversion'] = '<p>无效的Moodle站点版本。Moodle应用只支持 {{$a}}以上的Moodle系统。</p>
<p>您可以联系您的站点管理员，让他们更新他们的Moodle系统。</p>
<p>“站点管理员”是在您的学校/大学/公司或学习组织管理Moodle的人。如果您不知道如何联系他们，请联系您的老师/培训师。</p>';
$string['core.login.invalidsite'] = '站点网址无效。';
$string['core.login.invalidtime'] = '无效的时间';
$string['core.login.invalidvaluemax'] = '最大值为{{$a}}';
$string['core.login.invalidvaluemin'] = '最小值为{{$a}}';
$string['core.login.loginbutton'] = '登录';
$string['core.login.mobileservicesnotenabled'] = '您的站点上没有启用移动访问。如果您认为应该启用它，请联系您的站点管理员。';
$string['core.login.notloggedin'] = '您需要登录。';
$string['core.login.onboardingcreatemanagecourses'] = '创建和管理您的课程';
$string['core.login.onboardingenrolmanagestudents'] = '加入和管理您的学生';
$string['core.login.onboardinggetstarted'] = '开始使用Moodle';
$string['core.login.onboardingialreadyhaveasite'] = '我已经有了一个 Moodle 站点';
$string['core.login.onboardingimalearner'] = '我是一个学习者';
$string['core.login.onboardingimaneducator'] = '我是一个教育工作者';
$string['core.login.onboardingineedasite'] = '我需要一个 Moodle 站点';
$string['core.login.onboardingprovidefeedback'] = '提供及时的反馈';
$string['core.login.onboardingtoconnect'] = '要连接到 Moodle 应用，您需要一个Moodle 站点';
$string['core.login.onboardingwelcome'] = '欢迎使用 Moodle 应用！';
$string['core.login.or'] = '或者';
$string['core.login.passwordrequired'] = '需要密码';
$string['core.login.recaptchachallengeimage'] = '验证码(reCAPTCHA)验证图像';
$string['core.login.recaptchaexpired'] = '验证过期。请再次回答安全问题。';
$string['core.login.recaptchaincorrect'] = '安全问题回答错误。';
$string['core.login.reconnect'] = '重新连接';
$string['core.login.searchby'] = '搜索：';
$string['core.login.selectsite'] = '请选择您的站点：';
$string['core.login.signupplugindisabled'] = '{{$a}}未启用。';
$string['core.login.signuprequiredfieldnotsupported'] = '注册表单包含应用程序不支持的必需自定义字段。请使用web浏览器创建您的帐户。';
$string['core.login.siteaddress'] = '您的站点';
$string['core.login.sitehasredirect'] = '您的站点至少包含一个HTTP重定向。此应用无法跟随重定向，这可能是阻止此应用连接到您的站点的问题。';
$string['core.login.siteinmaintenance'] = '您的站点处于维护模式';
$string['core.login.sitepolicynotagreederror'] = '未同意站点政策。';
$string['core.login.siteurl'] = '站点网址';
$string['core.login.siteurlrequired'] = '需要填写站点网址，比如<i>http://www.yourmoodlesite.abc 或https://www.yourmoodlesite.efg</i>';
$string['core.login.stillcantconnect'] = '仍然不能连接吗?';
$string['core.login.usernamerequired'] = '需要用户名';
$string['core.login.visitchangepassword'] = '您想访问该站点更改密码吗?';
$string['core.login.webservicesnotenabled'] = '您的主机站点可能没有启用Web服务。请联系您的管理员寻求帮助。';
$string['core.login.youcanstillconnectwithcredentials'] = '您仍然可以通过输入您的用户名和密码连接到此站点。';
$string['core.login.yourenteredsite'] = '连接到您的站点';
$string['core.lostconnection'] = '您的身份验证令牌无效或已过期。 您必须重新连接到此站点。';
$string['core.needhelp'] = '您需要帮助吗？';
$string['core.networkerroriframemsg'] = '此内容无法离线使用。请连接互联网再试试。';
$string['core.networkerrormsg'] = '连接到站点出现问题。请检查连接并重试。';
$string['core.nooptionavailable'] = '没有可用的选项';
$string['core.nopasswordchangeforced'] = '如果不更改密码，您无法继续操作。';
$string['core.nopermissionerror'] = '抱歉，您当前没有执行此操作的权限';
$string['core.notapplicable'] = '不适用';
$string['core.notsent'] = '未发送';
$string['core.nummore'] = '{{$a}} 更多';
$string['core.openfile'] = '打开文件';
$string['core.openfullimage'] = '点击此处显示完整尺寸的图像';
$string['core.openinbrowser'] = '在浏览器中打开';
$string['core.openmodinbrowser'] = '在浏览器中打开{{$a}}';
$string['core.percentagenumber'] = '{{$a}}%';
$string['core.pulltorefresh'] = '下拉刷新';
$string['core.qrscanner'] = '二维码扫描器';
$string['core.question.cannotdeterminestatus'] = '不能确定状态';
$string['core.question.errorattachmentsnotsupportedinsite'] = '您的网站尚不支持将文件附加到答案。';
$string['core.question.errorembeddedfilesnotsupportedinsite'] = '您的网站尚不支持编辑嵌入文件。';
$string['core.question.errorquestionnotsupported'] = '此应用不支持此题型：{{$a}}。';
$string['core.question.howtodraganddrop'] = '点击选择，然后点击放下。';
$string['core.question.questionmessage'] = '试题{{$a}}: {{$b}}';
$string['core.redirectingtosite'] = '您将被重定向到该站点。';
$string['core.removefiles'] = '移除文件 {{$a}}';
$string['core.requireduserdatamissing'] = '此用户缺少一些必需的个人档案数据。请在您的站点中输入数据，然后再试试。<br>{{$a}}';
$string['core.retry'] = '重试';
$string['core.scanqr'] = '扫描二维码';
$string['core.searching'] = '搜索中';
$string['core.settings.about'] = '关于';
$string['core.settings.appsettings'] = '应用设置';
$string['core.settings.appversion'] = '应用版本';
$string['core.settings.cannotsyncloggedout'] = '无法同步此网站，因为您已注销。请在重新登录网站后重试。';
$string['core.settings.cannotsyncoffline'] = '不能同步离线。';
$string['core.settings.cannotsyncwithoutwifi'] = '无法同步，因为目前的设置只允许在连接到 Wi-Fi 时进行同步。请连接到一个 Wi-Fi 无线网络。';
$string['core.settings.colorscheme'] = '配色方案';
$string['core.settings.colorscheme-dark'] = '深色模式';
$string['core.settings.colorscheme-light'] = '亮色模式';
$string['core.settings.compilationinfo'] = '编译信息';
$string['core.settings.copyinfo'] = '将设备信息复制到剪贴板上';
$string['core.settings.cordovadevicemodel'] = 'Cordova 设备型号';
$string['core.settings.cordovadeviceosversion'] = 'Cordova 设备操作系统版本';
$string['core.settings.cordovadeviceplatform'] = 'Cordova 设备平台';
$string['core.settings.cordovadeviceuuid'] = 'Cordova 设备 UUID';
$string['core.settings.cordovaversion'] = 'Cordova 版本';
$string['core.settings.debugdisplaydescription'] = '如果启用，错误模式将显示有关错误的更多数据（如果可能）。';
$string['core.settings.deviceinfo'] = '设备信息';
$string['core.settings.deviceos'] = '设备操作系统';
$string['core.settings.displayformat'] = '显示格式';
$string['core.settings.enabledownloadsection'] = '启用下载小节';
$string['core.settings.enablerichtexteditor'] = '启用富文本编辑器';
$string['core.settings.enablerichtexteditordescription'] = '如启用，则在输入内容时将显示富文本编辑器。如禁用，将显示纯文本编辑器。您可以在编辑时在两者之间切换。';
$string['core.settings.entriesincache'] = '{{$a}} 条缓存';
$string['core.settings.estimatedfreespace'] = '估计的可用空间';
$string['core.settings.filesystemroot'] = '文件系统根目录';
$string['core.settings.fontsize'] = '字体大小';
$string['core.settings.forcedsetting'] = '此设置是由您的站点配置强制设置的。';
$string['core.settings.localnotifavailable'] = '本地通知可用';
$string['core.settings.locationhref'] = 'Web视图网址';
$string['core.settings.navigatorlanguage'] = '浏览器语言';
$string['core.settings.navigatoruseragent'] = '浏览器用户代理';
$string['core.settings.networkstatus'] = '网络连接状态';
$string['core.settings.opensourcelicenses'] = '开源许可证';
$string['core.settings.privacypolicy'] = '隐私政策';
$string['core.settings.publisher'] = '发行人';
$string['core.settings.pushid'] = '推送通知ID';
$string['core.settings.reportinbackground'] = '自动报告错误';
$string['core.settings.screen'] = '屏幕信息';
$string['core.settings.showdownloadoptions'] = '显示下载选项';
$string['core.settings.siteinfo'] = '站点信息';
$string['core.settings.spaceusage'] = '空间使用情况';
$string['core.settings.synchronization'] = '同步';
$string['core.settings.synchronizenow'] = '现在同步';
$string['core.settings.synchronizenowhelp'] = '同步一个站点将发送待定的更改和所有存储在设备中的离线活动，并将同步一些数据，如消息和通知。';
$string['core.settings.syncsettings'] = '同步设置';
$string['core.settings.wificonnection'] = 'WiFi 连接';
$string['core.sharedfiles.chooseaccountstorefile'] = '选择存储文件的帐号。';
$string['core.sharedfiles.chooseactionrepeatedfile'] = '此名称的文件已经存在。要替换现有文件还是将其重命名为“{{$a}}”?';
$string['core.sharedfiles.errorreceivefilenosites'] = '没有存储的站点。 请在用此应用共享文件之前添加一个站点。';
$string['core.sharedfiles.nosharedfiles'] = '此站点上没有存储共享文件。';
$string['core.sharedfiles.nosharedfilestoupload'] = '您没有要上传的文件。 如果要从另一个应用程序上传文件，请找到该文件，然后点击“打开方式”按钮。';
$string['core.sharedfiles.rename'] = '重命名';
$string['core.sharedfiles.replace'] = '替换';
$string['core.sharedfiles.sharedfiles'] = '共享文件';
$string['core.sharedfiles.successstorefile'] = '文件存储成功。请选择要上传到您的私人文件或在活动中使用的文件。';
$string['core.sizetb'] = 'TB';
$string['core.sorry'] = '对不起…';
$string['core.storingfiles'] = '存储文件';
$string['core.tablet'] = '平板电脑';
$string['core.tag.errorareanotsupported'] = '此应用不支持该标签区域。';
$string['core.tag.warningareasnotsupported'] = '某些标签区域没有显示，因为此应用不支持它们。';
$string['core.thereisdatatosync'] = '有离线的{{$a}}要同步。';
$string['core.tryagain'] = '再试试';
$string['core.twoparagraphs'] = '{{p1}}<br><br>{{p2}}';
$string['core.uhoh'] = '呃 哦!';
$string['core.unexpectederror'] = '意外出错。请关闭并重新打开此应用程序，然后再试试。';
$string['core.unicodenotsupported'] = '本站点不支持某些表情符号。发送消息时，这些字符将被移除。';
$string['core.unicodenotsupportedcleanerror'] = '清理 Unicode 字符时发现空文本。';
$string['core.unknown'] = '未知的';
$string['core.unzipping'] = '解压中';
$string['core.updaterequired'] = '应用需要更新';
$string['core.updaterequireddesc'] = '请将您的应用升级到版本{{$a}}';
$string['core.user.contact'] = '联系方式';
$string['core.user.detailsnotavailable'] = '您无法获得此用户的详细信息。';
$string['core.user.errorloaduser'] = '加载用户出错。';
$string['core.user.sendemail'] = '电子邮件';
$string['core.viewcode'] = '查看代码';
$string['core.vieweditor'] = '查看编辑器';
$string['core.viewembeddedcontent'] = '查看嵌入的内容';
$string['core.warningofflinedatadeleted'] = '来自{{component}} “{{name}}\'”的离线数据已经被删除。 {{error}}';
$string['core.whyisthishappening'] = '为什么会这样?';
$string['core.wsfunctionnotavailable'] = 'web 服务功能不可用。';
$string['core.youreoffline'] = '您离线了';
$string['core.youreonline'] = '您重新上线了';
$string['freemium.ratetheapp'] = '你喜欢我们的程序吗？';
$string['freemium.ratetheapp_feedbackko'] = '告诉我们哪里有问题';
$string['freemium.ratetheapp_feedbackmessage'] = '你的反馈是匿名的';
$string['freemium.ratetheapp_feedbackok'] = '发送反馈';
$string['freemium.ratetheapp_feedbackplaceholder'] = '在这儿写点什么';
$string['freemium.ratetheapp_feedbacksent'] = '谢谢！你的反馈成功发送。';
$string['freemium.ratetheapp_sendtostore'] = '能占用你片刻给我们的程序一个好评吗？这会帮助我们改进程序。';
$string['freemium.remindmelater'] = '以后提醒我';
$string['freemium.settingsoptionsfacial'] = '启用人脸登录';
$string['freemium.settingsoptionsfingerprint'] = '启用指纹登录';
$string['freemium.subscription'] = '站点订阅';
$string['freemium.subscriptiondetails'] = '订阅详情';
$string['freemium.subscriptionfeature_exceeded_customlanguagestrings'] = '{{ overflowCount }} 个个性化语言字符串被忽略';
$string['freemium.subscriptionfeature_exceeded_custommenuitems'] = '{{ overflowCount }} 个个性化菜单项被忽略';
$string['freemium.subscriptionfeature_exceeded_disabledfeatures'] = '{{ overflowCount }} 个已设置禁用的功能仍在启用';
$string['freemium.subscriptionfeature_exceeded_remotethemes'] = '你的个性化主题未被应用';
$string['freemium.subscriptionfeature_exceeded_sitelogo'] = '你的站点标志未被应用';
$string['freemium.subscriptionfeature_limited'] = '受限于{{ limit }}';
$string['freemium.subscriptionfeature_unlimited'] = '无限制';
$string['freemium.subscriptionplan'] = '订阅计划';
$string['freemium.subscriptionplan_expired'] = '过期';
$string['freemium.subscriptionplan_free'] = '免费';
$string['freemium.subscriptionplan_upgrade'] = '升级你的计划';
$string['freemium.subscriptionplan_validuntil'] = '有效直到 {{ date }}';
$string['freemium.subscriptionplandescription'] = '订阅计划是为了使用本站点的受限应用。';
$string['freemium.subscriptionplanlearnmore'] = '学习更多';
$string['freemium.upsell_renewexpired'] = '你的订阅计划已过期';
$string['freemium.upsell_renewexpiring'] = '你的订阅计划将于 {{ days }} 天后过期';
$string['freemium.upsell_renewtitle'] = '恢复你的订阅';
$string['freemium.upsell_upgradefreeaccept'] = '升级';
$string['freemium.upsell_upgradefreemessage'] = '你目前是免费计划，升级可解锁更多功能。';
$string['freemium.upsell_upgradefreepostpone'] = '以后';
$string['freemium.upsell_upgradefreetitle'] = '升级你的计划';
$string['pluginname'] = 'Moodle 移动设备语言字符串';
$string['privacy_metadata'] = '此插件未存储任何用户数据';
$string['workplace.teams.isoverdue'] = '有逾期或者过期的项目';
