<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'theme_adaptable', language 'sr_lt', version '4.1'.
 *
 * @package     theme_adaptable
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['aboutme'] = 'O meni';
$string['actingasrole'] = 'Trenutno imate drugu ulogu';
$string['activatetemplateoverride'] = 'Aktivirajte izmenu šablona za \'{$a}\'';
$string['activatetemplateoverridedesc'] = 'Kada je označeno, vrednost u podešavanju \'{$a->setting}\' će se koristiti kao šablon \'{$a->template}\' ako sadrži tekst.';
$string['activebreadcrumb'] = 'Boja pozadine aktivne stavke navigacione putanje';
$string['activebreadcrumbdesc'] = 'Podesite boju pozadine trenutno aktivne stavke u navigacionoj putanji, kao i ostatka trake navigacione putanje.';
$string['activitiesheading'] = 'Aktivnosti';
$string['alertaccess'] = 'Vidljivost važnog obaveštenja';
$string['alertaccessadmins'] = 'Vidljivo administratorima';
$string['alertaccessdesc'] = 'Podesite tip ograničenja pristupa za vidljivost okvira sa važnim obaveštenjem. Napomena: ako koristite opciju ”Dodaj ograničenje vezano za prilagođeno polje profila” moraćete da unesete vrednosti za polja profila u donje polje.';
$string['alertaccessglobal'] = 'Vidljivo svima';
$string['alertaccessprofile'] = 'Dodaj ograničenje vezano za prilagođeno polje profila';
$string['alertaccessusers'] = 'Vidljivo prijavljenim korisnicima';
$string['alertannounce'] = 'Oglas';
$string['alertannouncedesc'] = 'Prikazuje oglas u okviru za važna obaveštenja.';
$string['alertbackgroundcolorinfo'] = 'Informacija - boja pozadine';
$string['alertbackgroundcolorinfodesc'] = 'Boja pozadine okvira za važna obaveštenja tipa "Informacija"';
$string['alertbackgroundcolorsuccess'] = 'Oglas - boja pozadine';
$string['alertbackgroundcolorsuccessdesc'] = 'Boja pozadine okvira za važna obaveštenja tipa "Oglas"';
$string['alertbackgroundcolorwarning'] = 'Upozorenje - boja pozadine';
$string['alertbackgroundcolorwarningdesc'] = 'Boja pozadine okvira za važna obaveštenja tipa "Upozorenje"';
$string['alertbordercolorinfo'] = 'Informacija - boja bordure';
$string['alertbordercolorinfodesc'] = 'Boja bordure okvira za važna obaveštenja tipa "Informacija"';
$string['alertbordercolorsuccess'] = 'Oglas - boja bordure';
$string['alertbordercolorsuccessdesc'] = 'Boja bordure okvira za važna obaveštenja tipa "Oglas"';
$string['alertbordercolorwarning'] = 'Upozorenje - boja bordure';
$string['alertbordercolorwarningdesc'] = 'Boja bordure okvira za važna obaveštenja tipa "Upozorenje"';
$string['alertcolorinfo'] = 'Informacija - boja ikonice';
$string['alertcolorinfodesc'] = 'Boja ikonice okvira za važna obaveštenja tipa "Informacija"';
$string['alertcolorsheading'] = 'Prilagodite okvire sa važnim obaveštenjem na vrhu stranice';
$string['alertcolorsuccess'] = 'Oglas - boja ikonice';
$string['alertcolorsuccessdesc'] = 'Boja ikonice okvira za važna obaveštenja tipa "Oglas"';
$string['alertcolorwarning'] = 'Upozorenje - boja ikonice';
$string['alertcolorwarningdesc'] = 'Boja ikonice okvira za važna obaveštenja tipa "Upozorenje"';
$string['alertcount'] = 'Broj važnih obaveštenja';
$string['alertcountdesc'] = 'Broj važnih obaveštenje koji se prikazuje u nastavku ove stranice za uređivanje.';
$string['alertdesc'] = 'Unesite i prilagodite tekst koji će biti prikazan na vrhu sajta kao važno obaveštenje. Moguće je podesiti više od jednog važnog obaveštenja, tako da svako bude namenjeno različitim tipovima korisnika. Takođe, imate mogućnost da obaveštenja prikažete na čitavom sajtu ili samo na naslovnoj stranici. <br /><br /><strong>Napomena:</strong> Sada je moguće prikazati važno obaveštenje na stranicama kursa kako biste upozorili predavače da su kursevi skriveni.';
$string['alertdisabled'] = 'Onemogućeno';
$string['alertdisabledesc'] = 'Onemogući ovo važno obaveštenje.';
$string['alerthiddencourse'] = 'Upozorenje o skrivenom kursu';
$string['alerthiddencoursedesc'] = 'Prikazuje važno obaveštenje na stranici kursa ako je kurs skriven';
$string['alerthiddencoursetext-end'] = '.';
$string['alerthiddencoursetext-link'] = 'kliknite ovde kako biste ažurirali podešavanja';
$string['alerthiddencoursetext-start'] = 'Ovaj kurs je skriven i polaznici ne mogu da mu pristupe.';
$string['alerticoninfo'] = 'Ikonica "Informacija"';
$string['alerticoninfodesc'] = 'Podesite <a href="http://fortawesome.github.io/Font-Awesome/icons/">Font Awesome ikonicu</a> koja će se koristiti za važna obaveštenja tipa "Informacija". Unesite naziv ikonice bez prefiksa fa-.';
$string['alerticonsuccess'] = 'Ikonica "Oglas"';
$string['alerticonsuccessdesc'] = 'Podesite <a href="http://fortawesome.github.io/Font-Awesome/icons/">Font Awesome ikonicu</a> koja će se koristiti za važna obaveštenja tipa "Oglas". Unesite naziv ikonice bez prefiksa fa-.';
$string['alerticonwarning'] = 'Ikonica "Upozorenje"';
$string['alerticonwarningdesc'] = 'Podesite <a href="http://fortawesome.github.io/Font-Awesome/icons/">Font Awesome ikonicu</a> koja će se koristiti za važna obaveštenja tipa "Uozorenje". Unesite naziv ikonice bez prefiksa fa-.';
$string['alertinfo'] = 'Informacija';
$string['alertinfodesc'] = 'Prikazuje informaciju u okviru za važna obaveštenja.';
$string['alertkeyvalue'] = 'Ključ važnog obaveštenja';
$string['alertkeyvalue_details'] = 'Ključ koji razlikuje ovo važno obaveštenje od prethodnih. Ako promenite ovaj ključ, svi korisnici koji su prethodno odbacili obaveštenje, videće ga ponovo. Ako izmenite obaveštenje, verovatno ćete hteti da promenite i ključ kako biste bili sigurni da će korisnici videti obaveštenje.';
$string['alertprofilefield'] = 'Naziv prilagođenog polja profila=vrednost (opciono)';
$string['alertprofilefielddesc'] = 'Dodajte pravilo pristupa koristeći prilagođeno polje profila, npr: usertype=student.';
$string['alertsettings'] = 'Okvir sa važnim obaveštenjem {$a}';
$string['alertsettingscourse'] = 'Podešavanja važnih obaveštenja na kursu';
$string['alertsettingsgeneral'] = 'Opšta podešavanja važnih obaveštenja';
$string['alertsettingsheading'] = 'Prilagodite okvir sa važnim obaveštenjem na vrhu stranice. Pogledajte primer rasporeda elemenata na stranici <a href="./../theme/adaptable/pix/layout.png" target="_blank">ovde</a>';
$string['alerttext'] = 'Tekst važnog obaveštenja';
$string['alerttextdesc'] = 'Uneti tekst koji će biti prikazan u okviru sa važnim obaveštenjem.';
$string['alerttype'] = 'Tip okvira sa važnim obaveštenjem';
$string['alerttypedesc'] = 'Izaberite tip obaveštenja: informacija (plavo), upozorenje (žuto) ili oglas (zeleno).';
$string['alertwarning'] = 'Upozorenje';
$string['alertwarningdesc'] = 'Prikazuje upozorenje u okviru za važna obaveštenja.';
$string['analyticscount'] = 'Broj polja analitike';
$string['analyticscountdesc'] = 'Broj polja analitike koji se prikazuje u nastavku ove stranice za uređivanje.';
$string['analyticsprofilefield'] = 'Naziv prilagođenog polja profila=vrednost (opciono)';
$string['analyticsprofilefielddesc'] = 'Dodajte pravilo pristupa koristeći prilagođeno polje profila, npr: usertype=student.';
$string['analyticssettings'] = 'Analitika';
$string['analyticssettingsdesc'] = 'Možete da podesite više kôdova za Google Analytics i povežete ih sa poljima korisničkih profila. Takođe možete da koristite Matomo, alat za analitiku, otvorenog kôda.';
$string['analyticssettingsheading'] = 'Podešavanje za Google Analytics i/ili Matomo';
$string['analyticstext'] = 'ID oznaka za Google Analytics';
$string['analyticstextdesc'] = 'Unesite ID oznaku za Google Analytics.';
$string['anonymizega'] = 'Sakrij korisničku IP adresu';
$string['anonymizegadesc'] = 'Sakrij korisničku IP adresu pre slanja podataka za Google Analytics.';
$string['backcolor'] = 'Boja pozadine';
$string['backcolordesc'] = 'Podesite boju pozadine.';
$string['bcustyle'] = 'BCU stil';
$string['blockbackgroundcolor'] = 'Boja pozadine bloka';
$string['blockbackgroundcolordesc'] = 'Podesite boju pozadine za sve blokove.';
$string['blockbordercolor'] = 'Boja bordure bloka';
$string['blockbordercolordesc'] = 'Podesite boju bordure bloka.';
$string['blockheaderbackgroundcolor'] = 'Boja pozadine naslova bloka';
$string['blockheaderbackgroundcolordesc'] = 'Podesite boju pozadine naslova za sve blokove.';
$string['blockheaderborderbottom'] = 'Debljina donje bordure zaglavlja bloka';
$string['blockheaderborderbottomdesc'] = 'Podesite debljinu donje bordure zaglavlja blokova.';
$string['blockheaderborderleft'] = 'Debljina leve bordure zaglavlja bloka';
$string['blockheaderborderleftdesc'] = 'Podesite debljinu leve bordure zaglavlja blokova.';
$string['blockheaderborderright'] = 'Debljina desne bordure zaglavlja bloka';
$string['blockheaderborderrightdesc'] = 'Podesite debljinu desne bordure zaglavlja blokova.';
$string['blockheaderbordertop'] = 'Debljina gornje bordure zaglavlja bloka';
$string['blockheaderbordertopdesc'] = 'Podesite debljinu gornje bordure zaglavlja blokova.';
$string['blockheaderbordertopstyle'] = 'Stil bordura zaglavlja blokova';
$string['blockheaderbordertopstyledesc'] = 'Podesite stil bordura zaglavlja blokova.';
$string['blockheaderbottomradius'] = 'Donji poluprečnik zaglavlja bloka';
$string['blockheaderbottomradiusdesc'] = 'Podesite donji poluprečnik bloka zaglavlja kako biste postigli efekat zakrivljenosti/zaobljenosti.';
$string['blockheadercolor'] = 'Boja teksta zaglavlja bloka';
$string['blockheadercolordesc'] = 'Podesite boju teksta zaglavlja bloka.';
$string['blockheadertopradius'] = 'Gornji poluprečnik zaglavlja bloka';
$string['blockheadertopradiusdesc'] = 'Podesite gornji poluprečnik zaglavlja bloka kako biste postigli efekat zakrivljenosti/zaobljenosti.';
$string['blockicons'] = 'Ikonice blokova';
$string['blockiconsdesc'] = 'Podesite ovo kako bi ikonice blokova bile prikazane u zaglavlju bloka.';
$string['blockiconsheadersize'] = 'Veličina ikonica u zaglavlju blokova';
$string['blockiconsheadersizedesc'] = 'Podesite veličinu ikonice fonta koja se koristi u zaglavlju moodle blokova. Izaberite vrednost sa liste.';
$string['blocklayoutbuilder'] = 'Regioni naslovne stranice sa blokovima';
$string['blocklayoutbuilderdesc'] = 'Ispod možete da napravite svoj raspored regiona sa blokovima na naslovnoj stranici. <br/>Da biste dodali sadržaj u ove regione moraćete da <strong> uključite uređivanje na naslovnoj stranici vašeg Moodle sajta</strong>.<br/>Nakon toga možete početi da prevlačite i spuštate blokove u regione koje ste kreirali!';
$string['blocklayoutlayoutcheck'] = 'Proverite svoj raspored blokova';
$string['blocklayoutlayoutcheckdesc'] = 'Upotrebite alat u nastavku kako biste proverili broj blokova koje koristite i videli kako izgleda vaš novi raspored blokova.';
$string['blocklayoutlayoutcount1'] = 'Možete da podesite najviše';
$string['blocklayoutlayoutcount2'] = 'region/a sa blokovima. Trenutno koristite:';
$string['blocklayoutlayoutrow'] = 'Red regiona sa blokovima';
$string['blocklayoutlayoutrowdesc'] = 'Dodajte / podesite raspored blokova u redu regiona sa blokovima na naslovnoj stranici.';
$string['blockmainborderbottom'] = 'Debljina donje bordure tela bloka';
$string['blockmainborderbottomdesc'] = 'Podesite debljinu donje bordure tela bloka.';
$string['blockmainborderleft'] = 'Debljina leve bordure tela bloka';
$string['blockmainborderleftdesc'] = 'Podesite debljinu leve bordure tela bloka.';
$string['blockmainborderright'] = 'Debljina desne bordure tela bloka';
$string['blockmainborderrightdesc'] = 'Podesite debljinu desne bordure tela bloka.';
$string['blockmainbordertop'] = 'Debljina gornje bordure tela bloka';
$string['blockmainbordertopdesc'] = 'Podesite debljinu gornje bordure tela bloka.';
$string['blockmainbordertopstyle'] = 'Stil bordura tela bloka';
$string['blockmainbordertopstyledesc'] = 'Podesite stil bordura tela bloka';
$string['blockmainbottomradius'] = 'Donji poluprečnik tela bloka';
$string['blockmainbottomradiusdesc'] = 'Podesite donji poluprečnik tela bloka kako biste postigli efekat zakrivljenosti/zaobljenosti.';
$string['blockmaintopradius'] = 'Gornji poluprečnik tela bloka';
$string['blockmaintopradiusdesc'] = 'Podesite gornji poluprečnik tela bloka kako biste postigli efekat zakrivljenosti/zaobljenosti.';
$string['blockregionbackground'] = 'Boja pozadine regiona blokova';
$string['blockregionbackgrounddesc'] = 'Boja pozadine kontejnera koji sadrži prilagođeni raspored blokova na naslovnoj stranici.';
$string['blockregioneditingtitleshown'] = 'Prikažite naslov regiona sa blokovima prilikom uređivanja';
$string['blockregioneditingtitleshowndesc'] = 'Možete prikazati / sakriti naslov regiona sa blokovima prilikom uređivanja.';
$string['blockside'] = 'Pozicija blokova';
$string['blocksidedesc'] = 'Kontroliše da li se blokovi na stranici pojavljuju levo ili desno.';
$string['breadcrumb'] = 'Navigaciona putanja';
$string['breadcrumbbackgroundcolor'] = 'Boja pozadine navigacione trake';
$string['breadcrumbbackgroundcolordesc'] = 'Podesite boju pozadine navigacione trake.';
$string['breadcrumbdisplay'] = 'Prikaz navigacione putanje';
$string['breadcrumbdisplaydesc'] = 'Podesite prikaz onoga što bi trebalo da bude u regionu navigacione putanje.';
$string['breadcrumbhome'] = 'Oznaka početne stranice u navigacionoj putanji';
$string['breadcrumbhomedesc'] = 'Prikažite oznaku za početnu stranicu u navigacionoj putanji kao ikonicu ili kao tekst.';
$string['breadcrumbhomeicon'] = 'Ikonica';
$string['breadcrumbhomeoff'] = 'Isklučeno';
$string['breadcrumbhometext'] = 'Tekst';
$string['breadcrumbseparator'] = 'Graničnik navigacione putanje';
$string['breadcrumbseparatordesc'] = 'Podesite <a href="http://fortawesome.github.io/Font-Awesome/icons/" target="_blank">Font Awesome ikonicu</a> koja će se koristiti kao graničnik u navigacionoj traci. Unesite naziv ikonice bez prefiksa fa-.';
$string['breadcrumbtextcolor'] = 'Boja teksta navigacione putanje';
$string['breadcrumbtextcolordesc'] = 'Podesite boju teksta navigacione putanje.';
$string['breadcrumbtitle'] = 'Naziv kursa u navigacionoj putanji';
$string['breadcrumbtitledesc'] = 'Podesite način na koji će naziv kursa biti prikazan u navigacionoj putanji.';
$string['bs4all'] = 'Ekstra mali - Ekstra veliki';
$string['bs4extralarge'] = 'Samo ekstra veliki';
$string['bs4large'] = 'Veliki - Ekstra veliki';
$string['bs4medium'] = 'Srednji - Ekstra veliki';
$string['bs4none'] = 'Nijedan';
$string['bs4small'] = 'Mali - Ekstra veliki';
$string['buttoncolor'] = 'Boja dugmeta';
$string['buttoncolorcancel'] = 'Boja dugmeta \'Otkaži\'';
$string['buttoncolordesc'] = 'Boja glavne dugmadi koja se koriste na čitavom sajtu.';
$string['buttoncolordesccancel'] = 'Boja pozadine dugmeta \'Otkaži\'<br />Unesite <strong>transparent</strong> u okvir za transparentnost.';
$string['buttoncolordescscnd'] = 'Boja sekundarnih dugmadi koja se koriste na čitavom veb sajtu.';
$string['buttoncolorscnd'] = 'Boja sekundarnog dugmeta';
$string['buttondesc'] = 'Promenite izgled dugmadi koja se koriste u ovoj temi.';
$string['buttondropshadow'] = 'Dekoracija u formi senke na dnu dugmeta';
$string['buttondropshadowdesc'] = 'Prikažite senku (senčenje) na dnu dugmeta.';
$string['buttonfocuscolour'] = 'Boja pozadine prilikom fokusiranja dugmeta';
$string['buttonfocuscolourdesc'] = 'Boja koju dugme koristi kada se nađe u fokusu.';
$string['buttonhovercolor'] = 'Lebdeća boja dugmeta';
$string['buttonhovercolorcancel'] = 'Lebdeća boja dugmeta \'Otkaži\'';
$string['buttonhovercolordesc'] = 'Boja dugmeta kada se mišem pređe preko njega';
$string['buttonhovercolordesccancel'] = 'Boja u koju se menja dugme \'Otkaži\' kada pređete mišem preko dugmeta. <br />Upišite <strong>transparent</strong> u okvir za transparentnost.';
$string['buttonhovercolordescscnd'] = 'Boja u koju se menja sekundarno dugme kada pređete mišem preko dugmeta.';
$string['buttonhovercolorscnd'] = 'Lebdeća boja sekundarnog dugmeta';
$string['buttonlogincolor'] = 'Boja dugmeta za prijavu';
$string['buttonlogincolordesc'] = 'Boja dugmeta za prijavu na sistem.';
$string['buttonloginheight'] = 'Podesi visinu dugmeta za prijavu';
$string['buttonloginheightdesc'] = 'Ovo podešavanje ima efekta samo ako se koristi obrazac za prijavu na sistem u gornjem zaglavlju.';
$string['buttonloginhovercolor'] = 'Lebdeća boja dugmeta za prijavu';
$string['buttonloginhovercolordesc'] = 'Boja dugmeta za prijavu na sistem kada se mišem pređe preko njega';
$string['buttonloginmargintop'] = 'Podesite gornju marginu dugmeta za prijavu';
$string['buttonloginmargintopdesc'] = 'Omogućava da rastojanje dugmeta za prijavu od gornje ivice, odnosno njegovo pozicija bude promenjena.';
$string['buttonloginpadding'] = 'Podesi razmak između ivice i teksta dugmeta za prijavu';
$string['buttonloginpaddingdesc'] = 'Veći broj = veće dugme.';
$string['buttonlogintextcolor'] = 'Boja teksta dugmeta za prijavu';
$string['buttonlogintextcolordesc'] = 'Boja teksta koji se koristi na dugmetu za prijavu na sistem.';
$string['buttonradius'] = 'Podesi poluprečnik dugmeta';
$string['buttonradiusdesc'] = 'Veći poluprečnik = zakrivljena dugmad, manji poluprečnik = četvrtasta dugmad.';
$string['buttonsettings'] = 'Dugmad';
$string['buttonsettingsheading'] = 'Podesite dugmad u ovoj temi';
$string['buttontextcolor'] = 'Boja teksta dugmeta';
$string['buttontextcolorcancel'] = 'Boja teksta na dugmetu \'Otkaži\'.';
$string['buttontextcolordesc'] = 'Boja teksta koji se koristi na dugmadima.';
$string['buttontextcolordesccancel'] = 'Boja teksta koja se koristi na dugmadima za otkazivanje.';
$string['buttontextcolordescscnd'] = 'Boja teksta koja se koristi na sekundarnim dugmadima.';
$string['buttontextcolorscnd'] = 'Boja teksta sekundarnih dugmadi';
$string['buttontextfocuscolour'] = 'Boja teksta prilikom fokusiranja dugmeta';
$string['buttontextfocuscolourdesc'] = 'Boja teksta koju dugme koristi kada se nađe u fokusu.';
$string['buttontexthovercolor'] = 'Lebdeća boja teksta na dugmetu';
$string['buttontexthovercolordesc'] = 'Boja u koju se menja tekst dugmeta kada pređete mišem preko dugmeta.';
$string['cachedef_adaptablefontawesomeiconmapping'] = 'Kešira Font Awesome ikonice';
$string['categoryhavecustomheader'] = 'Prilagođeno zaglavlje kategorije';
$string['categoryhavecustomheaderdesc'] = 'Izaberite kategorije najvišeg nivoa koje će imati prilagođeno zaglavlje. Da biste izabrali više od jedne ili poništili izbor kategorije koristite taster \'Ctrl\'. Sačuvajte i osvežite stranicu kako biste je ažurirali. Napomena: potkategorije izabranih kategorije će naslediti vrednosti podešavanja.';
$string['categoryheaderbgimage'] = 'Pozadinska slika kategorije \'{$a->name}\' sa ID oznakom id \'{$a->id}\'';
$string['categoryheaderbgimagedesc'] = 'Podesite pozadinsku sliku za kategoriju najvišeg nivoa \'{$a->name}\' sa ID oznakom \'{$a->id}\' u zaglavlju. Minimalna veličina je 1600x180 piksela (preporučuju se 1900x180 piksela). Slika će pokriti celo zaglavlje.';
$string['categoryheaderbgimagedescchildren'] = 'Podesite pozadinsku sliku za kategoriju najvišeg nivoa \'{$a->name}\' sa ID oznakom \'{$a->id}\' i njene potkategorije \'{$a->children}\' u zaglavlju. Minimalna veličina je 1600x180 piksela (preporučuju se 1900x180 piksela). Slika će pokriti celo zaglavlje.';
$string['categoryheaderbgimagetextcolour'] = 'Boja teksta na pozadinskoj slici kategorije \'{$a->name}\' sa ID oznakom \'{$a->id}\'';
$string['categoryheaderbgimagetextcolourdesc'] = 'Podesite boju teksta na pozadinskoj slici za kategoriju najvišeg nivoa \'{$a->name}\' sa ID oznakom id \'{$a->id}\' u zaglavlju.';
$string['categoryheaderbgimagetextcolourdescchildren'] = 'Podesite boju teksta na pozadinskoj slici za kategoriju najvišeg nivoa \'{$a->name}\' sa ID oznakom \'{$a->id}\' i njene potkategorije \'{$a->children}\' u zaglavlju.';
$string['categoryheadercustomcss'] = 'Prilagođeni SCSS kategorije \'{$a->name}\' sa ID oznakom \'{$a->id}\'';
$string['categoryheadercustomcssdesc'] = 'Podesite prilagođeni SCSS za kategoriju najvišeg nivoa \'{$a->name}\' sa ID oznakom id \'{$a->id}\'. Ovo će generisati SCSS za selektor teme sa prefiksom \'.category-{$a->id}\'. Ako se vam se učini da SCSS nije primenjen, onda upotrebite alate za razvoj veb čitača kako biste utvrdili šta se dogodilo. Takođe, proverite PHP datoteku zapisa.';
$string['categoryheadercustomcssdescchildren'] = 'Podesite prilagođeni SCSS za kategoriju najvišeg nivoa \'{$a->name}\' са ID ознаком id \'{$a->id}\' i sve njene potkategorije \'{$a->children}\'. Ovo će generisati SCSS za selektor teme sa prefiksom \'.category-{$a->id}\' i za sve ID oznake potkategorija. Ako se vam se učini da SCSS nije primenjen, onda upotrebite alate za razvoj veb čitača kako biste utvrdili šta se dogodilo. Takođe, proverite PHP datoteku zapisa.';
$string['categoryheadercustomtitle'] = 'Prilagođeni naslov kategorije \'{$a->name}\' sa ID oznakom \'{$a->id}\'';
$string['categoryheadercustomtitledesc'] = 'Podesite prilagođeni naslov za kategoriju najvišeg nivoa \'{$a->name}\' sa ID oznakom \'{$a->id}\' u zaglavlju. Ako je prazno, biće vam prikazano sa onim što je konfigurisano podešavanjima \'sitetitle\' i \'sitetitletext\' na stranicama koje nisu povezane sa kursom ili na stranicama kursa kada je podešavanje \'enableheading\' konfigurisano na \'off\'. Kada se popuni na stranicama koje nisu povezane sa kategorijama kurseva, ovo će zameniti naslov sajta. Kada se popuni na stranicama kursa, pojaviće se iznad naslova kao što je postavljeno podešavanjem \'enableheading\'. Ali na mobilnim uređajima svaki \'title\' će se pojaviti samo u zavisnosti od podešavanja \'responsivecoursetitle\'.';
$string['categoryheadercustomtitledescchildren'] = 'Podesite prilagođeni naslov za kategoriju najvišeg nivoa \'{$a->name}\' sa ID oznakom \'{$a->id}\' i njene potkategorije \'{$a->children}\' u zaglavlju. Ako je prazno, biće vam prikazano sa onim što je konfigurisano podešavanjima \'sitetitle\' i \'sitetitletext\' na stranicama koje nisu povezane sa kursom ili na stranicama kursa kada je podešavanje \'enableheading\' konfigurisano na \'off\'. Kada se popuni na stranicama koje nisu povezane sa kategorijama kurseva, ovo će zameniti naslov sajta. Kada se popuni na stranicama kursa, pojaviće se iznad naslova kao što je postavljeno podešavanjem \'enableheading\'. Ali na mobilnim uređajima svaki \'title\' će se pojaviti samo u zavisnosti od podešavanja \'responsivecoursetitle\'.';
$string['categoryheaderheader'] = 'Podešavanja za kategoriju najvišeg nivoa \'{$a->name}\' sa ID oznakom \'{$a->id}\'.';
$string['categoryheaderheaderdesc'] = 'Konfigurišite podešavanje za kategoriju najvišeg nivoa \'{$a->name}\' sa ID oznakom \'{$a->id}\'.';
$string['categoryheaderheaderdescchildren'] = 'Konfigurišite podešavanje za kategoriju najvišeg nivoa \'{$a->name}\' sa ID oznakom \'{$a->id}\' i sve njene potkategorije \'{$a->children}\'.';
$string['categoryheaderlogo'] = 'Logotip kategorije \'{$a->name}\' sa ID oznakom \'{$a->id}\'';
$string['categoryheaderlogodesc'] = 'Podesite logo za kategoriju najvišeg nivoa \'{$a->name}\' sa ID oznakom \'{$a->id}\' u zaglavlju. Preporučena veličina je 200 sa 80 piksela.';
$string['categoryheaderlogodescchildren'] = 'Podesite logo za kategoriju najvišeg nivoa \'{$a->name}\' sa ID oznakom \'{$a->id}\' i njene potkategorije \'{$a->children}\' u zaglavlju. Preporučena veličina je 200 sa 80 piksela.';
$string['categoryheaderssettings'] = 'Zaglavlja kategorija';
$string['categoryheaderssettingsdesc'] = 'Konfigurišite podešavanja za zaglavlja unutar kategorije.';
$string['categoryheaderssettingsheading'] = 'Promenite zaglavlje za jednu ili više kategorija najvišeg nivoa i potkategorija.';
$string['cdefaulticon'] = 'Standardna ikonica za \'Moji kursevi\'';
$string['cdefaulticondesc'] = 'Font Awesome ikonica bez prefiksa \'fa-\' koja se koristi za kurseve kada već nemaju ikonicu. Ako je polje prazno, koristiće se standardna ikonica.';
$string['cfrozenicon'] = 'Ikonica za zamrznute \'Moje kurseve\'';
$string['cfrozenicondesc'] = 'Font Awesome ikonica bez prefiksa \'fa-\' koja se koristi za zamrznute kurseve. Ako je polje prazno, koristiće se standardna ikonica.';
$string['chiddenicon'] = 'Ikonica za skrivene \'Moje kurseve\'';
$string['chiddenicondesc'] = 'Font Awesome ikonica bez prefiksa \'fa-\' koja se koristi za skrivene kurseve. Ako je polje prazno, koristiće se standardna ikonica.';
$string['choosereadme'] = '<div class="clearfix">
<div class="well">
<h2>Adaptable</h2>
<p><img class="img-polaroid" src="adaptable/pix/screenshot.png" /></p>
</div>
<div class="well">
<h2>Zasluge</h2>
<h3>O temi</h3>
<p>Adaptable je Moodle prilagodljiva tema sa dva stupca, i sa velikim brojem opcija za prilagođavanje. Tema se bazira na popularnoj BCU temi.</p>
<p>Ova tema je objavljena pod GPL  licencom (GNU General Public License). Kompletnu kopiju licence možete naći na: http://www.gnu.org/licenses/</p>
<p>Menjajte je / Unapređujte / Delite</p>
<br>
<p>Ovu temu su razvili:<br>
Jeremy Hopkins (Coventry University)<br>
Fernando Acedo (3-bits.com)<br>
</p>
<br>
 <p>i mnogi drugi programeri, testeri, prevodioci i volonteri (See <a href="adaptable/README.txt" target="_blank">README.txt</a>)</p>
<br>
<h3>Izveštaj o greškama</h3>
<p>Greške možete prijaviti (i molimo vas, <b>SAMO</b> greške) na našem <a href="https://bitbucket.org/covuni/moodle-theme_adaptable/issues" target="_blank">Bitbucket repozitorijumu</a></p>
<br>
<h3>Tehnička podrška</h3>
<p>Možete postavljati svoja pitanja i nedoumice, i deliti svoje savete na Moodle forumu:</p>
<ul>
<li>English: <a href="https://moodle.org/mod/forum/discuss.php?d=340404" target="_blank">https://moodle.org/mod/forum/discuss.php?d=340404</a>
<li>Español: <a href="https://moodle.org/mod/forum/discuss.php?d=326804" target="_blank">https://moodle.org/mod/forum/discuss.php?d=326804</a>
<li>Català: <a href="https://moodle.org/mod/forum/discuss.php?d=340406" target="_blank">https://moodle.org/mod/forum/discuss.php?d=340406</a>
</ul>
<br>
<h3>Dokumentacija</h3>
<p>Uskoro</p>
<br>
<h3>Demo</h3>
<p>Demo verziju teme možete videti <a href="http://3-bits.com/demo/adaptable" target="_blank">OVDE</a></p>
<br>
</div>
</div>';
$string['cneveraccessedicon'] = 'Ikonica za \'Moje kurseve\' kojima korisnici nisu pristupili';
$string['cneveraccessedicondesc'] = 'Font Awesome ikonica bez prefiksa \'fa-\' koja se koristi za kurseve na koje su korisnici upisani ali im nisu pristupali. Ako je polje prazno, koristiće se standardna ikonica.';
$string['collapsedtopicscoloursenabled'] = 'Podešavanja boja prednjeg plana i pozadine prekidača formata kursa \'Skupljene teme\'';
$string['collapsedtopicscoloursenableddesc'] = 'Koristite podešavanja boje prednjeg plana i pozadine prekidača formata kursa \'Skupljene teme\', umesto podešavanja \'sectionheadingcolor\' i \'coursesectionheaderbg\' teme Adaptable.';
$string['colordesc'] = 'Možete da izaberete boje koje želite da koristite u okviru ove teme. Koristite heksadecimalnu ili bilo koju drugu standardnu notaciju. Alternativno, možete da koristite vrednosti "transparent" ili "inherited"';
$string['colorsettings'] = 'Boje';
$string['colorsettingsheading'] = 'Izmenite glavne boje koje se koriste u ovoj temi.';
$string['configtabtitle'] = 'Podešavanja';
$string['configtitle'] = 'Adaptable';
$string['course'] = 'Kurs';
$string['courseactivitynavigationenabled'] = 'Navigacija aktivnosti';
$string['courseactivitynavigationenableddesc'] = 'Navigacija aktivnosti omogućena.';
$string['courseindexenabled'] = 'Omogućeno';
$string['courseindexenableddesc'] = 'Omogućite ili onemogućite \'Indeks kursa\'.';
$string['courseindexitemcolor'] = 'Boja stavke';
$string['courseindexitemcolordesc'] = 'Boja stavke u \'Indeksu kursa\'.';
$string['courseindexitemhovercolor'] = 'Lebdeća boja stavke';
$string['courseindexitemhovercolordesc'] = 'Lebdeća boja stavke u \'Indeksu kursa\'.';
$string['courseindexpageitembgcolor'] = 'Boja pozadine aktivne stavke';
$string['courseindexpageitembgcolordesc'] = 'Boja pozadine aktivne stavke u \'Indeksu kursa\'.';
$string['courseindexpageitemcolor'] = 'Boja aktivne stavke';
$string['courseindexpageitemcolordesc'] = 'Boja aktivne stavke u \'Indeksu kursa\'';
$string['courseindexsettings'] = 'Indeks kursa';
$string['courseindexsettingsdesc'] = 'Prilagodite indeks kursa';
$string['courseindexsettingsheading'] = 'Podešavanja indeksa kursa';
$string['coursepageactivitybottomblockregionheading'] = 'Prilagođeni donji region sa blokovima na stranici aktivnosti';
$string['coursepageactivitybottomblockregionheadingdesc'] = 'Prilagođeni region sa blokovima koji se pojavljuje nakon završetka aktivnosti.';
$string['coursepageblockactivitybottomenabled'] = 'Omogućite donji region sa blokovima unutar stranica aktivnosti, na svim stranicama kursa';
$string['coursepageblockactivitybottomenableddesc'] = 'Omogućite ovaj region na svim stranicama kursa.';
$string['coursepageblocklayoutbuilder'] = 'Regioni blokova na stranici kursa';
$string['coursepageblocklayoutbuilderdesc'] = 'Ispod možete da napravite svoj raspored regiona sa blokovima na stranici kursa.<br/>Da biste dodali sadržaj u ove regione moraćete da<strong> uključite uređivanje na stranici kursa vašeg Moodle sajta</strong>.<br/>Nakon toga možete početi da prevlačite i spuštate blokove u regione koje ste kreirali!';
$string['coursepageblocklayoutlayoutbottomrow'] = 'Red regiona sa blokovima na dnu stranice kursa';
$string['coursepageblocklayoutlayoutbottomrowdesc'] = 'Dodajte / podesite raspored blokova u redu regiona sa blokovima na stranici kursa.';
$string['coursepageblocklayoutlayouttoprow'] = 'Red regiona sa blokovima na vrhu stranice kursa';
$string['coursepageblocklayoutlayouttoprowdesc'] = 'Dodajte / podesite raspored blokova u redu regiona sa blokovima na stranici kursa.';
$string['coursepageblockregionsettings'] = 'Alat za kreiranje regiona blokova na stranici kursa';
$string['coursepageblocksenabled'] = 'Omogući prilagođene regione sa blokovima na stranici kursa';
$string['coursepageblocksenableddesc'] = 'Možete da omogućite / onemogućite prilagođene regione sa blokovima (gornji i donji) na stranici kursa. Nakon toga možete da prevučete i spustite blokove u regione koje ste kreirali.';
$string['coursepageblocksliderenabled'] = 'Omogućite prilagođeni region sa blokom \'Slajd-šou sa vestima\'';
$string['coursepageblocksliderenableddesc'] = 'Omogućite ovaj region na svim stranicama kursa.';
$string['coursepageheaderhidesitetitle'] = 'Sakrij naziv sajta na stranicama kursa';
$string['coursepageheaderhidesitetitledesc'] = 'Sakrijte naziv sajta, logo i polje za pretragu na stranicama kursa. Koristite ovo zajedno sa podešavanjem visine zaglavlja stranice kako biste prikazali manje zaglavlje na stranicama kursa.';
$string['coursepageheaderhidetitle'] = 'Sakrij naslov zaglavlja na stranicama kursa';
$string['coursepageheaderhidetitledesc'] = 'Sakrijte naslov zaglavlja, logotip i traku za pretragu na stranicama kursa. Koristite ovo zajedno sa podešavanjem visine zaglavlja stranice kako biste prikazali manje zaglavlje na stranicama koje su povezane sa kursom.';
$string['coursepagenewssliderblockregionheading'] = 'Prilagođeni region sa blokom \'Slajd-šou sa vestima\'';
$string['coursepagenewssliderblockregionheadingdesc'] = 'Prilagođeni region sa blokom dizajniranim da se koristi kao slajd-šou sa vestima koji je deo Adaptable UI.  Ovaj region se pojavljuje iznad aktivnosti na stranici kursa.  Da biste dodali blok koji prikazuje slajd-šou sa vestima, prvo instalirajte <strong><a href="{$a}" target="_blank">Adaptable UI slajd -šou sa vestima</a></strong> i konfigurišite ga tako da se pojavljuje u regionu "region za slajd-šou stranice kursa" na svim stranicama kursa.';
$string['coursepagesidebarinfooterenabled'] = 'Premesti bočni stubac sa blokovima u podnožje stranice kursa';
$string['coursepagesidebarinfooterenableddesc'] = 'Premeštanjem bočnog stupca sa blokovima u podnožje stranice, deo stranice kursa sa sekcijama će se proširiti.';
$string['coursepagesidebarinfooterenabledsection'] = 'Uobičajena podešavanja';
$string['coursepagesidebarinfooterenabledsectiondesc'] = 'Uobičajena podešavanja za većinu formata kurseva.';
$string['courses'] = 'Kursevi';
$string['coursesearch'] = 'Pretraga kurseva';
$string['coursesectionactivityassignbgcolor'] = 'Boja pozadine \'Zadatka\'';
$string['coursesectionactivityassignbgcolordesc'] = 'Podesite boju pozadine za aktivnost \'Zadatak\'. Unesite <strong>transparent</strong> u polje za transparentnost.';
$string['coursesectionactivityassignleftbordercolor'] = 'Boja prikaza leve bordure aktivnosti \'Zadatak\'';
$string['coursesectionactivityassignleftbordercolordesc'] = 'Podesite boju leve bordure.';
$string['coursesectionactivitybordercolor'] = 'Boja donje bordure aktivnosti unutar sekcije kursa';
$string['coursesectionactivitybordercolordesc'] = 'Podesite boju donje bordure aktivnosti unutar sekcije kursa.';
$string['coursesectionactivityborderstyle'] = 'Stil donje bordure aktivnosti unutar sekcije kursa';
$string['coursesectionactivityborderstyledesc'] = 'Podesite stil donje bordure aktivnosti unutar sekcije kursa.';
$string['coursesectionactivityborderwidth'] = 'Širina donje bordure aktivnosti unutar sekcije kursa';
$string['coursesectionactivityborderwidthdesc'] = 'Podesite širinu bordure koja se pojavljuje na dnu aktivnosti unutar sekcije kursa.';
$string['coursesectionactivitycolors'] = 'Podešavanja aktivnosti unutar sekcije kursa';
$string['coursesectionactivityforumbgcolor'] = 'Boja pozadine \'Foruma\'';
$string['coursesectionactivityforumbgcolordesc'] = 'Podesite boju pozadine za aktivnost \'Forum\'. Unesite <strong>transparent</strong> u polje za transparentnost.';
$string['coursesectionactivityforumleftbordercolor'] = 'Boja prikaza leve bordure aktivnosti \'Forum\'';
$string['coursesectionactivityforumleftbordercolordesc'] = 'Podesite boju leve bordure.';
$string['coursesectionactivityheadingcolour'] = 'Boja naslova sekcije unutar sekcije kursa';
$string['coursesectionactivityheadingcolourdesc'] = 'Boja za aktivnosti na koje se može kliknuti, prikazana na početnoj stranici kursa.';
$string['coursesectionactivityiconsize'] = 'Veličina ikonica aktivnosti unutar sekcije kursa';
$string['coursesectionactivityiconsizedesc'] = 'Podesite veličinu ikonica za aktivnosti / resurse (npr. vrednost 16px će podesiti dimenzije ikonica na veličinu 16 x 16 piksela).';
$string['coursesectionactivityleftborderwidth'] = 'Širina leve bordure unutar sekcije kursa';
$string['coursesectionactivityleftborderwidthdesc'] = 'Podesite širinu bordure koja se pojavljuje sa leve strane aktivnosti unutar sekcije kursa';
$string['coursesectionactivitymarginbottom'] = 'Donja margina razmaka između aktivnosti.';
$string['coursesectionactivitymarginbottomdesc'] = 'Donja margina razmaka između aktivnosti.';
$string['coursesectionactivitymargintop'] = 'Gornja margina razmaka između aktivnosti.';
$string['coursesectionactivitymargintopdesc'] = 'Gornja margina razmaka između aktivnosti.';
$string['coursesectionactivityquizbgcolor'] = 'Boja pozadine \'Testa\'';
$string['coursesectionactivityquizbgcolordesc'] = 'Podesite boju pozadine za aktivnost \'Test\'. Unesite <strong>transparent</strong> u polje za transparentnost.';
$string['coursesectionactivityquizleftbordercolor'] = 'Boja prikaza leve bordure aktivnosti \'Test\'';
$string['coursesectionactivityquizleftbordercolordesc'] = 'Podesite boju leve bordure.';
$string['coursesectionbgcolor'] = 'Pozadina sekcije kursa';
$string['coursesectionbgcolordesc'] = 'Podesite boju pozadine sekcije kursa.';
$string['coursesectionbordercolor'] = 'Boja bordura sekcije kursa';
$string['coursesectionbordercolordesc'] = 'Podesite boju bordura sekcija kursa';
$string['coursesectionborderradius'] = 'Poluprečnik bordura sekcije';
$string['coursesectionborderradiusdesc'] = 'Podesite poluprečnik bordura sekcije kursa (zaobljeni uglovi).';
$string['coursesectionborderstyle'] = 'Stil bordura sekcije';
$string['coursesectionborderstyledesc'] = 'Podesite stil bordura sekcije kursa.';
$string['coursesectionborderwidth'] = 'Širina bordura sekcije';
$string['coursesectionborderwidthdesc'] = 'Podesite širinu bordura sekcija kursa.';
$string['coursesectionheaderbg'] = 'Pozadina zaglavlja sekcije';
$string['coursesectionheaderbgdesc'] = 'Podesite boju pozadine zaglavlja sekcije kursa.';
$string['coursesectionheaderbordercolor'] = 'Boja bordure zaglavlja sekcije';
$string['coursesectionheaderbordercolordesc'] = 'Podesite boju bordure zaglavlja sekcije (koristi se samo donja bordura pošto spoljašnji kontejner ima borduru).';
$string['coursesectionheaderborderradiusbottom'] = 'Donji poluprečnik bordure zaglavlja sekcije';
$string['coursesectionheaderborderradiusbottomdesc'] = 'Podesite donji poluprečnik bordure zaglavlja sekcije (zaobljeni uglovi).';
$string['coursesectionheaderborderradiustop'] = 'Gornji poluprečnik bordure zaglavlja sekcije';
$string['coursesectionheaderborderradiustopdesc'] = 'Podesite gornji poluprečnik bordura zaglavlja sekcije (zaobljeni uglovi).';
$string['coursesectionheaderborderstyle'] = 'Stil bordure zaglavlja sekcije kursa';
$string['coursesectionheaderborderstyledesc'] = 'Podesite stil bordure zaglavlja sekcije kursa (samo donja bordura se koristi pošto spoljašnji kontejner takođe ime borduru).';
$string['coursesectionheaderborderwidth'] = 'Širina bordure zaglavlja sekcije kursa';
$string['coursesectionheaderborderwidthdesc'] = 'Podesite širinu bordure zaglavlja sekcije kursa (samo donja bordura se koristi pošto spoljašnji kontejner takođe ime borduru).';
$string['coursesections'] = 'Sekcije kursa';
$string['coursesettings'] = 'Formati kursa';
$string['coursesettingsdesc'] = 'Prilagodite neke od najčešće korišćenih formata Moodle kurseva kako bi odgovarali glavnom dizajnu.';
$string['coursesettingsheading'] = 'Podešavanja formata kursa';
$string['coursetitlefullname'] = 'Pun naziv kursa';
$string['coursetitlemaxwidth'] = 'Maksimalna dužina naslova kursa';
$string['coursetitlemaxwidthdesc'] = 'Podesite maksimalan broj znakova regiona sa naslovom kursa';
$string['coursetitleshortname'] = 'Skraćeni naziv kursa / kôd';
$string['covbkcolor'] = 'Boja pozadine naslova na Koventri pločicama';
$string['covbkcolordesc'] = 'Podesite boju pozadine naslova kada su izabrane Koventri pločice';
$string['coventrystyle'] = 'Koventri stil';
$string['covfontcolor'] = 'Boja slova naslova na Koventri pločicama';
$string['covfontcolordesc'] = 'Podesite boju slova naslova kada su izabrane Koventri pločice';
$string['covhidebutton'] = 'Dugme kursa na Koventri pločicama';
$string['covhidebuttondesc'] = 'Podesite ovu opciju kako biste sakrili dugme za kurs kada su izabrana Koventri pločice.';
$string['currentcolor'] = 'Boja naglašavanja tekuće sekcije kursa';
$string['currentcolordesc'] = 'Podesite boju kojom će biti naglašena tekuća sekcija kursa';
$string['customcoursesubtitle'] = 'Prilagođeni podnaslov kursa';
$string['customcoursesubtitledesc'] = 'Naziv prilagođenog polja korisničkog profila za podnaslov kursa.';
$string['customcoursetitle'] = 'Prilagođeni naslov kursa';
$string['customcoursetitledesc'] = 'Naziv prilagođenog polja korisničkog profila za naslov kursa.';
$string['customcss'] = 'Prilagođeni CSS';
$string['customcssdesc'] = 'CSS pravila koja dodate u ovo polje za tekst odraziće se na izgled svih stranica, što olakšava prilagođavanje ove teme.';
$string['customcssjssettingsheading'] = 'Primenite sopstvene modifikacije';
$string['customcsssettings'] = 'Prilagođeni CSS';
$string['customcsssettingsdescription'] = 'Ovde možete pronaći različita podešavanja za dodavanje sopstvenog CSS kôda u temu.';
$string['customjs'] = 'Prilagođeni JavaScript';
$string['customjsdesc'] = 'Dodajte JavaScript na sajt.';
$string['customjsfiles'] = 'Prilagođene JavaScript datoteke';
$string['customjsfilesdesc'] = 'Dodajte JavaScript datoteke na sajt.';
$string['customjsrestricted'] = 'Uslovni JavaScript';
$string['customjsrestricteddesc'] = 'Dodajte JavaScript na sajt uslovno na osnovu prilagođenog polja profila. Ovaj JavaScript će se pojaviti samo ako je ispunjen ovaj uslov.';
$string['customjssettings'] = 'Prilagođeni JS';
$string['customjssettingsdescription'] = 'Ovde možete pronaći različita podešavanja za dodavanje sopstvenog JavaScripta u temu. Napomena: JavaScript oznake se automatski dodaju, nemojte ih sami dodavati.';
$string['custommenu'] = 'Prilagođeni meni';
$string['custommenuitemscoredesc'] = 'Ovde se može konfigurisati prilagođeni meni. Unesite svaku stavku menija u novi red. Redovi koji počinju crticom pojaviće se kao stavke unutar podmenija stavke koja je višeg nivoa. Stavke u meniju mogu se razdvojiti dodavanjem reda sa jednim ili više znakova #.';
$string['custommenutitle'] = 'Naslov prilagođenog menija';
$string['custommenutitledesc'] = 'Podesite naslov prilagođenog menija koji će sadržati sve prilagođene menije na navigacionoj traci. Ako je polje prazno, onda će svaki uneti naslov (menija) najvišeg nivoa kreirati zaseban meni na navigacionoj traci.';
$string['customusermenuitemscoredesc'] = 'Možete da konfigurišete sadržaj korisničkog menija (sa izuzetkom linka za odjavu koji se automatski dodaje). Svaki red je odvojen vertikalnim crtama | i sastoji se od 1) stringa u obliku "langstringname, componentname" (ili kao običan tekst), 2) URL adrese i 3) naziva Font Awesome ikonice ili CSS klasa (opciono). Tamo gde je potrebno može se koristiti razdelnik dodavanjem reda sa jednim ili više znakova #. Kako biste pronašli besplatne FontAwesome klase za ikonicu koju želite da koristite, idite na <a href="https://fontawesome.com/search?o=r&m=free" target="_blank">Font Awesome (besplatna verzija)</a> i potražite ikonicu. Možete koristiti naziv, kao npr \'graduation-cap\' ili kompletan spisak klasa \'fa-solid fa-graduation-cap\'. Na primer:
<pre>
messages,message|/message/index.php|fa-regular fa-comment
privatefiles,moodle|/user/files.php|folder-tree
</pre>
Napomena: standardna osnovna vrednost može da sadrži duplikate, po mogućstvu.';
$string['dangericoncolor'] = 'Boja ikonice za upozorenja';
$string['dangericoncolordesc'] = 'Podesite boju ikonice za upozorenje/opasnost koja se uglavnom koristi u obaveznim poljima.';
$string['dashblocklayoutbuilder'] = 'Regioni sa blokovima na stranici \'Kontrolni panel\'';
$string['dashblocklayoutbuilderdesc'] = 'Ispod možete da napravite svoj raspored regiona sa blokovima na stranici \'Kontrolni panel\'.<br/>Da biste dodali sadržaj u ove regione moraćete da<strong> uključite uređivanje na stranici \'Kontrolni panel\' vašeg Moodle sajta</strong>.
<br/>Nakon toga možete početi da prevlačite i spuštate blokove u regione koje ste kreirali!';
$string['dashblocklayoutlayoutrow'] = 'Red regiona sa blokovima na kontrolnom panelu';
$string['dashblocklayoutlayoutrowdesc'] = 'Dodajte / podesite raspored blokova u redu regiona sa blokovima na stranici "Kontrolni panel".';
$string['dashblocksabovecontent'] = 'Prikaži iznad glavnog sadržaja';
$string['dashblocksbelowcontent'] = 'Prikaži ispod glavnog sadržaja';
$string['dashblocksenabled'] = 'Omogući prilagođeni region sa blokovima na stranici "Kontrolni panel".';
$string['dashblocksenableddesc'] = 'Možete da omogućite / onemogućite prilagođeni region sa blokovima na stranici \'Kontrolni panel\'. Zatim možete da prevučete i spustite blokove u regione koje ste kreirali.';
$string['dashblocksposition'] = 'Pozicija prilagođenog regiona sa blokovima';
$string['dashblockspositiondesc'] = 'Kada su prilagođeni regioni blokova omogućeni za stranicu \'Kontrolne panel\', izaberite poziciju.';
$string['dashboardblockregionsettings'] = 'Alat za kreiranje regiona blokova na kontrolnom panelu';
$string['dashed'] = 'Isprekidana ivica';
$string['defaultzoom'] = 'Podrazumevano zumiranje (veličina ekrana)';
$string['defaultzoomdesc'] = 'Podrazumevana veličina ekrana kada je opcija za uključivanje zumiranja isključena ili kada korisnik nije izabrao željenu opciju. Izaberite između prikaza preko celog ekrana i fiksne širine.';
$string['dimmedtextcolor'] = 'Bleda boja teksta';
$string['dimmedtextcolordesc'] = 'CSS klasa bledog teksta (bledi tekst) se koristi u Moodleu kako bi se označilo kada nešto (neka opcija) nije omogućena / nije vidljiva. Da biste podesili tu boju u grafičkoj temi, koristite HTML heksadecimalni kôd.';
$string['disablecustommenu'] = 'Onemogući Moodle prilagođeni meni';
$string['disablecustommenudesc'] = 'Ovo će onemogućiti Moodle prilagođeni meni u navigacionoj traci (meni će i dalje biti vidljiv u drugim temama koje ste instalirali).';
$string['disabled'] = 'Onemogućeno';
$string['disablemenuscoursepages'] = 'Onemogući menije na stranicama kursa';
$string['disablemenuscoursepagesdesc'] = 'Uključivanje ove opcije će ograničiti prikaz gornjih menija na stranice sajta, početnu stranicu i kontrolni panel (\'Moja početna stranica\') itd. Istovremeno, ovi meniji neće biti prikazani na bilo kojoj stranici kursa.';
$string['discardbuttontext'] = 'Otkaži';
$string['displayeditingbuttontext'] = 'Tekst na dugmetu za uređivanje';
$string['displayeditingbuttontextdesc'] = 'Prikažite ili sakrijte tekst na dugmetu za uređivanje. Napomena: Odnosi se samo na dugme za uređivanje kursa.';
$string['displaygrades'] = 'Prikaži ocene';
$string['displaygradesdesc'] = 'Prikažite ocena u meniju.';
$string['displaylogin'] = 'Prikaži obrazac za prijave na sajt';
$string['displayloginbox'] = 'Polja za prijavu';
$string['displayloginbutton'] = 'Dugme';
$string['displaylogindesc'] = 'Izaberite kako da se na ekranu prikaže prijava na sajt';
$string['displayloginno'] = 'Bez polja za prijavu';
$string['displayparticipants'] = 'Prikaži učesnike';
$string['displayparticipantsdesc'] = 'Prikažite stavku učesnika u meniju.';
$string['dividingline'] = 'Linija razdvajanja u zaglavlju';
$string['dividingline2'] = 'Linija razdvajanja u podnožju';
$string['dividingline2desc'] = 'Boja za liniju razdvajanja koja se nalazi u podnožju stranice.';
$string['dividinglinedesc'] = 'Boja za liniju razdvajanja koja se nalazi u zaglavlju stranice.';
$string['dotted'] = 'Tačkasta ivica';
$string['double'] = 'Dvostruka ivica';
$string['editcognocourseupdate'] = 'Pokažite zupčanik korisnicima koji ne ažuriraju kurs';
$string['editcognocourseupdatedesc'] = 'Pokažite zupčanik korisnicima koji nemaju mogućnost \'moodle/course:update\', tj. ulogu ’Predavač bez uređivačkih prava’.';
$string['editfont'] = 'Boja fonta dugmeta \'Uredi i prilagodi ovu stranicu\'';
$string['editfontdesc'] = 'Podesite boju fonta na dugmetu \'Uredi i prilagodi ovu stranicu\'';
$string['edithorizontalpadding'] = 'Podesi horizontalni razmak između ivice i teksta dugmadi za uređivanje';
$string['editoffbk'] = 'Poazdina dugmeta za isključivanje \'Uredi i prilagodi ovu stranicu\'';
$string['editoffbkdesc'] = 'Podesite boju fonta na dugmetu za isključivanje režima \'Uredi i prilagodi ovu stranicu.';
$string['editonbk'] = 'Boja pozadine dugmeta ”Uredi i prilagodi ovu stranicu”';
$string['editonbkdesc'] = 'Podesite boju pozadine dugmeta \'Uredi i prilagodi ovu stranicu.';
$string['editsettingsbutton'] = 'Uredite podešavanja i prikaz dugmadi';
$string['editsettingsbuttondesc'] = 'Ovde konfigurišite šta treba da se pojavi u navigacionoj traci za uređivanje podešavanja. Imajte na umu da se ove opcije ne primenjuju na onim stranicama za koje ne postoje povezana podešavanja, kao što je to, npr, stranica \'Kontrolni panel\'.';
$string['editsettingsbuttonshowbutton'] = 'Prikaži samo dugme za uređivanje. Npr. dugme "Uključi uređivanje" na stranici kursa.';
$string['editsettingsbuttonshowcog'] = 'Prikaži samo ikonicu za uređivanje podešavanja (ikonica zupčanika).';
$string['editsettingsbuttonshowcogandbutton'] = 'Prikaži dugme za uređivanje i zupčanik. Imajte na umu da ovo zauzima više prostora u navigacionoj traci.';
$string['emoticonsize'] = 'Veličina emotikona';
$string['emoticonsizedesc'] = 'Podesite visinu i širinu Moodle emotikona.';
$string['enableaccesstool'] = 'Alat za pristupačnost';
$string['enableaccesstooldesc'] = 'Prikažite link ka stranici sa podešavanjima korisnika "Alatka za pristupačnost" - napomena: ovo zahteva da je instaliran \'<a href="{$a}" target="_blank">додатак "Alatka za pristupačnost"</a>\'.';
$string['enablealert'] = 'Omogući okvir sa važnim obaveštenjem {$a}';
$string['enablealertdesc'] = 'Omogući okvir sa važnim obaveštenjem {$a}';
$string['enablealerts'] = 'Omogući / onemogući važna obaveštenja';
$string['enablealertsdesc'] = 'Omogućite / onemogućite važna obaveštenja na vašem sajtu (ne na stranicama kurseva). Pogledajte podešavanje \'alerthiddencourse\'.';
$string['enablealertstriptags'] = 'Ukloni automatski html oznake iz obaveštenja';
$string['enablealertstriptagsdesc'] = 'Ако омогућите ову опцију важна обавештења ће аутоматски бити очишћена и искључена како би вам пружила могућност да употребите HTML / линкове у порукама, али ћете морати ручно да их очистите у HTML приказу.';
$string['enableanalytics'] = 'Omogući Google Analytics';
$string['enableanalyticsdesc'] = 'Omogućite  podešavanja za Google Analytics na svom Moodle sajtu';
$string['enableavailablecourses'] = 'Prikaži "Dostupni kursevi"';
$string['enableavailablecoursesdesc'] = 'Prikažite natpis ”Dostupni kursevi” na naslovnoj stranici.';
$string['enablebadges'] = 'Bedževi';
$string['enablebadgesdesc'] = 'Prikažite link ka bedževima korisnika.';
$string['enableblog'] = 'Omogući moje blogove';
$string['enableblogdesc'] = 'Prikažite link ka stranicama blogova korisnika.';
$string['enablecalendar'] = 'Korisnički kalendar';
$string['enablecalendardesc'] = 'Prikažite link ka kalendaru korisnika.';
$string['enablecompetencieslink'] = 'Link ka kompetencijama';
$string['enablecompetencieslinkdesc'] = 'Prikažite link kao kompetencijama u meniju \'Ovaj kurs\'. Napomena: podešavanje \'\'core_competency | enabled\'\' treba da bude uključeno.';
$string['enablecoursesectionsdesc'] = 'Prikažite podmeni, u meniju \'Ovaj kurs\', koji sadrži linkove ka svakoj prikazanoj sekciji.';
$string['enablecoursetitle'] = 'Naziv kursa';
$string['enablecoursetitledesc'] = 'Podesite način na koji će naziv kursa biti prikazan.';
$string['enabledtabbedprofileeditprofilelink'] = 'Omogući karticu za uređivanje profila';
$string['enabledtabbedprofileeditprofilelinkdesc'] = 'Omogućite karticu za uređivanje profila na stranici profila sa karticama. Napomena: kada je ovo omogućeno, prikazaće se samo ukoliko korisnik koji pregleda profil ima dozvolu da ga uređuje.';
$string['enabledtabbedprofileuserpreferenceslink'] = 'Omogući karticu za podešavanja parametara';
$string['enabledtabbedprofileuserpreferenceslinkdesc'] = 'Omogućite karticu za korisnička podešavanja parametara na stranici profila sa karticama.';
$string['enableeditprofile'] = 'Uredi profil';
$string['enableeditprofiledesc'] = 'Prikažite link za uređivanje profila korisnika.';
$string['enableeventsdesc'] = 'Prikažite link ka kalendaru.';
$string['enablefeed'] = 'Moje povratne informacije';
$string['enablefeeddesc'] = 'Prikazuje link ka stranici korisnika ”Moje povratne informacije” - napomena: ovo zahteva <a href="https://moodle.org/plugins/report_myfeedback" target="blank">dodatak ”Moje povratne informacije”</a>';
$string['enablegrades'] = 'Ocene';
$string['enablegradesdesc'] = 'Prikažite link ka ocenama korisnika';
$string['enableheading'] = 'Zaglavlje sa naslovom kursa';
$string['enableheadingdesc'] = 'Podesite režim za prikaz naslova kursa u zaglavlju kada je omogućen podrazumevan naslov Moodle sajta.';
$string['enablehelp'] = 'Link za pomoć \'{$a->number}\'';
$string['enablehelpdesc'] = 'Dodajte link za pomoć \'{$a->number}\' u navigacionu traku.';
$string['enablehomedesc'] = 'Prikažite link ka naslovnoj stranici.';
$string['enablehomeredirect'] = 'Omogući redirekciju (redirect=0) ka naslovnoj stranici';
$string['enablehomeredirectdesc'] = 'Omogućite redirekciju (redirect=0) ka naslovnoj stranici. Ovo se koristi na sajtovima na kojima je kao podrazumevana početna stranica postavljena \'Moja početna stranica / Kontrolni panel\'. Ovo će sprečiti da korisnik, kada klikne na link \'Početna stranica\', bude preusmeren na \'Moja početna stranica / Kontrolni panel\'.';
$string['enablemenus'] = 'Omogući menije';
$string['enablemenusdesc'] = 'Preporučuje se da ovo ostavite isključeno, ako se meniji ne koriste zbog performansi sistema.';
$string['enablemy'] = 'Kontrolni panel';
$string['enablemydesc'] = 'Prikažite link ka stranici \'Kontrolni panel\'';
$string['enablemysitesdesc'] = 'Prikažite padajući meni sa kursevima korisnika';
$string['enablemysitesrestriction'] = 'Ограничите падајући мени са курсевима корисника на прилагођено поље профила';
$string['enablemysitesrestrictiondesc'] = 'Ograničite padajući meni sa kursevima korisnika prema prilagođenom polju profila. Npr. usertype=staff.';
$string['enablenavbarwhenloggedout'] = 'Omogućite navigacionu traku kada ste odjavljeni';
$string['enablenavbarwhenloggedoutdesc'] = 'Prikazuje navigacionu traku čak i kada ste odjavljeni. Ograničeno samo na pomoć i meni alata.';
$string['enablenote'] = 'Moja obaveštenja';
$string['enablenotedesc'] = 'Prikažite link ka stranici sa obaveštenjima za korisnika';
$string['enableposts'] = 'Moji postovi';
$string['enablepostsdesc'] = 'Prikažite link ka stranici sa mojim postovima';
$string['enablepref'] = 'Moja podešavanja';
$string['enableprefdesc'] = 'Prikažite link ka stranici sa podešavanjima korisnika';
$string['enableprivatefiles'] = 'Privatne datoteke';
$string['enableprivatefilesdesc'] = 'Prikažite link ka ka privatnim datotekama korisnika.';
$string['enableprofile'] = 'Korisnički profil';
$string['enableprofiledesc'] = 'Prikažite link ka profilu korisnika.';
$string['enablesavecanceloverlay'] = 'Omogućite prekrivajući sloj sa dugmadima \'Sačuvaj\' / \'Otkaži\'na stranicama sa podešavanjima';
$string['enablesavecanceloverlaydesc'] = 'Prikažite prekrivajući sloj sa dugmadima \'Sačuvaj\' / \'Otkaži\' na vrhu stranice sa podešavanjima kako biste lakše sačuvali podešavanja.';
$string['enablesavecanceloverlayresetconfirm'] = 'Ovo resetuje sve promene napravljene od učitavanja ove stranice.  Jeste li sigurni?';
$string['enableshowhideblocks'] = 'Omogući prekidač ”Prikaži/Sakrij blokove”';
$string['enableshowhideblocksdesc'] = 'Omogućava korisnicima da prikažu/sakriju sve blokove.';
$string['enableshowhideblockstext'] = 'Prikaži tekst za \'Prikaži sakrij blokove\'';
$string['enableshowhideblockstextdesc'] = 'Prikazuje tekst pored dugmeta.';
$string['enabletabbedprofile'] = 'Omogući kartični prikaz stranice profila';
$string['enabletabbedprofiledesc'] = 'Omogućite funkciju prikaza stranice profila sa karticama.';
$string['enablethiscoursedesc'] = 'Prikažite padajući meni sa aktivnostima iz tekućeg kursa.';
$string['enableticker'] = 'Omogući pokretnu traku sa vestima na početnoj stranici';
$string['enabletickerc'] = 'Omogući pokretnu traku sa vestima na internim stranicama';
$string['enabletickercdesc'] = 'Označite ovo kako biste omogućili pokretnu traku sa vestima na internim stranicama.';
$string['enabletickerdesc'] = 'Označite ovo kako biste omogućili pokretnu traku sa vestima na početnoj stranici.';
$string['enabletickermy'] = 'Da li omogućiti pokretnu traku sa vestima?';
$string['enabletickermydesc'] = 'Označite ovo kako biste omogućili pokretnu traku sa vestima na stranicama \'Moja početna stranica\' / \'Kontrolni panel\'.';
$string['enabletoolsmenus'] = 'Omogući menije \'Alati\'';
$string['enabletoolsmenusdesc'] = 'Preporučuje se da ovo ostavite isključeno, ako se meniji ne koriste, zbog performansi sistema.';
$string['enablezoom'] = 'Omogući zumiranje';
$string['enablezoomdesc'] = 'Dozvoljava korisnicima da menjaju prikaz stranice (između prikaza preko celog ekrana i prikaza fiksne širine).';
$string['enablezoomshowtext'] = 'Prikaži tekst za \'Omogući zumiranje\'';
$string['enablezoomshowtextdesc'] = 'Prikazuje tekst pored dugmeta.';
$string['events'] = 'Događaji';
$string['expandable'] = 'Proširivo';
$string['fa6name'] = 'FontAwesome 6 Besplatna verzija za grafičke teme';
$string['faiv'] = 'FontAwesome Free v4 shims';
$string['faivdesc'] = 'Kada koristite FontAwesome 6 Besplatnu verziju (za grafičke teme) za ikonice dodajte podršku za nazive klasa ikonica verzije 4.';
$string['fav'] = 'FontAwesome 6 Besplatna verzija';
$string['favdesc'] = 'Koristite FontAwesome 6 Besplatnu verziju za ikonice. Napomena: Molimo pogledajte licencu u direktorijumu fontova teme.';
$string['favicon'] = 'Favikonica';
$string['favicondesc'] = 'Postavite favikonicu koja će se koristiti na vašem sajtu koristeći osnovno podešavanje \'core_admin | favicon \' na stranici \'Administracija sajta\' -> \'Izgled\' -> \'Logotipi\'.';
$string['favoff'] = 'Osnovna FontAwesome 6 Besplatna verzija';
$string['flexibleblocksoverflow'] = 'Fleksibilan broj blokova';
$string['fontawesomesettingdesc'] = 'Format svakog reda je \'text|url|title|langs|fontawesome classes|capability to check\'. Unesite samo ono što vam je potrebno. Ako vam nešto od navednog nije potreno, ali vam je potrebna nešto drugo, ostavite to što je nepotrebno prazno, ali i dalje koristite znak za razdvajanje \'|\'. Na primer: \'text|url|||fontawesome classes\'. Da biste pronašli FontAwesome (besplatne) klase za ikonicu koju želite da koristite, idite na <a href="https://fontawesome.com/search?o=r&m=free" target="_blank">Font Awesome (besplatna verzija)</a> i potražite ikonicu. Možete koristiti naziv, kao što je \'graduation-cap\' ili kompletni spisak \'fa-solid fa-graduation-cap\'. Na primer:<pre>
Kursevi
-Svi kursevi|/course/
- Pretraga kurseva |/course/search.php
-###
-FAQ|https://example.org/faq
-Ispitni sat |https://mysite.localhost|Exam Clock|en|clock
-Ispitni sat |https://mysite.localhost|Clock arholiad|cy|clock
-Predavači |https://mysite.localhost|Educators only|en|graduation-cap|moodle/course:manageactivities
</pre>';
$string['fontblockheadercolor'] = 'Boja fonta zaglavlja blokova';
$string['fontblockheadercolordesc'] = 'Podesite boju fonta zaglavlja u Moodle blokovima, koristeći html heksadecimalni kôd. Imajte na umu da ovo utiče i na boju ikonica.';
$string['fontblockheadersize'] = 'Veličina fonta zaglavlja blokova';
$string['fontblockheadersizedesc'] = 'Podesite veličinu fonta koji se koristi u zaglavlju Moodle blokova. Izaberite vrednost sa spiska.';
$string['fontblockheaderweight'] = 'Debljina fonta zaglavlja blokova';
$string['fontblockheaderweightdesc'] = 'Podesite debljinu fonta koji se koristi u zaglavlju Moodle blokova. Izaberite vrednost od 100 do 900 u zavisnosti od izabranog fonta.';
$string['fontcolor'] = 'Boja glavnog fonta';
$string['fontcolordesc'] = 'Podesite boju fonta u temi, koristeći html heksadecimalni kôd.';
$string['fontdefault'] = 'Podrazumevani fontovi';
$string['fontdesc'] = 'Možete da izaberete fontove koje želite da koriste u okviru teme.';
$string['fontheadercolor'] = 'Boja fonta zaglavlja';
$string['fontheadercolordesc'] = 'Podesite boju fonta zaglavlja u temi, koristeći html heksadecimalni kôd.';
$string['fontheadername'] = 'Font zaglavlja';
$string['fontheadernamedesc'] = 'Izaberite font koji će se koristiti za zaglavlja u tekstu i u zaglavljima blokova.';
$string['fontheaderweight'] = 'Debljina fonta zaglavlja';
$string['fontheaderweightdesc'] = 'Debljina fonta zaglavlja koji se koriste na sajtu. Izaberite vrednost do 100 do 900, zavisno od izabranog fonta.';
$string['fontname'] = 'Glavni font';
$string['fontnamedesc'] = 'Izaberite glavni font za sajt.';
$string['fontsettings'] = 'Fontovi';
$string['fontsettingsheading'] = 'Izmenite fontove koji se koriste u okviru teme.';
$string['fontsize'] = 'Veličina glavnog fonta';
$string['fontsizedesc'] = 'Izaberite podrazumevanu veličinu fonta (u procentima) koja se koristi na čitavom sajtu.';
$string['fontsubset'] = 'Podskup Google fontova';
$string['fontsubsetdesc'] = 'Izaberite koji će se drugi podskup karaktera, pored latiničnog, primenjivati na sve fontove. Latinični podskup je standardno već uključen.';
$string['fonttitlecolor'] = 'Boja fonta naslova sajta /kursa';
$string['fonttitlecolorcourse'] = 'Boja fonta naslova kursa';
$string['fonttitlecolorcoursedesc'] = 'Podesite boju fonta naslova kursa u temi, koristeći html heksadecimalni kôd.';
$string['fonttitlecolordesc'] = 'Podesite boju fonta naslova sajta i naslova kursa u temi, koristeći html heksadecimalni kôd.';
$string['fonttitlename'] = 'Font naslova sajta / kursa';
$string['fonttitlenamedesc'] = 'Izaberite font koji će se koristiti za naslov sajta i naslove kurseva.';
$string['fonttitlesize'] = 'Veličina fonta naslova sajta / kursa';
$string['fonttitlesizedesc'] = 'Veličina fonta naslova sajta i naslova kursa koji se koristi na sajtu. Izaberite vrednost sa spiska.';
$string['fonttitleweight'] = 'Debljina fonta naslova sajta / kursa';
$string['fonttitleweightdesc'] = 'Podesite debljinu fonta koji se koristi za naslov sajta i naslove kurseva. Izaberite vrednost do 100 do 900, zavisno od izabranog fonta.';
$string['fontweight'] = 'Debljina glavnog fonta';
$string['fontweightdesc'] = 'Podesite debljinu fonta koji se koristi na sajtu. Izaberite vrednost do 100 do 900, zavisno od izabranog fonta.';
$string['footerbkcolor'] = 'Boja pozadine podnožja';
$string['footerbkcolordesc'] = 'Podesite boju pozadine u podnožju stranice.';
$string['footerblocksplacement'] = 'Pojavljivanje blokova podnožja';
$string['footerblocksplacement1'] = 'Na čitavom sajtu';
$string['footerblocksplacement2'] = 'Samo početna stranica';
$string['footerblocksplacement3'] = 'Nigde';
$string['footerblocksplacementdesc'] = 'Ovo podešavanje kontroliše gde će se prikazivati gornji blokovi podnožja. Podrazumevana vrednost je \'Na čitavom sajtu\'.';
$string['footerbuilderdesc'] = 'Upotrebite alat u nastavku kako biste podesili svoje blokove u podnožju stranice. Jednom definisani blokovi će biti raspoređeni kako je ovde podešeno, kada je uređivanje isključeno, a prozor širi od 575 piksela. Uvek će u jednom redu biti četiri bloka.';
$string['footerbuilderheading'] = 'Alat za kreiranje rasporeda blokova u podnožju';
$string['footercontent'] = 'Sekcija podnožja sa sadržajem';
$string['footercontentdesc'] = 'Dodajte sadržaj u sekciju podnožja stranice.';
$string['footerdesc'] = 'Dodajte naslov za sekciju podnožja.';
$string['footerheader'] = 'Naslov sekcije podnožja';
$string['footerlayoutrow'] = 'Alat za kreiranje izgleda podnožja stranice';
$string['footerlayoutrowdesc'] = 'Dizajnirajte raspored blokova za region podnožja stranice sa blokovima.';
$string['footerlinkcolor'] = 'Boja linka u blokovima podnožja';
$string['footerlinkcolordesc'] = 'Boja linka u blokovima podnožja stranice.';
$string['footersettings'] = 'Podnožje';
$string['footersettingsheading'] = 'Podesite sadržaj koji treba da se pojavi u podnožju stranice.';
$string['footertextcolor'] = 'Boja teksta podnožja';
$string['footertextcolor2'] = 'Boja teksta donjeg podnožja';
$string['footertextcolor2desc'] = 'Boja teksta u donjem delu podnožja stranice.';
$string['footertextcolordesc'] = 'Podesite boju teksta u podnožju stranice, koristeći html heksadecimalni kôd.';
$string['footnote'] = 'Fusnota';
$string['footnotedesc'] = 'Dodaje tekst u podnožje.';
$string['forumbodybackgroundcolor'] = 'Pozadina tela posta na forumu';
$string['forumbodybackgroundcolordesc'] = 'Boja pozadine tela posta na forumu.';
$string['forumheaderbackgroundcolor'] = 'Pozadina zaglavlja posta na forumu';
$string['forumheaderbackgroundcolordesc'] = 'Boja pozadine zaglavlja posta na forumu';
$string['frnt-footer'] = 'Blokovi u ovom regionu biće vidljivi samo administratorima.';
$string['frontpageblocksenabled'] = 'Omogući prilagođeni region sa blokovima na naslovnoj stranici';
$string['frontpageblocksenableddesc'] = 'Možete da omogućite / onemogućite prilagođene regione sa blokovima na naslovnoj stranici. Nakon toga, možete da prevlačite i spuštate blokove u regione koje ste kreirali.';
$string['frontpageblocksettings'] = 'Promotivni blokovi';
$string['frontpagecoursesettings'] = 'Spisak kurseva na naslovnoj stranici';
$string['frontpagedesc'] = 'Konfigurišite način na koji se prikazuju blokovi sa kursevima na naslovnoj stranici.';
$string['frontpagemarketenabled'] = 'Omogući promotivne blokove';
$string['frontpagemarketenableddesc'] = 'Podesite promotivne blokove na naslovnoj stranici.';
$string['frontpagemarketoption'] = 'Izaberite stil za promotivne blokove';
$string['frontpagemarketoptiondesc'] = 'Možete da primenite različite stilove na promotivne blokove. Napomena: BCU stil je dizajniran tako da radi sa slikama na vrhu bloka.';
$string['frontpagenumbertiles'] = 'Broj pločica kurseva po jednom redu';
$string['frontpagenumbertilesdesc'] = 'Broj pločica kurseva koji će biti prikazan u jednom redu na spisku kurseva na naslovnoj stranici.';
$string['frontpagerenderer'] = 'Blokovi kurseva na naslovnoj stranici';
$string['frontpagerendererdefaultimage'] = 'Podrazumevana slika kursa';
$string['frontpagerendererdefaultimagedesc'] = 'Podrazumevana slika kursa koja će se koristiti kada ne postoji slika kursa (primenjivo samo za opciju \'Pločice sa prekrivačem\').';
$string['frontpagerendererdesc'] = 'Kontroliše način na koji se prikazuju blokovi kurseva na naslovnoj stranici.';
$string['frontpagerendereroption1'] = 'Pločice';
$string['frontpagerendereroption2'] = 'Pločice sa prekrivačem';
$string['frontpagerendereroption3'] = 'Moodle standardno';
$string['frontpagerendereroption4'] = 'Koventri pločice';
$string['frontpagesettingsheading'] = 'Prikaz naslovne stranice';
$string['frontpageslidersettings'] = 'Slajd -šou na naslovnoj stranici';
$string['frontpagetiles1'] = 'Jedna pločica';
$string['frontpagetiles2'] = 'Dve pločice';
$string['frontpagetiles3'] = 'Tri pločice';
$string['frontpagetiles4'] = 'Četiri pločice';
$string['frontpagetiles6'] = 'Šest pločica';
$string['frontpageuserblocksenabled'] = 'Omogući bočni region blokova na naslovnoj stranici za korisnike';
$string['frontpageuserblocksenableddesc'] = 'Možete da omogućite/onemogućite bočni region blokova na naslovnoj stranici za korisnike. Napomena: pod \'Korisnici\' ovde se misli na goste i korisnike čiji je identitet potvrđen. Administratori će uvek videti region.';
$string['fullscreen'] = 'Prikaz preko celog ekrana';
$string['fullscreenwidth'] = 'Širina prikaza preko celog ekrana';
$string['fullscreenwidthdesc'] = 'Podesite maksimalnu širinu teme kada je u režimu prikaza preko celog ekrana / zumiranja.';
$string['future'] = 'Budući';
$string['gdprbutton'] = 'Dugme za rezime o zadržavanju podataka';
$string['gdprbuttondesc'] = 'Prikažite dugme za rezime o zadržavanja podataka u podnožju.';
$string['googleanalyticssettings'] = 'Google Analytics';
$string['googleanalyticssettingsdesc'] = 'Možete da podesite više kôdova za Google Analytics i povežete ih sa poljima korisničkih profila.';
$string['googleanalyticssettingsheading'] = 'Google Analytics podešavanja za vaš sajt';
$string['googlefonts'] = 'Google fontovi';
$string['googlefontsdesc'] = 'Uključite <a href="{$a}" target="_blank">Google Fontove</a> tako što ćete izabrati njihove nazive, osim \'Podrazumevanog fonta\'.  Kada su Google fontovi\'isključeni\', imate priliku da ih sami obezbedite putem modifikacija CSS-a, odnosno teme ili tako što ćete ih instalirate na uređajima korisnika.  Kada su Google fontovi\'uključeni\' izaberite potreban podskup fontova (latinica je uvek uključena) i unesite pravu debljinu fonta ili se font neće prikazati.  <b>NAPOMENA : Tema Adaptable je licencirana pod GPLv3 licencom i može sadržati greške. Proverite sami da se Google fontovi ne koriste kada su isključeni!</b>';
$string['headerbgimage'] = 'Pozadinska slika';
$string['headerbgimagedesc'] = 'Podesite pozadinsku sliku u zaglavlju. Minimalna veličina je 1600 x 180 piksela (preporučuje se 1900 x 180 piksela). Slika pokriva čitavo zaglavlje. Možete da dodate boju u \'Boja pozadine gornjeg zaglavlja\' ili da koristite opciju <i>transparent</i> kako biste prikazali pozadinsku sliku. U tom slučaju, kako bi tekst ispravno bio prikazan preko slike, modifikujte njegovu boju.';
$string['headerbgimagetextcolour'] = 'Boja teksta na pozadinskoj slici';
$string['headerbgimagetextcolourdesc'] = 'Ako imate sliku u pozadini, koristite ovo podešavanje kako biste podesili boju teksta koji se nalazi na njoj.';
$string['headerbkcolor'] = 'Boja pozadine gornjeg zaglavlja';
$string['headerbkcolor2'] = 'Boja pozadine donjeg zaglavlja';
$string['headerbkcolor2desc'] = 'Podesite boju pozadine donjeg zaglavlja. Imajte na umu da ovo takođe postavlja boju za pozadinu u stilu Zaglavlja 2.';
$string['headerbkcolordesc'] = 'Podesite boju pozadine gornjeg zaglavlja';
$string['headerdesc'] = 'Postavite svoj logo, podesite obrazac za prijavu u zaglavlju, kao i naslove u zaglavlju.<br />
Veličinu fonta i stilove za naslove možete da podesite na stranici za podešavanje \'<a href="./../admin/settings.php?section=theme_adaptable_font">fontova</a>\'.';
$string['headernavbarcustommenucoreempty'] = 'Podešavanje \'<small>{$a}</small>\' je prazno.';
$string['headernavbarcustommenucoreheading'] = 'Osnovna podešavanja';
$string['headernavbarcustommenucoreheadingdesc'] = 'Duplirano radi pogodnosti.';
$string['headernavbarcustommenucorenotempty'] = 'Podešavanje \'<small>{$a}</small>\' je:<br><br>';
$string['headernavbarcustommenuheading'] = 'Prilagođeni meni';
$string['headernavbarcustommenuheadingdesc'] = 'Prilagođeni meni podešen do strane osnovnog custommenuitems\' podešavanja, dupliran u nastavku.';
$string['headernavbarhelpheading'] = 'Linkovi za pomoć i opcije';
$string['headernavbarhelpheadingdesc'] = 'Opcije za linkove menija pomoći.';
$string['headernavbarmycoursesheading'] = 'Meni \'Moji kursevi\'';
$string['headernavbarmycoursesheadingdesc'] = 'Sve opcije za opciju menija \'Moji kursevi\' (\'Moji sajtovi\') koja prikazuje spisak kurseva trenutnog korisnika.';
$string['headernavbarthiscourseheading'] = 'Meni ovog kursa';
$string['headernavbarthiscourseheadingdesc'] = 'U ovom meniju polaznik može direktno da pristupi svim aktivnostima na kursu i spisku učesnika i njihovim ocenama.';
$string['headersearchandsocial'] = 'Pretraga i ikonice društvenih mreža u zaglavlju';
$string['headersearchandsocialdesc'] = 'Podesite poziciju okvira za pretragu i ikonica društvenih mreža u zaglavlju za stil zaglavlja jedan.<br />
Ikonice društvenih mreža možete podesiti na stranici za podešavanje <a href="./../admin/settings.php?section=themesettingadaptable#theme_adaptable_social">Zaglavlje - društvene mreže</a>.';
$string['headersearchandsocialnone'] = 'Ništa';
$string['headersearchandsocialsearchheader'] = 'Okvir za pretragu u zaglavlju';
$string['headersearchandsocialsearchmobilenav'] = 'Okvir za pretragu u zaglavlju i navigaciona traka za mobilne uređaje';
$string['headersearchandsocialsearchnavbar'] = 'Okvir za pretragu u navigacionoj traci';
$string['headersearchandsocialsearchnavbarsocialheader'] = 'Okvir za pretragu u navigacionoj traci, ikonice društvenih mreža u zaglavlju';
$string['headersearchandsocialsocialheader'] = 'Ikonice društvenih mreža u zaglavlju';
$string['headersettings'] = 'Zaglavlje';
$string['headersettingsheading'] = 'Prilagodite zaglavlje ove teme.';
$string['headerstyle'] = 'Stil zaglavlja';
$string['headerstyle1'] = 'Zaglavlje jedan (originalno zaglavlje u tri reda)';
$string['headerstyle2'] = 'Zaglavlje dva (zaglavlje u dva reda)';
$string['headerstyledesc'] = 'Izaberite stil zaglavlja. Zaglavlje jedan se odnosi na originalno Adaptable zaglavlje u tri reda. Zaglavlje dva je minimalno zaglavlje u dva reda sa poljem za pretragu.';
$string['headerstyleheading'] = 'Podešavanja stila zaglavlja';
$string['headerstyleheadingdesc'] = 'Adaptable podržava dva stila zaglavlja, originalno zaglavlje, u tri reda i novije, pojednostavljeno zaglavlje u dva reda.<br/>Imajte na umu da ako pređete na novije zaglavlje u dva reda <strong>NEĆETE</strong> moći da:<br /><ol><li>prikažite u zaglavlju ikonice društvenih mreža.</li><li>prikažite logo sajta na mobilnim uređajima.</li></ol>';
$string['headertextcolor'] = 'Boja teksta i linka gornjeg zaglavlja';
$string['headertextcolor2'] = 'Boja teksta i linka donjeg zaglavlja';
$string['headertextcolor2desc'] = 'Podesite boju teksta i linka donjeg zaglavlja';
$string['headertextcolordesc'] = 'Podesite boju teksta i linka gornjeg zaglavlja';
$string['help'] = 'Pomoć';
$string['helplinkscount'] = 'Broj linkova za pomoć';
$string['helplinkscountdesc'] = 'Podesite broj linkova za pomoć koje želite da dodate u glavnu navigacionu traku.';
$string['helplinktitle'] = 'Naslov linka za pomoć \'{$a->number}\'';
$string['helplinktitledesc'] = 'Naslov link za pomoć \'{$a->number}\' u navigacionoj traci.  Ako je polje prazno koristiće se podrazumevani naslov \'Pomoć {$a->number}\'.';
$string['helpprofilefield'] = 'Prilagođeno polje profila (opciono) linka za pomoć \'{$a->number}\'';
$string['helpprofilefielddesc'] = 'Dodajte pravilo za pristup linku za pomoć \'{$a->number}\' koristeći prilagođeno polje profila npr: usertype=student';
$string['helptarget'] = 'Prozor u kojem se prikazuje pomoć';
$string['helptargetdesc'] = 'Da li želite da se link za pomoć otvori u novom prozoru?';
$string['helptitle'] = 'Pomoć {$a->number}';
$string['hiddencourses'] = 'Sakriveni kursevi';
$string['hiddenfromview'] = 'Sakriveno od prikaza';
$string['hide'] = 'Sakrij';
$string['hidefootersocial'] = 'Prikaži ikonice društvenih mreža';
$string['hidefootersocialdesc'] = 'Prikažite ikonice društvenih mreža u podnožju ispod blokova.';
$string['hideinforum'] = 'Sakrij \'Pomoć\' i meni \'Alati\' u forumima';
$string['hideinforumdesc'] = 'Kada se koristi prikaz fiksne širine i sve opcije menija, polje za pretragu foruma može skliznuti u red ispod. Uključivanje ove opcije će sakriti \'Pomoć\' i meni \'Alati\' u forumima, što će omogućiti da stranica foruma budu ispravno prikazana.';
$string['home'] = 'Početna stranica';
$string['homebk'] = 'Pozadinska slika naslovne stranice';
$string['homebkdesc'] = 'Postavite sliku koja će biti pozadinska slika na početnoj stranici.';
$string['hvpcustomcss'] = 'H5P prilagođeni CSS';
$string['hvpcustomcssdesc'] = 'Prilagođeni CSS za H5P modul.';
$string['infobox'] = 'Info-blok naslovne stranice';
$string['infobox2'] = 'Sekundarni info-blok naslovne stranice';
$string['infobox2desc'] = 'Sekundarni info-blok naslovne stranice. Molimo, pogledajte odeljak \'Readme\' na kartici za podešavanja \'Informacije\' za dodatne informacije.<br><strong>Napomena: </strong><i>Ovaj element se koristi samo za kompatibilnost sa grafičkom temom BCU i biće uklonjen u narednim verzijama.</i>';
$string['infoboxdesc'] = 'Info-blok naslovne stranice HTML. Molimo, pogledajte odeljak \'Readme\' na kartici za podešavanja \'Informacije\' za dodatne informacije.<br><strong>Napomena: </strong><i>Ovaj element se koristi samo za kompatibilnost sa grafičkom temom BCU i biće uklonjen u narednim verzijama.</i>';
$string['infoboxfullscreen'] = 'Info-blok preko celog ekrana';
$string['infoboxfullscreendesc'] = 'Ako uključite ovu opciju sadržaj info-bloka biće prikazan čitavom širinom ekrana.';
$string['infoiconcolor'] = 'Boja ikonice za pomoć';
$string['infoiconcolordesc'] = 'Podesite boju ikonice za informacije/pomoć koju koriste opisi alata.';
$string['informationblocksbuilderdesc'] = 'Upotrebite alat u nastavku kako biste podesili svoje informacione blokove. Jednom definisani blokovi će biti raspoređeni kako je ovde podešeno, kada je uređivanje isključeno.';
$string['informationblocksbuilderheading'] = 'Alat za kreiranje rasporeda informacionih blokova';
$string['informationblocksenabled'] = 'Omogući informativne blokove';
$string['informationblocksenableddesc'] = 'Podesite informacione blokove na naslovnoj strani.';
$string['informationblocksettings'] = 'Informacioni blokovi';
$string['informationblockslayoutrow'] = 'Red sa informacionim blokovima';
$string['informationblockslayoutrowdesc'] = 'Dodajte /podesite izgled ovog red sa informacionim blokovima na naslovnoj stranici.';
$string['informationblocksvisible'] = 'Prikažite informacione blokove kada';
$string['informationblocksvisibledesc'] = 'Prikažite informacione blokove kada su korisnici\'Odjavljeni\', \'Prijavljeni\' ili \'Prijavljeni ili odjavljeni\'.';
$string['informationblocksvisibleloggedin'] = 'Prijavljeni';
$string['informationblocksvisibleloggedinout'] = 'Prijavljeni ili odjavljeni';
$string['informationblocksvisibleloggedout'] = 'Odjavljeni';
$string['informationsettingsdesc'] = 'Postoji alat za kreiranje rasporeda blokova koji vam omogućava da odlučite koliko blokova vam je potrebno i tako definišete izgled stranice. <br >Za dodatne informacije molimo pogledajte odeljak \'Readme\' (Pročitaj me) na kartici podešavanja \'Informacije\'.';
$string['informationsettingsheading'] = 'Prilagodite region sa informacionim blokovima koji se pojavljuje na naslovnoj stranici.';
$string['inprogress'] = 'U toku';
$string['inputbuttonfocuscolour'] = 'Boja dugmeta za ulazne podatke prilikom fokusiranja';
$string['inputbuttonfocuscolourdesc'] = 'Boja koju dugme za ulazne podatke koristi kada se nađe u fokusu';
$string['inputbuttonfocuscolouropacity'] = 'Neprozirnost boje dugmeta za ulazne podatke prilikom fokusiranja';
$string['inputbuttonfocuscolouropacitydesc'] = 'Neprozirnost koje dugme za ulazne podatke koristi kada se nađe u fokusu';
$string['introboxbackgroundcolor'] = 'Boja pozadine uvodnog bloka';
$string['introboxbackgroundcolordesc'] = 'Boja pozadine za uvodni blok (ističe opise aktivnosti) koji se koristi u forumima i drugim aktivnostima';
$string['invalidcategorygeneratedscss'] = 'Neispravna kategorija prilagođeno generisanog SCSS: \'{$a->scss}\'.';
$string['invalidcategoryscss'] = 'Neispravna kategorija prilagođenog SCSS za kategoriju \'{$a->topcatname}\' sa ID oznakom \'{$a->topcatid}\': \'{$a->scss}\'.';
$string['jssection'] = 'Javascript sekcija';
$string['jssectiondesc'] = 'Dodajte javascript kôd na sajt.';
$string['jssectionrestricted'] = 'Sekcija uslovnog javascripta';
$string['jssectionrestricteddashboardonly'] = 'Uključi javascript samo na stranici \'Kontrolni panel\'';
$string['jssectionrestricteddashboardonlydesc'] = 'Prikažite javascript samo na stranicu \'Kontrolni panel\'. U suprotnom, biće prikazano na celom sajtu.';
$string['jssectionrestricteddesc'] = 'ZASTARELO , umesto toga koristite \'customjsrestricted\' .';
$string['jssectionrestrictedprofilefield'] = 'Vrednost prilagođenog polja profila za prikaz Javascript sekcije';
$string['jssectionrestrictedprofilefielddesc'] = 'Prikaži javascript iznad SAMO kada korisnik odgovara ovoj vrednosti prilagođenog polja profila, npr: faculty = fbl.';
$string['jumpto'] = 'Idi na..';
$string['landscape'] = 'Pejzažna orijentacija';
$string['layoutaddcontent'] = 'Zadovoljni ste sa svojim rasporedom blokova? Sada dodajte sadržaj u vaše blokove:';
$string['layoutaddcontentdesc1'] = 'Konfigurisali ste';
$string['layoutaddcontentdesc2'] = 'promotivne blokove. Ako ste zadovoljni sa ovim rasporedom dodajte u nastavku stranice sadržaj u blokove.<br >Ako niste zadovoljni upotrebite gornji alat za kreiranje rasporeda blokova kako biste napravili promene.';
$string['layoutcheck'] = 'Proverite svoj raspored blokova';
$string['layoutcheckdesc'] = 'Upotrebite alat u nastavku kako biste proverili broj blokova koje koristite i videli kako izgleda vaš novi raspored blokova.';
$string['layoutcount1'] = 'Možete da podesite najviše';
$string['layoutcount2'] = 'region/a sa blokovima. Trenutno koristite:';
$string['layoutdesc'] = 'Podesite podrazumevani raspored blokova koji korisnici vide.';
$string['layoutsettings'] = 'Izgled sajta';
$string['layoutsettingsheading'] = 'Kontrolni aspekti izgleda sajta';
$string['leftblocks'] = 'Leva strana';
$string['linkcolor'] = 'Boja linka';
$string['linkcolordesc'] = 'Podesite boju linkova u temi, koristeći html heksadecimalni kôd.';
$string['linkhover'] = 'Lebdeća boja linka';
$string['linkhoverdesc'] = 'Podesite boju linkova u temi (kada se mišem pređe preko njih), koristeći html heksadecimalni kôd.';
$string['linksmenu'] = 'Meni linkova';
$string['loadingcolor'] = 'Boja učitavanja';
$string['loadingcolordesc'] = 'Boja trake učitavanja na vrhu stranice.';
$string['loginbgimage'] = 'Pozadinska slika';
$string['loginbgimagedesc'] = 'Dodajte pozadinsku sliku preko cele stranice';
$string['loginbgopacity'] = 'Neprozirnost zaglavlja stranice za prijavu, navigacione trake, okvira za prijavu i pozadine podnožja kada postoji pozadinska slika';
$string['loginbgopacitydesc'] = 'Neprozirnost pozadine stranice za prijavu za zaglavlje, navigacionu traku, okvir za prijavu i podnožje kada postoji pozadinska slika.';
$string['loginbgstyle'] = 'Stil pozadine stranice za prijavu';
$string['loginbgstyledesc'] = 'Izaberite stil za postavljenu sliku.';
$string['logindesc'] = 'Prilagodite stranicu za prijavu dodavanjem pozadinske slike i teksta iznad i ispod polja za prijavu.';
$string['loginfooter'] = 'Podnožje stranice za prijavu';
$string['loginfooterdesc'] = 'Prikaži podnožje stranice za prijavu.';
$string['loginheader'] = 'Zaglavlje stranice za prijavu';
$string['loginheaderdesc'] = 'Prikaži zaglavlje stranice za prijavu.';
$string['loginplaceholder'] = 'Korisničko ime';
$string['loginsettings'] = 'Stranica za prijavu';
$string['loginsettingsheading'] = 'Prilagodite stranicu za prijavu.';
$string['logintextboxbottom'] = 'Tekstualni okvir na dnu stranice za prijavu';
$string['logintextboxbottomdesc'] = 'Dodajte prilagođeni tekst ispod polja za prijavu na sajt.';
$string['logintextboxtop'] = 'Tekstualni okvir na vrhu stranice za prijavu';
$string['logintextboxtopdesc'] = 'Dodajte prilagođeni tekst iznad polja za prijavu na sajt.';
$string['logintextbutton'] = 'Prijavi se';
$string['logintextbuttonwhenoidc'] = 'Prijava gostiju/Ručna prijava';
$string['logintextmanualbutton'] = 'Prijava sa testnim nalogom';
$string['logo'] = 'Logo';
$string['logoalt'] = 'Opis logotipa';
$string['logoaltdesc'] = 'Navedite opis svog logotipa zbog pristupačnosti. Višejezična kompatibilnost.';
$string['logodesc'] = 'Postavite logo koji će se koristiti na vašem sajtu. Preporučena veličina je 200 x 80 piksela.';
$string['maincolor'] = 'Glavna boja';
$string['maincolordesc'] = 'Glavna boja za blokove i podnožje stranice.';
$string['maincoursepage'] = 'Glavna stranica kursa';
$string['market'] = 'Promotivni blok';
$string['marketblockbordercolor'] = 'Boja bordure promotivnog bloka';
$string['marketblockbordercolordesc'] = 'Podesite boju bordure promotivnog bloka.';
$string['marketblocksbackgroundcolor'] = 'Boja pozadine regiona sa promotivnim blokovima';
$string['marketblocksbackgroundcolordesc'] = 'Podesite boju pozadine regiona sa promotivnim blokovima.';
$string['marketdesc'] = 'Dodajte HTML za promotivni blok. Molimo, pogledajte odeljak \'Readme\' na kartici za podešavanja \'Informacije\' za dodatne informacije.';
$string['marketingbuilderdesc'] = 'Upotrebite alat u nastavku kako biste podesili svoje promotivne blokove. Jednom kada ovde definišite broj blokova u donjem delu stranice pojaviće se podešavanja za svaki od njih.';
$string['marketingbuilderheading'] = 'Alat za raspored promotivnih blokova';
$string['marketingdeprecated'] = 'Promotivni blokovi su zastareli, pređite na korišćenje regiona sa Informacionim blokovima.';
$string['marketingdesc'] = 'Postoje dva info-bloka pune širine sa različitim stilovima koje možete da koristite.<br>Pored toga postoji i alat za kreiranje rasporeda blokova koji vam daje mogućnost da odlučite koliko blokova vam je potrebno i da definišete svoj raspored blokova.<br>Molimo, pogledajte odeljak \'Readme\' na kartici za podešavanja \'Informacije\' za dodatne informacije.';
$string['marketingsettings'] = 'Promotivni blokovi';
$string['marketingsettingsheading'] = 'Prilagodite promotivne blokove koji se pojavljuju na naslovnoj stranici.';
$string['marketingvisible'] = 'Prikažite promotivne blokove kada';
$string['marketingvisibledesc'] = 'Prikažite promotivne blokove kada ste \'Odjavljeni\', \'Prijavljeni\' ili \'Prijavljeni ili odjavljeni\'.';
$string['marketingvisibleloggedin'] = 'Prijavljeni';
$string['marketingvisibleloggedinout'] = 'Prijavljeni ili odjavljeni';
$string['marketingvisibleloggedout'] = 'Odjavljeni';
$string['marketlayoutrow'] = 'Red promotivnih blokova';
$string['marketlayoutrowdesc'] = 'Dodajte / podesite izgled reda sa promotivnim blokovima na naslovnoj stranici';
$string['menubkcolor'] = 'Boja pozadine glavnog menija';
$string['menubkcolordesc'] = 'Podesite boju pozadine glavnog menija';
$string['menubkhovercolor'] = 'Lebdeća boja pozadine glavnog menija';
$string['menubkhovercolordesc'] = 'Podesite lebdeću boju pozadine glavnog menija';
$string['menubordercolor'] = 'Boja donje bordure glavnog menija';
$string['menubordercolordesc'] = 'Podesite boju donje bordure glavnog menija.';
$string['menufontcolor'] = 'Boja fonta glavnog menija';
$string['menufontcolordesc'] = 'Podesite boju fonta glavnog menija.';
$string['menufonthovercolor'] = 'Lebdeća boja glavnog menija';
$string['menufonthovercolordesc'] = 'Podesite lebdeću boju glavnog menija';
$string['menufontpadding'] = 'Razmak između stavki navigacije';
$string['menufontpaddingdesc'] = 'Podesite razmak između stavki u glavnoj navigacionoj traci.';
$string['menufontsize'] = 'Veličina fonta za navigacionu traku';
$string['menufontsizedesc'] = 'Podesite veličinu fonta koji se koristi u glavnoj navigacionoj traci';
$string['menuoverrideprofilefield'] = 'Naziv prilagođenog polja profila';
$string['menuoverrideprofilefielddefault'] = 'topmenusettings';
$string['menuoverrideprofilefielddesc'] = 'Naziv prilagođenog polja profila (u formatu ”spiska”) koje se koriste za korisničke izmene.';
$string['menusdesc'] = '';
$string['menusession'] = 'Sačuvaj detalje o pristupu u sesiji korisnika';
$string['menusessiondesc'] = 'Zbog performansi sistema sugeriše se da uključite ovu opciju. Možda ćete želeti da je onemogućiti prilikom testiranja.';
$string['menusessionttl'] = 'Vreme čuvanja pravila pristupa u sesiji korisnika';
$string['menusessionttldesc'] = 'Vremenski period (broj minuta) nakon kog se pravila za pristup meniju osvežavaju u sesiji korisnika.';
$string['menusettings'] = 'Meniji zaglavlja';
$string['menusettingsheading'] = 'Prilagodite menije u gornjem zaglavlju ove teme.';
$string['menusheading'] = 'Konfigurišite navigaciju za linkove menija u gornjem zaglavlju';
$string['menusheadingvisibility'] = 'Opšta podešavanja za vidljivost menija na vrhu stranice';
$string['menusheadingvisibilitydesc'] = 'Sledeća podešavanja omogućavaju da kontrolišete gde se pojavljuju meniji i opciono omogućavaju korisnicima da prilagode svoja podešavanja';
$string['menuslinkicon'] = 'Ikonica linkova u meniju';
$string['menuslinkicondesc'] = 'Izaberite prilagođenu Font Awesome ikonicu';
$string['menuslinkright'] = 'Prikaži meni linkova gore desno';
$string['menuslinkrightdesc'] = 'Ako je označeno, meni sa linkovima se prikazuje u gornjem desnom uglu odmah pored menija sa porukama.';
$string['menustitledesc'] = 'Meniji \'Alati\' (u navigacionoj traci) i Gornji meniji (u gornjem zaglavlju) se mogu ograničiti na osnovu prilagođenih polja u profilu korisnika (opciono). Da biste dodali ograničenje unesite naziv polja profila i očekivanu vrednost. Struktura menija sledi uobičajeni Moodle format:
<br/>
<pre>
Moodle community|https://moodle.org
-Moodle free support|https://moodle.org/support
-Moodle development|https://moodle.org/development
--Moodle Docs|http://docs.moodle.org|Moodle Docs
--German Moodle Docs|http://docs.moodle.org/de|Documentation in German|de
Moodle.com|http://moodle.com/
</pre>';
$string['menuuseroverride'] = 'Dozvoli izmene od strane korisnika';
$string['menuuseroverridedesc'] = 'Ovo podešavanje može da se koristi kako bi se, putem prilagođenog polja profila, korisnicima dala kontrola nad pojavljivanjem menija. Za korišćenje ove opcije biće potrebno da kreirate prilagođeno polje profila u formatu ”spiska”sa vrednostima poređanim odgovarajućim redosledom:
<br/>
<pre>1 . Na čitavom sajtu (prva vrednost na spisku biće za vidljivost menija na čitavom sajtu)
2 . Samo početne stranice (druga vrednost na spisku ograničiće vidljivost menija samo na sajtu / početno stranici)
3 . Sakriveno (treća vrednost na spisku će sakriti menije u potpunosti)</pre>
NEMOJTE koristiti opciju ”Onemogući menije na stranicama kursa” zajedno sa podešavanjima polja profila. Umesto toga, kada podešavate vaš spisak polja profila, koristite kao podrazumevanu vrednost ”Samo početne stranice”.

Napomena: da bi ova promena stupila na snagu, korisnici će morati da se odjave sa sajta i ponovo prijave. Bilo bi dobro da u prilagođeno polje profila dodate napomenu koja ovo objašnjava.';
$string['messagepopupbackground'] = 'Boja pozadine iskačućeg prozora sa porukama';
$string['messagepopupbackgrounddesc'] = 'Podesite boju pozadine zaglavlja iskačućeg prozora sa porukama.';
$string['messagepopupcolor'] = 'Boja teksta iskačućeg prozora sa porukama';
$string['messagepopupcolordesc'] = 'Podesite boju teksta zaglavlja iskačućeg prozora sa porukama.';
$string['messagingbackgroundcolor'] = 'Boja pozadine glavnog prozora privatne poruke';
$string['messagingbackgroundcolordesc'] = 'Podesite boju pozadine glavnog prozora privatnih poruka.';
$string['mobilemenubkcolor'] = 'Boja pozadine menija na mobilnim uređajima';
$string['mobilemenubkcolordesc'] = 'Podesite boju pozadine glavnog menija na mobilnim uređajima (skupljeno).';
$string['mobileprimarynav'] = 'Primarna navigacija na mobilnim uređajima';
$string['mobileprimarynavdesc'] = 'Omogućite ili onemogućite. Napomena: Ovo je meni koji kontroliše ikonica hamburgera';
$string['moodledocs'] = 'Link ka Moodle dokumentaciji';
$string['moodledocsdesc'] = 'Prikažite link ka Moodle dokumentaciji u podnožju stranice.';
$string['more'] = 'Više';
$string['myblogs'] = 'Moji blogovi';
$string['mycoursesmenulimit'] = 'Ograničenje menija \'Moji kursevi\'';
$string['mycoursesmenulimitdesc'] = 'Podesite maksimalan broj kurseva koji se pojavljuju u padajućem meniju "Moji kursevi". 0 će prikazati sve kurseve.';
$string['mysites'] = 'Moji kursevi';
$string['mysitesdisabled'] = 'Onemogući';
$string['mysitesexclude'] = 'Omogući isključivanje sakrivenih kurseva';
$string['mysitesinclude'] = 'Omogući uključivanje sakrivenih kurseva';
$string['mysitesmaxlength'] = 'Maksimalna dužina naziva mojih kurseva';
$string['mysitesmaxlengthdesc'] = 'Podesite maksimalnu dužinu naziva kurseva u padajućem meniju ”Moji kursevi”.';
$string['mysitesmenudisplay'] = 'Prikaz menija \'Moji kursevi\'';
$string['mysitesmenudisplaydesc'] = 'Izaberite koji tekst želite da prikažete za stavku menija i prilikom prelaska mišem preko stavke.';
$string['mysitesmenudisplayfullnamefullnameonhover'] = 'Prikaži puni naziv kursa i puni naslov prilikom prelaska miša.';
$string['mysitesmenudisplayfullnamenohover'] = 'Prikaži puni naziv kursa i nikakav tekst prilikom prelaska miša.';
$string['mysitesmenudisplayshortcodefullnameonhover'] = 'Prikaži kratak kôd i puni naziv kursa prilikom prelaska miša.';
$string['mysitesmenudisplayshortcodenohover'] = 'Prikaži kratak kôd bez teksta prilikom prelaska miša.';
$string['mysitessortoverride'] = 'Omogući prilagođeno sortiranje u meniju \'Moji kursevi\'';
$string['mysitessortoverridedesc'] = 'Upotrebite prilagođena polja profila ili generičke stringove (godina itd) kako biste skupili protekle kurseve u podmeniju.';
$string['mysitessortoverridefield'] = 'Prilagođena polja profila ili stringovi za meni ”Moji kursevi”';
$string['mysitessortoverridefielddesc'] = 'Spisak polja profila ili stringova, razdvojenih zarezima, za proveru u kratkim kôdovim kurseva.';
$string['mysitessortoverridelast'] = 'Vreme poslednjeg pristupa ili vreme početka upisa na kurs ako se kursu nikada nije pristupilo';
$string['mysitessortoverridemyoverview'] = 'Preuzmite spisak sa \'Pregled mojih kurseva\'';
$string['mysitessortoverrideoff'] = 'Prikaži sve upisane kurseve kao običan spisak';
$string['mysitessortoverrideprofilefields'] = 'Prikaži kurseve pronađene u poljima profila u prvom spisku, ostale u podmeniju';
$string['mysitessortoverrideprofilefieldscohort'] = 'Prikaži kurseve pronađene u poljima profila i kohortama u prvom spisku, ostale u podmeniju';
$string['mysitessortoverridestrings'] = 'Prikaži upisane kurseve koji sadrže stringove u prvom spisku, ostale u podmeniju';
$string['navbarcachetime'] = 'Vreme keširanja navigacione trake';
$string['navbarcachetimedesc'] = 'Broj minuta tokom kojih se kešira navigaciona traka.';
$string['navbardesc'] = 'Omogućava vam da kontrolišete sve elemente koji se pojavljuju u navigacionoj traci.';
$string['navbardisplayicons'] = 'Prikaži ikonice';
$string['navbardisplayiconsdesc'] = 'Prikažite ikonice pored naslova glavnog menija';
$string['navbardisplaymenuarrow'] = 'Prikaži strelicu menija';
$string['navbardisplaymenuarrowdesc'] = 'Prikažite strelicu menija (okrenutu nadole) za naslov menija.';
$string['navbardisplaytitles'] = 'Prikaži naslove';
$string['navbardisplaytitlesdesc'] = 'Prikažite naslov menija. Napomene : ignoriše se kada opcija \'navbardisplayicons\' nije podešena, a takođe se ignoriše i kada opcija \'custommenutitle\' nije podešena za prilagođeni meni.';
$string['navbardropdownborderradius'] = 'Poluprečnik bordure padajućeg menija';
$string['navbardropdownborderradiusdesc'] = 'Kontroliše poluprečnik bordure padajućih menija (npr. zaobljeni uglovi)';
$string['navbardropdownhovercolor'] = 'Lebdeća boja pozadine padajućeg menija';
$string['navbardropdownhovercolordesc'] = 'Boja pozadine padajućeg menija kada pređete mišem preko stavki menija.';
$string['navbardropdowntextcolor'] = 'Boja teksta padajućeg menija';
$string['navbardropdowntextcolordesc'] = 'Boja teksta stavke padajućeg menija.';
$string['navbardropdowntexthovercolor'] = 'Lebdeća boja teksta u padajućem meniju';
$string['navbardropdowntexthovercolordesc'] = 'Boja teksta padajućeg menija kada pređete mišem preko stavki menija.';
$string['navbardropdowntransitiontime'] = 'Vreme tranzicije navigacione trake';
$string['navbardropdowntransitiontimedesc'] = 'Vreme trajanja tranzicionog efekta navigacione trake, u sekundama. Obezbeđuje animacioni efekat postepenog pojavljivanja kada se mišem pređe preko menija koji ima podmenije.';
$string['navbarlinksettingsdesc'] = 'Omogućava vam da kontrolišete linkove koje se pojavljuju na traci za navigaciju.';
$string['navbarlinksettingsheading'] = 'Prilagodite linkove na traci za navigaciju';
$string['navbarlinkssettings'] = 'Linkovi navigacione trake';
$string['navbarmycourses'] = 'Meni\' Moji kursevi\' u navigacionoj traci';
$string['navbarsettings'] = 'Navigaciona traka';
$string['navbarsettingsheading'] = 'Prilagodite navigacionu traku';
$string['navbarstyles'] = 'Stilovi navigacione trake';
$string['navbarstylesdesc'] = 'Омогућава вам да контролишете стилове елемената који се појављују на траци за навигацију.';
$string['navbarstylesheading'] = 'Prilagodite stilove navigaciione trake';
$string['newmenu'] = 'Padajući meni na vrhu stranice';
$string['newmenudesc'] = 'Konfigurišite linkovi koji će biti prikazani u meniju gornjeg zaglavlja.';
$string['newmenufield'] = 'Naziv prilagođenog polja profila=Vrednost (opciono)';
$string['newmenufielddesc'] = 'Dodajte pravilo pristupa koristeći prilagođeno polje profila, npr: usertype=student.';
$string['newmenuheading'] = 'Meni na vrhu stranice';
$string['newmenurequirelogin'] = 'Zahteva prijavu na sistem';
$string['newmenurequirelogindesc'] = 'Ako je podešavanje omogućeno, ovaj meni će videti samo prijavljeni korisnici.';
$string['newmenutitle'] = 'Naslov menija na vrhu stranice';
$string['newmenutitledefault'] = 'Meni';
$string['newmenutitledesc'] = 'Naslov padajućeg menija koji se pojavljuje u zaglavlju vašeg sajta.';
$string['newstickercount'] = 'Broj sekcija pokretne trake sa vestima';
$string['newstickercountdesc'] = 'Definišite više sekcija pokretne trake sa vestima, zajedno sa pravilima pristupa kako biste targetirali različitu publiku.';
$string['newstickersettings'] = 'Pokretna traka sa vestima';
$string['nextactivity'] = 'Sledeća aktivnost';
$string['nextsection'] = 'Sledeća sekcija';
$string['noenrolments'] = 'Nije pronađen nijedan upis na kurs.';
$string['none'] = 'Bez senke';
$string['normal'] = 'Fiksna širina';
$string['nostyle'] = 'Bez stila';
$string['notbadgebackgroundcolour'] = 'Boja pozadine obaveštenja o bedževima';
$string['notbadgebackgroundcolourdesc'] = 'Podesite boju pozadine za obaveštenja o bedževima / oblačić u zaglavlju (prikazuje broj nepročitanih obaveštenja)';
$string['notbadgecolour'] = 'Boja obaveštenja o bedževima';
$string['notbadgecolourdesc'] = 'Podesite boju za obaveštenja o bedževima / oblačić u zaglavlju (prikazuje broj nepročitanih obaveštenja)';
$string['onetopicactivetabbackgroundcolor'] = 'Boja pozadine aktivne kartice';
$string['onetopicactivetabbackgroundcolordesc'] = 'Boja pozadine aktivne kartice na kursu u formatu jednotematskih kartica';
$string['onetopicactivetabtextcolor'] = 'Boja teksta aktivne kartice';
$string['onetopicactivetabtextcolordesc'] = 'Boja teksta aktivne kartice na kursu u formatu jednotematskih kartica';
$string['onetopicdesc'] = 'Prilagodite izgled \'<a href="{$a}" target="_blank">Kursa u formatu jednotematskih kartica</a>\' (ako se koristi na vašem sajtu).';
$string['onetopicheading'] = 'Format jednotematskih kartica';
$string['originaltemplatepreview'] = 'Pregled originalne / zamenjene datoteke teme';
$string['originaltemplatesource'] = 'Izvorni kôd originalne / zamenjene datoteke teme';
$string['orphanedblock'] = '<em>NAPUŠTENI BLOK - Originalno se prikazuje u: <strong>{$a}</strong></em>';
$string['overriddentemplate'] = 'Zamenjen šablon: {$a}';
$string['overriddentemplatedesc'] = 'Ako je podešeno, ovde unet tekst će se koristiti kao šablon \'{$a}\'. Da bi se osiguralo da pregled funkcioniše, mora postojati standardni primer konteksta u JSON formatu.';
$string['overriddentemplatenopreview'] = 'Nema pregleda jer nedostaje JSON primer';
$string['overriddentemplatepreview'] = 'Pregled izmenjenih podešavanja';
$string['overridetemplate'] = 'Zameni šablon: {$a}';
$string['pageheaderalternative'] = 'Alternativa';
$string['pageheaderheight'] = 'Visina zaglavlja stranice';
$string['pageheaderheightdesc'] = 'Podesite visinu regiona glavnog zaglavlja (koji sadrži logo i naslove).';
$string['pageheaderlayout'] = 'Zaglavlje jedan, izgled zaglavlja stranice';
$string['pageheaderlayoutdesc'] = 'Izgled zaglavlja stranice za stil zaglavlja jedan';
$string['pageheaderlayouttwo'] = 'Zaglavlje dva, izgled zaglavlja stranice';
$string['pageheaderlayouttwodesc'] = 'Izgled zaglavlja stranice za stil zaglavlja dva';
$string['pageheadernosearch'] = 'Bez okvira za pretragu';
$string['pageheaderoriginal'] = 'Original';
$string['pageloadingprogress'] = 'Napredak učitavanja stranice';
$string['pageloadingprogressdesc'] = 'Prikažite napredak pri učitavanju stranice.';
$string['pageloadingprogresstheme'] = 'Tema za učitavanje stranice';
$string['pageloadingprogressthemebarbershop'] = 'Berbernica';
$string['pageloadingprogressthemebigcounter'] = 'Veliki brojač';
$string['pageloadingprogressthemebounce'] = 'Loptica skočica';
$string['pageloadingprogressthemecenteratom'] = 'Atom u centru';
$string['pageloadingprogressthemecentercircle'] = 'Krug u centru';
$string['pageloadingprogressthemecenterradar'] = 'Radar u centru';
$string['pageloadingprogressthemecornerindicator'] = 'Indikator u uglu';
$string['pageloadingprogressthemedesc'] = 'Podesite temu za učitavanje stranice.';
$string['pageloadingprogressthemeflash'] = 'Fleš';
$string['pageloadingprogressthemeloadingbar'] = 'Traka za učitavanje';
$string['pageloadingprogressthememacosx'] = 'Mac OSX';
$string['pageloadingprogressthememinimal'] = 'Minimalno';
$string['passwordplaceholder'] = 'Lozinka';
$string['past'] = 'Прошли';
$string['pastcourses'] = 'Protekli kursevi';
$string['people'] = 'Učesnici';
$string['piwikenabled'] = 'Omogućeno';
$string['piwikenableddesc'] = 'Omogućite Matomo praćenje podataka za Moodle.';
$string['piwikimagetrack'] = 'Praćenje slika';
$string['piwikimagetrackdesc'] = 'Omogućite praćenje slike na Moodle sajtu za veb čitače kod kojih je isključen JavaScript.';
$string['piwiksettings'] = 'Matomo (nekadašnji Piwik) Analytics';
$string['piwiksettingsdesc'] = 'Generiše pročišćenu URL adresu za napredno praćenje.';
$string['piwiksettingsheading'] = 'Matomo podešavanja';
$string['piwiksiteid'] = 'ID oznaka sajta';
$string['piwiksiteiddesc'] = 'Unesite ID oznaku vašeg sajta';
$string['piwiksiteurl'] = 'Matomo URL adresa';
$string['piwiksiteurldesc'] = 'Unesite URL adresu za Matomo Analytics  bez http(s) i pratećih kosih crta';
$string['piwiktrackadmin'] = 'Praćenje administratora';
$string['piwiktrackadmindesc'] = 'Omogućite praćenje administratora (ne preporučuje se)';
$string['pluginname'] = 'Adaptable';
$string['portrait'] = 'Portretna orijentacija';
$string['previousactivity'] = 'Prethodna aktivnost';
$string['previoussection'] = 'Prethodna sekcija';
$string['primarycolour'] = 'Primarna boja';
$string['primarycolourdesc'] = 'Podesite primarnu boju. Ovo je Bootstrap \'primarna\' boja koja se koristi unutar SCSS-a.';
$string['printbodyfontsize'] = 'Величина основног фонта';
$string['printbodyfontsizedesc'] = 'Podesite veličinu osnovnog fonta';
$string['printlineheight'] = 'Visina reda';
$string['printlineheightdesc'] = 'Podesite visinu reda.';
$string['printmargin'] = 'Margina';
$string['printmargindesc'] = 'Podesite margine';
$string['printpageorientation'] = 'Orijentacija stranice';
$string['printpageorientationdesc'] = 'Podesite orijentaciju stranice na\'Portretna orijentacija\' ili \'Pejzažna orijentacija\'.';
$string['printsettings'] = 'Štampa';
$string['printsettingsdesc'] = 'Конфигуришите подешавања за штампање.';
$string['printsettingsheading'] = 'Podešavanja štampanja';
$string['privacy:closed'] = 'Zatvoreno';
$string['privacy:metadata:preference:collapseblock'] = 'Status blokova na stranici.';
$string['privacy:metadata:preference:draweropenblock'] = 'Status fioke sa blokovima.';
$string['privacy:metadata:preference:draweropenindex'] = 'Status fioke sa indeksom kursa';
$string['privacy:metadata:preference:themeadaptablealertkey'] = 'Dato važno obaveštenje.';
$string['privacy:metadata:preference:themeadaptablefull'] = 'Status prikaza preko celog ekrana';
$string['privacy:metadata:preference:themeadaptablezoom'] = 'Status zumiranja';
$string['privacy:note'] = 'Napomena: grafička tema Adaptable ima podešavanja koja se tiču njene konfiguraciju. Specifična korisnička podešavanja opisana u \'Registru privatnosti dodataka\' važe i za Adaptable lokalni dodatak (kada se instalira). Za ostala podešavanja, na vama leži odgovornost da obezbedite da se ne unose podaci o korisnicima u bilo koje tekstualno polje dodatka. Podaci o instaliranju i podešavanju dodatka biće zapisani u osnovnom Moodle sistemu za evidentiranje događaja, zajedno sa podacima o korisniku koji je promene napravio. Ovo je izvan kontrole grafičke tema. Molimo vas, pogledajte osnovni sistem za evidenciju događaja radi usklađenosti sa privatnošću. Kada postavljate slike, trebalo bi da izbegavate postavljanje slika, kod kojih su uključeni podaci o lokaciji (EXIF GPS) ili drugi slični privatni podaci (iz takvih slika se mogu izdvojiti podaci o mestu gde je slika nastala, kao i slični privatni podaci). Pažljivo pregledajte kôd kako biste bili sigurni da je on u potpunosti skladu sa vašom interpretacijom zakona o privatnosti koji važe u vašoj zemlji. Ja nisam pravnik i moja analiza se zasniva na mom tumačenju. Ako imate bilo kakvu sumnju, odmah uklonite temu.';
$string['privacy:open'] = 'Otvoreno';
$string['privacy:request:preference:collapseblock'] = 'Parametar korisnika "{$a->name}" za ID oznaku bloka "{$a->blockid}" ima vrednost "{$a->value}" što predstavlja "{$a->decoded}" za status bloka.';
$string['privacy:request:preference:draweropenblock'] = 'Parametar korisnika "{$a->name}" ima vrednost "{$a->value}" što predstavlja "{$a->decoded}" za status fioke sa blokovima.';
$string['privacy:request:preference:draweropenindex'] = 'Parametar korisnika "{$a->name}" ima vrednost "{$a->value}" što predstavlja "{$a->decoded}" za status fioke sa indeksom kursa.';
$string['privacy:request:preference:themeadaptablealertkey'] = 'Parametar korisnika "{$a->name}" za ID oznaku važnog obaveštenja  "{$a->alertid}" ima vrednost "{$a->value}" za dato važno obaveštenje, \'undismissable\' ili bilo koji drugi \'alertkey\' što predstavlja da je važno obaveštenje već postojalo za korisnika.';
$string['privacy:request:preference:themeadaptablefull'] = 'Parametar korisnika "{$a->name}" ima vrednost "{$a->value}" što predstavlja "{$a->decoded}" za status zumiranja.';
$string['privacy:request:preference:themeadaptablezoom'] = 'Parametar korisnika "{$a->name}" ima vrednost "{$a->value}" što predstavlja "{$a->decoded}" za status zumiranja.';
$string['properties'] = 'Uvoz /izvoz podešavanja';
$string['propertiesdesc'] = 'U ovom odeljku možete da uvezete/izvezete trenutna podešavanja Adaptable teme (svojstva) u JSON formatu. Takođe možete videti sva trenutna podešavanja u ovoj Moodle instalaciji.';
$string['propertiesexport'] = 'Izvezite parametre kao JSON string';
$string['propertiesexportfilestoo'] = 'Izvezite parametre sa datotetekama<br>kao JSON string';
$string['propertiesexportfilestoofile'] = 'Izvezite parametre sa datotetekama<br>kao JSON datoteku';
$string['propertiesexportfilestoofilefail'] = 'Dostignut je maksimalan broj parametara sa datotekama, kao JSON datoteka. Obrišite jedan ili više njih.';
$string['propertiesexportfilestoofilehelp'] = 'Nakon eksportovanja, preuzmite generisanu JSON datoteku sa današnjim datumom i vremenom iz podešavanja \'propertyfiles\' i postavite je u podešavanje \'fileputprops\' na odredišnoj instalaciji i kliknite na dugme \' Sačuvaj promene \'. Izveštaj će zatim biti generisan i postavljen u podešavanje \'putprops\' \'.';
$string['propertiesexportfilestoofilesuccess'] = 'Svojstva sa datotekama kao JSON datoteka izvezena kao {$a}.';
$string['propertiesexportfilestoohelp'] = 'Nakon eksportovanja, kopirajte JSON sa ekrana u podešavanje \'putprops\' (nakon što ga obrišete) na odredišnoj instalaciji i kliknite na dugme \'Sačuvaj promene \'. Izveštaj će zatim biti generisan i postavljen u podešavanje \'putprops\' \'.';
$string['propertiesexporthelp'] = 'Nakon eksportovanja, kopirajte JSON sa ekrana u podešavanje \'putprops\' (nakon što ga obrišete) na odredišnoj instalaciji i kliknite na dugme \'Sačuvaj promene \'. Izveštaj će zatim biti generisan i postavljen u podešavanje \'putprops\' \'. U izveštaju će biti prikazana sva podešavanja za koje je potrebno da njihove datoteke (sa tim podešavanjima) budu ručno prenete.';
$string['propertiesproperty'] = 'Parametar';
$string['propertiesreturn'] = 'Povratak';
$string['propertiessub'] = 'Trenutna podešavanja teme';
$string['propertiesvalue'] = 'Vrednost';
$string['propertyfileadded'] = 'Datoteke \'{$a->filename}\' je dodata u podešavanje \'{$a->settingname}\'.';
$string['propertyfileremoved'] = 'Datoteka\'{$a->filename}\' je uklonjena iz podešavanja \'{$a->settingname}\'.';
$string['propertyfiles'] = 'Datoteke sa svojstvima';
$string['propertyfilesdesc'] = 'Kada se dostigne maksimalan broj datoteka, nove neće biti dodavane sve dok se jedna ili više datoteka ne obriše.';
$string['putpropertiesadded'] = 'Dodato:';
$string['putpropertieschanged'] = 'Promenjeno:';
$string['putpropertiesdesc'] = 'Nalepite JSON string i kliknite na dugme \'Sačuvaj promene\'. Pažnja! Ne proverava vrednosti podešavanja niti izvršava komandu \'Očistite sve keš memorije\'';
$string['putpropertiesfiledesc'] = 'Prevucite i spustite JSON datoteku ili je postavite i kliknite na dugme\'Sačuvaj promene\'. Pažnja! Ne proverava vrednosti podešavanja niti izvršava komandu \'Očistite sve keš memorije\'';
$string['putpropertiesfilename'] = 'Uvezite svojstva iz datoteke';
$string['putpropertiesfrom'] = 'od';
$string['putpropertiesheading'] = 'Uvezite podešavanja teme';
$string['putpropertiesignorecti'] = 'Ignorisanje svih podešavanja naslovnih slika kursa.';
$string['putpropertiesignored'] = 'Ignorisano:';
$string['putpropertiesname'] = 'Uvoz parametara';
$string['putpropertiesreportfiles'] = 'Ne zaboravite da postavite sledeće datoteke u njihova podešavanja:';
$string['putpropertiesreportfileschanged'] = 'Promenjene datoteke:';
$string['putpropertiessettingsreport'] = 'Izveštaj o podešavanjima:';
$string['putpropertiesunchanged'] = 'Nepromenjeno:';
$string['putpropertiesvalue'] = '->';
$string['putpropertyproperties'] = 'Parametri';
$string['putpropertyreport'] = 'Izveštaj:';
$string['putpropertyversion'] = 'verzija:';
$string['region-content'] = 'Sadržaj';
$string['region-course-bottom-a'] = 'Dno stranice kursa - region pet';
$string['region-course-bottom-b'] = 'Dno stranice kursa - region šest';
$string['region-course-bottom-c'] = 'Dno stranice kursa - region sedam';
$string['region-course-bottom-d'] = 'Dno stranice kursa - region osam';
$string['region-course-section-a'] = 'Donji region na kraju stranice aktivnosti';
$string['region-course-tab-one-a'] = 'Kartica stranice kursa - region blokova jedan';
$string['region-course-tab-two-a'] = 'Kartica stranice kursa - region blokova dva';
$string['region-course-top-a'] = 'Vrh stranice kursa - region jedan';
$string['region-course-top-b'] = 'Vrh stranice kursa - region dva';
$string['region-course-top-c'] = 'Vrh stranice kursa - region tri';
$string['region-course-top-d'] = 'Vrh stranice kursa - region četiri';
$string['region-frnt-footer'] = 'Podnožje';
$string['region-frnt-market-a'] = 'Region stranice jedan';
$string['region-frnt-market-b'] = 'Region stranice dva';
$string['region-frnt-market-c'] = 'Region stranice tri';
$string['region-frnt-market-d'] = 'Region stranice četiri';
$string['region-frnt-market-e'] = 'Region stranice pet';
$string['region-frnt-market-f'] = 'Region stranice šest';
$string['region-frnt-market-g'] = 'Region stranice sedam';
$string['region-frnt-market-h'] = 'Region stranice osam';
$string['region-frnt-market-i'] = 'Region stranice devet';
$string['region-frnt-market-j'] = 'Region stranice deset';
$string['region-frnt-market-k'] = 'Region stranice jedanaest';
$string['region-frnt-market-l'] = 'Region stranice dvanaest';
$string['region-frnt-market-m'] = 'Region stranice trinaest';
$string['region-frnt-market-n'] = 'Region stranice četrnaest';
$string['region-frnt-market-o'] = 'Region stranice petnaest';
$string['region-frnt-market-p'] = 'Region stranice šesnaest';
$string['region-frnt-market-q'] = 'Region stranice sedamnaest';
$string['region-frnt-market-r'] = 'Region stranice osamnaest';
$string['region-frnt-market-s'] = 'Region stranice devetnaest';
$string['region-frnt-market-t'] = 'Region stranice dvadeset';
$string['region-information'] = 'Informacije';
$string['region-my-tab-one-a'] = 'Kartica \'Kontrolnog panela\' - region jedan';
$string['region-my-tab-two-a'] = 'Kartica \'Kontrolnog panela\' - region dva';
$string['region-news-slider-a'] = 'Region stranice kursa za slajd-šou';
$string['region-side-post'] = 'Desno';
$string['region-side-pre'] = 'Levo';
$string['regionmaincolor'] = 'Boja glavnog regiona';
$string['regionmaincolordesc'] = 'Podesite boju pozadine za region sa glavnim sadržajem.';
$string['regionmaintextcolor'] = 'Boja teksta glavnog regiona';
$string['regionmaintextcolordesc'] = 'Podesite boju teksta za region sa glavnim sadržajem.';
$string['rendereroverlaycolor'] = 'Boja prekrivajućeg sloja';
$string['rendereroverlaycolordesc'] = 'Boja prekrivajućeg sloja, kada je izabrana opcija prikaza \'Pločice sa prekrivajućim slojem\'.';
$string['rendereroverlayfontcolor'] = 'Boja fonta prekrivajućeg sloja';
$string['rendereroverlayfontcolordesc'] = 'Boja fonta kada se mišem pređe preko polja kursa (u situaciji kada je omogućena opcija prikaza \'Pločice sa prekrivajućim slojem\').';
$string['responsivebreadcrumb'] = 'Navigacija s putanjom';
$string['responsivebreadcrumbdesc'] = 'Na ekranima koje veličine želite da se prikazuje navigacija s putanjom?';
$string['responsivecoursetitle'] = 'Naziv kursa / sajta';
$string['responsivecoursetitledesc'] = 'ZASTARELO , umesto toga koristite \'responsivesitetitle\' .';
$string['responsiveheader'] = 'Glavno zaglavlje';
$string['responsiveheaderdesc'] = 'Na ekranima koje veličine želite da se prikazuje glavno zaglavlje?
<br/>Potpuno uklanjanje zaglavlja takođe će ukloniti sve elemente koji se nalaze u njemu:<br/><ul><li>Ikonice društvenih mreža</li><li>Logo</li><li>Naslov sajta / kursa</li></ul>';
$string['responsiveheadertitle'] = 'Naslov zaglavalja';
$string['responsiveheadertitledesc'] = 'Na ekranima koje veličine želite da se prikazuje naslov zaglavlja?';
$string['responsivelogo'] = 'Logo';
$string['responsivelogodesc'] = 'Na ekranima koje veličine želite da se prikazuje logo?';
$string['responsivepagefooter'] = 'Podnožje';
$string['responsivepagefooterdesc'] = 'Na ekranima koje veličine želite da se prikazuje podnožje?';
$string['responsivesectionnav'] = 'Navigacija kroz aktivnost / sekcije';
$string['responsivesectionnavdesc'] = 'Prikažite /sakrijte <strong>tekstualnu navigaciju</strong> za "prethodnu" odnosno "sledeću" aktivnost/sekciju na malim ekranima. Podrazumevano , ovaj tekst je sakriven na manjim ekranima tako da se prikazuju samo ikonice za linkove <prev> <next>, a ne pun naziv sekcije/aktivnosti.';
$string['responsivesettings'] = 'Prilagodljiv raspored elemenata';
$string['responsivesettingsdesc'] = 'Ovde možete da kontrolišete odzivno ponašanje vašeg veb sajta (koji se elementi pojavljuju na ekranima različitih veličina). Standardno , većina nebitnih stavki je skrivena na mobilnim uređajima i podešena da se prikazuje samo na većim ekranima. Možete da učinite da se elementi pojavljuju na manjim ekranima tako što ćete izabrati da ih prikažete na"Izuzetno malim" ili "Malim ekranima". Da biste bolje razumeli kako ova podešavanja funkcionišu, pogledajte Bootstrap dokumentaciju o \'<a href="{$a}" target="_blank">Svojstvima prikaza</а>\'.';
$string['responsivesettingsheading'] = 'Kontrolišite kako se vaš veb sajt ponaša na različitim veličinama ekrana';
$string['responsivesitetitle'] = 'Naslov sajta';
$string['responsivesitetitledesc'] = 'ZASTARELO , umesto toga koristite \'responsiveheadertitle\' .';
$string['responsiveslider'] = 'Slajd-šou na naslovnoj stranici';
$string['responsivesliderdesc'] = 'Na ekranima koje veličine želite da se prikazuje slajd-šou na naslovnoj stranici?';
$string['responsivesocial'] = 'Ikonice društvenih mreža';
$string['responsivesocialdesc'] = 'Na ekranima koje veličine želite da se prikazuju ikonice društvenih mreža?';
$string['responsivesocialsize'] = 'Podesi veličinu fonta ikonica društvenih mreža na mobilnim uređajima';
$string['responsivesocialsizedesc'] = 'Da bi prikaz bio bolji, veličina treba da bude 5 piksela veća od željene.';
$string['responsiveticker'] = 'Pokretna traka sa vestima';
$string['responsivetickerdesc'] = 'Na ekranima koje veličine želite da se prikazuje pokretna traka sa vestima?';
$string['rightblocks'] = 'Desna strana';
$string['savebuttontext'] = 'Sačuvaj promene';
$string['searchboxpadding'] = 'Slobodan prostor oko polja za pretragu';
$string['searchboxpaddingdesc'] = 'Podesite udaljenost polja za pretragu od ivica stranice (ako se ovo polje koristi umesto ikonica društvenih mreža) <br />Npr. 5px 10px 5px 10px (gore, desno, dole, levo).<br> Ikonice društvenih mreža možete podesiti na stranici za podešavanje <a href="./../admin/settings.php?section=themesettingadaptable#theme_adaptable_social">Zaglavlje - društvene mreže</a>.';
$string['secondarycolour'] = 'Sekundarna boja';
$string['secondarycolourdesc'] = 'Podesite sekundarnu boju. Ovo je Bootstrap \'sekundarna\' boja koja se koristi unutar SCSS-a.';
$string['sectionheadingcolor'] = 'Boja teksta naslova sekcije';
$string['sectionheadingcolordesc'] = 'Podesite boju za tekst naslova sekcije';
$string['sections'] = 'Sekcije';
$string['selectionbackground'] = 'Boja pozadine izabranog teksta';
$string['selectionbackgrounddesc'] = 'Podesite boju pozadine teksta koji je izabran na ekranu.';
$string['selectiontext'] = 'Boja izabranog teksta';
$string['selectiontextdesc'] = 'Podesite boju teksta koji je izabran na ekranu.';
$string['settingsalertbox'] = 'Okvir sa važnim obaveštenjem';
$string['settingsanalytics'] = 'Analitika';
$string['settingsblockicons'] = 'Ikonice';
$string['settingsblocksconfiguration'] = 'Konfiguracija';
$string['settingsborders'] = 'Bordure';
$string['settingsbreadcrumbcolors'] = 'Boje navigacione putanje';
$string['settingscolors'] = 'Boje';
$string['settingscourses'] = 'Kursevi';
$string['settingsfonts'] = 'Fontovi';
$string['settingsfootercolors'] = 'Boje podnožja';
$string['settingsforumheading'] = 'Forum';
$string['settingsheadercolors'] = 'Boje zaglavlja';
$string['settingsinfoboxcolors'] = 'Boje info-bloka';
$string['settingsinformation'] = 'Informacije';
$string['settingsmaincolors'] = 'Glavne boje';
$string['settingsmarketingcolors'] = 'Boje promotivnih blokova';
$string['settingsmessagescolors'] = 'Boje iskačućeg prozora sa porukama';
$string['settingsmobilecolors'] = 'Boje na mobilnim uređajima';
$string['settingsnavbarcolors'] = 'Boje navigacione trake';
$string['settingsoverlaycolors'] = 'Boje pločica prekrivajućeg sloja';
$string['settingspagealertsettings'] = 'Važna obaveštenja';
$string['settingspageblocksettings'] = 'Blokovi';
$string['settingspagefrontpageblockregionsettings'] = 'Alat za kreiranje rasporeda blokova na naslovnojn stranici';
$string['settingspagegeneralsettings'] = 'Opšta podešavanja';
$string['settingssecondinfoboxcolors'] = 'Boje sekundarnog info-bloka';
$string['settingstopicsweeks'] = 'Teme/Sedmice';
$string['show'] = 'Prikaži';
$string['showfooterblocks'] = 'Prikaži blokove podnožja';
$string['showfooterblocksdesc'] = 'Prikaži/sakrij četiri podesiva bloka u podnožju stranice.';
$string['shownavigationblockoncoursepage'] = 'Prikaži blok za navigaciju na stranici kursa';
$string['shownavigationblockoncoursepagedesc'] = 'Podesite ovo kako biste prikazali blok za navigaciju na stranici kursa.';
$string['showusername'] = 'Prikaži korisničko ime';
$string['showusernamedesc'] = 'Prikažite korisničko ime u korisničkom meniju na navigacionoj traci.';
$string['side-post1'] = 'Bočni stubac sa blokovima u podnožju';
$string['sidebaricon'] = 'Prikaži / sakrij bočni stubac sa blokovima';
$string['sitelinkslabel'] = 'Linkovi sajta';
$string['sitetitle'] = 'Prikaži naslov sajta';
$string['sitetitlecoursesdisabled'] = 'Onemogućeno - prikaži samo naslove kurseva na stranicama kurseva';
$string['sitetitlecoursesenabled'] = 'Omogućeno - prikaži naslov sajta i naslove kurseva na stranicama kurseva';
$string['sitetitlecustom'] = 'Koristite prilagođeni naslov sajta (unesite ga u donje tekstualno polje \'sitetitletext\' )';
$string['sitetitledefault'] = 'Koristi naslov Moodle sajta (naziv sajta)';
$string['sitetitledesc'] = 'Prikažite podrazumevani naslov Moodle sajta preuzet iz <a href="./../admin/settings.php?section=frontpagesettings" target="_blank">Podešavanja naslovne stranice</a> ili unesite u donje polje prilagođeni naziv sajta.';
$string['sitetitleoff'] = 'Onemogući naslov sajta';
$string['sitetitletext'] = 'Naslov sajta';
$string['sitetitletextdesc'] = 'Наслов сајта који се приказује у заглављу. Можете да користите било коју HTML ознаку и применити уметнуте стилове. Препоручује се да користите HTML ознаку H1 око наслова, уместо ознаке P која се додаје као подразумевана када унесете нешто у ово поље.';
$string['skipblock'] = 'Preskoči blok {$a}';
$string['slider2h3bgcolor'] = 'Slajd-šou dva - boja pozadine H3 oznake';
$string['slider2h3bgcolordesc'] = 'Izaberite boju pozadine koju želite za oznaku H3 (za slajd-šou stil dva)';
$string['slider2h3color'] = 'Slajd-šou dva - boja teksta oznake H3';
$string['slider2h3colordesc'] = 'Izaberite boju teksta koju želite za oznaku H3 (za slajd-šou stil dva)';
$string['slider2h4bgcolor'] = 'Slajd-šou dva - boja pozadine H4 oznake';
$string['slider2h4bgcolordesc'] = 'Izaberite boju pozadine koju želite za oznaku H4 (za slajd-šou stil dva)';
$string['slider2h4color'] = 'Slajd-šou dva - boja teksta oznake H4';
$string['slider2h4colordesc'] = 'Izaberite boju teksta koju želite za oznaku H4 (za slajd-šou stil dva)';
$string['slidercaption'] = 'Natpis na slajdu';
$string['slidercaptiondesc'] = 'Dodajte natpis za vaš slajd';
$string['slidercount'] = 'Broj slajdova';
$string['slidercountdesc'] = 'Izaberite koliko slajdova želite da dodate, a <strong>onda kliknite na dugme \'SAČUVAJ\'</strong> kako bi se učitala polja za unos podešavanja.';
$string['sliderenabled'] = 'Omogući slajd-šou';
$string['sliderenableddesc'] = 'Omogućite slajd-šou na vrhu vaše početne stranice.';
$string['sliderfullscreen'] = 'Slajd-šou preko celog ekrana';
$string['sliderfullscreendesc'] = 'Označite ovo polje kako bi slajd-šou bio prikazan preko celog ekrana (100% širine).';
$string['sliderh3color'] = 'Slajd-šou jedan - boja H3 oznake';
$string['sliderh3colordesc'] = 'Izaberite boju koju želite za oznaku H3 (za slajd-šou stil jedan)';
$string['sliderh4color'] = 'Slajd-šou jedan - boja H4 oznake';
$string['sliderh4colordesc'] = 'Izaberite boju koju želite za oznaku H4 (za slajd-šou stil jedan)';
$string['sliderimage'] = 'Slika slajda';
$string['sliderimagedesc'] = 'Dodajte sliku za vaš slajd. Preporučena veličina je 1600 x 400 piksela ili veća.';
$string['slidermarginbottom'] = 'Slajd-šou - donja margina';
$string['slidermarginbottomdesc'] = 'Podesite veličinu margine ispod slajd-šou prezentacije.';
$string['slidermargintop'] = 'Slajd-šou - gornja margina';
$string['slidermargintopdesc'] = 'Podesite veličinu margine iznad slajd-šou prezentacije';
$string['slideroption2'] = 'Izaberi tip slajd-šou prezentacije';
$string['slideroption2a'] = 'Boja pozadine strelice (slajd-šou stil dva)';
$string['slideroption2adesc'] = 'Podesite boju pozadine strelice (za slajd-šou stil dva).';
$string['slideroption2color'] = 'Slajd-šou dva - pozadina dugmeta';
$string['slideroption2colordesc'] = 'Podesite boju pozadine dugmeta (za slajd-šou stil dva)';
$string['slideroption2desc'] = 'Izaberite tip slajd-šou prezentacije, a <strong>onda kliknite na dugme SAČUVAJ</strong> kako biste videla podešavanja boja za izabrani tip prezentacije.';
$string['slideroption2submitcolor'] = 'Slajd-šou dva - tekst dugmeta';
$string['slideroption2submitcolordesc'] = 'Podesite boju teksta na dugmetu (za slajd-šou stil dva)';
$string['sliderstyle1'] = 'Slajd-šou - stil jedan';
$string['sliderstyle2'] = 'Slajd-šou - stil dva';
$string['slidersubmitbgcolor'] = 'Slajd-šou jedan - pozadina dugmeta';
$string['slidersubmitbgcolordesc'] = 'Izaberite boju pozadine dugmeta (za slajd-šou stil jedan)';
$string['slidersubmitcolor'] = 'Slajd-šou jedan - tekst dugmeta';
$string['slidersubmitcolordesc'] = 'Izaberite boju teksta na dugmetu (za slajd-šou stil 1jedan)';
$string['sliderurl'] = 'URL adresa linka slajda';
$string['sliderurldesc'] = 'Dodajte URL adresu sa kojom će vaš slajd biti povezan kada se klikne na njega.';
$string['slidervisible'] = 'Prikaži slajd-šou kada je korisnik';
$string['slidervisibledesc'] = 'Prikažite slajd-šou kada ste \'Odjavljeni\', \'Prijavljeni\' ili \'Prijavljeni ili odjavljeni\'.';
$string['slidervisibleloggedin'] = 'Prijavljen';
$string['slidervisibleloggedinout'] = 'Prijavljen ili odjavljen';
$string['slidervisibleloggedout'] = 'Odjavljen';
$string['slideshowdesc'] = 'Postavite slike, dodajte linkove i opis za karusel slajdova na naslovnoj stranici.';
$string['slideshowsettings'] = 'Slajd-šou';
$string['slideshowsettingsheading'] = 'Prilagodite karusel slajdova na naslovnoj stranici.';
$string['slight'] = 'Blaga senka';
$string['socialheading'] = 'Podešavanje ikonica društvenih mreža';
$string['socialicondesc'] = 'Podesite Font Awesome ikonicu, na primer: fa-facebook.';
$string['socialiconlist'] = 'Spisak ikonica društvenih mreža';
$string['socialiconlistdesc'] = 'Unesite spisak sa graničnicima, kako biste podesili ikonice društvenih mreža / linkove koji su vam potrebni, koristeći format: url|title|icon.';
$string['socialpaddingside'] = 'Podesite razmak sa strane ikonica društvenih mreža';
$string['socialpaddingsidedesc'] = 'Ovo će biti razmak između ikonice i drugog elementa ili međuprostor između dve ikonice. tj. dodatni prostor oko ikonice će biti ova vrednosat podeljena sa dva. Podrazumevana vrednost prati smernice za brendiranje Instagrama.';
$string['socialpaddingtop'] = 'Podesite razmak iznad ikonica društvenih mreža (menja vertikalni položaj)';
$string['socialpaddingtopdesc'] = 'Ovo će biti minimum od 15 piksela (podešeno korišćenjem margine) plus ova vrednost.';
$string['socialsearchicon'] = 'Pretraži Moodle';
$string['socialsearchicondesc'] = 'Ovo podešavanje omogućava da se postavi polje za pretragu uporedo sa ikonicama društvenih mreža (pošto njihovo korišćenje onemogućava polje za pretragu na čitavom sajtu).';
$string['socialsettings'] = 'Zaglavlje - društvene mreže';
$string['socialsize'] = 'Podesi veličinu fonta za ikonice društvenih mreža';
$string['socialsizedesc'] = 'Za bolji prikaz, veličina treba da bude 5 piksela veća od željene veličine.';
$string['socialtarget'] = 'Odredište linkova društvenih mreža';
$string['socialtargetdesc'] = 'Kako želite da se linkovi društvenih mreža otvaraju (u istom ili novom prozoru).';
$string['socialtitledesc'] = 'Možete da onemogućite polje za pretragu na čitavom sajtu i umesto njega omogućite ikonice / linkove društvenih mreža.
Da biste podesili ikonice društvenih mreža unesite spisak sa graničnicima u donje polje "Spisak ikonica društvenih mreža".
Spisak treba da bude u formatu:

url|title|icon

Na primer:
<pre>
https://example.com/course/search.php|Search Moodle|fa-search
https://facebook.com/|Facebook|fa-facebook-square
https://twitter.com/|Twitter|fa-twitter-square
https://instagram.com|Instagram|fa-instagram
https://example.com|My Web|fa-globe
</pre>
Kompletan spisak Font Awesome ikonica možete naći <a href="https://fortawesome.github.io/Font-Awesome/icons/">ovde</a>.';
$string['solid'] = 'Puna ivica';
$string['standard'] = 'Standardna senka';
$string['standardscreenwidth'] = 'Standardna širina ekrana.';
$string['standardscreenwidthdesc'] = 'Podesite širinu ekrana kada se prikaz prebaci na "standardni" prikaz (takođe pogledajte povezana podešavanja enablezoom i defaultzoom).';
$string['standardview'] = 'Standardni prikaz';
$string['stickynavbar'] = 'Lepljiva navigaciona traka na vrhu';
$string['stickynavbardesc'] = 'Fiksirajte navigacionu traku za vrh ekrana prilikom premotavanja sadržaja stranice.';
$string['stylecover'] = 'Naslovna slika';
$string['stylestretch'] = 'Razvučena slika';
$string['tabbedlayoutcoursepage'] = 'Izgled stranice kursa sa karticama';
$string['tabbedlayoutcoursepagedesc'] = 'Upotrebite kartični izgled za početnu stranicu kurs. Ovo prikazuju sav sadržaj unutar kartica. U okviru kartice \'Sadržaj kursa\' nalazi se sadržaj početne stranice kursa, dok sadržaj preostale dve kartice (Kartica jedan, Kartica dva) možete prilagoditi svojim potrebama. Koristite ovo podešavanje kako biste konfigurisali redosled kartica.';
$string['tabbedlayoutcoursepagelink'] = 'Kartica za povratak na kurs';
$string['tabbedlayoutcoursepagelinkdesc'] = 'Dodajte među kartice kursa karticu za povratak na stranicu kursa.';
$string['tabbedlayoutcoursepagetabcolorselected'] = 'Boja izabrane kartice na stranici kursa';
$string['tabbedlayoutcoursepagetabcolorselecteddesc'] = 'Izaberite boju za trenutno izabranu karticu.';
$string['tabbedlayoutcoursepagetabcolorunselected'] = 'Boja neizabrane kartice na stranici kursa';
$string['tabbedlayoutcoursepagetabcolorunselecteddesc'] = 'Izaberite boju za bilo koju drugu karticu.';
$string['tabbedlayoutcoursepagetabpersistencetime'] = 'Vreme trajanja kartice na početnoj stranici kursa';
$string['tabbedlayoutcoursepagetabpersistencetimedesc'] = 'Početna stranica kursa opstaje na izabranoj kartici kada dolazi do osvežavanja nakon određenog perioda neaktivnosti. Ovde podesite period neaktivnosti. Na primer, podesite ovo na 30 tako da prva kartica bude izabrana nakon 30 minuta neaktivnosti.';
$string['tabbedlayoutdashboard'] = 'Kartični izgled \'Kontrolnog panela\'';
$string['tabbedlayoutdashboarddesc'] = 'Upotrebite kartični izgled stranice \'Kontrolni panel\'. Ovo prikazuje sav sadržaj unutar kartica. U okviru kartice \'Sadržaj kontrolnog panela\' nalazi se sadržaj istoimena stranica, dok sadržaj preostale dve kartice (Kartica jedan, Kartica dva) možete prilagoditi svojim potrebama. Koristite ovo podešavanje kako biste konfigurisali redosled kartica.';
$string['tabbedlayoutdashboardtab1condition'] = 'Ograničenje prikaza Kartice 1 na osnovu prilagođenog polje profila (opciono)';
$string['tabbedlayoutdashboardtab1conditiondesc'] = 'Dodajte pravilo pristupa za prikaz Kartice 1 koristeći prilagođeno polje profila npr: showtab1 = true.';
$string['tabbedlayoutdashboardtab2condition'] = 'Ograničenje prikaza Kartice 2 na osnovu prilagođenog polje profila (opciono)';
$string['tabbedlayoutdashboardtab2conditiondesc'] = 'Dodajte pravilo pristupa za prikaz Kartice 2 koristeći prilagođeno polje profila npr: showtab2 = true.';
$string['tabbedlayoutdashboardtabcolorselected'] = 'Boja izabrane kartice na Kontrolnom panelu';
$string['tabbedlayoutdashboardtabcolorselecteddesc'] = 'Izaberite boju za trenutno izabranu karticu.';
$string['tabbedlayoutdashboardtabcolorunselected'] = 'Boja neizabrana kartice na Kontrolnom panelu';
$string['tabbedlayoutdashboardtabcolorunselecteddesc'] = 'Izaberite boju za bilo koju drugu karticu.';
$string['tabbedlayoutheading'] = 'Adaptable stranica sa karticama';
$string['tabbedlayouttablabelcourse'] = 'Sadržaj kursa';
$string['tabbedlayouttablabelcourse1'] = 'Kartica jedan';
$string['tabbedlayouttablabelcourse2'] = 'Kartica dva';
$string['tabbedlayouttablabeldashboard'] = 'Sadržaj \'Kontrolnog panela\'';
$string['tabbedlayouttablabeldashboard1'] = 'Kartica jedan';
$string['tabbedlayouttablabeldashboard2'] = 'Kartica dva';
$string['targetnewwindow'] = 'Novi prozor';
$string['targetsamewindow'] = 'Isti prozor';
$string['templatesheading'] = 'Podešavanje šablona';
$string['templatesheadingdesc'] = 'Zamenite šablone.';
$string['templatessel'] = 'Šabloni koje treba zameniti';
$string['templatesseldesc'] = 'Izaberite šablone koje želite da zamenite, a zatim će svaki biti prikazan na sopstvenoj stranici. Ako ovde nije izabran, šablon neće biti zamenjen čak i ako je omogućen. Ukoliko želite da ne izaberete nijedan šbalon, upotrebite taster \'Ctrl\'.';
$string['templatessettings'] = 'Šabloni';
$string['themechanges'] = 'Promene';
$string['themereadme'] = 'Readme uputstvo';
$string['themesupportsponsorship'] = 'Podrška i sponzorstvo';
$string['thiscourse'] = 'Ovaj kurs';
$string['ticker'] = 'Najave';
$string['tickerconstainerbackgroundcolour'] = 'Boja pozadine pokretne trake sa vestima';
$string['tickerconstainerbackgroundcolourdesc'] = 'Podesite boju pozadine pokretne trake sa vestima.';
$string['tickerconstainertextcolour'] = 'Boja teksta na pokretnoj traci sa vestima';
$string['tickerconstainertextcolourdesc'] = 'Podesite boju teksta pokretne trake sa vestima.';
$string['tickerdefault'] = 'Nema novih vesti za prikaz';
$string['tickerdesc'] = 'Ovde možete podesiti pokretnu traku sa vestima koja se kreće preko naslovne stranice vašeg Moodle sajta.
Njena namena je da bude manje nametljiva alternativa za slajd-šou, s obzirom da zauzima vrlo malo prostora.
Da biste podesili pokretnu traku sa vestima jednostavno unesite spisak  vesti, zajedno sa  hiperlinkovima koji su vam potrebni u tekstu vesti.
<strong>Napomena:</strong> Ako se vaša pokretna traka sa vestima ne učitava ispravno prebacite se na HTML prikaz i proverite da imate samo &lt;p&gt; oznake:
<pre>
&lt;p&gt;Prva vest.....&lt;/p&gt;
&lt;p&gt; Druga vest.....&lt;/p&gt;
</pre>';
$string['tickerfullscreen'] = 'Prikaz preko celog ekrana';
$string['tickerheaderbackgroundcolour'] = 'Boja pozadine zaglavlja pokretne trake sa vestima';
$string['tickerheaderbackgroundcolourdesc'] = 'Podesite boju pozadine zaglavlja pokretne trake sa vestima';
$string['tickerheadertextcolour'] = 'Boja teksta zaglavlja na pokretnoj traci sa vestima';
$string['tickerheadertextcolourdesc'] = 'Podesite boju testa zaglavlja na pokretnoj traci sa vestima';
$string['tickersettings'] = 'Pokretna traka sa vestima';
$string['tickersettingsheading'] = 'Prilagodite pokretnu traku sa vestima na naslovnoj stranici. Pogledajte primer rasporeda elemenata na stranici <a href="./../theme/adaptable/pix/layout.png" target="_blank">ovde</a>';
$string['tickertext'] = 'Tekst pokretne trake sa vestima';
$string['tickertextdesc'] = 'Dodajte tekst za pokretnu traku sa vestima u formatu spiska. Pogledajte readme.txt datoteku za više informacija.';
$string['tickertextprofilefield'] = 'Naziv prilagođenog polja profila=vrednost (opciono)';
$string['tickertextprofilefielddesc'] = 'Dodajte pravilo pristupa koristeći prilagođeno polje profila, npr: usertype=student';
$string['tickerwidth'] = 'Fiksna širina';
$string['tickerwidthdesc'] = 'Možete koristiti ovo podešavanje kako biste fiksirali pokretnu traku sa  vestima na 100% širine.';
$string['tilesbordercolor'] = 'Boja bordure pločica okvira kursa';
$string['tilesbordercolordesc'] = 'Podesite boju bordure pločica okvira kursa.';
$string['tilescontactstitle'] = 'Prikaži uloge kontakt osoba';
$string['tilescontactstitledesc'] = 'Prikažite / sakrijte ulogu kontakt osoba na kursu. Ako nije prikazana uloga, biće prikazana slika pored svake kontakt osobe.';
$string['tilesshowallcontacts'] = 'Prikaži sve kontakt osobe';
$string['tilesshowallcontactsdesc'] = 'Prikažite sve kontakt osobe na kursu ili samo jednu.';
$string['tilesshowcontacts'] = 'Prikaži osobe na kursu zadužene za kontakt';
$string['tilesshowcontactsdesc'] = 'Prikaži / sakrij osobe na kursu zadužene za kontakt.';
$string['togglenavigation'] = 'Uključi/isključi navigaciju';
$string['toolsmenu'] = 'Padajući meni \'Alati';
$string['toolsmenudesc'] = 'Dodajte padajući meni u glavnu navigacionu traku';
$string['toolsmenufield'] = 'Naziv prilagođenog polja profila=vrednost (opciono)';
$string['toolsmenufielddesc'] = 'Dodajte pravilo pristupa koristeći prilagođeno polje profila, npr: usertype=student.';
$string['toolsmenuheading'] = 'Meni \'Alati\'';
$string['toolsmenuheadingdesc'] = 'Možete da konfigurišete linkove u okviru menija \'Alati\' (u glavnoj navigacionoj traci. Format je sličan onom koji se koristi za Moodle prilagođene menije, ali vam omogućava da uz stavke menija dodate Font Awesome ikonice:
<pre>
&lt;span class=&quot;fa fa-video-camera&quot;&gt;&lt;/span&gt; Record Screen|http://google.co.uk|Record Screen
&lt;span class=&quot;fa fa-picture-o&quot;&gt;&lt;/span&gt; ThinkStock|http://google.co.uk|ThinkStock
&lt;span class=&quot;fa fa-clock-o&quot;&gt;&lt;/span&gt; Exam Clock|http://google.co.uk|Exam Clock
</pre><br />';
$string['toolsmenuheadingindex'] = 'Meni \'Alati\' {$a}';
$string['toolsmenuscount'] = 'Broj menija \'Alati\'';
$string['toolsmenuscountdesc'] = 'Podesite broj menija \'Alati\' koje želite da dodate u glavnu navigacionu traku';
$string['toolsmenutitle'] = 'Naslov menija \'Alati\'';
$string['toolsmenutitledefault'] = 'Alati';
$string['toolsmenutitledesc'] = 'Dodajte naslov menija koji želite da prikažete na glavnoj navigacijionoj traci.';
$string['topicsweeks'] = 'Tematski/Sedmični format kursa';
$string['topicsweeksdesc'] = 'Podesite stilove za Tematski/Sedmični format kursa';
$string['topmenufontsize'] = 'Veličina fonta menija na vrhu stranice';
$string['topmenufontsizedesc'] = 'Podesite veličinu fonta menija na vrhu stranice.';
$string['topmenuscount'] = 'Broj menija na vrhu stranice';
$string['topmenuscountdesc'] = 'Podesite broj menija na vrhu stranice koje želite da dodate u navigacionu traku.';
$string['turngradereditingoff'] = 'Isključite uređivanje ocenjivača';
$string['turngradereditingon'] = 'Uključite uređivanje ocenjivača';
$string['usermenu'] = 'Korisnički meni';
$string['usernameposition'] = 'Pozicija korisničkog imena';
$string['usernamepositiondesc'] = 'Podesite poziciju korisničkog imena, \'Levo\' ili \'Desno\'.';
$string['usernav'] = 'Zaglavlje - korisnički meni';
$string['usernavdesc'] = 'Omogućava vam da kontrolišete sve elemente koji se pojavljuju u korisničkom padajućem meniju.';
$string['usernavheading'] = 'Prilagodite korisnički padajući meni za navigaciju';
$string['usernodescription'] = 'Korisnik još nije ažurirao svoj opis.';
$string['usernointerests'] = 'Korisnik još uvek nije ažurirao svoja interesovanja.';
$string['usersettings'] = 'Korisnički profil';
$string['usersettingsdesc'] = 'Konfigurišite podešavanja za korisnički profil.';
$string['usersettingsheading'] = 'Podešavanja korisničkog profila';
$string['versionalpha'] = 'Alfa verzija - gotovo sigurno sadrži greške. Ovo je razvojna verzija samo za programere! Nemojte ni pomišljati na instaliranje na produkcionom serveru!';
$string['versionbeta'] = 'Beta verzija – verovatno sadrži greške. Spremno za testiranje od strane administratora samo na test serveru.';
$string['versioninfo'] = 'Izdanje {$a->release}, verzija {$a->version} na Moodleu {$a->moodle}';
$string['versionrc'] = 'RC (Release candidate) verzija - može da sadrži greške. Proverite na test serveru pre nego što dodatak instalirate na svom produkcionom serveru.';
$string['versionstable'] = 'Stabilna verzija – može da sadrži greške jer u univerzumu nije ostalo dovoljno vremena da sve budu pronađene. Proverite prvo na test serveru, pre nego što temu instalirate na svom produkcioni server, ozbiljno! Nećete požaliti i moći ćete sve da prilagodite dok ne budete zadovoljni, a zatim upotrebite funkciju \'Uvoz/izvoz podešavanja\' kako biste preneli sva podešavanja.';
$string['wide'] = 'Prikaz preko celog ekrana';
