<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'moodle', language 'sl', version '4.1'.
 *
 * @package     moodle
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['abouttobeinstalled'] = 'bo nameščeno';
$string['accept'] = 'Sprejmi';
$string['action'] = 'Ukaz';
$string['actionchoice'] = 'Kaj želite narediti z datoteko »{$a}«?';
$string['actions'] = 'Ukazi';
$string['actionsfor'] = 'Dejanja za {$a}';
$string['actionsmenu'] = 'Meni dejanj';
$string['active'] = 'Dejavno';
$string['activeusers'] = 'Dejavni uporabniki';
$string['activities'] = 'Dejavnosti';
$string['activities_help'] = 'Dejavnosti, kot so forumi, kvizi in wiki, omogočajo dodajanje interaktivnih vsebin v učilnice.';
$string['activity'] = 'Dejavnost';
$string['activityclipboard'] = 'Premikanje dejavnosti: {$a}';
$string['activityheader'] = 'Meni dejavnosti';
$string['activityicon'] = 'Ikona {$a}';
$string['activityiscurrentlyhidden'] = 'Žal je ta dejavnost trenutno skrita';
$string['activitymodule'] = 'Modul dejavnosti';
$string['activitymodules'] = 'Moduli dejavnosti';
$string['activitynotready'] = 'Dejavnost še ni pripravljena';
$string['activityreport'] = 'Poročilo o dejavnosti';
$string['activityreports'] = 'Poročila o dejavnostih';
$string['activityselect'] = 'Izberite to dejavnost, da jo premaknete drugam';
$string['activitysince'] = 'Dejavnosti od {$a}';
$string['activitytypetitle'] = '{$a->activity} - {$a->type}';
$string['activityweighted'] = 'Dejavnosti po uporabnikih';
$string['add'] = 'Dodaj';
$string['addactivity'] = 'Dodaj dejavnost ...';
$string['addactivitytosection'] = 'Dodajte dejavnost v odsek \'{$a}\'';
$string['addadmin'] = 'Dodaj skrbnika';
$string['addblock'] = 'Dodaj blok';
$string['addcomment'] = 'Dodaj komentar ...';
$string['addcondition'] = 'Dodaj pogoj';
$string['addcountertousername'] = 'Ustvari uporabnika z dodajanjem številke k uporabniškemu imenu';
$string['addcreator'] = 'Dodaj ustvarjalca predmetov';
$string['adddots'] = 'Dodaj ...';
$string['added'] = 'Dodan {$a}';
$string['addedtogroup'] = 'Dodan v skupino "{$a}"';
$string['addedtogroupnot'] = 'Ni dodan v skupino "{$a}"';
$string['addedtogroupnotenrolled'] = 'Ni dodan v skupino »{$a}«, ker ni vpisan v predmet';
$string['addfilehere'] = 'Sem odložite datoteke, da jih dodate na konec tega poglavja';
$string['addinganew'] = 'Dodajanje novega {$a}';
$string['addinganewto'] = 'Dodajanje novega {$a->what} v {$a->to}';
$string['addingdatatoexisting'] = 'Dodajanje podatkov v obstoječe';
$string['additionalcustomnav'] = 'Dodatna prilagojena navigacija';
$string['additionalnames'] = 'Dodatna imena';
$string['addlinkhere'] = 'Tukaj dodaj povezavo';
$string['addnew'] = 'Dodaj novo {$a}';
$string['addnewcategory'] = 'Dodaj novo kategorijo';
$string['addnewcourse'] = 'Dodaj nov predmet';
$string['addnewuser'] = 'Dodaj novega uporabnika';
$string['addnousersrecip'] = 'Dodaj uporabnike, ki niso dostopali do tega {$a}, na seznam prejemnikov';
$string['addpagehere'] = 'Dodaj besedilo tukaj';
$string['addresource'] = 'Dodaj vir ...';
$string['addresourceoractivity'] = 'Dodaj dejavnost ali vir';
$string['addresourcetosection'] = 'Dodaj vir v odsek \'{$a}\'';
$string['address'] = 'Naslov';
$string['addsections'] = 'Dodaj odseke';
$string['addstudent'] = 'Dodaj udeleženca';
$string['addsubcategory'] = 'Dodaj podkategorijo';
$string['addteacher'] = 'Dodaj učitelja';
$string['admin'] = 'Skrbnik';
$string['adminhelpaddnewuser'] = 'Za ročno ustvarjanje novega uporabniškega računa';
$string['adminhelpassignadmins'] = 'Skrbniki lahko naredijo vse in gredo kamorkoli na spletnem mestu';
$string['adminhelpassigncreators'] = 'Ustvarjalci predmeta lahko ustvarijo nove predmete';
$string['adminhelpassignsiteroles'] = 'Dodeli opredeljene vloge spletnega mesta določenim uporabnikom';
$string['adminhelpassignstudents'] = 'Pojdi v predmet in dodaj udeležence v skrbniškem meniju';
$string['adminhelpauthentication'] = 'Uporabite lahko interne uporabniške račune ali zunanje zbirke podatkov';
$string['adminhelpbackup'] = 'Konfiguriraj samodejne varnostne kopije in njihov urnik';
$string['adminhelpconfiguration'] = 'Konfiguriraj videz in delovanje strani';
$string['adminhelpconfigvariables'] = 'Konfiguriraj spremenljivke, ki vplivajo na splošno delovanje strani';
$string['adminhelpcourses'] = 'Določi predmete in kategorije ter jim dodeli osebe, uredi čakajoče predmete';
$string['adminhelpeditorsettings'] = 'Določi osnovne nastavitve za HTML urejevalnik';
$string['adminhelpedituser'] = 'Prebrskaj seznam uporabniških računov in uredi kateregakoli izmed njih';
$string['adminhelpenvironment'] = 'Preverite, kako vaš strežnik ustreza trenutnim in bodočim zahtevam namestitve';
$string['adminhelpfailurelogs'] = 'Prebrskaj dnevnike neuspešnih prijav';
$string['adminhelplanguage'] = 'Za preverjanje in urejanje trenutnega jezikovnega paketa';
$string['adminhelplogs'] = 'Prebrskaj dnevnike vseh dejavnosti na tem spletnem mestu';
$string['adminhelpmanageblocks'] = 'Upravljaj nameščene bloke in njihove nastavitve';
$string['adminhelpmanagedatabase'] = 'Neposredno dostopajte do podatkovne baze (bodite previdni!)';
$string['adminhelpmanagefilters'] = 'Izberi filtre besedil in njihove nastavitve';
$string['adminhelpmanagemodules'] = 'Upravljaj nameščene module in njihove nastavitve';
$string['adminhelpmanageroles'] = 'Ustvari in opredeli vloge, ki se jih lahko določi uporabnikom';
$string['adminhelpmymoodle'] = 'Konfiguriraj bloke Moj Moodle za uporabnike';
$string['adminhelpreports'] = 'Poročila na ravni spletnega mesta';
$string['adminhelpsitefiles'] = 'Za objavo splošnih datotek ali nalaganje zunanjih varnostnih kopij';
$string['adminhelpsitesettings'] = 'Določi videz naslovne strani spletnega mesta';
$string['adminhelpstickyblocks'] = 'Konfiguriraj lepljive bloke za celoten Moodle';
$string['adminhelpthemes'] = 'Izberi videz strani (barve, pisave itd.)';
$string['adminhelpuploadusers'] = 'Uvozite nove uporabniške račune iz besedilne datoteke';
$string['adminhelpusers'] = 'Določite vaše uporabnike in nastavite avtentikacije';
$string['adminhelpxmldbeditor'] = 'Vmesnik za urejanje XMLDB datotek. Samo za razvijalce.';
$string['administration'] = 'Skrbništvo';
$string['administrationsite'] = 'Skrbništvo spletnega mesta';
$string['administrator'] = 'Skrbnik';
$string['administratordescription'] = 'Skrbniki lahko ponavadi naredijo karkoli na spletnem mestu, v vseh predmetih.';
$string['administrators'] = 'Skrbniki';
$string['administratorsall'] = 'Vsi skrbniki';
$string['administratorsandteachers'] = 'Skrbniki in učitelji';
$string['advanced'] = 'Napredno';
$string['advancedfilter'] = 'Napredno iskanje';
$string['advancedsettings'] = 'Napredne nastavitve';
$string['afterresource'] = 'Po viru "{$a}"';
$string['aftersection'] = 'Za odsekom "{$a}"';
$string['again'] = 'ponovno';
$string['agelocationverification'] = 'Preverjanje starosti in lokacije';
$string['aimid'] = 'AIM ID';
$string['ajaxuse'] = 'AJAX in Javascript';
$string['all'] = 'Vse';
$string['allactions'] = 'Vsa dejanja';
$string['allactivities'] = 'Vse dejavnosti';
$string['allcategories'] = 'Vse kategorije';
$string['allchanges'] = 'Vse spremembe';
$string['alldays'] = 'Vsi dnevi';
$string['allfiles'] = 'Vse datoteke';
$string['allgroups'] = 'Vse skupine';
$string['alllogs'] = 'Vsi dnevniki';
$string['allmods'] = 'Vsi {$a}';
$string['allow'] = 'Dovoli';
$string['allowinternal'] = 'Dovoli tudi notranje načine';
$string['allownone'] = 'Ne dovoli ničesar';
$string['allownot'] = 'Ne dovoli';
$string['allowstealthmodules'] = 'Dovoli prikrite dejavnosti';
$string['allowstealthmodules_help'] = 'Če je omogočeno, lahko dejavnosti na domači strani predmeta skrijemo, a so te kljub temu dosegljive udeležencem. Povezave do prikritih dejavnosti morate dodati drugje, npr. v besedilu vira \'Spletna stran\'. Prikrite dejavnosti so prikazane v redovalnici in drugih poročilih.';
$string['allparticipants'] = 'Vsi sodelujoči';
$string['allteachers'] = 'Vsi učitelji';
$string['alphanumerical'] = 'Sme vsebovati samo alfanumerične znake, vezaj (-) ali piko (.)';
$string['alreadyconfirmed'] = 'Registracija je že potrjena';
$string['alternatename'] = 'Nadomestno ime';
$string['always'] = 'Vedno';
$string['and'] = '{$a->one} in {$a->two}';
$string['answer'] = 'Odgovor';
$string['any'] = 'Vsak';
$string['appearance'] = 'Izgled';
$string['applyfilters'] = 'Uporabi filtre';
$string['approve'] = 'Odobri';
$string['areyousure'] = 'Ste prepričani?';
$string['areyousuretorestorethis'] = 'Ali želite nadaljevati?';
$string['areyousuretorestorethisinfo'] = 'Pozneje boste imeli možnost dodajanja te varnostne kopije v obstoječ predmet ali ustvariti popolnoma nov predmet.';
$string['asc'] = 'Naraščajoče';
$string['assessment'] = 'Vrednotenje';
$string['assignadmins'] = 'Dodeli skrbnike';
$string['assigncreators'] = 'Dodeli ustvarjalce';
$string['assignedrolecount'] = '{$a->role}: {$a->count}';
$string['assignsiteroles'] = 'Dodeli vloge celotnega spletnega mesta';
$string['authenticateduser'] = 'Overjen uporabnik';
$string['authenticateduserdescription'] = 'Vsi prijavljeni uporabniki.';
$string['authentication'] = 'Preverjanje pristnosti';
$string['authenticationplugins'] = 'Vtičniki za preverjanje pristnosti';
$string['autosubscribe'] = 'Samodejno naročanje na forum';
$string['autosubscribeno'] = 'Ne: ne naroči me samodejno na razprave na forumu';
$string['autosubscribeyes'] = 'Da: ko objavim, me naroči na to razpravo na forumu';
$string['availability'] = 'Razpoložljivost';
$string['availablecourses'] = 'Predmeti na voljo';
$string['back'] = 'Nazaj';
$string['backto'] = 'Nazaj na {$a}';
$string['backtocourselisting'] = 'Nazaj na seznam predmeta';
$string['backtohome'] = 'Nazaj na prvo stran spletnega mesta';
$string['backtopageyouwereon'] = 'Nazaj na stran, kjer ste bili';
$string['backup'] = 'Varnostna kopija';
$string['backupactivehelp'] = 'Izberite, ali naj se varnostne kopije samodejno ustvarjajo ali ne.';
$string['backupadhocpending'] = 'Takojšnjo opravilo varnostnega kopiranja predmeta je v teku';
$string['backupcancelled'] = 'Varnostno kopiranje je preklicano';
$string['backupcoursefileshelp'] = 'Če je omogočeno, bodo datoteke predmeta vključene v samodejne varnostne kopije';
$string['backupdate'] = 'Datum varnostne kopije';
$string['backupdatenew'] = '&nbsp; {$a->TAG} je sedaj {$a->weekday}, {$a->mday} {$a->month} {$a->year}<br />';
$string['backupdateold'] = '{$a->TAG} je bil/a {$a->weekday}, {$a->mday} {$a->month} {$a->year}';
$string['backupdaterecordtype'] = '<br />{$a->recordtype} - {$a->recordname}<br />';
$string['backupdetails'] = 'Podrobnosti varnostnega kopiranja';
$string['backuperrorinvaliddestination'] = 'Ciljna mapa varnostne kopije ne obstaja ali vanjo ni mogoče pisati.';
$string['backupexecuteathelp'] = 'Izberite čas, ob katerem naj se izdelajo samodejne varnostne kopije.';
$string['backupfailed'] = 'Nekateri vaši predmeti niso bili shranjeni!';
$string['backupfilename'] = 'varnostna kopija';
$string['backupfinished'] = 'Varnostno kopiranje uspešno zaključeno';
$string['backupfromthissite'] = 'Je bila varnostna kopija narejena na tem spletnem mestu?';
$string['backupgradebookhistoryhelp'] = 'Če je omogočeno, bo zgodovina redovalnice vključena v samodejne varnostne kopije. Zgodovina ocen ne sme biti onemogočena v nastavitvah strežnika (disablegradehistory), če želite, da ta nastavitev deluje';
$string['backupincludemoduleshelp'] = 'Izberite, ali želite vključiti module predmetov, z uporabniškimi podatki ali brez, v samodejne varnostne kopije';
$string['backupincludemoduleuserdatahelp'] = 'Izberite, ali želite v samodejne varnostne kopije vključiti uporabniške podatke modula.';
$string['backuplogdetailed'] = 'Podroben dnevnik izvajanja';
$string['backuploglaststatus'] = 'Dnevnik zadnjega izvajanja';
$string['backupmissinguserinfoperms'] = 'Opomba: Ta varnostna kopija ne vsebuje podatkov o uporabniku. Aktivnosti Vaja in Delavnica ne bosta vključeni v varnostno kopijo, ker ta dva modula nista združljiva s to vrsto varnostne kopije.';
$string['backupnext'] = 'Naslednja varnostna kopija';
$string['backupnonisowarning'] = 'Opozorilo: ta varnostna kopija izvira iz različice Moodla brez podpore Unicode (pred 1.6). Če ta varnostna kopija vsebuje besedilo, ki ni v kodni tabeli ISO-8859-1, se besedilo lahko POŠKODUJE, če ga boste poskušali obnoviti v to različico Moodla s podporo Unicode. Oglejte si <a href="https://docs.moodle.org/en/Backup_FAQ">Pogosta vprašanja o varnostnem kopiranju</a> za več informacij o tem kako pravilno obnoviti to varnostno kopijo.';
$string['backupnotyetrun'] = 'Samodejna varnostna kopija je v čakanju';
$string['backuporiginalname'] = 'Ime varnostne kopije';
$string['backuproleassignments'] = 'Varnostno kopiranje vloge naloge za te vloge';
$string['backupsavetohelp'] = 'Celotna pot do mape, kamor želite shraniti datoteke varnostne kopije';
$string['backupsitefileshelp'] = 'Če je omogočeno, bodo datoteke spletnega mesta, ki so v uporabi v predmetih, vključene v samodejne varnostne kopije';
$string['backuptakealook'] = 'Prosimo, oglejte si vaše dnevnike varnostnega kopiranja v:
 {$a}';
$string['backupuserfileshelp'] = 'Izberite, ali naj se uporabniške datoteke (npr. slike profila) vključijo v samodejne varnostne kopije';
$string['backupversion'] = 'Različica varnostne kopije';
$string['badges'] = 'Priznanja';
$string['block'] = 'Blokiraj';
$string['blockconfiga'] = 'Konfiguriranje bloka {$a}';
$string['blockconfigbad'] = 'Ta blok ni bil pravilno narejen, zato ne more zagotoviti vmesnika za konfiguriranje.';
$string['blocks'] = 'Bloki';
$string['blocksaddedit'] = 'Dodaj/Uredi bloke';
$string['blockseditoff'] = 'Izključi urejanje blokov';
$string['blocksediton'] = 'Vključi urejanje blokov';
$string['blocksetup'] = 'Nastavitev tabel blokov';
$string['blocksuccess'] = '{$a} tabele so nastavljene pravilno';
$string['brief'] = 'Kratko';
$string['bulkactions'] = 'Paketna dejanja';
$string['bulkactionselect'] = 'Izbor paketnih dejanj {$a}';
$string['bulkmovecoursessuccess'] = '{$a->courses} predmetov uspešno premaknjenih v kategorijo {$a->category}';
$string['bycourseorder'] = 'Po vrstnem redu predmetov';
$string['byname'] = 'po {$a}';
$string['bypassed'] = 'Preskočeno';
$string['cachecontrols'] = 'Nadzor predpomnilnika';
$string['calltofeedback'] = 'Ustvarjalci te programske opreme bi želeli vašo povratno informacijo.';
$string['calltofeedback_give'] = 'Podajte povratno informacijo o tej programski opremi';
$string['calltofeedback_remind'] = 'Opomni me pozneje';
$string['cancel'] = 'Prekliči';
$string['cancelled'] = 'Preklicano';
$string['categories'] = 'Kategorije predmetov';
$string['categoriesandcourses'] = 'Kategorije predmetov in predmeti';
$string['category'] = 'Kategorija';
$string['categoryadded'] = 'Kategorija \'{$a}\' je bila dodana';
$string['categorybulkaction'] = 'Paketna dejanja za izbrane kategorije';
$string['categorycontents'] = 'Podkategorije in predmeti';
$string['categorycurrentcontents'] = 'Vsebina {$a}';
$string['categorydeleted'] = 'Kategorija \'{$a}\' je bila izbrisana';
$string['categoryduplicate'] = 'Kategorija z imenom \'{$a}\' že obstaja!';
$string['categoryheader'] = 'Meni kategorije';
$string['categoryhidden'] = '(skrito)';
$string['categorymodifiedcancel'] = 'Kategorija je bila spremenjena. Prekličite in poskusite ponovno.';
$string['categoryname'] = 'Ime kategorije';
$string['categorypath'] = 'Pot kategorije';
$string['categorysubcategoryof'] = '{$a->category} – podkategorija kategorije {$a->parentcategory}';
$string['categoryupdated'] = 'Kategorija \'{$a}\' je posodobljena';
$string['changedpassword'] = 'Spremenjeno geslo';
$string['changepassword'] = 'Spremeni geslo';
$string['changesmade'] = 'Opravljene spremembe';
$string['changesmadereallygoaway'] = 'Naredili ste spremembe. Ste prepričani, da želite stran zapustiti in izgubiti spremembe?';
$string['changessaved'] = 'Spremembe so shranjene';
$string['check'] = 'Preveri';
$string['checkactual'] = 'Dejanski';
$string['checkall'] = 'Preveri vse';
$string['checkexpected'] = 'Pričakovan';
$string['checkingbackup'] = 'Preverjanje varnostne kopije';
$string['checkingcourse'] = 'Preverjanje predmeta';
$string['checkingforbbexport'] = 'Preverjanje za izvoz BlackBoard';
$string['checkinginstances'] = 'Preverjanje elementov';
$string['checkingsections'] = 'Preverjanje odsekov';
$string['checklanguage'] = 'Preveri jezik';
$string['checknone'] = 'Ne preveri ničesar';
$string['checks'] = 'Preverjanja';
$string['checksok'] = 'Vsa preverjanja \'{$a}\' so bila uspešna';
$string['childcoursenotfound'] = 'Podrejenega predmeta ni mogoče najti!';
$string['childcourses'] = 'Podrejeni predmeti';
$string['choose'] = 'Izberi';
$string['choosecourse'] = 'Izberi predmet';
$string['choosedots'] = 'Izberi ...';
$string['chooselivelogs'] = 'Ali spremljaj trenutno dejavnost';
$string['chooselogs'] = 'Izberite dnevnik, ki ga želite videti';
$string['choosereportfilter'] = 'Izberite filter za poročilo';
$string['choosetheme'] = 'Izberite temo';
$string['chooseuser'] = 'Izberite uporabnika';
$string['city'] = 'Mesto/kraj';
$string['cleaningtempdata'] = 'Čiščenje začasnih podatkov';
$string['clear'] = 'Počisti';
$string['clearfilterrow'] = 'Odstrani vrstico s filtri';
$string['clearfilters'] = 'Počisti filtre';
$string['clearsearch'] = 'Počisti iskalni vnos';
$string['clickhelpiconformoreinfo'] = '... se nadaljuje ... Za branje celotnega članka kliknite na ikono pomoči';
$string['clickhere'] = 'Klikni tu ...';
$string['clicktochangeinbrackets'] = '{$a} (Klikni za spremembo)';
$string['clicktohideshow'] = 'Klikni za razširitev ali skrčenje';
$string['closeblockdrawer'] = 'Zapri predal blokov';
$string['closebuttontitle'] = 'Zapri';
$string['closecourseindex'] = 'Zapri kazalo predmeta';
$string['closedrawer'] = 'Zapri predal';
$string['closewindow'] = 'Zapri okno';
$string['collapse'] = 'Skrči';
$string['collapseall'] = 'Skrči vse';
$string['collapsecategory'] = 'Skrči {$a}';
$string['comebacklater'] = 'Vrnite se kasneje';
$string['commentincontext'] = 'Najdi ta komentar v kontekstu';
$string['comments'] = 'Komentarji';
$string['commentscount'] = 'Komentarji ({$a})';
$string['commentsnotenabled'] = 'Funkcija komentarjev ni omogočena';
$string['commentsrequirelogin'] = 'Za ogled komentarjev se morate prijaviti.';
$string['comparelanguage'] = 'Primerjaj in uredi trenuten jezik';
$string['complete'] = 'Zaključeno';
$string['completed'] = 'Dokončano';
$string['completereport'] = 'Celotno poročilo';
$string['configuration'] = 'Konfiguracija';
$string['confirm'] = 'Potrdi';
$string['confirmcheckfull'] = 'Ali ste popolnoma prepričani, da želite potrditi {$a}?';
$string['confirmcoursemove'] = 'Ste prepričani, da želite premakniti predmet ({$a->course}) v kategorijo ({$a->category})?';
$string['confirmdeletesection'] = 'Ste povsem prepričani, da želite popolnoma izbrisati »{$a}« in vse dejavnosti, ki jih vsebuje?';
$string['confirmed'] = 'Vaša registracija je bila potrjena';
$string['confirmednot'] = 'Vaša registracija še ni bila potrjena. Prosimo preglejte vaš e-poštni nabiralnik za potrditveno sporočilo.';
$string['considereddigitalminor'] = 'Ste premladi, da bi lahko na tej strani ustvarili uporabniški račun.';
$string['content'] = 'Vsebina';
$string['contentbank'] = 'Zbirka vsebin';
$string['contentexport_aboutthiscourse'] = 'Povzetek predmeta';
$string['contentexport_coursesummary'] = 'Ta datoteka je del vsebine, prenešene iz <a href="{$a->courselink}">{$a->coursename}</a>.';
$string['contentexport_footersummary'] = 'Ta datoteka je del vsebine, ki jo je iz <a href="{$a->courselink}">{$a->coursename}</a> prenesel {$a->userfullname} dne {$a->date}.';
$string['contentexport_modulesummary'] = 'Ta stran je del vsebine, prenešene iz <a href="{$a->modulelink}">{$a->modulename}</a> on {$a->date}. Pomni, da nekatera vsebina in vse datoteke, večje od {$a->maxfilesize}, niso prenešene.';
$string['contentexport_viewfilename'] = 'Ogled datoteke {$a}';
$string['context'] = 'Kontekst';
$string['contexturl'] = 'URL konteksta';
$string['continue'] = 'Nadaljuj';
$string['continuetocourse'] = 'Kliknite tu za vstop v vaš predmet';
$string['convertingwikitomarkdown'] = 'Pretvorba Wiki v Markdown';
$string['cookiesenabled'] = 'Piškotki morajo biti omogočeni v vašem brskalniku';
$string['cookiesenabled_help'] = 'To mesto uporablja dva piškotka.

Bistven je piškotek seje, ki se običajno imenuje MoodleSession. Temu piškotku morate dovoliti v vaš brskalnik, da zagotovite stalnost in ohranite vašo prijavo iz strani na stran. Ko se odjavite ali zaprete brskalnik, se ta piškotek uniči (v vašem brskalniku in na strežniku).

Drug piškotek je zgolj za udobje in se običajno imenuje nekaj podobnega kot MOODLEID. Zapomni si vaše uporabniško ime v brskalniku. To pomeni, da bo ob vaši vrnitvi na to stran polje uporabniško ime na prijavni strani že izpolnjeno za vas. Varno lahko zavrnete ta piškotek - potem boste morali samo vsakič ponovno vnesti svoje uporabniško ime ob prijavi.';
$string['cookiesenabled_help_html'] = 'To spletno mesto uporablja dva piškotka</br></br>:

Bistven je piškotek seje, ki se običajno imenuje MoodleSession. Temu piškotku morate dovoliti v vaš brskalnik, da zagotovite stalnost in ohranite vašo prijavo iz strani na stran. Ko se odjavite ali zaprete brskalnik, se ta piškotek uniči (v vašem brskalniku in na strežniku).</br></br>

Drug piškotek je zgolj za udobje in se običajno imenuje nekaj podobnega kot MOODLEID.  Zapomni si vaše uporabniško ime v brskalniku. To pomeni, da bo ob vaši vrnitvi na to stran polje uporabniško ime na prijavni strani že izpolnjeno za vas. Varno lahko zavrnete ta piškotek - potem boste morali samo vsakič ponovno vnesti svoje uporabniško ime ob prijavi.';
$string['cookiesenabledonlysession'] = 'Piškotki morajo biti omogočeni v vašem brskalniku';
$string['cookiesenabledonlysession_help'] = 'To spletno mesto uporablja en piškotek seje, ki se običajno imenuje MoodleSession. Ta piškotek morate dovoliti v vašem brskalniku, da zagotovite stalnost in ostanete prijavljeni, medtem ko brskate po strani. Ko se odjavite ali zaprete brskalnik, je ta piškotek uničen (v vašem brskalniku in na strežniku).';
$string['cookiesnotenabled'] = 'Žal trenutno piškotki v vašem brskalniku niso omogočeni';
$string['cookiesnotice'] = 'Obvestilo o piškotkih';
$string['copy'] = 'kopiraj';
$string['copyasnoun'] = 'kopiraj';
$string['copycourse'] = 'Kopiraj predmet';
$string['copyingcoursefiles'] = 'Kopiranje datotek predmeta';
$string['copyingsitefiles'] = 'Kopiranje datotek spletnega mesta, ki so v uporabi v predmetu';
$string['copyinguserfiles'] = 'Kopiranje uporabniških datotek';
$string['copyingzipfile'] = 'Kopiranje stisnjenih datotek';
$string['copyrightnotice'] = 'Obvestilo o avtorskih pravicah';
$string['coresystem'] = 'Sistem';
$string['cost'] = 'Cena';
$string['costdefault'] = 'Privzeta cena';
$string['counteditems'] = '{$a->count} {$a->items}';
$string['country'] = 'Država';
$string['course'] = 'Predmet';
$string['courseadministration'] = 'Skrbništvo predmeta';
$string['courseapprovedemail'] = 'Vaš zahtevani predmet, {$a->name}, je bil odobren in postali ste {$a->teacher}. Za dostop do predmeta pojdite na {$a->url}';
$string['courseapprovedemail2'] = 'Vaš zahtevani predmet, {$a->name}, je odobren. Za dostop do predmeta pojdite na {$a->url}';
$string['courseapprovedfailed'] = 'Shranjevanje predmeta kot odobrenega ni uspelo!';
$string['courseapprovedsubject'] = 'Vaš predmet je odobren!';
$string['courseavailable'] = 'Ta predmet je na voljo udeležencem';
$string['courseavailablenot'] = 'Ta predmet ni na voljo udeležencem';
$string['coursebackup'] = 'Varnostna kopija predmeta';
$string['coursebulkaction'] = 'Paketna dejanja za izbrane predmete';
$string['coursecategories'] = 'Kategorije predmetov';
$string['coursecategory'] = 'Kategorija predmeta';
$string['coursecategory_help'] = 'Ta nastavitev določa kategorijo, v kateri se bo predmet pojavil na seznamu predmetov.';
$string['coursecategorydeleted'] = 'Izbrisana kategorija predmetov {$a}';
$string['coursecatmanagement'] = 'Upravljanje predmetov in kategorij';
$string['coursecompletion'] = 'Zaključevanje predmeta';
$string['coursecompletions'] = 'Zaključek predmeta';
$string['coursecreators'] = 'Ustvarjalec predmeta';
$string['coursecreatorsdescription'] = 'Ustvarjalci predmeta lahko ustvarjajo nove predmete.';
$string['coursedeleted'] = 'Izbrisan predmet {$a}';
$string['coursedetails'] = 'Podrobnosti predmeta';
$string['coursedisplay'] = 'Postavitev predmeta';
$string['coursedisplay_help'] = 'Poglavja predmeta so lahko vsa prikazana na eni strani ali razdeljena na več strani.';
$string['coursedisplay_multi'] = 'Prikaži en odsek na stran';
$string['coursedisplay_single'] = 'Prikaži vse odseke na eni strani';
$string['courseduration'] = 'Trajanje predmeta';
$string['courseduration_desc'] = 'Trajanje predmeta se uporabi za preračunavanje privzetega datuma zaključka predmeta. Datum zaključka predmeta se uporabi za odločanje za vključitev predmeta v uporabnikov seznam predmetov. Uporabniki lahko po datumu zaključka predmeta še vedno vstopajo v predmet.';
$string['courseenddateenabled'] = 'Datum zaključka predmeta privzeto omogočen';
$string['courseenddateenabled_desc'] = 'Ta nastavitev določa, ali bo datum zaključka predmeta privzeto omogočen za nove predmete in nastavljen na datum, izračunan na podlagi trajanja predmeta.';
$string['courseextendednamedisplay'] = '{$a->shortname} {$a->fullname}';
$string['coursefiles'] = 'Podedovane datoteke predmeta';
$string['coursefilesedit'] = 'Uredi podedovane datoteke predmeta';
$string['coursefileswarning'] = 'Datoteke predmeta so opuščene';
$string['coursefileswarning_help'] = 'Datoteke predmeta so opuščene od različice Moodla 2.0 naprej. Priporočamo uporabo zunanjih skladišč.';
$string['courseformatdata'] = 'Podatki o obliki predmeta';
$string['courseformatoptions'] = 'Možnosti oblikovanja za {$a}';
$string['courseformats'] = 'Oblike predmeta';
$string['courseformatudpate'] = 'Posodobite obliko';
$string['coursegrades'] = 'Ocene predmeta';
$string['courseheader'] = 'Meni predmeta';
$string['coursehelpcategory'] = 'Določite položaj predmeta na seznamu predmetov, da ga bodo udeleženci lažje našli.';
$string['coursehelpforce'] = 'Vsili način skupin za vsako dejavnost v predmetu.';
$string['coursehelpformat'] = 'Glavna stran predmeta bo prikazana v tej obliki.';
$string['coursehelphiddensections'] = 'Kako so skriti odseki v predmetu prikazani udeležencem.';
$string['coursehelpmaximumupload'] = 'Določite največjo velikost datoteke, ki je lahko naložena v predmet in omejena z nastavitvijo na celotnem spletnem mestu.';
$string['coursehelpnewsitemsnumber'] = 'Število nedavnih obvestil, ki se pojavijo v bloku zadnjih novic na prvi strani predmeta. Če je nastavljeno na nič, pomeni, da se blok novic ne bo pojavil.';
$string['coursehelpnumberweeks'] = 'Število odsekov v predmetu (v uporabi le pri nekaterih formatih predmeta).';
$string['coursehelpshowgrades'] = 'Omogoči prikaz redovalnice. To ne preprečuje prikaza ocen za posamezne dejavnosti.';
$string['coursehidden'] = 'Ta predmet trenutno ni na voljo udeležencem';
$string['courseinfo'] = 'Informacije o predmetu';
$string['courselegacyfiles'] = 'Podedovane datoteke predmeta';
$string['courselegacyfiles_help'] = 'Mesto datotek predmeta zagotavlja delno povratno združljivost z Moodle 1.9 in prejšnjimi različicami. Vse datoteke na tem mestu so vedno dostopne vsem udeležencem predmeta (če ustvarite povezavo do njih ali pa ne). Ni mogoče izvedeti, ali so te datoteke uporabljene kjerkoli v Moodlu.

Če uporabljate to mesto za shranjevanje datotek predmeta, se lahko pojavijo številne težave v zvezi z zasebnostjo in varnostjo, kot tudi morebitne manjkajoče datoteke varnostnih kopij, uvoženih predmetov ali vsakič, ko je vsebina deljena ali ponovno uporabljena. Zato je priporočljivo, da tega mesta ne uporabljate za shranjevanje, razen če zagotovo veste, kaj počnete.';
$string['courselegacyfiles_link'] = 'coursefiles2';
$string['courselegacyfilesofcourse'] = 'Podedovane datoteke predmeta: {$a}';
$string['coursenotaccessible'] = 'Ta predmet ne dovoljuje javnega dostopa';
$string['courseoverview'] = 'Pregled predmeta';
$string['courseoverviewfiles'] = 'Slika predmeta';
$string['courseoverviewfiles_help'] = 'Slika predmeta je prikazana na strani Moji predmeti. Skrbnik spletnega mesta lahko odobri dodatne vrste datotek in uporabo večih datotek. V primeru uporabe večih datotek bodo te, na strani seznama predmetov, prikazane poleg povzetka predmeta.';
$string['courseoverviewfilesext'] = 'Končnice datoteke za sliko predmeta';
$string['courseoverviewfileslimit'] = 'Omejitev števila datotek za sliko predmeta';
$string['courseoverviewgraph'] = 'Graf pregleda predmeta';
$string['coursepreferences'] = 'Nastavitve predmeta';
$string['courseprofiles'] = 'Profili predmeta';
$string['coursereasonforrejecting'] = 'Vaši razlogi za zavrnitev te zahteve';
$string['coursereasonforrejectingemail'] = 'To bo po e-pošti poslano osebi, ki je zahtevala predmet';
$string['coursereject'] = 'Zavrnite zahtevo za predmet';
$string['courserejected'] = 'Predmet je bil zavrnjen. Kdor ga je zahteval, je bil o tem obveščen.';
$string['courserejectemail'] = 'Predmet, ki ste ga zahtevali, je zavrnjen. Tu so našteti razlogi:

{$a}';
$string['courserejectreason'] = 'Naštejte razloge za zavrnitev tega predmeta<br />(to bo poslano osebi, ki je predmet zahtevala)';
$string['courserejectsubject'] = 'Vaš predmet je zavrnjen';
$string['coursereport'] = 'Poročilo predmeta';
$string['coursereports'] = 'Poročila predmeta';
$string['courserequest'] = 'Zahteva za predmet';
$string['courserequestdetails'] = 'Podrobnosti o predmetu, ki ga zahtevate';
$string['courserequestfailed'] = 'Vaše zahteve za predmet ni bilo mogoče shraniti';
$string['courserequestintro'] = 'Uporabite ta obrazec za zahtevo predmeta, ki naj bo ustvarjen za vas.<br />Poskusite vnesti čim več informacij, da bo<br />skrbnik razumel, zakaj želite ta predmet.';
$string['courserequestreason'] = 'Zakaj želite ta predmet';
$string['courserequestsuccess'] = 'Zahteva za predmet je bila oddana.';
$string['courserequestsupport'] = 'Dodatne informacije, ki skrbniku pomagajo pri obravnavi zahteve';
$string['courserequestwarning'] = 'Uporabnik, ki zahteva ta predmet, bo samodejno vpisan in mu bo dodeljena vloga {$a}.';
$string['courserestore'] = 'Obnavljanje predmeta';
$string['coursereuse'] = 'Ponovna uporaba predmeta';
$string['courses'] = 'Predmeti';
$string['coursesearch'] = 'Išči predmete';
$string['coursesearch_help'] = 'Iščete lahko več besed hkrati in iščete podrobneje na sledeči način:

* beseda - najdi katerokoli ujemanje te besede v besedilu.n* +beseda – najdene bodo samo točno ujemajoče se besede.
* -beseda – ne vključi rezultatov, ki vsebujejo to besedo.';
$string['coursesectionsummaries'] = 'Povzetki odsekov predmeta';
$string['coursesectiontitle'] = '{$a->sectionname}: {$a->sectiontitle} | {$a->course}';
$string['coursesectiontitleediting'] = 'Uredi {$a->sectionname}: {$a->sectiontitle} | {$a->course}';
$string['coursesettings'] = 'Privzete nastavitve predmeta';
$string['coursesmovedout'] = 'Predmeti so bili premaknjeni iz {$a}';
$string['coursespending'] = 'Predmeti, ki čakajo na odobritev';
$string['coursestart'] = 'Začetek predmeta';
$string['coursesummary'] = 'Povzetek predmeta';
$string['coursesummary_help'] = 'Kratek opis vašega predmeta. Vsebina, ki jo dodate sem, je vključena v iskalnik.';
$string['coursetitle'] = 'Predmet: {$a->course}';
$string['courseupdates'] = 'Posodobitve predmeta';
$string['coursevisibility'] = 'Vidnost predmeta';
$string['coursevisibility_help'] = '* Prikaži: predmet se prikaže na seznamu predmetov in je na voljo udeležencem.
* Skrij: Dostop je omejen na učitelje in druge uporabnike z zmožnostjo ogleda skritih predmetov.';
$string['create'] = 'Ustvari';
$string['createaccount'] = 'Ustvari moj novi račun';
$string['createcategory'] = 'Ustvari kategorijo';
$string['createfolder'] = 'Ustvari mapo v {$a}';
$string['createnew'] = 'Ustvari novo';
$string['createnewcategory'] = 'Ustvari novo kategorijo';
$string['createnewcourse'] = 'Ustvari nov predmet';
$string['createnewsubcategory'] = 'Ustvari novo podkategorijo';
$string['createsubcategoryof'] = 'Ustvari podkategorijo {$a}';
$string['createuser'] = 'Ustvari uporabnika';
$string['createuserandpass'] = 'Izberite svoje uporabniško ime in geslo';
$string['createziparchive'] = 'Ustvari prenešeno mapo';
$string['creatingblocks'] = 'Ustvarjanje blokov';
$string['creatingblocksroles'] = 'Ustvarjanje dodelitve vlog in prednosti na nivoju blokov';
$string['creatingblogsinfo'] = 'Ustvarjanje informacij o blogih';
$string['creatingcategoriesandquestions'] = 'Ustvarjanje kategorij in vprašanj';
$string['creatingcoursemodules'] = 'Ustvarjanje modulov predmeta';
$string['creatingcourseroles'] = 'Ustvarjanje dodelitve vlog in prednosti na ravni predmetov';
$string['creatingevents'] = 'Ustvarjanje dogodkov';
$string['creatinggradebook'] = 'Ustvarjanje redovalnice';
$string['creatinggroupings'] = 'Ustvarjanje skupkov';
$string['creatinggroupingsgroups'] = 'Dodajanje skupin v skupke';
$string['creatinggroups'] = 'Ustvarjanje skupin';
$string['creatinglogentries'] = 'Ustvarjanje dnevniških zapiskov';
$string['creatingmessagesinfo'] = 'Ustvarjanje informacij o sporočilih';
$string['creatingmodroles'] = 'Ustvarjanje dodelitve vlog in prednosti na nivoju modulov';
$string['creatingnewcourse'] = 'Ustvarjanje novega predmeta';
$string['creatingrolesdefinitions'] = 'Ustvarjanje definicij vlog';
$string['creatingscales'] = 'Ustvarjanje lestvic';
$string['creatingsections'] = 'Ustvarjanje odsekov';
$string['creatingtemporarystructures'] = 'Ustvarjanje začasnih struktur';
$string['creatinguserroles'] = 'Ustvarjanje dodelitve vlog in prednosti na nivoju uporabnikov';
$string['creatingusers'] = 'Ustvarjanje uporabnikov';
$string['creatingxmlfile'] = 'Ustvarjanje datoteke XML';
$string['currency'] = 'Valuta';
$string['currentcourse'] = 'Trenutni predmet';
$string['currentcourseadding'] = 'Dodajanje podatkov v trenutni predmet';
$string['currentcoursedeleting'] = 'Brisanje trenutnega predmeta';
$string['currentlanguage'] = 'Trenutni jezik';
$string['currentlocaltime'] = 'vaš trenutni lokalni čas';
$string['currentpicture'] = 'Trenutna slika';
$string['currentrelease'] = 'Informacije o trenutni izdaji';
$string['currentversion'] = 'Trenutna različica';
$string['databasechecking'] = 'Nadgradnja podatkovne zbirke Moodla z različice {$a->oldversion} v {$a->newversion}';
$string['databaseperformance'] = 'Učinkovitost delovanja zbirke podatkov';
$string['databasesetup'] = 'Nastavitev zbirke podatkov';
$string['databasesuccess'] = 'Zbirka podatkov je uspešno nadgrajena';
$string['databaseupgradebackups'] = 'Različica varnostne kopije je sedaj {$a}';
$string['databaseupgradeblocks'] = 'Različica blokov je sedaj {$a}';
$string['databaseupgradegroups'] = 'Različica skupin je sedaj {$a}';
$string['databaseupgradelocal'] = 'Različica prilagoditve lokalne podatkovne zbirke je zdaj {$a}';
$string['databaseupgrades'] = 'Nadgrajevanje zbirke podatkov';
$string['dataformats'] = 'Oblike zapisa podatkov';
$string['date'] = 'Datum';
$string['datechanged'] = 'Datum spremembe';
$string['datemostrecentfirst'] = 'Datum – najnovejši prvi';
$string['datemostrecentlast'] = 'Datum – najnovejši zadnji';
$string['day'] = 'dan';
$string['days'] = 'dni';
$string['decodinginternallinks'] = 'Dekodiranje notranjih povezav';
$string['default'] = 'Privzeto';
$string['defaultcategoryname'] = 'Kategorija 1';
$string['defaultcompetencescale'] = 'Privzeta lestvica kompetenc';
$string['defaultcompetencescaledesc'] = 'Binarna ocenjevalna lestvica, ki ne nudi dodatnih informacij razen teh, ali je nekdo pokazal znanje ali ne.';
$string['defaultcompetencescalenotproficient'] = 'Še ni kompetenten';
$string['defaultcompetencescaleproficient'] = 'Kompetenten';
$string['defaultcoursestudent'] = 'Udeleženec';
$string['defaultcoursestudentdescription'] = 'Udeleženci imajo ponavadi manj privilegijev znotraj predmeta.';
$string['defaultcoursestudents'] = 'Udeleženci';
$string['defaultcoursesummary'] = 'Napišite jedrnat in zanimiv odstavek, ki pojasni, za kaj gre v tem predmetu';
$string['defaultcourseteacher'] = 'Učitelj';
$string['defaultcourseteacherdescription'] = 'Izvajalci lahko v predmetu počnejo karkoli, tudi spreminjajo dejavnosti in ocenjujejo udeležence.';
$string['defaultcourseteachers'] = 'Učitelji';
$string['defaulteditor'] = 'Privzeti urejevalnik';
$string['defaulthomepageuser'] = 'Začetna stran';
$string['defaulthomepageuser_help'] = 'Na katero stran naj bo uporabnik preusmerjen po prijavi v portal?';
$string['delete'] = 'Izbriši';
$string['deleteablock'] = 'Izbriši blok';
$string['deleteall'] = 'Izbriši vse';
$string['deleteallcannotundo'] = 'Izbriši vse – ni mogoče razveljaviti';
$string['deleteallcomments'] = 'Izbriši vse komentarje';
$string['deleteallratings'] = 'Izbriši vse ocene';
$string['deletecategory'] = 'Izbriši kategorijo: {$a}';
$string['deletecategorycheck'] = 'Ste popolnoma prepričani, da želite v celoti izbrisati to kategorijo <b>\'{$a}\'</b>?<br />To bo premaknilo vse predmete v nadrejeno kategorijo, če obstaja, ali v Razno.';
$string['deletecategorycheck2'] = 'Če izbrišete to kategorijo, morate izbrati, kaj se bo zgodilo s predmeti in podkategorijami, ki jih vsebuje.';
$string['deletecategoryempty'] = 'Ta kategorija je prazna.';
$string['deletecheck'] = 'Izbriši {$a}?';
$string['deletecheckfiles'] = 'Ste popolnoma prepričani, da želite izbrisati te datoteke?';
$string['deletecheckfull'] = 'Ste popolnoma prepričani, da želite dokončno izbrisati uporabnika {$a}, vključno z njegovimi prijavami, dejavnostmi in drugimi uporabniškimi podatki?';
$string['deletechecktype'] = 'Ste prepričani, da želite izbrisati {$a->type}?';
$string['deletechecktypename'] = 'Ste prepričani, da želite izbrisati {$a->type} "{$a->name}"?';
$string['deletecheckwarning'] = 'Izbrisali boste te datoteke';
$string['deletecommentbyon'] = 'Izbriši komentar, ki ga je {$a->time} objavil {$a->user}';
$string['deletecompletely'] = 'Dokončno izbriši';
$string['deletecourse'] = 'Izbriši predmet';
$string['deletecoursecheck'] = 'Ste popolnoma prepričani, da želite dokončno izbrisati ta predmet in vse podatke, ki jih vsebuje?';
$string['deleted'] = 'Izbrisano';
$string['deletedactivity'] = 'Izbrisano {$a}';
$string['deletedcourse'] = '{$a} je bil popolnoma izbrisan';
$string['deletednot'] = 'Ni bilo mogoče izbrisati {$a}!';
$string['deletepicture'] = 'Izbriši sliko';
$string['deletesection'] = 'Izbriši odsek';
$string['deleteselected'] = 'Izbriši izbrano';
$string['deleteselectedkey'] = 'Izbriši izbrani ključ';
$string['deletingcourse'] = 'Brisanje {$a}';
$string['deletingexistingcoursedata'] = 'Brisanje obstoječih podatkov predmeta';
$string['deletingolddata'] = 'Brisanje starih podatkov';
$string['department'] = 'Oddelek';
$string['deprecatedeventname'] = '{$a} (ni več v uporabi)';
$string['desc'] = 'Padajoče';
$string['description'] = 'Opis';
$string['descriptiona'] = 'Opis: {$a}';
$string['deselectall'] = 'Počisti izbor';
$string['deselectnos'] = 'Prekliči izbor vseh \'Ne\'';
$string['detailedless'] = 'Manj podrobno';
$string['detailedmore'] = 'Bolj podrobno';
$string['details'] = 'Podrobnosti';
$string['digitalminor'] = 'Digitalni mladoletnik';
$string['digitalminor_desc'] = 'Prosite starša/skrbnika da kontaktira:';
$string['directory'] = 'Imenik';
$string['disable'] = 'Onemogoči';
$string['disabledcomments'] = 'Komentarji so onemogočeni';
$string['dismissnotification'] = 'Opusti to obvestilo';
$string['displayingfirst'] = 'Samo prvih {$a->count} {$a->things} je prikazanih';
$string['displayingrecords'] = 'Prikazanih {$a} zapisov';
$string['displayingusers'] = 'Prikazani uporabniki {$a->start} do {$a->end}';
$string['displayonpage'] = 'Prikaži na strani';
$string['dndcourse'] = 'Predmet lahko povlečete in spustite, da spremenite njegovo razvrstitev ali ga premaknete v drugo kategorijo.';
$string['dndenabled_inbox'] = 'Datoteke lahko dodate, tako da jih povlečete in spustite sem.';
$string['dndnotsupported'] = 'Nalaganje z načinom povleci in spusti ni podprto';
$string['dndnotsupported_help'] = 'Vaš brskalnik ne podpira načina nalaganja povleci in spusti. Ta funkcija je podprta v vseh zadnjih verzijah brskalnikov Chrome, Firefox in Safari, kot tudi Internet Explorer v10 in novejših.';
$string['dndnotsupported_insentence'] = 'način povleci in spusti ni podprt';
$string['dnduploadwithoutcontent'] = 'Ta naložena datoteka nima nobene vsebine';
$string['dndworkingfile'] = 'Za nalaganje, datoteke povlecite in spustite v odseke predmeta';
$string['dndworkingfilelink'] = 'Za nalaganje, datoteke ali povezave povlecite in spustite v odseke predmeta';
$string['dndworkingfiletext'] = 'Za nalaganje, datoteke ali tekst povlecite in spustite v odseke predmeta';
$string['dndworkingfiletextlink'] = 'Za nalaganje, datoteke, tekst ali povezave povlecite in spustite v odseke predmeta';
$string['dndworkinglink'] = 'Za nalaganje, povezave povlecite in spustite v odseke predmeta';
$string['dndworkingtext'] = 'Za nalaganje, tekst povlecite in spustite v odseke predmeta';
$string['dndworkingtextlink'] = 'Za nalaganje, tekst ali povezave povlecite in spustite v odseke predmeta';
$string['documentation'] = 'Dokumentacija Moodle';
$string['dontsortcategories'] = 'Ne razvrsti kategorij';
$string['dontsortcourses'] = 'Ne razvrsti predmetov';
$string['down'] = 'Dol';
$string['download'] = 'Prenesi';
$string['downloadall'] = 'Prenesi vse';
$string['downloadexcel'] = 'Prenesi v formatu Excel';
$string['downloadfile'] = 'Prenesi datoteko';
$string['downloadods'] = 'Prenesi v formatu ODS';
$string['downloadtext'] = 'Prenesi v besedilnem formatu';
$string['doyouagree'] = 'Ste prebrali te pogoje in jih razumeli?';
$string['droptoupload'] = 'Za nalaganje spustite datoteke sem';
$string['duplicate'] = 'Podvoji';
$string['duplicatedmodule'] = '{$a} (kopiraj)';
$string['edhelpaspellpath'] = 'Če želite uporabiti preverjanje črkovanja v urejevalniku, MORATE imeti na strežniku nameščen <strong>aspell 0.50</strong> ali novejšo različico in navesti pravilno pot za dostop do binarnih datotek aspell. Na sistemih Unix/Linux je ta pot običajno <strong>/usr/bin/aspell</strong>, vendar je lahko tudi drugačna.';
$string['edhelpbgcolor'] = 'Določite barvo ozadja na mestu urejevalnika.<br />Veljavni vrednosti sta na primer: #FFFFFF ali bela';
$string['edhelpcleanword'] = 'Ta nastavitev omogoči ali onemogoči filtriranje oblike, značilne za Word.';
$string['edhelpenablespelling'] = 'Omogoči ali onemogoči preverjanje črkovanja. Če je omogočeno, mora biti na strežniku nameščen <strong>aspell</strong>. Druga vrednost je <strong>privzeti besednjak</strong>. Ta vrednost bo uporabljena, če aspell nima besednjaka za jezik uporabnika.';
$string['edhelpfontfamily'] = 'Lastnost družine pisave je seznam imen družin pisav oz. generičnih imen družin. Imena družin morajo biti ločena z vejico.';
$string['edhelpfontlist'] = 'Določite pisave, ki so uporabljene v spustnem meniju urejevalnika.';
$string['edhelpfontsize'] = 'Privzeta velikost pisave nastavi velikost pisave. <br />Veljavne vrednosti so na primer: srednja, velika, manjša, večja, 10pt, 11px.';
$string['edit'] = 'Uredi';
$string['edita'] = 'Uredi {$a}';
$string['editcategorysettings'] = 'Uredi nastavitve kategorije';
$string['editcategorythis'] = 'Uredi to kategorijo';
$string['editcoursesettings'] = 'Uredi nastavitve predmeta';
$string['editfiles'] = 'Uredi datoteke';
$string['editgroupprofile'] = 'Uredi profil skupine';
$string['editinga'] = 'Urejanje {$a}';
$string['editingteachershort'] = 'Urejevalnik';
$string['editlock'] = 'Te vrednosti ni mogoče urediti!';
$string['editmode'] = 'Način urejanja';
$string['editmyprofile'] = 'Uredi profil';
$string['editorbgcolor'] = 'Barva ozadja';
$string['editorcleanonpaste'] = 'Počisti Word HTML ob lepljenju';
$string['editorcommonsettings'] = 'Skupne nastavitve';
$string['editordefaultfont'] = 'Privzeta pisava';
$string['editorenablespelling'] = 'Omogoči preverjanje črkovanja';
$string['editorfontlist'] = 'Seznam pisav';
$string['editorfontsize'] = 'Privzeta velikost pisave';
$string['editorpreferences'] = 'Nastavitve urejevalnika';
$string['editorresettodefaults'] = 'Ponastavi na privzete vrednosti';
$string['editorsettings'] = 'Nastavitve urejevalnika';
$string['editorshortcutkeys'] = 'Tipke za bližnjice v urejevalniku';
$string['editsection'] = 'Uredi odsek';
$string['editsectionname'] = 'Uredi ime odseka';
$string['editsettings'] = 'Uredi nastavitve';
$string['editsummary'] = 'Uredi povzetek';
$string['editthisactivity'] = 'Uredi to dejavnost';
$string['editthiscategory'] = 'Uredi to kategorijo';
$string['edittitle'] = 'Uredi naslov';
$string['edittitleinstructions'] = 'Pritisnite tipko \'Escape\' za prekinitev, \'Enter\' za zaključek';
$string['edituser'] = 'Uredi uporabniške račune';
$string['edulevel'] = 'Vsi dogodki';
$string['edulevel_help'] = '* Poučevanje - dejavnosti izvajalca, npr. posodobitev vira
* Udeležba - dejavnosti udeleženca, npr. objava v forumu
* Drugo - dejavnosti uporabnika z vlogo, ki ni izvajalec ali udeleženec';
$string['edulevelother'] = 'Drugo';
$string['edulevelparticipating'] = 'Sodelujoči';
$string['edulevelteacher'] = 'Učitelj';
$string['email'] = 'E-poštni naslov';
$string['emailactive'] = 'E-sporočilo aktivirano';
$string['emailagain'] = 'E-poštni naslov (ponovno)';
$string['emailalreadysent'] = 'E-sporočilo za ponastavitev gesla je že poslano. Preverite svoj e-poštni nabiralnik.';
$string['emailcharset'] = 'Nabor znakov za e-pošto';
$string['emailconfirm'] = 'Potrdite vaš račun';
$string['emailconfirmation'] = 'Pozdravljeni,

Na \'{$a->sitename}\' je bil z vašim e-poštnim naslovom zahtevan nov uporabniški račun.

Za potrditev vašega novega računa obiščite ta spletni naslov:

{$a->link}

V večini e-poštnih programov bi se moral naslov pojaviti kot modra povezava
na katero lahko preprosto kliknete.  Če to ne deluje,
potem kopirajte in prilepite naslov v naslovno
vrstico na vrhu okna vašega spletnega brskalnika.

Če potrebujete pomoč, se obrnite na skrbnika spletnega mesta,
{$a->admin}';
$string['emailconfirmationresend'] = 'Ponovno pošlji potrditveno e-sporočilo';
$string['emailconfirmationsubject'] = '{$a}: potrditev računa';
$string['emailconfirmsent'] = '<p>Na vaš naslov <b>{$a}</b> bi moralo biti poslano e-sporočilo.</p>
 <p>Vsebuje enostavna navodila za dokončanje vaše registracije.</p>
 <p>Če imate še vedno težave, se obrnite na skrbnika spletnega mesta.</p>';
$string['emailconfirmsentfailure'] = 'Potrditvenega e-sporočila ni bilo mogoče poslati';
$string['emailconfirmsentsuccess'] = 'Potrditveno e-sporočilo uspešno poslano';
$string['emaildigest'] = 'Vrsta e-poštnega izvlečka';
$string['emaildigest_help'] = 'To je privzeta nastavitev forumov za izvlečke.

* Brez izvlečkov – prejeli boste eno e-sporočilo na forumsko objavo;
* Izvleček celotnih objav – prejeli boste eno e-sporočilo na dan, ki bo vsebovalo celotno vsebino vsake forumske objave;
* Izvleček zadev – prejeli boste eno e-sporočilo z izvlečki, ki bo vsebovalo le zadevo vsake forumske objave.

Če želite, lahko izberete drugačno nastavitev za vsak forum.';
$string['emaildigestcomplete'] = 'Popoln (dnevna e-pošta s celotnimi objavami)';
$string['emaildigestoff'] = 'Brez izvlečkov (eno e-sporočilo na forumsko objavo)';
$string['emaildigestsubjects'] = 'Zadeve (dnevno e-sporočilo samo z zadevami)';
$string['emaildisable'] = 'Ta e-poštni naslov je onemogočen';
$string['emaildisableclick'] = 'Kliknite tu, če želite onemogočiti pošiljanje vse e-pošte na ta naslov';
$string['emaildisplay'] = 'Vidnost e-poštnega naslova';
$string['emaildisplay_help'] = '* Skrit - Samo uporabniki z ustreznimi pravicami, kot na primer učitelji, lahko vidijo vaš e-naslov.
* Viden vsem - Vsi uporabniki na portalu lahko vidijo vaš e-naslov.
* Viden udeležencem predmeta - Samo udeleženci predmetov v katere ste vpisani lahko vidijo vaš e naslov.';
$string['emaildisplaycourse'] = 'Viden udeležencem predmeta';
$string['emaildisplaycoursemembersonly'] = '(Viden drugim udeležencem predmeta)';
$string['emaildisplayeveryone'] = '(Viden vsem)';
$string['emaildisplayhide'] = '(Skrit pred vsemi, razen uporabniki z ustreznimi pravicami)';
$string['emaildisplayno'] = 'Skrit';
$string['emaildisplayyes'] = 'Viden vsem';
$string['emailenable'] = 'Ta e-poštni naslov je onemogočen';
$string['emailenableclick'] = 'Kliknite tu, če želite ponovno omogočiti pošiljanje vse e-pošte na ta naslov';
$string['emailexists'] = 'Ta e-poštni naslov je že registriran.';
$string['emailexistshintlink'] = 'Obnovi pozabljeno uporabniško ime ali geslo';
$string['emailexistssignuphint'] = 'Ali ste morda že ustvarili račun v preteklosti? {$a}';
$string['emailformat'] = 'Oblika e-pošte';
$string['emailmustbereal'] = 'Opomba: vaš e-poštni naslov mora biti resničen';
$string['emailnotallowed'] = 'E-poštni naslovi teh domen niso dovoljeni ({$a})';
$string['emailnotfound'] = 'Tega e-poštnega naslova ni bilo mogoče najti v podatkovni zbirki';
$string['emailonlyallowed'] = 'Ta e-poštni naslov ni eden od tistih, ki so dovoljeni ({$a})';
$string['emailpasswordchangeinfo'] = 'Pozdravljeni {$a->firstname},

Nekdo (verjetno vi) je zahteval novo geslo za vaš uporabniški račun \'{$a->username}\' na spletnem mestu \'{$a->sitename}\'.

Za spremembo gesla pojdite na spodnjo povezavo:

{$a->link}

V večini e-poštnih odjemalcev, bi se moral naslov pojaviti kot modra povezava na katero lahko preprosto kliknete. Če to ne deluje, potem kopirajte in prilepite naslov v naslovno vrstico na vrhu okna vašega spletnega brskalnika.

Če potrebujete pomoč, se obrnite na skrbnika strani,
{$a->admin}';
$string['emailpasswordchangeinfodisabled'] = 'Pozdravljeni {$a->firstname},

Nekdo (verjetno vi) je zahteval novo geslo za vaš uporabniški račun na spletnem mestu \'{$a->sitename}\'.

Žal je bil uporabniški račun na tej strani onemogočen in ga ni mogoče ponastaviti. Obrnite se na skrbnika strani, {$a->admin}.';
$string['emailpasswordchangeinfofail'] = 'Pozdravljeni {$a->firstname},

nekdo (verjetno vi) je zahteval novo geslo za vaš uporabniški račun na strani \'{$a->sitename}\'.

Žal gesel na tem spletnem mestu ni mogoče ponastaviti, zato se obrnite na skrbnika strani, {$a->admin}.';
$string['emailpasswordchangeinfosubject'] = '{$a}: Spremeni informacije o geslu';
$string['emailpasswordconfirmation'] = 'Pozdravljeni {$a->firstname},

Nekdo (verjetno vi) je zahteval novo geslo za vaš
uporabniški račun na \'{$a->sitename}\'.

Za potrditev in novo geslo, ki bo poslano na vaš e-poštni naslov,
pojdite na sledeči spletni naslov:

{$a->link}

V večini e-poštnih programov bi se moral naslov pojaviti kot modra povezava,
na katero lahko preprosto kliknete. Če to ne deluje,
kopirajte in prilepite naslov v naslovno
vrstico na vrhu okna vašega spletnega brskalnika.

Če potrebujete pomoč, povprašajte skrbnika spletnega mesta,
{$a->admin}';
$string['emailpasswordconfirmationsubject'] = '{$a}: Potrditev spremembe gesla';
$string['emailpasswordconfirmmaybesent'] = '<p>V primeru, da ste vnesli pravilno uporabniško ime ali unikaten e-poštni naslov, vam bi moralo biti poslano e-poštno sporočilo.</p>
<p>Sporočilo vsebuje enostavna navodila za potrditev in izvedbo zamenjave gesla.
V primeru nadaljnjih težave se obrnite na skrbnika spletnega mesta.</p>';
$string['emailpasswordconfirmnoemail'] = '<p>Uporabniški račun, ki ste ga navedli, nima zabeleženega e-poštnega naslova.</p>
<p>Obrnite se na skrbnika spletnega mesta.</p>';
$string['emailpasswordconfirmnotsent'] = '<p>Navedeni podatek o uporabniku se ne ujema z obstoječim uporabniškim računom.</p>
 <p>Preverite vneseno informacijo in poskusite znova.
Če imate še vedno težave, se obrnite na skrbnika spletnega mesta.</p>';
$string['emailpasswordconfirmsent'] = 'Na vaš naslov <b>{$a}</b> je bilo poslano elektronsko sporočilo.
<br />V njem so enostavna navodila za potrditev in izvedbo spremembe gesla.
Če imate še vedno težave, se obrnite na skrbnika spletnega mesta.';
$string['emailpasswordsent'] = 'Hvala za potrditev spremembe gesla.
E-sporočilo z vašim novim geslom je bilo poslano na vaš naslov <br /><b>{$a->email}</b>.<br />
Novo geslo je bilo samodejno generirano - morda boste želeli
<a href="{$a->link}">spremeniti vaše geslo</a> v nekaj, kar si boste lažje zapomnili.';
$string['emailresetconfirmation'] = 'Pozdravljeni, {$a->firstname},

na strani {$a->sitename} smo za vaš račun \'{$a->username}\' prejeli zahtevo za ponastavitev gesla.

Za potrditev te zahteve vas prosimo, da obiščete sledečo povezavo in nastavite novo geslo za vaš račun:
{$a->link}

(Ta povezava je veljavna še {$a->resetminutes} minut po sprožitvi zahteve za ponastavitev gesla)

Če ponastavitve gesla niste zahtevali, vam ni treba storiti ničesar.

Če potrebujete pomoč, se obrnite na skrbnika spletnega mesta,
{$a->admin}';
$string['emailresetconfirmationsubject'] = '{$a}: zahteva za ponastavitev gesla';
$string['emailresetconfirmsent'] = 'E-sporočilo je bilo poslano na vaš naslov na <b>{$a}</b>.
<br />V njem so enostavna navodila za potrditev in izvedbo spremembe gesla.
Če imate še vedno težave, se obrnite na skrbnika spletnega mesta.';
$string['emailstop'] = 'Onemogoči obvestila';
$string['emailtoprivatefiles'] = 'Datoteke lahko tudi pošljete kot priponke prek e-pošte neposredno v svoj zasebni prostor za datoteke. Pripnite svoje datoteke v e-pošto in ga pošljite na naslov {$a}';
$string['emailtoprivatefilesdenied'] = 'Skrbnik je onemogočil možnost nalaganja vaših zasebnih datotek na strežnik.';
$string['emailvia'] = '{$a->name} (via {$a->siteshortname})';
$string['emojicategoryactivities'] = 'Dejavnosti';
$string['emojicategoryanimalsnature'] = 'Živali & narava';
$string['emojicategoryflags'] = 'Zastave';
$string['emojicategoryfooddrink'] = 'Hrana & pijača';
$string['emojicategoryobjects'] = 'Predmeti';
$string['emojicategoryrecent'] = 'Nedavno';
$string['emojicategorysymbols'] = 'Simboli';
$string['emojicategorytravelplaces'] = 'Potovanja & kraji';
$string['emptycmids'] = 'ID praznih modulov predmeta';
$string['emptydragdropregion'] = 'prazno mesto';
$string['emptysectionids'] = 'ID praznih odsekov';
$string['enable'] = 'Omogoči';
$string['encryptedcode'] = 'Šifrirana koda';
$string['enddate'] = 'Datum zaključka predmeta';
$string['enddate_help'] = 'Datum zaključka predmeta ne omejuje dostopa udeležencev do predmeta. Določa, ali je predmet med Mojimi predmeti razvrščen med Pretekle predmete.';
$string['english'] = 'Angleščina';
$string['enrolmentmethods'] = 'Načini vpisa';
$string['entercourse'] = 'Kliknite za vstop v ta predmet';
$string['enteremail'] = 'Vnesite vaš e-poštni naslov';
$string['enteremailaddress'] = 'Vnesite vaš e-poštni naslov za ponastavitev vašega
 gesla in v e-nabiralnik boste prejeli novo geslo.';
$string['enterusername'] = 'Vnesite vaše uporabniško ime';
$string['entries'] = 'Vnosi';
$string['error'] = 'Napaka';
$string['errorcreatingactivity'] = 'Posamezne dejavnosti \'{$a}\' ni bilo mogoče ustvariti';
$string['errorfiletoobig'] = 'Datoteka je večja od omejitve {$a} bajtov';
$string['errornouploadrepo'] = 'Za to spletno mesto ni omogočeno nobeno skladišče za nalaganje';
$string['errorwhenconfirming'] = 'Niste še potrjeni, ker je prišlo do napake.  Če ste kliknili na povezavo v e-pošti, da ste prišli sem, se prepričajte, da vrstica v vašem sporočilu ni bila prekinjena ali prelomljena. Morda boste morali za pravilno povezavo uporabiti kopiranje in lepljenje.';
$string['eventcommentcreated'] = 'Komentar ustvarjen';
$string['eventcommentdeleted'] = 'Komentar je izbrisan';
$string['eventcommentsviewed'] = 'Komentarji ogledani';
$string['eventconfiglogcreated'] = 'Konfiguracijski dnevnik ustvarjen';
$string['eventcontentviewed'] = 'Vsebina ogledana';
$string['eventcoursebackupcreated'] = 'Varnostna kopija predmeta ustvarjena';
$string['eventcoursecategorycreated'] = 'Kategorija ustvarjena';
$string['eventcoursecategorydeleted'] = 'Kategorija izbrisana';
$string['eventcoursecategoryupdated'] = 'Kategorija posodobljena';
$string['eventcoursecategoryviewed'] = 'Kategorija ogledana';
$string['eventcoursecontentdeleted'] = 'Vsebina predmeta izbrisana';
$string['eventcoursecreated'] = 'Predmet ustvarjen';
$string['eventcoursedeleted'] = 'Predmet izbrisan';
$string['eventcourseinformationviewed'] = 'Povzetek predmeta ogledan';
$string['eventcoursemodulecreated'] = 'Modul predmeta ustvarjen';
$string['eventcoursemoduledeleted'] = 'Modul predmeta izbrisan';
$string['eventcoursemoduleinstancelistviewed'] = 'Seznam elementov modula predmeta ogledan';
$string['eventcoursemoduleupdated'] = 'Modul predmeta posodobljen';
$string['eventcoursemoduleviewed'] = 'Modul predmeta ogledan';
$string['eventcourseresetended'] = 'Ponastavitev predmeta končana';
$string['eventcourseresetstarted'] = 'Ponastavitev predmeta se je začela';
$string['eventcourserestored'] = 'Predmet obnovljen';
$string['eventcoursesectioncreated'] = 'Odsek predmeta ustvarjen';
$string['eventcoursesectiondeleted'] = 'Odsek predmeta izbrisan';
$string['eventcoursesectionupdated'] = 'Odsek predmeta posodobljen';
$string['eventcoursessearched'] = 'Iskani predmeti';
$string['eventcourseupdated'] = 'Predmet posodobljen';
$string['eventcourseuserreportviewed'] = 'Uporabniško poročilo o predmetu ogledano';
$string['eventcourseviewed'] = 'Predmet ogledan';
$string['eventdashboardreset'] = 'Nadzorna plošča ponastavljena';
$string['eventdashboardsreset'] = 'Nadzorne plošče ponastavljene';
$string['eventdashboardviewed'] = 'Nadzorna plošča ogledana';
$string['eventdatabasetextfieldcontentreplaced'] = 'Globalno iskanje in zamenjava v podatkovni bazi';
$string['eventemailfailed'] = 'Pošiljanje e-sporočila ni uspelo';
$string['eventmycoursesviewed'] = 'Ogled Mojih predmetov';
$string['eventname'] = 'Ime dogodka';
$string['eventrecentactivityviewed'] = 'Nedavna dejavnost ogledana';
$string['eventsearchindexed'] = 'Podatki iskanja indeksirani';
$string['eventsearchresultsviewed'] = 'Rezultati iskanja ogledani';
$string['eventunknownlogged'] = 'Neznan dogodek';
$string['eventusercreated'] = 'Uporabnik ustvarjen';
$string['eventuserdeleted'] = 'Uporabnik izbrisan';
$string['eventuserfeedbackgiven'] = 'Kliknjena povezava za povratno informacijo';
$string['eventuserfeedbackremind'] = 'Kliknjena povezava za opomin na povratno informacijo';
$string['eventuserinfocategorycreated'] = 'Kategorija mesta uporabniškega profila ustvarjena';
$string['eventuserinfocategorydeleted'] = 'Kategorija mesta uporabniškega profila izbrisana';
$string['eventuserinfocategoryupdated'] = 'Kategorija mesta uporabniškega profila posodobljena';
$string['eventuserinfofieldcreated'] = 'Polje uporabniškega profila ustvarjeno';
$string['eventuserinfofielddeleted'] = 'Mesto uporabniškega profila izbrisano';
$string['eventuserinfofieldupdated'] = 'Polje uporabniškega profila posodobljeno';
$string['eventuserlistviewed'] = 'Seznam uporabnikov ogledan';
$string['eventuserloggedout'] = 'Uporabnik se je odjavil';
$string['eventuserpasswordpolicyfailed'] = 'Uporabniško geslo ni v skladu s pravilnikom za gesla';
$string['eventuserpasswordupdated'] = 'Uporabniško geslo posodobljeno';
$string['eventuserprofileviewed'] = 'Profil uporabnika ogledan';
$string['eventuserupdated'] = 'Uporabnik posodobljen';
$string['everybody'] = 'Vsi';
$string['executeat'] = 'Izvedi ob';
$string['existing'] = 'Obstoječe';
$string['existingadmins'] = 'Obstoječi skrbniki';
$string['existingcourse'] = 'Obstoječi predmet';
$string['existingcourseadding'] = 'Dodajanje podatkov v obstoječi predmet';
$string['existingcoursedeleting'] = 'Brisanje obstoječega predmeta';
$string['existingcreators'] = 'Obstoječi ustvarjalci predmetov';
$string['existingstudents'] = 'Vpisani udeleženci';
$string['existingteachers'] = 'Obstoječi učitelji';
$string['expand'] = 'Razširi';
$string['expandall'] = 'Razširi vse';
$string['expandcategory'] = 'Razširi {$a}';
$string['explanation'] = 'Pojasnilo';
$string['explanationdigitalminor'] = 'Ti podatki so potrebni za določitev, ali vaša starost presega digitalno starost za privolitev. To je starost, pri kateri lahko posameznik soglaša s pogoji in se lahko njegovi podatki hranijo in obdelujejo v skladu z zakonom.';
$string['extendperiod'] = 'Podaljšano obdobje';
$string['extendsession'] = 'Podaljšaj sejo';
$string['failedloginattempts'] = '{$a->attempts} spodletelih prijav od vaše zadnje prijave';
$string['favourites'] = 'Označeno z zvezdico';
$string['feedback'] = 'Pripombe';
$string['file'] = 'Datoteka';
$string['fileexists'] = 'Datoteka z imenom {$a} že obstaja';
$string['filemissing'] = '{$a} manjka';
$string['filereaderror'] = 'Ni mogoče prebrati datoteke \'{$a}\'. Preverite, ali je res datoteka in ne mapa.';
$string['files'] = 'Datoteke';
$string['filesanduploads'] = 'Datoteke in prenosi';
$string['filesfolders'] = 'Datoteke/mape';
$string['fileuploadwithcontent'] = 'Naložene datoteke ne smejo vsebovati parametrov vsebine';
$string['filloutallfields'] = 'Izpolnite vsa polja tega obrazca';
$string['filter'] = 'Filter';
$string['filteroption'] = '{$a->criteria}: {$a->value}';
$string['filterrowlegend'] = 'Filter {$a}';
$string['filters'] = 'Filtri';
$string['filtersetmatchdescription'] = 'Kako naj bo kombiniranih več filtrov';
$string['filtertype'] = 'Tip filtra';
$string['findmorecourses'] = 'Najdi več predmetov ...';
$string['first'] = 'Prvi';
$string['firstaccess'] = 'Prvi dostop';
$string['firstname'] = 'Ime';
$string['firstnamephonetic'] = 'Ime – fonetično';
$string['firstpage'] = 'Prva stran';
$string['firstsiteaccess'] = 'Prvi dostop do spletnega mesta';
$string['firsttime'] = 'Je to vaš prvi obisk?';
$string['folder'] = 'Mapa';
$string['folderclosed'] = 'Zaprta mapa';
$string['folderopened'] = 'Odprta mapa';
$string['followingoptional'] = 'Sledeči elementi so neobvezni';
$string['followingrequired'] = 'Sledeči elementi so zahtevani';
$string['for'] = 'Za';
$string['force'] = 'Vsili';
$string['forcelanguage'] = 'Vsili jezik';
$string['forceno'] = 'Ne vsili';
$string['forcepasswordchange'] = 'Vsili spremembo gesla';
$string['forcepasswordchange_help'] = 'Če je to polje obkljukano, bo moral uporabnik ob naslednji prijavi spremeniti geslo';
$string['forcepasswordchangecheckfull'] = 'Ste popolnoma prepričani, da želite vsiliti spremembo gesla za {$a}?';
$string['forcepasswordchangenot'] = 'Ne morem vsiliti spremembe gesla za {$a}';
$string['forcepasswordchangenotice'] = 'Za nadaljevanje morate spremeniti svoje geslo.';
$string['forcepasswordresetfailurenotice'] = 'Vaše trenutno geslo ni več v skladu z nastavljenim pravilnikom za gesla. Za pomoč se obrnite na vašega skrbnika Moodla.
{$a}';
$string['forcepasswordresetnotice'] = 'Vaše trenutno geslo ni več v skladu s politiko gesel. Za prijavo morate ponastaviti geslo.
{$a}';
$string['forcetheme'] = 'Vsili temo';
$string['forgotaccount'] = 'Ste izgubili geslo?';
$string['forgotten'] = 'Ste pozabili svoje uporabniško ime ali geslo?';
$string['forgottenduplicate'] = 'Ta e-poštni naslov uporablja več uporabniških računov. Prosimo, vnesite uporabniško ime';
$string['forgotteninvalidurl'] = 'Napačen naslov URL za ponastavitev gesla';
$string['format'] = 'Oblika';
$string['format_help'] = 'Oblika predmeta določa postavitev strani predmeta.

* Oblika posamične dejavnosti – za prikaz posamične dejavnosti ali vira (kot je kviz ali paket SCORM) na strani predmeta
* Družabna oblika – na strani predmeta je prikazan forum
* Tematska oblika – stran predmeta je organizirana po temah
* Tedenska oblika – stran predmeta je organizirana v tedenske odseke, tako da se prvi teden začne z začetnim datumom predmeta';
$string['formathtml'] = 'Format HTML';
$string['formatmarkdown'] = 'Format Markdown';
$string['formatplain'] = 'Format golega besedila';
$string['formattext'] = 'Samodejni format Moodle';
$string['forumpreferences'] = 'Nastavitve foruma';
$string['framesetinfo'] = 'Ta dokument vrste frameset vsebuje:';
$string['from'] = 'Od';
$string['frontpagecategorycombo'] = 'Kombiniran seznam';
$string['frontpagecategorynames'] = 'Seznam kategorij';
$string['frontpagecourselist'] = 'Seznam predmetov';
$string['frontpagecoursesearch'] = 'Iskalnik predmetov';
$string['frontpagedescription'] = 'Povzetek Prve strani spletnega mesta';
$string['frontpagedescriptionhelp'] = 'Ta povzetek bo prikazan na Prvi strani spletnega mesta v bloku povzetka predmeta/spletnega mesta.';
$string['frontpageenrolledcourselist'] = 'Vpisani predmeti';
$string['frontpageformat'] = 'Oblika Prve strani spletnega mesta';
$string['frontpageformatloggedin'] = 'Oblika Prve strani spletnega mesta po prijavi';
$string['frontpagenews'] = 'Obvestila';
$string['frontpagesettings'] = 'Nastavitve Prve strani spletnega mesta';
$string['fulllistofcourses'] = 'Vsi predmeti';
$string['fullname'] = 'Polno ime';
$string['fullnamecourse'] = 'Polno ime predmeta';
$string['fullnamecourse_help'] = 'Ime, ki se prikaže na strani Moji predmeti in v seznamu predmetov na Prvi strani spletnega mesta.';
$string['fullnamedisplay'] = '{$a->firstname} {$a->lastname}';
$string['fullnameuser'] = 'Polno ime uporabnika';
$string['fullprofile'] = 'Poln profil';
$string['fullsitename'] = 'Polno ime spletnega mesta';
$string['functiondisabled'] = 'Ta funkcionalnost je trenutno onemogočena';
$string['general'] = 'Splošno';
$string['geolocation'] = 'širina – dolžina';
$string['gettheselogs'] = 'Pridobi te dnevnike';
$string['go'] = 'Pojdi';
$string['gpl'] = 'Avtorske pravice (C) od leta 1999 naprej Martin Dougiamas (http://moodle.com)

Ta program spada med prosto programsko opremo; lahko ga razširjate in/ali spreminjate pod pogoji Splošnega dovoljenja GNU (GNU General Public License), kot ga je objavila
ustanova Free Software Foundation; bodisi različice 2 ali
(po vaši izbiri) katerekoli poznejše različice.

Ta program se razširja v upanju, da bo uporaben,
vendar BREZ VSAKRŠNEGA JAMSTVA; tudi brez posredne zagotovitve
CENOVNE VREDNOSTI ali PRIMERNOSTI ZA DOLOČEN NAMEN.

Za podrobnosti obiščite informativno stran o Moodle licenci:
http://docs.moodle.org/en/License';
$string['gpl3'] = 'Copyright (C) 1999 Martin Dougiamas (http://moodle.com)

Ta program spada med prosto programsko opremo: lahko ga razširjate oz.
spreminjate pod pogoji GNU General Public License, kot jo je
objavila Free Software Foundation, različica 3 licence,
ali katerekoli poznejše različice.

Ta program se razširja v upanju, da bo uporaben, vendar
BREZ VSAKRŠNEGA JAMSTVA, tudi brez posredne zagotovitve
CENOVNE VREDNOSTI ali PRIMERNOSTI ZA DOLOČEN NAMEN.

Za podrobnosti obiščite informativno stran o Moodle licenci:
http://docs.moodle.org/dev/license';
$string['gpllicense'] = 'Licenca GPL';
$string['grade'] = 'Ocena';
$string['gradenoun'] = 'Ocena';
$string['grades'] = 'Ocene';
$string['gradeverb'] = 'Ocena';
$string['gravatarenabled'] = '<a href="http://www.gravatar.com/">Gravatar</a> je bil za to spletno mesto omogočen. Če ne boste naložili vaše slike profila, bo Moodle poskusil sliko profila za vas naložiti iz Gravatar-ja.';
$string['group'] = 'Skupina';
$string['groupadd'] = 'Dodaj novo skupino';
$string['groupaddusers'] = 'Dodaj izbrane v skupino';
$string['groupfor'] = 'za skupino';
$string['groupinfo'] = 'Informacije o izbrani skupini';
$string['groupinfoedit'] = 'Urejanje nastavitev skupine';
$string['groupinfomembers'] = 'Informacije o izbranih članih';
$string['groupinfopeople'] = 'Informacije o izbranih osebah';
$string['groupmembers'] = 'Člani skupine';
$string['groupmemberssee'] = 'Poglej člane skupine';
$string['groupmembersselected'] = 'Člani izbrane skupine';
$string['groupmode'] = 'Skupinski način';
$string['groupmodeforce'] = 'Vsili skupinski način';
$string['groupmy'] = 'Moja skupina';
$string['groupnonmembers'] = 'Osebe, ki niso v skupini';
$string['groupnotamember'] = 'Niste član te skupine';
$string['grouprandomassign'] = 'Naključno dodeli vse v skupine';
$string['groupremove'] = 'Odstrani izbrano skupino';
$string['groupremovemembers'] = 'Odstrani izbrane člane';
$string['groups'] = 'Skupine';
$string['groupsnone'] = 'Brez skupin';
$string['groupsseparate'] = 'Ločene skupine';
$string['groupsvisible'] = 'Vidne skupine';
$string['guest'] = 'Gost';
$string['guestdescription'] = 'Gostje imajo minimalne pravice in običajno ne morejo nikamor vnašati besedila.';
$string['guestskey'] = 'Dovoli gostom, ki imajo ključ';
$string['guestsno'] = 'Ne dovoli vstopa gostom';
$string['guestsnotallowed'] = 'Žal \'{$a}‘ gostom ne dovoli vstopiti.';
$string['guestsyes'] = 'Dovoli gostom brez ključa';
$string['guestuser'] = 'Gostujoči uporabnik';
$string['guestuserinfo'] = 'Ta uporabnik je poseben uporabnik, ki mu je dovoljen bralni dostop do nekaterih predmetov.';
$string['help'] = 'Pomoč';
$string['helpprefix2'] = 'Pomoč za {$a}';
$string['helpwiththis'] = 'Pomoč pri tem';
$string['hiddenassign'] = 'Skrita naloga';
$string['hiddenfromstudents'] = 'Skrito za udeležence';
$string['hiddenoncoursepage'] = 'Na voljo, a ni prikazano na strani predmeta';
$string['hiddensections'] = 'Skriti odseki';
$string['hiddensections_help'] = 'Skriti odseki so lahko udeležencem na strani predmeta prikazani kot \'nerazpoložljivi\' ali popolnoma skriti.';
$string['hiddensectionscollapsed'] = 'Skriti odseki so prikazani kot nerazpoložljivi';
$string['hiddensectionsinvisible'] = 'Skriti odseki so popolnoma nevidni';
$string['hiddenwithbrackets'] = '(skrito)';
$string['hide'] = 'Skrij';
$string['hideadvancedsettings'] = 'Skrij napredne nastavitve';
$string['hidechartdata'] = 'Skrij podatke grafa';
$string['hidefromstudents'] = 'Skrij na strani predmeta';
$string['hideoncoursepage'] = 'Naj bo na voljo, vendar ne prikazano na strani predmeta';
$string['hidepicture'] = 'Skrij sliko';
$string['hidepopoverwindow'] = 'Skrij pojavno okno';
$string['hidesection'] = 'Skrij odsek {$a}';
$string['hidesettings'] = 'Skrij nastavitve';
$string['hideshowblocks'] = 'Skrij ali pokaži bloke';
$string['highlight'] = 'Poudari';
$string['highlighted'] = 'Poudarjeno';
$string['highlightoff'] = 'Odstrani poudarek';
$string['hits'] = 'Zadetki';
$string['hitsoncourse'] = 'Zadetki v predmetu {$a->coursename} od {$a->username}';
$string['hitsoncoursetoday'] = 'Današnji zadetki v predmetu {$a->coursename} od {$a->username}';
$string['home'] = 'Domov';
$string['homeheader'] = 'Meni domače strani';
$string['hour'] = 'ura';
$string['hours'] = 'ure';
$string['howtomakethemes'] = 'Kako narediti nove teme';
$string['htmleditor'] = 'Uporabi urejevalnik HTML';
$string['htmleditoravailable'] = 'Urejevalnik HTML je na voljo';
$string['htmleditordisabled'] = 'Onemogočili ste urejevalnik HTML v vašem uporabniškem profilu';
$string['htmleditordisabledadmin'] = 'Skrbnik je onemogočil urejevalnik HTML v tem spletnem mestu';
$string['htmleditordisabledbrowser'] = 'Urejevalnik HTML ni na voljo, ker vaš spletni brskalnik ni združljiv';
$string['htmlfilesonly'] = 'Samo datoteke HTML';
$string['htmlformat'] = 'Lep format HTML';
$string['icon'] = 'Ikona';
$string['icqnumber'] = 'Številka ICQ';
$string['idnumber'] = 'Številka ID';
$string['idnumbercourse'] = 'ID številka predmeta';
$string['idnumbercourse_help'] = 'Uporablja se samo za ujemanje predmeta z zunanjimi sistemi. Pustite prazno, če nimate uradne identifikacijske kode predmeta.';
$string['idnumbercoursecategory'] = 'Številka ID kategorije';
$string['idnumbercoursecategory_help'] = 'Številka ID kategorije predmetov se uporablja samo za ujemanje kategorije z zunanjimi sistemi in se nikoli ne prikazuje na tej strani. Če imate uradno kodno ime za to kategorijo, ga uporabite tu, sicer lahko polje pustite prazno.';
$string['idnumbergroup'] = 'Številka ID skupine';
$string['idnumbergroup_help'] = 'Številka ID skupine se uporablja samo za ujemanje te skupine z zunanjimi sistemi in se nikoli ne prikazuje na tej strani. Če imate uradno kodno ime za to skupino, ga lahko vnesete, sicer lahko polje pustite prazno.';
$string['idnumbergrouping'] = 'Številka ID skupka';
$string['idnumbergrouping_help'] = 'Številka ID skupka se uporablja samo za ujemanje tega skupka z zunanjimi sistemi in se nikoli ne prikazuje na tej strani. Če imate uradno kodno ime za ta skupek, ga lahko vnesete, sicer lahko polje pustite prazno.';
$string['idnumbermod'] = 'Številka ID';
$string['idnumbermod_help'] = 'Nastavitev ID števila nudi možnost prepoznavanja dejavnosti za namene kot je izračun ocene ali prilagojena poročila. Sicer je to polje lahko prazno.

Za aktivnosti, ki jih je moč oceniti, se lahko ID število nastavi tudi v redovalnici, vendar ga lahko urejate samo na strani nastavitve dejavnosti.';
$string['idnumbertaken'] = 'Ta številka ID je že zasedena';
$string['imagealt'] = 'Opis slike';
$string['import'] = 'Uvozi';
$string['importdata'] = 'Uvozi podatke predmeta';
$string['importdataexported'] = 'Uspešno izvoženi podatki iz predmeta “iz”.<br /> Nadaljujte z uvažanjem v vaš predmet “v”.';
$string['importdatafinished'] = 'Uvoz dokončan! Nadaljujte v vaš predmet';
$string['importdatafrom'] = 'Najdi predmet za uvoz podatkov iz:';
$string['inactive'] = 'Nedejavno';
$string['include'] = 'Vključi';
$string['includeallusers'] = 'Vključi vse uporabnike';
$string['includecoursefiles'] = 'Vključi datoteke predmeta';
$string['includecourseusers'] = 'Vključi uporabnike predmeta';
$string['included'] = 'Vključeno';
$string['includelogentries'] = 'Vključi dnevniške zapiske';
$string['includemodules'] = 'Vključi module';
$string['includemoduleuserdata'] = 'Vključi podatke o uporabnikih modula';
$string['includeneededusers'] = 'Vključi potrebne uporabnike';
$string['includenoneusers'] = 'Ne vključi uporabnikov';
$string['includeroleassignments'] = 'Vključi dodeljevanje vlog';
$string['includesitefiles'] = 'Vključi datoteke spletnega mesta, ki so uporabljene v tem predmetu';
$string['includeuserfiles'] = 'Vključi uporabnikove datoteke';
$string['increasesections'] = 'Povečaj število odsekov';
$string['indicator:accessesafterend'] = 'Dostop do predmeta po datumu zaključka';
$string['indicator:accessesafterend_help'] = 'Ta kazalnik kaže, ali je udeleženec dostopal do predmeta po datumu zaključka predmeta.';
$string['indicator:accessesbeforestart'] = 'Dostop do predmeta pred datumom začetka';
$string['indicator:accessesbeforestart_help'] = 'Ta kazalnik kaže, ali je udeleženec dostopal do predmeta pred datumom začetka predmeta.';
$string['indicator:activitiesdue'] = 'Skorajšnje dejavnosti';
$string['indicator:activitiesdue_help'] = 'Uporabnik ima skorajšnje dejavnosti.';
$string['indicator:anycourseaccess'] = 'Kateri koli dostop do predmeta';
$string['indicator:anycourseaccess_help'] = 'Ta kazalnik odraža dostop do katerega koli predmeta, v katerega je uporabnik vpisan.';
$string['indicator:anywrite'] = 'Kakršnokoli dejanje pisanja';
$string['indicator:anywrite_help'] = 'Ta kazalnik predstavlja kakršnokoli dejanje pisanja (vnašanja), ki ga izvede udeleženec.';
$string['indicator:anywriteincourse'] = 'Kakršnokoli dejanje pisanja v predmetu';
$string['indicator:anywriteincourse_help'] = 'Ta kazalnik predstavlja kakršnokoli dejanje pisanja (vnašanja), ki ga izvede udeleženec v katerikoli dejavnosti v predmetu.';
$string['indicator:completeduserprofile'] = 'Uporabniški profil je dokončan';
$string['indicator:completeduserprofile_help'] = 'Ta kazalnik kaže, da je udeleženec dokončal svoj uporabniški profil.';
$string['indicator:completeduserprofiledef'] = 'Uporabniški profil je dokončan';
$string['indicator:completeduserprofiledef_help'] = 'Politike spletnega mesta so potrjene in uporabnik je izpolnil sledeča polja: Ustanova, Oddelek, Naslov, Kraj, Država, URL.';
$string['indicator:completionenabled'] = 'Sledenje dejanju dokončanja omogočeno';
$string['indicator:completionenabled_help'] = 'Ta kazalnik kaže, da je bilo sledenje dejanju dokončanja omogočeno za ta predmet.';
$string['indicator:nostudent'] = 'Vpisi udeležencev';
$string['indicator:nostudent_help'] = 'Ta kazalnik odraža razpoložljivost udeležencev v okviru tega predmeta.';
$string['indicator:noteacher'] = 'Razpoložljivost izvajalcev';
$string['indicator:noteacher_help'] = 'Ta kazalnik odraža razpoložljivost izvajalcev v okviru tega predmeta.';
$string['indicator:potentialcognitive'] = 'Stopnja potencialne kognitivne širine predmeta';
$string['indicator:potentialcognitive_help'] = 'Ta kazalnik temelji na potencialni kognitivni angažiranosti, ki jo lahko udeleženci dosežejo s sodelovanjem pri predmetnih dejavnostih.';
$string['indicator:potentialcognitivedef'] = 'Stopnja potencialne kognitivne širine predmeta';
$string['indicator:potentialcognitivedef_help'] = 'Stopnja kognitivne angažiranosti, ki jo predmet omogoča, npr. predložitev dela za povratne informacije, možnost pregleda dela drugih in priložnost za revizijo in ponovno predložitev dela.';
$string['indicator:potentialcognitivedef_link'] = 'Learning_analytics_indicators#Cognitive_depth';
$string['indicator:potentialsocial'] = 'Stopnja potencialne družbene širine predmeta';
$string['indicator:potentialsocial_help'] = 'Ta kazalnik temelji na potencialni družabni širini, ki jo lahko udeleženci dosežejo s sodelovanjem pri predmetnih dejavnostih.';
$string['indicator:potentialsocialdef'] = 'Stopnja potencialne družbene širine predmeta';
$string['indicator:potentialsocialdef_help'] = 'Stopnja, do katere predmet omogoča »široko"družbeno angažiranost, interakcijo z drugimi udeleženci in s skupnostjo prakse izven študijskega okolja.';
$string['indicator:potentialsocialdef_link'] = 'Learning_analytics_indicators#Social_breadth';
$string['indicator:readactions'] = 'Število branj';
$string['indicator:readactions_help'] = 'Ta kazalnik kaže število branj (ogledov), ki jih je izvedel udeleženec.';
$string['indicator:userforumstracking'] = 'Uporabnik spremlja forume';
$string['indicator:userforumstracking_help'] = 'Ta kazalnik kaže, ali ima udeleženec v forumih vklopljeno sledenje ali ne.';
$string['info'] = 'Informacije';
$string['inprogress'] = 'V poteku';
$string['institution'] = 'Ustanova';
$string['instudentview'] = 'v pogledu udeleženca';
$string['interests'] = 'Zanimanja';
$string['interestslist'] = 'Seznam zanimanj';
$string['interestslist_help'] = 'Vnesite svoja zanimanja po vrsti; kot oznake bodo prikazani na strani vašega profila.';
$string['invalidemail'] = 'Neveljaven e-poštni naslov';
$string['invalidlogin'] = 'Neveljavna prijava, poskusite ponovno';
$string['invalidusername'] = 'Uporabniško ime lahko vsebuje samo alfanumerične male znake (črke in števke), podčrtaj (_), vezaj (-), piko (.) in afno (@).';
$string['invalidusernameupload'] = 'Neveljavno uporabniško ime';
$string['ip_address'] = 'Naslov IP';
$string['jump'] = 'Skok';
$string['jumpto'] = 'Skoči na ...';
$string['keep'] = 'Obdrži';
$string['labelvalue'] = '{$a->label}: {$a->value}';
$string['langltr'] = 'Smer jezika od leve proti desni';
$string['langrtl'] = 'Smer jezika od desne proti levi';
$string['language'] = 'Jezik';
$string['languagegood'] = 'Ta jezikovni paket je posodobljen! :-)';
$string['languageselector'] = 'Izbirnik jezika';
$string['last'] = 'Zadnji';
$string['lastaccess'] = 'Zadnji dostop';
$string['lastcourseaccess'] = 'Zadnji dostop do predmeta';
$string['lastedited'] = 'Zadnje urejanje';
$string['lastip'] = 'Zadnji naslov IP';
$string['lastlogin'] = 'Zadnja prijava';
$string['lastmodified'] = 'Zadnja sprememba';
$string['lastname'] = 'Priimek';
$string['lastnamephonetic'] = 'Priimek – fonetično';
$string['lastpage'] = 'Zadnja stran';
$string['lastsiteaccess'] = 'Zadnji dostop do spletnega mesta';
$string['lastyear'] = 'Zadnje leto';
$string['latestlanguagepack'] = 'Preveri zadnji jezikovni paket na moodle.org';
$string['layouttable'] = 'Postavitvena tabela';
$string['leavetokeep'] = 'Pustite prazno za ohranitev trenutnega gesla';
$string['legacylogginginuse'] = 'Ta stran ima omogočeno pisanje v podedovano dnevniško shrambo. Pisanje v to dnevniško shrambo je opuščeno. Pišite v podprti dnevniški shrambi, kot sta \'standardna\' ali \'zunanja\'.';
$string['legacythemeinuse'] = 'To spletno mesto je prikazano v združljivostnem načinu, ker je vaša različica brskalnika prestara.';
$string['license'] = 'Licenca';
$string['licenses'] = 'Licence';
$string['liketologin'] = 'Se želite zdaj prijaviti s polnim uporabniškim računom?';
$string['list'] = 'Seznam';
$string['listfiles'] = 'Seznam datotek v {$a}';
$string['listofallpeople'] = 'Seznam vseh oseb';
$string['listofcourses'] = 'Seznam predmetov';
$string['loading'] = 'Nalaganje';
$string['loadinghelp'] = 'Nalaganje ...';
$string['local'] = 'Lokalno';
$string['localplugins'] = 'Lokalni vtičniki';
$string['localpluginsmanage'] = 'Upravljaj lokalne vtičnike';
$string['location'] = 'Lokacija';
$string['locktimeout'] = 'Pri čakanju na zaklep je operacija časovno potekla.';
$string['log_excel_date_format'] = 'yyyy mmmm d h:mm';
$string['loggedinas'] = 'Prijavljeni ste kot {$a}';
$string['loggedinasguest'] = 'Trenutno uporabljate gostujoči dostop';
$string['loggedinnot'] = 'Niste prijavljeni.';
$string['login'] = 'Prijavite se';
$string['login_failure_logs'] = 'Dnevniki spodletelih prijav';
$string['loginactivity'] = 'Dejavnost prijav';
$string['loginagain'] = 'Ponovno se prijavite';
$string['loginalready'] = 'Ste že prijavljeni';
$string['loginas'] = 'Prijavite se kot';
$string['loginaspasswordexplain'] = '<p>Za uporabo te možnosti morate vnesti posebno "geslo za prijavo kot".<br />Če gesla ne poznate, vprašajte skrbnika strežnika.</p>';
$string['loginguest'] = 'Prijavite se kot gost';
$string['loginsite'] = 'Prijavite se v spletno mesto';
$string['loginsteps'] = 'Za poln dostop do te strani morate najprej ustvariti uporabniški račun.';
$string['loginstepsnone'] = '<p>Pozdravljeni!</p>
<p>Za poln dostop do predmetov morate ustvariti uporabniški račun.</p>
<p>Vse, kar morate narediti, je, da si izmislite uporabniško ime in geslo in ju uporabite v obrazcu na tej strani!</p>
<p>Če je to uporabniško ime že uporabil kdo drug, poskusite znova z drugačnim uporabniškim imenom.</p>';
$string['loginto'] = 'Prijava v {$a}';
$string['logoof'] = 'Odjava iz {$a}';
$string['logout'] = 'Odjava';
$string['logoutconfirm'] = 'Ali se res želite odjaviti?';
$string['logs'] = 'Dnevniki';
$string['logtoomanycourses'] = '[ <a href="{$a->url}">več</a> ]';
$string['logtoomanyusers'] = '[ <a href="{$a->url}">več</a> ]';
$string['lookback'] = 'Poglej nazaj';
$string['mailadmins'] = 'Obvesti skrbnike';
$string['mailstudents'] = 'Obvesti udeležence';
$string['mailteachers'] = 'Obvesti učitelje';
$string['maincoursepage'] = 'Glavna stran predmeta';
$string['makeafolder'] = 'Ustvari mapo';
$string['makeavailable'] = 'Omogoči razpoložljivost';
$string['makeeditable'] = 'Če boste omogočili urejanje \'{$a}\' procesu spletnega strežnika (npr. Apache), boste datoteko lahko urejali neposredno na tej strani';
$string['makethismyhome'] = 'Nastavi kot privzeto domačo stran';
$string['makeunavailable'] = 'Onemogoči razpoložljivost';
$string['manageblocks'] = 'Bloki';
$string['managecategories'] = 'Upravljaj kategorije predmetov';
$string['managecategorythis'] = 'Upravljaj to kategorijo';
$string['managecombined'] = 'Upravljaj kategorije predmetov in predmete';
$string['managecontentbanktypes'] = 'Upravljaj s tipi vsebin';
$string['managecourses'] = 'Upravljaj predmete';
$string['managedatabase'] = 'Podatkovna baza';
$string['managedataformats'] = 'Upravljaj podatkovne formate';
$string['manageeditorfiles'] = 'Urejaj datoteke, ki jih uporablja urejevalnik';
$string['managefilters'] = 'Filtri';
$string['managemodules'] = 'Moduli';
$string['manageroles'] = 'Vloge in dovoljenja';
$string['markallread'] = 'Označi vse kot prebrano';
$string['markedthistopic'] = 'Ta tema je označena kot trenutna tema';
$string['markthistopic'] = 'Označi to temo kot trenutno temo';
$string['match'] = 'Ujemanje';
$string['matchingsearchandrole'] = 'Ujemanje \'{$a->search}\' in {$a->role}';
$string['matchofthefollowing'] = 'izmed sledečih:';
$string['maxareabytesreached'] = 'Velikost datotek(e) je večja od prostora, ki je še na voljo na tem mestu.';
$string['maxfilesize'] = 'Največja velikost novih datotek: {$a}';
$string['maxfilesreached'] = 'K temu elementu lahko pripnete največ {$a} datotek';
$string['maximumchars'] = 'Največ {$a} znakov';
$string['maximumgrade'] = 'Najvišja ocena';
$string['maximumgradex'] = 'Najvišja ocena: {$a}';
$string['maximumshort'] = 'Maks';
$string['maximumupload'] = 'Največja velikost naložene datoteke';
$string['maximumupload_help'] = 'Največja velikost datoteke, ki jo lahko naložijo udeleženci v predmetu. To velikost je možno dodatno omejiti z nastavitvami znotraj posamezne dejavnosti.';
$string['maxnumberweeks'] = 'Najvišje število odsekov';
$string['maxnumberweeks_desc'] = 'Najvišja vrednost v spustnem seznamu števila odsekov (v uporabi le pri nekaterih formatih predmetov).';
$string['maxnumcoursesincombo'] = 'Brskaj <a href="{$a->link}">{$a->numberofcourses} predmetov</a>.';
$string['maxsectionslimit'] = 'Ni mogoče ustvariti novega odseka, ker bi presegalo največje število odsekov, dovoljenih za ta predmet ({$a}).';
$string['maxsize'] = 'Max velikost: {$a}';
$string['maxsizeandareasize'] = 'Največja dovoljena velikost novih datotek: {$a->size}, celotna omejitev: {$a->areasize}';
$string['maxsizeandattachments'] = 'Največja velikost datoteke: {$a->size}, največje število datotek: {$a->attachments}';
$string['maxsizeandattachmentsandareasize'] = 'Največja velikost datoteke: {$a->size}, najvišje število priponk: {$a->attachments}, celotna omejitev: {$a->areasize}';
$string['memberincourse'] = 'Osebe v predmetu';
$string['menu'] = 'Meni';
$string['message'] = 'Sporočilo';
$string['messagebody'] = 'Telo sporočila';
$string['messagedselectedusers'] = 'Izbrani uporabniki so bili obveščeni. Seznam prejemnikov je bil ponastavljen.';
$string['messagedselectedusersfailed'] = 'Prišlo je do napake pri obveščanju izbranih uporabnikov. Nekateri so morda prejeli e-sporočilo.';
$string['messageprovider:asyncbackupnotification'] = 'Obvestila o asinhronem varnostnem kopiranju/obnovi';
$string['messageprovider:availableupdate'] = 'Obvestila o razpoložljivih posodobitvah';
$string['messageprovider:backup'] = 'Obvestila o varnostnem kopiranju';
$string['messageprovider:badgecreatornotice'] = 'Obvestila ustvarjalca značke';
$string['messageprovider:badgerecipientnotice'] = 'Obvestila prejemnika značke';
$string['messageprovider:competencyplancomment'] = 'Objavljen je komentar na učni načrt';
$string['messageprovider:competencyusercompcomment'] = 'Objavljen je komentar na kompetenco';
$string['messageprovider:coursecompleted'] = 'Predmet zaključen';
$string['messageprovider:coursecontentupdated'] = 'Spremembe vsebine predmeta';
$string['messageprovider:courserequestapproved'] = 'Obvestilo o odobritvi zahteve za ustvarjanje novega predmeta';
$string['messageprovider:courserequested'] = 'Obvestilo o zahtevi za nov predmet';
$string['messageprovider:courserequestrejected'] = 'Obvestilo o zavrnitvi zahteve za ustvarjanje novega predmeta';
$string['messageprovider:errors'] = 'Pomembne napake spletnega mesta';
$string['messageprovider:errors_help'] = 'To so pomembne napake, ki bi jih skrbnik moral poznati.';
$string['messageprovider:gradenotifications'] = 'Obvestila o ocenah';
$string['messageprovider:infected'] = 'Obvestila o napaki protivirusnega programa.';
$string['messageprovider:insights'] = 'Spoznanja, ustvarjena z modeli predvidevanj';
$string['messageprovider:instantmessage'] = 'Osebna sporočila med uporabniki';
$string['messageprovider:instantmessage_help'] = 'Ta odsek določa, kaj se zgodi s sporočili, ki vam jih neposredno pošljejo drugi uporabniki tega spletnega mesta.';
$string['messageprovider:messagecontactrequests'] = 'Obvestilo o zahtevah za sporočila stikom';
$string['messageprovider:notices'] = 'Obvestila o manjših problemih';
$string['messageprovider:notices_help'] = 'To so obvestila, ki bi lahko zanimale skrbnika.';
$string['messageselect'] = 'Izberite tega uporabnika kot prejemnika sporočila';
$string['messageselectadd'] = 'Pošlji sporočilo';
$string['middlename'] = 'Srednje ime';
$string['migratinggrades'] = 'Selitev ocen';
$string['min'] = 'min';
$string['mins'] = 'min';
$string['minute'] = 'minuta';
$string['minutes'] = 'minute';
$string['miscellaneous'] = 'Razno';
$string['missingcategory'] = 'Izbrati morate kategorijo';
$string['missingdescription'] = 'Manjka opis';
$string['missingemail'] = 'Manjka e-poštni naslov';
$string['missingfirstname'] = 'Manjka ime';
$string['missingfromdisk'] = 'Manjka iz diska';
$string['missingfullname'] = 'Manjka polno ime';
$string['missinglastname'] = 'Manjka priimek';
$string['missingname'] = 'Manjka ime';
$string['missingnewpassword'] = 'Manjka novo geslo';
$string['missingpassword'] = 'Manjkajoče geslo';
$string['missingrecaptchachallengefield'] = 'Preizkus reCAPTCHA je spodletel, poskusite znova.';
$string['missingreqreason'] = 'Manjka razlog';
$string['missingshortname'] = 'Manjka kratko ime';
$string['missingshortsitename'] = 'Manjka kratko ime spletnega mesta';
$string['missingsitedescription'] = 'Manjka opis spletnega mesta';
$string['missingsitename'] = 'Manjka ime spletnega mesta';
$string['missingstrings'] = 'Preveri neprevedene besede ali besedne zveze';
$string['missingstudent'] = 'Nekaj je treba izbrati';
$string['missingsummary'] = 'Manjka povzetek';
$string['missingteacher'] = 'Nekaj je treba izbrati';
$string['missingurl'] = 'Manjka URL';
$string['missingusername'] = 'Manjka uporabniško ime';
$string['moddoesnotsupporttype'] = 'Modul {$a->modname} ne podpira nalaganje datotek vrste {$a->type}';
$string['modhide'] = 'Skrij';
$string['modified'] = 'Spremenjeno';
$string['modshow'] = 'Pokaži';
$string['moduleintro'] = 'Opis';
$string['modulesetup'] = 'Nastavitev tabel modula';
$string['modulesuccess'] = '{$a} tabele so nastavljene pravilno';
$string['modulesused'] = 'Uporabljeni moduli';
$string['modvisible'] = 'Razpoložljivost';
$string['modvisible_help'] = '* Pokaži na strani predmeta: na voljo udeležencem (mogoče so dodatne omejitve dostopa).
* Skrij na strani predmeta: ni na voljo udeležencem.';
$string['modvisiblehiddensection'] = 'Razpoložljivost';
$string['modvisiblehiddensection_help'] = '* Skrij na strani predmeta: ni na voljo udeležencem.
* Na voljo, a ne prikaži na strani predmeta: na voljo udeležencem, če jim posredujete povezavo. Aktivnost bo kljub temu prikazana v redovalnici in v drugih poročilih.';
$string['modvisiblewithstealth'] = 'Razpoložljivost';
$string['modvisiblewithstealth_help'] = '* Pokaži na strani predmeta: na voljo udeležencem (mogoče so dodatne omejitve dostopa).
* Skrij na strani predmeta: ni na voljo udeležencem.
* Na voljo, a ne prikaži na strani predmeta: na voljo udeležencem, če jim posredujete povezavo. Aktivnost bo kljub temu prikazana v redovalnici in v drugih poročilih.';
$string['month'] = 'Mesec';
$string['months'] = 'Meseci';
$string['moodledocs'] = 'Moodle dokumenti';
$string['moodledocslink'] = 'Pomoč in dokumentacija';
$string['moodlelogo'] = 'Logotip Moodle';
$string['moodlerelease'] = 'Izdaja Moodle';
$string['moodleservicesandsupport'] = 'Storitve in podpora';
$string['moodleversion'] = 'Različica Moodle';
$string['more'] = 'več';
$string['moreactions'] = 'Več dejanj';
$string['morehelp'] = 'Pomoč Moodle';
$string['morehelpaboutmodule'] = 'Več pomoči za dejavnost {$a}';
$string['moreinfo'] = 'Več o tem';
$string['moreinformation'] = 'Več o tej napaki';
$string['moremenu'] = 'Več';
$string['morenavigationlinks'] = 'Več ...';
$string['moreprofileinfoneeded'] = 'Povejte nam kaj več o sebi';
$string['mostrecently'] = 'nazadnje';
$string['move'] = 'Premakni';
$string['movecategoriessuccess'] = 'Uspešno premaknjenih {$a->count} kategorij v kategorijo \'{$a->to}\'';
$string['movecategoriestotopsuccess'] = 'Uspešno premaknjenih {$a->count} kategorij na vrhnjo raven';
$string['movecategorycontentto'] = 'Premakni v';
$string['movecategorysuccess'] = 'Kategorija \'{$a->moved}\' uspešno premaknjena v kategorijo \'{$a->to}\'';
$string['movecategoryto'] = 'Premakni kategorijo v:';
$string['movecategorytotopsuccess'] = 'Kategorija »{$a->moved}« uspešno premaknjena na vrhnjo raven';
$string['movecontent'] = 'Premakni {$a}';
$string['movecontentafter'] = 'Po "{$a}"';
$string['movecontentstoanothercategory'] = 'Premakni vsebino v drugo kategorijo';
$string['movecontenttothetop'] = 'Na vrh seznama';
$string['movecoursemodule'] = 'Premakni dejavnost';
$string['movecoursesection'] = 'Premakni odsek';
$string['movecourseto'] = 'Premakni predmet v:';
$string['movedown'] = 'Premakni navzdol';
$string['movefilestohere'] = 'Premakni datoteke sem';
$string['movefull'] = 'Premakni {$a} na to mesto';
$string['movehere'] = 'Premakni sem';
$string['moveleft'] = 'Premakni levo';
$string['moveright'] = 'Premakni desno';
$string['movesection'] = 'Premakni odsek {$a}';
$string['moveselectedcategoriesto'] = 'Premakni izbrane kategorije v';
$string['moveselectedcoursesto'] = 'Premakni izbrane predmete v ...';
$string['movetoanotherfolder'] = 'Premakni v drugo mapo';
$string['moveup'] = 'Premakni navzgor';
$string['msnid'] = 'MSN ID';
$string['mustchangepassword'] = 'Novo geslo mora biti drugačno od trenutnega';
$string['mustconfirm'] = 'Svoj račun morate potrditi';
$string['mycourses'] = 'Moji predmeti';
$string['myfiles'] = 'Moje zasebne datoteke';
$string['myfilesmanage'] = 'Upravljaj moje zasebne datoteke';
$string['myhome'] = 'Nadzorna plošča';
$string['mymoodledashboard'] = 'Nadzorna plošča Moj Moodle';
$string['myprofile'] = 'Moj profil';
$string['name'] = 'Ime';
$string['namedfiletoolarge'] = 'Datoteka »{$a->filename}« je prevelika in je ni mogoče naložiti';
$string['nameforlink'] = 'Kako želite poimenovati to povezavo?';
$string['nameforpage'] = 'Ime';
$string['navigation'] = 'Navigacija';
$string['needed'] = 'Potrebno';
$string['networkdropped'] = 'Zaznali smo, da je vaša internetna povezava nezanesljiva ali pa je bila prekinjena. <br />
Spremembe ne bodo pravilno shranjene, dokler se povezava ne izboljša.';
$string['never'] = 'Nikoli';
$string['neverdeletelogs'] = 'Nikoli ne briši dnevnikov';
$string['new'] = 'Novo';
$string['newaccount'] = 'Nov račun';
$string['newactivityname'] = 'Novo ime za dejavnost {$a}';
$string['newcourse'] = 'Nov predmet';
$string['newloginnotificationbodyfull'] = '<p>Pozdravljeni {$a->userfullname},</p>
<p/>Za vaš račun na {$a->sitename} je bila pravkar zaznana prijava iz nove naprave..</p>
<ul>
<li>Vaš račun: {$a->username} {$a->useremail}</li>
<li>{$a->logintime}</li>
<li>Naprava: {$a->logindevice}</li>
<li>IP: {$a->loginip}</li>
</ul>
<p>Če ste to bili vi, potem vam ni potrebno storiti ničesar.</p>
<p>Če te aktivnosti ne prepoznate, vam svetujemo, da <a href="{$a->changepasswordlink}">zamenjate geslo</a>.</p>';
$string['newloginnotificationbodysmall'] = 'Za vaš račun na {$a} je bila pravkar zaznana prijava iz nove naprave.';
$string['newloginnotificationtitle'] = 'Nova prijava v vaš račun na {$a}';
$string['newpassword'] = 'Novo geslo';
$string['newpassword_help'] = 'Vnesite novo geslo ali pustite prazno, da ohranite trenutno geslo.';
$string['newpasswordfromlost'] = '<strong>OPOMBA:</strong> Vaše <strong>trenutno geslo</strong> vam bo poslano <strong>v drugem</strong> izmed dveh e-poštnih sporočil, ki sestavljata postopek obnove pozabljenega gesla. Preverite, če ste prejeli vaše nadomestno geslo, preden nadaljujete s to stranjo.';
$string['newpasswordtext'] = 'Pozdravljeni {$a->firstname},

Geslo vašega računa na \'{$a->sitename}\' je bilo ponastavljeno
in izdano vam je bilo novo začasno geslo.

Vaši trenutni podatki za prijavo so:
 Uporabniško ime: {$a->username}
 Geslo: {$a->newpassword}

Obiščite to stran za spremembo vašega gesla:
 {$a->link}

V večini e-poštnih programov bi se moral naslov pojaviti kot modra povezava,
na katero lahko preprosto kliknete. Če to ne deluje,
potem naslov kopirajte in ga prilepite v naslovno
vrstico na vrhu okna vašega spletnega brskalnika.

Pozdrav, skrbnik \'{$a->sitename}\',
{$a->signoff}';
$string['newpicture'] = 'Nova slika';
$string['newpicture_help'] = 'Če želite dodati novo sliko, poiščite in izberite sliko (v formatu JPG ali PNG), nato pa kliknite na »Posodobi profil«. Slika bo obrezana v kvadrat, njena velikost pa bo spremenjena na 100x100 pikslov.';
$string['newpictureusernotsetup'] = 'Sliko profila je mogoče dodati šele, ko so vsi zahtevani podatki za profil shranjeni.';
$string['newsectionname'] = 'Novo ime za odsek {$a}';
$string['newsitem'] = 'element novic';
$string['newsitems'] = 'obvestila';
$string['newsitemsnumber'] = 'Število novic';
$string['newsitemsnumber_help'] = 'Forum obvestil ima privzeto nastavljeno vsiljeno naročnino. Na njem lahko objavljajo le učitelji in drugi uporabniki z ustreznimi dovoljenji.

Če forum obvestil v predmetu ni potreben, to možnost nastavite na nič.

Ta nastavitev tudi določa, koliko nedavnih sporočil se prikaže v bloku z zadnjimi obvestili.';
$string['newuser'] = 'Nov uporabnik';
$string['newusernewpasswordsubj'] = 'Nov uporabniški račun';
$string['newusernewpasswordtext'] = 'Pozdravljeni {$a->firstname},

Za vas je bil ustvarjen nov uporabniški račun na \'{$a->sitename}\'
in izdano vam je bilo novo začasno geslo.

Vaši trenutni podatki za prijavo so:

   Uporabniško ime: {$a->username}
   Geslo: {$a->newpassword}
             (ob prvi prijavi boste pozvani k spremembi gesla)

Za začetek uporabe \'{$a->sitename}\', se prijavite na naslovu
   {$a->link}

V večini e-poštnih odjemalcev, bi se moral naslov pojaviti kot modra
povezava na katero lahko preprosto kliknete, sicer kopirajte in
prilepite naslov v naslovno vrstico vašega spletnega brskalnika.

Pozdrav, skrbnik \'{$a->sitename}\',
{$a->signoff}';
$string['newusers'] = 'Novi uporabniki';
$string['newwindow'] = 'Novo okno';
$string['next'] = 'Naprej';
$string['nextpage'] = 'Naslednja stran';
$string['nextsection'] = 'Naslednji odsek';
$string['no'] = 'Ne';
$string['noblockstoaddhere'] = 'Ni blokov, ki jih lahko dodate na to stran.';
$string['nobody'] = 'Nihče';
$string['nochange'] = 'Ni sprememb';
$string['nocomments'] = 'Ni komentarjev';
$string['nocourses'] = 'Ni predmetov';
$string['nocoursesfound'] = 'Nobenega predmeta z besedami \'{$a}\' ni bilo mogoče najti';
$string['nocoursestarttime'] = 'Predmet nima določenega časa začetka.';
$string['nocoursesyet'] = 'Ni predmetov v tej kategoriji';
$string['nodstpresets'] = 'Skrbnik ni omogočil podpore za poletni čas.';
$string['nofilesselected'] = 'Za obnovitev ni izbrana nobena datoteka';
$string['nofilesyet'] = 'V vaš predmet še ni naložena nobena datoteka';
$string['nofiltersapplied'] = 'Filtri niso uporabljeni';
$string['nograde'] = 'Ni ocene';
$string['nohelpforactivityorresource'] = 'Pomoč za ta vir ali dejavnost trenutno ne obstaja';
$string['noimagesyet'] = 'V vaš predmet ni bila naložena še nobena slika';
$string['nologsfound'] = 'Ni najdenih dnevniških zapisov';
$string['nomatchingusers'] = 'Ni uporabnikov, ki ustrezajo \'{$a}\'';
$string['nomorecourses'] = 'Ni mogoče najti več ustreznih predmetov';
$string['nomoreidnumber'] = 'Ne uporabljaj ID številke v izogib trkom';
$string['none'] = 'Brez';
$string['noneditingteacher'] = 'Učitelj brez pravic urejanja';
$string['noneditingteacherdescription'] = 'Učitelji brez pravic urejanja lahko poučujejo in ocenjujejo udeležence pri predmetu, vendar ne smejo spreminjati aktivnosti.';
$string['nonstandard'] = 'Nestandardno';
$string['nopendingcourses'] = 'Ni predmetov, ki čakajo na odobritev';
$string['nopotentialadmins'] = 'Ni možnih skrbnikov';
$string['nopotentialcreators'] = 'Ni možnih ustvarjalcev predmetov';
$string['nopotentialstudents'] = 'Ni možnih udeležencev';
$string['nopotentialteachers'] = 'Ni možnih učiteljev';
$string['norecentactivity'] = 'Ni nedavnih dejavnosti';
$string['noreplybouncemessage'] = 'Odgovorili ste na e-poštni naslov, ki ni namenjen odgovorom. Če ste poskušali odgovoriti na forumsko objavo, odgovorite na forumu {$a}.

To je vsebina vašega e-sporočila:';
$string['noreplybouncesubject'] = '{$a} - odklonjeno e-sporočilo.';
$string['noreplyname'] = 'Ne odgovarjajte na to e-sporočilo';
$string['noresetrecord'] = 'Ni zapisa o prošnji za ponastavitev gesla. Prosimo, začnite novo ponastavitev gesla.';
$string['noresults'] = 'Ni rezultatov';
$string['normal'] = 'Običajno';
$string['normalfilter'] = 'Navadno iskanje';
$string['nosite'] = 'Ni bilo mogoče najti predmeta na ravni spletnega mesta';
$string['nostudentsfound'] = 'Ni najdenih {$a}';
$string['nostudentsingroup'] = 'V tej skupini še ni udeležencev';
$string['nostudentsyet'] = 'V tem predmetu ni vpisanih udeležencev.';
$string['nosuchemail'] = 'Ni takega e-poštnega naslova';
$string['notavailable'] = 'Ni na voljo';
$string['notavailablecourse'] = '{$a} ni na voljo';
$string['noteachersyet'] = 'V tem predmetu še ni učiteljev';
$string['noteachingupcomingcourses'] = 'Prihajajoči predmeti nimajo izvajalcev ali udeležencev';
$string['notenrolled'] = '{$a} ni vpisan v ta predmet.';
$string['notenrolledprofile'] = 'Profil ni na voljo, ker uporabnik ni vpisan v ta predmet.';
$string['noteusercannotrolldatesoncontext'] = '<strong>Opomba:</strong> Možnost, da povozite datum, ko obnavljate to varnostno kopijo, je onemogočena, ker nimate potrebnih dovoljenj.';
$string['noteuserschangednonetocourse'] = '<strong>Opomba:</strong> uporabniki predmeta morajo biti obnovljeni, ko obnavljate uporabniške podatke (v dejavnostih, datotekah ali sporočilih). Ta nastavitev je bila spremenjena za vas.';
$string['nothingnew'] = 'Ni nedavnih dejavnosti';
$string['nothingtodisplay'] = 'Ničesar za prikaz';
$string['notice'] = 'Obvestilo';
$string['noticenewerbackup'] = 'Ta datoteka varnostne kopije je bila ustvarjena z Moodle {$a->backuprelease} ({$a->backupversion}) in je novejša od vaše trenutno nameščene različice Moodla {$a->serverrelease} ({$a->serverversion}). To lahko povzroči določena neskladja, saj združljivost za nazaj ne more biti zagotovljena.';
$string['notifications'] = 'Obvestila';
$string['notifyloginfailuresmessage'] = '{$a->time}, IP: {$a->ip}, uporabnik: {$a->info}, polno ime uporabnika: {$a->name}';
$string['notifyloginfailuresmessageend'] = 'Te dnevnike si lahko ogledate na {$a}';
$string['notifyloginfailuresmessagestart'] = 'Tu je seznam neuspešnih poskusov prijav v {$a}, odkar ste bili zadnjič obveščeni';
$string['notifyloginfailuressubject'] = '{$a} :: obvestilo o neuspešnih prijavah';
$string['notincluded'] = 'Ni vključeno';
$string['notingroup'] = 'Žal morate biti del skupine, da bi videli to stran.';
$string['notpublic'] = 'Ni javno!';
$string['nousersfound'] = 'Ni najdenih uporabnikov';
$string['nousersmatching'] = 'Ni bilo mogoče najti uporabnika, ki bi ustrezal \'{$a}\'';
$string['nousersyet'] = 'Ni še uporabnikov';
$string['novalidcourses'] = 'Ni veljavnih predmetov za prikaz';
$string['now'] = 'zdaj';
$string['numattempts'] = 'Št. neuspešnih poskusov prijave: {$a}';
$string['numberofcourses'] = 'Število predmetov';
$string['numberweeks'] = 'Število odsekov';
$string['numday'] = '{$a} dan';
$string['numdays'] = '{$a} dni';
$string['numhours'] = '{$a} ur';
$string['numletters'] = '{$a} črk';
$string['numminutes'] = '{$a} minut';
$string['nummonth'] = '{$a} mesec';
$string['nummonths'] = '{$a} mesecev';
$string['numseconds'] = '{$a} sekund';
$string['numviews'] = '{$a} ogledov';
$string['numweek'] = '{$a} teden';
$string['numweeks'] = '{$a} tednov';
$string['numwords'] = '{$a} besed';
$string['numyear'] = '{$a} leto';
$string['numyears'] = '{$a} let';
$string['ok'] = 'V redu';
$string['oldpassword'] = 'Trenutno geslo';
$string['olduserdirectory'] = 'To je STAR imenik uporabnikov, ki ni več potreben. Lahko ga varno izbrišete. Datoteke, ki jih vsebuje, so bile kopirane v NOV imenik uporabnikov.';
$string['opendrawerblocks'] = 'Odpri predal blokov';
$string['opendrawerindex'] = 'Odpri kazalo predmeta';
$string['opensinnewwindow'] = 'Odpre se v novem oknu';
$string['operator_and'] = 'in';
$string['operator_andnot'] = 'in';
$string['operator_or'] = 'ali';
$string['optional'] = 'neobvezno';
$string['options'] = 'možnosti';
$string['order'] = 'Vrstni red';
$string['originalpath'] = 'Izvirna pot';
$string['orphanedactivitiesinsectionno'] = 'Osirotele dejavnosti (odsek {$a})';
$string['other'] = 'Drugo';
$string['outline'] = 'Povzetek';
$string['outlinereport'] = 'Oris poročila';
$string['page'] = 'Stran';
$string['pagea'] = 'Stran {$a}';
$string['pagedcontentnavigation'] = 'Krmarjenje po številčenju strani';
$string['pagedcontentnavigationactiveitem'] = 'Trenutna stran, stran {$a}';
$string['pagedcontentnavigationitem'] = 'Pojdi na stran {$a}';
$string['pagedcontentpagingbaritemsperpage'] = 'Pokaži {$a} elementov na stran';
$string['pageheaderconfigablock'] = 'Konfiguriranje bloka v {$a->fullname}';
$string['pagepath'] = 'Pot strani';
$string['pageshouldredirect'] = 'Ta stran bi se morala samodejno preusmeriti. Če se ni, kliknite na spodnjo povezavo.';
$string['parentcategory'] = 'Nadrejena kategorija';
$string['parentcoursenotfound'] = 'Nadrejenega predmeta ni bilo mogoče najti!';
$string['parentfolder'] = 'Nadrejena mapa';
$string['participants'] = 'Sodelujoči';
$string['participantslist'] = 'Seznam sodelujočih';
$string['participationratio'] = 'Razmerje sodelovanja';
$string['participationreport'] = 'Poročilo o sodelovanju';
$string['password'] = 'Geslo';
$string['passwordchanged'] = 'Geslo je spremenjeno';
$string['passwordconfirmchange'] = 'Potrdi spremembo gesla';
$string['passwordextlink'] = 'Sledeča povezava vam omogoča obnovo pozabljenega gesla. S tem boste zapustili Moodle.';
$string['passwordforgotten'] = 'Pozabljeno geslo';
$string['passwordforgotteninstructions'] = 'Vaše podatke je treba najprej najti v podatkovni zbirki uporabnikov. V ustrezno polje vnesite <strong>bodisi</strong> vaše uporabniško ime ali e-poštni naslov, ki ste ga uporabili ob registraciji. Ni treba vnesti obojega.';
$string['passwordforgotteninstructions2'] = 'Če želite ponastaviti geslo, vpišite svoje uporabniško ime ali vaš e-poštni naslov. Če vas najdemo v podatkovni zbirki, bo e-sporočilo z navodili za dostop poslano na vaš e-poštni naslov.';
$string['passwordnohelp'] = 'Pomoč za iskanje izgubljenega gesla ni na voljo. Obrnite se na vašega skrbnika Moodla.';
$string['passwordpolicynomatch'] = 'Vaše trenutno geslo ni več v skladu z nastavljenim pravilnikom za gesla.
   {$a}';
$string['passwordrecovery'] = 'Da, potrebujem pomoč pri prijavi';
$string['passwordsdiffer'] = 'Ti dve gesli se ne ujemata';
$string['passwordsent'] = 'Geslo je poslano';
$string['passwordsenttext'] = '<p>E-pošta je bila poslana na vaš naslov: {$a->email}.</p>
 <p><b>Preverite vaš e-nabiralnik za novo geslo</b></p>
 <p>Novo geslo je bilo generirano samodejno, morda boste želeli
 <a href="{$a->link}">spremeniti geslo v nekaj, kar si boste lažje zapomnili</a>.</p>';
$string['passwordset'] = 'Vaše geslo je nastavljeno.';
$string['path'] = 'Pot';
$string['pathnotexists'] = 'Pot ne obstaja na vašem strežniku!';
$string['pathslasherror'] = 'Pot se ne sme končati s poševnico!!';
$string['paymentinstant'] = 'Uporabite spodnji gumb za plačilo in vpisani boste v nekaj minutah!';
$string['paymentpending'] = '(<small><b><u>{$a}</u></b> v čakanju</small>)';
$string['paymentrequired'] = 'Ta predmet zahteva plačilo za vstop.';
$string['payments'] = 'Plačila';
$string['paymentsorry'] = 'Hvala za vaše plačilo! Žal plačilo še ni bilo v celoti obdelano in zato še niste registrirani za vstop v predmet "{$a->fullname}". Prosimo, poskusite nadaljevati v predmet čez nekaj sekund, če imate še vedno težave, pa na to opozorite {$a->teacher} predmeta ali skrbnika spletnega mesta';
$string['paymentthanks'] = 'Hvala za vaše plačilo! Zdaj ste vpisani v predmet:<br />"{$a}"';
$string['pendingrequests'] = 'Zahteve v čakanju';
$string['percents'] = '{$a}%';
$string['periodending'] = 'Konec obdobja ({$a})';
$string['perpage'] = 'Na stran';
$string['perpagea'] = 'Na stran: {$a}';
$string['personal'] = 'Osebno';
$string['personalprofile'] = 'Osebni profil';
$string['phone'] = 'Telefon';
$string['phone1'] = 'Telefon';
$string['phone2'] = 'Številka mobilnega telefona';
$string['phpinfo'] = 'Informacije PHP';
$string['picture'] = 'Slika';
$string['pictureof'] = 'Slika {$a}';
$string['pictureofuser'] = 'Slika uporabnika';
$string['placeholdertypeorselect'] = 'Vnesi ali izberi …';
$string['pleaseclose'] = 'Zaprite to okno.';
$string['pleasesearchmore'] = 'Poiščite več';
$string['pleaseusesearch'] = 'Prosimo, uporabite iskanje';
$string['plugin'] = 'Vtičnik';
$string['pluginarea'] = 'Področje';
$string['plugincheck'] = 'Preverjanje vtičnikov';
$string['plugindeletefiles'] = 'Vsi podatki, povezani z vtičnikom \'{$a->name}\', so bili izbrisani iz podatkovne baze. Da bi preprečili samodejno ponovno namestitev vtičnika, morate izbrisati to mapo s strežnika: {$a->directory}';
$string['pluginitemid'] = '';
$string['pluginsetup'] = 'Nastavitev tabel vtičnikov';
$string['policyaccept'] = 'Razumem in se strinjam';
$string['policyagree'] = 'Za nadaljnjo uporabo tega spletnega mesta se morate strinjati s temi pravili. Ali se strinjate?';
$string['policyagreement'] = 'Pravila spletnega mesta';
$string['policyagreementclick'] = 'Povezava do pravil spletnega mesta';
$string['popup'] = 'pojavno';
$string['popupwindow'] = 'Odpri datoteko v novem oknu';
$string['popupwindowname'] = 'Pojavno okno';
$string['post'] = 'Objava';
$string['posts'] = 'Objave';
$string['potentialadmins'] = 'Možni skrbniki';
$string['potentialcreators'] = 'Možni ustvarjalci predmetov';
$string['potentialstudents'] = 'Možni udeleženci';
$string['potentialteachers'] = 'Možni učitelji';
$string['poweredbymoodle'] = 'Stran poganja <a href="https://moodle.com">Moodle</a>';
$string['preferences'] = 'Nastavitve';
$string['preferredlanguage'] = 'Želeni jezik';
$string['preferredtheme'] = 'Želena tema';
$string['preprocessingbackupfile'] = 'Vnaprejšnja obdelava varnostne kopije';
$string['prev'] = 'Prejšnji';
$string['preview'] = 'Predogled';
$string['previeworchoose'] = 'Predogled ali izbor teme';
$string['previous'] = 'Prejšnji';
$string['previouslyselectedusers'] = 'Prej izbrani uporabniki ne ustrezajo \'{$a}\'';
$string['previouspage'] = 'Prejšnja stran';
$string['previoussection'] = 'Prejšnji odsek';
$string['primaryadminsetup'] = 'Nastavi skrbniški račun';
$string['privacy:metadata:config_log'] = 'Dnevnik sprememb konfiguracije.';
$string['privacy:metadata:config_log:name'] = 'Ime sprememb nastavitev.';
$string['privacy:metadata:config_log:oldvalue'] = 'Prejšnja vrednost te nastavitve.';
$string['privacy:metadata:config_log:plugin'] = 'Vtičnik spremenjen.';
$string['privacy:metadata:config_log:timemodified'] = 'Čas, ko je bila narejena sprememba.';
$string['privacy:metadata:config_log:userid'] = 'Uporabnik, ki je naredil spremembo.';
$string['privacy:metadata:config_log:value'] = 'Nova vrednost te nastavitve.';
$string['privacy:metadata:events_queue'] = 'Čakalna vrsta uporabniških dogodkov, ki čakajo na izvršbo.';
$string['privacy:metadata:events_queue:eventdata'] = 'Podatki, shranjeni v tem dogodku.';
$string['privacy:metadata:events_queue:stackdump'] = 'Katerakoli sled sklada, povezana s tem dogodkom.';
$string['privacy:metadata:events_queue:timecreated'] = 'Čas, ko je bil ta dogodek ustvarjen.';
$string['privacy:metadata:events_queue:userid'] = 'Uporabniški ID, povezan s tem dogodkom';
$string['privacy:metadata:log'] = 'Zbirka preteklih dogodkov';
$string['privacy:metadata:log:action'] = 'Opis ukaza';
$string['privacy:metadata:log:cmid'] = 'cmid';
$string['privacy:metadata:log:course'] = 'predmet';
$string['privacy:metadata:log:info'] = 'Dodatne informacije';
$string['privacy:metadata:log:ip'] = 'IP naslov, uporabljen v času dogodka';
$string['privacy:metadata:log:module'] = 'modul';
$string['privacy:metadata:log:time'] = 'Čas izvedbe ukaza';
$string['privacy:metadata:log:url'] = 'URL, povezan s tem dogodkom';
$string['privacy:metadata:log:userid'] = 'ID uporabnika, ki je izvršil dejanje';
$string['privacy:metadata:oauth2_refresh_token'] = 'Žeton za osveževanje, uporabljen v komunikaciji OAuth 2.0';
$string['privacy:metadata:oauth2_refresh_token:issuerid'] = 'ID izdajatelja, s katerim se žeton ujema';
$string['privacy:metadata:oauth2_refresh_token:scopehash'] = 'ID uporabnika, s katerim se žeton ujema';
$string['privacy:metadata:oauth2_refresh_token:timecreated'] = 'Čas stvaritve žetona';
$string['privacy:metadata:oauth2_refresh_token:timemodified'] = 'Čas zadnje posodobitve žetona';
$string['privacy:metadata:oauth2_refresh_token:token'] = 'Žeton za osveževanje za zadevni obseg in uporabnika';
$string['privacy:metadata:oauth2_refresh_token:userid'] = 'ID uporabnika, s katerim se žeton ujema';
$string['privacy:metadata:task_adhoc'] = 'Status ad hoc opravil.';
$string['privacy:metadata:task_adhoc:component'] = 'Komponenta, ki si lasti opravilo.';
$string['privacy:metadata:task_adhoc:nextruntime'] = 'Najzgodnejši čas za izvršbo tega opravila.';
$string['privacy:metadata:task_adhoc:userid'] = 'Kateri uporabnik naj izvrši pravilo.';
$string['privacy:metadata:task_log'] = 'Dnevniški izpis za dnevnik';
$string['privacy:metadata:task_log:component'] = 'Komponenta, ki si lasti opravilo.';
$string['privacy:metadata:task_log:userid'] = 'Uporabnik, ki mu je opravilo pripadalo.';
$string['privacy:metadata:upgrade_log'] = 'Dnevnik nadgradnje.';
$string['privacy:metadata:upgrade_log:backtrace'] = 'Kakršnakoli sled, povezana s tem korakom nadgradnje.';
$string['privacy:metadata:upgrade_log:details'] = 'Dodatne informacije o posodobitvi.';
$string['privacy:metadata:upgrade_log:info'] = 'Glavne informacije za ta korak nadgradnje.';
$string['privacy:metadata:upgrade_log:plugin'] = 'Vtičnik, ki je bil nadgrajen.';
$string['privacy:metadata:upgrade_log:targetversion'] = 'Nova različica za nadgradnjo.';
$string['privacy:metadata:upgrade_log:timemodified'] = 'Čas izvršbe nadgradnje.';
$string['privacy:metadata:upgrade_log:type'] = 'Vrsta dnevniškega vnosa.';
$string['privacy:metadata:upgrade_log:userid'] = 'Uporabnik, ki je zagnal nadgradnjo.';
$string['privacy:metadata:upgrade_log:version'] = 'Stara različica vtičnika.';
$string['private_files_handler'] = 'Shrani priponke e-sporočila v uporabnikovem prostoru za hrambo zasebnih datotek.';
$string['private_files_handler_name'] = 'E-pošta v zasebne datoteke';
$string['privatefiles'] = 'Zasebne datoteke';
$string['privatefilesmanage'] = 'Upravljaj zasebne datoteke';
$string['proceed'] = 'Nadaljuj';
$string['profile'] = 'Profil';
$string['profilenotshown'] = 'Ta opis profila ne bo viden, dokler se oseba ne vpiše v vsaj en predmet.';
$string['publicprofile'] = 'Javni profil';
$string['publicsitefileswarning'] = 'Opomba: do teh datotek lahko dostopajo vsi';
$string['publicsitefileswarning2'] = 'Opomba: do datotek, ki se nahajajo tu, lahko dostopa vsakdo, ki pozna (ali lahko ugane) URL. Zaradi varnostnih razlogov je priporočljivo, da so vse datoteke varnostnih kopij izbrisane takoj po obnovitvi.';
$string['publicsitefileswarning3'] = 'Opomba: do datotek, ki se nahajajo tu, lahko dostopa vsakdo, ki pozna (ali lahko ugane) URL. <br /> Zaradi varnostnih razlogov naj bodo datoteke varnostnih kopij shranjene samo v mapi varnostnih kopij.';
$string['question'] = 'Vprašanje';
$string['questionsinthequestionbank'] = 'Vprašanja v zbirki vprašanj';
$string['queued'] = 'V čakalni vrsti';
$string['quotausage'] = 'Trenutno ste porabili {$a->used} od omejitve {$a->total}.';
$string['readinginfofrombackup'] = 'Branje informacij iz varnostne kopije';
$string['readme'] = 'NAVODILA';
$string['recentactivity'] = 'Nedavna dejavnost';
$string['recentactivityreport'] = 'Celotno poročilo nedavnih dejavnosti ...';
$string['recipientslist'] = 'Seznam prejemnikov';
$string['recommended'] = 'Priporočeno';
$string['recreatedcategory'] = 'Ponovno ustvarjena kategorija {$a}';
$string['redirect'] = 'Preusmeri';
$string['reducesections'] = 'Zmanjšaj število odsekov';
$string['refresh'] = 'Osveži';
$string['refreshingevents'] = 'Osveževanje dogodkov';
$string['registration'] = 'Registracija Moodla';
$string['registrationcontact'] = 'Stik iz javnosti';
$string['registrationcontactno'] = 'Ne, nočem, da me drugi kontaktirajo';
$string['registrationcontactyes'] = 'Da, ponudi drugim uporabnikom Moodla obrazec za vzpostavitev kontakta z mano';
$string['registrationemail'] = 'E-poštna obvestila';
$string['registrationinfo'] = '<p>Ta stran omogoča registracijo vaše Moodle strani pri moodle.org. Registracija je brezplačna.
Glavna prednost registracije je, da boste dodani v poštni seznam z nizkim obsegom
za pomembna obvestila, kot so varnostna opozorila in nove izdaje Moodle.</p>
<p>Vaše informacije bodo privzeto ohranjene zasebne in ne bodo nikoli prodane ali posredovane komurkoli drugemu. Edini
 namen zbiranja teh informacij je podpora in pomoč pri ustvarjanju statistične
 podobe skupnosti Moodle kot celote.</p>
<p>Če se odločite, lahko dovolite objavo imena strani, države in naslova URL v javnem seznamu strani Moodle.</p>
<p>Vse nove registracije so ročno preverjene, preden so dodane na seznam, ko ste dodani, pa lahko kadarkoli posodobite registracijo (in vaš vnos v javni seznam) s ponovno oddajo tega obrazca.</p>';
$string['registrationinfotitle'] = 'Informacije o registraciji';
$string['registrationno'] = 'Ne, ne želim prejemati e-pošte';
$string['registrationsend'] = 'Pošlji informacije o registraciji na moodle.org';
$string['registrationyes'] = 'Da, obveščaj me o novih izdajah Moodla, varnostnih opozorilih in drugih pomembnih novicah';
$string['reject'] = 'Zavrni';
$string['rejectdots'] = 'Zavrni ...';
$string['relativedatesmode'] = 'Način relativnih datumov';
$string['relativedatesmode_help'] = 'Prikaži datume predmeta ali dejavnosti relativno glede na uporabnikov datum začetka v predmetu.
Uporabnikov datum začetka predmeta bo datum njegovega vpisa v predmet, razen če se vpiše pred začetkom izvajanja predmeta, v tem primeru bo njihov datum začetka tudi datum začetka izvajanja predmeta.
OPOZORILO: To je poskusna funkcija in je vse dejavnosti morda ne podpirajo. Ko je predmet ustvarjen, te nastavitve ni več mogoče spreminjati.';
$string['relativedatesmode_warning'] = '<strong>Opozorilo:</strong> Ko je predmet ustvarjen, načina relativnih datumov ni več mogoče spremeniti.';
$string['reload'] = 'Ponovno naloži';
$string['remoteappuser'] = 'Oddaljeni {$a} Uporabnik';
$string['remove'] = 'Odstrani';
$string['removeadmin'] = 'Odstrani skrbnika';
$string['removecreator'] = 'Odstrani ustvarjalca predmeta';
$string['removestudent'] = 'Odstrani udeleženca';
$string['removeteacher'] = 'Odstrani učitelja';
$string['rename'] = 'Preimenuj';
$string['renamefileto'] = 'Preimenuj <b>{$a}</b> v';
$string['report'] = 'Poročilo';
$string['reports'] = 'Poročila';
$string['reporttype'] = 'Tip poročila';
$string['repositories'] = 'Skladišča';
$string['requestcourse'] = 'Zahtevaj predmet';
$string['requestedby'] = 'Zahteval/-a';
$string['requestedcourses'] = 'Zahtevani predmeti';
$string['requestreason'] = 'Razlog za zahtevo predmeta';
$string['requests'] = 'Zahteve';
$string['required'] = 'Zahtevano';
$string['requirespayment'] = 'Ta predmet zahteva plačilo za dostop';
$string['resendemail'] = 'Ponovno pošlji e-sporočilo';
$string['reset'] = 'Ponastavi';
$string['resetcomponent'] = 'Komponenta';
$string['resetcourse'] = 'Ponastavi predmet';
$string['resetinfo'] = 'Ta stran vam omogoča, da izpraznite uporabniške podatke iz predmeta in ohranite dejavnosti ter druge nastavitve. Bodite pozorni, saj boste z izbiro spodnjih elementov in oddajo te strani trajno izbrisali izbrane uporabniške podatke iz tega predmeta!';
$string['resetnotimplemented'] = 'Ponastavitev ni bila izvedena';
$string['resetrecordexpired'] = 'Povezava za ponastavitev gesla je starejša od {$a} minut in je potekla. Sprožite novo ponastavitev gesla.';
$string['resetstartdate'] = 'Ponastavi datum začetka';
$string['resetstatus'] = 'Stanje';
$string['resettable'] = 'Ponastavi nastavitve tabele';
$string['resettask'] = 'Opravilo';
$string['resettodefaults'] = 'Ponastavi na privzete vrednosti';
$string['resortcourses'] = 'Razvrsti predmete';
$string['resortsubcategoriesby'] = 'Razvrsti podkategorije po {$a}, naraščajoče';
$string['resortsubcategoriesbyreverse'] = 'Razvrsti podkategorije po {$a}, padajoče';
$string['resource'] = 'Vir';
$string['resourcedisplayauto'] = 'Samodejno';
$string['resourcedisplaydownload'] = 'Vsili prenos';
$string['resourcedisplayembed'] = 'Vdelaj';
$string['resourcedisplayframe'] = 'V okvirju';
$string['resourcedisplaynew'] = 'Novo okno';
$string['resourcedisplayopen'] = 'Odpri';
$string['resourcedisplaypopup'] = 'V pojavnem oknu';
$string['resources'] = 'Viri';
$string['resources_help'] = 'Vrste virov omogočajo dodajanje skoraj vseh spletnih vsebin v predmet.';
$string['restore'] = 'Obnovi';
$string['restorecancelled'] = 'Obnovitev preklicana';
$string['restorecannotassignroles'] = 'Za obnovitev je treba dodeliti vloge, vi pa za to nimate dovoljenja';
$string['restorecannotcreateorassignroles'] = 'Za obnovitev je treba ustvariti ali dodeliti vloge, vi pa za to nimate dovoljenja';
$string['restorecannotcreateuser'] = 'Za obnovitev je treba ustvariti uporabnika \'{$a}\' iz varnostne kopije, vi pa za to nimate dovoljenja';
$string['restorecannotoverrideperms'] = 'Za obnovitev je treba izničiti dovoljenja, vi pa nimate dovoljenj za to';
$string['restorecoursenow'] = 'Obnovi ta predmet zdaj!';
$string['restoredaccount'] = 'Obnovljeni račun';
$string['restoredaccountinfo'] = 'Ta račun je bil uvožen z drugega strežnika, geslo je bilo izgubljeno. Za nastavitev novega gesla po e-pošti kliknite "Nadaljuj"';
$string['restorefinished'] = 'Obnova je uspešno zaključena';
$string['restoremnethostidmismatch'] = 'Gostiteljev MNET ID uporabnika \'{$a}\' se ne ujema z lokalnim gostiteljevim MNET ID.';
$string['restoreto'] = 'Obnovi v';
$string['restoretositeadding'] = 'Opozorilo: obnovili boste na naslovno stran spletnega mesta in nanjo dodali podatke!';
$string['restoretositedeleting'] = 'Opozorilo: obnovili boste na naslovno stran spletnega mesta in najprej z nje izbrisali podatke!';
$string['restoreuserconflict'] = 'Poskus obnovitve uporabnika \'{$a}\' iz varnostne kopije bo povzočil spor';
$string['restoreuserinfofailed'] = 'Obnovitveni postopek se je ustavil, ker nimate dovoljenja za obnovitev uporabniških podatkov.';
$string['restoreusersprecheck'] = 'Preverjanje uporabniških podatkov';
$string['restoreusersprecheckerror'] = 'Zaznanih je bilo nekaj problemov med preverjanjem uporabniških podatkov';
$string['restricted'] = 'Omejeno';
$string['resultsfound'] = 'Št. najdenih rezultatov: {$a}';
$string['retry'] = 'Poskusite znova';
$string['returningtosite'] = 'Se vračate na to spletno mesto?';
$string['returntooriginaluser'] = 'Vrni se na {$a}';
$string['revert'] = 'Povrni';
$string['role'] = 'Vloga';
$string['roleassignments'] = 'Dodelitve vlog';
$string['rolemappings'] = 'Preslikovanje vlog';
$string['rolerenaming'] = 'Preimenovanje vlog';
$string['rolerenaming_help'] = 'Ta nastavitev omogoča spremembo prikazanih imen za vloge v predmetu. Spremenjeno je samo prikazano ime - to ne vpliva na dovoljenja za vloge. Nova imena za vloge se bodo pojavila na strani sodelujočih v predmetu in drugje znotraj predmeta. Če je preimenovana vloga ta, ki jo je skrbnik izbral kot vlogo upravljalca predmeta, se bo novo ime za vlogo pojavilo tudi kot del izpisa predmeta.';
$string['roles'] = 'Vloge';
$string['rss'] = 'RSS';
$string['rssarticles'] = 'Število nedavnih člankov RSS';
$string['rsserror'] = 'Napaka pri branju podatkov RSS';
$string['rsserrorauth'] = 'Vaša povezava RSS ne vsebuje veljavnega avtentikacijskega žetona.';
$string['rsserrorguest'] = 'Ta vir uporablja dostop gosta za dostop do podatkov, vendar gosti nimajo dovoljenja za branje teh podatkov. Obiščite izvorno lokacijo vira (URL) kot veljavni uporabnik in tam pridobite novo povezavo RSS.';
$string['rsskeyshelp'] = '<p>Za zagotavljanje varnosti in zasebnosti vsebujejo naslovi URL virov RSS poseben žeton, ki identificira uporabnika, ki so mu namenjeni. To prepreči drugim uporabnikom dostop do mest v Moodlu, do katerih ne smejo dostopati.</p><p>Ta žeton je samodejno ustvarjen, ko prvič dostopate do mesta, ki ustvari vir RSS. Če menite, da je bil vaš žeton vira RSS kompromitiran, lahko zahtevate novega s klikom na tukajšnjo povezavo za ponastavitev. Prosimo, upoštevajte, da bo trenutni naslov URL vira RSS tako postal neveljaven.</p>';
$string['rsstype'] = 'Vir RSS za to dejavnost';
$string['save'] = 'Shrani';
$string['saveandnext'] = 'Shrani in prikaži naslednjo';
$string['savechanges'] = 'Shrani spremembe';
$string['savechangesanddisplay'] = 'Shrani in prikaži';
$string['savechangesandreturn'] = 'Shrani in se vrni';
$string['savechangesandreturntocourse'] = 'Shrani in se vrni na predmet';
$string['savecomment'] = 'Shrani komentar';
$string['savedat'] = 'Shranjeno ob:';
$string['savepreferences'] = 'Shrani nastavitve';
$string['saveto'] = 'Shrani v';
$string['scale'] = 'Lestvica';
$string['scale_help'] = 'Lestvica je način za vrednotenje ali ocenjevanje uspešnosti pri dejavnosti. Definira jo urejen seznam vrednosti, ki segajo od negativne do pozitivne in so med seboj ločene z vejicami, npr. "Slabo, Nezadovoljivo, Povprečno, Dobro, Zelo dobro, Odlično!"';
$string['scale_link'] = 'ocena/lestvica';
$string['scales'] = 'Lestvice';
$string['scalescustom'] = 'Lestvice po meri';
$string['scalescustomcreate'] = 'Dodaj novo lestvico';
$string['scalescustomno'] = 'Lestvice po meri še niso ustvarjene';
$string['scalesstandard'] = 'Standardne lestvice';
$string['scalestandard'] = 'Standardna lestvica';
$string['scalestandard_help'] = 'Standardna lestvica je na voljo za celo spletno mesto in vse predmete.';
$string['scalestandard_link'] = 'ocena/lestvica';
$string['scalestip'] = 'Za ustvarjanje lestvic po meri uporabite povezavo \'Lestvice ...\' v skrbniškem meniju predmeta.';
$string['scalestip2'] = 'Za ustvarjanje lestvic po meri kliknite na povezavo Ocene v skrbniškem meniju predmeta, nato izberite Uredi, Lestvice.';
$string['schedule'] = 'Urnik';
$string['screenshot'] = 'Posnetek zaslona';
$string['search'] = 'Išči';
$string['search_help'] = 'Za osnovno iskanje ene ali več besed kjerkoli v besedilu preprosto vpišite besede, ločene s presledki. Uporabite lahko vse besede, daljše od dveh znakov.

Za napredno iskanje kliknite na gumb iskanje in ne vpišite ničesar v iskalno polje - tako boste prišli do naprednega obrazca za iskanje.';
$string['searchactivities'] = 'Poiščite dejavnosti po imenu ali opisu';
$string['searchagain'] = 'Išči znova';
$string['searchbyemail'] = 'Išči po e-poštnih naslovih';
$string['searchbyusername'] = 'Išči po uporabniških imenih';
$string['searchcoursecategories'] = 'Iskalne kategorije';
$string['searchcourses'] = 'Išči predmete';
$string['searchoptions'] = 'Možnosti iskanja';
$string['searchresults'] = 'Rezultati iskanja';
$string['sec'] = 's';
$string['seconds'] = 'sekunde';
$string['secondsleft'] = '{$a} s';
$string['secondstotime172800'] = '2 dni';
$string['secondstotime259200'] = '3 dni';
$string['secondstotime345600'] = '4 dni';
$string['secondstotime432000'] = '5 dni';
$string['secondstotime518400'] = '6 dni';
$string['secondstotime604800'] = '1 teden';
$string['secondstotime86400'] = '1 dan';
$string['secretalreadyused'] = 'Povezava za potrditev zamenjave gesla je bila že uporabljena, geslo ni bilo spremenjeno.';
$string['secs'] = 's';
$string['section'] = 'Odsek';
$string['sectionactionnotsupported'] = 'Dejavnost odseka "{$a}" tu ni podprta';
$string['sectionname'] = 'Ime odseka';
$string['sections'] = 'Odseki';
$string['seealsostats'] = 'Glej tudi: statistika';
$string['selctauser'] = 'Izberi uporabnika';
$string['select'] = 'Izberi';
$string['selectacategory'] = 'Izberi kategorijo';
$string['selectacountry'] = 'Izberite državo';
$string['selectacourse'] = 'Izberi predmet';
$string['selectacoursesite'] = 'Izberite predmet ali spletno mesto';
$string['selectagroup'] = 'Izberi skupino';
$string['selectall'] = 'Izberi vse';
$string['selectallusersonpage'] = 'Izberi vse uporabnike na tej strani';
$string['selectalluserswithcount'] = 'Izberi vseh {$a} uporabnikov';
$string['selectamodule'] = 'Izberi modul dejavnosti';
$string['selectanaction'] = 'Izberi dejanje';
$string['selectanoptions'] = 'Izberi možnost';
$string['selectaregion'] = 'Izberite območje';
$string['selectcategorysort'] = 'Katere kategorije želite razvrstiti?';
$string['selectcategorysortby'] = 'Izberite, kako želite razvrstiti kategorije';
$string['selectcoursesortby'] = 'Izberite, kako želite razvrstiti predmete';
$string['selectdefault'] = 'Izberi privzeto';
$string['selectedcategories'] = 'Izbrane kategorije';
$string['selectedfile'] = 'Izbrana datoteka';
$string['selectednowmove'] = '{$a} datotek izbranih za premik. Zdaj pojdite v ciljno mapo in pritisnite \'Premakni datoteke sem\'';
$string['selectfiles'] = 'Izberite datoteke';
$string['selectfiltertype'] = 'Izberi';
$string['selectgroupsseparate'] = 'Izberi ločene skupine';
$string['selectgroupsvisible'] = 'Izberi vidne skupine';
$string['selectitem'] = 'Izberite \'{$a}\'';
$string['selectmoduletoviewhelp'] = 'Za ogled pomoči izberite dejavnost ali vir.

Dvakrat kliknite na ime dejavnosti ali vira, da ga dodate.';
$string['selectnos'] = 'Pri vseh izberi \'Ne\'';
$string['selectperiod'] = 'Izberi obdobje';
$string['senddetails'] = 'Pošlji moje podrobnosti prek e-pošte';
$string['separate'] = 'Ločeno';
$string['separateandconnected'] = 'Ločeni in povezani načini védenja';
$string['separateandconnectedinfo'] = 'Lestvica temelji na teoriji ločenega in povezanega znanja. Ta teorija opisuje dva različna načina vrednotenja in učenja o stvareh, ki jih vidimo in slišimo.<ul><li><strong>Strokovnjaki ločenega znanja</strong>ostajajo objektivni, ne da bi vključevali občutke in čustva. V pogovoru z drugimi ljudmi radi branijo svoje ideje z uporabo logike, da bi našli luknje v idejah nasprotnika.</li><li><strong>Strokovnjaki povezanega znanja</strong>so bolj občutljivi do drugih ljudi. So empatični, radi poslušajo in postavljajo vprašanja toliko časa, da se lahko povežejo s človekom in "razumejo stvari iz svojega stališča". Učijo se prek izkušenj, ki so pripeljale do znanja, ki ga najdejo v drugih ljudeh.</li></ul>';
$string['servererror'] = 'Pri komunikaciji z strežnikom je prišlo do napake';
$string['serverlocaltime'] = 'Strežnikov lokalni čas';
$string['sessionforceclean'] = 'Kot varnostni ukrep so bile v tej seji onemogočene skripte, ki jih generirajo uporabniki.';
$string['sessiontimeoutsoon'] = 'Vaša seja bo kmalu potekla. Ali želite podaljšati trenutno sejo?';
$string['setcategorytheme'] = 'Določi temo kategorije';
$string['setmode'] = 'Nastavi način';
$string['setpassword'] = 'Nastavi geslo';
$string['setpasswordinstructions'] = 'Spodaj dvakrat vnesite novo geslo in nato shranite spremembe.';
$string['settings'] = 'Nastavitve';
$string['shortname'] = 'Kratko ime';
$string['shortnamecollisionwarning'] = '[*] = To kratko ime že uporablja predmet in ga bo treba pred odobritvijo spremeniti';
$string['shortnamecourse'] = 'Kratko ime predmeta';
$string['shortnamecourse_help'] = 'Ime, ki je prikazano na mestih z omejenim prostorom. Biti mora unikatno.';
$string['shortnametaken'] = 'Kratko ime že uporablja drug predmet ({$a})';
$string['shortnameuser'] = 'Kratko ime uporabnika';
$string['shortsitename'] = 'Kratko ime za spletno mesto (npr. ena beseda)';
$string['show'] = 'Pokaži';
$string['showactions'] = 'Pokaži dejanja';
$string['showactivitydates'] = 'Pokaži datume aktivnosti';
$string['showadvancededitor'] = 'Napredno';
$string['showadvancedsettings'] = 'Pokaži napredne nastavitve';
$string['showall'] = 'Pokaži vse {$a}';
$string['showallcourses'] = 'Prikaži vse predmete';
$string['showallusers'] = 'Pokaži vse uporabnike';
$string['showblockcourse'] = 'Pokaži seznam predmetov z blokom';
$string['showcategory'] = 'Pokaži {$a}';
$string['showchartdata'] = 'Pokaži podatke grafa';
$string['showcomments'] = 'Pokaži/skrij komentarje';
$string['showcommentsnonjs'] = 'Pokaži komentarje';
$string['showdescription'] = 'Prikaži opis na strani predmeta';
$string['showdescription_help'] = 'Če je omogočeno, bo zgornji opis prikazan na strani predmeta, tik pod povezavo na dejavnost ali vir.';
$string['showgrades'] = 'Pokaži redovalnico udeležencem';
$string['showgrades_help'] = 'Dovolite udeležencem ogled seznama vseh njihovih ocen v predmetu.';
$string['showingacourses'] = 'Prikazanih vseh {$a} predmetov';
$string['showingxofycourses'] = 'Prikazani predmeti od {$a->start}. do {$a->end}. od skupaj {$a->total}. predmetov';
$string['showlistofcourses'] = 'Pokaži seznam predmetov';
$string['showmodulecourse'] = 'Pokaži seznam predmetov, ki vsebujejo dejavnost';
$string['showoncoursepage'] = 'Prikaži na strani predmeta';
$string['showonly'] = 'Pokaži samo';
$string['showperpage'] = 'Pokaži {$a} na stran';
$string['showpopoverwindow'] = 'Pokaži pojavno okno';
$string['showrecent'] = 'Pokaži nedavne dejavnosti';
$string['showreports'] = 'Pokaži poročila dejavnosti';
$string['showreports_help'] = 'Dovolite udeležencem ogled poročil o dejavnostih prek svoje profilne strani.';
$string['showsettings'] = 'Pokaži nastavitve';
$string['showtheselogs'] = 'Pokaži te dnevnike';
$string['showthishelpinlanguage'] = 'Pokaži pomoč v jeziku: {$a}';
$string['sidepanel'] = 'Stransko polje';
$string['signoutofotherservices'] = 'Odjava povsod';
$string['signoutofotherservices_help'] = 'Če je ta možnost označena, se boste z računom odjavili v vseh napravah in sistemih, ki uporabljajo spletne storitve, kot je mobilna aplikacija.';
$string['since'] = 'Od';
$string['sincelast'] = 'od zadnje prijave';
$string['site'] = 'Spletno mesto';
$string['sitedefault'] = 'Privzeto za spletno mesto';
$string['sitedefaultspecified'] = 'Privzeto za spletno mesto ({$a})';
$string['siteerrors'] = 'Napake spletnega mesta';
$string['sitefiles'] = 'Datoteke spletnega mesta';
$string['sitefilesused'] = 'Datoteke spletnega mesta, ki so v rabi v tem predmetu';
$string['sitehome'] = 'Prva stran spletnega mesta';
$string['sitelegacyfiles'] = 'Podedovane datoteke spletnega mesta';
$string['sitelogs'] = 'Dnevniki spletnega mesta';
$string['sitenews'] = 'Obvestila spletnega mesta';
$string['sitepages'] = 'Strani spletnega mesta';
$string['sitepartlist'] = 'Nimate zahtevanih dovoljenj za ogled seznama sodelujočih';
$string['sitepartlist0'] = 'Za ogled udeležencev spletnega mesta morate biti izvajalec spletnega mesta';
$string['sitepartlist1'] = 'Za ogled udeležencev spletnega mesta morate biti izvajalec';
$string['sites'] = 'Spletna mesta';
$string['sitesection'] = 'Vključi odsek teme';
$string['sitesettings'] = 'Nastavitve spletnega mesta';
$string['siteteachers'] = 'Učitelji spletnega mesta';
$string['size'] = 'Velikost';
$string['sizeb'] = 'bajtov';
$string['sizegb'] = 'GB';
$string['sizekb'] = 'KB';
$string['sizemb'] = 'MB';
$string['sizepb'] = 'PB';
$string['sizetb'] = 'TB';
$string['skipped'] = 'Preskočeno';
$string['skiptocategorylisting'] = 'Preskoči na sezname kategorij';
$string['skiptocoursedetails'] = 'Preskoči na podrobnosti predmeta';
$string['skiptocourselisting'] = 'Preskoči na sezname predmetov';
$string['skypeid'] = 'Skype ID';
$string['socialheadline'] = 'Družabni forum - zadnje teme';
$string['someallowguest'] = 'Nekateri predmeti morda omogočajo gostujoči dostop';
$string['someerrorswerefound'] = 'Nekatere informacije manjkajo ali so nepravilne. Spodaj si oglejte podrobnosti.';
$string['sort'] = 'Razvrsti';
$string['sortby'] = 'Razvrsti po';
$string['sortbyx'] = 'Razvrsti po {$a} naraščajoče';
$string['sortbyxreverse'] = 'Razvrsti po {$a} padajoče';
$string['sorting'] = 'Razvrščanje';
$string['sourcerole'] = 'Izvorna vloga';
$string['specifyname'] = 'Navesti morate ime.';
$string['standard'] = 'Privzeto';
$string['starpending'] = '([*] = predmet čaka na odobritev)';
$string['startdate'] = 'Datum začetka predmeta';
$string['startdate_help'] = 'Ta nastavitev določa začetek prvega tedna predmeta v tedenski obliki. Določa tudi najbolj zgodnji datum prikaza dnevnikov dejavnosti v predmetu. Če je predmet ponastavljen in se je datum pričetka predmeta spremenil, se vsi datumi predmeta premaknejo glede na nov začetni datum.';
$string['startingfrom'] = 'Začne se od';
$string['startsignup'] = 'Ustvari nov račun';
$string['state'] = 'Občina';
$string['statistics'] = 'Statistika';
$string['statisticsgraph'] = 'Statistični graf';
$string['stats'] = 'Statistika';
$string['statslogins'] = 'Prijave';
$string['statsmodedetailed'] = 'Podroben (uporabniški) pogled';
$string['statsmodegeneral'] = 'Splošen pogled';
$string['statsnodata'] = 'Za to kombinacijo predmeta in časovnega obdobja podatki niso na voljo.';
$string['statsnodatauser'] = 'Za to kombinacijo predmeta, uporabnika in časovnega obdobja podatki niso na voljo.';
$string['statsoff'] = 'Statistika trenutno ni omogočena';
$string['statsreads'] = 'Ogledi';
$string['statsreport1'] = 'Prijave';
$string['statsreport10'] = 'Dejavnost uporabnika';
$string['statsreport11'] = 'Najdejavnejši predmeti';
$string['statsreport12'] = 'Najdejavnejši predmeti (uteženo)';
$string['statsreport13'] = 'Predmeti z največ udeležbe (vpisi)';
$string['statsreport14'] = 'Predmeti z največ udeležbe (ogledi/objave)';
$string['statsreport2'] = 'Ogledi (vse vloge)';
$string['statsreport3'] = 'Objave (vse vloge)';
$string['statsreport4'] = 'Vse dejavnosti (vse vloge)';
$string['statsreport5'] = 'Vse dejavnosti (ogledi in objave)';
$string['statsreport7'] = 'Dejavnost uporabnika (ogledi in objave)';
$string['statsreport8'] = 'Vse dejavnosti uporabnika';
$string['statsreport9'] = 'Prijave (predmet na spletnem mestu)';
$string['statsreportactivity'] = 'Vse dejavnosti (vse vloge)';
$string['statsreportactivitybyrole'] = 'Vse dejavnosti (ogledi in objave)';
$string['statsreportforuser'] = 'za';
$string['statsreportlogins'] = 'Prijave';
$string['statsreportreads'] = 'Ogledi (vse vloge)';
$string['statsreporttype'] = 'Vrsta poročila';
$string['statsreportwrites'] = 'Objave (vse vloge)';
$string['statsstudentactivity'] = 'Dejavnost udeleženca';
$string['statsstudentreads'] = 'Ogledi udeleženca';
$string['statsstudentwrites'] = 'Objave udeleženca';
$string['statsteacheractivity'] = 'Dejavnost učitelja';
$string['statsteacherreads'] = 'Ogledi učitelja';
$string['statsteacherwrites'] = 'Objave učitelja';
$string['statstimeperiod'] = 'Časovno obdobje – zadnjih:';
$string['statsuniquelogins'] = 'Enkratne prijave';
$string['statsuseractivity'] = 'Vse dejavnosti';
$string['statsuserlogins'] = 'Prijave';
$string['statsuserreads'] = 'Ogledi';
$string['statsuserwrites'] = 'Objave';
$string['statswrites'] = 'Objave';
$string['status'] = 'Stanje';
$string['statuscritical'] = 'Kritično';
$string['statuserror'] = 'Napaka';
$string['statusinfo'] = 'Informacije';
$string['statusna'] = 'Brez odgovora';
$string['statusok'] = 'V redu';
$string['statuswarning'] = 'Opozorilo';
$string['stringsnotset'] = 'Sledeči nizi niso določeni v {$a}';
$string['studentnotallowed'] = 'Žal v ta predmet ne morete vstopiti kot \'{$a}\'';
$string['students'] = 'Udeleženci';
$string['studentsandteachers'] = 'Udeleženci in učitelji';
$string['subcategories'] = 'Podkategorije';
$string['subcategory'] = 'Podkategorija';
$string['subcategoryof'] = 'Podkategorija kategorije {$a}';
$string['subject'] = 'Zadeva';
$string['submit'] = 'Oddaj';
$string['success'] = 'Uspešno';
$string['successduration'] = 'Uspešna izvedba ({$a} sekund)';
$string['summary'] = 'Povzetek';
$string['summary_help'] = 'Povzetek je kratko besedilo, ki pripravi udeležence na dejavnosti znotraj določene teme ali tedna. Besedilo je prikazano na strani predmeta pod imenom odseka.';
$string['summaryof'] = 'Povzetek {$a}';
$string['supplyinfo'] = 'Več podrobnosti';
$string['suspended'] = 'Začasno onemogočeno';
$string['suspendedusers'] = 'Začasno onemogočeni uporabniki';
$string['switchdevicedefault'] = 'Preklopi na standardno temo';
$string['switchdevicerecommended'] = 'Preklopi na priporočljivo temo za vašo napravo';
$string['switchrolereturn'] = 'Vrni se v mojo običajno vlogo';
$string['switchroleto'] = 'Zamenjaj vlogo v ...';
$string['switchroleto_help'] = 'Izberite vlogo in se seznanite s tem, kako bo nekdo s to vlogo videl ta predmet.

Upoštevajte, da tak pogled morda ni popoln (<a href=«https://docs.moodle.org/en/Switch_roles«>Glej podrobnosti in alternative</a>).';
$string['tag'] = 'Oznaka';
$string['tagalready'] = 'Ta oznaka že obstaja';
$string['tagmanagement'] = 'Dodaj/izbriši oznake ...';
$string['tags'] = 'Oznake';
$string['targetrole'] = 'Ciljna vloga';
$string['teacheronly'] = 'samo za {$a}';
$string['teacherroles'] = 'vloge {$a}';
$string['teachers'] = 'Učitelji';
$string['textcopiedtoclipboard'] = 'Tekst je bil kopiran v odložišče';
$string['textediting'] = 'Urejevalnik besedil';
$string['textediting_help'] = 'Če je izbran HTML urejevalnik, kot sta Atto ali TinyMCE, bodo vnosna polja vsebovala orodno vrstico z gumbi za enostavnejšo dodajanje vsebine.

Če je izbrano \'Polje gole vsebine\' lahko v vnosna polja vsebino vnašate v formatu, kot sta HTML ali Markdown.

Seznam urejevalnikov, ki so vam na voljo, upravlja skrbnik spletnega mesta.';
$string['texteditor'] = 'Uporaba standardnih spletnih obrazcev';
$string['textellipsis'] = '{$a}...';
$string['textformat'] = 'Format golega besedila';
$string['thanks'] = 'Hvala';
$string['theme'] = 'Tema';
$string['themes'] = 'Teme';
$string['themesaved'] = 'Nova tema je shranjena';
$string['therearecourses'] = 'Število predmetov: {$a}';
$string['thereareno'] = 'V tem predmetu ni {$a}';
$string['thiscategory'] = 'Ta kategorija';
$string['thiscategorycontains'] = 'Ta kategorija vsebuje';
$string['time'] = 'Čas';
$string['timecreated'] = 'Ustvarjeno';
$string['timecreatedcourse'] = 'Čas, ko je bil predmet ustvarjen';
$string['timesplitting:deciles'] = 'Zadnja desetina';
$string['timesplitting:deciles_help'] = 'Ta metoda delitve časa razdeli predmet po desetinah (10 enakih delov), pri tem pa vsako predvidevanje temelji na podatkih samo zadnje desetine.';
$string['timesplitting:decilesaccum'] = 'Vse prejšnje desetine';
$string['timesplitting:decilesaccum_help'] = 'Ta metoda delitve časa razdeli predmet po desetinah (10 enakih delov), pri tem pa vsako predvidevanje temelji na podatkih vseh prejšnjih desetin.';
$string['timesplitting:nosplitting'] = 'Brez časovnih omejitev';
$string['timesplitting:nosplitting_help'] = 'Za ta model ni določen noben interval analize.';
$string['timesplitting:onemonthafterstart'] = 'En mesec po začetku';
$string['timesplitting:onemonthafterstart_help'] = 'Ta interval analize ustvari napoved 1 mesec po začetku analiziranja.';
$string['timesplitting:oneweekafterstart'] = 'En teden po začetku';
$string['timesplitting:oneweekafterstart_help'] = 'Ta interval analize ustvari napoved 1 teden po začetku analiziranega.';
$string['timesplitting:past3days'] = 'Pretekli 3 dnevi';
$string['timesplitting:past3days_help'] = 'Ta interval analize ustvarja napovedi vsake 3 dni. Izračuni kazalnikov bodo temeljili na preteklih 3 dneh.';
$string['timesplitting:pastmonth'] = 'Pretekli mesec';
$string['timesplitting:pastmonth_help'] = 'Ta interval analize ustvarja napovedi vsak mesec. Izračuni kazalnikov bodo temeljili na preteklem mesecu.';
$string['timesplitting:pastweek'] = 'Pretekli teden';
$string['timesplitting:pastweek_help'] = 'Ta interval analize ustvarja napovedi vsak teden. Izračuni kazalnikov bodo temeljili na preteklem tednu.';
$string['timesplitting:quarters'] = 'Zadnja četrtina';
$string['timesplitting:quarters_help'] = 'Ta metoda delitve časa razdeli predmet po četrtinah (4 enaki deli), pri tem pa vsako predvidevanje temelji na podatkih samo zadnje četrtine.';
$string['timesplitting:quartersaccum'] = 'Vse prejšnje četrtine';
$string['timesplitting:quartersaccum_help'] = 'Ta metoda delitve časa razdeli predmet po četrtinah (4 enaki deli), pri tem pa vsako predvidevanje temelji na podatkih vseh prejšnjih četrtin.';
$string['timesplitting:singlerange'] = 'Od začetka do konca';
$string['timesplitting:singlerange_help'] = 'Ta metoda delitve časa obravnava celoten predmet kot en razpon.';
$string['timesplitting:tenpercentafterstart'] = '10 % po začetku';
$string['timesplitting:tenpercentafterstart_help'] = 'Ta interval analize ustvari napoved po opravljenih 10 % predmeta.';
$string['timesplitting:upcoming3days'] = 'Prihodnji 3 dnevi';
$string['timesplitting:upcoming3days_help'] = 'Ta interval analize ustvari napovedi vsake 3 dni. Izračuni kazalnikov bodo temeljili na prihodnjih 3 dneh.';
$string['timesplitting:upcomingfortnight'] = 'Prihodnjih 14 dni';
$string['timesplitting:upcomingfortnight_help'] = 'Ta interval analize ustvari napovedi vsakih 14 dni. Izračuni kazalnikov bodo temeljili na prihodnjih 14 dneh.';
$string['timesplitting:upcomingweek'] = 'Prihodnji teden';
$string['timesplitting:upcomingweek_help'] = 'Ta interval analize ustvarja napovedi vsak teden. Izračuni kazalnikov bodo temeljili na prihodnjem tednu.';
$string['timezone'] = 'Časovni pas';
$string['to'] = 'K';
$string['tocontent'] = 'K elementu "{$a}"';
$string['tocreatenewaccount'] = 'Preskoči in ustvari nov račun';
$string['today'] = 'Danes';
$string['todaylogs'] = 'Današnji dnevniki';
$string['toeveryone'] = 'za vse';
$string['toggleemojipicker'] = 'Preklopi izbirnik emodžijev';
$string['togglesearch'] = 'Preklopi iskalni vnos';
$string['toomanybounces'] = 'Ta e-poštni naslov je povzročil preveč odklonitev. Za nadaljevanje ga <b>morate</b> spremeniti.';
$string['toomanytags'] = 'To iskanje je vsebovalo preveč oznak; nekatere so bile prezrte.';
$string['toomanytoshow'] = 'Za prikaz je preveč uporabnikov.';
$string['toomanyusersmatchsearch'] = 'Preveč uporabnikov ({$a->count}), ki ustrezajo \'{$a->search}\'';
$string['toomanyuserstoshow'] = ' Preveč uporabnikov ({$a}) za prikaz';
$string['toonly'] = 'samo za {$a}';
$string['top'] = 'Vrh';
$string['topic'] = 'Tema';
$string['topichide'] = 'Skrij to temo pred {$a}';
$string['topicoutline'] = 'Oris teme';
$string['topicshow'] = 'Pokaži to temo {$a}';
$string['toplevelcategory'] = 'Kategorija najvišje ravni';
$string['total'] = 'Skupaj';
$string['totopofsection'] = 'Na vrh odseka "{$a}"';
$string['trackforums'] = 'Sledenje forumu';
$string['trackforumsno'] = 'Ne: ne vodi evidence mojih ogledov objav';
$string['trackforumsyes'] = 'Da: poudari nove objave zame';
$string['trysearching'] = 'Namesto tega poskusite z iskanjem.';
$string['turneditingoff'] = 'Izključi urejanje';
$string['turneditingon'] = 'Vključi urejanje';
$string['unabletocopytoclipboard'] = 'Ni bilo mogoče kopirati v odložišče';
$string['unauthorisedlogin'] = 'Uporabniški račun »{$a}« ni na voljo na tem spletnem mestu';
$string['undecided'] = 'Neodločen';
$string['unexistingcmid'] = 'ID predmetnega modula ni bil najden';
$string['unexistingsectionid'] = 'ID odseka predmeta ni bil najden';
$string['unfinished'] = 'Nedokončano';
$string['unknowncategory'] = 'Neznana kategorija';
$string['unknownerror'] = 'Neznana napaka';
$string['unknownuser'] = 'Neznan uporabnik';
$string['unlimited'] = 'Neomejeno';
$string['unpacking'] = 'Razpakiranje {$a}';
$string['unsafepassword'] = 'Geslo ni varno – poskusite s čim drugim';
$string['untilcomplete'] = 'Do zaključka';
$string['unusedaccounts'] = 'Neuporabljeni računi bodo po {$a} dneh samodejno izpisani';
$string['unzip'] = 'Razširi';
$string['unzippingbackup'] = 'Razširjanje varnostne kopije';
$string['up'] = 'Gor';
$string['update'] = 'Posodobi';
$string['updated'] = 'Posodobljeno {$a}';
$string['updatemymoodleoff'] = 'Ustavi prilagajanje te strani';
$string['updatemymoodleon'] = 'Prilagodi to stran';
$string['updatemyprofile'] = 'Posodobi profil';
$string['updatesevery'] = 'Posodobitev vsakih {$a} sekund';
$string['updatethis'] = 'Posodobi {$a}';
$string['updatethiscourse'] = 'Posodobi ta predmet';
$string['updatinga'] = 'Posodabljanje: {$a}';
$string['updatingain'] = 'Posodabljanje {$a->what} v {$a->in}';
$string['upload'] = 'Naloži';
$string['uploadafile'] = 'Naloži datoteko';
$string['uploadcantwrite'] = 'Neuspešno zapisovanje datoteke na disk';
$string['uploadedfile'] = 'Datoteka uspešno naložena';
$string['uploadedfileto'] = 'Datoteka {$a->file} naložena v {$a->directory}';
$string['uploadedfiletoobig'] = 'Oprostite, datoteka je prevelika (omejitev je {$a} bajtov)';
$string['uploadextension'] = 'Nalaganje datoteke je ustavila razširitev PHP';
$string['uploadfailednotrecovering'] = 'Vaše nalaganje datotek ni uspelo, ker je prišlo do težave z eno izmed datotek {$a->name}.<br /> Tu je dnevnik težav:<br />{$a->problem}<br />Ni obnavljanja.';
$string['uploadfilelog'] = 'Dnevnik nalaganja za datoteko {$a}';
$string['uploadformlimit'] = 'Naložena datoteka {$a} presega z obrazcem nastavljeno omejitev največje velikosti';
$string['uploadlabel'] = 'Naslov:';
$string['uploadlimitwithsize'] = '{$a->contextname} omejitev nalaganja ({$a->displaysize})';
$string['uploadnewfile'] = 'Naloži novo datoteko';
$string['uploadnofilefound'] = 'Nobene datoteke ni bilo mogoče najti. Ste prepričani, da ste izbrali datoteko za nalaganje?';
$string['uploadnotallowed'] = 'Nalaganje datotek ni dovoljeno';
$string['uploadnotempdir'] = 'Manjka začasna mapa';
$string['uploadoldfilesdeleted'] = 'Stare datoteke v vašem področju nalaganja so bile izbrisane';
$string['uploadpartialfile'] = 'Datoteka je bila samo delno naložena';
$string['uploadproblem'] = 'Pri nalaganju datoteke \'{$a}\' je prišlo do neznane težave (morda je bila prevelika?)';
$string['uploadrenamedchars'] = 'Datoteka je bila preimenovana iz {$a->oldname} v {$a->newname} zaradi neveljavnih znakov.';
$string['uploadrenamedcollision'] = 'Datoteka je bila preimenovana iz {$a->oldname} v {$a->newname} zaradi spora pri imenih datotek.';
$string['uploadserverlimit'] = 'Naložena datoteka presega nastavljeno omejitev največje velikosti na strežniku';
$string['uploadthisfile'] = 'Naloži to datoteko';
$string['url'] = 'URL';
$string['used'] = 'Uporabljeno';
$string['usedinnplaces'] = 'Uporabljeno na {$a} mestih';
$string['user'] = 'Uporabnik';
$string['useraccount'] = 'Uporabniški račun';
$string['useractivity'] = 'Dejavnost';
$string['userconfirmed'] = 'Potrjeno {$a}';
$string['userdata'] = 'Podatki o uporabniku';
$string['userdeleted'] = 'Ta uporabniški račun je izbrisan';
$string['userdescription'] = 'Opis';
$string['userdescription_help'] = 'To polje vam omogoča, da vnesete nekaj besedila o sebi, kar bo nato prikazano na vaši profilni strani in vidno drugim.';
$string['userdetails'] = 'Uporabnikove podrobnosti';
$string['userfiles'] = 'Uporabnikove datoteke';
$string['userlist'] = 'Seznam uporabnikov';
$string['usermenu'] = 'Uporabniški meni';
$string['usermenugoback'] = 'Nazaj na meni uporabnikov';
$string['username'] = 'Uporabniško ime';
$string['usernameemail'] = 'Uporabniško ime ali e-naslov';
$string['usernameemailmatch'] = 'Uporabniško ime in e-poštni naslov se ne nanašata na istega uporabnika';
$string['usernameexists'] = 'To uporabniško ime že obstaja, izberite drugačnega';
$string['usernamelowercase'] = 'Dovoljene so samo male črke';
$string['usernamenotfound'] = 'To uporabniško ime ni bilo najdeno v zbirki podatkov';
$string['usernameoremail'] = 'Vnesite uporabniško ime ali e-poštni naslov';
$string['usernotconfirmed'] = 'Ni bilo mogoče potrditi {$a}';
$string['userpic'] = 'Slika uporabnika';
$string['userpreferences'] = 'Uporabniške nastavitve';
$string['users'] = 'Uporabniki';
$string['userselectorautoselectunique'] = 'Če samo en uporabnik ustreza iskanju, ga izberi samodejno';
$string['userselectorpreserveselected'] = 'Obdrži izbrane uporabnike, četudi več ne ustrezajo iskanju';
$string['userselectorsearchanywhere'] = 'Iskalno besedilo poveži kjer koli v prikazanih poljih';
$string['usersnew'] = 'Novi uporabniki';
$string['usersnoaccesssince'] = 'Nedejavni dlje kot';
$string['userswithfiles'] = 'Uporabniki z datotekami';
$string['useruploadtype'] = 'Način uporabnikovega nalaganja {$a}';
$string['userzones'] = 'Uporabniška področja';
$string['usetheme'] = 'Uporabi temo';
$string['usingexistingcourse'] = 'Uporaba obstoječega predmeta';
$string['valuealreadyused'] = 'Ta vrednost je že v uporabi.';
$string['version'] = 'Različica';
$string['view'] = 'Ogled';
$string['viewallcourses'] = 'Poglej vse predmete';
$string['viewallcoursescategories'] = 'Poglej vse predmete in kategorije';
$string['viewallsubcategories'] = 'Preglej vse podkategorije';
$string['viewfileinpopup'] = 'Ogled datoteke v pojavnem oknu';
$string['viewing'] = 'Ogledovanje:';
$string['viewmore'] = 'Pokaži več';
$string['viewprofile'] = 'Poglej profil';
$string['views'] = 'Ogledi';
$string['viewsolution'] = 'ogled rešitve';
$string['visible'] = 'Vidno';
$string['visible_help'] = 'Ta možnost določa, ali se predmet pojavi v seznamu predmetov. Uporabnikom, razen izvajalcem in skrbnikom, vstop v predmet ni dovoljen.';
$string['visibletostudents'] = 'Vidno {$a}';
$string['warning'] = 'Opozorilo';
$string['warningdeleteresource'] = 'Opozorilo: na {$a} se sklicuje vir. Želite posodobiti vir?';
$string['webpage'] = 'Spletna stran';
$string['week'] = 'Teden';
$string['weekhide'] = 'Skrij ta teden pred {$a}';
$string['weeklyoutline'] = 'Tedenski povzetek';
$string['weeks'] = 'tednov';
$string['weekshow'] = 'Pokaži ta teden {$a}';
$string['welcomeback'] = 'Dobrodošli nazaj, {$a->firstname}! 👋';
$string['welcometocourse'] = 'Dobrodošli v {$a}';
$string['welcometocoursetext'] = 'Dobrodošli pri predmetu {$a->coursename}!

Če tega še niste storili, si uredite svojo profilno stran
, tako bomo lahko izvedeli več o vas:

 {$a->profileurl}';
$string['welcometosite'] = 'Dobrodošli, {$a->firstname}! 👋';
$string['whatforlink'] = 'Kaj želite storiti s povezavo?';
$string['whatforpage'] = 'Kaj želite storiti z besedilom?';
$string['whatisyourage'] = 'Koliko ste stari?';
$string['whattocallzip'] = 'Kako želite poimenovati stisnjeno datoteko?';
$string['whattodo'] = 'Kaj narediti';
$string['wheredoyoulive'] = 'V kateri državi živite?';
$string['whyisthisrequired'] = 'Zakaj je to zahtevano?';
$string['windowclosing'] = 'Okno se bi moralo zapreti samodejno. Če se ni, ga zaprite zdaj.';
$string['withchosenfiles'] = 'Z izbranimi datotekami';
$string['withdisablednote'] = '{$a} (onemogočen)';
$string['withoutuserdata'] = 'brez uporabniških podatkov';
$string['withselectedusers'] = 'Z izbranimi uporabniki ...';
$string['withuserdata'] = 'z uporabniškimi podatki';
$string['wordforstudent'] = 'Vaša beseda za udeleženca';
$string['wordforstudenteg'] = 'npr. študent, sodelujoči itn.';
$string['wordforstudents'] = 'Vaša beseda za udeležence';
$string['wordforstudentseg'] = 'npr. študenti, sodelujoči itn.';
$string['wordforteacher'] = 'Vaša beseda za učitelja';
$string['wordforteachereg'] = 'npr. učitelj, profesor, mentor itn.';
$string['wordforteachers'] = 'Vaša beseda za učitelje';
$string['wordforteacherseg'] = 'npr. učitelji, profesorji, mentorji itn.';
$string['writingblogsinfo'] = 'Pisanje informacij o blogih';
$string['writingcategoriesandquestions'] = 'Pisanje kategorij in vprašanj';
$string['writingcoursedata'] = 'Pisanje podatkov o predmetu';
$string['writingeventsinfo'] = 'Pisanje informacij o dogodkih';
$string['writinggeneralinfo'] = 'Pisanje splošnih informacij';
$string['writinggradebookinfo'] = 'Pisanje informacij o redovalnici';
$string['writinggroupingsgroupsinfo'] = 'Pisanje informacij o skupkih-skupinah';
$string['writinggroupingsinfo'] = 'Pisanje informacij o skupkih';
$string['writinggroupsinfo'] = 'Pisanje informacij o skupinah';
$string['writingheader'] = 'Pisanje glave';
$string['writingloginfo'] = 'Zapisovanje informacij o dnevnikih';
$string['writingmessagesinfo'] = 'Pisanje informacij o sporočilih';
$string['writingmoduleinfo'] = 'Pisanje informacij o modulih';
$string['writingscalesinfo'] = 'Pisanje informacij o lestvicah';
$string['writinguserinfo'] = 'Pisanje informacij o uporabnikih';
$string['wrongpassword'] = 'Nepravilno geslo za to uporabniško ime';
$string['yahooid'] = 'Yahoo ID';
$string['year'] = 'leto';
$string['years'] = 'leta';
$string['yes'] = 'Da';
$string['youareabouttocreatezip'] = 'Ustvarili boste stisnjeno datoteko, ki bo vsebovala';
$string['youaregoingtorestorefrom'] = 'Zagnali boste postopek obnavljanja za';
$string['youhaveupcomingactivitiesdue'] = 'Vaši skorajšnji roki prihajajočih dejavnosti';
$string['youhaveupcomingactivitiesdueinfo'] = 'Pozdravljeni {$a},

<br/><br/> vaši prihajajoči skorajšnji roki dejavnosti:';
$string['youneedtoenrol'] = 'Za izvajanje tega dejanja morate biti vpisani v ta predmet.';
$string['yourlastlogin'] = 'Vaša zadnja prijava je bila';
$string['yourself'] = 'samega sebe';
$string['yourteacher'] = 'vaš {$a}';
$string['yourwordforx'] = 'Vaša beseda za \'{$a}\'';
$string['zippingbackup'] = 'Stiskanje varnostne kopije (ZIP)';
