<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'lesson', language 'uk', version '5.1'.
 *
 * @package     lesson
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['accesscontrol'] = 'Контроль доступу';
$string['actionaftercorrectanswer'] = 'Дія після правильної відповіді';
$string['actionaftercorrectanswer_help'] = '<p>Після правильно даної відповіді існує 3 опції для наступної сторінки:</p><ul><li>Звичайний - Продовжувати шлях уроку</li><li>Показати приховану сторінку - сторінки показано у довільному порядку без жодних повторень</li><li>Показати сторінки без відповідей - Сторінки показано у довільному порядку, а сторінки, що містять запитання, на які не дано відповіді показуються ще раз</li></ul>';
$string['actions'] = 'Дії';
$string['activitylink'] = 'Посилання до наступної діяльності';
$string['activitylink_help'] = 'Щоб надати в кінці уроку посилання на іншу роботу в курсі, виберіть заняття зі спадного меню.';
$string['activitylinkname'] = 'Перейти до {$a}';
$string['activityoverview'] = 'Ви маєте Уроки, які повинні пройти';
$string['addabranchtable'] = 'Додати сторінку з даними';
$string['addanendofbranch'] = 'Додати кінець сегменту';
$string['addanewpage'] = 'Додати нову сторінку';
$string['addaquestionpage'] = 'Додати сторінку з питанням';
$string['addaquestionpagehere'] = 'Додати сторінку з питанням тут';
$string['addbranchtable'] = 'Додати сторінку з даними';
$string['addcluster'] = 'Додати кластер';
$string['addedabranchtable'] = 'Додана сторінка з даними';
$string['addedanendofbranch'] = 'Кінець сегменту додано';
$string['addedaquestionpage'] = 'Додано сторінку з питанням';
$string['addedcluster'] = 'Кластер додано';
$string['addedendofcluster'] = 'Кінець кластеру додано';
$string['addendofbranch'] = 'Додайте кінець гілки';
$string['addendofcluster'] = 'Додати кінець кластеру';
$string['addessay'] = 'Створіть сторінку запитання есе';
$string['addmatching'] = 'Створіть сторінку питань з вибором';
$string['addmultichoice'] = 'Створіть сторінку запитань із кількома варіантами';
$string['addnewgroupoverride'] = 'Додати перевизначення для групи';
$string['addnewuseroverride'] = 'Додати перевизначення для користувача';
$string['addnumerical'] = 'Створіть сторінку з числовими питаннями';
$string['addpage'] = 'Додати сторінку';
$string['addshortanswer'] = 'Створіть сторінку із короткими відповідями';
$string['addtruefalse'] = 'Створіть сторінку запитань «Правда/неправда».';
$string['allotheranswers'] = 'Всі інші відповіді';
$string['allotheranswersjump'] = 'Усі інші відповіді стрибають';
$string['allotheranswersscore'] = 'Усі інші оцінки';
$string['allowofflineattempts'] = 'Дозволити спробу уроку в автономному режимі за допомогою мобільного додатка';
$string['allowofflineattempts_help'] = 'Якщо ввімкнено, користувач мобільного додатка може завантажити урок і спробувати його в автономному режимі. Усі можливі відповіді та правильні відповіді також будуть завантажені. Примітка. Неможливо спробувати урок офлайн, якщо він має обмежений час.';
$string['anchortitle'] = 'Почати основне наповнення';
$string['and'] = 'ТА';
$string['answer'] = 'Відповідь';
$string['answeredcorrectly'] = 'відповідь правильна';
$string['answersfornumerical'] = 'Відповіді на числові питання повинні бути співставленими парами з максимальним чи мінімальним значенням';
$string['arrangebuttonshorizontally'] = 'Розташувати кнопки вмісту горизонтально?';
$string['attempt'] = 'Спроба: {$a}';
$string['attemptheader'] = 'Спроба';
$string['attemptinfonograde'] = '{$a->timestart} ({$a->duration})';
$string['attemptinfowithgrade'] = '{$a->grade}% {$a->timestart} ({$a->duration})';
$string['attempts'] = 'Спроби';
$string['attemptsdeleted'] = 'Спроби вилучено';
$string['attemptsremaining'] = 'У Вас залишилося {$a} спроб(и)';
$string['available'] = 'Доступно з';
$string['averagescore'] = 'Середній бал';
$string['averagetime'] = 'Середній час';
$string['branch'] = 'Вміст';
$string['branchtable'] = 'Вміст';
$string['cachedef_overrides'] = 'Інформація про заміну користувача та групи';
$string['cancel'] = 'Скасувати';
$string['cannotfindanswer'] = 'Помилка: не знайдено відповідь';
$string['cannotfindattempt'] = 'Помилка: не знайдено спробу';
$string['cannotfindessay'] = 'Помилка: не знайдено есе';
$string['cannotfindfirstgrade'] = 'Помилка: не знайдено оцінок';
$string['cannotfindfirstpage'] = 'Не знайдено першої сторінки';
$string['cannotfindgrade'] = 'Помилка: не знайдено оцінок';
$string['cannotfindnewestgrade'] = 'Помилка: не знайдено новішої оцінки';
$string['cannotfindnextpage'] = 'Копія уроку: Наступну сторінку не знайдено!';
$string['cannotfindpagerecord'] = 'Додайте кінець сегменту: дані сторінки не знайдено';
$string['cannotfindpages'] = 'Неможливо знайти сторінки уроку';
$string['cannotfindpagetitle'] = 'Підтвердити видалення: назви сторінки не знайдено';
$string['cannotfindpreattempt'] = 'Даних попередньої спроби не знайдено!';
$string['cannotfindrecords'] = 'Помилка: неможливо знайти дані уроку';
$string['cannotfindtimer'] = 'Помилка: неможливо знайти дані таймеру уроку';
$string['cannotfinduser'] = 'Помилка: користувачів не знайдено';
$string['canretake'] = '{$a} може перездати';
$string['casesensitive'] = 'Використовувати регулярні вирази';
$string['casesensitive_help'] = 'Встановіть відмітку, щоб використовувати регулярні вирази для аналізу відповідей.';
$string['checkbranchtable'] = 'Перевірити сторінку з даними';
$string['checkedthisone'] = 'Це перевірено.';
$string['checknavigation'] = 'Випробувати навігацію';
$string['checkquestion'] = 'Випробувати запитання';
$string['classstats'] = 'Статистика класу';
$string['clicktodownload'] = 'Натисніть на це посилання, щоб завантажити файл.';
$string['closebeforeopen'] = 'Не вдається оновити урок. Ви вказали дату закінчення раніше від дати початку.';
$string['cluster'] = 'Кластер';
$string['clusterjump'] = 'Не переглянута сторінка кластеру';
$string['clustertitle'] = 'Кластер';
$string['collapsed'] = 'Згорнуто';
$string['comments'] = 'Ваші коментарі';
$string['completed'] = 'Завершено';
$string['completederror'] = 'Завершити урок';
$string['completethefollowingconditions'] = 'Вам потрібно пройти наступні завдання в <b>{$a}</b> уроці перед тим як продовжувати.';
$string['completiondetail:reachend'] = 'Пройдіть вправу до кінця';
$string['completiondetail:timespent'] = 'Витратьте принаймні {$a} на цю діяльність';
$string['completionendreached'] = 'Потрібне закінчення';
$string['completionendreached_desc'] = 'Для виконання цієї діяльності студент повинен досягти кінцевої сторінки уроку';
$string['completiontimespentdesc'] = 'Студент має виконувати цю дію принаймні {$a}';
$string['completiontimespentgroup'] = 'Потрібний час опрацювання';
$string['conditionsfordependency'] = 'Умов(а)и для залежності';
$string['configintro'] = 'Вказані значення визначають типові параметри, які будуть використовуватися у формі налаштування при створенні нового уроку. Налаштування, які вказано як розширені, будуть показуватися лише при натисканні на посилання "Показати більше".';
$string['configmaxanswers'] = 'Типова максимальна кількість відповідей на сторінку';
$string['configmediaclose'] = 'Відображає кнопку "Закрити" як частину виринаючого вікна для зв’язаних медіа файлів';
$string['configmediaheight'] = 'Встановлює висоту виринаючого вікна для зв’язаних медіа файлів';
$string['configmediawidth'] = 'Встановлює ширину виринаючого вікна для зв’язаних медіа файлів';
$string['configpassword_desc'] = 'Чи потрібно вводити пароль, щоб почати урок.';
$string['configslideshowbgcolor'] = 'Колір фону для слайд-шоу, якщо його ввімкнено';
$string['configslideshowheight'] = 'Встановлює висоту демонстрації слайдів, якщо активовано';
$string['configslideshowwidth'] = 'Встановлює ширину демонстрації слайдів, якщо активовано';
$string['configtimelimit_desc'] = 'Якщо обмежено час, то на початку уроку буде показано таймер, який буде відраховувати час назад Якщо значення встановлено в 0, то ніяких обмежень не буде.';
$string['confirmdelete'] = 'Видалити сторінку';
$string['confirmdeletionofthispage'] = 'Підтвердіть видалення цієї сторінки';
$string['congratulations'] = 'Вітаємо - Ви повністю пройшли цей урок';
$string['continue'] = 'Продовжити';
$string['continuetoanswer'] = 'Продовжити змінювати відповіді.';
$string['continuetonextpage'] = 'Продовжити до наступної сторінки.';
$string['correctanswerjump'] = 'Перехід до правильної відповіді';
$string['correctanswerscore'] = 'Кількість правильних відповідей';
$string['correctresponse'] = 'Правильна відповідь';
$string['createaquestionpage'] = 'Створити сторінку питання';
$string['credit'] = 'Бали';
$string['customscoring'] = 'Бали користувача';
$string['customscoring_help'] = 'Після активації, кожній відповіді буде присвоєно числове значення (позитивне або негативне)';
$string['deadline'] = 'Кінцевий термін';
$string['defaultessayresponse'] = 'Ваше есе буде оцінене вашим викладачем.';
$string['deleteallattempts'] = 'Видалити усі спроби проходження уроку';
$string['deletedefaults'] = 'Видалений {$a} x урок за умовчанням';
$string['deletedpage'] = 'Сторінку видалено';
$string['deletepagenamed'] = 'Видалити сторінку: {$a}';
$string['deleting'] = 'Видалення';
$string['deletingpage'] = 'Видалення сторінки: {$a}';
$string['dependencyon'] = 'Залежний від';
$string['dependencyon_help'] = 'Цей параметр дозволяє отримати доступ до цього уроку в залежності від продуктивності студента в інший уроках того ж курсу. Може бути використаною будь-яка комбінація з витраченого часу, завершення або "оцінка краще ніж" .';
$string['description'] = 'Опис';
$string['deselectallattempts'] = 'Скасуйте вибір усіх спроб';
$string['detailedstats'] = 'Детальна статистика';
$string['didnotanswerquestion'] = 'Немає відповіді на питання';
$string['didnotreceivecredit'] = 'Не отримав балів';
$string['disabled'] = 'Відключено';
$string['displaydefaultfeedback'] = 'Використати типовий відгук';
$string['displaydefaultfeedback_help'] = 'Якщо включено, то коли не знайдено коментар до відповіді для конкретного питання, типово буде показуватися "Це правильна відповідь" або "Це неправильна відповідь".';
$string['displayinleftmenu'] = 'Відобразити в меню?';
$string['displayleftif'] = 'Показувати меню тільки при оцінці більшій';
$string['displayleftif_help'] = 'Цей параметр визначає, чи повинен учень отримати певну оцінку перед переглядом меню уроку. Це змушує учня з першої спроби пройти весь урок, а потім, отримавши необхідну оцінку, може скористатися меню для повторення.';
$string['displayleftmenu'] = 'Показати меню';
$string['displayleftmenu_help'] = 'Якщо включено, то буде показуватися список сторінок уроку. Студенти зможуть відразу переходити до потрібної інформації.';
$string['displaymode'] = 'Режим відображення';
$string['displayofgrade'] = 'Показати оцінки (тільки для студентів)';
$string['displayreview'] = 'Показати кнопку «Виправити»';
$string['displayreview_help'] = 'Якщо ввімкнено, коли на запитання відповідає неправильна відповідь, учневі надається можливість спробувати ще раз без зарахування балів або продовжити урок. Якщо учень клацне, щоб перейти до іншого запитання, буде вибрана (неправильна) відповідь. За замовчуванням для переходу з неправильною відповіддю встановлено значення «ця сторінка» і оцінка дорівнює 0, тому рекомендується встановлювати перехід неправильної відповіді на іншу сторінку, щоб уникнути плутанини зі своїми учнями.';
$string['displayscorewithessays'] = 'Ви отримали {$a->score} балів із {$a->tempmaxgrade} за питання, оцінені автоматично. <br> Оцінки за {$a->essayquestions} эссе будуть виставленні і враховані при виставленні результативної оцінки. <br> Ваша поточна оцінка (без врахування эсе): {$a->score} из {$a->grade}.';
$string['displayscorewithoutessays'] = 'Ваша оцінка {$a->score} (з {$a->grade}).';
$string['duplicatepagenamed'] = 'Копія сторінки: {$a}';
$string['edit'] = 'Редагувати';
$string['editbranchtable'] = 'Редагування сторінки вмісту';
$string['editcluster'] = 'Редагування кластера';
$string['editendofbranch'] = 'Редагування сторінки кінця гілки';
$string['editendofcluster'] = 'Редагування кінця сторінки кластера';
$string['editessay'] = 'Редагування сторінки запитання есе';
$string['editinglesson'] = 'Урок редагування';
$string['editingquestionpage'] = 'Редагування {$a} сторінки запитань';
$string['editlesson'] = 'Редагувати урок';
$string['editlessonsettings'] = 'Редагувати установки уроку';
$string['editmatching'] = 'Редагування сторінки відповідних запитань';
$string['editmultichoice'] = 'Редагування сторінки запитання з кількома варіантами';
$string['editnumerical'] = 'Редагування сторінки з числовими запитаннями';
$string['editoverride'] = 'Редагувати перевизначення';
$string['editpage'] = 'Редагування вмісту сторінки';
$string['editpagecontent'] = 'Редагування вмісту сторінки';
$string['editquestion'] = 'Редагування сторінки запитання';
$string['editshortanswer'] = 'Редагування сторінки запитання з короткою відповіддю';
$string['edittruefalse'] = 'Редагування сторінки запитань «Правда/неправда».';
$string['email'] = 'Ел.пошта';
$string['emailallgradedessays'] = 'Надіслати сповіщення з оцінкою есе';
$string['emailgradedessays'] = 'Надіслати сповіщення з оцінкою есе';
$string['emailsuccess'] = 'Сповіщення успішно надіслано';
$string['emptypassword'] = 'Пароль не може бути порожнім';
$string['enabled'] = 'Включено';
$string['endofbranch'] = 'Кінець сегменту';
$string['endofcluster'] = 'Кінець кластера';
$string['endofclustertitle'] = 'Кінець кластера';
$string['endoflesson'] = 'Кінець уроку';
$string['enteredthis'] = 'ввів це.';
$string['enterpassword'] = 'Будь ласка, введіть пароль:';
$string['eolstudentoutoftime'] = 'Увага: Виділений час на урок вичерпано. Вашу останню відповідь не буде зараховано, якщо Ви відповіли після закінчення часу.';
$string['eolstudentoutoftimenoanswers'] = 'Ви не дали відповіді на жодне запитання. Ви отримуєте нуль за цей урок.';
$string['essay'] = 'Есе';
$string['essayemailmessage2'] = '<p>Есе уточнення: {$a->question}</p><p>Ваша відповідь:<em>{$a->response}</em></p><p>Коментарі викладача: <em>{$a->comment}</em></p><p>Ви отримали {$a->earned} з {$a->outof} можливих за це завдання.</p><p>Ваша оцінка за урок {$a->lesson} буде змінена до {$a->newgrade}%.</p>';
$string['essayemailmessagesmall'] = 'Ви отримали {$a->earned} з {$a->outof} за це есе. Вашу оцінку за урок {$a->lesson} змінено на {$a->newgrade}%.';
$string['essayemailsubject'] = 'Оцінка за питання уроку';
$string['essaynotgradedyet'] = 'Це есе ще не оцінено';
$string['essayresponses'] = 'Відповіді Есе';
$string['essays'] = 'Есе';
$string['essayscore'] = 'Бали за есе';
$string['eventcontentpageviewed'] = 'Переглянуто вміст сторінки';
$string['eventessayassessed'] = 'Оцінено есе';
$string['eventessayattemptviewed'] = 'Переглянуто есе спроби';
$string['eventhighscoreadded'] = 'Додано високий бал за урок';
$string['eventhighscoresviewed'] = 'Переглянуто високі бали за урок';
$string['eventlessonended'] = 'Закінчено урок';
$string['eventlessonrestarted'] = 'Почато урок заново';
$string['eventlessonresumed'] = 'Відновлено урок';
$string['eventlessonstarted'] = 'Почато урок';
$string['eventoverridecreated'] = 'Створено перевизначення уроку';
$string['eventoverridedeleted'] = 'Вилучено перевизначення уроку';
$string['eventoverrideupdated'] = 'Оновлено перевизначення уроку';
$string['eventpagecreated'] = 'Створено сторінку';
$string['eventpagedeleted'] = 'Вилучено сторінку';
$string['eventpagemoved'] = 'Переміщено сторінку';
$string['eventpageupdated'] = 'Оновлено сторінку';
$string['eventquestionanswered'] = 'Дано відповідь на питання';
$string['eventquestionviewed'] = 'Переглянуто питання';
$string['false'] = 'Неправильно';
$string['fileformat'] = 'Формат файлу';
$string['finalwrong'] = 'Не зовсім.';
$string['finish'] = 'Завершити';
$string['firstanswershould'] = 'перша відповідь повинна перейти до сторінки "Правильно"';
$string['firstwrong'] = 'Ви відповіли неправильно. Хочете спробувати поставити запитання ще раз? (Якщо ви тепер правильно відповісте на запитання, це не буде зараховано до вашого остаточного бала.)';
$string['flowcontrol'] = 'Поточний контроль';
$string['fractionsaddwrong'] = 'Позитивні оцінки за питання в сумі не становлять 100% <br />Їхня сума {$a}%.<br />  Повернутися й виправити питання?';
$string['fractionsnomax'] = 'Одна з відповідей повинна бути оцінена в 100%, щоб<br />було можливо одержати оцінку за це питання<br /> чи хочете ви повернутися й виправити питання?';
$string['full'] = 'Розгорнутий';
$string['general'] = 'Загальний';
$string['gotoendoflesson'] = 'Перейти на кінець уроку';
$string['gradebetterthan'] = 'Оцінка краще ніж (%)';
$string['gradebetterthanerror'] = 'Отримано оцінку кращу ніж {$a} відсотків';
$string['graded'] = 'Оцінено';
$string['gradeessay'] = 'Оцінити есе ({$a->notgradedcount} не оцінені та {$a->notsentcount} не відправлені)';
$string['gradeis'] = 'Оцінка: {$a}';
$string['gradeoptions'] = 'Параметри оцінювання';
$string['groupoverrides'] = 'Перевизначення для групи';
$string['groupoverridesdeleted'] = 'Вилучено перевизначення для групи';
$string['groupsnone'] = 'Немає груп, до яких ви можете отримати доступ.';
$string['handlingofretakes'] = 'Оперування перездачами';
$string['handlingofretakes_help'] = 'Якщо дозволена перездача, то це налаштування визначає, яка оцінка буде кінцевою середня або максимальна зі всіх спроб.';
$string['havenotgradedyet'] = 'Поки що не оцінені.';
$string['here'] = 'тут';
$string['highscore'] = 'Найвищій бал';
$string['hightime'] = 'Найбільший час';
$string['importcount'] = 'Імпортування {$a} питань';
$string['importquestions'] = 'Імпортувати питання';
$string['importquestions_help'] = 'Ця функція дозволяє імпортувати питання в різних форматах за допомогою текстового файлу.';
$string['inactiveoverridehelp'] = '* Це перевизначення неактивне, оскільки доступ користувача до активності обмежено. Це може бути пов’язано з призначенням груп або ролей, іншими обмеженнями доступу або прихованою активністю.';
$string['indicator:cognitivedepth'] = 'Лекція: пізнавальний аспект';
$string['indicator:cognitivedepth_help'] = 'Цей показник базується на глибині пізнання, досягнутої студентом під час роботи на уроці.';
$string['indicator:cognitivedepthdef'] = 'Урок пізнавальний';
$string['indicator:cognitivedepthdef_help'] = 'Учасник досяг цього відсотка когнітивної залученості, запропонованої діяльністю уроку протягом цього інтервалу аналізу (Рівні = Немає перегляду, Переглянути, Надіслати, Переглянути відгук, Коментар до відгуку, Повторно надіслати після перегляду відгуку)';
$string['indicator:cognitivedepthdef_link'] = 'Learning_analytics_indicators#Cognitive_depth';
$string['indicator:socialbreadth'] = 'Лекція: соціальний аспект';
$string['indicator:socialbreadth_help'] = 'Цей показник базується на соціальному розширенні, досягнутому учнем під час діяльності на уроці.';
$string['indicator:socialbreadthdef'] = 'Урок соц';
$string['indicator:socialbreadthdef_help'] = 'Учасник досяг цього відсотка соціальної залученості, запропонованої діяльністю Уроку протягом цього інтервалу аналізу (Рівні = Без участі, Учасник сам, Учасник з іншими)';
$string['indicator:socialbreadthdef_link'] = 'Learning_analytics_indicators#Social_breadth';
$string['insertedpage'] = 'Сторінку додано';
$string['invalidfile'] = 'Неправильний файл';
$string['invalidid'] = 'Немає в курсі Коду модуля або Коду уроку для проходження';
$string['invalidlessonid'] = 'Неправильний Код уроку';
$string['invalidoverrideid'] = 'Неправильний код перевизначення';
$string['invalidpageid'] = 'Неправильний Код сторінки';
$string['jump'] = 'Перехід';
$string['jumps'] = 'Перейти';
$string['jumps_help'] = 'Кожна відповідь (для питань) або опис (для сторінки з даними) повинна пов’язуватися відповідним переходом. Перехід може бути відносним, наприклад, ця сторінка, наступна сторінка, або абсолютним, вказавши будь-яку конкретну сторінку уроку.';
$string['jumpsto'] = 'Перейти до <em>{$a}</em>';
$string['leftduringtimed'] = 'Ви закінчили урок із заданим часом його проходу. <br/> Будь-ласка, клацніть на кнопку «Продовжити», щоб почати урок знову.';
$string['leftduringtimednoretake'] = 'Ви покинули урок під час його проходження і не можете пройти його знову або продовжити.';
$string['leftduringtimedsession'] = 'Ви залишили під час уроку';
$string['lesson:addinstance'] = 'Додавати нові уроки';
$string['lesson:edit'] = 'Редагувати діяльність урок';
$string['lesson:grade'] = 'Оцінювати в Уроці питання типу есе';
$string['lesson:manage'] = 'Керувати діяльністю уроку';
$string['lesson:manageoverrides'] = 'Керувати перевизначеннями уроку';
$string['lesson:view'] = 'Переглянути діяльність уроку';
$string['lesson:viewreports'] = 'Переглядати звіти уроку';
$string['lessonbeingpreviewed'] = 'Урок зараз переглядається.';
$string['lessonclosed'] = 'Цей урок закрився {$a}.';
$string['lessoncloses'] = 'Урок закривається';
$string['lessoneventcloses'] = '{$a} закрито';
$string['lessoneventopens'] = '{$a} доступно';
$string['lessonformating'] = 'Форматування уроку';
$string['lessonmenu'] = 'Меню уроку';
$string['lessonnotready'] = 'Цей урок ще не готовий. Будь ласка, зверніться до свого {$a}.';
$string['lessonnotready2'] = 'Цей урок ще не готовий.';
$string['lessonopen'] = 'Цей урок відкриється {$a}';
$string['lessonopens'] = 'Урок відкрито';
$string['lessonpagelinkingbroken'] = 'Першу сторінку не знайдено. Посилання на сторінку уроку пошкоджена. Будь ласка, зверніться до адміністратора.';
$string['lessonstats'] = 'Статистика уроку';
$string['linkedmedia'] = 'Зв\'язані медіа';
$string['loginfail'] = 'Помилка входу, будь ласка, спробуйте ще раз...';
$string['lowscore'] = 'Найнижчий бал';
$string['lowtime'] = 'Менший час';
$string['manageoverrides'] = 'Керувати перевизначеннями';
$string['manualgrading'] = 'Оцінювання есе';
$string['matchesanswer'] = 'Відповідність відповіді';
$string['matching'] = 'Відповідність';
$string['matchingpair'] = 'Відповідна пара {$a}';
$string['maxgrade'] = 'Максимальна оцінка';
$string['maxgrade_help'] = 'Це налаштування визначає максимальну оцінку за урок. Якщо встановлено 0, то урок не з’являтиметься в журналі оцінок.';
$string['maximumnumberofanswersbranches'] = 'Максимальна кількість варіантів відповідей';
$string['maximumnumberofanswersbranches_help'] = 'Це налаштування визначає максимальну кількість відповідей, які можуть використовуватися в уроці.  Якщо використовуються питання типу Так/Ні, то відповідей може бути тільки 2. Налаштування може бути змінено у будь-який час, оскільки це залежить від викладача, а не від даних, які вводяться.';
$string['maximumnumberofattempts'] = 'Максимальна кількість спроб на запитання';
$string['maximumnumberofattempts_help'] = 'Це налаштування визначає максимальну кількість спроб для кожного питання. Якщо неодноразово надається неправильна відповідь, то коли наступає межа, за якою потрібно переходити до наступної сторінки.';
$string['maximumnumberofattemptsreached'] = 'Досягнуто максимальної кількості спроб - Перехід до наступної сторінки';
$string['mediaclose'] = 'Показати кнопку закриття';
$string['mediafile'] = 'Зв’язане медіа';
$string['mediafile_help'] = 'Для того, щоб включити виринаюче вікно на початку уроку, оберіть відповідний файл, щоб показати. Кожна сторінка уроку буде містити посилання, щоб знову відкрити виринаюче вікно за необхідності.';
$string['mediafilepopup'] = 'Натисніть тут, щоб переглянути';
$string['mediaheight'] = 'Висота спливаючого вікна';
$string['mediawidth'] = 'Ширина спливаючого вікна';
$string['messageprovider:graded_essay'] = 'Повідомлення про оцінку есе уроку';
$string['minimumnumberofquestions'] = 'Мінімальне число запитань';
$string['minimumnumberofquestions_help'] = 'Цей параметр визначає мінімальну кількість запитань, які будуть використані для обчислення оцінки за роботу.';
$string['missingname'] = 'Введіть псевдо';
$string['modattempts'] = 'Дозволити перегляд  студентам.';
$string['modattempts_help'] = 'Після активації, студент може переміщатися в межах одного уроку знов від початку.';
$string['modattemptsnoteacher'] = 'Перегляд студентів доступний лише для студентів.';
$string['modulename'] = 'Урок';
$string['modulename_help'] = '<p>Це найскладніша діяльність, яку необхідно заздалегідь спланувати і ретельно продумати, але вона дозволяє створити гнучкий, ефективний і цікавий навчальний матеріал.</p>
<p>Урок будується за принципом чергування сторінок з теоретичним матеріалом та сторінок з навчальними тестовими завданнями та питаннями. Послідовність переходів між сторінками визначається автором курсу і залежить від того, як студент відповідає на запитання. На неправильні відповіді викладач може надати відповідний коментар.</p>
<p>В арсеналі викладача є широкий набір типів питань: багатоваріантний вибір, вибір правильного варіанту, числова відповідь, коротка відповідь, есе. Сторінки з теоретичним матеріалом можна імпортувати із презентації PowerPoint. Сторінки з питаннями можна імпортувати з різних форматів.</p>
<p>Є можливість налаштовувати кількість спроб студентів, тимчасові обмеження, мінімальні бали, відображати індикатор виконання, отримані на даний момент бали.</p>
<p>Планування уроку вимагає значно більше часу, ніж будь-якої іншої діяльності курсу. Перш, ніж створювати урок, радимо продумати схему вивчення матеріалу, виділяючи послідовність сторінок.</p>
<p><b>Уроки</b> можуть бути використані:</p>
<ul>
  <li>Для самостійного вивчення нової теми</li>
  <li>Для сценаріїв або вправ з моделювання/прийняття рішень</li>
  <li>Для диференційованого перегляду з різними наборами питань в залежності від відповідей на попередні питання</li>
</ul>';
$string['modulename_link'] = 'mod/lesson/view';
$string['modulenameplural'] = 'Уроки';
$string['move'] = 'Перемістити сторінку';
$string['movedpage'] = 'Сторінка переміщена';
$string['movepagehere'] = 'Перемістити сторінку сюди';
$string['movepagenamed'] = 'Перемістити сторінку: {$a}';
$string['moving'] = 'Перехід на сторінку: {$a}';
$string['multianswer'] = 'Багатозначна відповідь';
$string['multianswer_help'] = 'Поставте відмітку у вікні-прапорці, якщо більше, ніж одна відповідь правильна.';
$string['multichoice'] = 'Множинний вибір';
$string['multipleanswer'] = 'Кілька правильних відповідей';
$string['nameapproved'] = 'Ім’я прийнято';
$string['namereject'] = 'Вибачте, вибране вами ім\'я не може бути прийняте (через параметри фільтру, які використовуються).<br/>Спробуйте ввести інше ім\'я.';
$string['new'] = 'нове';
$string['nextpage'] = 'Наступна сторінка';
$string['noanswer'] = 'Одне або більше питань залишилися без відповіді. Будь ласка, поверніться і дайте відповідь.';
$string['noattemptrecordsfound'] = 'Записи про спроби не знайдені: Неможливо оцінити';
$string['nobranchtablefound'] = 'Сторінка з даними не знайдена';
$string['noclose'] = 'Без дати закінчення';
$string['nocommentyet'] = 'Коментарів поки-що немає';
$string['nocoursemods'] = 'Ресурсів не знайдено';
$string['nocredit'] = 'Немає балів';
$string['nodeadline'] = 'Крайній термін не вказано';
$string['noessayquestionsfound'] = 'В цьому уроці не знайдено жодного запитання, яке передбачає написання есе.';
$string['nohighscores'] = 'Відсутні високі результати';
$string['nolessonattempts'] = 'спроби проходження цього уроку не знайдено.';
$string['nolessonattemptsgroup'] = 'Студенти групи {$a} не зробили жодної спроби проходження уроку.';
$string['none'] = 'Немає';
$string['nooneansweredcorrectly'] = 'Ніхто не відповів правильно на це питання.';
$string['nooneansweredthisquestion'] = 'На це запитання не було дано відповіді.';
$string['noonecheckedthis'] = 'Це ще не перевірено.';
$string['nooneenteredthis'] = 'Сюди ніхто не заходив.';
$string['noonehasanswered'] = 'На запитання, що передбачає написання есе ще немає жодних відповідей.';
$string['noonehasansweredgroup'] = 'Ніхто в {$a} ще не дав відповіді на питання есе.';
$string['noopen'] = 'Немає дати початку';
$string['nooverridecreated'] = 'Перевизначення не створено.';
$string['nooverridedata'] = 'Ви повинні перевизначити принаймні один з параметрів уроку.';
$string['noretake'] = 'Вам не дозволяється пройти цей урок ще раз.';
$string['normal'] = 'Непогано - продовжуйте проходити урок';
$string['notcompleted'] = 'Не завершено';
$string['notcompletedwithdate'] = 'Не завершено ({$a})';
$string['notdefined'] = 'Не визначено';
$string['notenoughsubquestions'] = 'Була визначена недостатня кількість підпитань!<br />Повернутися до редагування питання?';
$string['notenoughtimespent'] = 'Ви закінчили урок за {$a->timespent}, що менше ніж необхідний час в {$a->timerequired}. Вам, можливо, буде потрібно зробити ще одну спробу.';
$string['notgraded'] = 'Не оцінено';
$string['notitle'] = 'Немає заголовку';
$string['notyetcompleted'] = 'Урок було почато, але не закінчено';
$string['numberofcorrectanswers'] = 'Кількість правильних відповідей: {$a}';
$string['numberofcorrectanswersheader'] = 'Кількість правильних відповідей';
$string['numberofcorrectmatches'] = 'Кількість правильних відповідностей: {$a}';
$string['numberofpagestoshow'] = 'Кількість сторінок для перегляду';
$string['numberofpagestoshow_help'] = 'Ці налаштування вказують кількість доступних для перегляду сторінок в уроці. Вони застосовуються лише для уроків, сторінки яких демонструються в хаотичному порядку (якщо "Дія після правильної відповіді" або "Показати сторінки без відповіді"). Якщо поставити нуль, будуть відображатися всі сторінки .';
$string['numberofpagesviewed'] = 'Кількість запитань, на які було дано відповідь: {$a}';
$string['numberofpagesviewedheader'] = 'Кількість запитань, на які було дано відповідь';
$string['numberofpagesviewednotice'] = 'Кількість запитань, на які було дано відповідь: {$a->nquestions}; (вам потрібно відповісти хоча б на: {$a->minquestions})';
$string['numerical'] = 'Числовий';
$string['numericanswer'] = 'Числова відповідь';
$string['numericanswer_help'] = 'Ви можете вказати одне число або діапазон чисел за допомогою двокрапки. Наприклад, 2:5 означає, що будь-яка відповідь від 2 до 5, включаючи 2 і 5, є правильною.';
$string['offlinedatamessage'] = 'Ви працювали над цією спробою за допомогою мобільного пристрою. Востаннє дані були збережені на цьому сайті {$a} тому. Будь ласка, переконайтеся, що у вас немає незбережених робіт.';
$string['ongoing'] = 'Показати поточну оцінку';
$string['ongoing_help'] = 'Після активації, на кожній сторінці буде показано кількість вже отриманих балів із максимально можливих.';
$string['ongoingcustom'] = 'Ви отримали {$a->score} бал(ів) з {$a->currenthigh} можливих.';
$string['ongoingnormal'] = 'Ви відповіли правильно на {$a->correct} запитань із {$a->viewed} переглянутих.';
$string['onpostperpage'] = 'Тільки одне повідомлення на оцінку';
$string['openafterclose'] = 'Ви вказали дату відкриття після дати закриття';
$string['options'] = 'Параметри';
$string['or'] = 'АБО';
$string['ordered'] = 'Впорядкований';
$string['other'] = 'Інший';
$string['outof'] = 'З {$a}';
$string['override'] = 'Перевизначити';
$string['overridedeletegroupsure'] = 'Ви впевнені, що хочете вилучити перевизначення для групи {$a}?';
$string['overridedeleteusersure'] = 'Ви впевнені, що хочете вилучити перевизначення для користувача {$a}?';
$string['overridegroup'] = 'Перевизначення для групи';
$string['overridegroupeventname'] = '{$a->lesson} - {$a->group}';
$string['overrides'] = 'Перевизначення';
$string['overrideuser'] = 'Перевизначення для користувача';
$string['overrideusereventname'] = '{$a->lesson} - Перевизначення';
$string['overview'] = 'Переглянути';
$string['overview_help'] = 'Урок складається з певного числа обов’язкових сторінок та додаткових сторінок з даними. На сторінці розміщено деякий матеріал і, який, зазвичай, закінчується запитанням. З кожною відповіддю на запитання відбувається перехід. Перехід може бути відносним, як на цю сторінку або наступну сторінку, або абсолютним, з вказуванням будь-якої зі сторінок уроку. Інформативна сторінка - це сторінка, що містить безліч переходів на інші сторінки в уроці, наприклад, Зміст.';
$string['page'] = 'Сторінка: {$a}';
$string['page-mod-lesson-edit'] = 'Редагувати сторінку уроку';
$string['page-mod-lesson-view'] = 'Переглянути або попередньо переглянути сторінку уроку';
$string['page-mod-lesson-x'] = 'Будь-яка сторінка уроку';
$string['pageanswers'] = 'Сторінка відповідей';
$string['pagecontents'] = 'Вміст сторінок';
$string['pageresponses'] = 'Сторінка відгуків';
$string['pages'] = 'Сторінки';
$string['pagetitle'] = 'Заголовок сторінки';
$string['password'] = 'Пароль';
$string['passwordprotectedlesson'] = '{$a} - урок, захищений паролем.';
$string['pleasecheckoneanswer'] = 'Виберіть одну відповідь';
$string['pleasecheckoneormoreanswers'] = 'Виберіть одну або кілька відповідей';
$string['pleaseenteryouranswerinthebox'] = 'Введіть Вашу відповідь в поле';
$string['pleasematchtheabovepairs'] = 'Поставте у відповідність';
$string['pluginadministration'] = 'Керування уроком';
$string['pluginname'] = 'Урок';
$string['pointsearned'] = 'Отримані бали';
$string['postprocesserror'] = 'Сталася помилка під час закінчення обробки!';
$string['postsuccess'] = 'відправлено успішно';
$string['practice'] = 'Тренувальний урок';
$string['practice_help'] = 'Тренувальний урок не з’являється в журналі оцінок.';
$string['preprocesserror'] = 'Сталася помилка під час попередньої обробки!';
$string['prerequisiteisobsolete'] = 'Опція доступу до уроку за умовою буде вилучена. Будь ласка, використовуйте новий модуль обмеження доступності.';
$string['prerequisitelesson'] = 'Передумова уроку';
$string['preview'] = 'Попередньо переглянути';
$string['previewlesson'] = 'Попередньо переглянути {$a}';
$string['previewpagenamed'] = 'Переглянути сторінку: {$a}';
$string['previouspage'] = 'Попередня сторінка';
$string['privacy:metadata:attempts'] = 'Запис спроб сторінки';
$string['privacy:metadata:attempts:answerid'] = 'Ідентифікатор відповіді';
$string['privacy:metadata:attempts:correct'] = 'Чи правильною була спроба';
$string['privacy:metadata:attempts:pageid'] = 'Ідентифікатор сторінки';
$string['privacy:metadata:attempts:retry'] = 'Номер спроби';
$string['privacy:metadata:attempts:timeseen'] = 'Час, коли була зроблена спроба';
$string['privacy:metadata:attempts:useranswer'] = 'Детальна інформація про відповідь користувача';
$string['privacy:metadata:attempts:userid'] = 'Ідентифікатор користувача';
$string['privacy:metadata:branch'] = 'Запис про переглянуті сторінки';
$string['privacy:metadata:branch:flag'] = 'Чи була розрахована наступна сторінка випадковим чином';
$string['privacy:metadata:branch:nextpageid'] = 'Ідентифікатор наступної сторінки';
$string['privacy:metadata:branch:pageid'] = 'Ідентифікатор сторінки';
$string['privacy:metadata:branch:retry'] = 'Номер спроби';
$string['privacy:metadata:branch:timeseen'] = 'Час перегляду сторінки';
$string['privacy:metadata:branch:userid'] = 'Ідентифікатор користувача';
$string['privacy:metadata:grades'] = 'Запис оцінок за кожен урок';
$string['privacy:metadata:grades:completed'] = 'Дата, коли була виставлена оцінка';
$string['privacy:metadata:grades:grade'] = 'Поставлена оцінка';
$string['privacy:metadata:grades:userid'] = 'Ідентифікатор користувача';
$string['privacy:metadata:overrides'] = 'Запис перевизначення за урок';
$string['privacy:metadata:overrides:available'] = 'Час, коли можна спробувати урок';
$string['privacy:metadata:overrides:deadline'] = 'Кінцевий термін завершення уроку.';
$string['privacy:metadata:overrides:maxattempts'] = 'Максимальна кількість спроб';
$string['privacy:metadata:overrides:password'] = 'Пароль для доступу до уроку';
$string['privacy:metadata:overrides:retake'] = 'Чи дозволені повторні зйомки';
$string['privacy:metadata:overrides:review'] = 'Чи дозволено повторне запитання';
$string['privacy:metadata:overrides:timelimit'] = 'Обмеження часу на завершення уроку в секундах.';
$string['privacy:metadata:overrides:userid'] = 'Ідентифікатор користувача';
$string['privacy:metadata:timer'] = 'Запис спроби уроку';
$string['privacy:metadata:timer:completed'] = 'Чи завершена спроба';
$string['privacy:metadata:timer:lessontime'] = 'Останній момент, коли ми зафіксували активність';
$string['privacy:metadata:timer:starttime'] = 'Дата початку спроби';
$string['privacy:metadata:timer:timemodifiedoffline'] = 'Останній момент, коли ми записали активність із мобільного додатка';
$string['privacy:metadata:timer:userid'] = 'Ідентифікатор користувача';
$string['privacy:metadata:userpref:lessonview'] = 'Бажаний режим відображення під час редагування уроків';
$string['privacy:path:essayanswers'] = 'Відповіді на есе';
$string['privacy:path:essayresponses'] = 'Відповіді на есе';
$string['privacy:path:pages'] = 'Сторінки';
$string['processerror'] = 'Сталася помилка під час обробки!';
$string['progressbar'] = 'Індикатор виконання';
$string['progressbar_help'] = 'Якщо включено, то індикатор відображається на сторінках уроку, показуючи у відсотковому значенні проходження уроку.';
$string['progressbarteacherwarning'] = 'Індикатор виконання не показується для {$a}';
$string['progressbarteacherwarning2'] = 'Ви не можете бачити індикатор виконання, оскільки ви можете редагувати цей урок';
$string['progresscompleted'] = 'Ви вже пройшли {$a}% уроку';
$string['qtype'] = 'Формат сторінки';
$string['question'] = 'Питання';
$string['questionoption'] = 'Питання';
$string['questiontype'] = 'Тип питання';
$string['randombranch'] = 'Випадкова сторінка з даними';
$string['randompageinbranch'] = 'Випадкове питання у межах сторінки';
$string['rank'] = 'Розташувати в порядку';
$string['rawgrade'] = 'Попередня оцінка';
$string['receivedcredit'] = 'Отримані бали';
$string['redisplaypage'] = 'Повторно показати сторінку';
$string['removeallgroupoverrides'] = 'Вилучити всі перевизначення для груп';
$string['removealluseroverrides'] = 'Вилучити всі перевизначення для користувачів';
$string['report'] = 'Звіт';
$string['reports'] = 'Звіти';
$string['response'] = 'Відповідь';
$string['retakesallowed'] = 'Перездачу дозволено';
$string['retakesallowed_help'] = 'Після активації, студенти матимуть можливість пройти урок більше, ніж один раз.';
$string['returnto'] = 'Повернутися до {$a}';
$string['returntocourse'] = 'Повернутися до курсу';
$string['reverttodefaults'] = 'Повернутися до типових налаштувань уроку';
$string['review'] = 'Переглянути';
$string['reviewlesson'] = 'Переглянути урок';
$string['reviewquestionback'] = 'Так, я хочу спробувати знов';
$string['reviewquestioncontinue'] = 'Ні, я просто хочу перейти до наступного питання';
$string['sanitycheckfailed'] = 'Помилка при перевірці: Ця спроба була видалена';
$string['save'] = 'Зберегти';
$string['savechanges'] = 'Зберегти зміни';
$string['savechangesandeol'] = 'Зберегти всі зміни і перейти до кінця уроку.';
$string['saveoverrideandstay'] = 'Зберегти та ввести інше перевизначення';
$string['savepage'] = 'Зберегти сторінку';
$string['score'] = 'Оцінка';
$string['score_help'] = 'Бали використовуються тільки при включеному ручному оцінюванні. Кожній відповіді тоді може бути надане числове (позитивне або негативне) значення.';
$string['scores'] = 'Бали';
$string['search:activity'] = 'Урок - інформація про діяльність';
$string['secondpluswrong'] = 'Недостатньо. Ви хочете спробувати знову?';
$string['selectallattempts'] = 'Виберіть усі спроби';
$string['selectaqtype'] = 'Вибрати тип питання';
$string['selectreport'] = 'Виберіть звіт';
$string['sent'] = 'Надісланий';
$string['shortanswer'] = 'Коротка відповідь';
$string['showanunansweredpage'] = 'Показати сторінки без відповідей';
$string['showanunseenpage'] = 'Показати не переглянуту сторінку';
$string['singleanswer'] = 'Одна відповідь';
$string['skip'] = 'Пропустити навігацію';
$string['slideshow'] = 'Показ слайдів';
$string['slideshow_help'] = 'Після активації, урок буде показуватися у вигляді демонстрації слайдів, з фіксованою шириною та висотою.';
$string['slideshowbgcolor'] = 'Колір тла показу слайдів';
$string['slideshowheight'] = 'Висота демонстрації слайдів';
$string['slideshowwidth'] = 'Ширина демонстрації слайдів';
$string['startlesson'] = 'Розпочати урок';
$string['studentattemptlesson'] = 'Спроба №{$a->attempt} для {$a->lastname} {$a->firstname}';
$string['studentname'] = '{$a} Ім`я студента';
$string['studentoneminwarning'] = 'Увага! У Вас одна хвилина або менше, щоб закінчить урок.';
$string['studentoutoftimeforreview'] = 'Увага: у вас не вистачило часу на повторення цього уроку';
$string['studentresponse'] = 'Відповідь студента {$a}';
$string['submit'] = 'Відправити';
$string['submitname'] = 'Відправити ім\'я';
$string['teacherjumpwarning'] = 'У цьому уроці використовується стрибок {$a->cluster} або {$a->unseen}. Замість цього буде використано наступний перехід сторінки. Увійдіть як студент, щоб перевірити ці стрибки.';
$string['teacherongoingwarning'] = 'Поточна оцінка відображається лише для студента. Увійдіть як студент, щоб перевірити поточний результат.';
$string['teachertimerwarning'] = 'Таймер працює лише для студентів. Перевірте таймер, зайшовши в систему як студент.';
$string['thatsthecorrectanswer'] = 'Це правильна відповідь';
$string['thatsthewronganswer'] = 'Це неправильна відповідь';
$string['thefollowingpagesjumptothispage'] = 'Наступні сторінки переходять до цієї сторінки';
$string['thispage'] = 'Ця сторінка';
$string['timeisup'] = 'Час вийшов';
$string['timelimit'] = 'Обмеження часу';
$string['timelimit_help'] = 'Якщо ввімкнено, на початку уроку відображається попередження про обмеження часу, а також відображається таймер зворотного відліку. Будь-які відповіді, надані після закінчення часу, не оцінюються.';
$string['timelimitwarning'] = 'Ви маєте {$a} до закінчення уроку.';
$string['timeremaining'] = 'Залишилося';
$string['timespenterror'] = 'Ви повинні відпрацювати з уроком принаймні {$a} хвилин';
$string['timespentminutes'] = 'Затрачений час (у хвилинах)';
$string['timetaken'] = 'Витрачений час';
$string['totalpagesviewedheader'] = 'Кількість переглянутих сторінок';
$string['true'] = 'Правильно';
$string['truefalse'] = 'Правильно/Неправильно';
$string['unabledtosavefile'] = 'Звантажений вами файл не вдалося зберегти';
$string['unknownqtypesnotimported'] = '{$a} питань з непідтримуваними типами не були імпортовані';
$string['unseenpageinbranch'] = 'Не переглянута сторінка гілки';
$string['unsupportedqtype'] = 'Тип питання, який не підтримується ({$a})!';
$string['updatedpage'] = 'Оновлена сторінка';
$string['updatefailed'] = 'Оновлення не відбулося';
$string['updatepagenamed'] = 'Оновити сторінку: {$a}';
$string['usemaximum'] = 'Максимальна оцінка';
$string['usemean'] = 'Середня оцінка';
$string['usepassword'] = 'Урок захищено паролем';
$string['usepassword_help'] = 'Після активації, для доступу до уроку потрібно буде ввести пароль';
$string['useroverrides'] = 'Перевизначення для користувача';
$string['useroverridesdeleted'] = 'Перевизначення для користувача вилучено';
$string['usersnone'] = 'Немає студентів з доступом до цього уроку';
$string['viewessayanswers'] = 'Переглянути відповіді на есе';
$string['viewgrades'] = 'Подивитися оцінки';
$string['viewreports'] = 'Переглянути {$a->attempts} спроб, які завершив {$a->student}';
$string['viewreports2'] = 'Переглянути {$a} завершених спроб';
$string['warning'] = 'Увага';
$string['welldone'] = 'Відмінно!';
$string['whatdofirst'] = 'Що Ви бажаєте зробити спершу?';
$string['withselectedattempts'] = 'З обраними спробами...';
$string['wronganswerjump'] = 'Перехід при неправильній відповіді';
$string['wronganswerscore'] = 'Бали за неправильну відповідь';
$string['wrongresponse'] = 'Неправильна відповідь';
$string['youhaveseen'] = 'Ви вже працювали з цим уроком.<br /> Хочете продовжити з того місця, на якому Ви зупинились?';
$string['youranswer'] = 'Ваша відповідь';
$string['yourcurrentgradeis'] = 'Ваша поточна оцінка - {$a}';
$string['yourcurrentgradeisoutof'] = 'Ваша оцінка {$a->grade} з {$a->total}';
$string['youshouldview'] = 'Вам потрібно відповісти хоча б на: {$a}';
