<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'workshop', language 'sv', version '5.1'.
 *
 * @package     workshop
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['activitydate:assessmentsclose'] = 'Bedömningarna avslutas:';
$string['activitydate:assessmentsclosed'] = 'Bedömningarna avslutades:';
$string['activitydate:assessmentsopen'] = 'Bedömningarna påbörjas:';
$string['activitydate:assessmentsopened'] = 'Bedömningarna påbörjades:';
$string['activitydate:submissionsclose'] = 'Inlämningarna stänger:';
$string['activitydate:submissionsclosed'] = 'Inlämningar stängdes:';
$string['activitydate:submissionsopen'] = 'Inlämningar öppnas:';
$string['activitydate:submissionsopened'] = 'Inlämningar öppnades:';
$string['aggregategrades'] = 'Räkna om betygen';
$string['aggregation'] = 'Betygsaggregering';
$string['allocate'] = 'Fördela inlämningar';
$string['allocatedetails'] = 'förväntat: {$a->expected}<br />inlämnat: {$a->submitted}<br />att fördela: {$a->allocate}';
$string['allocation'] = 'Fördelning av inlämningar';
$string['allocationconfigured'] = 'Fördelning konfigurerad';
$string['allocationdone'] = 'Fördelning utförd';
$string['allocationerror'] = 'Fel vid fördelning';
$string['allowedfiletypesforoverallfeedback'] = 'Tillåtna filtyper i återkopplingsbilagor';
$string['allowedfiletypesforoverallfeedback_help'] = 'Filtyper för återkopplingsbilagor kan begränsas genom att ange en lista över tillåtna filtyper. Om fältet lämnas tomt är alla filtyper tillåtna.';
$string['allowedfiletypesforoverallfeedback_link'] = 'admin/tool/filetypes/index';
$string['allowedfiletypesforsubmission'] = 'Tillåtna filtyper i inlämningsbilagor';
$string['allowedfiletypesforsubmission_help'] = 'Tillåtna filtyper i inlämningsbilagor kan begränsas genom att ange en lista över tillåtna filtyper. Om fältet lämnas tomt är alla filtyper tillåtna.';
$string['allowedfiletypesforsubmission_link'] = 'admin/tool/filetypes/index';
$string['allsubmissions'] = 'Alla inlämningar ({$a})';
$string['alreadygraded'] = 'Redan betygsatt';
$string['areaconclusion'] = 'Slutsatstext';
$string['areainstructauthors'] = 'Inlämningsinstruktioner';
$string['areainstructreviewers'] = 'Bedömningsinstruktioner';
$string['areaoverallfeedbackattachment'] = 'Bilagor till övergripande återkoppling';
$string['areaoverallfeedbackcontent'] = 'Texter för övergripande återkoppling';
$string['areasubmissionattachment'] = 'Inlämningsbilagor';
$string['areasubmissioncontent'] = 'Inlämningstexter';
$string['assess'] = 'Bedöm';
$string['assessedexample'] = 'Bedömd exempeluppgift';
$string['assessedsubmission'] = 'Bedömd inlämning';
$string['assessingexample'] = 'Bedömer inlämnad exempeluppgift';
$string['assessingsubmission'] = 'Bedömer inlämnad uppgift';
$string['assessment'] = 'Bedömning';
$string['assessmentby'] = 'av <a href="{$a->url}">{$a->name}</a>';
$string['assessmentbyfullname'] = 'Bedömning av {$a}';
$string['assessmentbyyourself'] = 'Din bedömning';
$string['assessmentdeleted'] = 'Bedömning ej längre fördelad';
$string['assessmentend'] = 'Slutdatum för bedömningar';
$string['assessmentendbeforestart'] = 'Sista dag för bedömning kan inte vara innan datum för att öppna för bedömning';
$string['assessmentenddatetime'] = 'Sluttid för bedömning: {$a->daydatetime} ({$a->distanceday})';
$string['assessmentendevent'] = '{$a} sluttid för bedömning';
$string['assessmentform'] = 'Bedömningsformulär';
$string['assessmentofsubmission'] = '<a href="{$a->assessmenturl}">Bedömning</a> av <a href="{$a->submissionurl}">{$a->submissiontitle}</a>';
$string['assessmentreference'] = 'Referensbedömning';
$string['assessmentreferenceconflict'] = 'Det är inte möjligt att bedöma en exempelinlämning som du gav en referensbedömning.';
$string['assessmentreferenceneeded'] = 'Du måste bedöma denna exempelinlämning för att ge en referensbedömning. Klicka på knappen "Fortsätt" för att bedöma inlämningen.';
$string['assessments'] = 'Bedömningar';
$string['assessmentsettings'] = 'Bedömningsinställningar';
$string['assessmentstart'] = 'Öppen för bedömning från';
$string['assessmentstartdatetime'] = 'Öppen för bedömning från {$a->daydatetime} ({$a->distanceday})';
$string['assessmentstartevent'] = '{$a} öppnar för bedömning';
$string['assessmentweight'] = 'Bedömningsvikt';
$string['assignedassessments'] = 'Tilldelade inlämningar att bedöma';
$string['assignedassessmentsnone'] = 'Du har ingen tilldelad inlämning att bedöma';
$string['backtoeditform'] = 'Tillbaka till redigeringsformuläret';
$string['byfullname'] = 'av <a href="{$a->url}">{$a->name}</a>';
$string['byfullnamewithoutlink'] = 'av {$a}';
$string['calculategradinggrades'] = 'Beräkna bedömningsbetyg';
$string['calculategradinggradesdetails'] = 'förväntat: {$a->expected}<br />beräknat: {$a->calculated}';
$string['calculatesubmissiongrades'] = 'Beräkna inlämningsbetyg';
$string['calculatesubmissiongradesdetails'] = 'förväntat: {$a->expected}<br />beräknat: {$a->calculated}';
$string['chooseuser'] = 'Välj användare...';
$string['clearaggregatedgrades'] = 'Ta bort alla aggregerade betyg';
$string['clearaggregatedgrades_help'] = 'De aggregerade betygen för inlämningar och betyg för bedömningar återställs. Du kan omberäkna dessa betyg från början i Betygsfas.';
$string['clearaggregatedgradesconfirm'] = 'Är du säker på att du vill ta bort de beräknade inlämnings- och bedömningsbetygen?';
$string['clearassessments'] = 'Rensa bedömningar';
$string['clearassessments_help'] = 'De beräknade betygen för inlämningar samt betyg för bedömningar kommer att återställas. Informationen om hur bedömningsformuläret ska fyllas i kommer behållas, men alla granskare måste öppna bedömningsformuläret på nytt och spara om det för att få de givna betygen att beräknas igen.';
$string['clearassessmentsconfirm'] = 'Är du säker på att du vill ta bort alla betyg? Du kommer inte att kunna få tillbaka informationen på egen hand, alla granskare måste på nytt bedöma sina tilldelade inlämningsuppgifter.';
$string['conclusion'] = 'Slutsats';
$string['conclusion_help'] = 'Slutsats visas för deltagare på slutet av aktiviteten.';
$string['configexamplesmode'] = 'Standardvärde för exempelbedömningar i workshops';
$string['configgrade'] = 'Förvalt maximalt betyg för inlämningar i workshops';
$string['configgradedecimals'] = 'Förvalt antal siffror som ska visas efter decimalkommat vid visning av betyg.';
$string['configgradinggrade'] = 'Förvalt maximalt betyg för bedömning i workshop';
$string['configmaxbytes'] = 'Förvald maximal filstorlek för inlämningar i alla workshops på webbplatsen (med förbehåll för kursbegränsningar och andra lokala inställningar)';
$string['configstrategy'] = 'Förvald betygsstrategi för workshops';
$string['createsubmission'] = 'Lägg till inlämning';
$string['crontask'] = 'Bakgrundsbearbetning för workshop-modul';
$string['daysago'] = 'för {$a} dagar sedan ';
$string['daysleft'] = '{$a} dagar kvar';
$string['daystoday'] = 'idag';
$string['daystomorrow'] = 'imorgon';
$string['daysyesterday'] = 'igår';
$string['deadline'] = 'Stoppdatum/tid';
$string['deadlinesignored'] = 'Tidsbegränsningar gäller inte dig';
$string['deletesubmission'] = 'Ta bort inlämning';
$string['editassessmentform'] = 'Redigera bedömningsformulär';
$string['editassessmentformstrategy'] = 'Redigera bedömningsformulär ({$a})';
$string['editingassessmentform'] = 'Redigerar bedömningsformulär';
$string['editingsubmission'] = 'Redigerar inlämning';
$string['editsubmission'] = 'Redigera inlämning';
$string['err_multiplesubmissions'] = 'Medan du redigerade denna blankett blev en annan version av uppgiften inlämnad. Du kan inte skicka in flera versioner.';
$string['err_removegrademappings'] = 'Kunde inte ta bort oanvända betygsmappningar';
$string['evaluategradeswait'] = 'Vänta tills bedömningarna är utvärderade och betygen beräknade.';
$string['evaluation'] = 'Betygsutvärdering';
$string['evaluationmethod'] = 'Betygsutvärderingsmetod';
$string['evaluationmethod_help'] = 'Betygsutvärderingsmetoden avgör hur betyg för bedömning beräknas. Du kan låta den beräkna om betygen upprepade gånger med olika inställningar om du inte är nöjd med resultatet.';
$string['evaluationsettings'] = 'Inställningar för betygsutvärdering';
$string['eventassessableuploaded'] = 'En inlämning har laddats upp.';
$string['eventassessmentevaluated'] = 'Bedömning utvärderad';
$string['eventassessmentevaluationsreset'] = 'Återställning av utvärderade bedömningar';
$string['eventassessmentreevaluated'] = 'Bedömning utvärderad på nytt';
$string['eventphaseautomaticallyswitched'] = 'Fas automatiskt växlad';
$string['eventphaseswitched'] = 'Fas växlad';
$string['eventsubmissionassessed'] = 'Inlämning bedömd';
$string['eventsubmissionassessmentsreset'] = 'Inlämningsbedömningar tömda';
$string['eventsubmissioncreated'] = 'Inlämning skapad';
$string['eventsubmissiondeleted'] = 'Inlämning borttagen';
$string['eventsubmissionreassessed'] = 'Inlämning bedömd på nytt';
$string['eventsubmissionupdated'] = 'Inlämning uppdaterad';
$string['eventsubmissionviewed'] = 'Inlämning visad';
$string['example'] = 'Exempelinlämning';
$string['exampleadd'] = 'Lägg till exempelinlämning';
$string['exampleassess'] = 'Bedöm exempelinlämning';
$string['exampleassessments'] = 'Exempelinlämningar att bedöma';
$string['exampleassesstask'] = 'Bedöm exempel';
$string['exampleassesstaskdetails'] = 'förväntad: {$a->expected}<br />bedömd: {$a->assessed}';
$string['examplecomparing'] = 'Jämför bedömningar av exempelinlämningar';
$string['exampledelete'] = 'Ta bort exempel';
$string['exampledeleteconfirm'] = 'Är du säker på att du vill ta bort följande exempelinlämning? Klicka på knappen "Fortsätt" för att ta bort inlämningen.';
$string['exampleedit'] = 'Redigera exempel';
$string['exampleediting'] = 'Redigerar exempel';
$string['exampleneedassessed'] = 'Du måste först bedöma alla exempelinlämningar';
$string['exampleneedsubmission'] = 'Du måste först lämna in ditt arbete och bedöma alla exempelinlämningar';
$string['examplesbeforeassessment'] = 'Exempel är tillgängliga efter egen inlämning och måste bedömas innan inbördes utvärdering';
$string['examplesbeforesubmission'] = 'Exempel måste bedömas innan egen inlämning';
$string['examplesmode'] = 'Läge för exempelbedömning';
$string['examplesubmissions'] = 'Exempelinlämningar';
$string['examplesvoluntary'] = 'Bedömning av exempelinlämning är frivillig';
$string['exportsubmission'] = 'Exportera sidan';
$string['feedbackauthor'] = 'Återkoppling till författaren';
$string['feedbackauthorattachment'] = 'Bilaga';
$string['feedbackby'] = 'Återkoppling från {$a}';
$string['feedbackreviewer'] = 'Återkoppling till granskaren';
$string['feedbacksettings'] = 'Återkoppling';
$string['formataggregatedgrade'] = '{$a->grade}';
$string['formataggregatedgradeover'] = '<del>{$a->grade}</del><br /><ins>{$a->over}</ins>';
$string['formatpeergrade'] = '<span class="grade">{$a->grade}</span> <span class="gradinggrade">({$a->gradinggrade})</span>';
$string['formatpeergradeover'] = '<span class="grade">{$a->grade}</span> <span class="gradinggrade">(<del>{$a->gradinggrade}</del> / <ins>{$a->gradinggradeover}</ins>)</span>';
$string['formatpeergradeoverweighted'] = '<span class="grade">{$a->grade}</span> <span class="gradinggrade">(<del>{$a->gradinggrade}</del> / <ins>{$a->gradinggradeover}</ins>)</span> @ <span class="weight">{$a->weight}</span>';
$string['formatpeergradeweighted'] = '<span class="grade">{$a->grade}</span> <span class="gradinggrade">({$a->gradinggrade})</span> @ <span class="weight">{$a->weight}</span>';
$string['givengrades'] = 'Betyg utdelade';
$string['grade_grading_name'] = 'Bedömning';
$string['grade_submission_name'] = 'Inlämning';
$string['gradecalculated'] = 'Beräknat betyg för inlämning';
$string['gradedecimals'] = 'Antal decimaler i betyg';
$string['gradegivento'] = '&gt;';
$string['gradeinfo'] = 'Betyg: {$a->received} av {$a->max}';
$string['gradeitemassessment'] = '{$a->workshopname} (bedömning)';
$string['gradeitemsubmission'] = '{$a->workshopname} (inlämning)';
$string['gradeover'] = 'Åsidosätt betyg för inlämning';
$string['gradereceivedfrom'] = '&lt;';
$string['gradesreport'] = 'Betygsrapport för workshop';
$string['gradetopassgrading'] = 'Betygsgräns för godkänd bedömning';
$string['gradetopasssubmission'] = 'Betygsgräns för godkänd inlämning';
$string['gradinggrade'] = 'Maxbetyg för bedömning';
$string['gradinggrade_help'] = 'Denna inställning anger maximalt betyg som kan uppnås för bedömning av inlämningar.';
$string['gradinggradecalculated'] = 'Beräknat betyg för bedömning';
$string['gradinggradeof'] = 'Betyg för bedömning (av {$a})';
$string['gradinggradeover'] = 'Åsidosätt betyg för bedömning';
$string['gradingsettings'] = 'Betygsinställningar';
$string['groupnoallowed'] = 'Du har inte tillåtelse att bedöma någon grupp i denna workshop';
$string['iamsure'] = 'Ja, jag är säker';
$string['indicator:cognitivedepth'] = 'Workshop kognitiv';
$string['indicator:cognitivedepth_help'] = 'Denna indikator baseras på det kognitiva djup som uppnåtts av studenten i en Workshopaktivitet.';
$string['indicator:cognitivedepthdef'] = 'Workshop kognitiv';
$string['indicator:cognitivedepthdef_help'] = 'Deltagaren har uppnått denna procentandel av det kognitiva engagemanget som tillhandahålls av Workshop-aktiviteten under detta analysintervall (Nivåer = Ej visad, Visad, Lämna in, Visa återkoppling, Kommentera återkoppling, Ny inlämning efter att ha sett återkoppling)';
$string['indicator:cognitivedepthdef_link'] = 'Learning_analytics_indicators#Cognitive_depth';
$string['indicator:socialbreadth'] = 'Workshop social';
$string['indicator:socialbreadth_help'] = 'Denna indikator baseras på den sociala bredd som uppnåtts av studenten i en Workshopaktivitet.';
$string['indicator:socialbreadthdef'] = 'Workshop social';
$string['indicator:socialbreadthdef_help'] = 'Deltagaren har nått denna procentandel av det sociala engagemanget som erbjuds av Workshopaktiviteterna under detta analysintervall (Nivåer = Inget deltagande, Deltagaren ensamt, Deltagaren tillsammans med andra)';
$string['indicator:socialbreadthdef_link'] = 'Learning_analytics_indicators#Social_breadth';
$string['info'] = 'Info';
$string['instructauthors'] = 'Inlämningsinstruktioner';
$string['instructreviewers'] = 'Bedömningsinstruktioner';
$string['introduction'] = 'Beskrivning';
$string['latesubmissions'] = 'Sent inskickade uppgifter';
$string['latesubmissions_desc'] = 'Tillåt inskickning av uppgifter efter sluttiden.';
$string['latesubmissions_help'] = 'Om aktiverat kan en workshopdeltagare lämna in sitt arbete efter tidsfristen för inlämning eller under bedömningsfasen. För sent inlämnade arbeten kan däremot inte redigeras.';
$string['latesubmissionsallowed'] = 'Sent inskickade uppgifter accepteras';
$string['maxbytes'] = 'Maximal filstorlek för inlämningsbilagor';
$string['modulename'] = 'Workshop';
$string['modulename_help'] = 'Aktiviteten <em>Workshop</em> möjliggör insamling, granskning och medarbetarbedömning av elevernas arbeten.

Eleverna kan lämna digitalt innehåll (filer), som dokument från ordbehandlingsprogram eller kalkylark och kan även skriva text direkt i ett fält med hjälp av textredigeraren.

Inlämningarna bedöms med hjälp av ett formulär där läraren definierat ett flertal bedömningskriterier. Processen för bedömning av inlämnade uppgifter samt att förstå bedömningsformuläret kan förövas med exempelinlämningar och exempelbedömningar som läraren skapat. Eleverna ges möjlighet att bedöma en eller flera av deras tilldelade inlämningar. Inlämnade uppgifter och gjorda bedömningar av arbeten kan vara anonyma vid behov.

Eleverna får två betyg i en workshop - ett betyg för sin inlämnade uppgift och ett betyg för sina medarbetarbedömningar. Båda betygen sparas i betygsboken.';
$string['modulename_link'] = 'mod/workshop/view';
$string['modulenameplural'] = 'Workshops';
$string['myassessments'] = 'Mina bedömningar';
$string['mysubmission'] = 'Min inskickade uppgift';
$string['nattachments'] = 'Maximalt antal bilagor till inlämningsuppgift';
$string['noexamples'] = 'Det finns inga exempel i denna workshop än';
$string['noexamplesformready'] = 'Du måste definiera bedömningsformuläret innan du ger exempel på inlämningsuppgifter';
$string['nogradeyet'] = 'Inget betyg ännu';
$string['nosubmissionfound'] = 'Ingen inlämnad uppgift hittades för denna användare';
$string['nosubmissions'] = 'Inga inlämnade uppgifter finns än i denna workshop';
$string['nosubmissiontype'] = 'Minst en inlämningstyp måste finnas';
$string['notassessed'] = 'Ej bedömd';
$string['nothingfound'] = 'Inget att visa';
$string['nothingtoreview'] = 'Inget att granska';
$string['notoverridden'] = 'Ej åsidosatt';
$string['noworkshops'] = 'Det finns inga Workshops i den här kursen';
$string['noyoursubmission'] = 'Du har inte lämnat in ditt arbete ännu';
$string['nullgrade'] = '-';
$string['overallfeedback'] = 'Övergripande återkoppling';
$string['overallfeedbackfiles'] = 'Högsta antal tillåtna bilagor till övergripande återkoppling';
$string['overallfeedbackmaxbytes'] = 'Maxmal storlek för bilaga till övergripande återkoppling';
$string['overallfeedbackmode'] = 'Läge för övergripande återkoppling';
$string['overallfeedbackmode_0'] = 'Inaktiverad';
$string['overallfeedbackmode_1'] = 'Aktiverad och valfri';
$string['overallfeedbackmode_2'] = 'Aktiverad och obligatorisk';
$string['overallfeedbackmode_help'] = 'Om det är aktiverat visas ett textfält längst ned i bedömningsformuläret. Granskare kan ange den övergripande bedömningen av uppgiften där, eller ge ytterligare förklaring av sin bedömning.';
$string['page-mod-workshop-x'] = 'Vilken sida som helst i workshopmodulen';
$string['participant'] = 'Deltagare';
$string['participantrevierof'] = 'Deltagaren är granskare av';
$string['participantreviewedby'] = 'Deltagaren granskas av';
$string['phase'] = 'Fas';
$string['phaseassessment'] = 'Bedömningsfas';
$string['phaseclosed'] = 'Stängd';
$string['phaseevaluation'] = 'Betygsutvärderingsfas';
$string['phasesetup'] = 'Förberedelsefas';
$string['phasesoverlap'] = 'Inlämningsfasen och bedömningsfasen kan inte överlappa varandra';
$string['phasesubmission'] = 'Inlämningsfas';
$string['pluginadministration'] = 'Workshopadministration';
$string['pluginname'] = 'Workshop';
$string['prepareexamples'] = 'Förbered exempelinlämningar';
$string['previewassessmentform'] = 'Förhandsgranska';
$string['privacy:metadata:aggregatedgradinggrade'] = 'Aggregerat betyg för alla bedömningar som användaren gör i den angivna workshopaktiviteten';
$string['privacy:metadata:assessmentgrade'] = 'Aggregerat betyg för den inlämning som föreslås utifrån denna bedömning';
$string['privacy:metadata:assessmentgradinggrade'] = 'Betyg för att tillhandahålla bedömningen';
$string['privacy:metadata:assessmentgradinggradeover'] = 'Manuellt åsidosatt värde för betyget för tillhandahållande av denna bedömning';
$string['privacy:metadata:assessmentid'] = 'ID för bedömning';
$string['privacy:metadata:authorid'] = 'ID för inlämnande författare';
$string['privacy:metadata:dimensiongrade'] = 'Betyg i den givna bedömningsdimensionen';
$string['privacy:metadata:dimensionid'] = 'ID för bedömningsdimensionen';
$string['privacy:metadata:example'] = 'Om denna post representerar en exempelinlämning';
$string['privacy:metadata:feedbackauthor'] = 'Återkoppling för författaren';
$string['privacy:metadata:feedbackauthorformat'] = 'Textformat på återkoppling till författaren';
$string['privacy:metadata:feedbackreviewer'] = 'Återkoppling till användaren som tillhandahöll bedömningen';
$string['privacy:metadata:feedbackreviewerformat'] = 'Textformat på återkoppling på användaren som tillhandahöll bedömningen';
$string['privacy:metadata:late'] = 'Om inlämningen lämnats in efter sluttiden';
$string['privacy:metadata:peercomment'] = 'Kommentar på betyget från användaren som tillhandahöll bedömningen';
$string['privacy:metadata:peercommentformat'] = 'Textformat på kommentar på det utdelade betyget';
$string['privacy:metadata:preference:perpage'] = 'Antal inlämningar användaren föredrar att se per sida';
$string['privacy:metadata:preference:viewlet-allexamples-collapsed'] = 'Komprimerad/expanderad-status för \'Exempelinlämning\'-panelen.';
$string['privacy:metadata:preference:viewlet-allsubmissions-collapsed'] = 'Komprimerad/expanderad-status för \'Inlämningstapport\'-panelen.';
$string['privacy:metadata:preference:viewlet-assessmentform-collapsed'] = 'Komprimerad/expanderad-status för \'Bedömningsformulär\'-sektionen.';
$string['privacy:metadata:preference:viewlet-assignedassessments-collapsed'] = 'Det komprimerade/expanderade tillståndet för vyn Tilldelade inlämningar att bedöma.';
$string['privacy:metadata:preference:viewlet-cleargrades-collapsed'] = 'Det komprimerade/expanderade tillståndet för vyn Workshopverktyg.';
$string['privacy:metadata:preference:viewlet-conclusion-collapsed'] = 'Det komprimerade/expanderade tillståndet för vyn Slutsats.';
$string['privacy:metadata:preference:viewlet-examples-collapsed'] = 'Det komprimerade/expanderade tillståndet för vyn Exempelinlämningar att bedöma.';
$string['privacy:metadata:preference:viewlet-examplesfail-collapsed'] = 'Det komprimerade/expanderade tillståndet för vyn Exempelinlämningar att bedöma.';
$string['privacy:metadata:preference:viewlet-gradereport-collapsed'] = 'Det komprimerade/expanderade tillståndet för vyn Betygsrapporten i workshopmodulen.';
$string['privacy:metadata:preference:viewlet-instructauthors-collapsed'] = 'Det komprimerade/expanderade tillståndet för vyn Inlämningsinstruktioner.';
$string['privacy:metadata:preference:viewlet-instructreviewers-collapsed'] = 'Det komprimerade/expanderade tillståndet för vyn Bedömningsinstruktioner.';
$string['privacy:metadata:preference:viewlet-intro-collapsed'] = 'Det komprimerade/expanderade tillståndet för vyn Introduktion.';
$string['privacy:metadata:preference:viewlet-overallfeedback-collapsed'] = 'Det komprimerade/expanderade tillståndet för vyn Övergripande återkoppling.';
$string['privacy:metadata:preference:viewlet-ownsubmission-collapsed'] = 'Det komprimerade/expanderade tillståndet för vyn Dina inlämningar.';
$string['privacy:metadata:preference:viewlet-publicsubmissions-collapsed'] = 'Det komprimerade/expanderade tillståndet för vyn Publicerade inlämningar.';
$string['privacy:metadata:preference:viewlet-yourgrades-collapsed'] = 'Det komprimerade/expanderade tillståndet för vyn "Dina betyg".';
$string['privacy:metadata:published'] = 'Om inlämningen ska offentliggöras för alla deltagare när workshopen stängs';
$string['privacy:metadata:reviewerid'] = 'ID för användaren som tillhandahåller utvärderingen';
$string['privacy:metadata:strategy'] = 'Namn på delplugin för bedömningsstrategin som tolkar postvärdena';
$string['privacy:metadata:submissioncontent'] = 'Inlämningens innehåll';
$string['privacy:metadata:submissioncontentformat'] = 'Textformatet på inlämningsinnehållet';
$string['privacy:metadata:submissiongrade'] = 'Aggregerat resultat för inlämningen angivet som ett decimaltal i intervallet 0..100';
$string['privacy:metadata:submissiongradeover'] = 'Manuellt åsidosatt värde för det aggregerade betyget';
$string['privacy:metadata:submissionid'] = 'ID för inlämningen';
$string['privacy:metadata:submissiontitle'] = 'Inlämningens titel';
$string['privacy:metadata:subsystem:corefiles'] = 'Workshopmodulen lagrar filer inbäddade i / kopplade till inlämningstexten';
$string['privacy:metadata:subsystem:coreplagiarism'] = 'Workshopmodulen har inbyggt stöd för system som skyddar mot plagieringar';
$string['privacy:metadata:timeaggregated'] = 'När det aggregerade betyget senast beräknades';
$string['privacy:metadata:timecreated'] = 'När denna post skapades i databasen';
$string['privacy:metadata:timemodified'] = 'När posten senast ändrades i databasen';
$string['privacy:metadata:userid'] = 'ID för användaren vars aggregerade betyg beräknats';
$string['privacy:metadata:weight'] = 'Viktningen för bedömningen';
$string['privacy:metadata:workshopaggregations'] = 'Innehåller aggregerade bedömningsbetyg';
$string['privacy:metadata:workshopassessments'] = 'Innehåller information om tilldelade bedömningar av inlämningar i workshopmodulen';
$string['privacy:metadata:workshopgrades'] = 'Innehåller information om hur bedömningsformulären fylldes med resultat och kommentarer';
$string['privacy:metadata:workshopid'] = 'ID för workshopaktiviteten';
$string['privacy:metadata:workshopsubmissions'] = 'Innehåller information om workshopmodulens inlämningar';
$string['privacy:request:delete:content'] = 'Detta innehåll har tagits bort (antingen på begäran av användaren eller för att det förfallit)';
$string['privacy:request:delete:title'] = '[Borttagen]';
$string['publishedsubmissions'] = 'Publicerade inlämningar';
$string['publishsubmission'] = 'Publicera inlämning';
$string['publishsubmission_help'] = 'Publicerade inlämningar är tillgängliga för andra när workshopen stängs.';
$string['reassess'] = 'Bedöm igen';
$string['receivedgrades'] = 'Betyg mottagna';
$string['recentassessments'] = 'Workshop-bedömningar:';
$string['recentsubmissions'] = 'Workshop-inlämningar:';
$string['resetassessments'] = 'Ta bort alla bedömningar';
$string['resetassessments_help'] = 'Du kan välja att endast ta bort allokerade utvärderingar utan att detta påverkar inlämningar. Om inlämningar ska tas bort tas deras utvärderingar implicit bort och det här alternativet ignoreras. Observera att detta även omfattar utvärderingar av exempelinlämningar.';
$string['resetphase'] = 'Växla till inställningsfas';
$string['resetphase_help'] = 'Om aktiverat kommer samtliga workshops att sättas i den initiala uppsättningfasen.';
$string['resetsubmissions'] = 'Ta bort alla inlämningar';
$string['resetsubmissions_help'] = 'Alla inlämningar tillsammans med deras bedömningar kommer att tas bort. Detta påverkar inte exempelinlämningar.';
$string['saveandclose'] = 'Spara och stäng';
$string['saveandcontinue'] = 'Spara och fortsätt att redigera';
$string['saveandpreview'] = 'Spara och förhandsgranska';
$string['saveandshownext'] = 'Spara och visa nästa';
$string['search:activity'] = 'Workshop - aktivitetsinformation';
$string['selfassessmentdisabled'] = 'Självbedömning inaktiverad';
$string['showingperpage'] = 'Visar {$a} objekt per sida';
$string['showingperpagechange'] = 'Ändra ...';
$string['someuserswosubmission'] = 'Det finns minst en deltagare som ännu inte har lämnat in sitt arbete';
$string['sortasc'] = 'Stigande sortering';
$string['sortdesc'] = 'Fallande sortering';
$string['strategy'] = 'Betygsstrategi';
$string['strategy_help'] = 'Bedömningsstrategin bestämmer vilket bedömningsformulär som används och metoden för att bedöma inlämningar. Det finns 4 alternativ:

* Ackumulerad betygssättning - Kommentarer och betyg ges avseende specificerade aspekter
* Kommentarer - Kommentarer ges om angivna aspekter men inget betyg kan ges
* Antal fel - Kommentarer och en ja/nej-bedömning ges avseende angivna påståenden
* Bedömningsmatris - En nivåbedömning görs avseende angivna kriterier';
$string['strategyhaschanged'] = 'Workshopens betygsstrategi har ändrats sedan formuläret öppnades för redigering.';
$string['submission'] = 'Inlämning';
$string['submissionattachment'] = 'Bilaga';
$string['submissionby'] = 'Inskickad uppgift av {$a}';
$string['submissioncontent'] = 'Inlämningsinnehåll';
$string['submissiondeleteconfirm'] = 'Är du säker på att du vill ta bort följande inlämning?';
$string['submissiondeleteconfirmassess'] = 'Är du säker på att du vill ta bort följande inlämningar? Observera att detta även tar bort {$a->count} bedömningar som är knutna till denna inlämning och som kan påverka granskarens betyg.';
$string['submissionend'] = 'Sluttid för inlämningar';
$string['submissionendbeforestart'] = 'Sluttid för inlämning kan inte anges som före tid för början av inlämning';
$string['submissionenddatetime'] = 'Sluttid för inskickning av uppgifter: {$a->daydatetime} ({$a->distanceday})';
$string['submissionendevent'] = '{$a} sluttid för inlämningar';
$string['submissionendswitch'] = 'Byt till nästa fas efter tidsgränsen för inlämningar';
$string['submissionendswitch_help'] = 'Om en tidsfrist för inlämningar anges och denna ruta är markerad, kommer Workshopen automatiskt växla till bedömningsfasen efter det att tidsfristen för inlämningar inträffat.

Om du aktiverar den här funktionen rekommenderas du även att ställa in en schemalagd allokering. Om inlämningarna inte allokeras kan ingen bedömning göras även om själva Workshopen befinner sig i bedömningsfasen.';
$string['submissiongrade'] = 'Maxbetyg för inlämning';
$string['submissiongrade_help'] = 'Denna inställning anger maximalt betyg som kan erhållas för inlämnat arbete.';
$string['submissiongradeof'] = 'Betyg för inlämning (av {$a})';
$string['submissionlastmodified'] = 'Senast ändrad';
$string['submissionrequiredcontent'] = 'Du måste skriva något eller lägga till en fil.';
$string['submissionrequiredfile'] = 'Du måste lägga till en fil eller ange text';
$string['submissions'] = 'Inskickade  uppgiftslösningar';
$string['submissionsallocation'] = 'Inlämningstilldelning';
$string['submissionsettings'] = 'Inlämningsinställningar';
$string['submissionsreport'] = 'Workshopinlämningsrapport';
$string['submissionstart'] = 'Öppen för inlämning av uppgifter';
$string['submissionstartdatetime'] = 'Öppen för inlämning av uppgifter från {$a->daydatetime} ({$a->distanceday})';
$string['submissionstartevent'] = '{$a} öppnar för inlämningar';
$string['submissiontitle'] = 'Titel';
$string['submissiontypedisabled'] = 'Denna inlämningstyp är inaktiverad i denna workshop.';
$string['submissiontypefileavailable'] = 'Filbilags<span class="accesshide"> tillgänglig</span>';
$string['submissiontypefilerequired'] = '<span class="accesshide">Filbilaga </span>Krävs';
$string['submissiontypes'] = 'Inlämningstyper';
$string['submissiontypetextavailable'] = 'Online textinlämning<span class="accesshide"> tillgänglig</span>';
$string['submissiontypetextrequired'] = '<span class="accesshide">Online textinlämning </span>Krävs';
$string['submittednotsubmitted'] = 'Inlämnade ({$a->submitted}) / nej inlämnade ({$a->notsubmitted})';
$string['subplugintype_workshopallocation'] = 'Fördelningsmetod för inlämningar';
$string['subplugintype_workshopallocation_plural'] = 'Fördelningsmetoder för inlämningar';
$string['subplugintype_workshopeval'] = 'Betygsättningsmetod';
$string['subplugintype_workshopeval_plural'] = 'Betygsättningsmetoder';
$string['subplugintype_workshopform'] = 'Betygsstrategi';
$string['subplugintype_workshopform_plural'] = 'Betygsstrategier';
$string['switchingphase'] = 'Byter fas';
$string['switchphase'] = 'Byt fas';
$string['switchphase10'] = 'Växla till uppsättningsfasen';
$string['switchphase10info'] = 'Du håller på att byta fas för workshopen till <strong>Förberedelsefas</strong>. I denna fas kan användare inte ändra sina inlämningar eller deras bedömningar. Lärare kan använda denna fas för att ändra inställningar för workshopen, ändra betygsstrategi eller justera bedömningsformerna.';
$string['switchphase20'] = 'Växla till inlämningsfasen';
$string['switchphase20info'] = 'Du håller på att byta fas för workshopen till <strong>Inlämningsfas</strong>. Eleverna kan lämna in sitt arbete under denna fas (inom givna datum, om dessa är inställda). Lärare kan fördela bidrag för kollegial granskning.';
$string['switchphase30'] = 'Växla till bedömningsfasen';
$string['switchphase30auto'] = 'Workshopen kommer automatiskt in i bedömningsfasen efter {$a->daydatetime} ({$a->distanceday})';
$string['switchphase30info'] = 'Du håller på att byta fas för workshopen till <strong>Bedömningsfas</strong>. I denna fas kan granskare bedöma de inlämningar som de tilldelats (inom givna datum, om dessa är inställda).';
$string['switchphase40'] = 'Växla till utvärderingsfasen';
$string['switchphase40info'] = 'Du håller på att byta fas för workshopen till <strong>Betygsfas</strong>. I denna fas kan användare inte ändra sina inlämningar eller sina gjorda bedömningar. Lärare kan använda verktygen för betygsutvärdering för att beräkna slutbetyg och ge återkoppling för granskare.';
$string['switchphase50'] = 'Stäng workshop';
$string['switchphase50info'] = 'Du håller på att stänga workshopen. Detta innebär att de beräknade betygen kommer finnas i Betygsboken. Eleverna kan se sina inlämningar och sina gjorda bedömningar.';
$string['switchphaseauto'] = 'Byte har schemalagts';
$string['switchphasenext'] = 'Byt till nästa fas';
$string['taskassesspeers'] = 'Bedöm kollegor';
$string['taskassesspeersdetails'] = 'summa: {$a->total}<br />återstående: {$a->todo}';
$string['taskassessself'] = 'Bedöm dig själv';
$string['taskconclusion'] = 'Ge en slutsats för aktiviteten';
$string['taskdone'] = 'Uppgift genomförd';
$string['taskfail'] = 'Uppgift misslyckad';
$string['taskinfo'] = 'Uppgiftsinformation';
$string['taskinstructauthors'] = 'Ge anvisningar för inlämning';
$string['taskinstructreviewers'] = 'Ge anvisningar för bedömning';
$string['taskintro'] = 'Ställ in beskrivningen för workshopen';
$string['tasksubmit'] = 'Lämna in ditt arbete';
$string['tasktodo'] = 'Uppgift att göra';
$string['toolbox'] = 'Verktygslåda för workshop';
$string['undersetup'] = 'Workshopen håller på att skapas. Vänta tills den övergår till nästa fas';
$string['useexamples'] = 'Använd exempel';
$string['useexamples_desc'] = 'Exempelinlämningar finns för att träna på bedömning';
$string['useexamples_help'] = 'Om det är aktiverat kan användare försöka bedöma en eller flera exempelinlämningar och jämföra sin bedömning med en referensbedömning. Betyget räknas inte i betyget för bedömning.';
$string['usepeerassessment'] = 'Använd kollegial bedömning';
$string['usepeerassessment_desc'] = 'Eleverna kan bedöma andras arbete';
$string['usepeerassessment_help'] = 'Om det är aktiverat kan en användare tilldelas inlämningar från andra användare att bedöma, och får betyg för sina gjorda bedömningar tillsammans med betyget för sin inlämnade uppgift.';
$string['userdatecreated'] = 'inlämnat den <span>{$a}</span>';
$string['userdatemodified'] = 'modifierat den <span>{$a}</span>';
$string['userplan'] = 'Workshopplanerare';
$string['userplan_help'] = 'Workshop planeraren visar alla faser av aktiviteten och listar uppgifterna för varje fas. Den innevarande fasen är markerad och genomföra uppgifter markeras som förbockade.';
$string['userplanaccessibilityskip'] = 'Hoppa till nuvarande uppgifter';
$string['userplanaccessibilitytitle'] = 'Workshoptidslinje med {$a} faser';
$string['userplancurrentphase'] = 'Aktuell fas';
$string['useselfassessment'] = 'Använd självbedömning';
$string['useselfassessment_desc'] = 'Studerande tillåts utvärdera sitt eget arbete';
$string['useselfassessment_help'] = 'Om det är aktiverat kan en användare tilldelas sin egen inlämning för bedömning och kommer att få ett betyg för bedömning utöver ett betyg för inlämnande.';
$string['viewworkshopsummary'] = 'Visa översikt';
$string['weightinfo'] = 'Viktning: {$a}';
$string['withoutsubmission'] = 'Utvärderare utan egen inlämning';
$string['workshop:addinstance'] = 'Lägg till en ny workshop';
$string['workshop:allocate'] = 'Tilldela inlämningar för granskning';
$string['workshop:deletesubmissions'] = 'Radera inlämning';
$string['workshop:editdimensions'] = 'Redigera bedömningsformulär';
$string['workshop:exportsubmissions'] = 'Exportera inlämningar';
$string['workshop:ignoredeadlines'] = 'Ignorera tidsbegränsningar';
$string['workshop:manageexamples'] = 'Hantera exempel inlämningar';
$string['workshop:overridegrades'] = 'Åsidosätt beräknade betyg';
$string['workshop:peerassess'] = 'Kollegiebedömning';
$string['workshop:publishsubmissions'] = 'Publicera inlämningar';
$string['workshop:submit'] = 'Skicka';
$string['workshop:switchphase'] = 'Byt fas';
$string['workshop:view'] = 'Visa Workshop';
$string['workshop:viewallassessments'] = 'Visa alla bedömningar';
$string['workshop:viewallsubmissions'] = 'Visa alla inlämningar';
$string['workshop:viewauthornames'] = 'Visa författarnamn';
$string['workshop:viewauthorpublished'] = 'Visa författare för publicerade inlämningar';
$string['workshop:viewpublishedsubmissions'] = 'Visa publicerade inlämningar';
$string['workshop:viewreviewernames'] = 'Visa granskares namn';
$string['workshopname'] = 'Namn';
$string['yourassessmentfor'] = 'Din bedömning av {$a}';
$string['yourgrades'] = 'Dina betyg';
$string['yoursubmission'] = 'Din inlämning';
$string['yoursubmissionwithassessments'] = 'Din inlämning med utvärderingar';
