<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'quiz', language 'sv', version '5.1'.
 *
 * @package     quiz
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['accessnoticesheader'] = 'Du kan förhandsgranska det här kunskapstestet, men om detta vore ett verkligt försök, skulle du bli blockerad eftersom:';
$string['action'] = 'Åtgärd';
$string['activityoverview'] = 'Du har kunskapstest som är försenade';
$string['adaptive'] = 'Adaptivt läge';
$string['adaptive_help'] = 'Om detta är aktiverat kommer flera svarsförsök på en fråga att tillåtas inom samma försök på kunskapstestet. Så om till exempel ett svar är markerat som felaktigt ska studenten ha rätt att försöka igen direkt. Dock, om det är inställt på "Tillämpa avdrag", så kommer ett avdrag att göras för varje felaktigt försök.';
$string['add'] = 'Lägg till';
$string['addaquestion'] = 'ny fråga';
$string['addarandomquestion'] = 'slumpmässig fråga';
$string['addarandomquestion_help'] = 'När en slumpmässig fråga läggs till, resulterar det i att en slumpmässigt vald fråga från kategorin infogas i kunskapstestet. Detta innebär att olika studenter kan få olika urval av frågor, och när ett kunskapstest tillåter flera försök, så innehåller sannolikt varje försök ett nytt urval av frågor.';
$string['addarandomselectedquestion'] = 'Lägg till en slumpmässig fråga...';
$string['addasection'] = 'ny avsnittsrubrik';
$string['adddescriptionlabel'] = 'Lägg till beskrivning';
$string['addingquestion'] = 'Lägger till en fråga';
$string['addingquestions'] = '<p>Den här sidan på sidan är där du hanterar din frågedatabas. Frågor lagras i kategorier för att hjälpa dig att hålla dem organiserade och de kan användas av alla kunskapstest i din kurs eller till och med andra kurser om du väljer att "publicera" dem.</p>
<p>Efter att du har valt eller skapat en frågekategori kan du skapa eller redigera frågor. Du kan välja någon av dessa frågor som ska läggas till i ditt kunskapstest på andra sidan av denna sida.</p>';
$string['addmoreoverallfeedbacks'] = 'Lägg till ytterligare {no} fält för återkoppling';
$string['addnewgroupoverride'] = 'Lägg till gruppåsidosättande';
$string['addnewpagesafterselected'] = 'Lägg till nya sidor efter de valda frågorna';
$string['addnewquestionsqbank'] = 'Lägg till frågor till kategorin {$a->catname}: {$a->link}';
$string['addnewuseroverride'] = 'Lägg till användaråsidosättande';
$string['addpagebreak'] = 'Lägg till sidbrytning';
$string['addpagehere'] = 'Lägg till sida här';
$string['addquestion'] = 'Lägg till fråga';
$string['addquestionfrombankatend'] = 'Lägg till från frågebanken sist i kunskapstestet';
$string['addquestionfrombanktopage'] = 'Lägg till från frågebanken till sida {$a}';
$string['addquestions'] = 'Lägg till frågor';
$string['addquestionstoquiz'] = 'Lägg till frågor till det aktuella kunskapstestet';
$string['addrandom'] = 'Lägg till {$a} slumpmässiga frågor';
$string['addrandom1'] = '<< Lägg till';
$string['addrandom2'] = 'slumpmässiga frågor';
$string['addrandomfromcategory'] = 'Lägg till slumpmässiga frågor från kategorin: ';
$string['addrandomquestion'] = 'Lägg till en slumpmässig fråga';
$string['addrandomquestionatend'] = 'Lägg till en fråga sist i kunskapstestet';
$string['addrandomquestiontopage'] = 'Lägg till en slumpmässig fråga till sida {$a}';
$string['addrandomquestiontoquiz'] = 'Lägg till en slumpmässig fråga till kunskapstest {$a}';
$string['addselectedquestionstoquiz'] = 'Lägg valda frågor till kunskapstestet';
$string['addselectedtoquiz'] = 'Lägg valda till kunskapstestet';
$string['addtoquiz'] = 'Lägg till i kunskapstestet';
$string['affectedstudents'] = 'Berörda {$a}';
$string['aftereachquestion'] = 'Efter tillägget av varje fråga';
$string['afternquestions'] = 'Efter tillägget av {$a} frågor';
$string['age'] = 'ålder';
$string['allattempts'] = 'Alla försök';
$string['allinone'] = 'Obegränsat';
$string['allowreview'] = 'Tillåt granskning';
$string['alreadysubmitted'] = 'Det är troligt att du redan har skickat in detta försök för bedömning.';
$string['alternativeunits'] = 'Alternativa enheter';
$string['alwaysavailable'] = 'Alltid tillgängligt';
$string['alwayslatest'] = 'Alltid senaste';
$string['analysisoptions'] = 'Analysalternativ';
$string['analysistitle'] = 'Tabell för komponentanalys';
$string['answer'] = 'Svar';
$string['answered'] = 'Besvarad';
$string['answerhowmany'] = 'Ett eller flera svar?';
$string['answers'] = 'Svar';
$string['answersingleno'] = 'Flera svar tillåtna';
$string['answersingleyes'] = 'Endast ett svar';
$string['answertoolong'] = 'Svaret är för långt efter rad {$a} (max 255 tecken)';
$string['anytags'] = 'Valfria etiketter';
$string['aon'] = 'AON-format';
$string['areyousureremoveselected'] = 'Är du säker på att du vill ta bort alla de valda frågorna?';
$string['asshownoneditscreen'] = 'Som visat i redigeringsskärmen';
$string['attempt'] = 'Försök {$a}';
$string['attemptalreadyclosed'] = 'Det här försöket har redan slutförts.';
$string['attemptclosed'] = 'Försöket har inte avslutats ännu';
$string['attemptduration'] = 'Tidsåtgång';
$string['attemptedon'] = 'Försök genomfört den';
$string['attempterror'] = 'Du får inte göra detta kunskapstest nu eftersom: {$a}';
$string['attempterrorcontentchange'] = 'Den här förhandsvisningen finns inte längre. (När ett kunskapstest redigeras tas eventuellt pågående förhandsgranskningar automatiskt bort.)';
$string['attempterrorcontentchangeforuser'] = 'Detta försök finns inte längre.';
$string['attempterrorinvalid'] = 'Ogiltigt försöks-ID';
$string['attemptfirst'] = 'Första försöket';
$string['attemptgradeddelay'] = 'Tidsfördröjning innan aviseringar om betygsatt försök skickas';
$string['attemptgradeddelay_desc'] = 'En fördröjning tillämpas innan ett meddelande skickas till studenten för att berätta att deras kunskapstest-försök nu har betygsatts. Det här är en kompromiss. Vi vill meddela studenten så snart som möjligt. Läraren kan dock gå tillbaka och redigera betyget igen, och vi vill inte meddela eleven innan det händer';
$string['attemptincomplete'] = 'Det här försöket (av {$a}) är ännu inte avslutat';
$string['attemptlast'] = 'Senaste försök';
$string['attemptnumber'] = 'Försök';
$string['attemptquiz'] = 'Gör kunskapstestet';
$string['attemptquiznow'] = 'Påbörja kunskapstest';
$string['attemptreviewtitle'] = '{$a}: Försöksgranskning';
$string['attemptreviewtitlepaged'] = '{$a->name}: Försöksgranskning (page {$a->currentpage} av {$a->totalpages})';
$string['attempts'] = 'Försök';
$string['attempts_help'] = 'Totala antalet tillåtna försök (ej antalet extraförsök).';
$string['attemptsallowed'] = 'Antal tillåtna försök';
$string['attemptsdeleted'] = 'Försök borttagna';
$string['attemptselection'] = 'Markera vilka försök per användare som du vill analysera:';
$string['attemptsexist'] = 'Du kan inte längre lägga till eller ta bort frågor.';
$string['attemptsnum'] = 'Försök: {$a}';
$string['attemptsnumthisgroup'] = 'Försök: {$a->total} ({$a->group} från den här gruppen)';
$string['attemptsnumyourgroups'] = 'Försök: {$a->total} ({$a->group} från dina grupper)';
$string['attemptsonly'] = 'Visa bara de studenter som har gjort försök';
$string['attemptstate'] = 'Status';
$string['attemptstillinprogress'] = 'Pågående försök';
$string['attemptsummarytitle'] = '{$a}: Försökssammanfattning';
$string['attemptsunlimited'] = 'Obegränsat antal försök';
$string['attempttitle'] = '{$a}';
$string['attempttitlepaged'] = '{$a->name} (page {$a->currentpage} av {$a->totalpages})';
$string['autosaveperiod'] = 'Intervall för autospara';
$string['autosaveperiod_desc'] = 'Svar kan sparas automatiskt under försök av ett kunskapstest. Svaren sparas när de ändras och därefter enligt denna fördröjning. Det finns en avvägning: en kortare fördröjning ökar serverbelastningen, men minskar risken för att eleverna förlorar sitt arbete. Om du ska göra denna fördröjning mycket kortare bör du ändra värdet gradvis och övervaka serverbelastningen. Om lasten blir för hög, gör du fördröjningen längre igen. Om du ställer in fördröjningen på 0 stängs autospara av.';
$string['back'] = 'Tillbaka till förhandsgranskning av fråga';
$string['backtocourse'] = 'Tillbaka till kursen';
$string['backtoquestionlist'] = 'Tillbaka till frågelistan';
$string['backtoquiz'] = 'Tillbaka till redigering av test';
$string['bestgrade'] = 'Bästa betyget';
$string['bothattempts'] = 'Visa både studenter som har gjort försök och som inte har gjort försök';
$string['browsersecurity'] = 'Webbläsarsäkerhet';
$string['browsersecurity_help'] = 'Om "Fullskärms popup med JavaScript säkerhet" är valt,

* Kunskapstestet kommer bara att starta om studenten har JavaScript aktiverat i sin Webläsare
* Testet visas i ett popup fönster som täcker alla andra fönster och saknar navigationskontroller
* Studenterna är hindrade, så långt som möjligt från att använda möjligheter som  klipp och klistra';
$string['cachedef_overrides'] = 'Information om användar- och gruppåsidosättanden';
$string['calculated'] = 'Beräknad';
$string['calculatedquestion'] = 'Beräknad fråga stödjs inte på rad {$a}. Ingen hänsyn kommer att tas till frågan.';
$string['cannotcreatepath'] = 'Det går inte att skapa sökvägen';
$string['cannoteditafterattempts'] = 'Du kan inte ta bort eller lägga till frågor eftersom det har gjorts försök på det här kunskapstestet. ({$a})';
$string['cannotfindprevattempt'] = 'Det går inte att hitta ett föregående försök att bygga vidare på';
$string['cannotfindquestionregard'] = 'Det gick inte att hämta frågorna för att göra om betygssättningen!';
$string['cannotinsert'] = 'Det går inte att infoga fråga';
$string['cannotinsertrandomquestion'] = 'Det gick inte att infoga en ny slumpmässig fråga!';
$string['cannotloadquestion'] = 'Det gick inte att ladda alternativen som hör till frågan';
$string['cannotloadtypeinfo'] = 'Det gick inte att ladda in frågetypen med specifik information kring frågan';
$string['cannotopen'] = 'Det går inte att öppna den exporterade filen ({$a})';
$string['cannotremoveallsectionslots'] = 'Du har valt alla frågorna i avsnittet \'{$a}\'. Det är inte tillåtet att ta bort alla frågor i ett avsnitt.';
$string['cannotremoveslots'] = 'Kan inte ta bort frågor';
$string['cannotrestore'] = 'Det gick inte att återställa frågesessionerna';
$string['cannotreviewopen'] = 'Du kan inte granska det här försöket eftersom det fortfarande pågår';
$string['cannotsavelayout'] = 'Det gick inte att spara layouten';
$string['cannotsavenumberofquestion'] = 'Det gick inte att spara antal frågor per sida';
$string['cannotsavequestion'] = 'Det går inte att spara frågelistan';
$string['cannotsetgrade'] = 'Det gick inte att ange ett nytt maxbetyg för kunskapstestet';
$string['cannotsetsumgrades'] = 'Det gick inte att ställa in sammanlagda betyg';
$string['cannotstartgradesmismatch'] = 'Kan inte starta ett försök för detta kunskapstest. Testet är inställt för att betygssättas utifrån {$a->grade}, men ingen av frågorna i kunskapstest har ett betyg. Detta kan lösas på sidan \'Redigera kunskapstest\'.';
$string['cannotstartmissingquestion'] = 'Kan inte starta försök för detta kunskapstest. Testets definition innehåller en fråga som inte existerar.';
$string['cannotstartnoquestions'] = 'Kan inte starta försök för detta kunskapstest. Testet har inte satts upp ännu. Inga frågor har lagts till.';
$string['cannotwrite'] = 'Det går inte att skriva till den exporterade filen ({$a})';
$string['canredoquestions'] = 'Tillåt nytt försök';
$string['canredoquestions_desc'] = 'Om aktiverat visas efter avslutat frågor försök knappen \'Prova en annan fråga som den här\'. Detta gör det möjligt att försöka besvara en liknande fråga (väljs slumpmässigt), eller samma fråga igen, utan att hela kunskapstestet måste lämnas in och ett annat test startas. Det här alternativet är användbart för övningstest. Den här inställningen påverkar bara frågor och beteenden (till exempel omedelbar feedback eller interaktiv med flera försök) där det är möjligt att avsluta en fråga innan försöket skickas in.';
$string['canredoquestions_help'] = 'Om det här alternativet är aktiverat visas knappen \'Prova en annan fråga som den här\' när du har avslutat ett försök att besvara en fråga. Detta gör att en liknande fråga (vald slumpmässigt), eller samma fråga igen, kan försöka besvaras, utan att hela kunskapstestet behöver skickas in och ett nytt försök startas. Det här alternativet är användbart för övningstester.

Den här inställningen påverkar bara frågor och beteenden (till exempel omedelbar återkoppling eller interaktiv med flera försök) där det är möjligt att slutföra en fråga innan svarsförsöket skickas in.';
$string['canredoquestionsyes'] = 'Ja, visa alternativet \'Prova en annan fråga som den här\'';
$string['caseno'] = 'Nej, skiftläget spelar ingen roll';
$string['casesensitive'] = 'Skiftlägeskänslighet';
$string['caseyes'] = 'Ja, skiftläget måste matcha';
$string['categoryadded'] = 'Kategorin \'{$a}\' lades till';
$string['categorydeleted'] = 'Kategorin \'{$a}\' togs bort';
$string['categorynoedit'] = 'Du har inte behörighet att redigera privilegier i kategorin \'{$a}\'.';
$string['categoryupdated'] = 'Kategorin uppdaterades framgångsrikt';
$string['close'] = 'Stäng fönster';
$string['closebeforeopen'] = 'Det gick inte att uppdatera kunskapstestet. Du har angivit ett slutdatum som ligger för startdatumet.';
$string['closed'] = 'Stängd';
$string['closepreview'] = 'Stäng förhandsgranskning';
$string['closereview'] = 'Stäng granskning';
$string['comment'] = 'Kommentar';
$string['commentorgrade'] = 'Kommentera eller åsidosätt betyg';
$string['comments'] = 'Kommenarer';
$string['completedon'] = 'Slutfördes';
$string['completionattemptsexhausted'] = 'Eller alla tillgängliga försök avslutade';
$string['completionattemptsexhausted_help'] = 'Markera kunskapstestet som slutfört när studenten har uppnått maximala antalet försök.';
$string['completiondetail:minattempts'] = 'Försök: {$a}';
$string['completiondetail:passorexhaust'] = 'Uppnå godkänt betyg eller slutför alla möjliga försök';
$string['completionminattempts'] = 'Minsta antal försök:';
$string['completionminattemptsdesc'] = 'Minsta antal försök som krävs: {$a}';
$string['completionminattemptserror'] = 'Minsta antal försök måste vara lägre eller lika med antalet försök som tillåts.';
$string['completionpassorattemptsexhausteddesc'] = 'Studenten måste uppnå godkänt betyg, eller uttömma alla tillgängliga försök att slutföra denna aktivitet';
$string['configadaptive'] = 'Om du väljer "Ja" för det här alternativet då kommer studenten kunna avge flera olika svar på en fråga under samma försök i kunskapstestet.';
$string['configattemptsallowed'] = 'Begränsning av det antal försök som studenter tillåts göra på kunskapstestet.';
$string['configdecimaldigits'] = 'Antal siffror som ska visas efter decimalkommat vid visning av betyg.';
$string['configdecimalplaces'] = 'Det antal siffror som ska användas efter decimaltecknet när betyg för kunskapstestet visas.';
$string['configdecimalplacesquestion'] = 'Det antal siffror som ska användas efter decimaltecknet när betyg för enskilda frågor visas.';
$string['configdelay1'] = 'Om du sätter tidsfördröjning måste studenten vänta den angivna tiden innan den kan utföra ett nytt försök sedan sitt första försök.';
$string['configdelay1st2nd'] = 'Om du anger en tidsfördröjning här kan eleven inte starta sitt andra försök förrän så mycket tid har passerat sedan deras första försök.';
$string['configdelay2'] = 'Om du anger en tidsfördröjning här kan eleven inte starta sitt försök förrän så mycket tid har passerat sedan deras tredje eller senare försök.';
$string['configdelaylater'] = 'Om du anger en tidsfördröjning här kan eleven inte starta sitt tredje, fjärde, ... försök förrän så här mycket tid har gått efter dennes föregående försök.';
$string['configeachattemptbuildsonthelast'] = 'Om flera försök tillåts innehåller varje nytt försök resultatet från det föregående försöket.';
$string['configgrademethod'] = 'Om flera försök tillåts, vilken metod skall användas för att beräkna studentens slutgiltiga betyg för kunskapstestet?';
$string['configintro'] = 'Värdena du anger här definierar de förinställda värdena som används i inställningsformuläret när man skapar ett nytt kunskapstest. Du kan även ange vilka inställningar för kunskapstestet som ska anses som avancerade.';
$string['configmaximumgrade'] = 'Förvald betygsskala som kunskapstestets betygssättning ska använda.';
$string['confignavmethod'] = 'I läget fri navigering kan frågor besvaras i valfri ordning med användning av navigationen. I sekventiell navigering måste frågorna besvaras i en bestämd ordning.';
$string['confignewpageevery'] = 'När du lägger till frågor till kunskapstestet kommer sidbrytning att göras automatiskt enligt de inställningar du gör här.';
$string['configoutcomesadvanced'] = 'Om denna inställning är aktiverad kommer resultat på sidan för inställningar för kunskapstestet att betraktas som avancerade inställningar.';
$string['configpenaltyscheme'] = 'Avdrag gjorda för varje felaktigt svar i anpassande läge';
$string['configpopup'] = 'Tvinga kunskapstest att öppnas i ett popup-fönster och använd JavaScript för att försöka förhindra att kopiera och klistra in används under försöket.';
$string['configrequirepassword'] = 'Studenter måste ange det här lösenordet innan de kan göra det här kunskapstestet.';
$string['configrequiresubnet'] = 'Studenter kan bara göra det här kunskapstestet från dessa datorer.';
$string['configreviewoptions'] = 'Dessa inställningar avgör vilken information användare kan se när de granskar ett försök av ett kunskapstest eller granskar testrapporter.';
$string['configshowblocks'] = 'Visa kursens block under försök.';
$string['configshowuserpicture'] = 'Visa användarbild på skärmen under försök.';
$string['configshufflewithin'] = 'Om du aktiverar detta alternativ, då kommer de delar som bygger upp de enskilda frågorna att blandas om varje gång en student påbörjar ett försök av det här kunskapstestet. Detta under förutsättning att alternativet också är aktiverat i frågeinställningarna.';
$string['configtimelimit'] = 'Standard tidsgräns i minuter för kunskapstest. 0 betyder ingen begränsning.';
$string['configtimelimitsec'] = 'Förvald tidsgräns för kunskapstest i sekunder. 0 betyder ingen gräns.';
$string['configurerandomquestion'] = 'Konfigurera fråga';
$string['confirmclose'] = 'När du väl har skickat in svaren kommer du inte längre att kunna ändra dem.';
$string['confirmremovequestion'] = 'Är du säker på att du vill ta bort {$a}-frågan?';
$string['confirmremovesectionheading'] = 'Är du säker på att du vill ta bort avsnittsrubriken \'{$a}\'?';
$string['confirmserverdelete'] = 'Är Du säker på att Du vill ta bort servern <b>{$a}</b> från listan?';
$string['connectionerror'] = 'Nätverksanslutningen har förlorats. (Autospara misslyckades).

Anteckna de eventuella svar du angivit på den här sidan under de senaste minuterna och försök sedan att ansluta igen.

När anslutningen har återupprättats kommer dina svar sparas och det här meddelandet försvinna.';
$string['connectionok'] = 'Nätverksanslutning återställd. Du kan fortsätta.';
$string['containercategorycreated'] = 'Den här kategorin har skapats för att lagra alla de ursprungliga kategorier som har flyttats till webbplatsnivån p.g.a. de orsaker som anges nedan.';
$string['continueattemptquiz'] = 'Fortsätt med senaste försöket';
$string['continuepreview'] = 'Fortsätt med senaste förhandsgranskningen';
$string['copyingfrom'] = 'Skapar en kopia av frågan \'{$a}\'';
$string['copyingquestion'] = 'Kopierar en fråga';
$string['correct'] = 'Rätt';
$string['correctanswer'] = 'Rätt svar';
$string['correctanswerformula'] = 'Rätt svarsformel';
$string['correctansweris'] = 'Rätt svar: {$a}';
$string['correctanswerlength'] = 'Betydande siffror';
$string['correctanswers'] = 'Rätt svar';
$string['correctanswershows'] = 'Rätt svar visar';
$string['corrresp'] = 'Rätt svar';
$string['countdown'] = 'Nedräkning';
$string['countdownfinished'] = 'Tiden håller på att ta slut. Du bör spara dina svar nu!';
$string['countdowntenminutes'] = 'Tio minuter kvar!';
$string['coursetestmanager'] = '\'Course Test  Manager\'-format';
$string['createcategoryandaddrandomquestion'] = 'Skapa en kategori och lägg till en slumpmässig fråga';
$string['createfirst'] = 'Du måste skapa några kortsvar-frågor först.';
$string['createmultiple'] = 'Skapa flera frågor';
$string['createnewquestion'] = 'Skapa ny fråga';
$string['createquestionandadd'] = 'Skapa en ny fråga och lägg till den till testet.';
$string['custom'] = 'Anpassat format';
$string['dataitemneed'] = 'Du måste lägga till åtminstone en uppsättning datakomponenter för att få till en giltig fråga.';
$string['datasetdefinitions'] = 'Återanvändbara definitioner av dataset för kategorin {$a}';
$string['datasetnumber'] = 'Tal';
$string['daysavailable'] = 'Dagar tillgängligt';
$string['decimaldigits'] = 'Decimalsiffror i betyg';
$string['decimalplaces'] = 'Antal decimaler i betyg';
$string['decimalplaces_help'] = 'Den här inställningen anger antalet siffror som visas efter decimalkommat när betyg visas. Det påverkar bara <em>visningen</em> av betyg, inte de betyg som lagras i databasen eller de interna beräkningarna, som utförs med full noggrannhet.';
$string['decimalplacesquestion'] = 'Antal decimaler i betyg för fråga';
$string['decimalplacesquestion_help'] = 'Denna inställning specificerar det antal siffror som visas efter decimalkommat vid visning av poäng vid varje fråga.';
$string['decimalpoints'] = 'Antal decimaler';
$string['default'] = 'Standard';
$string['defaultgrade'] = 'Standardbetyg';
$string['defaultinfo'] = 'Standardkategori för frågor.';
$string['delay1'] = 'Tidsfördröjning mellan det första och det andra försöket';
$string['delay1st2nd'] = 'Påtvingad fördröjning mellan 1:a och 2:a försöket';
$string['delay1st2nd_help'] = 'Om du ställer in en tidsfördröjning kommer studenterna vara tvungna att vänta så här länge innan de kan göra ett andra försök att genomföra kunskapstestet.';
$string['delay2'] = 'Tidsfördröjning mellan senare försök';
$string['delaylater'] = 'Tvingad tidsfördröjning mellan senare försök';
$string['delaylater_help'] = 'Om du anger en tidsfördröjning här då kommer eleverna att bli tvungna att vänta så länge innan de kan göra förnyade försök att genomföra kunskapstestet.';
$string['deleteattemptcheck'] = 'Är du helt säker på att du vill ta bort de här försöken helt?';
$string['deleteselected'] = 'Ta bort markerade';
$string['deletingquestionattempts'] = 'Tar bort försök på frågor';
$string['description'] = 'Beskrivning';
$string['disabled'] = 'Inaktiverad';
$string['displayoptions'] = 'Visningsalternativ';
$string['donotuseautosave'] = 'Använd inte auto-spara';
$string['download'] = 'Klicka för att ladda ner den exporterade filen för kategorier';
$string['downloadextra'] = '(filen är också lagrad in \'kursens filer\' i katalogen /test)';
$string['dragtoafter'] = 'Efter {$a}';
$string['dragtostart'] = 'Till början';
$string['duplicateresponse'] = 'Den inskickade uppgiftslösningen räknas inte eftersom du har lämnat ett liknande svar tidigare.';
$string['eachattemptbuildsonthelast'] = 'Varje försök bygger på det senaste';
$string['eachattemptbuildsonthelast_help'] = 'Om det är tillåtet att göra flera försök och den här inställningen är satt till \'Ja\' kommer varje försök att innehålla resultaten från det tidigare försöket. Detta gör det möjligt att slutföra provet via ett flera försök. För att visa ett nytt kunskapstest vid varje försök väljer du \'Nej\' i den här inställningen.';
$string['editcategories'] = 'Redigera kategorier';
$string['editcategory'] = 'Redigera kategori';
$string['editcatquestions'] = 'Redigera frågor i kategorin';
$string['editingquestion'] = 'Redigera en fråga';
$string['editingquiz'] = 'Redigerar test';
$string['editingquiz_help'] = 'När du skapar ett kunskapstest, så är de viktigaste begreppen följande:

* Kunskapstestet, med frågor över en eller flera sidor
* Frågebanken, som lagrar kopior av alla frågor indelade i kategorier
* Slumpade frågor - En student får olika frågor varje gång han/hon gör försök på kunskapstestet och olika studenter kan alltså få olika frågor.';
$string['editingquiz_link'] = 'mod/quiz/edit';
$string['editingquizx'] = 'Redigerar kunskapstest: {$a}';
$string['editmaxmark'] = 'Redigera maxpoäng';
$string['editoverride'] = 'Redigera åsidosättande';
$string['editqcats'] = 'Redigera frågekategorier';
$string['editquestion'] = 'Redigera fråga';
$string['editquestions'] = 'Redigera frågor';
$string['editquiz'] = 'Redigera kunskapstest';
$string['editquizquestions'] = 'Redigera frågor för kunskapstest';
$string['emailconfirmautosubmitsmall'] = 'Tack för dina inskickade svar på kunskapstestet \'{$a->quizname}\'';
$string['emailconfirmbody'] = 'Hej {$a->username},

Tack för att du skickat in dina svar för \'{$a->quizname}\' i kursen \'{$a->coursename}\' klockan {$a->submissiontime}.

Detta meddelande bekräftar att dina svar har sparats. Du kan komma åt kunskapstestet här: {$a->quizurl}.';
$string['emailconfirmbodyautosubmit'] = 'Hej {$a->username},

Senaste tidpunkt för att besvara kunskapstestet \'{$a->quizname}\' i kursen \'{$a->coursename}\' passerades. Dina svar skickades in automatiskt klockan {$a->submissiontime}.

Det här meddelandet är en bekräftelse på att dina svar sparades.

Du kan se kunskapstestet här: {$a->quizurl}.';
$string['emailconfirmsmall'] = 'Tack för att du skickat in dina svar för \'{$a->quizname}\'';
$string['emailconfirmsubject'] = 'Bekräftelse på inlämnat kunskapstest: {$a->quizname}';
$string['emailmanualgradedbody'] = 'Hej {$a->studentname},

Dina svar på {$a->quizname} i kursen {$a->coursename} kl. {$a->attempttimefinish} har nu betygsatts.

Du kommer att kunna se din poäng och feedback genom att besöka {$a->quizurl} och granska ditt försök.';
$string['emailmanualgradedsubject'] = 'Ditt försök på kunskapstestet {$a->quizname} har betygsatts';
$string['emailnotifybody'] = 'Hej {$a->username},

{$a->studentname} har slutfört \'{$a->quizname}\' ({$a->quizurl}) i kursen \'{$a->coursename}\'.

Du kan granska försöket här: {$a->quizreviewurl}.';
$string['emailnotifysmall'] = '{$a->studentname} har slutfört {$a->quizname}. Se {$a->quizreviewurl}';
$string['emailnotifysubject'] = '{$a->studentname} har slutfört {$a->quizname}';
$string['emailoverduebody'] = 'Hej {$a->studentname},

Du påbörjade ett försök på \'{$a->quizname}\' i kursen \'{$a->coursename}\', men du skickade inte in det. Det borde ha skickats in senast {$a->attemptduedate}.

Om du fortfarande vill skicka in detta försök, gå till {$a->attemptsummaryurl} och klicka på knappen <em>Skicka in</em>. Du måste göra detta innan {$a->attemptgraceend} annars kommer ditt försök inte att räknas.';
$string['emailoverduesmall'] = 'Du skickade inte in ditt försök på {$a->quizname}. Gå till {$a->attemptsummaryurl} före {$a->attemptgraceend} om du fortfarande vill skicka in försöket.';
$string['emailoverduesubject'] = 'Försöket är nu förfallet: {$a->quizname}';
$string['empty'] = 'Tom';
$string['enabled'] = 'Aktiverad';
$string['endtest'] = 'Slutför test...';
$string['erroraccessingreport'] = 'Du har inte tillgång till den här rapporten';
$string['errorinquestion'] = 'Fel i fråga';
$string['errormissingquestion'] = 'Fel: Systemet saknar frågan med id:  {$a}';
$string['errornotnumbers'] = 'Fel - svar måste vara numeriska';
$string['errorunexpectedevent'] = 'Oväntad kod för händelse {$a->event} återfanns för frågan {$a->questionid} i försöket {$a->attemptid}.';
$string['essay'] = 'Uppsats';
$string['essayquestions'] = 'Uppsatsfrågor';
$string['eventattemptautosaved'] = 'Kunskapstestförsök auto-sparat';
$string['eventattemptdeleted'] = 'Försök borttaget';
$string['eventattemptmanualgradingcomplete'] = 'Manuell betygsättning av försök på kunskapstest slutförd';
$string['eventattemptpreviewstarted'] = 'Förhandsgranskning av försök påbörjad';
$string['eventattemptquestionrestarted'] = 'Kunskapstestförsök-fråga påbörjad på nytt';
$string['eventattemptreviewed'] = 'Försöket granskat';
$string['eventattemptsummaryviewed'] = 'Försökssammanställning visad';
$string['eventattemptupdated'] = 'Kunskapstestförsök uppdaterat';
$string['eventattemptviewed'] = 'Försök visat';
$string['eventeditpageviewed'] = 'Redigeringssida för kunskapstest visad';
$string['eventoverridecreated'] = 'Åsidosättande av kunskapstest skapat';
$string['eventoverridedeleted'] = 'Åsidosättande av kunskapstest borttaget';
$string['eventoverrideupdated'] = 'Åsidosättande av kunskapstest uppdaterat';
$string['eventpagebreakcreated'] = 'Sidbrytning skapad';
$string['eventpagebreakdeleted'] = 'Sidbrytning borttagen';
$string['eventquestionmanuallygraded'] = 'Fråga manuellt bedömnd';
$string['eventquizattemptabandoned'] = 'Försök på kunskapstest övergavs';
$string['eventquizattemptregraded'] = 'Försök på kunskapstest fick nytt betyg';
$string['eventquizattemptstarted'] = 'Försök på kunskapstest påbörjat';
$string['eventquizattemptsubmitted'] = 'Försök på kunskapstest inlämnat';
$string['eventquizattempttimelimitexceeded'] = 'Tidsgränsen för kunskapstestet överskriden';
$string['eventquizgradeupdated'] = 'Betyg för kunskapstest uppdaterat';
$string['eventquizrepaginated'] = 'Sidbrytning uppdaterad för kunskapstest';
$string['eventreportviewed'] = 'Kunskapstestrapport visad';
$string['eventsectionbreakcreated'] = 'Avsnittsbrytning skapad';
$string['eventsectionbreakdeleted'] = 'Avsnittsbrytning borttagen';
$string['eventsectionshuffleupdated'] = 'Avsnittsblandning uppdaterad';
$string['eventsectiontitleupdated'] = 'Avsnittsrubrik uppdaterad';
$string['eventslotcreated'] = 'Frågeplats skapad';
$string['eventslotdeleted'] = 'Frågeplats borttagen';
$string['eventslotmarkupdated'] = 'Frågeplatsbetyg uppdaterat';
$string['eventslotmoved'] = 'Frågeplats flyttad';
$string['eventslotrequirepreviousupdated'] = 'Frågeplats kräver föregående uppdaterad';
$string['everynquestions'] = 'Var {$a}:e fråga';
$string['everyquestion'] = 'Varje fråga';
$string['everythingon'] = 'Allting på';
$string['existingcategory'] = 'Befintlig kategori';
$string['exportcategory'] = 'Exportera kategori';
$string['exporterror'] = 'Ett fel inträffade i samband med genomförande av exporten';
$string['exportingquestions'] = 'Frågorna exporteras till en fil';
$string['exportname'] = 'Namn på fil';
$string['exportquestions'] = 'Exportera frågorna till en fil';
$string['extraattemptrestrictions'] = 'Extra restriktioner för försök';
$string['false'] = 'Falskt';
$string['feedback'] = 'Återkoppling';
$string['feedbackerrorboundaryformat'] = 'Betygsgränserna för återkoppling måste vara angivna antingen i procent eller i form av ett tal. Det värde som Du har angivit inom spannet {$a} är inte giltigt.';
$string['feedbackerrorboundaryoutofrange'] = 'Betygsgränserna för återkoppling måste vara mellan 0% och 100%. Det värde som Du har matat in i spannet {$a} är utanför den begränsningen.';
$string['feedbackerrorjunkinboundary'] = 'Du måste fylla i boxarna för betygsgränserna för återkoppling utan att lämna några tomrum.';
$string['feedbackerrorjunkinfeedback'] = 'Du måste fylla i boxarna för återkoppling utan att lämna några tomrum.';
$string['feedbackerrororder'] = 'Betygsgränserna för återkoppling måste vara i ordning, med den högsta först. Det värde som du matat in i intervallet {$a} följer inte den ordningen.';
$string['file'] = 'Fil';
$string['fileformat'] = 'Filformat';
$string['fillcorrect'] = 'Fyll i med rätt';
$string['filloutnumericalanswer'] = 'Du tillhandahåller åtminstone ett möjligt svar och tolerans. Det första matchande svaret kommer att användas för att bestämma resultatet och återkopplingen. Om du tillhandahåller återkoppling men inget svar på slutet kommer detta att visas för de deltagare vars svar inte matchas av något av de andra svaren.';
$string['filloutoneanswer'] = 'Du måste ange minst ett möjligt svar. Svar som lämnas tomma kommer inte att användas. \'*\' kan användas som jokertecken för att matcha alla tecken. Det första matchande svaret kommer att användas för att bestämma betyget och återkopplingen.';
$string['filloutthreequestions'] = 'Du måste ange minst tre frågor med matchande svar. Du kan ange extra felaktiga svar genom att ange ett svar med en tom fråga. Poster där både frågan och svaret är tomma ignoreras.';
$string['fillouttwochoices'] = 'Du måste fylla i åtminstone två val. Val som lämnas tomma räknas inte.';
$string['finishattemptdots'] = 'Avsluta försök...';
$string['finishreview'] = 'Avsluta granskning';
$string['forceregeneration'] = 'tvinga återskapande';
$string['formatnotfound'] = 'Det gick inte att hitta import-/exportformatet {$a}';
$string['formulaerror'] = 'Formelfel!';
$string['fractionsaddwrong'] = 'Summan av de betyg du valt blir inte 100% utan bara {$a}%.<br/>Vill du gå tillbaka och korrigera den här frågan?';
$string['fractionsnomax'] = 'Ett av svaren bör vara 100% så att det är<br />möjligt att få full poäng på den här frågan.<br />Vill du gå tillbaka och korrigera frågan?';
$string['fromfile'] = 'från fil';
$string['functiondisabledbysecuremode'] = 'Den funktionen är för närvarande inaktiverad';
$string['generalfeedback'] = 'Allmän återkoppling';
$string['generalfeedback_help'] = 'Allmän återkoppling är text som visas efter att en fråga har besvarats. Till skillnad från återkoppling för en specifik fråga vilken beror på avgivet svar, så visas alltid samma allmänna återkoppling oavsett svar.';
$string['gobacktoquiz'] = 'Tillbaka';
$string['graceperiod'] = 'Tidsfrist för inlämning';
$string['graceperiod_desc'] = 'Om det som ska hända <em>När tiden går ut</em> är inställt på <em>"Det finns en tidsfrist..."</em> är detta standardvärdet för den extra tid som tillåts.';
$string['graceperiod_help'] = 'Om det som ska hända <em>När tiden går ut</em> är inställt på <em>"Det finns en tidsfrist..."</em> är detta den extra tid som tillåts.';
$string['graceperiodmin'] = 'Senaste tidsfrist för inlämningar';
$string['graceperiodmin_desc'] = 'Det finns ett potentiellt problem precis i slutet av kunskapstestet. Å ena sidan vill vi låta eleverna fortsätta arbeta ända fram till sista sekunden - med hjälp av timern som automatiskt skickar in kunskapstestet när tiden går ut. Å andra sidan kan servern sedan vara överbelastad, och ta lite tid för att bearbeta svaren. Därför kommer vi att acceptera svar för upp till så här lång efter att provtiden löpt ut så att de inte straffas för att servern är långsam. Men, å andra sidan skulle elever kunna fuska och få så här många sekunder extra tid. Du måste göra en avvägning baserat på hur mycket du litar på prestandan på din server vid kunskapstest.';
$string['graceperiodtoosmall'] = 'Tidsfristen måste vara mer än {$a}.';
$string['gradeall'] = 'Bedöm alla';
$string['gradeaverage'] = 'Medelbetyg';
$string['gradeboundary'] = 'Betygsgräns';
$string['gradeessays'] = 'Betygsätt uppsatser';
$string['gradehighest'] = 'Högsta betyg';
$string['gradeitems'] = 'Betygsobjekt';
$string['grademethod'] = 'Betygsättningsmetod';
$string['grademethod_help'] = 'När flera försök tillåts är följande metoder tillgängliga för att beräkna det slutliga betyget för kunskapstestet:

* Högsta betyg av alla försök
* Medelbetyg (medelvärde) för alla försök
* Första försöket (alla andra försök ignoreras)
* Sista försöket (alla andra försök ignoreras)';
$string['gradesdeleted'] = 'Betyg på kunskapstest har tagits bort';
$string['gradesofar'] = '{$a->method}: {$a->mygrade} / {$a->quizgrade}.';
$string['gradetopassmustbeset'] = 'Betyg för godkänt kan inte vara noll eftersom det här kunskapstestet har ett slutförandevillkor som kräver ett godkänt betyg. Ange ett värde som inte är noll.';
$string['gradetopassoutof'] = 'Betyg för godkänt: {$a->grade} av {$a->maxgrade}';
$string['gradingdetails'] = 'Poäng för detta försök: {$a->raw}/{$a->max}.';
$string['gradingdetailsadjustment'] = 'Med tidigare avdrag ger detta <strong>{$a->cur}/{$a->max}</strong>.';
$string['gradingdetailspenalty'] = 'Det här inlämnade kunskapstestet innehåller ett poängavdrag på {$a}.';
$string['gradingdetailszeropenalty'] = 'Du har inte fått något avdrag på det här inskickade kunskapstestet.';
$string['gradingmethod'] = 'Metod för betygssättning: {$a}';
$string['groupoverrides'] = 'Gruppåsidosättanden';
$string['groupoverridesdeleted'] = 'Gruppåsidosättanden borttagna';
$string['groupsnone'] = 'Det finns inga kurser som du har behörighet till.';
$string['guestsno'] = 'Tyvärr, gäster kan inte se eller göra kunskapstest';
$string['hidebreaks'] = 'Dölj sidbrytningar';
$string['hidereordertool'] = 'Dölj verktyget för ändring av ordningsföljden';
$string['history'] = 'Svarshistorik:';
$string['howquestionsbehave_desc'] = 'Standardinställning för hur frågor beter sig i ett kunskapstest.';
$string['imagedisplay'] = 'Bild att visa';
$string['import_help'] = 'Denna funktion gör att du kan importera frågor från externa textfiler.

Om filen innehåller icke ASCII-tecken måste du använda teckenkodning UTF-8. Var särskilt försiktig med filer som genereras av Microsofts Office program eftersom dessa ofta använder en speciell kodning som inte kommer att hanteras på rätt sätt.

Importformat och exportformat är en möjliga att lägga till och ta bort som pluginmoduler. Andra valfria format kan vara tillgängliga i databasen för moduler och pluginmoduler.';
$string['import_link'] = 'question/import';
$string['importcategory'] = 'importera kategori';
$string['importerror'] = 'Ett fel inträffade i samband med genomförande av importen';
$string['importfilearea'] = 'Importen från filen finns redan i kursfilerna...';
$string['importfileupload'] = 'Import från fil - laddas upp...';
$string['importfromthisfile'] = 'Importera från den här filen';
$string['importingquestions'] = 'Importerar {$a} frågor från fil';
$string['importmax10error'] = 'Det finns ett fel i frågan. Du kan inte ha fler än 10 svar.';
$string['importmaxerror'] = 'Det finns ett fel i frågan. Det finns för många svar.';
$string['importquestions'] = 'Importera frågor från fil';
$string['inactiveoverridehelp'] = '* Den här åsidosättningen är inaktiv eftersom användarens åtkomst till aktiviteten är begränsad. Detta kan bero på att grupp- eller rolltilldelningar, andra åtkomstbegränsningar att eller aktiviteten är dold.';
$string['incorrect'] = 'Felaktigt';
$string['indicator:cognitivedepth'] = 'Test kognitiv';
$string['indicator:cognitivedepth_help'] = 'Denna indikator baseras på det kognitiva djup som uppnåtts av studenten i en Testaktivitet.';
$string['indicator:cognitivedepthdef'] = 'Test kognitiv';
$string['indicator:cognitivedepthdef_help'] = 'Deltagaren har nått denna procentandel av det kognitiva engagemang som erbjuds av Test-aktiviteterna under detta analysintervall (Nivåer = Ingen visning, Visa, Skicka in, Visa återkoppling, Kommentera återkoppling, Skicka in på nytt efter läst återkoppling)';
$string['indicator:cognitivedepthdef_link'] = 'Learning_analytics_indicators#Cognitive_depth';
$string['indicator:socialbreadth'] = 'Test social';
$string['indicator:socialbreadth_help'] = 'Denna indikator baseras på den sociala bredd som uppnåtts av studenten i en Testaktivitet.';
$string['indicator:socialbreadthdef'] = 'Test social';
$string['indicator:socialbreadthdef_help'] = 'Deltagaren har nått denna procentandel av det sociala engagemanget som erbjuds av Testaktiviteterna under detta analysintervall (Nivåer = Inget deltagande, Deltagaren ensamt, Deltagaren tillsammans med andra)';
$string['indicator:socialbreadthdef_link'] = 'Learning_analytics_indicators#Social_breadth';
$string['indivresp'] = 'Svar från elever på respektive fråga';
$string['info'] = 'Info';
$string['infoshort'] = 'i';
$string['initialnumfeedbacks'] = 'Förvalt antal fält för övergripande återkoppling';
$string['initialnumfeedbacks_desc'] = 'Anger hur många tomma feedback-fält som ska visas när du skapar ett nytt kunskapstest. Värdet måste vara minst 1.';
$string['inprogress'] = 'Pågående';
$string['introduction'] = 'Beskrivning';
$string['invalidattemptid'] = 'Det finns inget försök med detta ID';
$string['invalidcategory'] = 'ID för kategori är ogiltigt';
$string['invalidoverrideid'] = 'Ogiltigt id för åsidosättande';
$string['invalidquestionid'] = 'Ogiltigt id för fråga';
$string['invalidquizid'] = 'Ogiltigt kunskapstest-ID';
$string['invalidrandomslot'] = 'Ogiltigt plats-id för slumpmässig fråga.';
$string['invalidsource'] = 'Den här källan är inte godkänd som giltig';
$string['invalidsourcetype'] = 'Ogiltig typ av källa';
$string['invalidstateid'] = 'Ogiltigt id för status';
$string['lastanswer'] = 'Ditt senaste svar var';
$string['layout'] = 'Frågelayout';
$string['layoutasshown'] = 'Sidans layout är som visas.';
$string['layoutasshownwithpages'] = 'Sidans layout är som visas. <small>(Automatiskt en ny sida för var {$a} fråga.)</small>';
$string['layoutshuffledandpaged'] = 'Frågor blandas slumpmässigt med {$a} frågor per sida.';
$string['layoutshuffledsinglepage'] = 'Frågor blandas slumpmässigt, alla på en sida.';
$string['link'] = 'Länk';
$string['listitems'] = 'Listar komponenter i kunskapstestet';
$string['literal'] = 'Egentlig';
$string['loadingquestionsfailed'] = 'Laddning av frågor misslyckades: {$a}';
$string['makecopy'] = 'Spara som ny fråga';
$string['managetypes'] = 'Hantera frågetyper och servrar';
$string['manualgradequestion'] = 'Betygsätt fråga {$a->question} i {$a->quiz} av {$a->user} manuellt.';
$string['manualgrading'] = 'Betygsättning';
$string['mark'] = 'Skicka';
$string['markall'] = 'Skicka sida';
$string['marks'] = 'Poäng';
$string['marks_help'] = 'Den numeriska poängen för varje fråga, och den övergripande poängen för försöket.';
$string['match'] = 'Matchning';
$string['matchanswer'] = 'Matchande svar';
$string['matchanswerno'] = 'Matchar svar {$a}';
$string['max'] = 'Max';
$string['maxmark'] = 'Maxpoäng';
$string['messageprovider:attempt_grading_complete'] = 'Meddelande om att ditt försök har betygsatts';
$string['messageprovider:attempt_overdue'] = 'Varning när ditt testförsök förfaller';
$string['messageprovider:confirmation'] = 'Bekräftelse på dina egna inlämningar av kunskapstest';
$string['messageprovider:submission'] = 'Meddelande om inlämnade kunskapstest';
$string['min'] = 'Min';
$string['minutes'] = 'Minuter';
$string['missingcorrectanswer'] = 'Du måste ange rätt svar';
$string['missingitemtypename'] = 'Namn saknas';
$string['missingquestion'] = 'Denna fråga verkar inte längre existera';
$string['modulename'] = 'Kunskapstest';
$string['modulename_help'] = 'Aktiviteten <em>Kunskapstest</em> gör det möjligt för en lärare att skapa kunskapstester bestående av frågor av olika slag, inklusive flervals, matchning, kortsvar och numeriska.

Läraren kan tillåta att kunskapstestet görs flera gånger, med frågorna blandade eller slumpmässigt utvalda från frågebanken. En tidsgräns kan ställas in.

Varje försök markeras automatiskt, med undantag för uppsatsfrågor och betyget registreras i betygsboken.

Läraren kan välja när och om tips, feedback och korrekta svar visas för eleverna.

Kunskapstester kan användas

* Som kurstentor
* Som minitester efter genomgång av uppgifter eller i slutet av ett ämne
* För att öva på ett ämne med hjälp av frågor från tidigare tentor
* För att leverera omedelbar återkoppling angående prestationen
* För självbedömning';
$string['modulename_link'] = 'mod/quiz/view';
$string['modulenameplural'] = 'Kunskapstester';
$string['moveselectedonpage'] = 'Flytta de valda frågorna till sidan: {$a}';
$string['multichoice'] = 'Flerval';
$string['multipleanswers'] = 'Välj minst ett svar';
$string['mustbesubmittedby'] = 'Det här försöket måste skickas in av {$a}.';
$string['name'] = 'Namn';
$string['navigatenext'] = 'Nästa sida';
$string['navigateprevious'] = 'Föregående sida';
$string['navmethod'] = 'Navigeringsmetod';
$string['navmethod_free'] = 'Fri';
$string['navmethod_help'] = 'När sekventiell navigering är aktiverad måste eleven genomföra kunskapstestet i angiven ordning och kan då inte gå tillbaka till tidigare sidor eller hoppa framåt.';
$string['navmethod_seq'] = 'Sekventiell';
$string['navnojswarning'] = 'OBS! de här länkarna kommer inte att spara dina svar. Använd knappen "Fortsätt" längst ner på sidan.';
$string['neverallononepage'] = 'Aldrig, alla frågor på en sida';
$string['newattemptfail'] = 'Fel: Det gick inte att påbörja ett nytt försök av kunskapstestet';
$string['newcategory'] = 'Ny kategori';
$string['newpage'] = 'Ny sida';
$string['newpage_help'] = 'För längre kunskapstest är det lämpligt att låta kunskapstestet sträcka sig över flera sidor genom att begränsa antalet frågor per sida. När du lägger till frågor i kunskapstestet kommer sidbrytningar automatiskt att infogas enligt den här inställningen. Sidbrytningar kan dock senare flyttas manuellt på redigeringssidan.';
$string['newpageevery'] = 'Starta en ny sida automatiskt';
$string['newsectionheading'] = 'Ny rubrik';
$string['noanswers'] = 'Du valde inga svar!';
$string['noattempts'] = 'Inga försök har gjorts på detta kunskapstest';
$string['noattemptsfound'] = 'Inga försök funna.';
$string['noattemptstoshow'] = 'Det finns inga försök att visa';
$string['nocategory'] = 'En felaktig kategori, eller ingen kategori har angivits';
$string['noclose'] = 'Inget slutdatum';
$string['nocommentsyet'] = 'Inga kommentarer ännu.';
$string['noconnection'] = 'Det finns för närvarande ingen uppkoppling till en webbtjänst som kan bearbeta denna fråga. Kontakta administratören.';
$string['nodataset'] = 'ingenting - detta är inte ett wild card';
$string['nodatasubmitted'] = 'Ingen data skickades in.';
$string['noessayquestionsfound'] = 'Det gick inte att hitta några manuellt betygssatta frågor';
$string['nogradewarning'] = 'Detta kunskapstest är inte betygssatt så du kan inte sätta övergripande återkoppling som skiljer sig genom betyget.';
$string['nomoreattempts'] = 'Inga fler försök tillåtna';
$string['none'] = 'Ingen';
$string['noopen'] = 'Inget startdatum';
$string['nooverridedata'] = 'Du måste åsidosätta åtminstone en av inställningarna i kunskapstestet.';
$string['nopossibledatasets'] = 'Inga möjliga datauppsättningar';
$string['noquestionintext'] = 'Frågetexten innehåller inte några inbäddade frågor';
$string['noquestions'] = 'Inga frågor har lagts till ännu';
$string['noquestionsfound'] = 'Det gick inte att hitta några frågor';
$string['noquestionsinquiz'] = 'Det finns inga frågor i det här kunskapstestet.';
$string['noquestionsnotinuse'] = 'Denna slumpmässiga fråga används inte eftersom dess kategori är tom.';
$string['noquestionsonpage'] = 'Tom sida';
$string['noresponse'] = 'Inget svar';
$string['noreview'] = 'Du får inte granska detta kunskapstest';
$string['noreviewattempt'] = 'Du har inte behörighet att granska det här försöket.';
$string['noreviewshort'] = 'Ej tillåten';
$string['noreviewuntil'] = 'Du får inte granska detta kunskapstest förrän {$a}';
$string['noreviewuntilshort'] = 'Tillgänglig {$a}';
$string['noscript'] = 'JavaScript måste vara aktiverat om du vill fortsätta!';
$string['notavailabletostudents'] = 'OBS! Detta kunskapstest är inte tillgängligt för dina elever';
$string['notenoughrandomquestions'] = 'Det finns inte tillräckligt många frågor i kategorin {$a->category} för att skapa frågan {$a->name} ({$a->id}).';
$string['notenoughsubquestions'] = 'Otillräckligt antal delfrågor!<br />
Vill du gå tillbaka och rätta till den här frågan?';
$string['notifyattemptsgradedtask'] = 'Skicka aviseringar om kunskapstest-försök där betygsättningen nu är slutförd';
$string['notimedependentitems'] = 'Tidsberoende objekt stöds för närvarande inte av kunskapstestmodulen. Som en work-around, ställ in en tidsgräns för hela kunskapstestet. Vill du välja ett annat objekt (eller använda det aktuella objektet ändå)?';
$string['notyetgraded'] = 'Ännu ej betygsatt';
$string['notyetviewed'] = 'Ännu ej visad';
$string['notyourattempt'] = 'Detta är inte ditt försök!';
$string['noview'] = 'Användare som är inloggade får inte se det här kunskapstestet';
$string['numattempts'] = '{$a->studentnum} {$a->studentstring} har genomfört {$a->attemptnum} försök';
$string['numberabbr'] = '#';
$string['numerical'] = 'Numerisk';
$string['numquestionsx'] = 'Frågor: {$a}';
$string['oneminute'] = '1 minut';
$string['onlyteachersexport'] = 'Endast lärare kan exportera frågor';
$string['onlyteachersimport'] = 'Endast lärare med behörighet att redigera kan importera frågor';
$string['onthispage'] = 'Denna sida';
$string['open'] = 'Inte besvarad';
$string['openafterclose'] = 'Kunde inte uppdatera kunskapstestet. Du har angivit ett startdatum som infaller efter stängningsdatum.';
$string['openclosedatesupdated'] = 'Datum för att öppna och stänga kunskapstestet har uppdaterats';
$string['optional'] = 'valfritt';
$string['orderandpaging'] = 'Ordningsföljd och sidindelning';
$string['orderandpaging_help'] = 'Siffrorna 10, 20, 30, ... motstående varje fråga indikerar ordningen på frågorna. Numreringen ökar med steg om 10 för att lämna utrymme för tillkommande frågor att kunna infogas. För att ändra ordningsföljden för frågorna, ändra på numreringen och klicka sedan på knappen "Gör om ordningsföljden på frågorna".';
$string['orderingquiz'] = 'Ordningsföljd och sidindelning';
$string['orderingquizx'] = 'Ordningsföljd och sidindelning: {$a}';
$string['outcomesadvanced'] = 'Resultat är avancerade inställningar';
$string['outof'] = '{$a->grade} av {$a->maxgrade}';
$string['outofpercent'] = '{$a->grade} av {$a->maxgrade} ({$a->percent}%)';
$string['outofshort'] = '{$a->grade}/{$a->maxgrade}';
$string['overallfeedback'] = 'Övergripande återkoppling';
$string['overallfeedback_help'] = 'Övergripande återkoppling är text som visas efter att ett kunskapstest har försökts. Genom att ange specifika poänggränser (som procenttal eller som antal), kan texten bero på den poäng som uppnåtts.';
$string['overdue'] = 'Försenat';
$string['overduehandling'] = 'När tiden går ut';
$string['overduehandling_desc'] = 'Standard för vad som ska hända om en elev inte skickar in kunskapstestet innan tiden går ut.';
$string['overduehandling_help'] = 'Denna inställning kontrollerar vad som händer om en elev misslyckas med att skicka in sitt försök på ett kunskapstest innan tiden går ut. Om eleven aktivt arbetar i kunskapstestet när tiden går ut kommer timern för nedräkning alltid att automatiskt skicka in försöket, men om eleven har loggat ut kommer denna inställning avgöra vad som händer.';
$string['overduehandling_link'] = 'mod/quiz/timing';
$string['overduehandlingautoabandon'] = 'Försök måste skickas in innan tiden går ut, annars räknas de inte';
$string['overduehandlingautosubmit'] = 'Pågående försök skickas in automatiskt';
$string['overduehandlinggraceperiod'] = 'Det finns en tidsfrist när pågående försök kan skickas in, men inga fler frågor besvaras';
$string['overduemustbesubmittedby'] = 'Detta försök är nu försenat. Det borde redan ha lämnats in. Om du vill att det här kunskapstestet ska bedömas måste du skicka in det senast {$a}. Om du inte skickar in det då kommer inga poäng från detta försök att räknas.';
$string['override'] = 'Åsidosätt';
$string['overridedeletegroupsure'] = 'Är du säker på att du vill ta bort åsidosättandet för gruppen {$a}?';
$string['overridedeleteusersure'] = 'Är du säker på att du vill ta bort åsidosättandet för användaren {$a}?';
$string['overridegroup'] = 'Åsidosätt grupp';
$string['overridegroupeventname'] = '{$a->quiz} - {$a->group}';
$string['overrides'] = 'Åsidosättanden';
$string['overridesforquiz'] = 'Åsidosatta inställningar: {$a}';
$string['overridesnoneforgroups'] = 'Inga gruppåsidosättanden har skapats för detta kunskapstest.';
$string['overridesnoneforusers'] = 'Inga användaråsidosättanden har skapats för detta kunskapstest.';
$string['overridessummary'] = 'Åsidosättanden av inställningar finns ({$a})';
$string['overridessummarygroup'] = 'Grupper: {$a}';
$string['overridessummarythisgroup'] = 'Åsidosättanden av inställningar finns ({$a}) För denna grupp.';
$string['overridessummaryuser'] = 'Användare: {$a}';
$string['overridessummaryyourgroups'] = 'Åsidosättanden av inställningar finns ({$a}) för dina grupper';
$string['overrideuser'] = 'Åsidosätt användare';
$string['overrideusereventname'] = '{$a->quiz} - Åsidosättande';
$string['page-mod-quiz-attempt'] = 'Försökssida';
$string['page-mod-quiz-edit'] = 'Redigera testsida';
$string['page-mod-quiz-report'] = 'Valfri rapportsida för kunskapstest';
$string['page-mod-quiz-review'] = 'Granskningssida för kunskapstest';
$string['page-mod-quiz-summary'] = 'Sida över försökssammanfattning för kunskapstest';
$string['page-mod-quiz-view'] = 'Informationssida för kunskapstest';
$string['page-mod-quiz-x'] = 'Godtycklig sida för kunskapstest';
$string['pageshort'] = 's';
$string['pagesize'] = 'Sidstorlek';
$string['parent'] = 'Överliggande';
$string['parentcategory'] = 'Överliggande kategori';
$string['parsingquestions'] = 'Läser frågor från importfil.';
$string['partiallycorrect'] = 'Delvis rätt';
$string['penalty'] = 'Avdrag';
$string['penaltyscheme'] = 'Tillämpa avdrag';
$string['penaltyscheme_help'] = 'Om detta är aktiverat subtraheras ett straff från det slutliga betyget för en fråga för ett felaktigt svar. Straffstorleken anges i frågeinställningarna. Den här inställningen gäller bara om adaptivt läge är aktiverat.';
$string['percentcorrect'] = 'Procent rätt';
$string['pleaseclose'] = 'Din förfrågan har bearbetats. Du kan stänga det här fönstret nu.';
$string['pluginadministration'] = 'Hantera kunskapstest';
$string['pluginname'] = 'Kunskapstest';
$string['popup'] = 'Visa kunskapstest i ett "säkert" fönster';
$string['popupblockerwarning'] = 'Den här delen av kunskapstestet körs i säkert läge. Det innebär att du måste genomföra testet i ett säkert fönster. Vänligen stäng av din popup-blockerare.';
$string['popupnotice'] = 'Studenter kommer att få se detta kunskapstest i ett säkert fönster.';
$string['preprocesserror'] = 'Fel inträffade under förbearbetningen!';
$string['preview'] = 'Förhandsgranska';
$string['previewquestion'] = 'Förhandsgranska fråga';
$string['previewquiz'] = 'Förhandsgranska {$a}';
$string['previewquiznow'] = 'Förhandsgranska kunskapstest';
$string['previewquizstart'] = 'Förhandsgranska kunskapstest';
$string['previous'] = 'Tidigare status';
$string['privacy:metadata:core_question'] = 'Aktiviteten Kunskapstest lagrar information om frågeanvändning i core_question delsystemet.';
$string['privacy:metadata:quiz'] = 'Aktiviteten Kunskapstest använder kunskapstestrapporter.';
$string['privacy:metadata:quiz_attempts'] = 'Detaljer för varje försök av ett kunskapstest.';
$string['privacy:metadata:quiz_attempts:attempt'] = 'Försöksnumret.';
$string['privacy:metadata:quiz_attempts:currentpage'] = 'Sidan som användaren för närvarande är på.';
$string['privacy:metadata:quiz_attempts:gradednotificationsenttime'] = 'Tidpunkt då användaren meddelades att den manuella betygsättningen av deras försök slutfördes';
$string['privacy:metadata:quiz_attempts:preview'] = 'Huruvida detta är en förhandsgranskning av ett kunskapstest.';
$string['privacy:metadata:quiz_attempts:state'] = 'Aktuellt tillstånd för kunskapstestet.';
$string['privacy:metadata:quiz_attempts:sumgrades'] = 'Betygssumman i försöket.';
$string['privacy:metadata:quiz_attempts:timecheckstate'] = 'Tidpunkt då tillståndet senast kontrollerades.';
$string['privacy:metadata:quiz_attempts:timefinish'] = 'Tidpunkt då kunskapstestet slutfördes.';
$string['privacy:metadata:quiz_attempts:timemodified'] = 'Tidpunkt då försöket uppdaterades.';
$string['privacy:metadata:quiz_attempts:timemodifiedoffline'] = 'Tidpunkt då försöket uppdaterades via en off-line uppdatering.';
$string['privacy:metadata:quiz_attempts:timestart'] = 'Tidpunkt då försöket påbörjades.';
$string['privacy:metadata:quiz_grades'] = 'Detaljer för det övergripande betyget för detta kunskapstest.';
$string['privacy:metadata:quiz_grades:grade'] = 'Det övergripande betyget för kunskapstestet.';
$string['privacy:metadata:quiz_grades:quiz'] = 'Kunskapstestet betygsattes.';
$string['privacy:metadata:quiz_grades:timemodified'] = 'Tidpunkt då betyget ändrades.';
$string['privacy:metadata:quiz_grades:userid'] = 'Användaren som betygsattes.';
$string['privacy:metadata:quiz_overrides'] = 'Detaljer för åsidosättanden för detta kunskapstest.';
$string['privacy:metadata:quiz_overrides:quiz'] = 'Kunskapstestet med information om åsidosättanden.';
$string['privacy:metadata:quiz_overrides:timeclose'] = 'Den nya sluttiden för kunskapstestet.';
$string['privacy:metadata:quiz_overrides:timelimit'] = 'Den nya tidsbegränsningen för kunskapstestet.';
$string['privacy:metadata:quiz_overrides:timeopen'] = 'Den nya starttiden för kunskapstestet.';
$string['privacy:metadata:quiz_overrides:userid'] = 'Användaren som åsidosätts';
$string['privacy:metadata:quizaccess'] = 'Aktiviteten Kunskapstest använder sig av kunskapstest-åtkomstbegränsningar.';
$string['publish'] = 'Publicera';
$string['publishedit'] = 'Du måste ha behörighet i den publicerande kursen för att få lägga till eller redigera frågor i den här kategorin';
$string['qbrief'] = 'F. {$a}';
$string['qname'] = 'namn';
$string['qti'] = 'IMS QTI format';
$string['qtypename'] = 'typ, namn';
$string['question'] = 'Fråga';
$string['questionbank'] = 'från frågebanken';
$string['questionbankmanagement'] = 'Hantera frågebank';
$string['questionbehaviour'] = 'Frågebeteende';
$string['questioncats'] = 'Frågekategorier';
$string['questiondeleted'] = 'Den här frågan har tagits bort. Vänligen kontakta din lärare.';
$string['questiondependencyadd'] = 'Ingen begränsning för när fråga {$a->thisq} får besvaras. Klicka för att ändra';
$string['questiondependencyfree'] = 'Inga begränsningar för denna fråga';
$string['questiondependencyremove'] = 'Fråga {$a->thisq} får inte besvaras innan föregående fråga {$a->previousq} besvarats •  Klicka för att ändra';
$string['questiondependsonprevious'] = 'Denna fråga får inte besvaras innan föregående fråga besvarats.';
$string['questioninuse'] = 'För närvarande används frågan \'{$a}\' :';
$string['questionmissing'] = 'Frågan för den här sessionen saknas';
$string['questionname'] = 'Namn';
$string['questionnonav'] = '<span class="accesshide">Fråga </span>{$a->number}<span class="accesshide"> {$a->attributes}</span>';
$string['questionnonavinfo'] = '<span class="accesshide">Information </span>{$a->number}<span class="accesshide"> {$a->attributes}</span>';
$string['questionnotloaded'] = 'Frågan {$a} har inte laddats från databasen';
$string['questionorder'] = 'Frågeordning';
$string['questionposition'] = 'Ny position i ordningen för fråga {$a}';
$string['questions'] = 'Frågor';
$string['questionsetpreview'] = 'Förhandsgranskning av frågeuppsättning';
$string['questionsinclhidden'] = 'Frågor (inklusive dolda)';
$string['questionsinthisquiz'] = 'Frågor i det här kunskapstestet';
$string['questionsmatchingfilter'] = 'Frågor som matchar detta filter: {$a}';
$string['questionsperpage'] = 'Frågor per sida';
$string['questionsperpageselected'] = 'Antal frågor per sida har satts så att sidindelningen för närvarande är fast. Som resultat av detta har kontrollen för sidindelning inaktiverats. Du kan ändra detta på {$a}.';
$string['questionsperpagex'] = 'Frågor per sida: {$a}';
$string['questiontext'] = 'Frågetext';
$string['questiontextisempty'] = '[tom frågetext]';
$string['questiontype'] = 'Frågetyp {$a}';
$string['questiontypesetupoptions'] = 'Inställningsalternativ för frågetyper:';
$string['questionversion'] = 'v{$a}';
$string['questionversionlatest'] = 'v{$a} (senaste)';
$string['quiz:addinstance'] = 'Nytt kunskapstest';
$string['quiz:attempt'] = 'Försök att genomföra kunskapstestet';
$string['quiz:deleteattempts'] = 'Ta bort försök att genomföra kunskapstestet';
$string['quiz:emailconfirmsubmission'] = 'Få bekräftelse vid inlämnande av egna kunskapstest';
$string['quiz:emailnotifyattemptgraded'] = 'Få meddelande när ditt försök har betygsatts';
$string['quiz:emailnotifysubmission'] = 'Få bekräftelse vid dina elevers inlämnande av kunskapstester';
$string['quiz:emailwarnoverdue'] = 'Få ett meddelande när inlämningstiden för ett kunskapstest passeras';
$string['quiz:grade'] = 'Betygssätt kunskapstestet manuellt';
$string['quiz:ignoretimelimits'] = 'Ta inte hänsyn till tidsbegränsningar på kunskapstestet';
$string['quiz:manage'] = 'Hantera kunskapstester';
$string['quiz:manageoverrides'] = 'Hantera åsidosättande av kunskapstest';
$string['quiz:preview'] = 'Förhandsgranska kunskapstest';
$string['quiz:regrade'] = 'Gör om betygsättning på försök';
$string['quiz:reviewmyattempts'] = 'Granska dina försök';
$string['quiz:view'] = 'Visa information om kunskapstest';
$string['quiz:viewoverrides'] = 'Visa åsidosättanden för kunskapstest';
$string['quiz:viewreports'] = 'Visa kunskapstestrapporter';
$string['quizavailable'] = 'Detta kunskapstest är tillgängligt till: {$a}';
$string['quizclose'] = 'Stäng kunskapstestet';
$string['quizclosed'] = 'Detta kunskapstest stängdes {$a}';
$string['quizcloses'] = 'Kunskapstestet stängs';
$string['quizcloseson'] = 'Kunskapstestet kommer att stängas {$a}';
$string['quizeventcloses'] = '{$a} stänger';
$string['quizeventopens'] = '{$a} öppnar';
$string['quizisclosed'] = 'Det här kunskapstestet är stängt';
$string['quizisclosedwillopen'] = 'Kunskapstestet stängt (öppnas {$a})';
$string['quizisopen'] = 'Det här kunskapstestet är öppet';
$string['quizisopenwillclose'] = 'Kunskapstestet är öppet (stängs {$a})';
$string['quiznavigation'] = 'Navigering i kunskapstest';
$string['quizopen'] = 'Öppna kunskapstestet';
$string['quizopenclose'] = 'Öppnings- och stängningsdatum';
$string['quizopenclose_help'] = 'Elever kan endast starta sina försök efter öppningstiden och de måste fullfölja in sina försök före stängningstiden.';
$string['quizopenclose_link'] = 'mod/quiz/timing';
$string['quizopened'] = 'Det här kunskapstestet är öppet';
$string['quizopenedon'] = 'Det här kunskapstestet öppnades {$a}';
$string['quizopens'] = 'Kunskapstestet öppnas';
$string['quizopenwillclose'] = 'Det här kunskapstestet är öppet, kommer att stängas {$a}';
$string['quizordernotrandom'] = 'Ordningsföljden i kunskapstestet är inte blandad';
$string['quizorderrandom'] = '* Ordningsföljden i kunskapstestet är omblandad';
$string['quizreport'] = 'Kunskapstestrapport';
$string['quizsettings'] = 'Inställningar för kunskapstest';
$string['quiztimer'] = 'Kunskapstest-timer';
$string['quizwillopen'] = 'Det här kunskapstestet kommer att öppnas {$a}';
$string['random'] = 'Slumpmässig fråga';
$string['randomcreate'] = 'Skapa slumpmässiga frågor';
$string['randomediting'] = 'Redigerar slumpmässig fråga';
$string['randomfromcategory'] = 'Slumpmässig fråga från kategori:';
$string['randomfromexistingcategory'] = 'Slumpmässig fråga från befintlig kategori:';
$string['randomfromunavailabletag'] = '{$a} (otillgänglig)';
$string['randomnosubcat'] = 'Endast frågor från denna kategori, inte från dess underkategorier';
$string['randomnumber'] = 'Antal slumpmässiga frågor';
$string['randomquestion'] = 'Slumpmässig fråga';
$string['randomquestion_help'] = 'En slumpmässig fråga är ett sätt att infoga en slumpmässigt vald fråga från en angiven kategori eller med en angiven etikett i en aktivitet.';
$string['randomquestiontags'] = 'Etiketter';
$string['randomquestiontags_help'] = 'Du kan begränsa urvalskriterierna ytterligare genom att ange några frågeetiketter här. De "slumpmässiga" frågorna kommer att väljas bland de frågor som har alla dessa etiketter.';
$string['randomquestionusinganewcategory'] = 'Slumpad fråga under användning av en ny kategori';
$string['randomwithsubcat'] = 'Frågor från denna kategori och dess underkategorier';
$string['readytosend'] = 'Du är på väg att skicka hela ditt kunskapstest för betygsättning. Är du säker på att du vill fortsätta?';
$string['reattemptquiz'] = 'Gör om kunskapstestet';
$string['recentlyaddedquestion'] = 'Nyligen tillagd fråga!';
$string['recurse'] = 'Inkludera frågor från underkategorier';
$string['redoesofthisquestion'] = 'Övriga frågor som besvarats: {$a}';
$string['redoquestion'] = 'Försök med en annan fråga som den här';
$string['regrade'] = 'Gör om betygsättning för alla försök';
$string['regradecomplete'] = 'Alla försök har betygsatts på nytt';
$string['regradecount'] = '{$a->changed} av {$a->attempt} betyg ändrades';
$string['regradedisplayexplanation'] = 'Försök som ändras i samband med förnyad betygssättning visas som länkar till fönstret för förnyad visning av fråga.';
$string['regradenotallowed'] = 'Du har inte behörighet att göra om betygssättningen för det här kunskapstestet';
$string['regradingquestion'] = 'Förnyad betygssättning av  "{$a}"';
$string['regradingquiz'] = 'Förnyad betygssättning av kunskapstest "{$a}"';
$string['remove'] = 'Ta bort';
$string['removeallgroupoverrides'] = 'Ta bort alla gruppåsidosättanden';
$string['removeallquizattempts'] = 'Ta bort alla försök på kunskapstestet';
$string['removealluseroverrides'] = 'Ta bort alla användaråsidosättanden';
$string['removeemptypage'] = 'Ta bort tom sida';
$string['removepagebreak'] = 'Ta bort sidbrytning';
$string['removeselected'] = 'Ta bort markerade';
$string['rename'] = 'Ändra namn';
$string['renderingserverconnectfailed'] = 'Servern {$a} misslyckades med att bearbeta ett RQP anrop. Kontrollera att URLen är korrekt.';
$string['reorderquestions'] = 'Ändra ordningsföljden på frågorna';
$string['reordertool'] = 'Visa verktyget för ändring av ordningsföljden';
$string['repaginate'] = 'Sidbryt med {$a} frågor per sida';
$string['repaginatecommand'] = 'Ny sidindelning';
$string['repaginatenow'] = 'Gör om sidindelningen nu';
$string['replace'] = 'Byt ut';
$string['replacementoptions'] = 'Ersättningsalternativ';
$string['report'] = 'Rapporter';
$string['reportanalysis'] = 'Komponentanalys';
$string['reportattemptsfrom'] = 'Försök från';
$string['reportattemptsthatare'] = 'Försök som är';
$string['reportdisplayoptions'] = 'Visa alternativ';
$string['reportfullstat'] = 'Detaljerad statistik';
$string['reportmulti_percent'] = 'Flera procent';
$string['reportmulti_q_x_student'] = 'Flerfaldiga val av studenter';
$string['reportmulti_resp'] = 'Individuella svar';
$string['reportmustselectstate'] = 'Du måste välja åtminstone ett tillstånd.';
$string['reportnotfound'] = 'Rapporten är okänd ({$a})';
$string['reportoverview'] = 'Översikt';
$string['reportregrade'] = 'Ny betygsättning för försök';
$string['reportresponses'] = 'Svarsdetaljer';
$string['reports'] = 'Rapporter';
$string['reportshowonly'] = 'Visa endast försök';
$string['reportshowonlyfinished'] = 'Visa högst ett genomfört försök per användare ({$a})';
$string['reportsimplestat'] = 'Enkel statistik';
$string['reportusersall'] = 'alla användare som har försökt kunskapstestet';
$string['reportuserswith'] = 'registrerade användare som har försökt kunskapstestet';
$string['reportuserswithorwithout'] = 'registrerade användare som har. eller inte har, försökt kunskapstestet';
$string['reportuserswithout'] = 'registrerade användare som inte har försökt kunskapstestet';
$string['reportwhattoinclude'] = 'Vad som inkluderas i rapporten';
$string['requirepassword'] = 'Kräv lösenord';
$string['requirepassword_help'] = 'Om ett lösenord anges måste en deltagare ange det för att kunna göra kunskapstestet.';
$string['requiresubnet'] = 'Kräv en nätverksadress';
$string['requiresubnet_help'] = '<p>Det h&auml;r f&auml;ltet &auml;r valfritt.</p>
<p>Du kan begr&auml;nsa tillg&aring;ngen till ett test till specifika undern&auml;t
p&aring; ett LAN eller p&aring; Internet genom att ange en kommaseparerad lista med
delar av, eller hela numren f&ouml;r IP-adresser.</p>
<p>Det h&auml;r &auml;r speciellt anv&auml;ndbart n&auml;r det g&auml;ller test d&auml;r Du vill vara s&auml;ker p&aring; att
bara m&auml;nniskor i ett specifikt rum ska ha tillg&aring;ng till testet.</p>
<p>Till exempel:  <b>192.168. , 231.54.211.0/20, 231.3.56.211</b></p>
<p>Det finns tre typer av nummer som Du kan anv&auml;nda (Du kan inte anv&auml;nda
textbaserade dom&auml;nnamnm som exempel.se):</p>
<ol>
<li>Kompletta IP-adresser, s&aring;som <b>192.168.10.1</b> som kommer att kopplas till en enskild dator
(eller proxy).</li>
<li>Delar av adresser, s&aring;som <b>192.168</b> som kommer att kopplas till allt som inleds med dessa siffror.</li>
<li>CIDR notation,  s&aring;som <b>231.54.211.0/20</b> som g&ouml;r det m&ouml;jligt att ange mer detaljerade undern&auml;t.</li>
</ol>
<p>Mellanslag g&ouml;r ingen skillnad.</p>';
$string['response'] = 'Svar';
$string['responses'] = 'Svar';
$string['results'] = 'Resultat';
$string['returnattempt'] = 'Återgå till försök';
$string['reuseifpossible'] = 'Återanvänd en tidigare borttagen';
$string['reverttodefaults'] = 'Återställ standardinställningar för kunskapstestet';
$string['review'] = 'Granska';
$string['reviewafter'] = 'Senare, medan kunskapstestet fortfarande är öppet';
$string['reviewalways'] = 'Tillåt granskning när som helst';
$string['reviewattempt'] = 'Granska försök';
$string['reviewbefore'] = 'Tillåt granskning medan kunskapstestet är öppet';
$string['reviewclosed'] = 'Efter att kunskapstestet stängts';
$string['reviewduring'] = 'Under försöket';
$string['reviewimmediately'] = 'Omedelbart efter genomförandet';
$string['reviewnever'] = 'Tillåt aldrig granskning';
$string['reviewofquestion'] = 'Granskning av frågan {$a->question} i {$a->quiz} av {$a->användare}';
$string['reviewopen'] = 'Senare, medan kunskapstestet fortfarande är öppet';
$string['reviewoptions'] = 'Studenter kan granska';
$string['reviewoptionsheading'] = 'Granskningsalternativ';
$string['reviewoptionsheading_help'] = 'Dessa inställningar kontrollerar vilken information eleven kan se när de granskar sitt försök eller tittar på kunskapstestrapporten.

**Under försöket** är inställningar som endast är relevant för visst beteende, som "interaktiv med multipla försök", som kan visa återkoppling under försöket.

**Direkt efter försöket** är inställningar som gäller för de första två minuterna efter att eleven klickat på knappen "Skicka in allt och avsluta".

**Senare, medan kunskapstestet fortfarande är öppet** är inställningar som gäller efter att kunskapstestet är genomfört men innan stängningsdatum har passerat.

** Efter det att kunskapstestet är avslutat ** är inställningar som gäller efter att kunskapstestets stängningsdatum har passerats. Om kunskapstestet inte har en stängningsdatum  uppnås detta tillstånd aldrig.';
$string['reviewoverallfeedback'] = 'Övergripande återkoppling';
$string['reviewoverallfeedback_help'] = 'Återkopplingen som ges vid slutet av ett försök, beroende på elevens totala poäng.';
$string['reviewresponse'] = 'Granska respons';
$string['reviewresponsetoq'] = 'Granska svar (fråga {$a})';
$string['reviewthisattempt'] = 'Granska dina svar i det här försöket';
$string['rqp'] = 'Extern fråga';
$string['rqps'] = 'Externa frågor';
$string['sameasoverall'] = 'Samma som för övergripande betyg';
$string['save'] = 'Spara';
$string['saveandedit'] = 'Spara ändringar och redigera frågor';
$string['saveattemptfailed'] = 'Det gick inte att spara det aktuella försöket på kunskapstestet';
$string['savedfromdeletedcourse'] = 'Sparad från den borttagna kursen "{$a}"';
$string['savegrades'] = 'Spara betyg';
$string['savemyanswers'] = 'Spara mina svar';
$string['savenosubmit'] = 'Spara utan att skicka in kunskapstestet';
$string['saveoverrideandstay'] = 'Spara och mata in ytterligare ett åsidosättande';
$string['savequiz'] = 'Spara hela detta kunskapstest';
$string['saving'] = 'Sparar';
$string['savingnewgradeforquestion'] = 'Sparar ny poäng för fråga med id {$a}.';
$string['savingnewmaximumgrade'] = 'Sparar ny maximal poäng.';
$string['score'] = 'Rena poäng';
$string['scores'] = 'Poäng';
$string['search:activity'] = 'Kunskapstest - aktivitetsinformation';
$string['sectionheadingedit'] = 'Redigera rubrik \'{$a}\'';
$string['sectionheadingremove'] = 'Ta bort rubriken \'{$a}\'';
$string['sectionnoname'] = 'Namnlöst avsnitt';
$string['seequestions'] = '(Se frågor)';
$string['select'] = 'Välj';
$string['selectall'] = 'Välj alla';
$string['selectattempt'] = 'Välj försök';
$string['selectcategory'] = 'Välj kategori';
$string['selectedattempts'] = 'Valda försök...';
$string['selectmultipleitems'] = 'Välj flera frågor';
$string['selectmultipletoolbar'] = 'Välj flera-verktygsrad';
$string['selectnone'] = 'Avmarkera alla';
$string['selectquestiontype'] = '-- Välj frågetyp --';
$string['serveradded'] = 'En server har lagts till';
$string['serveridentifier'] = 'Identifierare';
$string['serverinfo'] = 'Information om server';
$string['servers'] = 'Servrar';
$string['serverurl'] = 'URL till server';
$string['shortanswer'] = 'Kortsvar';
$string['show'] = 'Visa';
$string['showall'] = 'Visa alla frågor på en sida';
$string['showblocks'] = 'Visa block under försök';
$string['showblocks_help'] = 'Om satt till ja kommer normala block att visas under försök av kunskapstestet';
$string['showbreaks'] = 'Visa sidbrytningar';
$string['showcategorycontents'] = 'Visa innehåll i kategori {$a->arrow}';
$string['showcorrectanswer'] = 'Visa rätta svaren i återkopplingen?';
$string['showdetailedmarks'] = 'Visa poänginformation';
$string['showeachpage'] = 'Visa en sida i taget';
$string['showfeedback'] = 'Vill du visa återkoppling efter det att frågorna är besvarade?';
$string['showinsecurepopup'] = 'Öppna kunskapstestet i ett "säkert" fönster';
$string['showlargeimage'] = 'Stor bild';
$string['shownoattempts'] = 'Visa de studenter som inte har gjort några försök';
$string['shownoattemptsonly'] = 'Visa bara studenter som inte har gjort några försök';
$string['shownoimage'] = 'Ingen bild';
$string['showreport'] = 'Visa rapport';
$string['showsmallimage'] = 'Liten bild';
$string['showteacherattempts'] = 'Visa de försök som lärare har gjort';
$string['showuserpicture'] = 'Visa användarens bild';
$string['showuserpicture_help'] = 'Om aktiverat kommer elevens namn och bild visas på skärmen under försöket, och på översiktsvyn, vilket gör det enklare att kontrollera att eleven har loggat in som sig själv i ett övervakat kunskapstest.';
$string['shuffle'] = 'Blanda';
$string['shuffleanswers'] = 'Svarsalternativen ska visas i slumpmässig ordning';
$string['shuffledrandomly'] = 'Slumpmässigt ändrad ordningsföljd';
$string['shufflequestions'] = 'Blanda';
$string['shufflequestions_help'] = 'Om aktiverat kommer ordningen på frågorna i det här avsnittet att blandas i en annan slumpmässig ordning för varje deltagare. Det kan göra det svårare för deltagarna att dela svar, men det gör det också svårare för deltagarna att diskutera en viss fråga med läraren.';
$string['shufflewithin'] = 'Blanda om inom frågorna';
$string['shufflewithin_help'] = '<p>Om du aktiverar det här alternativet då kommer de delar som bygger upp de enskilda frågorna att slumpmässigt blandas varje gång en student  påbörjar ett försök med det här kunskapstestet, detta under förutsättning att alternativet även är aktiverat i inställningarna för frågan. </p> <p>Avsikten är bara att göra det lite svårare för folk att kopiera av varandra.</p> <p>Det här gäller bara frågor som består av flera delar som t.ex. flervalsfrågor och para-ihop-frågor. Ordningen för flervalsfrågor blandas bara när det här alternativet är aktiverat. Svaren till para-ihop-frågor blandas alltid, i det fallet styr den här inställningen bara huruvida även ordningsföljden på paren av frågor-svar ska blandas.</p> <p>Det här alternativet har ingenting med användningen av slumpmässiga frågor att göra. </p>';
$string['singleanswer'] = 'Välj ett svar';
$string['sortage'] = 'Sortera enligt ålder';
$string['sortalpha'] = 'Sortera enligt alfabetet';
$string['sortquestionsbyx'] = 'Sortera frågor enligt: {$a}';
$string['sortsubmit'] = 'Sortera frågor';
$string['sorttypealpha'] = 'Sortera enligt typ, namn';
$string['specificapathnotonquestion'] = 'Den angivna sökvägen till filen finns inte med i den angivna frågan';
$string['specificquestionnotonquiz'] = 'Den angivna frågan finns inte med i det angivna kunskapstestet';
$string['startagain'] = 'Starta om';
$string['startattempt'] = 'Starta försök';
$string['startedon'] = 'Påbörjades';
$string['startnewpreview'] = 'Starta ny förhandsgranskning';
$string['stateabandoned'] = 'Aldrig inskickat';
$string['statefinished'] = 'Slutfört';
$string['statefinisheddetails'] = 'Inskickat {$a}';
$string['stateinprogress'] = 'Pågående';
$string['statenotloaded'] = 'Status för frågan {$a} har inte laddats från databasen';
$string['stateoverdue'] = 'Försenat';
$string['stateoverduedetails'] = 'Måste skickas in senast {$a}';
$string['status'] = 'Status';
$string['stoponerror'] = 'Avbryt vid fel';
$string['submitallandfinish'] = 'Skicka in allt och avsluta';
$string['subneterror'] = 'Det här kunskapstestet är bara tillgängligt från speciella platser. Den dator som du använder tillhör inte de datorer som du kan använda för att göra kunskapstestet.';
$string['subnetnotice'] = 'Det här kunskapstestet har låsts så att det bara är tillgängligt från vissa platser. Din dator tillhör inte ett undernät med behörighet. Som lärare kan du ändå förhandsgranska kunskapstestet.';
$string['subplugintype_quiz'] = 'Rapport';
$string['subplugintype_quiz_plural'] = 'Rapporter';
$string['subplugintype_quizaccess'] = 'Åtkomstregel';
$string['subplugintype_quizaccess_plural'] = 'Åtkomstregler';
$string['substitutedby'] = 'kommer att ersättas av';
$string['summaryofattempt'] = 'Sammanfattning av försök';
$string['summaryofattempts'] = 'Sammanfattning av dina tidigare försök';
$string['temporaryblocked'] = 'Du får för tillfället inte göra om försöket på kunskapstestet. <br />Du kommer att få pröva igen på:';
$string['theattempt'] = 'Försöket';
$string['theattempt_help'] = 'Om eleven kan granska försöket överhuvud taget.';
$string['time'] = 'Tid';
$string['timecompleted'] = 'Genomförd';
$string['timedelay'] = 'Du får inte göra kunskapstestet eftersom det återstår tid i den tidsfördröjning som gäller innan du får fortsätta med ett annat kunskapstest.';
$string['timeleft'] = 'Återstående tid';
$string['timelimit'] = 'Tidsbegränsning';
$string['timelimit_help'] = 'Om den är aktiverad anges tidsgränsen på den första kunskapstestsidan och en nedräkningstimer visas i kunskapstestets navigeringsmeny.';
$string['timelimit_link'] = 'mod/quiz/timing';
$string['timelimitexeeded'] = 'Tyvärr! Du har överskridit tiden för kunskapstestet!';
$string['timestr'] = '%H:%M:%S on %d/%m/%y';
$string['timesup'] = 'Tiden är slut!';
$string['timing'] = 'Tidtagning';
$string['tofile'] = 'till fil';
$string['tolerance'] = 'Tolerans';
$string['toomanyrandom'] = 'Antalet frågor som skall slumpas fram är fler än antalet tillgängliga frågor i kategorin! ({$a})';
$string['top'] = 'Överst';
$string['totalmarksx'] = 'Maxpoäng: {$a}';
$string['totalquestionsinrandomqcategory'] = 'Totalt {$a} frågor i kategori.';
$string['true'] = 'Sant';
$string['truefalse'] = 'Sant/falskt';
$string['type'] = 'Typ';
$string['unfinished'] = 'öppen';
$string['ungraded'] = 'Ej betygsatt';
$string['unit'] = 'Enhet';
$string['unknowntype'] = 'Frågetypen stöds inte på rad {$a}. Frågan kommer att ignoreras.';
$string['updateoverdueattemptstask'] = 'Uppdatera försenade kunskapstest-försök';
$string['updatequizslotswithrandomxofy'] = 'Uppdaterar test-fack med "slumpmässig" frågedata ({$a->done}/{$a->total})';
$string['updatesettings'] = 'Uppdatera inställningarna för kunskapstestet';
$string['updatingatttemptgrades'] = 'Uppdaterar betyg för försök.';
$string['updatingfinalgrades'] = 'Uppdaterar slutliga betyg.';
$string['updatingthegradebook'] = 'Uppdaterar betygsbok.';
$string['upgradesure'] = '<div style="color: red;">Modulen Kunskapstest kommer att genomföra en omfattande förändring av testtabellerna och den här uppgraderingen har inte testats tillräckligt. Vi rekommenderar starkt att du säkerhetskopierar din databas innan du fortsätter.</div>';
$string['upgradingquizattempts'] = 'Uppgraderar försök på kunskapstestet: kunskapstest {$a->done}/{$a->outof} (Kunskapstestet-ID {$a->info})';
$string['upgradingveryoldquizattempts'] = 'Uppgraderar väldigt gamla kunskapstestförsöket: {$a->done}/{$a->outof}';
$string['url'] = 'URL';
$string['usedcategorymoved'] = 'Den här kategorin har flyttats till webbplatsnivån efterom dess frågor användes av andra kunskapstest på servern efter det att kursen tagits bort.';
$string['useroverrides'] = 'Användaråsidosättanden';
$string['useroverridesdeleted'] = 'Användaråsidosättanden borttagna';
$string['usersnone'] = 'Inga studenter har tillgång till detta kunskapstest.';
$string['validate'] = 'Validera';
$string['viewallanswers'] = 'Visa {$a} genomförda kunskapstest';
$string['viewallreports'] = 'Visa rapporter för {$a} försök';
$string['viewed'] = 'Granskad';
$string['warningmissingtype'] = '<b>Den här frågan är av en typ som inte har installerats för Moodle ännu.< br />Vänligen meddela din Moodleadministratör. </b>';
$string['wheregrade'] = 'Var är mitt betyg?';
$string['wildcard'] = 'Wild card';
$string['windowclosing'] = 'Det här fönstret kommer strax att stängas.';
$string['withsummary'] = 'med sammanfattande statistik';
$string['wronguse'] = 'Det går inte att använda sidan så';
$string['xhtml'] = 'XHTML';
$string['youneedtoenrol'] = 'Du måste registrera dig på den här kursen innan du får göra ett försök på kunskapstestet.';
$string['yourfinalgradeis'] = 'Ditt slutgiltiga betyg för detta kunskapstest är {$a}.';
