<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'filter_multilang2', language 'sr_cr', version '5.1'.
 *
 * @package     filter_multilang2
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['filtername'] = 'Вишејезички садржај (v2)';
$string['parentlangalwaysen'] = 'Увек користите надређене језике, укључујући \'en\'.';
$string['parentlangbehaviour'] = 'Понашање надређених језика';
$string['parentlangbehaviour_desc'] = '<p>
 Филтер одређује да ли треба приказати језички таг (ознаку)
 на основу језика наведених у самом тагу и тренутног
 језика који корисник употребљава. Овај поступак поклапања
 може да прати три различита приступа, који су познати као      <em>понашање надређених језика</em>":
</p>
<ol>
  <li>
<b>Увек користите надређене језике, искључујући \'en\'.</b>
    <ul>
      <li>
        Ово је подразумевано подешавање. Филтер узима у обзир
        језике наведенe у оквиру језичког тага <code>{mlang
        ...}</code>, и све њихове надређене језичке пакете (све до,
        али не и сам енглески <code>en</code> језички пакет).
      </li>
        <li>
        Пример: Ако је као језичка ознака наведен <code>{mlang
        en_us_k12}</code>, текст ће бити приказан само ако је
        корисник као текући језик изабрао <code>en_us_k12</code>
        или <code>en_us</code> али не и <code>en</code>.
      </li>
        <li>
        Напомена: енглески се и даље може користити уколико је
        експлицитно наведен. На пример, <code>{mlang en} Овај
        текст ће бити приказан ако корисник тренутно користи
        \'en\'.{mlang}</code>, биће приказан само ако полазник тренутно
        користи енглески језички пакет.
      </li>
    </ul>
  </li>
  <li>
    <b>Увек користи надређене језике, укључујући \'en\'.</b>
    <ul>
      <li>
        Ово подешавање функционише као и претходно, али укључује
        <code>en</code> језички пакет као надређени.
      </li>
      <li>
        Пример: Ако је као језичка ознака наведен <code>{mlang
        en_us_k12}</code>, текст ће бити приказан само ако је
        корисник каотекући језик изабрао било <code>en_us_k12</
        code>,в<code>en_us</code> или <code>en</code>.
      </li>
    </ul>
  </li>
  <li>
    <b>Никада не користите надређене језике.</b>
    <ul>
      <li>
        Као што назив говори, надређени језици се не користе
        Филтер ће омогућити приказ само оних језика који су
        експлицитно наведни у језичкој ознаци, не узимајући у обзир
        надређене језике.
      </li>
      <li>
        Пример: Ако је као језичка ознака наведен <code>{mlang
        en_us_k12}</code>, текст ће бити приказан само ако је
        корисник као текући језик изабрао <code>en_us_k12</code>
        али не и <code>en_us</code> или <code>en</code>.
      </li>
    </ul>
  </li>
</ol>';
$string['parentlangdefault'] = 'Увек користите надређене језике, искључујући \'en\' (уобичајено понашање).';
$string['parentlangnever'] = 'Никада не користите надређене језике.';
$string['pluginname'] = 'Филтер за вишејезички садржај (v2)';
$string['privacy:metadata'] = 'Додатак Филтер за вишејезички садржај (v2) не чува никакве личне податке.';
