<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'qtype_formulas', language 'sk', version '5.1'.
 *
 * @package     qtype_formulas
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['abserror'] = 'Absolútna chyba';
$string['algebraic_formula'] = 'Algebraický výraz';
$string['answer'] = 'Odpoveď';
$string['answer_help'] = '**Požadované**.
musí byť zoznam čísel alebo zoznam reťazcov v závislosti od zvoleného typu odpovede. Ak existuje iba jedna odpoveď, môže to byť číslo alebo reťazec zadaný priamo. Upozorňujeme, že počet prvkov v zozname definuje počet polí odpovede pre túto časť.

<pre class="prettyprint">123<br>[1, 0, 0, 1]<br>a<br>[1, a, b]<br>"exp(-a t)"<br>["vx t","vy t - 0.5 a t^2"]</pre>';
$string['answercombinedunitmulti'] = 'Odpoveď a jednotka pre časť {$a->part}';
$string['answercombinedunitsingle'] = 'Odpoveď a jednotka';
$string['answercoordinatemulti'] = 'Odpoveď pre časť {$a->part} a súradnica {$a->numanswer}';
$string['answercoordinatesingle'] = 'Odpoveď pre súradnicu {$a->numanswer}';
$string['answermark_help'] = '**Požadovaný**.
Značka pre odpoveď na túto časť, ktorá by mala byť číslom väčším ako 0.  Predvolená známka celej otázky je súčtom všetkých jej častí.

Poznámka: Ak je pole značky tejto časti prázdne, diel sa pri uložení otázky odstráni.';
$string['answermulti'] = 'Odpoveď pre časť {$a->part}';
$string['answerno'] = 'Časť  {$a}';
$string['answersingle'] = 'Odpoveď';
$string['answertype'] = 'Typ odpovede';
$string['answertype_help'] = 'Existujú štyri typy odpovedí.

Odpoveď na čísla, číselné a číselné vzorce vyžaduje ako odpoveď číslo alebo zoznam čísel.

Algebraické odpovede vzorcov vyžadujú ako odpoveď reťazec alebo zoznam reťazcov.

Rôzne typy odpovedí uložia rôzne obmedzenia pri zadávaní odpovedí, tak aj študenti
potrebujú vedieť, ako ich vložiť.

Kontrola formátu v otázke bude navie, ak niečo nie je v poriadku s vkladaným vzorcom. Podrobnosti nájdete v dokumentácii.';
$string['answertype_link'] = 'https://moodleformulas.org/';
$string['answerunitmulti'] = 'Jednotka pre časť {$a->part}';
$string['answerunitsingle'] = 'Jednotka';
$string['checkvarshdr'] = 'Skontrolujte inštancie premenných';
$string['choiceno'] = 'Nie';
$string['choiceyes'] = 'Áno';
$string['commonsiunit'] = 'Spoločné SI jednotky';
$string['correctansweris'] = 'Jedna správna odpoveď je: {$a}';
$string['correctfeedback'] = 'Pre akúkoľvek správnu odpoveď';
$string['correctfeedback_help'] = 'Táto spätná väzba sa zobrazí študentom, ktorí v tejto časti získali maximum bodov. Môže obsahovať globálne a lokálne premenné, ktoré budú nahradené ich hodnotami';
$string['correctness'] = 'Hodnotiace kritériun*';
$string['correctness_help'] = '**Požadované**. Môžete zvoliť buď relatívnu chybu alebo absolútnu chybu s
rozsahom chyby. Relatívnu chybu nemožno použiť pre algebraický typ odpovede.

Presnú definíciu relatívnej chyby a absolútnej chyby, keď existuje viac ako jedno pole odpovede, nájdete v dokumentácii.';
$string['correctness_link'] = 'https://moodleformulas.org/';
$string['correctnessexpert'] = 'Expert';
$string['correctnesssimple'] = 'Jednoduchý';
$string['defaultanswermark'] = 'Predvolená známka';
$string['defaultanswermark_desc'] = 'Predvolená známka pre nové časti otázok';
$string['defaultanswertype'] = 'Predvolený typ odpovede';
$string['defaultanswertype_desc'] = 'Predvolený typ odpovede pre časti novej otázky';
$string['defaultcorrectness'] = 'Predvolené kritériá hodnotenia';
$string['defaultcorrectness_desc'] = 'Predvolené kritériá hodnotenia nových častí otázky';
$string['defaultunitpenalty'] = 'Predvolené penále za jednotku';
$string['defaultunitpenalty_desc'] = 'Predvolená pokuta za nesprávnu jednotku (0-1)';
$string['error_algebraic_var'] = 'Chyba syntaxe pri definovaní algebraickej premennej.';
$string['error_answer_missing'] = 'Nebola definovaná žiadna odpoveď.';
$string['error_answerbox_duplicate'] = 'Každý zástupný symbol poľa odpovede je možné použiť iba raz za časť.';
$string['error_answertype_mistmatch'] = 'Nesúlad typu odpovede: Číselný typ odpovede vyžaduje číslo a algebraický typ odpovede vyžaduje reťazec';
$string['error_criterion'] = 'Kritérium hodnotenia sa musí vyhodnotiť na jedno číslo.';
$string['error_eval_numerical'] = 'Niektoré výrazy nie je možné numericky vyhodnotiť.';
$string['error_fixed_range'] = 'Syntaktická chyba pevného rozsahu.';
$string['error_forbid_char'] = 'Vzorec alebo výraz obsahuje zakázané znaky alebo operátory.';
$string['error_forloop'] = 'Syntaktická chyba cyklu "pre".';
$string['error_forloop_expression'] = 'Vyjadrenie cyklu for musí byť zoznam.';
$string['error_forloop_var'] = 'Premenná cyklu for obsahuje niekoľko chýb.';
$string['error_func_param'] = 'Nesprávny počet alebo nesprávny typ parametrov pre funkciu {$a} ()';
$string['error_mark'] = 'Odpoveď musí mať hodnotu väčšiu ako 0.';
$string['error_no_answer'] = 'Vyžaduje sa aspoň jedna odpoveď.';
$string['error_placeholder_format'] = 'Nesprávny formát zástupného znaku alebo zakázané znaky.';
$string['error_placeholder_main_duplicate'] = 'Duplikovaný zástupný symbol v texte hlavnej otázky.';
$string['error_placeholder_missing'] = 'Tento zástupný znak chýba v texte hlavnej otázky.';
$string['error_placeholder_sub_duplicate'] = 'Tento zástupný znak už bol definovaný v inej časti.';
$string['error_placeholder_too_long'] = 'Dĺžka zástupného symbolu je obmedzená na 40 znakov.';
$string['error_randvars_set_size'] = 'Počet generovateľných prvkov v súprave musí byť väčší ako 1.';
$string['error_randvars_type'] = 'Všetky prvky v množine musia mať presne rovnaký typ a veľkosť.';
$string['error_rule'] = 'Chyba analýzy pravidla!';
$string['error_ruleid'] = 'V súbore s identifikátorom / menom neexistuje žiadne také pravidlo.';
$string['error_subexpression_empty'] = 'Podvýraz je prázdny.';
$string['error_syntax'] = 'Syntaktická chyba.';
$string['error_unit'] = 'Chyba pri vyhodnocovaní jednotky !';
$string['error_unitpenalty'] = 'Penaltou musí byť číslo od 0 do 1.';
$string['error_validation_eval'] = 'Chyba pri vyhodnocovaní  !';
$string['error_vars_array_index_nonnumeric'] = 'Nečíselnú hodnotu nie je možné použiť ako index zoznamu.';
$string['error_vars_array_index_out_of_range'] = 'Zoznam indexov je mimo rozsah !!!';
$string['error_vars_array_size'] = 'Veľkosť zoznamu musí byť v rozsahu 1 až 1000.';
$string['error_vars_array_type'] = 'Prvok v tom istom zozname musí byť rovnakého typu, buď čísla alebo reťazca.';
$string['error_vars_array_unsubscriptable'] = 'Premenná je nezrušiteľná.';
$string['error_vars_bracket_mismatch'] = 'Nezhoda zátvoriek.';
$string['error_vars_end_separator'] = 'Na konci chýba oddeľovač úloh.';
$string['error_vars_name'] = 'Syntax názvu premennej je nesprávny.';
$string['error_vars_reserved'] = 'Funkcia {$a}() je rezervovaná a nemôže byť použitá ako premenná.';
$string['error_vars_string'] = 'Chyba! Reťazec bez úvodzoviek alebo použitie neakceptovaného znaku, ako napríklad „.';
$string['error_vars_undefined'] = 'Premenná \'{$a}\' nebola definovaná.';
$string['feedback'] = 'Časť všeobecnej spätnej väzby';
$string['feedback_help'] = 'Táto časť spätnej väzby sa zobrazí všetkým študentom. Môže obsahovať globálne a lokálne premenné, ktoré budú nahradené ich hodnotami';
$string['functiontakesatleasttwo'] = 'Funkcia {$a} musí obsahovať najmenej dva argumenty';
$string['functiontakesnoargs'] = 'Funkcia {$a} neberie žiadne argumenty';
$string['functiontakesonearg'] = 'Funkcia {$a} musí mať práve jeden argument';
$string['functiontakesoneortwoargs'] = 'Funkcia {$a} musí obsahovať jeden alebo dva argumenty';
$string['functiontakestwoargs'] = 'Funkcia {$a} musí obsahovať presne dva argumenty';
$string['globalvarshdr'] = 'Premenné';
$string['illegalformulasyntax'] = 'Neplatná syntax vzorca, ktorá začína na \'{$a}\\';
$string['incorrectfeedback'] = 'Z dôvodu akejkoľvek nesprávnej odpovede';
$string['incorrectfeedback_help'] = 'Táto spätná väzba sa zobrazí študentom, ktorí v tejto časti nedostanú žiadne známky. Môže obsahovať globálne a lokálne premenné, ktoré budú nahradené ich hodnotami';
$string['mainq'] = 'Hlavná otázka';
$string['modelanswer'] = 'Modelová odpoveď';
$string['none'] = 'Žiadny';
$string['number'] = 'Číslo';
$string['number_unit'] = 'Číslo a jednotka';
$string['numdataset'] = 'Počet datasetov';
$string['numeric'] = 'Číselný';
$string['numeric_unit'] = 'Číslo a jednotka';
$string['numerical_formula'] = 'Číselný vzorec';
$string['numerical_formula_unit'] = 'Číselný vzorec a jednotka';
$string['otherrule'] = 'Iné pravidlá';
$string['otherrule_help'] = 'Tu môže autor otázky definovať ďalšie pravidlá konverzie pre ďalšie akceptované základné jednotky. Pozrite si dokumentáciu pre pokročilé použitie.';
$string['partiallycorrectfeedback'] = 'Pre akúkoľvek čiastočne správnu odpoveď';
$string['partiallycorrectfeedback_help'] = 'Táto spätná väzba sa zobrazí študentom, ktorí v tejto časti nedostanú maximálny počet bodov. Môže obsahovať globálne a lokálne premenné, ktoré budú nahradené ich hodnotami';
$string['placeholder'] = 'Zástupný názov';
$string['placeholder_help'] = 'Zástupný symbol sa používa na identifikáciu miesta v texte hlavnej otázky, ktorý bude nahradený obsahom.
Je to reťazec alfanumerických znakov s predponou „**#**“, napríklad #1, #2a, #2b a #A.

Ak toto pole zostane prázdne, časť sa pripojí na koniec textu hlavnej otázky.';
$string['pleaseputananswer'] = 'Do každého vstupného poľa zadajte odpoveď.';
$string['pluginname'] = 'Vzorce';
$string['pluginname_link'] = 'question/type/formulas';
$string['pluginnameadding'] = 'Pridanie otázky typu "Vzorce"';
$string['pluginnameediting'] = 'Editovanie otázky typu "Vzorce"';
$string['pluginnamesummary'] = 'Typ otázky s náhodnými hodnotami a viacerými odpoveďami.
Polia odpovedí môžu byť umiestnené kdekoľvek, aby sme mohli vytvárať otázky týkajúce sa rôznych štruktúr, ako sú vektory, polynómy a matice.
Ostatné funkcie, ako je kontrola jednotky a otázky s viacerými časťami, sú tiež integrované a ľahko použiteľné.';
$string['postunit'] = 'Jednotka';
$string['privacy:metadata'] = 'Zásuvný module pre testové otázky "Vzorce" neuchováva žiadne osobné údaje.';
$string['qtextpreview'] = 'Náhľad pomocou súboru údajov';
$string['questiontext'] = 'Text otázky';
$string['relerror'] = 'Relatívna chyba';
$string['renew'] = 'Aktualizácia';
$string['ruleid'] = 'Základné konverzné pravidlá';
$string['ruleid_help'] = 'Tento typ otázky má zabudovaný systém prevodu jednotiek a má základné pravidlá prevodu.

Základným je pravidlo „Spoločné jednotky SI“, ktoré prevádzajú štandardné jednotky
napríklad jednotka dĺžky, povedzme km, m, cm a mm. Táto možnosť nemá účinok, ak nebola použitá žiadna jednotka.';
$string['settingusepopup'] = 'Použite popisy';
$string['settingusepopup_desc'] = 'Zobrazte správnu odpoveď a spätnú väzbu v popise';
$string['subqoptions'] = 'Extra možnosťi';
$string['unit'] = 'Jednotka';
$string['unitpenalty_help'] = 'Táto voľba určuje značku, ktorú chcete potrestať študentom za nesprávnu jednotku.

Berie hodnotu medzi 0 a 1. Ak vezme hodnotu 1, jednotka a odpoveď
musia byť správne súčasne, aby získal známku. Jednotka a odpoveď sa považujú za jednu entitu. Na druhej strane, akje hodnota 0, študenti môžu získať plnú známku iba za správnu odpoveď, vtedy reťazec (jednotka) na konci odpovede nebude mať žiadny účinok.

Preto sa odporúča použiť hodnotu 1 vždy, keď odpoveď nemá priradenú jednotku.';
$string['unsupportedformulafunction'] = 'Funkcia {$a} nie je podporovaná';
$string['vars1'] = 'Lokálne premenné';
$string['vars1_help'] = 'Tu môžete definovať premenné rovnakým spôsobom, ako sú definované globálne premenné na úrovni otázok. Premenné tu definované môžu byť použité v odpovedi alebo v spätnej väzbe a ich rozsah viditeľnosti je obmedzený len pre danú časť.';
$string['vars2'] = 'Premenné hodnotenia';
$string['vars2_help'] = 'Tu je možné použiť všetky miestne premenné a odpovede študentov. Podrobné informácie o používaní nájdete v dokumentácii.';
$string['vars2_link'] = 'https://moodleformulas.org/';
$string['varsglobal'] = 'Globálne premenné';
$string['varsglobal_link'] = 'https://moodleformulas.org/';
$string['varsrandom'] = 'Náhodné premenné';
$string['varsrandom_link'] = 'https://moodleformulas.org/';
$string['varsstatistics'] = 'Štatistika';
$string['yougotnright'] = 'Správne si zodpovedal {$a->num} časť(i) tejto otázky.';
