<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'local_moodlemobileapp', language 'pt', version '5.1'.
 *
 * @package     local_moodlemobileapp
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['addon.block_myoverview.browseallcourses'] = 'Ver todas as disciplinas';
$string['addon.block_myoverview.nocoursesenrolled'] = 'Ainda não está inscrito em nenhuma disciplina.';
$string['addon.block_myoverview.nocoursesenrolleddescription'] = 'Navegue por todas as disciplinas disponíveis abaixo e comece a aprender.';
$string['addon.block_myoverview.noresult'] = 'A sua pesquisa não corresponde a nenhuma disciplina.';
$string['addon.block_myoverview.noresultdescription'] = 'Tente ajustar os seus filtros ou navegue em todas as disciplinas abaixo.';
$string['addon.block_myoverview.searchavailablecourses'] = 'Pesquisar disciplinas disponíveis';
$string['addon.blog.errorloadentries'] = 'Ocorreu um erro ao carregar publicações do Blogue.';
$string['addon.blog.showonlyyourentries'] = 'Mostrar apenas as suas publicações';
$string['addon.calendar.calendarevent'] = 'Evento do calendário';
$string['addon.calendar.calendarevents'] = 'Eventos do calendário';
$string['addon.calendar.calendarreminders'] = 'Lembretes do calendário';
$string['addon.calendar.currentmonth'] = 'Mês atual';
$string['addon.calendar.defaultnotificationtime'] = 'Hora de notificação predefinida';
$string['addon.calendar.errorloadevent'] = 'Erro ao carregar evento.';
$string['addon.calendar.errorloadevents'] = 'Erro ao carregar eventos.';
$string['addon.calendar.monthlyview'] = 'Vista mensal';
$string['addon.calendar.noevents'] = 'Sem eventos';
$string['addon.calendar.reminders'] = 'Lembretes';
$string['addon.calendar.setnewreminder'] = 'Definir um novo lembrete';
$string['addon.competency.errornocompetenciesfound'] = 'Nenhuma competência encontrada';
$string['addon.competency.nocompetencies'] = 'Sem competências';
$string['addon.coursecompletion.complete'] = 'Concluído';
$string['addon.coursecompletion.couldnotloadreport'] = 'Não foi possível carregar o relatório de conclusão da disciplina. Por favor, tente mais tarde.';
$string['addon.enrol_self.confirmselfenrol'] = 'Tem certeza de que pretende inscrever-se nesta disciplina?';
$string['addon.enrol_self.errorselfenrol'] = 'Ocorreu um erro durante a autoinscrição.';
$string['addon.messageoutput_airnotifier.processorsettingsdesc'] = 'Configurar dispositivos';
$string['addon.messageoutput_airnotifier.pushdisabledwarning'] = 'Os seus utilizadores não estão a receber nenhuma notificação deste site nos seus dispositivos móveis. Ative as notificações móveis na página de configurações das notificações.';
$string['addon.messages.contactlistempty'] = 'A lista de contactos está vazia';
$string['addon.messages.contactname'] = 'Nome do contacto';
$string['addon.messages.deletemessage'] = 'Apagar mensagem';
$string['addon.messages.deletemessageconfirmation'] = 'Tem a certeza de que pretende apagar esta mensagem? Apenas será excluída do seu histórico de mensagens. Poderá ser visualizada pelo utilizador que enviou ou recebeu a mensagem.';
$string['addon.messages.errordeletemessage'] = 'Erro ao apagar a mensagem.';
$string['addon.messages.errorwhileretrievingcontacts'] = 'Erro ao obter contactos do servidor.';
$string['addon.messages.errorwhileretrievingdiscussions'] = 'Erro ao obter tópicos de discussão do servidor.';
$string['addon.messages.errorwhileretrievingmessages'] = 'Erro ao obter mensagens do servidor.';
$string['addon.messages.errorwhileretrievingusers'] = 'Erro ao obter utilizadores do servidor.';
$string['addon.messages.messagenotsent'] = 'A mensagem não foi enviada. Tente novamente mais tarde.';
$string['addon.messages.newmessages'] = 'Novas mensagens';
$string['addon.messages.nousersfound'] = 'Nenhum utilizador encontrado';
$string['addon.messages.showdeletemessages'] = 'Mostrar mensagens apagadas';
$string['addon.messages.type_blocked'] = 'Bloqueado';
$string['addon.messages.type_offline'] = 'Offline';
$string['addon.messages.type_online'] = 'Online';
$string['addon.messages.type_search'] = 'Resultados da pesquisa';
$string['addon.messages.type_strangers'] = 'Outros';
$string['addon.messages.useentertosenddescdesktop'] = 'Se desativar esta opção, pode utilizar Ctrl+Enter para enviar a mensagem.';
$string['addon.messages.useentertosenddescmac'] = 'Se desativar esta opção, pode utilizar Cmd+Enter para enviar a mensagem.';
$string['addon.messages.warningconversationmessagenotsent'] = 'Não foi possível enviar mensagens para a conversação {{conversation}}. {{error}}';
$string['addon.messages.warningmessagenotsent'] = 'Não foi possível enviar mensagens ao utilizador {{user}}. {{error}}';
$string['addon.mod_assign.acceptsubmissionstatement'] = 'Por favor, aceite a declaração de submissão.';
$string['addon.mod_assign.allowsubmissionsanddescriptionfromdatesummary'] = 'Os detalhes do trabalho e o formulário de envio estarão disponíveis em <strong>{{$a}}</strong>';
$string['addon.mod_assign.allowsubmissionsfromdatesummary'] = 'Este trabalho aceitará submissões a partir de <strong>{{$a}}</strong>';
$string['addon.mod_assign.cannoteditduetostatementsubmission'] = 'Não pode adicionar ou editar uma submissão na aplicação porque não foi possível recuperar a declaração de submissão desde o site.';
$string['addon.mod_assign.cannotgradefromapp'] = 'Alguns métodos de avaliação ainda não são suportados pela aplicação e não podem ser modificados.';
$string['addon.mod_assign.cannotsubmitduetostatementsubmission'] = 'Não pode submeter o trabalho na aplicação porque não foi possível obter a declaração de submissão desde o site.';
$string['addon.mod_assign.duedateno'] = 'Sem data limite';
$string['addon.mod_assign.erroreditpluginsnotsupported'] = 'Não pode adicionar ou editar uma submissão na aplicação porque alguns módulos ainda não são suportados para edição.';
$string['addon.mod_assign.errorshowinginformation'] = 'Não é possível mostrar informações da submissão';
$string['addon.mod_assign.feedbacknotsupported'] = 'Este feedback não é suportado pela aplicação e pode não conter toda a informação.';
$string['addon.mod_assign.gradenotsynced'] = 'Nota não está sincronizada';
$string['addon.mod_assign.notallparticipantsareshown'] = 'Não são mostrados os participantes sem submissão.';
$string['addon.mod_assign.numberofdraftsubmissionscountdescription'] = 'Existem {{count}} rascunhos.';
$string['addon.mod_assign.numberofparticipantscountdescription'] = 'Existem {{count}} participantes.';
$string['addon.mod_assign.numberofsubmissionsneedgradingcountdescription'] = 'Existem {{count}} submissões que precisam de ser avaliadas.';
$string['addon.mod_assign.numberofsubmittedassignmentscountdescription'] = 'Existem {{count}} trabalhos submetidos.';
$string['addon.mod_assign.numberofteamscountdescription'] = 'Existem {{count}} equipas.';
$string['addon.mod_assign.submissionnotsupported'] = 'Esta submissão não é suportada pela aplicação e pode não conter toda a informação.';
$string['addon.mod_assign.syncblockedusercomponent'] = 'nota do utilizador';
$string['addon.mod_assign.warningsubmissiongrademodified'] = 'A nota da submissão foi modificada no site.';
$string['addon.mod_assign.warningsubmissionmodified'] = 'A submissão do utilizador foi modificada no site.';
$string['addon.mod_chat.confirmloss'] = 'Tem a certeza? O histórico do chat pode ser perdido.';
$string['addon.mod_chat.errorwhileconnecting'] = 'Erro ao entrar no chat.';
$string['addon.mod_chat.errorwhilegettingchatdata'] = 'Erro ao obter os dados do chat.';
$string['addon.mod_chat.errorwhilegettingchatusers'] = 'Erro ao obter os utilizadores do chat.';
$string['addon.mod_chat.errorwhileretrievingmessages'] = 'Erro ao obter mensagens do servidor.';
$string['addon.mod_chat.errorwhilesendingmessage'] = 'Erro ao enviar a mensagem.';
$string['addon.mod_chat.mustbeonlinetosendmessages'] = 'Tem de estar online para poder enviar mensagens.';
$string['addon.mod_chat.nosessionsfound'] = 'Nenhuma sessão encontrada';
$string['addon.mod_chat.showincompletesessions'] = 'Mostrar sessões incompletas';
$string['addon.mod_choice.errorgetchoice'] = 'Erro ao obter os dados da sondagem.';
$string['addon.mod_choice.responsesresultgraphdescription'] = '{{number}}% dos utilizadores escolheram esta opção: {{text}}.';
$string['addon.mod_choice.resultsnotsynced'] = 'A sua última resposta tem de ser sincronizada para estar incluída nos resultados.';
$string['addon.mod_data.edittagsnotsupported'] = 'A edição de palavras-chave não é suportada pela aplicação.';
$string['addon.mod_data.errorapproving'] = 'Erro ao aprovar ou desaprovar uma entrada.';
$string['addon.mod_data.errordeleting'] = 'Erro ao apagar a entrada.';
$string['addon.mod_data.gettinglocation'] = 'A obter localização';
$string['addon.mod_data.locationnotenabled'] = 'Localização não está ativada';
$string['addon.mod_data.locationpermissiondenied'] = 'Foi negada a permissão para aceder à sua localização.';
$string['addon.mod_data.mylocation'] = 'Minha localização';
$string['addon.mod_data.searchbytagsnotsupported'] = 'Pesquisar por palavras-chave não é suportado pela aplicação.';
$string['addon.mod_feedback.captchaofflinewarning'] = 'Inquérito com CAPTCHA não pode ser concluído em modo offline, ou se não estiver configurado, ou o servidor não está acessível.';
$string['addon.mod_feedback.completedfeedbackscountdescription'] = 'Existem {{count}} respostas submetidas.';
$string['addon.mod_feedback.feedback_submitted_offline'] = 'O Inquérito foi gravado para ser enviado mais tarde.';
$string['addon.mod_feedback.questionscountdescription'] = 'Existem {{count}} perguntas.';
$string['addon.mod_folder.emptyfilelist'] = 'Não existem ficheiros para mostrar.';
$string['addon.mod_forum.errorgetforum'] = 'Erro ao obter dados do fórum.';
$string['addon.mod_forum.errorgetgroups'] = 'Erro ao obter as configurações do grupo.';
$string['addon.mod_forum.errorloadingsortingorder'] = 'Fórum não disponível nesta ordenação';
$string['addon.mod_forum.errorloadingsortingorderdetails'] = 'Tente alterar a ordenação ou aceder à Internet para ver este fórum.';
$string['addon.mod_forum.errorposttoallgroups'] = 'Não foi possível criar nova conversação em todos os grupos.';
$string['addon.mod_forum.forumnodiscussionsyet'] = 'Ainda não existem tópicos de discussão neste fórum.';
$string['addon.mod_forum.group'] = 'Grupo';
$string['addon.mod_forum.numdiscussions'] = '{{numdiscussions}} tópicos de discussão';
$string['addon.mod_forum.numreplies'] = '{{numreplies}} respostas';
$string['addon.mod_forum.postingroup'] = 'Publicar no grupo "{{groupname}}".';
$string['addon.mod_forum.refreshposts'] = 'Atualizar tópicos de discussão';
$string['addon.mod_glossary.browsemode'] = 'Ver entradas';
$string['addon.mod_glossary.byalphabet'] = 'Alfabeticamente';
$string['addon.mod_glossary.byauthor'] = 'Agrupar por autor';
$string['addon.mod_glossary.bycategory'] = 'Agrupar por categoria';
$string['addon.mod_glossary.bynewestfirst'] = 'Ordenar por mais recentes';
$string['addon.mod_glossary.byrecentlyupdated'] = 'Recentemente atualizados';
$string['addon.mod_glossary.bysearch'] = 'Pesquisar';
$string['addon.mod_glossary.cannoteditentry'] = 'Não é possível editar a entrada';
$string['addon.mod_glossary.entriestobesynced'] = 'Entradas a serem sincronizadas';
$string['addon.mod_glossary.entrypendingapproval'] = 'Este termo aguarda aprovação.';
$string['addon.mod_glossary.errordeleting'] = 'Erro ao apagar entrada.';
$string['addon.mod_glossary.errorloadingentries'] = 'Ocorreu um erro ao carregar os termos.';
$string['addon.mod_glossary.errorloadingentry'] = 'Ocorreu um erro ao carregar o termo.';
$string['addon.mod_glossary.errorloadingglossary'] = 'Ocorreu um erro ao carregar o glossário.';
$string['addon.mod_glossary.noentriesfound'] = 'Nenhum termo encontrado.';
$string['addon.mod_glossary.searchquery'] = 'Pesquisa';
$string['addon.mod_h5pactivity.downloadh5pfile'] = 'Descarregar ficheiro H5P';
$string['addon.mod_h5pactivity.errorgetactivity'] = 'Erro ao obter dados da atividade H5P.';
$string['addon.mod_h5pactivity.filestatenotdownloaded'] = 'O pacote H5P ainda não foi descarregado. Tem de descarregar primeiro para poder usá-lo.';
$string['addon.mod_h5pactivity.filestateoutdated'] = 'O pacote H5P foi modificado desde a última vez que foi descarregado. Tem de o descarregar novamente para poder usá-lo.';
$string['addon.mod_h5pactivity.numberofattempts'] = '{{$a}} tentativas';
$string['addon.mod_h5pactivity.offlinedisabledwarning'] = 'Tem de estar online para visualizar o pacote H5P.';
$string['addon.mod_h5pactivity.viewattempt'] = 'Ver a tentativa {{$a}}';
$string['addon.mod_imscp.showmoduledescription'] = 'Mostrar descrição';
$string['addon.mod_lesson.errorprefetchrandombranch'] = 'Esta lição contém um salto para uma página de conteúdo aleatório. Não pode ser tentada na aplicação antes de ser iniciada no site.';
$string['addon.mod_lesson.errorreviewretakenotlast'] = 'Já não é possível rever esta tentativa porque já foi terminada outra tentativa.';
$string['addon.mod_lesson.finishretakeoffline'] = 'Esta tentativa foi concluída em modo offline.';
$string['addon.mod_lesson.retakefinishedinsync'] = 'Uma tentativa offline foi sincronizada. Pretende rever a tentativa?';
$string['addon.mod_lesson.retakelabelfull'] = '{{retake}}: {{grade}} {{timestart}} ({{duration}})';
$string['addon.mod_lesson.retakelabelshort'] = '{{retake}}: {{grade}} {{timestart}}';
$string['addon.mod_lesson.warningretakefinished'] = 'A tentativa foi terminada no site.';
$string['addon.mod_lti.errorgetlti'] = 'Erro ao obter os dados do módulo.';
$string['addon.mod_lti.errorinvalidlaunchurl'] = 'O URL não é válido.';
$string['addon.mod_lti.launchactivity'] = 'Iniciar a atividade';
$string['addon.mod_page.errorwhileloadingthepage'] = 'Erro ao carregar o conteúdo da página.';
$string['addon.mod_quiz.canattemptbutnotsubmit'] = 'Pode tentar responder a este teste na aplicação, mas precisará de enviar a tentativa através do navegador pelos seguintes motivos:';
$string['addon.mod_quiz.cannotsubmitquizdueto'] = 'Esta tentativa de resolução do teste não pode ser submetida pelas seguintes razões:';
$string['addon.mod_quiz.confirmcontinueoffline'] = 'Esta tentativa não foi sincronizada desde {{$a}}. Se continuou esta tentativa noutro dispositivo desde então, pode perder dados.';
$string['addon.mod_quiz.confirmleavequizonerror'] = 'Ocorreu um erro ao guardar as respostas. Tem a certeza de que pretende sair do teste?';
$string['addon.mod_quiz.errorbehaviournotsupported'] = 'Este teste não pode ser respondido na aplicação porque o comportamento das perguntas não é suportado:';
$string['addon.mod_quiz.errordownloading'] = 'Erro ao descarregar os dados necessários.';
$string['addon.mod_quiz.errorgetattempt'] = 'Erro ao obter dados da tentativa.';
$string['addon.mod_quiz.errorgetquestions'] = 'Erro ao obter perguntas.';
$string['addon.mod_quiz.errorgetquiz'] = 'Erro ao obter dados de teste.';
$string['addon.mod_quiz.errorparsequestions'] = 'Ocorreu um erro ao ler as perguntas. Tente o teste num navegador web.';
$string['addon.mod_quiz.errorquestionsnotsupported'] = 'Este teste não pode ser tentado na aplicação porque apenas contém tipos de perguntas não suportados pela aplicação:';
$string['addon.mod_quiz.errorrulesnotsupported'] = 'Este teste não pode ser tentado na aplicação porque tem regras de acesso não suportadas pela aplicação:';
$string['addon.mod_quiz.errorsaveattempt'] = 'Ocorreu um erro ao guardar os dados da tentativa.';
$string['addon.mod_quiz.finishedofflinenotice'] = 'A sua tentativa foi submetida e guardada. Será submetida para o site quando estiver novamente online.';
$string['addon.mod_quiz.finishnotsynced'] = 'Terminado mas não sincronizado';
$string['addon.mod_quiz.opentoc'] = 'Abrir navegação';
$string['addon.mod_quiz.warningattemptfinished'] = 'Esta tentativa offline foi descartada por já estar concluída no site ou não ter  sido encontrada.';
$string['addon.mod_quiz.warningdatadiscarded'] = 'Algumas respostas offline foram descartadas porque as perguntas foram modificadas no site.';
$string['addon.mod_quiz.warningdatadiscardedfromfinished'] = 'Tentativa inacabada porque algumas respostas offline foram descartadas. Por favor reveja as suas respostas e reenvie a tentativa.';
$string['addon.mod_quiz.warningquestionsnotsupported'] = 'Este teste contém tipos de perguntas não suportados pela aplicação:';
$string['addon.mod_resource.errorwhileloadingthecontent'] = 'Erro ao carregar o conteúdo.';
$string['addon.mod_resource.openthefile'] = 'Abrir';
$string['addon.mod_resource.resourcestatusoutdated'] = 'Este ficheiro foi alterado desde a última vez que o abriu.';
$string['addon.mod_resource.resourcestatusoutdatedconfirm'] = 'Existe uma versão mais recente deste ficheiro. Para vê-lo, ligue o seu dispositivo à Internet.';
$string['addon.mod_scorm.cannotcalculategrade'] = 'Não foi possível calcular a nota.';
$string['addon.mod_scorm.dataattemptshown'] = 'Estes dados pertencem à tentativa número {{number}}.';
$string['addon.mod_scorm.errorcreateofflineattempt'] = 'Ocorreu um erro ao criar uma nova tentativa offline. Por favor, tente novamente.';
$string['addon.mod_scorm.errordownloadscorm'] = 'Erro ao descarregar o SCORM: "{{name}}".';
$string['addon.mod_scorm.errorgetscorm'] = 'Erro ao obter os dados do SCORM.';
$string['addon.mod_scorm.errorinvalidversion'] = 'A aplicação apenas suporta a versão SCORM 1.2.';
$string['addon.mod_scorm.errornotdownloadable'] = 'Não é permitido descarregar pacotes SCORM. Por favor, contacte o administrador do site.';
$string['addon.mod_scorm.errornovalidsco'] = 'Este pacote SCORM não possui um SCO visível para carregar.';
$string['addon.mod_scorm.errorpackagefile'] = 'A aplicação apenas suporta pacotes ZIP.';
$string['addon.mod_scorm.errorsyncscorm'] = 'Ocorreu um erro durante o processo de sincronização. Por favor, tente novamente.';
$string['addon.mod_scorm.offlineattemptnote'] = 'Esta tentativa possui dados que ainda não foram sincronizados.';
$string['addon.mod_scorm.offlineattemptovermax'] = 'Esta tentativa não pode ser enviada porque já excedeu o número máximo de tentativas.';
$string['addon.mod_scorm.scormstatusnotdownloaded'] = 'Este pacote SCORM não foi descarregado. Será descarregado assim que o abrir.';
$string['addon.mod_scorm.scormstatusoutdated'] = 'Este pacote SCORM foi modificado desde a última vez que o descarregou. A versão mais recente do mesmo será descarregada automaticamente assim que o abrir.';
$string['addon.mod_scorm.warningofflinedatadeleted'] = 'Alguns dados offline da tentativa {{number}} foram excluídos porque não podem ser considerados numa nova tentativa.';
$string['addon.mod_scorm.warningsynconlineincomplete'] = 'Algumas tentativas ainda não foram sincronizadas com o site porque a última tentativa ainda não se está finalizada. Por favor, termine a tentativa online primeiro.';
$string['addon.mod_survey.cannotsubmitsurvey'] = 'Ocorreu um problema durante a submissão do seu inquérito. Por favor, tente novamente.';
$string['addon.mod_survey.errorgetsurvey'] = 'Erro ao obter os dados do inquérito.';
$string['addon.mod_survey.results'] = 'Resultados';
$string['addon.mod_url.accessurl'] = 'Aceder ao URL';
$string['addon.mod_url.pointingtourl'] = 'O URL para onde aponta este recurso.';
$string['addon.mod_wiki.errorloadingpage'] = 'Ocorreu um erro ao carregar a página.';
$string['addon.mod_wiki.errornowikiavailable'] = 'Este Wiki ainda não possui conteúdo.';
$string['addon.mod_wiki.gowikihome'] = 'Ir para página principal do Wiki';
$string['addon.mod_wiki.subwiki'] = 'Sub-Wiki';
$string['addon.mod_wiki.titleshouldnotbeempty'] = 'O título não deve estar vazio';
$string['addon.mod_wiki.viewpage'] = 'Visualizar página';
$string['addon.mod_wiki.wikipage'] = 'Página Wiki';
$string['addon.mod_workshop.assessmentstrategynotsupported'] = 'Estratégia de avaliação {{$a}} não suportada';
$string['addon.mod_workshop.submissionrequiredtitle'] = 'É necessário indicar um título.';
$string['addon.mod_workshop.warningassessmentmodified'] = 'A submissão foi alterada no site.';
$string['addon.mod_workshop.warningsubmissionmodified'] = 'O trabalho foi modificado no site.';
$string['addon.notes.warningnotenotsent'] = 'Não foi possível adicionar ou apagar anotações. {{error}}';
$string['addon.notifications.allownotifications'] = 'Permitir notificações';
$string['addon.notifications.errorgetnotifications'] = 'Erro ao obter notificações.';
$string['addon.notifications.notifications'] = 'Notificações';
$string['addon.notifications.playsound'] = 'Reproduzir som';
$string['addon.notifications.therearentnotificationsyet'] = 'Não existem notificações.';
$string['addon.notifications.typeofnotification'] = 'Tipo de notificação';
$string['addon.privatefiles.couldnotloadfiles'] = 'A lista de ficheiros não pôde ser carregada.';
$string['addon.privatefiles.emptyfilelist'] = 'Não existem ficheiros para mostrar.';
$string['addon.privatefiles.erroruploadnotworking'] = 'Infelizmente, no momento não é possível carregar ficheiros para o seu site.';
$string['addon.storagemanager.confirmdeleteallsitedata'] = 'Apagar todos os dados descarregados do site?';
$string['addon.storagemanager.confirmdeletecourses'] = 'Apagar os dados descarregados de todas as disciplinas?';
$string['addon.storagemanager.confirmdeletedatafrom'] = 'Apagar todos os dados descarregados de \'{{name}}\'?';
$string['addon.storagemanager.coursedownloads'] = 'Descarregamentos da disciplina';
$string['addon.storagemanager.courseinfo'] = 'Descarregue o conteúdo da disciplina para trabalhar offline. A sua atividade será sincronizada automaticamente quando o seu dispositivo estiver online novamente.';
$string['addon.storagemanager.deleteallsitedata'] = 'Apagar todos os dados descarregados do site';
$string['addon.storagemanager.deleteallsitedatainfo'] = 'Irá apagar todos os dados descarregados de \'{{name}}\', incluindo todas as disciplinas descarregadas e os dados que permitem que trabalhe offline.';
$string['addon.storagemanager.deletecourses'] = 'Apagar todos os dados descarregados de todas as disciplinas';
$string['addon.storagemanager.deletedata'] = 'Apagar dados descarregados';
$string['addon.storagemanager.deletedatafrom'] = 'Apagar todos os dados descarregados de \'{{name}}\'';
$string['addon.storagemanager.downloaddatafrom'] = 'Descarregar {{name}}';
$string['addon.storagemanager.downloadedcourses'] = 'Disciplinas descarregadas';
$string['addon.storagemanager.downloads'] = 'Descarregamentos';
$string['addon.storagemanager.errordeletedownloadeddata'] = 'Erro ao apagar dados descarregados.';
$string['addon.storagemanager.managedownloads'] = 'Gerir descarregamentos';
$string['addon.storagemanager.totaldownloads'] = 'Total de descarregamentos';
$string['addon.storagemanager.totalspaceusage'] = 'Total espaço usado';
$string['addon.tinymce.enabletinymceeditor'] = 'Utilizar o editor de texto TinyMCE';
$string['addon.tinymce.enabletinymceeditordescription'] = 'Um editor de texto avançado com funcionalidades de formatação adicionais.';
$string['addon.tinymce.license'] = 'A Moodle Pty Ltd garantiu uma licença comercial TinyMCE compatível com a licença Apache 2.0.';
$string['appstoredescription'] = 'NOTA: Esta aplicação oficial Moodle Mobile apenas funciona com sites Moodle que foram configurados para o permitir. Fale com o administrador do seu Moodle se tiver quaisquer dificuldades em se ligar. Se o seu site Moodle foi configurado corretamente, pode usar esta aplicação para:

- Navegar no conteúdo das suas disciplinas, mesmo quando estiver offline
- Receber notificações instantâneas de mensagens e outros eventos
- Encontrar de forma rápida e entrar em contacto com outras pessoas nas suas disciplinas
- Carregar imagens, áudio, vídeos e outros ficheiros do seu dispositivo móvel
- Visualizar as suas notas das disciplinas
- E muito mais!

Por favor, consulte http://docs.moodle.org/en/Mobile_app para aceder à informação mais atualizada.

Gostaríamos muito de receber boas opiniões sobre a funcionalidade até agora implementada e as suas sugestões para outras funcionalidades que desejaria que esta aplicação tivesse!

A aplicação requer as seguintes permissões:
Gravar áudio - Para gravação de áudio e carregar no Moodle
Ler e modificar o conteúdo do cartão SD - Os conteúdos são descarregados para o cartão SD para que os possa consultar offline
Acesso à rede - Para ser capaz de se ligar ao seu site Moodle e verificar se está ligado ou não, para mudar para o modo offline
Executar no arranque do sistema - Para receber notificações, mesmo quando a aplicação está a ser executada em segundo plano
Impedir que dispositivo entre em suspensão - Para que possa receber notificações a qualquer momento';
$string['assets.mimetypes.application/vnd.apple.keynote'] = 'Apresentação Apple Keynote';
$string['assets.mimetypes.application/vnd.apple.numbers'] = 'Folha de cálculo Apple Numbers';
$string['assets.mimetypes.application/vnd.apple.pages'] = 'Documento Apple Pages';
$string['assets.mimetypes.application/vnd.google-apps.audio'] = 'Áudio do Google Drive';
$string['assets.mimetypes.application/vnd.google-apps.document'] = 'Google Docs';
$string['assets.mimetypes.application/vnd.google-apps.drawing'] = 'Google Drawing';
$string['assets.mimetypes.application/vnd.google-apps.file'] = 'Ficheiro do Google Drive';
$string['assets.mimetypes.application/vnd.google-apps.folder'] = 'Pasta do Google Drive';
$string['assets.mimetypes.application/vnd.google-apps.form'] = 'Google Forms';
$string['assets.mimetypes.application/vnd.google-apps.fusiontable'] = 'Google Fusion Tables';
$string['assets.mimetypes.application/vnd.google-apps.presentation'] = 'Google Slides';
$string['assets.mimetypes.application/vnd.google-apps.script'] = 'Google Apps Scripts';
$string['assets.mimetypes.application/vnd.google-apps.site'] = 'Google Sites';
$string['assets.mimetypes.application/vnd.google-apps.spreadsheet'] = 'Google Sheets';
$string['assets.mimetypes.application/vnd.google-apps.video'] = 'Vídeo do Google Drive';
$string['core.ajaxendpointnotfound'] = '<p>Endpoint do AJAX não encontrado. Pode acontecer se o site Moodle é muito antigo ou está a bloquear o acesso a este endpoint. A aplicação Moodle suporta apenas sistemas Moodle {{$a}} em diante. Contacte o administrador do seu site.</p>
<p>{{whoisadmin}}</p>';
$string['core.browser'] = 'Navegador';
$string['core.calculating'] = 'A calcular';
$string['core.cannotconnect'] = 'Não é possível estabelecer a ligação';
$string['core.cannotdownloadfiles'] = 'A descarga de ficheiros está desativada. Por favor, contacte o administrador do site.';
$string['core.cannotinstallapk'] = 'Por questões de segurança, não pode instalar aplicações desconhecidas no seu dispositivo a partir desta aplicação. Abra o ficheiro no navegador.';
$string['core.cannotinstallapkinfo'] = 'Por motivos de segurança, não pode instalar aplicações desconhecidas no seu dispositivo a partir desta aplicação. Se mesmo assim pretende prosseguir com a instalação, é necessário abri-la num navegador.';
$string['core.cannotlogoutpageblocks'] = 'Guarde ou descarte as suas alterações antes de continuar.';
$string['core.cannotopeninapp'] = 'Este ficheiro pode não funcionar como esperado neste dispositivo. Pretende abri-lo mesmo assim?';
$string['core.cannotopeninappdownload'] = 'Este ficheiro pode não funcionar como esperado neste dispositivo. Pretende descarregá-lo mesmo assim?';
$string['core.captureaudio'] = 'Gravar áudio';
$string['core.capturedimage'] = 'Fotografia tirada.';
$string['core.captureimage'] = 'Tirar fotografia';
$string['core.capturevideo'] = 'Gravar vídeo';
$string['core.certificaterror'] = 'O certificado deste site não é confiável para o seu dispositivo: {{details}}';
$string['core.clearsearch'] = 'Limpar pesquisa';
$string['core.clearstoreddata'] = 'Limpar armazenamento {{$a}}';
$string['core.clicktoseefull'] = 'Clique para ver todos os conteúdos.';
$string['core.comments.commentsnotworking'] = 'Comentários não podem ser recuperados';
$string['core.comments.warningcommentsnotsent'] = 'Não foi possível sincronizar os comentários. {{error}}';
$string['core.confirmcanceledit'] = 'Tem a certeza de que pretende sair desta página? Todas as alterações serão perdidas.';
$string['core.confirmleavepagedescription'] = 'As alterações não guardadas serão perdidas.';
$string['core.confirmleavepagetitle'] = 'Sair da página?';
$string['core.confirmleaveunknownchanges'] = 'Tem a certeza de que pretende sair desta página? Quaisquer alterações não guardadas serão perdidas.';
$string['core.confirmloss'] = 'Tem a certeza absoluta? Todas as alterações serão perdidas.';
$string['core.confirmopeninbrowser'] = 'Pretende abrir a ligação no navegador do seu dispositivo?';
$string['core.confirmremoveselectedfile'] = 'Isto apagará definitivamente \'{{filename}}\'. Não é possível desfazer esta ação.';
$string['core.confirmremoveselectedfiles'] = 'Isto apagará definitivamente os ficheiros selecionados. Não é possível desfazer esta ação.';
$string['core.connectandtryagain'] = 'Ligue-se à internet e tente novamente.';
$string['core.connectionlost'] = 'Ligação ao site perdida';
$string['core.contactsupport'] = 'Contactar suporte';
$string['core.contactverb'] = 'Contacto';
$string['core.contenteditingsynced'] = 'O conteúdo que está a editar foi sincronizado.';
$string['core.contentlinks.chooseaccount'] = 'Escolha a conta';
$string['core.contentlinks.chooseaccounttoopenlink'] = 'Escolha uma conta para abrir a hiperligação com.';
$string['core.contentlinks.confirmurlothersite'] = 'Esta hiperligação pertence a outro site. Pretende abri-la?';
$string['core.contentlinks.errornoactions'] = 'Não foi possível encontrar uma ação para executar com esta hiperligação.';
$string['core.contentlinks.errornosites'] = 'Não foi possível encontrar um site que suporte esta hiperligação.';
$string['core.contentlinks.errorredirectothersite'] = 'O URL de redirecionamento não pode apontar para um site diferente.';
$string['core.copiedtoclipboard'] = 'Texto copiado para a área de transferência';
$string['core.copytoclipboard'] = 'Copiar para área de transferência';
$string['core.course.activitydisabled'] = 'A sua organização desativou esta atividade na aplicação para dispositivos móveis.';
$string['core.course.activitynotavailableoffline'] = 'Esta atividade não está disponível offline.';
$string['core.course.activitynotyetviewableremoteaddon'] = 'A sua organização instalou um módulo que ainda não é suportado.';
$string['core.course.activityrequiresconnection'] = 'Esta atividade só está disponível com ligação à internet. Se o seu dispositivo estiver offline, não poderá aceder.';
$string['core.course.allsections'] = 'Todas as secções';
$string['core.course.aria:sectionprogress'] = 'Progresso da secção:';
$string['core.course.availablespace'] = 'Atualmente, dispõe aproximadamente de {{available}} de espaço livre.';
$string['core.course.cannotdeletewhiledownloading'] = 'Os ficheiros não podem ser apagados enquanto a atividade está a ser descarregada. Por favor, aguarde que o descarregamento termine.';
$string['core.course.changesofflinemaybelost'] = 'Quaisquer alterações efetuadas nesta atividade enquanto estiver offline não podem ser guardadas. <br><br>Ligue o seu dispositivo à internet para evitar perder o seu progresso.';
$string['core.course.confirmdownload'] = 'Está prestes a descarregar {{size}}. {{availableSpace}} Tem a certeza de que pretende continuar?';
$string['core.course.confirmdownloadunknownsize'] = 'Não foi possível calcular o tamanho da descarga. {{availableSpace}} Tem a certeza de que pretende continuar?';
$string['core.course.confirmdownloadzerosize'] = 'Está prestes a iniciar a descarga. {{AvailableSpace}} Tem a certeza de que pretende continuar?';
$string['core.course.confirmlimiteddownload'] = 'Não está ligado a qualquer rede Wi-Fi.';
$string['core.course.confirmpartialdownloadsize'] = 'Está prestes a descarregar <strong>pelo menos</strong> {{size}}. {{availableSpace}} Tem a certeza de que pretende continuar?';
$string['core.course.couldnotloadsectioncontent'] = 'Não foi possível carregar o conteúdo da secção. Por favor, tente novamente mais tarde.';
$string['core.course.couldnotloadsections'] = 'Não foi possível carregar as secções. Por favor, tente novamente mais tarde.';
$string['core.course.downloadcoursesprogressdescription'] = 'Descarregar disciplinas: descarregadas {{count}} de {{total}}.';
$string['core.course.downloadsectionprogressdescription'] = 'Descarregar secções: descarregadas {{count}} de {{total}}.';
$string['core.course.errordownloadingcourse'] = 'Erro ao descarregar a disciplina.';
$string['core.course.errordownloadingsection'] = 'Erro ao descarregar a secção.';
$string['core.course.errorgetmodule'] = 'Erro ao obter os dados da atividade.';
$string['core.course.insufficientavailablequota'] = 'O seu dispositivo não conseguiu libertar espaço para guardar o que pretende descarregar. Pode estar a reservar espaço para atualizações do sistema e/ou aplicações. Por favor, liberte espaço livre para armazenamento.';
$string['core.course.insufficientavailablespace'] = 'Está a tentar descarregar {{size}}. Se prosseguir, o dispositivo deixará de ter espaço suficiente para funcionar normalmente. Por favor, liberte espaço livre para armazenamento.';
$string['core.course.lastaccessedactivity'] = 'Última atividade acedida';
$string['core.course.manualcompletionnotsynced'] = 'Conclusão manual não sincronizada.';
$string['core.course.modulenotfound'] = 'Recurso ou atividade não encontrada. Verifique que está online e se ainda está disponível.';
$string['core.course.nextactivity'] = 'Próxima atividade';
$string['core.course.nextactivitynotfound'] = 'Próxima atividade não encontrada. É possível que tenha sido ocultada ou apagada.';
$string['core.course.nocontentavailable'] = 'De momento, não existe conteúdo disponível.';
$string['core.course.previousactivity'] = 'Atividade anterior';
$string['core.course.previousactivitynotfound'] = 'Atividade anterior não encontrada. É possível que tenha sido ocultada ou apagada.';
$string['core.course.refreshcourse'] = 'Atualizar disciplina';
$string['core.course.useactivityonbrowser'] = 'Pode continuar a usá-lo no navegador do seu dispositivo.';
$string['core.course.warningmanualcompletionmodified'] = 'A conclusão manual de uma atividade foi modificada no site.';
$string['core.course.warningofflinemanualcompletiondeleted'] = 'Uma conclusão manual offline da disciplina \'{{name}}\' foi apagada. {{error}}';
$string['core.coursenogroups'] = 'Não é membro de qualquer grupo desta disciplina.';
$string['core.courses.browserenrolinstructions'] = 'Será encaminhado para o navegador do seu dispositivo. Depois de concluir a sua inscrição, volte para esta aplicação.';
$string['core.courses.cannotretrievemorecategories'] = 'Categorias abaixo do nível {{$a}} não podem ser recuperadas.';
$string['core.courses.completeenrolmentbrowser'] = 'Concluir inscrição no navegador';
$string['core.courses.downloadcourses'] = 'Descarregar todas as disciplinas';
$string['core.courses.enrolme'] = 'Inscrever-me';
$string['core.courses.errorloadcategories'] = 'Ocorreu um erro ao carregar as categorias.';
$string['core.courses.errorloadcourses'] = 'Ocorreu um erro ao carregar as disciplinas.';
$string['core.courses.errorloadplugins'] = 'Não foram carregados corretamente os módulos exigidos por esta disciplina. Por favor, recarregue a aplicação para tentar novamente.';
$string['core.courses.errorsearching'] = 'Ocorreu um erro durante a pesquisa.';
$string['core.courses.filtermycourses'] = 'Filtrar as minhas disciplinas';
$string['core.courses.notenrollable'] = 'Não pode inscrever-se nesta disciplina.';
$string['core.courses.otherenrolments'] = 'Outras inscrições';
$string['core.courses.password'] = 'Senha de inscrição';
$string['core.courses.refreshcourses'] = 'Atualizar lista de disciplinas';
$string['core.courses.searchcoursesadvice'] = 'Pode usar o botão Pesquisar disciplinas para encontrar disciplinas com acesso permitido a visitantes ou inscrever-se em disciplinas que o permitam.';
$string['core.courses.showonlyenrolled'] = 'Mostrar apenas as minhas disciplinas';
$string['core.courses.totalcoursesearchresults'] = 'Total de disciplinas: {{$a}}';
$string['core.currentdevice'] = 'Dispositivo atual';
$string['core.datastoredoffline'] = 'Dados armazenados no dispositivo por não ter sido possível enviar. Serão automaticamente enviados mais tarde.';
$string['core.deletedoffline'] = 'Apagada em modo offline';
$string['core.deleting'] = 'A apagar';
$string['core.desktop'] = 'PC de secretária';
$string['core.dfdaymonthyear'] = 'DD-MM-YYYY';
$string['core.dfdayweekmonth'] = 'ddd, D MMM';
$string['core.dffulldate'] = 'dddd, D MMMM YYYY h[:]mm A';
$string['core.dflastweekdate'] = 'ddd';
$string['core.dfmediumdate'] = 'LLL';
$string['core.dftimedate'] = 'hh[:]mm';
$string['core.discard'] = 'Descartar';
$string['core.dismiss'] = 'Dispensar';
$string['core.dontshowagain'] = 'Não mostrar novamente.';
$string['core.downloaded'] = 'Descarregada';
$string['core.downloading'] = 'A descarregar';
$string['core.editor.hidetoolbar'] = 'Ocultar barra de ferramentas';
$string['core.editor.toggle'] = 'Alternar editor';
$string['core.emptysplit'] = 'Esta página aparecerá em branco se o painel esquerdo estiver vazio ou enquanto estiver a ser carregado.';
$string['core.endingtime'] = 'Data/hora de fim: {{$a}}';
$string['core.errorchangecompletion'] = 'Ocorreu um erro ao alterar o estado da conclusão. Por favor, tente novamente.';
$string['core.errorcode'] = 'Código do erro';
$string['core.errordeletefile'] = 'Erro ao apagar o ficheiro. Por favor, tente novamente.';
$string['core.errordetailshide'] = 'Ocultar detalhes do erro';
$string['core.errordetailsshow'] = 'Mostrar detalhes do erro';
$string['core.errordownloading'] = 'Erro ao descarregar o ficheiro.';
$string['core.errordownloadingsomefiles'] = 'Erro ao descarregar os ficheiros. Alguns ficheiros poderão estar em falta.';
$string['core.errorfileexistssamename'] = 'Já existe um ficheiro com este nome.';
$string['core.errorinvalidform'] = 'Verifique se todos os campos obrigatórios estão preenchidos e se os dados inseridos estão no formato correto.';
$string['core.errorinvalidresponse'] = 'Resposta inválida para o webservice {{method}}.';
$string['core.errorloadingcontent'] = 'Erro ao carregar o conteúdo.';
$string['core.errorofflinedisabled'] = 'A navegação offline está desativada no site. Precisa de estar ligado à internet para usar a aplicação.';
$string['core.erroropenfiledownloading'] = 'Erro ao abrir o ficheiro: é necessário aguardar a conclusão do descarregamento.';
$string['core.erroropenfilenoapp'] = 'Erro ao abrir o ficheiro: não foi encontrada nenhuma aplicação compatível com este tipo de ficheiro.';
$string['core.erroropenfilenoextension'] = 'Erro ao abrir o ficheiro: o ficheiro não possui uma extensão.';
$string['core.erroropenpopup'] = 'Esta atividade está a tentar abrir uma janela pop-up. Esta funcionalidade não é suportada na aplicação.';
$string['core.errorrenamefile'] = 'Erro ao mudar o nome do ficheiro. Por favor, tente novamente.';
$string['core.errorsitesupport'] = 'Se o problema persistir, contacte o suporte do site.';
$string['core.errorsomedatanotdownloaded'] = 'Se descarregou esta atividade, tenha em atenção que alguns dados não são descarregados durante o processo de descarregamento por motivos de desempenho e uso de dados.';
$string['core.errorsomethingwrong'] = 'Ocorreu um erro. Tente novamente.';
$string['core.errorsync'] = 'Ocorreu um erro durante a sincronização. Por favor, tente novamente.';
$string['core.errorsyncblocked'] = 'Não é possível sincronizar agora este {{$a}} devido a outro processo já em progresso. Por favor, tente novamente mais tarde. Se o problema persistir, tente reiniciar a aplicação.';
$string['core.errorurlschemeinvalidscheme'] = 'Este URL deve ser usado noutra aplicação: {{$a}}.';
$string['core.errorurlschemeinvalidsite'] = 'O URL deste site não pode ser aberto nesta aplicação.';
$string['core.exactalarmsturnedoff'] = 'As notificações em tempo real estão desativadas';
$string['core.exactalarmsturnedoffmessage'] = 'Para garantir que não perde nenhum alerta importante, ative ‘Alarmes e lembretes’ nas configurações do seu dispositivo.';
$string['core.filedeletedsuccessfully'] = 'Apagou \'{{filename}}\' com sucesso';
$string['core.filenameexist'] = 'O nome do ficheiro já existe: {{$a}}';
$string['core.fileuploader.audio'] = 'Áudio';
$string['core.fileuploader.camera'] = 'Câmara';
$string['core.fileuploader.confirmuploadfile'] = 'Está prestes a carregar {{size}}. Tem a certeza de que pretende continuar?';
$string['core.fileuploader.confirmuploadunknownsize'] = 'Não foi possível calcular o tamanho do carregamento. Tem a certeza de que pretende continuar?';
$string['core.fileuploader.discardrecording'] = 'Descartar gravação';
$string['core.fileuploader.errorcapturingaudio'] = 'Erro ao captar o áudio.';
$string['core.fileuploader.errorcapturingimage'] = 'Erro ao captar a imagem.';
$string['core.fileuploader.errorcapturingvideo'] = 'Erro ao captar o vídeo.';
$string['core.fileuploader.errorgettingimagealbum'] = 'Erro ao obter imagem do álbum.';
$string['core.fileuploader.errormustbeonlinetoupload'] = 'Tem de estar online para enviar ficheiros.';
$string['core.fileuploader.errornoapp'] = 'Não possui a aplicação móvel necessária para executar esta ação.';
$string['core.fileuploader.errorreadingfile'] = 'Erro ao ler o ficheiro.';
$string['core.fileuploader.errorwhileuploading'] = 'Ocorreu um erro durante o carregamento do ficheiro.';
$string['core.fileuploader.file'] = 'Ficheiro';
$string['core.fileuploader.fileuploaded'] = 'Ficheiro carregado com sucesso.';
$string['core.fileuploader.maxbytesfile'] = 'O ficheiro {{$a.file}} é muito grande. O tamanho máximo que pode carregar é de {{$a.size}}.';
$string['core.fileuploader.microphonepermissiondenied'] = 'Foi negada a permissão para aceder ao microfone.';
$string['core.fileuploader.microphonepermissionrestricted'] = 'O acesso ao microfone é restrito.';
$string['core.fileuploader.pauserecording'] = 'Pausar a gravação';
$string['core.fileuploader.photoalbums'] = 'Álbuns de fotos';
$string['core.fileuploader.readingfile'] = 'A ler ficheiro';
$string['core.fileuploader.readingfileperc'] = 'A ler o ficheiro: {{$a}}%';
$string['core.fileuploader.resumerecording'] = 'Continuar a gravação';
$string['core.fileuploader.selectafile'] = 'Selecione um ficheiro';
$string['core.fileuploader.startrecordinginstructions'] = 'Toque para começar a gravação';
$string['core.fileuploader.uploadafile'] = 'Carregar um ficheiro';
$string['core.fileuploader.uploading'] = 'A carregar';
$string['core.fileuploader.uploadingperc'] = 'A carrregar: {{$a}}%';
$string['core.fileuploader.video'] = 'Vídeo';
$string['core.fullnameandsitename'] = '{{fullname}} ({{sitename}})';
$string['core.goto'] = 'Ir para {{$a}}';
$string['core.h5p.errorgetemail'] = 'Erro ao obter o e-mail do utilizador. Por favor, verifique a sua ligação e tente novamente.';
$string['core.h5p.offlinedisabled'] = 'O site não permite descarregar pacotes H5P.';
$string['core.h5p.play'] = 'Executar H5P';
$string['core.hasdatatosync'] = '{{$a}} tem dados offline que precisam de ser sincronizados.';
$string['core.howtoobtaincoordinates'] = 'Pode obter as suas coordenadas utilizando uma aplicação GPS ou uma <a href="{{url}}">aplicação de mapas</a>.';
$string['core.humanreadablesize'] = '{{size}} {{unit}}';
$string['core.iframehelp'] = 'Este conteúdo não está a funcionar?';
$string['core.image'] = 'Imagem';
$string['core.imageviewer'] = 'Visualizador de imagens';
$string['core.ioscookieshelp'] = 'O conteúdo incorporado pode exigir cookies para funcionar. Nas configurações da aplicação no iOS, ative \'Permitir monitorização entre sites\' e tente novamente.';
$string['core.lastdownloaded'] = 'Último descarregamento';
$string['core.lastsync'] = 'Última sincronização';
$string['core.leave'] = 'Sair';
$string['core.loadmore'] = 'Ver mais';
$string['core.locationnolongeravailable'] = 'Já não é possível obter a sua localização. {{howToObtain}}';
$string['core.login.authenticating'] = 'A autenticar';
$string['core.login.changepasswordbutton'] = 'Alterar a senha';
$string['core.login.changepasswordhelp'] = 'Se tiver problemas para alterar a sua senha ou contacte a sua escola ou provedor de ensino.';
$string['core.login.changepasswordreconnectinstructions'] = 'Se não alterou a sua senha corretamente, será avisado novamente para a alterar.';
$string['core.login.changepasswordsupportsubject'] = 'Preciso de ajuda para alterar a minha senha';
$string['core.login.confirmdeletesite'] = 'Tem a certeza de que pretende remover a conta no site {{sitename}}?';
$string['core.login.connect'] = 'Ligar';
$string['core.login.connecttomoodle'] = 'Ligar ao Moodle';
$string['core.login.connecttomoodleapp'] = 'Está a tentar ligar-se a um site normal do Moodle. Descarregue a Aplicação móvel Moodle para aceder a este site.';
$string['core.login.connecttoworkplaceapp'] = 'Está a tentar ligar-se a um site do Moodle Workplace. Descarregue a Aplicação móvel Moodle para aceder a este site.';
$string['core.login.credentialsdescription'] = 'Por favor, digite o nome de utilizador e a senha para entrar.';
$string['core.login.credentialshelp'] = 'Se tiver problemas para entrar, tente novamente mais tarde ou contacte a sua escola ou provedor de ensino.';
$string['core.login.credentialssupportsubject'] = 'Precisa de ajuda para entrar';
$string['core.login.emailconfirmsentnoemail'] = '<p>Foi enviado um e-mail para o seu endereço.</p><p> Contém instruções fáceis para concluir o seu registo.</p>';
$string['core.login.emailnotmatch'] = 'Os e-mails não coincidem';
$string['core.login.erroraccesscontrolalloworigin'] = 'A ação de Cross-Origin que tentou executar foi rejeitada. Por favor, para mais informações consulte \'https://moodledev.io/general/app/development/setup/app-in-browser\'';
$string['core.login.errordeletesite'] = 'Ocorreu um erro ao apagar esta conta. Por favor, tente novamente.';
$string['core.login.errorexampleurl'] = 'O URL \'https://campus.example.edu\' é apenas um exemplo de URL, não é um site real. <strong>Use o URL do site da sua escola ou organização.</strong>';
$string['core.login.errorqrnoscheme'] = 'Este URL não é um URL de autenticação válido.';
$string['core.login.errorupdatesite'] = 'Ocorreu um erro enquanto atualizava o token do site.';
$string['core.login.exceededloginattempts'] = 'Precisa de ajuda para entrar? Tente {{recoverPassword}} ou contacte o suporte do seu site.';
$string['core.login.exceededloginattemptsrecoverpassword'] = 'a recuperar a sua senha';
$string['core.login.exceededloginattemptssupportsubject'] = 'Não consigo entrar';
$string['core.login.exceededloginattemptswithoutpassword'] = 'Precisa de ajuda para entrar? Contacte o suporte do seu site.';
$string['core.login.exceededloginattemptswithoutsupport'] = 'Precisa de ajuda para entrar? Tente {{recoverPassword}}.';
$string['core.login.exceededpasswordresetattempts'] = 'Parece que está a ter problemas para aceder a sua conta. Pode contactar a sua escola ou provedor de aensino ou tentar novamente mais tarde.';
$string['core.login.exceededpasswordresetattemptssupportsubject'] = 'Não consigo redefinir a minha senha';
$string['core.login.faqcannotfindmysiteanswer'] = 'Se tentou pesquisar por endereço URL e ainda não conseguiu encontrar o seu site Moodle, contacte o responsável pelo Moodle da sua escola ou organização de aprendizagem.';
$string['core.login.faqcannotfindmysitequestion'] = 'Não consigo encontrar o meu site pelo endereço URL.';
$string['core.login.faqcantloginanswer'] = '<p>Depois de ligar-se ao seu site Moodle, poderá autenticar-se com o seu nome de utilizador e senha habituais.</p><br><p>Se esqueceu-se do seu nome de utilizador ou da senha, selecione a opção <strong >Recuperar senha</strong>. Se continuar a ter dificuldades em autenticar-se ou não conseguir ver nenhuma opção para recuperar o seu nome de utilizador ou senha, contacte o responsável pelo Moodle da sua escola ou organização de aprendizagem.</p>';
$string['core.login.faqcantloginquestion'] = 'Não consigo autenticar-me.';
$string['core.login.faqmore'] = 'Consulte as <a href="https://docs.moodle.org/en/Moodle_app_FAQ#toc" target="_blank">FAQ</a> para mais respostas.';
$string['core.login.faqsetupsiteanswer'] = 'Visite a página {{$link}} para consultar as diferentes opções que precisa para criar o seu próprio site Moodle.';
$string['core.login.faqsetupsitelinktitle'] = 'Iniciar.';
$string['core.login.faqsetupsitequestion'] = 'Eu pretendo criar o meu próprio site Moodle.';
$string['core.login.faqtestappanswer'] = 'Para testar a aplicação num site de demonstração do Moodle, digite "teacher" ou "student" no campo <strong>O seu site</strong> e clique no botão <strong>Ligar-se ao seu site</strong>.';
$string['core.login.faqtestappquestion'] = 'Posso testar a aplicação num site de demonstração?';
$string['core.login.faqwhatisurlanswer'] = '<p>Se não conseguir encontrar o seu site pelo nome, tente pesquisar pelo endereço URL do seu site Moodle (ou endereço web).</p><p>Para encontrar o endereço do seu site:</p><ol><li>Abra um navegador web e aceda à página de autenticação do seu site Moodle.</li><li>No topo da página, na barra de endereço, verá o URL do seu site Moodle, por exemplo "campus.example.edu".<br>{{$image}}</li><li>Copie o URL (não copie \'/login\' nem o que vem depois), cole-o em <strong>Seu site< /strong> na aplicação e toque em <strong>Ligar-se ao seu site</strong></li><li>Agora pode autenticar-se no seu site usando o seu nome de utilizador e a sua senha.</li></ol><p>Se tentou pesquisar por endereço URL e ainda não conseguiu encontrar o seu site Moodle, contacte o responsável pelo Moodle da sua escola ou organização de aprendizagem.</p>';
$string['core.login.faqwhatisurlquestion'] = 'Como posso encontrar o meu site?';
$string['core.login.faqwhereisqrcode'] = 'Onde posso encontrar o código QR?';
$string['core.login.faqwhereisqrcodeanswer'] = '<p>Se a sua escola ou provedor de ensino ativou o código QR, irá aparecer um código QR na parte inferior da sua página de perfil do utilizador.</p>{{$image}}';
$string['core.login.findyoursite'] = 'Procurar o site';
$string['core.login.invalidaccount'] = 'Por favor, verifique os detalhes dos seus dados de utilizador e tente novamente.';
$string['core.login.invalidmoodleversion'] = 'A versão deste site Moodle é muito antiga. A aplicação móvel Moodle apenas suporta sistemas Moodle com a versão {{$a}} ou superior.';
$string['core.login.invalidsite'] = 'O URL do site não é válido.';
$string['core.login.invalidtime'] = 'Data/hora não válida';
$string['core.login.invalidvaluemax'] = 'O valor máximo é {{$a}}';
$string['core.login.invalidvaluemin'] = 'O valor mínimo é {{$a}}';
$string['core.login.loginbutton'] = 'Iniciar sessão';
$string['core.login.mobileservicesnotenabled'] = 'Os serviços Mobile não estão ativados no site.';
$string['core.login.morewaystologin'] = 'Mais formas de autenticação';
$string['core.login.notloggedin'] = 'Precisa de estar autenticado.';
$string['core.login.onboardingcreatemanagecourses'] = 'Criar e gerir as suas disciplinas';
$string['core.login.onboardingenrolmanagestudents'] = 'Inscrever e gerir os seus alunos';
$string['core.login.onboardinggetstarted'] = 'Começar com o Moodle';
$string['core.login.onboardingialreadyhaveasite'] = 'Eu já tenho um site Moodle';
$string['core.login.onboardingimalearner'] = 'Sou aluno';
$string['core.login.onboardingimaneducator'] = 'Sou educador';
$string['core.login.onboardingineedasite'] = 'Eu preciso de um site Moodle';
$string['core.login.onboardingprovidefeedback'] = 'Fornecer feedback oportuno';
$string['core.login.onboardingtoconnect'] = 'Para se ligar à aplicação Moodle, precisa de um site Moodle';
$string['core.login.onboardingwelcome'] = 'Bem-vindo à aplicação Moodle!';
$string['core.login.or'] = 'Ou';
$string['core.login.passwordrequired'] = 'A senha é obrigatória';
$string['core.login.policyacceptmandatory'] = 'Eu entendo e concordo com as políticas obrigatórias do site';
$string['core.login.recaptchachallengeimage'] = 'Imagem reCAPTCHA';
$string['core.login.recaptchaexpired'] = 'O prazo de verificação expirou. Responda novamente à pergunta de segurança.';
$string['core.login.recaptchaincorrect'] = 'A resposta à pergunta de segurança está incorreta.';
$string['core.login.reconnect'] = 'Entrar novamente';
$string['core.login.reconnecthelp'] = 'Se tiver problemas para voltar a entrar, tente novamente mais tarde ou contacte a escola ou provedor de ensino.';
$string['core.login.reconnectsupportsubject'] = 'Preciso de ajuda para voltar a entrar';
$string['core.login.reconnecttosite'] = 'Entrar no site';
$string['core.login.removeaccount'] = 'Remover conta';
$string['core.login.searchby'] = 'Pesquisar por:';
$string['core.login.selectsite'] = 'Selecione a sua conta:';
$string['core.login.signupplugindisabled'] = '{{$a}} não está ativado.';
$string['core.login.signuprequiredfieldnotsupported'] = 'O formulário de inscrição contém um campo personalizado obrigatório que não é compatível com a aplicação. Por favor, crie a sua a conta usando um navegador web.';
$string['core.login.siteaddress'] = 'O seu site';
$string['core.login.siteaddressplaceholder'] = 'https://campus.example.edu';
$string['core.login.sitebadgedescription'] = 'Existem {{count}} notificações não lidas.';
$string['core.login.sitehasredirect'] = 'O seu site contém pelo menos um redirecionamento de HTTP. A aplicação não pode seguir redirecionamentos. Pode ser este o problema que não permite a aplicação ligar-se ao seu site.';
$string['core.login.siteinmaintenance'] = 'O seu site está em modo de manutenção';
$string['core.login.sitenotallowed'] = 'Esse site já não está disponível.';
$string['core.login.sitepolicynotagreederror'] = 'Não concordou com as políticas do site.';
$string['core.login.siteurl'] = 'URL do site';
$string['core.login.siteurlrequired'] = 'Necessário o URL do site, exemplo <i>https://campus.example.edu</i>';
$string['core.login.stillcantconnect'] = 'Continua com problemas na ligação?';
$string['core.login.toggleremove'] = 'Editar a lista de contas';
$string['core.login.unsupportedsite'] = 'Site não acessível pela aplicação';
$string['core.login.unsupportedsitemessage'] = '{{site}} não pode ser acedido com esta aplicação.<br><br>Pode continuar a aceder ao site com um navegador web.';
$string['core.login.usernamerequired'] = 'Nome de utilizador é obrigatório';
$string['core.login.visitchangepassword'] = 'Pretende visitar o site para alterar a senha?';
$string['core.login.webservicesnotenabled'] = 'Os web services não estão ativados no site.';
$string['core.login.youcanstillconnectwithcredentials'] = 'Ainda pode ligar-se ao site digitando o seu nome de utilizador e a senha.';
$string['core.login.yourenteredsite'] = 'Ligar-se ao seu site';
$string['core.lostconnection'] = 'A sua sessão expirou. Tem de autenticar-se para continuar.';
$string['core.mainmenu.switchaccount'] = 'Mudar de conta';
$string['core.mainmenu.usermenutourdescription'] = 'O local para verificar as suas notas, alterar as suas preferências ou mudar de conta.';
$string['core.mainmenu.usermenutourtitle'] = 'Explorar a sua área pessoal';
$string['core.needhelp'] = 'Precisa de ajuda?';
$string['core.needinternettoaccessit'] = 'Tem de estar ligado à internet para poder aceder.';
$string['core.networkerroriframemsg'] = 'Este conteúdo não está disponível offline. Por favor, ligue-se à Internet e tente novamente.';
$string['core.networkerrormsg'] = 'Ocorreu um erro ao ligar ao site. Por favor, verifique a sua ligação e tente novamente.';
$string['core.nooptionavailable'] = 'Nenhuma opção disponível';
$string['core.nopasswordchangeforced'] = 'Não pode prosseguir sem alterar a sua senha.';
$string['core.nopermissionerror'] = 'Desculpe, mas não tem permissão para executar esta operação';
$string['core.notapplicable'] = 'n/a';
$string['core.notavailablecontentinapp'] = 'Este conteúdo não está disponível na aplicação, mas pode abri-lo num navegador da Web utilizando o botão.';
$string['core.notavailableoffline'] = 'Este conteúdo não está disponível offline. Ligue-se à internet e tente novamente.';
$string['core.notdownloadable'] = 'Não descarregável';
$string['core.notnow'] = 'Agora não';
$string['core.notsent'] = 'Não enviado';
$string['core.nummore'] = 'mais {{$a}}';
$string['core.openfile'] = 'Abrir ficheiro';
$string['core.openfilewithextension'] = 'Abrir ficheiro {{extensão}}';
$string['core.openfullimage'] = 'Clique aqui para mostrar a imagem em tamanho real';
$string['core.openinbrowser'] = 'Abrir no navegador';
$string['core.openinbrowserdescription'] = 'Será direcionado para um navegador web';
$string['core.openmodinbrowser'] = 'Abrir {{$a}} no navegador';
$string['core.opensecurityquestion'] = 'Abrir pergunta de segurança';
$string['core.opensettings'] = 'Abrir configurações';
$string['core.openwith'] = 'Abrir com...';
$string['core.percentagenumber'] = '{{$a}}%';
$string['core.play'] = 'Tocar';
$string['core.policy.havereadandagreepolicy'] = 'Li e concordo com {{policyname}}';
$string['core.policy.nopoliciesyet'] = 'Ainda não existem políticas e acordos.';
$string['core.policy.policyacceptmandatory'] = 'Entendo e concordo com as políticas obrigatórias do site';
$string['core.policy.sitepolicynotagreederror'] = 'Política do site não aceite.';
$string['core.policy.viewpolicy'] = 'Ver a política {{policyname}}.';
$string['core.pulltorefresh'] = 'Puxe para atualizar';
$string['core.qrscanner'] = 'Leitor códigos QR';
$string['core.question.cannotdeterminestatus'] = 'Não é possível determinar o estado';
$string['core.question.errorattachmentsnotsupportedinsite'] = 'O seu site ainda não oferece suporte para anexar ficheiros às respostas.';
$string['core.question.errorembeddedfilesnotsupportedinsite'] = 'O seu site ainda não oferece suporte à edição de ficheiros incorporados.';
$string['core.question.errorquestionnotsupported'] = 'Este tipo de pergunta não é suportado pela aplicação: {{$a}}.';
$string['core.question.howtodraganddrop'] = 'Toque para selecionar e depois toque para largar.';
$string['core.question.questionmessage'] = 'Pergunta {{$a}}: {{$b}}';
$string['core.redirectingtosite'] = 'Irá ser redirecionado para o site.';
$string['core.reminders.atthetime'] = 'Na data/hora do evento';
$string['core.reminders.custom'] = 'Personalizado...';
$string['core.reminders.customreminder'] = 'Lembrete personalizado';
$string['core.reminders.delete'] = 'Apagar lembrete';
$string['core.reminders.reminderset'] = 'Lembrete definido para {{$a}}';
$string['core.reminders.reminderunset'] = 'Lembrete apagado';
$string['core.reminders.setareminder'] = 'Definir um lembrete';
$string['core.reminders.setareminderfor'] = 'Definir um lembrete para "{{title}}" ({{label}})';
$string['core.reminders.setreminder'] = 'Definir um lembrete';
$string['core.reminders.timebefore'] = '{{value}} {{units}} antes';
$string['core.reminders.value'] = 'Valor';
$string['core.removedownloadeddata'] = 'Remover dados descarregados';
$string['core.removefiles'] = 'Remover ficheiros {{$a}}';
$string['core.reportbuilder.filtersapplied'] = 'Pode haver filtros aplicados a esta exibição. Para editar os filtros ou alterar a ordenação, <a href="{{$a}}">abra este relatório no seu navegador.</a>';
$string['core.reportbuilder.hidecolumns'] = 'Ocultar colunas';
$string['core.reportbuilder.showcolumns'] = 'Mostrar colunas';
$string['core.requireduserdatamissing'] = 'Este utilizador não tem preenchido todos os dados de perfil obrigatórios. Por favor, preencha os dados em falta no seu site e tente novamente.<br>{{$a}}';
$string['core.resume'] = 'Continuar';
$string['core.retry'] = 'Tentar novamente';
$string['core.scanqr'] = 'Ler código QR';
$string['core.scrollbackward'] = 'Scroll para trás';
$string['core.scrollforward'] = 'Scroll para a frente';
$string['core.search.allcategories'] = 'Todas as categorias';
$string['core.search.empty'] = 'O que procura?';
$string['core.search.filtercategories'] = 'Filtrar resultados por';
$string['core.search.filtercourses'] = 'Procurar em';
$string['core.search.noresults'] = 'Nenhum resultado para "{{$a}}"';
$string['core.search.noresultshelp'] = 'Verifique se existem erros de digitação ou tente usar palavras-chave diferentes';
$string['core.search.resultby'] = 'Por {{$a}}';
$string['core.searching'] = 'A pesquisar';
$string['core.serverconnection'] = 'Erro ao ligar ao servidor: {{details}}';
$string['core.settings.about'] = 'Acerca';
$string['core.settings.appsettings'] = 'Configurações da aplicação';
$string['core.settings.appversion'] = 'Versão da aplicação';
$string['core.settings.cannotsyncloggedout'] = 'Este site não pode ser sincronizado porque terminou a sua sessão/saiu. Por favor, tente novamente quando estiver autenticado no site.';
$string['core.settings.cannotsyncoffline'] = 'Ocorreu um erro na sincronização do site porque o seu dispositivo não está ligado à Internet.';
$string['core.settings.cannotsyncwithoutwifi'] = 'O seu dispositivo não está ligado ao Wi-Fi. Ligue-se a uma rede Wi-Fi ou desative a Economia de dados nas configurações da aplicação.';
$string['core.settings.changelanguage'] = 'Mudar para {{$a}}';
$string['core.settings.changelanguagealert'] = 'Mudar de idioma irá reiniciar a aplicação.';
$string['core.settings.colorscheme'] = 'Esquema de cores';
$string['core.settings.colorscheme-dark'] = 'Escuro';
$string['core.settings.colorscheme-light'] = 'Claro';
$string['core.settings.colorscheme-system'] = 'Predefinições do sistema';
$string['core.settings.colorscheme-system-notice'] = 'As predefinições do sistema dependerão do suporte do seu dispositivo.';
$string['core.settings.compilationinfo'] = 'Informações da compilação';
$string['core.settings.connecttosync'] = 'O seu dispositivo está offline. Ligue-se à Internet para sincronizar os sites.';
$string['core.settings.connectwifitosync'] = 'Ligue-se a uma rede Wi-Fi ou desative a Economia de dados para sincronizar sites.';
$string['core.settings.copyinfo'] = 'Copiar informações do dispositivo para a  área de transferência';
$string['core.settings.cordovadevicemodel'] = 'Modelo do dispositivo Cordova';
$string['core.settings.cordovadeviceosversion'] = 'Versão do OS do dispositivo Cordova';
$string['core.settings.cordovadeviceplatform'] = 'Plataforma do dispositivo Cordova';
$string['core.settings.cordovadeviceuuid'] = 'UUID do dispositivo Cordova';
$string['core.settings.cordovaversion'] = 'Versão do Cordova';
$string['core.settings.debugdisplaydescription'] = 'Se ativar esta opção, as janelas modais dos erros mostrarão mais informações sobre o erro, se for possível.';
$string['core.settings.developeroptions'] = 'Opções de programação';
$string['core.settings.deviceinfo'] = 'Informação do dispositivo';
$string['core.settings.deviceos'] = 'OS do dispositivo';
$string['core.settings.displayformat'] = 'Formato de visualização';
$string['core.settings.enableanalytics'] = 'Ativar analítica';
$string['core.settings.enableanalyticsdescription'] = 'Se ativar esta opção, a aplicação recolherá a utilização de dados anónimos.';
$string['core.settings.enabledownloadsection'] = 'Ativar a transferência de secções';
$string['core.settings.enablepinchtozoom'] = 'Ativar "beliscar para ampliar"';
$string['core.settings.enablerichtexteditor'] = 'Ativar o editor de texto';
$string['core.settings.enablerichtexteditordescription'] = 'Se ativar esta opção, será mostrado um editor de texto ao inserir conteúdos.';
$string['core.settings.encryptedpushsupported'] = 'Suportadas notificações push encriptadas';
$string['core.settings.entriesincache'] = '{{$a}} entradas na cache';
$string['core.settings.estimatedfreespace'] = 'Espaço livre estimado';
$string['core.settings.filesystemroot'] = 'Raíz dos ficheiros do sistema';
$string['core.settings.fontsize'] = 'Tamanho do texto';
$string['core.settings.forcedsetting'] = 'Esta configuração foi forçada pela configuração do seu site.';
$string['core.settings.helpusimprove'] = 'Ajude-nos a melhorar esta aplicação';
$string['core.settings.ioscookies'] = 'Permitir monitorização entre sites';
$string['core.settings.ioscookiesdescription'] = 'O conteúdo incorporado do site pode exigir cookies entre sites para funcionar. Para ativar, nas configurações da aplicação no iOS, ative \'Permitir monitorização entre sites\'.';
$string['core.settings.legaldisclaimer'] = 'Informação legal';
$string['core.settings.localnotifavailable'] = 'Notificações locais disponíveis';
$string['core.settings.locationhref'] = 'URL da vista Web';
$string['core.settings.logintosync'] = 'Autentique-se para sincronizar';
$string['core.settings.navigatorlanguage'] = 'Idioma do navegador';
$string['core.settings.navigatoruseragent'] = 'UserAgent do navegador';
$string['core.settings.networkstatus'] = 'Estado da ligação à Internet';
$string['core.settings.opensourcelicenses'] = 'Licenças de Código Aberto';
$string['core.settings.privacypolicy'] = 'Politica de privacidade';
$string['core.settings.publisher'] = 'Editor';
$string['core.settings.pushid'] = 'Enviar ID das notificações';
$string['core.settings.reportinbackground'] = 'Reportar erros automaticamente';
$string['core.settings.screen'] = 'Informação do ecrã';
$string['core.settings.showdownloadoptions'] = 'Mostrar opções do descarregamento';
$string['core.settings.siteinfo'] = 'Informação do site';
$string['core.settings.sitesynccompleted'] = 'Sincronização do site concluída.';
$string['core.settings.sitesyncfailed'] = 'Erro na sincronização do site';
$string['core.settings.spaceusage'] = 'Utilização do espaço';
$string['core.settings.syncdatasaver'] = 'Economia de dados: sincronizar apenas em ligações Wi-Fi';
$string['core.settings.synchronization'] = 'Sincronização';
$string['core.settings.synchronizenow'] = 'Sincronizar agora';
$string['core.settings.synchronizenowhelp'] = 'A sincronização de um site enviará alterações pendentes e todas as atividades offline armazenadas no dispositivo e sincronizará alguns dados, como por exemplo, mensagens e notificações.';
$string['core.settings.syncsettings'] = 'Configurações da sincronização';
$string['core.settings.wificonnection'] = 'Ligação Wi-Fi';
$string['core.settings.youradev'] = 'Agora é um programador';
$string['core.sharedfiles.chooseaccountstorefile'] = 'Escolha uma conta para onde armazenar o ficheiro.';
$string['core.sharedfiles.chooseactionrepeatedfile'] = 'Já existe um ficheiro com este nome. Deseja substituir o ficheiro existente ou renomeá-lo para "{{$a}}"?';
$string['core.sharedfiles.errorreceivefilenosites'] = 'Não existem sites armazenados. Adicione um site antes de partilhar um ficheiro com a aplicação.';
$string['core.sharedfiles.nosharedfiles'] = 'Não existem quaisquer ficheiros partilhados armazenados neste site.';
$string['core.sharedfiles.nosharedfilestoupload'] = 'Não existem ficheiros para fazer o carregamento. Se pretende carregar um ficheiro de outra aplicação, localize o ficheiro e clique no botão \'Abrir em\'.';
$string['core.sharedfiles.rename'] = 'Renomear';
$string['core.sharedfiles.replace'] = 'Substituir';
$string['core.sharedfiles.sharedfiles'] = 'Ficheiros partilhados';
$string['core.sharedfiles.successstorefile'] = 'Ficheiro armazenado com sucesso. Selecione este ficheiro para enviá-lo para os seus ficheiros privados ou usá-lo em atividades.';
$string['core.sitenotfoundhelp'] = 'Não foi encontrado o site que indicou. Verifique se existem erros de digitação ou tente novamente mais tarde. Se esta mensagem de erro persistir, contacte a sua escola ou provedor de ensino.';
$string['core.siteunavailablehelp'] = 'De momento, o site "{{site}}" não está disponível. Tente novamente mais tarde ou contacte a sua escola ou provedor de ensino.';
$string['core.sizetb'] = 'TB';
$string['core.sorry'] = 'Desculpe...';
$string['core.start'] = 'Iniciar';
$string['core.startingtime'] = 'Data/hora de início: {{$a}}';
$string['core.storingfiles'] = 'A armazenar ficheiros';
$string['core.submittedoffline'] = 'Submetida (Offline)';
$string['core.swipenavigationtourdescription'] = 'Deslize para a esquerda e para a direita para navegar.';
$string['core.tablet'] = 'Tablet';
$string['core.tag.errorareanotsupported'] = 'Esta área de palavras-chave não é suportada pela aplicação.';
$string['core.tag.tagareabadgedescription'] = 'Existem {{count}} itens.';
$string['core.tag.warningareasnotsupported'] = 'Algumas das áreas de palavras-chave não são mostradas porque não são suportadas pela aplicação.';
$string['core.thereisdatatosync'] = 'Existem {{$a}} offline que têm de ser sincronizados.';
$string['core.toggledelete'] = 'Alternar botões de apagar';
$string['core.tryagain'] = 'Tente novamente';
$string['core.turnon'] = 'Ativar';
$string['core.turnonexactalarms'] = 'Ativar alertas em tempo real';
$string['core.turnonnotifications'] = 'Ativar notificações';
$string['core.turnonnotificationsmessage'] = 'Gostaria de receber notificações sobre atividades e trabalhos?';
$string['core.twoparagraphs'] = '{{p1}}<br><br>{{p2}}';
$string['core.uhoh'] = 'Ocorreu um erro!';
$string['core.unexpectederror'] = 'Erro inesperado. Por favor, feche e abra a aplicação e tente de novo.';
$string['core.unicodenotsupported'] = 'Alguns emojis não são suportados neste site. Estes caracteres serão removidos quando a mensagem for enviada.';
$string['core.unicodenotsupportedcleanerror'] = 'Foi encontrado texto vazio ao limpar caracteres Unicode.';
$string['core.unknown'] = 'Desconhecido';
$string['core.unzipping'] = 'A descompactar';
$string['core.updaterequired'] = 'Tem de atualizar a aplicação';
$string['core.updaterequireddesc'] = 'Por favor, atualize a aplicação para a versão {{$a}}';
$string['core.user.completeprofile'] = 'Completar perfil';
$string['core.user.completeprofilehelp'] = 'Se tiver problemas ao preencher o seu perfil, tente novamente mais tarde ou ou contacte a sua escola ou provedor de ensino.';
$string['core.user.completeprofilenotice'] = 'Antes de continuar, preencha os campos obrigatórios do seu perfil de utilizador.';
$string['core.user.completeprofilereconnectinstructions'] = 'Se não completou o seu perfil corretamente, será solicitado a fazê-lo novamente.';
$string['core.user.completeprofilesupportsubject'] = 'Preciso de ajuda para completar o meu perfil';
$string['core.user.completeyourprofile'] = 'Complete o seu perfil';
$string['core.user.contact'] = 'Contacto';
$string['core.user.detailsnotavailable'] = 'Não tem acesso aos detalhes deste utilizador.';
$string['core.user.errorloaduser'] = 'Erro ao carregar o utilizador.';
$string['core.user.sendemail'] = 'E-mail';
$string['core.user.support'] = 'Contacte o suporte do site';
$string['core.user.supportsubject'] = '[Aplicação] {{subject}}';
$string['core.user.userwithid'] = 'Utilizador com o ID {{id}}';
$string['core.usernologin'] = 'A autenticação foi revogada para esta conta';
$string['core.viewcode'] = 'Ver código';
$string['core.vieweditor'] = 'Ver editor';
$string['core.viewembeddedcontent'] = 'Ver conteúdo incorporado';
$string['core.viewer.decreasetextsize'] = 'Diminuir o tamanho do texto';
$string['core.viewer.editimage'] = 'Editar imagem';
$string['core.viewer.enterreadingmode'] = 'Entrar no modo de leitura';
$string['core.viewer.exitreadingmode'] = 'Sair do modo de leitura';
$string['core.viewer.fliphorizontally'] = 'Inverter horizontalmente';
$string['core.viewer.increasetextsize'] = 'Aumentar o tamanho do texto';
$string['core.viewer.openreadingmodesettings'] = 'Abrir as configurações do modo de leitura';
$string['core.viewer.qrscannerdeniedpermissionmessage'] = 'Permita o acesso à câmara nas definições do seu dispositivo para utilizar o leitor de QR.';
$string['core.viewer.qrscannerdeniedpermissiontitle'] = 'Permissão de câmara negada';
$string['core.viewer.qrscannerswitchtofrontcamera'] = 'Mudar para a câmara frontal';
$string['core.viewer.qrscannerswitchtorearcamera'] = 'Mudar para câmara traseira';
$string['core.viewer.qrscannertitle'] = 'Ler código QR';
$string['core.viewer.qrscannerturnofftorch'] = 'Desligar lanterna';
$string['core.viewer.qrscannerturnontorch'] = 'Ligar lanterna';
$string['core.viewer.readingthemedark'] = 'Escuro';
$string['core.viewer.readingthemehcm'] = 'Alto contraste';
$string['core.viewer.readingthemelight'] = 'Claro';
$string['core.viewer.readingthemesepia'] = 'Sépia';
$string['core.wanttochangesite'] = 'Pretende ir para outro site ou sair?';
$string['core.warningofflinedatadeleted'] = 'As alterações offline de {{component}} \'{{name}}\' foram ignoradas. {{error}}';
$string['core.warningofflinedatadeletedreason'] = 'Alterações mais recentes nesta atividade foram feitas num dispositivo diferente.';
$string['core.warnopeninbrowser'] = '<p>Está prestes a sair da aplicação para abrir o seguinte URL no navegador do seu dispositivo. Pretende continuar?</p>
<p><b>{{url}}</b></p>';
$string['core.whyisthishappening'] = 'Por que é que isto está a acontecer?';
$string['core.wsfunctionnotavailable'] = 'A função web service não está disponível.';
$string['core.youreoffline'] = 'O seu dispositivo está offline';
$string['core.youreonline'] = 'O seu dispositivo está online novamente';
$string['core.zoomin'] = 'Zoom -';
$string['core.zoomout'] = 'Zoom +';
$string['freemium.biometriclogin'] = 'Autenticação biométrica';
$string['freemium.biometriclogindescription'] = 'Coloque o dedo no leitor de impressão digital.';
$string['freemium.biometricloginenablefaceid'] = 'Ativar o FaceID';
$string['freemium.biometricloginenablefingerprint'] = 'Ativar impressão digital';
$string['freemium.biometricloginenabletouchid'] = 'Ativar o TouchID';
$string['freemium.biometricloginloginwithfaceid'] = 'Autenticação com FaceID';
$string['freemium.biometricloginloginwithfingerprint'] = 'Autenticação com impressão digital';
$string['freemium.biometricloginloginwithtouchid'] = 'Autenticação com TouchID';
$string['freemium.biometricloginskip'] = 'Ignorar agora';
$string['freemium.biometricloginsuccessfullyenabled'] = '{{ biometricMethod }} ativado.';
$string['freemium.biometricloginturnoff'] = 'Pode ativar e desativar esta funcionalidade a qualquer momento nas configurações.';
$string['freemium.biometriclogintypefaceid'] = 'FaceID';
$string['freemium.biometriclogintypefingerprint'] = 'Impressão digital';
$string['freemium.biometriclogintypetouchid'] = 'TouchID';
$string['freemium.biometricloginwithfingerorface'] = 'Usar a autenticação biométrica com a sua impressão digital ou o seu rosto.';
$string['freemium.change'] = 'Mudar';
$string['freemium.coursesbatchdownloaddisabled'] = 'Descarregar disciplinas em massa não está ativo neste site.';
$string['freemium.coursesdownloadlimitreached'] = 'Atingiu o limite de descarregamento de disciplinas! Só pode descarregar {{limit}} disciplinas. Contacte o seu administrador para aumentar esse limite ou remova do seu dispositivo algumas disciplinas descarregadas.';
$string['freemium.downloadmainapplicationrequired'] = 'Só pode ligar-se a este site se usar a aplicação personalizada.';
$string['freemium.downloadmainapplicationsuggestion'] = 'O site ao qual está a tentar ligar-se tem uma aplicação personalizada que pode experimentar.';
$string['freemium.feature_biometriclogin'] = 'Autenticar com biometria';
$string['freemium.feature_coursesdownload'] = 'Descarregar disciplinas';
$string['freemium.feature_multimediapushnotifications'] = 'Notificações de envio de multimédia';
$string['freemium.feature_pushnotificationsdevices'] = 'Dispositivos de envio de notificações';
$string['freemium.feature_qrlogin'] = 'Autenticar-se via código QR';
$string['freemium.feature_remotethemes'] = 'Temas remotos';
$string['freemium.feature_sitelogo'] = 'Logótipo do site';
$string['freemium.notallowed'] = 'Não permitido';
$string['freemium.nottoday'] = 'Hoje não';
$string['freemium.qrlogindisabled'] = 'A autenticação na aplicação via código QR não está ativada para o site:<br><br>{{url}}';
$string['freemium.qrloginexpiredkey'] = 'O código QR expirou. Atualize a página com o código QR e digitalize-o novamente.';
$string['freemium.qrloginipmismatch'] = 'O dispositivo que está a usar para se ligar parece não estar na mesma rede que o dispositivo que exibe o código QR. Certifique-se de que ambos os dispositivos estão ligados à mesma rede (por exemplo, mesma rede Wi-Fi).<br><br>Se o erro persistir, entre em contacto com o administrador do site.';
$string['freemium.ratetheapp'] = 'Está a gostar da nossa aplicação?';
$string['freemium.ratetheapp_feedbackko'] = 'Diga-nos o que correu mal';
$string['freemium.ratetheapp_feedbackmessage'] = 'O seu feedback será anónimo';
$string['freemium.ratetheapp_feedbackok'] = 'Enviar feedback';
$string['freemium.ratetheapp_feedbackplaceholder'] = 'Escreva aqui';
$string['freemium.ratetheapp_feedbacksent'] = 'Obrigado! O seu feedback foi enviado com sucesso.';
$string['freemium.ratetheapp_sendtostore'] = 'Poderia reservar um momento para avaliar a nossa aplicação? Irá ajudar-nos a melhorar a aplicação.';
$string['freemium.remindmelater'] = 'Lembrar-me depois';
$string['freemium.settingsoptionsfacial'] = 'Ativar autenticação facial';
$string['freemium.settingsoptionsfingerprint'] = 'Ativar autenticação com impressão digital';
$string['freemium.subscription'] = 'Subscrição do site';
$string['freemium.subscriptiondetails'] = 'Detralhes da subscrição';
$string['freemium.subscriptionfeature_exceeded_customlanguagestrings'] = '{{ overflowCount }} strings personalizadas do idioma foram ignoradas';
$string['freemium.subscriptionfeature_exceeded_custommenuitems'] = '{{ overflowCount }} itens de menu personalizados foram ignorados';
$string['freemium.subscriptionfeature_exceeded_disabledfeatures'] = '{{ overflowCount }} recursos desativados ainda estão ativados';
$string['freemium.subscriptionfeature_exceeded_remotethemes'] = 'O seu tema personalizado não foi aplicado';
$string['freemium.subscriptionfeature_exceeded_sitelogo'] = 'O logótipo do seu site não foi aplicado';
$string['freemium.subscriptionfeature_limited'] = 'Limitado a {{ limit }}';
$string['freemium.subscriptionfeature_unlimited'] = 'Ilimitado';
$string['freemium.subscriptionplan'] = 'Plano da subscrição';
$string['freemium.subscriptionplan_expired'] = 'expirada';
$string['freemium.subscriptionplan_free'] = 'Grátis';
$string['freemium.subscriptionplan_upgrade'] = 'Atualize o seu plano';
$string['freemium.subscriptionplan_validuntil'] = 'válido até {{ date }}';
$string['freemium.subscriptionplandescription'] = 'Os planos de subscrição indicam quais as restrições que se aplicam a este site.';
$string['freemium.subscriptionplanlearnmore'] = 'Mais';
$string['freemium.upsell_renewexpired'] = 'A sua subscrição já expirou';
$string['freemium.upsell_renewexpiring'] = 'A sua subscrição irá expirar daqui a {{ days }} dias';
$string['freemium.upsell_renewtitle'] = 'Renovar a sua subscrição';
$string['freemium.upsell_upgradefreeaccept'] = 'Atualizar';
$string['freemium.upsell_upgradefreemessage'] = 'Está atualmente a usar o plano gratuito. Atualize para desbloquear mais funcionalidades.';
$string['freemium.upsell_upgradefreepostpone'] = 'Mais tarde';
$string['freemium.upsell_upgradefreetitle'] = 'Atualize o seu plano';
$string['pluginname'] = 'Strings de idioma da Aplicação móvel Moodle';
$string['privacy_metadata'] = 'Este módulo não armazena quaisquer dados pessoais.';
$string['workplace.teams.isoverdue'] = 'Tem itens atrasados ou expirados';
