<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'lesson', language 'pl', version '5.1'.
 *
 * @package     lesson
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['accesscontrol'] = 'Kontrola dostępu';
$string['actionaftercorrectanswer'] = 'Operacja po udzieleniu poprawnej odpowiedzi';
$string['actionaftercorrectanswer_help'] = 'Po udzieleniu poprawnej odpowiedzi istnieją 3 opcje dotyczące następnej strony:

* Normalnie - kontynuować zgodnie ze ścieżką lekcji
* Wyświetl nie oglądaną wcześniej stronę - Strony są wyświetlane w losowej kolejności, ale żadna z nich nie będzie pokazana dwa razy
* Wyświetl stronę, na której nie udzielono jeszcze odpowiedzi - Strony są wyświetlane w losowej kolejności, ale strony zawierające pytania, na które nie udzielono odpowiedzi są wyświetlane ponownie.';
$string['actions'] = 'Operacje';
$string['activitylink'] = 'Link do następnej aktywności';
$string['activitylink_help'] = 'Aby umieścić link, na końcu lekcji, do innej aktywności w ramach kursu, wybierz aktywność z menu rozwijanego.';
$string['activitylinkname'] = 'Idź do {$a}';
$string['activityoverview'] = 'Masz zaplanowane lekcje';
$string['addabranchtable'] = 'Wstaw stronę z treścią';
$string['addanendofbranch'] = 'Wstaw koniec rozgałęzienia';
$string['addanewpage'] = 'Dodaj nową stronę';
$string['addaquestionpage'] = 'Wstaw stronę z pytaniem';
$string['addaquestionpagehere'] = 'Dodaj stronę z pytaniem';
$string['addbranchtable'] = 'Wstaw stronę z treścią';
$string['addcluster'] = 'Wstaw klaster';
$string['addedabranchtable'] = 'Dodano stronę z treścią';
$string['addedanendofbranch'] = 'Dodano koniec rozgałęzienia';
$string['addedaquestionpage'] = 'Dodano stronę pytań';
$string['addedcluster'] = 'Dodano klaster';
$string['addedendofcluster'] = 'Dodano koniec klastra';
$string['addendofbranch'] = 'Dodaj koniec gałęzi';
$string['addendofcluster'] = 'Wstaw koniec klastra';
$string['addessay'] = 'Utwórz stronę z pytaniem typu esej';
$string['addmatching'] = 'Utwórz stronę z pasującym pytaniem';
$string['addmultichoice'] = 'Utwórz stronę z pytaniami wielokrotnego wyboru';
$string['addnewgroupoverride'] = 'Dodaj wyjątek dla grupy';
$string['addnewuseroverride'] = 'Dodaj wyjątek dla użytkownika';
$string['addnumerical'] = 'Utwórz stronę z pytaniem typu numerycznego';
$string['addpage'] = 'Dodaj stronę';
$string['addshortanswer'] = 'Utwórz stronę z krótką odpowiedzią na pytanie';
$string['addtruefalse'] = 'Utwórz stronę z pytaniami typu prawda/fałsz';
$string['allotheranswers'] = 'Wszystkie inne odpowiedzi';
$string['allotheranswersjump'] = 'Wszystkie inne odpowiedzi przeskakują';
$string['allotheranswersscore'] = 'Wszystkie pozostałe odpowiedzi są punktowane';
$string['allowedattempts'] = 'Dozwolone próby na studenta';
$string['allowofflineattempts'] = 'Zezwalaj na rozwiązywanie lekcji offline w aplikacji mobilnej';
$string['allowofflineattempts_help'] = 'Jeśli ta opcja zostanie włączona, użytkownik aplikacji mobilnej będzie mógł pobrać lekcję i przejść ją bez połączenia z internetem (offline). Wszystkie możliwe opcje pytań i poprawne odpowiedzi zostaną również pobrane. Uwaga: nie jest możliwe przechodzenie lekcji offline jeśli ma ona ustalony limit czasowy.';
$string['anchortitle'] = 'Początek głównej zawartości';
$string['and'] = 'ORAZ';
$string['answer'] = 'Odpowiedź';
$string['answeredcorrectly'] = 'odpowiedziano poprawnie.';
$string['answersfornumerical'] = 'Odpowiedzi na pytania numeryczne powinny być parami wartości minimalnych i maksymalnych';
$string['arrangebuttonshorizontally'] = 'Uporządkować przyciski zawartości poziomo?';
$string['attempt'] = 'Próba: {$a}';
$string['attemptheader'] = 'Próba';
$string['attempts'] = 'Podejścia';
$string['attemptsdeleted'] = 'Usunięte podejścia';
$string['attemptsremaining'] = 'Pozostało Ci {$a} prób';
$string['available'] = 'Dostępne od';
$string['averageattempts'] = 'Dozwolone próby na studenta';
$string['averagescore'] = 'Średnia liczba punktów';
$string['averagetime'] = 'Średni czas';
$string['branch'] = 'Zawartość';
$string['branchtable'] = 'Strona z treścią';
$string['cachedef_overrides'] = 'Informacje o nadpisaniu użytkownika i grupy';
$string['cancel'] = 'Anuluj';
$string['cannotfindanswer'] = 'Błąd: nie znaleziono odpowiedzi';
$string['cannotfindattempt'] = 'Błąd: nie znaleziono prób';
$string['cannotfindessay'] = 'Błąd: nie znaleziono eseju';
$string['cannotfindfirstgrade'] = 'Błąd: nie znaleziono ocen';
$string['cannotfindfirstpage'] = 'Nie można znaleźć pierwszej strony';
$string['cannotfindgrade'] = 'Błąd: nie znaleziono ocen';
$string['cannotfindnewestgrade'] = 'Błąd: nie znaleziono najnowszych ocen';
$string['cannotfindnextpage'] = 'Kopia zapasowa lekcji: Nie znaleziono następnej strony!';
$string['cannotfindpagerecord'] = 'Dodaj koniec gałęzi: nie znaleziono rekordu strony';
$string['cannotfindpages'] = 'Nie znaleziono stron w tej lekcji';
$string['cannotfindpagetitle'] = 'Potwierdź usunięcie: nie znaleziono tytułu strony';
$string['cannotfindpreattempt'] = 'Nie znaleziono rekordu poprzedniego podejścia!';
$string['cannotfindrecords'] = 'Błąd: Nie znaleziono rekordów lekcji';
$string['cannotfindtimer'] = 'Błąd: Nie znaleziono rekordów lesson_timer';
$string['cannotfinduser'] = 'Błąd: nie znaleziono użytkowników';
$string['canretake'] = 'Powtórzenie lekcji';
$string['casesensitive'] = 'Użyj wyrażeń regularnych';
$string['casesensitive_help'] = '<p>Niektóre z typów pytań mogą być rozszerzone poprzez wybór opcji pytania za pomocą okienka wyboru (checkbox). Uwagi poniższe odnoszą się do następujących typów pytań: <ol> <li><p><b>Wielokrotny wybór</b> To wariant pytań wielokrotnego wyboru zwany <b>"Wiele dobrych odpowiedzi"</b>. Jeśli opcja ta zostanie wybrana wówczas student musi wskazać wszystkie poprawne odpowiedzi w ramach zestawu odpowiedzi. Pytanie może podpowiedzieć studentowi ile odpowiedzi jest poprawnych n.p. Wskaż dwóch prezydentów USA z poniższej listy. Liczba właściwych odpowiedzi może być minimalnie 1 i maksymalnie tyle ile jest odpowiedzi do zakreślenia. W klasycznym pytaniu wielokrotnego wyboru student wybiera tylko jedną dobrą odpowiedź i tym różni się od tego typu pytań ten wariant.</p></li> <li><p><b>Krótka odpowiedź</b> Domyślnie system ignoruje wielkość liter w odpowiedziach. Jeśli Opcja pytania zostania wybrana, wówczas system będzie sprawdzał użycie liter.</p></li></ol></p> <p>Inne typy pytań nie wykorzystują Opcji pytań.</p>';
$string['checkbranchtable'] = 'Sprawdź stronę z zawartością';
$string['checkedthisone'] = 'Sprawdzono.';
$string['checknavigation'] = 'Sprawdź nawigację';
$string['checkquestion'] = 'Sprawdź pytanie';
$string['classstats'] = 'Statystyka klasy';
$string['clicktodownload'] = 'Kliknij na link, aby pobrać plik.';
$string['closebeforeopen'] = 'Nie można zaktualizować lekcji. Określiłeś datę zamknięcia przed datą otwarcia.';
$string['cluster'] = 'Klaster';
$string['clusterjump'] = 'Nie widziane pytanie w obrębie klastra';
$string['clustertitle'] = 'Nazwa klastra';
$string['collapsed'] = 'Zwinięty';
$string['comments'] = 'Twój komentarz';
$string['completed'] = 'Skończono';
$string['completederror'] = 'Zakończ lekcje';
$string['completethefollowingconditions'] = 'Musisz spełnić wskazane poniżej kryteria w lekcji<b>{$a}</b> aby kontynuować.';
$string['completiondetail:reachend'] = 'Przejdź całą aktywność do końca';
$string['completiondetail:timespent'] = 'Spędź co najmniej {$a} w tej aktywności';
$string['completionendreached'] = 'Wymaga ukończenia';
$string['completionendreached_desc'] = 'Student musi dotrzeć do strony kończącej lekcję aby ukończyć tę aktywność';
$string['completiontimespentdesc'] = 'Student musi wykonywać to ćwiczenie co najmniej {$a} raz(y)';
$string['completiontimespentgroup'] = 'Wymaga określonego czasu wykonywania';
$string['conditionsfordependency'] = 'Warunki ochrony';
$string['configintro'] = 'Wartości ustawione w tym miejscu definiują wartości domyślne, które są używane w formularzu ustawień podczas tworzenia nowej lekcji. Ustawienia określone jako zaawansowane są wyświetlane tylko po kliknięciu łącza „Pokaż więcej ...”.';
$string['configmaxanswers'] = 'Domyślna maksymalna liczba odpowiedzi na jednej stronie';
$string['configmediaclose'] = 'Wyświetl przycisk zamykający okno popup z plikiem multimedialnym';
$string['configmediaheight'] = 'Określ wysokość okna popup z plikiem multimedialnym';
$string['configmediawidth'] = 'Określ szerokość okna popup z plikiem multimedialnym';
$string['configpassword_desc'] = 'Czy wymagane jest hasło, aby uzyskać dostęp do lekcji.';
$string['configslideshowbgcolor'] = 'Kolor tła pokazu slajdów, jeśli jest włączony';
$string['configslideshowheight'] = 'Określ wysokość pokazu slajdów, jeśli jest włączony';
$string['configslideshowwidth'] = 'Określ szerokość pokazu slajdów, jeśli jest włączony';
$string['configtimelimit_desc'] = 'Jeśli ustawiony jest limit czasu, na początku lekcji wyświetlane jest ostrzeżenie i jest zegar odliczający. Jeśli jest ustawiony na zero, nie ma limitu czasu.';
$string['confirmdelete'] = 'Usuń stronę';
$string['confirmdeletionofthispage'] = 'Potwierdź usunięcie tej strony';
$string['congratulations'] = 'Osiągnięto koniec lekcji';
$string['continue'] = 'Kontynuuj';
$string['continuetoanswer'] = 'Kontynuuj zmianę odpowiedzi.';
$string['continuetonextpage'] = 'Kontynuuj do następnej strony.';
$string['correctanswerjump'] = 'Przejdź';
$string['correctanswerscore'] = 'Punkty za poprawną odpowiedź';
$string['correctresponse'] = 'Informacja zwrotna po poprawnej odpowiedzi';
$string['createaquestionpage'] = 'Utwórz stronę z pytaniami';
$string['credit'] = 'Ocena';
$string['customscoring'] = 'Punktacja za pytanie';
$string['customscoring_help'] = 'Jeśli aktywne, każda z odpowiedzi może mieć nadaną inną punktację (dodatnią lub ujemną).';
$string['deadline'] = 'Termin końcowy';
$string['defaultessayresponse'] = 'Twój esej zostanie oceniony przez Twojego nauczyciela.';
$string['deleteallattempts'] = 'Wszystkie podejścia do lekcji';
$string['deletedefaults'] = 'Usuń {$a} x lekcji domyślnie';
$string['deletedpage'] = 'Usuń stronę';
$string['deletepagenamed'] = 'Usuń stronę: {$a}';
$string['deleting'] = 'Usuwanie';
$string['deletingpage'] = 'Usuwanie strony: {$a}';
$string['dependencyon'] = 'W zależności od';
$string['dependencyon_help'] = 'Ten parametr umożliwia ograniczenie dostępu do lekcji, w oparciu o wyniki osiągane przez studenta w innej lekcji w tym samym kursie. Można do tego celu wykorzystać kombinację: czasu spędzonego w lekcji, czy lekcja została ukończona, oraz ustalić minimalną ocenę jaka będzie wymagana.';
$string['description'] = 'Opis';
$string['deselectallattempts'] = 'Odznacz wszystkie próby';
$string['detailedstats'] = 'Szczegółowe statystyki';
$string['didnotanswerquestion'] = 'Nie odpowiedział na pytanie';
$string['didnotreceivecredit'] = 'Nie otrzymał oceny.';
$string['disabled'] = 'Wyłączone';
$string['displaydefaultfeedback'] = 'Wyświetl domyślną informację zwrotną';
$string['displaydefaultfeedback_help'] = 'Jeśli aktywne, w przypadku gdy informacja zwrotna dla danego pytania nie będzie zdefiniowana, zostanie wyświetlony domyślny komunikat: "To jest prawidłowa odpowiedź" lub "To jest nieprawidłowa odpowiedź"';
$string['displayinleftmenu'] = 'Wyświetlić w menu?';
$string['displayleftif'] = 'Wymagany minimalny wynik, aby wyświetlić menu';
$string['displayleftif_help'] = 'Ten parametr wymaga od studenta uzyskania określonej oceny, aby móc zobaczyć menu lekcji z listą stron. Zmusza to studenta do przejścia przez całą lekcję za pierwszym razem. Później, już po osiągnięciu wymaganej oceny, może korzystać z menu do swobodnej nawigacji.';
$string['displayleftmenu'] = 'Wyświetl menu';
$string['displayleftmenu_help'] = 'Jeśli ta opcja jest włączona, wyświetlane jest menu umożliwiające użytkownikom poruszanie się po liście stron.';
$string['displaymode'] = 'Tryb wyświetlania';
$string['displayofgrade'] = 'Wyświetl ocenę studentowi';
$string['displayreview'] = 'Daje możliwość ponownego podejścia do pytania';
$string['displayreview_help'] = '<p>Po niepoprawnej odpowiedzi będzie wyświetlony przycisk, pozwalający na zmianę odpowiedzi. Przycisk nie wyświetli się w przypadku pytania typu esej. </p>';
$string['displayscorewithessays'] = 'Otrzymałeś {$a->score} z {$a->tempmaxgrade} za pytania oceniane automatycznie. Twój {$a->essayquestions} esej zostanie oceniony i punktu zostaną dodane</br> do oceny końcowej później. <br/><br/> Twoja aktualna ocena bez oceny z eseju jest {$a->score} z {$a->grade}';
$string['displayscorewithoutessays'] = 'Liczba Twoich punktów wynosi {$a->score} (z {$a->grade})';
$string['duedate'] = 'Termin wykonania';
$string['duplicatepagenamed'] = 'Powiel stronę: {$a}';
$string['edit'] = 'Edycja';
$string['editbranchtable'] = 'Edycja strony z treścią';
$string['editcluster'] = 'Edycja klastra';
$string['editessay'] = 'Edytowanie strony z pytaniem typu esej';
$string['editinglesson'] = 'Edytuję lekcję';
$string['editingquestionpage'] = 'Edytuj {$a} stronę pytań';
$string['editlesson'] = 'Edytuj lekcję';
$string['editlessonsettings'] = 'Edytuj ustawienia lekcji';
$string['editmatching'] = 'Edytowanie strony z pytaniem typu  dopasowanie';
$string['editmultichoice'] = 'Edytowanie strony z pytaniem typu wybór wielokrotny';
$string['editnumerical'] = 'Edytowanie strony z pytaniem typu numerycznego';
$string['editoverride'] = 'Edytuj nadpisanie';
$string['editpage'] = 'Edytuj zawartość strony';
$string['editpagecontent'] = 'Edytuj zawartość strony';
$string['editquestion'] = 'Edytowanie strony z pytaniem';
$string['editshortanswer'] = 'Edytowanie strony z pytaniem typu krótkiej odpowiedzi';
$string['edittruefalse'] = 'Edytowanie strony z pytaniem typu prawda/fałsz';
$string['email'] = 'E-mail';
$string['emailallgradedessays'] = 'Wyślij powiadomienia z oceną za esej';
$string['emailgradedessays'] = 'Wyślij powiadomienia z oceną za esej';
$string['emailsuccess'] = 'Powiadomienia zostały wysłane';
$string['emptypassword'] = 'Hasło nie może być puste';
$string['enabled'] = 'Włączone';
$string['endofbranch'] = 'Koniec gałęzi';
$string['endofcluster'] = 'Koniec klastra';
$string['endofclustertitle'] = 'Koniec klastra';
$string['endoflesson'] = 'Koniec lekcji';
$string['enteredthis'] = 'wprowadzone.';
$string['enterpassword'] = 'Wprowadź hasło:';
$string['eolstudentoutoftime'] = 'Uwaga: Czas lekcji minął. Twoja ostatnia odpowiedź nie będzie się liczyła jeżeli została wysłana po czasie';
$string['eolstudentoutoftimenoanswers'] = 'Nie odpowiedziałeś na żadne pytanie. Otrzymujesz 0 z tej lekcji.';
$string['essay'] = 'Esej';
$string['essayemailmessage2'] = '<p> Temat eseju: <blockquote> {$a->question} </blockquote></p><p> Twoja odpowiedź: <blockquote> <em>{$a->response}</em> </blockquote></p><p> Komentarz nauczyciela: <blockquote> <em>{$a->comment}</em> </blockquote></p><p> Otrzymałeś {$a->earned} z {$a->outof} możliwych na to pytanie. </p><p> Twoja ocena z lekcji został zmieniony na {$a->newgrade}%. </p>';
$string['essayemailsubject'] = 'Ocena dostępna dla pytania lekcji';
$string['essaynotgradedyet'] = 'Ten esej nie został jeszcze oceniony';
$string['essayresponses'] = 'Odpowiedzi na esej';
$string['essays'] = 'Eseje';
$string['essayscore'] = 'Punkty za esej';
$string['eventcontentpageviewed'] = 'Wyświetlona strona treści';
$string['eventessayassessed'] = 'Esej oceniany';
$string['eventessayattemptviewed'] = 'Wyświetlona próba napisania eseju';
$string['eventhighscoreadded'] = 'Dodano wynik lekcji';
$string['eventhighscoresviewed'] = 'Wyświetlone najlepsze wyniki lekcji';
$string['eventlessonended'] = 'Lekcja zakończona';
$string['eventlessonrestarted'] = 'Lekcja uruchomiona ponownie';
$string['eventlessonresumed'] = 'Lekcja wznowiona';
$string['eventlessonstarted'] = 'Lekcja uruchomiona';
$string['eventoverridecreated'] = 'Utworzono nadpisanie lekcji';
$string['eventoverridedeleted'] = 'Usunięto nadpisanie lekcji';
$string['eventoverrideupdated'] = 'Zaktualizowano nadpisanie lekcji';
$string['eventpagecreated'] = 'Strona utworzona';
$string['eventpagedeleted'] = 'Strona usunięta';
$string['eventpagemoved'] = 'Strona przeniesiona';
$string['eventpageupdated'] = 'Strona znaktualizowana';
$string['eventquestionanswered'] = 'Odpowiedź na pytanie';
$string['eventquestionviewed'] = 'Wyświetlone pytanie';
$string['false'] = 'Fałsz';
$string['fileformat'] = 'Format pliku';
$string['finalwrong'] = 'Nie do końca.';
$string['finish'] = 'Koniec';
$string['firstanswershould'] = 'Pierwsza odpowiedź powinna przenieść do strony odpowiedniej dla prawidłowej odpowiedzi';
$string['firstwrong'] = 'Odpowiedziałeś niepoprawnie. Czy chcesz odpowiedzieć ponownie na to pytanie? (Jeśli teraz odpowiesz poprawnie, nie będzie się to liczyć do Twojego końcowego wyniku)';
$string['flowcontrol'] = 'Kontrola przebiegu lekcji';
$string['fractionsaddwrong'] = 'Wybrane odpowiedzi pozytywne nie sumują się do 100% <br />Teraz sumują się do {$a}% <br />Czy chcesz wrócić i poprawić pytanie?';
$string['fractionsnomax'] = 'Jedna z odpowiedzi powinna być warta 100% tak,<br />aby można było uzyskać maksymalną ocenę za to pytanie.<br />Czy chcesz wrócić i poprawić pytanie?';
$string['full'] = 'Rozszerzony';
$string['general'] = 'Ogólny';
$string['gotoendoflesson'] = 'Przejdź do końca lekcji';
$string['gradebetterthan'] = 'Ocena wyższa niż (%)';
$string['gradebetterthanerror'] = 'Uzyskaj wynik lepszy niż {$a} procent';
$string['graded'] = 'Ocenione';
$string['gradeessay'] = 'Oceny za esej ({$a->notgradedcount} nieocenionych {$a->notsentcount} niewysłanych)';
$string['gradeis'] = 'Ocena: {$a}';
$string['gradeoptions'] = 'Opcje oceniania';
$string['groupoverrides'] = 'Wyjątki dla grupy';
$string['groupoverridesdeleted'] = 'Usunięto wyjątki dla grupy';
$string['groupsnone'] = 'Brak grup, do których masz dostęp.';
$string['handlingofretakes'] = 'Ocenianie wielu podejść';
$string['handlingofretakes_help'] = '<p>Jeśli student może robić poprawki, nauczyciel może wybrać jako ocenę końcową średnią z wszystkich prób lub najlepszy wynik.</p> <p>Opcja ta może być zmieniona w dowolnym momencie.</p>';
$string['havenotgradedyet'] = 'Jeszcze nie oceniono';
$string['here'] = 'tutaj';
$string['highscore'] = 'Najwyższa ocena';
$string['hightime'] = 'Najdłuższy czas';
$string['importcount'] = 'Importuj {$a} pytań';
$string['importquestions'] = 'Importuj pytania';
$string['importquestions_help'] = 'Ta funkcjonalność pozwala na import wielu typów pytań z pliku tekstowego.';
$string['inactiveoverridehelp'] = '* To nadpisanie jest nieaktywne, ponieważ dostęp użytkownika do aktywności jest ograniczony. Może to być spowodowane przypisaniem do grupy lub roli, innymi ograniczeniami dostępu lub ukryciem aktywności.';
$string['indicator:cognitivedepth'] = 'Poznawczość Lekcji';
$string['indicator:cognitivedepth_help'] = 'Ten wskaźnik opiera się na głębi poznawczej osiągniętej przez studenta podczas korzystania z aktywności Lekcji.';
$string['indicator:cognitivedepthdef'] = 'Poznawczość Lekcji';
$string['indicator:cognitivedepthdef_help'] = 'Uczestnik osiągnął określony procent zaangażowania poznawczego oferowanego przez aktywność Lekcji w tym okresie analizy (Poziomy = Brak wyświetlenia, Wyświetlenie, Wysłanie, Wyświetlenie informacji zwrotnej, Skomentowanie informacji zwrotnej, Ponowne wysłanie po zapoznaniu się z informacją zwrotną)';
$string['indicator:cognitivedepthdef_link'] = 'Learning_analytics_indicators#Cognitive_depth';
$string['indicator:socialbreadth'] = 'Lekcja społeczna';
$string['indicator:socialbreadthdef'] = 'Lekcja społeczna';
$string['indicator:socialbreadthdef_link'] = 'Learning_analytics_indicators#Social_breadth';
$string['insertedpage'] = 'Wstawiona strona';
$string['invalidfile'] = 'Niepoprawny plik';
$string['invalidid'] = 'Ani ID modułu kursu, ani ID lekcji nie zostały przekazane';
$string['invalidlessonid'] = 'ID lekcji była błędne';
$string['invalidoverrideid'] = 'Nieprawidłowy identyfikator wyjątku';
$string['invalidpageid'] = 'Nieprawidłowy ID strony';
$string['jump'] = 'Przejdź';
$string['jumps'] = 'Przejścia';
$string['jumps_help'] = 'Każda z odpowiedzi (na pytanie) lub opis (strony z tekstem) ma przypisany cel przejścia. Cel ten może być względny (np. \'ta strona\' lub \'następna strona\'), lub bezwzględny - do określonej strony w lekcji.';
$string['jumpsto'] = 'Przejścia do <em>{$a}</em>';
$string['leftduringtimed'] = 'Opuściłeś lekcję ograniczoną czasowo.<br/>Kliknij \'Kontynuuj\', żeby zacząć lekcję od nowa.';
$string['leftduringtimednoretake'] = 'Opuściłeś lekcję ograniczoną czasowo i nie możesz jej powtórzyć.';
$string['leftduringtimedsession'] = 'Opuściłaś/eś lekcję na czas.';
$string['lesson:addinstance'] = 'Dodaj nową lekcję';
$string['lesson:edit'] = 'Edytuj lekcję';
$string['lesson:grade'] = 'Oceń pytania esejowe na lekcji';
$string['lesson:manage'] = 'Zarządzaj lekcją';
$string['lesson:manageoverrides'] = 'Zarządzaj wyjątkami w lekcji';
$string['lesson:view'] = 'Zobacz lekcję';
$string['lesson:viewreports'] = 'Zobacz raporty lekcji';
$string['lessonbeingpreviewed'] = 'Aktualnie trwa podgląd lekcji.';
$string['lessonclosed'] = 'Ta lekcja zakończyła się {$a}';
$string['lessoncloses'] = 'Lekcja zamknięta';
$string['lessoneventcloses'] = '{$a} zamyka się';
$string['lessoneventopens'] = '{$a} otwiera się';
$string['lessonformating'] = 'Formatuj lekcje';
$string['lessonmenu'] = 'Menu lekcji';
$string['lessonnotready'] = 'Ta lekcja nie jest gotowa do rozwiązania. Prosze skontaktować się ze swoim {$a}.';
$string['lessonnotready2'] = 'Ta lekcja nie jest gotowa do nauki.';
$string['lessonopen'] = 'Lekcja rozpocznie się {$a}.';
$string['lessonopens'] = 'Lekcja rozpoczęta';
$string['lessonpagelinkingbroken'] = 'Nie znaleziono strony startowej. Link do strony z lekcją jest niepoprawny. Proszę skontaktować się z administratorem.';
$string['lessonstats'] = 'Statystyka lekcji';
$string['linkedmedia'] = 'Dołączone media';
$string['loginfail'] = 'Błąd logowania, spróbuj ponownie';
$string['lowscore'] = 'Najniższa ocena';
$string['lowtime'] = 'Najkrótszy czas';
$string['manageoverrides'] = 'Zarządzaj nadpisaniami';
$string['manualgrading'] = 'Oceń eseje';
$string['matchesanswer'] = 'Pasujące z odpowiedzią';
$string['matching'] = 'Dopasowywanie';
$string['matchingpair'] = 'Dopasuj pary {$a}';
$string['maxgrade'] = 'Maksymalna ocena';
$string['maxgrade_help'] = 'Ten parametr określa maksymalną ocenę za lekcję. Jeśli ustawiony na 0, nie będzie widoczny w dzienniku ocen.';
$string['maximumnumberofanswersbranches'] = 'Maksymalna liczba odpowiedzi';
$string['maximumnumberofanswersbranches_help'] = 'Ten parametr określa maksymalną liczbę wyborów odpowiedzi dostępnych w pytaniach umieszczanych w lekcji. Jeśli używane są tylko pytania typu prawda/fałsz, wówczas można tę wartość ustawić na 2. Parametr można dostosować w dowolnej chwili, gdyż określa on jedynie zakres pola widzenia nauczyciela, bez wpływu na same dane.';
$string['maximumnumberofattempts'] = 'Maksymalna liczba podejść do pytania';
$string['maximumnumberofattempts_help'] = 'Ten parametr określa maksymalną liczbę dopuszczalnych podejść do każdego z pytań.
Jeśli student udziela niepoprawnych odpowiedzi na pytanie, po przekroczeniu tego limitu wyświetli się następna strona w lekcji.';
$string['maximumnumberofattemptsreached'] = 'Osiągnięto maksymalną liczbę prób - przejdź do następnej strony';
$string['mediaclose'] = 'Pokaż przycisk zamknij';
$string['mediafile'] = 'Wstaw wyskakujące okienko z plikiem lub stroną WWW';
$string['mediafile_help'] = 'Aby na początku lekcji wyświetlić okno popup, wybierz plik do wyświetlenia. Dodatkowo na każdej ze stron lekcji znajdzie się link do ponownego otworzenia tego okna popup.';
$string['mediafilepopup'] = 'Kliknij tutaj aby wyświetlić';
$string['mediaheight'] = 'Wysokość wyskakującego okna';
$string['mediawidth'] = 'Szerokość wyskakującego okna';
$string['messageprovider:graded_essay'] = 'Powiadomienie o ocenionym eseju';
$string['minimumnumberofquestions'] = 'Minimalna liczba pytań';
$string['minimumnumberofquestions_help'] = 'Ustawienie to określa minimalną liczbę pytań, które będą używane do obliczania ocen dla aktywności.';
$string['missingname'] = 'Podaj nick';
$string['modattempts'] = 'Pozwól studentom na ponowny wgląd w odpowiedzi';
$string['modattempts_help'] = '<p> Można pozwolić studentowi na ponowny wgląd w odpowiedzi</p>';
$string['modattemptsnoteacher'] = 'Tylko student może zmieniać pracę.';
$string['modulename'] = 'Lekcja';
$string['modulename_help'] = '<P>Lekcja pozwala na przedstawienie treści w interesujący sposób na wielu stronach.
Każda strona zwykle kończy się pytaniem i kilkoma odpowiedziami. W zależności od
postępów studenta, albo idzie on do przodu z materiałem, albo jest cofany.
Nawigacja lekcji może być albo uproszczona ale może też być dużo bardziej
skomplikowana w zależności od struktury materiału lekcyjnego.</P>';
$string['modulename_link'] = 'mod/lesson/view';
$string['modulenameplural'] = 'Lekcje';
$string['move'] = 'Przenieś stronę';
$string['movedpage'] = 'Przesunięto stronę';
$string['movepagehere'] = 'Przesuń stronę tutaj';
$string['movepagenamed'] = 'Strona przeniesiona: {$a}';
$string['moving'] = 'Przesuwanie strony: {$a}';
$string['multianswer'] = 'Wielokrotny wybór';
$string['multianswer_help'] = '<p>Niektóre z typów pytań mogą być rozszerzone poprzez wybór opcji pytania za pomocą okienka wyboru (checkbox). Uwagi poniższe odnoszą się do następujących typów pytań: <ol> <li><p><b>Wielokrotny wybór</b> To wariant pytań wielokrotnego wyboru zwany <b>&quot;Wiele dobrych odpowiedzi&quot;</b>. Jeśli opcja ta zostanie wybrana wówczas student musi wskazać wszystki poprawne odpowiedzi w ramach zestawu odpowiedzi. Pytanie może podpowiedzieć studentowi ile odpowiedzi jest poprawnych n.p. Wskaż dwóch prezedyentów USA z poniższej listy. Liczba właściwych odpowiedzi może być minimalnie 1 i maksymalnie tyle ile jest odpowiedzi do zakreślenia. W klasycznym pytaniu wielokrotnego wyboru student wybiera tylko jedną dobrą odpowiedĽ i tym różni się od tego typu pytań ten wariant.</p></li> <li><p><b>Krótka odpowiedĽ</b> Domyślnie system ignoruje wielkość liter w odpowiedziach. Jeśli Opcja pytania zostania wybrana, wówczas system będzie sprawdzał użycie liter.</p></li></ol></p> <p>Inne typy pytań nie wykorzystują Opcji pytań.</p>';
$string['multichoice'] = 'Wielokrotny wybór';
$string['multipleanswer'] = 'Wielokrotne odpowiedzi';
$string['nameapproved'] = 'Wprowadzono nazwę';
$string['namereject'] = 'Nazwa wprowadzona przez Ciebie jest na liście słów zakazanych. Wprowadź inną nazwę.';
$string['new'] = 'nowa';
$string['nextpage'] = 'Następna strona';
$string['noanswer'] = 'Co najmniej jedno pytanie jest bez odpowiedzi. Wróć do pytań i podaj odpowiedzi.';
$string['noattemptrecordsfound'] = 'Brak prób: nie przyznano oceny';
$string['nobranchtablefound'] = 'Nie znaleziono strony z zawartością';
$string['noclose'] = 'Brak daty zakończenia';
$string['nocommentyet'] = 'Brak komentarzy';
$string['nocoursemods'] = 'Nie znaleziono aktywności';
$string['nocredit'] = 'Bez oceny';
$string['nodeadline'] = 'Brak ostatecznego terminu ';
$string['noessayquestionsfound'] = 'W tej lekcji nie odnaleziono pytań typu \'esej\'';
$string['nohighscores'] = 'Brak najlepszych wyników';
$string['nolessonattempts'] = 'Nikt jeszcze nie rozwiązał tej lekcji.';
$string['nolessonattemptsgroup'] = 'Członkowie grupy {$a} nie podjęli prób w tej lekcji.';
$string['none'] = 'Żaden';
$string['nooneansweredcorrectly'] = 'Brak poprawnych odpowiedzi';
$string['nooneansweredthisquestion'] = 'Brak odpowiedzi na to pytanie';
$string['noonecheckedthis'] = 'Nikt tego nie zaznaczył';
$string['nooneenteredthis'] = 'Nikt tego nie wprowadził';
$string['noonehasanswered'] = 'Nikt nie odpowiedział jeszcze na pytanie \'esej\'';
$string['noonehasansweredgroup'] = 'Nikt w {$a} nie odpowiedział jeszcze na pytanie w eseju.';
$string['noopen'] = 'Brak daty otwarcia';
$string['nooverridecreated'] = 'Nie utworzono żadnych wyjątków.';
$string['nooverridedata'] = 'Musisz nadpisać co najmniej jedno z ustawień lekcji.';
$string['noretake'] = 'Nie możesz powtórnie przejrzeć lekcji.';
$string['normal'] = 'Normalnie - idź zgodnie z trybem lekcji';
$string['notcompleted'] = 'Niekompletne';
$string['notcompletedwithdate'] = 'Nie ukończono ({$a})';
$string['notdefined'] = 'Brak definicji';
$string['notenoughsubquestions'] = 'Nie zdefiniowano wystarczającej liczby podpunktów pytań! <br /> Czy chcesz wrócić i poprawić pytanie?';
$string['notenoughtimespent'] = 'Zakończyłeś tę lekcję w {$a->timespent}, co stanowi mniej niż wymagany czas {$a->timerequired}. Możliwe, że musisz przystąpić do lekcji ponownie.';
$string['notgraded'] = 'Nieocenione';
$string['notitle'] = 'Brak tytułu';
$string['notyetcompleted'] = 'Lekcja została rozpoczęta, ale jeszcze nie jest ukończona';
$string['numberofcorrectanswers'] = 'Liczba poprawnych odpowiedzi: {$a}';
$string['numberofcorrectanswersheader'] = 'Liczba poprawnych odpowiedzi';
$string['numberofcorrectmatches'] = 'Liczba poprawnych połączeń: {$a}';
$string['numberofpagestoshow'] = 'Liczba stron do wyświetlenia';
$string['numberofpagestoshow_help'] = '<p>Ten parametr stosuje się tylko do lekcji typu Flash Card. Domyślna wartość to 0, co oznacza, że wszystkie
strony (karty) są widoczne. Wskazanie liczby wyższej niż 0 wyświetli żądaną liczbę stron. Po wyświetleniu
żądanej liczby stron, nastąpi zakończenie lekcji i student zobaczy swoją ocenę.</p>

<p>Jeśli ten parametr zostanie ustawiony na wartość wyższą niż
liczba stron danej lekcji, wówczas koniec lekcji nastąpi po pokazaniu wszystkich stron.</p>';
$string['numberofpagesviewed'] = 'Liczba pytań z odpowiedziami: {$a}';
$string['numberofpagesviewedheader'] = 'Liczba pytań, na które udzielono odpowiedzi';
$string['numberofpagesviewednotice'] = 'Liczba pytań z odpowiedziami: {$a->nquestions}; (powinieneś odpowiedzieć na przynajmniej {$a->minquestions})';
$string['numerical'] = 'Numeryczne';
$string['numericanswer'] = 'Odpowiedź numeryczna';
$string['numericanswer_help'] = 'Można określić pojedynczą liczbę lub zakres liczb, używając dwukropka. Na przykład 2:5 oznacza, że każda odpowiedź od 2 do 5, w tym 2 do 5, jest prawidłowa.';
$string['offlinedatamessage'] = 'Pracowałeś nad tą próbą używając urządzenia mobilnego. Dane zostały ostatnio zapisane na tej stronie {$a} temu. Sprawdź, czy nie masz żadnej niezapisanej pracy.';
$string['ongoing'] = 'Wyświetlaj bieżący wynik w trakcie rozwiązywania lekcji';
$string['ongoing_help'] = 'Jeśli aktywne, na każdej stronie będzie wyświetlana liczba zdobytych do tej pory punktów, w odniesieniu do wszystkich możliwych do zdobycia.';
$string['ongoingcustom'] = 'Otrzymałeś dotąd {$a->score} punktów z {$a->currenthigh}';
$string['ongoingnormal'] = 'Odpowiedziałeś poprawnie na {$a->correct} z {$a->viewed} pytań';
$string['onpostperpage'] = 'Tylko jeden wpis na jedną ocenę';
$string['openafterclose'] = 'Podałeś datę otwarcia po dacie zamknięcia';
$string['options'] = 'Opcje';
$string['or'] = 'LUB';
$string['ordered'] = 'Poukładane';
$string['other'] = 'Inne';
$string['outof'] = 'Z {$a}';
$string['override'] = 'Nadpisz';
$string['overridedeletegroupsure'] = 'Czy na pewno chcesz usunąć nadpisanie dla grupy {$a}?';
$string['overridedeleteusersure'] = 'Czy na pewno chcesz usunąć nadpisanie dla użytkownika {$a}?';
$string['overridegroup'] = 'Nadpisz grupę';
$string['overridegroupeventname'] = '{$a->lesson} - {$a->group}';
$string['overrides'] = 'Wyjątki';
$string['overrideuser'] = 'Nadpisz użytkownika';
$string['overrideusereventname'] = '{$a->lesson} - nadpisane';
$string['overview'] = 'Skrócony';
$string['overview_help'] = 'Lekcja składa się ze stron, gdzie niektóre mogą być wyświetlane tylko w określonych sytuacjach. Strona zawiera treść, oraz przeważnie kończy się pytaniem. Do każdej odpowiedzi na pytanie przyporządkowane jest przejście do innej strony. Przejście to może być względne np: \'poprzednia strona\' lub \'następna strona\', może być też bezwzględne - prowadzić dokładnie do wybranej strony w lekcji.';
$string['page'] = 'Strona: {$a}';
$string['page-mod-lesson-edit'] = 'Edytuj stronę lekcji';
$string['page-mod-lesson-view'] = 'Wyświetl podgląd strony lekcji';
$string['page-mod-lesson-x'] = 'Na każdej stronie lekcji';
$string['pageanswers'] = 'Strona odpowiedzi';
$string['pagecontents'] = 'Zawartość strony';
$string['pageresponses'] = 'Strona odpowiedzi';
$string['pages'] = 'Strony';
$string['pagetitle'] = 'Tytuł strony';
$string['password'] = 'Hasło';
$string['passwordprotectedlesson'] = '{$a} jest chroniona hasłem.';
$string['pleasecheckoneanswer'] = 'Proszę sprawdź jedną odpowiedź';
$string['pleasecheckoneormoreanswers'] = 'Sprawdź jedną lub więcej odpowiedzi';
$string['pleaseenteryouranswerinthebox'] = 'Proszę wpisz swoją odpowiedź w polu';
$string['pleasematchtheabovepairs'] = 'Połącz powyższe pary';
$string['pluginadministration'] = 'Administracja lekcją';
$string['pluginname'] = 'Lekcja';
$string['pointsearned'] = 'Zdobyte punkty';
$string['postprocesserror'] = 'Podczas przetwarzania końcowego wystąpił błąd!';
$string['postsuccess'] = 'Przesłano';
$string['practice'] = 'Lekcja ćwiczeniowa';
$string['practice_help'] = 'Lekcja ćwiczeniowa nie jest widoczna w dzienniku ocen.';
$string['preprocesserror'] = 'Wystąpił błąd podczas przetwarzania wstępnego!';
$string['prerequisitelesson'] = 'Warunek przystąpienia do lekcji';
$string['preview'] = 'Podgląd';
$string['previewlesson'] = 'Podgląd {$a}';
$string['previewpagenamed'] = 'Wyświetl stronę: {$a}';
$string['previouspage'] = 'Poprzednia strona';
$string['privacy:metadata:attempts:answerid'] = 'Identyfikator odpowiedzi';
$string['privacy:metadata:attempts:pageid'] = 'Identyfikator strony';
$string['privacy:metadata:attempts:retry'] = 'Numer próby';
$string['privacy:metadata:attempts:timeseen'] = 'Czas podjęcia próby';
$string['privacy:metadata:attempts:useranswer'] = 'Szczegóły dotyczące odpowiedzi użytkownika';
$string['privacy:metadata:attempts:userid'] = 'Identyfikator użytkownika';
$string['privacy:metadata:branch:nextpageid'] = 'Identyfikator następnej strony';
$string['privacy:metadata:branch:pageid'] = 'Identyfikator strony';
$string['privacy:metadata:branch:retry'] = 'Numer próby';
$string['privacy:metadata:branch:timeseen'] = 'Czas wyświetlenia strony';
$string['privacy:metadata:branch:userid'] = 'Identyfikator użytkownika';
$string['privacy:metadata:grades'] = 'Zapis ocen z każdej lekcji';
$string['privacy:metadata:grades:completed'] = 'Data wystawienia oceny';
$string['privacy:metadata:grades:grade'] = 'Wystawiona ocena';
$string['privacy:metadata:grades:userid'] = 'Identyfikator użytkownika';
$string['privacy:metadata:overrides:available'] = 'Moment, w którym można podjąć próbę lekcji';
$string['privacy:metadata:overrides:deadline'] = 'Termin zakończenia lekcji.';
$string['privacy:metadata:overrides:maxattempts'] = 'Maksymalna liczba prób';
$string['privacy:metadata:overrides:password'] = 'Hasło dostępu do lekcji';
$string['privacy:metadata:overrides:retake'] = 'Czy powtórki są dozwolone?';
$string['privacy:metadata:overrides:review'] = 'Czy ponowna próba pytania jest dozwolona';
$string['privacy:metadata:overrides:timelimit'] = 'Czas na ukończenie lekcji w sekundach.';
$string['privacy:metadata:overrides:userid'] = 'Identyfikator użytkownika';
$string['privacy:metadata:timer:userid'] = 'Identyfikator użytkownika';
$string['privacy:path:pages'] = 'Strony';
$string['processerror'] = 'Wystąpił błąd podczas przetwarzania!';
$string['progressbar'] = 'Pasek postępu';
$string['progressbar_help'] = 'Jeśli aktywne, pasek postępu wyświetlany jest na dole strony, pokazując ile procent lekcji zostało ukończonych';
$string['progressbarteacherwarning'] = 'Pasek postępu nie jest wyświetlany dla  {$a}';
$string['progressbarteacherwarning2'] = 'Nie zobaczysz wskaźnika postępu, ponieważ możesz edytować tę lekcję.';
$string['progresscompleted'] = 'Masz za sobą {$a}% lekcji';
$string['qtype'] = 'Typ strony';
$string['question'] = 'Pytanie';
$string['questionoption'] = 'Opcja pytania';
$string['questiontype'] = 'Typ pytania';
$string['randombranch'] = 'losuj strony z zawartością';
$string['randompageinbranch'] = 'losuj pytania w obrębie stron z zawartością';
$string['rank'] = 'Pozycja';
$string['rawgrade'] = 'Surowa (nieprzeliczona) ocena';
$string['receivedcredit'] = 'Otrzymany kredyt';
$string['redisplaypage'] = 'Ponownie wyświetl stronę';
$string['removeallgroupoverrides'] = 'Wszystkie wyjątki grupy';
$string['removealluseroverrides'] = 'Wszystkie wyjątki użytkownika';
$string['report'] = 'Raport';
$string['reports'] = 'Raporty';
$string['response'] = 'Informacja zwrotna';
$string['retakesallowed'] = 'Ponowne podejścia dozwolone';
$string['retakesallowed_help'] = 'Jeśli aktywne, student może podejść do tej lekcji więcej niż jeden raz.';
$string['returnto'] = 'Powróć do {$a}';
$string['returntocourse'] = 'Powrót do kursu';
$string['reverttodefaults'] = 'Przywróć domyślne ustawienia lekcji';
$string['review'] = 'Przegląd';
$string['reviewlesson'] = 'Przejrzyj lekcję';
$string['reviewquestionback'] = 'Tak, chcę spróbować ponownie';
$string['reviewquestioncontinue'] = 'Nie, chcę kontynuować';
$string['sanitycheckfailed'] = 'Ta próba została usunięta!';
$string['save'] = 'Zapisz';
$string['savechanges'] = 'Zapisz zmiany';
$string['savechangesandeol'] = 'Zachowaj wszystkie zmiany i przejdź na koniec lekcji';
$string['saveoverrideandstay'] = 'Zapisz i wprowadzić kolejne nadpisanie';
$string['savepage'] = 'Zapisz stronę';
$string['score'] = 'Wynik';
$string['score_help'] = 'Jeśli w ustawieniach lekcji włączona jest opcja punktacji niestandardowej, dla każdej odpowiedzi można wpisać wartość całkowitą (dodatnią lub ujemną).';
$string['scores'] = 'Wyniki';
$string['search:activity'] = 'Lekcja - informacja o aktywności';
$string['secondpluswrong'] = 'Niezupełnie. Chcesz spróbować ponownie?';
$string['selectallattempts'] = 'Wybierz wszystkie próby';
$string['selectaqtype'] = 'Wybierz typ pytania';
$string['selectreport'] = 'Wybierz raport';
$string['sent'] = 'Wysłane';
$string['shortanswer'] = 'Krótka odpowiedź';
$string['showanunansweredpage'] = 'Wyświetl stronę w której nie udzielono odpowiedzi';
$string['showanunseenpage'] = 'Pokaż stronę niewidzianą wcześniej';
$string['singleanswer'] = 'Pojedyncza odpowiedź';
$string['skip'] = 'Pomiń nawigację';
$string['slideshow'] = 'Pokaz slajdów';
$string['slideshow_help'] = 'Jeśli aktywne, lekcja wyświetlana jest jako pokaz slajdów o sztywno ustalonych rozmiarach.';
$string['slideshowbgcolor'] = 'Tło pokazu slajdów';
$string['slideshowheight'] = 'Wysokość pokazu slajdów';
$string['slideshowwidth'] = 'Szerokość pokazu slajdów';
$string['startlesson'] = 'Zacznij lekcję';
$string['studentattemptlesson'] = '{$a->lastname}, {$a->firstname} podejście nr {$a->attempt}';
$string['studentname'] = '{$a} Imię';
$string['studentoneminwarning'] = 'Ostrzeżenie: Została niecała minuta do końca lekcji.';
$string['studentoutoftimeforreview'] = 'Uwaga: skończył Ci się czas na powtórzenie tej lekcji';
$string['studentresponse'] = 'odpowiedź {$a}';
$string['submit'] = 'Prześlij';
$string['submitname'] = 'Zatwierdź nazwę';
$string['teacherjumpwarning'] = 'Skoki typu {$a->cluster} lub {$a->unseen} są używane w tej lekcji. Zamiast tego stosowany będzie skok do następnej strony. Zaloguj się jako student, żeby przetestować te przejścia.';
$string['teacherongoingwarning'] = 'Bieżący wynik jest pokazywany tylko studentowi. Zaloguj się jako student aby to sprawdzić.';
$string['teachertimerwarning'] = 'Licznik czasu działa tylko dla studentów, Aby przetestować, zaloguj się jako student.';
$string['thatsthecorrectanswer'] = 'To jest poprawna odpowiedź';
$string['thatsthewronganswer'] = 'To jest błędna odpowiedź';
$string['thefollowingpagesjumptothispage'] = 'Następujące strony prowadzą do tej strony';
$string['thispage'] = 'Ta strona';
$string['timeisup'] = 'Czas minął';
$string['timelimit'] = 'Limit czasu';
$string['timelimitwarning'] = 'Musisz {$a} aby ukończyć lekcje.';
$string['timeremaining'] = 'Pozostały czas';
$string['timespenterror'] = 'Poświęć tej lekcji przynajmniej {$a} minut';
$string['timespentminutes'] = 'Spędzony czas (w minutach)';
$string['timetaken'] = 'Łączny czas';
$string['totalattepmts'] = 'Łączna liczba prób';
$string['totalpagesviewedheader'] = 'Liczba wyświetlonych stron';
$string['true'] = 'Prawda';
$string['truefalse'] = 'Prawda / Fałsz';
$string['unabledtosavefile'] = 'Przesłany plik nie może zostać zapisany';
$string['unknownqtypesnotimported'] = '{$a} pytań o nieobsługiwanym typie nie zostało zaimportowanych';
$string['unseenpageinbranch'] = 'Niewyświetlane dotąd pytanie w treści strony';
$string['unsupportedqtype'] = 'Nie wspierany typ pytania ({$a})!';
$string['updatedpage'] = 'Uaktualniono stronę';
$string['updatefailed'] = 'Błąd';
$string['updatepagenamed'] = 'Zaktualizuj stronę: {$a}';
$string['usemaximum'] = 'Użyj maksimum';
$string['usemean'] = 'Użyj średniej';
$string['usepassword'] = 'Lekcja chroniona hasłem';
$string['usepassword_help'] = 'Jeśli aktywne, aby wejść do lekcji należy podać hasło.';
$string['useroverrides'] = 'Wyjątki dla użytkownika';
$string['useroverridesdeleted'] = 'Usunięto wyjątki dla użytkownika';
$string['usersnone'] = 'Żaden student nie ma dostępu do tej lekcji';
$string['view'] = 'Wyświetl';
$string['viewgrades'] = 'Pokaż oceny';
$string['viewreports'] = 'Zobacz {$a->attempts} zakończonych podejść studenta {$a->student}';
$string['viewreports2'] = 'Zobacz {$a} zakończonych prób';
$string['warning'] = 'Ostrzeżenie';
$string['welldone'] = 'Dobra robota!';
$string['whatdofirst'] = 'Co chcesz zrobić najpierw?';
$string['withselectedattempts'] = 'Z wybranymi próbami...';
$string['wronganswerjump'] = 'Przejdź';
$string['wronganswerscore'] = 'Punkty za złą odpowiedź';
$string['wrongresponse'] = 'Informacja zwrotna po złej odpowiedzi';
$string['youhaveseen'] = 'Widziałeś już więcej niż jedną stronę tej lekcji. <br />Czy chciałbyś zacząć od ostatniej strony, którą przeglądałeś?';
$string['youranswer'] = 'Twoja odpowiedź';
$string['yourcurrentgradeis'] = 'Twoja aktualna ocena to {$a}';
$string['yourcurrentgradeisoutof'] = 'Masz obecnie {$a->grade} punktów z {$a->total}';
$string['youshouldview'] = 'Powinieneś odpowiedzieć na co najmniej: {$a}';
