<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'grades', language 'pl', version '5.1'.
 *
 * @package     grades
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['activities'] = 'Aktywności';
$string['addcategory'] = 'Dodaj kategorię';
$string['addcategoryerror'] = 'Nie można dodać kategorii';
$string['addexceptionerror'] = 'Błąd podczas dodawania wyjątku dla userid:gradeitem';
$string['addfeedback'] = 'Dodaj informację zwrotną';
$string['addgradeletter'] = 'Dodaj nazwę oceny';
$string['addidnumbers'] = 'Dodaj numery identyfikacyjne';
$string['additem'] = 'Dodaj oceniany element';
$string['additionalfeedback'] = 'Dodatkowa informacja zwrotna';
$string['addoutcome'] = 'Dodaj efekt uczenia się';
$string['addoutcomeitem'] = 'Dodaj pozycje efektu uczenia się';
$string['addscale'] = 'Dodaj skalę';
$string['adjustedweight'] = 'Waga zmodyfikowana';
$string['aggregateextracreditmean'] = 'Średnia ocen (z dodatkowymi punktami)';
$string['aggregatemax'] = 'Najwyższa ocena';
$string['aggregatemean'] = 'Średnia ocen';
$string['aggregatemedian'] = 'Mediana ocen';
$string['aggregatemin'] = 'Najniższa ocena';
$string['aggregatemode'] = 'Dominanta (wartość najczęstsza)';
$string['aggregatenotonlygraded'] = 'Uwzględnij puste oceny';
$string['aggregateonlygraded'] = 'Pomiń puste pozycje oceny';
$string['aggregateonlygraded_help'] = 'W dzienniku ocen mogą znajdować się pozycje niewypełnione. Mogą to być zadania jeszcze nie ocenione lub testy, których jeszcze nie rozwiązano.
To opcja określa, czy puste oceny mają nie być uwzględniane w podsumowaniu lub czy mają być liczone jako minimalne oceny, np. jako 0 jeśli skala oceniania to 0-100.';
$string['aggregateoutcomes'] = 'Uwzględnij efekty uczenia się w podsumowaniu';
$string['aggregateoutcomes_help'] = 'Jeśli włączone, efekty uczenia się będą uwzględnione w podsumowaniu. Może to spowodować nieoczekiwaną sumę punktów w kategorii.';
$string['aggregatesonly'] = 'Tylko oceny wynikowe';
$string['aggregatesubcatsupgradedgrades'] = 'Uwaga: Ustawienie agregacji "Agreguj łącznie z podkategoriami" zostało usunięte w ramach aktualizacji witryny. Ponieważ opcja "Agreguj, w tym podkategorie" była wcześniej używana w tym kursie, zaleca się sprawdzenie tej zmiany w dzienniku ocen.';
$string['aggregatesum'] = 'Suma ocen';
$string['aggregateweightedmean'] = 'Średnia ważona ocen';
$string['aggregateweightedmean2'] = 'Prosta średnia ważona ocen';
$string['aggregation'] = 'Zestawienie';
$string['aggregation_help'] = '* suma ocen - suma wszystkich ocen liczbowych z uwzględnieniem ich wagSposób agregacji (wyliczania oceny wynikowej) określa, w jaką metodą wyznacza się ocenę wynikową:

* średnia ocen - suma wszystkich ocen podzielona przez ich liczbę
* mediana ocen - wartość środkowa, ocena znajdująca się w połowie ciągu po jego posortowaniu
* najniższa ocena
* najwyższa ocena
* dominanta (wartość najczęstsza)
* suma ocen - suma wszystkich ocen liczbowych, oceny z innych skal są ignorowane';
$string['aggregation_link'] = 'grade/aggregation';
$string['aggregationcoef'] = 'Współczynnik agregacji';
$string['aggregationcoefextra'] = 'Extra kredyt';
$string['aggregationcoefextra_help'] = 'Jeśli ocena wynikowa jest obliczana jako Suma lub Prosta średnia ważona, a pole Extra kredyt jest zaznaczone, maksymalna ocena tej pozycji nie jest dodawana do maksymalnej oceny w kategorii i w związku z tym można osiągnąć ocenę maksymalną w kategorii (lub nawet ją przekroczyć, jeśli zezwoli na to administrator) nie mając maksimum we wszystkich ocenach składowych.
Jeśli wyliczana jest \'Średnia ocen (z dodatkowymi punktami)\' i Extra kredyt jest ustawiony na wartość większą od zera, jest on mnożnikiem, przez który mnoży się ocenę przed dodaniem jej do oceny końcowej po obliczeniu średniej.';
$string['aggregationcoefextra_link'] = 'grade/aggregation';
$string['aggregationcoefextrasum'] = 'Ekstra kredyt';
$string['aggregationcoefextrasum_help'] = 'Jeśli pole Extra kredyt jest zaznaczone, maksymalna ocena tej pozycji nie jest dodawana do maksymalnej oceny w kategorii i w związku z tym można osiągnąć ocenę maksymalną w kategorii (lub nawet ją przekroczyć, jeśli zezwoli na to administrator) nie mając maksimum we wszystkich ocenach składowych.';
$string['aggregationcoefextrasum_link'] = 'grade/aggregation';
$string['aggregationcoefextrasumabbr'] = '+';
$string['aggregationcoefextraweight'] = 'Waga Ekstra kredytu';
$string['aggregationcoefextraweight_help'] = 'Jeśli waga Ekstra kredytu jest większa niż 0, ocena liczy się jako dodatkowa, "nadobowiązkowa" ocena w podsumowaniu. Wartość wagi jest mnożnikiem, przez który mnoży się ocenę przed dodaniem jej  w celu obliczenia średniej.';
$string['aggregationcoefextraweight_link'] = 'grade/aggregation';
$string['aggregationcoefweight'] = 'Waga pozycji';
$string['aggregationcoefweight_help'] = 'Waga pozycji określa wagę, z jaką dana pozycja wchodzi do obliczeń oceny wynikowej w kategorii.';
$string['aggregationcoefweight_link'] = 'grade/aggregation';
$string['aggregationhintdropped'] = '(odrzucona)';
$string['aggregationhintexcluded'] = '(Pominięta)';
$string['aggregationhintextra'] = '(Punkty dodatkowe)';
$string['aggregationhintnovalue'] = '(Pusty/e)';
$string['aggregationofa'] = 'Zestawienie {$a}';
$string['aggregationposition'] = 'Pozycja kolumny podsumowania';
$string['aggregationposition_help'] = 'To ostawienie określa, czy kolumny podsumowania kategorii oraz kursu są wyświetlane w raporcie dziennika ocen jako pierwsze, czy jako ostatnie.';
$string['aggregationsvisible'] = 'Dostępne typy zestawień';
$string['aggregationsvisiblehelp'] = 'Wybierz wszystkie typy podsumowań, które powinny być dostępne. Przytrzymaj klawisz CTRL aby wybrać wiele pozycji.';
$string['allgrades'] = 'Wszystkie oceny w kategorii';
$string['allstudents'] = 'Wszyscy studenci';
$string['allusers'] = 'Wszyscy';
$string['autosort'] = 'Automatyczne sortowanie';
$string['availableidnumbers'] = 'Dostępne identyfikatory';
$string['average'] = 'Średnia';
$string['averagesdecimalpoints'] = 'Liczba miejsc po przecinku w kolumnie średnich';
$string['averagesdecimalpoints_help'] = 'Ustawienie to określa liczbę miejsc po przecinku wyświetlaną w kolumnie  średniej.
\'Dziedzicz\' oznacza przyjęcie ustawienia z kategorii.';
$string['averagesdisplaytype'] = 'Postać kolumny średnich';
$string['averagesdisplaytype_help'] = 'To ustawienie określa, w jakiej postaci wyświetlana jest średnia: wartości rzeczywiste, procenty, literowo.
\'Dziedzicz\' oznacza przyjęcie ustawienia z kategorii.';
$string['backupwithoutgradebook'] = 'Kopia zapasowa nie zawiera konfiguracji dziennika ocen.';
$string['badgrade'] = 'Wprowadzona ocena jest niepoprawna';
$string['badlyformattedscale'] = 'Proszę wprowadzić rozdzielaną przecinkami listę wartości (minimum dwie wartości są wymagane)';
$string['baduser'] = 'Wprowadzona nazwa użytkownika jest niepoprawna';
$string['bonuspoints'] = 'Punkty bonusowe';
$string['bulkcheckboxes'] = 'Zbiorcze pola wyboru';
$string['calculatedgrade'] = 'Ocena obliczona';
$string['calculation'] = 'Obliczenie';
$string['calculation_help'] = 'Obliczenie to formuła służąca do wyliczenia oceny w niestandardowy sposób. Formuła zaczyna się znakiem równości (=) i może zawierać powszechnie stosowane operatory matematyczne takie jak max, min, czy sum . Jeśli to niezbędne, inne oceny mogą być uwzględnione w obliczeniu poprzez wpisanie ich identyfikatorów (ID) w podwójnych nawiasach kwadratowych.';
$string['calculation_link'] = 'grade/calculation';
$string['calculationadd'] = 'Dodaj obliczenie';
$string['calculationedit'] = 'Edytuj obliczenie';
$string['calculationsaved'] = 'Obliczenie zapisane';
$string['calculationview'] = 'Pokaż obliczenie';
$string['calculationwarning'] = 'W tej kategorii stosowana jest kalkulacja ocen dla całej kategorii, a nie agregacja.';
$string['cannotaccessgroup'] = 'Nie można uzyskać dostępu do ocen wybranej grupy, przepraszamy.';
$string['categories'] = 'Kategorie';
$string['category'] = 'Kategoria';
$string['categoryedit'] = 'Edytuj kategorię';
$string['categoryname'] = 'Nazwa kategorii';
$string['categorytotal'] = 'suma kategorii';
$string['categorytotalfull'] = 'Suma {$a->category}';
$string['categorytotalname'] = 'Nazwa sumy kategorii';
$string['changedefaults'] = 'Zmień domyślne';
$string['changereportdefaults'] = 'Zmień domyślne ustawienia raportowania';
$string['chooseaction'] = 'Wybierz czynność...';
$string['choosecategory'] = 'Wybierz kategorię';
$string['collapsecriterion'] = 'Zwiń kryteria';
$string['compact'] = 'Kompaktuj';
$string['componentcontrolsvisibility'] = 'To, czy ten element oceny będzie ukryty, zależy od ustawień aktywności.';
$string['contract'] = 'Zwiń kategorię';
$string['contributiontocoursetotal'] = 'Udział w całym kursie';
$string['courseavg'] = 'Średnia kursu';
$string['coursegradecategory'] = 'Kategoria oceny';
$string['coursegradedisplaytype'] = 'Sposób wyświetlania oceny';
$string['coursegradedisplayupdated'] = 'Uaktualniono sposób wyświetlania oceny';
$string['coursegradesettings'] = 'Ustawienia ocen w kursie';
$string['coursename'] = 'Nazwa kursu';
$string['coursescales'] = 'Skale w kursach';
$string['coursesettings'] = 'Ustawienia kursu';
$string['coursesettingsexplanation'] = 'Ustawienia kursu określają, w jaki sposób dziennik ocen jest wyświetlany dla uczestników kursu.';
$string['coursesiamtaking'] = 'Kursy, w których uczestniczę';
$string['coursesiamteaching'] = 'Kursy, w których uczę';
$string['coursetotal'] = 'w całym kursie';
$string['createcategory'] = 'Utwórz kategorię';
$string['createcategoryerror'] = 'Nie można utworzyć nowej kategorii';
$string['creatinggradebooksettings'] = 'Tworzenie ustawień dziennika ocen';
$string['csv'] = 'CSV';
$string['currentgrade'] = 'Aktualna ocena';
$string['currentparentaggregation'] = 'Agregacja z kategorii nadrzędnej';
$string['curveto'] = 'Zaokrąglaj do';
$string['decimalpoints'] = 'Ogółem miejsc po przecinku';
$string['decimalpoints_help'] = 'To ustawienie określa liczbę wyświetlanych miejsc dziesiętnych w ocenie. To nie ma jednak wpływu na obliczenia ocen, które dokonywane są z 5 miejscami po przecinku.';
$string['default'] = 'Domyślnie';
$string['defaultprev'] = 'Domyślnie ({$a})';
$string['deletecategory'] = 'Usuń kategorię';
$string['deletescale'] = 'Usuń skalę';
$string['disablegradehistory'] = 'Wyłącz historię dziennika';
$string['disablegradehistory_help'] = 'Wyłącz śledzenie historii zmian w tabelach dotyczących oceniania. To nieco przyśpieszy pracę serwera i zmniejszy bazę danych.';
$string['displaylettergrade'] = 'Pokazuj oceny';
$string['displaypercent'] = 'Pokazuj procenty';
$string['displaypoints'] = 'Pokazuj punkty';
$string['displayweighted'] = 'Pokazuj ważone oceny';
$string['droplow'] = 'Odrzuć najniższe';
$string['droplow_help'] = 'To ustawienie umożliwia wyłączenie z podsumowania określonej liczby najniższych ocen.';
$string['droplowestvalue'] = 'Ustaw upuszczanie najniższej wartości oceny';
$string['droplowestvalues'] = 'Odrzuć {$a} najniższych wartości';
$string['dropped'] = 'Usunięto';
$string['dropxlowest'] = 'Usuń \'n\' najniższych';
$string['dropxlowestwarning'] = 'Wskazówka: liczba odrzuconych dla danej kategorii powinna mieć taką samą wartość, w przeciwnym razie wyniki mogą być niedokładne.';
$string['duplicatedgradeitem'] = '{$a} (kopia)';
$string['duplicatescale'] = 'Zduplikuj skalę';
$string['edit'] = 'Edytuj';
$string['editcalculation'] = 'Edytuj obliczenie';
$string['editcalculationverbose'] = 'Edytuj obliczenie dla {$a->category} {$a->itemmodule} {$a->itemname}';
$string['editfeedback'] = 'Edytuj informację zwrotną';
$string['editgrade'] = 'Edytuj ocenę';
$string['editgradeletters'] = 'Edytuj nazwy ocen';
$string['editoutcome'] = 'Edytuj efekt uczenia się';
$string['editoutcomes'] = 'Edytuj efekt uczenia się';
$string['editscale'] = 'Edytuj skalę';
$string['edittree'] = 'Konfiguracja';
$string['editverbose'] = 'Edytuj {$a->category} {$a->itemmodule} {$a->itemname}';
$string['enableoutcomes'] = 'Włącz efekty uczenia się';
$string['enableoutcomes_help'] = 'Jeśli ta opcja jest włączona, pozycje ocen mogą być oceniane przy użyciu jednej lub więcej skal powiązanych ze deklaracją efektów uczeni się.';
$string['encoding'] = 'Kodowanie';
$string['encoding_help'] = 'Wybierz kodowanie znaków używane dla danych. (Standardowe kodowanie to UTF-8.) Jeśli przez pomyłkę wybrane zostanie nieprawidłowe kodowanie, będzie to zauważalne podczas podglądu danych do importu.';
$string['errorcalculationbroken'] = 'Błąd w obliczeniu elementu oceny {$a}.';
$string['errorcalculationnoequal'] = 'Wyrażenie musi rozpoczynać się znakiem równości (=1+2)';
$string['errorcalculationunknown'] = 'Niepoprawne wyrażenie';
$string['errorgradevaluenonnumeric'] = 'Otrzymano nienumeryczną wartość dla najniższej i najwyższej oceny';
$string['errornocalculationallowed'] = 'Obliczenia nie są dozwolone dla tej pozycji';
$string['errornocategorisedid'] = 'Nie udało się znaleźć id bez kategorii!';
$string['errornocourse'] = 'Brak informacji o kursie';
$string['erroroverweight'] = 'Całkowita waga przekracza 100%.';
$string['errorreprintheadersnonnumeric'] = 'Otrzymano nienumeryczną wartość dla powtórzeń nagłówka';
$string['errorsavegrade'] = 'Nie można zapisać oceny, przepraszamy.';
$string['errorsettinggrade'] = 'Błąd zapisu "{$a->itemname}" oceny dla użytkownika o identyfikatorze {$a->userid}';
$string['errorunderweight'] = 'Całkowita waga jest mniejsza 100%.';
$string['errorupdatinggradecategoryaggregateonlygraded'] = 'Błąd aktualizacji ustawień "Aggregate only non-empty grades" kategorii {$a->id}';
$string['errorupdatinggradecategoryaggregateoutcomes'] = 'Błąd aktualizacji ustawień opcji "Uwzględnij efekty kształcenia w podsumowaniu" kategorii {$a->id}';
$string['errorupdatinggradecategoryaggregation'] = 'Błąd aktualizacji typu podsumowania kategorii {$a->id}';
$string['errorupdatinggradeitemaggregationcoef'] = 'Błąd aktualizacji współczynnika agregacji (wagi lub extra kredytu) oceny {$a->id}';
$string['eventgradedeleted'] = 'Ocena usunięta';
$string['eventgradeexported'] = 'Ocena eksportowana';
$string['eventgradeitemcreated'] = 'Utworzono pozycję oceny';
$string['eventgradeitemdeleted'] = 'Ocena została usunięta';
$string['eventgradeitemupdated'] = 'Ocena została zaktualizowana';
$string['eventgradelettercreated'] = 'Utworzono nazwę oceny';
$string['eventgradeletterdeleted'] = 'Usunięto nazwę oceny';
$string['eventgradeletterupdated'] = 'Zaktualizowano nazwę oceny';
$string['eventgradeviewed'] = 'Oceny zostały wyświetlone w dzienniku ocen';
$string['eventscalecreated'] = 'Skala utworzona';
$string['eventscaledeleted'] = 'Skala usunięta';
$string['eventscaleupdated'] = 'Skala zaktualizowana';
$string['eventusergraded'] = 'Użytkownik oceniony';
$string['excluded'] = 'Wykluczony';
$string['excluded_help'] = 'Jeśli będzie zaznaczone, oceny nie będą uwzględniane żadnym zestawieniu.';
$string['expand'] = 'Rozwiń kategorię';
$string['expandcriterion'] = 'Rozwiń kryteria';
$string['export'] = 'Eksportuj';
$string['exportalloutcomes'] = 'Eksportuj wszystkie efekty uczenia się';
$string['exportas'] = 'Eksportuj jako';
$string['exportfeedback'] = 'Uwzględnij opinie zwrotne';
$string['exportfeedback_desc'] = 'Można to nadpisać podczas eksportu.';
$string['exportformatoptions'] = 'Opcje formatu eksportu';
$string['exportonlyactive'] = 'Wyklucz zawieszonych użytkowników';
$string['exportonlyactive_help'] = 'Włączenie tylko studentów, których zapis jest aktywny i nie zostali zawieszeni.';
$string['exportplugins'] = 'Eksportuj wtyczki';
$string['exportsettings'] = 'Eksportuj ustawienia';
$string['exportto'] = 'Eksportuj do';
$string['externalurl'] = 'Zewnętrzny adres URL';
$string['externalurl_desc'] = 'Jeśli używany jest zewnętrzny dziennik ocen, w tym miejscu należy podać jego adres URL.';
$string['extracreditvalue'] = 'Wartość dodatkowego kredytu dla {$a}';
$string['extracreditwarning'] = 'Uwaga: ustawienie wszystkich danych jako opcji dodatkowej dla wyszczególnionej kategorii może skutkować niespodziewanymi wynikami. Nie będzie uwzględniony w wyniku ogólnym.';
$string['fail'] = 'Niepowodzenie';
$string['feedback'] = 'Informacja zwrotna';
$string['feedback_help'] = 'W tym polu można wpisać   jakiekolwiek uwagi czy komentarze na temat oceny.';
$string['feedbackadd'] = 'Dodaj informację zwrotną';
$string['feedbackedit'] = 'Edytuj informację zwrotną';
$string['feedbackfiles'] = 'Pliki informacji zwrotnych';
$string['feedbackforgradeitems'] = 'Odpowiedź zwrotna dla {$a}';
$string['feedbackhistoryfiles'] = 'Pliki historii odpowiedzi zwrotnej';
$string['feedbackprovided'] = 'Przekazano odpowiedź zwrotną';
$string['feedbacks'] = 'Odpowiedzi zwrotne';
$string['feedbacksaved'] = 'Informacja zwrotna  zapisana';
$string['feedbackview'] = 'Zobacz informację zwrotną';
$string['filterbothactive'] = 'Imię ({$a->first}) Nazwisko ({$a->last})';
$string['filterbyname'] = 'Filtruj po nazwisku';
$string['filterfirstactive'] = 'Imię ({$a->first})';
$string['filterlastactive'] = 'Nazwisko ({$a->last})';
$string['finalgrade'] = 'Ocena końcowa';
$string['finalgrade_help'] = 'Jeżeli pole "nadpisane" jest zaznaczone ocena może być dodana lub zmodyfikowana.';
$string['fixedstudents'] = 'Statyczna kolumna studentów';
$string['fixedstudents_help'] = 'Pozwala na przewijanie poziome bez utraty widoczności kolumny studentów, poprzez spowodowanie, aby była statyczna.';
$string['forceimport'] = 'Wymuś import';
$string['forceimport_help'] = 'Wymuś import ocen, nawet jeśli oceny zostały zaktualizowane po wyeksportowaniu pliku importu';
$string['forceoff'] = 'Wymuś: wyłączone';
$string['forceon'] = 'Wymuś: włączone';
$string['forelementtypes'] = 'dla wybranych {$a}';
$string['forstudents'] = 'Dla studentów';
$string['full'] = 'Pełny';
$string['fullmode'] = 'Pokaż oceny i podsumowania';
$string['generalsettings'] = 'Ustawienia ogólne';
$string['grade_help'] = 'Ocena przyznana uczniowi za pracę.';
$string['gradeadministration'] = 'Administracja ocenami';
$string['gradealreadyupdated'] = '{$a} oceny nie zostały zaimportowane, ponieważ oceny w pliku importu są starsze niż w raporcie oceniającego. Aby mimo to kontynuować import ocen, użyj opcji wymuś import.';
$string['gradeanalysis'] = 'Analiza ocen';
$string['gradebook'] = 'Dziennik ocen';
$string['gradebookcalculationsfixbutton'] = 'Zaakceptuj zmiany ocen i napraw błędy obliczeń';
$string['gradebookcalculationsuptodate'] = 'Obliczenia w dzienniku ocen są aktualne. Może być konieczne przeładowanie strony, aby zobaczyć zmiany.';
$string['gradebookcalculationswarning'] = 'Uwaga: Wykryto pewne błędy w obliczaniu ocen wyświetlanych w dzienniku ocen. Jeśli kurs jeszcze się nie rozpoczął lub jest w trakcie, zaleca się naprawienie błędów poprzez kliknięcie poniższego przycisku, choć spowoduje to zmianę niektórych ocen. Jeśli kurs już się zakończył, a oceny zostały przesłane, prawdopodobnie nie chcesz naprawiać tego błędu.

Nowszą wersją jest {$a->currentversion}; używasz wersji dziennika ocen {$a->gradebookversion}. Listę zmian można zobaczyć w <a href="{$a->url}">Zmiany w obliczeniach dziennika ocen</a>.';
$string['gradebookhiddenerror'] = 'Dziennik ocen jest obecnie niedostępny dla studentów.';
$string['gradebookhistories'] = 'Historia ocen';
$string['gradebooknavigationmenu'] = 'Menu nawigacji dziennika ocen';
$string['gradebooksetup'] = 'Ustawienia dziennika ocen';
$string['gradeboundary'] = 'granica literowych  ocen';
$string['gradeboundary_help'] = 'To ustawienie określa minimalne progi procentowe, którym odpowiadają oceny literowe.';
$string['gradecategories'] = 'Kategorie ocen';
$string['gradecategory'] = 'Kategoria ocen';
$string['gradecategoryonmodform'] = 'Kategoria ocen';
$string['gradecategoryonmodform_help'] = 'To ustawienie określa, w której kategorii dziennika jest umieszczana ocena tej aktywności.';
$string['gradecategorysettings'] = 'Ustawienia kategorii ocen';
$string['gradedisplay'] = 'Wyświetl oceny';
$string['gradedisplaytype'] = 'Sposób wyświetlania oceny';
$string['gradedisplaytype_help'] = 'To ustawienie określa w jaki sposób wyświetlane są oceny w dzienniku oraz w raporcie użytkownika.

* Punkty - aktualne oceny punktowe
* Procentowo
* Nazwa stopnia - litery lub słowa wykorzystywane w zakresie oceniania';
$string['gradedon'] = 'Ocenienione: {$a}';
$string['gradeexport'] = 'Eksport ocen';
$string['gradeexportcolumntype'] = '{$a->name} ({$a->extra})';
$string['gradeexportcustomprofilefields'] = 'Niestandardowe pola profilu eksportu ocen';
$string['gradeexportcustomprofilefields_desc'] = 'Uwzględnij te niestandardowe pola profilu w eksporcie oceny, oddzielone przecinkami.';
$string['gradeexportdecimalpoints'] = 'Miejsca dziesiętne podczas eksportu ocen';
$string['gradeexportdecimalpoints_desc'] = 'Liczba miejsc dziesiętnych podczas eksportu ocen. Można tę wartość zmienić podczas eksportu.';
$string['gradeexportdisplaytype'] = 'Typ wyświetlania ocen podczas eksportu';
$string['gradeexportdisplaytype_desc'] = 'Podczas eksportu oceny mogą być wyświetlane w postaci liczb rzeczywistych, wartości procentowych (w odniesieniu do najmniejszej i największej oceny) lub jako litery (A, B, C itd.). Ustawienie to może być zmienione podczas eksportu.';
$string['gradeexportdisplaytypes'] = 'Wybierz typ eksportowanych ocen';
$string['gradeexportuserprofilefields'] = 'Pola profilu użytkownika eksportu ocen';
$string['gradeexportuserprofilefields_desc'] = 'Uwzględnij te pola profilu użytkownika podczas eksportu ocen, rozdzielając je przecinkami.';
$string['gradeforstudent'] = '{$a->student}<br />{$a->item}{$a->feedback}';
$string['gradegrademinmax'] = 'Zachowaj pierwotne ustawienia oceny minimalnej i maksymalnej';
$string['gradehelp'] = 'Pomoc do ocen';
$string['gradehistorylifetime'] = 'Czas przechowywania historii ocen.';
$string['gradehistorylifetime_help'] = 'Ten parametr określa okres czasu, przez który należy zachować historię zmian w ocenach. Zaleca się, aby ustawić jak najdłuższy czas. Jeśli wystąpią problemy z wydajnością lub mamy ograniczoną pojemność bazy danych, można ustawić niższą wartość.';
$string['gradeimport'] = 'Import ocen';
$string['gradeimportfailed'] = 'Importowanie oceny nie powiodło się podczas zatwierdzania. Szczegóły:';
$string['gradeitem'] = 'Oceniany element';
$string['gradeitemaddusers'] = 'Wyklucz z listy ocenianych';
$string['gradeitemislocked'] = 'Ta aktywność jest zablokowana w dzienniku ocen. Zmiany dokonane w ocenach tej aktywności nie zostaną skopiowane do dziennika ocen dopóki nie zostanie ona odblokowana.';
$string['gradeitemlocked'] = 'Ocenianie zablokowane';
$string['gradeitemmembersselected'] = 'Wykluczeni z listy ocenianych';
$string['gradeitemminmax'] = 'Użyj bieżącego ustawienia wartości oceny minimalnej i maksymalnej';
$string['gradeitemnonmembers'] = 'Uwzględniono w ocenianiu';
$string['gradeitemremovemembers'] = 'Uwzględnij w ocenianiu';
$string['gradeitems'] = 'Oceny';
$string['gradeitemsettings'] = 'Ustawienia pozycji ocen';
$string['gradeitemsinc'] = 'Uwzględnij oceny z:';
$string['gradeletter'] = 'Nazwa oceny';
$string['gradeletter_help'] = 'Nazwy ocen to litery A, B, C,..., lub słowa, np. Bardzo dobry, dobry, dostateczny,.... używane do wyrażenia zakresu ocen.';
$string['gradeletternote'] = 'Żeby usunąć literowe oceny, zostaw puste pole i kliknij "Zachowaj zmiany".';
$string['gradeletteroverridden'] = 'Domyślne nazwy ocen zostały nadpisane.';
$string['gradeletters'] = 'Nazwy ocen';
$string['gradelocked'] = 'Ocena jest zablokowana';
$string['gradelong'] = '{$a->grade} / {$a->max}';
$string['grademax'] = 'Ocena maksymalna';
$string['grademax_help'] = 'To pole określa maksymalną ocenę tej pozycji w przypadku ocen liczbowych.
Maksymalną ocenę za aktywność (np. zadanie) ustawia się na stronie ustawień tej aktywności.';
$string['grademin'] = 'Ocena minimalna';
$string['grademin_help'] = 'To pole określa minimalną ocenę tej pozycji w przypadku ocen liczbowych.';
$string['gradenotificationmessage'] = 'Masz nową opinię na temat swojej pracy "{$a}"';
$string['gradenotificationsubject'] = 'Zostałeś oceniony';
$string['gradeoutcomeitem'] = 'Efekt uczenia się';
$string['gradeoutcomes'] = 'Efekty uczenia się';
$string['gradeoutcomescourses'] = 'Efekty uczenia się kursu';
$string['gradepass'] = 'Próg zaliczeniowy';
$string['gradepass_help'] = 'To ustawienie określa minimalną ocenę wymaganą do zaliczenia. Ta wartość jest wykorzystywana w śledzeniu zaliczenia aktywności i kursu (completion tracking) oraz w dzienniku ocen, w którym oceny w kolorze zielonym oznaczają zaliczenie a czerwone jego brak.';
$string['gradepassgreaterthangrade'] = 'Ocena do zaliczenia nie może być wyższa niż maksymalna możliwa ocena {$a}';
$string['gradepenalty'] = 'Kary ocen';
$string['gradepenalty_enabledmodules'] = 'Włączone aktywności';
$string['gradepenalty_enabledmodules_help'] = 'Włącz kary dla ocen za wybrane aktywności.';
$string['gradepenalty_indicator_info'] = 'Zastosowano karę za spóźnienie -{$a} punktów';
$string['gradepenalty_supportedplugins'] = 'Zarządzaj wspieranymi aktywnościami';
$string['gradepointdefault'] = 'Domyślna ocena punktowa';
$string['gradepointdefault_help'] = 'To ustawienie określa wartość domyślną dla oceny punktowej dostępnej w aktywności.';
$string['gradepointdefault_validateerror'] = 'To ustawienie musi być liczbą całkowitą między 1 a maksymalną oceną punktową.';
$string['gradepointmax'] = 'Maksymalna ocena punktowa';
$string['gradepointmax_help'] = 'To ustawienie określa maksymalną wartość domyślną dla oceny punktowej dostępnej w aktywności.';
$string['gradepointmax_validateerror'] = 'To ustawienie musi być liczbą całkowitą z przedziału od 1 do 10000.';
$string['gradepreferences'] = 'Właściwości oceny';
$string['gradepreferenceshelp'] = 'Pomoc do właściwości oceny';
$string['gradepublishing'] = 'Włącz publikowanie';
$string['gradepublishing_help'] = 'Włącz publikowanie podczas eksportu i importu. Oceny wyeksportowane publicznie mogą być dostępne przez URL, bez logowanie do Moodle. Oceny mogą być zaimportowane przy użyciu takiego URLa (czyli Moodle może importować oceny opublikowane przez inną witrynę). Domyślnie tylko administratorzy mogę użyć tej opcji. Prawa tego nie powinno się przekazywać niezaawansowanym użytkownikom (ryzyko utraty bezpieczeństwa danych itp.)';
$string['gradepublishinglink'] = 'Pobierz: {$a}';
$string['gradereport'] = 'Raport ocen';
$string['graderreport'] = 'Raport dziennika';
$string['grades'] = 'Oceny';
$string['gradesforuser'] = 'Oceny dla {$a->user}';
$string['gradesmoduledeletionpendingwarning'] = 'Uwaga: Trwa usuwanie aktywności! Niektóre oceny mogą zostać usunięte.';
$string['gradesmoduledeletionprefix'] = 'Trwa usuwanie';
$string['gradesonly'] = 'Pokaż tylko oceny';
$string['gradessettings'] = 'Ustawienia oceny';
$string['gradetype'] = 'Typ oceny';
$string['gradetype_help'] = 'Są 4 typy ocen:

Brak - brak mozliwości oceniania
Wartość  - wartość numeryczna z minimum i maximum
Skala - pozycja ze skali ocen
Tekst - tylko informacja zwrotna .

Tylko typy Wartość i Skala pozwalają na podsumowania. Typ oceny dla ocen wynikających z aktywności są ustawiane w ustawieniach aktywności.';
$string['gradevaluetoobig'] = 'Jedna z wartości ocen jest większa niż dozwolone maksimum określone na {$a}.';
$string['gradevaluetoosmall'] = 'Jedna z wartości ocen jest mniejsza niż dozwolona minimalna ocena wynosząca {$a}';
$string['gradeview'] = 'Pokaż ocenę';
$string['gradewasmodifiedduringediting'] = 'Wprowadzona ocena {$a->itemname} dla {$a->username} został a zignorowana, ponieważ została ona ostatnia zaktualizowana przez kogoś innego.';
$string['gradeweighthelp'] = 'Pomoc do wag ocen';
$string['gradingmodulename'] = 'Ocenianie ({$a})';
$string['groupavg'] = 'Średnia grupy';
$string['hidden'] = 'Ukryte';
$string['hidden_help'] = 'Jeśli zaznaczone, oceny są ukryte przed studentami. Można ustawić datę, do której oceny mają być ukryte, aby pokazać je dopiero po zakończeniu oceniania.';
$string['hiddenasdate'] = 'Pokaż datę wysłania ukrytych ocen';
$string['hiddenasdate_help'] = 'W miejscach ukrytych ocen pokazuj datę wysłania zamiast znaku \'-\'.';
$string['hiddenuntil'] = 'Ukryty do';
$string['hiddenuntildate'] = 'Ukryty do: {$a}';
$string['hideadvanced'] = 'Ukryj zaawansowane możliwości';
$string['hideaverages'] = 'Ukryj średnie';
$string['hidecalculations'] = 'Ukryj obliczenia';
$string['hidecategory'] = 'Ukryj';
$string['hideeyecons'] = 'Ukryj ikony pokazywania/ukrywania';
$string['hidefeedback'] = 'Ukryj informację zwrotną';
$string['hideforcedsettings'] = 'Ukryj wymuszone ustwienia';
$string['hideforcedsettings_help'] = 'Nie pokazuj ustawień wymuszonych w intefejsie użytkownika używanym do oceniania.';
$string['hidegroups'] = 'Ukryj grupy';
$string['hidelocks'] = 'Ukryj blokady';
$string['hidenooutcomes'] = 'Pokaż efekty uczenia się';
$string['hidequickfeedback'] = 'Ukryj szybką informację zwrotną.';
$string['hideranges'] = 'Ukryj zakresy';
$string['hidetotalifhiddenitems'] = 'Ukryj sumy, jeżeli zawierają ukryte pozycje.';
$string['hidetotalifhiddenitems_help'] = 'Ta opcja określa, czy oceny wynikowe, które obejmują oceny ukryte są widoczne dla studentów lub zastępowane myślnikiem (-). Jeżeli są wyświetlane, ocena wynikowa może być obliczana z uwzględnieniem lub bez uwzględnienia ukrytych elementów.

Jeśli ukryte oceny nie są uwzględniane, ocena łączna będzie inna dla studenta i nauczyciela, ponieważ nauczyciel zawsze widzi wszystkie elementy. Jeśli ukryte oceny są uwzględniane, studenci mogą być w stanie wyliczyć ukryte oceny na podstawie pozostałych.';
$string['hidetotalshowexhiddenitems'] = 'Wyświetl sumy pomijając ukryte pozycje.';
$string['hidetotalshowinchiddenitems'] = 'Wyświetl sumy włączając ukryte pozycje.';
$string['hideverbose'] = 'Ukryj {$a->category} {$a->itemmodule} {$a->itemname}';
$string['highgradeascending'] = 'Sortuj wg najwyższych ocen rosnąco';
$string['highgradedescending'] = 'Sortuj wg najwyższych ocen malejąco';
$string['highgradeletter'] = 'Do';
$string['identifier'] = 'Identyfikuj użytkowników przez';
$string['idnumbers'] = 'Numery ID';
$string['ignore'] = 'Ignoruj';
$string['import'] = 'Importuj';
$string['importas'] = 'Importuj jako';
$string['importcsv'] = 'Importuj CSV';
$string['importcsv_help'] = 'Oceny można importować za pomocą pliku CSV o następującym formacie:

* Każdy wiersz pliku zawiera jeden rekord
* Każdy rekord to seria danych oddzielonych wybranym separatorem
* Pierwszy rekord zawiera listę nazw pól definiujących format pozostałej części pliku.
* Wymagana jest nazwa pola zawierająca dane identyfikacyjne użytkownika - nazwę użytkownika, numer identyfikacyjny lub adres e-mail.

Plik o prawidłowym formacie można uzyskać poprzez wyeksportowanie niektórych ocen. Plik można następnie edytować i zapisać jako plik CSV.';
$string['importcsv_link'] = 'grade/import/csv/index';
$string['importcustom'] = 'Importu jako własne efekty uczenia się (tylko w tym kursie)';
$string['importdata'] = 'Dane';
$string['importdata_help'] = 'Oceny można wklejać bezpośrednio z arkusza kalkulacyjnego OpenDocument lub Excel w następującym formacie:

* Co najmniej jedna kolumna powinna zawierać dane identyfikacyjne użytkownika - nazwę użytkownika, adres e-mail lub numer ID.
* Pozostałe kolumny powinny mieć nagłówki dla istniejących aktywności lub pozycji dziennika ocen.

Prawidłowo sformatowany arkusz kalkulacyjny można uzyskać poprzez wyeksportowanie niektórych ocen. Arkusz kalkulacyjny można następnie edytować, aby dodać więcej ocen i zapisać.

Wybierz i skopiuj kolumny, które chcesz zaimportować z arkusza kalkulacyjnego, a następnie wklej je w tym polu.';
$string['importerror'] = 'Błąd, wywołano skrypt z błędnymi parametrami.';
$string['importfailed'] = 'Importowanie nie powiodło się. Żadne dane nie zostały zaimportowane.';
$string['importfeedback'] = 'Importuj informację zwrotną';
$string['importfile'] = 'Importuj plik';
$string['importfilemissing'] = 'Nie pobrano pliku, wróć do formularza i załaduj poprawny plik.';
$string['importfrom'] = 'Importuj z';
$string['importoutcomenofile'] = 'Przesłany plik jest pusty lub uszkodzony. Proszę sprawdzić czy jest to prawidłowy plik. Problem został wykryty w linii {$a}.
Błąd jest sygnalizowany, gdy linie danych nie mają tylu kolumn, ile w pierwszym wierszu (wierszu nagłówka), lub gdy w pliku brakuje oczekiwanych nagłówków. Prawidłowe nagłówki znajdziesz w pliku wyeksportowanym.';
$string['importoutcomes'] = 'Importuj efekty uczenia się';
$string['importoutcomes_help'] = 'Efekty uczenia się mogą być zaimportowane poprzez plik cvs w takim samym formacie w jakim są eksportowane.';
$string['importoutcomes_link'] = 'grade/outcome';
$string['importoutcomesuccess'] = 'Zaimportowany efekt uczenia się "{$a->name}" z identyfikatorem  {$a->id}';
$string['importplugins'] = 'Importuj wtyczkę (plugin)';
$string['importpreview'] = 'Importuj podgląd';
$string['importsettings'] = 'Importuj ustawienia';
$string['importskippednomanagescale'] = 'Nie masz uprawnień, aby dodać nową skalę ocen, a efekt uczenia się "{$a}" wymaga stworzenia nowej skali, zatem został on pominięty.';
$string['importskippedoutcome'] = 'Efekt uczenia się o krótkiej nazwie "{$a}" już istnieje w tym kontekście, dlatego ten z importowanego pliku został pominięty.';
$string['importstandard'] = 'Zaimportuj jako standardowe efekty uczenia się';
$string['importsuccess'] = 'Import ocen zakończony pomyślnie';
$string['importxml'] = 'Import XML';
$string['includescalesinaggregation'] = 'Uwzględnij skale w zestawieniu';
$string['includescalesinaggregation_help'] = 'Tu możesz ustalić, czy oceny w skalach symbolicznych będą przeliczane na liczby i uwzględniane  wszystkich wynikowych ocenach we wszystkich dziennikach ocen we wszystkich kursach. UWAGA: Zmiana tego ustawienia spowoduje przeliczenie wszystkich wynikowych ocen.';
$string['incorrectcourseid'] = 'ID kursu był niepoprawny';
$string['incorrectcustomscale'] = '(Niepoprawna skala własna, należy zmienić.)';
$string['incorrectminmax'] = 'Minimum musi być mniejsze niż maksimum';
$string['inherit'] = 'dziedzicz';
$string['intersectioninfo'] = 'Informacja o studencie/ocenie';
$string['invalidgradeexporteddate'] = 'Data eksportu jest nieprawidłowa, ponieważ pochodzi sprzed ponad roku, jest w przyszłości lub jej format jest nieprawidłowy.';
$string['item'] = 'Pozycja';
$string['iteminfo'] = 'Informacje o elemencie';
$string['iteminfo_help'] = 'To jest miejsce na dodatkowy opis tej pozycji, Informacja nie jest wyświetlana nigdzie indziej.';
$string['itemname'] = 'Nazwa ocenianego elementu';
$string['itemnamehelp'] = 'Nazwa pozycji, ustalona wewnętrznie.';
$string['items'] = 'Pozycje';
$string['itemsedit'] = 'Modyfikuj oceniany element';
$string['keephigh'] = 'Zachowaj najwyższe';
$string['keephigh_help'] = 'Ta opcja zatrzyma X najwyższych ocen, odrzucając resztę. X jest wybraną wartością.';
$string['keephighestvalues'] = 'Trzymaj {$a} najwyższych wartości';
$string['keymanager'] = 'Menedżer kluczy';
$string['lessthanmin'] = 'Ocena wprowadzona w {$a->itemname} dla użytkownika {$a->username} jest mniejsza od najmniejszej dopuszczalnej.';
$string['letter'] = 'Nazwa oceny';
$string['lettergrade'] = 'Nazwy ocen';
$string['lettergradenonnumber'] = 'Niska i/lub wysoka ocena dla nienumerycznych';
$string['letterpercentage'] = 'Nazwa oceny (procentowo)';
$string['letterreal'] = 'Nazwa oceny (punkty)';
$string['letters'] = 'Nazwy ocen';
$string['linkedactivity'] = 'Powiązana aktywność';
$string['linkedactivity_help'] = 'Tu określona jest aktywność, z którą efekt uczenia się jest powiązany. W ten sposób można ocenić osiągnięcia studenta nie objęte oceną z aktywności.';
$string['linktoactivity'] = 'Przejdź do aktywności - {$a->name}: {$a->title}';
$string['lock'] = 'Zablokuj';
$string['locked'] = 'Zablokowany';
$string['locked_help'] = 'Jeśli zaznaczone, oceny nie mogą być aktualizowane powiązana aktywność.';
$string['locktime'] = 'Zablokuj po';
$string['locktimedate'] = 'Zablokowany po: {$a}';
$string['lockverbose'] = 'Zablokuj {$a->category} {$a->itemmodule} {$a->itemname}';
$string['lowest'] = 'Najniższa';
$string['lowgradeletter'] = 'Od';
$string['manageoutcomes'] = 'Zarządzaj efektami uczenia się';
$string['managepenaltyplugins'] = 'Zarządzaj wtyczkami kar';
$string['manualitem'] = 'Pozycja wstawiona ręcznie';
$string['mapfrom'] = 'Mapuj z';
$string['mapfrom_help'] = 'Wybierz kolumnę w arkuszu kalkulacyjnym zawierającą dane identyfikujące użytkownika, takie jak nazwa użytkownika, identyfikator użytkownika lub adres e-mail.';
$string['mappings'] = 'Mapowania pozycji ocen';
$string['mappings_help'] = 'Dla każdej kolumny ocen w arkuszu kalkulacyjnym wybierz odpowiednią pozycję oceny, do której chcesz zaimportować oceny.';
$string['mapto'] = 'Mapuj do';
$string['mapto_help'] = 'Wybierz te same dane identyfikacyjne, które zostały wybrane dla opcji "Mapuj do".';
$string['max'] = 'Najwyższa';
$string['maxgrade'] = 'Maksymalna ocena';
$string['meanall'] = 'Wszystkie oceny';
$string['meangraded'] = 'Niepuste oceny';
$string['meanselection'] = 'Oceny brane do wyliczenia średniej';
$string['meanselection_help'] = 'Określ, typy ocen zawartych w kolumnie średnich. Komórki nie zawierające ocen będą ignorowane albo traktowane jakby zawierały zero (domyślnie).';
$string['median'] = 'Mediana';
$string['min'] = 'Najniższa';
$string['minimum_show'] = 'Pokaż minimalną wartość oceny';
$string['minimum_show_help'] = 'Ocena minimalna jest używana do obliczania ocen i wag. Jeśli nie zostanie wyświetlona, minimalna ocena zostanie domyślnie ustawiona na zero i nie będzie można jej edytować.';
$string['minmaxtouse'] = 'Zastosowane wartości oceny minimalnej i maksymalnej';
$string['minmaxtouse_desc'] = 'To ustawienie określa, czy podczas obliczania oceny wyświetlanej w dzienniku ocen mają być używane początkowe minimalne i maksymalne oceny z momentu wystawienia oceny, czy minimalne i maksymalne oceny określone w ustawieniach elementu oceny. Zaleca się modyfikowanie tego ustawienia poza godzinami szczytu, ponieważ wszystkie oceny zostaną ponownie obliczone, co może spowodować duże obciążenie serwera.';
$string['minmaxtouse_help'] = 'To ustawienie określa, czy - przy kalkulacji oceny w dzienniku ocen - zachowane mają być początkowe wartości oceny minimalnej i maksymalnej wykorzystane podczas przeprowadzonego oceniania, czy też zastosowane mają być aktualnie ustawione wartości minimum i maksimum oceny.';
$string['minmaxtouse_link'] = 'Grades_min_max';
$string['minmaxupgradedgrades'] = 'Uwaga: Niektóre oceny zostały zmienione w celu rozwiązania niespójności w dzienniku ocen spowodowanej zmianą minimalnych i maksymalnych ocen używanych podczas obliczania wyświetlanej oceny. Zaleca się sprawdzenie i zaakceptowanie tych zmian.';
$string['minmaxupgradefixbutton'] = 'Rozwiązywanie niespójności';
$string['minmaxupgradewarning'] = 'Uwaga: Wykryto niespójność z niektórymi ocenami z powodu zmiany minimalnej i maksymalnej oceny używanej podczas obliczania oceny wyświetlanej w dzienniku ocen. Zaleca się usunięcie niespójności poprzez kliknięcie poniższego przycisku, choć spowoduje to zmianę niektórych ocen.';
$string['missingitemtypeoreid'] = 'Brak klucza tablicy (itemtype lub eid)';
$string['missingscale'] = 'Skala musi być określona';
$string['mode'] = 'Tryb';
$string['modgrade'] = 'Ocena';
$string['modgrade_help'] = '* Punkt – wartość liczbowa
* Brak – tylko informacja zwrotna
* Skala – element z listy';
$string['modgradecantchangegradetype'] = 'Nie możesz zmienić tego ustawienia, ponieważ istnieją już oceny dla tej aktywności.';
$string['modgradecantchangegradetypemsg'] = 'Część punktów została już wpisana, w związku z tym nie można zmienić sposobu oceniania. Jeżeli chcesz zmienić maksymalną punktację, musisz najpierw zdecydować, czy przeliczyć wpisane punkty.';
$string['modgradecantchangegradetyporscalemsg'] = 'Niektóre oceny zostały już przydzielone, więc ocena skala nie może być zmieniona.';
$string['modgradecantchangeratingmaxgrade'] = 'Nie można zmienić maksymalnej oceny, jeśli istnieją już oceny za aktywność z ocenami.';
$string['modgradecantchangescale'] = 'Nie można zmienić skali, ponieważ istnieją już oceny dla tej pozycji.';
$string['modgradecategorycantchangegradetypemsg'] = 'Ta kategoria ma powiązane pozycje ocen, które zostały zastąpione. Dlatego niektóre oceny zostały już przyznane, więc typ oceny nie może zostać zmieniony. Jeśli chcesz zmienić maksymalną ocenę, musisz najpierw wybrać, czy chcesz przeskalować istniejące oceny.';
$string['modgradecategorycantchangegradetyporscalemsg'] = 'Ta kategoria ma powiązane pozycje ocen, które zostały zastąpione. W związku z tym niektóre oceny zostały już przyznane, więc typ oceny i skala nie mogą zostać zmienione.';
$string['modgradecategoryrescalegrades'] = 'Przeskalowanie nadpisanych ocen';
$string['modgradecategoryrescalegrades_help'] = 'Podczas zmiany maksymalnej oceny w elemencie dziennika ocen należy określić, czy spowoduje to również zmianę istniejących ocen procentowych.

Jeśli ta opcja jest ustawiona na "Tak", wszystkie istniejące nadpisane oceny zostaną przeskalowane tak, aby ocena procentowa pozostała taka sama.

Na przykład, jeśli ta opcja jest ustawiona na "Tak", zmiana maksymalnej oceny przedmiotu z 10 na 20 spowoduje przeskalowanie oceny 6/10 (60%) na 12/20 (60%). Jeśli ta opcja jest ustawiona na "Nie", ocena pozostanie niezmieniona, wymagając ręcznego dostosowania elementów oceny w celu zapewnienia prawidłowych wyników.';
$string['modgradedonotmodify'] = 'Nie modyfikuj istniejących ocen';
$string['modgradeerrorbadpoint'] = 'Nieprawidłowa wartość ocen. Musi być ona liczbą całkowitą pomiędzy 1 a {$a}';
$string['modgradeerrorbadscale'] = 'Wybrano nieprawidłową skalę. Upewnij się, że wybrałeś poprawną skalę z poniższej listy.';
$string['modgrademaxgrade'] = 'Maksymalna ocena';
$string['modgraderecalculatepenalty'] = 'Przelicz karę';
$string['modgraderecalculatepenalty_help'] = 'Kara zostanie przeliczona dla wszystkich użytkowników.';
$string['modgraderescalegrades'] = 'Przelicz wpisane punkty';
$string['modgraderescalegrades_help'] = 'Podczas zmiany maksymalnej punktacji dla zadania należy określić, czy spowoduje to procentową zmianę punktów wpisanych w dzienniku ocen.
Jeśli wybrano wartość "Tak", to wszystkie wpisane oceny zostaną przeliczone, tak aby procentowo ocena pozostała taka sama.

Np., wybrano opcję "Tak": po zmianie maksymalnej punktacji z 10 do 20 punktów, wpisane punkty 6/10 (60%) zostaną przeliczone do 12/20 (60%). Wybrano opcję "Nie": punktacja 6/10 (60%) zmieni się do 6/20 (30%) wymagając ręcznego modyfikowania elementów punktacji, aby zapewnić prawidłowe wyniki.';
$string['modgradetype'] = 'Typ';
$string['modgradetypenone'] = 'Żaden';
$string['modgradetypepoint'] = 'Punkt';
$string['modgradetypescale'] = 'Skala';
$string['morethanmax'] = 'Ocena wprowadzona w {$a->itemname} dla użytkownika {$a->username} jest większa od największej dopuszczalnej.';
$string['moveselectedto'] = 'Przenieś zaznaczone elementy do';
$string['movesitems'] = 'Przesuń elementy';
$string['movingelement'] = 'Przenoszenie {$a}';
$string['multfactor'] = 'Mnożnik';
$string['multfactor_help'] = 'Jest to mnożnik, przez który wszystkie oceny w tej pozycji będą pomnożone, przy czym wynik nie przekroczy górnej granicy skali.
Na przykład, jeżeli mnożnik wynosi 2 a maksymalna ocena to 100, wszystkie oceny mniejsze niż 50 będą pomnożone przez 2, a 50 i powyżej będą zmieniony na 100.';
$string['multfactorvalue'] = 'Wartość mnożnika dla {$a}';
$string['mustchooserescaleyesorno'] = 'Musisz wybrać, czy przeskalować istniejące oceny, czy nie.';
$string['mygrades'] = 'Łącze do ocen w menu użytkownika';
$string['mygrades_desc'] = 'Te ustawienie pozwala opcjonalnie dodać łącze do zewnętrznego dziennika ocen w menu użytkownika.';
$string['mypreferences'] = 'Moje ustawienia';
$string['myreportpreferences'] = 'Preferencje raportowania';
$string['myself'] = 'Ja';
$string['neverdeletehistory'] = 'Nigdy nie kasuj historii';
$string['newcategory'] = 'Nowa kategoria';
$string['newitem'] = 'Nowy oceniany element';
$string['newoutcomeitem'] = 'Nowa pozycja efektu uczenia się';
$string['no'] = 'Nie';
$string['nocategories'] = 'Kategoria ocen nie może zostać dodana lub znaleziona dla tego kursu';
$string['nocategoryname'] = 'Nie podano nazwy kategorii';
$string['nocategoryview'] = 'Nie ma kategorii do wyświetlenia';
$string['nocourses'] = 'Nie ma jeszcze żadnych kursów';
$string['noexistingoutcomes'] = 'Brak istniejących efektów uczenia się.';
$string['noexistingscales'] = 'Brak istniejących skal.';
$string['noforce'] = 'Nie wymuszaj';
$string['nogradeletters'] = 'Nie ustawiono nazw ocen';
$string['nogradesreturned'] = 'Brak ocen';
$string['noidnumber'] = 'Brak numeru ID';
$string['nolettergrade'] = 'Brak nazwy oceny dla';
$string['nomode'] = 'Bez trybu';
$string['nonnumericweight'] = 'Otrzymano nienumeryczną wartość';
$string['nonunhideableverbose'] = 'Aby pokazać tę ocenę, musisz odkryć {$a->itemname}.';
$string['nonunlockableverbose'] = 'Aby odblokować tę ocenę, musisz odblokować {$a->itemname}.';
$string['nonweightedpct'] = 'Nieważony %';
$string['nooutcome'] = 'Brak efektu uczenia się';
$string['nooutcomes'] = 'Pozycje efektów uczenia się muszą być powiązane z efektami kształcenia dla tego kursu. Czy chcesz je dodać?';
$string['nopermissiontoresetweights'] = 'Nie masz uprawnień do zmiany wagi';
$string['nopublish'] = 'Nie publikuj';
$string['noreports'] = 'Nie jesteś zapisany, ani nie uczysz w żadnym kursie na tej stronie.';
$string['norolesdefined'] = 'Nie zdefiniowano ról w Administracja serwisu > Oceny > Ustawienia ogólne > Oceniane role';
$string['noscales'] = 'Wyniki muszą być powiązane ze skalą kursu lub skalą globalną, ale ich nie zdefiniowano. Czy chcesz teraz dodać skalę?';
$string['noselectedcategories'] = 'nie wybrano kategorii';
$string['noselecteditems'] = 'nie wybrano pozycji';
$string['notenrolled'] = 'Nie jesteś obecnie zapisany/zapisana do żadnego kursu.';
$string['notteachererror'] = 'Tej opcji może używać tylko nauczyciel';
$string['nousersloaded'] = 'Nie załadowano żadnych użytkowników';
$string['nouserstograde'] = 'Brak użytkowników do oceny';
$string['numberofgrades'] = 'Liczba ocen';
$string['onascaleof'] = 'Na skali od {$a->grademin} do {$a->grademax}';
$string['operations'] = 'Operacje';
$string['options'] = 'Opcje';
$string['originalgrade'] = 'Pierwotna ocena';
$string['others'] = 'Inne';
$string['otheruser'] = 'Użytkownik';
$string['outcome'] = 'Wynik';
$string['outcome_help'] = 'To ustawienie określa efekt uczenia się, który ta ocena będzie reprezentować w dzienniku ocen.';
$string['outcomeassigntocourse'] = 'Przypisz inny efekt uczenia się do tego kursu';
$string['outcomecategory'] = 'Utwórz efekty uczenia się w kategorii';
$string['outcomecategorynew'] = 'Nowa kategoria';
$string['outcomeconfirmdelete'] = 'Czy na pewno chcesz usunąć efekt uczenia się: "{$a}"?';
$string['outcomecreate'] = 'Dodaj nowy efekt uczenia się';
$string['outcomedelete'] = 'Usuń efekt uczenia się';
$string['outcomefullname'] = 'Pełna nazwa';
$string['outcomeitem'] = 'Pozycja efektu uczenia się';
$string['outcomeitemsedit'] = 'Edytuj efekt uczenia się';
$string['outcomereport'] = 'Raport efektów uczenia się';
$string['outcomes'] = 'Efekty uczenia się';
$string['outcomescourse'] = 'Efekty uczenia się użyte w kursie';
$string['outcomescoursecustom'] = 'Użyte własne (brak możliwości usunięcia)';
$string['outcomescoursenotused'] = 'Standardowy nie został użyty';
$string['outcomescourseused'] = 'Użyty standardowy (brak możliwości usunięcia)';
$string['outcomescustom'] = 'Własne efekty uczenia się';
$string['outcomesdisabled'] = 'Efekty uczenia się nie są włączone';
$string['outcomeshortname'] = 'Skrócona nazwa';
$string['outcomesstandard'] = 'Standardowe efekty uczenia się';
$string['outcomesstandardavailable'] = 'Dostępne standardowe efekty uczenia się';
$string['outcomestandard'] = 'Standardowy efekt uczenia się';
$string['outcomestandard_help'] = 'Standardowy efekt uczenia się jest dostępny w całym Moodlu, dla wszystkich kursów.';
$string['overallaverage'] = 'Ogólna średnia';
$string['overridden'] = 'Nadpisane ręcznie';
$string['overridden_help'] = 'Jeśli zaznaczone, ocena nie może być zmieniona przez powiązaną z nią aktywność. Jeśli oceny są modyfikowane w raporcie ocen, pole "Nadpisana ręcznie" jest zaznaczane automatycznie. Jednakże zaznaczenie można zdjąć, aby umożliwić aktualizację oceny przez aktywność.';
$string['overriddennotice'] = 'Twoja ocena końcowa z tej aktywności została ręcznie zmieniona';
$string['overridecat'] = 'Zezwól na ręczne nadpisanie kategorii ocen';
$string['overridecat_help'] = 'Wyłączenie tego ustawienia uniemożliwia użytkownikom zmianę ocen kategorii.';
$string['overridesitedefaultgradedisplaytype'] = 'Nadpisz ustawienia domyślne witryny';
$string['overridesitedefaultgradedisplaytype_help'] = 'Jeśli zaznaczono, litery i limity punktacji ocen można ustawić w ramach kursu, zamiast używać ustawień z całej witryny.';
$string['overrideweightofa'] = 'Nadpisz wagę {$a}';
$string['parentcategory'] = 'Kategoria nadrzędna';
$string['pass'] = 'Zaliczone';
$string['pctoftotalgrade'] = '% z całości oceny';
$string['percent'] = 'procent';
$string['percentage'] = 'Procentowo';
$string['percentageletter'] = 'Procentowo (nazwa oceny)';
$string['percentagereal'] = 'Procentowo (punkty)';
$string['percentascending'] = 'Sortuj wg procentów rosnąco';
$string['percentdescending'] = 'Sortuj wg procentów malejąco';
$string['percentshort'] = '%';
$string['plusfactor'] = 'Poprawka';
$string['plusfactor_help'] = 'Poprawka to liczba dodawana do każdej oceny w tej pozycji po zastosowaniu mnożnika.';
$string['plusfactorvalue'] = 'Wartość przesunięcia dla {$a}';
$string['points'] = 'punkty';
$string['pointsascending'] = 'Sortuj wg punktów rosnąco';
$string['pointsdescending'] = 'Sortuj wg punktów malejąco';
$string['positionfirst'] = 'Pierwszy';
$string['positionlast'] = 'Ostatni';
$string['preferences'] = 'Preferencje';
$string['prefgeneral'] = 'Ogólny';
$string['prefletters'] = 'Nazwy ocen i granice';
$string['prefrows'] = 'Wiersze specjalne';
$string['prefshow'] = 'Pokaż / ukryj';
$string['previewrows'] = 'Podgląd wierszy';
$string['privacy:metadata:categorieshistory'] = 'Zapis poprzednich wersji kategorii ocen';
$string['privacy:metadata:filepurpose'] = 'Pliki informacji zwrotnej przechowywane w dzienniku ocen dla użytkownika.';
$string['privacy:metadata:grade_import_newitem'] = 'Tymczasowa tabela do przechowywania nowych nazw grade_item z importu ocen';
$string['privacy:metadata:grade_import_newitem:importcode'] = 'Unikalny kod partii do identyfikacji jednej partii importu';
$string['privacy:metadata:grade_import_newitem:importer'] = 'Użytkownik importujący dane';
$string['privacy:metadata:grade_import_newitem:itemname'] = 'Nowa nazwa oceny';
$string['privacy:metadata:grade_import_values'] = 'Tymczasowa tabela do importowania ocen';
$string['privacy:metadata:grade_import_values:feedback'] = 'Informacje zwrotne o ocenie';
$string['privacy:metadata:grade_import_values:finalgrade'] = 'Surowa wartość oceny';
$string['privacy:metadata:grade_import_values:importcode'] = 'Unikalny kod partii do identyfikacji jednej partii importu';
$string['privacy:metadata:grade_import_values:importer'] = 'Użytkownik importujący dane';
$string['privacy:metadata:grade_import_values:importonlyfeedback'] = 'Flaga, jeśli zaimportowano tylko opinię zwrotne';
$string['privacy:metadata:grade_import_values:userid'] = 'Użytkownik, którego ocena została zaimportowana';
$string['privacy:metadata:grades'] = 'Rekord ocen';
$string['privacy:metadata:grades:aggregationstatus'] = 'Stan agregacji';
$string['privacy:metadata:grades:aggregationweight'] = 'Waga w agregacji';
$string['privacy:metadata:grades:feedback'] = 'Informacja zwrotna';
$string['privacy:metadata:grades:finalgrade'] = 'Ocena';
$string['privacy:metadata:grades:information'] = 'Dodatkowe informacje o ocenie';
$string['privacy:metadata:grades:timemodified'] = 'Czas ostatniej modyfikacji oceny';
$string['privacy:metadata:grades:userid'] = 'Identyfikator użytkownika, którego jest ocena';
$string['privacy:metadata:grades:usermodified'] = 'Identyfikator użytkownika, który ostatnio zmodyfikował zapis';
$string['privacy:metadata:gradeshistory'] = 'Zapis poprzednich ocen';
$string['privacy:metadata:history:loggeduser'] = 'Identyfikator użytkownika, który był zalogowany podczas wersjonowania';
$string['privacy:metadata:history:timemodified'] = 'Czas, w którym miało miejsce wersjonowanie ocen';
$string['privacy:metadata:itemshistory'] = 'Zapis poprzednich wersji pozycji ocen';
$string['privacy:metadata:outcomes'] = 'Zapis efektów uczenia się';
$string['privacy:metadata:outcomes:timemodified'] = 'Czas, w którym rekord został zmodyfikowany';
$string['privacy:metadata:outcomes:usermodified'] = 'Użytkownik, który ostatnio zmodyfikował rekord';
$string['privacy:metadata:outcomeshistory'] = 'Zapis poprzednich wersji efektów uczenia się';
$string['privacy:metadata:scale'] = 'Rekord wag';
$string['privacy:metadata:scale:timemodified'] = 'Czas ostatniej modyfikacji rekordu';
$string['privacy:metadata:scale:userid'] = 'Użytkownik, który ostatnio zmodyfikował rekord';
$string['privacy:metadata:scalehistory'] = 'Rekord poprzednich wersji wag';
$string['privacy:path:relatedtome'] = 'Powiązane ze mną';
$string['privacy:request:historyactiondelete'] = 'Usuń';
$string['privacy:request:historyactioninsert'] = 'Wstaw';
$string['privacy:request:historyactionupdate'] = 'Zaktualizuj';
$string['privacy:request:unknowndeletedgradeitem'] = 'Nieznany (ocena została usunięta)';
$string['profilereport'] = 'Raport w  profilu użytkownika';
$string['profilereport_help'] = 'Raport ocen wyświetlany na stronie profilu użytkownika.';
$string['publishing'] = 'Publikowane';
$string['publishingoptions'] = 'Opcje publikacji oceny';
$string['quickfeedback'] = 'Szybka informacja zwrotna';
$string['quickgrading'] = 'Szybkie ocenianie';
$string['quickgrading_help'] = 'Jeśli włączone, w trybie edycji każda ocena jest w polu tekstowym i może być zmieniana na tym formularzu. Zmiany są zapisywane i podświetlone, gdy przycisk aktualizacja zostanie kliknięty. Zauważ, że gdy ocena jest zmieniona w dzienniku ocen, flaga \'Nadpisane ręcznie\' jest ustawiana, co oznacza, że ocena nie może być już zmieniana z poziomu aktywności.';
$string['range'] = 'Zakres';
$string['rangedecimals'] = 'Miejsc po przecinku w wyświetlanych zakresach';
$string['rangedecimals_help'] = 'Liczba miejsc dziesiętnych do wyświetlania dla zakresu.';
$string['rangesdecimalpoints'] = 'Miejsc dziesiętnych pokazywanych w zakresie';
$string['rangesdecimalpoints_help'] = 'Ustawienie to określa liczbę miejsc po przecinku wyświetlaną w zakresie.
\'Dziedzicz\' oznacza przyjęcie ustawienia z kategorii.';
$string['rangesdisplaytype'] = 'Typ wyświetlania zakresu';
$string['rangesdisplaytype_help'] = 'To ustawienie określa, czy zakres jest wyświetlany w postaci liczbowej punktów, procentów czy liter. \'Dziedzicz\'  oznacza, że używany jest typ wyświetlania z kategorii lub elementu.';
$string['rank'] = 'Pozycja na tle grupy';
$string['rawpct'] = 'Bez ocen %';
$string['real'] = 'Punkty';
$string['realletter'] = 'Punkty (nazwa oceny)';
$string['realpercentage'] = 'Punkty (procentowo)';
$string['recalculatepenalty'] = 'Przelicz kary';
$string['recalculatepenaltyconfirm'] = 'To spowoduje ponowne obliczenie i zastosowanie kar dla wszystkich zadań w tym kontekście. Czy na pewno chcesz kontynuować?';
$string['recalculatepenaltysuccess'] = 'Pomyślnie zainicjowano ponowne obliczenie kary. Może wystąpić opóźnienie w aktualizacji ocen.';
$string['recalculatinggrades'] = 'Ponowne przeliczanie ocen';
$string['recalculatinggradesadhoc'] = 'Raport zostanie zaktualizowany automatycznie. Nie musisz nic robić.';
$string['recovergradesdefault'] = 'Przywracanie domyślnych ocen';
$string['recovergradesdefault_help'] = 'Przywraca domyślne stare oceny, kiedy następuje ponowne zapisanie użytkowników w kursie.';
$string['refreshpreview'] = 'Odśwież podgląd';
$string['regradeanyway'] = 'Przelicz oceny mimo wszystko';
$string['removeallcoursegrades'] = 'Wszystkie oceny';
$string['removeallcoursegrades_help'] = 'Jeśli opcja ta zostanie zaznaczona, usunięte zostaną wszystkie pozycje ocen i oceny, które zostały ręcznie dodane do dziennika ocen, a także dane dotyczące nadpisanych, wykluczonych, ukrytych i zablokowanych ocen. Pozostaną tylko pozycje ocen i oceny powiązane z aktywnościami.';
$string['removeallcourseitems'] = 'Wszystkie elementy i kategorie';
$string['removeallcourseitems_help'] = 'Jeśli opcja ta zostanie zaznaczona, wszystkie kategorie i elementy ocen, które zostały ręcznie dodane do dziennika ocen, zostaną usunięte wraz z ocenami i danymi dotyczącymi nadpisanych, wykluczonych, ukrytych i zablokowanych ocen. Pozostaną tylko elementy ocen powiązane z aktywnościami.';
$string['report'] = 'Raport';
$string['reportdefault'] = 'Ustawienia domyślne ({$a})';
$string['reportplugins'] = 'Wtyczki raportu';
$string['reportsettings'] = 'Ustawienia raportu';
$string['reprintheaders'] = 'Powtórzenie nagłówków';
$string['resetweights'] = 'Resetuj wagi {$a->itemname}';
$string['resetweightsshort'] = 'Resetuj wagi';
$string['respectingcurrentdata'] = 'pozostawienie obecnej konfiguracji';
$string['rowpreviewnum'] = 'Podgląd wierszy';
$string['rowpreviewnum_help'] = 'Dane do importu mogą być wyświetlane w podglądzie przed potwierdzeniem importu. To ustawienie określa liczbę wierszy wyświetlanych w podglądzie.';
$string['savechanges'] = 'Zachowaj zmiany';
$string['savepreferences'] = 'Zachowaj ustawienia';
$string['scaleconfirmdelete'] = 'Czy na pewno chcesz usunąć skalę "{$a}"?';
$string['scaledpct'] = 'Skala %';
$string['searchcollapsedcolumns'] = 'Wyszukaj zwinięte kolumny';
$string['seeallcoursegrades'] = 'Zobacz oceny w całym kursie';
$string['select'] = 'Wybierz {$a}';
$string['selectalloroneuser'] = 'Pokaż oceny dla wszystkich lub jednej osoby';
$string['selectauser'] = 'Wybierz użytkownika';
$string['selectdestination'] = 'Wybierz miejsce docelowe dla {$a}';
$string['selectgrouplink'] = 'Wybierz grupę';
$string['selectuserlink'] = 'Wybierz użytkownika';
$string['separator'] = 'Separator';
$string['separator_help'] = 'Określ separator używany w pliku CSV. (Zazwyczaj wykorzystywany jest przecinek.)';
$string['sepcolon'] = 'Dwukropek';
$string['sepcomma'] = 'Przecinek';
$string['sepsemicolon'] = 'Średnik';
$string['septab'] = 'Tabulator';
$string['setcategories'] = 'Ustaw kategorię';
$string['setcategorieserror'] = 'Najpierw musisz ustawić kategorię, zanim nadasz wagi.';
$string['setgradeletters'] = 'Ustaw nazwy ocen';
$string['setpreferences'] = 'Ustaw preferencje';
$string['setting'] = 'Ustawienie';
$string['settings'] = 'Ustawienia';
$string['setup'] = 'Ustaw';
$string['setweights'] = 'Ustal wagi';
$string['showallgrades'] = 'Pokaż wszystkie oceny';
$string['showallhidden'] = 'Pokaż ukryte';
$string['showallstudents'] = 'Pokaż wszystkich studentów';
$string['showaverage'] = 'Pokaż średnie';
$string['showaverage_help'] = 'Czy pokazywać kolumnę średnich? Studenci mogą być w stanie oszacować oceny innych osób, jeśli średnia jest obliczana z małej liczby ocen. Ze względu na wydajność średnia jest przybliżona, jeżeli obejmuje elementy ukryte.';
$string['showaverages'] = 'Pokaż wiersz średnich';
$string['showaverages_help'] = 'Pokazuje dodatkowy wiersz zawierający średnie z poszczególnych kolumn.';
$string['showcontributiontocoursetotal'] = 'Pokaż udział w całym kursie';
$string['showcontributiontocoursetotal_help'] = 'Czy ma być wyświetlana kolumna wartości procentowych wskazująca, w jakim stopniu każdy element oceny przyczynia się do całkowitej wartości procentowej kursu użytkownika (po zastosowaniu wagi).';
$string['showfeedback'] = 'Pokaż informacje zwrotne';
$string['showfeedback_help'] = 'Wyświetlanie kolumny informacji zwrotnej.';
$string['showgrade'] = 'Pokaż oceny';
$string['showgrade_help'] = 'Wyświetlanie kolumny ocen.';
$string['showgroups'] = 'Pokaż grupy';
$string['showhiddenitems'] = 'Pokaż ukryte pozycje';
$string['showhiddenitems_help'] = 'Tu ustalamy, czy ukrytych oceny są całkowicie ukryte, czy nazwy ocen ukrytych są widoczne dla studentów.
* Pokaż ukryte - nazwy elementów są widoczne, ale oceny studentów są ukryte
* Ukryte dopóki - oceny są całkowicie ukryte, aż do określonego dnia, po którym są w pełni wyświetlane
* Nie pokazuj - oceny są całkowicie ukryte';
$string['showhiddenuntilonly'] = 'Ukryte dopóki';
$string['showingaggregatesonly'] = 'Wyświetlanie tylko podsumowań';
$string['showingfullmode'] = 'Wyświetlanie ocen i podsumowań';
$string['showinggradesonly'] = 'Tylko oceny';
$string['showlettergrade'] = 'Pokaż nazwy ocen';
$string['showlettergrade_help'] = 'Wyświetlanie kolumny z nazwą oceny.';
$string['shownohidden'] = 'Nie pokazuj';
$string['shownooutcomes'] = 'Ukryj efekty uczenia się';
$string['shownumberofgrades'] = 'Pokaż liczbę ocen w średniej';
$string['shownumberofgrades_help'] = 'Liczba ocen składowych do obliczenia średniej jest wyświetlana w nawiasach po każdej średniej.';
$string['showonlyactiveenrol'] = 'Pokaż tylko aktywne rejestracje';
$string['showonlyactiveenrol_help'] = 'To ustawienie określa, czy tylko aktywni spośród zapisanych użytkowników powinni być widoczni w raporcie dziennika ocen. Jeżeli włączono, zawieszeni użytkownicy nie będą pokazywani w dzienniku ocen.';
$string['showpercentage'] = 'Pokaż procentowo';
$string['showpercentage_help'] = 'Pokazać wartość procentową przy każdej pozycji oceny?';
$string['showrange'] = 'Pokaż zakresy';
$string['showrange_help'] = 'Wyświetlanie kolumny zakresów.';
$string['showranges'] = 'Pokaż zakresy';
$string['showranges_help'] = 'Jeśli opcja jest włączona, raport nauczyciela będzie zawierać dodatkowy wiersz pokazujący zakres dla każdej kategorii i pozycji.';
$string['showrank'] = 'Pokaż pozycję na tle grupy';
$string['showrank_help'] = 'Pokaż pozycję na tle grupy dla każdej pozycji oceny.';
$string['showuserimage'] = 'Pokaż zdjęcia użytkowników';
$string['showuserimage_help'] = 'Czy pokazywać obrazek/fotografię użytkownika obok jego nazwiska w raporcie ocen.';
$string['showverbose'] = 'Pokaż  {$a->category} {$a->itemmodule} {$a->itemname}';
$string['showweight'] = 'Pokaż wagi';
$string['showweight_help'] = 'Wyświetlanie kolumny wag.';
$string['simpleview'] = 'Pojedynczy widok';
$string['sitewide'] = 'W skali całej platformy';
$string['sort'] = 'Sortuj';
$string['sortasc'] = 'Sortuj rosnąco';
$string['sortbyfirstname'] = 'Sortuj wg imienia';
$string['sortbylastname'] = 'Sortuj wg nazwiska';
$string['sortdesc'] = 'Sortuj malejąco';
$string['standarddeviation'] = 'Odchylenie standardowe';
$string['stats'] = 'Statystyka';
$string['statslink'] = 'Statys';
$string['student'] = 'Student';
$string['studentsperpagereduced'] = 'Obniżono maksymalną liczbę studentów na stronie z {$a->originalstudentsperpage} na {$a->studentsperpage}. Należy rozważyć zwiększenie ustawienia PHP max_input_vars z {$a->maxinputvars}.';
$string['subcategory'] = 'Normalna kategoria';
$string['submissions'] = 'Przesłane zadania';
$string['submittedon'] = 'Oddano: {$a}';
$string['sumofgradesupgradedgrades'] = 'Uwaga: W wyniku aktualizacji platformy zmieniony został algorytm sumowania ocen . Ponieważ metoda "Suma ocen" była użyta w tym kursie, koniecznie sprawdź zmiany jakie zaszły w dzienniku ocen.';
$string['switchtofullview'] = 'Przełącz do pełnego widoku';
$string['switchtosimpleview'] = 'Przełącz do widoku prostego';
$string['topcategory'] = 'Kategoria nadrzędna';
$string['total'] = 'Ogólnie';
$string['totalweight100'] = 'Suma wag jest równa 100';
$string['totalweightnot100'] = 'Suma wag nie jest równa 100';
$string['turnfeedbackoff'] = 'Wyłącz informację zwrotną';
$string['turnfeedbackon'] = 'Włącz informację zwrotną';
$string['typenone'] = 'żaden';
$string['typescale'] = 'Skala';
$string['typescale_help'] = 'To ustawienie określa użytą skalę ocen. Skali elementu związanego z aktywnością zdefiniowana jest na stronie ustawień tej aktywności.';
$string['typetext'] = 'Tekst';
$string['typevalue'] = 'Wartość';
$string['uncategorised'] = 'Bez kategorii';
$string['unchangedgrade'] = 'Ocena niezmieniona';
$string['unenrolledusersinimport'] = 'Import obejmował następujące oceny  użytkowników, którzy nie są obecnie zapisani w tym kursie: {$a}';
$string['unlimitedgrades'] = 'Oceny bez ograniczenia';
$string['unlimitedgrades_help'] = 'Normalnie ocena ograniczona jest do określonego zakresu (maksimum, minimum). Włączenie tej opcji znosi to ograniczenie tak, można bezpośrednio w dzienniku ocen wprowadzić ocenę np. ponad 100%. Zaleca się, by ta opcja była włączona w czasie poza szczytem obciążenia, ponieważ powoduje przeliczanie wszystkich ocen, co może wiązać się z wysokim obciążeniem serwera.';
$string['unlock'] = 'Odblokuj';
$string['unlockverbose'] = 'Odblokuj {$a->category} {$a->itemmodule}  {$a->itemname}';
$string['unused'] = 'Nieużywane';
$string['updatedgradesonly'] = 'Eksportuj tylko nowe lub zaktualizowane oceny';
$string['upgradedgradeshidemessage'] = 'OK';
$string['upgradedminmaxrevertmessage'] = 'Cofnij zmiany';
$string['uploadgrades'] = 'Prześlij oceny';
$string['useadvanced'] = 'Użyj zaawansowanych funkcji';
$string['usedcourses'] = 'Używane kursy';
$string['usedgradeitem'] = 'Używane pozycje oceny';
$string['usenooutcome'] = 'Nie używaj efektów uczenia się';
$string['usenoscale'] = 'Nie używaj skali';
$string['usepercent'] = 'Użyj procent';
$string['user'] = 'Użytkownik';
$string['userenrolmentsuspended'] = 'Zapisy użytkowników zostały zawieszone';
$string['userfields_show'] = 'Pokaż pola użytkowników';
$string['userfields_show_help'] = 'Wyświetlanie dodatkowych pól użytkownika, takich jak adres e-mail, w raporcie oceny. Konkretne wyświetlane pola są kontrolowane przez ustawienie witryny showuseridentity';
$string['usergrade'] = 'Użytkownik {$a->fullname} ({$a->useridnumber}) w {$a->gradeidnumber}';
$string['userid'] = 'ID użytkownika';
$string['useridnumberwarning'] = 'Użytkownicy bez numeru ID są wykluczeni z eksportu, ponieważ nie można ich zaimportować.';
$string['usermappingerror'] = 'Błąd mapowania użytkownika: Nie można znaleźć użytkownika {$a->field} z "{$a->value}".';
$string['usermappingerrorcurrentgroup'] = 'Użytkownik nie jest członkiem bieżącej grupy.';
$string['usermappingerrormultipleusersfound'] = 'Błąd mapowania użytkowników: Znaleziono wielu użytkowników z {$a->field} "{$a->value}". Użyj bardziej unikalnego pola mapowania.';
$string['usermappingerrorusernotfound'] = 'Błąd mapowania użytkownika: Nie można znaleźć użytkownika.';
$string['userpreferences'] = 'Preferencje użytkownika';
$string['useweighted'] = 'Użyj wag';
$string['verbosescales'] = 'Słowne skale ocen';
$string['verbosescales_help'] = 'Skala słowna ocen używa słów zamiast liczb. Ustaw na "Tak", jeśli mają być importowane zarówno skale numeryczne, jak i słowne. Ustaw na "Nie", jeśli mają być importowane tylko skale numeryczne.';
$string['viewas'] = 'Zobacz raport jako';
$string['viewbygroup'] = 'Grupa';
$string['viewfeedback'] = 'Wyświetl informacje zwrotne';
$string['viewgrades'] = 'Podgląd ocen';
$string['weight'] = 'Waga';
$string['weight_help'] = 'Wartość używana do określenia względnej wartości wielu elementów oceny w kategorii lub kursie.';
$string['weightcourse'] = 'Użyj w kursie ocen ważonych';
$string['weightedascending'] = 'Sortuj wg ważonych procentów rosnąco';
$string['weighteddescending'] = 'Sortuj wg ważonych procentów malejąco';
$string['weightedpct'] = 'ważone %';
$string['weightedpctcontribution'] = 'udział % wag';
$string['weightofa'] = 'waga dla {$a}';
$string['weightorextracredit'] = 'Waga lub extra kredyt';
$string['weightoverride'] = 'dopasowanie wagi';
$string['weightoverride_help'] = 'Usuń zaznaczenie tej opcji, aby zresetować wagę przedmiotu oceny do automatycznie obliczonej wartości. Zaznaczenie tego zapobiegnie automatycznemu dopasowaniu wagi.';
$string['weights'] = 'Wagi';
$string['weightsadjusted'] = 'Twoje wagi zostały ustawione na 100.';
$string['weightsedit'] = 'Edytuj wagę lub extra kredyt';
$string['weightuc'] = 'Obliczona waga';
$string['writinggradebookinfo'] = 'Zapisywanie ustawień dziennika';
$string['xml'] = 'XML';
$string['yes'] = 'Tak';
$string['yourgrade'] = 'Twoja ocena';
