<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'tool_oauth2', language 'no', version '5.1'.
 *
 * @package     tool_oauth2
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['acceptrisk'] = 'Jeg forstår at deaktivering av e-postbekreftelse kan være et sikkerhetsproblem.';
$string['acceptrisk_help'] = 'Deaktivering av e-postbekreftelse kan potensielt tillate en bruker å autentisere seg som en annen bruker.';
$string['authconfirm'] = 'Denne handlingen vil gi varig API-tilgang til Moodle for den autentiserte kontoen. Dette er ment for å brukes som en systemkonto for administrasjon av filer eid av Moodle.';
$string['authconnected'] = 'Systemkonoten er nå koblet til for offline tilgang';
$string['authnotconnected'] = 'Systemkonoten er ikke koblet til for offline tilgang';
$string['clever_service'] = 'Flink';
$string['configured'] = 'Konfigurert';
$string['configuredstatus'] = 'Konfigurert';
$string['connectsystemaccount'] = 'Koble til en systemkonto';
$string['createfromtemplate'] = 'Opprett en OAuth 2 tjeneste fra en mal';
$string['createfromtemplatedesc'] = 'Velg en av OAuth 2 tjenestemalene for å opprette en OAuth tjeneste med gylidig koppsett for en av de kjente tjenestetypene. Dette vil opprette OAuth 2 tjenesten med korrekte sluttpnkter og nødevnedige parametres for autentisering. Du må fortsatt legge inn klientID\'en og den hemmelige strengen for den nye tjenesten før den kan brukes.';
$string['createnewendpoint'] = 'Opprett nytt sluttpunkt for utgiveren "{$a}"';
$string['createnewservice'] = 'Opprett en ny tjeneste:';
$string['createnewuserfieldmapping'] = 'Opprett ny brukerfeltmapping for utgiveren "{$a}"';
$string['custom_service'] = 'Egendefinert';
$string['deleteconfirm'] = 'Er du sikker på at du ønsker å slette utgiveren "{$a}"? Alle moduler som er avhengige av denne utgiveren vil stoppe å fungere.';
$string['deleteendpointconfirm'] = 'Er du sikker på at du ønsker å slette sluttpunktet "{$a->endpoint}" for utgiveren "{$a->issuer}"? Alle moduler som er avhengige av dette sluttpunktet vil stoppe å fungere.';
$string['deleteuserfieldmappingconfirm'] = 'Er du sikker på at du ønsker å slette brukerfeltmappingen for utgiveren "{$a}"?';
$string['discovered'] = 'Vellykket oppdagelse av tjeneste';
$string['discovered_help'] = 'Oppdag betyr at OAuth 2-endepunktene automatisk kan bestemmes fra basisadressen for OAuth-tjenesten. Ikke alle tjenester er påkrevd å bli "oppdaget", men hvis de ikke er, må endepunktene og brukerkortinformasjonen oppgis manuelt.';
$string['discoverystatus'] = 'Oppdagelse';
$string['editendpoint'] = 'Rediger sluttpunkt {$a->endpint} for utgiveren {$a->issuer}';
$string['editendpoints'] = 'Konfigurer sluttpunkter';
$string['editissuer'] = 'Rediger utgiver {$a}';
$string['edituserfieldmapping'] = 'Rediger brukerfeltmapping for utgiveren {$a}';
$string['edituserfieldmappings'] = 'Konfigurer brukerfeltmappinger';
$string['endpointdeleted'] = 'Sluttpunkt slettet';
$string['endpointname'] = 'Navn';
$string['endpointname_help'] = 'Nøøkelen som brukes til å søke etter dette sluttpunktet. Må slutte med "_endpoint".';
$string['endpointsforissuer'] = 'Sluttpunkt for utgiveren: {$a}';
$string['endpointurl'] = 'URL';
$string['endpointurl_help'] = 'URL for dette sluttpunktet. Må bruke https://-protokollen.';
$string['facebook_service'] = 'Facebook';
$string['google_service'] = 'Google';
$string['issueralloweddomains'] = 'Innloggingsdomener';
$string['issueralloweddomains_help'] = 'Denne innstillingen skal bestå av en kommaseparert liste med domener som innlogging vil være begrenset til ved bruk av denne tilbyderen.';
$string['issueralloweddomains_link'] = 'OAuth_2_login_domains';
$string['issuerbaseurl'] = 'Tjenesten basisURL';
$string['issuerbaseurl_help'] = 'BasisURL for tilgang til tjenesten';
$string['issuerclientid'] = 'KlientID';
$string['issuerclientid_help'] = 'OAuth klientID for denne utgiveren';
$string['issuerclientsecret'] = 'Klient hemmelig streng';
$string['issuerclientsecret_help'] = 'OAuth klient hemmelig streng for denne utgivere.';
$string['issuerdeleted'] = 'Utgiveridentitet sletter';
$string['issuerdisabled'] = 'Utgiveridentitet deaktivert';
$string['issuerenabled'] = 'Utgiveridentitet aktivert';
$string['issuerimage'] = 'Logo-URL';
$string['issuerimage_help'] = 'En bildeURL for bruk av logovisning for denne utgiveren. Kan vises på innloggingssiden.';
$string['issuerloginpagename'] = 'Navnet vises på påloggingssiden';
$string['issuerloginpagename_help'] = 'Hvis spesifisert, vil dette navnet bli brukt på påloggingssiden i stedet for tjenestenavnet.';
$string['issuerloginparams'] = 'Andre parametre i en innloggingsforespørsel.';
$string['issuerloginparams_help'] = 'Noen systemer krever flere parametre i en innloggingsforespørsel for å lese brukerens profil.';
$string['issuerloginparamsoffline'] = 'Tilleggsparamtre inkludert i en innloggingsforespørsel for offlinetilgang.';
$string['issuerloginparamsoffline_help'] = 'Hvert OAuth system definerer en ulike måter å be om offlinetilgang. .feks. krever Google tilleggsparametrene "access_type=offline&pompt=consent". Disse parametrene skal være i URL-spørringsparameterformat.';
$string['issuerloginscopes'] = 'Mål er inkludert i en påloggingsforespørsel.';
$string['issuerloginscopes_help'] = 'Enkelte systemer krever flere mål for en påloggingsforespørsel for å lese brukerens grunnleggende profil. Standardomfangene for et OpenID Connect-kompatibelt system er "openid profile email".';
$string['issuerloginscopesoffline'] = 'Mål inkludert i en innloggingsforespørsel for offline tilgang.';
$string['issuerloginscopesoffline_help'] = 'Hvert enkelt OAuth-system kan definere forskjellige måter å håndtere forespørsler om offline tilgang på. F.eks. krever Microsoft et tilleggsmål for offline tilgang.';
$string['issuername'] = 'Navn';
$string['issuername_help'] = 'Navn på identitetsutsteder. Vises ofte på innloggingssiden.';
$string['issuerrequireconfirmation'] = 'Krev epostbekreftelse';
$string['issuerrequireconfirmation_help'] = 'Krev at alle brukere bekrefter e-postadressen før de kan logge på med OAuth. Dette gjelder nyopprettede kontoer som en del av påloggingsprosessen, eller når en eksisterende Moodle-konto er koblet til en OAuth-pålogging via matchende e-postadresser.';
$string['issuers'] = 'Utgivere';
$string['issuersetup'] = 'Detaljerte instrukser for konfigurering av de vanlige OAuth2 tjenestene';
$string['issuersetuptype'] = 'Detaljerte instruksjoner for oppsettet av {$a} OAuth2 tilbyderen';
$string['issuershowonloginpage'] = 'Vis på innloggingssiden';
$string['issuershowonloginpage_help'] = 'Dersom autentiseringsmodulen OAuth2 er aktivert vil mulige innloggingstilbydere listes opp på innloggingssiden og brukeren kan velge hvilken tilbyder som skal brukes til innlogging.';
$string['issuersmtpsystememail'] = 'SMTP epost';
$string['issuersmtpsystememail_help'] = 'Hvis spesifisert vil denne eposten brukes for å koble til en systemkonto for utgående epost via SMTP. Dette kreves for enkelte OAuth2-tjenester (f.eks. Microsoft). Vennligst sjekk dokumentasjonen for din OAuth2-tjeneste for å se om dette er påkrevd';
$string['issuersservicesallow'] = 'Tillat tjenester';
$string['issuersservicesnotallow'] = 'Ikke tillat tjenester';
$string['issuerusedforinternal'] = 'Interne tjenester';
$string['issuerusedforlogin'] = 'Logg inn';
$string['issuerusein'] = 'Denne tjenesten vil bli benyttet';
$string['issuerusein_help'] = 'OAuth 2-tjenester kan brukes på interne tjenester, på innloggingssiden, SMTP med XOAUTH2 eller begge deler, om nødvendig';
$string['issueruseineverywhere'] = 'Påloggingsside og interne tjenester';
$string['issueruseininternalonly'] = 'Kun interne tjenester';
$string['issueruseinloginonly'] = 'Kun påloggingsside';
$string['issueruseinsmtpwithoauth'] = 'SMTP kun med XOAUTH2';
$string['linkedin_service'] = 'LinkedIn';
$string['logindisplay'] = 'Vis på påloggingssiden som';
$string['loginissuer'] = 'Tillat innlogging';
$string['microsoft_service'] = 'Microsoft';
$string['moodlenet_service'] = 'MoodleNet';
$string['nextcloud_service'] = 'Nexcloud';
$string['notconfigured'] = 'Ikke konfigurert';
$string['notdiscovered'] = 'Oppdagelse av tjeneste feilet';
$string['notloginissuer'] = 'Ikke tillat innlogging';
$string['pluginname'] = 'OAuth2-tjeneste';
$string['privacy:metadata'] = 'Modulen "OAuth2 tjenester" lagrer ikke noen persondata.';
$string['savechanges'] = 'Lagre endringer';
$string['serviceshelp'] = 'Instruksjonser for oppsett av tjenestetilbyder.';
$string['systemaccountconnected'] = 'Systemkonto tilkoblet';
$string['systemaccountconnected_help'] = 'Systemkontoer brukes til å gi avansert funksjonalitet for moduler. De kreves ikke bare for påloggingsfunksjonalitet, men andre pluginprogrammer som bruker OAuth-tjenesten, kan tilby et redusert sett med funksjoner hvis systemkontoen ikke er koblet til. For eksempel kan ikke repositorier støtte "kontrollerte lenker" uten en systemkonto for å utføre filoperasjoner.';
$string['systemaccountnotconnected'] = 'Systemkonto ikke tilkoblet';
$string['systemauthstatus'] = 'Systemkonto tilkoblet';
$string['usebasicauth'] = 'Godkjenne token-forespørsler via HTTP-headere';
$string['usebasicauth_help'] = 'Bruk HTTP Basic autentiseringsskjema når du sender klient-ID og passord med en forespørsel om oppdateringstoken. Anbefalt av OAuth 2-standarden, men er kanskje tilgjengelig hos enkelte utstedere.';
$string['userfieldexternalfield'] = 'Eksternt feltnavn';
$string['userfieldexternalfield_error'] = 'Dette feltet kan ikke inneholde HTML.';
$string['userfieldexternalfield_help'] = 'Feltnavnet fra det eksterne OAuth-systemet';
$string['userfieldinternalfield'] = 'Internt feltnavn';
$string['userfieldinternalfield_help'] = 'Navn på profilfeltet i Moodle som skal mappes fra det eksterne feltet';
$string['userfieldmappingdeleted'] = 'Profilfeltmapping slettet';
$string['userfieldmappingsforissuer'] = 'Brukerfeltmapping for utgiver: {$a}';
